import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SelfSignedCertConfig extends cdktf.TerraformMetaArguments {
    /**
     * Uses that are allowed for the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#allowed_uses SelfSignedCert#allowed_uses}
     *
     * @stability stable
     */
    readonly allowedUses: string[];
    /**
     * List of DNS names to use as subjects of the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#dns_names SelfSignedCert#dns_names}
     *
     * @stability stable
     */
    readonly dnsNames?: string[];
    /**
     * Number of hours before the certificates expiry when a new certificate will be generated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#early_renewal_hours SelfSignedCert#early_renewal_hours}
     *
     * @stability stable
     */
    readonly earlyRenewalHours?: number;
    /**
     * List of IP addresses to use as subjects of the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#ip_addresses SelfSignedCert#ip_addresses}
     *
     * @stability stable
     */
    readonly ipAddresses?: string[];
    /**
     * Whether the generated certificate will be usable as a CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#is_ca_certificate SelfSignedCert#is_ca_certificate}
     *
     * @stability stable
     */
    readonly isCaCertificate?: boolean | cdktf.IResolvable;
    /**
     * Name of the algorithm to use to generate the certificate's private key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#key_algorithm SelfSignedCert#key_algorithm}
     *
     * @stability stable
     */
    readonly keyAlgorithm: string;
    /**
     * PEM-encoded private key that the certificate will belong to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#private_key_pem SelfSignedCert#private_key_pem}
     *
     * @stability stable
     */
    readonly privateKeyPem: string;
    /**
     * If true, the generated certificate will include a subject key identifier.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#set_subject_key_id SelfSignedCert#set_subject_key_id}
     *
     * @stability stable
     */
    readonly setSubjectKeyId?: boolean | cdktf.IResolvable;
    /**
     * List of URIs to use as subjects of the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#uris SelfSignedCert#uris}
     *
     * @stability stable
     */
    readonly uris?: string[];
    /**
     * Number of hours that the certificate will remain valid for.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#validity_period_hours SelfSignedCert#validity_period_hours}
     *
     * @stability stable
     */
    readonly validityPeriodHours: number;
    /**
     * subject block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#subject SelfSignedCert#subject}
     *
     * @stability stable
     */
    readonly subject: SelfSignedCertSubject[];
}
/**
 * @stability stable
 */
export interface SelfSignedCertSubject {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#common_name SelfSignedCert#common_name}.
     *
     * @stability stable
     */
    readonly commonName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#country SelfSignedCert#country}.
     *
     * @stability stable
     */
    readonly country?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#locality SelfSignedCert#locality}.
     *
     * @stability stable
     */
    readonly locality?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#organization SelfSignedCert#organization}.
     *
     * @stability stable
     */
    readonly organization?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#organizational_unit SelfSignedCert#organizational_unit}.
     *
     * @stability stable
     */
    readonly organizationalUnit?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#postal_code SelfSignedCert#postal_code}.
     *
     * @stability stable
     */
    readonly postalCode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#province SelfSignedCert#province}.
     *
     * @stability stable
     */
    readonly province?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#serial_number SelfSignedCert#serial_number}.
     *
     * @stability stable
     */
    readonly serialNumber?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html#street_address SelfSignedCert#street_address}.
     *
     * @stability stable
     */
    readonly streetAddress?: string[];
}
export declare function selfSignedCertSubjectToTerraform(struct?: SelfSignedCertSubject): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html tls_self_signed_cert}.
 *
 * @stability stable
 */
export declare class SelfSignedCert extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/tls/r/self_signed_cert.html tls_self_signed_cert} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SelfSignedCertConfig);
    private _allowedUses?;
    /**
     * @stability stable
     */
    get allowedUses(): string[];
    /**
     * @stability stable
     */
    set allowedUses(value: string[]);
    /**
     * @stability stable
     */
    get allowedUsesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get certPem(): string;
    private _dnsNames?;
    /**
     * @stability stable
     */
    get dnsNames(): string[];
    /**
     * @stability stable
     */
    set dnsNames(value: string[]);
    /**
     * @stability stable
     */
    resetDnsNames(): void;
    /**
     * @stability stable
     */
    get dnsNamesInput(): string[] | undefined;
    private _earlyRenewalHours?;
    /**
     * @stability stable
     */
    get earlyRenewalHours(): number;
    /**
     * @stability stable
     */
    set earlyRenewalHours(value: number);
    /**
     * @stability stable
     */
    resetEarlyRenewalHours(): void;
    /**
     * @stability stable
     */
    get earlyRenewalHoursInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipAddresses?;
    /**
     * @stability stable
     */
    get ipAddresses(): string[];
    /**
     * @stability stable
     */
    set ipAddresses(value: string[]);
    /**
     * @stability stable
     */
    resetIpAddresses(): void;
    /**
     * @stability stable
     */
    get ipAddressesInput(): string[] | undefined;
    private _isCaCertificate?;
    /**
     * @stability stable
     */
    get isCaCertificate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isCaCertificate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsCaCertificate(): void;
    /**
     * @stability stable
     */
    get isCaCertificateInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAlgorithm?;
    /**
     * @stability stable
     */
    get keyAlgorithm(): string;
    /**
     * @stability stable
     */
    set keyAlgorithm(value: string);
    /**
     * @stability stable
     */
    get keyAlgorithmInput(): string | undefined;
    private _privateKeyPem?;
    /**
     * @stability stable
     */
    get privateKeyPem(): string;
    /**
     * @stability stable
     */
    set privateKeyPem(value: string);
    /**
     * @stability stable
     */
    get privateKeyPemInput(): string | undefined;
    /**
     * @stability stable
     */
    get readyForRenewal(): any;
    private _setSubjectKeyId?;
    /**
     * @stability stable
     */
    get setSubjectKeyId(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set setSubjectKeyId(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSetSubjectKeyId(): void;
    /**
     * @stability stable
     */
    get setSubjectKeyIdInput(): boolean | cdktf.IResolvable | undefined;
    private _uris?;
    /**
     * @stability stable
     */
    get uris(): string[];
    /**
     * @stability stable
     */
    set uris(value: string[]);
    /**
     * @stability stable
     */
    resetUris(): void;
    /**
     * @stability stable
     */
    get urisInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get validityEndTime(): string;
    private _validityPeriodHours?;
    /**
     * @stability stable
     */
    get validityPeriodHours(): number;
    /**
     * @stability stable
     */
    set validityPeriodHours(value: number);
    /**
     * @stability stable
     */
    get validityPeriodHoursInput(): number | undefined;
    /**
     * @stability stable
     */
    get validityStartTime(): string;
    private _subject?;
    /**
     * @stability stable
     */
    get subject(): SelfSignedCertSubject[];
    /**
     * @stability stable
     */
    set subject(value: SelfSignedCertSubject[]);
    /**
     * @stability stable
     */
    get subjectInput(): SelfSignedCertSubject[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
