<a id="mypy-boto3-timestream-write"></a>

# mypy-boto3-timestream-write

[![PyPI - mypy-boto3-timestream-write](https://img.shields.io/pypi/v/mypy-boto3-timestream-write.svg?color=blue)](https://pypi.org/project/mypy-boto3-timestream-write)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-timestream-write.svg?color=blue)](https://pypi.org/project/mypy-boto3-timestream-write)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-timestream-write?color=blue)](https://pypistats.org/packages/mypy-boto3-timestream-write)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.TimestreamWrite 1.17.111](https://boto3.amazonaws.com/v1/documentation/api/1.17.111/reference/services/timestream-write.html#TimestreamWrite)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.22.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-timestream-write docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_timestream_write/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-timestream-write](#mypy-boto3-timestream-write)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `TimestreamWrite` service.

```bash
python -m pip install boto3-stubs[timestream-write]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[timestream-write]` in your environment:
  `python -m pip install 'boto3-stubs[timestream-write]'`

Both type checking and auto-complete should work for `TimestreamWrite` service.
No explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[timestream-write]` in your environment:
  `python -m pip install 'boto3-stubs[timestream-write]'`

Both type checking and auto-complete should work for `TimestreamWrite` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[timestream-write]` in your environment:
  `python -m pip install 'boto3-stubs[timestream-write]'`
- Run `mypy` as usual

Type checking should work for `TimestreamWrite` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[timestream-write]` in your environment:
  `python -m pip install 'boto3-stubs[timestream-write]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `TimestreamWrite` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`TimestreamWriteClient` provides annotations for
`boto3.client("timestream-write")`.

```python
import boto3

from mypy_boto3_timestream_write import TimestreamWriteClient

client: TimestreamWriteClient = boto3.client("timestream-write")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: TimestreamWriteClient = session.client("timestream-write")
```

<a id="literals"></a>

### Literals

`mypy_boto3_timestream_write.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_timestream_write.literals import (
    DimensionValueTypeType,
    MeasureValueTypeType,
    TableStatusType,
    TimeUnitType,
)

def check_value(value: DimensionValueTypeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_timestream_write.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_timestream_write.type_defs import (
    CreateDatabaseRequestRequestTypeDef,
    CreateDatabaseResponseTypeDef,
    CreateTableRequestRequestTypeDef,
    CreateTableResponseTypeDef,
    DatabaseTypeDef,
    DeleteDatabaseRequestRequestTypeDef,
    DeleteTableRequestRequestTypeDef,
    DescribeDatabaseRequestRequestTypeDef,
    DescribeDatabaseResponseTypeDef,
    DescribeEndpointsResponseTypeDef,
    DescribeTableRequestRequestTypeDef,
    DescribeTableResponseTypeDef,
    DimensionTypeDef,
    EndpointTypeDef,
    ListDatabasesRequestRequestTypeDef,
    ListDatabasesResponseTypeDef,
    ListTablesRequestRequestTypeDef,
    ListTablesResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    RecordTypeDef,
    ResponseMetadataTypeDef,
    RetentionPropertiesTypeDef,
    TableTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateDatabaseRequestRequestTypeDef,
    UpdateDatabaseResponseTypeDef,
    UpdateTableRequestRequestTypeDef,
    UpdateTableResponseTypeDef,
    WriteRecordsRequestRequestTypeDef,
)

def get_structure() -> CreateDatabaseRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-timestream-write` version is the same as related `boto3` version
and follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-timestream-write docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_timestream_write/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
