# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.conversation_initiation_client_data_request_input import ConversationInitiationClientDataRequestInput
from ...types.twilio_outbound_call_response import TwilioOutboundCallResponse
from .raw_client import AsyncRawTwilioClient, RawTwilioClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TwilioClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTwilioClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTwilioClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTwilioClient
        """
        return self._raw_client

    def outbound_call(
        self,
        *,
        agent_id: str,
        agent_phone_number_id: str,
        to_number: str,
        conversation_initiation_client_data: typing.Optional[ConversationInitiationClientDataRequestInput] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TwilioOutboundCallResponse:
        """
        Handle an outbound call via Twilio

        Parameters
        ----------
        agent_id : str

        agent_phone_number_id : str

        to_number : str

        conversation_initiation_client_data : typing.Optional[ConversationInitiationClientDataRequestInput]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TwilioOutboundCallResponse
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.twilio.outbound_call(
            agent_id="agent_id",
            agent_phone_number_id="agent_phone_number_id",
            to_number="to_number",
        )
        """
        _response = self._raw_client.outbound_call(
            agent_id=agent_id,
            agent_phone_number_id=agent_phone_number_id,
            to_number=to_number,
            conversation_initiation_client_data=conversation_initiation_client_data,
            request_options=request_options,
        )
        return _response.data


class AsyncTwilioClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTwilioClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTwilioClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTwilioClient
        """
        return self._raw_client

    async def outbound_call(
        self,
        *,
        agent_id: str,
        agent_phone_number_id: str,
        to_number: str,
        conversation_initiation_client_data: typing.Optional[ConversationInitiationClientDataRequestInput] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TwilioOutboundCallResponse:
        """
        Handle an outbound call via Twilio

        Parameters
        ----------
        agent_id : str

        agent_phone_number_id : str

        to_number : str

        conversation_initiation_client_data : typing.Optional[ConversationInitiationClientDataRequestInput]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TwilioOutboundCallResponse
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.twilio.outbound_call(
                agent_id="agent_id",
                agent_phone_number_id="agent_phone_number_id",
                to_number="to_number",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.outbound_call(
            agent_id=agent_id,
            agent_phone_number_id=agent_phone_number_id,
            to_number=to_number,
            conversation_initiation_client_data=conversation_initiation_client_data,
            request_options=request_options,
        )
        return _response.data
