# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.music_prompt import MusicPrompt
from .raw_client import AsyncRawMusicClient, RawMusicClient
from .types.music_compose_detailed_request_output_format import MusicComposeDetailedRequestOutputFormat
from .types.music_compose_request_output_format import MusicComposeRequestOutputFormat
from .types.music_stream_request_output_format import MusicStreamRequestOutputFormat

if typing.TYPE_CHECKING:
    from .composition_plan.client import AsyncCompositionPlanClient, CompositionPlanClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MusicClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMusicClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._composition_plan: typing.Optional[CompositionPlanClient] = None

    @property
    def with_raw_response(self) -> RawMusicClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMusicClient
        """
        return self._raw_client

    def compose(
        self,
        *,
        output_format: typing.Optional[MusicComposeRequestOutputFormat] = None,
        prompt: typing.Optional[str] = OMIT,
        music_prompt: typing.Optional[MusicPrompt] = OMIT,
        composition_plan: typing.Optional[MusicPrompt] = OMIT,
        music_length_ms: typing.Optional[int] = OMIT,
        model_id: typing.Optional[typing.Literal["music_v1"]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[bytes]:
        """
        Compose a song from a prompt or a composition plan.

        Parameters
        ----------
        output_format : typing.Optional[MusicComposeRequestOutputFormat]
            Output format of the generated audio. Formatted as codec_sample_rate_bitrate. So an mp3 with 22.05kHz sample rate at 32kbs is represented as mp3_22050_32. MP3 with 192kbps bitrate requires you to be subscribed to Creator tier or above. PCM with 44.1kHz sample rate requires you to be subscribed to Pro tier or above. Note that the μ-law format (sometimes written mu-law, often approximated as u-law) is commonly used for Twilio audio inputs.

        prompt : typing.Optional[str]
            A simple text prompt to generate a song from. Cannot be used in conjunction with `composition_plan`.

        music_prompt : typing.Optional[MusicPrompt]
            A music prompt. Deprecated. Use `composition_plan` instead.

        composition_plan : typing.Optional[MusicPrompt]
            A detailed composition plan to guide music generation. Cannot be used in conjunction with `prompt`.

        music_length_ms : typing.Optional[int]
            The length of the song to generate in milliseconds. Used only in conjunction with `prompt`. Must be between 10000ms and 300000ms. Optional - if not provided, the model will choose a length based on the prompt.

        model_id : typing.Optional[typing.Literal["music_v1"]]
            The model to use for the generation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            The generated audio file in the format specified
        """
        with self._raw_client.compose(
            output_format=output_format,
            prompt=prompt,
            music_prompt=music_prompt,
            composition_plan=composition_plan,
            music_length_ms=music_length_ms,
            model_id=model_id,
            request_options=request_options,
        ) as r:
            yield from r.data

    def compose_detailed(
        self,
        *,
        output_format: typing.Optional[MusicComposeDetailedRequestOutputFormat] = None,
        prompt: typing.Optional[str] = OMIT,
        music_prompt: typing.Optional[MusicPrompt] = OMIT,
        composition_plan: typing.Optional[MusicPrompt] = OMIT,
        music_length_ms: typing.Optional[int] = OMIT,
        model_id: typing.Optional[typing.Literal["music_v1"]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[bytes]:
        """
        Compose a song from a prompt or a composition plan.

        Parameters
        ----------
        output_format : typing.Optional[MusicComposeDetailedRequestOutputFormat]
            Output format of the generated audio. Formatted as codec_sample_rate_bitrate. So an mp3 with 22.05kHz sample rate at 32kbs is represented as mp3_22050_32. MP3 with 192kbps bitrate requires you to be subscribed to Creator tier or above. PCM with 44.1kHz sample rate requires you to be subscribed to Pro tier or above. Note that the μ-law format (sometimes written mu-law, often approximated as u-law) is commonly used for Twilio audio inputs.

        prompt : typing.Optional[str]
            A simple text prompt to generate a song from. Cannot be used in conjunction with `composition_plan`.

        music_prompt : typing.Optional[MusicPrompt]
            A music prompt. Deprecated. Use `composition_plan` instead.

        composition_plan : typing.Optional[MusicPrompt]
            A detailed composition plan to guide music generation. Cannot be used in conjunction with `prompt`.

        music_length_ms : typing.Optional[int]
            The length of the song to generate in milliseconds. Used only in conjunction with `prompt`. Must be between 10000ms and 300000ms. Optional - if not provided, the model will choose a length based on the prompt.

        model_id : typing.Optional[typing.Literal["music_v1"]]
            The model to use for the generation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            Multipart/mixed response with JSON metadata and binary audio file
        """
        with self._raw_client.compose_detailed(
            output_format=output_format,
            prompt=prompt,
            music_prompt=music_prompt,
            composition_plan=composition_plan,
            music_length_ms=music_length_ms,
            model_id=model_id,
            request_options=request_options,
        ) as r:
            yield from r.data

    def stream(
        self,
        *,
        output_format: typing.Optional[MusicStreamRequestOutputFormat] = None,
        prompt: typing.Optional[str] = OMIT,
        music_prompt: typing.Optional[MusicPrompt] = OMIT,
        composition_plan: typing.Optional[MusicPrompt] = OMIT,
        music_length_ms: typing.Optional[int] = OMIT,
        model_id: typing.Optional[typing.Literal["music_v1"]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[bytes]:
        """
        Stream a composed song from a prompt or a composition plan.

        Parameters
        ----------
        output_format : typing.Optional[MusicStreamRequestOutputFormat]
            Output format of the generated audio. Formatted as codec_sample_rate_bitrate. So an mp3 with 22.05kHz sample rate at 32kbs is represented as mp3_22050_32. MP3 with 192kbps bitrate requires you to be subscribed to Creator tier or above. PCM with 44.1kHz sample rate requires you to be subscribed to Pro tier or above. Note that the μ-law format (sometimes written mu-law, often approximated as u-law) is commonly used for Twilio audio inputs.

        prompt : typing.Optional[str]
            A simple text prompt to generate a song from. Cannot be used in conjunction with `composition_plan`.

        music_prompt : typing.Optional[MusicPrompt]
            A music prompt. Deprecated. Use `composition_plan` instead.

        composition_plan : typing.Optional[MusicPrompt]
            A detailed composition plan to guide music generation. Cannot be used in conjunction with `prompt`.

        music_length_ms : typing.Optional[int]
            The length of the song to generate in milliseconds. Used only in conjunction with `prompt`. Must be between 10000ms and 300000ms. Optional - if not provided, the model will choose a length based on the prompt.

        model_id : typing.Optional[typing.Literal["music_v1"]]
            The model to use for the generation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            Streaming audio data in the format specified
        """
        with self._raw_client.stream(
            output_format=output_format,
            prompt=prompt,
            music_prompt=music_prompt,
            composition_plan=composition_plan,
            music_length_ms=music_length_ms,
            model_id=model_id,
            request_options=request_options,
        ) as r:
            yield from r.data

    @property
    def composition_plan(self):
        if self._composition_plan is None:
            from .composition_plan.client import CompositionPlanClient  # noqa: E402

            self._composition_plan = CompositionPlanClient(client_wrapper=self._client_wrapper)
        return self._composition_plan


class AsyncMusicClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMusicClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._composition_plan: typing.Optional[AsyncCompositionPlanClient] = None

    @property
    def with_raw_response(self) -> AsyncRawMusicClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMusicClient
        """
        return self._raw_client

    async def compose(
        self,
        *,
        output_format: typing.Optional[MusicComposeRequestOutputFormat] = None,
        prompt: typing.Optional[str] = OMIT,
        music_prompt: typing.Optional[MusicPrompt] = OMIT,
        composition_plan: typing.Optional[MusicPrompt] = OMIT,
        music_length_ms: typing.Optional[int] = OMIT,
        model_id: typing.Optional[typing.Literal["music_v1"]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[bytes]:
        """
        Compose a song from a prompt or a composition plan.

        Parameters
        ----------
        output_format : typing.Optional[MusicComposeRequestOutputFormat]
            Output format of the generated audio. Formatted as codec_sample_rate_bitrate. So an mp3 with 22.05kHz sample rate at 32kbs is represented as mp3_22050_32. MP3 with 192kbps bitrate requires you to be subscribed to Creator tier or above. PCM with 44.1kHz sample rate requires you to be subscribed to Pro tier or above. Note that the μ-law format (sometimes written mu-law, often approximated as u-law) is commonly used for Twilio audio inputs.

        prompt : typing.Optional[str]
            A simple text prompt to generate a song from. Cannot be used in conjunction with `composition_plan`.

        music_prompt : typing.Optional[MusicPrompt]
            A music prompt. Deprecated. Use `composition_plan` instead.

        composition_plan : typing.Optional[MusicPrompt]
            A detailed composition plan to guide music generation. Cannot be used in conjunction with `prompt`.

        music_length_ms : typing.Optional[int]
            The length of the song to generate in milliseconds. Used only in conjunction with `prompt`. Must be between 10000ms and 300000ms. Optional - if not provided, the model will choose a length based on the prompt.

        model_id : typing.Optional[typing.Literal["music_v1"]]
            The model to use for the generation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            The generated audio file in the format specified
        """
        async with self._raw_client.compose(
            output_format=output_format,
            prompt=prompt,
            music_prompt=music_prompt,
            composition_plan=composition_plan,
            music_length_ms=music_length_ms,
            model_id=model_id,
            request_options=request_options,
        ) as r:
            async for _chunk in r.data:
                yield _chunk

    async def compose_detailed(
        self,
        *,
        output_format: typing.Optional[MusicComposeDetailedRequestOutputFormat] = None,
        prompt: typing.Optional[str] = OMIT,
        music_prompt: typing.Optional[MusicPrompt] = OMIT,
        composition_plan: typing.Optional[MusicPrompt] = OMIT,
        music_length_ms: typing.Optional[int] = OMIT,
        model_id: typing.Optional[typing.Literal["music_v1"]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[bytes]:
        """
        Compose a song from a prompt or a composition plan.

        Parameters
        ----------
        output_format : typing.Optional[MusicComposeDetailedRequestOutputFormat]
            Output format of the generated audio. Formatted as codec_sample_rate_bitrate. So an mp3 with 22.05kHz sample rate at 32kbs is represented as mp3_22050_32. MP3 with 192kbps bitrate requires you to be subscribed to Creator tier or above. PCM with 44.1kHz sample rate requires you to be subscribed to Pro tier or above. Note that the μ-law format (sometimes written mu-law, often approximated as u-law) is commonly used for Twilio audio inputs.

        prompt : typing.Optional[str]
            A simple text prompt to generate a song from. Cannot be used in conjunction with `composition_plan`.

        music_prompt : typing.Optional[MusicPrompt]
            A music prompt. Deprecated. Use `composition_plan` instead.

        composition_plan : typing.Optional[MusicPrompt]
            A detailed composition plan to guide music generation. Cannot be used in conjunction with `prompt`.

        music_length_ms : typing.Optional[int]
            The length of the song to generate in milliseconds. Used only in conjunction with `prompt`. Must be between 10000ms and 300000ms. Optional - if not provided, the model will choose a length based on the prompt.

        model_id : typing.Optional[typing.Literal["music_v1"]]
            The model to use for the generation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            Multipart/mixed response with JSON metadata and binary audio file
        """
        async with self._raw_client.compose_detailed(
            output_format=output_format,
            prompt=prompt,
            music_prompt=music_prompt,
            composition_plan=composition_plan,
            music_length_ms=music_length_ms,
            model_id=model_id,
            request_options=request_options,
        ) as r:
            async for _chunk in r.data:
                yield _chunk

    async def stream(
        self,
        *,
        output_format: typing.Optional[MusicStreamRequestOutputFormat] = None,
        prompt: typing.Optional[str] = OMIT,
        music_prompt: typing.Optional[MusicPrompt] = OMIT,
        composition_plan: typing.Optional[MusicPrompt] = OMIT,
        music_length_ms: typing.Optional[int] = OMIT,
        model_id: typing.Optional[typing.Literal["music_v1"]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[bytes]:
        """
        Stream a composed song from a prompt or a composition plan.

        Parameters
        ----------
        output_format : typing.Optional[MusicStreamRequestOutputFormat]
            Output format of the generated audio. Formatted as codec_sample_rate_bitrate. So an mp3 with 22.05kHz sample rate at 32kbs is represented as mp3_22050_32. MP3 with 192kbps bitrate requires you to be subscribed to Creator tier or above. PCM with 44.1kHz sample rate requires you to be subscribed to Pro tier or above. Note that the μ-law format (sometimes written mu-law, often approximated as u-law) is commonly used for Twilio audio inputs.

        prompt : typing.Optional[str]
            A simple text prompt to generate a song from. Cannot be used in conjunction with `composition_plan`.

        music_prompt : typing.Optional[MusicPrompt]
            A music prompt. Deprecated. Use `composition_plan` instead.

        composition_plan : typing.Optional[MusicPrompt]
            A detailed composition plan to guide music generation. Cannot be used in conjunction with `prompt`.

        music_length_ms : typing.Optional[int]
            The length of the song to generate in milliseconds. Used only in conjunction with `prompt`. Must be between 10000ms and 300000ms. Optional - if not provided, the model will choose a length based on the prompt.

        model_id : typing.Optional[typing.Literal["music_v1"]]
            The model to use for the generation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            Streaming audio data in the format specified
        """
        async with self._raw_client.stream(
            output_format=output_format,
            prompt=prompt,
            music_prompt=music_prompt,
            composition_plan=composition_plan,
            music_length_ms=music_length_ms,
            model_id=model_id,
            request_options=request_options,
        ) as r:
            async for _chunk in r.data:
                yield _chunk

    @property
    def composition_plan(self):
        if self._composition_plan is None:
            from .composition_plan.client import AsyncCompositionPlanClient  # noqa: E402

            self._composition_plan = AsyncCompositionPlanClient(client_wrapper=self._client_wrapper)
        return self._composition_plan
