# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawTranscriptsClient, RawTranscriptsClient
from .types.transcripts_get_response import TranscriptsGetResponse


class TranscriptsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTranscriptsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTranscriptsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTranscriptsClient
        """
        return self._raw_client

    def get(
        self, transcription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TranscriptsGetResponse:
        """
        Retrieve a previously generated transcript by its ID.

        Parameters
        ----------
        transcription_id : str
            The unique ID of the transcript to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TranscriptsGetResponse
            The transcript data

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.speech_to_text.transcripts.get(
            transcription_id="transcription_id",
        )
        """
        _response = self._raw_client.get(transcription_id, request_options=request_options)
        return _response.data


class AsyncTranscriptsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTranscriptsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTranscriptsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTranscriptsClient
        """
        return self._raw_client

    async def get(
        self, transcription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TranscriptsGetResponse:
        """
        Retrieve a previously generated transcript by its ID.

        Parameters
        ----------
        transcription_id : str
            The unique ID of the transcript to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TranscriptsGetResponse
            The transcript data

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.speech_to_text.transcripts.get(
                transcription_id="transcription_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(transcription_id, request_options=request_options)
        return _response.data
