# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class DynamicVariableAssignment(UncheckedBaseModel):
    """
    Configuration for extracting values from tool responses and assigning them to dynamic variables.
    """

    source: typing.Optional[typing.Literal["response"]] = pydantic.Field(default=None)
    """
    The source to extract the value from. Currently only 'response' is supported.
    """

    dynamic_variable: str = pydantic.Field()
    """
    The name of the dynamic variable to assign the extracted value to
    """

    value_path: str = pydantic.Field()
    """
    Dot notation path to extract the value from the source (e.g., 'user.name' or 'data.0.id')
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
