# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.unchecked_base_model import UncheckedBaseModel
from .conversation_history_analysis_common_model import ConversationHistoryAnalysisCommonModel
from .conversation_history_metadata_common_model import ConversationHistoryMetadataCommonModel
from .conversation_history_transcript_common_model_output import ConversationHistoryTranscriptCommonModelOutput
from .conversation_initiation_client_data_request_output import ConversationInitiationClientDataRequestOutput
from .get_conversation_response_model_status import GetConversationResponseModelStatus


class GetConversationResponseModel(UncheckedBaseModel):
    agent_id: str
    conversation_id: str
    status: GetConversationResponseModelStatus
    user_id: typing.Optional[str] = None
    transcript: typing.List[ConversationHistoryTranscriptCommonModelOutput]
    metadata: ConversationHistoryMetadataCommonModel
    analysis: typing.Optional[ConversationHistoryAnalysisCommonModel] = None
    conversation_initiation_client_data: typing.Optional[ConversationInitiationClientDataRequestOutput] = None
    has_audio: bool
    has_user_audio: bool
    has_response_audio: bool

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .conversation_history_transcript_workflow_tools_result_common_model_output import (
    ConversationHistoryTranscriptWorkflowToolsResultCommonModelOutput,
)  # noqa: E402, F401, I001
from .workflow_tool_nested_tools_step_model_output import WorkflowToolNestedToolsStepModelOutput  # noqa: E402, F401, I001
from .workflow_tool_response_model_output import WorkflowToolResponseModelOutput  # noqa: E402, F401, I001

update_forward_refs(GetConversationResponseModel)
