# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.unchecked_base_model import UncheckedBaseModel, UnionMetadata
from .dynamic_variable_assignment import DynamicVariableAssignment
from .dynamic_variables_config import DynamicVariablesConfig
from .system_tool_config_output_params import SystemToolConfigOutputParams
from .webhook_tool_api_schema_config_output import WebhookToolApiSchemaConfigOutput


class PromptAgentApiModelOutputToolsItem_Client(UncheckedBaseModel):
    """
    The type of tool
    """

    type: typing.Literal["client"] = "client"
    name: str
    description: str
    response_timeout_secs: typing.Optional[int] = None
    disable_interruptions: typing.Optional[bool] = None
    force_pre_tool_speech: typing.Optional[bool] = None
    assignments: typing.Optional[typing.List[DynamicVariableAssignment]] = None
    parameters: typing.Optional["ObjectJsonSchemaPropertyOutput"] = None
    expects_response: typing.Optional[bool] = None
    dynamic_variables: typing.Optional[DynamicVariablesConfig] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PromptAgentApiModelOutputToolsItem_Mcp(UncheckedBaseModel):
    value: typing.Optional[typing.Any] = None
    type: typing.Literal["mcp"] = "mcp"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True


class PromptAgentApiModelOutputToolsItem_System(UncheckedBaseModel):
    """
    The type of tool
    """

    type: typing.Literal["system"] = "system"
    name: str
    description: str
    response_timeout_secs: typing.Optional[int] = None
    disable_interruptions: typing.Optional[bool] = None
    force_pre_tool_speech: typing.Optional[bool] = None
    assignments: typing.Optional[typing.List[DynamicVariableAssignment]] = None
    params: SystemToolConfigOutputParams

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PromptAgentApiModelOutputToolsItem_Webhook(UncheckedBaseModel):
    """
    The type of tool
    """

    type: typing.Literal["webhook"] = "webhook"
    name: str
    description: str
    response_timeout_secs: typing.Optional[int] = None
    disable_interruptions: typing.Optional[bool] = None
    force_pre_tool_speech: typing.Optional[bool] = None
    assignments: typing.Optional[typing.List[DynamicVariableAssignment]] = None
    api_schema: WebhookToolApiSchemaConfigOutput
    dynamic_variables: typing.Optional[DynamicVariablesConfig] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_json_schema_property_output import ArrayJsonSchemaPropertyOutput  # noqa: E402, F401, I001
from .object_json_schema_property_output import ObjectJsonSchemaPropertyOutput  # noqa: E402, F401, I001

PromptAgentApiModelOutputToolsItem = typing_extensions.Annotated[
    typing.Union[
        PromptAgentApiModelOutputToolsItem_Client,
        PromptAgentApiModelOutputToolsItem_Mcp,
        PromptAgentApiModelOutputToolsItem_System,
        PromptAgentApiModelOutputToolsItem_Webhook,
    ],
    UnionMetadata(discriminant="type"),
]
update_forward_refs(PromptAgentApiModelOutputToolsItem_Client)
update_forward_refs(PromptAgentApiModelOutputToolsItem_Webhook)
