# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class SongMetadata(UncheckedBaseModel):
    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title of the song
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the song
    """

    genres: typing.List[str] = pydantic.Field()
    """
    The genres of the song
    """

    languages: typing.List[str] = pydantic.Field()
    """
    The languages of the song
    """

    is_explicit: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the song is explicit
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
