# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class SongSection(UncheckedBaseModel):
    section_name: str = pydantic.Field()
    """
    The name of the section. Must be between 1 and 100 characters.
    """

    positive_local_styles: typing.List[str] = pydantic.Field()
    """
    The styles that should be present in this section.
    """

    negative_local_styles: typing.List[str] = pydantic.Field()
    """
    The styles that should not be present in this section.
    """

    duration_ms: int = pydantic.Field()
    """
    The duration of the section in milliseconds. Must be between 3000ms and 120000ms.
    """

    lines: typing.List[str] = pydantic.Field()
    """
    The lyrics of the section.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
