# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.unchecked_base_model import UncheckedBaseModel
from .resource_access_info import ResourceAccessInfo
from .tool_response_model_tool_config import ToolResponseModelToolConfig
from .tool_usage_stats_response_model import ToolUsageStatsResponseModel


class ToolResponseModel(UncheckedBaseModel):
    id: str
    tool_config: ToolResponseModelToolConfig = pydantic.Field()
    """
    The type of tool
    """

    access_info: ResourceAccessInfo
    usage_stats: ToolUsageStatsResponseModel

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_json_schema_property_output import ArrayJsonSchemaPropertyOutput  # noqa: E402, F401, I001
from .object_json_schema_property_output import ObjectJsonSchemaPropertyOutput  # noqa: E402, F401, I001

update_forward_refs(ToolResponseModel)
