# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .resource_access_info import ResourceAccessInfo


class UnitTestSummaryResponseModel(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    The ID of the test
    """

    name: str = pydantic.Field()
    """
    Name of the test
    """

    access_info: typing.Optional[ResourceAccessInfo] = pydantic.Field(default=None)
    """
    The access information of the test
    """

    created_at_unix_secs: int = pydantic.Field()
    """
    Creation time of the test in unix seconds
    """

    last_updated_at_unix_secs: int = pydantic.Field()
    """
    Last update time of the test in unix seconds
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
