from typing import Any, Callable, TypeVar

_range = range
TS = TypeVar("TS")
TR = TypeVar("TR")
TF = TypeVar("TF")

class linq(list[TS]):
    """LINQ-like list extension class"""

    def __init_subclass__(cls) -> None: ...
    @property
    def __is_empty(self) -> bool: ...
    def any(self, pred: Callable[[TS], bool] | None = None) -> bool: ...
    def count(self, pred: Callable[[TS], bool] | None = None) -> int: ...
    def where(self, pred: Callable[[TS], bool]) -> "linq[TS]": ...
    def select(self, func: Callable[[TS], TR]) -> "linq[TR]": ...
    def find_index(self, pred: Callable[[TS], bool]) -> int: ...
    def find(self, pred: Callable[[TS], bool]) -> TS | None: ...
    def find_last(self, pred: Callable[[TS], bool]) -> TS | None: ...
    def find_last_index(self, pred: Callable[[TS], bool]) -> int: ...
    def first(self, pred: Callable[[TS], bool] | None = None) -> TS | None: ...
    def first_or_default(
        self, default: TS, pred: Callable[[TS], bool] | None = None
    ) -> TS: ...
    def last(self, pred: Callable[[TS], bool] | None = None) -> TS | None: ...
    def last_or_default(
        self, default: TS, pred: Callable[[TS], bool] | None = None
    ) -> TS: ...
    def order_by(self, key: Callable[[TS], Any]) -> "linq[TS]": ...
    def order_by_descending(self, key: Callable[[TS], Any]) -> "linq[TS]": ...

def range(s: int, c: int) -> linq[int]: ...
def repeat(v: TF, c: int) -> linq[TF]: ...
