import sys
from select import select
from socket import socket
from types import TracebackType
from typing import final

if sys.version_info < (3, 11):
    from typing_extensions import Self
else:
    from typing import Self

@final
class epoll:
    def __init__(self, sizehint: int = ...) -> None: ...
    def __enter__(self) -> Self: ...
    def __exit__(
        self,
        exc_type: type[BaseException] | None = None,
        exc_value: BaseException | None = ...,
        exc_tb: TracebackType | None = None,
        /,
    ) -> None: ...
    def close(self) -> None: ...
    closed: bool
    def fileno(self) -> int: ...
    def register(self, fd: int | socket, eventmask: int = ...) -> None: ...
    def modify(self, fd: int | socket, eventmask: int) -> None: ...
    def unregister(self, fd: int | socket) -> None: ...
    def poll(
        self, timeout: float | None = None, maxevents: int = -1
    ) -> list[tuple[int, int]]: ...

    # Maybe in a Future release but we shall see...
    # @classmethod
    # def fromfd(cls, fd: int, /) -> epoll: ...
