"use strict";
(self["webpackChunkmito_ai"] = self["webpackChunkmito_ai"] || []).push([["lib_index_js"],{

/***/ "./lib/Extensions/AiChat/AiChatPlugin.js":
/*!***********************************************!*\
  !*** ./lib/Extensions/AiChat/AiChatPlugin.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/application */ "webpack/sharing/consume/default/@jupyterlab/application");
/* harmony import */ var _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _ChatWidget__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ChatWidget */ "./lib/Extensions/AiChat/ChatWidget.js");
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/rendermime */ "webpack/sharing/consume/default/@jupyterlab/rendermime");
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _commands__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../commands */ "./lib/commands.js");
/* harmony import */ var _token__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./token */ "./lib/Extensions/AiChat/token.js");
/* harmony import */ var _ContextManager_ContextManagerPlugin__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../ContextManager/ContextManagerPlugin */ "./lib/Extensions/ContextManager/ContextManagerPlugin.js");
/* harmony import */ var _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/settingregistry */ "webpack/sharing/consume/default/@jupyterlab/settingregistry");
/* harmony import */ var _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _jupyterSettingsManager__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./jupyterSettingsManager */ "./lib/Extensions/AiChat/jupyterSettingsManager.js");
/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/docmanager */ "webpack/sharing/consume/default/@jupyterlab/docmanager");
/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_5__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */











// The Widget Rank determins where the ChatIcon is displayed
// in the left hand toolbar
const WIDGET_RANK = 2000;
/**
 * Initialization data for the mito-ai extension.
 */
const AiChatPlugin = {
    id: 'mito_ai:chat',
    description: 'AI chat for JupyterLab',
    autoStart: true,
    requires: [
        _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__.ILabShell,
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.INotebookTracker,
        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ICommandPalette,
        _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_3__.IRenderMimeRegistry,
        _ContextManager_ContextManagerPlugin__WEBPACK_IMPORTED_MODULE_6__.IContextManager,
        _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_4__.ISettingRegistry,
        _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_5__.IDocumentManager
    ],
    optional: [_jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__.ILayoutRestorer],
    provides: _token__WEBPACK_IMPORTED_MODULE_7__.IChatTracker,
    activate: (app, labShell, notebookTracker, palette, rendermime, contextManager, settingRegistry, documentManager, restorer) => {
        // Define a widget creator function,
        // then call it to make a new widget
        const newWidget = () => {
            // Create a blank content widget inside of a MainAreaWidget
            const chatWidget = (0,_ChatWidget__WEBPACK_IMPORTED_MODULE_8__.buildChatWidget)(app, notebookTracker, rendermime, contextManager);
            return chatWidget;
        };
        let widget = newWidget();
        // Add an application command
        app.commands.addCommand(_commands__WEBPACK_IMPORTED_MODULE_9__.COMMAND_MITO_AI_OPEN_CHAT, {
            label: 'Your friendly Python Expert chat bot',
            execute: (args) => {
                // In order for the widget to be accessible, the widget must be:
                // 1. Created
                // 2. Added to the widget tracker
                // 3. Attatched to the frontend
                // Step 1: Create the widget if its not already created
                if (!widget || widget.isDisposed) {
                    widget = newWidget();
                }
                // Step 2: Add the widget to the widget tracker if
                // its not already there
                if (!tracker.has(widget)) {
                    void tracker.add(widget);
                }
                // Step 3: Attatch the widget to the app if its not already there
                if (!widget.isAttached) {
                    void app.shell.add(widget, 'left', { rank: WIDGET_RANK });
                }
                // Now that the widget is added to the shell, activating it will open the taskpane
                app.shell.activateById(widget.id);
                // If the command is called with focus on chat input set to false, 
                // don't focus. This is useful when we don't want to active cell 
                // preview to be displayed when using the smart debugger.
                if ((args === null || args === void 0 ? void 0 : args.focusChatInput) === false) {
                    return;
                }
                // Set focus on the chat input
                const chatInput = widget.node.querySelector('.chat-input');
                chatInput === null || chatInput === void 0 ? void 0 : chatInput.focus();
            }
        });
        app.commands.addKeyBinding({
            command: _commands__WEBPACK_IMPORTED_MODULE_9__.COMMAND_MITO_AI_OPEN_CHAT,
            keys: ['Accel E'],
            selector: 'body'
        });
        app.shell.add(widget, 'left', { rank: WIDGET_RANK });
        // Add the command to the palette.
        palette.addItem({
            command: _commands__WEBPACK_IMPORTED_MODULE_9__.COMMAND_MITO_AI_OPEN_CHAT,
            category: 'AI Chat'
        });
        // Track and restore the widget state
        const tracker = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.WidgetTracker({
            namespace: widget.id
        });
        if (!tracker.has(widget)) {
            void tracker.add(widget);
        }
        if (restorer) {
            restorer.add(widget, 'mito_ai');
        }
        // Instead of immediately activating the chat widget, wait for app restoration to complete
        // This ensures our widget activation happens after JupyterLab's initial setup which by 
        // default tries to open the file browser instead. 
        // TODO: It might be nice to only open to chat if a notebook is already open. If a 
        // notebook is not already open, then users might want to open to the file browser, 
        void app.restored.then(() => {
            // Activate our chat widget after JupyterLab has fully initialized
            // This will override the default file browser selection
            labShell.activateById(widget.id);
        });
        // Update jupyter settings to work best with mito-ai
        void (0,_jupyterSettingsManager__WEBPACK_IMPORTED_MODULE_10__.setRenameUntitledFileOnSave)(settingRegistry, documentManager);
        void (0,_jupyterSettingsManager__WEBPACK_IMPORTED_MODULE_10__.setDefaultWindowingMode)(settingRegistry);
        // By returning a tracker token, we can require the token in other 
        // plugins. This allows us to force plugin load order. For example, 
        // we can ensure that the COMMAND_MITO_AI_OPEN_CHAT is created 
        // before trying to use it in other plugins
        return tracker;
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AiChatPlugin);


/***/ }),

/***/ "./lib/Extensions/AiChat/CTACarousel.js":
/*!**********************************************!*\
  !*** ./lib/Extensions/AiChat/CTACarousel.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SettingsManager_SettingsManagerPlugin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../SettingsManager/SettingsManagerPlugin */ "./lib/Extensions/SettingsManager/SettingsManagerPlugin.js");
/* harmony import */ var _icons_MitoLogo__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../icons/MitoLogo */ "./lib/icons/MitoLogo.js");
/* harmony import */ var _style_CTACarousel_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../style/CTACarousel.css */ "./style/CTACarousel.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const CTACarousel = ({ app }) => {
    const [currentIndex, setCurrentIndex] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
    // Define messages inside component to access app prop
    const CTACAROUSEL_MESSAGES = [
        {
            content: (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null,
                "Generate more than just Python code. Talk to your database, no SQL required.",
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("br", null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "button-base button-gray cta-carousel-button", onClick: () => app.commands.execute(_SettingsManager_SettingsManagerPlugin__WEBPACK_IMPORTED_MODULE_2__.COMMAND_MITO_AI_SETTINGS), "data-testid": "cta-carousel-button" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("b", null, "\uFF0B Add Database"))))
        },
        {
            content: react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Use Agent mode to let the AI write and execute cells on your behalf.")
        },
        {
            content: react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Use @ to reference your variables, files, rules, and more.")
        }
    ];
    const currentMessage = CTACAROUSEL_MESSAGES[Math.min(currentIndex, CTACAROUSEL_MESSAGES.length - 1)].content;
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "cta-carousel" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "cta-logo-container" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_MitoLogo__WEBPACK_IMPORTED_MODULE_3__["default"], { width: "60", height: "30" })),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "cta-title" }, "Data Copilot"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "cta-carousel-container" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "cta-message", "data-testid": "cta-message" }, currentMessage)),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "cta-carousel-dots" }, CTACAROUSEL_MESSAGES.map((_, index) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: index, className: `cta-carousel-dot ${index === currentIndex ? 'active' : ''}`, onClick: () => setCurrentIndex(index), "data-testid": "cta-carousel-dot", role: "button" }))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CTACarousel);


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatHistoryManager.js":
/*!*****************************************************!*\
  !*** ./lib/Extensions/AiChat/ChatHistoryManager.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChatHistoryManager: () => (/* binding */ ChatHistoryManager)
/* harmony export */ });
/* harmony import */ var _utils_notebook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/notebook */ "./lib/utils/notebook.js");
/* harmony import */ var _utils_strings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/strings */ "./lib/utils/strings.js");
/* harmony import */ var _utils_user__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/user */ "./lib/utils/user.js");
/* harmony import */ var _validationUtils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validationUtils */ "./lib/Extensions/AiChat/validationUtils.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




/*
    The ChatHistoryManager is responsible for managing the AI chat history.

    It keeps track of messages displayed in the chat interface that only display info the user wants to see, like their original input.

    TODO: In the future, we should make this its own extension that provides an interface for adding new messages to the chat history,
    creating new chats, etc. Doing so would allow us to easily append new messages from other extensions without having to do so
    by calling commands with untyped arguments.

    Whenever, the chatHistoryManager is updated, it should automatically send a message to the AI.
*/
class ChatHistoryManager {
    constructor(contextManager, notebookTracker, initialHistory) {
        this._allAssumptions = new Set();
        this.getLastAIMessageIndex = () => {
            // We assume that assistant messages are always separated by user messages.
            // This allows us to simply find the last assistant message in the history.
            // If this invariant changes (e.g., if we need to support consecutive assistant messages),
            // we should modify this to use message IDs instead.
            const displayOptimizedChatHistory = this.getDisplayOptimizedHistory();
            const aiMessageIndexes = displayOptimizedChatHistory.map((chatEntry, index) => {
                if (chatEntry.message.role === 'assistant') {
                    return index;
                }
                return undefined;
            }).filter(index => index !== undefined);
            return aiMessageIndexes[aiMessageIndexes.length - 1];
        };
        this.getLastAIDisplayOptimizedChatItem = () => {
            const lastAIMessagesIndex = this.getLastAIMessageIndex();
            if (!lastAIMessagesIndex) {
                return;
            }
            return this.displayOptimizedChatHistory[lastAIMessagesIndex];
        };
        // Initialize the history
        this.displayOptimizedChatHistory = initialHistory || [];
        // Save the context manager
        this.contextManager = contextManager;
        // Save the notebook tracker
        this.notebookTracker = notebookTracker;
        // Initialize assumptions from existing history
        this.initializeAssumptionsFromHistory();
    }
    initializeAssumptionsFromHistory() {
        this._allAssumptions.clear();
        this.displayOptimizedChatHistory.forEach(item => {
            var _a;
            // Validate the agent response if it exists
            if (item.agentResponse !== undefined) {
                item.agentResponse = (0,_validationUtils__WEBPACK_IMPORTED_MODULE_0__.validateAndCorrectAgentResponse)(item.agentResponse);
            }
            // Process the assumptions
            if ((_a = item.agentResponse) === null || _a === void 0 ? void 0 : _a.analysis_assumptions) {
                item.agentResponse.analysis_assumptions.forEach(assumption => {
                    this._allAssumptions.add(assumption);
                });
            }
        });
    }
    deduplicateAssumptions(agentResponse) {
        // If there are no assumptions, return the original response
        if ((agentResponse === null || agentResponse === void 0 ? void 0 : agentResponse.analysis_assumptions) === undefined || (agentResponse === null || agentResponse === void 0 ? void 0 : agentResponse.analysis_assumptions) === null) {
            return agentResponse;
        }
        const newAssumptions = agentResponse.analysis_assumptions.filter(assumption => !this._allAssumptions.has(assumption));
        newAssumptions.forEach(assumption => this._allAssumptions.add(assumption));
        return {
            ...agentResponse,
            analysis_assumptions: newAssumptions.length > 0 ? newAssumptions : undefined
        };
    }
    createDuplicateChatHistoryManager() {
        const duplicateManager = new ChatHistoryManager(this.contextManager, this.notebookTracker, this.displayOptimizedChatHistory);
        // Copy the assumptions set to the duplicate
        duplicateManager._allAssumptions = new Set(this._allAssumptions);
        return duplicateManager;
    }
    getDisplayOptimizedHistory() {
        return this.displayOptimizedChatHistory;
    }
    addChatMessageFromHistory(message) {
        this.displayOptimizedChatHistory.push({
            message: message,
            type: 'openai message',
            codeCellID: undefined,
            promptType: 'chat'
        });
    }
    async addChatInputMessage(input, activeThreadId, messageIndex, additionalContext) {
        const activeCellCode = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_1__.getActiveCellCode)(this.notebookTracker) || '';
        const activeCellID = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_1__.getActiveCellID)(this.notebookTracker) || '';
        const activeNotebookContext = this.contextManager.getActiveNotebookContext();
        const chatMessageMetadata = {
            promptType: 'chat',
            variables: (activeNotebookContext === null || activeNotebookContext === void 0 ? void 0 : activeNotebookContext.variables) || [],
            files: (activeNotebookContext === null || activeNotebookContext === void 0 ? void 0 : activeNotebookContext.files) || [],
            activeCellCode: activeCellCode,
            activeCellId: activeCellID,
            input: input,
            threadId: activeThreadId,
            index: messageIndex,
            additionalContext: additionalContext
        };
        this.displayOptimizedChatHistory.push({
            message: getDisplayedOptimizedUserMessage(input, activeCellCode),
            type: 'openai message',
            codeCellID: activeCellID,
            promptType: 'chat',
            additionalContext: additionalContext
        });
        return chatMessageMetadata;
    }
    addAgentExecutionMessage(activeThreadId, notebookPanel, input, additionalContext) {
        const aiOptimizedCells = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_1__.getAIOptimizedCellsInNotebookPanel)(notebookPanel);
        const notebookContext = this.contextManager.getNotebookContext(notebookPanel.id);
        const agentExecutionMetadata = {
            promptType: 'agent:execution',
            variables: (notebookContext === null || notebookContext === void 0 ? void 0 : notebookContext.variables) || [],
            files: (notebookContext === null || notebookContext === void 0 ? void 0 : notebookContext.files) || [],
            aiOptimizedCells: aiOptimizedCells,
            input: input || '',
            threadId: activeThreadId,
            isChromeBrowser: (0,_utils_user__WEBPACK_IMPORTED_MODULE_2__.isChromeBasedBrowser)(),
            additionalContext: additionalContext
        };
        // We use this function in two ways: 
        // 1. When the user sends the original agent:execution message to start the agent
        // 2. When the agent sends itself information about the updated variables, etc. In this case, 
        // we don't want to pass an input. 
        let userMessage;
        if (input) {
            userMessage = getDisplayedOptimizedUserMessage(input);
        }
        else {
            userMessage = {
                role: 'user',
                content: ''
            };
        }
        this.displayOptimizedChatHistory.push({
            message: userMessage,
            type: 'openai message',
            promptType: 'chat',
            additionalContext: additionalContext
        });
        return agentExecutionMetadata;
    }
    addSmartDebugMessage(activeThreadId, errorMessage) {
        const activeCellID = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_1__.getActiveCellID)(this.notebookTracker) || '';
        const activeCellCode = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_1__.getCellCodeByID)(this.notebookTracker, activeCellID) || '';
        const activeNotebookContext = this.contextManager.getActiveNotebookContext();
        const smartDebugMetadata = {
            promptType: 'smartDebug',
            variables: (activeNotebookContext === null || activeNotebookContext === void 0 ? void 0 : activeNotebookContext.variables) || [],
            files: (activeNotebookContext === null || activeNotebookContext === void 0 ? void 0 : activeNotebookContext.files) || [],
            activeCellCode: activeCellCode,
            activeCellId: activeCellID,
            errorMessage: errorMessage,
            threadId: activeThreadId
        };
        this.displayOptimizedChatHistory.push({
            message: getDisplayedOptimizedUserMessage(errorMessage, activeCellCode),
            type: 'openai message',
            codeCellID: activeCellID,
            promptType: 'smartDebug'
        });
        return smartDebugMetadata;
    }
    addAgentSmartDebugMessage(activeThreadId, errorMessage, notebookPanel) {
        const activeCellID = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_1__.getActiveCellIDInNotebookPanel)(notebookPanel);
        const activeCellCode = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_1__.getCellCodeByIDInNotebookPanel)(notebookPanel, activeCellID);
        const notebookContext = this.contextManager.getNotebookContext(notebookPanel.id);
        const agentSmartDebugMetadata = {
            promptType: 'agent:autoErrorFixup',
            aiOptimizedCells: (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_1__.getAIOptimizedCellsInNotebookPanel)(notebookPanel),
            variables: (notebookContext === null || notebookContext === void 0 ? void 0 : notebookContext.variables) || [],
            files: (notebookContext === null || notebookContext === void 0 ? void 0 : notebookContext.files) || [],
            errorMessage: errorMessage,
            error_message_producing_code_cell_id: activeCellID || '',
            threadId: activeThreadId,
            isChromeBrowser: (0,_utils_user__WEBPACK_IMPORTED_MODULE_2__.isChromeBasedBrowser)()
        };
        this.displayOptimizedChatHistory.push({
            message: getDisplayedOptimizedUserMessage(errorMessage, activeCellCode),
            type: 'openai message',
            codeCellID: activeCellID,
            promptType: 'agent:autoErrorFixup'
        });
        return agentSmartDebugMetadata;
    }
    addExplainCodeMessage(activeThreadId) {
        const activeCellID = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_1__.getActiveCellID)(this.notebookTracker);
        const activeCellCode = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_1__.getCellCodeByID)(this.notebookTracker, activeCellID);
        const activeNotebookContext = this.contextManager.getActiveNotebookContext();
        const codeExplainMetadata = {
            promptType: 'codeExplain',
            variables: (activeNotebookContext === null || activeNotebookContext === void 0 ? void 0 : activeNotebookContext.variables) || [],
            activeCellCode,
            threadId: activeThreadId
        };
        this.displayOptimizedChatHistory.push({
            message: getDisplayedOptimizedUserMessage('Explain this code', activeCellCode),
            type: 'openai message',
            codeCellID: activeCellID,
            promptType: 'codeExplain'
        });
        return codeExplainMetadata;
    }
    addAIMessageFromResponse(messageContent, promptType, mitoAIConnectionError = false, mitoAIConnectionErrorType = null) {
        if (messageContent === null) {
            return;
        }
        const aiMessage = {
            role: 'assistant',
            content: messageContent
        };
        let type;
        if (mitoAIConnectionError) {
            type = 'connection error';
        }
        else {
            type = 'openai message';
        }
        const activeCellID = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_1__.getActiveCellID)(this.notebookTracker);
        this.displayOptimizedChatHistory.push({
            message: aiMessage,
            type: type,
            mitoAIConnectionErrorType: mitoAIConnectionErrorType,
            codeCellID: activeCellID,
            promptType: promptType
        });
    }
    addStreamingAIMessage(messageContent, promptType) {
        // Find the last AI message in the history
        const lastAIMessageIndex = this.getLastAIMessageIndex();
        if (lastAIMessageIndex === undefined ||
            this.displayOptimizedChatHistory.length !== lastAIMessageIndex + 1) {
            // If no AI message exists, create a new one
            this.addAIMessageFromResponse(messageContent, promptType);
        }
        else {
            // Update the last AI message with the new content
            const lastMessage = this.displayOptimizedChatHistory[lastAIMessageIndex];
            if (lastMessage) {
                lastMessage.message.content = messageContent;
            }
        }
    }
    addAIMessageFromAgentResponse(agentResponse) {
        var _a;
        agentResponse = (0,_validationUtils__WEBPACK_IMPORTED_MODULE_0__.validateAndCorrectAgentResponse)(agentResponse);
        let content = agentResponse.message;
        if (agentResponse.type === 'cell_update') {
            // For cell_update messages, we want to display the code the agent wrote along with 
            // the message it sent. For all other agent responses, we ignore all other fields
            // and just display the message.
            const code = (_a = agentResponse.cell_update) === null || _a === void 0 ? void 0 : _a.code;
            const codeWithMarkdownFormatting = (0,_utils_strings__WEBPACK_IMPORTED_MODULE_3__.addMarkdownCodeFormatting)(code);
            if (codeWithMarkdownFormatting !== undefined) {
                content = content + '\n\n' + codeWithMarkdownFormatting;
            }
        }
        const aiMessage = {
            role: 'assistant',
            content: content
        };
        this.displayOptimizedChatHistory.push({
            message: aiMessage,
            type: 'openai message',
            promptType: 'agent:execution',
            agentResponse: this.deduplicateAssumptions(agentResponse)
        });
    }
    dropMessagesStartingAtIndex(index) {
        this.displayOptimizedChatHistory.splice(index);
    }
}
const getDisplayedOptimizedUserMessage = (input, activeCellCode, messageToAgent = false) => {
    // Don't include the active cell code if it is an agent planning message
    // or if the there is no active cell code provided, which occurs when
    // sending an agent:execution message which uses the entire notebook as context
    // instead of just the active cell
    let activeCellCodeBlock = '';
    if (!messageToAgent && activeCellCode) {
        activeCellCodeBlock =
            `\`\`\`python
${activeCellCode}
\`\`\``;
    }
    return {
        role: 'user',
        content: `${activeCellCodeBlock}
${input}`
    };
};


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatMessage/AlertBlock.js":
/*!*********************************************************!*\
  !*** ./lib/Extensions/AiChat/ChatMessage/AlertBlock.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_errors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/errors */ "./lib/utils/errors.js");
/* harmony import */ var _utils_stripe__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../utils/stripe */ "./lib/utils/stripe.js");
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/* harmony import */ var _style_AlertBlock_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../style/AlertBlock.css */ "./style/AlertBlock.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */





// Add calendly link constant
const CALENDLY_LINK = 'https://calendly.com/jake_from_mito/mito-meeting';
const AlertBlock = ({ content, mitoAIConnectionErrorType }) => {
    const [showEmailDetails, setShowEmailDetails] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    // The first time this AlertBlock is rendered, log the error type
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        void (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_2__.logEvent)('alert_block_displayed', { 'type': mitoAIConnectionErrorType, 'error': content });
    }, []);
    if (mitoAIConnectionErrorType === _utils_errors__WEBPACK_IMPORTED_MODULE_3__.FREE_TIER_LIMIT_REACHED_ERROR_TITLE) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "chat-message-alert-container upgrade" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "chat-message-alert" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "alert-error-message" }, "Free Trial Limit Reached")),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "alert-actions-title" }, "You've used up your free trial of Mito AI for this month."),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "alert-actions-title", style: { marginTop: '0px', marginBottom: '5px' } }, "Choose how you'd like to continue:"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ol", { style: { margin: '0', paddingLeft: '20px' } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { action: _utils_stripe__WEBPACK_IMPORTED_MODULE_4__.STRIPE_PAYMENT_LINK, method: "POST", target: "_blank", style: { display: 'inline' } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { type: "submit", className: "secondary-option-link", style: {
                                background: 'none',
                                border: 'none',
                                padding: 0,
                                font: 'inherit',
                                color: 'var(--purple-700)',
                                textDecoration: 'underline',
                                cursor: 'pointer',
                                transition: 'color 0.2s ease'
                            } }, "Upgrade to Mito Pro")),
                    ' ',
                    " for unlimited AI access and dedicated support"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: () => {
                            window.open(CALENDLY_LINK, '_blank');
                        }, className: "secondary-option-link", style: {
                            background: 'none',
                            border: 'none',
                            padding: 0,
                            font: 'inherit',
                            color: 'var(--purple-700)',
                            textDecoration: 'underline',
                            cursor: 'pointer',
                            transition: 'color 0.2s ease'
                        } }, "Schedule a call with our founders"),
                    ' ',
                    " to get 3 free months of Mito Pro"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", { href: "https://docs.trymito.io/mito-ai/configuring-ai-provider-keys", target: "_blank", rel: "noreferrer", className: "secondary-option-link" }, "Use your own API keys"),
                    ' ',
                    " to continue using Mito AI"))));
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "chat-message-alert-container error" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "chat-message-alert" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "alert-error-message" },
                "\u26A0 ",
                content)),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "alert-actions-title" }, "If this issue persists, we recommend:"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", { className: "alert-actions-list" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, "Restarting JupyterLab completely"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, "Upgrading to the latest version of Mito AI"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null,
                    "Sending us an email to founders@sagacollab.com \u00A0",
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "details-toggle" },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { type: "button", onClick: () => setShowEmailDetails(!showEmailDetails), className: "toggle-button" },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "toggle-text" }, " Info to send us"),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: `toggle-caret ${showEmailDetails ? 'open' : ''}` }, "\u25BC"))),
                    showEmailDetails && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "details-content" },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, "A screenshot of your entire Jupyter window"),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, "A screenshot of your browser's console. You can access this by right clicking on this error message, clicking \"Inspect\", and then clicking the \"Console\" tab. Then find the red error message at the bottom of the console and screenshot it."),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, "Your `pip list` output"))))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AlertBlock);


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatMessage/AssistantCodeBlock.js":
/*!*****************************************************************!*\
  !*** ./lib/Extensions/AiChat/ChatMessage/AssistantCodeBlock.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _PythonCode__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./PythonCode */ "./lib/Extensions/AiChat/ChatMessage/PythonCode.js");
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/classNames */ "./lib/utils/classNames.js");
/* harmony import */ var _style_CodeBlock_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../style/CodeBlock.css */ "./style/CodeBlock.css");
/* harmony import */ var _style_AgentComponentHeader_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../style/AgentComponentHeader.css */ "./style/AgentComponentHeader.css");
/* harmony import */ var _icons_CodeIcon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../icons/CodeIcon */ "./lib/icons/CodeIcon.js");
/* harmony import */ var _CodeBlockToolbar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./CodeBlockToolbar */ "./lib/Extensions/AiChat/ChatMessage/CodeBlockToolbar.js");
/* harmony import */ var _components_AgentComponents_AgentComponentHeader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../components/AgentComponents/AgentComponentHeader */ "./lib/components/AgentComponents/AgentComponentHeader.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */








const AssistantCodeBlock = ({ code, codeSummary, isCodeComplete, renderMimeRegistry, previewAICode, acceptAICode, rejectAICode, isLastAiMessage, codeReviewStatus, agentModeEnabled, isErrorFixup, }) => {
    const [isCodeExpanded, setIsCodeExpanded] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const shouldShowToolbar = isLastAiMessage || isCodeComplete;
    if (agentModeEnabled) {
        // Handle regular code blocks
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_3__.classNames)('code-block-container', 'agent-mode', {
                'agent-mode-collapsed': !isCodeExpanded,
            }) },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_AgentComponents_AgentComponentHeader__WEBPACK_IMPORTED_MODULE_4__["default"], { icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_CodeIcon__WEBPACK_IMPORTED_MODULE_5__["default"], null), text: codeSummary !== null && codeSummary !== void 0 ? codeSummary : 'Generated code', onClick: () => setIsCodeExpanded(!isCodeExpanded), isExpanded: isCodeExpanded, displayBorder: !isErrorFixup, className: isErrorFixup ? 'error-fixup' : undefined }),
            isCodeExpanded && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_PythonCode__WEBPACK_IMPORTED_MODULE_6__["default"], { code: code, renderMimeRegistry: renderMimeRegistry }))));
    }
    else {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "code-block-container" },
            shouldShowToolbar && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CodeBlockToolbar__WEBPACK_IMPORTED_MODULE_7__["default"], { code: code, isLastAiMessage: isLastAiMessage, codeReviewStatus: codeReviewStatus, onPreview: previewAICode, onAccept: acceptAICode, onReject: rejectAICode })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_PythonCode__WEBPACK_IMPORTED_MODULE_6__["default"], { code: code, renderMimeRegistry: renderMimeRegistry })));
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AssistantCodeBlock);


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatMessage/ChatDropdown.js":
/*!***********************************************************!*\
  !*** ./lib/Extensions/AiChat/ChatMessage/ChatDropdown.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/* harmony import */ var _ChatDropdownItems__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ChatDropdownItems */ "./lib/Extensions/AiChat/ChatMessage/ChatDropdownItems.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */



const priortizeByType = (options, maxPerType) => {
    /*
    Makes sure that some of each type are displayed at the top of the dropdown so
    users can easily see what types of options are available to them.
    */
    const typeCounts = {};
    const prioritizedOptions = [];
    const extraOptions = [];
    for (const option of options) {
        const type = option.type;
        const currentCount = typeCounts[type] || 0;
        if (currentCount < maxPerType) {
            prioritizedOptions.push(option);
            typeCounts[type] = currentCount + 1;
        }
        else {
            extraOptions.push(option);
        }
    }
    // Return prioritized options first, then extras at the bottom
    return [...prioritizedOptions, ...extraOptions];
};
const ChatDropdown = ({ options, onSelect, filterText, isDropdownFromButton = false, onFilterChange, onClose, }) => {
    const [selectedIndex, setSelectedIndex] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
    const [localFilterText, setLocalFilterText] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(filterText);
    const searchInputRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    const [rules, setRules] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    const [databaseConnections, setDatabaseConnections] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const fetchRules = async () => {
            const rules = await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__.getRules)();
            setRules(rules);
        };
        const fetchDatabaseConnections = async () => {
            const databaseConnections = await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__.getDatabaseConnections)();
            setDatabaseConnections(databaseConnections);
        };
        void fetchRules();
        void fetchDatabaseConnections();
    }, []);
    // Focus search input when dropdown opens with search input
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (isDropdownFromButton && searchInputRef.current) {
            searchInputRef.current.focus();
        }
    }, [isDropdownFromButton]);
    // Use local filter text when search input is shown, otherwise use prop
    const effectiveFilterText = isDropdownFromButton ? localFilterText : filterText;
    // Create a list of all options with the format 
    // ['type': 'variable', "expandedVariable": variable]
    // ['type': 'rule', "rule": rule]
    // ['type': 'file', "file": file]
    const allOptions = [
        // Rules first
        ...rules.map((rule) => ({
            type: 'rule',
            rule: rule
        })),
        // Files second
        ...options
            .filter(variable => variable.file_name) // Only files
            .map((file) => ({
            type: 'file',
            file: file
        })),
        // Databases third
        ...Object.entries(databaseConnections).map(([connectionId, connection]) => ({
            type: 'db',
            variable: {
                variable_name: connection.alias || connection.database,
                type: "db",
                value: connectionId + " - " + connection.type,
                parent_df: connection.type
            }
        })),
        // Dataframes fourth
        ...options
            .filter(variable => !variable.file_name && variable.type === "pd.DataFrame")
            .map((variable) => ({
            type: 'variable',
            variable: variable
        })),
        // Columns fifth
        ...options
            .filter(variable => !variable.file_name && variable.parent_df && variable.type !== "pd.DataFrame")
            .map((variable) => ({
            type: 'variable',
            variable: variable
        })),
        // Other variables last
        ...options
            .filter(variable => !variable.file_name && !variable.parent_df && variable.type !== "pd.DataFrame")
            .map((variable) => ({
            type: 'variable',
            variable: variable
        })),
    ];
    let searchFilteredOptions = allOptions.filter((option) => {
        if (option.type === 'variable') {
            return option.variable.variable_name.toLowerCase().includes(effectiveFilterText.toLowerCase()) &&
                option.variable.type !== "<class 'module'>" &&
                option.variable.variable_name !== "FUNCTIONS"; // This is default exported from mitosheet when you run from mitosheet import * as FUNCTIONS
        }
        else if (option.type === 'file') {
            return option.file.variable_name.toLowerCase().includes(effectiveFilterText.toLowerCase());
        }
        else if (option.type === 'db') {
            return option.variable.variable_name.toLowerCase().includes(effectiveFilterText.toLowerCase()) ||
                option.variable.value.toLowerCase().includes(effectiveFilterText.toLowerCase());
        }
        else {
            return option.rule.toLowerCase().includes(effectiveFilterText.toLowerCase());
        }
    });
    // If user is searching (has filter text), show all matches
    // Otherwise, show only 3 of each type by default
    if (effectiveFilterText.trim() === '') {
        searchFilteredOptions = priortizeByType(searchFilteredOptions, 3);
    }
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        setSelectedIndex(0);
    }, [options, rules, effectiveFilterText]);
    const handleKeyDown = (event) => {
        switch (event.key) {
            case 'ArrowDown':
            case 'Down':
                event.preventDefault();
                setSelectedIndex((prev) => prev < searchFilteredOptions.length - 1 ? prev + 1 : 0);
                break;
            case 'ArrowUp':
            case 'Up':
                event.preventDefault();
                setSelectedIndex((prev) => prev > 0 ? prev - 1 : searchFilteredOptions.length - 1);
                break;
            case 'Enter':
            case 'Return':
            case 'Tab': {
                event.preventDefault();
                const selectedOption = searchFilteredOptions[selectedIndex];
                if (selectedOption !== undefined) {
                    if (selectedOption.type === 'variable') {
                        onSelect(selectedOption);
                    }
                    else {
                        onSelect(selectedOption);
                    }
                }
                break;
            }
        }
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        document.addEventListener('keydown', handleKeyDown);
        return () => document.removeEventListener('keydown', handleKeyDown);
    }, [searchFilteredOptions, selectedIndex]);
    // Handle click outside to close dropdown
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const handleClickOutside = (event) => {
            const target = event.target;
            const dropdownElement = document.querySelector('.chat-dropdown');
            if (dropdownElement && !dropdownElement.contains(target)) {
                if (onClose) {
                    onClose();
                }
            }
        };
        document.addEventListener('mousedown', handleClickOutside);
        return () => document.removeEventListener('mousedown', handleClickOutside);
    }, [onClose]);
    const handleSearchInputChange = (event) => {
        const newFilterText = event.target.value;
        setLocalFilterText(newFilterText);
        if (onFilterChange) {
            onFilterChange(newFilterText);
        }
    };
    const handleSearchInputKeyDown = (event) => {
        if (event.key === 'Escape') {
            event.preventDefault();
            event.stopPropagation();
            if (onFilterChange) {
                onFilterChange(''); // Clear the filter
            }
            if (onClose) {
                onClose(); // Close the dropdown
            }
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `chat-dropdown`, "data-testid": "chat-dropdown" },
        isDropdownFromButton && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "chat-dropdown-search" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { ref: searchInputRef, type: "text", placeholder: "Search variables and rules...", value: localFilterText, onChange: handleSearchInputChange, onKeyDown: handleSearchInputKeyDown, className: "chat-dropdown-search-input" }))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", { className: "chat-dropdown-list", "data-testid": "chat-dropdown-list" },
            searchFilteredOptions.length === 0 && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { className: "chat-dropdown-item", "data-testid": "chat-dropdown-empty-item" }, "No variables found")),
            searchFilteredOptions.map((option, index) => {
                switch (option.type) {
                    case 'variable': {
                        const uniqueKey = option.variable.parent_df
                            ? `${option.variable.parent_df}.${option.variable.variable_name}`
                            : option.variable.variable_name;
                        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ChatDropdownItems__WEBPACK_IMPORTED_MODULE_2__.VariableDropdownItem, { key: uniqueKey, variable: option.variable, index: index, selectedIndex: selectedIndex, onSelect: () => onSelect(option) }));
                    }
                    case 'file': {
                        const uniqueKey = option.file.variable_name;
                        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ChatDropdownItems__WEBPACK_IMPORTED_MODULE_2__.FileDropdownItem, { key: uniqueKey, file: option.file, index: index, selectedIndex: selectedIndex, onSelect: () => onSelect(option) }));
                    }
                    case 'rule': {
                        const uniqueKey = option.rule;
                        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ChatDropdownItems__WEBPACK_IMPORTED_MODULE_2__.RuleDropdownItem, { key: uniqueKey, rule: option.rule, index: index, selectedIndex: selectedIndex, onSelect: () => onSelect(option) }));
                    }
                    case 'db': {
                        const uniqueKey = option.variable.variable_name;
                        // You can replace VariableDropdownItem with a custom DBDropdownItem if you want
                        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ChatDropdownItems__WEBPACK_IMPORTED_MODULE_2__.VariableDropdownItem, { key: uniqueKey, variable: option.variable, index: index, selectedIndex: selectedIndex, onSelect: () => onSelect(option) }));
                    }
                    default:
                        return null;
                }
            }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChatDropdown);


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatMessage/ChatDropdownItems.js":
/*!****************************************************************!*\
  !*** ./lib/Extensions/AiChat/ChatMessage/ChatDropdownItems.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FileDropdownItem: () => (/* binding */ FileDropdownItem),
/* harmony export */   RuleDropdownItem: () => (/* binding */ RuleDropdownItem),
/* harmony export */   VariableDropdownItem: () => (/* binding */ VariableDropdownItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../utils/classNames */ "./lib/utils/classNames.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


const VariableDropdownItem = ({ variable, index, selectedIndex, onSelect }) => {
    const getShortType = (type) => {
        var _a;
        if (type.includes("DataFrame")) {
            return "df";
        }
        if (type.includes("Series")) {
            return "s";
        }
        if (type.includes("<class '")) {
            return (_a = type.split("'")[1]) !== null && _a !== void 0 ? _a : '';
        }
        return type;
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_1__.classNames)("chat-dropdown-item", { selected: index === selectedIndex }), onClick: () => onSelect(variable.variable_name, variable.parent_df), "data-testid": `chat-dropdown-item-${variable.variable_name}` },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "chat-dropdown-item-type", title: getShortType(variable.type), "data-testid": `chat-dropdown-item-type-${variable.variable_name}` }, getShortType(variable.type)),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "chat-dropdown-item-name", title: variable.variable_name, "data-testid": `chat-dropdown-item-name-${variable.variable_name}`, ref: (el) => {
                // Show full text on hover if the text is too long
                if (el) {
                    el.title = el.scrollWidth > el.clientWidth ? variable.variable_name : '';
                }
            } }, variable.variable_name),
        variable.parent_df && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "chat-dropdown-item-parent-df" }, variable.parent_df))));
};
const FileDropdownItem = ({ file, index, selectedIndex, onSelect }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_1__.classNames)("chat-dropdown-item", { selected: index === selectedIndex }), onClick: () => onSelect(file), "data-testid": `chat-dropdown-item-${file.variable_name}` },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "chat-dropdown-item-type", title: file.type, "data-testid": `chat-dropdown-item-type-${file.variable_name}` }, file.type),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "chat-dropdown-item-name", title: file.variable_name, "data-testid": `chat-dropdown-item-name-${file.variable_name}`, ref: (el) => {
                // Show full text on hover if the text is too long
                if (el) {
                    el.title = el.scrollWidth > el.clientWidth ? file.variable_name : '';
                }
            } }, file.variable_name)));
};
const RuleDropdownItem = ({ rule, index, selectedIndex, onSelect }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_1__.classNames)("chat-dropdown-item", { selected: index === selectedIndex }), onClick: () => onSelect(rule), "data-testid": `chat-dropdown-item-${rule}` },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "chat-dropdown-item-type", title: "rule", "data-testid": `chat-dropdown-item-type-${rule}` }, "rule"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "chat-dropdown-item-name", title: rule, "data-testid": `chat-dropdown-item-name-${rule}`, ref: (el) => {
                // Show full text on hover if the text is too long
                if (el) {
                    el.title = el.scrollWidth > el.clientWidth ? rule : '';
                }
            } }, rule)));
};


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatMessage/ChatInput.js":
/*!********************************************************!*\
  !*** ./lib/Extensions/AiChat/ChatMessage/ChatInput.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../utils/classNames */ "./lib/utils/classNames.js");
/* harmony import */ var _ChatDropdown__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ChatDropdown */ "./lib/Extensions/AiChat/ChatMessage/ChatDropdown.js");
/* harmony import */ var _utils_notebook__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/notebook */ "./lib/utils/notebook.js");
/* harmony import */ var _style_ChatInput_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../style/ChatInput.css */ "./style/ChatInput.css");
/* harmony import */ var _style_ChatDropdown_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../style/ChatDropdown.css */ "./style/ChatDropdown.css");
/* harmony import */ var _hooks_useDebouncedFunction__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../hooks/useDebouncedFunction */ "./lib/hooks/useDebouncedFunction.js");
/* harmony import */ var _components_SelectedContextContainer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../components/SelectedContextContainer */ "./lib/components/SelectedContextContainer.js");
/* harmony import */ var _components_AttachFileButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../components/AttachFileButton */ "./lib/components/AttachFileButton.js");
/* harmony import */ var _components_DatabaseButton__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../components/DatabaseButton */ "./lib/components/DatabaseButton.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */










const ChatInput = ({ app, initialContent, onSave, onCancel, isEditing, contextManager, notebookTracker, agentModeEnabled = false, agentExecutionStatus = 'idle', operatingSystem = 'mac', displayOptimizedChatHistoryLength = 0, agentTargetNotebookPanelRef, isSignedUp = true, }) => {
    var _a;
    const [input, setInput] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initialContent);
    const textAreaRef = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(null);
    const [activeCellID, setActiveCellID] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)((0,_utils_notebook__WEBPACK_IMPORTED_MODULE_3__.getActiveCellID)(notebookTracker));
    const activeCellCode = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_3__.getActiveCellCode)(notebookTracker) || '';
    const [isDropdownVisible, setDropdownVisible] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [dropdownFilter, setDropdownFilter] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    const [additionalContext, setAdditionalContext] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    const [isDropdownFromButton, setIsDropdownFromButton] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const handleFileUpload = (file) => {
        let uploadType;
        if (file.type.startsWith('image/')) {
            // If the file is an image, we want to preserve the file type.
            // The type is used to display the image icon in the SelectedContextContainer,
            // and is used to encode the image on the backend.
            uploadType = file.type;
        }
        else {
            uploadType = 'file';
        }
        // Add the uploaded file to the additional context
        setAdditionalContext(prev => [
            ...prev, {
                type: uploadType,
                value: file.name,
                display: file.name
            }
        ]);
    };
    // Debounce the active cell ID change to avoid multiple rerenders. 
    // We use this to avoid a flickering screen when the active cell changes. 
    const debouncedSetActiveCellID = (0,_hooks_useDebouncedFunction__WEBPACK_IMPORTED_MODULE_4__.useDebouncedFunction)((newID) => {
        setActiveCellID(newID);
    }, 100);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const activeCellChangedListener = () => {
            const newActiveCellID = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_3__.getActiveCellID)(notebookTracker);
            debouncedSetActiveCellID(newActiveCellID);
        };
        // Connect the listener once when the component mounts
        notebookTracker.activeCellChanged.connect(activeCellChangedListener);
        // Cleanup: disconnect the listener when the component unmounts
        return () => {
            notebookTracker.activeCellChanged.disconnect(activeCellChangedListener);
        };
    }, [notebookTracker, activeCellID, debouncedSetActiveCellID]);
    // TextAreas cannot automatically adjust their height based on the content that they contain, 
    // so instead we re-adjust the height as the content changes here. 
    const adjustHeight = (resetHeight = false) => {
        const textarea = textAreaRef === null || textAreaRef === void 0 ? void 0 : textAreaRef.current;
        if (!textarea)
            return;
        textarea.style.minHeight = 'auto';
        const maxHeight = 350;
        textarea.style.height = !textarea.value || resetHeight
            ? '80px'
            : `${Math.min(maxHeight, Math.max(80, textarea.scrollHeight))}px`;
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        adjustHeight();
    }, [(_a = textAreaRef === null || textAreaRef === void 0 ? void 0 : textAreaRef.current) === null || _a === void 0 ? void 0 : _a.value]);
    const handleInputChange = (event) => {
        const value = event.target.value;
        setInput(value);
        const cursorPosition = event.target.selectionStart;
        const textBeforeCursor = value.slice(0, cursorPosition);
        const words = textBeforeCursor.split(/\s+/);
        const currentWord = words[words.length - 1];
        if (currentWord && currentWord.startsWith("@")) {
            const query = currentWord.slice(1);
            setDropdownFilter(query);
            setDropdownVisible(true);
            setIsDropdownFromButton(false);
        }
        else {
            setDropdownVisible(false);
            setDropdownFilter('');
            setIsDropdownFromButton(false);
        }
    };
    const handleOptionSelect = (option) => {
        if (isDropdownFromButton) {
            // When triggered by "Add Context" button, add to SelectedContextContainer
            if (option.type === 'variable') {
                // For variables, we'll add them as a special context type
                const contextName = option.variable.parent_df
                    ? `${option.variable.parent_df}.${option.variable.variable_name}`
                    : option.variable.variable_name;
                setAdditionalContext(prev => [...prev, { type: 'variable', value: contextName }]);
            }
            else if (option.type === 'file') {
                setAdditionalContext(prev => [...prev, { type: 'file', value: option.file.variable_name }]);
            }
            else if (option.type === 'rule') {
                setAdditionalContext(prev => [...prev, { type: 'rule', value: option.rule }]);
            }
            else if (option.type === 'db') {
                setAdditionalContext(prev => [
                    ...prev,
                    {
                        type: 'db',
                        value: option.variable.value,
                        display: option.variable.variable_name
                    }
                ]);
            }
            setDropdownVisible(false);
            // Use setTimeout to ensure this happens after React's state update cycle
            setTimeout(() => {
                var _a;
                (_a = textAreaRef.current) === null || _a === void 0 ? void 0 : _a.focus();
            }, 0);
            return;
        }
        // Original behavior for @ dropdown - add to text input
        const textarea = textAreaRef.current;
        if (!textarea)
            return;
        const cursorPosition = textarea.selectionStart;
        const textBeforeCursor = input.slice(0, cursorPosition);
        const atIndex = textBeforeCursor.lastIndexOf("@");
        const textAfterCursor = input.slice(cursorPosition);
        let contextChatRepresentation = '';
        if (option.type === 'variable') {
            if (option.variable.parent_df) {
                contextChatRepresentation = `\`${option.variable.variable_name}\``;
            }
            else {
                contextChatRepresentation = `\`${option.variable.variable_name}\``;
            }
        }
        else if (option.type === 'file') {
            // For files, add them as both back-ticked elements and the additional context container
            contextChatRepresentation = `\`${option.file.variable_name}\``;
            setAdditionalContext([...additionalContext, { type: 'file', value: option.file.variable_name }]);
        }
        else if (option.type === 'rule') {
            // We don't add the rule as an back ticked element in the chat input, 
            // and instead just add it as plain text because we also add it as 
            // a context container above the chat input and we want the user to 
            // delete the context from there if they want to. 
            contextChatRepresentation = option.rule;
            setAdditionalContext([...additionalContext, { type: 'rule', value: option.rule }]);
        }
        else if (option.type === 'db') {
            // For databases, add them as back-ticked elements
            contextChatRepresentation = `\`${option.variable.variable_name}\``;
            setAdditionalContext([
                ...additionalContext,
                { type: 'db', value: option.variable.value, display: option.variable.variable_name }
            ]);
        }
        const newValue = input.slice(0, atIndex) +
            contextChatRepresentation +
            textAfterCursor;
        setInput(newValue);
        setDropdownVisible(false);
        // After updating the input value, set the cursor position after the inserted variable name
        // We use setTimeout to ensure this happens after React's state update
        setTimeout(() => {
            if (textarea) {
                const newCursorPosition = atIndex + contextChatRepresentation.length;
                textarea.focus();
                textarea.setSelectionRange(newCursorPosition, newCursorPosition);
            }
        }, 0);
    };
    const handleDropdownClose = () => {
        setDropdownVisible(false);
        setDropdownFilter('');
        setIsDropdownFromButton(false);
    };
    const mapAdditionalContext = () => {
        const result = [];
        additionalContext.forEach(contextItem => {
            if (contextItem.type === 'db') {
                result.push({
                    type: contextItem.type,
                    value: contextItem.value
                });
            }
            else {
                result.push(contextItem);
            }
        });
        return result;
    };
    const getExpandedVarialbes = () => {
        const activeNotebookContext = contextManager === null || contextManager === void 0 ? void 0 : contextManager.getActiveNotebookContext();
        const expandedVariables = [
            // Add base variables (excluding DataFrames)
            ...((activeNotebookContext === null || activeNotebookContext === void 0 ? void 0 : activeNotebookContext.variables.filter(variable => variable.type !== "pd.DataFrame")) || []),
            // Add DataFrames
            ...((activeNotebookContext === null || activeNotebookContext === void 0 ? void 0 : activeNotebookContext.variables.filter((variable) => variable.type === "pd.DataFrame")) || []),
            // Add series with parent DataFrame references
            ...((activeNotebookContext === null || activeNotebookContext === void 0 ? void 0 : activeNotebookContext.variables.filter((variable) => variable.type === "pd.DataFrame").flatMap((df) => Object.entries(df.value).map(([seriesName, _]) => ({
                variable_name: seriesName,
                type: "col",
                value: "replace_me",
                parent_df: df.variable_name,
            })))) || []),
            // Add files
            ...((activeNotebookContext === null || activeNotebookContext === void 0 ? void 0 : activeNotebookContext.files.map(file => {
                var _a;
                return ({
                    variable_name: file.file_name,
                    type: ((_a = file.file_name.split('.').pop()) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '',
                    value: file.file_name,
                    file_name: file.file_name
                });
            })) || [])
        ];
        return expandedVariables;
    };
    const getPlaceholderText = () => {
        var _a;
        if (!isSignedUp && displayOptimizedChatHistoryLength === 0) {
            return 'Sign up above to use Mito AI';
        }
        else if (agentExecutionStatus === 'working') {
            return `Agent is editing ${(_a = agentTargetNotebookPanelRef === null || agentTargetNotebookPanelRef === void 0 ? void 0 : agentTargetNotebookPanelRef.current) === null || _a === void 0 ? void 0 : _a.context.path.split('/').pop()}`;
        }
        else if (agentExecutionStatus === 'stopping') {
            return 'Agent is stopping...';
        }
        else if (agentModeEnabled) {
            return 'Ask agent to do anything';
        }
        else if (isEditing) {
            return 'Edit your message';
        }
        else if (displayOptimizedChatHistoryLength < 2) {
            return `Ask question (${operatingSystem === 'mac' ? '⌘' : 'Ctrl'}E), @ to mention`;
        }
        else {
            return `Ask followup (${operatingSystem === 'mac' ? '⌘' : 'Ctrl'}E), @ to mention`;
        }
    };
    // Automatically add active cell context when in Chat mode and there's active cell code
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (!agentModeEnabled) {
            // Check if active cell context is already present
            const hasActiveCellContext = additionalContext.some(context => context.type === 'active_cell');
            if (!hasActiveCellContext) {
                setAdditionalContext(prev => [...prev, {
                        type: 'active_cell',
                        value: 'Active Cell',
                        display: 'Active Cell'
                    }]);
            }
        }
        else if (agentModeEnabled) {
            // Remove active cell context when in agent mode
            const hasActiveCellContext = additionalContext.some(context => context.type === 'active_cell');
            if (hasActiveCellContext) {
                setAdditionalContext(prev => prev.filter(context => context.type !== 'active_cell'));
            }
        }
    }, [agentModeEnabled, additionalContext, activeCellCode]);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_5__.classNames)("chat-input-container", { "editing": isEditing }) },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'context-container' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_DatabaseButton__WEBPACK_IMPORTED_MODULE_6__["default"], { app: app }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_AttachFileButton__WEBPACK_IMPORTED_MODULE_7__["default"], { onFileUploaded: handleFileUpload, notebookTracker: notebookTracker }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "context-button", onClick: () => {
                    var _a;
                    setDropdownVisible(true);
                    setDropdownFilter('');
                    setIsDropdownFromButton(true);
                    (_a = textAreaRef.current) === null || _a === void 0 ? void 0 : _a.focus();
                } }, "\uFF20 Add Context"),
            additionalContext.map((context, index) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_SelectedContextContainer__WEBPACK_IMPORTED_MODULE_8__["default"], { key: `${context.type}-${context.value}-${index}`, title: context.display || context.value, type: context.type, onRemove: () => setAdditionalContext(additionalContext.filter((_, i) => i !== index)), notebookTracker: notebookTracker, activeCellID: activeCellID })))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'chat-input-text-area-container' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("textarea", { ref: textAreaRef, className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_5__.classNames)("message", "message-user", 'chat-input', { "agent-mode": agentModeEnabled }), placeholder: getPlaceholderText(), value: input, disabled: agentExecutionStatus === 'working' || agentExecutionStatus === 'stopping', onChange: handleInputChange, onKeyDown: (e) => {
                    // If dropdown is visible, only handle escape to close it
                    if (isDropdownVisible) {
                        if (e.key === 'Escape') {
                            e.preventDefault();
                            setDropdownVisible(false);
                        }
                        return;
                    }
                    // Enter key sends the message, but we still want to allow 
                    // shift + enter to add a new line.
                    if (e.key === 'Enter' && !e.shiftKey) {
                        e.preventDefault();
                        adjustHeight(true);
                        onSave(input, undefined, mapAdditionalContext());
                        // Reset
                        setInput('');
                        setAdditionalContext([]);
                    }
                    // Escape key cancels editing
                    if (e.key === 'Escape') {
                        e.preventDefault();
                        if (onCancel) {
                            onCancel();
                        }
                    }
                } }),
            isDropdownVisible && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ChatDropdown__WEBPACK_IMPORTED_MODULE_9__["default"], { options: getExpandedVarialbes(), onSelect: handleOptionSelect, filterText: dropdownFilter, isDropdownFromButton: isDropdownFromButton, onFilterChange: setDropdownFilter, onClose: handleDropdownClose }))),
        isEditing &&
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "message-edit-buttons" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: () => onSave(input, undefined, mapAdditionalContext()) }, "Save"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: onCancel }, "Cancel"))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChatInput);


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatMessage/ChatMessage.js":
/*!**********************************************************!*\
  !*** ./lib/Extensions/AiChat/ChatMessage/ChatMessage.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../utils/classNames */ "./lib/utils/classNames.js");
/* harmony import */ var _UserCodeBlock__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./UserCodeBlock */ "./lib/Extensions/AiChat/ChatMessage/UserCodeBlock.js");
/* harmony import */ var _AssistantCodeBlock__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./AssistantCodeBlock */ "./lib/Extensions/AiChat/ChatMessage/AssistantCodeBlock.js");
/* harmony import */ var _AlertBlock__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./AlertBlock */ "./lib/Extensions/AiChat/ChatMessage/AlertBlock.js");
/* harmony import */ var _MarkdownBlock__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./MarkdownBlock */ "./lib/Extensions/AiChat/ChatMessage/MarkdownBlock.js");
/* harmony import */ var _utils_strings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/strings */ "./lib/utils/strings.js");
/* harmony import */ var _icons_Pencil__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../../icons/Pencil */ "./lib/icons/Pencil.js");
/* harmony import */ var _ChatInput__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ChatInput */ "./lib/Extensions/AiChat/ChatMessage/ChatInput.js");
/* harmony import */ var _components_TextAndIconButton__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../components/TextAndIconButton */ "./lib/components/TextAndIconButton.js");
/* harmony import */ var _icons_PlayButtonIcon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../icons/PlayButtonIcon */ "./lib/icons/PlayButtonIcon.js");
/* harmony import */ var _icons_CopyIcon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../icons/CopyIcon */ "./lib/icons/CopyIcon.js");
/* harmony import */ var _utils_copyToClipboard__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../utils/copyToClipboard */ "./lib/utils/copyToClipboard.js");
/* harmony import */ var _components_TextButton__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../components/TextButton */ "./lib/components/TextButton.js");
/* harmony import */ var _style_ChatMessage_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../style/ChatMessage.css */ "./style/ChatMessage.css");
/* harmony import */ var _style_MarkdownMessage_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../style/MarkdownMessage.css */ "./style/MarkdownMessage.css");
/* harmony import */ var _components_AgentComponents_GetCellOutputToolUI__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../../components/AgentComponents/GetCellOutputToolUI */ "./lib/components/AgentComponents/GetCellOutputToolUI.js");
/* harmony import */ var _components_AgentComponents_AssumptionToolUI__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../../components/AgentComponents/AssumptionToolUI */ "./lib/components/AgentComponents/AssumptionToolUI.js");
/* harmony import */ var _components_SelectedContextContainer__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../../components/SelectedContextContainer */ "./lib/components/SelectedContextContainer.js");
/* harmony import */ var _components_AgentComponents_RunAllCellsToolUI__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../../components/AgentComponents/RunAllCellsToolUI */ "./lib/components/AgentComponents/RunAllCellsToolUI.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




















const ChatMessage = ({ app, message, promptType, agentResponse, messageIndex, mitoAIConnectionError, mitoAIConnectionErrorType, notebookTracker, renderMimeRegistry, isLastAiMessage, isLastMessage, operatingSystem, previewAICode, acceptAICode, rejectAICode, onUpdateMessage, contextManager, codeReviewStatus, setNextSteps, agentModeEnabled, additionalContext, }) => {
    const [isEditing, setIsEditing] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    if (message.role !== 'user' && message.role !== 'assistant') {
        return null;
    }
    const editable = message.role === 'user';
    const messageContentParts = (0,_utils_strings__WEBPACK_IMPORTED_MODULE_3__.splitStringWithCodeBlocks)(message);
    const messageContent = (0,_utils_strings__WEBPACK_IMPORTED_MODULE_3__.getContentStringFromMessage)(message);
    const handleEditClick = () => {
        setIsEditing(true);
    };
    const handleSave = (content, _index, additionalContext) => {
        onUpdateMessage(messageIndex, content, additionalContext);
        setIsEditing(false);
    };
    const handleCancel = () => {
        setIsEditing(false);
    };
    if (isLastMessage && (agentResponse === null || agentResponse === void 0 ? void 0 : agentResponse.type) === 'finished_task' &&
        agentResponse.next_steps &&
        agentResponse.next_steps.length > 0) {
        /*
        We only want to set the next steps if the message is the last message in the chat.
        This is because the next steps are only available after the agent has finished its task.

        We handle this in the ChatMessage component to automatically handle reloading a previous chat thread.
        */
        setNextSteps(agentResponse.next_steps);
    }
    if (isEditing) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ChatInput__WEBPACK_IMPORTED_MODULE_4__["default"], { app: app, initialContent: message.content.replace(/```[\s\S]*?```/g, '').trim(), onSave: handleSave, onCancel: handleCancel, isEditing: isEditing, contextManager: contextManager, notebookTracker: notebookTracker, agentModeEnabled: false }));
    }
    if (mitoAIConnectionError) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_5__.classNames)("message") },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_AlertBlock__WEBPACK_IMPORTED_MODULE_6__["default"], { content: message.content, mitoAIConnectionErrorType: mitoAIConnectionErrorType })));
    }
    // If the message is empty, don't render anything
    if (messageContent === undefined || messageContent === '') {
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null);
    }
    // While the code is streaming back we don't want to show the overwrite button. 
    // Users end up applying the code in the middle of streaming and it gets very confusing
    // very quickly for users. 
    let isCodeComplete = false;
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_5__.classNames)("message", { "message-user": message.role === 'user' }, { 'message-assistant-chat': message.role === 'assistant' }) },
        messageContentParts.map((messagePart, index) => {
            var _a, _b;
            if (messagePart.startsWith(_utils_strings__WEBPACK_IMPORTED_MODULE_3__.PYTHON_CODE_BLOCK_START_WITHOUT_NEW_LINE)) {
                isCodeComplete = messagePart.endsWith('```');
                // Make sure that there is actually code in the message. 
                // An empty code will look like this '```python  ```'
                if (messagePart.length > 14) {
                    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                        message.role === 'user' ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_UserCodeBlock__WEBPACK_IMPORTED_MODULE_7__["default"], { code: messagePart, renderMimeRegistry: renderMimeRegistry, agentModeEnabled: agentModeEnabled })) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_AssistantCodeBlock__WEBPACK_IMPORTED_MODULE_8__["default"], { code: messagePart, codeSummary: (_b = (_a = agentResponse === null || agentResponse === void 0 ? void 0 : agentResponse.cell_update) === null || _a === void 0 ? void 0 : _a.code_summary) !== null && _b !== void 0 ? _b : ((agentResponse === null || agentResponse === void 0 ? void 0 : agentResponse.type) === 'run_all_cells' ? 'Running all cells' : undefined), isCodeComplete: isCodeComplete, renderMimeRegistry: renderMimeRegistry, previewAICode: previewAICode, acceptAICode: acceptAICode, rejectAICode: rejectAICode, isLastAiMessage: isLastAiMessage, codeReviewStatus: codeReviewStatus, agentModeEnabled: agentModeEnabled })),
                        !agentModeEnabled && isLastAiMessage && isCodeComplete && codeReviewStatus === 'chatPreview' &&
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'chat-message-buttons' },
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_TextAndIconButton__WEBPACK_IMPORTED_MODULE_9__["default"], { onClick: () => { previewAICode(); }, text: 'Overwrite Active Cell', icon: _icons_PlayButtonIcon__WEBPACK_IMPORTED_MODULE_10__["default"], title: 'Write the Ai generated code to the active cell in the jupyter notebook, replacing the current code.', variant: 'gray', width: 'fit-contents' }),
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_TextAndIconButton__WEBPACK_IMPORTED_MODULE_9__["default"], { onClick: () => { void (0,_utils_copyToClipboard__WEBPACK_IMPORTED_MODULE_11__["default"])(messagePart); }, text: 'Copy', icon: _icons_CopyIcon__WEBPACK_IMPORTED_MODULE_12__["default"], title: 'Copy the Ai generated code to your clipboard', variant: 'gray', width: 'fit-contents' })),
                        !agentModeEnabled && isLastAiMessage && isCodeComplete && codeReviewStatus === 'codeCellPreview' &&
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'chat-message-buttons' },
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_TextButton__WEBPACK_IMPORTED_MODULE_13__["default"], { onClick: () => { acceptAICode(); }, text: `Accept code ${operatingSystem === 'mac' ? '⌘Y' : 'Ctrl+Y'}`, title: 'Accept the Ai generated code', variant: 'green', width: 'fit-contents' }),
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_TextButton__WEBPACK_IMPORTED_MODULE_13__["default"], { onClick: () => { rejectAICode(); }, text: `Reject code ${operatingSystem === 'mac' ? '⌘U' : 'Ctrl+U'}`, title: 'Reject the Ai generated code and revert to the previous version of the code cell', variant: 'red', width: 'fit-contents' })),
                        message.role === 'user' && additionalContext && additionalContext.length > 0 &&
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, additionalContext
                                .filter(context => context.type !== 'active_cell') // Hide active cell context in chat messages
                                .map((context, index) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_SelectedContextContainer__WEBPACK_IMPORTED_MODULE_14__["default"], { key: `${context.type}-${context.value}-${index}`, title: `${context.value}`, type: context.type, onRemove: () => { } }))))));
                }
                else {
                    // Return null for empty code blocks
                    return null;
                }
            }
            else {
                return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: index + messagePart, className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_5__.classNames)('markdown-message-part') },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { onDoubleClick: () => {
                            // Only allow users to edit their own messages, not the AI responses
                            if (message.role === 'user') {
                                setIsEditing(true);
                            }
                        } }, message.role === 'user' && promptType === 'smartDebug' ? (
                    /* Use a pre tag to preserve the newline and indentation of the error message */
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("pre", { className: "chat-taskpane-smart-debug-error-message" }, messagePart)) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MarkdownBlock__WEBPACK_IMPORTED_MODULE_15__["default"], { markdown: messagePart, renderMimeRegistry: renderMimeRegistry, notebookTracker: notebookTracker }))),
                    (agentResponse === null || agentResponse === void 0 ? void 0 : agentResponse.analysis_assumptions) &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_AgentComponents_AssumptionToolUI__WEBPACK_IMPORTED_MODULE_16__["default"], { assumptions: agentResponse.analysis_assumptions })));
            }
        }),
        editable &&
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "message-action-buttons" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "message-start-editing-button", onClick: handleEditClick, title: "Edit message" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_Pencil__WEBPACK_IMPORTED_MODULE_17__["default"], null))),
        (agentResponse === null || agentResponse === void 0 ? void 0 : agentResponse.type) === 'get_cell_output' &&
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_AgentComponents_GetCellOutputToolUI__WEBPACK_IMPORTED_MODULE_18__["default"], null),
        (agentResponse === null || agentResponse === void 0 ? void 0 : agentResponse.type) === 'run_all_cells' && agentModeEnabled &&
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_AgentComponents_RunAllCellsToolUI__WEBPACK_IMPORTED_MODULE_19__["default"], null)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChatMessage);


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatMessage/Citation.js":
/*!*******************************************************!*\
  !*** ./lib/Extensions/AiChat/ChatMessage/Citation.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Citation: () => (/* binding */ Citation),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_notebook__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../utils/notebook */ "./lib/utils/notebook.js");
/* harmony import */ var _style_Citation_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../style/Citation.css */ "./style/Citation.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */



// Helper function to get the display text for a line/range
const getLineDisplayText = (line) => {
    if (typeof line === 'number') {
        return `Line ${line}`;
    }
    else {
        return `Lines ${line.start}-${line.end}`;
    }
};
// Citation button component
const Citation = ({ citationIndex, cellId, line, notebookTracker }) => {
    const handleClick = () => {
        const lineStart = typeof line === 'number' ? line : line.start;
        // In order to support old citations that have just one line, we 
        // we set the end line to the start line if only a single line number is provided.
        const lineEnd = typeof line === 'number' ? line : line.end;
        // Scroll to the cell and highlight the lines
        (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_2__.scrollToAndHighlightCell)(notebookTracker.currentWidget, cellId, lineStart, lineEnd);
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "citation-button", onClick: handleClick, title: getLineDisplayText(line) }, citationIndex));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Citation);


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatMessage/CodeBlockToolbar.js":
/*!***************************************************************!*\
  !*** ./lib/Extensions/AiChat/ChatMessage/CodeBlockToolbar.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_copyToClipboard__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../utils/copyToClipboard */ "./lib/utils/copyToClipboard.js");
/* harmony import */ var _components_IconButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../components/IconButton */ "./lib/components/IconButton.js");
/* harmony import */ var _icons_CopyIcon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../icons/CopyIcon */ "./lib/icons/CopyIcon.js");
/* harmony import */ var _icons_PlayButtonIcon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../icons/PlayButtonIcon */ "./lib/icons/PlayButtonIcon.js");
/* harmony import */ var _icons_AcceptIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../icons/AcceptIcon */ "./lib/icons/AcceptIcon.js");
/* harmony import */ var _icons_RejectIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../icons/RejectIcon */ "./lib/icons/RejectIcon.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */







const CodeBlockToolbar = ({ code, isLastAiMessage = false, codeReviewStatus, onPreview, onAccept, onReject }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'code-block-toolbar' },
        isLastAiMessage && codeReviewStatus === 'chatPreview' && onPreview && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_IconButton__WEBPACK_IMPORTED_MODULE_1__["default"], { icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_PlayButtonIcon__WEBPACK_IMPORTED_MODULE_2__["default"], null), title: "Overwrite Active Cell", onClick: onPreview })),
        isLastAiMessage && codeReviewStatus === 'codeCellPreview' && onAccept && onReject && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_IconButton__WEBPACK_IMPORTED_MODULE_1__["default"], { icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_AcceptIcon__WEBPACK_IMPORTED_MODULE_3__["default"], null), title: "Accept AI Generated Code", onClick: onAccept, style: { color: 'var(--green-700)' } }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_IconButton__WEBPACK_IMPORTED_MODULE_1__["default"], { icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_RejectIcon__WEBPACK_IMPORTED_MODULE_4__["default"], null), title: "Reject AI Generated Code", onClick: onReject, style: { color: 'var(--red-700)' } }))),
        (!isLastAiMessage || codeReviewStatus !== 'codeCellPreview') && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_IconButton__WEBPACK_IMPORTED_MODULE_1__["default"], { icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_CopyIcon__WEBPACK_IMPORTED_MODULE_5__["default"], null), title: "Copy", onClick: () => { void (0,_utils_copyToClipboard__WEBPACK_IMPORTED_MODULE_6__["default"])(code); } }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CodeBlockToolbar);


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatMessage/MarkdownBlock.js":
/*!************************************************************!*\
  !*** ./lib/Extensions/AiChat/ChatMessage/MarkdownBlock.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/rendermime */ "webpack/sharing/consume/default/@jupyterlab/rendermime");
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-dom */ "webpack/sharing/consume/default/react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Citation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Citation */ "./lib/Extensions/AiChat/ChatMessage/Citation.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const CitationPortal = ({ container, ...props }) => {
    return (0,react_dom__WEBPACK_IMPORTED_MODULE_2__.createPortal)(react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Citation__WEBPACK_IMPORTED_MODULE_3__.Citation, { ...props }), container);
};
const MarkdownBlock = ({ markdown, renderMimeRegistry, notebookTracker }) => {
    const [citationPortals, setCitationPortals] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    const containerRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    // Helper function to parse line numbers or ranges
    const parseLineNumber = (lineStr) => {
        if (lineStr.includes('-')) {
            // Handle range format like "18-41"
            const parts = lineStr.split('-');
            const startStr = parts[0];
            const endStr = parts[1];
            if (!startStr || !endStr) {
                // Fallback to single line if split fails
                return parseInt(lineStr, 10);
            }
            const start = parseInt(startStr, 10);
            const end = parseInt(endStr, 10);
            if (isNaN(start) || isNaN(end)) {
                // Fallback to single line if parsing fails
                return parseInt(lineStr, 10);
            }
            return { start, end };
        }
        else {
            // Handle single line number
            return parseInt(lineStr, 10);
        }
    };
    // Extract citations from the markdown, returning the markdown with the JSON citations replaced with 
    // citation placeholders {{${id}}} and an array of citation objects.
    const extractCitations = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((text) => {
        // Updated regex to match both single lines and line ranges: [MITO_CITATION:cell_id:line_number] or [MITO_CITATION:cell_id:start_line-end_line]
        const citationRegex = /\[MITO_CITATION:([^:]+):(\d+(?:-\d+)?)\]/g;
        const citations = [];
        let counter = 0;
        // Replace each citation with a placeholder
        const processedMarkdown = text.replace(citationRegex, (match, cellId, lineStr) => {
            try {
                const id = `citation-${counter++}`;
                const line = parseLineNumber(lineStr);
                citations.push({
                    id,
                    data: {
                        citation_index: counter,
                        cell_id: cellId,
                        line: line
                    }
                });
                return `{{${id}}}`;
            }
            catch (e) {
                console.error("Failed to parse citation:", e);
                return match;
            }
        });
        return { processedMarkdown, citations };
    }, []);
    // Uses the Jupyter markdowm MimeRenderer to render the markdown content as normal HTML
    const renderMarkdownContent = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async (processedMarkdown) => {
        if (!processedMarkdown || !containerRef.current)
            return;
        try {
            const model = new _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__.MimeModel({
                data: { ['text/markdown']: processedMarkdown },
            });
            const renderer = renderMimeRegistry.createRenderer('text/markdown');
            await renderer.renderModel(model);
            // Clear previous content
            containerRef.current.innerHTML = '';
            containerRef.current.appendChild(renderer.node.cloneNode(true));
        }
        catch (error) {
            console.error("Error rendering markdown:", error);
        }
    }, [renderMimeRegistry]);
    // Replace the citation placeholders with Citation Components in the DOM
    const createCitationPortals = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((citations) => {
        if (!containerRef.current || citations.length === 0)
            return [];
        const newPortals = [];
        // Create a map of placeholder to citation for faster lookup
        const citationMap = new Map(citations.map(citation => [`{{${citation.id}}}`, citation]));
        // Find all text nodes that contain our placeholder like {{citation-id}}).
        // Since these placeholders exist within the text content (not as separate DOM elements):
        //  - Find all text nodes in the rendered markdown
        //  - Check each one to see if it contains any of your placeholders
        //  - Process those that do contain placeholders
        const textNodes = [];
        const walker = document.createTreeWalker(containerRef.current, NodeFilter.SHOW_TEXT);
        let textNode;
        while ((textNode = walker.nextNode())) {
            textNodes.push(textNode);
        }
        // Process all text nodes in a single pass
        textNodes.forEach(node => {
            if (!node.nodeValue)
                return;
            // Check if this node contains any placeholders
            let containsPlaceholder = false;
            for (const placeholder of citationMap.keys()) {
                if (node.nodeValue.includes(placeholder)) {
                    containsPlaceholder = true;
                    break;
                }
            }
            if (!containsPlaceholder)
                return;
            // Create a regex to match all placeholders
            const placeholderPattern = /\{\{citation-\d+\}\}/g;
            const matches = [...node.nodeValue.matchAll(placeholderPattern)];
            if (matches.length === 0)
                return;
            // Split the text by all placeholders and create a fragment
            const fragment = document.createDocumentFragment();
            let lastIndex = 0;
            matches.forEach(match => {
                const placeholder = match[0];
                const citation = citationMap.get(placeholder);
                if (!citation)
                    return;
                const startIndex = match.index;
                // Add text before the placeholder
                if (startIndex > lastIndex) {
                    fragment.appendChild(document.createTextNode(node.nodeValue.substring(lastIndex, startIndex)));
                }
                // Create span for the citation
                const span = document.createElement('span');
                span.classList.add('citation-container');
                span.dataset.citationId = citation.id;
                fragment.appendChild(span);
                // Create React portal for this span
                newPortals.push(react__WEBPACK_IMPORTED_MODULE_0___default().createElement(CitationPortal, { key: citation.id + '-' + matches.indexOf(match), container: span, citationIndex: citation.data.citation_index, cellId: citation.data.cell_id, line: citation.data.line, notebookTracker: notebookTracker }));
                lastIndex = startIndex + placeholder.length;
            });
            // Add any remaining text after the last placeholder
            if (lastIndex < node.nodeValue.length) {
                fragment.appendChild(document.createTextNode(node.nodeValue.substring(lastIndex)));
            }
            // Replace the original text node with our fragment
            if (node.parentNode) {
                node.parentNode.replaceChild(fragment, node);
            }
        });
        return newPortals;
    }, []);
    // Process everything in one effect, but with clear separation via helper functions
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const processMarkdown = async () => {
            // Step 1: Extract citations and get processed markdown
            const { processedMarkdown, citations } = extractCitations(markdown);
            // Step 2: Render markdown with placeholders
            await renderMarkdownContent(processedMarkdown);
            // Step 3: Create and insert citation portals
            const portals = createCitationPortals(citations);
            setCitationPortals(portals);
        };
        void processMarkdown();
    }, [markdown, extractCitations, renderMarkdownContent, createCitationPortals]);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { ref: containerRef, className: "markdown-block-with-citations" }, citationPortals));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MarkdownBlock);


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatMessage/PythonCode.js":
/*!*********************************************************!*\
  !*** ./lib/Extensions/AiChat/ChatMessage/PythonCode.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/rendermime */ "webpack/sharing/consume/default/@jupyterlab/rendermime");
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_strings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/strings */ "./lib/utils/strings.js");
/* harmony import */ var _style_PythonCode_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../style/PythonCode.css */ "./style/PythonCode.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const PythonCode = ({ code, renderMimeRegistry }) => {
    const containerRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    const rendererRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const container = containerRef.current;
        if (!container)
            return;
        // Create renderer only once
        if (!rendererRef.current) {
            rendererRef.current = renderMimeRegistry.createRenderer('text/markdown');
        }
        const model = new _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__.MimeModel({
            data: { ['text/markdown']: (0,_utils_strings__WEBPACK_IMPORTED_MODULE_3__.addMarkdownCodeFormatting)(code, true) },
        });
        const renderCode = async () => {
            await rendererRef.current.renderModel(model);
            // Clear previous content
            while (container.firstChild) {
                container.removeChild(container.firstChild);
            }
            // Append new content
            container.appendChild(rendererRef.current.node);
        };
        void renderCode();
        // Clean up function
        return () => {
            var _a;
            if (((_a = rendererRef.current) === null || _a === void 0 ? void 0 : _a.node) && rendererRef.current.node.parentNode) {
                rendererRef.current.node.parentNode.removeChild(rendererRef.current.node);
            }
        };
    }, [code, renderMimeRegistry]);
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'code-block-python-code', ref: containerRef });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PythonCode);


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatMessage/RevertQuestionnaire.js":
/*!******************************************************************!*\
  !*** ./lib/Extensions/AiChat/ChatMessage/RevertQuestionnaire.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_TextButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../components/TextButton */ "./lib/components/TextButton.js");
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/* harmony import */ var _style_RevertQuestionnaire_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../style/RevertQuestionnaire.css */ "./style/RevertQuestionnaire.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const RevertQuestionnaire = ({ onDestroy, getDuplicateChatHistoryManager, setChatHistoryManager }) => {
    const CHOICES = [
        'AI misunderstood me',
        'Code was buggy/incorrect',
        'Code was low quality',
        'I changed my mind about what I wanted'
    ];
    const handleButtonClick = (choice) => {
        // Log the event
        void (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_2__.logEvent)('mito_ai_revert_questionnaire_choice', { 'reason': choice });
        // Add a message to the chat history
        const newChatHistoryManager = getDuplicateChatHistoryManager();
        newChatHistoryManager.addAIMessageFromResponse("I've reverted all previous changes.", "chat", false);
        setChatHistoryManager(newChatHistoryManager);
        // Destroy the component (set showRevertQuestionnaire to false)
        onDestroy();
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'message revert-questionnaire-message' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'revert-questionnaire-message-text' }, "What went wrong?"),
        CHOICES.map((choice) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_TextButton__WEBPACK_IMPORTED_MODULE_3__["default"], { text: choice, onClick: () => handleButtonClick(choice), title: choice, variant: 'gray', width: 'block', textAlign: 'left', className: "revert-questionnaire-button" }))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RevertQuestionnaire);


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatMessage/ScrollableSuggestions.js":
/*!********************************************************************!*\
  !*** ./lib/Extensions/AiChat/ChatMessage/ScrollableSuggestions.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_scrollMask__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../utils/scrollMask */ "./lib/utils/scrollMask.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


const DEFAULT_SUGGESTION_OPTIONS = [
    {
        display: "Plot Meta Acquisitions",
        prompt: "Build an annotated graph of how Meta's acquisitions of Instagram, Whatsapp, and Giphy affected the Meta stock price. Use the data from https://raw.githubusercontent.com/mito-ds/mito/refs/heads/dev/jupyterhub/meta_stock_prices.csv"
    },
    {
        display: "Analyze Vehicle Fatalities",
        prompt: "Visualize which vehicle types are most deadly to pedestrians and cyclists, measuring total fatalities and fatality rate per collision. Use the data from https://raw.githubusercontent.com/mito-ds/mito/refs/heads/dev/jupyterhub/nyc_car_crashes.csv"
    },
    {
        display: "Compare Trade Surpluses",
        prompt: "Graph the countries that have the highest trade surplus with America. Use the data from https://raw.githubusercontent.com/mito-ds/mito/refs/heads/dev/jupyterhub/us_tarrifs.csv"
    }
];
const ScrollableSuggestions = ({ onSelectSuggestion, }) => {
    const suggestionsRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    // Apply the scroll mask to the suggestions container when it mounts, updates, or is scrolled
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const suggestionsContainer = suggestionsRef.current;
        if (!suggestionsContainer)
            return;
        // Initialize the mask with a delay to ensure content is rendered
        (0,_utils_scrollMask__WEBPACK_IMPORTED_MODULE_1__.initScrollMask)(suggestionsContainer);
        // Update mask on scroll
        const handleScroll = () => {
            (0,_utils_scrollMask__WEBPACK_IMPORTED_MODULE_1__.updateScrollMask)(suggestionsContainer);
        };
        // Update mask on window resize
        const handleResize = () => {
            (0,_utils_scrollMask__WEBPACK_IMPORTED_MODULE_1__.updateScrollMask)(suggestionsContainer);
        };
        // Create a ResizeObserver to monitor changes to the container's parent
        const resizeObserver = new ResizeObserver(() => {
            (0,_utils_scrollMask__WEBPACK_IMPORTED_MODULE_1__.updateScrollMask)(suggestionsContainer);
        });
        // Observe the parent container that has the max-width constraint
        const parentContainer = suggestionsContainer.closest('.suggestions-container');
        if (parentContainer) {
            resizeObserver.observe(parentContainer);
        }
        suggestionsContainer.addEventListener('scroll', handleScroll);
        window.addEventListener('resize', handleResize);
        // Clean up the event listeners and observers on unmount
        return () => {
            suggestionsContainer.removeEventListener('scroll', handleScroll);
            window.removeEventListener('resize', handleResize);
            resizeObserver.disconnect();
        };
    }, [DEFAULT_SUGGESTION_OPTIONS.length]); // Re-apply when options change
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "chat-suggestions", ref: suggestionsRef }, DEFAULT_SUGGESTION_OPTIONS.map((opt) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { key: opt.display, className: "suggestion-box", onClick: () => onSelectSuggestion(opt.prompt) }, opt.display)))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ScrollableSuggestions);


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatMessage/UserCodeBlock.js":
/*!************************************************************!*\
  !*** ./lib/Extensions/AiChat/ChatMessage/UserCodeBlock.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _PythonCode__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./PythonCode */ "./lib/Extensions/AiChat/ChatMessage/PythonCode.js");
/* harmony import */ var _style_CodeBlock_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../style/CodeBlock.css */ "./style/CodeBlock.css");
/* harmony import */ var _icons_ExpandIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../icons/ExpandIcon */ "./lib/icons/ExpandIcon.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const UserCodeBlock = ({ code, renderMimeRegistry, agentModeEnabled }) => {
    const [isExpanded, setIsExpanded] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const numCodePreviewLines = 5;
    const isCodeExpandable = code.split('\n').length > numCodePreviewLines;
    const previewCode = code.split('\n').slice(0, numCodePreviewLines).join('\n');
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `code-block-container active-cell-code-block ${agentModeEnabled ? 'agent-mode' : ''}`, onClick: () => setIsExpanded(!isExpanded), style: { cursor: 'pointer' } },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_PythonCode__WEBPACK_IMPORTED_MODULE_2__["default"], { code: isExpanded ? code : previewCode, renderMimeRegistry: renderMimeRegistry }),
        isCodeExpandable && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'code-block-expand-button', title: isExpanded ? "Collapse" : "Expand", onClick: (e) => {
                e.stopPropagation();
                setIsExpanded(!isExpanded);
            } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_ExpandIcon__WEBPACK_IMPORTED_MODULE_3__["default"], { isExpanded: isExpanded })))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserCodeBlock);


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatTaskpane.js":
/*!***********************************************!*\
  !*** ./lib/Extensions/AiChat/ChatTaskpane.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _codemirror_state__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @codemirror/state */ "webpack/sharing/consume/default/@codemirror/state");
/* harmony import */ var _codemirror_state__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_codemirror_state__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _commands__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../commands */ "./lib/commands.js");
/* harmony import */ var _components_AgentComponents_ErrorFixupToolUI__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ../../components/AgentComponents/ErrorFixupToolUI */ "./lib/components/AgentComponents/ErrorFixupToolUI.js");
/* harmony import */ var _components_DropdownMenu__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../../components/DropdownMenu */ "./lib/components/DropdownMenu.js");
/* harmony import */ var _components_IconButton__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../../components/IconButton */ "./lib/components/IconButton.js");
/* harmony import */ var _components_LoadingCircle__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ../../components/LoadingCircle */ "./lib/components/LoadingCircle.js");
/* harmony import */ var _components_ModelSelector__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../components/ModelSelector */ "./lib/components/ModelSelector.js");
/* harmony import */ var _components_NextStepsPills__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ../../components/NextStepsPills */ "./lib/components/NextStepsPills.js");
/* harmony import */ var _components_TextAndIconButton__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ../../components/TextAndIconButton */ "./lib/components/TextAndIconButton.js");
/* harmony import */ var _components_ToggleButton__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ../../components/ToggleButton */ "./lib/components/ToggleButton.js");
/* harmony import */ var _icons__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../../icons */ "./lib/icons/index.js");
/* harmony import */ var _icons_UndoIcon__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ../../icons/UndoIcon */ "./lib/icons/UndoIcon.js");
/* harmony import */ var _utils_agentActions__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../utils/agentActions */ "./lib/utils/agentActions.js");
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../utils/classNames */ "./lib/utils/classNames.js");
/* harmony import */ var _utils_blacklistedWords__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../utils/blacklistedWords */ "./lib/utils/blacklistedWords.js");
/* harmony import */ var _utils_checkpoint__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../utils/checkpoint */ "./lib/utils/checkpoint.js");
/* harmony import */ var _utils_chatHistory__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../../utils/chatHistory */ "./lib/utils/chatHistory.js");
/* harmony import */ var _utils_codeDiff__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../utils/codeDiff */ "./lib/utils/codeDiff.js");
/* harmony import */ var _utils_notebook__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../utils/notebook */ "./lib/utils/notebook.js");
/* harmony import */ var _utils_cellOutput__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../utils/cellOutput */ "./lib/utils/cellOutput.js");
/* harmony import */ var _utils_scroll__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../utils/scroll */ "./lib/utils/scroll.js");
/* harmony import */ var _utils_strings__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../utils/strings */ "./lib/utils/strings.js");
/* harmony import */ var _utils_waitForNotebookReady__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../utils/waitForNotebookReady */ "./lib/utils/waitForNotebookReady.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./utils */ "./lib/Extensions/AiChat/utils.js");
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/* harmony import */ var _utils_userSignupState__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../utils/userSignupState */ "./lib/utils/userSignupState.js");
/* harmony import */ var _SettingsManager_SettingsManagerPlugin__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../SettingsManager/SettingsManagerPlugin */ "./lib/Extensions/SettingsManager/SettingsManagerPlugin.js");
/* harmony import */ var _SettingsManager_profiler_ProfilerPage__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../SettingsManager/profiler/ProfilerPage */ "./lib/Extensions/SettingsManager/profiler/ProfilerPage.js");
/* harmony import */ var _CTACarousel__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./CTACarousel */ "./lib/Extensions/AiChat/CTACarousel.js");
/* harmony import */ var _SignUpForm__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./SignUpForm */ "./lib/Extensions/AiChat/SignUpForm.js");
/* harmony import */ var _CodeDiffDisplay__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./CodeDiffDisplay */ "./lib/Extensions/AiChat/CodeDiffDisplay.js");
/* harmony import */ var _FirstMessage__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./FirstMessage */ "./lib/Extensions/AiChat/FirstMessage.js");
/* harmony import */ var _ChatMessage_ChatInput__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./ChatMessage/ChatInput */ "./lib/Extensions/AiChat/ChatMessage/ChatInput.js");
/* harmony import */ var _ChatMessage_ChatMessage__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./ChatMessage/ChatMessage */ "./lib/Extensions/AiChat/ChatMessage/ChatMessage.js");
/* harmony import */ var _ChatMessage_RevertQuestionnaire__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./ChatMessage/RevertQuestionnaire */ "./lib/Extensions/AiChat/ChatMessage/RevertQuestionnaire.js");
/* harmony import */ var _ChatMessage_ScrollableSuggestions__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./ChatMessage/ScrollableSuggestions */ "./lib/Extensions/AiChat/ChatMessage/ScrollableSuggestions.js");
/* harmony import */ var _ChatHistoryManager__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ChatHistoryManager */ "./lib/Extensions/AiChat/ChatHistoryManager.js");
/* harmony import */ var _style_button_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../style/button.css */ "./style/button.css");
/* harmony import */ var _style_ChatTaskpane_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../style/ChatTaskpane.css */ "./style/ChatTaskpane.css");
/* harmony import */ var _style_TextButton_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../style/TextButton.css */ "./style/TextButton.css");
/* harmony import */ var _components_LoadingDots__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ../../components/LoadingDots */ "./lib/components/LoadingDots.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
// External libraries




// Internal imports - Commands

// Internal imports - Components









// Internal imports - Icons


// Internal imports - Utils
















// Internal imports - Chat components









// Styles




const AGENT_EXECUTION_DEPTH_LIMIT = 20;
const getDefaultChatHistoryManager = (notebookTracker, contextManager) => {
    const chatHistoryManager = new _ChatHistoryManager__WEBPACK_IMPORTED_MODULE_7__.ChatHistoryManager(contextManager, notebookTracker);
    return chatHistoryManager;
};
const ChatTaskpane = ({ notebookTracker, renderMimeRegistry, contextManager, app, operatingSystem, websocketClient, }) => {
    const [isSignedUp, setIsSignedUp] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(true);
    const [chatHistoryManager, setChatHistoryManager] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(() => getDefaultChatHistoryManager(notebookTracker, contextManager));
    const chatHistoryManagerRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(chatHistoryManager);
    const [loadingAIResponse, setLoadingAIResponse] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    // Store the original cell before diff so that we can revert to it if the user rejects the AI's code
    const cellStateBeforeDiff = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(undefined);
    // Three possible states:
    // 1. chatPreview: state where the user has not yet pressed the apply button.
    // 2. codeCellPreview: state where the user is seeing the code diffs and deciding how they want to respond.
    // 3. applied: state where the user has applied the code to the code cell
    const [codeReviewStatus, setCodeReviewStatus] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)('chatPreview');
    // Add this ref for the chat messages container
    const chatMessagesRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    /*
        Keep track of agent mode enabled state and use keep a ref in sync with it
        so that we can access the most up-to-date value during a function's execution.
        Without it, we would always use the initial value of agentModeEnabled.
    */
    const [agentModeEnabled, setAgentModeEnabled] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(true);
    const agentModeEnabledRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(agentModeEnabled);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        // Update the ref whenever agentModeEnabled state changes
        agentModeEnabledRef.current = agentModeEnabled;
    }, [agentModeEnabled]);
    /*
        Auto-scroll follow mode: tracks whether we should automatically scroll to bottom
        when new messages arrive. Set to false when user manually scrolls up.
    */
    const [autoScrollFollowMode, setAutoScrollFollowMode] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(true);
    const autoScrollFollowModeRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(autoScrollFollowMode);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        autoScrollFollowModeRef.current = autoScrollFollowMode;
    }, [autoScrollFollowMode]);
    const [chatThreads, setChatThreads] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
    // The active thread id is originally set by the initializeChatHistory function, which will either set it to 
    // the last active thread or create a new thread if there are no previously existing threads. So that
    // we don't need to handle the undefined case everywhere, we just default to an empty string knowing that
    // it will always be set to a valid thread id before it is used.
    const activeThreadIdRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)('');
    /*
        Three possible states:
        1. working: the agent is working on the task
        2. stopping: the agent is stopping after it has received ai response it is waiting on
        3. idle: the agent is idle
    */
    const [agentExecutionStatus, setAgentExecutionStatus] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)('idle');
    const agentTargetNotebookPanelRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    // We use a ref to always access the most up-to-date value during a function's execution. Refs immediately reflect changes, 
    // unlike state variables, which are captured at the beginning of a function and may not reflect updates made during execution.
    const shouldContinueAgentExecution = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(true);
    const streamingContentRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)('');
    const streamHandlerRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    // Track active requests for cancellation
    const activeRequestControllerRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    // State for managing next steps from responses
    // If the user hides the next steps, we keep them hidden until they re-open them
    const [nextSteps, setNextSteps] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
    const [displayedNextStepsIfAvailable, setDisplayedNextStepsIfAvailable] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(true);
    // Track if checkpoint exists for UI updates
    const [hasCheckpoint, setHasCheckpoint] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    // Track if revert questionnaire should be shown
    const [showRevertQuestionnaire, setShowRevertQuestionnaire] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const updateModelOnBackend = async (model) => {
        try {
            await websocketClient.sendMessage({
                type: "update_model_config",
                message_id: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.UUID.uuid4(),
                metadata: {
                    promptType: "update_model_config",
                    model: model
                },
                stream: false
            });
            console.log('Model configuration updated on backend:', model);
        }
        catch (error) {
            console.error('Failed to update model configuration on backend:', error);
        }
    };
    const fetchChatThreads = async () => {
        const metadata = {
            promptType: "get_threads"
        };
        const chatThreadsResponse = await websocketClient.sendMessage({
            type: "get_threads",
            message_id: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.UUID.uuid4(),
            metadata: metadata,
            stream: false
        });
        setChatThreads(chatThreadsResponse.threads);
    };
    const fetchChatHistoryAndSetActiveThread = async (threadId) => {
        const metadata = {
            promptType: "fetch_history",
            thread_id: threadId
        };
        const fetchHistoryCompletionRequest = {
            type: 'fetch_history',
            message_id: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.UUID.uuid4(),
            metadata: metadata,
            stream: false
        };
        const chatHistoryResponse = await websocketClient.sendMessage(fetchHistoryCompletionRequest);
        // Create a fresh ChatHistoryManager and add the initial messages
        const newChatHistoryManager = getDefaultChatHistoryManager(notebookTracker, contextManager);
        // Each thread only contains agent or chat messages. For now, we enforce this by clearing the chat 
        // when the user switches mode. When the user reloads a chat, we want to put them back into the same
        // chat mode so that we use the correct system message and preserve this one-type of message invariant.
        let isAgentChat = false;
        // Add messages to the ChatHistoryManager
        chatHistoryResponse.items.forEach(item => {
            try {
                // If the user sent a message in agent:execution mode, the ai response will be a JSON object which we need to parse. 
                // TODO: We need to save the full metadata in the message_history.json so we don't have to do these hacky workarounds!
                const chatHistoryItem = JSON.parse(item.content);
                if (Object.prototype.hasOwnProperty.call(chatHistoryItem, 'type')) {
                    // If it is a structured output with 'type', then it is an AgentResponse and we should handle it as such
                    const agentResponse = chatHistoryItem;
                    newChatHistoryManager.addAIMessageFromAgentResponse(agentResponse);
                    isAgentChat = true;
                }
                else {
                    newChatHistoryManager.addChatMessageFromHistory(item);
                    isAgentChat = false;
                }
            }
            catch (_a) {
                newChatHistoryManager.addChatMessageFromHistory(item);
            }
        });
        // Update the state with the new ChatHistoryManager
        setAgentModeEnabled(isAgentChat);
        setChatHistoryManager(newChatHistoryManager);
        activeThreadIdRef.current = threadId;
    };
    const deleteThread = async (threadId) => {
        const metadata = {
            promptType: "delete_thread",
            thread_id: threadId
        };
        const response = await websocketClient.sendMessage({
            type: "delete_thread",
            message_id: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.UUID.uuid4(),
            metadata: metadata,
            stream: false
        });
        if (response.success) {
            const updatedThreads = chatThreads.filter(thread => thread.thread_id !== threadId);
            setChatThreads(updatedThreads);
            if (activeThreadIdRef.current === threadId) {
                if (updatedThreads.length > 0) {
                    const latestThread = updatedThreads[0];
                    await fetchChatHistoryAndSetActiveThread(latestThread.thread_id);
                }
                else {
                    await startNewChat();
                }
            }
        }
    };
    const startNewChat = async () => {
        // If current thread is empty and we already have an active thread id, do not create a new thread.
        if (chatHistoryManagerRef.current.getDisplayOptimizedHistory().length === 0 && activeThreadIdRef.current !== '') {
            return chatHistoryManager;
        }
        // Clear next steps when starting a new chat
        setNextSteps([]);
        // Get rid of the revert questionaire if its open
        setShowRevertQuestionnaire(false);
        // Clear agent checkpoint when starting new chat
        setHasCheckpoint(false);
        // Enable follow mode when starting a new chat
        setAutoScrollFollowMode(true);
        // Reset frontend chat history
        const newChatHistoryManager = getDefaultChatHistoryManager(notebookTracker, contextManager);
        setChatHistoryManager(newChatHistoryManager);
        // Notify the backend to request a new chat thread and get its ID
        try {
            const response = await websocketClient.sendMessage({
                type: 'start_new_chat',
                message_id: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.UUID.uuid4(),
                metadata: {
                    promptType: 'start_new_chat'
                },
                stream: false,
            });
            // Set the new thread ID as active
            activeThreadIdRef.current = response.thread_id;
        }
        catch (error) {
            console.error('Error starting new chat:', error);
        }
        return newChatHistoryManager;
    };
    // Main initialization effect - runs once on mount
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        const initializeChatHistory = async () => {
            try {
                // Check for saved model preference in localStorage
                const storedConfig = localStorage.getItem('llmModelConfig');
                let initialModel = _components_ModelSelector__WEBPACK_IMPORTED_MODULE_8__.DEFAULT_MODEL;
                if (storedConfig) {
                    try {
                        const parsedConfig = JSON.parse(storedConfig);
                        initialModel = parsedConfig.model || _components_ModelSelector__WEBPACK_IMPORTED_MODULE_8__.DEFAULT_MODEL;
                    }
                    catch (e) {
                        console.error('Failed to parse stored LLM config', e);
                    }
                }
                // Set the model on backend when the taskpane is opened
                void updateModelOnBackend(initialModel);
                // 1. Fetch available chat threads.
                const chatThreadsResponse = await websocketClient.sendMessage({
                    type: "get_threads",
                    message_id: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.UUID.uuid4(),
                    metadata: {
                        promptType: "get_threads"
                    },
                    stream: false
                });
                setChatThreads(chatThreadsResponse.threads);
                // 2. If threads exist, load the latest thread; otherwise, start a new chat.
                if (chatThreadsResponse.threads.length > 0) {
                    const latestThread = chatThreadsResponse.threads[0];
                    await fetchChatHistoryAndSetActiveThread(latestThread.thread_id);
                }
                else {
                    await startNewChat();
                }
                const firstMessage = (0,_FirstMessage__WEBPACK_IMPORTED_MODULE_9__.getFirstMessageFromCookie)();
                if (firstMessage) {
                    await (0,_utils_waitForNotebookReady__WEBPACK_IMPORTED_MODULE_10__.waitForNotebookReady)(notebookTracker);
                    await startAgentExecution(firstMessage);
                }
            }
            catch (error) {
                const newChatHistoryManager = getDefaultChatHistoryManager(notebookTracker, contextManager);
                addAIMessageFromResponseAndUpdateState(error.title ? error.title : `${error}`, 'chat', newChatHistoryManager, false);
                addAIMessageFromResponseAndUpdateState(error.hint ? error.hint : `${error}`, 'chat', newChatHistoryManager, true);
            }
        };
        void (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_11__.logEvent)('opened_ai_chat_taskpane');
        void initializeChatHistory();
        void refreshUserSignupState(); // Get user signup state when the component first mounts
    }, [websocketClient]);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        /*
            Why we use a ref (chatHistoryManagerRef) instead of directly accessing the state (chatHistoryManager):

            The reason we use a ref here is because the function `applyLatestCode` is registered once
            when the component mounts via `app.commands.addCommand`. If we directly used `chatHistoryManager`
            in the command's execute function, it would "freeze" the state at the time of the registration
            and wouldn't update as the state changes over time.

            React's state (`useState`) is asynchronous, and the registered command won't automatically pick up the
            updated state unless the command is re-registered every time the state changes, which would require
            unregistering and re-registering the command, causing unnecessary complexity.

            By using a ref (`chatHistoryManagerRef`), we are able to keep a persistent reference to the
            latest version of `chatHistoryManager`, which is updated in this effect whenever the state
            changes. This allows us to always access the most recent state of `chatHistoryManager` in the
            `applyLatestCode` function, without needing to re-register the command or cause unnecessary re-renders.

            We still use `useState` for `chatHistoryManager` so that we can trigger a re-render of the chat
            when the state changes.
        */
        chatHistoryManagerRef.current = chatHistoryManager;
    }, [chatHistoryManager]);
    // Function to refresh user signup state using the shared helper
    const refreshUserSignupState = async () => {
        const signupState = await (0,_utils_userSignupState__WEBPACK_IMPORTED_MODULE_12__.checkUserSignupState)();
        setIsSignedUp(signupState.isSignedUp);
    };
    // Scroll to bottom whenever chat history updates, but only if in follow mode
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        if (autoScrollFollowMode) {
            (0,_utils_scroll__WEBPACK_IMPORTED_MODULE_13__.scrollToDiv)(chatMessagesRef);
        }
    }, [chatHistoryManager.getDisplayOptimizedHistory().length, chatHistoryManager, autoScrollFollowMode]);
    // Add scroll event handler to detect manual scrolling
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        const chatContainer = chatMessagesRef.current;
        if (!chatContainer)
            return;
        const handleScroll = () => {
            const { scrollTop, scrollHeight, clientHeight } = chatContainer;
            const isAtBottom = scrollTop + clientHeight >= scrollHeight - 10; // 10px threshold
            // If user is not at bottom and we're in follow mode, break out of follow mode
            if (!isAtBottom && autoScrollFollowModeRef.current) {
                setAutoScrollFollowMode(false);
            }
            // If user scrolls back to bottom, re-enter follow mode
            else if (isAtBottom && !autoScrollFollowModeRef.current) {
                setAutoScrollFollowMode(true);
            }
        };
        chatContainer.addEventListener('scroll', handleScroll);
        return () => chatContainer.removeEventListener('scroll', handleScroll);
    }, []);
    const getDuplicateChatHistoryManager = () => {
        /*
            We use getDuplicateChatHistoryManager() instead of directly accessing the state variable because
            the COMMAND_MITO_AI_SEND_MESSAGE is registered in a useEffect on initial render, which
            would otherwise always use the initial state values. By using a function, we ensure we always
            get the most recent chat history, even when the command is executed later.
        */
        return chatHistoryManagerRef.current.createDuplicateChatHistoryManager();
    };
    /*
        Send a message with a specific input, clearing what is currently in the chat input.
        This is useful when we want to send the error message from the MIME renderer directly
        to the AI chat.
    */
    const sendSmartDebugMessage = async (errorMessage) => {
        // Check if user is in agent mode and switch to chat mode if needed
        if (agentModeEnabledRef.current) {
            await startNewChat();
            setAgentModeEnabled(false);
            // Clear agent checkpoint when switching modes
            setHasCheckpoint(false);
        }
        // Step 0: reset the state for a new message
        resetForNewMessage();
        // Enable follow mode when sending a debug message
        setAutoScrollFollowMode(true);
        // Step 1: Add the smart debug message to the chat history
        const newChatHistoryManager = getDuplicateChatHistoryManager();
        const smartDebugMetadata = newChatHistoryManager.addSmartDebugMessage(activeThreadIdRef.current, errorMessage);
        setChatHistoryManager(newChatHistoryManager);
        setLoadingAIResponse(true);
        // Step 2: Send the message to the AI
        const smartDebugCompletionRequest = {
            type: 'smartDebug',
            message_id: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.UUID.uuid4(),
            metadata: smartDebugMetadata,
            stream: true
        };
        await _sendMessageAndSaveResponse(smartDebugCompletionRequest, newChatHistoryManager);
    };
    const sendAgentSmartDebugMessage = async (errorMessage) => {
        if (agentTargetNotebookPanelRef.current === null) {
            return;
        }
        // Step 0: reset the state for a new message
        resetForNewMessage();
        // Enable follow mode when sending agent debug message (same behavior as other modes)
        setAutoScrollFollowMode(true);
        // Step 1: Create message metadata
        const newChatHistoryManager = getDuplicateChatHistoryManager();
        const agentSmartDebugMessage = newChatHistoryManager.addAgentSmartDebugMessage(activeThreadIdRef.current, errorMessage, agentTargetNotebookPanelRef.current);
        setChatHistoryManager(newChatHistoryManager);
        setLoadingAIResponse(true);
        // Step 2: Send the message to the AI
        const smartDebugCompletionRequest = {
            type: 'agent:autoErrorFixup',
            message_id: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.UUID.uuid4(),
            metadata: agentSmartDebugMessage,
            stream: false
        };
        await _sendMessageAndSaveResponse(smartDebugCompletionRequest, newChatHistoryManager);
    };
    const sendExplainCodeMessage = async () => {
        // Step 0: reset the state for a new message
        resetForNewMessage();
        // Enable follow mode when explaining code
        setAutoScrollFollowMode(true);
        // Step 1: Add the code explain message to the chat history
        const newChatHistoryManager = getDuplicateChatHistoryManager();
        const explainCodeMetadata = newChatHistoryManager.addExplainCodeMessage(activeThreadIdRef.current);
        setChatHistoryManager(newChatHistoryManager);
        setLoadingAIResponse(true);
        // Step 2: Send the message to the AI
        const explainCompletionRequest = {
            type: 'codeExplain',
            message_id: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.UUID.uuid4(),
            metadata: explainCodeMetadata,
            stream: true
        };
        await _sendMessageAndSaveResponse(explainCompletionRequest, newChatHistoryManager);
        // Step 3: No post processing step needed for explaining code. 
    };
    const sendAgentExecutionMessage = async (input, messageIndex, sendCellIDOutput = undefined, additionalContext) => {
        // Step 0: reset the state for a new message
        resetForNewMessage();
        const agentTargetNotebookPanel = agentTargetNotebookPanelRef.current;
        if (agentTargetNotebookPanel === null) {
            return;
        }
        // Step 1: Add the user's message to the chat history
        const newChatHistoryManager = getDuplicateChatHistoryManager();
        if (messageIndex !== undefined) {
            // Drop all of the messages starting at the message index
            newChatHistoryManager.dropMessagesStartingAtIndex(messageIndex);
        }
        const agentExecutionMetadata = newChatHistoryManager.addAgentExecutionMessage(activeThreadIdRef.current, agentTargetNotebookPanel, input, additionalContext);
        if (messageIndex !== undefined) {
            agentExecutionMetadata.index = messageIndex;
        }
        agentExecutionMetadata.base64EncodedActiveCellOutput = await (0,_utils__WEBPACK_IMPORTED_MODULE_14__.getBase64EncodedCellOutputInNotebook)(agentTargetNotebookPanel, sendCellIDOutput);
        setChatHistoryManager(newChatHistoryManager);
        setLoadingAIResponse(true);
        // Step 2: Send the message to the AI
        const completionRequest = {
            type: 'agent:execution',
            message_id: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.UUID.uuid4(),
            metadata: agentExecutionMetadata,
            stream: false
        };
        await _sendMessageAndSaveResponse(completionRequest, newChatHistoryManager);
    };
    /*
        Send whatever message is currently in the chat input
    */
    const sendChatInputMessage = async (input, messageIndex, additionalContext) => {
        // Step 0: reset the state for a new message
        resetForNewMessage();
        // Enable follow mode when user sends a new message
        setAutoScrollFollowMode(true);
        // Step 1: Add the user's message to the chat history
        const newChatHistoryManager = getDuplicateChatHistoryManager();
        if (messageIndex !== undefined) {
            // Drop all of the messages starting at the message index
            newChatHistoryManager.dropMessagesStartingAtIndex(messageIndex);
        }
        const chatMessageMetadata = await newChatHistoryManager.addChatInputMessage(input, activeThreadIdRef.current, messageIndex, additionalContext);
        setChatHistoryManager(newChatHistoryManager);
        setLoadingAIResponse(true);
        // Yield control briefly to allow React to re-render the UI
        // A timeout of 0ms pushes the rest of the function to the next event loop cycle
        // so we don't get stuck behind the slow getActiveCellOutput function.
        await new Promise(resolve => setTimeout(resolve, 0));
        // Add the active cell output to the metadata afterwards setting the chatHistoryManager so that 
        // we don't have to wait on turning the output into a base64 image before we can add the user's message
        // to the chat.
        const activeCellOutput = await (0,_utils_cellOutput__WEBPACK_IMPORTED_MODULE_15__.getActiveCellOutput)(notebookTracker);
        if (activeCellOutput !== undefined) {
            chatMessageMetadata.base64EncodedActiveCellOutput = activeCellOutput;
        }
        const completionRequest = {
            type: 'chat',
            message_id: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.UUID.uuid4(),
            metadata: chatMessageMetadata,
            stream: true
        };
        // Step 2: Send the message to the AI
        await _sendMessageAndSaveResponse(completionRequest, newChatHistoryManager);
    };
    const handleUpdateMessage = async (messageIndex, newContent, additionalContext) => {
        // Then send the new message to replace it
        if (agentModeEnabled) {
            await startAgentExecution(newContent, messageIndex, additionalContext);
        }
        else {
            await sendChatInputMessage(newContent, messageIndex, additionalContext);
        }
    };
    const _sendMessageAndSaveResponse = async (completionRequest, newChatHistoryManager) => {
        var _a, _b, _c, _d;
        // Create AbortController for this request
        const abortController = new AbortController();
        activeRequestControllerRef.current = abortController;
        // Capture the completion request for debugging
        (0,_SettingsManager_profiler_ProfilerPage__WEBPACK_IMPORTED_MODULE_16__.captureCompletionRequest)(completionRequest);
        if (completionRequest.stream) {
            // Reset the streaming response and set streaming state
            streamingContentRef.current = '';
            // Disconnect any existing stream handler
            if (streamHandlerRef.current) {
                websocketClient.stream.disconnect(streamHandlerRef.current, null);
                streamHandlerRef.current = null;
            }
            // Create the stream handler function and store it in the ref
            const streamHandler = (_, chunk) => {
                if (chunk.error) {
                    console.group('Error calling OpenAI API:');
                    console.error('Title:', chunk.error.title);
                    console.error('Type:', chunk.error.error_type);
                    console.error('Hint:', chunk.error.hint);
                    console.log('Full Error Details:', chunk.error);
                    console.groupEnd();
                    // Log traceback separately to preserve formatting
                    if (chunk.error.traceback) {
                        console.group('Error Traceback:');
                        console.error(chunk.error.traceback);
                        console.groupEnd();
                    }
                    addAIMessageFromResponseAndUpdateState(chunk.error.hint || chunk.error.title || "An error occurred", completionRequest.metadata.promptType, newChatHistoryManager, true, chunk.error.title);
                    setLoadingAIResponse(false);
                }
                else if (chunk.done) {
                    // Reset states to allow future messages to show the "Apply" button
                    setCodeReviewStatus('chatPreview');
                }
                else {
                    // Use a ref to accumulate the content properly
                    streamingContentRef.current += chunk.chunk.content;
                    // Create a new chat history manager instance to ensure React detects the state change
                    const updatedChatHistoryManager = newChatHistoryManager.createDuplicateChatHistoryManager();
                    updatedChatHistoryManager.addStreamingAIMessage(streamingContentRef.current, completionRequest.metadata.promptType);
                    setChatHistoryManager(updatedChatHistoryManager);
                    // Set loading to false after we receive the first chunk
                    if (streamingContentRef.current.length > 0) {
                        setLoadingAIResponse(false);
                    }
                }
            };
            // Store the handler for later cleanup
            streamHandlerRef.current = streamHandler;
            // Connect the handler
            websocketClient.stream.connect(streamHandler, null);
            try {
                const aiResponse = await websocketClient.sendMessage(completionRequest);
                const content = (_b = (_a = aiResponse.items[0]) === null || _a === void 0 ? void 0 : _a.content) !== null && _b !== void 0 ? _b : '';
                if (completionRequest.metadata.promptType === 'agent:execution' ||
                    completionRequest.metadata.promptType === 'agent:autoErrorFixup') {
                    // Agent:Execution prompts return a CellUpdate object that we need to parse
                    const agentResponse = JSON.parse(content);
                    newChatHistoryManager.addAIMessageFromAgentResponse(agentResponse);
                }
            }
            catch (error) {
                addAIMessageFromResponseAndUpdateState(error.title ? error.title : `${error}`, 'chat', newChatHistoryManager, false);
                addAIMessageFromResponseAndUpdateState(error.hint ? error.hint : `${error}`, completionRequest.metadata.promptType, newChatHistoryManager, true);
            }
        }
        else {
            // NON-STREAMING RESPONSES
            // Once we move everything to streaming, we can remove everything in this else block
            try {
                // Check if request was aborted before making the call
                if (abortController.signal.aborted) {
                    throw new Error('Request aborted');
                }
                const aiResponse = await websocketClient.sendMessage(completionRequest);
                // Check if request was aborted after receiving response
                if (abortController.signal.aborted) {
                    throw new Error('Request aborted');
                }
                if (aiResponse.error) {
                    console.group('Error calling OpenAI API:');
                    console.error('Title:', aiResponse.error.title);
                    console.error('Type:', aiResponse.error.error_type);
                    console.error('Hint:', aiResponse.error.hint);
                    console.log('Full Error Details:', aiResponse.error);
                    console.groupEnd();
                    // Log traceback separately to preserve formatting
                    if (aiResponse.error.traceback) {
                        console.group('Error Traceback:');
                        console.error(aiResponse.error.traceback);
                        console.groupEnd();
                    }
                    addAIMessageFromResponseAndUpdateState(aiResponse.error.hint
                        ? aiResponse.error.hint
                        : `${aiResponse.error.error_type}: ${aiResponse.error.title}`, completionRequest.metadata.promptType, newChatHistoryManager, true, aiResponse.error.title);
                }
                else {
                    const content = (_d = (_c = aiResponse.items[0]) === null || _c === void 0 ? void 0 : _c.content) !== null && _d !== void 0 ? _d : '';
                    if (completionRequest.metadata.promptType === 'agent:execution' || completionRequest.metadata.promptType === 'agent:autoErrorFixup') {
                        // Agent:Execution prompts return a CellUpdate object that we need to parse
                        const agentResponse = JSON.parse(content);
                        newChatHistoryManager.addAIMessageFromAgentResponse(agentResponse);
                    }
                    else {
                        // For all other prompt types, we can just add the content to the chat history
                        aiResponse.items.forEach((item) => {
                            newChatHistoryManager.addAIMessageFromResponse(item.content || '', completionRequest.metadata.promptType);
                        });
                        setChatHistoryManager(newChatHistoryManager);
                    }
                }
            }
            catch (error) {
                // Check if this was an abort error
                if (error.message === 'Request aborted') {
                    // Don't show error message for aborted requests
                    return false;
                }
                addAIMessageFromResponseAndUpdateState(error.title ? error.title : `${error}`, 'chat', newChatHistoryManager, false);
                addAIMessageFromResponseAndUpdateState(error.hint ? error.hint : `${error}`, completionRequest.metadata.promptType, newChatHistoryManager, true);
            }
            finally {
                // Reset states to allow future messages to show the "Apply" button
                setCodeReviewStatus('chatPreview');
                setLoadingAIResponse(false);
            }
        }
        // Clean up AbortController
        if (activeRequestControllerRef.current === abortController) {
            activeRequestControllerRef.current = null;
        }
        return true;
    };
    const addAIMessageFromResponseAndUpdateState = (messageContent, promptType, chatHistoryManager, mitoAIConnectionError = false, mitoAIConnectionErrorType = null) => {
        /*
        Adds a new message to the chat history and updates the state. If we don't update the state
        then the chat history does not update in the UI.
        */
        chatHistoryManager.addAIMessageFromResponse(messageContent, promptType, mitoAIConnectionError, mitoAIConnectionErrorType);
        setChatHistoryManager(chatHistoryManager);
    };
    const markAgentForStopping = async (reason = 'naturalConclusion') => {
        // Signal that the agent should stop immediately
        shouldContinueAgentExecution.current = false;
        // Update state/UI
        setAgentExecutionStatus('idle');
        setLoadingAIResponse(false);
        if (reason === 'userStop') {
            // Immediately abort any ongoing requests
            if (activeRequestControllerRef.current) {
                activeRequestControllerRef.current.abort();
                activeRequestControllerRef.current = null;
            }
            // Add feedback message based on reason
            const newChatHistoryManager = getDuplicateChatHistoryManager();
            addAIMessageFromResponseAndUpdateState("Agent stopped by user.", 'chat', newChatHistoryManager);
            // Send stop message to backend
            await websocketClient.sendMessage({
                type: "stop_agent",
                message_id: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.UUID.uuid4(),
                metadata: {
                    promptType: "stop_agent",
                    threadId: activeThreadIdRef.current
                },
                stream: false
            });
        }
        return;
    };
    const startAgentExecution = async (input, messageIndex, additionalContext) => {
        agentTargetNotebookPanelRef.current = notebookTracker.currentWidget;
        await (0,_utils_checkpoint__WEBPACK_IMPORTED_MODULE_17__.createCheckpoint)(app, setHasCheckpoint);
        setAgentExecutionStatus('working');
        // Enable follow mode when user starts agent execution
        setAutoScrollFollowMode(true);
        // Reset the execution flag at the start of a new plan
        shouldContinueAgentExecution.current = true;
        let isAgentFinished = false;
        let agentExecutionDepth = 1;
        let sendCellIDOutput = undefined;
        // Loop through each message in the plan and send it to the AI
        while (!isAgentFinished && agentExecutionDepth <= AGENT_EXECUTION_DEPTH_LIMIT) {
            // Check if we should continue execution
            if (!shouldContinueAgentExecution.current) {
                await markAgentForStopping();
                break;
            }
            // Only the first message sent to the Agent should contain the user's input.
            // All other messages only contain updated information about the state of the notebook.
            if (agentExecutionDepth === 1) {
                await sendAgentExecutionMessage(input, messageIndex, undefined, additionalContext);
            }
            else {
                await sendAgentExecutionMessage('', undefined, sendCellIDOutput);
                // Reset flag back to false until the agent requests the active cell output again
                sendCellIDOutput = undefined;
            }
            // Iterate the agent execution depth
            agentExecutionDepth++;
            // Check the code generated by the AI for blacklisted words before running it
            const aiDisplayOptimizedChatItem = chatHistoryManagerRef.current.getLastAIDisplayOptimizedChatItem();
            // # TODO: Make this is a helper function so we can also use it in the auto error fixup! 
            if (aiDisplayOptimizedChatItem) {
                const aiGeneratedCode = (0,_utils_strings__WEBPACK_IMPORTED_MODULE_18__.getCodeBlockFromMessage)(aiDisplayOptimizedChatItem.message);
                if (aiGeneratedCode) {
                    const securityCheck = (0,_utils_blacklistedWords__WEBPACK_IMPORTED_MODULE_19__.checkForBlacklistedWords)(aiGeneratedCode);
                    if (!securityCheck.safe) {
                        console.error('Security Warning:', securityCheck.reason);
                        addAIMessageFromResponseAndUpdateState(`I cannot execute this code without your approval because this code did not pass my security checks. ${securityCheck.reason}. For your safety, I am stopping execution of this plan.`, 'agent:execution', chatHistoryManager);
                        await markAgentForStopping();
                        break;
                    }
                }
            }
            const agentResponse = aiDisplayOptimizedChatItem === null || aiDisplayOptimizedChatItem === void 0 ? void 0 : aiDisplayOptimizedChatItem.agentResponse;
            if (agentTargetNotebookPanelRef.current === null) {
                // If the agent target notebook panel is not set, we don't know where to run the code so we stop
                await markAgentForStopping();
                isAgentFinished = true;
                break;
            }
            if (agentResponse === undefined) {
                // If the agent response is undefined, we need to send a message to the agent
                await markAgentForStopping();
                isAgentFinished = true;
                break;
            }
            if (agentResponse.type === 'finished_task') {
                // If the agent told us that it is finished, we can stop
                await markAgentForStopping();
                isAgentFinished = true;
                break;
            }
            if (agentResponse.type === 'cell_update' && (agentResponse.cell_update === undefined || agentResponse.cell_update === null)) {
                // If the agent's response is not formatted correctly, stop. This is for typechecking mostly
                await markAgentForStopping();
                isAgentFinished = true;
                break;
            }
            if (agentResponse.type === 'cell_update' && agentResponse.cell_update) {
                // Run the code and handle any errors
                await (0,_utils_agentActions__WEBPACK_IMPORTED_MODULE_20__.acceptAndRunCellUpdate)(agentResponse.cell_update, agentTargetNotebookPanelRef.current);
                const status = await (0,_utils_agentActions__WEBPACK_IMPORTED_MODULE_20__.retryIfExecutionError)(agentTargetNotebookPanelRef.current, app, sendAgentSmartDebugMessage, shouldContinueAgentExecution, markAgentForStopping, chatHistoryManagerRef);
                if (status === 'interupted') {
                    break;
                }
                // If we were not able to run the code, break out of the loop 
                // so we don't continue to execute the plan. Instead, we encourage
                // the user to update the plan and try again. 
                // TODO: Save this message in backend also even if there is not another message sent. 
                // TODO: Move this into the retryIfExecutionError function?
                if (status === 'failure') {
                    addAIMessageFromResponseAndUpdateState("I apologize, but I was unable to fix the error after 3 attempts. You may want to try rephrasing your request or providing more context.", 'agent:execution', chatHistoryManager);
                    break;
                }
            }
            if (agentResponse.type === 'get_cell_output' && agentResponse.get_cell_output_cell_id !== null && agentResponse.get_cell_output_cell_id !== undefined) {
                // Mark that we should send the cell output to the agent 
                // in the next loop iteration
                sendCellIDOutput = agentResponse.get_cell_output_cell_id;
            }
            if (agentResponse.type === 'run_all_cells') {
                const result = await (0,_utils_agentActions__WEBPACK_IMPORTED_MODULE_20__.runAllCells)(app, agentTargetNotebookPanelRef.current);
                // If run_all_cells resulted in an error, handle it through the error fixup process
                if (!result.success && result.errorMessage && result.errorCellId) {
                    // Set the error cell as active so the error retry logic can work with it
                    (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_21__.setActiveCellByIDInNotebookPanel)(agentTargetNotebookPanelRef.current, result.errorCellId);
                    const status = await (0,_utils_agentActions__WEBPACK_IMPORTED_MODULE_20__.retryIfExecutionError)(agentTargetNotebookPanelRef.current, app, sendAgentSmartDebugMessage, shouldContinueAgentExecution, markAgentForStopping, chatHistoryManagerRef);
                    if (status === 'interupted') {
                        break;
                    }
                    if (status === 'failure') {
                        addAIMessageFromResponseAndUpdateState("I apologize, but I encountered an error while running all cells and was unable to fix it after multiple attempts. You may want to check the notebook for errors.", 'agent:execution', chatHistoryManager);
                        break;
                    }
                }
            }
        }
        if (agentExecutionDepth > AGENT_EXECUTION_DEPTH_LIMIT) {
            addAIMessageFromResponseAndUpdateState("Since I've been working for a while now, give my work a review and then tell me how to continue.", 'agent:execution', chatHistoryManager);
        }
        // Use markAgentForStopping for natural conclusion to ensure consistent cleanup
        await markAgentForStopping();
    };
    const updateCodeDiffStripes = (aiMessage, updateCellID) => {
        if (!aiMessage) {
            return;
        }
        const updateCellCode = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_21__.getCellCodeByID)(notebookTracker, updateCellID);
        if (updateCellID === undefined || updateCellCode === undefined) {
            return;
        }
        // Extract the code from the AI's message and then calculate the code diffs
        const aiGeneratedCode = (0,_utils_strings__WEBPACK_IMPORTED_MODULE_18__.getCodeBlockFromMessage)(aiMessage);
        const aiGeneratedCodeCleaned = (0,_utils_strings__WEBPACK_IMPORTED_MODULE_18__.removeMarkdownCodeFormatting)(aiGeneratedCode || '');
        const { unifiedCodeString, unifiedDiffs } = (0,_utils_codeDiff__WEBPACK_IMPORTED_MODULE_22__.getCodeDiffsAndUnifiedCodeString)(updateCellCode, aiGeneratedCodeCleaned);
        // Store the code cell ID where we write the code diffs so that we can
        // accept or reject the code diffs to the correct cell
        cellStateBeforeDiff.current = { codeCellID: updateCellID, code: updateCellCode };
        // Temporarily write the unified code string to the active cell so we can display
        // the code diffs to the user
        (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_21__.writeCodeToCellByID)(notebookTracker, unifiedCodeString, updateCellID);
        updateCodeCellsExtensions(unifiedDiffs);
        // Briefly highlight the code cell to draw the user's attention to it
        (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_21__.highlightCodeCell)(notebookTracker, updateCellID);
    };
    const displayOptimizedChatHistory = chatHistoryManager.getDisplayOptimizedHistory();
    const previewAICodeToActiveCell = () => {
        setCodeReviewStatus('codeCellPreview');
        const activeCellID = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_21__.getActiveCellID)(notebookTracker);
        const lastAIDisplayMessage = chatHistoryManagerRef.current.getLastAIDisplayOptimizedChatItem();
        if (activeCellID === undefined || lastAIDisplayMessage === undefined) {
            return;
        }
        (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_21__.scrollToCell)(notebookTracker.currentWidget, activeCellID, undefined, 'end');
        updateCodeDiffStripes(lastAIDisplayMessage.message, activeCellID);
        updateCellToolbarButtons();
    };
    const acceptAICode = () => {
        const latestChatHistoryManager = chatHistoryManagerRef.current;
        const lastAIMessage = latestChatHistoryManager.getLastAIDisplayOptimizedChatItem();
        if (!lastAIMessage || !cellStateBeforeDiff.current) {
            return;
        }
        const aiGeneratedCode = (0,_utils_strings__WEBPACK_IMPORTED_MODULE_18__.getCodeBlockFromMessage)(lastAIMessage.message);
        if (!aiGeneratedCode) {
            return;
        }
        setCodeReviewStatus('applied');
        const targetCellID = cellStateBeforeDiff.current.codeCellID;
        // Write to the cell that has the code diffs
        writeCodeToCellAndTurnOffDiffs(aiGeneratedCode, targetCellID);
        // Focus on the active cell after the code is written
        const targetCell = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_21__.getCellByID)(notebookTracker, targetCellID);
        if (targetCell) {
            // Make the target cell the active cell
            (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_21__.setActiveCellByID)(notebookTracker, targetCellID);
            // Focus on the active cell
            targetCell.activate();
        }
    };
    const resetForNewMessage = () => {
        /*
        Before we send the next user message, we need to reset the state for a new message:
        - Reject the previous Ai generated code if they did not accept it yet
        - Clear the next steps
        */
        rejectAICode();
        setNextSteps([]);
        setShowRevertQuestionnaire(false);
    };
    const rejectAICode = () => {
        if (cellStateBeforeDiff.current === undefined) {
            return;
        }
        setCodeReviewStatus('chatPreview');
        writeCodeToCellAndTurnOffDiffs(cellStateBeforeDiff.current.code, cellStateBeforeDiff.current.codeCellID);
    };
    const writeCodeToCellAndTurnOffDiffs = (code, codeCellID) => {
        updateCodeCellsExtensions(undefined);
        cellStateBeforeDiff.current = undefined;
        if (codeCellID !== undefined) {
            (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_21__.writeCodeToCellByID)(notebookTracker, code, codeCellID);
            updateCellToolbarButtons();
        }
    };
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        /*
            Add a new command to the JupyterLab command registry that applies the latest AI generated code
            to the active code cell. Do this inside of the useEffect so that we only register the command
            the first time we create the chat. Registering the command when it is already created causes
            errors.
        */
        app.commands.addCommand(_commands__WEBPACK_IMPORTED_MODULE_23__.COMMAND_MITO_AI_PREVIEW_LATEST_CODE, {
            execute: () => {
                previewAICodeToActiveCell();
            }
        });
        app.commands.addCommand(_commands__WEBPACK_IMPORTED_MODULE_23__.COMMAND_MITO_AI_APPLY_LATEST_CODE, {
            execute: () => {
                acceptAICode();
            }
        });
        app.commands.addCommand(_commands__WEBPACK_IMPORTED_MODULE_23__.COMMAND_MITO_AI_REJECT_LATEST_CODE, {
            execute: () => {
                rejectAICode();
            }
        });
        /*
            Add a new command to the JupyterLab command registry that sends the current chat message.
            We use this to automatically send the message when the user adds an error to the chat.
        */
        app.commands.addCommand(_commands__WEBPACK_IMPORTED_MODULE_23__.COMMAND_MITO_AI_SEND_DEBUG_ERROR_MESSAGE, {
            execute: async (args) => {
                if (args === null || args === void 0 ? void 0 : args.input) {
                    await sendSmartDebugMessage(args.input.toString());
                }
            }
        });
        app.commands.addCommand(_commands__WEBPACK_IMPORTED_MODULE_23__.COMMAND_MITO_AI_SEND_EXPLAIN_CODE_MESSAGE, {
            execute: async () => {
                await sendExplainCodeMessage();
            }
        });
        app.commands.addCommand(_commands__WEBPACK_IMPORTED_MODULE_23__.COMMAND_MITO_AI_SEND_AGENT_MESSAGE, {
            execute: async (args) => {
                if (args === null || args === void 0 ? void 0 : args.input) {
                    // If its not already in agent mode, start a new chat in agent mode
                    if (!agentModeEnabledRef.current) {
                        await startNewChat();
                        setAgentModeEnabled(true);
                    }
                    // Wait for the next tick to ensure state update is processed
                    await new Promise(resolve => setTimeout(resolve, 0));
                    await startAgentExecution(args.input.toString());
                }
            }
        });
        /*
            Register the code cell toolbar buttons for accepting and rejecting code.
        */
        app.commands.addCommand(_commands__WEBPACK_IMPORTED_MODULE_23__.COMMAND_MITO_AI_CELL_TOOLBAR_ACCEPT_CODE, {
            label: `Accept ${operatingSystem === 'mac' ? '⌘Y' : 'Ctrl+Y'}`,
            className: 'text-button-mito-ai button-base button-green',
            caption: 'Accept Code',
            execute: () => { acceptAICode(); },
            // We use the cellStateBeforeDiff because it contains the code cell ID that we want to write to
            // and it will only be set when the codeReviewStatus is 'codeCellPreview'
            isVisible: () => {
                var _a, _b;
                try {
                    return ((_a = notebookTracker.activeCell) === null || _a === void 0 ? void 0 : _a.model.id) === ((_b = cellStateBeforeDiff.current) === null || _b === void 0 ? void 0 : _b.codeCellID);
                }
                catch (error) {
                    console.error('Error checking if code cell toolbar accept code is visible', error);
                    return false;
                }
            }
        });
        app.commands.addCommand(_commands__WEBPACK_IMPORTED_MODULE_23__.COMMAND_MITO_AI_CELL_TOOLBAR_REJECT_CODE, {
            label: `Reject ${operatingSystem === 'mac' ? '⌘U' : 'Ctrl+U'}`,
            className: 'text-button-mito-ai button-base button-red',
            caption: 'Reject Code',
            execute: () => { rejectAICode(); },
            isVisible: () => {
                var _a, _b;
                try {
                    return ((_a = notebookTracker.activeCell) === null || _a === void 0 ? void 0 : _a.model.id) === ((_b = cellStateBeforeDiff.current) === null || _b === void 0 ? void 0 : _b.codeCellID);
                }
                catch (error) {
                    console.error('Error checking if code cell toolbar reject code is visible', error);
                    return false;
                }
            }
        });
    }, []);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        // Register keyboard shortcuts 
        const accelYDisposable = app.commands.addKeyBinding({
            command: codeReviewStatus === 'chatPreview' ?
                _commands__WEBPACK_IMPORTED_MODULE_23__.COMMAND_MITO_AI_PREVIEW_LATEST_CODE :
                _commands__WEBPACK_IMPORTED_MODULE_23__.COMMAND_MITO_AI_APPLY_LATEST_CODE,
            keys: ['Accel Y'],
            selector: 'body',
        });
        const accelDDisposable = app.commands.addKeyBinding({
            command: _commands__WEBPACK_IMPORTED_MODULE_23__.COMMAND_MITO_AI_REJECT_LATEST_CODE,
            keys: ['Accel U'],
            selector: 'body',
            preventDefault: true,
        });
        // Clean up the key bindings when the component unmounts or when codeReviewStatus changes
        // This prevents keyboard shortcuts from persisting when they shouldn't.
        return () => {
            accelYDisposable.dispose();
            accelDDisposable.dispose();
        };
    }, [codeReviewStatus]);
    const updateCellToolbarButtons = () => {
        // Tell Jupyter to re-evaluate if the toolbar buttons should be visible.
        // Without this, the user needs to take some action, like switching to a different cell 
        // and then switching back in order for the Jupyter to re-evaluate if it should
        // show the toolbar buttons.
        app.commands.notifyCommandChanged(_commands__WEBPACK_IMPORTED_MODULE_23__.COMMAND_MITO_AI_CELL_TOOLBAR_ACCEPT_CODE);
        app.commands.notifyCommandChanged(_commands__WEBPACK_IMPORTED_MODULE_23__.COMMAND_MITO_AI_CELL_TOOLBAR_REJECT_CODE);
    };
    const codeDiffStripesCompartments = react__WEBPACK_IMPORTED_MODULE_1___default().useRef(new Map());
    // Function to update the extensions of code cells
    const updateCodeCellsExtensions = (unifiedDiffLines) => {
        var _a;
        const notebook = (_a = notebookTracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;
        if (!notebook) {
            return;
        }
        const activeCellIndex = notebook.activeCellIndex;
        notebook.widgets.forEach((cell, index) => {
            if (cell.model.type === 'code') {
                const isActiveCodeCell = activeCellIndex === index;
                // TODO: Instead of casting, we should rely on the type system to make 
                // sure we're using the correct types!
                const codeCell = cell;
                const cmEditor = codeCell.editor;
                const editorView = cmEditor === null || cmEditor === void 0 ? void 0 : cmEditor.editor;
                if (editorView) {
                    const cellId = codeCell.model.id;
                    let compartment = codeDiffStripesCompartments.current.get(cellId);
                    if (!compartment) {
                        // Create a new compartment and store it
                        compartment = new _codemirror_state__WEBPACK_IMPORTED_MODULE_0__.Compartment();
                        codeDiffStripesCompartments.current.set(cellId, compartment);
                        // Apply the initial configuration
                        editorView.dispatch({
                            effects: _codemirror_state__WEBPACK_IMPORTED_MODULE_0__.StateEffect.appendConfig.of(compartment.of(unifiedDiffLines !== undefined && isActiveCodeCell ? (0,_CodeDiffDisplay__WEBPACK_IMPORTED_MODULE_24__.codeDiffStripesExtension)({ unifiedDiffLines: unifiedDiffLines }) : [])),
                        });
                    }
                    else {
                        // Reconfigure the compartment
                        editorView.dispatch({
                            effects: compartment.reconfigure(unifiedDiffLines !== undefined && isActiveCodeCell ? (0,_CodeDiffDisplay__WEBPACK_IMPORTED_MODULE_24__.codeDiffStripesExtension)({ unifiedDiffLines: unifiedDiffLines }) : []),
                        });
                    }
                }
                else {
                    console.log('Mito AI: editor view not found when applying code diff stripes');
                }
            }
        });
    };
    const lastAIMessagesIndex = chatHistoryManager.getLastAIMessageIndex();
    let processedDisplayOptimizedChatHistory = [];
    // In agent mode, we group consecutive error messages together. 
    // In chat mode, we display messages individually as they were sent
    if (agentModeEnabled) {
        processedDisplayOptimizedChatHistory = (0,_utils_chatHistory__WEBPACK_IMPORTED_MODULE_25__.processChatHistoryForErrorGrouping)(chatHistoryManager.getDisplayOptimizedHistory());
    }
    else {
        processedDisplayOptimizedChatHistory = chatHistoryManager.getDisplayOptimizedHistory();
    }
    // Type guard function to check if an item is GroupedErrorMessages
    const isGroupedErrorMessages = (item) => {
        return Array.isArray(item);
    };
    return (
    // We disable the chat taskpane if the user is not signed up AND there are no chat history items
    react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_26__.classNames)('chat-taskpane', { 'disabled': !(isSignedUp || displayOptimizedChatHistory.length > 0) }) },
        react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { className: "chat-taskpane-header" },
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { className: "chat-taskpane-header-left" },
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_components_IconButton__WEBPACK_IMPORTED_MODULE_27__["default"], { icon: react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.settingsIcon.react, null), title: "Mito AI Settings", onClick: () => {
                        void app.commands.execute(_SettingsManager_SettingsManagerPlugin__WEBPACK_IMPORTED_MODULE_28__.COMMAND_MITO_AI_SETTINGS);
                    } })),
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { className: "chat-taskpane-header-right" },
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_components_IconButton__WEBPACK_IMPORTED_MODULE_27__["default"], { icon: react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.addIcon.react, null), title: "Start New Chat", onClick: async () => { await startNewChat(); } }),
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_components_DropdownMenu__WEBPACK_IMPORTED_MODULE_29__["default"], { trigger: react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", { className: "icon-button", title: "Chat Threads", onClick: fetchChatThreads },
                        react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.historyIcon.react, null)), items: chatThreads.length > 0
                        ? chatThreads.map(thread => ({
                            label: thread.name,
                            primaryIcon: activeThreadIdRef.current === thread.thread_id ? _icons__WEBPACK_IMPORTED_MODULE_30__.OpenIndicatorLabIcon.react : undefined,
                            onClick: () => fetchChatHistoryAndSetActiveThread(thread.thread_id),
                            secondaryActions: [
                                {
                                    icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.deleteIcon.react,
                                    onClick: () => deleteThread(thread.thread_id),
                                    tooltip: 'Delete this chat',
                                }
                            ]
                        }))
                        : [{
                                label: "No chat history available",
                                disabled: true,
                                onClick: () => { }
                            }], alignment: "right" }))),
        react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { className: "chat-messages", ref: chatMessagesRef },
            displayOptimizedChatHistory.length === 0 &&
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { className: "chat-empty-message" }, isSignedUp === false
                    ? react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_SignUpForm__WEBPACK_IMPORTED_MODULE_31__["default"], { onSignUpSuccess: refreshUserSignupState })
                    : react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_CTACarousel__WEBPACK_IMPORTED_MODULE_32__["default"], { app: app })),
            processedDisplayOptimizedChatHistory.map((displayOptimizedChat, index) => {
                if (isGroupedErrorMessages(displayOptimizedChat)) {
                    return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_components_AgentComponents_ErrorFixupToolUI__WEBPACK_IMPORTED_MODULE_33__["default"], { key: index, messages: displayOptimizedChat, renderMimeRegistry: renderMimeRegistry }));
                }
                else {
                    return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_ChatMessage_ChatMessage__WEBPACK_IMPORTED_MODULE_34__["default"], { key: index, message: displayOptimizedChat.message, promptType: displayOptimizedChat.promptType, agentResponse: displayOptimizedChat.agentResponse, codeCellID: displayOptimizedChat.codeCellID, mitoAIConnectionError: displayOptimizedChat.type === 'connection error', mitoAIConnectionErrorType: displayOptimizedChat.mitoAIConnectionErrorType || null, messageIndex: index, notebookTracker: notebookTracker, renderMimeRegistry: renderMimeRegistry, app: app, isLastAiMessage: index === lastAIMessagesIndex, isLastMessage: index === displayOptimizedChatHistory.length - 1, operatingSystem: operatingSystem, previewAICode: previewAICodeToActiveCell, acceptAICode: acceptAICode, rejectAICode: rejectAICode, onUpdateMessage: handleUpdateMessage, contextManager: contextManager, codeReviewStatus: codeReviewStatus, setNextSteps: setNextSteps, agentModeEnabled: agentModeEnabled, additionalContext: displayOptimizedChat.additionalContext }));
                }
            }).filter(message => message !== null),
            loadingAIResponse &&
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { className: "chat-loading-message" },
                    "Thinking ",
                    react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_components_LoadingDots__WEBPACK_IMPORTED_MODULE_35__["default"], null)),
            hasCheckpoint &&
                agentModeEnabled &&
                agentExecutionStatus === 'idle' &&
                displayOptimizedChatHistory.length > 0 && (react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { className: 'message message-assistant-chat' },
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_components_TextAndIconButton__WEBPACK_IMPORTED_MODULE_36__["default"], { text: "Revert changes", icon: _icons_UndoIcon__WEBPACK_IMPORTED_MODULE_37__["default"], title: "Revert changes", onClick: () => {
                        void (0,_utils_checkpoint__WEBPACK_IMPORTED_MODULE_17__.restoreCheckpoint)(app, notebookTracker, setHasCheckpoint);
                        setDisplayedNextStepsIfAvailable(false);
                        setHasCheckpoint(false);
                        setShowRevertQuestionnaire(true);
                        (0,_utils_scroll__WEBPACK_IMPORTED_MODULE_13__.scrollToDiv)(chatMessagesRef);
                    }, variant: "gray", width: "fit-contents", iconPosition: "left" }),
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement("p", { className: "text-muted text-sm" }, "Undo the most recent changes made by the agent"))),
            showRevertQuestionnaire && (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_ChatMessage_RevertQuestionnaire__WEBPACK_IMPORTED_MODULE_38__["default"], { onDestroy: () => setShowRevertQuestionnaire(false), getDuplicateChatHistoryManager: getDuplicateChatHistoryManager, setChatHistoryManager: setChatHistoryManager }))),
        displayOptimizedChatHistory.length === 0 && (react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { className: "suggestions-container" },
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_ChatMessage_ScrollableSuggestions__WEBPACK_IMPORTED_MODULE_39__["default"], { onSelectSuggestion: (prompt) => {
                    if (agentModeEnabled) {
                        void startAgentExecution(prompt);
                    }
                    else {
                        void sendChatInputMessage(prompt);
                    }
                } }))),
        react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { className: `connected-input-container ${nextSteps.length > 0 ? 'has-next-steps' : ''}` },
            nextSteps.length > 0 && (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_components_NextStepsPills__WEBPACK_IMPORTED_MODULE_40__["default"], { nextSteps: nextSteps, onSelectNextStep: agentModeEnabled ? startAgentExecution : sendChatInputMessage, displayedNextStepsIfAvailable: displayedNextStepsIfAvailable, setDisplayedNextStepsIfAvailable: setDisplayedNextStepsIfAvailable })),
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_ChatMessage_ChatInput__WEBPACK_IMPORTED_MODULE_41__["default"], { app: app, initialContent: '', onSave: agentModeEnabled ? startAgentExecution : sendChatInputMessage, onCancel: undefined, isEditing: false, contextManager: contextManager, notebookTracker: notebookTracker, agentModeEnabled: agentModeEnabled, agentExecutionStatus: agentExecutionStatus, operatingSystem: operatingSystem, displayOptimizedChatHistoryLength: displayOptimizedChatHistory.length, agentTargetNotebookPanelRef: agentTargetNotebookPanelRef, isSignedUp: isSignedUp })),
        agentExecutionStatus !== 'working' && agentExecutionStatus !== 'stopping' && (react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { className: "chat-controls" },
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { className: "chat-controls-left" },
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_components_ToggleButton__WEBPACK_IMPORTED_MODULE_42__["default"], { leftText: "Chat", leftTooltip: "Chat mode suggests an edit to the active cell and let's you decide to accept or reject it.", rightText: "Agent", rightTooltip: "Agent mode writes and executes code until it's finished your request.", isLeftSelected: !agentModeEnabled, onChange: async (isLeftSelected) => {
                        await startNewChat(); // TODO: delete thread instead of starting new chat
                        setAgentModeEnabled(!isLeftSelected);
                        // Clear agent checkpoint when switching modes
                        setHasCheckpoint(false);
                        setShowRevertQuestionnaire(false);
                        // Focus the chat input directly
                        const chatInput = document.querySelector('.chat-input');
                        if (chatInput) {
                            chatInput.focus();
                        }
                    } }),
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_components_ModelSelector__WEBPACK_IMPORTED_MODULE_8__["default"], { onConfigChange: (config) => {
                        // Just update the backend
                        void updateModelOnBackend(config.model);
                    } })),
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", { className: "button-base submit-button", onClick: () => {
                    const chatInput = document.querySelector('.chat-input');
                    if (chatInput && chatInput.value) {
                        // Simulate an Enter keypress
                        // This triggers the existing submission logic in ChatInput.tsx
                        const enterEvent = new KeyboardEvent('keydown', {
                            key: 'Enter',
                            code: 'Enter',
                            keyCode: 13,
                            which: 13,
                            bubbles: true,
                            cancelable: true
                        });
                        chatInput.dispatchEvent(enterEvent);
                    }
                } },
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", { className: "submit-text" }, "Submit"),
                " \u23CE"))),
        (agentExecutionStatus === 'working' || agentExecutionStatus === 'stopping') && (react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", { className: "button-base button-red stop-agent-button", onClick: () => void markAgentForStopping('userStop'), disabled: agentExecutionStatus === 'stopping', "data-testid": "stop-agent-button" }, agentExecutionStatus === 'stopping' ? (react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { className: "stop-agent-button-content" },
            "Stopping",
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_components_LoadingCircle__WEBPACK_IMPORTED_MODULE_43__["default"], null),
            " ")) : ('Stop Agent')))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChatTaskpane);


/***/ }),

/***/ "./lib/Extensions/AiChat/ChatWidget.js":
/*!*********************************************!*\
  !*** ./lib/Extensions/AiChat/ChatWidget.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChatWidget: () => (/* binding */ ChatWidget),
/* harmony export */   buildChatWidget: () => (/* binding */ buildChatWidget),
/* harmony export */   chatIcon: () => (/* binding */ chatIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ChatTaskpane__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ChatTaskpane */ "./lib/Extensions/AiChat/ChatTaskpane.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _src_icons_ChatIcon_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../src/icons/ChatIcon.svg */ "./src/icons/ChatIcon.svg");
/* harmony import */ var _utils_user__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/user */ "./lib/utils/user.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _websockets_completions_CompletionsWebsocketClient__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../websockets/completions/CompletionsWebsocketClient */ "./lib/websockets/completions/CompletionsWebsocketClient.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */








const chatIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.LabIcon({
    name: 'mito_ai',
    svgstr: _src_icons_ChatIcon_svg__WEBPACK_IMPORTED_MODULE_4__
});
class ChatWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ReactWidget {
    constructor(options) {
        super();
        this.options = options;
        this._capabilitiesChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._lastErrorChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        // Create the websocket client
        this.websocketClient = new _websockets_completions_CompletionsWebsocketClient__WEBPACK_IMPORTED_MODULE_5__.CompletionWebsocketClient({
            serverSettings: options.app.serviceManager.serverSettings,
        });
        this.websocketClient.messages.connect(this.onMessage, this);
        // Initialize the websocket client
        this.websocketClient.initialize().catch((error) => {
            console.error('Failed to initialized the websocketClient for the Mito AI Chat panel', error);
        });
        this.title.icon = chatIcon;
        this.title.caption = 'AI Chat for your JupyterLab';
    }
    /**
     * Signal emitted when the capabilities of the AI provider changes.
     */
    get capabilitiesChanged() {
        return this._capabilitiesChanged;
    }
    /**
     * Signal emitted when the last error of the AI provider changes.
     */
    get lastErrorChanged() {
        return this._lastErrorChanged;
    }
    /**
     * Dispose the widget.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this.websocketClient.dispose();
        super.dispose();
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ChatTaskpane__WEBPACK_IMPORTED_MODULE_6__["default"], { app: this.options.app, notebookTracker: this.options.notebookTracker, renderMimeRegistry: this.options.renderMimeRegistry, contextManager: this.options.contextManager, operatingSystem: this.options.operatingSystem, websocketClient: this.websocketClient }));
    }
    onMessage(client, message) {
        switch (message.type) {
            case 'ai_capabilities':
                this._capabilitiesChanged.emit(message);
                break;
            case 'error':
                this._lastErrorChanged.emit(message);
                break;
        }
    }
}
function buildChatWidget(app, notebookTracker, renderMimeRegistry, contextManager) {
    // Get the operating system here so we don't have to do it each time the chat changes.
    // The operating system won't change, duh.
    const operatingSystem = (0,_utils_user__WEBPACK_IMPORTED_MODULE_7__.getOperatingSystem)();
    const chatWidget = new ChatWidget({
        app,
        notebookTracker,
        renderMimeRegistry,
        contextManager,
        operatingSystem
    });
    chatWidget.id = 'mito_ai';
    return chatWidget;
}


/***/ }),

/***/ "./lib/Extensions/AiChat/CodeDiffDisplay.js":
/*!**************************************************!*\
  !*** ./lib/Extensions/AiChat/CodeDiffDisplay.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   codeDiffStripesExtension: () => (/* binding */ codeDiffStripesExtension)
/* harmony export */ });
/* harmony import */ var _codemirror_state__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @codemirror/state */ "webpack/sharing/consume/default/@codemirror/state");
/* harmony import */ var _codemirror_state__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_codemirror_state__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @codemirror/view */ "webpack/sharing/consume/default/@codemirror/view");
/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_codemirror_view__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_arrays__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/arrays */ "./lib/utils/arrays.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */



// Defines new styles for this extension
const baseTheme = _codemirror_view__WEBPACK_IMPORTED_MODULE_1__.EditorView.baseTheme({
    // We need to set some transparency because the stripes are above the selection layer
    '.cm-codeDiffRemovedStripe': { backgroundColor: 'color-mix(in srgb, var(--error-color) 30%, transparent)' },
    '.cm-codeDiffInsertedStripe': { backgroundColor: 'color-mix(in srgb, var(--jp-accent-color2) 35%, transparent)' },
});
// Resolve step to use in the editor
const unifiedDiffLines = _codemirror_state__WEBPACK_IMPORTED_MODULE_0__.Facet.define({
    combine: (unifiedDiffLines) => {
        return unifiedDiffLines;
    }
});
// Add decoration to editor lines
const removedStripe = _codemirror_view__WEBPACK_IMPORTED_MODULE_1__.Decoration.line({
    attributes: { class: 'cm-codeDiffRemovedStripe' }
});
const insertedStripe = _codemirror_view__WEBPACK_IMPORTED_MODULE_1__.Decoration.line({
    attributes: { class: 'cm-codeDiffInsertedStripe' }
});
// Create the range of lines requiring decorations
const getCodeDiffStripesDecoration = (view) => {
    var _a, _b, _c;
    const unifiedDiffLinesFacet = view.state.facet(unifiedDiffLines)[0];
    const builder = new _codemirror_state__WEBPACK_IMPORTED_MODULE_0__.RangeSetBuilder();
    for (const { from, to } of view.visibleRanges) {
        for (let pos = from; pos <= to;) {
            const line = view.state.doc.lineAt(pos);
            // The code mirror line numbers are 1-indexed, but our diff lines are 0-indexed
            if (line.number - 1 >= ((_a = unifiedDiffLinesFacet === null || unifiedDiffLinesFacet === void 0 ? void 0 : unifiedDiffLinesFacet.length) !== null && _a !== void 0 ? _a : 0)) {
                /*
                  Because we need to rerender the decorations each time the doc changes or viewport updates
                  (maybe we don't need to, but the code mirror examples does this so we will to for now) there
                  is a race condition where sometimes the content of the code cell updates before the unified diff lines
                  are updated. As a result, we need to break out of the loop before we get a null pointer error.
        
                  This isn't a problem because right afterwards, the code mirror updates again due to the unified diff lines
                  being updated. In that render, we get the correct results.
                */
                break;
            }
            if (((_b = unifiedDiffLinesFacet === null || unifiedDiffLinesFacet === void 0 ? void 0 : unifiedDiffLinesFacet[line.number - 1]) === null || _b === void 0 ? void 0 : _b.type) === 'removed') {
                builder.add(line.from, line.from, removedStripe);
            }
            if (((_c = unifiedDiffLinesFacet === null || unifiedDiffLinesFacet === void 0 ? void 0 : unifiedDiffLinesFacet[line.number - 1]) === null || _c === void 0 ? void 0 : _c.type) === 'inserted') {
                builder.add(line.from, line.from, insertedStripe);
            }
            pos = line.to + 1;
        }
    }
    return builder.finish();
};
// Update the decoration status of the editor view
const showStripes = _codemirror_view__WEBPACK_IMPORTED_MODULE_1__.ViewPlugin.fromClass(class {
    constructor(view) {
        this.decorations = getCodeDiffStripesDecoration(view);
    }
    update(update) {
        var _a, _b;
        const oldUnifiedDiffLines = update.startState.facet(unifiedDiffLines);
        const newUnifiedDiffLines = update.view.state.facet(unifiedDiffLines);
        if (update.docChanged ||
            update.viewportChanged ||
            !(0,_utils_arrays__WEBPACK_IMPORTED_MODULE_2__.deepEqualArrays)((_a = oldUnifiedDiffLines[0]) !== null && _a !== void 0 ? _a : [], (_b = newUnifiedDiffLines[0]) !== null && _b !== void 0 ? _b : [])) {
            this.decorations = getCodeDiffStripesDecoration(update.view);
        }
    }
}, {
    decorations: v => v.decorations
});
// Create the Code Mirror Extension to apply the code diff stripes to the code mirror editor
function codeDiffStripesExtension(options = {}) {
    return [
        baseTheme,
        options.unifiedDiffLines ? unifiedDiffLines.of(options.unifiedDiffLines) : [],
        showStripes
    ];
}


/***/ }),

/***/ "./lib/Extensions/AiChat/FirstMessage.js":
/*!***********************************************!*\
  !*** ./lib/Extensions/AiChat/FirstMessage.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFirstMessageFromCookie: () => (/* binding */ getFirstMessageFromCookie)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
const getCookie = (name) => {
    const nameEQ = name + "=";
    const ca = document.cookie.split(';');
    for (let i = 0; i < ca.length; i++) {
        let c = ca[i];
        if (!c)
            continue;
        while (c.charAt(0) === ' ')
            c = c.substring(1, c.length);
        if (c.indexOf(nameEQ) === 0)
            return c.substring(nameEQ.length, c.length);
    }
    return null;
};
const deleteCookie = (name) => {
    // Delete for current domain
    document.cookie = `${name}=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;`;
    // Delete for all subdomains
    document.cookie = `${name}=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/; domain=.trymito.io;`;
};
const getFirstMessageFromCookies = () => {
    const firstMessage = getCookie('mito-ai-first-message');
    if (firstMessage) {
        // Clean up cookie after reading
        deleteCookie('mito-ai-first-message');
        return firstMessage;
    }
    return null;
};
const getFirstMessageFromCookie = () => {
    // Primary: Check cookies (works through SSO flow)
    const firstMessage = getFirstMessageFromCookies();
    console.log('Cookie check:', firstMessage);
    return firstMessage || undefined;
};


/***/ }),

/***/ "./lib/Extensions/AiChat/SignUpForm.js":
/*!*********************************************!*\
  !*** ./lib/Extensions/AiChat/SignUpForm.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/* harmony import */ var _icons_MitoLogo__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../icons/MitoLogo */ "./lib/icons/MitoLogo.js");
/* harmony import */ var _utils_userSignupEvents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/userSignupEvents */ "./lib/utils/userSignupEvents.js");
/* harmony import */ var _style_SignUpForm_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../style/SignUpForm.css */ "./style/SignUpForm.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */





const SignUpForm = ({ onSignUpSuccess }) => {
    const [email, setEmail] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    const handleSubmit = async (e) => {
        e.preventDefault();
        try {
            await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_2__.setUserKey)('user_email', email);
            onSignUpSuccess === null || onSignUpSuccess === void 0 ? void 0 : onSignUpSuccess();
            // Emit signup success event for other components to listen to
            _utils_userSignupEvents__WEBPACK_IMPORTED_MODULE_3__.userSignupEvents.emitSignupSuccess();
        }
        catch (error) {
            console.error('Failed to set user email:', error);
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "signup-form-container" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "signup-form-header-logo" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_MitoLogo__WEBPACK_IMPORTED_MODULE_4__["default"], { width: "60", height: "30" })),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "signup-form-header" }, "Sign Up for Mito"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "signup-form-message", "data-testid": "signup-form-message" }, "To avoid abuse of our free AI credits, we ask that you login to use Mito AI. No credit card required, just an email."),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { onSubmit: handleSubmit, style: { marginTop: '15px' } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: "email", value: email, onChange: (e) => setEmail(e.target.value), placeholder: "Your work email", className: "signup-form-input", required: true }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { type: "submit", className: "button-base signup-form-button" }, "Sign Up"))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SignUpForm);


/***/ }),

/***/ "./lib/Extensions/AiChat/jupyterSettingsManager.js":
/*!*********************************************************!*\
  !*** ./lib/Extensions/AiChat/jupyterSettingsManager.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   setDefaultWindowingMode: () => (/* binding */ setDefaultWindowingMode),
/* harmony export */   setRenameUntitledFileOnSave: () => (/* binding */ setRenameUntitledFileOnSave)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
// Document manager plugin ID
const DOCMANAGER_PLUGIN_ID = '@jupyterlab/docmanager-extension:plugin';
const NOTEBOOK_PLUGIN_ID = '@jupyterlab/notebook-extension:tracker';
// Set renameUntitledFileOnSave to false when the extension loads
const setRenameUntitledFileOnSave = async (settingRegistry, _documentManager) => {
    // Note we don't use the documentManager, but we require it as a parameter to make sure
    // that we leave the documentManager as a required token in the AiChatPlugin.ts file.
    try {
        await settingRegistry.set(DOCMANAGER_PLUGIN_ID, 'renameUntitledFileOnSave', false);
    }
    catch (error) {
        console.error('[mito-ai jupyter settings manager] Failed to set renameUntitledFileOnSave setting:', error);
    }
};
const setDefaultWindowingMode = async (settingRegistry) => {
    try {
        await settingRegistry.set(NOTEBOOK_PLUGIN_ID, 'windowingMode', 'defer');
    }
    catch (error) {
        console.log('[mito-ai jupyter settings manager] Failed to set windowingMode to defer', error);
    }
};


/***/ }),

/***/ "./lib/Extensions/AiChat/token.js":
/*!****************************************!*\
  !*** ./lib/Extensions/AiChat/token.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IChatTracker: () => (/* binding */ IChatTracker)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/*
Because other extensions rely on the Chat plugin, we need to make sure that the
Chat plugin is loaded before these other extensions.

For example, the emptyCell extension relies on the Chat plugin in order to
find the keybindings associated with the COMMAND_MITO_AI_OPEN_CHAT command.

By providing a chat plugin token, we can require it from the other extensions.
This makes sure that the chat plugin is loaded before these other extensions.
*/
const IChatTracker = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('mito-ai/IChatTracker', 'Widget tracker for the chat sidebar.');


/***/ }),

/***/ "./lib/Extensions/AiChat/utils.js":
/*!****************************************!*\
  !*** ./lib/Extensions/AiChat/utils.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getBase64EncodedCellOutput: () => (/* binding */ getBase64EncodedCellOutput),
/* harmony export */   getBase64EncodedCellOutputInNotebook: () => (/* binding */ getBase64EncodedCellOutputInNotebook)
/* harmony export */ });
/* harmony import */ var _utils_notebook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/notebook */ "./lib/utils/notebook.js");
/* harmony import */ var _utils_cellOutput__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/cellOutput */ "./lib/utils/cellOutput.js");
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */



const getBase64EncodedCellOutput = async (notebookTracker, cellID) => {
    const notebookPanel = notebookTracker.currentWidget;
    return getBase64EncodedCellOutputInNotebook(notebookPanel, cellID);
};
const getBase64EncodedCellOutputInNotebook = async (notebookPanel, cellID) => {
    if (cellID === undefined || notebookPanel === null) {
        return undefined;
    }
    const cellIndex = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_0__.getCellIndexByIDInNotebookPanel)(notebookPanel, cellID);
    if (cellIndex === undefined) {
        // Log that the cell id is not part of the notebook
        console.log(`Cell with id ${cellID} not found in notebook ${notebookPanel.context.path}`);
        void (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__.logEvent)('get_cell_output_requested_non_existent_cell');
        return undefined;
    }
    const activeCellOutput = await (0,_utils_cellOutput__WEBPACK_IMPORTED_MODULE_2__.getCellOutputByIDInNotebook)(notebookPanel, cellID);
    if (activeCellOutput !== undefined) {
        return activeCellOutput;
    }
    return undefined;
};


/***/ }),

/***/ "./lib/Extensions/AiChat/validationUtils.js":
/*!**************************************************!*\
  !*** ./lib/Extensions/AiChat/validationUtils.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   validateAndCorrectAgentResponse: () => (/* binding */ validateAndCorrectAgentResponse)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
/**
 * Validates and corrects an AgentResponse to ensure it adheres to the expected format.
 * Handles common mistakes like string instead of array, missing fields, etc.
 */
function validateAndCorrectAgentResponse(agentResponse) {
    var _a;
    // Create a copy to avoid mutating the original
    const correctedResponse = { ...agentResponse };
    // Ensure type is valid. Default to finished_task if not valid.
    const validTypes = ['cell_update', 'get_cell_output', 'run_all_cells', 'finished_task'];
    correctedResponse.type = (correctedResponse.type && validTypes.includes(correctedResponse.type))
        ? correctedResponse.type
        : 'finished_task';
    // Ensure message is a string. Default to empty string if not valid.
    if (!correctedResponse.message || typeof correctedResponse.message !== 'string') {
        correctedResponse.message = '';
    }
    // Correct get_cell_output_cell_id if present
    const getCellOutputCellIdType = typeof correctedResponse.get_cell_output_cell_id;
    correctedResponse.get_cell_output_cell_id = getCellOutputCellIdType === 'string' ? correctedResponse.get_cell_output_cell_id : undefined;
    // Correct next_steps - handle string to array conversion
    if (correctedResponse.next_steps !== undefined && correctedResponse.next_steps !== null) {
        correctedResponse.next_steps = correctStringArray(correctedResponse.next_steps);
    }
    // Correct analysis_assumptions - handle string to array conversion
    if (correctedResponse.analysis_assumptions !== undefined && correctedResponse.analysis_assumptions !== null) {
        correctedResponse.analysis_assumptions = correctStringArray(correctedResponse.analysis_assumptions);
        // No empty strings in the assumptions
        correctedResponse.analysis_assumptions = (_a = correctedResponse.analysis_assumptions) === null || _a === void 0 ? void 0 : _a.filter(assumption => assumption.trim() !== '');
    }
    // For now we don't validate the cell_update object itself, as this is more complex and has 
    // not caused issues thus far.
    return correctedResponse;
}
/**
 * Corrects a value to be a string array, handling various input formats.
 * Handles cases where the AI returns a string instead of an array of strings.
 */
function correctStringArray(value) {
    // If it's already a valid array of strings, return it
    if (Array.isArray(value)) {
        return value;
    }
    if (typeof value === 'string') {
        return [value];
    }
    return undefined;
}


/***/ }),

/***/ "./lib/Extensions/AppDeploy/AppDeployPlugin.js":
/*!*****************************************************!*\
  !*** ./lib/Extensions/AppDeploy/AppDeployPlugin.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IAppDeployService: () => (/* binding */ IAppDeployService),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _websockets_appDeploy_appDeployWebsocketClient__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../websockets/appDeploy/appDeployWebsocketClient */ "./lib/websockets/appDeploy/appDeployWebsocketClient.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


/**
 * The token for the AppDeploy service.
 */
const IAppDeployService = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('mito-ai:IAppDeployService', 'Token for the AppDeploy service that provides access to the websocket client');
/**
 * Implementation of the AppDeploy service.
 */
class AppDeployService {
    /**
     * Create a new AppDeploy service.
     */
    constructor(app) {
        // Create the websocket client with the app's server settings
        this.client = new _websockets_appDeploy_appDeployWebsocketClient__WEBPACK_IMPORTED_MODULE_1__.AppDeployWebsocketClient({
            serverSettings: app.serviceManager.serverSettings
        });
        // Initialize the websocket connection in the background
        void this.client.initialize().catch(error => {
            console.error('Failed to initialize AppDeploy websocket client:', error);
            // We don't need to throw the error since the client will attempt to reconnect when used
        });
    }
}
/**
 * The AppDeploy plugin that provides the websocket client.
 */
const AppDeployPlugin = {
    id: 'mito-ai:app-deploy',
    autoStart: true,
    provides: IAppDeployService,
    activate: (app) => {
        console.log('mito-ai: AppDeployPlugin activated');
        return new AppDeployService(app);
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AppDeployPlugin);


/***/ }),

/***/ "./lib/Extensions/AppDeploy/DeployAppNotification.js":
/*!***********************************************************!*\
  !*** ./lib/Extensions/AppDeploy/DeployAppNotification.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   deployAppNotification: () => (/* binding */ deployAppNotification)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _AppManager_CheckAppStatusAPI__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../AppManager/CheckAppStatusAPI */ "./lib/Extensions/AppManager/CheckAppStatusAPI.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


const deployAppNotification = (url, appManagerService, notificationId) => {
    // Total deployment time in milliseconds (3 minutes = 180000ms)
    const totalDeploymentTime = 180000;
    // Create an array of deployment steps
    const deploymentSteps = [
        "Step 2/7: Preparing your app...",
        "Step 3/7: Assembling clouds...",
        "Step 4/7: Building your app...",
        "Step 5/7: Configuring network settings...",
        "Step 6/7: Adding final touches...",
        "Step 7/7: Running security checks...",
        "Deployment complete! Your app is ready."
    ];
    // Calculate time between steps (evenly distribute throughout the total deployment time)
    const stepInterval = totalDeploymentTime / (deploymentSteps.length - 1);
    let retryCount = 5;
    // Update message at each step interval
    for (let i = 0; i < deploymentSteps.length; i++) {
        setTimeout(() => {
            const isLastStep = i === deploymentSteps.length - 1;
            if (isLastStep) {
                const checkUrlAndUpdate = async () => {
                    if (retryCount < 0) {
                        console.log("Retries done");
                        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Notification.update({
                            id: notificationId,
                            message: "Unable to deploy. Your app is not reachable",
                            type: 'warning',
                            autoClose: false
                        });
                        return;
                    }
                    try {
                        console.log("Awaiting response");
                        const urlIsUp = await (0,_AppManager_CheckAppStatusAPI__WEBPACK_IMPORTED_MODULE_1__.checkAppStatus)(url, appManagerService);
                        console.log(`App status check result for ${url}: ${urlIsUp}`);
                        if (urlIsUp) {
                            // Update notification with the button
                            _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Notification.update({
                                id: notificationId,
                                message: deploymentSteps[i],
                                type: 'default',
                                autoClose: false,
                                actions: [
                                    {
                                        label: "Launch Application Now",
                                        displayType: 'accent',
                                        callback: () => {
                                            window.open(url, '_blank');
                                        }
                                    }
                                ]
                            });
                        }
                        else {
                            // Retry after 30s
                            console.log("In retry for url to be up");
                            retryCount = retryCount - 1;
                            setTimeout(() => void checkUrlAndUpdate(), 30000);
                        }
                    }
                    catch (error) {
                        // Retry after 30s
                        console.error("Error checking app status:", error);
                        retryCount = retryCount - 1;
                        setTimeout(() => void checkUrlAndUpdate(), 30000);
                    }
                };
                void checkUrlAndUpdate();
            }
            else {
                // Regular intermediate step
                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Notification.update({
                    id: notificationId,
                    message: deploymentSteps[i],
                    type: 'in-progress',
                    autoClose: false
                });
            }
        }, i * stepInterval);
    }
};


/***/ }),

/***/ "./lib/Extensions/AppDeploy/DeployFilesSelector.js":
/*!*********************************************************!*\
  !*** ./lib/Extensions/AppDeploy/DeployFilesSelector.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FileUploadPopup: () => (/* binding */ FileUploadPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_ConnectionForm_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../style/ConnectionForm.css */ "./style/ConnectionForm.css");
/* harmony import */ var _style_button_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../style/button.css */ "./style/button.css");
/* harmony import */ var _style_FilesSelector_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../style/FilesSelector.css */ "./style/FilesSelector.css");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */





const FileIcon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.fileIcon.react;
const FolderIcon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.folderIcon.react;
const CloseIcon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.closeIcon.react;
const FileUploadPopup = ({ filePath, onClose, onSubmit }) => {
    const [items, setItems] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    const [selectedItems, setSelectedItems] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(new Set());
    // Figure out current notebook directory
    const getNotebookDir = () => {
        if (!filePath)
            return '';
        const parts = filePath.split('/');
        parts.pop(); // remove notebook filename
        return parts.join('/');
    };
    const alwaysSelected = ['requirements.txt', 'app.py'];
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const nbDir = getNotebookDir();
        const apiPath = nbDir ? `/api/contents/${nbDir}` : '/api/contents/';
        fetch(apiPath)
            .then(res => res.json())
            .then(data => {
            const entries = data.content.map((item) => ({
                name: item.name,
                type: item.type, // "file" or "directory"
            }))
                .sort((a, b) => a.name.localeCompare(b.name));
            setItems(entries);
            // Pre-select default files
            const defaultFiles = new Set();
            entries.forEach(entry => {
                if (alwaysSelected.includes(entry.name)) {
                    defaultFiles.add(entry.name);
                }
            });
            setSelectedItems(defaultFiles);
        })
            .catch(err => console.error('Error fetching files/dirs:', err));
    }, []);
    const handleCheckboxChange = (name) => {
        setSelectedItems(prev => {
            const newSet = new Set(prev);
            if (newSet.has(name))
                newSet.delete(name);
            else
                newSet.add(name);
            return newSet;
        });
    };
    const handleSelectAll = (checked) => {
        if (checked) {
            // select all, nothing excluded
            setSelectedItems(new Set(items.map(i => i.name)));
        }
        else {
            // keep only alwaysSelected
            setSelectedItems(new Set(alwaysSelected));
        }
    };
    const handleSubmit = () => {
        const selectedPaths = Array.from(selectedItems);
        onSubmit(selectedPaths);
        onClose();
    };
    const allSelected = items.length > 0 && selectedItems.size === items.length;
    const partiallySelected = selectedItems.size > 0 && selectedItems.size < items.length;
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-overlay" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-content" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-header" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Upload files Required for the App"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: onClose, className: "modal-close-button", title: "Close" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(CloseIcon, null))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-subheader" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "modal-subtext" }, "Select the files and/or directories that are required to render the app. For example, if your app reads data from a csv file, you must select it here.")),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-body" }, items.length === 0 ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "No items found.")) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "files-selector-select-all" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { className: "checkbox-label" },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: "checkbox", checked: allSelected, ref: el => {
                                if (el)
                                    el.indeterminate = partiallySelected;
                            }, onChange: e => handleSelectAll(e.target.checked) }),
                        "Select All")),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "file-list-scrollable" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", { className: "file-list" }, items.map((item, index) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { key: index },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { className: "checkbox-label" },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: "checkbox", checked: selectedItems.has(item.name), onChange: () => handleCheckboxChange(item.name), disabled: alwaysSelected.includes(item.name), title: alwaysSelected.includes(item.name) ? "Required for deploying your app" : undefined }),
                            item.type === 'directory' ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FolderIcon, null) : react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FileIcon, null),
                            " ",
                            item.name))))))))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-footer" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "files-selector-submit-button", onClick: handleSubmit, disabled: selectedItems.size === 0 }, "Deploy App")))));
};


/***/ }),

/***/ "./lib/Extensions/AppDeploy/DeployStreamlitApp.js":
/*!********************************************************!*\
  !*** ./lib/Extensions/AppDeploy/DeployStreamlitApp.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   deployStreamlitApp: () => (/* binding */ deployStreamlitApp)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _requirementsUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./requirementsUtils */ "./lib/Extensions/AppDeploy/requirementsUtils.js");
/* harmony import */ var _fileUtils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./fileUtils */ "./lib/Extensions/AppDeploy/fileUtils.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _DeployAppNotification__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./DeployAppNotification */ "./lib/Extensions/AppDeploy/DeployAppNotification.js");
/* harmony import */ var _auth__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./auth */ "./lib/Extensions/AppDeploy/auth.js");
/* harmony import */ var _authPopupUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./authPopupUtils */ "./lib/Extensions/AppDeploy/authPopupUtils.js");
/* harmony import */ var _FilesSelectorUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./FilesSelectorUtils */ "./lib/Extensions/AppDeploy/FilesSelectorUtils.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */








/*
This function generates the requirements.txt file needed to host the streamlit app,
and deploys it!
*/
const deployStreamlitApp = async (notebookTracker, appDeployService, appManagerService) => {
    let selectedFiles = [];
    let jwtToken = await (0,_auth__WEBPACK_IMPORTED_MODULE_2__.getJWTToken)();
    if (!jwtToken) {
        // No token found, show authentication popup
        console.log('User not authenticated, redirected to signup');
        try {
            const user = await (0,_authPopupUtils__WEBPACK_IMPORTED_MODULE_3__.showAuthenticationPopup)();
            console.log('User authenticated successfully:', user);
            // Try to get the JWT token again after successful authentication
            jwtToken = await (0,_auth__WEBPACK_IMPORTED_MODULE_2__.getJWTToken)();
            if (!jwtToken) {
                console.error('JWT token still not available after authentication');
                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Notification.emit('Authentication failed - JWT token not found', 'error', {
                    autoClose: false
                });
                return;
            }
        }
        catch (error) {
            console.log('Authentication cancelled or failed:', error);
            return; // Exit early if authentication was cancelled
        }
    }
    const notebookPanel = notebookTracker.currentWidget;
    if (!notebookPanel) {
        console.error('No notebook is currently active');
        return;
    }
    const notebookPath = notebookPanel.context.path;
    const notificationId = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Notification.emit('Step 1/7: Gathering requirements...', 'in-progress', {
        autoClose: false
    });
    // Build the requirements.txt file
    const requirementsContent = await (0,_requirementsUtils__WEBPACK_IMPORTED_MODULE_4__.generateRequirementsTxt)(notebookTracker);
    // Save the files to the current directory
    await (0,_fileUtils__WEBPACK_IMPORTED_MODULE_5__.saveFileWithKernel)(notebookTracker, './requirements.txt', requirementsContent);
    try {
        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Notification.dismiss(notificationId);
        selectedFiles = await (0,_FilesSelectorUtils__WEBPACK_IMPORTED_MODULE_6__.fileSelectorPopup)(notebookPath);
    }
    catch (error) {
        console.log('File selection failed:', error);
        return;
    }
    const newNotificationId = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Notification.emit("Step 2/7: Preparing your app...", 'in-progress', {
        autoClose: false
    });
    // After building the files, we need to send a request to the backend to deploy the app
    try {
        console.log("Sending request to deploy the app");
        // Use the JWT token that was already obtained or refreshed above
        const response = await appDeployService.client.sendMessage({
            type: 'deploy-app',
            message_id: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.UUID.uuid4(),
            notebook_path: notebookPath,
            jwt_token: jwtToken,
            selected_files: selectedFiles
        });
        if (response.error) {
            _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Notification.update({
                id: newNotificationId,
                message: response.error.title,
                type: 'error',
                autoClose: false
            });
        }
        else {
            console.log("App deployment response:", response);
            const url = response.url;
            (0,_DeployAppNotification__WEBPACK_IMPORTED_MODULE_7__.deployAppNotification)(url, appManagerService, newNotificationId);
        }
    }
    catch (error) {
        // TODO: Do something with the error
        console.error("Error deploying app:", error);
    }
};


/***/ }),

/***/ "./lib/Extensions/AppDeploy/FilesSelectorUtils.js":
/*!********************************************************!*\
  !*** ./lib/Extensions/AppDeploy/FilesSelectorUtils.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fileSelectorPopup: () => (/* binding */ fileSelectorPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom/client */ "./node_modules/react-dom/client.js");
/* harmony import */ var _DeployFilesSelector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DeployFilesSelector */ "./lib/Extensions/AppDeploy/DeployFilesSelector.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */



/**
 * Shows a file selector popup
 */
const fileSelectorPopup = (notebookPath) => {
    return new Promise((resolve, reject) => {
        console.log("Starting file selector for:", notebookPath);
        // Create a container for the popup
        const popupContainer = document.createElement('div');
        popupContainer.id = 'file-selector-popup-container';
        document.body.appendChild(popupContainer);
        // Create root
        const root = (0,react_dom_client__WEBPACK_IMPORTED_MODULE_1__.createRoot)(popupContainer);
        const handleSubmit = (items) => {
            // Clean up the popup
            root.unmount();
            document.body.removeChild(popupContainer);
            resolve(items);
        };
        const handleClose = () => {
            // Clean up the popup
            root.unmount();
            document.body.removeChild(popupContainer);
            reject(new Error('File selection cancelled'));
        };
        // Render the AuthPopup
        root.render(react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DeployFilesSelector__WEBPACK_IMPORTED_MODULE_2__.FileUploadPopup, { filePath: notebookPath, onClose: handleClose, onSubmit: handleSubmit }));
    });
};


/***/ }),

/***/ "./lib/Extensions/AppDeploy/auth-popup-deploy.js":
/*!*******************************************************!*\
  !*** ./lib/Extensions/AppDeploy/auth-popup-deploy.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AuthPopup: () => (/* binding */ AuthPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui-react */ "webpack/sharing/consume/default/@aws-amplify/ui-react/@aws-amplify/ui-react");
/* harmony import */ var _aws_amplify_ui_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_aws_amplify_ui_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _aws_amplify_ui_react_styles_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react/styles.css */ "./node_modules/@aws-amplify/ui-react/dist/styles.css");
/* harmony import */ var _style_ConnectionForm_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../style/ConnectionForm.css */ "./style/ConnectionForm.css");
/* harmony import */ var _style_button_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../style/button.css */ "./style/button.css");
/* harmony import */ var _style_AuthPopup_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../style/AuthPopup.css */ "./style/AuthPopup.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
// auth-popup.tsx - Simple authentication popup with CSS-based requirements






const AuthPopup = ({ isOpen, onClose, onSuccess }) => {
    // Track if we've already called onSuccess to prevent infinite loops
    const hasCalledOnSuccess = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(false);
    // Track if we should show progress bar
    const [showProgress, setShowProgress] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(false);
    // Cleanup on unmount
    react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
        return () => {
            setShowProgress(false);
        };
    }, []);
    if (!isOpen)
        return null;
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-overlay" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-content" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-header" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Sign In / Sign Up"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: onClose, className: "modal-close-button", title: "Close" }, "\u00D7")),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_aws_amplify_ui_react__WEBPACK_IMPORTED_MODULE_1__.Authenticator, { loginMechanisms: ['email'], signUpAttributes: ['name', 'email'], formFields: {
                    signUp: {
                        name: {
                            order: 1,
                            placeholder: 'Enter your full name',
                            label: 'Full Name *',
                            required: true
                        },
                        email: {
                            order: 2,
                            placeholder: 'Enter your email address',
                            label: 'Email *'
                        },
                        password: {
                            order: 3,
                            placeholder: 'Enter your password',
                            label: 'Password *',
                            required: true
                        },
                        confirm_password: {
                            order: 4,
                            placeholder: 'Confirm your password',
                            label: 'Confirm Password *'
                        }
                    }
                } }, ({ user }) => {
                // Call onSuccess when user is authenticated, but only once and with delay
                if (user && !hasCalledOnSuccess.current) {
                    // Show the progress bar
                    setShowProgress(true);
                    // Give users time to see the success message before calling onSuccess
                    setTimeout(() => {
                        if (!hasCalledOnSuccess.current) {
                            hasCalledOnSuccess.current = true;
                            onSuccess(user);
                        }
                    }, 3000); // 3 second delay
                }
                // If user is signed in, show the welcome message
                if (user) {
                    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "welcome-message-container" },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "welcome-message-title" }, "Welcome to mito!"),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "welcome-message-description" }, "You're all set to deploy your app."),
                        showProgress && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "progress-bar-container" },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "progress-bar-fill" }))),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "progress-bar-timer" }, "Closing automatically in a few seconds...")));
                }
                // If user is not signed in, don't render anything here
                return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: 'none' } });
            }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "password-requirements" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Password Requirements:"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, "At least 8 characters long"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, "Contains at least one uppercase letter"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, "Contains at least one lowercase letter"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, "Contains at least one number"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, "Contains at least one special character"))))));
};


/***/ }),

/***/ "./lib/Extensions/AppDeploy/auth.js":
/*!******************************************!*\
  !*** ./lib/Extensions/AppDeploy/auth.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getAuthHeaders: () => (/* binding */ getAuthHeaders),
/* harmony export */   getJWTToken: () => (/* binding */ getJWTToken),
/* harmony export */   logoutAndClearJWTTokens: () => (/* binding */ logoutAndClearJWTTokens)
/* harmony export */ });
/* harmony import */ var aws_amplify_auth__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! aws-amplify/auth */ "./node_modules/@aws-amplify/core/dist/esm/singleton/apis/fetchAuthSession.mjs");
/* harmony import */ var aws_amplify_auth__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! aws-amplify/auth */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signOut.mjs");
/* harmony import */ var _aws_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./aws-config */ "./lib/Extensions/AppDeploy/aws-config.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


// Ensure Amplify is configured before any auth operations
(0,_aws_config__WEBPACK_IMPORTED_MODULE_0__.configureAmplify)();
/**
 * Get JWT token from cookies
 */
const getJWTToken = async () => {
    var _a, _b;
    try {
        const session = await (0,aws_amplify_auth__WEBPACK_IMPORTED_MODULE_1__.fetchAuthSession)();
        const accessToken = (_b = (_a = session.tokens) === null || _a === void 0 ? void 0 : _a.accessToken) === null || _b === void 0 ? void 0 : _b.toString();
        return accessToken || '';
    }
    catch (error) {
        console.error('Error getting JWT token:', error);
        return '';
    }
};
/**
 * Get authentication headers for API requests
 */
const getAuthHeaders = async () => {
    const token = await getJWTToken();
    if (token) {
        return {
            'Authorization': `Bearer ${token}`
        };
    }
    return {};
};
/**
 * Logout user and clear all AWS Amplify/Cognito localStorage items
 */
const logoutAndClearJWTTokens = async () => {
    try {
        // Sign out from AWS Cognito using Amplify
        await (0,aws_amplify_auth__WEBPACK_IMPORTED_MODULE_2__.signOut)();
        console.log('User logged out successfully');
    }
    catch (error) {
        console.error('Error during logout:', error);
        throw error;
    }
    finally {
        // Remove all keys that start with common Amplify prefixes
        const keysToRemove = [];
        for (let i = 0; i < localStorage.length; i++) {
            const key = localStorage.key(i);
            if (key && (key.startsWith('CognitoIdentityServiceProvider.'))) {
                keysToRemove.push(key);
            }
        }
        // Remove all identified keys
        keysToRemove.forEach(key => {
            localStorage.removeItem(key);
        });
        console.log('Auth tokens cleared successfully');
    }
};


/***/ }),

/***/ "./lib/Extensions/AppDeploy/authPopupUtils.js":
/*!****************************************************!*\
  !*** ./lib/Extensions/AppDeploy/authPopupUtils.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   showAuthenticationPopup: () => (/* binding */ showAuthenticationPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom/client */ "./node_modules/react-dom/client.js");
/* harmony import */ var _auth_popup_deploy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./auth-popup-deploy */ "./lib/Extensions/AppDeploy/auth-popup-deploy.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */



/**
 * Shows an authentication popup and returns a promise that resolves when authentication is successful
 */
const showAuthenticationPopup = () => {
    return new Promise((resolve, reject) => {
        // Create a container for the popup
        const popupContainer = document.createElement('div');
        popupContainer.id = 'auth-popup-container';
        document.body.appendChild(popupContainer);
        // Create root for React 18
        const root = (0,react_dom_client__WEBPACK_IMPORTED_MODULE_1__.createRoot)(popupContainer);
        const handleSuccess = (user) => {
            // Clean up the popup
            root.unmount();
            document.body.removeChild(popupContainer);
            resolve(user);
        };
        const handleClose = () => {
            // Clean up the popup
            root.unmount();
            document.body.removeChild(popupContainer);
            reject(new Error('Authentication cancelled'));
        };
        // Render the AuthPopup
        root.render(react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_auth_popup_deploy__WEBPACK_IMPORTED_MODULE_2__.AuthPopup, { isOpen: true, onSuccess: handleSuccess, onClose: handleClose }));
    });
};


/***/ }),

/***/ "./lib/Extensions/AppDeploy/aws-config.js":
/*!************************************************!*\
  !*** ./lib/Extensions/AppDeploy/aws-config.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   configureAmplify: () => (/* binding */ configureAmplify)
/* harmony export */ });
/* harmony import */ var aws_amplify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! aws-amplify */ "webpack/sharing/consume/default/aws-amplify/aws-amplify?b926");
/* harmony import */ var aws_amplify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(aws_amplify__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const userPoolIdDev = 'us-east-1_Kk0f9mOfx';
const userPoolClientIdDev = '6ara3u3l8sss738hrhbq1qtiqf';
// TODO: modify to prod user ID and client ID on after creating teh cognito resources in prod
const userPoolId = userPoolIdDev;
const userPoolClientId = userPoolClientIdDev;
const configureAmplify = () => {
    aws_amplify__WEBPACK_IMPORTED_MODULE_0__.Amplify.configure({
        Auth: {
            Cognito: {
                userPoolId: userPoolId,
                userPoolClientId: userPoolClientId,
                loginWith: {
                    email: true,
                    username: false,
                }
            },
        }
    });
    console.log('Amplify configuration loaded successfully');
};
// Configure immediately when this module is imported
configureAmplify();


/***/ }),

/***/ "./lib/Extensions/AppDeploy/fileUtils.js":
/*!***********************************************!*\
  !*** ./lib/Extensions/AppDeploy/fileUtils.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   saveFileWithKernel: () => (/* binding */ saveFileWithKernel)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
const saveFileWithKernel = async (notebookTracker, filePath, fileContent) => {
    const notebookPanel = notebookTracker.currentWidget;
    if (!notebookPanel) {
        console.error('No notebook is currently active');
        return;
    }
    try {
        // Use the kernel to execute Python code
        const session = notebookPanel.sessionContext.session;
        if (session) {
            // Escape any triple quotes in the source code
            const escapedContent = fileContent
                .replace(/\\/g, '\\\\')
                .replace(/"/g, '\\"');
            // Create Python code to save the file
            const pythonCode = `
import os

# Ensure directory exists
os.makedirs(os.path.dirname("${filePath.replace(/\\/g, '\\\\')}"), exist_ok=True)

# Save the file
with open("${filePath.replace(/\\/g, '\\\\')}", 'w') as f:
    f.write("""${escapedContent}""")

print(f"File saved successfully to ${filePath}")
        `;
            if (!session.kernel) {
                throw new Error('Kernel is not available');
            }
            // Execute the code
            const future = session.kernel.requestExecute({
                code: pythonCode,
                silent: false
            });
            // Set up handler for output
            future.onIOPub = (msg) => {
                if (msg.header.msg_type === 'stream' && msg.content.name === 'stdout') {
                    console.log('Python output:', msg.content.text);
                }
            };
            // Wait for execution to complete
            await future.done;
            console.log(`File save completed for: ${filePath}`);
        }
    }
    catch (error) {
        console.error(`Error saving file to ${filePath}:`, error);
    }
};


/***/ }),

/***/ "./lib/Extensions/AppDeploy/requirementsUtils.js":
/*!*******************************************************!*\
  !*** ./lib/Extensions/AppDeploy/requirementsUtils.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   generateRequirementsTxt: () => (/* binding */ generateRequirementsTxt)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
// Function to generate requirements.txt content using the kernel with pipreqs
const generateRequirementsTxt = async (notebookTracker) => {
    const notebookPanel = notebookTracker.currentWidget;
    if (!notebookPanel) {
        console.error('No notebook is currently active');
        return '';
    }
    // Initialize with fallback requirements in case kernel execution fails
    let requirementsContent = 'streamlit>=1.28.0';
    try {
        // Use the kernel to execute Python code using pipreqs
        const session = notebookPanel.sessionContext.session;
        if (session) {
            const appPyPath = `app.py`;
            // Create Python code to run pipreqs on the app.py file
            const pythonCode = `
import subprocess
import os

# Check if app.py exists in the notebook directory
app_py_path = os.path.join(os.getcwd(), "${appPyPath}")
if not os.path.exists(app_py_path):
    print(f"Error: app.py not found at {app_py_path}")
    exit(1)

# Make sure pipreqs is installed. Then
# 1. Create a requirements.in file
# 2. From the requirements.in file, generate the requirements.txt file with the canonical PyPI name of the packages
# and the versions as they exist on the user's terminal
try:
    # Run pipreqs on the directory containing app.py
    notebook_dir = os.path.dirname(app_py_path)
    generate_req_in_file = subprocess.run(
        ['pipreqs', '--encoding=utf-8', '--savepath', 'requirements.in', '--force', notebook_dir],
        capture_output=True, 
        text=True
    )

    print("Log: ", generate_req_in_file.stderr)

    # Read requirements.in and process each line
    requirements_in_path = os.path.join(notebook_dir, 'requirements.in')
    if os.path.exists(requirements_in_path):
        with open(requirements_in_path, 'r') as f:
            lines = f.readlines()
        
        processed_requirements = []
        for line in lines:
            line = line.strip()
            if not line:
                continue
                
            # Extract package name (everything before =)
            pkg_name = line.split('=')[0].strip()
            
            # Get package info using pip show
            try:
                result = subprocess.run(['pip', 'show', pkg_name], 
                                      capture_output=True, text=True, check=True)
                output = result.stdout
                
                # Parse the output to get Name and Version
                name = None
                version = None
                for output_line in output.split('\\n'):
                    if output_line.startswith('Name:'):
                        name = output_line.split(':', 1)[1].strip()
                    elif output_line.startswith('Version:'):
                        version = output_line.split(':', 1)[1].strip()
                
                if name and version:
                    processed_requirements.append(f"{name}=={version}")
                else:
                    processed_requirements.append(line)
            except subprocess.CalledProcessError:
                # If pip show fails, use the original line
                processed_requirements.append(line)
        
        # Print the processed requirements
        for req in processed_requirements:
            print(req)

except Exception as e:
    print(f"Error running pipreqs: {e}")
`;
            const kernel = session.kernel;
            if (kernel === null) {
                console.error('No kernel found');
                return requirementsContent;
            }
            // Execute the code and get the result
            const future = kernel.requestExecute({
                code: pythonCode,
                silent: false
            });
            // Variable to store our result
            let resultText = '';
            // Set up handler for output
            future.onIOPub = (msg) => {
                if (msg.header.msg_type === 'stream' && msg.content.name === 'stdout') {
                    const text = msg.content.text;
                    if (text.startsWith('Log: ')) {
                        console.error(text);
                    }
                    else {
                        console.log('Found dependencies:\n', text);
                        resultText += text;
                    }
                }
            };
            // Wait for execution to complete
            await future.done;
            // Check if we got a non-empty result, add it to the requirements content
            if (resultText.trim()) {
                // Replace the default with pipreqs results
                requirementsContent = resultText.trim();
                const requiredPackages = ['streamlit', 'pandas', 'matplotlib', 'snowflake-sqlalchemy'];
                // Make sure the required packages are included
                for (const requiredPackage of requiredPackages) {
                    if (!requirementsContent.includes(requiredPackage)) {
                        requirementsContent = requiredPackage + '\n' + requirementsContent;
                    }
                }
            }
        }
    }
    catch (error) {
        console.error('Error generating requirements.txt:', error);
        // Keep using our fallback list
    }
    return requirementsContent;
};


/***/ }),

/***/ "./lib/Extensions/AppManager/AppsList.js":
/*!***********************************************!*\
  !*** ./lib/Extensions/AppManager/AppsList.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppsList: () => (/* binding */ AppsList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _AppDeploy_auth__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../AppDeploy/auth */ "./lib/Extensions/AppDeploy/auth.js");
/* harmony import */ var _ListAppsAPI__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ListAppsAPI */ "./lib/Extensions/AppManager/ListAppsAPI.js");
/* harmony import */ var _style_AppsList_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../style/AppsList.css */ "./style/AppsList.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
//app-list.tsx





const AppsList = ({ appManagerService }) => {
    const [apps, setApps] = react__WEBPACK_IMPORTED_MODULE_0__.useState([]);
    const [loading, setLoading] = react__WEBPACK_IMPORTED_MODULE_0__.useState(true);
    const [error, setError] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);
    // Fetch apps on component mount
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        const loadApps = async () => {
            try {
                console.log('[AppsList] Starting to load apps...');
                setLoading(true);
                setError(null);
                console.log('[AppsList] Calling fetchUserApps...');
                const response = await (0,_ListAppsAPI__WEBPACK_IMPORTED_MODULE_3__.fetchUserApps)(appManagerService);
                console.log('[AppsList] fetchUserApps response:', response);
                if ((0,_ListAppsAPI__WEBPACK_IMPORTED_MODULE_3__.isGetAppsSuccess)(response)) {
                    setApps(response.apps);
                }
                else {
                    setError(response.errorMessage || 'Failed to load apps');
                    setApps([]);
                }
            }
            catch (err) {
                console.error('[AppsList] Error loading apps:', err);
                setError(err instanceof Error ? err.message : 'An unexpected error occurred');
                setApps([]);
            }
            finally {
                setLoading(false);
            }
        };
        console.log('[AppsList] Component mounted, calling loadApps...');
        void loadApps();
    }, [appManagerService]);
    const refreshApps = async () => {
        const response = await (0,_ListAppsAPI__WEBPACK_IMPORTED_MODULE_3__.fetchUserApps)(appManagerService);
        if ((0,_ListAppsAPI__WEBPACK_IMPORTED_MODULE_3__.isGetAppsSuccess)(response)) {
            setApps(response.apps);
            setError(null);
        }
        else {
            setError(response.errorMessage || 'Failed to refresh apps');
        }
    };
    const copyToClipboard = async (url, appName) => {
        try {
            await navigator.clipboard.writeText(url);
            console.log(`Copied URL for ${appName}: ${url}`);
        }
        catch (err) {
            console.error('Failed to copy URL:', err);
            // Fallback for older browsers
            const textArea = document.createElement('textarea');
            textArea.value = url;
            document.body.appendChild(textArea);
            textArea.select();
            document.execCommand('copy');
            document.body.removeChild(textArea);
        }
    };
    const getStatusColor = (status) => {
        switch (status) {
            case 'active':
                return '#4caf50';
            case 'error':
                return '#f44336';
            case 'deploying':
                return '#2196f3';
            case 'shut down':
                return '#9e9e9e';
            default:
                return '#9e9e9e';
        }
    };
    const getStatusText = (status) => {
        return status.charAt(0).toUpperCase() + status.slice(1);
    };
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "apps-list-container" },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "apps-list-header" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("h3", { className: "apps-list-title" }, "Your Apps"),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "apps-list-actions" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", { onClick: refreshApps, disabled: loading, className: "apps-list-button", title: "Refresh apps" }, loading ? 'Loading...' : 'Refresh'),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", { onClick: () => {
                        console.log('Logout clicked');
                        void (0,_AppDeploy_auth__WEBPACK_IMPORTED_MODULE_4__.logoutAndClearJWTTokens)();
                    }, className: "apps-list-button", title: "Logout" }, "Logout"))),
        loading ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "apps-list-loading" }, "Loading apps...")) : error ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "apps-list-error" },
            "Error: ",
            error,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "apps-list-error-actions" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", { onClick: refreshApps, className: "apps-list-button primary" }, "Try Again")))) : apps.length === 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "apps-list-empty" }, "No apps deployed yet")) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, apps.map((app) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { key: app.name, className: "app-item" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "app-item-header" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "app-item-content" },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "app-item-name" }, app.name),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "app-item-status-container" },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: "app-item-status-indicator", style: { backgroundColor: getStatusColor(app.status) } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: "app-item-status-text" }, getStatusText(app.status))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "app-item-last-deployed" },
                        "Last Deployed at: ",
                        app.lastDeployedAt))),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "app-item-url-container" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "app-item-url" }, app.url),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", { onClick: () => copyToClipboard(app.url, app.name), className: "app-item-copy-button", title: `Copy URL for ${app.name}` },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.copyIcon.react, { width: "14px", height: "14px", fill: "var(--jp-ui-font-color2)" }))))))))));
};


/***/ }),

/***/ "./lib/Extensions/AppManager/CheckAppStatusAPI.js":
/*!********************************************************!*\
  !*** ./lib/Extensions/AppManager/CheckAppStatusAPI.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkAppStatus: () => (/* binding */ checkAppStatus)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
/**
 * Check if an app URL is accessible through the backend.
 */
const checkAppStatus = async (appUrl, appManagerService) => {
    try {
        // Create the request message with proper typing
        const request = {
            type: 'check-app-status',
            app_url: appUrl
        };
        // Using websocket service
        const response = await appManagerService.client.sendMessage(request);
        // Check if the response indicates an error
        if (response.error) {
            console.error('Error checking app status:', response.error.title);
            return false;
        }
        console.log('App is accessible:', response.is_accessible);
        return response.is_accessible;
    }
    catch (error) {
        console.error('Error checking app status:', error);
        return false;
    }
};


/***/ }),

/***/ "./lib/Extensions/AppManager/ListAppsAPI.js":
/*!**************************************************!*\
  !*** ./lib/Extensions/AppManager/ListAppsAPI.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fetchUserApps: () => (/* binding */ fetchUserApps),
/* harmony export */   isGetAppsFailure: () => (/* binding */ isGetAppsFailure),
/* harmony export */   isGetAppsSuccess: () => (/* binding */ isGetAppsSuccess)
/* harmony export */ });
/* harmony import */ var _AppDeploy_auth__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../AppDeploy/auth */ "./lib/Extensions/AppDeploy/auth.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

// Type guards for working with the discriminated union
const isGetAppsSuccess = (response) => {
    return response.success === true;
};
const isGetAppsFailure = (response) => {
    return response.success === false;
};
const fetchUserApps = async (appManagerService) => {
    try {
        const jwtToken = await (0,_AppDeploy_auth__WEBPACK_IMPORTED_MODULE_0__.getJWTToken)();
        if (!jwtToken) {
            return {
                success: false,
                errorMessage: 'User not authenticated'
            };
        }
        // Create the request message with proper typing
        const request = {
            type: 'manage-app',
            jwt_token: jwtToken
        };
        // Using websocket service with correct message structure and proper typing
        const response = await appManagerService.client.sendMessage(request);
        // Check if the response indicates an error
        if (response.error) {
            return {
                success: false,
                errorMessage: response.error.title || 'Failed to fetch apps'
            };
        }
        // Transform the response to match expected format
        const apps = (response.apps || []).map(app => {
            var _a;
            return ({
                name: app.app_name,
                url: app.url,
                status: (_a = app.status) === null || _a === void 0 ? void 0 : _a.toLowerCase(),
                lastDeployedAt: app.last_deployed_at
            });
        });
        return {
            success: true,
            apps
        };
    }
    catch (error) {
        console.error('Error fetching apps:', error);
        return {
            success: false,
            errorMessage: error instanceof Error ? error.message : 'Failed to fetch apps'
        };
    }
};


/***/ }),

/***/ "./lib/Extensions/AppManager/ManageAppsPlugin.js":
/*!*******************************************************!*\
  !*** ./lib/Extensions/AppManager/ManageAppsPlugin.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IAppManagerService: () => (/* binding */ IAppManagerService),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _AppsList__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./AppsList */ "./lib/Extensions/AppManager/AppsList.js");
/* harmony import */ var _websockets_appManager_appManagerWebsocketClient__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../websockets/appManager/appManagerWebsocketClient */ "./lib/websockets/appManager/appManagerWebsocketClient.js");
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */






/**
 * The token for the AppManager service.
 */
const IAppManagerService = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.Token('mito-ai:IAppManagerService', 'Token for the AppManager service that provides access to the websocket client');
/**
 * Implementation of the AppManager service.
 */
class AppManagerService {
    /**
     * Create a new AppManager service.
     */
    constructor(app) {
        // Create the websocket client with the app's server settings
        this.client = new _websockets_appManager_appManagerWebsocketClient__WEBPACK_IMPORTED_MODULE_3__.AppManagerWebsocketClient({
            serverSettings: app.serviceManager.serverSettings
        });
        // Initialize the websocket connection in the background
        void this.client.initialize().catch(error => {
            console.error('Failed to initialize AppManager websocket client:', error);
            // We don't need to throw the error since the client will attempt to reconnect when used
        });
    }
}
class ManageAppsWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.ReactWidget {
    constructor(appManagerService) {
        super();
        this._appManagerService = appManagerService;
    }
    render() {
        // Pass the appManagerService as a prop to the AppsList component
        return react__WEBPACK_IMPORTED_MODULE_2__.createElement(_AppsList__WEBPACK_IMPORTED_MODULE_4__.AppsList, {
            appManagerService: this._appManagerService
        });
    }
}
const ManageAppsPlugin = {
    id: 'manage-apps:manage-app-plugin',
    autoStart: true,
    provides: IAppManagerService,
    activate: (app) => {
        console.log('ManageApps plugin activated');
        // Create the AppManager service
        const appManagerService = new AppManagerService(app);
        // Create and add the ManageApps widget
        const widget = new ManageAppsWidget(appManagerService);
        widget.title.label = 'Manage apps';
        widget.id = 'manage-apps-widget';
        // For now, only show the manage apps widget if beta mode is enabled
        (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_5__.getSetting)('beta_mode').then(value => {
            if (value === 'true') {
                // Add to right sidebar
                app.shell.add(widget, 'right');
            }
        }).catch(error => {
            console.error('Error checking beta mode:', error);
        });
        // Return the service so other plugins can use it
        return appManagerService;
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ManageAppsPlugin);


/***/ }),

/***/ "./lib/Extensions/AppPreview/StreamlitPreviewPlugin.js":
/*!*************************************************************!*\
  !*** ./lib/Extensions/AppPreview/StreamlitPreviewPlugin.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/* harmony import */ var _AppDeploy_DeployStreamlitApp__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../AppDeploy/DeployStreamlitApp */ "./lib/Extensions/AppDeploy/DeployStreamlitApp.js");
/* harmony import */ var _AppDeploy_AppDeployPlugin__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../AppDeploy/AppDeployPlugin */ "./lib/Extensions/AppDeploy/AppDeployPlugin.js");
/* harmony import */ var _AppManager_ManageAppsPlugin__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../AppManager/ManageAppsPlugin */ "./lib/Extensions/AppManager/ManageAppsPlugin.js");
/* harmony import */ var _commands__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../commands */ "./lib/commands.js");
/* harmony import */ var _icons__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../icons */ "./lib/icons/index.js");
/* harmony import */ var _style_StreamlitPreviewPlugin_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../style/StreamlitPreviewPlugin.css */ "./style/StreamlitPreviewPlugin.css");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./utils */ "./lib/Extensions/AppPreview/utils.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _UpdateAppDropdown__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./UpdateAppDropdown */ "./lib/Extensions/AppPreview/UpdateAppDropdown.js");
/* harmony import */ var react_dom_client__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-dom/client */ "./node_modules/react-dom/client.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


















/**
 * Simple HTML widget for displaying iframe content.
 */
class IFrameWidget extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_3__.Widget {
    constructor(url) {
        super();
        this.addClass('jp-iframe-widget');
        const iframe = document.createElement('iframe');
        iframe.src = url;
        iframe.style.width = '100%';
        iframe.style.height = '100%';
        iframe.style.border = 'none';
        this.node.appendChild(iframe);
    }
    setUrl(url) {
        const iframe = this.node.querySelector('iframe');
        if (iframe) {
            iframe.src = url;
        }
    }
}
async function showRecreateAppConfirmation(notebookPath) {
    const result = await (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.showDialog)({
        title: 'Recreate App',
        body: 'This will recreate the app from scratch, discarding all your current edits. This action cannot be undone. Are you sure you want to continue?',
        buttons: [
            _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Dialog.cancelButton({ label: 'Cancel' }),
            _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Dialog.warnButton({ label: 'Recreate App' })
        ],
        defaultButton: 1
    });
    if (result.button.accept) {
        void (0,_utils__WEBPACK_IMPORTED_MODULE_7__.startStreamlitPreviewAndNotify)(notebookPath, true, undefined, 'Recreating app from scratch...', 'App recreated successfully!');
    }
}
/**
 * Show the update app dropdown.
 */
function showUpdateAppDropdown(buttonElement, notebookPath) {
    // Remove any existing dropdown
    const existingDropdown = document.querySelector('.update-app-dropdown');
    if (existingDropdown) {
        existingDropdown.remove();
    }
    // Create dropdown container
    const dropdownContainer = document.createElement('div');
    dropdownContainer.className = 'update-app-dropdown';
    dropdownContainer.style.position = 'absolute';
    dropdownContainer.style.zIndex = '1000';
    // Position the dropdown below the button
    const buttonRect = buttonElement.getBoundingClientRect();
    dropdownContainer.style.top = `${buttonRect.bottom + 4}px`;
    dropdownContainer.style.left = `${buttonRect.left}px`;
    // Add to document
    document.body.appendChild(dropdownContainer);
    // Render the React component
    (0,react_dom_client__WEBPACK_IMPORTED_MODULE_6__.createRoot)(dropdownContainer).render(react__WEBPACK_IMPORTED_MODULE_5__.createElement(_UpdateAppDropdown__WEBPACK_IMPORTED_MODULE_8__["default"], { onSubmit: async (message) => {
            await (0,_utils__WEBPACK_IMPORTED_MODULE_7__.startStreamlitPreviewAndNotify)(notebookPath, true, message, 'Updating app...', 'App updated successfully!');
            dropdownContainer.remove();
        }, onClose: () => {
            dropdownContainer.remove();
        } }));
    // Close dropdown when clicking outside
    const handleClickOutside = (event) => {
        if (!dropdownContainer.contains(event.target) &&
            !buttonElement.contains(event.target)) {
            dropdownContainer.remove();
            document.removeEventListener('mousedown', handleClickOutside);
        }
    };
    // Add click outside listener after a small delay to avoid immediate closure
    setTimeout(() => {
        document.addEventListener('mousedown', handleClickOutside);
    }, 100);
}
/**
 * The streamlit preview plugin.
 */
const StreamlitPreviewPlugin = {
    id: 'mito-ai:streamlit-preview',
    autoStart: true,
    requires: [_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.INotebookTracker, _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ICommandPalette, _AppDeploy_AppDeployPlugin__WEBPACK_IMPORTED_MODULE_9__.IAppDeployService, _AppManager_ManageAppsPlugin__WEBPACK_IMPORTED_MODULE_10__.IAppManagerService],
    activate: (app, notebookTracker, palette, appDeployService, appManagerService) => {
        console.log('mito-ai: StreamlitPreviewPlugin activated');
        // Add command to command palette
        app.commands.addCommand(_commands__WEBPACK_IMPORTED_MODULE_11__.COMMAND_MITO_AI_PREVIEW_AS_STREAMLIT, {
            label: 'Preview as Streamlit',
            caption: 'Convert current notebook to Streamlit app and preview it',
            execute: async () => {
                await previewNotebookAsStreamlit(app, notebookTracker, appDeployService, appManagerService);
            }
        });
        // Add to command palette
        palette.addItem({
            command: _commands__WEBPACK_IMPORTED_MODULE_11__.COMMAND_MITO_AI_PREVIEW_AS_STREAMLIT,
            category: 'Mito AI'
        });
    }
};
/**
 * Preview the current notebook as a Streamlit app.
 */
async function previewNotebookAsStreamlit(app, notebookTracker, appDeployService, appManagerService) {
    const notebookPanel = notebookTracker.currentWidget;
    if (!notebookPanel) {
        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Notification.error('No notebook is currently active');
        return;
    }
    // First save the notebook to ensure the app is up to date
    await notebookPanel.context.save();
    const notebookPath = notebookPanel.context.path;
    const notebookName = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__.PathExt.basename(notebookPath, '.ipynb');
    try {
        const previewData = await (0,_utils__WEBPACK_IMPORTED_MODULE_7__.startStreamlitPreviewAndNotify)(notebookPath);
        if (previewData === undefined) {
            return;
        }
        // Create iframe widget
        // TODO: Instead of having this widget creation code in the previewNotebookAsStreamlit function, 
        // I wonder if we can make it part of the StreamlitPreviewPlugin. What we want is the following: 
        // a react component that takes the app, notebookTracker, and appDeployService as a prop and is 
        // already set up with this layout. Each time it opens, we're just deciding which notebook to display.
        const iframeWidget = new IFrameWidget(previewData.url);
        // Create main area widget
        const widget = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.MainAreaWidget({ content: iframeWidget });
        widget.title.label = `App Preview (${notebookName})`;
        widget.title.closable = true;
        /* ******************************************************
         * Create Streamlit App Toolbar Buttons
         ****************************************************** */
        const editAppButton = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ToolbarButton({
            className: 'text-button-mito-ai button-base button-small jp-ToolbarButton mito-deploy-button',
            onClick: () => {
                showUpdateAppDropdown(editAppButton.node, notebookPath);
            },
            tooltip: 'Edit Streamlit App',
            label: 'Edit App',
            icon: _icons__WEBPACK_IMPORTED_MODULE_12__.EditLabIcon,
            iconClass: 'mito-ai-deploy-icon'
        });
        const recreateAppButton = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ToolbarButton({
            className: 'text-button-mito-ai button-base button-small jp-ToolbarButton mito-deploy-button',
            onClick: async () => {
                await showRecreateAppConfirmation(notebookPath);
            },
            tooltip: 'Recreate new App from scratch based on the current state of the notebook',
            label: 'Recreate App',
            icon: _icons__WEBPACK_IMPORTED_MODULE_12__.ResetCircleLabIcon,
            iconClass: 'mito-ai-deploy-icon'
        });
        const deployButton = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ToolbarButton({
            className: 'text-button-mito-ai button-base button-small jp-ToolbarButton mito-deploy-button',
            onClick: () => {
                void (0,_AppDeploy_DeployStreamlitApp__WEBPACK_IMPORTED_MODULE_13__.deployStreamlitApp)(notebookTracker, appDeployService, appManagerService);
            },
            tooltip: 'Deploy Streamlit App',
            label: 'Deploy App',
            icon: _icons__WEBPACK_IMPORTED_MODULE_12__.DeployLabIcon,
            iconClass: 'mito-ai-deploy-icon'
        });
        // Insert the button into the toolbar
        widget.toolbar.insertAfter('spacer', 'edit-app-button', editAppButton);
        widget.toolbar.insertAfter('edit-app-button', 'recreate-app-button', recreateAppButton);
        widget.toolbar.insertAfter('recreate-app-button', 'deploy-app-button', deployButton);
        // Handle widget disposal
        widget.disposed.connect(() => {
            console.log('Widget disposed, stopping preview');
            void (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_14__.stopStreamlitPreview)(previewData.id);
        });
        // Add widget to main area with split-right mode
        app.shell.add(widget, 'main', {
            mode: 'split-right',
            ref: notebookPanel.id
        });
    }
    catch (error) {
        console.error('Error starting streamlit preview:', error);
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StreamlitPreviewPlugin);


/***/ }),

/***/ "./lib/Extensions/AppPreview/UpdateAppDropdown.js":
/*!********************************************************!*\
  !*** ./lib/Extensions/AppPreview/UpdateAppDropdown.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_EditAppDropdown_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../style/EditAppDropdown.css */ "./style/EditAppDropdown.css");
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/classNames */ "./lib/utils/classNames.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */



const UpdateAppDropdown = ({ onSubmit, onClose }) => {
    const [message, setMessage] = react__WEBPACK_IMPORTED_MODULE_0___default().useState('');
    const handleSubmit = () => {
        if (message.trim()) {
            onSubmit(message);
            onClose();
        }
    };
    const handleKeyDown = (e) => {
        if (e.key === 'Escape') {
            onClose();
        }
    };
    const disabled = message.trim() === '';
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "update-app-dropdown", onKeyDown: handleKeyDown },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "update-app-dropdown-content" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { htmlFor: "update-description", className: "update-app-dropdown-label" }, "How would you like to modify the app?"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("textarea", { id: "update-description", value: message, onChange: (e) => setMessage(e.target.value), placeholder: "Describe your changes (e.g., Change the title, Remove a plot, etc.)", className: "update-app-dropdown-textarea", autoFocus: true }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "update-app-dropdown-buttons" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: onClose, className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_2__.classNames)("update-app-dropdown-button", "update-app-dropdown-button-cancel") }, "Cancel"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: handleSubmit, disabled: disabled, className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_2__.classNames)('update-app-dropdown-button', 'update-app-dropdown-button-submit', { 'disabled': disabled }) }, "Submit")))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UpdateAppDropdown);


/***/ }),

/***/ "./lib/Extensions/AppPreview/utils.js":
/*!********************************************!*\
  !*** ./lib/Extensions/AppPreview/utils.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   startStreamlitPreviewAndNotify: () => (/* binding */ startStreamlitPreviewAndNotify)
/* harmony export */ });
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


const startStreamlitPreviewAndNotify = async (notebookPath, force_recreate = false, edit_prompt = '', start_notification_message = 'Building App Preview...', success_notification_message = 'Streamlit preview started successfully!') => {
    const notificationId = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Notification.emit(start_notification_message, 'in-progress', { autoClose: false });
    try {
        const previewData = await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__.startStreamlitPreview)(notebookPath, force_recreate, edit_prompt);
        // Update notification to success
        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Notification.update({
            id: notificationId,
            message: success_notification_message,
            type: 'success',
            autoClose: 5 * 1000
        });
        return previewData;
    }
    catch (error) {
        // Display error notification
        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Notification.update({
            id: notificationId,
            message: "Failed to start app preview: " + String(error),
            type: 'error',
            autoClose: 5 * 1000
        });
        return undefined;
    }
};


/***/ }),

/***/ "./lib/Extensions/ContextManager/ContextManagerPlugin.js":
/*!***************************************************************!*\
  !*** ./lib/Extensions/ContextManager/ContextManagerPlugin.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ContextManager: () => (/* binding */ ContextManager),
/* harmony export */   ContextManagerPlugin: () => (/* binding */ ContextManagerPlugin),
/* harmony export */   IContextManager: () => (/* binding */ IContextManager),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _VariableInspector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./VariableInspector */ "./lib/Extensions/ContextManager/VariableInspector.js");
/* harmony import */ var _FileInspector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FileInspector */ "./lib/Extensions/ContextManager/FileInspector.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




// The provides field in JupyterLab's JupyterFrontEndPlugin expects a token 
// that can be used to look up the service in the dependency injection system,
// so we define a new token for the ContextManager
const IContextManager = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.Token('mito-ai:IContextManager');
class ContextManager {
    constructor(app, notebookTracker) {
        this.notebookContexts = new Map();
        this._startKernelListener = async (app, notebookPanel) => {
            if (notebookPanel === null) {
                return;
            }
            // Initialize context for this notebook if it doesn't exist
            if (!this.notebookContexts.has(notebookPanel.id)) {
                this.notebookContexts.set(notebookPanel.id, { variables: [], files: [] });
            }
            // As soon as the notebook is opened, fetch the files since these are not related to the kernel, 
            // but to the notebook itself. This is useful so we can tell the agent which files are available 
            // or let the user select a file from the dropdown menu before the kernel is started.
            // We use the notebookPanel.id to identify the notebook because we might need to access
            // NotebookContext even before the kernel is started. For example, to figure out 
            // which files are available.
            const updatedFiles = await (0,_FileInspector__WEBPACK_IMPORTED_MODULE_2__.getFiles)(app, notebookPanel);
            this.updateNotebookFiles(notebookPanel.id, updatedFiles);
            // Listen for kernel restart or shut down events and clear the variables for this notebook
            notebookPanel.context.sessionContext.statusChanged.connect((sender, status) => {
                if (status === 'restarting' || status === 'terminating' || status === 'unknown') {
                    // Clear the variables for this specific notebook, but don't clear the files 
                    // as they have not changed.
                    this.updateNotebookVariables(notebookPanel.id, []); // Clear variables for this specific notebook
                }
            });
            // Listen to kernel messages
            notebookPanel.context.sessionContext.iopubMessage.connect(async (sender, msg) => {
                // Watch for execute_input messages, which indicate is a request to execute code. 
                // Previosuly, we watched for 'execute_result' messages, but these are only returned
                // from the kernel when a code cell prints a value to the output cell, which is not what we want.
                // TODO: Check if there is a race condition where we might end up fetching variables before the 
                // code is executed. I don't think this is the case because the kernel runs in one thread I believe.
                // TODO: Eventually we should create a document manager listener so if the user uploads a new file
                // to jupyter, we can update the available files even if they have not executed a kernel message.
                if (msg.header.msg_type === 'execute_input') {
                    void (0,_VariableInspector__WEBPACK_IMPORTED_MODULE_3__.fetchVariablesAndUpdateState)(notebookPanel, this.updateNotebookVariables.bind(this, notebookPanel.id));
                    const updatedFiles = await (0,_FileInspector__WEBPACK_IMPORTED_MODULE_2__.getFiles)(app, notebookPanel);
                    this.updateNotebookFiles(notebookPanel.id, updatedFiles);
                }
            });
        };
        this.notebookTracker = notebookTracker;
        // Setup the kernel listener to update context as kernel messages are received
        this.setupKernelListener(app, notebookTracker);
    }
    getNotebookContext(notebookId) {
        return this.notebookContexts.get(notebookId);
    }
    getActiveNotebookContext() {
        const activeNotebook = this.notebookTracker.currentWidget;
        if (!activeNotebook)
            return undefined;
        return this.getNotebookContext(activeNotebook.id);
    }
    updateNotebookVariables(notebookID, variables) {
        const context = this.notebookContexts.get(notebookID) || { variables: [], files: [] };
        context.variables = variables;
        this.notebookContexts.set(notebookID, context);
    }
    updateNotebookFiles(notebookID, files) {
        const context = this.notebookContexts.get(notebookID) || { variables: [], files: [] };
        context.files = files;
        this.notebookContexts.set(notebookID, context);
    }
    // Setup kernel execution listener
    setupKernelListener(app, notebookTracker) {
        // Start the kernel listener for the currently active notebook
        const notebookPanel = notebookTracker.currentWidget;
        void this._startKernelListener(app, notebookPanel);
        // Update the kernel listener whenever the active notebook changes
        notebookTracker.currentChanged.connect(async (_, notebookPanel) => {
            void this._startKernelListener(app, notebookPanel);
        });
    }
}
const ContextManagerPlugin = {
    id: 'mito-ai:context-manager',
    autoStart: true,
    requires: [_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.INotebookTracker],
    provides: IContextManager,
    activate: (app, notebookTracker) => {
        console.log("mito-ai: ContextManagerPlugin activated");
        return new ContextManager(app, notebookTracker);
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ContextManagerPlugin);


/***/ }),

/***/ "./lib/Extensions/ContextManager/FileInspector.js":
/*!********************************************************!*\
  !*** ./lib/Extensions/ContextManager/FileInspector.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFiles: () => (/* binding */ getFiles)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/*
    Fetches all files in the current directory and updates the state of the files.
*/
const getFiles = async (app, notebookPanel) => {
    const fileManager = app.serviceManager.contents;
    const relativeNotebookPath = notebookPanel.context.path;
    const relativeDirectoryPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.dirname(relativeNotebookPath);
    try {
        const contents = await fileManager.get(relativeDirectoryPath);
        if (contents.type === 'directory') {
            // Filter for only csv and Excel files
            const data_files = contents.content.filter((file) => {
                var _a;
                const extension = (_a = file.name.split('.').pop()) === null || _a === void 0 ? void 0 : _a.toLowerCase();
                return extension === 'csv' ||
                    extension === 'xlsx' ||
                    extension === 'xls' ||
                    extension === 'xlsm';
            });
            // Map the files to the File type
            const files = data_files.map((file) => ({
                file_name: file.name
            }));
            // Update the state of the files
            return files;
        }
        else {
            // If the contents are not a directory, set the files to an empty array
            return [];
        }
    }
    catch (error) {
        console.error('Error listing directory contents:', error);
        return [];
    }
};


/***/ }),

/***/ "./lib/Extensions/ContextManager/VariableInspector.js":
/*!************************************************************!*\
  !*** ./lib/Extensions/ContextManager/VariableInspector.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fetchVariablesAndUpdateState: () => (/* binding */ fetchVariablesAndUpdateState)
/* harmony export */ });
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

// TODO: Use something like raw-loader to load an actual python file 
// to make it easier to modify the script without creating syntax errors.
const pythonVariableInspectionScript = `import json
import inspect


# We need to check if pandas is imported so we know if its safe
# to check for pandas dataframes 
_is_pandas_imported = False
try:
    import pandas as pd
    _is_pandas_imported = True
except:
    pass

# Function to convert dataframe to structured format
def get_dataframe_structure(df, sample_size=5):
    def convert_value(value):
        if pd.isna(value):
            # Handle None and NaN (convert to None, which maps to null in JSON)
            return None
        elif not isinstance(value, (str, int, float, bool, type(None))):
            value_str = str(value)
            if len(value_str) > 50:
                return value_str[:50] + "..."
            return value_str
        elif isinstance(value, str) and len(value) > 50:
            # Truncate strings longer than 50 characters
            return value[:50] + "..."
        return value 
        
    structure = {}
    for column in df.columns:
        structure[column] = {
            "dtype": str(df[column].dtype),
            "samples": [convert_value(x) for x in df[column].head(sample_size)]
        }
    return structure

def is_from_mitosheet(obj):
    """Check if an object is from any mitosheet module"""
    try:
        module = inspect.getmodule(obj)
        if module and (module.__name__.startswith('mitosheet')):
            return True

        # if the dictionary contains all of the mito functions, then we can assume that the object is from mitosheet
        mito_functions = ["STRIPTIMETOMONTHS", "GETNEXTVALUE", "FILLNAN"]
        if isinstance(obj, dict) and all(key in obj for key in mito_functions):
            return True


    except Exception:
        return False
    return False

def structured_globals():
    output = []
    for k, v in globals().items():

        # Skip mitosheet functions
        if is_from_mitosheet(v):
            continue

        if not k.startswith("_") and k not in ("In", "Out", "json") and not callable(v):
            
            if _is_pandas_imported and isinstance(v, pd.DataFrame):

                new_variable = {
                    "variable_name": k,
                    "type": "pd.DataFrame",
                    "value": get_dataframe_structure(v)
                }

                try:
                    # Check if the variable can be converted to JSON.
                    # If it can, add it to the outputs. If it can't, we just skip it.
                    # We check each variable individually so that we don't crash
                    # the entire variable inspection if just one variable cannot be serialized.
                    json.dumps(new_variable["value"])
                    output.append(new_variable)
                except:
                    pass

            else:

                max_value_length = 4000 # This is roughly 1000 tokens in the LLM
                truncated_value = str(repr(v))  # Force to string

                if len(truncated_value) > max_value_length:
                    split_length = max_value_length // 2
                    truncated_value = truncated_value[:split_length] + '... <middle of value truncated> ...' + truncated_value[-split_length:]

                new_variable = {
                    "variable_name": k,
                    "type": str(type(v)),
                    "value": truncated_value
                }

                try:
                    # Check if the variable can be converted to JSON.
                    # If it can, add it to the outputs. If it can't, we just skip it.
                    # We check each variable individually so that we don't crash
                    # the entire variable inspection if just one variable cannot be serialized.
                    json.dumps(new_variable["value"])
                    output.append(new_variable)
                except:
                    pass

    return json.dumps(output)

print(structured_globals())
`;
/*
Function to fetch variables and sync with the frontend
*/
function fetchVariablesAndUpdateState(notebookPanel, setVariables) {
    var _a;
    const kernel = (_a = notebookPanel.context.sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel;
    if (kernel) {
        // Request the kernel to execute a command to fetch global variables
        const future = kernel.requestExecute({
            code: pythonVariableInspectionScript,
            // Adding silent: true prevents a execute_input message from being sent. This is important 
            // because it prevents an infinite loop where we fetch variables and in the process trigger 
            // a new execute_input which leads to fetching variables again.
            silent: true
        });
        // Listen for the output from the kernel
        future.onIOPub = (msg) => {
            // A 'stream' message represents standard output (stdout) or standard error (stderr) produced 
            // during the execution of code in the kernel. 
            if (_jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.KernelMessage.isStreamMsg(msg)) {
                if (msg.content.name === 'stdout') {
                    try {
                        setVariables(JSON.parse(msg.content.text));
                    }
                    catch (e) {
                        console.log("Error parsing variables", e);
                    }
                }
            }
        };
    }
}


/***/ }),

/***/ "./lib/Extensions/ErrorMimeRenderer/CollapsibleWarningBlock.js":
/*!*********************************************************************!*\
  !*** ./lib/Extensions/ErrorMimeRenderer/CollapsibleWarningBlock.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CollapsibleWarningBlock: () => (/* binding */ CollapsibleWarningBlock)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const CollapsibleWarningBlock = ({ message }) => {
    const [isExpanded, setIsExpanded] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const lines = message.split('\n');
    const warningCount = lines.filter(line => line.includes("Warning: ")).length;
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "output-block" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { style: { display: 'flex', alignItems: 'center', gap: '8px', cursor: 'pointer' }, onClick: () => setIsExpanded(!isExpanded) },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "collapse-button" }, isExpanded ? '▼' : '▶'),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("pre", { style: { margin: 0, display: 'inline' } },
                "Warning (",
                warningCount,
                ")")),
        isExpanded &&
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "output-block-expanded" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("pre", { style: { marginTop: '10px' } }, message))));
};


/***/ }),

/***/ "./lib/Extensions/ErrorMimeRenderer/ErrorMimeRendererPlugin.js":
/*!*********************************************************************!*\
  !*** ./lib/Extensions/ErrorMimeRenderer/ErrorMimeRendererPlugin.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom/client */ "./node_modules/react-dom/client.js");
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/rendermime */ "webpack/sharing/consume/default/@jupyterlab/rendermime");
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _commands__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../commands */ "./lib/commands.js");
/* harmony import */ var _icons_MagicWand__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../icons/MagicWand */ "./lib/icons/MagicWand.js");
/* harmony import */ var _style_ErrorMimeRendererPlugin_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../style/ErrorMimeRendererPlugin.css */ "./style/ErrorMimeRendererPlugin.css");
/* harmony import */ var _CollapsibleWarningBlock__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./CollapsibleWarningBlock */ "./lib/Extensions/ErrorMimeRenderer/CollapsibleWarningBlock.js");
/* harmony import */ var _errorUtils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./errorUtils */ "./lib/Extensions/ErrorMimeRenderer/errorUtils.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */









const ErrorMessage = ({ onDebugClick }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "error-mime-renderer-container" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: onDebugClick, className: 'error-mime-renderer-button' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_MagicWand__WEBPACK_IMPORTED_MODULE_5__["default"], null),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Fix Error in AI Chat"))));
};
/**
 * A mime renderer plugin for the mimetype application/vnd.jupyter.stderr
 *
 * This plugin augments the standard error output with a prompt to debug the error in the chat interface.
*/
const ErrorMimeRendererPlugin = {
    id: 'mito-ai:debug-error-with-ai',
    autoStart: true,
    requires: [_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_2__.IRenderMimeRegistry],
    activate: (app, rendermime) => {
        const factory = rendermime.getFactory('application/vnd.jupyter.stderr');
        if (factory) {
            rendermime.addFactory({
                safe: true,
                mimeTypes: ['application/vnd.jupyter.stderr'],
                createRenderer: (options) => {
                    const originalRenderer = factory.createRenderer(options);
                    return new AugmentedStderrRenderer(app, originalRenderer);
                }
            }, -1); // Giving this renderer a lower rank than the default renderer gives this default priority
        }
        console.log("mito-ai: ErrorMimeRendererPlugin activated");
    }
};
/**
 * A widget that extends the default StderrRenderer.
*/
class AugmentedStderrRenderer extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_3__.Widget {
    constructor(app, originalRenderer) {
        super();
        this.app = app;
        this.originalRenderer = originalRenderer;
    }
    /**
     * Render the original error message and append the custom prompt.
     */
    async renderModel(model) {
        // Determine if it's an error or a warning. 
        // An error has:     'application/vnd.jupyter.error' 
        // A warning has:    'application/vnd.jupyter.stderr'
        const isErrorMessage = 'application/vnd.jupyter.error' in model.data;
        // Create the container for the custom UI elements
        const resolveInChatDiv = document.createElement('div');
        const originalNode = this.originalRenderer.node;
        // Only show the Fix Error in AI Chat button if it is an error, not a warning
        if (isErrorMessage) {
            (0,react_dom_client__WEBPACK_IMPORTED_MODULE_1__.createRoot)(resolveInChatDiv).render(react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ErrorMessage, { onDebugClick: () => this.openChatInterfaceWithError(model) }));
            // Append the chat container before rendering the original output
            this.node.appendChild(resolveInChatDiv);
            // Render the original content
            await this.originalRenderer.renderModel(model);
        }
        else {
            // Apply styling for warnings
            // Strip styling, use ErrorMimeRendererPlugin.css
            originalNode.style.background = 'transparent';
            originalNode.style.padding = '0px';
            // Render the OutputBlock component
            (0,react_dom_client__WEBPACK_IMPORTED_MODULE_1__.createRoot)(originalNode).render(react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CollapsibleWarningBlock__WEBPACK_IMPORTED_MODULE_6__.CollapsibleWarningBlock, { message: String(model.data['application/vnd.jupyter.stderr'] || '') }));
        }
        // Append the original error/warning rendered node
        this.node.appendChild(originalNode);
    }
    /*
        Open the chat interface and preload the error message into
        the user input.
    */
    async openChatInterfaceWithError(model) {
        const structuredError = (0,_errorUtils__WEBPACK_IMPORTED_MODULE_7__.getFullErrorMessageFromModel)(model);
        await this.app.commands.execute(_commands__WEBPACK_IMPORTED_MODULE_8__.COMMAND_MITO_AI_OPEN_CHAT, { focusChatInput: false });
        await this.app.commands.execute(_commands__WEBPACK_IMPORTED_MODULE_8__.COMMAND_MITO_AI_SEND_DEBUG_ERROR_MESSAGE, { input: structuredError });
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ErrorMimeRendererPlugin);


/***/ }),

/***/ "./lib/Extensions/ErrorMimeRenderer/errorUtils.js":
/*!********************************************************!*\
  !*** ./lib/Extensions/ErrorMimeRenderer/errorUtils.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getConciseErrorMessage: () => (/* binding */ getConciseErrorMessage),
/* harmony export */   getFullErrorMessageFromModel: () => (/* binding */ getFullErrorMessageFromModel),
/* harmony export */   getFullErrorMessageFromTraceback: () => (/* binding */ getFullErrorMessageFromTraceback)
/* harmony export */ });
/* harmony import */ var _utils_strings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/strings */ "./lib/utils/strings.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/*
Get the error string from the model.
    
For example, if this is the error message:

    Cell In[3], line 3
      1 import pandas as pd
      2 df = pd.DataFrame({'A': ['1/2/24', '2/2/24', '3/2/24'], 'B': [4, 5, 6]})
----> 3 df['Year'] = df['A'].dt.year

    AttributeError: Can only use .dt accessor with datetimelike values

This function will return:

    AttributeError: Can only use .dt accessor with datetimelike values
*/
const getConciseErrorMessage = (model) => {
    const error = model.data['application/vnd.jupyter.error'];
    if (error && typeof error === 'object' && 'ename' in error && 'evalue' in error) {
        return `${error.ename}: ${error.evalue}`;
    }
    return '';
};
/*
Gets all of the error message parts that contain code in the Jupyter Notebook.

For example, if this is the error message:

---------------------------------------------------------------------------
AttributeError                            Traceback (most recent call last)
Cell In[3], line 3
      1 import pandas as pd
      2 df = pd.DataFrame({'A': ['1/2/24', '2/2/24', '3/2/24'], 'B': [4, 5, 6]})
----> 3 df['Year'] = df['A'].dt.year

File ~/Mito/mito/mito-ai/venv/lib/python3.11/site-packages/pandas/core/generic.py:6299, in NDFrame.__getattr__(self, name)
   6292 if (
   6293     name not in self._internal_names_set
   6294     and name not in self._metadata
   6295     and name not in self._accessors
   6296     and self._info_axis._can_hold_identifiers_and_holds_name(name)
   6297 ):
   6298     return self[name]
-> 6299 return object.__getattribute__(self, name)

File ~/Mito/mito/mito-ai/venv/lib/python3.11/site-packages/pandas/core/accessor.py:224, in CachedAccessor.__get__(self, obj, cls)
    221 if obj is None:
    222     # we're accessing the attribute of the class, i.e., Dataset.geo
    223     return self._accessor
--> 224 accessor_obj = self._accessor(obj)
    225 # Replace the property with the accessor object. Inspired by:
    226 # https://www.pydanny.com/cached-property.html
    227 # We need to use object.__setattr__ because we overwrite __setattr__ on
    228 # NDFrame
    229 object.__setattr__(obj, self._name, accessor_obj)

File ~/Mito/mito/mito-ai/venv/lib/python3.11/site-packages/pandas/core/indexes/accessors.py:643, in CombinedDatetimelikeProperties.__new__(cls, data)
    640 elif isinstance(data.dtype, PeriodDtype):
    641     return PeriodProperties(data, orig)
--> 643 raise AttributeError("Can only use .dt accessor with datetimelike values")

AttributeError: Can only use .dt accessor with datetimelike values


This function will only return:

Cell In[3], line 3
      1 import pandas as pd
      2 df = pd.DataFrame({'A': ['1/2/24', '2/2/24', '3/2/24'], 'B': [4, 5, 6]})
----> 3 df['Year'] = df['A'].dt.year

AttributeError: Can only use .dt accessor with datetimelike values

*/
const getFullErrorMessageFromModel = (model) => {
    const error = model.data['application/vnd.jupyter.error'];
    return getFullErrorMessageFromTraceback(error['traceback']);
};
const getFullErrorMessageFromTraceback = (tracebackArray) => {
    var _a;
    try {
        // Strip ANSI codes from each line
        const cleanedArray = tracebackArray.map(line => (0,_utils_strings__WEBPACK_IMPORTED_MODULE_0__.stripAnsiCodes)(line));
        const filteredLines = [];
        for (const line of cleanedArray) {
            // Start capturing when we see a Cell block or its the last line
            if (line.trim().startsWith('Cell In[') || line === cleanedArray[cleanedArray.length - 1]) {
                // Split on any type of line ending (\r\n, \r, \n, ↵)
                const newLines = line.split(/\r\n|\r|\n|↵/);
                filteredLines.push(...newLines);
                // Add a new line to separate the sections
                filteredLines.push('\n');
                continue;
            }
        }
        const fullErrorMessage = filteredLines.join('\n');
        return fullErrorMessage;
    }
    catch (error) {
        // If something goes wrong parsing the error, just return the concise error message
        console.error('Error processing traceback:', error);
        return (_a = tracebackArray[tracebackArray.length - 1]) !== null && _a !== void 0 ? _a : '';
    }
};


/***/ }),

/***/ "./lib/Extensions/NotebookFooter/NotebookFooter.js":
/*!*********************************************************!*\
  !*** ./lib/Extensions/NotebookFooter/NotebookFooter.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _commands__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../commands */ "./lib/commands.js");
/* harmony import */ var _style_NotebookFooter_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../style/NotebookFooter.css */ "./style/NotebookFooter.css");
/* harmony import */ var _components_LoadingCircle__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../components/LoadingCircle */ "./lib/components/LoadingCircle.js");
/* harmony import */ var _icons_NotebookFooter_CodeIcon__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../icons/NotebookFooter/CodeIcon */ "./lib/icons/NotebookFooter/CodeIcon.js");
/* harmony import */ var _icons_NotebookFooter_TextIcon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../icons/NotebookFooter/TextIcon */ "./lib/icons/NotebookFooter/TextIcon.js");
/* harmony import */ var _utils_userSignupEvents__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/userSignupEvents */ "./lib/utils/userSignupEvents.js");
/* harmony import */ var _utils_userSignupState__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/userSignupState */ "./lib/utils/userSignupState.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */










const NotebookFooter = ({ notebookTracker, app }) => {
    var _a;
    const notebook = (_a = notebookTracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;
    const [inputValue, setInputValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    const [isGenerating, setIsGenerating] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [isSignedUp, setIsSignedUp] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true);
    // Function to refresh user signup state using the shared helper
    const refreshUserSignupState = async () => {
        const signupState = await (0,_utils_userSignupState__WEBPACK_IMPORTED_MODULE_3__.checkUserSignupState)();
        setIsSignedUp(signupState.isSignedUp);
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        void refreshUserSignupState();
    }, []);
    // Listen for signup success events from other components
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const handleSignupSuccess = () => {
            void refreshUserSignupState();
        };
        _utils_userSignupEvents__WEBPACK_IMPORTED_MODULE_4__.userSignupEvents.signupSuccess.connect(handleSignupSuccess);
        // Cleanup the event listener when component unmounts
        return () => {
            _utils_userSignupEvents__WEBPACK_IMPORTED_MODULE_4__.userSignupEvents.signupSuccess.disconnect(handleSignupSuccess);
        };
    }, []);
    // If the notebook is not loaded yet, don't render anything
    if (notebook === undefined || notebook.model === null) {
        return null;
    }
    const getPlaceholder = () => {
        if (isGenerating) {
            return 'Generating notebook...';
        }
        else if (isSignedUp) {
            return 'What analysis can I help you with?';
        }
        else {
            return 'Sign up to use Mito AI (see taskpane on the left)';
        }
    };
    const addCell = (cellType = 'code') => {
        if (notebook.widgets.length && notebook.widgets.length > 0) {
            notebook.activeCellIndex = notebook.widgets.length - 1;
        }
        if (cellType === 'code') {
            _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__.NotebookActions.insertBelow(notebook);
        }
        else {
            _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__.NotebookActions.insertBelow(notebook);
            // Change the cell type after insertion
            const activeCell = notebook.activeCell;
            if (activeCell && activeCell.model.type !== cellType) {
                _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__.NotebookActions.changeCellType(notebook, cellType);
            }
        }
        void _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__.NotebookActions.focusActiveCell(notebook);
    };
    const handleInputSubmit = () => {
        const _handleInputSubmitAsync = async () => {
            const submittedInput = inputValue.trim();
            if (submittedInput !== '') {
                setIsGenerating(true);
                setInputValue('');
                await app.commands.execute(_commands__WEBPACK_IMPORTED_MODULE_5__.COMMAND_MITO_AI_OPEN_CHAT, { focusChatInput: false });
                await app.commands.execute(_commands__WEBPACK_IMPORTED_MODULE_5__.COMMAND_MITO_AI_SEND_AGENT_MESSAGE, { input: submittedInput });
                setIsGenerating(false);
            }
        };
        void _handleInputSubmitAsync();
    };
    /*
    We handle keypress events to prevent JupyterLab from intercepting keyboard events
    and taking some other action while the user is typing in this input field. Jupyter
    might otherwise do things like: change cell type, move focus to a cell, etc.
    */
    const handleKeyPress = (e) => {
        e.stopPropagation();
    };
    const handleInputFocus = (e) => {
        e.stopPropagation();
    };
    const handleInputBlur = (e) => {
        e.stopPropagation();
    };
    const handleInputChange = (e) => {
        e.stopPropagation();
        setInputValue(e.target.value);
    };
    const handleKeyDown = (e) => {
        e.stopPropagation();
        if (e.key === 'Enter' && !e.shiftKey) {
            e.preventDefault();
            handleInputSubmit();
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "notebook-footer-container" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "input-container" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `input-wrapper ${isGenerating ? 'generating' : ''}` },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "input-icon-left" }, isGenerating ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_LoadingCircle__WEBPACK_IMPORTED_MODULE_6__["default"], null)) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, "\u2726"))),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: "text", value: inputValue, onChange: handleInputChange, onKeyDown: handleKeyDown, onKeyPress: handleKeyPress, onFocus: handleInputFocus, onBlur: handleInputBlur, placeholder: getPlaceholder(), className: "prompt-input", autoComplete: "off", spellCheck: false, disabled: isGenerating || !isSignedUp }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "input-icons-right" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "input-action-button", onClick: handleInputSubmit, onMouseDown: (e) => e.stopPropagation() }, "\u25B6")))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "button-row" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: () => addCell('code'), className: "footer-button", onMouseDown: (e) => e.stopPropagation() },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "button-content" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "button-icon" },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_NotebookFooter_CodeIcon__WEBPACK_IMPORTED_MODULE_7__["default"], null)),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "button-label" }, "Python"))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { onClick: () => addCell('markdown'), className: "footer-button", onMouseDown: (e) => e.stopPropagation() },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "button-content" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "button-icon" },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_NotebookFooter_TextIcon__WEBPACK_IMPORTED_MODULE_8__["default"], null)),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "button-label" }, "Text"))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotebookFooter);


/***/ }),

/***/ "./lib/Extensions/NotebookFooter/index.js":
/*!************************************************!*\
  !*** ./lib/Extensions/NotebookFooter/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MitoNotebookFooter: () => (/* binding */ MitoNotebookFooter),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _NotebookFooter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./NotebookFooter */ "./lib/Extensions/NotebookFooter/NotebookFooter.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _AiChat_token__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../AiChat/token */ "./lib/Extensions/AiChat/token.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */





class MitoNotebookFooter extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.ReactWidget {
    constructor(notebookTracker, app) {
        super();
        this.notebookTracker = notebookTracker;
        this.app = app;
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_NotebookFooter__WEBPACK_IMPORTED_MODULE_3__["default"], { notebookTracker: this.notebookTracker, app: this.app }));
    }
}
const NotebookFooterPlugin = {
    id: 'mito-ai:notebook-footer',
    autoStart: true,
    requires: [_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.INotebookTracker, _AiChat_token__WEBPACK_IMPORTED_MODULE_4__.IChatTracker],
    activate: (app, notebookTracker) => {
        const replaceFooter = (notebook) => {
            const layout = notebook.layout;
            if (layout === undefined) {
                return;
            }
            const customFooter = new MitoNotebookFooter(notebookTracker, app);
            layout.footer = customFooter;
        };
        notebookTracker.forEach(widget => {
            replaceFooter(widget.content);
        });
        notebookTracker.widgetAdded.connect((sender, widget) => {
            setTimeout(() => {
                replaceFooter(widget.content);
            }, 100);
        });
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotebookFooterPlugin);


/***/ }),

/***/ "./lib/Extensions/SettingsManager/SettingsManagerPlugin.js":
/*!*****************************************************************!*\
  !*** ./lib/Extensions/SettingsManager/SettingsManagerPlugin.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   COMMAND_MITO_AI_SETTINGS: () => (/* binding */ COMMAND_MITO_AI_SETTINGS),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/application */ "webpack/sharing/consume/default/@jupyterlab/application");
/* harmony import */ var _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _SettingsWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SettingsWidget */ "./lib/Extensions/SettingsManager/SettingsWidget.js");
/* harmony import */ var _ContextManager_ContextManagerPlugin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../ContextManager/ContextManagerPlugin */ "./lib/Extensions/ContextManager/ContextManagerPlugin.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const COMMAND_MITO_AI_SETTINGS = 'mito-ai:open-settings';
/**
 * Initialization data for the mito settings extension.
 */
const SettingsManagerPlugin = {
    id: 'mito-ai:settings-manager',
    description: 'Mito AI settings manager',
    autoStart: true,
    requires: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ICommandPalette, _ContextManager_ContextManagerPlugin__WEBPACK_IMPORTED_MODULE_2__.IContextManager],
    optional: [_jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__.ILayoutRestorer],
    activate: _activate
};
function _activate(app, palette, contextManager, restorer) {
    // Create a widget creator function
    const newWidget = () => {
        const content = new _SettingsWidget__WEBPACK_IMPORTED_MODULE_3__.SettingsWidget(contextManager);
        const widget = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.MainAreaWidget({ content });
        widget.id = 'mito-ai-settings';
        widget.title.label = 'Mito AI Settings';
        widget.title.closable = true;
        return widget;
    };
    let widget = newWidget();
    // Add an application command
    app.commands.addCommand(COMMAND_MITO_AI_SETTINGS, {
        label: 'Mito AI Settings',
        execute: () => {
            // Create the widget if it doesn't exist or is disposed
            if (!widget || widget.isDisposed) {
                widget = newWidget();
            }
            // Add the widget to the tracker if not already there
            if (!tracker.has(widget)) {
                void tracker.add(widget);
            }
            // Add the widget to the app if not already attached
            if (!widget.isAttached) {
                void app.shell.add(widget, 'main');
            }
            // Activate the widget
            app.shell.activateById(widget.id);
        }
    });
    // Add the command to the palette
    palette.addItem({
        command: COMMAND_MITO_AI_SETTINGS,
        category: 'Mito AI'
    });
    // Track and restore the widget state
    const tracker = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.WidgetTracker({
        namespace: widget.id
    });
    if (!tracker.has(widget)) {
        void tracker.add(widget);
    }
    if (restorer) {
        restorer.add(widget, 'mito-ai-settings');
    }
    return tracker;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsManagerPlugin);


/***/ }),

/***/ "./lib/Extensions/SettingsManager/SettingsWidget.js":
/*!**********************************************************!*\
  !*** ./lib/Extensions/SettingsManager/SettingsWidget.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SettingsWidget: () => (/* binding */ SettingsWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _database_DatabasePage__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./database/DatabasePage */ "./lib/Extensions/SettingsManager/database/DatabasePage.js");
/* harmony import */ var _support_SupportPage__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./support/SupportPage */ "./lib/Extensions/SettingsManager/support/SupportPage.js");
/* harmony import */ var _general_GeneralPage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./general/GeneralPage */ "./lib/Extensions/SettingsManager/general/GeneralPage.js");
/* harmony import */ var _rules_RulesPage__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./rules/RulesPage */ "./lib/Extensions/SettingsManager/rules/RulesPage.js");
/* harmony import */ var _profiler_ProfilerPage__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./profiler/ProfilerPage */ "./lib/Extensions/SettingsManager/profiler/ProfilerPage.js");
/* harmony import */ var _style_SettingsWidget_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../style/SettingsWidget.css */ "./style/SettingsWidget.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */








const TABS_CONFIG = (contextManager) => ({
    database: {
        label: 'Database',
        component: _database_DatabasePage__WEBPACK_IMPORTED_MODULE_3__.DatabasePage
    },
    general: {
        label: 'General',
        component: _general_GeneralPage__WEBPACK_IMPORTED_MODULE_4__.GeneralPage
    },
    rules: {
        label: 'Rules',
        component: _rules_RulesPage__WEBPACK_IMPORTED_MODULE_5__.RulesPage
    },
    profiler: {
        label: 'Profiler',
        component: () => react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_profiler_ProfilerPage__WEBPACK_IMPORTED_MODULE_6__.ProfilerPage, { contextManager: contextManager })
    },
    support: {
        label: 'Support',
        component: _support_SupportPage__WEBPACK_IMPORTED_MODULE_7__.SupportPage
    },
});
const App = ({ contextManager }) => {
    const [activeTab, setActiveTab] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('database');
    const tabsConfig = TABS_CONFIG(contextManager);
    const renderContent = () => {
        const TabComponent = tabsConfig[activeTab].component;
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(TabComponent, null);
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "settings-widget" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "settings-layout" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "settings-sidebar" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("nav", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", null, Object.entries(tabsConfig).map(([key, { label }]) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { key: key, className: activeTab === key ? 'active' : '', onClick: () => setActiveTab(key) }, label)))))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "settings-main" }, renderContent()))));
};
class SettingsWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ReactWidget {
    constructor(contextManager) {
        super();
        this.contextManager = contextManager;
        this.addClass('jp-ReactWidget');
    }
    render() {
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(App, { contextManager: this.contextManager });
    }
}


/***/ }),

/***/ "./lib/Extensions/SettingsManager/database/ConnectionForm.js":
/*!*******************************************************************!*\
  !*** ./lib/Extensions/SettingsManager/database/ConnectionForm.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConnectionForm: () => (/* binding */ ConnectionForm)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./model */ "./lib/Extensions/SettingsManager/database/model.js");
/* harmony import */ var _style_ConnectionForm_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../style/ConnectionForm.css */ "./style/ConnectionForm.css");
/* harmony import */ var _components_LoadingCircle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../components/LoadingCircle */ "./lib/components/LoadingCircle.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const ConnectionForm = ({ formData, formError, onInputChange, onSubmit, onClose }) => {
    const [isLoading, setIsLoading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const selectedConfig = formData.type ? _model__WEBPACK_IMPORTED_MODULE_2__.databaseConfigs[formData.type] : undefined;
    const handleSubmit = async (e) => {
        e.preventDefault();
        setIsLoading(true);
        try {
            await onSubmit(e);
        }
        finally {
            setIsLoading(false);
        }
    };
    const renderField = (field) => {
        var _a;
        const commonProps = {
            id: field.name,
            name: field.name,
            value: formData[field.name] || '',
            onChange: onInputChange,
            placeholder: field.placeholder,
            required: field.required,
            className: 'form-control'
        };
        switch (field.type) {
            case 'select':
                return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("select", { ...commonProps },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { value: "" },
                        "Select ",
                        field.label), (_a = field.options) === null || _a === void 0 ? void 0 :
                    _a.map(option => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: option.value, value: option.value }, option.label)))));
            case 'number':
                return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { ...commonProps, type: "number" }));
            default:
                return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { ...commonProps, type: field.type }));
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { onSubmit: handleSubmit, className: "connection-form" },
        formError && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "error" }, formError),
        (selectedConfig === null || selectedConfig === void 0 ? void 0 : selectedConfig.alertText) && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "alert-banner", dangerouslySetInnerHTML: { __html: selectedConfig.alertText } })),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "form-group" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { htmlFor: "type" }, "Database Type"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("select", { id: "type", name: "type", value: formData.type, onChange: onInputChange, required: true },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { value: "" }, "Select Database Type"),
                Object.values(_model__WEBPACK_IMPORTED_MODULE_2__.databaseConfigs).map(config => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: config.type, value: config.type }, config.displayName))))),
        selectedConfig && selectedConfig.fields.map(field => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: field.name, className: "form-group" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { htmlFor: field.name }, field.label),
            renderField(field)))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "form-info" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
                "Mito will automatically install any required database drivers when you connect.",
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", { href: "https://docs.trymito.io/mito-ai/database-connectors/database-drivers", target: "_blank", rel: "noopener noreferrer" }, "Learn more about database drivers"))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "form-actions" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { type: "button", className: "button-base button-gray", onClick: onClose, disabled: isLoading }, "Cancel"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { type: "submit", className: "button-base button-purple", disabled: isLoading }, isLoading ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                "Validating Connection",
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { color: 'var(--purple-700)' } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_LoadingCircle__WEBPACK_IMPORTED_MODULE_3__["default"], null)))) : ('Add Connection')))));
};


/***/ }),

/***/ "./lib/Extensions/SettingsManager/database/ConnectionList.js":
/*!*******************************************************************!*\
  !*** ./lib/Extensions/SettingsManager/database/ConnectionList.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConnectionList: () => (/* binding */ ConnectionList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./model */ "./lib/Extensions/SettingsManager/database/model.js");
/* harmony import */ var _GettingStartedVideo__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./GettingStartedVideo */ "./lib/Extensions/SettingsManager/database/GettingStartedVideo.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */



const ConnectionList = ({ connections, loading, error, onDelete }) => {
    const [clickedDelete, setClickedDelete] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
    if (loading) {
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Loading connections...");
    }
    if (error) {
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "error" },
            "Error: ",
            error);
    }
    if (Object.keys(connections).length === 0) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "no-connections-container" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "No database connections found."),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "video-tutorial" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_GettingStartedVideo__WEBPACK_IMPORTED_MODULE_1__.GettingStartedVideo, { width: "560", height: "315" }))));
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "connections-grid" }, Object.entries(connections).map(([id, connection]) => {
        var _a;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: id, className: "connection-card" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "connection-card-header" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", { className: "connection-alias" }, connection.alias ? connection.alias : connection.database),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "connection-type" }, connection.type.toUpperCase())),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "connection-divider" }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "connection-details" }, (_a = _model__WEBPACK_IMPORTED_MODULE_2__.databaseConfigs[connection.type]) === null || _a === void 0 ? void 0 : _a.fields.map(field => {
                // Skip specific fields
                if (field.type === 'password')
                    return null;
                if (field.name === 'alias')
                    return null;
                const value = connection[field.name];
                // Only show fields that have values
                if (value === undefined || value === '')
                    return null;
                return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { key: field.name },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("strong", null,
                        field.label,
                        ":"),
                    " ",
                    value));
            })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "connection-actions" }, clickedDelete === id ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "confirmation-buttons" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "button-base button-red", onClick: () => onDelete(id) }, "Yes, I want to delete"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "button-base button-gray", onClick: () => setClickedDelete(null) }, "Cancel"))) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "button-base button-red", onClick: () => setClickedDelete(id) }, "Delete")))));
    })));
};


/***/ }),

/***/ "./lib/Extensions/SettingsManager/database/DatabasePage.js":
/*!*****************************************************************!*\
  !*** ./lib/Extensions/SettingsManager/database/DatabasePage.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DatabasePage: () => (/* binding */ DatabasePage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ConnectionList__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ConnectionList */ "./lib/Extensions/SettingsManager/database/ConnectionList.js");
/* harmony import */ var _ConnectionForm__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ConnectionForm */ "./lib/Extensions/SettingsManager/database/ConnectionForm.js");
/* harmony import */ var _GettingStartedVideo__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./GettingStartedVideo */ "./lib/Extensions/SettingsManager/database/GettingStartedVideo.js");
/* harmony import */ var _restAPI_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../restAPI/utils */ "./lib/restAPI/utils.js");
/* harmony import */ var _style_DatabasePage_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../style/DatabasePage.css */ "./style/DatabasePage.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */






const DatabasePage = () => {
    const [connections, setConnections] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true);
    const [error, setError] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
    const [showModal, setShowModal] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [showVideoModal, setShowVideoModal] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [formData, setFormData] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({
        type: 'snowflake',
        username: '',
        password: '',
        account: '',
        warehouse: '',
    });
    const [formError, setFormError] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
    const fetchConnections = async () => {
        const resp = await (0,_restAPI_utils__WEBPACK_IMPORTED_MODULE_2__.requestAPI)('db/connections');
        if (resp.error) {
            // Handle error case - you might want to show an error message to the user
            console.error('Failed to fetch database connections:', resp.error.message);
            setError(resp.error.message);
            setConnections({});
        }
        else if (resp.data) {
            setConnections(resp.data);
            setError(null);
        }
        setLoading(false);
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        void fetchConnections();
    }, []);
    const handleInputChange = (e) => {
        const { name, value } = e.target;
        setFormData(prev => ({
            ...prev,
            [name]: value
        }));
    };
    const handleSubmit = async (e) => {
        e.preventDefault();
        setFormError(null);
        const resp = await (0,_restAPI_utils__WEBPACK_IMPORTED_MODULE_2__.requestAPI)('db/connections', {
            method: 'POST',
            body: JSON.stringify(formData)
        });
        if (resp.error) {
            setFormError(resp.error.message);
            return;
        }
        if (resp.data) {
            // Refresh the connections list
            await fetchConnections();
            setShowModal(false);
            setFormData({
                type: 'snowflake',
                username: '',
                password: '',
                account: '',
                warehouse: '',
            });
        }
    };
    const handleDelete = async (id) => {
        const resp = await (0,_restAPI_utils__WEBPACK_IMPORTED_MODULE_2__.requestAPI)(`db/connections/${id}`, {
            method: 'DELETE',
        });
        if (resp.error) {
            setError(resp.error.message);
            return;
        }
        if (resp.data) {
            // Refresh the connections list
            await fetchConnections();
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "db-connections" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "settings-header" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, "Database Connections"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "header-buttons" },
                Object.keys(connections).length > 0 && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "button-base button-gray", onClick: () => setShowVideoModal(true) },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("b", null, "Getting Started"))),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "button-base button-purple", onClick: () => setShowModal(true) },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("b", null, "\uFF0B Add Connection")))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ConnectionList__WEBPACK_IMPORTED_MODULE_3__.ConnectionList, { connections: connections, loading: loading, error: error, onDelete: handleDelete }),
        showModal && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-overlay", onClick: () => setShowModal(false) },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-content", onClick: e => e.stopPropagation() },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-header" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Add New Connection"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "modal-close-button", onClick: () => setShowModal(false) }, "\u2715")),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ConnectionForm__WEBPACK_IMPORTED_MODULE_4__.ConnectionForm, { formData: formData, formError: formError, onInputChange: handleInputChange, onSubmit: handleSubmit, onClose: () => setShowModal(false) })))),
        showVideoModal && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-overlay", onClick: () => setShowVideoModal(false) },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-content video-modal", onClick: e => e.stopPropagation() },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-header" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Getting Started"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "modal-close-button", onClick: () => setShowVideoModal(false) }, "\u2715")),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_GettingStartedVideo__WEBPACK_IMPORTED_MODULE_5__.GettingStartedVideo, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "video-description" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
                        "Still have questions? Check out our ",
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", { href: "https://docs.trymito.io/mito-ai/database-connectors", target: "_blank", rel: "noopener noreferrer" }, "documentation"),
                        " for more information.")))))));
};


/***/ }),

/***/ "./lib/Extensions/SettingsManager/database/GettingStartedVideo.js":
/*!************************************************************************!*\
  !*** ./lib/Extensions/SettingsManager/database/GettingStartedVideo.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GettingStartedVideo: () => (/* binding */ GettingStartedVideo)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const GettingStartedVideo = ({ width = "100%", height = "400", className = "" }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `video-container ${className}` },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("iframe", { width: width, height: height, src: "https://www.youtube.com/embed/sJgphOrmZb4?rel=0", title: "How to connect to your database with Mito", frameBorder: "0", allow: "accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture", allowFullScreen: true })));
};


/***/ }),

/***/ "./lib/Extensions/SettingsManager/database/model.js":
/*!**********************************************************!*\
  !*** ./lib/Extensions/SettingsManager/database/model.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   databaseConfigs: () => (/* binding */ databaseConfigs)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
const ALIAS_PLACEHOLDER = 'Enter a nickname for this database';
const databaseConfigs = {
    mssql: {
        type: 'mssql',
        displayName: 'Microsoft SQL Server',
        alertText: 'Microsoft SQL Server requires an additional driver. If you\'ve already installed it, you can safely ignore this message. For more info, consult the <a href="https://docs.trymito.io/mito-ai/database-connectors/microsoft-sql-server" target="_blank">Mito docs</a>.',
        fields: [
            {
                name: 'alias',
                type: 'text',
                label: 'Alias',
                placeholder: ALIAS_PLACEHOLDER,
                required: true
            },
            {
                name: 'username',
                type: 'text',
                label: 'Username',
                placeholder: 'john.doe',
                required: true
            },
            {
                name: 'password',
                type: 'password',
                label: 'Password',
                placeholder: 'Enter your password',
                required: true
            },
            {
                name: 'host',
                type: 'text',
                label: 'Host',
                placeholder: 'localhost',
                required: true
            },
            {
                name: 'port',
                type: 'number',
                label: 'Port',
                placeholder: '1433',
                required: true
            },
            {
                name: 'database',
                type: 'text',
                label: 'Database',
                placeholder: 'mydb',
                required: true
            },
            {
                name: 'odbc_driver_version',
                type: 'text',
                label: 'ODBC Driver Version',
                placeholder: '18',
                required: true
            }
        ]
    },
    mysql: {
        type: 'mysql',
        displayName: 'MySQL',
        fields: [
            {
                name: 'alias',
                type: 'text',
                label: 'Alias',
                placeholder: ALIAS_PLACEHOLDER,
                required: true
            },
            {
                name: 'username',
                type: 'text',
                label: 'Username',
                placeholder: 'john.doe',
                required: true
            },
            {
                name: 'password',
                type: 'password',
                label: 'Password',
                placeholder: 'Enter your password',
                required: true
            },
            {
                name: 'host',
                type: 'text',
                label: 'Host',
                placeholder: 'localhost',
                required: true
            },
            {
                name: 'port',
                type: 'number',
                label: 'Port',
                placeholder: '3306',
                required: true
            },
            {
                name: 'database',
                type: 'text',
                label: 'Database',
                placeholder: 'mydb',
                required: true
            }
        ]
    },
    oracle: {
        type: 'oracle',
        displayName: 'Oracle',
        fields: [
            {
                name: 'alias',
                type: 'text',
                label: 'Alias',
                placeholder: ALIAS_PLACEHOLDER,
                required: true
            },
            {
                name: 'username',
                type: 'text',
                label: 'Username',
                placeholder: 'john.doe',
                required: true
            },
            {
                name: 'password',
                type: 'password',
                label: 'Password',
                placeholder: 'Enter your password',
                required: true
            },
            {
                name: 'host',
                type: 'text',
                label: 'Host',
                placeholder: 'localhost',
                required: true
            },
            {
                name: 'port',
                type: 'number',
                label: 'Port',
                placeholder: '1521',
                required: true
            },
            {
                name: 'service_name',
                type: 'text',
                label: 'Service Name',
                placeholder: 'xe',
                required: true
            }
        ]
    },
    postgres: {
        type: 'postgres',
        displayName: 'PostgreSQL',
        fields: [
            {
                name: 'alias',
                type: 'text',
                label: 'Alias',
                placeholder: ALIAS_PLACEHOLDER,
                required: true
            },
            {
                name: 'username',
                type: 'text',
                label: 'Username',
                placeholder: 'john.doe',
                required: true
            },
            {
                name: 'password',
                type: 'password',
                label: 'Password',
                placeholder: 'Enter your password',
                required: true
            },
            {
                name: 'host',
                type: 'text',
                label: 'Host',
                placeholder: 'localhost',
                required: true
            },
            {
                name: 'port',
                type: 'number',
                label: 'Port',
                placeholder: '5432',
                required: true
            },
            {
                name: 'database',
                type: 'text',
                label: 'Database',
                placeholder: 'mydb',
                required: true
            }
        ]
    },
    snowflake: {
        type: 'snowflake',
        displayName: 'Snowflake',
        fields: [
            {
                name: 'alias',
                type: 'text',
                label: 'Alias',
                placeholder: ALIAS_PLACEHOLDER,
                required: true
            },
            {
                name: 'username',
                type: 'text',
                label: 'Username',
                placeholder: 'john.doe',
                required: true
            },
            {
                name: 'password',
                type: 'password',
                label: 'Password',
                placeholder: 'Enter your password',
                required: true
            },
            {
                name: 'account',
                type: 'text',
                label: 'Account',
                placeholder: 'tudbfdr-ab12345',
                required: true
            },
            {
                name: 'warehouse',
                type: 'text',
                label: 'Warehouse',
                placeholder: 'COMPUTE_WH',
                required: true
            }
        ]
    },
    sqlite: {
        type: 'sqlite',
        displayName: 'SQLite',
        fields: [
            {
                name: 'alias',
                type: 'text',
                label: 'Alias',
                placeholder: ALIAS_PLACEHOLDER,
                required: true
            },
            {
                name: 'database',
                type: 'text',
                label: 'Path to database',
                placeholder: '/Users/jake/db.sqlite3',
                required: true
            }
        ]
    }
};


/***/ }),

/***/ "./lib/Extensions/SettingsManager/general/GeneralPage.js":
/*!***************************************************************!*\
  !*** ./lib/Extensions/SettingsManager/general/GeneralPage.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GeneralPage: () => (/* binding */ GeneralPage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


const GeneralPage = () => {
    const [betaMode, setBetaMode] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    // When we first open the page, load the settings from the server
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const fetchSettings = async () => {
            const betaMode = await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__.getSetting)('beta_mode');
            setBetaMode(betaMode === 'true');
        };
        void fetchSettings();
    }, []);
    const handleBetaModeChange = async () => {
        const newBetaMode = !betaMode;
        await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__.updateSettings)('beta_mode', newBetaMode.toString());
        setBetaMode(newBetaMode);
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "settings-header" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, "General")),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "settings-option" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { className: "settings-checkbox-label" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: "checkbox", checked: betaMode, onChange: handleBetaModeChange }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Beta Mode")),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "settings-option-description" }, "Enable early access to experimental features. These features may be less stable than regular features."))));
};


/***/ }),

/***/ "./lib/Extensions/SettingsManager/profiler/CapturedRequestsSection.js":
/*!****************************************************************************!*\
  !*** ./lib/Extensions/SettingsManager/profiler/CapturedRequestsSection.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CapturedRequestsSection: () => (/* binding */ CapturedRequestsSection)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../utils/constants */ "./lib/utils/constants.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


const CapturedRequestsSection = () => {
    const [capturedRequests, setCapturedRequests] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    // Listen for captured completion requests
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const handleCapturedRequest = (event) => {
            setCapturedRequests(prev => [event.detail, ...prev]);
        };
        window.addEventListener(_utils_constants__WEBPACK_IMPORTED_MODULE_1__.EVENT_NAMES.MITO_AI_CAPTURE_REQUEST, handleCapturedRequest);
        return () => {
            window.removeEventListener(_utils_constants__WEBPACK_IMPORTED_MODULE_1__.EVENT_NAMES.MITO_AI_CAPTURE_REQUEST, handleCapturedRequest);
        };
    }, []);
    const clearCapturedRequests = () => {
        setCapturedRequests([]);
    };
    const copyRequestToClipboard = async (request) => {
        try {
            await navigator.clipboard.writeText(JSON.stringify(request, null, 2));
            console.log('Request copied to clipboard');
        }
        catch (err) {
            console.error('Failed to copy request to clipboard:', err);
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Captured Completion Requests"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "button-base profiler-clear-button", onClick: clearCapturedRequests }, "Clear Captured Requests"),
        capturedRequests.length === 0 ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "profiler-no-requests" }, "No requests captured yet. Send a message in the AI chat to see captured requests here.")) : (capturedRequests.map((captured, index) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: index, className: "profiler-request-container" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "profiler-request-header" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, capturedRequests.length - index),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "button-base profiler-copy-button", onClick: () => copyRequestToClipboard(captured.request) }, "Copy")),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("pre", { className: "json-container" }, JSON.stringify(captured.request, null, 2))))))));
};


/***/ }),

/***/ "./lib/Extensions/SettingsManager/profiler/ContextManagerSection.js":
/*!**************************************************************************!*\
  !*** ./lib/Extensions/SettingsManager/profiler/ContextManagerSection.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ContextManagerSection: () => (/* binding */ ContextManagerSection)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const ContextManagerSection = ({ contextManager }) => {
    const [refreshKey, setRefreshKey] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
    const handleRefreshContextManager = () => {
        // Force a re-render by toggling the state
        setRefreshKey(prev => prev + 1);
    };
    const activeNotebookContext = contextManager.getActiveNotebookContext();
    const copyContextManagerToClipboard = async () => {
        const jsonContent = JSON.stringify({
            variables: activeNotebookContext === null || activeNotebookContext === void 0 ? void 0 : activeNotebookContext.variables,
            files: activeNotebookContext === null || activeNotebookContext === void 0 ? void 0 : activeNotebookContext.files
        }, null, 2);
        try {
            await navigator.clipboard.writeText(jsonContent);
            console.log('Context Manager contents copied to clipboard');
        }
        catch (err) {
            console.error('Failed to copy to clipboard:', err);
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Context Manager"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "profiler-button-container" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "button-base", onClick: handleRefreshContextManager }, "Refresh"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "button-base", onClick: copyContextManagerToClipboard }, "Copy")),
        refreshKey > 0 && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "settings-option" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("pre", { className: "json-container" }, JSON.stringify({
                variables: activeNotebookContext === null || activeNotebookContext === void 0 ? void 0 : activeNotebookContext.variables,
                files: activeNotebookContext === null || activeNotebookContext === void 0 ? void 0 : activeNotebookContext.files
            }, null, 2))))));
};


/***/ }),

/***/ "./lib/Extensions/SettingsManager/profiler/ProfilerPage.js":
/*!*****************************************************************!*\
  !*** ./lib/Extensions/SettingsManager/profiler/ProfilerPage.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ProfilerPage: () => (/* binding */ ProfilerPage),
/* harmony export */   captureCompletionRequest: () => (/* binding */ captureCompletionRequest)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ContextManagerSection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ContextManagerSection */ "./lib/Extensions/SettingsManager/profiler/ContextManagerSection.js");
/* harmony import */ var _CapturedRequestsSection__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./CapturedRequestsSection */ "./lib/Extensions/SettingsManager/profiler/CapturedRequestsSection.js");
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../utils/constants */ "./lib/utils/constants.js");
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/* harmony import */ var _style_ProfilerPage_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../style/ProfilerPage.css */ "./style/ProfilerPage.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */






// Simple event system for capturing completion requests.
// These events are usually variables that are not stored in the context manager,
// and are created dynamically. So we capture them before they are sent to the backend.
const captureCompletionRequest = (request) => {
    const event = new CustomEvent(_utils_constants__WEBPACK_IMPORTED_MODULE_2__.EVENT_NAMES.MITO_AI_CAPTURE_REQUEST, {
        detail: {
            request,
        }
    });
    window.dispatchEvent(event);
};
const ProfilerPage = ({ contextManager }) => {
    const [hasAcceptedDisclaimer, setHasAcceptedDisclaimer] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    // When we first open the page, check if the user has already accepted the disclaimer
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const checkDisclaimerStatus = async () => {
            try {
                const disclaimerAccepted = await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_3__.getSetting)('profiler_disclaimer_accepted');
                setHasAcceptedDisclaimer(disclaimerAccepted === 'true');
            }
            catch (error) {
                console.error('Error checking disclaimer status:', error);
                // If there's an error, default to showing the disclaimer
                setHasAcceptedDisclaimer(false);
            }
        };
        void checkDisclaimerStatus();
    }, []);
    const handleAcceptDisclaimer = async () => {
        try {
            await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_3__.updateSettings)('profiler_disclaimer_accepted', 'true');
            setHasAcceptedDisclaimer(true);
        }
        catch (error) {
            console.error('Error accepting disclaimer:', error);
        }
    };
    // Show disclaimer if not yet accepted
    if (!hasAcceptedDisclaimer) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "settings-header" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, "Profiler")),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "The profiler is an internal debugging tool intended for use by the Mito development team. It is not designed, tested, or supported for general usage. Running the profiler may impact performance, produce unstable behavior, or generate incomplete results. Use at your own discretion."),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "button-base button-gray", onClick: handleAcceptDisclaimer }, "Accept")));
    }
    // Show the actual profiler content after disclaimer is accepted
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "settings-header" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, "Profiler")),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "profiler-warning" }, "For internal debugging only."),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ContextManagerSection__WEBPACK_IMPORTED_MODULE_4__.ContextManagerSection, { contextManager: contextManager }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CapturedRequestsSection__WEBPACK_IMPORTED_MODULE_5__.CapturedRequestsSection, null)));
};


/***/ }),

/***/ "./lib/Extensions/SettingsManager/rules/RulesForm.js":
/*!***********************************************************!*\
  !*** ./lib/Extensions/SettingsManager/rules/RulesForm.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RulesForm: () => (/* binding */ RulesForm)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_LoadingCircle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../components/LoadingCircle */ "./lib/components/LoadingCircle.js");
/* harmony import */ var _style_RulesForm_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../style/RulesForm.css */ "./style/RulesForm.css");
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../utils/classNames */ "./lib/utils/classNames.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const RulesForm = ({ formData, formError, onInputChange, onSubmit, onClose, isEditing }) => {
    const [isLoading, setIsLoading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const handleSubmit = async (e) => {
        e.preventDefault();
        setIsLoading(true);
        try {
            await onSubmit(e);
        }
        finally {
            setIsLoading(false);
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { onSubmit: handleSubmit, className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_2__.classNames)("connection-form", "rules-form") },
        formError && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "error" }, formError),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "form-group" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { htmlFor: "name" }, "Rule Name"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("sub", null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Rules must contain only alphanumeric characters, underscores, or hyphens.")),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: "text", id: "name", name: "name", value: formData.name, onChange: onInputChange, placeholder: "Enter rule name", required: true })),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "form-group" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { htmlFor: "description" }, "Rule Content"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("textarea", { id: "description", name: "description", value: formData.description, onChange: onInputChange, placeholder: "Enter or paste rule content here", rows: 30, required: true, className: "form-textarea" })),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "form-actions" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { type: "button", className: "button-base button-gray", onClick: onClose, disabled: isLoading }, "Cancel"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { type: "submit", className: "button-base button-purple", disabled: isLoading }, isLoading ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                "Saving Rule",
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { color: 'var(--purple-700)' } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_LoadingCircle__WEBPACK_IMPORTED_MODULE_3__["default"], null)))) : (isEditing ? 'Update Rule' : 'Add Rule')))));
};


/***/ }),

/***/ "./lib/Extensions/SettingsManager/rules/RulesPage.js":
/*!***********************************************************!*\
  !*** ./lib/Extensions/SettingsManager/rules/RulesPage.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RulesPage: () => (/* binding */ RulesPage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _RulesForm__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./RulesForm */ "./lib/Extensions/SettingsManager/rules/RulesForm.js");
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/* harmony import */ var _utils_fileName__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../utils/fileName */ "./lib/utils/fileName.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const RulesPage = () => {
    const [modalStatus, setModalStatus] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(undefined);
    const [rules, setRules] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    const [error, setError] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
    const [formData, setFormData] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({
        name: '',
        description: ''
    });
    const [formError, setFormError] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
    const fetchRules = async () => {
        try {
            const rules = await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__.getRules)();
            setRules(rules.sort());
        }
        catch (err) {
            setError(err instanceof Error ? err.message : 'An error occurred');
        }
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        void fetchRules();
    }, []);
    const handleInputChange = (e) => {
        const { name, value } = e.target;
        setFormData(prev => ({ ...prev, [name]: value }));
    };
    const handleSubmit = async (e) => {
        e.preventDefault();
        // Make sure tha the rule is a valid file name
        if (!(0,_utils_fileName__WEBPACK_IMPORTED_MODULE_2__.isValidFileName)(formData.name)) {
            setFormError('Invalid rule name. Rules must contain only alphanumeric characters, underscores, or hyphens.');
            return;
        }
        else {
            setFormError(null);
        }
        await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__.setRule)(formData.name, formData.description);
        setModalStatus(undefined);
        setFormData({
            name: '',
            description: ''
        });
        void fetchRules();
    };
    const handleRuleClick = async (rule) => {
        const ruleContent = await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__.getRule)(rule);
        setFormData({
            name: (0,_utils_fileName__WEBPACK_IMPORTED_MODULE_2__.stripFileEnding)(rule),
            description: ruleContent || ''
        });
        setModalStatus('edit rule');
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "settings-header" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, "Rules"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "button-base button-purple", onClick: () => setModalStatus('new rule') },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("b", null, "\uFF0B Add Rule"))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Rules provide more context to Ai models to help them follow your preferences, adhere to your organization's style guides, learn niche topics, and be a better colleague."),
        error && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "error" }, error),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "rules-list" }, rules && rules.length > 0 ? rules.map((rule) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: rule, className: "rule-item", onClick: () => handleRuleClick(rule) },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "rule-content" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", { className: "rule-name" }, (0,_utils_fileName__WEBPACK_IMPORTED_MODULE_2__.stripFileEnding)(rule)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "rule-description" }, "Click update to edit this rule's description and settings.")),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "rule-actions" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "button-base button-gray" }, "Update"))))) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "empty-state" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "No rules created yet. Add your first rule to get started!")))),
        modalStatus && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-overlay" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-content modal-content-large", onClick: e => e.stopPropagation() },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_RulesForm__WEBPACK_IMPORTED_MODULE_3__.RulesForm, { formData: formData, formError: formError, onInputChange: handleInputChange, onSubmit: handleSubmit, onClose: () => {
                        setModalStatus(undefined);
                        setFormData({
                            name: '',
                            description: ''
                        });
                    }, isEditing: modalStatus === 'edit rule' }))))));
};


/***/ }),

/***/ "./lib/Extensions/SettingsManager/support/SupportPage.js":
/*!***************************************************************!*\
  !*** ./lib/Extensions/SettingsManager/support/SupportPage.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SupportPage: () => (/* binding */ SupportPage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const SupportPage = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "settings-header" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null, "Support")),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
            "To learn more about Mito AI, please visit our ",
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", { href: "https://docs.trymito.io/", target: "_blank", rel: "noopener noreferrer" }, "documentation"),
            "."),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
            "Additional support is available by emailing ",
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", { href: "mailto:founders@sagacollab.com" }, "founders@sagacollab.com"))));
};


/***/ }),

/***/ "./lib/Extensions/ToolbarButtons/ToolbarButtonsPlugin.js":
/*!***************************************************************!*\
  !*** ./lib/Extensions/ToolbarButtons/ToolbarButtonsPlugin.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _commands__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../commands */ "./lib/commands.js");
/* harmony import */ var _icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../icons */ "./lib/icons/index.js");
/* harmony import */ var _utils_cellMetadata__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/cellMetadata */ "./lib/utils/cellMetadata.js");
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */





const ToolbarButtonsPlugin = {
    // Important: The Cell Toolbar Buttons are added to the toolbar registry via the schema/toolbar-buttons.json file.
    // The id here must be mito-ai:toolbar-buttons otherwise the buttons are not successfully added. My understanding is that
    // the id must match the name of the package and `toolbar-buttons` must match the name of the .json file.
    id: 'mito_ai:toolbar-buttons',
    description: 'Adds an "explain code cell with AI" button to the cell toolbar',
    autoStart: true,
    requires: [_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.INotebookTracker],
    activate: (app, notebookTracker) => {
        const { commands } = app;
        // Important: To add a button to the cell toolbar, the command must start with "toolbar-button:"
        // and the command must match the command in the schema/plugin.json file.
        commands.addCommand('toolbar-button:explain-code', {
            icon: _icons__WEBPACK_IMPORTED_MODULE_1__.lightBulbLabIcon,
            caption: 'Explain code in AI Chat',
            execute: async () => {
                /*
                    In order to click on the cell toolbar button, that cell must be the active cell,
                    so the ChatHistoryManager will take care of providing the cell context.
                */
                await app.commands.execute(_commands__WEBPACK_IMPORTED_MODULE_2__.COMMAND_MITO_AI_OPEN_CHAT);
                await app.commands.execute(_commands__WEBPACK_IMPORTED_MODULE_2__.COMMAND_MITO_AI_SEND_EXPLAIN_CODE_MESSAGE);
            },
            isVisible: () => { var _a; return ((_a = notebookTracker.activeCell) === null || _a === void 0 ? void 0 : _a.model.type) === 'code' && app.commands.hasCommand(_commands__WEBPACK_IMPORTED_MODULE_2__.COMMAND_MITO_AI_SEND_EXPLAIN_CODE_MESSAGE); }
        });
        commands.addCommand('toolbar-button:toggle-include-cell-in-app', {
            icon: () => {
                const includeCellInApp = (0,_utils_cellMetadata__WEBPACK_IMPORTED_MODULE_3__.getActiveCellIncludeInApp)(notebookTracker);
                return includeCellInApp ? _icons__WEBPACK_IMPORTED_MODULE_1__.AppBuilderIncludeCellLabIcon : _icons__WEBPACK_IMPORTED_MODULE_1__.AppBuilderExcludeCellLabIcon;
            },
            caption: 'Toggle cell output visibility in Streamlit app',
            execute: async () => {
                /*
                In order to click on the cell toolbar button, that cell must be the active cell.

                Currently we mark the entire cell as not included in the app.
                    
                    Future improvement: Allow users to hide only the cell OUTPUT while keeping the code.
                    
                    Implementation challenges:
                    1. Handling displayed expressions: Streamlit automatically displays hanging variables.
                    
                    Potential solutions:
                    - Use linting (pyright/pylance) to detect reportUnusedExpression in cells that have outputs turned off and remove unused expressions
                    - Use AI to identify and remove hanging variables
                    - Parse code to find and remove lone variable references and literals
                */
                (0,_utils_cellMetadata__WEBPACK_IMPORTED_MODULE_3__.toggleActiveCellIncludeInAppMetadata)(notebookTracker);
                // Force command refresh to update the icon
                commands.notifyCommandChanged('toolbar-button:toggle-include-cell-in-app');
            },
            isVisible: () => {
                return app.commands.hasCommand(_commands__WEBPACK_IMPORTED_MODULE_2__.COMMAND_MITO_AI_BETA_MODE_ENABLED);
            }
        });
        commands.addCommand('toolbar-button:preview-as-streamlit', {
            label: 'App Mode',
            caption: 'Preview notebook as app and turn on App Mode',
            className: 'text-button-mito-ai button-base button-purple button-small',
            execute: async () => {
                void app.commands.execute('mito-ai:preview-as-streamlit');
            },
            isVisible: () => {
                return app.commands.hasCommand(_commands__WEBPACK_IMPORTED_MODULE_2__.COMMAND_MITO_AI_BETA_MODE_ENABLED);
            }
        });
        // Check if the beta mode is enabled. After checking, tell Jupyter to 
        // re-evaluate convert-to-streamlit visibility now that we have had the 
        // opportunity to set the mito-ai:beta-mode-enabled command if beta mode is enabled.
        (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_4__.getSetting)('beta_mode').then(value => {
            if (value === 'true') {
                commands.addCommand(_commands__WEBPACK_IMPORTED_MODULE_2__.COMMAND_MITO_AI_BETA_MODE_ENABLED, { execute: () => { } });
                commands.notifyCommandChanged('toolbar-button:toggle-include-cell-in-app');
                commands.notifyCommandChanged('toolbar-button:preview-as-streamlit');
            }
        }).catch(error => {
            console.error('Error checking beta mode:', error);
        });
        console.log("mito-ai: ToolbarButtonsPlugin activated");
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ToolbarButtonsPlugin);


/***/ }),

/***/ "./lib/Extensions/VersionCheck/index.js":
/*!**********************************************!*\
  !*** ./lib/Extensions/VersionCheck/index.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   versionCheckPlugin: () => (/* binding */ versionCheckPlugin)
/* harmony export */ });
/* harmony import */ var _utils_version_check__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/version_check */ "./lib/utils/version_check.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

// Check interval - once per day in milliseconds
const CHECK_INTERVAL = 24 * 60 * 60 * 1000;
// Cache key for storing the last check time
const CACHE_KEY = 'mito-ai-last-version-check';
/**
 * Plugin to check for updates of Mito AI.
 * This will only show a notification if an update is available.
 * If any errors occur or if the extension can't check for updates, no notification will be shown.
 */
const versionCheckPlugin = {
    id: 'mito-ai:version-check',
    autoStart: true,
    requires: [],
    activate: (app) => {
        // Make sure the app is fully initialized before checking for updates
        void app.started.then(() => {
            // Check if we should perform a version check based on last check time
            const shouldCheck = shouldPerformCheck();
            if (shouldCheck) {
                // Perform the check and handle any errors
                return performVersionCheck(app)
                    .catch(error => {
                    console.warn('Error checking for Mito AI updates:', error);
                })
                    .finally(() => {
                    // Update the last check timestamp regardless of success/failure
                    updateLastCheckTime();
                });
            }
            return Promise.resolve();
        }).catch(error => {
            console.warn('Error during JupyterLab initialization:', error);
        });
        // Set up periodic checks
        setUpPeriodicChecks(app);
    }
};
/**
 * Determines if we should perform a version check based on the last check time
 */
function shouldPerformCheck() {
    try {
        const lastCheck = window.localStorage.getItem(CACHE_KEY);
        if (!lastCheck) {
            return true; // No record of previous check, so perform check
        }
        const lastCheckTime = parseInt(lastCheck, 10);
        const currentTime = Date.now();
        // Check if the last check was more than the check interval ago
        return (currentTime - lastCheckTime) > CHECK_INTERVAL;
    }
    catch (error) {
        // If there's any error (e.g., localStorage not available), default to performing the check
        console.warn('Error checking last version check time:', error);
        return true;
    }
}
/**
 * Updates the last check time to the current time
 */
function updateLastCheckTime() {
    try {
        window.localStorage.setItem(CACHE_KEY, Date.now().toString());
    }
    catch (error) {
        console.warn('Error updating last version check time:', error);
    }
}
/**
 * Performs the version check
 */
async function performVersionCheck(app) {
    return (0,_utils_version_check__WEBPACK_IMPORTED_MODULE_0__.checkForUpdates)(app.serviceManager.serverSettings);
}
/**
 * Sets up periodic checks for updates
 */
function setUpPeriodicChecks(app) {
    // Don't set up periodic checks in node environments (for testing)
    if (typeof window === 'undefined') {
        return;
    }
    // Check once per day
    setInterval(() => {
        void performVersionCheck(app).catch(error => {
            console.warn('Error during periodic version check:', error);
        });
    }, CHECK_INTERVAL);
}


/***/ }),

/***/ "./lib/Extensions/emptyCell/EmptyCellPlugin.js":
/*!*****************************************************!*\
  !*** ./lib/Extensions/emptyCell/EmptyCellPlugin.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   emptyCellPlaceholder: () => (/* binding */ emptyCellPlaceholder)
/* harmony export */ });
/* harmony import */ var _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/codeeditor */ "webpack/sharing/consume/default/@jupyterlab/codeeditor");
/* harmony import */ var _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/codemirror */ "webpack/sharing/consume/default/@jupyterlab/codemirror");
/* harmony import */ var _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_commands__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/commands */ "webpack/sharing/consume/default/@lumino/commands");
/* harmony import */ var _lumino_commands__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_commands__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _commands__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../commands */ "./lib/commands.js");
/* harmony import */ var _AiChat_token__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../AiChat/token */ "./lib/Extensions/AiChat/token.js");
/* harmony import */ var _emptyCell__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./emptyCell */ "./lib/Extensions/emptyCell/emptyCell.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */






const emptyCellPlaceholder = {
    id: 'mito-ai:empty-cell-placeholder',
    description: 'Display a default message in an empty code cell.',
    autoStart: true,
    requires: [_AiChat_token__WEBPACK_IMPORTED_MODULE_3__.IChatTracker, _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_1__.IEditorExtensionRegistry],
    activate: (app, 
    // Trick to ensure the chat plugin is available and loaded before this one
    // so that the keybinding can be properly resolved.
    tracker, extensions) => {
        var _a;
        const keyBindings = app.commands.keyBindings.find(b => b.command === _commands__WEBPACK_IMPORTED_MODULE_4__.COMMAND_MITO_AI_OPEN_CHAT);
        const pythonAdvice = `Start writing python or Press ${_lumino_commands__WEBPACK_IMPORTED_MODULE_2__.CommandRegistry.formatKeystroke((_a = keyBindings === null || keyBindings === void 0 ? void 0 : keyBindings.keys[0]) !== null && _a !== void 0 ? _a : 'Accel E')
            .split(/[+\s]/)
            .map(s => `<kbd>${s}</kbd>`)
            .join(' + ')} to ask Mito AI to write code for you.`;
        extensions.addExtension({
            name: 'mito-ai:empty-editor-advice',
            factory: options => {
                let advice = ''; // Default advice
                // Add the advice only for cells (not for file editor)
                if (options.inline) {
                    let guessedMimeType = options.model.mimeType;
                    if (guessedMimeType === _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.IEditorMimeTypeService.defaultMimeType &&
                        options.model.type === 'code') {
                        // Assume the kernel is not yet ready and will be a Python one.
                        // FIXME it will be better to deal with model.mimeTypeChanged signal
                        // but this is gonna be hard.
                        guessedMimeType = 'text/x-ipython';
                    }
                    // Tune the advice with the mimetype
                    switch (guessedMimeType) {
                        case 'text/x-ipython': // Python code cell
                            advice = pythonAdvice;
                            break;
                        case 'text/x-ipythongfm': // Jupyter Markdown cell
                            advice = 'Start writing markdown.';
                            break;
                    }
                }
                return _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_1__.EditorExtensionRegistry.createImmutableExtension((0,_emptyCell__WEBPACK_IMPORTED_MODULE_5__.advicePlugin)({
                    advice
                }));
            }
        });
        console.log("mito-ai: EmptyCellPlugin activated");
    }
};


/***/ }),

/***/ "./lib/Extensions/emptyCell/emptyCell.js":
/*!***********************************************!*\
  !*** ./lib/Extensions/emptyCell/emptyCell.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   advicePlugin: () => (/* binding */ advicePlugin),
/* harmony export */   showAdvice: () => (/* binding */ showAdvice)
/* harmony export */ });
/* harmony import */ var _codemirror_state__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @codemirror/state */ "webpack/sharing/consume/default/@codemirror/state");
/* harmony import */ var _codemirror_state__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_codemirror_state__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @codemirror/view */ "webpack/sharing/consume/default/@codemirror/view");
/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_codemirror_view__WEBPACK_IMPORTED_MODULE_1__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


/**
 * Theme for the advice widget.
 */
const adviceTheme = _codemirror_view__WEBPACK_IMPORTED_MODULE_1__.EditorView.baseTheme({
    '& .cm-mito-advice': {
        color: 'var(--jp-ui-font-color3)',
        fontStyle: 'italic'
    },
    '& .cm-mito-advice > kbd': {
        borderRadius: '3px',
        borderStyle: 'solid',
        borderWidth: '1px',
        fontSize: 'calc(var(--jp-code-font-size) - 2px)',
        padding: '3px 5px',
        verticalAlign: 'middle'
    }
});
/**
 * A facet that stores the chat shortcut.
 */
const adviceText = _codemirror_state__WEBPACK_IMPORTED_MODULE_0__.Facet.define({
    // @ts-expect-error - Ignoring this error because I don't want to mess with codemirror for now
    combine: values => (values.length ? values[values.length - 1] : '')
});
class AdviceWidget extends _codemirror_view__WEBPACK_IMPORTED_MODULE_1__.WidgetType {
    constructor(advice) {
        super();
        this.advice = advice;
    }
    eq(_) {
        return false;
    }
    toDOM() {
        const wrap = document.createElement('span');
        wrap.className = 'cm-mito-advice';
        wrap.innerHTML = this.advice;
        return wrap;
    }
}
function shouldDisplayAdvice(view) {
    const shortcut = view.state.facet(adviceText);
    const widgets = [];
    if (view.hasFocus && view.state.doc.length == 0) {
        const deco = _codemirror_view__WEBPACK_IMPORTED_MODULE_1__.Decoration.widget({
            widget: new AdviceWidget(shortcut),
            side: 1
        });
        widgets.push(deco.range(0));
    }
    return _codemirror_view__WEBPACK_IMPORTED_MODULE_1__.Decoration.set(widgets);
}
const showAdvice = _codemirror_view__WEBPACK_IMPORTED_MODULE_1__.ViewPlugin.fromClass(class {
    constructor(view) {
        this.decorations = shouldDisplayAdvice(view);
    }
    update(update) {
        const advice = update.view.state.facet(adviceText);
        if (update.docChanged ||
            update.focusChanged ||
            advice !== update.startState.facet(adviceText)) {
            this.decorations = shouldDisplayAdvice(update.view);
        }
    }
}, {
    decorations: v => v.decorations,
    provide: () => [adviceTheme]
});
function advicePlugin(options = {}) {
    var _a;
    return [adviceText.of((_a = options.advice) !== null && _a !== void 0 ? _a : ''), showAdvice];
}


/***/ }),

/***/ "./lib/Extensions/status/index.js":
/*!****************************************!*\
  !*** ./lib/Extensions/status/index.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   statusItem: () => (/* binding */ statusItem)
/* harmony export */ });
/* harmony import */ var _jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/statusbar */ "webpack/sharing/consume/default/@jupyterlab/statusbar");
/* harmony import */ var _jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../icons */ "./lib/icons/index.js");
/* harmony import */ var _AiChat_token__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../AiChat/token */ "./lib/Extensions/AiChat/token.js");
/* harmony import */ var _utils_errors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/errors */ "./lib/utils/errors.js");
/* harmony import */ var _components_TextButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/TextButton */ "./lib/components/TextButton.js");
/* harmony import */ var _utils_stripe__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/stripe */ "./lib/utils/stripe.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */








/**
 * Mito AI status model
 */
class StatusModel extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.VDomModel {
    constructor(chatPanel) {
        super();
        this.chatPanel = chatPanel;
        chatPanel.capabilitiesChanged.connect(this._onCapabilitiesChanged, this);
        chatPanel.lastErrorChanged.connect(this._onLastErrorChanged, this);
    }
    /**
     * AI capabilities.
     */
    get capabilities() {
        return this._capabilities;
    }
    /**
     * Latest seen error.
     */
    get lastError() {
        return this._lastError;
    }
    _onCapabilitiesChanged(_, capabilities) {
        this._capabilities = capabilities;
        this.stateChanged.emit(void 0);
    }
    _onLastErrorChanged(_, error) {
        this._lastError = error.error_type ? error : undefined;
        this.stateChanged.emit(void 0);
    }
}
/**
 * Mito AI status popup.
 */
class StatusPopUp extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.VDomRenderer {
    render() {
        var _a, _b, _c, _d;
        let status_paragraph = react__WEBPACK_IMPORTED_MODULE_2___default().createElement("p", { className: 'mito-ai-status-ready' }, "Ready");
        if (((_a = this.model.lastError) === null || _a === void 0 ? void 0 : _a.title) == _utils_errors__WEBPACK_IMPORTED_MODULE_3__.FREE_TIER_LIMIT_REACHED_ERROR_TITLE) {
            status_paragraph = react__WEBPACK_IMPORTED_MODULE_2___default().createElement("p", { className: 'mito-ai-status-error' }, "Free Trial Expired");
        }
        return (react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", { className: "mito-ai-status-popup" },
            react__WEBPACK_IMPORTED_MODULE_2___default().createElement("h3", null, "Mito AI Status"),
            react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", { className: 'mito-ai-status-popup-table-row' },
                react__WEBPACK_IMPORTED_MODULE_2___default().createElement("p", null, "Status:"),
                status_paragraph),
            react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", { className: 'mito-ai-status-popup-table-row' },
                react__WEBPACK_IMPORTED_MODULE_2___default().createElement("p", null, "Provider:"),
                react__WEBPACK_IMPORTED_MODULE_2___default().createElement("p", null, (_c = (_b = this.model.capabilities) === null || _b === void 0 ? void 0 : _b.provider) !== null && _c !== void 0 ? _c : 'None')),
            ((_d = this.model.lastError) === null || _d === void 0 ? void 0 : _d.title) == _utils_errors__WEBPACK_IMPORTED_MODULE_3__.FREE_TIER_LIMIT_REACHED_ERROR_TITLE && (react__WEBPACK_IMPORTED_MODULE_2___default().createElement((react__WEBPACK_IMPORTED_MODULE_2___default().Fragment), null,
                react__WEBPACK_IMPORTED_MODULE_2___default().createElement("p", null,
                    "\u26A0\uFE0F You've used up your free Mito AI completions for this month. Upgrade to ",
                    react__WEBPACK_IMPORTED_MODULE_2___default().createElement("a", { href: "https://www.trymito.io/plans", target: "_blank", rel: "noreferrer" }, "Mito Pro"),
                    " or supply your own Open AI Key to continue using Mito AI."),
                react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_components_TextButton__WEBPACK_IMPORTED_MODULE_4__["default"], { title: "Upgrade to Pro", text: "Upgrade to Pro", action: _utils_stripe__WEBPACK_IMPORTED_MODULE_5__.STRIPE_PAYMENT_LINK, variant: 'gray', width: 'block' }))),
            this.model.lastError && this.model.lastError.title !== _utils_errors__WEBPACK_IMPORTED_MODULE_3__.FREE_TIER_LIMIT_REACHED_ERROR_TITLE && (react__WEBPACK_IMPORTED_MODULE_2___default().createElement((react__WEBPACK_IMPORTED_MODULE_2___default().Fragment), null,
                react__WEBPACK_IMPORTED_MODULE_2___default().createElement("p", null, "Last error:"),
                react__WEBPACK_IMPORTED_MODULE_2___default().createElement("ul", null,
                    react__WEBPACK_IMPORTED_MODULE_2___default().createElement("li", null,
                        "Type: ",
                        this.model.lastError.error_type),
                    react__WEBPACK_IMPORTED_MODULE_2___default().createElement("li", null,
                        "Title: ",
                        this.model.lastError.title),
                    this.model.lastError.hint && (react__WEBPACK_IMPORTED_MODULE_2___default().createElement("li", null,
                        "Hint: ",
                        this.model.lastError.hint)))))));
    }
}
const MITO_AI_ERROR_CLASS = 'mito-ai-error';
/**
 * Mito widget to display in the status bar.
 */
class StatusItem extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.ReactWidget {
    constructor(model) {
        super();
        this.model = model;
        this._hasError = false;
        this._popup = null;
        model.stateChanged.connect(this._onLastErrorChanged, this);
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.Button, { className: "mito-ai-status-button", onClick: () => {
                this._onClick();
            }, minimal: true, small: true, title: "Mito AI Status" },
            "Mito AI \u00A0 ",
            react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_icons__WEBPACK_IMPORTED_MODULE_6__.NucleusLabIcon.react, { tag: 'span', stylesheet: 'statusBar' })));
    }
    _onLastErrorChanged() {
        var _a, _b;
        if (this.model.lastError) {
            this._hasError = true;
            (_a = this.node.querySelector('button')) === null || _a === void 0 ? void 0 : _a.classList.add(MITO_AI_ERROR_CLASS);
        }
        else {
            if (this._hasError) {
                this._hasError = false;
                (_b = this.node
                    .querySelector('button')) === null || _b === void 0 ? void 0 : _b.classList.remove(MITO_AI_ERROR_CLASS);
            }
        }
    }
    _onClick() {
        if (this._popup && !this._popup.isDisposed) {
            this._popup.dispose();
        }
        else {
            this._popup = (0,_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_0__.showPopup)({
                body: new StatusPopUp(this.model),
                anchor: this,
                align: 'right',
                hasDynamicSize: true
            });
        }
    }
}
const statusItem = {
    id: 'mito_ai:status-item',
    autoStart: true,
    requires: [_AiChat_token__WEBPACK_IMPORTED_MODULE_7__.IChatTracker, _jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_0__.IStatusBar],
    activate: (app, chatTracker, statusBar) => {
        let registered = false;
        const registerMitoStatus = (chatPanel) => {
            if (registered) {
                return;
            }
            registered = true;
            const model = new StatusModel(chatPanel);
            const renderer = new StatusItem(model);
            statusBar.registerStatusItem('mito-ai:status-item', {
                item: renderer,
                align: 'right',
                rank: 0
            });
        };
        if (chatTracker.currentWidget) {
            registerMitoStatus(chatTracker.currentWidget);
        }
        else {
            chatTracker.widgetAdded.connect((_, chatPanel) => {
                registerMitoStatus(chatPanel);
            });
        }
    }
};


/***/ }),

/***/ "./lib/commands.js":
/*!*************************!*\
  !*** ./lib/commands.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   COMMAND_MITO_AI_APPLY_LATEST_CODE: () => (/* binding */ COMMAND_MITO_AI_APPLY_LATEST_CODE),
/* harmony export */   COMMAND_MITO_AI_BETA_MODE_ENABLED: () => (/* binding */ COMMAND_MITO_AI_BETA_MODE_ENABLED),
/* harmony export */   COMMAND_MITO_AI_CELL_TOOLBAR_ACCEPT_CODE: () => (/* binding */ COMMAND_MITO_AI_CELL_TOOLBAR_ACCEPT_CODE),
/* harmony export */   COMMAND_MITO_AI_CELL_TOOLBAR_REJECT_CODE: () => (/* binding */ COMMAND_MITO_AI_CELL_TOOLBAR_REJECT_CODE),
/* harmony export */   COMMAND_MITO_AI_OPEN_CHAT: () => (/* binding */ COMMAND_MITO_AI_OPEN_CHAT),
/* harmony export */   COMMAND_MITO_AI_PREVIEW_AS_STREAMLIT: () => (/* binding */ COMMAND_MITO_AI_PREVIEW_AS_STREAMLIT),
/* harmony export */   COMMAND_MITO_AI_PREVIEW_LATEST_CODE: () => (/* binding */ COMMAND_MITO_AI_PREVIEW_LATEST_CODE),
/* harmony export */   COMMAND_MITO_AI_REJECT_LATEST_CODE: () => (/* binding */ COMMAND_MITO_AI_REJECT_LATEST_CODE),
/* harmony export */   COMMAND_MITO_AI_SEND_AGENT_MESSAGE: () => (/* binding */ COMMAND_MITO_AI_SEND_AGENT_MESSAGE),
/* harmony export */   COMMAND_MITO_AI_SEND_DEBUG_ERROR_MESSAGE: () => (/* binding */ COMMAND_MITO_AI_SEND_DEBUG_ERROR_MESSAGE),
/* harmony export */   COMMAND_MITO_AI_SEND_EXPLAIN_CODE_MESSAGE: () => (/* binding */ COMMAND_MITO_AI_SEND_EXPLAIN_CODE_MESSAGE),
/* harmony export */   COMMAND_MITO_AI_SEND_MESSAGE: () => (/* binding */ COMMAND_MITO_AI_SEND_MESSAGE)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
const MITO_AI = 'mito_ai';
const COMMAND_MITO_AI_OPEN_CHAT = `${MITO_AI}:open-chat`;
const COMMAND_MITO_AI_PREVIEW_LATEST_CODE = `${MITO_AI}:preview-latest-code`;
const COMMAND_MITO_AI_APPLY_LATEST_CODE = `${MITO_AI}:apply-latest-code`;
const COMMAND_MITO_AI_REJECT_LATEST_CODE = `${MITO_AI}:reject-latest-code`;
const COMMAND_MITO_AI_SEND_MESSAGE = `${MITO_AI}:send-message`;
const COMMAND_MITO_AI_SEND_EXPLAIN_CODE_MESSAGE = `${MITO_AI}:send-explain-code-message`;
const COMMAND_MITO_AI_SEND_DEBUG_ERROR_MESSAGE = `${MITO_AI}:send-debug-error-message`;
const COMMAND_MITO_AI_SEND_AGENT_MESSAGE = `${MITO_AI}:send-agent-message`;
const COMMAND_MITO_AI_CELL_TOOLBAR_ACCEPT_CODE = `toolbar-button:accept-code`;
const COMMAND_MITO_AI_CELL_TOOLBAR_REJECT_CODE = `toolbar-button:reject-code`;
// Beta mode commands
const COMMAND_MITO_AI_BETA_MODE_ENABLED = `${MITO_AI}:beta-mode-enabled`;
// Streamlit commands
const COMMAND_MITO_AI_PREVIEW_AS_STREAMLIT = 'mito-ai:preview-as-streamlit';


/***/ }),

/***/ "./lib/components/AgentComponents/AgentComponentHeader.js":
/*!****************************************************************!*\
  !*** ./lib/components/AgentComponents/AgentComponentHeader.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/classNames */ "./lib/utils/classNames.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


const AgentComponentHeader = ({ icon, text, onClick, isExpanded, displayBorder = true, className }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { onClick: onClick, className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_1__.classNames)('agent-component-header', {
            expanded: isExpanded,
            'no-border': !displayBorder
        }, className) },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "agent-component-header-content" },
            icon,
            text),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_1__.classNames)('agent-component-header-expand-icon', {
                expanded: isExpanded
            }), width: "16", height: "16", viewBox: "0 0 16 16", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M4 6L8 10L12 6", stroke: "currentColor", strokeWidth: "1.5", strokeLinecap: "round", strokeLinejoin: "round", transform: isExpanded ? 'rotate(90 8 8)' : 'rotate(0 8 8)' }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AgentComponentHeader);


/***/ }),

/***/ "./lib/components/AgentComponents/AssumptionToolUI.js":
/*!************************************************************!*\
  !*** ./lib/components/AgentComponents/AssumptionToolUI.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/classNames */ "./lib/utils/classNames.js");
/* harmony import */ var _style_AssumptionTool_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../style/AssumptionTool.css */ "./style/AssumptionTool.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */



const AssumptionToolUI = ({ assumptions, }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_2__.classNames)('assumption-tool-container') },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "assumption-header-label" }, "Assumption"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_2__.classNames)('assumption-content') },
            assumptions.length > 1 && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", null, assumptions.map((assumption, index) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { key: index }, assumption))))),
            assumptions.length === 1 && (assumptions[0]))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AssumptionToolUI);


/***/ }),

/***/ "./lib/components/AgentComponents/ErrorFixupToolUI.js":
/*!************************************************************!*\
  !*** ./lib/components/AgentComponents/ErrorFixupToolUI.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/classNames */ "./lib/utils/classNames.js");
/* harmony import */ var _utils_strings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/strings */ "./lib/utils/strings.js");
/* harmony import */ var _Extensions_AiChat_ChatMessage_PythonCode__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../Extensions/AiChat/ChatMessage/PythonCode */ "./lib/Extensions/AiChat/ChatMessage/PythonCode.js");
/* harmony import */ var _Extensions_AiChat_ChatMessage_AssistantCodeBlock__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../Extensions/AiChat/ChatMessage/AssistantCodeBlock */ "./lib/Extensions/AiChat/ChatMessage/AssistantCodeBlock.js");
/* harmony import */ var _icons_AlertIcon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../icons/AlertIcon */ "./lib/icons/AlertIcon.js");
/* harmony import */ var _AgentComponentHeader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./AgentComponentHeader */ "./lib/components/AgentComponents/AgentComponentHeader.js");
/* harmony import */ var _style_ErrorFixupToolUI_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../style/ErrorFixupToolUI.css */ "./style/ErrorFixupToolUI.css");
/* harmony import */ var _style_AgentComponentHeader_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../style/AgentComponentHeader.css */ "./style/AgentComponentHeader.css");
/* harmony import */ var _RunAllCellsToolUI__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./RunAllCellsToolUI */ "./lib/components/AgentComponents/RunAllCellsToolUI.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */










const parsePythonErrorType = (content) => {
    if (!content)
        return 'Error';
    const errorMatch = content.match(/(\w+Error):/);
    return (errorMatch === null || errorMatch === void 0 ? void 0 : errorMatch[1]) || 'Error';
};
const processErrorContent = (content) => {
    if (!content)
        return '';
    // Remove all Python code (content between triple backticks).
    // If we don't do this, the PythonCode component will remove the error content,
    // and only show the code block. 
    return content.replace(/```(?:python)?[\s\S]*?```/g, '').trim();
};
const ErrorDetectedBlock = ({ errorMessage, renderMimeRegistry, }) => {
    const [expandedError, setExpandedError] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const rawErrorContent = (0,_utils_strings__WEBPACK_IMPORTED_MODULE_3__.getContentStringFromMessage)(errorMessage);
    const errorContent = processErrorContent(rawErrorContent);
    const errorType = parsePythonErrorType(errorContent);
    const toggleError = () => {
        setExpandedError(!expandedError);
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_4__.classNames)('error-fixup-container', { expanded: expandedError }) },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_AgentComponentHeader__WEBPACK_IMPORTED_MODULE_5__["default"], { icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_AlertIcon__WEBPACK_IMPORTED_MODULE_6__["default"], null), text: `${errorType} Detected`, onClick: toggleError, isExpanded: expandedError, displayBorder: false }),
        expandedError && errorContent && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "error-fixup-expanded" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Extensions_AiChat_ChatMessage_PythonCode__WEBPACK_IMPORTED_MODULE_7__["default"], { code: errorContent, renderMimeRegistry: renderMimeRegistry })))));
};
const GroupedErrorsAndFixes = ({ messages, renderMimeRegistry, }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "error-fixup-root" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "error-fixup-header" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Fixing an error")),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "error-fixup-messages-container" }, messages.map((messageItem, index) => {
            var _a, _b, _c, _d;
            const isUserMessage = messageItem.message.role === 'user';
            if (isUserMessage) {
                return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ErrorDetectedBlock, { key: `error-${index}`, errorMessage: messageItem.message, renderMimeRegistry: renderMimeRegistry }));
            }
            if (((_a = messageItem.agentResponse) === null || _a === void 0 ? void 0 : _a.type) === 'run_all_cells') {
                return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_RunAllCellsToolUI__WEBPACK_IMPORTED_MODULE_8__["default"], { key: `run-all-cells-${index}`, inErrorFixup: true }));
            }
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Extensions_AiChat_ChatMessage_AssistantCodeBlock__WEBPACK_IMPORTED_MODULE_9__["default"], { key: `assistant-${index}`, code: messageItem.message.content, codeSummary: (_d = (_c = (_b = messageItem.agentResponse) === null || _b === void 0 ? void 0 : _b.cell_update) === null || _c === void 0 ? void 0 : _c.code_summary) !== null && _d !== void 0 ? _d : 'Fixing error', isCodeComplete: true, renderMimeRegistry: renderMimeRegistry, previewAICode: () => { }, acceptAICode: () => { }, rejectAICode: () => { }, isLastAiMessage: false, codeReviewStatus: "chatPreview", agentModeEnabled: true, isErrorFixup: true }));
        }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (GroupedErrorsAndFixes);


/***/ }),

/***/ "./lib/components/AgentComponents/GetCellOutputToolUI.js":
/*!***************************************************************!*\
  !*** ./lib/components/AgentComponents/GetCellOutputToolUI.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _icons_MagnifyingGlassIcon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../icons/MagnifyingGlassIcon */ "./lib/icons/MagnifyingGlassIcon.js");
/* harmony import */ var _style_AgentToolUIComponent_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../style/AgentToolUIComponent.css */ "./style/AgentToolUIComponent.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */



const GetCellOutputToolUI = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "agent-tool-ui-container" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "agent-tool-ui-content" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_MagnifyingGlassIcon__WEBPACK_IMPORTED_MODULE_2__["default"], null),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Taking a look at the cell output"))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (GetCellOutputToolUI);


/***/ }),

/***/ "./lib/components/AgentComponents/RunAllCellsToolUI.js":
/*!*************************************************************!*\
  !*** ./lib/components/AgentComponents/RunAllCellsToolUI.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _icons_PlayButtonIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../icons/PlayButtonIcon */ "./lib/icons/PlayButtonIcon.js");
/* harmony import */ var _style_AgentToolUIComponent_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../style/AgentToolUIComponent.css */ "./style/AgentToolUIComponent.css");
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/classNames */ "./lib/utils/classNames.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const RunAllCellsToolUI = ({ inErrorFixup }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_2__.classNames)('agent-tool-ui-container', {
            'agent-tool-ui-error-fixup': inErrorFixup,
        }) },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "agent-tool-ui-content" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_PlayButtonIcon__WEBPACK_IMPORTED_MODULE_3__["default"], null),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Running all cells"))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RunAllCellsToolUI);


/***/ }),

/***/ "./lib/components/AttachFileButton.js":
/*!********************************************!*\
  !*** ./lib/components/AttachFileButton.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _IconButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./IconButton */ "./lib/components/IconButton.js");
/* harmony import */ var _icons_PaperClipIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../icons/PaperClipIcon */ "./lib/icons/PaperClipIcon.js");
/* harmony import */ var _restAPI_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../restAPI/utils */ "./lib/restAPI/utils.js");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */





// Constants for file handling
const CHUNKED_UPLOAD_SIZE_CUTOFF = 25 * 1024 * 1024; // 25MB cutoff for chunked uploads
const CHUNK_SIZE = 10 * 1024 * 1024; // 10MB chunks
const AttachFileButton = ({ onFileUploaded, notebookTracker }) => {
    const fileInputRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    const [isUploading, setIsUploading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    // Helper function to get notebook directory from notebook path
    const getNotebookDirectory = (notebookPath) => {
        const lastSlashIndex = notebookPath.lastIndexOf('/');
        if (lastSlashIndex === -1) {
            // No directory, just filename (root directory)
            return '.';
        }
        return notebookPath.substring(0, lastSlashIndex);
    };
    const handleClick = () => {
        var _a;
        // Don't allow clicks if uploading
        if (isUploading)
            return;
        // Trigger the hidden file input
        (_a = fileInputRef.current) === null || _a === void 0 ? void 0 : _a.click();
    };
    const handleFileSelect = async (event) => {
        const files = event.target.files;
        if (!files || files.length === 0)
            return;
        const file = files[0];
        if (!file)
            return;
        // Don't allow new uploads if already uploading
        if (isUploading)
            return;
        setIsUploading(true);
        try {
            // Check file size and handle accordingly
            if (file.size > CHUNKED_UPLOAD_SIZE_CUTOFF) {
                console.log(`File ${file.name} is larger than 25MB (${(file.size / (1024 * 1024)).toFixed(2)}MB). Splitting into chunks...`);
                await handleLargeFile(file);
            }
            else {
                // Upload file directly for files <= 25MB
                await uploadFile(file);
            }
        }
        catch (error) {
            _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Notification.emit(`Upload failed: ${error}`, "error", {
                autoClose: 5 * 1000 // 5 seconds
            });
            console.error('Error during file upload:', error);
        }
        finally {
            setIsUploading(false);
            // Clear the file input
            if (fileInputRef.current) {
                fileInputRef.current.value = '';
            }
        }
    };
    const handleLargeFile = async (file) => {
        const totalChunks = Math.ceil(file.size / CHUNK_SIZE);
        console.log(`Splitting file into ${totalChunks} chunks of ${(CHUNK_SIZE / (1024 * 1024)).toFixed(2)}MB each`);
        // Get notebook directory path
        const notebookPanel = notebookTracker.currentWidget;
        if (!notebookPanel) {
            console.error('No notebook is currently active');
            throw new Error('No notebook is currently active');
        }
        const notebookPath = notebookPanel.context.path;
        const notebookDir = getNotebookDirectory(notebookPath);
        for (let chunkIndex = 0; chunkIndex < totalChunks; chunkIndex++) {
            const start = chunkIndex * CHUNK_SIZE;
            const end = Math.min(start + CHUNK_SIZE, file.size);
            const chunk = file.slice(start, end);
            console.log(`Uploading chunk ${chunkIndex + 1}/${totalChunks}:`, {
                chunkNumber: chunkIndex + 1,
                totalChunks: totalChunks,
                chunkSize: chunk.size,
                chunkSizeMB: (chunk.size / (1024 * 1024)).toFixed(2),
                startByte: start,
                endByte: end,
                fileName: file.name,
                originalFileSize: file.size,
                originalFileSizeMB: (file.size / (1024 * 1024)).toFixed(2)
            });
            // Upload chunk to backend
            const success = await uploadChunk(chunk, file.name, chunkIndex + 1, totalChunks, notebookDir);
            if (!success) {
                console.error(`Failed to upload chunk ${chunkIndex + 1}`);
                throw new Error(`Failed to upload chunk ${chunkIndex + 1}`);
            }
        }
        console.log(`Successfully uploaded all ${totalChunks} chunks for file: ${file.name}`);
        // Notify the parent component that the file was uploaded
        onFileUploaded(file);
    };
    const uploadChunk = async (chunk, filename, chunkNumber, totalChunks, notebookDir) => {
        try {
            // Create FormData for chunk upload
            const formData = new FormData();
            formData.append('file', chunk, filename);
            formData.append('chunk_number', chunkNumber.toString());
            formData.append('total_chunks', totalChunks.toString());
            formData.append('notebook_dir', notebookDir);
            // Upload chunk to backend
            const resp = await (0,_restAPI_utils__WEBPACK_IMPORTED_MODULE_2__.requestAPI)('upload', {
                method: 'POST',
                body: formData
            });
            if (resp.error) {
                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Notification.emit(`Upload failed: ${resp.error.message}`, "error", {
                    autoClose: 5 * 1000 // 5 seconds
                });
                console.error(`Chunk ${chunkNumber} upload failed:`, resp.error.message);
                return false;
            }
            else if (resp.data) {
                if (resp.data.chunk_complete) {
                    console.log(`All chunks uploaded successfully. File reconstructed: ${resp.data.filename}`);
                }
                else if (resp.data.chunk_received) {
                    console.log(`Chunk ${resp.data.chunk_number}/${resp.data.total_chunks} uploaded successfully`);
                }
                return true;
            }
            return false;
        }
        catch (error) {
            _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Notification.emit(`Upload failed: ${error}`, "error", {
                autoClose: 5 * 1000 // 5 seconds
            });
            console.error(`Error uploading chunk ${chunkNumber}:`, error);
            return false;
        }
    };
    const uploadFile = async (file) => {
        // Get notebook directory path
        const notebookPanel = notebookTracker.currentWidget;
        if (!notebookPanel) {
            console.error('No notebook is currently active');
            throw new Error('No notebook is currently active');
        }
        const notebookPath = notebookPanel.context.path;
        const notebookDir = getNotebookDirectory(notebookPath);
        // Create FormData for file upload
        const formData = new FormData();
        formData.append('file', file);
        formData.append('notebook_dir', notebookDir);
        // Upload file to backend using FormData
        const resp = await (0,_restAPI_utils__WEBPACK_IMPORTED_MODULE_2__.requestAPI)('upload', {
            method: 'POST',
            body: formData
        });
        if (resp.error) {
            _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Notification.emit(`Upload failed: ${resp.error.message}`, "error", {
                autoClose: 5 * 1000 // 5 seconds
            });
            console.error('Upload failed:', resp.error.message);
        }
        else if (resp.data) {
            console.log('File uploaded successfully:', resp.data);
            // Notify the parent component that the file was uploaded, 
            // which will update the context manager.
            onFileUploaded(file);
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { position: 'relative' } },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { ref: fileInputRef, type: "file", style: { display: 'none' }, onChange: handleFileSelect, accept: "*" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_IconButton__WEBPACK_IMPORTED_MODULE_3__["default"], { icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_PaperClipIcon__WEBPACK_IMPORTED_MODULE_4__["default"], null), title: isUploading ? 'Uploading...' : 'Attach File', onClick: handleClick, className: 'icon-button-hover', disabled: isUploading, style: {
                ...(isUploading && { opacity: 0.5 }),
                cursor: isUploading ? 'not-allowed' : 'pointer'
            } })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AttachFileButton);


/***/ }),

/***/ "./lib/components/DatabaseButton.js":
/*!******************************************!*\
  !*** ./lib/components/DatabaseButton.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _IconButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./IconButton */ "./lib/components/IconButton.js");
/* harmony import */ var _icons_DatabaseOutlineIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../icons/DatabaseOutlineIcon */ "./lib/icons/DatabaseOutlineIcon.js");
/* harmony import */ var _Extensions_SettingsManager_SettingsManagerPlugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Extensions/SettingsManager/SettingsManagerPlugin */ "./lib/Extensions/SettingsManager/SettingsManagerPlugin.js");
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */





const DatabaseButton = ({ app }) => {
    const [databaseConnections, setDatabaseConnections] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    const [isIconVisible, setIsIconVisible] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true);
    // Fetch database connections
    const fetchDatabaseConnections = async () => {
        const databaseConnections = await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__.getDatabaseConnections)();
        setDatabaseConnections(databaseConnections);
    };
    // Fetch database connections
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        void fetchDatabaseConnections();
    }, []);
    // Determine notification dot type based on connections
    const getNotificationDotType = () => {
        if (!isIconVisible) {
            return null;
        }
        return Object.keys(databaseConnections).length > 0 ? 'success' : 'warning';
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_IconButton__WEBPACK_IMPORTED_MODULE_2__["default"], { icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_DatabaseOutlineIcon__WEBPACK_IMPORTED_MODULE_3__["default"], null), title: 'Add Database', onClick: () => {
            void app.commands.execute(_Extensions_SettingsManager_SettingsManagerPlugin__WEBPACK_IMPORTED_MODULE_4__.COMMAND_MITO_AI_SETTINGS);
            setIsIconVisible(false);
        }, notificationDotType: getNotificationDotType(), className: 'icon-button-hover', style: {
            height: 'var(--chat-context-button-height)'
        } }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DatabaseButton);


/***/ }),

/***/ "./lib/components/DropdownMenu.js":
/*!****************************************!*\
  !*** ./lib/components/DropdownMenu.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_DropdownMenu_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../style/DropdownMenu.css */ "./style/DropdownMenu.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


const DropdownMenu = ({ trigger, items, className = '', alignment = 'left', }) => {
    const [isOpen, setIsOpen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const dropdownRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    // Close dropdown when clicking outside
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const handleClickOutside = (event) => {
            if (dropdownRef.current &&
                !dropdownRef.current.contains(event.target)) {
                setIsOpen(false);
            }
        };
        document.addEventListener('mousedown', handleClickOutside);
        return () => document.removeEventListener('mousedown', handleClickOutside);
    }, []);
    // Handle the main click (primary action)
    const handlePrimaryClick = (onClick, disabled) => {
        if (disabled)
            return;
        onClick();
        setIsOpen(false);
    };
    // Choose the alignment class
    const alignmentClass = alignment === 'right' ? 'dropdown-menu-right' : 'dropdown-menu-left';
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `dropdown-container ${className}`, ref: dropdownRef },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { onClick: () => setIsOpen(!isOpen) }, trigger),
        isOpen && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `dropdown-menu ${alignmentClass}` }, items.map((item, index) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: index, className: `dropdown-item-row ${item.disabled ? 'dropdown-item-disabled' : ''}` },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "dropdown-item-main", onClick: () => handlePrimaryClick(item.onClick, item.disabled), disabled: item.disabled, title: item.disabled ? item.disabledTooltip : item.label },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "dropdown-item-icon" }, item.primaryIcon && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(item.primaryIcon)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "dropdown-item-label" }, item.label)),
            item.secondaryActions && item.secondaryActions.map((action, actionIndex) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { key: actionIndex, className: "dropdown-item-secondary", onClick: (e) => {
                    e.stopPropagation(); // prevent triggering the main onClick
                    if (!action.disabled) {
                        action.onClick();
                        setIsOpen(false); // optional: close the dropdown after secondary action
                    }
                }, disabled: action.disabled, title: action.tooltip, style: {
                    background: 'none',
                    border: 'none',
                    cursor: action.disabled ? 'default' : 'pointer',
                    padding: 0,
                } }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(action.icon, { fill: 'currentColor' })))))))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DropdownMenu);


/***/ }),

/***/ "./lib/components/IconButton.js":
/*!**************************************!*\
  !*** ./lib/components/IconButton.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_IconButton_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../style/IconButton.css */ "./style/IconButton.css");
/* harmony import */ var _style_button_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../style/button.css */ "./style/button.css");
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/classNames */ "./lib/utils/classNames.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const IconButton = ({ icon, onClick, title, style, notificationDotType = null, className, disabled = false }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_3__.classNames)("icon-button", className), onClick: onClick, title: title, style: style, disabled: disabled },
        icon,
        notificationDotType && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `notification-dot notification-dot-${notificationDotType}` })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (IconButton);


/***/ }),

/***/ "./lib/components/LoadingCircle.js":
/*!*****************************************!*\
  !*** ./lib/components/LoadingCircle.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
// Copyright (c) Mito

/*
    A spinning circle loading indicator that inherits its color from the parent component.
*/
const LoadingCircle = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "16", height: "16", viewBox: "0 0 16 16", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", { cx: "8", cy: "8", r: "7", stroke: "currentColor", strokeWidth: "2", opacity: "0.25" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M8 1C11.866 1 15 4.13401 15 8", stroke: "currentColor", strokeWidth: "2", strokeLinecap: "round" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animateTransform", { attributeName: "transform", attributeType: "XML", type: "rotate", from: "0 8 8", to: "360 8 8", dur: "1s", repeatCount: "indefinite" }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LoadingCircle);


/***/ }),

/***/ "./lib/components/LoadingDots.js":
/*!***************************************!*\
  !*** ./lib/components/LoadingDots.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
// Copyright (c) Mito

/*
    Dot, dot, dots. They count, so that you can display something as loading.
*/
const LoadingDots = () => {
    // We use a count to track the number of ...s to display.
    // 0 -> '', 1 -> '.', 2 -> '..', 3 -> '...'. Wraps % 4.
    const [indicatorState, setIndicatorState] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(1);
    // Schedule a change to update the loading indicator, every .5 seconds
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const interval = setInterval(() => {
            setIndicatorState(indicatorState => indicatorState + 1);
        }, 500);
        return () => clearInterval(interval);
    }, []);
    const someNumberOfDots = '.'.repeat(indicatorState % 4);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, someNumberOfDots));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LoadingDots);


/***/ }),

/***/ "./lib/components/ModelSelector.js":
/*!*****************************************!*\
  !*** ./lib/components/ModelSelector.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DEFAULT_MODEL: () => (/* binding */ DEFAULT_MODEL),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_ModelSelector_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../style/ModelSelector.css */ "./style/ModelSelector.css");
/* harmony import */ var _icons_NucleausIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../icons/NucleausIcon */ "./lib/icons/NucleausIcon.js");
/* harmony import */ var _utils_models__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/models */ "./lib/utils/models.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const MODEL_MAPPINGS = [
    { displayName: 'GPT 4.1', fullName: 'gpt-4.1' },
    { displayName: _utils_models__WEBPACK_IMPORTED_MODULE_2__.CLAUDE_SONNET_DISPLAY_NAME, fullName: _utils_models__WEBPACK_IMPORTED_MODULE_2__.CLAUDE_SONNET_MODEL_NAME },
    { displayName: 'Gemini 2.5 Pro', fullName: 'gemini-2.5-pro-preview-03-25' }
];
const ALL_MODEL_DISPLAY_NAMES = MODEL_MAPPINGS.map(mapping => mapping.displayName);
// Maximum length for displayed model name before truncating
const DEFAULT_MODEL = _utils_models__WEBPACK_IMPORTED_MODULE_2__.CLAUDE_SONNET_DISPLAY_NAME;
const ModelSelector = ({ onConfigChange }) => {
    const [selectedModel, setSelectedModel] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(DEFAULT_MODEL);
    const [isOpen, setIsOpen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    // Load config from localStorage on component mount and notify parent
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        var _a;
        const storedConfig = localStorage.getItem('llmModelConfig');
        let fullModelName;
        let displayName;
        if (storedConfig) {
            try {
                const parsedConfig = JSON.parse(storedConfig);
                fullModelName = parsedConfig.model;
                displayName = (_a = MODEL_MAPPINGS.find(m => m.fullName === fullModelName)) === null || _a === void 0 ? void 0 : _a.displayName;
            }
            catch (e) {
                console.error('Failed to parse stored LLM config', e);
            }
        }
        // Fallback to default if not found
        let defaultMapping = MODEL_MAPPINGS.find(m => m.displayName === DEFAULT_MODEL);
        if (!defaultMapping) {
            defaultMapping = MODEL_MAPPINGS[0];
        }
        if (!fullModelName || !displayName) {
            fullModelName = defaultMapping.fullName;
            displayName = defaultMapping.displayName;
        }
        setSelectedModel(displayName);
        onConfigChange({ model: fullModelName });
    }, [onConfigChange]);
    const handleModelChange = (displayName) => {
        var _a;
        setSelectedModel(displayName);
        setIsOpen(false);
        const fullModelName = ((_a = MODEL_MAPPINGS.find(m => m.displayName === displayName)) === null || _a === void 0 ? void 0 : _a.fullName) || displayName;
        const newConfig = {
            model: fullModelName
        };
        localStorage.setItem('llmModelConfig', JSON.stringify(newConfig));
        // Notify parent component
        onConfigChange(newConfig);
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const handleClickOutside = (event) => {
            const target = event.target;
            if (!target.closest('.model-selector')) {
                setIsOpen(false);
            }
        };
        document.addEventListener('mousedown', handleClickOutside);
        return () => {
            document.removeEventListener('mousedown', handleClickOutside);
        };
    }, []);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "model-selector" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `model-selector-dropdown`, onClick: () => setIsOpen(!isOpen), title: selectedModel, "data-testid": "model-selector" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "selected-model" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "model-icon" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_NucleausIcon__WEBPACK_IMPORTED_MODULE_3__["default"], { height: 10, width: 10 })),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "model-name" }, selectedModel),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "dropdown-arrow" }, "\u25BC")),
            isOpen && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `model-options dropup`, style: { minWidth: '150px' } }, ALL_MODEL_DISPLAY_NAMES.map(model => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: model, className: `model-option ${model === selectedModel ? 'selected' : ''}`, onClick: (e) => {
                    e.stopPropagation();
                    handleModelChange(model);
                }, title: model, "data-testid": "model-option" }, model))))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ModelSelector);


/***/ }),

/***/ "./lib/components/NextStepsPills.js":
/*!******************************************!*\
  !*** ./lib/components/NextStepsPills.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_NextStepsPills_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../style/NextStepsPills.css */ "./style/NextStepsPills.css");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


const NextStepsPills = ({ nextSteps, onSelectNextStep, displayedNextStepsIfAvailable, setDisplayedNextStepsIfAvailable }) => {
    const [isVisible, setIsVisible] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(displayedNextStepsIfAvailable);
    const [isAnimatingOut, setIsAnimatingOut] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    /*
    Triggers entrance animation for next steps pills.
    When new next steps are available, waits 50ms before making the component visible
    to ensure smooth CSS animation transitions. The delay allows the DOM to render
    before the animation state change occurs.
    */
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (nextSteps.length > 0) {
            // Small delay to trigger the entrance animation
            const timer = setTimeout(() => setIsVisible(true), 50);
            return () => clearTimeout(timer);
        }
        return () => { }; // Return empty cleanup function for the else case
    }, []);
    const handleNextStepClick = (nextStep) => {
        // Start exit animation
        setIsAnimatingOut(true);
        // Call the callback after a short delay to allow animation
        setTimeout(() => {
            if (onSelectNextStep) {
                onSelectNextStep(nextStep);
            }
        }, 150);
    };
    const toggleExpanded = () => {
        setDisplayedNextStepsIfAvailable(!displayedNextStepsIfAvailable);
    };
    if (nextSteps.length === 0) {
        return null;
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `next-steps-pills-container ${isVisible ? 'visible' : ''} ${isAnimatingOut ? 'animating-out' : ''}` },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "next-steps-header", onClick: toggleExpanded },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `next-steps-caret ${displayedNextStepsIfAvailable ? 'expanded' : 'collapsed'}` }, "\u25BC"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "next-steps-title" }, "Suggested Next Steps")),
        displayedNextStepsIfAvailable && (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "next-steps-pills-list" }, nextSteps.map((nextStep, index) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { key: index, className: "next-step-pill", onClick: () => handleNextStepClick(nextStep), title: nextStep, style: { animationDelay: `${index * 50}ms` } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "next-step-pill-text" }, nextStep),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "next-step-pill-icon" }, "\u2192"))))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NextStepsPills);


/***/ }),

/***/ "./lib/components/SelectedContextContainer.js":
/*!****************************************************!*\
  !*** ./lib/components/SelectedContextContainer.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_SelectedContextContainer_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../style/SelectedContextContainer.css */ "./style/SelectedContextContainer.css");
/* harmony import */ var _icons_RuleIcon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../icons/RuleIcon */ "./lib/icons/RuleIcon.js");
/* harmony import */ var _icons_CodeIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../icons/CodeIcon */ "./lib/icons/CodeIcon.js");
/* harmony import */ var _icons_DatabaseIcon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../icons/DatabaseIcon */ "./lib/icons/DatabaseIcon.js");
/* harmony import */ var _icons_PhotoIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../icons/PhotoIcon */ "./lib/icons/PhotoIcon.js");
/* harmony import */ var _utils_notebook__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/notebook */ "./lib/utils/notebook.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */







const SelectedContextContainer = ({ title, type, onRemove, onClick, notebookTracker, activeCellID }) => {
    const [isHovered, setIsHovered] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    let icon = react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_RuleIcon__WEBPACK_IMPORTED_MODULE_2__["default"], null);
    if (type.startsWith('image/')) {
        icon = react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_PhotoIcon__WEBPACK_IMPORTED_MODULE_3__["default"], null);
    }
    else if (type === 'rule') {
        icon = react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_RuleIcon__WEBPACK_IMPORTED_MODULE_2__["default"], null);
    }
    else if (type === 'variable') {
        icon = react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_CodeIcon__WEBPACK_IMPORTED_MODULE_4__["default"], null);
    }
    else if (type === 'db') {
        icon = react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_DatabaseIcon__WEBPACK_IMPORTED_MODULE_5__["default"], null);
    }
    else if (type === 'active_cell') {
        icon = react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_CodeIcon__WEBPACK_IMPORTED_MODULE_4__["default"], null);
    }
    const handleClick = () => {
        var _a;
        if (type === 'active_cell') {
            // Handle active cell context click
            if (notebookTracker && activeCellID) {
                // Find the cell 
                const cell = (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_6__.getCellByID)(notebookTracker, activeCellID);
                if (cell) {
                    // Scroll to the cell
                    void ((_a = notebookTracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content.scrollToCell(cell, 'center'));
                    // Highlight the cell
                    setTimeout(() => {
                        (0,_utils_notebook__WEBPACK_IMPORTED_MODULE_6__.highlightCodeCell)(notebookTracker, activeCellID);
                    }, 500);
                }
            }
            // If notebookTracker or activeCellID are not available, do nothing
        }
        else if (onClick) {
            // Call the custom onClick handler for other context types
            onClick();
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "selected-context-container", onMouseEnter: () => setIsHovered(true), onMouseLeave: () => setIsHovered(false), onClick: handleClick, "data-testid": "selected-context-container" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `icon`, onClick: (e) => {
                e.stopPropagation(); // Prevent triggering the button's onClick
                onRemove();
            }, title: isHovered ? "Remove rule" : "Selected rule" }, isHovered && type !== 'active_cell' ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "remove-icon" }, "X")) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "icon" }, icon))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "rule-name" }, title)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SelectedContextContainer);


/***/ }),

/***/ "./lib/components/TextAndIconButton.js":
/*!*********************************************!*\
  !*** ./lib/components/TextAndIconButton.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_TextAndIconButton_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../style/TextAndIconButton.css */ "./style/TextAndIconButton.css");
/* harmony import */ var _style_button_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../style/button.css */ "./style/button.css");
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/classNames */ "./lib/utils/classNames.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const TextAndIconButton = ({ text, icon: Icon, onClick, title, variant, iconPosition = 'right' // default to right
 }) => {
    const content = iconPosition === 'right' ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
        text,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "text-and-icon-button__icon" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Icon, null)))) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "text-and-icon-button__icon" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Icon, null)),
        text));
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_3__.classNames)('text-and-icon-button', 'button-base', `button-${variant}`, `button-width-fit-contents`), onClick: onClick, title: title }, content));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TextAndIconButton);


/***/ }),

/***/ "./lib/components/TextButton.js":
/*!**************************************!*\
  !*** ./lib/components/TextButton.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_TextButton_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../style/TextButton.css */ "./style/TextButton.css");
/* harmony import */ var _style_button_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../style/button.css */ "./style/button.css");
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/classNames */ "./lib/utils/classNames.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const TextButton = ({ text, onClick, title, variant, width, action, textAlign = 'center', className }) => {
    if (action) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { action: action, method: "POST", target: "_blank" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_3__.classNames)("text-button-mito-ai", "button-base", `button-${variant}`, `button-width-${width}`, `text-align-${textAlign}`, className), onClick: onClick, title: title }, text)));
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_3__.classNames)("text-button-mito-ai", "button-base", `button-${variant}`, `button-width-${width}`, `text-align-${textAlign}`, className), onClick: onClick, title: title }, text));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TextButton);


/***/ }),

/***/ "./lib/components/ToggleButton.js":
/*!****************************************!*\
  !*** ./lib/components/ToggleButton.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_button_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../style/button.css */ "./style/button.css");
/* harmony import */ var _style_ToggleButton_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../style/ToggleButton.css */ "./style/ToggleButton.css");
/* harmony import */ var _utils_classNames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/classNames */ "./lib/utils/classNames.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




const ToggleButton = ({ leftText, rightText, leftTooltip, rightTooltip, leftIcon: LeftIcon, rightIcon: RightIcon, isLeftSelected, onChange, }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_3__.classNames)("toggle-button-container") },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_3__.classNames)("toggle-button-half", "button-base", isLeftSelected ? 'selected' : 'unselected'), onClick: () => onChange(true), title: leftTooltip },
            LeftIcon && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LeftIcon, { width: "16px", height: "16px" }),
            leftText),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: (0,_utils_classNames__WEBPACK_IMPORTED_MODULE_3__.classNames)("toggle-button-half", "button-base", !isLeftSelected ? 'selected' : 'unselected'), onClick: () => onChange(false), title: rightTooltip },
            RightIcon && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(RightIcon, { width: "16px", height: "16px" }),
            rightText)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ToggleButton);


/***/ }),

/***/ "./lib/hooks/useDebouncedFunction.js":
/*!*******************************************!*\
  !*** ./lib/hooks/useDebouncedFunction.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useDebouncedFunction: () => (/* binding */ useDebouncedFunction)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/**
 * Creates a debounced version of a function that only executes after waiting for a specified delay
 * with no additional calls. If the function is called multiple times within the delay period,
 * only the last call will be executed.
 *
 * @param callback The function to debounce
 * @param delay The delay in milliseconds
 * @returns A debounced version of the callback
 */
const useDebouncedFunction = (callback, delay) => {
    const timeoutRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((...args) => {
        // Clear any existing timeout
        if (timeoutRef.current) {
            clearTimeout(timeoutRef.current);
        }
        // Set new timeout
        timeoutRef.current = setTimeout(() => {
            callback(...args);
        }, delay);
    }, [callback, delay]);
};


/***/ }),

/***/ "./lib/icons/AcceptIcon.js":
/*!*********************************!*\
  !*** ./lib/icons/AcceptIcon.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const AcceptIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "1em", height: "1em", viewBox: "0 0 21 20", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M10.2236 0C4.70642 0 0.224487 4.48351 0.224487 10.0009C0.224487 15.5182 4.70642 20 10.2236 20C15.7408 20 20.2245 15.5181 20.2245 10.0009C20.2245 4.48368 15.741 0 10.2236 0ZM14.6192 5.46298C14.986 5.46298 15.3511 5.60114 15.6283 5.87746C16.1817 6.43091 16.1817 7.34456 15.6283 7.89886L9.56828 13.9589C9.01482 14.5123 8.10035 14.5123 7.54687 13.9589L4.85354 11.2648C4.30008 10.7114 4.30008 9.79937 4.85354 9.24518C5.407 8.69172 6.319 8.69172 6.87319 9.24518L8.55657 10.9294L13.6083 5.87851C13.8855 5.60054 14.2525 5.46298 14.6192 5.46298Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AcceptIcon);


/***/ }),

/***/ "./lib/icons/AlertIcon.js":
/*!********************************!*\
  !*** ./lib/icons/AlertIcon.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const AlertIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "14", height: "14", viewBox: "0 0 96 84", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M94.0805 67.8053L57.025 5.49763C55.1179 2.28364 51.657 0.313801 47.9194 0.313801C44.1818 0.313801 40.7209 2.28355 38.8137 5.49763L1.91856 67.8053C0.0350518 71.0665 0.0267897 75.0839 1.89611 78.3535C3.76543 81.6232 7.23119 83.6541 10.9969 83.6862H85.1079C88.8549 83.6177 92.2873 81.5723 94.1307 78.3088C95.974 75.0452 95.9546 71.0513 94.0805 67.8053ZM48.0531 73.0989C46.6493 73.0989 45.3023 72.5412 44.3097 71.5486C43.3172 70.5561 42.7594 69.209 42.7594 67.8053C42.7594 66.4015 43.3172 65.0545 44.3097 64.0619C45.3023 63.0694 46.6493 62.5116 48.0531 62.5116C49.4568 62.5116 50.8039 63.0694 51.7964 64.0619C52.789 65.0545 53.3467 66.4015 53.3467 67.8053C53.3467 69.209 52.789 70.5561 51.7964 71.5486C50.8039 72.5412 49.4568 73.0989 48.0531 73.0989ZM53.3467 49.2775C53.3467 51.1693 52.3376 52.9168 50.6999 53.8621C49.0622 54.8074 47.044 54.8074 45.4063 53.8621C43.7686 52.9168 42.7594 51.1692 42.7594 49.2775V28.103C42.7594 26.2112 43.7685 24.4637 45.4063 23.5184C47.044 22.5731 49.0622 22.5731 50.6999 23.5184C52.3376 24.4637 53.3467 26.2113 53.3467 28.103V49.2775Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AlertIcon);


/***/ }),

/***/ "./lib/icons/CodeIcon.js":
/*!*******************************!*\
  !*** ./lib/icons/CodeIcon.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const CodeIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "14", height: "14", viewBox: "0 0 20 14", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M12.3162 0.0513449C12.8027 0.213518 13.0817 0.713391 12.9792 1.20347L12.9487 1.31624L8.94868 13.3162C8.77403 13.8402 8.20773 14.1233 7.68378 13.9487C7.19726 13.7865 6.91835 13.2866 7.02082 12.7966L7.05134 12.6838L11.0513 0.683791C11.226 0.159848 11.7923 -0.123303 12.3162 0.0513449ZM5.79999 3.40001C6.10587 3.80785 6.05312 4.37331 5.69568 4.71852L5.59998 4.8L2.667 7.00001L5.59998 9.20003C6.00782 9.50591 6.1155 10.0635 5.86902 10.495L5.79999 10.6C5.49411 11.0079 4.9365 11.1155 4.50501 10.869L4.40003 10.8L0.40003 7.8C-0.0977483 7.42667 -0.130987 6.7049 0.30042 6.28511L0.40003 6.20003L4.40003 3.20003C4.84186 2.86866 5.46862 2.95818 5.79999 3.40001ZM15.495 3.131L15.6 3.20003L19.6 6.20003C20.0978 6.57336 20.131 7.29513 19.6996 7.71492L19.6 7.8L15.6 10.8C15.1582 11.1314 14.5314 11.0418 14.2 10.6C13.8941 10.1922 13.9469 9.62672 14.3043 9.28151L14.4 9.20003L17.333 7.00001L14.4 4.8C13.9922 4.49412 13.8845 3.93654 14.131 3.50505L14.2 3.40001C14.5059 2.99217 15.0635 2.88452 15.495 3.131Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CodeIcon);


/***/ }),

/***/ "./lib/icons/CopyIcon.js":
/*!*******************************!*\
  !*** ./lib/icons/CopyIcon.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const CopyIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "1em", height: "1em", viewBox: "0 0 10 11", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M3.12502 4.03283H4.27968C4.35507 4.02072 4.4082 3.95276 4.40156 3.87658V2.59542C4.25976 2.64425 4.13359 2.72979 4.03593 2.84385L3.32343 3.65323C3.22929 3.76299 3.16172 3.89307 3.125 4.03291L3.12502 4.03283Z" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M7.75784 2.55308H4.70626V3.87342C4.71524 4.12263 4.5211 4.33201 4.27188 4.34217H3.0813V9.2C3.08208 9.56993 3.38012 9.8707 3.75005 9.875H7.75788C7.93757 9.87578 8.11022 9.80508 8.23757 9.67852C8.3653 9.55195 8.43717 9.37969 8.43757 9.2V3.22808C8.43718 3.0484 8.3653 2.87613 8.23757 2.74957C8.11022 2.623 7.93757 2.5523 7.75788 2.55308H7.75784Z" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M3.80163 2.62967C4.01452 2.38553 4.32155 2.24373 4.64538 2.2406H6.91879V1.79998C6.91801 1.43005 6.61997 1.12928 6.25004 1.12498H3.19221V2.44531C3.20119 2.69453 3.00705 2.9039 2.75783 2.91406H1.5625V7.77189C1.56328 8.14416 1.86523 8.44611 2.2375 8.44689H2.76407V4.30631C2.76172 3.98795 2.87578 3.67974 3.08438 3.43914L3.80163 2.62967Z" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M2.75783 2.60467C2.83322 2.59256 2.88635 2.52459 2.87971 2.44842V1.16725C2.74182 1.21569 2.61916 1.29928 2.52346 1.40943L1.80783 2.21881C1.71096 2.33013 1.64065 2.46217 1.60315 2.60474L2.75783 2.60467Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CopyIcon);


/***/ }),

/***/ "./lib/icons/DatabaseIcon.js":
/*!***********************************!*\
  !*** ./lib/icons/DatabaseIcon.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const DatabaseIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "10", height: "10", viewBox: "0 0 100 100", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M50 43.839C71.447 43.839 89.737 41.166 96.839 37.411C98.881 38.49 100 39.659 100 40.88V59.12C100 64.586 77.614 69.017 50 69.017C22.386 69.017 0 64.585 0 59.12V40.88C0 39.659 1.12 38.49 3.161 37.411C10.263 41.166 28.553 43.839 50 43.839ZM3.161 68.393C1.12 69.473 0 70.642 0 71.862V90.102C0 95.568 22.386 100 50 100C77.614 100 100 95.568 100 90.103V71.863C100 70.642 98.881 69.473 96.839 68.393C89.737 72.147 71.447 74.821 50 74.821C28.553 74.821 10.263 72.147 3.161 68.393ZM50 0C22.386 0 0 4.432 0 9.898V28.137C0 33.604 22.386 38.035 50 38.035C77.614 38.035 100 33.604 100 28.137V9.898C100 4.432 77.614 0 50 0Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DatabaseIcon);


/***/ }),

/***/ "./lib/icons/DatabaseOutlineIcon.js":
/*!******************************************!*\
  !*** ./lib/icons/DatabaseOutlineIcon.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const DatabaseOutlineIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "14", height: "14", viewBox: "0 0 82 96", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M41 95.5C61.0983 95.5 81.4446 90.198 81.4446 80.0651V15.9349C81.4403 5.80206 61.0963 0.5 41 0.5C20.9037 0.5 0.559864 5.80206 0.555621 15.9349L0.55542 80.0651C0.55542 90.198 20.9017 95.5 41 95.5ZM41 6.83333C63.0713 6.83333 75.1112 12.8476 75.1112 15.938C75.1112 19.0284 63.0713 25.0432 41 25.0432C18.9287 25.0432 6.88875 19.0284 6.88875 15.938C6.88875 12.8476 18.9287 6.83333 41 6.83333ZM6.88875 24.6315C14.4639 29.0832 27.7848 31.3765 41 31.3765C54.2152 31.3765 67.5361 29.0832 75.1112 24.6315V37.3079C75.1112 40.4003 63.0713 46.4198 41 46.4198C18.9287 46.4198 6.88875 40.4003 6.88875 37.3079L6.88875 24.6315ZM6.88875 46.0052C14.4639 50.4589 27.7848 52.7531 41 52.7531C54.2152 52.7531 67.5361 50.4589 75.1112 46.0052V58.6916C75.1112 61.7805 63.0713 67.7932 41 67.7932C18.9287 67.7932 6.88875 61.7805 6.88875 58.6916L6.88875 46.0052ZM6.88875 67.383C14.4639 71.8337 27.7848 74.1265 41 74.1265C54.2152 74.1265 67.5361 71.8337 75.1112 67.383V80.0651C75.1112 83.1544 63.0713 89.1667 41 89.1667C18.9287 89.1667 6.88875 83.1544 6.88875 80.0651L6.88875 67.383Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DatabaseOutlineIcon);


/***/ }),

/***/ "./lib/icons/ExpandIcon.js":
/*!*********************************!*\
  !*** ./lib/icons/ExpandIcon.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const ExpandIcon = ({ isExpanded }) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "12", height: "12", viewBox: "0 0 12 12", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" }, isExpanded ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M6 2L10 6L9 7L6 4L3 7L2 6L6 2Z" })) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M6 10L2 6L3 5L6 8L9 5L10 6L6 10Z" })))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExpandIcon);


/***/ }),

/***/ "./lib/icons/MagicWand.js":
/*!********************************!*\
  !*** ./lib/icons/MagicWand.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const MagicWandIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "17", height: "16", viewBox: "0 0 17 16", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { clipPath: "url(#clip0_52_2)" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M11.7423 4.48214C11.4704 4.21083 11.0307 4.21083 10.7587 4.48214L7.80698 7.43387L8.79062 8.41751L11.7415 5.46578C12.0129 5.1952 12.0136 4.75411 11.7423 4.48214H11.7423Z", fill: "currentColor" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M0.428284 15.796C0.700257 16.068 1.13995 16.068 1.41192 15.796L8.29886 8.90973L7.31522 7.92609L0.428284 14.8124C0.156311 15.0843 0.156311 15.524 0.428284 15.796Z", fill: "currentColor" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M11.3549 1.39133L11.0071 0L10.6592 1.39133L9.26791 1.73915L10.6592 2.08701L11.0071 3.47835L11.3549 2.08701L12.7462 1.73915L11.3549 1.39133Z", fill: "currentColor" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M14.4858 3.47826L14.1379 4.8696L12.7466 5.21741L14.1379 5.56522L14.4858 6.95656L14.8336 5.56522L16.225 5.21741L14.8336 4.8696L14.4858 3.47826Z", fill: "currentColor" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M12.7462 7.65213L12.0506 10.4348L9.26791 11.1304L12.0506 11.8261L12.7462 14.6088L13.4419 11.8261L16.2246 11.1304L13.4419 10.4348L12.7462 7.65213Z", fill: "currentColor" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M6.48544 4.17387L9.2681 3.47824L6.48544 2.78256L5.78976 -0.000106812L5.09413 2.78256L2.31146 3.47824L5.09413 4.17387L5.78976 6.95653L6.48544 4.17387Z", fill: "currentColor" })),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("defs", null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("clipPath", { id: "clip0_52_2" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { width: "16", height: "16", fill: "white", transform: "translate(0.224487)" })))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MagicWandIcon);


/***/ }),

/***/ "./lib/icons/MagnifyingGlassIcon.js":
/*!******************************************!*\
  !*** ./lib/icons/MagnifyingGlassIcon.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const MagnifyingGlassIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "16", height: "16", viewBox: "0 0 21 20", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M2.96182 19.9992C3.53644 19.9992 4.11107 19.7813 4.54856 19.3447L7.30621 16.5858C7.61783 16.7681 7.94074 16.9313 8.27665 17.0772C9.41116 17.5685 10.609 17.8142 11.8102 17.8142C12.9178 17.8142 14.0271 17.6041 15.0897 17.1839C17.3005 16.3089 19.0375 14.6238 19.9809 12.4415C20.9262 10.2582 20.9644 7.83974 20.0886 5.6287C18.277 1.0529 13.1089 -1.1824 8.53539 0.628434C6.32457 1.50348 4.58668 3.18857 3.64154 5.37091C2.69801 7.55325 2.66068 9.97263 3.53564 12.1837C3.7049 12.6108 3.90455 13.0205 4.13197 13.4112L1.37432 16.1691C0.500226 17.0433 0.500226 18.4679 1.37432 19.3437C1.8118 19.7812 2.38729 20 2.96278 20L2.96182 19.9992ZM18.6852 6.1833C19.4117 8.02022 19.3796 10.0291 18.5949 11.8406C17.812 13.6532 16.3693 15.0527 14.5327 15.7794C12.6977 16.506 10.6873 16.4747 8.8759 15.6908C5.1357 14.0727 3.40838 9.71143 5.02719 5.97068C5.81188 4.15808 7.25524 2.76051 9.09034 2.03195C12.887 0.528388 17.1811 2.38613 18.6855 6.18328L18.6852 6.1833Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MagnifyingGlassIcon);


/***/ }),

/***/ "./lib/icons/MitoLogo.js":
/*!*******************************!*\
  !*** ./lib/icons/MitoLogo.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const MitoLogo = ({ height = '30', width = '60', }) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: width, height: height, viewBox: "0 0 60 30", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "2", y: "2", width: "56", height: "26", rx: "13", fill: "#DECEFF", stroke: "#9D6CFF", strokeWidth: "4" }),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M17 29V13", stroke: "#9D6CFF", strokeWidth: "4" }),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ellipse", { cx: "17", cy: "13", rx: "2", ry: "1", fill: "#9D6CFF" }),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M43 29V13", stroke: "#9D6CFF", strokeWidth: "4" }),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ellipse", { cx: "43", cy: "13", rx: "2", ry: "1", fill: "#9D6CFF" }),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M30 0.999999V17", stroke: "#9D6CFF", strokeWidth: "4" }),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ellipse", { rx: "2", ry: "1", transform: "matrix(1 0 0 -1 30 17)", fill: "#9D6CFF" })));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MitoLogo);


/***/ }),

/***/ "./lib/icons/NotebookFooter/CodeIcon.js":
/*!**********************************************!*\
  !*** ./lib/icons/NotebookFooter/CodeIcon.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const CodeIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "15", height: "12", viewBox: "0 0 15 12", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: 'currentColor' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M4.94038 2.90526C4.94038 2.65884 4.84466 2.42724 4.66957 2.25163C4.3308 1.9148 3.70255 1.91386 3.36425 2.25263L0.270338 5.34702C0.0985595 5.51875 0 5.7566 0 5.99966C0 6.24272 0.0985583 6.48051 0.270338 6.65229L3.36522 9.74766C3.53989 9.92086 3.77144 10.0171 4.01691 10.0171C4.26238 10.0171 4.49398 9.92134 4.67054 9.74624C4.84421 9.5721 4.93993 9.34002 4.93993 9.09408C4.93993 8.84814 4.84421 8.61606 4.66959 8.44145L2.22834 6.00019L4.67008 3.55894C4.84422 3.38427 4.94042 3.15267 4.94042 2.90531L4.94038 2.90526Z" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M14.279 5.34708L11.1846 2.25268C10.8472 1.91438 10.219 1.91391 9.87875 2.25268C9.70461 2.42682 9.60889 2.6589 9.60889 2.90531C9.60889 3.15315 9.70508 3.38522 9.87875 3.55795L12.3205 5.99969L9.87875 8.44094C9.70461 8.61508 9.60889 8.84716 9.60889 9.09357C9.60889 9.33999 9.7046 9.57207 9.8797 9.7472C10.0544 9.92087 10.2864 10.0166 10.5319 10.0166C10.7773 10.0166 11.0094 9.92088 11.184 9.74673L14.2784 6.65233C14.4502 6.48055 14.5488 6.24276 14.5488 5.9997C14.5488 5.75669 14.4507 5.51884 14.2789 5.34711L14.279 5.34708Z" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M8.81621 0.0325582C8.2851 -0.111468 7.69701 0.238298 7.56072 0.767032L4.98125 10.7157C4.83912 11.2627 5.16928 11.8239 5.71667 11.9675C5.8004 11.989 5.88656 12 5.97456 12C6.44301 12 6.85116 11.6837 6.96791 11.2311L9.54738 1.28239C9.61677 1.01684 9.57751 0.740717 9.43879 0.505334C9.30002 0.268483 9.07751 0.100535 8.81627 0.0325776L8.81621 0.0325582Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CodeIcon);


/***/ }),

/***/ "./lib/icons/NotebookFooter/TextIcon.js":
/*!**********************************************!*\
  !*** ./lib/icons/NotebookFooter/TextIcon.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const TextIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "11", height: "12", viewBox: "0 0 11 12", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: 'currentColor' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M9.98373 7.9354e-05C9.9573 7.9354e-05 9.93255 0.00614082 9.90713 0.00761542C9.88171 0.00614094 9.85696 7.9354e-05 9.83104 7.9354e-05H1.16989C1.14346 7.9354e-05 1.11871 0.00614077 1.09278 0.00810691C1.06686 0.00614093 1.04211 7.9354e-05 1.01619 7.9354e-05C0.455038 7.9354e-05 0 0.442923 0 0.988938V2.5733C0 3.11936 0.455081 3.56166 1.01619 3.56166C1.57729 3.56166 2.03237 3.11931 2.03237 2.5733V1.97696H4.50719V10.0223H3.48157C2.92042 10.0223 2.4659 10.4646 2.4659 11.0111C2.4659 11.5567 2.92047 12 3.48157 12H5.51833H5.52355H5.52877H7.56606C8.1272 12 8.58224 11.5567 8.58224 11.0111C8.58224 10.4646 8.12716 10.0223 7.56606 10.0223L6.53944 10.0221V1.97721H8.96763V2.57356C8.96763 3.11961 9.42271 3.56191 9.98382 3.56191C10.545 3.56191 11 3.11957 11 2.57356V0.989194C11.0002 0.442843 10.5449 0 9.98382 0L9.98373 7.9354e-05Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TextIcon);


/***/ }),

/***/ "./lib/icons/NucleausIcon.js":
/*!***********************************!*\
  !*** ./lib/icons/NucleausIcon.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const NucleausIcon = ({ height = 20, width = 20, }) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: width, height: height, viewBox: "0 0 20 20", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M18.5775 2.50569L17.3933 1.85818C17.3684 1.84329 17.3461 1.82344 17.3337 1.79616L16.6832 0.61281C16.5715 0.404416 16.353 0 16.1171 0C15.8788 0 15.6628 0.404416 15.5485 0.61281L14.9005 1.79616C14.8856 1.82344 14.8658 1.84329 14.8385 1.85818L13.6542 2.50569C13.4456 2.61981 13.0087 2.83564 13.0087 3.07381C13.0087 3.30949 13.4456 3.52781 13.6542 3.64193L14.8385 4.28944C14.8658 4.30184 14.8856 4.32417 14.9005 4.34898L15.5485 5.53232C15.6628 5.74072 15.8788 6.16746 16.1171 6.16746C16.353 6.16746 16.5715 5.74072 16.6832 5.53232L17.3337 4.34898C17.3461 4.32417 17.3684 4.30184 17.3933 4.28944L18.5775 3.64193C18.7861 3.52781 19.2306 3.30949 19.2306 3.07381C19.2306 2.83564 18.7861 2.61981 18.5775 2.50569Z" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M15.4932 9.95234L12.2462 8.17563C12.1781 8.13478 12.1168 8.08032 12.0828 8.00544L10.2993 4.75843C9.99295 4.18661 9.3939 3.07692 8.7472 3.07692C8.0937 3.07692 7.50145 4.18661 7.18832 4.75843L5.4116 8.00544C5.37075 8.08032 5.3163 8.13478 5.24141 8.17563L1.9944 9.95234C1.42258 10.2655 0.224487 10.8577 0.224487 11.5112C0.224487 12.1579 1.42258 12.757 1.9944 13.0701L5.24141 14.8468C5.3163 14.8809 5.37075 14.9421 5.4116 15.0102L7.18832 18.2572C7.50145 18.829 8.0937 20 8.7472 20C9.3939 20 9.99295 18.829 10.2993 18.2572L12.0828 15.0102C12.1168 14.9421 12.1781 14.8809 12.2462 14.8468L15.4932 13.0701C16.065 12.757 17.2837 12.1579 17.2837 11.5112C17.2837 10.8577 16.065 10.2655 15.4932 9.95234Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NucleausIcon);


/***/ }),

/***/ "./lib/icons/PaperClipIcon.js":
/*!************************************!*\
  !*** ./lib/icons/PaperClipIcon.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const PaperClipIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "14", height: "14", viewBox: "0 0 72 86", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M70.363 44.59C68.6013 43.258 66.0935 43.6017 64.7575 45.3634L46.4995 69.4724C39.73 78.4099 27.0735 80.6284 17.6905 74.5154C12.71 71.2693 9.39359 66.2537 8.37409 60.3904C7.31939 54.3435 8.8819 48.0154 12.6632 43.0234L35.3312 13.0894C39.5773 7.48783 47.5812 6.37853 53.1902 10.6246C58.7879 14.8668 59.8894 22.8746 55.6472 28.4766L50.8425 34.8204L32.6475 58.8434C31.1709 60.7965 28.4366 61.3629 26.5577 60.109C25.5304 59.4215 24.8546 58.3863 24.6515 57.1832C24.4484 55.984 24.7413 54.7887 25.4757 53.8199L43.8707 29.5389C45.2027 27.7772 44.859 25.2694 43.0973 23.9334C41.3356 22.6014 38.8278 22.9452 37.4918 24.7069L19.0968 48.9879C17.0499 51.691 16.1984 55.1637 16.7648 58.5113C17.296 61.6597 18.964 64.4019 21.4914 66.316C21.6945 66.4722 21.9054 66.6207 22.1203 66.7652C27.3781 70.273 34.5073 69.0933 38.6323 64.1441C38.6948 64.0699 38.769 64.0113 38.8276 63.9332L39.0229 63.6714L62.0229 33.3044C68.9291 24.1833 67.1362 11.1484 58.0112 4.23843C48.8979 -2.66387 35.8632 -0.863167 28.9522 8.25793L6.2842 38.1919L5.88967 38.7115C5.8428 38.774 5.81545 38.8404 5.77248 38.9029C1.03418 45.5435 -0.895518 53.8209 0.491282 61.7619C1.77648 69.1252 5.68268 75.5239 11.5693 79.9849C12.1357 80.4146 12.7216 80.8247 13.3232 81.2154C26.2102 89.606 43.5812 86.567 52.8782 74.2974L71.1362 50.1924C72.4721 48.4307 72.1247 45.9221 70.363 44.59Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PaperClipIcon);


/***/ }),

/***/ "./lib/icons/Pencil.js":
/*!*****************************!*\
  !*** ./lib/icons/Pencil.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const PencilIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "14", height: "14", viewBox: "0 0 10 10", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: 'currentColor' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M9.88308 1.82456C9.68326 1.49798 9.43085 1.18192 9.1259 0.876387C8.8209 0.570854 8.5054 0.317998 8.18991 0.117862C7.88492 -0.0717913 7.48531 -0.0296413 7.22238 0.223215L1.15425 6.29155C1.12269 6.32317 1.10167 6.35476 1.08065 6.39691L0.0289843 9.38893C-0.0341088 9.55749 0.00796491 9.73662 0.134151 9.86302C0.218298 9.94732 0.333977 10 0.449651 10C0.502235 10 0.554818 9.98947 0.596894 9.97894L3.58363 8.92541C3.6257 8.91488 3.65723 8.88326 3.6888 8.85168L9.76744 2.78325C10.0304 2.51987 10.0724 2.13008 9.88311 1.82454L9.88308 1.82456ZM1.56439 6.80777C1.86938 6.98685 2.18488 7.2397 2.47934 7.53471C2.77382 7.82972 3.01568 8.14578 3.19449 8.45128L1.46976 9.06235C1.41717 8.957 1.34357 8.85164 1.25942 8.76734C1.16476 8.67252 1.0701 8.60931 0.964937 8.55664L1.56439 6.80777Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PencilIcon);


/***/ }),

/***/ "./lib/icons/PhotoIcon.js":
/*!********************************!*\
  !*** ./lib/icons/PhotoIcon.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const PhotoIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "14", height: "14", viewBox: "0 0 98 76", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { fillRule: "evenodd", clipRule: "evenodd", d: "M14.85 0.129997H83.15C91.32 0.129997 98 6.82 98 14.98V61.02C98 69.18 91.32 75.87 83.15 75.87H14.85C6.68 75.87 0 69.18 0 61.02V14.98C0 6.82 6.68 0.129997 14.85 0.129997ZM70.01 11.03C74.21 11.03 77.61 14.43 77.61 18.63C77.61 22.83 74.21 26.24 70.01 26.24C65.81 26.24 62.4 22.83 62.4 18.63C62.4 14.43 65.81 11.03 70.01 11.03ZM21.03 52.61L38.48 24.28C39.94 22.6 43.25 22.6 44.71 24.28L56.04 42.66L60.53 35.37C61.57 34.17 63.92 34.17 64.96 35.37L77.35 55.49C79.69 59.29 77.22 63.95 73.08 63.95C57.73 63.95 42.38 63.95 27.03 63.95C21.14 63.95 17.73 57.96 21.03 52.61Z" }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PhotoIcon);


/***/ }),

/***/ "./lib/icons/PlayButtonIcon.js":
/*!*************************************!*\
  !*** ./lib/icons/PlayButtonIcon.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const PlayButtonIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "1em", height: "1em", viewBox: "0 0 10 11", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { fillRule: "evenodd", clipRule: "evenodd", d: "M5 0.5C6.38068 0.5 7.63072 1.05968 8.53558 1.9646C9.44034 2.86935 10 4.11938 10 5.50005C10 6.88071 9.44031 8.13075 8.53558 9.03559C7.63071 9.94034 6.38058 10.5 5 10.5C3.61942 10.5 2.36928 9.94032 1.46442 9.03559C0.559662 8.13073 0 6.88062 0 5.50005C0 4.11948 0.55969 2.86935 1.46461 1.9645C2.36937 1.05975 3.61942 0.500096 5.0001 0.500096L5 0.5ZM7.31017 5.70697C7.34646 5.68679 7.37783 5.65673 7.40006 5.61816C7.46534 5.50465 7.42621 5.35975 7.31271 5.29447L3.89591 3.32169C3.85701 3.29401 3.80938 3.27775 3.75805 3.27775C3.62653 3.27775 3.51992 3.38435 3.51992 3.51588L3.51988 5.50003V7.48417H3.52085C3.52085 7.52427 3.53099 7.56497 3.55237 7.60234C3.61764 7.71585 3.76256 7.75501 3.87606 7.6897L5.59438 6.69758L7.31017 5.70697Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PlayButtonIcon);


/***/ }),

/***/ "./lib/icons/RejectIcon.js":
/*!*********************************!*\
  !*** ./lib/icons/RejectIcon.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const RejectIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "1em", height: "1em", viewBox: "0 0 21 20", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M10.2245 0C7.57229 0 5.02869 1.0536 3.15349 2.929C1.27817 4.8044 0.224487 7.348 0.224487 10C0.224487 12.652 1.27809 15.1958 3.15349 17.071C5.02889 18.9463 7.57249 20 10.2245 20C12.8765 20 15.4203 18.9464 17.2955 17.071C19.1708 15.1956 20.2245 12.652 20.2245 10C20.2245 8.2446 19.7624 6.5202 18.8847 5C18.0071 3.47984 16.7447 2.2174 15.2245 1.3398C13.7044 0.46206 11.9799 3.9978e-05 10.2245 3.9978e-05L10.2245 0ZM13.9315 12.293C14.1244 12.4794 14.2344 12.7354 14.2367 13.0036C14.2391 13.2718 14.1335 13.5298 13.9438 13.7194C13.7542 13.9091 13.4962 14.0146 13.228 14.0123C12.9598 14.01 12.7038 13.9 12.5174 13.7071L10.2244 11.4141L7.93143 13.7071C7.67737 13.9524 7.31283 14.0455 6.97229 13.9521C6.63175 13.8588 6.36565 13.5927 6.27229 13.2521C6.17893 12.9116 6.27205 12.5471 6.51737 12.293L8.81037 10L6.51737 7.707C6.27205 7.45294 6.17893 7.0884 6.27229 6.74786C6.36565 6.40732 6.63175 6.14122 6.97229 6.04786C7.31283 5.9545 7.67737 6.04763 7.93143 6.29294L10.2244 8.58594L12.5174 6.29294V6.29286C12.7715 6.04754 13.136 5.95442 13.4766 6.04778C13.8171 6.14114 14.0832 6.40724 14.1766 6.74778C14.2699 7.08832 14.1768 7.45286 13.9315 7.70692L11.6385 9.99992L13.9315 12.293Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RejectIcon);


/***/ }),

/***/ "./lib/icons/RuleIcon.js":
/*!*******************************!*\
  !*** ./lib/icons/RuleIcon.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const RuleIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "9", height: "12", viewBox: "0 0 9 12", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M1.22727 0C0.554444 0 0 0.580846 0 1.28571V10.7143C0 11.4192 0.554444 12 1.22727 12H7.77273C8.44556 12 9 11.4192 9 10.7143V3.42857H6.95455C6.28172 3.42857 5.72727 2.84773 5.72727 2.14286V0H1.22727ZM6.54545 0V2.14286C6.54545 2.38768 6.72085 2.57143 6.95455 2.57143H9C9 2.45777 8.95688 2.3488 8.88013 2.26843L6.83468 0.125577C6.75797 0.0451748 6.65396 0 6.54545 0ZM2.45455 4.71429H6.54545C6.77139 4.71429 6.95455 4.90616 6.95455 5.14286C6.95455 5.37955 6.77139 5.57143 6.54545 5.57143H2.45455C2.22861 5.57143 2.04545 5.37955 2.04545 5.14286C2.04545 4.90616 2.22861 4.71429 2.45455 4.71429ZM2.45455 6.85714H6.54545C6.77139 6.85714 6.95455 7.04902 6.95455 7.28571C6.95455 7.52241 6.77139 7.71429 6.54545 7.71429H2.45455C2.22861 7.71429 2.04545 7.52241 2.04545 7.28571C2.04545 7.04902 2.22861 6.85714 2.45455 6.85714ZM2.45455 9H6.54545C6.77139 9 6.95455 9.19187 6.95455 9.42857C6.95455 9.66527 6.77139 9.85714 6.54545 9.85714H2.45455C2.22861 9.85714 2.04545 9.66527 2.04545 9.42857C2.04545 9.19187 2.22861 9 2.45455 9Z" }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RuleIcon);


/***/ }),

/***/ "./lib/icons/UndoIcon.js":
/*!*******************************!*\
  !*** ./lib/icons/UndoIcon.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const UndoIcon = () => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "14", height: "14", viewBox: "0 0 96 76", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { fill: "currentColor" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M95.5 49.875C95.5 64.277 83.777 76 69.375 76H48C45.3789 76 43.25 73.875 43.25 71.25C43.25 68.625 45.3789 66.5 48 66.5H69.375C78.5391 66.5 86 59.0391 86 49.875C86 40.7109 78.5391 33.25 69.375 33.25H16.719L32.36 48.891C34.2155 50.7465 34.2155 53.7504 32.36 55.6098C31.4303 56.5356 30.2155 57.0004 29.0006 57.0004C27.7857 57.0004 26.5709 56.5356 25.6412 55.6098L1.8912 31.8598C0.0356977 30.0043 0.0356977 27.0004 1.8912 25.141L25.6412 1.391C27.4967 -0.464501 30.5006 -0.464501 32.36 1.391C34.2155 3.2465 34.2155 6.2504 32.36 8.1098L16.719 23.7508H69.375C83.777 23.7508 95.5 35.469 95.5 49.875Z" }))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UndoIcon);


/***/ }),

/***/ "./lib/icons/index.js":
/*!****************************!*\
  !*** ./lib/icons/index.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppBuilderExcludeCellLabIcon: () => (/* binding */ AppBuilderExcludeCellLabIcon),
/* harmony export */   AppBuilderIncludeCellLabIcon: () => (/* binding */ AppBuilderIncludeCellLabIcon),
/* harmony export */   DeployLabIcon: () => (/* binding */ DeployLabIcon),
/* harmony export */   EditLabIcon: () => (/* binding */ EditLabIcon),
/* harmony export */   NucleusLabIcon: () => (/* binding */ NucleusLabIcon),
/* harmony export */   OpenIndicatorLabIcon: () => (/* binding */ OpenIndicatorLabIcon),
/* harmony export */   ResetCircleLabIcon: () => (/* binding */ ResetCircleLabIcon),
/* harmony export */   lightBulbLabIcon: () => (/* binding */ lightBulbLabIcon)
/* harmony export */ });
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _src_icons_LightbulbIcon_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../src/icons/LightbulbIcon.svg */ "./src/icons/LightbulbIcon.svg");
/* harmony import */ var _src_icons_NucleusIcon_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../src/icons/NucleusIcon.svg */ "./src/icons/NucleusIcon.svg");
/* harmony import */ var _src_icons_OpenIndicatorIcon_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../src/icons/OpenIndicatorIcon.svg */ "./src/icons/OpenIndicatorIcon.svg");
/* harmony import */ var _src_icons_AppBuilderExcludeCellIcon_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../src/icons/AppBuilderExcludeCellIcon.svg */ "./src/icons/AppBuilderExcludeCellIcon.svg");
/* harmony import */ var _src_icons_AppBuilderIncludeCellIcon_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../src/icons/AppBuilderIncludeCellIcon.svg */ "./src/icons/AppBuilderIncludeCellIcon.svg");
/* harmony import */ var _src_icons_App_DeployIcon_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../src/icons/App/DeployIcon.svg */ "./src/icons/App/DeployIcon.svg");
/* harmony import */ var _src_icons_PencilIcon_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../src/icons/PencilIcon.svg */ "./src/icons/PencilIcon.svg");
/* harmony import */ var _src_icons_ResetCircleIcon_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../src/icons/ResetCircleIcon.svg */ "./src/icons/ResetCircleIcon.svg");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */









const lightBulbLabIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'lightbulb-icon',
    svgstr: _src_icons_LightbulbIcon_svg__WEBPACK_IMPORTED_MODULE_1__
});
const NucleusLabIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'nucleus-icon',
    svgstr: _src_icons_NucleusIcon_svg__WEBPACK_IMPORTED_MODULE_2__
});
const OpenIndicatorLabIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'open-indicator-icon',
    svgstr: _src_icons_OpenIndicatorIcon_svg__WEBPACK_IMPORTED_MODULE_3__
});
const AppBuilderExcludeCellLabIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'app-builder-exclude-cell-icon',
    svgstr: _src_icons_AppBuilderExcludeCellIcon_svg__WEBPACK_IMPORTED_MODULE_4__
});
const AppBuilderIncludeCellLabIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'app-builder-include-cell-icon',
    svgstr: _src_icons_AppBuilderIncludeCellIcon_svg__WEBPACK_IMPORTED_MODULE_5__
});
const DeployLabIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'deploy-icon',
    svgstr: _src_icons_App_DeployIcon_svg__WEBPACK_IMPORTED_MODULE_6__
});
const EditLabIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'edit-icon',
    svgstr: _src_icons_PencilIcon_svg__WEBPACK_IMPORTED_MODULE_7__
});
const ResetCircleLabIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'reset-circle-icon',
    svgstr: _src_icons_ResetCircleIcon_svg__WEBPACK_IMPORTED_MODULE_8__
});


/***/ }),

/***/ "./lib/index.js":
/*!**********************!*\
  !*** ./lib/index.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Extensions_AiChat_AiChatPlugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Extensions/AiChat/AiChatPlugin */ "./lib/Extensions/AiChat/AiChatPlugin.js");
/* harmony import */ var _Extensions_ContextManager_ContextManagerPlugin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Extensions/ContextManager/ContextManagerPlugin */ "./lib/Extensions/ContextManager/ContextManagerPlugin.js");
/* harmony import */ var _Extensions_ErrorMimeRenderer_ErrorMimeRendererPlugin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Extensions/ErrorMimeRenderer/ErrorMimeRendererPlugin */ "./lib/Extensions/ErrorMimeRenderer/ErrorMimeRendererPlugin.js");
/* harmony import */ var _Extensions_ToolbarButtons_ToolbarButtonsPlugin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Extensions/ToolbarButtons/ToolbarButtonsPlugin */ "./lib/Extensions/ToolbarButtons/ToolbarButtonsPlugin.js");
/* harmony import */ var _Extensions_AppDeploy_AppDeployPlugin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Extensions/AppDeploy/AppDeployPlugin */ "./lib/Extensions/AppDeploy/AppDeployPlugin.js");
/* harmony import */ var _Extensions_AppPreview_StreamlitPreviewPlugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Extensions/AppPreview/StreamlitPreviewPlugin */ "./lib/Extensions/AppPreview/StreamlitPreviewPlugin.js");
/* harmony import */ var _Extensions_emptyCell_EmptyCellPlugin__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Extensions/emptyCell/EmptyCellPlugin */ "./lib/Extensions/emptyCell/EmptyCellPlugin.js");
/* harmony import */ var _Extensions_status__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Extensions/status */ "./lib/Extensions/status/index.js");
/* harmony import */ var _Extensions_SettingsManager_SettingsManagerPlugin__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Extensions/SettingsManager/SettingsManagerPlugin */ "./lib/Extensions/SettingsManager/SettingsManagerPlugin.js");
/* harmony import */ var _Extensions_VersionCheck__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Extensions/VersionCheck */ "./lib/Extensions/VersionCheck/index.js");
/* harmony import */ var _Extensions_NotebookFooter__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Extensions/NotebookFooter */ "./lib/Extensions/NotebookFooter/index.js");
/* harmony import */ var _Extensions_AppManager_ManageAppsPlugin__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Extensions/AppManager/ManageAppsPlugin */ "./lib/Extensions/AppManager/ManageAppsPlugin.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */












// This is the main entry point to the mito-ai extension. It must export all of the top level
// extensions that we want to load.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ([
    _Extensions_AiChat_AiChatPlugin__WEBPACK_IMPORTED_MODULE_0__["default"],
    _Extensions_ErrorMimeRenderer_ErrorMimeRendererPlugin__WEBPACK_IMPORTED_MODULE_1__["default"],
    _Extensions_ContextManager_ContextManagerPlugin__WEBPACK_IMPORTED_MODULE_2__["default"],
    _Extensions_AppDeploy_AppDeployPlugin__WEBPACK_IMPORTED_MODULE_3__["default"],
    _Extensions_AppPreview_StreamlitPreviewPlugin__WEBPACK_IMPORTED_MODULE_4__["default"],
    _Extensions_ToolbarButtons_ToolbarButtonsPlugin__WEBPACK_IMPORTED_MODULE_5__["default"],
    _Extensions_emptyCell_EmptyCellPlugin__WEBPACK_IMPORTED_MODULE_6__.emptyCellPlaceholder,
    _Extensions_status__WEBPACK_IMPORTED_MODULE_7__.statusItem,
    _Extensions_SettingsManager_SettingsManagerPlugin__WEBPACK_IMPORTED_MODULE_8__["default"],
    _Extensions_VersionCheck__WEBPACK_IMPORTED_MODULE_9__.versionCheckPlugin,
    _Extensions_NotebookFooter__WEBPACK_IMPORTED_MODULE_10__["default"],
    _Extensions_AppManager_ManageAppsPlugin__WEBPACK_IMPORTED_MODULE_11__["default"]
]);


/***/ }),

/***/ "./lib/restAPI/RestAPI.js":
/*!********************************!*\
  !*** ./lib/restAPI/RestAPI.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getChatHistoryThread: () => (/* binding */ getChatHistoryThread),
/* harmony export */   getChatHistoryThreads: () => (/* binding */ getChatHistoryThreads),
/* harmony export */   getDatabaseConnections: () => (/* binding */ getDatabaseConnections),
/* harmony export */   getRule: () => (/* binding */ getRule),
/* harmony export */   getRules: () => (/* binding */ getRules),
/* harmony export */   getSetting: () => (/* binding */ getSetting),
/* harmony export */   getUserKey: () => (/* binding */ getUserKey),
/* harmony export */   logEvent: () => (/* binding */ logEvent),
/* harmony export */   setRule: () => (/* binding */ setRule),
/* harmony export */   setUserKey: () => (/* binding */ setUserKey),
/* harmony export */   startStreamlitPreview: () => (/* binding */ startStreamlitPreview),
/* harmony export */   stopStreamlitPreview: () => (/* binding */ stopStreamlitPreview),
/* harmony export */   updateSettings: () => (/* binding */ updateSettings)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ "./lib/restAPI/utils.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/************************************

LOG ENDPOINTS

************************************/
const logEvent = async (logEvent, params) => {
    const resp = await (0,_utils__WEBPACK_IMPORTED_MODULE_0__.requestAPI)('log', {
        method: 'PUT',
        body: JSON.stringify({
            log_event: logEvent,
            params: params || {}
        }),
    });
    if (resp.error) {
        console.error(resp.error.message);
    }
};
/************************************

SETTINGS ENDPOINTS

************************************/
const getSetting = async (settingsKey) => {
    var _a;
    const resp = await (0,_utils__WEBPACK_IMPORTED_MODULE_0__.requestAPI)(`settings/${settingsKey}`);
    if (resp.error) {
        throw new Error(resp.error.message);
    }
    return ((_a = resp.data) === null || _a === void 0 ? void 0 : _a.value) || undefined;
};
const updateSettings = async (settingsKey, settingsValue) => {
    const resp = await (0,_utils__WEBPACK_IMPORTED_MODULE_0__.requestAPI)(`settings/${settingsKey}`, {
        method: 'PUT',
        body: JSON.stringify({ value: settingsValue }),
    });
    if (resp.error) {
        throw new Error(resp.error.message);
    }
    return resp.data || '';
};
/************************************

RULES ENDPOINTS

************************************/
const setRule = async (ruleName, ruleContent) => {
    const resp = await (0,_utils__WEBPACK_IMPORTED_MODULE_0__.requestAPI)(`rules/${ruleName}`, {
        method: 'PUT',
        body: JSON.stringify({ content: ruleContent }),
    });
    if (resp.error) {
        throw new Error(resp.error.message);
    }
    return resp.data || '';
};
const getRule = async (ruleName) => {
    var _a;
    const resp = await (0,_utils__WEBPACK_IMPORTED_MODULE_0__.requestAPI)(`rules/${ruleName}`);
    if (resp.error) {
        throw new Error(resp.error.message);
    }
    return (_a = resp.data) === null || _a === void 0 ? void 0 : _a.content;
};
const getRules = async () => {
    const resp = await (0,_utils__WEBPACK_IMPORTED_MODULE_0__.requestAPI)(`rules`);
    if (resp.error) {
        throw new Error(resp.error.message);
    }
    return resp.data || [];
};
/************************************

DATABASE ENDPOINTS

************************************/
const getDatabaseConnections = async () => {
    const resp = await (0,_utils__WEBPACK_IMPORTED_MODULE_0__.requestAPI)('db/connections');
    if (resp.error) {
        throw new Error(resp.error.message);
    }
    return resp.data || {};
};
/************************************

STREAMLIT PREVIEW ENDPOINTS

************************************/
const startStreamlitPreview = async (notebookPath, force_recreate = false, edit_prompt = '') => {
    const response = await (0,_utils__WEBPACK_IMPORTED_MODULE_0__.requestAPI)('streamlit-preview', {
        method: 'POST',
        body: JSON.stringify({
            notebook_path: notebookPath,
            force_recreate: force_recreate,
            edit_prompt: edit_prompt
        })
    });
    if (response.error) {
        throw new Error(response.error.message);
    }
    return response.data;
};
const stopStreamlitPreview = async (previewId) => {
    const response = await (0,_utils__WEBPACK_IMPORTED_MODULE_0__.requestAPI)(`streamlit-preview/${previewId}`, {
        method: 'DELETE',
    });
    if (response.error) {
        throw new Error(response.error.message);
    }
};
/************************************

USER ENDPOINTS

************************************/
const getUserKey = async (key) => {
    var _a;
    const resp = await (0,_utils__WEBPACK_IMPORTED_MODULE_0__.requestAPI)(`user/${key}`);
    if (resp.error) {
        throw new Error(resp.error.message);
    }
    return (_a = resp.data) === null || _a === void 0 ? void 0 : _a.value;
};
const setUserKey = async (key, value) => {
    const resp = await (0,_utils__WEBPACK_IMPORTED_MODULE_0__.requestAPI)(`user/${key}`, {
        method: 'PUT',
        body: JSON.stringify({ value: value }),
    });
    if (resp.error) {
        throw new Error(resp.error.message);
    }
    return resp.data || '';
};
const getChatHistoryThreads = async () => {
    var _a;
    const resp = await (0,_utils__WEBPACK_IMPORTED_MODULE_0__.requestAPI)('chat-history/threads');
    if (resp.error) {
        throw new Error(resp.error.message);
    }
    return ((_a = resp.data) === null || _a === void 0 ? void 0 : _a.threads) || [];
};
const getChatHistoryThread = async (threadId) => {
    const resp = await (0,_utils__WEBPACK_IMPORTED_MODULE_0__.requestAPI)(`chat-history/threads/${threadId}`);
    if (resp.error) {
        throw new Error(resp.error.message);
    }
    return resp.data;
};


/***/ }),

/***/ "./lib/restAPI/utils.js":
/*!******************************!*\
  !*** ./lib/restAPI/utils.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getXsrfToken: () => (/* binding */ getXsrfToken),
/* harmony export */   requestAPI: () => (/* binding */ requestAPI)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


/**
 * Call the API extension
 *
 * @param endPoint API REST end point for the extension
 * @param init Initial values for the request
 * @returns The response body interpreted as JSON
 */
async function requestAPI(endPoint = '', init = {}) {
    // Make request to Jupyter API
    const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
    const requestUrl = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.URLExt.join(settings.baseUrl, 'mito-ai', // API Namespace
    endPoint);
    let response;
    try {
        response = await _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(requestUrl, init, settings);
    }
    catch (error) {
        console.log(error);
        return {
            error: {
                message: error.message || 'Network error occurred',
                type: 'network'
            }
        };
    }
    let data = await response.text();
    if (!response.ok) {
        try {
            data = JSON.parse(data);
            return {
                error: {
                    message: data.error || 'Server error occurred',
                    type: 'response',
                    status: response.status
                }
            };
        }
        catch (error) {
            return {
                error: {
                    message: 'Server error occurred',
                    type: 'response',
                    status: response.status
                }
            };
        }
    }
    if (data.length > 0) {
        try {
            data = JSON.parse(data);
        }
        catch (error) {
            return {
                error: {
                    message: 'Invalid JSON response from server',
                    type: 'parse',
                    status: response.status
                }
            };
        }
    }
    return { data };
}
const getXsrfToken = () => {
    const cookies = document.cookie.split(';');
    const xsrfCookie = cookies.find(cookie => cookie.trim().startsWith('_xsrf='));
    if (xsrfCookie) {
        return xsrfCookie.split('=')[1];
    }
    return null;
};


/***/ }),

/***/ "./lib/utils/agentActions.js":
/*!***********************************!*\
  !*** ./lib/utils/agentActions.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   acceptAndRunCellUpdate: () => (/* binding */ acceptAndRunCellUpdate),
/* harmony export */   retryIfExecutionError: () => (/* binding */ retryIfExecutionError),
/* harmony export */   runAllCells: () => (/* binding */ runAllCells)
/* harmony export */ });
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Extensions_ErrorMimeRenderer_errorUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Extensions/ErrorMimeRenderer/errorUtils */ "./lib/Extensions/ErrorMimeRenderer/errorUtils.js");
/* harmony import */ var _sleep__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sleep */ "./lib/utils/sleep.js");
/* harmony import */ var _notebook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./notebook */ "./lib/utils/notebook.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */





const acceptAndRunCellUpdate = async (cellUpdate, notebookPanel) => {
    // If the cellUpdate is creating a new code cell, insert it 
    // before previewing and accepting the code. It is safe to do this 
    // in the background agent because it does not effect the active cell 
    // in other notebooks.
    if (cellUpdate.type === 'new') {
        // makes the cell the active cell
        (0,_notebook__WEBPACK_IMPORTED_MODULE_1__.createCodeCellAtIndexAndActivate)(notebookPanel, cellUpdate.index);
    }
    else {
        (0,_notebook__WEBPACK_IMPORTED_MODULE_1__.setActiveCellByIDInNotebookPanel)(notebookPanel, cellUpdate.id);
    }
    const notebook = notebookPanel.content;
    const context = notebookPanel.context;
    if (notebook === undefined) {
        return;
    }
    const cellID = (0,_notebook__WEBPACK_IMPORTED_MODULE_1__.getActiveCellIDInNotebookPanel)(notebookPanel);
    (0,_notebook__WEBPACK_IMPORTED_MODULE_1__.writeCodeToCellByIDInNotebookPanel)(notebookPanel, cellUpdate.code, cellID);
    // We always create code cells, and then convert to markdown if necessary.
    if (cellUpdate.cell_type === 'markdown') {
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.NotebookActions.changeCellType(notebook, 'markdown');
    }
    else if (cellUpdate.cell_type === 'code') {
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.NotebookActions.changeCellType(notebook, 'code');
    }
    // This awaits until after the execution is finished.
    // Note that it is important that we just run the cell and don't run and advance the cell. 
    // We rely on the active cell remaining the same after running the cell in order to get the output
    // of the cell to send to the agent. This is changeable in the future, but for now its an invariant we rely on.
    await _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.NotebookActions.run(notebook, context === null || context === void 0 ? void 0 : context.sessionContext);
    // Scroll to the bottom of the active cell to show the output
    // as long as we are not operating in background agent mode.
    const activeCellID = (0,_notebook__WEBPACK_IMPORTED_MODULE_1__.getActiveCellIDInNotebookPanel)(notebookPanel);
    if (activeCellID) {
        (0,_notebook__WEBPACK_IMPORTED_MODULE_1__.scrollToCell)(notebookPanel, activeCellID, undefined, 'end');
    }
    // By sleeping here, we make sure that this function returns after the variable manager
    // has updated the state of the variables. This ensures that on the next Ai message
    // gets the most up to date data.
    await (0,_sleep__WEBPACK_IMPORTED_MODULE_2__.sleep)(1000);
};
const retryIfExecutionError = async (notebookPanel, app, sendAgentSmartDebugMessage, shouldContinueAgentExecution, markAgentForStopping, chatHistoryManagerRef) => {
    var _a;
    const cell = notebookPanel.content.activeCell;
    // Note: If you update the max retries, update the message we display on each failure
    // attempt to ensure we don't say "third attempt" over and over again.
    const MAX_RETRIES = 3;
    let attempts = 0;
    let runAllCellsAttempts = 0;
    const MAX_RUN_ALL_CELLS_ATTEMPTS = 2; // Only allow two run_all_cells attempt per error cycle
    while ((0,_notebook__WEBPACK_IMPORTED_MODULE_1__.didCellExecutionError)(cell) && attempts < MAX_RETRIES) {
        if (!shouldContinueAgentExecution.current) {
            await markAgentForStopping();
            return 'interupted';
        }
        // If the code cell has an error, we need to send the error to the AI
        // and get it to fix the error.
        const errorOutput = (_a = cell === null || cell === void 0 ? void 0 : cell.model.outputs) === null || _a === void 0 ? void 0 : _a.toJSON().find(output => output.output_type === "error");
        if (!errorOutput) {
            return 'success'; // If no error output, we're done
        }
        const errorMessage = (0,_Extensions_ErrorMimeRenderer_errorUtils__WEBPACK_IMPORTED_MODULE_3__.getFullErrorMessageFromTraceback)(errorOutput.traceback);
        await sendAgentSmartDebugMessage(errorMessage);
        const aiDisplayOptimizedChatItem = chatHistoryManagerRef.current.getLastAIDisplayOptimizedChatItem();
        // Handle different response types from the agent when fixing errors
        const agentResponse = aiDisplayOptimizedChatItem === null || aiDisplayOptimizedChatItem === void 0 ? void 0 : aiDisplayOptimizedChatItem.agentResponse;
        if (!agentResponse) {
            return 'failure';
        }
        if (agentResponse.type === 'cell_update') {
            const cellUpdate = agentResponse.cell_update;
            if (cellUpdate !== undefined && cellUpdate !== null) {
                await acceptAndRunCellUpdate(cellUpdate, notebookPanel);
            }
        }
        else if (agentResponse.type === 'run_all_cells') {
            // Prevent infinite loops by limiting run_all_cells attempts
            if (runAllCellsAttempts >= MAX_RUN_ALL_CELLS_ATTEMPTS) {
                console.log('Maximum run_all_cells attempts reached, treating as failure');
                return 'failure';
            }
            runAllCellsAttempts++;
            // Execute runAllCells to fix NameError issues
            const result = await runAllCells(app, notebookPanel);
            if (!result.success) {
                // If run_all_cells resulted in an error, we should continue with error handling
                // The error will be caught in the main loop
                console.log('Error after running all cells:', result.errorMessage);
            }
        }
        else {
            // Agent responded with an unexpected type for error fixing
            return 'failure';
        }
        attempts++;
        // If this was the last attempt and it still failed
        if (attempts === MAX_RETRIES && (0,_notebook__WEBPACK_IMPORTED_MODULE_1__.didCellExecutionError)(cell)) {
            return 'failure';
        }
    }
    return 'success';
};
const runAllCells = async (app, notebookPanel) => {
    var _a, _b;
    const notebook = notebookPanel.content;
    const sessionContext = (_a = notebookPanel.context) === null || _a === void 0 ? void 0 : _a.sessionContext;
    await _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.NotebookActions.runAll(notebook, sessionContext);
    // Give the execution some time to complete and update variables
    // This ensures that the variable manager has time to update the state
    await (0,_sleep__WEBPACK_IMPORTED_MODULE_2__.sleep)(2000);
    // Iterate through all cells to find any with errors
    for (let i = 0; i < notebook.widgets.length; i++) {
        const cell = notebook.widgets[i];
        if (cell && cell.model.type === 'code') {
            const codeCell = cell;
            if ((0,_notebook__WEBPACK_IMPORTED_MODULE_1__.didCellExecutionError)(codeCell)) {
                const errorOutput = (_b = codeCell.model.outputs) === null || _b === void 0 ? void 0 : _b.toJSON().find(output => output.output_type === "error");
                if (errorOutput) {
                    const errorMessage = (0,_Extensions_ErrorMimeRenderer_errorUtils__WEBPACK_IMPORTED_MODULE_3__.getFullErrorMessageFromTraceback)(errorOutput.traceback);
                    return {
                        success: false,
                        errorMessage: errorMessage,
                        errorCellId: codeCell.model.id
                    };
                }
            }
        }
    }
    return { success: true };
};


/***/ }),

/***/ "./lib/utils/arrays.js":
/*!*****************************!*\
  !*** ./lib/utils/arrays.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   deepEqualArrays: () => (/* binding */ deepEqualArrays)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
const deepEqualArrays = (arr1, arr2) => {
    if (arr1.length !== arr2.length)
        return false;
    for (let i = 0; i < arr1.length; i++) {
        if (typeof arr1[i] === 'object' && typeof arr2[i] === 'object') {
            if (!deepEqualArrays(arr1[i], arr2[i]))
                return false;
        }
        else if (arr1[i] !== arr2[i]) {
            return false;
        }
    }
    return true;
};


/***/ }),

/***/ "./lib/utils/blacklistedWords.js":
/*!***************************************!*\
  !*** ./lib/utils/blacklistedWords.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkForBlacklistedWords: () => (/* binding */ checkForBlacklistedWords)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
// Function to check for blacklisted words that could be dangerous for the agent to execute
const checkForBlacklistedWords = (code) => {
    // List of dangerous operations/commands that could delete files or cause harm
    const blacklistedPatterns = [
        {
            pattern: /\brm\s+-rf\b/,
            message: "This code contains a command (rm -rf) that could recursively delete files and directories from your system"
        },
        {
            pattern: /\bfs\.rmdir\b/,
            message: "This code contains a Node.js command (fs.rmdir) that could delete directories from your system"
        },
        {
            pattern: /\bfs\.unlink\b/,
            message: "This code contains a Node.js command (fs.unlink) that could delete files from your system"
        },
        {
            pattern: /\bshutil\.rmtree\b/,
            message: "This code contains a Python command (shutil.rmtree) that could recursively delete directories and their contents"
        },
        {
            pattern: /\bos\.remove\b/,
            message: "This code contains a Python command (os.remove) that could delete files from your system"
        },
        {
            pattern: /\bos\.rmdir\b/,
            message: "This code contains a Python command (os.rmdir) that could delete directories from your system"
        },
        {
            pattern: /\bos\.unlink\b/,
            message: "This code contains a Python command (os.unlink) that could delete files from your system"
        },
        {
            pattern: /\brmdir\b/,
            message: "This code contains a command (rmdir) that could delete directories from your system"
        },
        {
            pattern: /\bunlink\b/,
            message: "This code contains a function (unlink) that could delete files from your system"
        },
        {
            pattern: /\bdelete\s+from\b/i,
            message: "This code contains an SQL DELETE command that could remove data from your database"
        },
        {
            pattern: /\bdrop\s+table\b/i,
            message: "This code contains an SQL DROP TABLE command that could delete entire tables from your database"
        },
        {
            pattern: /\bdrop\s+database\b/i,
            message: "This code contains an SQL DROP DATABASE command that could delete your entire database"
        },
        {
            pattern: /\bformat\s*\(/,
            message: "This code contains a format command that could potentially format your drives or storage devices"
        },
        {
            pattern: /\bsystem\s*\(/,
            message: "This code contains a system() call that could execute arbitrary system commands, which is a security risk"
        },
        {
            pattern: /\beval\s*\(/,
            message: "This code contains an eval() function that could execute arbitrary code, which is a security risk"
        },
        {
            pattern: /\bexec\s*\(/,
            message: "This code contains an exec() function that could execute arbitrary code, which is a security risk"
        },
    ];
    for (const { pattern, message } of blacklistedPatterns) {
        if (pattern.test(code)) {
            return {
                safe: false,
                reason: message
            };
        }
    }
    return { safe: true };
};


/***/ }),

/***/ "./lib/utils/cellMetadata.js":
/*!***********************************!*\
  !*** ./lib/utils/cellMetadata.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getActiveCellIncludeInApp: () => (/* binding */ getActiveCellIncludeInApp),
/* harmony export */   getIncludeCellInApp: () => (/* binding */ getIncludeCellInApp),
/* harmony export */   toggleActiveCellIncludeInAppMetadata: () => (/* binding */ toggleActiveCellIncludeInAppMetadata),
/* harmony export */   toggleIncludeCellInAppMetadata: () => (/* binding */ toggleIncludeCellInAppMetadata)
/* harmony export */ });
/* harmony import */ var _notebook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./notebook */ "./lib/utils/notebook.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const INCLUDE_CELL_IN_APP = 'include-cell-in-app';
const toggleActiveCellIncludeInAppMetadata = (notebookTracker) => {
    const activeCellID = (0,_notebook__WEBPACK_IMPORTED_MODULE_0__.getActiveCellID)(notebookTracker);
    toggleIncludeCellInAppMetadata(notebookTracker, activeCellID);
};
const toggleIncludeCellInAppMetadata = (notebookTracker, cellID) => {
    if (cellID === undefined) {
        return;
    }
    const cell = (0,_notebook__WEBPACK_IMPORTED_MODULE_0__.getCellByID)(notebookTracker, cellID);
    if (!cell) {
        return undefined;
    }
    if (Object.prototype.hasOwnProperty.call(cell.model.metadata, INCLUDE_CELL_IN_APP)) {
        const originalVisibility = cell.model.getMetadata(INCLUDE_CELL_IN_APP);
        cell.model.setMetadata(INCLUDE_CELL_IN_APP, !originalVisibility);
    }
    else {
        // If the metadata doesn't exist yet, that means the user has not yet toggled the visibility.
        // The default value is to show the output, so the first toggle should set the visibiltiy to false.
        cell.model.setMetadata(INCLUDE_CELL_IN_APP, false);
    }
};
const getActiveCellIncludeInApp = (notebookTracker) => {
    const activeCellID = (0,_notebook__WEBPACK_IMPORTED_MODULE_0__.getActiveCellID)(notebookTracker);
    return getIncludeCellInApp(notebookTracker, activeCellID);
};
const getIncludeCellInApp = (notebookTracker, cellID) => {
    /*
    Checks the cell metadata tag to see if the user has marked that this cell should not be included in the app.
    */
    const cell = (0,_notebook__WEBPACK_IMPORTED_MODULE_0__.getCellByID)(notebookTracker, cellID);
    if (!cell) {
        return false;
    }
    if (!Object.prototype.hasOwnProperty.call(cell.model.metadata, INCLUDE_CELL_IN_APP)) {
        cell.model.setMetadata(INCLUDE_CELL_IN_APP, true);
    }
    return cell.model.getMetadata(INCLUDE_CELL_IN_APP);
};


/***/ }),

/***/ "./lib/utils/cellOutput.js":
/*!*********************************!*\
  !*** ./lib/utils/cellOutput.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getActiveCellOutput: () => (/* binding */ getActiveCellOutput),
/* harmony export */   getCellOutputByID: () => (/* binding */ getCellOutputByID),
/* harmony export */   getCellOutputByIDInNotebook: () => (/* binding */ getCellOutputByIDInNotebook)
/* harmony export */ });
/* harmony import */ var _jupyterlab_cells__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/cells */ "webpack/sharing/consume/default/@jupyterlab/cells");
/* harmony import */ var _jupyterlab_cells__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_cells__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _notebook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./notebook */ "./lib/utils/notebook.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


const getActiveCellOutput = async (notebookTracker) => {
    const activeCellID = (0,_notebook__WEBPACK_IMPORTED_MODULE_1__.getActiveCellID)(notebookTracker);
    return getCellOutputByID(notebookTracker, activeCellID);
};
const getCellOutputByID = async (notebookTracker, codeCellID) => {
    const notebookPanel = notebookTracker.currentWidget;
    return getCellOutputByIDInNotebook(notebookPanel, codeCellID);
};
const getCellOutputByIDInNotebook = async (notebookPanel, codeCellID) => {
    // TODO: There is a bug where if the cell is not actually rendered on the screen, 
    // then the output is not captured. This is pretty unlikely to happen currently because
    // the agent scrolls to the cell.
    var _a;
    if (codeCellID === undefined || notebookPanel === null) {
        return undefined;
    }
    const cell = notebookPanel.content.widgets.find(cell => cell.model.id === codeCellID);
    if (!(cell instanceof _jupyterlab_cells__WEBPACK_IMPORTED_MODULE_0__.CodeCell)) {
        return undefined;
    }
    const outputNode = (_a = cell.outputArea) === null || _a === void 0 ? void 0 : _a.node;
    if (!outputNode)
        return undefined;
    // Find the top-level Jupyter image output div
    // so we can check if there is a base64 encoded image 
    // already constructed for us.
    const renderedImageDiv = outputNode.querySelector('.jp-RenderedImage.jp-OutputArea-output');
    // If the image is the top-level output, then just use that instead
    // of capturing the entire output node. This is much faster and handles
    // matplotlib graphs.
    if (renderedImageDiv) {
        const img = renderedImageDiv.querySelector('img');
        if (img && img.src.startsWith('data:image')) {
            console.log('image found in top-level output');
            // Remove the data URL prefix
            // The img is initially in the format data:image/png;base64, <base64_data>
            // We want to return the base64 data.
            const base64 = img.src.split(',')[1];
            return base64;
        }
    }
    // Fallback: (optional) handle other output types, or use captureNode if needed
    // Previously, we used html2canvas to capture the entire output node. This would
    // give us the output even if it was html, svg, text, etc. However, starting around 
    // Chrome release 138, html2canvas became untenably slow. https://issues.chromium.org/issues/429073017
    if (outputNode) {
        // If the AI requested, a cell output that we cannot provide, we just tell it 
        // "Cell Output is present in notebook, but not available to share with the AI right now"
        return "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";
    }
    return undefined;
};


/***/ }),

/***/ "./lib/utils/chatHistory.js":
/*!**********************************!*\
  !*** ./lib/utils/chatHistory.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   processChatHistoryForErrorGrouping: () => (/* binding */ processChatHistoryForErrorGrouping)
/* harmony export */ });
/* harmony import */ var _strings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./strings */ "./lib/utils/strings.js");
/* harmony import */ var _errors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./errors */ "./lib/utils/errors.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


/**
 * Processes chat history to group consecutive error fixup messages together.
 * This helps in displaying error messages and their responses as a single unit in the UI.
 *
 * @param displayOptimizedChatHistory - The original chat history to process
 * @returns An array where error fixup messages and their responses are grouped together,
 *          while other messages remain as individual items
 */
const processChatHistoryForErrorGrouping = (displayOptimizedChatHistory) => {
    var _a, _b;
    const processedDisplayOptimizedChatHistory = [];
    let groupedErrorMessages = [];
    for (let i = 0; i < displayOptimizedChatHistory.length; i++) {
        const displayOptimizedChatItem = displayOptimizedChatHistory[i];
        if (!displayOptimizedChatItem) {
            continue;
        }
        const messageContent = (0,_strings__WEBPACK_IMPORTED_MODULE_0__.getContentStringFromMessage)(displayOptimizedChatItem.message);
        const _isErrorFixupMessage = (0,_errors__WEBPACK_IMPORTED_MODULE_1__.isErrorFixupMessage)(displayOptimizedChatItem.promptType, displayOptimizedChatItem.message, messageContent);
        if (_isErrorFixupMessage) {
            // If the current message is an error fixup message, we need to group it with the next message
            // which is the ai response to the error fixup message.
            groupedErrorMessages.push(displayOptimizedChatItem);
            // Note: We check that the next message is an ai response to the error fixup message.
            // If the user has stopped the agent, it might not be an ai response to the error fixup message.
            const next_index = i + 1;
            if (next_index < displayOptimizedChatHistory.length &&
                ((_a = displayOptimizedChatHistory[next_index]) === null || _a === void 0 ? void 0 : _a.type) === 'openai message' &&
                ((_b = displayOptimizedChatHistory[next_index]) === null || _b === void 0 ? void 0 : _b.message.role) === 'assistant') {
                groupedErrorMessages.push(displayOptimizedChatHistory[next_index]);
                i = next_index;
            }
        }
        else {
            if (groupedErrorMessages.length > 0) {
                processedDisplayOptimizedChatHistory.push(groupedErrorMessages);
                // Create a new array object since arrays are mutable and we want to avoid
                // accidentally modifying the array that was just pushed to the history
                groupedErrorMessages = new Array();
            }
            processedDisplayOptimizedChatHistory.push(displayOptimizedChatItem);
        }
    }
    // Handle case where the last messages were error messages
    if (groupedErrorMessages.length > 0) {
        processedDisplayOptimizedChatHistory.push(groupedErrorMessages);
    }
    return processedDisplayOptimizedChatHistory;
};


/***/ }),

/***/ "./lib/utils/checkpoint.js":
/*!*********************************!*\
  !*** ./lib/utils/checkpoint.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createCheckpoint: () => (/* binding */ createCheckpoint),
/* harmony export */   getNotebookStateHash: () => (/* binding */ getNotebookStateHash),
/* harmony export */   restoreCheckpoint: () => (/* binding */ restoreCheckpoint)
/* harmony export */ });
/* harmony import */ var _notebook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./notebook */ "./lib/utils/notebook.js");
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


const createCheckpoint = async (app, setHasCheckpoint) => {
    // By saving the notebook, we create a checkpoint that we can restore from
    await app.commands.execute("docmanager:save");
    // Despite what the docs say, this does not seem to do anything:
    // await app.commands.execute("logconsole:add-checkpoint")
    setHasCheckpoint(true);
};
// Helper function to get a hash of the current notebook state
const getNotebookStateHash = (notebookTracker) => {
    const cells = (0,_notebook__WEBPACK_IMPORTED_MODULE_0__.getAIOptimizedCells)(notebookTracker);
    // Create a simple hash by concatenating all cell IDs and their content
    const notebookState = cells.map(cell => `${cell.id}:${cell.code}`).join('|');
    return notebookState;
};
const restoreCheckpoint = async (app, notebookTracker, setHasCheckpoint) => {
    // Get the notebook state before attempting restoration
    const notebookStateBefore = getNotebookStateHash(notebookTracker);
    // Restore the checkpoint        
    await app.commands.execute("docmanager:restore-checkpoint");
    // Get the notebook state after the command
    const notebookStateAfter = getNotebookStateHash(notebookTracker);
    // Only proceed with state updates if the notebook actually changed
    if (notebookStateBefore === notebookStateAfter) {
        // The user canceled the restoration, so don't update any state
        return;
    }
    // The restoration was successful, so update the state
    setHasCheckpoint(false);
    // Log the checkpoint restoration
    void (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_1__.logEvent)('mito_ai_checkpoint_restored', {});
    // Restart the run all
    await app.commands.execute("notebook:restart-run-all");
};


/***/ }),

/***/ "./lib/utils/classNames.js":
/*!*********************************!*\
  !*** ./lib/utils/classNames.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   classNames: () => (/* binding */ classNames)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
/*
    A utility for constructing a valid classnames string, you can either pass
    a string, or an object that maps a string to a boolean value, indicating if
    it should be included in the final object.

    For example:
        classNames('abc', '123') = 'abc 123'
        classNames('abc', {'123': true}) = 'abc 123'
        classNames('abc', {'123': false}) = 'abc'
*/
const classNames = (...args) => {
    let finalString = '';
    for (let i = 0; i < args.length; i++) {
        const arg = args[i];
        // Skip undefined arguments
        if (arg === undefined) {
            continue;
        }
        if (typeof arg === 'string') {
            finalString += arg + ' ';
        }
        else {
            Object.entries(arg).map(([className, include]) => {
                if (include) {
                    finalString += className + ' ';
                }
            });
        }
    }
    return finalString;
};


/***/ }),

/***/ "./lib/utils/codeDiff.js":
/*!*******************************!*\
  !*** ./lib/utils/codeDiff.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createUnifiedDiff: () => (/* binding */ createUnifiedDiff),
/* harmony export */   getCodeDiffLineRanges: () => (/* binding */ getCodeDiffLineRanges),
/* harmony export */   getCodeDiffsAndUnifiedCodeString: () => (/* binding */ getCodeDiffsAndUnifiedCodeString)
/* harmony export */ });
/* harmony import */ var vscode_diff__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vscode-diff */ "webpack/sharing/consume/default/vscode-diff/vscode-diff");
/* harmony import */ var vscode_diff__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(vscode_diff__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const getCodeDiffLineRanges = (originalLines, modifiedLines) => {
    if (originalLines === undefined || originalLines === null) {
        originalLines = '';
    }
    if (modifiedLines === undefined || modifiedLines === null) {
        modifiedLines = '';
    }
    const originalLinesArray = originalLines.split('\n');
    const modifiedLinesArray = modifiedLines.split('\n');
    const options = {
        shouldPostProcessCharChanges: true,
        shouldIgnoreTrimWhitespace: true,
        shouldMakePrettyDiff: true,
        shouldComputeCharChanges: true,
        maxComputationTime: 0 // time in milliseconds, 0 => no computation limit.
    };
    const diffComputer = new vscode_diff__WEBPACK_IMPORTED_MODULE_0__.DiffComputer(originalLinesArray, modifiedLinesArray, options);
    const lineChanges = diffComputer.computeDiff().changes;
    return lineChanges || [];
};
const createUnifiedDiff = (originalCode, modifiedCode, lineChanges) => {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    if (originalCode === undefined || originalCode === null) {
        originalCode = '';
    }
    if (modifiedCode === undefined || modifiedCode === null) {
        modifiedCode = '';
    }
    const originalLines = originalCode.split('\n');
    const modifiedLines = modifiedCode.split('\n');
    /*
    Algorithm explanation:
    
    This function creates a unified diff by comparing the original and modified code.
    It iterates through both versions of the code simultaneously, creating a new representation
    of the code called result that is UnifiedDiffLine[]. Each time the algorithm sees a new line
    of code, it adds it to the result, marking it as unchanged, removed, or inserted.

    The algorithm works as follows:
    1. Process unchanged lines until a change is encountered.
    2. When a change is found, handle it based on its type:
        a. Modification: Mark original lines as removed, mark modified lines as inserted.
        b. Inserted: Add new lines from the modified code and mark as Inserted.
        c. Removed: Add removed lines from the original code to the result and mark as Removed.
    3. After processing all changes, handle any remaining lines.
    The result is a unified diff that shows all changes in context.
    */
    const result = [];
    let originalLineNum = 1;
    let modifiedLineNum = 1;
    let changeIndex = 0;
    while (originalLineNum <= originalLines.length ||
        modifiedLineNum <= modifiedLines.length) {
        if (changeIndex < lineChanges.length) {
            const change = lineChanges[changeIndex];
            if (change === undefined) {
                break;
            }
            // Process unchanged lines before the next change
            while ((originalLineNum < change.originalStartLineNumber ||
                modifiedLineNum < change.modifiedStartLineNumber) &&
                originalLineNum <= originalLines.length &&
                modifiedLineNum <= modifiedLines.length) {
                result.push({
                    content: (_a = originalLines[originalLineNum - 1]) !== null && _a !== void 0 ? _a : '',
                    type: 'unchanged',
                    originalLineNumber: originalLineNum,
                    modifiedLineNumber: modifiedLineNum,
                });
                originalLineNum++;
                modifiedLineNum++;
            }
            // Process the change
            if (change.originalEndLineNumber > 0 &&
                change.modifiedEndLineNumber > 0) {
                // Modification
                // First add removed lines
                for (; originalLineNum <= change.originalEndLineNumber; originalLineNum++) {
                    result.push({
                        content: (_b = originalLines[originalLineNum - 1]) !== null && _b !== void 0 ? _b : '',
                        type: 'removed',
                        originalLineNumber: originalLineNum,
                        modifiedLineNumber: null,
                    });
                }
                // Then add inserted lines
                for (; modifiedLineNum <= change.modifiedEndLineNumber; modifiedLineNum++) {
                    result.push({
                        content: (_c = modifiedLines[modifiedLineNum - 1]) !== null && _c !== void 0 ? _c : '',
                        type: 'inserted',
                        originalLineNumber: null,
                        modifiedLineNumber: modifiedLineNum,
                    });
                }
            }
            else if (change.originalEndLineNumber === 0) {
                // Inserted Lines
                for (; modifiedLineNum <= change.modifiedEndLineNumber; modifiedLineNum++) {
                    result.push({
                        content: (_d = modifiedLines[modifiedLineNum - 1]) !== null && _d !== void 0 ? _d : '',
                        type: 'inserted',
                        originalLineNumber: null,
                        modifiedLineNumber: modifiedLineNum,
                    });
                }
            }
            else if (change.modifiedEndLineNumber === 0) {
                // Removed lines
                for (; originalLineNum <= change.originalEndLineNumber; originalLineNum++) {
                    result.push({
                        content: (_e = originalLines[originalLineNum - 1]) !== null && _e !== void 0 ? _e : '',
                        type: 'removed',
                        originalLineNumber: originalLineNum,
                        modifiedLineNumber: null,
                    });
                }
            }
            changeIndex++;
        }
        else {
            // Process any remaining unchanged lines
            if (originalLineNum <= originalLines.length &&
                modifiedLineNum <= modifiedLines.length) {
                result.push({
                    content: (_f = originalLines[originalLineNum - 1]) !== null && _f !== void 0 ? _f : '',
                    type: 'unchanged',
                    originalLineNumber: originalLineNum,
                    modifiedLineNumber: modifiedLineNum,
                });
                originalLineNum++;
                modifiedLineNum++;
            }
            else if (originalLineNum <= originalLines.length) {
                // Remaining lines were removed
                result.push({
                    content: (_g = originalLines[originalLineNum - 1]) !== null && _g !== void 0 ? _g : '',
                    type: 'removed',
                    originalLineNumber: originalLineNum,
                    modifiedLineNumber: null,
                });
                originalLineNum++;
            }
            else if (modifiedLineNum <= modifiedLines.length) {
                // Remaining lines were added
                result.push({
                    content: (_h = modifiedLines[modifiedLineNum - 1]) !== null && _h !== void 0 ? _h : '',
                    type: 'inserted',
                    originalLineNumber: null,
                    modifiedLineNumber: modifiedLineNum,
                });
                modifiedLineNum++;
            }
            else {
                break;
            }
        }
    }
    return result;
};
const getCodeDiffsAndUnifiedCodeString = (originalCode, modifiedCode) => {
    const lineChanges = getCodeDiffLineRanges(originalCode, modifiedCode);
    const unifiedDiffs = createUnifiedDiff(originalCode, modifiedCode, lineChanges);
    const unifiedCodeString = (unifiedDiffs.map(line => {
        return line.content !== undefined ? line.content : '';
    }).join('\n'));
    return {
        unifiedCodeString,
        unifiedDiffs
    };
};


/***/ }),

/***/ "./lib/utils/constants.js":
/*!********************************!*\
  !*** ./lib/utils/constants.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EVENT_NAMES: () => (/* binding */ EVENT_NAMES)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
const EVENT_NAMES = {
    MITO_AI_CAPTURE_REQUEST: 'mito-ai-capture-request',
};


/***/ }),

/***/ "./lib/utils/copyToClipboard.js":
/*!**************************************!*\
  !*** ./lib/utils/copyToClipboard.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _strings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./strings */ "./lib/utils/strings.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

const copyToClipboard = async (text) => {
    const codeWithoutMarkdown = (0,_strings__WEBPACK_IMPORTED_MODULE_0__.removeMarkdownCodeFormatting)(text);
    await navigator.clipboard.writeText(codeWithoutMarkdown !== null && codeWithoutMarkdown !== void 0 ? codeWithoutMarkdown : '');
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (copyToClipboard);


/***/ }),

/***/ "./lib/utils/errors.js":
/*!*****************************!*\
  !*** ./lib/utils/errors.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FREE_TIER_LIMIT_REACHED_ERROR_TITLE: () => (/* binding */ FREE_TIER_LIMIT_REACHED_ERROR_TITLE),
/* harmony export */   isErrorFixupMessage: () => (/* binding */ isErrorFixupMessage)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
const FREE_TIER_LIMIT_REACHED_ERROR_TITLE = 'mito_server_free_tier_limit_reached';
const isErrorFixupMessage = (promptType, message, messageContent) => {
    if (!messageContent) {
        return false;
    }
    return (
    // Initially, messages are labeled with the prompt type 'agent:autoErrorFixup'
    promptType === 'agent:autoErrorFixup' ||
        // However, when the chat history is saved, this field is stripped, and every message is labeled as 'chat'.
        // In this case we have to manually determine if the message is an error fixup message.
        (message.role === 'user' &&
            messageContent &&
            messageContent.includes('->') || (messageContent === null || messageContent === void 0 ? void 0 : messageContent.includes('^')) &&
            /\w+Error:/.test(messageContent)));
};


/***/ }),

/***/ "./lib/utils/fileName.js":
/*!*******************************!*\
  !*** ./lib/utils/fileName.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidFileName: () => (/* binding */ isValidFileName),
/* harmony export */   stripFileEnding: () => (/* binding */ stripFileEnding)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
// This function checks if a given string is a valid file name.
// It returns true if the string contains only alphanumeric characters, underscores, or hyphens.
const isValidFileName = (fileName) => {
    return /^[a-zA-Z0-9_-]+$/.test(fileName);
};
const stripFileEnding = (rule) => {
    return rule.replace('.md', '');
};


/***/ }),

/***/ "./lib/utils/models.js":
/*!*****************************!*\
  !*** ./lib/utils/models.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CLAUDE_SONNET_DISPLAY_NAME: () => (/* binding */ CLAUDE_SONNET_DISPLAY_NAME),
/* harmony export */   CLAUDE_SONNET_MODEL_NAME: () => (/* binding */ CLAUDE_SONNET_MODEL_NAME),
/* harmony export */   GPT_4_1_DISPLAY_NAME: () => (/* binding */ GPT_4_1_DISPLAY_NAME),
/* harmony export */   GPT_4_1_MODEL_NAME: () => (/* binding */ GPT_4_1_MODEL_NAME)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
const CLAUDE_SONNET_DISPLAY_NAME = 'Claude 4.5 Sonnet';
const CLAUDE_SONNET_MODEL_NAME = 'claude-sonnet-4-5-20250929';
const GPT_4_1_DISPLAY_NAME = 'GPT 4.1';
const GPT_4_1_MODEL_NAME = 'gpt-4.1';


/***/ }),

/***/ "./lib/utils/notebook.js":
/*!*******************************!*\
  !*** ./lib/utils/notebook.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createCodeCellAtIndexAndActivate: () => (/* binding */ createCodeCellAtIndexAndActivate),
/* harmony export */   didCellExecutionError: () => (/* binding */ didCellExecutionError),
/* harmony export */   getAIOptimizedCells: () => (/* binding */ getAIOptimizedCells),
/* harmony export */   getAIOptimizedCellsInNotebookPanel: () => (/* binding */ getAIOptimizedCellsInNotebookPanel),
/* harmony export */   getActiveCell: () => (/* binding */ getActiveCell),
/* harmony export */   getActiveCellCode: () => (/* binding */ getActiveCellCode),
/* harmony export */   getActiveCellID: () => (/* binding */ getActiveCellID),
/* harmony export */   getActiveCellIDInNotebookPanel: () => (/* binding */ getActiveCellIDInNotebookPanel),
/* harmony export */   getActiveCellInNotebookPanel: () => (/* binding */ getActiveCellInNotebookPanel),
/* harmony export */   getCellByID: () => (/* binding */ getCellByID),
/* harmony export */   getCellByIDInNotebookPanel: () => (/* binding */ getCellByIDInNotebookPanel),
/* harmony export */   getCellCodeByID: () => (/* binding */ getCellCodeByID),
/* harmony export */   getCellCodeByIDInNotebookPanel: () => (/* binding */ getCellCodeByIDInNotebookPanel),
/* harmony export */   getCellIndexByID: () => (/* binding */ getCellIndexByID),
/* harmony export */   getCellIndexByIDInNotebookPanel: () => (/* binding */ getCellIndexByIDInNotebookPanel),
/* harmony export */   getNotebookName: () => (/* binding */ getNotebookName),
/* harmony export */   highlightCodeCell: () => (/* binding */ highlightCodeCell),
/* harmony export */   highlightLinesOfCodeInCodeCell: () => (/* binding */ highlightLinesOfCodeInCodeCell),
/* harmony export */   scrollToAndHighlightCell: () => (/* binding */ scrollToAndHighlightCell),
/* harmony export */   scrollToCell: () => (/* binding */ scrollToCell),
/* harmony export */   setActiveCellByID: () => (/* binding */ setActiveCellByID),
/* harmony export */   setActiveCellByIDInNotebookPanel: () => (/* binding */ setActiveCellByIDInNotebookPanel),
/* harmony export */   writeCodeToCellByID: () => (/* binding */ writeCodeToCellByID),
/* harmony export */   writeCodeToCellByIDInNotebookPanel: () => (/* binding */ writeCodeToCellByIDInNotebookPanel)
/* harmony export */ });
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _strings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./strings */ "./lib/utils/strings.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


const getActiveCell = (notebookTracker) => {
    const notebookPanel = notebookTracker.currentWidget;
    return getActiveCellInNotebookPanel(notebookPanel);
};
const getActiveCellInNotebookPanel = (notebookPanel) => {
    const activeCell = notebookPanel === null || notebookPanel === void 0 ? void 0 : notebookPanel.content.activeCell;
    return activeCell || undefined;
};
const getCellByID = (notebookTracker, cellID) => {
    const notebook = notebookTracker.currentWidget;
    return getCellByIDInNotebookPanel(notebook, cellID);
};
const getCellByIDInNotebookPanel = (notebookPanel, cellID) => {
    if (cellID === undefined) {
        return undefined;
    }
    return notebookPanel === null || notebookPanel === void 0 ? void 0 : notebookPanel.content.widgets.find(cell => cell.model.id === cellID);
};
const getActiveCellID = (notebookTracker) => {
    const notebookPanel = notebookTracker.currentWidget;
    return getActiveCellIDInNotebookPanel(notebookPanel);
};
const getActiveCellIDInNotebookPanel = (notebookPanel) => {
    var _a;
    return (_a = getActiveCellInNotebookPanel(notebookPanel)) === null || _a === void 0 ? void 0 : _a.model.id;
};
const getActiveCellCode = (notebookTracker) => {
    const activeCell = getActiveCell(notebookTracker);
    return activeCell === null || activeCell === void 0 ? void 0 : activeCell.model.sharedModel.source;
};
const getCellCodeByID = (notebookTracker, codeCellID) => {
    const notebookPanel = notebookTracker.currentWidget;
    return getCellCodeByIDInNotebookPanel(notebookPanel, codeCellID);
};
const getCellCodeByIDInNotebookPanel = (notebookPanel, codeCellID) => {
    const cell = getCellByIDInNotebookPanel(notebookPanel, codeCellID);
    return cell === null || cell === void 0 ? void 0 : cell.model.sharedModel.source;
};
const getCellIndexByID = (notebookTracker, cellID) => {
    const notebookPanel = notebookTracker.currentWidget;
    return getCellIndexByIDInNotebookPanel(notebookPanel, cellID);
};
const getCellIndexByIDInNotebookPanel = (notebookPanel, cellID) => {
    var _a;
    const cellList = (_a = notebookPanel === null || notebookPanel === void 0 ? void 0 : notebookPanel.model) === null || _a === void 0 ? void 0 : _a.cells;
    if (cellList === undefined) {
        return undefined;
    }
    // In order to get the cell index, we need to iterate over the cells and call the `get` method
    // to see the cells in order. Otherwise, the cells are returned in a random order.
    for (let i = 0; i < cellList.length; i++) {
        const cellModel = cellList.get(i);
        if (cellModel.id == cellID) {
            return i;
        }
    }
    return undefined;
};
const setActiveCellByID = (notebookTracker, cellID) => {
    const notebookPanel = notebookTracker.currentWidget;
    setActiveCellByIDInNotebookPanel(notebookPanel, cellID);
};
const setActiveCellByIDInNotebookPanel = (notebookPanel, cellID) => {
    const cellIndex = getCellIndexByIDInNotebookPanel(notebookPanel, cellID);
    if (cellIndex !== undefined && notebookPanel !== null) {
        notebookPanel.content.activeCellIndex = cellIndex;
    }
};
const writeCodeToCellByID = (notebookTracker, code, codeCellID) => {
    const notebookPanel = notebookTracker.currentWidget;
    writeCodeToCellByIDInNotebookPanel(notebookPanel, code, codeCellID);
};
const writeCodeToCellByIDInNotebookPanel = (notebookPanel, code, codeCellID) => {
    if (code === undefined || codeCellID === undefined) {
        return;
    }
    const codeMirrorValidCode = (0,_strings__WEBPACK_IMPORTED_MODULE_1__.removeMarkdownCodeFormatting)(code);
    const notebook = notebookPanel === null || notebookPanel === void 0 ? void 0 : notebookPanel.content;
    const cell = notebook === null || notebook === void 0 ? void 0 : notebook.widgets.find(cell => cell.model.id === codeCellID);
    if (cell) {
        cell.model.sharedModel.source = codeMirrorValidCode;
    }
};
const getAIOptimizedCells = (notebookTracker) => {
    const notebookPanel = notebookTracker.currentWidget;
    return getAIOptimizedCellsInNotebookPanel(notebookPanel);
};
const getAIOptimizedCellsInNotebookPanel = (notebookPanel) => {
    var _a;
    const cellList = (_a = notebookPanel === null || notebookPanel === void 0 ? void 0 : notebookPanel.model) === null || _a === void 0 ? void 0 : _a.cells;
    if (cellList == undefined || cellList == null) {
        return [];
    }
    // In order to get the cell index, we need to iterate over the cells and call the `get` method
    // to see the cells in order. Otherwise, the cells are returned in a random order.
    const cells = [];
    for (let i = 0; i < cellList.length; i++) {
        const cellModel = cellList.get(i);
        const cell = {
            id: cellModel.id,
            cell_type: cellModel.type,
            code: cellModel.sharedModel.source
        };
        cells.push(cell);
    }
    return cells;
};
function createCodeCellAtIndexAndActivate(notebookPanel, index) {
    /*
        Create a new code cell at index and make it the active cell.
    */
    const notebook = notebookPanel.content;
    if (notebook === undefined) {
        return;
    }
    if (index > 0) {
        notebook.activeCellIndex = index - 1;
        // insertBelow makes the new cell the active cell
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.NotebookActions.insertBelow(notebook);
    }
    else {
        notebook.activeCellIndex = 0;
        // insertAbove makes the new cell the active cell
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.NotebookActions.insertAbove(notebook);
    }
}
const didCellExecutionError = (cell) => {
    var _a;
    /*
        Check the cell's output for an error.
    */
    const outputs = ((_a = cell === null || cell === void 0 ? void 0 : cell.model.outputs) === null || _a === void 0 ? void 0 : _a.toJSON()) || [];
    return outputs.some(output => output.output_type === "error");
};
const getNotebookName = (notebookTracker) => {
    var _a;
    const notebook = (_a = notebookTracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;
    return (notebook === null || notebook === void 0 ? void 0 : notebook.title.label) || 'Untitled';
};
const highlightCodeCell = (notebookTracker, codeCellID) => {
    var _a;
    /*
        Briefly highlights a code cell, to draw the user's attention to it.
    */
    const notebook = (_a = notebookTracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;
    const cell = notebook === null || notebook === void 0 ? void 0 : notebook.widgets.find(cell => cell.model.id === codeCellID);
    if (cell) {
        const cellElement = cell.node;
        const originalBackground = cellElement.style.background;
        // Add a yellow highlight
        cellElement.style.background = 'var(--purple-400)';
        // Remove highlight after 500ms
        cellElement.style.transition = 'background 0.5s ease';
        setTimeout(() => {
            cellElement.style.background = originalBackground;
        }, 500);
    }
};
const highlightLinesOfCodeInCodeCell = (notebookPanel, codeCellID, startLine, endLine) => {
    /*
        Briefly highlights a range of lines in a code cell, to draw the user's attention to it.

        If no start and end line is provided, then highlight the entire cell.
        
        Args:
            notebookTracker: The notebook tracker.
            codeCellID: The ID of the code cell.
            startLine: The 0-indexed start line number to highlight.
            endLine: The 0-indexed end line number to highlight (inclusive).
    */
    // Get the cell with the given ID
    const cell = getCellByIDInNotebookPanel(notebookPanel, codeCellID);
    if (!cell) {
        return;
    }
    // Get the cell's editor
    const editor = cell.editor;
    if (!editor) {
        return;
    }
    // We expect the line numbers to be 0-indexed. To be safe, if the line numbers are out of bounds, we clamp them.
    const lines = editor.model.sharedModel.source.split('\n');
    const targetStartLine = startLine ? Math.min(Math.max(startLine, 0), lines.length - 1) : 0;
    const targetEndLine = endLine ? Math.min(Math.max(endLine, 0), lines.length - 1) : lines.length - 1;
    // Find the line elements in the DOM
    const cmEditor = cell.node.querySelector('.jp-Editor');
    if (!cmEditor) {
        return;
    }
    // Find all line elements
    const lineElements = cmEditor.querySelectorAll('.cm-line');
    const elementsToHighlight = [];
    const originalBackgrounds = [];
    // Collect all line elements in the range
    for (let i = targetStartLine; i <= targetEndLine; i++) {
        if (i < lineElements.length) {
            const lineElement = lineElements[i];
            if (lineElement) {
                elementsToHighlight.push(lineElement);
                originalBackgrounds.push(lineElement.style.background);
            }
        }
    }
    // Highlight all lines in the range
    elementsToHighlight.forEach(lineElement => {
        lineElement.style.background = 'var(--purple-400)';
        lineElement.style.transition = 'background 0.5s ease';
    });
    // Reset the background colors after a delay
    setTimeout(() => {
        elementsToHighlight.forEach((lineElement, index) => {
            lineElement.style.background = originalBackgrounds[index] || '';
        });
    }, 2000);
};
const scrollToAndHighlightCell = (notebookPanel, cellID, startLine, endLine, position = 'center') => {
    if (notebookPanel === null) {
        return;
    }
    // Scroll to the cell
    scrollToCell(notebookPanel, cellID, startLine, position);
    // Wait for the scroll animation to complete before highlighting the lines
    // The default smooth scroll takes about 300-500ms to complete
    setTimeout(() => {
        if (startLine !== undefined) {
            // If no end line was provided, then we just highlight the single line 
            endLine = endLine || startLine;
            highlightLinesOfCodeInCodeCell(notebookPanel, cellID, startLine, endLine);
        }
        else {
            // If no start line was provided, then we just highlight the entire cell
            highlightLinesOfCodeInCodeCell(notebookPanel, cellID, undefined, undefined);
        }
    }, 500);
};
const scrollToCell = (notebookPanel, cellID, startLine, position = 'center') => {
    // Get the cell
    const cell = getCellByIDInNotebookPanel(notebookPanel, cellID);
    if (!cell || notebookPanel === null) {
        return;
    }
    // If line numbers are provided, figure out what position to scroll to 
    // based on the start line's position in the cell
    const code = getCellCodeByIDInNotebookPanel(notebookPanel, cellID);
    startLine = startLine || 0;
    const relativeLinePosition = startLine / ((code === null || code === void 0 ? void 0 : code.split('\n').length) || 1);
    // These positions must be of type BaseScrollToAlignment defined in @jupyterlab/ui-components
    position = relativeLinePosition < 0.5 ? 'start' : 'end';
    // If the cell is not the active cell, the scrolling does not work. 
    // It scrolls to the cell and then flashes back to the active cell.
    setActiveCellByIDInNotebookPanel(notebookPanel, cellID);
    // Use the new JupyterLab scrollToCell method instead of DOM node scrollIntoView
    void notebookPanel.content.scrollToCell(cell, position);
};


/***/ }),

/***/ "./lib/utils/scroll.js":
/*!*****************************!*\
  !*** ./lib/utils/scroll.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   scrollToDiv: () => (/* binding */ scrollToDiv)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
// Helper function to scroll to div
const scrollToDiv = (div) => {
    setTimeout(() => {
        const divContainer = div.current;
        if (divContainer) {
            divContainer.scrollTo({
                top: divContainer.scrollHeight,
                behavior: 'smooth'
            });
        }
    }, 100);
};


/***/ }),

/***/ "./lib/utils/scrollMask.js":
/*!*********************************!*\
  !*** ./lib/utils/scrollMask.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   initScrollMask: () => (/* binding */ initScrollMask),
/* harmony export */   updateScrollMask: () => (/* binding */ updateScrollMask)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
/**
 * Updates the mask for a scrollable container based on its scroll position and container width
 * @param container - The scrollable container element
 */
const updateScrollMask = (container) => {
    if (!container)
        return;
    // Get the container and its parent's width
    const scrollLeft = container.scrollLeft;
    const scrollWidth = container.scrollWidth;
    const clientWidth = container.clientWidth;
    const isScrollable = scrollWidth > clientWidth;
    // Get the parent container which has the maximum width set
    const parentContainer = container.closest('.suggestions-container');
    const parentWidth = (parentContainer === null || parentContainer === void 0 ? void 0 : parentContainer.getBoundingClientRect().width) || 0;
    // Check if we're at max-width (600px) where we should hide the mask
    const isAtMaxWidth = parentWidth >= 600 && parentWidth <= 601; // Small buffer for rounding errors
    // If at max width or not scrollable, no need for any mask
    if (isAtMaxWidth || !isScrollable) {
        container.style.maskImage = 'none';
        container.style.webkitMaskImage = 'none';
        return;
    }
    // Determine mask type based on scroll position
    const scrollEnd = scrollWidth - clientWidth;
    const leftEdgeVisible = scrollLeft <= 5; // Add small buffer for precision issues
    const rightEdgeVisible = scrollLeft >= scrollEnd - 5; // Add small buffer for precision issues
    let maskImage = '';
    if (leftEdgeVisible) {
        // Only right mask when at left edge
        maskImage = 'linear-gradient(to right, black 85%, transparent 100%)';
    }
    else if (rightEdgeVisible) {
        // Only left mask when at right edge
        maskImage = 'linear-gradient(to left, black 85%, transparent 100%)';
    }
    else {
        // Both masks when in the middle
        maskImage = 'linear-gradient(to right, transparent 0%, black 15%, black 85%, transparent 100%)';
    }
    container.style.maskImage = maskImage;
    container.style.webkitMaskImage = maskImage;
};
/**
 * Initializes the scroll mask with a delay to ensure content has rendered
 * @param container - The scrollable container element
 * @param delay - Delay in milliseconds before updating the mask
 */
const initScrollMask = (container, delay = 100) => {
    if (!container)
        return;
    // Reset scroll position to start
    container.scrollLeft = 0;
    // Apply mask after a short delay to ensure content has rendered
    setTimeout(() => {
        updateScrollMask(container);
    }, delay);
};


/***/ }),

/***/ "./lib/utils/sleep.js":
/*!****************************!*\
  !*** ./lib/utils/sleep.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sleep: () => (/* binding */ sleep)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
/**
 * Pauses the execution of the program for a specified number of milliseconds.
 *
 * @param ms - The number of milliseconds to pause.
 */
function sleep(ms) {
    return new Promise((resolve) => setTimeout(resolve, ms));
}


/***/ }),

/***/ "./lib/utils/strings.js":
/*!******************************!*\
  !*** ./lib/utils/strings.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PYTHON_CODE_BLOCK_END_WITHOUT_NEW_LINE: () => (/* binding */ PYTHON_CODE_BLOCK_END_WITHOUT_NEW_LINE),
/* harmony export */   PYTHON_CODE_BLOCK_END_WITH_NEW_LINE: () => (/* binding */ PYTHON_CODE_BLOCK_END_WITH_NEW_LINE),
/* harmony export */   PYTHON_CODE_BLOCK_START_WITHOUT_NEW_LINE: () => (/* binding */ PYTHON_CODE_BLOCK_START_WITHOUT_NEW_LINE),
/* harmony export */   PYTHON_CODE_BLOCK_START_WITH_NEW_LINE: () => (/* binding */ PYTHON_CODE_BLOCK_START_WITH_NEW_LINE),
/* harmony export */   addMarkdownCodeFormatting: () => (/* binding */ addMarkdownCodeFormatting),
/* harmony export */   getCodeBlockFromMessage: () => (/* binding */ getCodeBlockFromMessage),
/* harmony export */   getContentStringFromMessage: () => (/* binding */ getContentStringFromMessage),
/* harmony export */   removeMarkdownCodeFormatting: () => (/* binding */ removeMarkdownCodeFormatting),
/* harmony export */   splitStringWithCodeBlocks: () => (/* binding */ splitStringWithCodeBlocks),
/* harmony export */   stripAnsiCodes: () => (/* binding */ stripAnsiCodes)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
const PYTHON_CODE_BLOCK_START_WITH_NEW_LINE = '```python\n';
const PYTHON_CODE_BLOCK_START_WITHOUT_NEW_LINE = '```python';
const PYTHON_CODE_BLOCK_END_WITH_NEW_LINE = '\n```';
const PYTHON_CODE_BLOCK_END_WITHOUT_NEW_LINE = '```';
/*
    Given a message from the OpenAI API, returns the content as a string.
    If the content is not a string, returns undefined.
*/
const getContentStringFromMessage = (message) => {
    // TODO: We can't assume this is a string. We need to handle the other
    // return options
    if (message.role === 'user' || message.role === 'assistant') {
        // Don't convert the message to a string if the content is undefined or null
        // so we can continue to use type checking
        if (message.content === undefined || message.content === null) {
            return undefined;
        }
        return message.content;
    }
    return undefined;
};
/*
    Given a string like "Hello ```python print('Hello, world!')```",
    returns ["Hello", "```python print('Hello, world!')```"]

    This is useful for taking an AI generated message and displaying the code in
    code blocks and the rest of the message in plain text.
*/
const splitStringWithCodeBlocks = (message) => {
    const messageContent = getContentStringFromMessage(message);
    if (!messageContent) {
        return [];
    }
    const parts = messageContent.split(/(```[\s\S]*?```)/);
    // Remove empty strings caused by consecutive delimiters, if any
    return parts.filter(part => part.trim() !== "");
};
/*
    Given a string like "Hello ```python print('Hello, world!')```",
    returns "```python print('Hello, world!')```"
*/
const getCodeBlockFromMessage = (message) => {
    const parts = splitStringWithCodeBlocks(message);
    return parts.find(part => part.startsWith('```'));
};
/*
    To display code in markdown, we need to take input values like this:

    ```python x + 1```

    And turn them into this:

    ```python
    x + 1
    ```

    Sometimes, we also want to trim the code to remove any leading or trailing whitespace. For example,
    when we're displaying the code in the chat history this is useful. Othertimes we don't want to trim.
    For example, when we're displaying the code in the active cell, we want to keep the users's whitespace.
    This is important for showing diffs. If the code cell contains no code, the first line will be marked as
    removed in the code diff. To ensure the diff lines up with the code, we need to leave this whitespace line.
*/
const addMarkdownCodeFormatting = (code, trim) => {
    var _a;
    if (code === undefined) {
        return undefined;
    }
    let codeWithoutBackticks = code;
    // If the code already has the code formatting backticks, remove them 
    // so we can add them back in the correct format
    if (code.split(PYTHON_CODE_BLOCK_START_WITHOUT_NEW_LINE).length > 1) {
        const parts = code.split(PYTHON_CODE_BLOCK_START_WITHOUT_NEW_LINE);
        if (parts.length > 1 && parts[1] != null) {
            const endParts = parts[1].split(PYTHON_CODE_BLOCK_END_WITHOUT_NEW_LINE);
            codeWithoutBackticks = (_a = endParts[0]) !== null && _a !== void 0 ? _a : '';
        }
    }
    else {
        codeWithoutBackticks = code;
    }
    if (trim) {
        codeWithoutBackticks = codeWithoutBackticks.trim();
    }
    // Note: We add a space after the code because for some unknown reason, the markdown 
    // renderer is cutting off the last character in the code block.
    return `${PYTHON_CODE_BLOCK_START_WITH_NEW_LINE}${codeWithoutBackticks} ${PYTHON_CODE_BLOCK_END_WITH_NEW_LINE}`;
};
/*
    To write code in a Jupyter Code Cell, we need to take inputs like this:

    ```python
    x + 1
    ```

    And turn them into this:

    x + 1

    Jupyter does not need the backticks.
*/
const removeMarkdownCodeFormatting = (code) => {
    if (code.split(PYTHON_CODE_BLOCK_START_WITH_NEW_LINE).length > 1) {
        const parts = code.split(PYTHON_CODE_BLOCK_START_WITH_NEW_LINE)[1].split(PYTHON_CODE_BLOCK_END_WITH_NEW_LINE)[0];
        return parts;
    }
    return code;
};
/*
    Remove ANSI escape sequences from text.
    For example, this is useful for removing the escape
    codes from the error traceback.
*/
const stripAnsiCodes = (text) => {
    // eslint-disable-next-line no-control-regex
    const ansiEscape = /\x1B(?:[@-Z\\-_]|\[[0-?]*[ -/]*[@-~])/g;
    return text.replace(ansiEscape, '');
};


/***/ }),

/***/ "./lib/utils/stripe.js":
/*!*****************************!*\
  !*** ./lib/utils/stripe.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STRIPE_PAYMENT_LINK: () => (/* binding */ STRIPE_PAYMENT_LINK)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
const STRIPE_PAYMENT_LINK = "https://jl76z192i0.execute-api.us-east-1.amazonaws.com/Prod/create_checkout_session/";


/***/ }),

/***/ "./lib/utils/user.js":
/*!***************************!*\
  !*** ./lib/utils/user.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getOperatingSystem: () => (/* binding */ getOperatingSystem),
/* harmony export */   isChromeBasedBrowser: () => (/* binding */ isChromeBasedBrowser),
/* harmony export */   isElectronBasedFrontend: () => (/* binding */ isElectronBasedFrontend)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
const getOperatingSystem = () => {
    if (navigator.userAgent.includes('Macintosh')) {
        return 'mac';
    }
    else {
        return 'windows';
    }
};
const isChromeBasedBrowser = () => {
    return /chrome/i.test(navigator.userAgent) && !/edge|edg/i.test(navigator.userAgent);
};
const isElectronBasedFrontend = () => {
    /*
    Checks if the user is using an Electron-based browser.
    This tells us that they are using Mito Desktop or JupyterLab Desktop.
    */
    const userAgent = navigator.userAgent.toLowerCase();
    return userAgent.includes('electron');
};


/***/ }),

/***/ "./lib/utils/userSignupEvents.js":
/*!***************************************!*\
  !*** ./lib/utils/userSignupEvents.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   userSignupEvents: () => (/* binding */ userSignupEvents)
/* harmony export */ });
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/**
 * Event emitter for user signup events
 */
class UserSignupEventEmitter {
    constructor() {
        this._signupSuccess = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
    }
    /**
     * Signal emitted when a user successfully signs up
     */
    get signupSuccess() {
        return this._signupSuccess;
    }
    /**
     * Emit a signup success event
     */
    emitSignupSuccess() {
        this._signupSuccess.emit();
    }
}
// Create a singleton instance
const userSignupEvents = new UserSignupEventEmitter();


/***/ }),

/***/ "./lib/utils/userSignupState.js":
/*!**************************************!*\
  !*** ./lib/utils/userSignupState.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkUserSignupState: () => (/* binding */ checkUserSignupState)
/* harmony export */ });
/* harmony import */ var _restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../restAPI/RestAPI */ "./lib/restAPI/RestAPI.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/**
 * Determines if a user should be considered "signed up" based on:
 * 1. Having an email address, OR
 * 2. Having existing chat history threads
 *
 * This ensures consistent behavior across all components that need to check
 * if a user should have access to Mito AI features.
 */
const checkUserSignupState = async () => {
    try {
        // Check if user has an email address
        const userEmail = await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_0__.getUserKey)('user_email');
        const hasEmail = userEmail !== "" && userEmail !== undefined;
        if (hasEmail) {
            return {
                isSignedUp: true,
                hasEmail: true,
                hasChatHistory: false
            };
        }
        // Check for existing chat history threads
        const chatThreads = await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_0__.getChatHistoryThreads)();
        const hasThreads = chatThreads.length > 0;
        if (!hasThreads) {
            return {
                isSignedUp: false,
                hasEmail: false,
                hasChatHistory: false
            };
        }
        // Verify the first thread has actual content (not just default empty thread)
        const firstThread = await (0,_restAPI_RestAPI__WEBPACK_IMPORTED_MODULE_0__.getChatHistoryThread)(chatThreads[0].thread_id);
        const hasActualChatHistory = firstThread.display_history.length > 0;
        return {
            isSignedUp: hasActualChatHistory,
            hasEmail: false,
            hasChatHistory: hasActualChatHistory
        };
    }
    catch (error) {
        console.error('Failed to check user signup state:', error);
        return {
            isSignedUp: false,
            hasEmail: false,
            hasChatHistory: false
        };
    }
};


/***/ }),

/***/ "./lib/utils/version_check.js":
/*!************************************!*\
  !*** ./lib/utils/version_check.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkForUpdates: () => (/* binding */ checkForUpdates),
/* harmony export */   showVersionOutdatedNotification: () => (/* binding */ showVersionOutdatedNotification)
/* harmony export */ });
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var semver__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! semver */ "webpack/sharing/consume/default/semver/semver");
/* harmony import */ var semver__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(semver__WEBPACK_IMPORTED_MODULE_2__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */



const VERSION_CHECK_TIMEOUT = 5000;
const VERSION_CHECK_ENDPOINT = 'mito-ai/version-check';
const DOCS_UPDATE_URL = 'https://docs.trymito.io/getting-started/installing-mito';
const RELEASE_NOTES_URL = 'https://docs.trymito.io/misc/release-notes';
/**
 * Display a notification when Mito AI is outdated
 */
function showVersionOutdatedNotification(currentVersion, latestVersion) {
    _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Notification.emit(`Your Mito AI version (${currentVersion}) is outdated. Latest version is ${latestVersion}.`, 'warning', {
        autoClose: false,
        actions: [
            {
                label: 'Learn how to update',
                callback: () => {
                    window.open(DOCS_UPDATE_URL, '_blank');
                }
            },
            {
                label: 'What\'s new?',
                callback: () => {
                    window.open(RELEASE_NOTES_URL, '_blank');
                }
            }
        ]
    });
}
/**
 * Check if there's a newer version of Mito AI available
 * @param serverSettings The server settings to use for the request
 * @returns A promise that resolves when the check is complete
 */
async function checkForUpdates(serverSettings) {
    try {
        // Build the URL
        const baseUrl = serverSettings.baseUrl;
        const url = `${baseUrl}${VERSION_CHECK_ENDPOINT}`;
        // Set timeout to 5 seconds to prevent hanging requests
        const controller = new AbortController();
        const timeoutId = setTimeout(() => controller.abort(), VERSION_CHECK_TIMEOUT);
        try {
            // Make the request
            const response = await _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, {
                method: 'GET',
                signal: controller.signal
            }, serverSettings);
            if (!response.ok) {
                console.warn('Failed to check for Mito AI updates:', response.statusText);
                return;
            }
            const data = await response.json();
            const { current_version, latest_version } = data;
            if (!current_version || !latest_version) {
                // If versions are null/undefined/empty, the server couldn't get it from PyPI
                // In this case, don't show any notification as requested
                return;
            }
            // Use semver to compare versions - first validate both versions
            const validCurrentVersion = semver__WEBPACK_IMPORTED_MODULE_2__.valid(current_version);
            const validLatestVersion = semver__WEBPACK_IMPORTED_MODULE_2__.valid(latest_version);
            if (!validCurrentVersion || !validLatestVersion) {
                console.warn('Invalid semver version format:', { current_version, latest_version });
                return;
            }
            // Now compare the valid versions
            if (semver__WEBPACK_IMPORTED_MODULE_2__.lt(validCurrentVersion, validLatestVersion)) {
                // Show a notification to the user
                showVersionOutdatedNotification(current_version, latest_version);
            }
        }
        finally {
            // Ensure timeout is cleared even if there's an error
            clearTimeout(timeoutId);
        }
    }
    catch (error) {
        // In case of any error, just log it and don't show any notification
        if (error instanceof DOMException && error.name === 'AbortError') {
            console.warn('Version check request timed out');
        }
        else {
            console.warn('Error checking for Mito AI updates:', error);
        }
    }
}


/***/ }),

/***/ "./lib/utils/waitForNotebookReady.js":
/*!*******************************************!*\
  !*** ./lib/utils/waitForNotebookReady.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   waitForNotebookReady: () => (/* binding */ waitForNotebookReady)
/* harmony export */ });
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */
/*
    Wait for the notebook to be ready and attached.
    This is used to wait for the notebook to be ready before sending the first message.
*/
const waitForNotebookReady = async (notebookTracker) => {
    // This is not critical and we never want it to break the app.
    try {
        // First, wait for a notebook to exist with retry pattern
        let notebook = notebookTracker.currentWidget;
        let attempts = 0;
        const maxAttempts = 30; // Wait up to 30 seconds (30 attempts * 1 second each)
        while (!notebook && attempts < maxAttempts) {
            console.log(`🔍 Waiting for notebook to appear (attempt ${attempts + 1}/${maxAttempts})...`);
            await new Promise(resolve => setTimeout(resolve, 1000)); // Wait 1 second
            notebook = notebookTracker.currentWidget;
            attempts++;
        }
        if (!notebook) {
            throw new Error(`No active notebook found after ${maxAttempts} seconds`);
        }
        console.log('🔍 Notebook found, waiting for it to be ready...');
        // Wait for notebook to be ready and attached
        await notebook.context.ready;
        // Wait for attachment
        if (!notebook.content.isAttached) {
            await new Promise(resolve => {
                const checkAttached = () => {
                    if (notebook.content.isAttached) {
                        resolve();
                    }
                    else {
                        setTimeout(checkAttached, 100);
                    }
                };
                checkAttached();
            });
        }
        // Wait for all cells to be created and ready
        await new Promise(resolve => {
            const checkCellsReady = () => {
                const cells = notebook.content.widgets;
                // In large notebooks, not all of the cells are attatched I think. 
                // So instead we just wait for any cell to be ready and then give it 
                // another 500ms to be ready.
                const anyCellReady = cells.some(cell => cell.isAttached && cell.model);
                if (anyCellReady && cells.length > 0) {
                    resolve();
                }
                else {
                    setTimeout(checkCellsReady, 100);
                }
            };
            checkCellsReady();
        });
        // Small buffer for final initialization
        await new Promise(resolve => setTimeout(resolve, 500));
    }
    catch (error) {
        console.error('Error waiting for notebook to be ready:', error);
        throw error;
    }
};


/***/ }),

/***/ "./lib/websockets/BaseWebsocketClient.js":
/*!***********************************************!*\
  !*** ./lib/websockets/BaseWebsocketClient.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseWebsocketClient: () => (/* binding */ BaseWebsocketClient),
/* harmony export */   MitoAIError: () => (/* binding */ MitoAIError)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_3__);
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */




/**
 * Error thrown by Mito AI completion
 */
class MitoAIError extends Error {
    constructor(message, options = {}) {
        super(message, { cause: options.cause });
        this.name = 'MitoAIError';
        this.hint = options.hint;
        if (options.cause && typeof options.cause === 'object' && 'stack' in options.cause) {
            this.stack = `${this.stack}\nCaused by: ${options.cause.stack}`;
        }
    }
}
/**
 * Base Mito AI websocket client
 *
 * It provides the common functionality for all websocket clients.
 */
class BaseWebsocketClient {
    /**
     * Create a new websocket client.
     */
    constructor(options = {}) {
        var _a;
        /**
         * Maximum number of reconnection attempts
         */
        this._maxReconnectAttempts = 5;
        /**
         * Current reconnection attempt
         */
        this._reconnectAttempt = 0;
        /** Whether the websocket client is disposed. */
        this._isDisposed = false;
        /** Messages stream */
        this._messages = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Stream(this);
        /** The WebSocket connection */
        this._socket = null;
        /** Stream for specific messages, if the client supports streaming */
        this._stream = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Stream(this);
        /** Promise delegate that resolves when the connection is ready */
        this._ready = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.PromiseDelegate();
        /** Dictionary mapping message IDs to Promise resolvers. */
        this._pendingRepliesMap = new Map();
        /** Connection status stream */
        this._connectionStatus = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Stream(this);
        /** Flag to track if initialization is in progress to prevent multiple concurrent initializations */
        this._initializationInProgress = false;
        this.serverSettings = (_a = options.serverSettings) !== null && _a !== void 0 ? _a : _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
        this._ready = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.PromiseDelegate();
    }
    /**
     * Whether the websocket client is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Message stream.
     */
    get messages() {
        return this._messages;
    }
    /**
     * Stream for specific messages, if the client supports streaming.
     */
    get stream() {
        return this._stream;
    }
    /**
     * Promise that resolves when the websocket connection is ready.
     */
    get ready() {
        return this._ready.promise;
    }
    /**
     * Stream of connection status events
     */
    get connectionStatus() {
        return this._connectionStatus;
    }
    /**
     * Check if websocket is currently connected
     */
    get isConnected() {
        return this._socket !== null && this._socket.readyState === WebSocket.OPEN;
    }
    /**
     * Dispose the websocket client.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        // Clean up socket.
        const socket = this._socket;
        if (socket) {
            this._socket = null;
            socket.onopen = () => undefined;
            socket.onerror = () => undefined;
            socket.onmessage = () => undefined;
            socket.onclose = () => undefined;
            socket.close();
        }
        this._stream.stop();
        for (const resolver of this._pendingRepliesMap.values()) {
            resolver.reject(new Error('Websocket client disposed'));
        }
        this._pendingRepliesMap.clear();
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal.clearData(this);
    }
    /**
     * Initializes the WebSocket connection to the backend. This
     * must be awaited before calling any other method.
     */
    async initialize() {
        try {
            await this._initialize();
        }
        catch (error) {
            console.error(`Failed to initialize WebSocket for ${this.SERVICE_URL}:`, error);
            throw error;
        }
    }
    /**
     * Sends a message across the WebSocket. Promise resolves to the response
     * when the server sends the reply back.
     * Automatically ensures the websocket is initialized before sending.
     */
    sendMessage(message) {
        // Create a Promise for the eventual result
        return new Promise((resolve, reject) => {
            // First check if we need to reconnect
            void Promise.resolve().then(async () => {
                try {
                    // If the socket is not connected, try to reconnect first
                    if (this._socket === null || this._socket.readyState !== WebSocket.OPEN) {
                        try {
                            console.log('Connection is closed, attempting to reconnect before sending message...');
                            // Reset the ready promise since we're going to reconnect
                            this._ready = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.PromiseDelegate();
                            await this.reconnect();
                            console.log('Successfully reconnected, now sending message');
                        }
                        catch (reconnectError) {
                            console.error('Failed to reconnect websocket:', reconnectError);
                            // If the error is a MitoAIError, propagate it directly to preserve the helpful message
                            if (reconnectError instanceof MitoAIError) {
                                reject(reconnectError);
                            }
                            else {
                                reject(new Error('Failed to reconnect websocket before sending message'));
                            }
                            return;
                        }
                    }
                    if (this._socket && this._socket.readyState === WebSocket.OPEN) {
                        const pendingReply = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.PromiseDelegate();
                        this._pendingRepliesMap.set(this.getMessageId(message), pendingReply);
                        pendingReply.promise.then(resolve).catch(reject);
                        // Send the message
                        this._socket.send(JSON.stringify(message));
                    }
                    else {
                        reject(new Error('Websocket not initialized'));
                    }
                }
                catch (error) {
                    reject(error);
                }
            });
        });
    }
    /**
     * Handle websocket connection opened.
     */
    _onOpen(_) {
        console.log(`Mito AI ${this.SERVICE_URL} websocket connected`);
        this._ready.resolve();
        this._connectionStatus.emit('connected');
    }
    /**
     * Handle websocket connection closed.
     */
    _onClose(_e) {
        this._ready.reject(new Error(`${this.SERVICE_URL} websocket disconnected`));
        console.error(`${this.SERVICE_URL} websocket disconnected`);
        this._connectionStatus.emit('disconnected');
    }
    /**
     * Initialize the websocket connection.
     */
    async _initialize() {
        if (this.isDisposed) {
            return;
        }
        // If we already have a pending initialization, return that
        if (this._initializationInProgress) {
            return this._ready.promise;
        }
        // Mark that initialization is in progress to prevent multiple concurrent initializations
        this._initializationInProgress = true;
        // Always create a new ready promise to ensure we're starting fresh
        this._ready = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.PromiseDelegate();
        // Clean up any existing socket first
        if (this._socket) {
            const oldSocket = this._socket;
            this._socket = null;
            // Clear handlers before closing to prevent triggering unintended events
            oldSocket.onopen = () => undefined;
            oldSocket.onerror = () => undefined;
            oldSocket.onmessage = () => undefined;
            oldSocket.onclose = () => undefined;
            // Close the socket
            oldSocket.close();
        }
        console.log(`Creating a new websocket connection for ${this.SERVICE_URL}...`);
        const { appendToken, token, WebSocket, wsUrl } = this.serverSettings;
        let url = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.URLExt.join(wsUrl, this.SERVICE_URL);
        if (appendToken && token !== '') {
            url += `?token=${encodeURIComponent(token)}`;
        }
        // Check if the service is available before attempting to connect
        try {
            const answer = await fetch(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.URLExt.join(this.serverSettings.baseUrl, `${this.SERVICE_URL}?check_availability=true`), {
                method: 'GET',
                credentials: 'include',
                headers: {
                    'Authorization': `token ${token}`
                }
            });
            if (!answer.ok) {
                const message = answer.status == 404
                    ? 'Mito AI extension not enabled.'
                    : `Mito AI service not available; error ${answer.status} ${answer.statusText}`;
                const hint = answer.status == 404
                    ? 'You can enable it by running in a cell `!jupyter server extension enable mito_ai`. Then restart the application.'
                    : undefined;
                this._messages.emit({
                    type: 'error',
                    error_type: 'HTTPError',
                    title: message,
                    hint
                });
                const error = new MitoAIError(message, {
                    cause: answer,
                    hint
                });
                this._ready.reject(error);
                this._initializationInProgress = false;
                return this._ready.promise;
            }
            const socket = (this._socket = new WebSocket(url));
            // Set a timeout to detect stalled connections
            const connectionTimeout = setTimeout(() => {
                if (socket.readyState !== WebSocket.OPEN && socket === this._socket) {
                    console.error('WebSocket connection timed out');
                    socket.close();
                }
            }, 10000); // 10 second timeout
            socket.onopen = e => {
                clearTimeout(connectionTimeout);
                this._onOpen(e);
                this._initializationInProgress = false;
            };
            socket.onclose = e => {
                clearTimeout(connectionTimeout);
                this._onClose(e);
                this._initializationInProgress = false;
            };
            socket.onerror = e => {
                clearTimeout(connectionTimeout);
                this._ready.reject(e);
                this._initializationInProgress = false;
            };
            socket.onmessage = msg => {
                if (msg.data) {
                    this._onMessage(JSON.parse(msg.data));
                }
            };
            return this._ready.promise;
        }
        catch (error) {
            this._initializationInProgress = false;
            this._ready.reject(error);
            throw error;
        }
    }
    /**
     * Attempt to reconnect the websocket with exponential backoff.
     * @param forceReset - If true (default), resets the reconnection attempt counter to 0,
     * effectively starting a fresh sequence of reconnection attempts. When false, maintains
     * the current attempt count, which is used during recursive reconnection attempts within the method.
     * @returns Promise that resolves when reconnection is successful or rejects after max attempts
     * @throws Error if the client is disposed or max reconnection attempts are exceeded
     */
    async reconnect(forceReset = true) {
        if (this._isDisposed) {
            throw new Error('Client is disposed');
        }
        // Reset _reconnectAttempt if this is a manual reconnect
        if (forceReset) {
            this._reconnectAttempt = 0;
        }
        if (this._reconnectAttempt >= this._maxReconnectAttempts) {
            this._reconnectAttempt = 0; // Reset for future attempts
            throw new MitoAIError(`Failed to reconnect after ${this._maxReconnectAttempts} attempts`);
        }
        // Calculate delay using exponential backoff
        // First attempt is immediate, then 1s, 2s, 4s, 8s
        const delay = this._reconnectAttempt === 0 ? 0 : Math.pow(2, this._reconnectAttempt - 1) * 1000;
        if (delay > 0) {
            console.log(`Attempting to reconnect in ${delay / 1000}s (attempt ${this._reconnectAttempt + 1}/${this._maxReconnectAttempts})...`);
            await new Promise(resolve => setTimeout(resolve, delay));
        }
        this._reconnectAttempt++;
        try {
            // Reinitialize connection
            await this._initialize();
            // Reset reconnect attempt counter on success
            this._reconnectAttempt = 0;
            return;
        }
        catch (error) {
            console.error(`Reconnection attempt ${this._reconnectAttempt} failed:`, error);
            // If the error is a MitoAIError (like the extension not being enabled),
            // propagate it immediately instead of retrying
            if (error instanceof MitoAIError) {
                this._reconnectAttempt = 0; // Reset for future attempts
                throw error;
            }
            // If we haven't reached max attempts, try again
            if (this._reconnectAttempt < this._maxReconnectAttempts) {
                return this.reconnect(false);
            }
            else {
                this._reconnectAttempt = 0; // Reset for future attempts
                throw new MitoAIError(`Failed to reconnect after ${this._maxReconnectAttempts} attempts`, {
                    cause: error
                });
            }
        }
    }
}


/***/ }),

/***/ "./lib/websockets/appDeploy/appDeployWebsocketClient.js":
/*!**************************************************************!*\
  !*** ./lib/websockets/appDeploy/appDeployWebsocketClient.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppDeployWebsocketClient: () => (/* binding */ AppDeployWebsocketClient)
/* harmony export */ });
/* harmony import */ var _BaseWebsocketClient__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../BaseWebsocketClient */ "./lib/websockets/BaseWebsocketClient.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/**
 * Mito AI app builder client
 *
 * It communicates with the backend over a WebSocket for app building functionality.
 */
class AppDeployWebsocketClient extends _BaseWebsocketClient__WEBPACK_IMPORTED_MODULE_0__.BaseWebsocketClient {
    /**
     * Create a new app builder client.
     */
    constructor(options = {}) {
        super(options);
        /**
         * The service URL for the websocket endpoint.
         */
        this.SERVICE_URL = 'mito-ai/app-deploy';
    }
    /**
     * App builder messages stream.
     */
    get messages() {
        return this._messages;
    }
    /**
     * Stream of connection status events
     */
    get connectionStatus() {
        return this._connectionStatus;
    }
    /**
     * Extract the message ID from a request message.
     */
    getMessageId(message) {
        return message.message_id;
    }
    /**
     * Process a message received from the websocket.
     */
    _onMessage(message) {
        /**
         * Emit unconditionally the message to interested parties.
         */
        this._messages.emit(message);
        /**
         * Dispatch app builder messages
         */
        const resolver = this._pendingRepliesMap.get(message.parent_id);
        if (resolver) {
            resolver.resolve(message);
            this._pendingRepliesMap.delete(message.parent_id);
        }
        else {
            // For streaming responses, emit the error through the stream
            // We need to do this here because errors do not come in as "chunk" messages
            // they come in as "reply" messages.
            if (message.error) {
                this._stream.emit({
                    type: 'chunk',
                    chunk: { content: message.error.hint || message.error.title || "An error occurred" },
                    done: true,
                    parent_id: message.parent_id,
                    error: message.error
                });
            }
            // This will get triggered when streaming and there is an error message.
            // However, errors are handled via the emit seen above above.
            console.warn('Unhandled mito ai app builder message', message);
        }
    }
}


/***/ }),

/***/ "./lib/websockets/appManager/appManagerWebsocketClient.js":
/*!****************************************************************!*\
  !*** ./lib/websockets/appManager/appManagerWebsocketClient.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppManagerWebsocketClient: () => (/* binding */ AppManagerWebsocketClient)
/* harmony export */ });
/* harmony import */ var _BaseWebsocketClient__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../BaseWebsocketClient */ "./lib/websockets/BaseWebsocketClient.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/**
 * Mito AI app manager client
 *
 * It communicates with the backend over a WebSocket for app managing functionality.
 */
class AppManagerWebsocketClient extends _BaseWebsocketClient__WEBPACK_IMPORTED_MODULE_0__.BaseWebsocketClient {
    /**
     * Create a new app manager client.
     */
    constructor(options = {}) {
        super(options);
        /**
         * The service URL for the websocket endpoint.
         */
        this.SERVICE_URL = 'mito-ai/app-manager';
    }
    /**
     * App manager messages stream.
     */
    get messages() {
        return this._messages;
    }
    /**
     * Stream of connection status events
     */
    get connectionStatus() {
        return this._connectionStatus;
    }
    /**
     * Get message ID from request (required by BaseWebsocketClient)
     */
    getMessageId(request) {
        return `${request.type}_${Date.now()}_${Math.random().toString(36).substring(7)}`;
    }
    /**
     * Process a message received from the websocket.
     * Routes responses to the appropriate pending requests.
     */
    _onMessage(message) {
        // Emit the message to stream listeners
        this._messages.emit(message);
        // Determine which pending request this message belongs to
        let pendingId = null;
        let pendingReply = null;
        const messageId = message.message_id;
        // First, try to match by message_id
        if (messageId && this._pendingRepliesMap.has(messageId)) {
            pendingId = messageId;
            pendingReply = this._pendingRepliesMap.get(messageId);
        }
        // If no message_id, check if this is a response to a single pending request
        else if (this._pendingRepliesMap.size === 1 && !messageId) {
            const entries = Array.from(this._pendingRepliesMap.entries());
            if (entries.length > 0) {
                const entry = entries[0];
                if (entry) {
                    pendingId = entry[0];
                    pendingReply = entry[1];
                }
            }
        }
        // Guard clause - exit if we couldn't find a matching pending request
        if (!pendingId || !pendingReply) {
            return;
        }
        // Common cleanup and resolution logic
        this._pendingRepliesMap.delete(pendingId);
        if (message.error) {
            pendingReply.reject(new Error(message.error.title || 'Server error'));
        }
        else {
            pendingReply.resolve(message);
        }
    }
}


/***/ }),

/***/ "./lib/websockets/completions/CompletionsWebsocketClient.js":
/*!******************************************************************!*\
  !*** ./lib/websockets/completions/CompletionsWebsocketClient.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CompletionWebsocketClient: () => (/* binding */ CompletionWebsocketClient)
/* harmony export */ });
/* harmony import */ var _BaseWebsocketClient__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../BaseWebsocketClient */ "./lib/websockets/BaseWebsocketClient.js");
/* harmony import */ var _utils_user__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/user */ "./lib/utils/user.js");
/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


/**
 * Mito AI completion client
 *
 * It communicates with the backend over a WebSocket to allow streaming answer.
 */
class CompletionWebsocketClient extends _BaseWebsocketClient__WEBPACK_IMPORTED_MODULE_0__.BaseWebsocketClient {
    /**
     * Create a new completion client.
     */
    constructor(options = {}) {
        super(options);
        /**
         * The service URL for the websocket endpoint.
         */
        this.SERVICE_URL = 'mito-ai/completions';
        this.isElectron = (0,_utils_user__WEBPACK_IMPORTED_MODULE_1__.isElectronBasedFrontend)();
    }
    /**
     * Completion chunk stream.
     */
    get messages() {
        return this._messages;
    }
    /**
     * Completion chunk stream.
     */
    get stream() {
        return this._stream;
    }
    /**
     * Stream of connection status events
     */
    get connectionStatus() {
        return this._connectionStatus;
    }
    /**
     * Extract the message ID from a request message.
     */
    getMessageId(message) {
        return message.message_id;
    }
    /**
     * Process a message received from the websocket.
     */
    _onMessage(message) {
        /**
         * Emit unconditionally the message to interested parties.
         */
        this._messages.emit(message);
        /**
         * Dispatch completion messages
         */
        switch (message.type) {
            case 'chunk': {
                // To see the stream in action, uncomment the following line
                // console.log(`[Mito AI Stream] ${message.done ? 'FINAL' : ''} Chunk:`, message.chunk.content);
                this._stream.emit(message);
                break;
            }
            case 'reply': {
                const resolver = this._pendingRepliesMap.get(message.parent_id);
                if (resolver) {
                    resolver.resolve(message);
                    this._pendingRepliesMap.delete(message.parent_id);
                }
                else {
                    // For streaming responses, emit the error through the stream
                    // We need to do this here because errors do not come in as "chunk" messages
                    // they come in as "reply" messages.
                    if (message.error) {
                        this._stream.emit({
                            type: 'chunk',
                            chunk: { content: message.error.hint || message.error.title || "An error occurred" },
                            done: true,
                            parent_id: message.parent_id,
                            error: message.error
                        });
                    }
                    // This will get triggered when streaming and there is an error message.
                    // However, errors are handled via the emit seen above above.
                    console.warn('Unhandled mito ai completion message', message);
                }
                break;
            }
            // default: /* no-op */
        }
    }
    // Override sendMessage to automatically add environment info
    sendMessage(message) {
        // Add environment info to all messages
        const messageWithEnvironment = {
            ...message,
            environment: {
                isElectron: this.isElectron,
            }
        };
        return super.sendMessage(messageWithEnvironment);
    }
}


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/AgentComponentHeader.css":
/*!******************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/AgentComponentHeader.css ***!
  \******************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.agent-component-header {
    cursor: pointer;
    padding: 10px var(--chat-taskpane-tool-call-horizontal-padding);
    color: var(--jp-ui-font-color2);
    display: flex;
    justify-content: space-between;
    align-items: center;
    border: 1px solid var(--jp-cell-editor-border-color);
    border-radius: var(--chat-taskpane-item-border-radius);
    transition: background-color 0.2s ease, border-color 0.2s ease;
}

.agent-component-header:hover {
    background-color: var(--jp-layout-color3);
}

.agent-component-header.no-border {
    border: none;
}

.agent-component-header.expanded {
    border: none;
    border-radius: 5px 5px 0 0;
    background-color: var(--jp-layout-color2);
}

.agent-component-header.error-fixup {
    border: none;
}

.agent-component-header.error-fixup.expanded {
    background-color: var(--jp-layout-color2);
}

.agent-component-header-content {
    display: flex;
    align-items: center;
    gap: 10px;
    flex: 1;
    min-width: 0;
}

.agent-component-header-content svg {
    flex-shrink: 0;
}

.agent-component-header-expand-icon {
    flex-shrink: 0;
    transition: transform 0.2s ease;
}

.agent-component-header-expand-icon.expanded {
    transform: rotate(90deg);
} `, "",{"version":3,"sources":["webpack://./style/AgentComponentHeader.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,eAAe;IACf,+DAA+D;IAC/D,+BAA+B;IAC/B,aAAa;IACb,8BAA8B;IAC9B,mBAAmB;IACnB,oDAAoD;IACpD,sDAAsD;IACtD,8DAA8D;AAClE;;AAEA;IACI,yCAAyC;AAC7C;;AAEA;IACI,YAAY;AAChB;;AAEA;IACI,YAAY;IACZ,0BAA0B;IAC1B,yCAAyC;AAC7C;;AAEA;IACI,YAAY;AAChB;;AAEA;IACI,yCAAyC;AAC7C;;AAEA;IACI,aAAa;IACb,mBAAmB;IACnB,SAAS;IACT,OAAO;IACP,YAAY;AAChB;;AAEA;IACI,cAAc;AAClB;;AAEA;IACI,cAAc;IACd,+BAA+B;AACnC;;AAEA;IACI,wBAAwB;AAC5B","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.agent-component-header {\n    cursor: pointer;\n    padding: 10px var(--chat-taskpane-tool-call-horizontal-padding);\n    color: var(--jp-ui-font-color2);\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    border: 1px solid var(--jp-cell-editor-border-color);\n    border-radius: var(--chat-taskpane-item-border-radius);\n    transition: background-color 0.2s ease, border-color 0.2s ease;\n}\n\n.agent-component-header:hover {\n    background-color: var(--jp-layout-color3);\n}\n\n.agent-component-header.no-border {\n    border: none;\n}\n\n.agent-component-header.expanded {\n    border: none;\n    border-radius: 5px 5px 0 0;\n    background-color: var(--jp-layout-color2);\n}\n\n.agent-component-header.error-fixup {\n    border: none;\n}\n\n.agent-component-header.error-fixup.expanded {\n    background-color: var(--jp-layout-color2);\n}\n\n.agent-component-header-content {\n    display: flex;\n    align-items: center;\n    gap: 10px;\n    flex: 1;\n    min-width: 0;\n}\n\n.agent-component-header-content svg {\n    flex-shrink: 0;\n}\n\n.agent-component-header-expand-icon {\n    flex-shrink: 0;\n    transition: transform 0.2s ease;\n}\n\n.agent-component-header-expand-icon.expanded {\n    transform: rotate(90deg);\n} "],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/AgentToolUIComponent.css":
/*!******************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/AgentToolUIComponent.css ***!
  \******************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.agent-tool-ui-container {
    display: flex;
    flex-direction: row;
    align-items: center;
    justify-content: start;
    background-color: transparent;
    padding: 10px;
    color: var(--jp-ui-font-color2);
}

.agent-tool-ui-container:not(.agent-tool-ui-error-fixup) {
    margin: 10px 0;
    border-radius: 5px;
    border: 1px solid var(--jp-cell-editor-border-color);
}

.agent-tool-ui-container:not(.agent-tool-ui-error-fixup) .agent-tool-ui-content {
    margin-left: 5px;
}

.agent-tool-ui-content {
    display: flex;
    align-items: center;
    gap: 10px;
} 
`, "",{"version":3,"sources":["webpack://./style/AgentToolUIComponent.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,aAAa;IACb,mBAAmB;IACnB,mBAAmB;IACnB,sBAAsB;IACtB,6BAA6B;IAC7B,aAAa;IACb,+BAA+B;AACnC;;AAEA;IACI,cAAc;IACd,kBAAkB;IAClB,oDAAoD;AACxD;;AAEA;IACI,gBAAgB;AACpB;;AAEA;IACI,aAAa;IACb,mBAAmB;IACnB,SAAS;AACb","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.agent-tool-ui-container {\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n    justify-content: start;\n    background-color: transparent;\n    padding: 10px;\n    color: var(--jp-ui-font-color2);\n}\n\n.agent-tool-ui-container:not(.agent-tool-ui-error-fixup) {\n    margin: 10px 0;\n    border-radius: 5px;\n    border: 1px solid var(--jp-cell-editor-border-color);\n}\n\n.agent-tool-ui-container:not(.agent-tool-ui-error-fixup) .agent-tool-ui-content {\n    margin-left: 5px;\n}\n\n.agent-tool-ui-content {\n    display: flex;\n    align-items: center;\n    gap: 10px;\n} \n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/AlertBlock.css":
/*!********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/AlertBlock.css ***!
  \********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/* Base alert container styles */
.chat-message-alert-container {
  display: flex;
  flex-direction: column;
  gap: 10px;
  border-radius: 5px;
  padding: 10px;
  border: 1px solid;
}

/* Red variant for errors */
.chat-message-alert-container.error {
  background-color: var(--red-300);
  border-color: var(--red-900);
  color: var(--red-900);
}

/* Purple variant for upgrades/CTAs */
.chat-message-alert-container.upgrade {
  background-color: var(--purple-300);
  color: var(--grey-900);
}

.chat-message-alert a {
  color: var(--purple-700) !important;
  text-decoration: underline;
}

/* Error message styles - red variant */
.alert-error-message {
  font-size: 14px;
  font-weight: 600;
  line-height: 1.4;
  margin-bottom: 8px;
}

.chat-message-alert-container.error .alert-error-message {
  color: var(--red-900);
}

.alert-actions-header {
  margin-bottom: 12px;
}

.alert-actions-title {
  font-weight: 500;
  margin: 0 0 8px 0;
  font-size: 13px;
}

.chat-message-alert-container.error .alert-actions-title {
  color: var(--red-900);
}

.alert-actions-list {
  margin: 0;
  padding-left: 16px;
}

.chat-message-alert-container.error .alert-actions-list {
  color: var(--red-800);
}

.chat-message-alert-container.upgrade .alert-actions-list {
  color: var(--purple-800);
}

.alert-actions-list li {
  margin-bottom: 4px;
  font-size: 13px;
  line-height: 1.4;
}

.alert-action-item {
  display: flex;
  align-items: flex-start;
  gap: 8px;
  padding: 8px 0;
  font-size: 13px;
  line-height: 1.4;
}

.chat-message-alert-container.error .alert-action-item {
  color: var(--red-800);
}

.chat-message-alert-container.upgrade .alert-action-item {
  color: var(--purple-800);
}

.action-icon {
  font-size: 16px;
  flex-shrink: 0;
  margin-top: 1px;
}

.details-toggle {
  display: inline-flex;
  align-items: center;
}

.toggle-button {
  background: none;
  border: none;
  padding: 0;
  cursor: pointer;
  display: flex;
  align-items: center;
  gap: 4px;
  font-size: 12px;
  font-family: inherit;
  text-decoration: underline;
}

.chat-message-alert-container.error .toggle-button {
  color: var(--red-900);
}

.toggle-button:hover {
  text-decoration: none;
}

.chat-message-alert-container.error .toggle-button:hover {
  color: var(--red-800);
}

.chat-message-alert-container.upgrade .toggle-button:hover {
  color: var(--purple-800);
}

.toggle-caret {
  font-size: 10px;
  transition: transform 0.2s ease;
  display: inline-block;
  text-decoration: none !important;
}

.toggle-caret.open {
  transform: rotate(180deg);
}

.details-content {
  margin-top: 8px;
  margin-left: 16px;
  padding: 8px;
  background-color: var(--grey-100);
  border-radius: 4px;
  animation: slideDown 0.2s ease-out;
}

@keyframes slideDown {
  from {
    opacity: 0;
    transform: translateY(-4px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

.secondary-option-link {
    color: var(--purple-700) !important;
    text-decoration: underline !important;
}

.secondary-option-link:hover {
    color: var(--purple-600) !important;
}
`, "",{"version":3,"sources":["webpack://./style/AlertBlock.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF,gCAAgC;AAChC;EACE,aAAa;EACb,sBAAsB;EACtB,SAAS;EACT,kBAAkB;EAClB,aAAa;EACb,iBAAiB;AACnB;;AAEA,2BAA2B;AAC3B;EACE,gCAAgC;EAChC,4BAA4B;EAC5B,qBAAqB;AACvB;;AAEA,qCAAqC;AACrC;EACE,mCAAmC;EACnC,sBAAsB;AACxB;;AAEA;EACE,mCAAmC;EACnC,0BAA0B;AAC5B;;AAEA,uCAAuC;AACvC;EACE,eAAe;EACf,gBAAgB;EAChB,gBAAgB;EAChB,kBAAkB;AACpB;;AAEA;EACE,qBAAqB;AACvB;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE,gBAAgB;EAChB,iBAAiB;EACjB,eAAe;AACjB;;AAEA;EACE,qBAAqB;AACvB;;AAEA;EACE,SAAS;EACT,kBAAkB;AACpB;;AAEA;EACE,qBAAqB;AACvB;;AAEA;EACE,wBAAwB;AAC1B;;AAEA;EACE,kBAAkB;EAClB,eAAe;EACf,gBAAgB;AAClB;;AAEA;EACE,aAAa;EACb,uBAAuB;EACvB,QAAQ;EACR,cAAc;EACd,eAAe;EACf,gBAAgB;AAClB;;AAEA;EACE,qBAAqB;AACvB;;AAEA;EACE,wBAAwB;AAC1B;;AAEA;EACE,eAAe;EACf,cAAc;EACd,eAAe;AACjB;;AAEA;EACE,oBAAoB;EACpB,mBAAmB;AACrB;;AAEA;EACE,gBAAgB;EAChB,YAAY;EACZ,UAAU;EACV,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,eAAe;EACf,oBAAoB;EACpB,0BAA0B;AAC5B;;AAEA;EACE,qBAAqB;AACvB;;AAEA;EACE,qBAAqB;AACvB;;AAEA;EACE,qBAAqB;AACvB;;AAEA;EACE,wBAAwB;AAC1B;;AAEA;EACE,eAAe;EACf,+BAA+B;EAC/B,qBAAqB;EACrB,gCAAgC;AAClC;;AAEA;EACE,yBAAyB;AAC3B;;AAEA;EACE,eAAe;EACf,iBAAiB;EACjB,YAAY;EACZ,iCAAiC;EACjC,kBAAkB;EAClB,kCAAkC;AACpC;;AAEA;EACE;IACE,UAAU;IACV,2BAA2B;EAC7B;EACA;IACE,UAAU;IACV,wBAAwB;EAC1B;AACF;;AAEA;IACI,mCAAmC;IACnC,qCAAqC;AACzC;;AAEA;IACI,mCAAmC;AACvC","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n/* Base alert container styles */\n.chat-message-alert-container {\n  display: flex;\n  flex-direction: column;\n  gap: 10px;\n  border-radius: 5px;\n  padding: 10px;\n  border: 1px solid;\n}\n\n/* Red variant for errors */\n.chat-message-alert-container.error {\n  background-color: var(--red-300);\n  border-color: var(--red-900);\n  color: var(--red-900);\n}\n\n/* Purple variant for upgrades/CTAs */\n.chat-message-alert-container.upgrade {\n  background-color: var(--purple-300);\n  color: var(--grey-900);\n}\n\n.chat-message-alert a {\n  color: var(--purple-700) !important;\n  text-decoration: underline;\n}\n\n/* Error message styles - red variant */\n.alert-error-message {\n  font-size: 14px;\n  font-weight: 600;\n  line-height: 1.4;\n  margin-bottom: 8px;\n}\n\n.chat-message-alert-container.error .alert-error-message {\n  color: var(--red-900);\n}\n\n.alert-actions-header {\n  margin-bottom: 12px;\n}\n\n.alert-actions-title {\n  font-weight: 500;\n  margin: 0 0 8px 0;\n  font-size: 13px;\n}\n\n.chat-message-alert-container.error .alert-actions-title {\n  color: var(--red-900);\n}\n\n.alert-actions-list {\n  margin: 0;\n  padding-left: 16px;\n}\n\n.chat-message-alert-container.error .alert-actions-list {\n  color: var(--red-800);\n}\n\n.chat-message-alert-container.upgrade .alert-actions-list {\n  color: var(--purple-800);\n}\n\n.alert-actions-list li {\n  margin-bottom: 4px;\n  font-size: 13px;\n  line-height: 1.4;\n}\n\n.alert-action-item {\n  display: flex;\n  align-items: flex-start;\n  gap: 8px;\n  padding: 8px 0;\n  font-size: 13px;\n  line-height: 1.4;\n}\n\n.chat-message-alert-container.error .alert-action-item {\n  color: var(--red-800);\n}\n\n.chat-message-alert-container.upgrade .alert-action-item {\n  color: var(--purple-800);\n}\n\n.action-icon {\n  font-size: 16px;\n  flex-shrink: 0;\n  margin-top: 1px;\n}\n\n.details-toggle {\n  display: inline-flex;\n  align-items: center;\n}\n\n.toggle-button {\n  background: none;\n  border: none;\n  padding: 0;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  gap: 4px;\n  font-size: 12px;\n  font-family: inherit;\n  text-decoration: underline;\n}\n\n.chat-message-alert-container.error .toggle-button {\n  color: var(--red-900);\n}\n\n.toggle-button:hover {\n  text-decoration: none;\n}\n\n.chat-message-alert-container.error .toggle-button:hover {\n  color: var(--red-800);\n}\n\n.chat-message-alert-container.upgrade .toggle-button:hover {\n  color: var(--purple-800);\n}\n\n.toggle-caret {\n  font-size: 10px;\n  transition: transform 0.2s ease;\n  display: inline-block;\n  text-decoration: none !important;\n}\n\n.toggle-caret.open {\n  transform: rotate(180deg);\n}\n\n.details-content {\n  margin-top: 8px;\n  margin-left: 16px;\n  padding: 8px;\n  background-color: var(--grey-100);\n  border-radius: 4px;\n  animation: slideDown 0.2s ease-out;\n}\n\n@keyframes slideDown {\n  from {\n    opacity: 0;\n    transform: translateY(-4px);\n  }\n  to {\n    opacity: 1;\n    transform: translateY(0);\n  }\n}\n\n.secondary-option-link {\n    color: var(--purple-700) !important;\n    text-decoration: underline !important;\n}\n\n.secondary-option-link:hover {\n    color: var(--purple-600) !important;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/AppsList.css":
/*!******************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/AppsList.css ***!
  \******************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/* apps-list.css */
.apps-list-container {
  padding: 16px;
  font-size: 13px;
  font-family: var(--jp-ui-font-family);
}

.apps-list-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  margin-bottom: 16px;
}

.apps-list-title {
  margin: 0;
  font-size: 14px;
  font-weight: bold;
  color: var(--jp-ui-font-color1);
}

.apps-list-actions {
  display: flex;
  gap: 8px;
}

.apps-list-button {
  padding: 4px 8px;
  font-size: 11px;
  background-color: transparent;
  color: var(--jp-ui-font-color2);
  border: 1px solid var(--jp-border-color2);
  border-radius: 3px;
  cursor: pointer;
  font-weight: normal;
  transition: background-color 0.2s ease;
}

.apps-list-button:hover {
  background-color: var(--jp-layout-color2);
}

.apps-list-button:disabled {
  cursor: not-allowed;
}

.apps-list-button.primary {
  background-color: var(--jp-brand-color1);
  color: white;
  border: none;
}

.apps-list-loading {
  color: var(--jp-ui-font-color2);
  text-align: center;
  padding: 20px 0;
}

.apps-list-error {
  color: #f44336;
  text-align: center;
  padding: 20px 0;
  background-color: var(--jp-layout-color1);
  border: 1px solid #f44336;
  border-radius: 4px;
}

.apps-list-error-actions {
  margin-top: 8px;
}

.apps-list-empty {
  color: var(--jp-ui-font-color2);
  text-align: center;
  padding: 20px 0;
}

.app-item {
  border: 1px solid var(--jp-border-color1);
  border-radius: 4px;
  padding: 12px;
  margin-bottom: 8px;
  background-color: var(--jp-layout-color0);
}

.app-item-header {
  display: flex;
  justify-content: space-between;
  align-items: flex-start;
  margin-bottom: 8px;
}

.app-item-content {
  flex: 1;
}

.app-item-name {
  font-weight: bold;
  color: var(--jp-ui-font-color1);
  margin-bottom: 4px;
}

.app-item-status-container {
  display: flex;
  align-items: center;
  margin-bottom: 4px;
}

.app-item-status-indicator {
  display: inline-block;
  width: 8px;
  height: 8px;
  border-radius: 50%;
  margin-right: 6px;
}

.app-item-status-text {
  color: var(--jp-ui-font-color2);
  font-size: 12px;
}

.app-item-last-deployed {
  color: var(--jp-ui-font-color2);
  font-size: 11px;
}

.app-item-url-container {
  display: flex;
  align-items: center;
  background-color: var(--jp-layout-color1);
  border: 1px solid var(--jp-border-color2);
  border-radius: 3px;
  padding: 6px 8px;
}

.app-item-url {
  flex: 1;
  color: var(--jp-ui-font-color1);
  font-size: 11px;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  font-family: var(--jp-code-font-family);
}

.app-item-copy-button {
  border: none;
  background: transparent;
  cursor: pointer;
  padding: 2px;
  display: flex;
  align-items: center;
  justify-content: center;
  margin-left: 8px;
  border-radius: 2px;
}

.app-item-copy-button:hover {
  background-color: var(--jp-layout-color2);
}
`, "",{"version":3,"sources":["webpack://./style/AppsList.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF,kBAAkB;AAClB;EACE,aAAa;EACb,eAAe;EACf,qCAAqC;AACvC;;AAEA;EACE,aAAa;EACb,8BAA8B;EAC9B,mBAAmB;EACnB,mBAAmB;AACrB;;AAEA;EACE,SAAS;EACT,eAAe;EACf,iBAAiB;EACjB,+BAA+B;AACjC;;AAEA;EACE,aAAa;EACb,QAAQ;AACV;;AAEA;EACE,gBAAgB;EAChB,eAAe;EACf,6BAA6B;EAC7B,+BAA+B;EAC/B,yCAAyC;EACzC,kBAAkB;EAClB,eAAe;EACf,mBAAmB;EACnB,sCAAsC;AACxC;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE,wCAAwC;EACxC,YAAY;EACZ,YAAY;AACd;;AAEA;EACE,+BAA+B;EAC/B,kBAAkB;EAClB,eAAe;AACjB;;AAEA;EACE,cAAc;EACd,kBAAkB;EAClB,eAAe;EACf,yCAAyC;EACzC,yBAAyB;EACzB,kBAAkB;AACpB;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,+BAA+B;EAC/B,kBAAkB;EAClB,eAAe;AACjB;;AAEA;EACE,yCAAyC;EACzC,kBAAkB;EAClB,aAAa;EACb,kBAAkB;EAClB,yCAAyC;AAC3C;;AAEA;EACE,aAAa;EACb,8BAA8B;EAC9B,uBAAuB;EACvB,kBAAkB;AACpB;;AAEA;EACE,OAAO;AACT;;AAEA;EACE,iBAAiB;EACjB,+BAA+B;EAC/B,kBAAkB;AACpB;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,kBAAkB;AACpB;;AAEA;EACE,qBAAqB;EACrB,UAAU;EACV,WAAW;EACX,kBAAkB;EAClB,iBAAiB;AACnB;;AAEA;EACE,+BAA+B;EAC/B,eAAe;AACjB;;AAEA;EACE,+BAA+B;EAC/B,eAAe;AACjB;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,yCAAyC;EACzC,yCAAyC;EACzC,kBAAkB;EAClB,gBAAgB;AAClB;;AAEA;EACE,OAAO;EACP,+BAA+B;EAC/B,eAAe;EACf,gBAAgB;EAChB,uBAAuB;EACvB,mBAAmB;EACnB,uCAAuC;AACzC;;AAEA;EACE,YAAY;EACZ,uBAAuB;EACvB,eAAe;EACf,YAAY;EACZ,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,gBAAgB;EAChB,kBAAkB;AACpB;;AAEA;EACE,yCAAyC;AAC3C","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n/* apps-list.css */\n.apps-list-container {\n  padding: 16px;\n  font-size: 13px;\n  font-family: var(--jp-ui-font-family);\n}\n\n.apps-list-header {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: 16px;\n}\n\n.apps-list-title {\n  margin: 0;\n  font-size: 14px;\n  font-weight: bold;\n  color: var(--jp-ui-font-color1);\n}\n\n.apps-list-actions {\n  display: flex;\n  gap: 8px;\n}\n\n.apps-list-button {\n  padding: 4px 8px;\n  font-size: 11px;\n  background-color: transparent;\n  color: var(--jp-ui-font-color2);\n  border: 1px solid var(--jp-border-color2);\n  border-radius: 3px;\n  cursor: pointer;\n  font-weight: normal;\n  transition: background-color 0.2s ease;\n}\n\n.apps-list-button:hover {\n  background-color: var(--jp-layout-color2);\n}\n\n.apps-list-button:disabled {\n  cursor: not-allowed;\n}\n\n.apps-list-button.primary {\n  background-color: var(--jp-brand-color1);\n  color: white;\n  border: none;\n}\n\n.apps-list-loading {\n  color: var(--jp-ui-font-color2);\n  text-align: center;\n  padding: 20px 0;\n}\n\n.apps-list-error {\n  color: #f44336;\n  text-align: center;\n  padding: 20px 0;\n  background-color: var(--jp-layout-color1);\n  border: 1px solid #f44336;\n  border-radius: 4px;\n}\n\n.apps-list-error-actions {\n  margin-top: 8px;\n}\n\n.apps-list-empty {\n  color: var(--jp-ui-font-color2);\n  text-align: center;\n  padding: 20px 0;\n}\n\n.app-item {\n  border: 1px solid var(--jp-border-color1);\n  border-radius: 4px;\n  padding: 12px;\n  margin-bottom: 8px;\n  background-color: var(--jp-layout-color0);\n}\n\n.app-item-header {\n  display: flex;\n  justify-content: space-between;\n  align-items: flex-start;\n  margin-bottom: 8px;\n}\n\n.app-item-content {\n  flex: 1;\n}\n\n.app-item-name {\n  font-weight: bold;\n  color: var(--jp-ui-font-color1);\n  margin-bottom: 4px;\n}\n\n.app-item-status-container {\n  display: flex;\n  align-items: center;\n  margin-bottom: 4px;\n}\n\n.app-item-status-indicator {\n  display: inline-block;\n  width: 8px;\n  height: 8px;\n  border-radius: 50%;\n  margin-right: 6px;\n}\n\n.app-item-status-text {\n  color: var(--jp-ui-font-color2);\n  font-size: 12px;\n}\n\n.app-item-last-deployed {\n  color: var(--jp-ui-font-color2);\n  font-size: 11px;\n}\n\n.app-item-url-container {\n  display: flex;\n  align-items: center;\n  background-color: var(--jp-layout-color1);\n  border: 1px solid var(--jp-border-color2);\n  border-radius: 3px;\n  padding: 6px 8px;\n}\n\n.app-item-url {\n  flex: 1;\n  color: var(--jp-ui-font-color1);\n  font-size: 11px;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  font-family: var(--jp-code-font-family);\n}\n\n.app-item-copy-button {\n  border: none;\n  background: transparent;\n  cursor: pointer;\n  padding: 2px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  margin-left: 8px;\n  border-radius: 2px;\n}\n\n.app-item-copy-button:hover {\n  background-color: var(--jp-layout-color2);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/AssumptionTool.css":
/*!************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/AssumptionTool.css ***!
  \************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.assumption-tool-container {
    color: var(--jp-ui-font-color2);
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-top: 10px;
    margin-bottom: 10px;
    position: relative;
    padding: 8px var(--chat-taskpane-tool-call-horizontal-padding);
    border-radius: var(--chat-taskpane-item-border-radius);
    border: 1px solid var(--jp-cell-editor-border-color);
    cursor: default;
}

.assumption-header-label {
    position: absolute;
    top: -10px;
    left: 12px;
    background-color: var(--chat-background-color);
    padding: 2px 8px;
    border-radius: 4px;
    font-size: 12px;
    color: var(--jp-ui-font-color2);
    font-style: italic;
}

.assumption-content {
    display: flex;
    align-items: flex-start;
    gap: 8px;
    color: var(--jp-ui-font-color2);
    font-size: 14px;
    line-height: 1.4;
    margin: 0;
    padding: 10px 10px 5px 10px;
}

.assumption-content ul {
    margin: 0;
    padding-left: 10px;
}`, "",{"version":3,"sources":["webpack://./style/AssumptionTool.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,+BAA+B;IAC/B,aAAa;IACb,8BAA8B;IAC9B,mBAAmB;IACnB,gBAAgB;IAChB,mBAAmB;IACnB,kBAAkB;IAClB,8DAA8D;IAC9D,sDAAsD;IACtD,oDAAoD;IACpD,eAAe;AACnB;;AAEA;IACI,kBAAkB;IAClB,UAAU;IACV,UAAU;IACV,8CAA8C;IAC9C,gBAAgB;IAChB,kBAAkB;IAClB,eAAe;IACf,+BAA+B;IAC/B,kBAAkB;AACtB;;AAEA;IACI,aAAa;IACb,uBAAuB;IACvB,QAAQ;IACR,+BAA+B;IAC/B,eAAe;IACf,gBAAgB;IAChB,SAAS;IACT,2BAA2B;AAC/B;;AAEA;IACI,SAAS;IACT,kBAAkB;AACtB","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.assumption-tool-container {\n    color: var(--jp-ui-font-color2);\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    margin-top: 10px;\n    margin-bottom: 10px;\n    position: relative;\n    padding: 8px var(--chat-taskpane-tool-call-horizontal-padding);\n    border-radius: var(--chat-taskpane-item-border-radius);\n    border: 1px solid var(--jp-cell-editor-border-color);\n    cursor: default;\n}\n\n.assumption-header-label {\n    position: absolute;\n    top: -10px;\n    left: 12px;\n    background-color: var(--chat-background-color);\n    padding: 2px 8px;\n    border-radius: 4px;\n    font-size: 12px;\n    color: var(--jp-ui-font-color2);\n    font-style: italic;\n}\n\n.assumption-content {\n    display: flex;\n    align-items: flex-start;\n    gap: 8px;\n    color: var(--jp-ui-font-color2);\n    font-size: 14px;\n    line-height: 1.4;\n    margin: 0;\n    padding: 10px 10px 5px 10px;\n}\n\n.assumption-content ul {\n    margin: 0;\n    padding-left: 10px;\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/AuthPopup.css":
/*!*******************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/AuthPopup.css ***!
  \*******************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/* Auth popup specific styling to integrate AWS Amplify with Mito theme */
.modal-content .amplify-authenticator {
  --amplify-colors-font-primary: var(--jp-ui-font-color1);
  --amplify-colors-font-secondary: var(--jp-ui-font-color2);
  --amplify-colors-background-primary: var(--jp-layout-color0);
  --amplify-colors-background-secondary: var(--jp-layout-color1);
  --amplify-colors-border-primary: var(--jp-border-color1);
  --amplify-colors-brand-primary-10: var(--purple-700);
  --amplify-colors-brand-primary-80: var(--purple-500);
  --amplify-colors-brand-primary-90: var(--purple-400);
  --amplify-colors-brand-primary-100: var(--purple-300);
  --amplify-radii-small: 4px;
  --amplify-radii-medium: 4px;
  --amplify-space-small: 8px;
  --amplify-space-medium: 12px;
  --amplify-space-large: 16px;
  --amplify-font-sizes-small: 14px;
  --amplify-font-sizes-medium: 14px;
  
  /* Remove the blue top border on active tabs */
  --amplify-components-tabs-item-active-border-width: 0;
  --amplify-components-tabs-item-border-width: 0;
  
  /* Ensure active tab bottom border uses purple */
  --amplify-components-tabs-item-active-border-color: var(--purple-500);
  --amplify-components-tabs-item-active-color: var(--purple-700);
}

/* Ensure modal content has adequate width for auth form */
.modal-content:has(.amplify-authenticator) {
  width: 480px;
  max-width: 90vw;
  min-width: 400px;
}

/* Style the authenticator container */
.modal-content .amplify-authenticator__modal {
  background: transparent !important;
  box-shadow: none !important;
  border: none !important;
}

/* Constrain authenticator content within modal bounds */
.modal-content .amplify-authenticator {
  width: 100% !important;
  max-width: 100% !important;
  overflow: hidden !important;
}

/* Specifically target the data-amplify-container to prevent overflow */
.modal-content [data-amplify-container] {
  width: 100% !important;
  max-width: 100% !important;
  overflow: hidden !important;
  box-sizing: border-box !important;
}



/* Constrain the tabs container */
.modal-content .amplify-tabs {
  width: 100% !important;
  max-width: 100% !important;
  overflow: hidden !important;
}

/* Ensure form fields don't overflow */
.modal-content .amplify-field,
.modal-content .amplify-field__group {
  width: 100% !important;
  max-width: 100% !important;
  box-sizing: border-box !important;
}

/* Align form elements with Mito styling */
.modal-content .amplify-field__label {
  color: var(--jp-ui-font-color1) !important;
  font-weight: 500 !important;
}

.modal-content .amplify-input,
.modal-content .amplify-select {
  background: var(--jp-layout-color0) !important;
  border: 1px solid var(--jp-border-color1) !important;
  color: var(--jp-ui-font-color1) !important;
  border-radius: 4px !important;
}

.modal-content .amplify-input:focus,
.modal-content .amplify-select:focus {
  border-color: var(--purple-500) !important;
  box-shadow: 0 0 0 2px rgba(124, 58, 237, 0.1) !important;
}



/* Style Amplify buttons to match Mito theme */
.modal-content .amplify-button--primary {
  background-color: var(--purple-400) !important;
  color: var(--purple-700) !important;
  border: none !important;
  border-radius: 4px !important;
  font-weight: 500 !important;
  padding: 8px 16px !important;
  width: 100% !important;
  max-width: 100% !important;
  box-sizing: border-box !important;
}

.modal-content .amplify-button--primary:hover {
  background-color: var(--purple-500) !important;
}

.modal-content .amplify-button--link {
  color: var(--purple-600) !important;
  text-decoration: none !important;
}

.modal-content .amplify-button--link:hover {
  color: var(--purple-700) !important;
  text-decoration: underline !important;
}

/* Error and success message styling */
.modal-content .amplify-alert--error {
  background-color: var(--red-300) !important;
  color: var(--red-900) !important;
  border: 1px solid var(--red-400) !important;
  border-radius: 4px !important;
}

.modal-content .amplify-alert--info {
  background-color: var(--purple-300) !important;
  color: var(--purple-700) !important;
  border: 1px solid var(--purple-400) !important;
  border-radius: 4px !important;
}

/* Tab styling for sign in/sign up tabs */
.modal-content .amplify-tabs__item {
  color: var(--jp-ui-font-color2) !important;
  border-bottom: 2px solid transparent !important;
}

.modal-content .amplify-tabs__item[data-state="active"] {
  color: var(--purple-700) !important;
  border-bottom-color: var(--purple-500) !important;
}

/* Ensure inactive tabs don't have purple styling */
.modal-content .amplify-tabs__item[data-state="inactive"] {
  color: var(--jp-ui-font-color2) !important;
  border-bottom: 2px solid transparent !important;
}



.modal-content .amplify-tabs__item:hover {
  color: var(--jp-ui-font-color1) !important;
}

/* Override any default blue tab styling from Amplify */
.modal-content .amplify-tabs__list {
  border-bottom: 1px solid var(--jp-border-color1) !important;
}

.modal-content .amplify-tabs__item[data-state="active"]:after,
.modal-content .amplify-tabs__item[aria-selected="true"]:after {
  background-color: var(--purple-500) !important;
  border-color: var(--purple-500) !important;
}

/* Override any Amplify default blue colors */
.modal-content .amplify-tabs [data-amplify-color-mode] .amplify-tabs__item[data-state="active"] {
  color: var(--purple-700) !important;
  border-bottom-color: var(--purple-500) !important;
}

.modal-content .amplify-tabs [data-amplify-color-mode] .amplify-tabs__item[aria-selected="true"] {
  color: var(--purple-700) !important;
  border-bottom-color: var(--purple-500) !important;
}

/* Additional selectors to ensure default active state on initial load */
.modal-content .amplify-tabs__item[aria-selected="true"] {
  color: var(--purple-700) !important;
  border-bottom: 2px solid var(--purple-500) !important;
}



/* Loading spinner colors */
.modal-content .amplify-loader {
  border-top-color: var(--purple-500) !important;
}

/* Additional purple color overrides for any remaining blue elements */
.modal-content .amplify-tabs__item[data-state="active"] *,
.modal-content .amplify-tabs__item[aria-selected="true"] * {
  color: var(--purple-700) !important;
}

/* Override focus states to use purple */
.modal-content .amplify-tabs__item:focus,
.modal-content .amplify-tabs__item:focus-visible {
  border-bottom-color: var(--purple-500) !important;
  outline-color: var(--purple-500) !important;
}

/* Ensure any nested tab content uses purple theme */
.modal-content [data-amplify-authenticator] [data-amplify-router] .amplify-tabs__item[data-state="active"] {
  color: var(--purple-700) !important;
  border-bottom-color: var(--purple-500) !important;
}

/* Remove any top borders, outlines, or blue styling from tabs */
.modal-content .amplify-tabs__item {
  border-top: none !important;
  border-left: none !important;
  border-right: none !important;
  outline: none !important;
}

.modal-content .amplify-tabs__item[data-state="active"],
.modal-content .amplify-tabs__item[aria-selected="true"] {
  border-top: none !important;
  border-left: none !important;
  border-right: none !important;
  outline: none !important;
  box-shadow: none !important;
}

/* Remove any pseudo-element borders that might create blue lines */
.modal-content .amplify-tabs__item:before,
.modal-content .amplify-tabs__item:after,
.modal-content .amplify-tabs__item[data-state="active"]:before,
.modal-content .amplify-tabs__item[aria-selected="true"]:before {
  display: none !important;
  border: none !important;
  background: none !important;
}



/* Additional containment rules for better layout */
.modal-content .amplify-authenticator * {
  box-sizing: border-box !important;
}

/* Prevent any Amplify containers from overflowing */
.modal-content [data-amplify-authenticator],
.modal-content [data-amplify-router],
.modal-content [data-amplify-authenticator-signin],
.modal-content [data-amplify-authenticator-signup] {
  width: 100% !important;
  max-width: 100% !important;
  overflow: hidden !important;
  box-sizing: border-box !important;
}

/* Remove any default margins or padding that might cause overflow */
.modal-content [data-amplify-container] * {
  max-width: 100% !important;
}

/* Ensure modal content itself doesn't allow horizontal scroll */
.modal-content:has(.amplify-authenticator) {
  overflow-x: hidden !important;
}

/* Target main Amplify containers but not inputs */
.modal-content div[data-amplify-container] {
  width: 100% !important;
  max-width: 100% !important;
  box-sizing: border-box !important;
}

/* Ensure tab panels fit within bounds */
.modal-content .amplify-tabs__panel {
  width: 100% !important;
  max-width: 100% !important;
  overflow: hidden !important;
  padding: 16px !important;
}

/* Ensure tab list doesn't overflow */
.modal-content .amplify-tabs__list {
  width: 100% !important;
  max-width: 100% !important;
  display: flex !important;
  justify-content: space-around !important;
}

.modal-content .amplify-tabs__item {
  flex: 1 !important;
  text-align: center !important;
  max-width: 50% !important;
}

/* Add this to your AuthPopup.css file */

/* Hide password requirements by default */
.password-requirements {
  display: none;
  padding: 16px 20px;
  background-color: var(--jp-layout-color2);
  border-top: 1px solid var(--jp-border-color1);
  font-size: 13px;
}

/* Show password requirements when sign-up form is present */
.modal-content:has([data-amplify-authenticator-signup]) .password-requirements {
  display: block;
}

/* Style the requirements content */
.password-requirements p {
  margin: 0 0 8px 0;
  font-weight: bold;
  color: var(--jp-ui-font-color1);
}

.password-requirements ul {
  margin: 0;
  padding-left: 20px;
  color: var(--jp-ui-font-color2);
  font-size: 12px;
}

/* Success message styling */
.auth-success-message {
  padding: 32px 24px;
  text-align: center;
  background: var(--jp-layout-color0);
  border-radius: 8px;
}

.success-icon {
  margin-bottom: 20px;
  display: flex;
  justify-content: center;
}

.success-title {
  color: var(--jp-ui-font-color1);
  font-size: 24px;
  font-weight: 600;
  margin: 0 0 12px 0;
  font-family: var(--jp-ui-font-family);
}

.success-description {
  color: var(--jp-ui-font-color1);
  font-size: 16px;
  margin: 0 0 16px 0;
  font-family: var(--jp-ui-font-family);
  line-height: 1.5;
}

.success-timer {
  color: var(--jp-ui-font-color2);
  font-size: 14px;
  margin: 0 0 24px 0;
  font-family: var(--jp-ui-font-family);
  font-style: italic;
}

.success-actions {
  display: flex;
  justify-content: center;
  gap: 12px;
}

/* Progress bar animation */
@keyframes progressFill {
  from { width: 0%; }
  to { width: 100%; }
}

/* Welcome message container styling */
.welcome-message-container {
  border: 1px solid var(--jp-border-color1);
  border-radius: 8px;
  padding: 32px 24px;
  margin: 16px 0;
  background-color: var(--jp-layout-color0);
  text-align: center;
}

/* Welcome message title */
.welcome-message-title {
  color: var(--jp-ui-font-color1);
  font-size: 24px;
  font-weight: 600;
  margin: 0 0 12px 0;
  font-family: var(--jp-ui-font-family);
}

/* Welcome message description */
.welcome-message-description {
  color: var(--jp-ui-font-color1);
  font-size: 16px;
  margin: 0 0 16px 0;
  font-family: var(--jp-ui-font-family);
  line-height: 1.5;
}

/* Progress bar container */
.progress-bar-container {
  width: 100%;
  height: 4px;
  background-color: var(--jp-border-color1);
  border-radius: 2px;
  overflow: hidden;
  margin-top: 20px;
  margin-bottom: 12px;
}

/* Progress bar fill with CSS animation */
.progress-bar-fill {
  width: 0%;
  height: 100%;
  background-color: var(--purple-500);
  border-radius: 2px;
  animation: progressFill 3s linear forwards;
}

/* Progress bar timer text */
.progress-bar-timer {
  color: var(--jp-ui-font-color2);
  font-size: 14px;
  margin: 0;
  font-family: var(--jp-ui-font-family);
  font-style: italic;
}`, "",{"version":3,"sources":["webpack://./style/AuthPopup.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF,yEAAyE;AACzE;EACE,uDAAuD;EACvD,yDAAyD;EACzD,4DAA4D;EAC5D,8DAA8D;EAC9D,wDAAwD;EACxD,oDAAoD;EACpD,oDAAoD;EACpD,oDAAoD;EACpD,qDAAqD;EACrD,0BAA0B;EAC1B,2BAA2B;EAC3B,0BAA0B;EAC1B,4BAA4B;EAC5B,2BAA2B;EAC3B,gCAAgC;EAChC,iCAAiC;;EAEjC,8CAA8C;EAC9C,qDAAqD;EACrD,8CAA8C;;EAE9C,gDAAgD;EAChD,qEAAqE;EACrE,8DAA8D;AAChE;;AAEA,0DAA0D;AAC1D;EACE,YAAY;EACZ,eAAe;EACf,gBAAgB;AAClB;;AAEA,sCAAsC;AACtC;EACE,kCAAkC;EAClC,2BAA2B;EAC3B,uBAAuB;AACzB;;AAEA,wDAAwD;AACxD;EACE,sBAAsB;EACtB,0BAA0B;EAC1B,2BAA2B;AAC7B;;AAEA,uEAAuE;AACvE;EACE,sBAAsB;EACtB,0BAA0B;EAC1B,2BAA2B;EAC3B,iCAAiC;AACnC;;;;AAIA,iCAAiC;AACjC;EACE,sBAAsB;EACtB,0BAA0B;EAC1B,2BAA2B;AAC7B;;AAEA,sCAAsC;AACtC;;EAEE,sBAAsB;EACtB,0BAA0B;EAC1B,iCAAiC;AACnC;;AAEA,0CAA0C;AAC1C;EACE,0CAA0C;EAC1C,2BAA2B;AAC7B;;AAEA;;EAEE,8CAA8C;EAC9C,oDAAoD;EACpD,0CAA0C;EAC1C,6BAA6B;AAC/B;;AAEA;;EAEE,0CAA0C;EAC1C,wDAAwD;AAC1D;;;;AAIA,8CAA8C;AAC9C;EACE,8CAA8C;EAC9C,mCAAmC;EACnC,uBAAuB;EACvB,6BAA6B;EAC7B,2BAA2B;EAC3B,4BAA4B;EAC5B,sBAAsB;EACtB,0BAA0B;EAC1B,iCAAiC;AACnC;;AAEA;EACE,8CAA8C;AAChD;;AAEA;EACE,mCAAmC;EACnC,gCAAgC;AAClC;;AAEA;EACE,mCAAmC;EACnC,qCAAqC;AACvC;;AAEA,sCAAsC;AACtC;EACE,2CAA2C;EAC3C,gCAAgC;EAChC,2CAA2C;EAC3C,6BAA6B;AAC/B;;AAEA;EACE,8CAA8C;EAC9C,mCAAmC;EACnC,8CAA8C;EAC9C,6BAA6B;AAC/B;;AAEA,yCAAyC;AACzC;EACE,0CAA0C;EAC1C,+CAA+C;AACjD;;AAEA;EACE,mCAAmC;EACnC,iDAAiD;AACnD;;AAEA,mDAAmD;AACnD;EACE,0CAA0C;EAC1C,+CAA+C;AACjD;;;;AAIA;EACE,0CAA0C;AAC5C;;AAEA,uDAAuD;AACvD;EACE,2DAA2D;AAC7D;;AAEA;;EAEE,8CAA8C;EAC9C,0CAA0C;AAC5C;;AAEA,6CAA6C;AAC7C;EACE,mCAAmC;EACnC,iDAAiD;AACnD;;AAEA;EACE,mCAAmC;EACnC,iDAAiD;AACnD;;AAEA,wEAAwE;AACxE;EACE,mCAAmC;EACnC,qDAAqD;AACvD;;;;AAIA,2BAA2B;AAC3B;EACE,8CAA8C;AAChD;;AAEA,sEAAsE;AACtE;;EAEE,mCAAmC;AACrC;;AAEA,wCAAwC;AACxC;;EAEE,iDAAiD;EACjD,2CAA2C;AAC7C;;AAEA,oDAAoD;AACpD;EACE,mCAAmC;EACnC,iDAAiD;AACnD;;AAEA,gEAAgE;AAChE;EACE,2BAA2B;EAC3B,4BAA4B;EAC5B,6BAA6B;EAC7B,wBAAwB;AAC1B;;AAEA;;EAEE,2BAA2B;EAC3B,4BAA4B;EAC5B,6BAA6B;EAC7B,wBAAwB;EACxB,2BAA2B;AAC7B;;AAEA,mEAAmE;AACnE;;;;EAIE,wBAAwB;EACxB,uBAAuB;EACvB,2BAA2B;AAC7B;;;;AAIA,mDAAmD;AACnD;EACE,iCAAiC;AACnC;;AAEA,oDAAoD;AACpD;;;;EAIE,sBAAsB;EACtB,0BAA0B;EAC1B,2BAA2B;EAC3B,iCAAiC;AACnC;;AAEA,oEAAoE;AACpE;EACE,0BAA0B;AAC5B;;AAEA,gEAAgE;AAChE;EACE,6BAA6B;AAC/B;;AAEA,kDAAkD;AAClD;EACE,sBAAsB;EACtB,0BAA0B;EAC1B,iCAAiC;AACnC;;AAEA,wCAAwC;AACxC;EACE,sBAAsB;EACtB,0BAA0B;EAC1B,2BAA2B;EAC3B,wBAAwB;AAC1B;;AAEA,qCAAqC;AACrC;EACE,sBAAsB;EACtB,0BAA0B;EAC1B,wBAAwB;EACxB,wCAAwC;AAC1C;;AAEA;EACE,kBAAkB;EAClB,6BAA6B;EAC7B,yBAAyB;AAC3B;;AAEA,wCAAwC;;AAExC,0CAA0C;AAC1C;EACE,aAAa;EACb,kBAAkB;EAClB,yCAAyC;EACzC,6CAA6C;EAC7C,eAAe;AACjB;;AAEA,4DAA4D;AAC5D;EACE,cAAc;AAChB;;AAEA,mCAAmC;AACnC;EACE,iBAAiB;EACjB,iBAAiB;EACjB,+BAA+B;AACjC;;AAEA;EACE,SAAS;EACT,kBAAkB;EAClB,+BAA+B;EAC/B,eAAe;AACjB;;AAEA,4BAA4B;AAC5B;EACE,kBAAkB;EAClB,kBAAkB;EAClB,mCAAmC;EACnC,kBAAkB;AACpB;;AAEA;EACE,mBAAmB;EACnB,aAAa;EACb,uBAAuB;AACzB;;AAEA;EACE,+BAA+B;EAC/B,eAAe;EACf,gBAAgB;EAChB,kBAAkB;EAClB,qCAAqC;AACvC;;AAEA;EACE,+BAA+B;EAC/B,eAAe;EACf,kBAAkB;EAClB,qCAAqC;EACrC,gBAAgB;AAClB;;AAEA;EACE,+BAA+B;EAC/B,eAAe;EACf,kBAAkB;EAClB,qCAAqC;EACrC,kBAAkB;AACpB;;AAEA;EACE,aAAa;EACb,uBAAuB;EACvB,SAAS;AACX;;AAEA,2BAA2B;AAC3B;EACE,OAAO,SAAS,EAAE;EAClB,KAAK,WAAW,EAAE;AACpB;;AAEA,sCAAsC;AACtC;EACE,yCAAyC;EACzC,kBAAkB;EAClB,kBAAkB;EAClB,cAAc;EACd,yCAAyC;EACzC,kBAAkB;AACpB;;AAEA,0BAA0B;AAC1B;EACE,+BAA+B;EAC/B,eAAe;EACf,gBAAgB;EAChB,kBAAkB;EAClB,qCAAqC;AACvC;;AAEA,gCAAgC;AAChC;EACE,+BAA+B;EAC/B,eAAe;EACf,kBAAkB;EAClB,qCAAqC;EACrC,gBAAgB;AAClB;;AAEA,2BAA2B;AAC3B;EACE,WAAW;EACX,WAAW;EACX,yCAAyC;EACzC,kBAAkB;EAClB,gBAAgB;EAChB,gBAAgB;EAChB,mBAAmB;AACrB;;AAEA,yCAAyC;AACzC;EACE,SAAS;EACT,YAAY;EACZ,mCAAmC;EACnC,kBAAkB;EAClB,0CAA0C;AAC5C;;AAEA,4BAA4B;AAC5B;EACE,+BAA+B;EAC/B,eAAe;EACf,SAAS;EACT,qCAAqC;EACrC,kBAAkB;AACpB","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n/* Auth popup specific styling to integrate AWS Amplify with Mito theme */\n.modal-content .amplify-authenticator {\n  --amplify-colors-font-primary: var(--jp-ui-font-color1);\n  --amplify-colors-font-secondary: var(--jp-ui-font-color2);\n  --amplify-colors-background-primary: var(--jp-layout-color0);\n  --amplify-colors-background-secondary: var(--jp-layout-color1);\n  --amplify-colors-border-primary: var(--jp-border-color1);\n  --amplify-colors-brand-primary-10: var(--purple-700);\n  --amplify-colors-brand-primary-80: var(--purple-500);\n  --amplify-colors-brand-primary-90: var(--purple-400);\n  --amplify-colors-brand-primary-100: var(--purple-300);\n  --amplify-radii-small: 4px;\n  --amplify-radii-medium: 4px;\n  --amplify-space-small: 8px;\n  --amplify-space-medium: 12px;\n  --amplify-space-large: 16px;\n  --amplify-font-sizes-small: 14px;\n  --amplify-font-sizes-medium: 14px;\n  \n  /* Remove the blue top border on active tabs */\n  --amplify-components-tabs-item-active-border-width: 0;\n  --amplify-components-tabs-item-border-width: 0;\n  \n  /* Ensure active tab bottom border uses purple */\n  --amplify-components-tabs-item-active-border-color: var(--purple-500);\n  --amplify-components-tabs-item-active-color: var(--purple-700);\n}\n\n/* Ensure modal content has adequate width for auth form */\n.modal-content:has(.amplify-authenticator) {\n  width: 480px;\n  max-width: 90vw;\n  min-width: 400px;\n}\n\n/* Style the authenticator container */\n.modal-content .amplify-authenticator__modal {\n  background: transparent !important;\n  box-shadow: none !important;\n  border: none !important;\n}\n\n/* Constrain authenticator content within modal bounds */\n.modal-content .amplify-authenticator {\n  width: 100% !important;\n  max-width: 100% !important;\n  overflow: hidden !important;\n}\n\n/* Specifically target the data-amplify-container to prevent overflow */\n.modal-content [data-amplify-container] {\n  width: 100% !important;\n  max-width: 100% !important;\n  overflow: hidden !important;\n  box-sizing: border-box !important;\n}\n\n\n\n/* Constrain the tabs container */\n.modal-content .amplify-tabs {\n  width: 100% !important;\n  max-width: 100% !important;\n  overflow: hidden !important;\n}\n\n/* Ensure form fields don't overflow */\n.modal-content .amplify-field,\n.modal-content .amplify-field__group {\n  width: 100% !important;\n  max-width: 100% !important;\n  box-sizing: border-box !important;\n}\n\n/* Align form elements with Mito styling */\n.modal-content .amplify-field__label {\n  color: var(--jp-ui-font-color1) !important;\n  font-weight: 500 !important;\n}\n\n.modal-content .amplify-input,\n.modal-content .amplify-select {\n  background: var(--jp-layout-color0) !important;\n  border: 1px solid var(--jp-border-color1) !important;\n  color: var(--jp-ui-font-color1) !important;\n  border-radius: 4px !important;\n}\n\n.modal-content .amplify-input:focus,\n.modal-content .amplify-select:focus {\n  border-color: var(--purple-500) !important;\n  box-shadow: 0 0 0 2px rgba(124, 58, 237, 0.1) !important;\n}\n\n\n\n/* Style Amplify buttons to match Mito theme */\n.modal-content .amplify-button--primary {\n  background-color: var(--purple-400) !important;\n  color: var(--purple-700) !important;\n  border: none !important;\n  border-radius: 4px !important;\n  font-weight: 500 !important;\n  padding: 8px 16px !important;\n  width: 100% !important;\n  max-width: 100% !important;\n  box-sizing: border-box !important;\n}\n\n.modal-content .amplify-button--primary:hover {\n  background-color: var(--purple-500) !important;\n}\n\n.modal-content .amplify-button--link {\n  color: var(--purple-600) !important;\n  text-decoration: none !important;\n}\n\n.modal-content .amplify-button--link:hover {\n  color: var(--purple-700) !important;\n  text-decoration: underline !important;\n}\n\n/* Error and success message styling */\n.modal-content .amplify-alert--error {\n  background-color: var(--red-300) !important;\n  color: var(--red-900) !important;\n  border: 1px solid var(--red-400) !important;\n  border-radius: 4px !important;\n}\n\n.modal-content .amplify-alert--info {\n  background-color: var(--purple-300) !important;\n  color: var(--purple-700) !important;\n  border: 1px solid var(--purple-400) !important;\n  border-radius: 4px !important;\n}\n\n/* Tab styling for sign in/sign up tabs */\n.modal-content .amplify-tabs__item {\n  color: var(--jp-ui-font-color2) !important;\n  border-bottom: 2px solid transparent !important;\n}\n\n.modal-content .amplify-tabs__item[data-state=\"active\"] {\n  color: var(--purple-700) !important;\n  border-bottom-color: var(--purple-500) !important;\n}\n\n/* Ensure inactive tabs don't have purple styling */\n.modal-content .amplify-tabs__item[data-state=\"inactive\"] {\n  color: var(--jp-ui-font-color2) !important;\n  border-bottom: 2px solid transparent !important;\n}\n\n\n\n.modal-content .amplify-tabs__item:hover {\n  color: var(--jp-ui-font-color1) !important;\n}\n\n/* Override any default blue tab styling from Amplify */\n.modal-content .amplify-tabs__list {\n  border-bottom: 1px solid var(--jp-border-color1) !important;\n}\n\n.modal-content .amplify-tabs__item[data-state=\"active\"]:after,\n.modal-content .amplify-tabs__item[aria-selected=\"true\"]:after {\n  background-color: var(--purple-500) !important;\n  border-color: var(--purple-500) !important;\n}\n\n/* Override any Amplify default blue colors */\n.modal-content .amplify-tabs [data-amplify-color-mode] .amplify-tabs__item[data-state=\"active\"] {\n  color: var(--purple-700) !important;\n  border-bottom-color: var(--purple-500) !important;\n}\n\n.modal-content .amplify-tabs [data-amplify-color-mode] .amplify-tabs__item[aria-selected=\"true\"] {\n  color: var(--purple-700) !important;\n  border-bottom-color: var(--purple-500) !important;\n}\n\n/* Additional selectors to ensure default active state on initial load */\n.modal-content .amplify-tabs__item[aria-selected=\"true\"] {\n  color: var(--purple-700) !important;\n  border-bottom: 2px solid var(--purple-500) !important;\n}\n\n\n\n/* Loading spinner colors */\n.modal-content .amplify-loader {\n  border-top-color: var(--purple-500) !important;\n}\n\n/* Additional purple color overrides for any remaining blue elements */\n.modal-content .amplify-tabs__item[data-state=\"active\"] *,\n.modal-content .amplify-tabs__item[aria-selected=\"true\"] * {\n  color: var(--purple-700) !important;\n}\n\n/* Override focus states to use purple */\n.modal-content .amplify-tabs__item:focus,\n.modal-content .amplify-tabs__item:focus-visible {\n  border-bottom-color: var(--purple-500) !important;\n  outline-color: var(--purple-500) !important;\n}\n\n/* Ensure any nested tab content uses purple theme */\n.modal-content [data-amplify-authenticator] [data-amplify-router] .amplify-tabs__item[data-state=\"active\"] {\n  color: var(--purple-700) !important;\n  border-bottom-color: var(--purple-500) !important;\n}\n\n/* Remove any top borders, outlines, or blue styling from tabs */\n.modal-content .amplify-tabs__item {\n  border-top: none !important;\n  border-left: none !important;\n  border-right: none !important;\n  outline: none !important;\n}\n\n.modal-content .amplify-tabs__item[data-state=\"active\"],\n.modal-content .amplify-tabs__item[aria-selected=\"true\"] {\n  border-top: none !important;\n  border-left: none !important;\n  border-right: none !important;\n  outline: none !important;\n  box-shadow: none !important;\n}\n\n/* Remove any pseudo-element borders that might create blue lines */\n.modal-content .amplify-tabs__item:before,\n.modal-content .amplify-tabs__item:after,\n.modal-content .amplify-tabs__item[data-state=\"active\"]:before,\n.modal-content .amplify-tabs__item[aria-selected=\"true\"]:before {\n  display: none !important;\n  border: none !important;\n  background: none !important;\n}\n\n\n\n/* Additional containment rules for better layout */\n.modal-content .amplify-authenticator * {\n  box-sizing: border-box !important;\n}\n\n/* Prevent any Amplify containers from overflowing */\n.modal-content [data-amplify-authenticator],\n.modal-content [data-amplify-router],\n.modal-content [data-amplify-authenticator-signin],\n.modal-content [data-amplify-authenticator-signup] {\n  width: 100% !important;\n  max-width: 100% !important;\n  overflow: hidden !important;\n  box-sizing: border-box !important;\n}\n\n/* Remove any default margins or padding that might cause overflow */\n.modal-content [data-amplify-container] * {\n  max-width: 100% !important;\n}\n\n/* Ensure modal content itself doesn't allow horizontal scroll */\n.modal-content:has(.amplify-authenticator) {\n  overflow-x: hidden !important;\n}\n\n/* Target main Amplify containers but not inputs */\n.modal-content div[data-amplify-container] {\n  width: 100% !important;\n  max-width: 100% !important;\n  box-sizing: border-box !important;\n}\n\n/* Ensure tab panels fit within bounds */\n.modal-content .amplify-tabs__panel {\n  width: 100% !important;\n  max-width: 100% !important;\n  overflow: hidden !important;\n  padding: 16px !important;\n}\n\n/* Ensure tab list doesn't overflow */\n.modal-content .amplify-tabs__list {\n  width: 100% !important;\n  max-width: 100% !important;\n  display: flex !important;\n  justify-content: space-around !important;\n}\n\n.modal-content .amplify-tabs__item {\n  flex: 1 !important;\n  text-align: center !important;\n  max-width: 50% !important;\n}\n\n/* Add this to your AuthPopup.css file */\n\n/* Hide password requirements by default */\n.password-requirements {\n  display: none;\n  padding: 16px 20px;\n  background-color: var(--jp-layout-color2);\n  border-top: 1px solid var(--jp-border-color1);\n  font-size: 13px;\n}\n\n/* Show password requirements when sign-up form is present */\n.modal-content:has([data-amplify-authenticator-signup]) .password-requirements {\n  display: block;\n}\n\n/* Style the requirements content */\n.password-requirements p {\n  margin: 0 0 8px 0;\n  font-weight: bold;\n  color: var(--jp-ui-font-color1);\n}\n\n.password-requirements ul {\n  margin: 0;\n  padding-left: 20px;\n  color: var(--jp-ui-font-color2);\n  font-size: 12px;\n}\n\n/* Success message styling */\n.auth-success-message {\n  padding: 32px 24px;\n  text-align: center;\n  background: var(--jp-layout-color0);\n  border-radius: 8px;\n}\n\n.success-icon {\n  margin-bottom: 20px;\n  display: flex;\n  justify-content: center;\n}\n\n.success-title {\n  color: var(--jp-ui-font-color1);\n  font-size: 24px;\n  font-weight: 600;\n  margin: 0 0 12px 0;\n  font-family: var(--jp-ui-font-family);\n}\n\n.success-description {\n  color: var(--jp-ui-font-color1);\n  font-size: 16px;\n  margin: 0 0 16px 0;\n  font-family: var(--jp-ui-font-family);\n  line-height: 1.5;\n}\n\n.success-timer {\n  color: var(--jp-ui-font-color2);\n  font-size: 14px;\n  margin: 0 0 24px 0;\n  font-family: var(--jp-ui-font-family);\n  font-style: italic;\n}\n\n.success-actions {\n  display: flex;\n  justify-content: center;\n  gap: 12px;\n}\n\n/* Progress bar animation */\n@keyframes progressFill {\n  from { width: 0%; }\n  to { width: 100%; }\n}\n\n/* Welcome message container styling */\n.welcome-message-container {\n  border: 1px solid var(--jp-border-color1);\n  border-radius: 8px;\n  padding: 32px 24px;\n  margin: 16px 0;\n  background-color: var(--jp-layout-color0);\n  text-align: center;\n}\n\n/* Welcome message title */\n.welcome-message-title {\n  color: var(--jp-ui-font-color1);\n  font-size: 24px;\n  font-weight: 600;\n  margin: 0 0 12px 0;\n  font-family: var(--jp-ui-font-family);\n}\n\n/* Welcome message description */\n.welcome-message-description {\n  color: var(--jp-ui-font-color1);\n  font-size: 16px;\n  margin: 0 0 16px 0;\n  font-family: var(--jp-ui-font-family);\n  line-height: 1.5;\n}\n\n/* Progress bar container */\n.progress-bar-container {\n  width: 100%;\n  height: 4px;\n  background-color: var(--jp-border-color1);\n  border-radius: 2px;\n  overflow: hidden;\n  margin-top: 20px;\n  margin-bottom: 12px;\n}\n\n/* Progress bar fill with CSS animation */\n.progress-bar-fill {\n  width: 0%;\n  height: 100%;\n  background-color: var(--purple-500);\n  border-radius: 2px;\n  animation: progressFill 3s linear forwards;\n}\n\n/* Progress bar timer text */\n.progress-bar-timer {\n  color: var(--jp-ui-font-color2);\n  font-size: 14px;\n  margin: 0;\n  font-family: var(--jp-ui-font-family);\n  font-style: italic;\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/CTACarousel.css":
/*!*********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/CTACarousel.css ***!
  \*********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.cta-carousel {
    width: 100%;
}

.cta-carousel-container {
    display: flex;
    align-items: center;
    justify-content: center;
    min-height: 100px;
}

.cta-message {
    display: block;
    text-align: center;
    font-size: 14px;
    color: var(--jp-ui-font-color3);
    margin-bottom: 15px;
    flex: 1;
    line-height: 1.3;
    min-height: 2.5em;
    padding: 0 8px;
    opacity: 1;
    transition: opacity 0.5s ease-in-out;
}

.cta-carousel-dots {
    display: flex;
    justify-content: center;
    gap: 8px;
    margin-top: 4px;
}

.cta-carousel-dot {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    background-color: var(--jp-layout-color3);
    cursor: pointer;
    transition: background-color 0.3s ease;
    box-sizing: border-box;
}

.cta-carousel-dot.active {
    background-color: var(--purple-500);
}

.cta-carousel-button {
    margin-top: 8px;
}

.cta-logo-container {
    margin: 0 auto 8px;
    display: block;
    text-align: center;
}

.cta-title {
    display: block;
    text-align: center;
    font-weight: bold;
    font-size: 20px;
    margin-bottom: 15px;
}`, "",{"version":3,"sources":["webpack://./style/CTACarousel.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,WAAW;AACf;;AAEA;IACI,aAAa;IACb,mBAAmB;IACnB,uBAAuB;IACvB,iBAAiB;AACrB;;AAEA;IACI,cAAc;IACd,kBAAkB;IAClB,eAAe;IACf,+BAA+B;IAC/B,mBAAmB;IACnB,OAAO;IACP,gBAAgB;IAChB,iBAAiB;IACjB,cAAc;IACd,UAAU;IACV,oCAAoC;AACxC;;AAEA;IACI,aAAa;IACb,uBAAuB;IACvB,QAAQ;IACR,eAAe;AACnB;;AAEA;IACI,WAAW;IACX,YAAY;IACZ,kBAAkB;IAClB,yCAAyC;IACzC,eAAe;IACf,sCAAsC;IACtC,sBAAsB;AAC1B;;AAEA;IACI,mCAAmC;AACvC;;AAEA;IACI,eAAe;AACnB;;AAEA;IACI,kBAAkB;IAClB,cAAc;IACd,kBAAkB;AACtB;;AAEA;IACI,cAAc;IACd,kBAAkB;IAClB,iBAAiB;IACjB,eAAe;IACf,mBAAmB;AACvB","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.cta-carousel {\n    width: 100%;\n}\n\n.cta-carousel-container {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    min-height: 100px;\n}\n\n.cta-message {\n    display: block;\n    text-align: center;\n    font-size: 14px;\n    color: var(--jp-ui-font-color3);\n    margin-bottom: 15px;\n    flex: 1;\n    line-height: 1.3;\n    min-height: 2.5em;\n    padding: 0 8px;\n    opacity: 1;\n    transition: opacity 0.5s ease-in-out;\n}\n\n.cta-carousel-dots {\n    display: flex;\n    justify-content: center;\n    gap: 8px;\n    margin-top: 4px;\n}\n\n.cta-carousel-dot {\n    width: 12px;\n    height: 12px;\n    border-radius: 50%;\n    background-color: var(--jp-layout-color3);\n    cursor: pointer;\n    transition: background-color 0.3s ease;\n    box-sizing: border-box;\n}\n\n.cta-carousel-dot.active {\n    background-color: var(--purple-500);\n}\n\n.cta-carousel-button {\n    margin-top: 8px;\n}\n\n.cta-logo-container {\n    margin: 0 auto 8px;\n    display: block;\n    text-align: center;\n}\n\n.cta-title {\n    display: block;\n    text-align: center;\n    font-weight: bold;\n    font-size: 20px;\n    margin-bottom: 15px;\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/ChatDropdown.css":
/*!**********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/ChatDropdown.css ***!
  \**********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.chat-dropdown {
  /* Position the dropdown in the right place*/
  position: absolute;
  z-index: 9999;
  bottom: 100%;
  margin-bottom: 5px;

  /* Style the dropdown */
  display: flex;
  flex-direction: column;
  width: 100%;
  border: 1px solid var(--jp-border-color1);
  border-radius: 5px;
}

.chat-dropdown-list {
  position: relative;
  border: 0px;
  border-radius: 5px;
  background-color: var(--jp-layout-color1);
  list-style-type: none;
  padding: 0;
  margin: 0;
  width: 100%;
  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
  overflow-y: auto;
  max-height: 350px;
}

.chat-dropdown-item {
  padding: 8px;
  cursor: pointer;
  display: flex;
  align-items: center;
  gap: 8px;
  color: var(--jp-content-font-color1);
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
}

.chat-dropdown-item:hover,
.chat-dropdown-item.selected {
  background-color: var(--jp-layout-color3);
}

.chat-dropdown-item-type {
  color: var(--jp-brand-color1);
  font-family: var(--jp-code-font-family);
  min-width: 35px;
  width: 35px;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}

.chat-dropdown-item-name {
  font-size: 15px;
  display: flex;
  align-items: center;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}

.chat-dropdown-item-parent-df {
  color: var(--muted-text-color);
  font-size: 12px;
  margin-left: 4px;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}

.dropdown-item-disabled {
  opacity: 0.5;
  cursor: not-allowed;
}

.dropdown-item-disabled:hover {
  background-color: inherit;
}

.chat-dropdown-search {
  padding: 8px;
  background-color: var(--jp-layout-color1);
  border-top-left-radius: 5px;
  border-top-right-radius: 5px;
}

.chat-dropdown-search-input {
  width: 100%;
  padding: 6px 8px;
  border-radius: 3px;
  font-size: 12px;
  font-family: var(--jp-ui-font-family);
  background-color: var(--jp-layout-color1);
  color: var(--jp-content-font-color1);
  outline: none;
  border: none;
  box-sizing: border-box;
}

.chat-dropdown-search-input:focus {
  outline: none;
  border: none;
}

.chat-dropdown-search-input::placeholder {
  color: var(--jp-content-font-color3);
}
`, "",{"version":3,"sources":["webpack://./style/ChatDropdown.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,4CAA4C;EAC5C,kBAAkB;EAClB,aAAa;EACb,YAAY;EACZ,kBAAkB;;EAElB,uBAAuB;EACvB,aAAa;EACb,sBAAsB;EACtB,WAAW;EACX,yCAAyC;EACzC,kBAAkB;AACpB;;AAEA;EACE,kBAAkB;EAClB,WAAW;EACX,kBAAkB;EAClB,yCAAyC;EACzC,qBAAqB;EACrB,UAAU;EACV,SAAS;EACT,WAAW;EACX,wCAAwC;EACxC,gBAAgB;EAChB,iBAAiB;AACnB;;AAEA;EACE,YAAY;EACZ,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,oCAAoC;EACpC,gBAAgB;EAChB,uBAAuB;EACvB,mBAAmB;AACrB;;AAEA;;EAEE,yCAAyC;AAC3C;;AAEA;EACE,6BAA6B;EAC7B,uCAAuC;EACvC,eAAe;EACf,WAAW;EACX,mBAAmB;EACnB,gBAAgB;EAChB,uBAAuB;AACzB;;AAEA;EACE,eAAe;EACf,aAAa;EACb,mBAAmB;EACnB,mBAAmB;EACnB,gBAAgB;EAChB,uBAAuB;AACzB;;AAEA;EACE,8BAA8B;EAC9B,eAAe;EACf,gBAAgB;EAChB,mBAAmB;EACnB,gBAAgB;EAChB,uBAAuB;AACzB;;AAEA;EACE,YAAY;EACZ,mBAAmB;AACrB;;AAEA;EACE,yBAAyB;AAC3B;;AAEA;EACE,YAAY;EACZ,yCAAyC;EACzC,2BAA2B;EAC3B,4BAA4B;AAC9B;;AAEA;EACE,WAAW;EACX,gBAAgB;EAChB,kBAAkB;EAClB,eAAe;EACf,qCAAqC;EACrC,yCAAyC;EACzC,oCAAoC;EACpC,aAAa;EACb,YAAY;EACZ,sBAAsB;AACxB;;AAEA;EACE,aAAa;EACb,YAAY;AACd;;AAEA;EACE,oCAAoC;AACtC","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.chat-dropdown {\n  /* Position the dropdown in the right place*/\n  position: absolute;\n  z-index: 9999;\n  bottom: 100%;\n  margin-bottom: 5px;\n\n  /* Style the dropdown */\n  display: flex;\n  flex-direction: column;\n  width: 100%;\n  border: 1px solid var(--jp-border-color1);\n  border-radius: 5px;\n}\n\n.chat-dropdown-list {\n  position: relative;\n  border: 0px;\n  border-radius: 5px;\n  background-color: var(--jp-layout-color1);\n  list-style-type: none;\n  padding: 0;\n  margin: 0;\n  width: 100%;\n  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);\n  overflow-y: auto;\n  max-height: 350px;\n}\n\n.chat-dropdown-item {\n  padding: 8px;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  color: var(--jp-content-font-color1);\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n\n.chat-dropdown-item:hover,\n.chat-dropdown-item.selected {\n  background-color: var(--jp-layout-color3);\n}\n\n.chat-dropdown-item-type {\n  color: var(--jp-brand-color1);\n  font-family: var(--jp-code-font-family);\n  min-width: 35px;\n  width: 35px;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n.chat-dropdown-item-name {\n  font-size: 15px;\n  display: flex;\n  align-items: center;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n.chat-dropdown-item-parent-df {\n  color: var(--muted-text-color);\n  font-size: 12px;\n  margin-left: 4px;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n.dropdown-item-disabled {\n  opacity: 0.5;\n  cursor: not-allowed;\n}\n\n.dropdown-item-disabled:hover {\n  background-color: inherit;\n}\n\n.chat-dropdown-search {\n  padding: 8px;\n  background-color: var(--jp-layout-color1);\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n}\n\n.chat-dropdown-search-input {\n  width: 100%;\n  padding: 6px 8px;\n  border-radius: 3px;\n  font-size: 12px;\n  font-family: var(--jp-ui-font-family);\n  background-color: var(--jp-layout-color1);\n  color: var(--jp-content-font-color1);\n  outline: none;\n  border: none;\n  box-sizing: border-box;\n}\n\n.chat-dropdown-search-input:focus {\n  outline: none;\n  border: none;\n}\n\n.chat-dropdown-search-input::placeholder {\n  color: var(--jp-content-font-color3);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/ChatInput.css":
/*!*******************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/ChatInput.css ***!
  \*******************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.chat-input-container {
  position: sticky;
  bottom: 0;
  margin: 10px 0;
  margin-top: auto;
  background-color: var(--chat-user-message-background-color);
  box-shadow: 
    0 4px 12px rgba(0, 0, 0, 0.08),
    0 2px 4px rgba(0, 0, 0, 0.06),
    0 0 0 1px rgba(0, 0, 0, 0.02);
  width: 100%;
  border-radius: 12px;
  transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.chat-input-container.editing {
  margin-top: 0;
}

.chat-input-text-area-container {
  position: relative;
  height: min-content;
}

.chat-input {
  outline: none;
  border: none;
  resize: none;
  width: 100%;
  padding: 10px;
  overflow-y: auto;
  box-sizing: border-box;
  flex-shrink: 0 !important;
  background-color: var(--chat-user-message-background-color);
  font-size: 12px;
  font-weight: 400;
  font-family: var(--jp-ui-font-family);
  line-height: 1.2;
  transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
}

.active-cell-preview-container {
  padding: 10px;
}

.chat-input-container:focus-within {
  transform: translateY(-1px);
  box-shadow: 
    0 2px 8px rgba(0, 0, 0, 0.12),
    0 8px 16px rgba(0, 0, 0, 0.08),
    0 0 0 1px rgba(0, 0, 0, 0.04);
}

.chat-input:focus {
  color: var(--jp-ui-font-color1);
}

.chat-input::placeholder {
  color: var(--jp-ui-font-color2);
  transition: color 0.2s ease;
}

.chat-input:focus::placeholder {
  color: var(--jp-ui-font-color3);
}

.context-button {
  display: flex;
  align-items: center;
  background-color: var(--jp-layout-color2);
  border: 1px solid var(--jp-border-color1);
  border-radius: 3px;
  padding: 4px 8px;
  font-size: 12px;
  height: var(--chat-context-button-height);
  cursor: pointer;
  color: var(--jp-content-font-color1);
  transition: background-color 0.2s ease;
}

.context-button:hover {
  background-color: var(--jp-layout-color3);
}

/* Disabled state styles */
.chat-input:disabled {
  opacity: 0.6;
  cursor: not-allowed;
  background-color: var(--jp-layout-color2);
}

.context-button:disabled {
  opacity: 0.6;
  cursor: not-allowed;
  background-color: var(--jp-layout-color2);
}

.context-button:disabled:hover {
  background-color: var(--jp-layout-color2);
}`, "",{"version":3,"sources":["webpack://./style/ChatInput.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,gBAAgB;EAChB,SAAS;EACT,cAAc;EACd,gBAAgB;EAChB,2DAA2D;EAC3D;;;iCAG+B;EAC/B,WAAW;EACX,mBAAmB;EACnB,iDAAiD;AACnD;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,kBAAkB;EAClB,mBAAmB;AACrB;;AAEA;EACE,aAAa;EACb,YAAY;EACZ,YAAY;EACZ,WAAW;EACX,aAAa;EACb,gBAAgB;EAChB,sBAAsB;EACtB,yBAAyB;EACzB,2DAA2D;EAC3D,eAAe;EACf,gBAAgB;EAChB,qCAAqC;EACrC,gBAAgB;EAChB,iDAAiD;AACnD;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,2BAA2B;EAC3B;;;iCAG+B;AACjC;;AAEA;EACE,+BAA+B;AACjC;;AAEA;EACE,+BAA+B;EAC/B,2BAA2B;AAC7B;;AAEA;EACE,+BAA+B;AACjC;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,yCAAyC;EACzC,yCAAyC;EACzC,kBAAkB;EAClB,gBAAgB;EAChB,eAAe;EACf,yCAAyC;EACzC,eAAe;EACf,oCAAoC;EACpC,sCAAsC;AACxC;;AAEA;EACE,yCAAyC;AAC3C;;AAEA,0BAA0B;AAC1B;EACE,YAAY;EACZ,mBAAmB;EACnB,yCAAyC;AAC3C;;AAEA;EACE,YAAY;EACZ,mBAAmB;EACnB,yCAAyC;AAC3C;;AAEA;EACE,yCAAyC;AAC3C","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.chat-input-container {\n  position: sticky;\n  bottom: 0;\n  margin: 10px 0;\n  margin-top: auto;\n  background-color: var(--chat-user-message-background-color);\n  box-shadow: \n    0 4px 12px rgba(0, 0, 0, 0.08),\n    0 2px 4px rgba(0, 0, 0, 0.06),\n    0 0 0 1px rgba(0, 0, 0, 0.02);\n  width: 100%;\n  border-radius: 12px;\n  transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);\n}\n\n.chat-input-container.editing {\n  margin-top: 0;\n}\n\n.chat-input-text-area-container {\n  position: relative;\n  height: min-content;\n}\n\n.chat-input {\n  outline: none;\n  border: none;\n  resize: none;\n  width: 100%;\n  padding: 10px;\n  overflow-y: auto;\n  box-sizing: border-box;\n  flex-shrink: 0 !important;\n  background-color: var(--chat-user-message-background-color);\n  font-size: 12px;\n  font-weight: 400;\n  font-family: var(--jp-ui-font-family);\n  line-height: 1.2;\n  transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);\n}\n\n.active-cell-preview-container {\n  padding: 10px;\n}\n\n.chat-input-container:focus-within {\n  transform: translateY(-1px);\n  box-shadow: \n    0 2px 8px rgba(0, 0, 0, 0.12),\n    0 8px 16px rgba(0, 0, 0, 0.08),\n    0 0 0 1px rgba(0, 0, 0, 0.04);\n}\n\n.chat-input:focus {\n  color: var(--jp-ui-font-color1);\n}\n\n.chat-input::placeholder {\n  color: var(--jp-ui-font-color2);\n  transition: color 0.2s ease;\n}\n\n.chat-input:focus::placeholder {\n  color: var(--jp-ui-font-color3);\n}\n\n.context-button {\n  display: flex;\n  align-items: center;\n  background-color: var(--jp-layout-color2);\n  border: 1px solid var(--jp-border-color1);\n  border-radius: 3px;\n  padding: 4px 8px;\n  font-size: 12px;\n  height: var(--chat-context-button-height);\n  cursor: pointer;\n  color: var(--jp-content-font-color1);\n  transition: background-color 0.2s ease;\n}\n\n.context-button:hover {\n  background-color: var(--jp-layout-color3);\n}\n\n/* Disabled state styles */\n.chat-input:disabled {\n  opacity: 0.6;\n  cursor: not-allowed;\n  background-color: var(--jp-layout-color2);\n}\n\n.context-button:disabled {\n  opacity: 0.6;\n  cursor: not-allowed;\n  background-color: var(--jp-layout-color2);\n}\n\n.context-button:disabled:hover {\n  background-color: var(--jp-layout-color2);\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/ChatMessage.css":
/*!*********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/ChatMessage.css ***!
  \*********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.message {
  position: relative;
  height: min-content;
  box-sizing: border-box;
  width: 100%;
  font-size: 14px;
  border-radius: var(--chat-taskpane-item-border-radius);
  padding: 0 var(--chat-taskpane-item-indent);
}

.message:not(.chat-input) {
  margin-bottom: 20px;
}

.message:hover .message-start-editing-button {
  opacity: 1 !important;
}

.message-user {
  background-color: var(--chat-user-message-background-color);
  color: var(--chat-user-message-font-color);
  padding: 10px;
}

.message-assistant-chat {
  color: var(--chat-assistant-message-font-color);
}

.chat-message-buttons {
  display: flex;
  flex-direction: row;
  gap: 8px;
  margin-top: 10px;
  margin-bottom: 4px;
  flex-wrap: wrap;
}

.chat-taskpane-smart-debug-error-message {
  white-space: pre;
  font-family: monospace;
  margin: 0;
  overflow-x: auto;
}

.message-text {
  align-items: center;
}

/* Message Action Buttons Container */
.message-action-buttons {
  position: absolute;
  bottom: 8px;
  right: 8px;
  display: flex;
  border-radius: 4px;
  overflow: hidden; /* Ensures inner buttons don't break the rounded corners */
}

/* Common styles for action buttons */
.message-action-buttons button,
.message-start-editing-button {
  cursor: pointer;
  opacity: 0;
  transition:
    opacity 0.2s ease-in-out,
    background-color 0.2s ease-in-out;
  background-color: var(--jp-layout-color3);
  border: none;
  display: flex;
  align-items: center;
  justify-content: center;
  color: var(--jp-content-font-color1);
}

/* Action buttons in the group */
.message-action-buttons button {
  width: 28px;
  height: 28px;
  padding: 0;
  border-radius: 0; /* Remove individual button radius */
}

/* Add subtle separator between buttons */
.message-action-buttons button:not(:last-child) {
  border-right: 1px solid var(--jp-border-color1);
}

/* Remove the individual button radius styles since we're handling it at the container level */
.message-action-buttons button:first-child,
.message-action-buttons button:last-child {
  border-radius: 0;
}

/* Standalone edit button */
.message-start-editing-button {
  position: relative;
  padding: 4px;
  border-radius: 4px;
}

/* SVG icon color */
.message-action-buttons button svg {
  color: var(--jp-content-font-color1);
}

/* Hover states */
.message-action-buttons button:hover,
.message-start-editing-button:hover {
  background-color: var(--jp-layout-color4);
}

/* Show buttons on message hover */
.message:hover .message-action-buttons button,
.message:hover .message-start-editing-button {
  opacity: 1;
}

.message-edit-buttons {
  display: flex;
  gap: 8px;
  padding: 5px;
}

.message-edit-buttons button {
  padding: 4px 12px;
  border-radius: 4px;
  background-color: var(--jp-layout-color1);
  color: var(--jp-content-font-color1);
  border: 1px solid var(--jp-border-color1);
  cursor: pointer;
}

.message-edit-buttons button:hover {
  background-color: var(--jp-layout-color2);
}`, "",{"version":3,"sources":["webpack://./style/ChatMessage.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,kBAAkB;EAClB,mBAAmB;EACnB,sBAAsB;EACtB,WAAW;EACX,eAAe;EACf,sDAAsD;EACtD,2CAA2C;AAC7C;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE,qBAAqB;AACvB;;AAEA;EACE,2DAA2D;EAC3D,0CAA0C;EAC1C,aAAa;AACf;;AAEA;EACE,+CAA+C;AACjD;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;EACR,gBAAgB;EAChB,kBAAkB;EAClB,eAAe;AACjB;;AAEA;EACE,gBAAgB;EAChB,sBAAsB;EACtB,SAAS;EACT,gBAAgB;AAClB;;AAEA;EACE,mBAAmB;AACrB;;AAEA,qCAAqC;AACrC;EACE,kBAAkB;EAClB,WAAW;EACX,UAAU;EACV,aAAa;EACb,kBAAkB;EAClB,gBAAgB,EAAE,0DAA0D;AAC9E;;AAEA,qCAAqC;AACrC;;EAEE,eAAe;EACf,UAAU;EACV;;qCAEmC;EACnC,yCAAyC;EACzC,YAAY;EACZ,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,oCAAoC;AACtC;;AAEA,gCAAgC;AAChC;EACE,WAAW;EACX,YAAY;EACZ,UAAU;EACV,gBAAgB,EAAE,oCAAoC;AACxD;;AAEA,yCAAyC;AACzC;EACE,+CAA+C;AACjD;;AAEA,8FAA8F;AAC9F;;EAEE,gBAAgB;AAClB;;AAEA,2BAA2B;AAC3B;EACE,kBAAkB;EAClB,YAAY;EACZ,kBAAkB;AACpB;;AAEA,mBAAmB;AACnB;EACE,oCAAoC;AACtC;;AAEA,iBAAiB;AACjB;;EAEE,yCAAyC;AAC3C;;AAEA,kCAAkC;AAClC;;EAEE,UAAU;AACZ;;AAEA;EACE,aAAa;EACb,QAAQ;EACR,YAAY;AACd;;AAEA;EACE,iBAAiB;EACjB,kBAAkB;EAClB,yCAAyC;EACzC,oCAAoC;EACpC,yCAAyC;EACzC,eAAe;AACjB;;AAEA;EACE,yCAAyC;AAC3C","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.message {\n  position: relative;\n  height: min-content;\n  box-sizing: border-box;\n  width: 100%;\n  font-size: 14px;\n  border-radius: var(--chat-taskpane-item-border-radius);\n  padding: 0 var(--chat-taskpane-item-indent);\n}\n\n.message:not(.chat-input) {\n  margin-bottom: 20px;\n}\n\n.message:hover .message-start-editing-button {\n  opacity: 1 !important;\n}\n\n.message-user {\n  background-color: var(--chat-user-message-background-color);\n  color: var(--chat-user-message-font-color);\n  padding: 10px;\n}\n\n.message-assistant-chat {\n  color: var(--chat-assistant-message-font-color);\n}\n\n.chat-message-buttons {\n  display: flex;\n  flex-direction: row;\n  gap: 8px;\n  margin-top: 10px;\n  margin-bottom: 4px;\n  flex-wrap: wrap;\n}\n\n.chat-taskpane-smart-debug-error-message {\n  white-space: pre;\n  font-family: monospace;\n  margin: 0;\n  overflow-x: auto;\n}\n\n.message-text {\n  align-items: center;\n}\n\n/* Message Action Buttons Container */\n.message-action-buttons {\n  position: absolute;\n  bottom: 8px;\n  right: 8px;\n  display: flex;\n  border-radius: 4px;\n  overflow: hidden; /* Ensures inner buttons don't break the rounded corners */\n}\n\n/* Common styles for action buttons */\n.message-action-buttons button,\n.message-start-editing-button {\n  cursor: pointer;\n  opacity: 0;\n  transition:\n    opacity 0.2s ease-in-out,\n    background-color 0.2s ease-in-out;\n  background-color: var(--jp-layout-color3);\n  border: none;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  color: var(--jp-content-font-color1);\n}\n\n/* Action buttons in the group */\n.message-action-buttons button {\n  width: 28px;\n  height: 28px;\n  padding: 0;\n  border-radius: 0; /* Remove individual button radius */\n}\n\n/* Add subtle separator between buttons */\n.message-action-buttons button:not(:last-child) {\n  border-right: 1px solid var(--jp-border-color1);\n}\n\n/* Remove the individual button radius styles since we're handling it at the container level */\n.message-action-buttons button:first-child,\n.message-action-buttons button:last-child {\n  border-radius: 0;\n}\n\n/* Standalone edit button */\n.message-start-editing-button {\n  position: relative;\n  padding: 4px;\n  border-radius: 4px;\n}\n\n/* SVG icon color */\n.message-action-buttons button svg {\n  color: var(--jp-content-font-color1);\n}\n\n/* Hover states */\n.message-action-buttons button:hover,\n.message-start-editing-button:hover {\n  background-color: var(--jp-layout-color4);\n}\n\n/* Show buttons on message hover */\n.message:hover .message-action-buttons button,\n.message:hover .message-start-editing-button {\n  opacity: 1;\n}\n\n.message-edit-buttons {\n  display: flex;\n  gap: 8px;\n  padding: 5px;\n}\n\n.message-edit-buttons button {\n  padding: 4px 12px;\n  border-radius: 4px;\n  background-color: var(--jp-layout-color1);\n  color: var(--jp-content-font-color1);\n  border: 1px solid var(--jp-border-color1);\n  cursor: pointer;\n}\n\n.message-edit-buttons button:hover {\n  background-color: var(--jp-layout-color2);\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/ChatTaskpane.css":
/*!**********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/ChatTaskpane.css ***!
  \**********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.chat-taskpane {
  display: flex;
  flex-direction: column;
  height: 100%;
  background-color: var(--chat-background-color) !important;
  --jp-sidebar-min-width: 350px;
  width: 100%;
  box-sizing: border-box;
  overflow-y: hidden;
  /* 
        Don't set padding on top from the taskpane so we can instead
        set the padding on the chat-taskpane-header instead to make 
        sure the sticky header covers all of the content behind it. 
    */
  padding-top: 0px;
  padding-left: 10px;
  padding-right: 10px;
  padding-bottom: 10px;
  /*
    'container-type: inline-size' enables container queries on this element.
    This allows child elements to use @container rules to react to the width of .chat-taskpane,
    rather than the viewport.
  */
  container-type: inline-size;
}

.chat-taskpane.disabled button:not(.signup-form-container):not(.signup-form-container *):not(.chat-taskpane-header-left):not(.chat-taskpane-header-left *) {
  opacity: 0.5;
  pointer-events: none;
}

.chat-taskpane.disabled textarea:not(.signup-form-container):not(.signup-form-container *) {
  opacity: 0.5;
  pointer-events: none;
  cursor: not-allowed;
}

.suggestions-container {
  max-width: 600px;
  margin: 0 auto;
  display: flex;
  justify-content: flex-start;
}

.chat-taskpane-header {
  display: flex;
  flex-direction: row;
  justify-content: space-between;
  align-items: center;
  padding-top: 10px;
  padding-bottom: 5px;
  position: sticky;
  /* Make the header sticky */
  top: 0;
  /* Stick to the top of the container */
  background-color: var(--chat-background-color);
  /* Ensure background color covers content behind */
  z-index: 1;
  /* Ensure it stays above other content */
}

.chat-taskpane-header-left {
  display: flex;
  gap: 8px;
}

.chat-taskpane-header-right {
  display: flex;
  gap: 8px;
}

.chat-taskpane-header-title {
  font-size: 14px;
  font-weight: bold;
  margin: 0;
}

.chat-taskpane-header-buttons {
  display: flex;
  gap: 8px;
}

.chat-messages {
  flex: 1;
  overflow-y: auto;
  padding-bottom: 10px;
  display: flex;
  flex-direction: column;
}

.chat-empty-message {
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  height: auto;
  min-height: 200px;
  max-height: 100%;
  text-align: center;
  color: var(--muted-text-color);
  padding: 20px;
  /* Add container query support */
  container-type: inline-size;
  user-select: none;
  overflow-y: hidden;
  margin: auto 0; /* This centers it vertically in the flex container */
}

.chat-empty-message .long-message {
  font-size: 16px;
  line-height: 1.5;
  max-width: 80%;
  margin: 0 auto;
}

/* Use container query instead of media query */
@container (max-width: 300px) {
  .chat-empty-message .long-message {
    display: none;
  }
}

.chat-loading-message {
  margin-top: 20px;
  margin-bottom: 20px;
}

.chat-controls {
  display: flex;
  justify-content: space-between;
  align-items: center;
}

.chat-controls-left {
  display: flex;
  gap: 4px;
  align-items: center;
  justify-content: flex-start;
}
.chat-controls-left > * {
  margin: 0 !important;
}
.submit-button {
  background-color: var(--purple-400);
  color: var(--purple-700);
  padding: 2px 10px;
}

.submit-button:hover {
  background-color: var(--purple-500);
  transition: background-color 0.2s ease-in-out;
}

.stop-agent-button {
  margin-top: 8px;
}

.stop-agent-button-content {
  display: flex;
  text-align: center;
  align-items: center;
  gap: 8px;
  justify-content: center;
}

.agent-controls {
  display: flex;
  gap: 8px;
  width: 100%;
}

.agent-start-button {
  flex: 1;
}

.agent-cancel-button {
  width: 32px;
  padding: 0;
}

/* Add suggestion box container styling */
.chat-suggestions {
  display: flex;
  flex-wrap: nowrap;
  overflow-x: auto;
  gap: 8px;
  padding-bottom: 16px;
  margin: 8px 0;
  /* smooth scrolling on touch devices */
  -webkit-overflow-scrolling: touch;
  /* Mask properties will be applied dynamically through JavaScript */
  mask-size: 100% 100%;
  mask-repeat: no-repeat;
  -webkit-mask-size: 100% 100%;
  -webkit-mask-repeat: no-repeat;
}

/* Add individual suggestion box styling */
.suggestion-box {
  background-color: var(--jp-layout-color1);
  color: var(--jp-ui-font-color1);
  border: 1px solid var(--jp-border-color2);
  border-radius: 16px;
  padding: 6px 12px;
  font-size: 14px;
  cursor: pointer;
  transition: background-color 0.2s ease-in-out;
  flex-shrink: 0;
  /* wrap text onto multiple lines */
  white-space: normal;
  text-align: center;
  /* limit width for wrapping into two lines */
  max-width: 140px;
  /* align content vertically */
  display: inline-flex;
  align-items: center;
  justify-content: center;
}

.suggestion-box:hover {
  background-color: var(--jp-border-color2);
}

/* Hide the 'Submit' text in the submit button when the chat-taskpane is narrow */
@container (max-width: 350px) {
  .submit-button .submit-text {
    display: none;
  }
}
`, "",{"version":3,"sources":["webpack://./style/ChatTaskpane.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,aAAa;EACb,sBAAsB;EACtB,YAAY;EACZ,yDAAyD;EACzD,6BAA6B;EAC7B,WAAW;EACX,sBAAsB;EACtB,kBAAkB;EAClB;;;;KAIG;EACH,gBAAgB;EAChB,kBAAkB;EAClB,mBAAmB;EACnB,oBAAoB;EACpB;;;;GAIC;EACD,2BAA2B;AAC7B;;AAEA;EACE,YAAY;EACZ,oBAAoB;AACtB;;AAEA;EACE,YAAY;EACZ,oBAAoB;EACpB,mBAAmB;AACrB;;AAEA;EACE,gBAAgB;EAChB,cAAc;EACd,aAAa;EACb,2BAA2B;AAC7B;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,mBAAmB;EACnB,iBAAiB;EACjB,mBAAmB;EACnB,gBAAgB;EAChB,2BAA2B;EAC3B,MAAM;EACN,sCAAsC;EACtC,8CAA8C;EAC9C,kDAAkD;EAClD,UAAU;EACV,wCAAwC;AAC1C;;AAEA;EACE,aAAa;EACb,QAAQ;AACV;;AAEA;EACE,aAAa;EACb,QAAQ;AACV;;AAEA;EACE,eAAe;EACf,iBAAiB;EACjB,SAAS;AACX;;AAEA;EACE,aAAa;EACb,QAAQ;AACV;;AAEA;EACE,OAAO;EACP,gBAAgB;EAChB,oBAAoB;EACpB,aAAa;EACb,sBAAsB;AACxB;;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,uBAAuB;EACvB,mBAAmB;EACnB,YAAY;EACZ,iBAAiB;EACjB,gBAAgB;EAChB,kBAAkB;EAClB,8BAA8B;EAC9B,aAAa;EACb,gCAAgC;EAChC,2BAA2B;EAC3B,iBAAiB;EACjB,kBAAkB;EAClB,cAAc,EAAE,qDAAqD;AACvE;;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,cAAc;EACd,cAAc;AAChB;;AAEA,+CAA+C;AAC/C;EACE;IACE,aAAa;EACf;AACF;;AAEA;EACE,gBAAgB;EAChB,mBAAmB;AACrB;;AAEA;EACE,aAAa;EACb,8BAA8B;EAC9B,mBAAmB;AACrB;;AAEA;EACE,aAAa;EACb,QAAQ;EACR,mBAAmB;EACnB,2BAA2B;AAC7B;AACA;EACE,oBAAoB;AACtB;AACA;EACE,mCAAmC;EACnC,wBAAwB;EACxB,iBAAiB;AACnB;;AAEA;EACE,mCAAmC;EACnC,6CAA6C;AAC/C;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,aAAa;EACb,kBAAkB;EAClB,mBAAmB;EACnB,QAAQ;EACR,uBAAuB;AACzB;;AAEA;EACE,aAAa;EACb,QAAQ;EACR,WAAW;AACb;;AAEA;EACE,OAAO;AACT;;AAEA;EACE,WAAW;EACX,UAAU;AACZ;;AAEA,yCAAyC;AACzC;EACE,aAAa;EACb,iBAAiB;EACjB,gBAAgB;EAChB,QAAQ;EACR,oBAAoB;EACpB,aAAa;EACb,sCAAsC;EACtC,iCAAiC;EACjC,mEAAmE;EACnE,oBAAoB;EACpB,sBAAsB;EACtB,4BAA4B;EAC5B,8BAA8B;AAChC;;AAEA,0CAA0C;AAC1C;EACE,yCAAyC;EACzC,+BAA+B;EAC/B,yCAAyC;EACzC,mBAAmB;EACnB,iBAAiB;EACjB,eAAe;EACf,eAAe;EACf,6CAA6C;EAC7C,cAAc;EACd,kCAAkC;EAClC,mBAAmB;EACnB,kBAAkB;EAClB,4CAA4C;EAC5C,gBAAgB;EAChB,6BAA6B;EAC7B,oBAAoB;EACpB,mBAAmB;EACnB,uBAAuB;AACzB;;AAEA;EACE,yCAAyC;AAC3C;;AAEA,iFAAiF;AACjF;EACE;IACE,aAAa;EACf;AACF","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.chat-taskpane {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n  background-color: var(--chat-background-color) !important;\n  --jp-sidebar-min-width: 350px;\n  width: 100%;\n  box-sizing: border-box;\n  overflow-y: hidden;\n  /* \n        Don't set padding on top from the taskpane so we can instead\n        set the padding on the chat-taskpane-header instead to make \n        sure the sticky header covers all of the content behind it. \n    */\n  padding-top: 0px;\n  padding-left: 10px;\n  padding-right: 10px;\n  padding-bottom: 10px;\n  /*\n    'container-type: inline-size' enables container queries on this element.\n    This allows child elements to use @container rules to react to the width of .chat-taskpane,\n    rather than the viewport.\n  */\n  container-type: inline-size;\n}\n\n.chat-taskpane.disabled button:not(.signup-form-container):not(.signup-form-container *):not(.chat-taskpane-header-left):not(.chat-taskpane-header-left *) {\n  opacity: 0.5;\n  pointer-events: none;\n}\n\n.chat-taskpane.disabled textarea:not(.signup-form-container):not(.signup-form-container *) {\n  opacity: 0.5;\n  pointer-events: none;\n  cursor: not-allowed;\n}\n\n.suggestions-container {\n  max-width: 600px;\n  margin: 0 auto;\n  display: flex;\n  justify-content: flex-start;\n}\n\n.chat-taskpane-header {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  align-items: center;\n  padding-top: 10px;\n  padding-bottom: 5px;\n  position: sticky;\n  /* Make the header sticky */\n  top: 0;\n  /* Stick to the top of the container */\n  background-color: var(--chat-background-color);\n  /* Ensure background color covers content behind */\n  z-index: 1;\n  /* Ensure it stays above other content */\n}\n\n.chat-taskpane-header-left {\n  display: flex;\n  gap: 8px;\n}\n\n.chat-taskpane-header-right {\n  display: flex;\n  gap: 8px;\n}\n\n.chat-taskpane-header-title {\n  font-size: 14px;\n  font-weight: bold;\n  margin: 0;\n}\n\n.chat-taskpane-header-buttons {\n  display: flex;\n  gap: 8px;\n}\n\n.chat-messages {\n  flex: 1;\n  overflow-y: auto;\n  padding-bottom: 10px;\n  display: flex;\n  flex-direction: column;\n}\n\n.chat-empty-message {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  height: auto;\n  min-height: 200px;\n  max-height: 100%;\n  text-align: center;\n  color: var(--muted-text-color);\n  padding: 20px;\n  /* Add container query support */\n  container-type: inline-size;\n  user-select: none;\n  overflow-y: hidden;\n  margin: auto 0; /* This centers it vertically in the flex container */\n}\n\n.chat-empty-message .long-message {\n  font-size: 16px;\n  line-height: 1.5;\n  max-width: 80%;\n  margin: 0 auto;\n}\n\n/* Use container query instead of media query */\n@container (max-width: 300px) {\n  .chat-empty-message .long-message {\n    display: none;\n  }\n}\n\n.chat-loading-message {\n  margin-top: 20px;\n  margin-bottom: 20px;\n}\n\n.chat-controls {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n}\n\n.chat-controls-left {\n  display: flex;\n  gap: 4px;\n  align-items: center;\n  justify-content: flex-start;\n}\n.chat-controls-left > * {\n  margin: 0 !important;\n}\n.submit-button {\n  background-color: var(--purple-400);\n  color: var(--purple-700);\n  padding: 2px 10px;\n}\n\n.submit-button:hover {\n  background-color: var(--purple-500);\n  transition: background-color 0.2s ease-in-out;\n}\n\n.stop-agent-button {\n  margin-top: 8px;\n}\n\n.stop-agent-button-content {\n  display: flex;\n  text-align: center;\n  align-items: center;\n  gap: 8px;\n  justify-content: center;\n}\n\n.agent-controls {\n  display: flex;\n  gap: 8px;\n  width: 100%;\n}\n\n.agent-start-button {\n  flex: 1;\n}\n\n.agent-cancel-button {\n  width: 32px;\n  padding: 0;\n}\n\n/* Add suggestion box container styling */\n.chat-suggestions {\n  display: flex;\n  flex-wrap: nowrap;\n  overflow-x: auto;\n  gap: 8px;\n  padding-bottom: 16px;\n  margin: 8px 0;\n  /* smooth scrolling on touch devices */\n  -webkit-overflow-scrolling: touch;\n  /* Mask properties will be applied dynamically through JavaScript */\n  mask-size: 100% 100%;\n  mask-repeat: no-repeat;\n  -webkit-mask-size: 100% 100%;\n  -webkit-mask-repeat: no-repeat;\n}\n\n/* Add individual suggestion box styling */\n.suggestion-box {\n  background-color: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n  border: 1px solid var(--jp-border-color2);\n  border-radius: 16px;\n  padding: 6px 12px;\n  font-size: 14px;\n  cursor: pointer;\n  transition: background-color 0.2s ease-in-out;\n  flex-shrink: 0;\n  /* wrap text onto multiple lines */\n  white-space: normal;\n  text-align: center;\n  /* limit width for wrapping into two lines */\n  max-width: 140px;\n  /* align content vertically */\n  display: inline-flex;\n  align-items: center;\n  justify-content: center;\n}\n\n.suggestion-box:hover {\n  background-color: var(--jp-border-color2);\n}\n\n/* Hide the 'Submit' text in the submit button when the chat-taskpane is narrow */\n@container (max-width: 350px) {\n  .submit-button .submit-text {\n    display: none;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/Citation.css":
/*!******************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/Citation.css ***!
  \******************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.citation-button {
    background-color: var(--purple-400);
    color: var(--purple-700);
    height: 14px;
    width: 14px;
    border-radius: 2px;
    font-size: 12px;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    position: relative;
    top: -0.5em; /* Makes it appear as superscript */
    vertical-align: baseline;
    margin-right: 2px;
}

.citation-button:hover {
    background-color: var(--purple-500);
}`, "",{"version":3,"sources":["webpack://./style/Citation.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,mCAAmC;IACnC,wBAAwB;IACxB,YAAY;IACZ,WAAW;IACX,kBAAkB;IAClB,eAAe;IACf,eAAe;IACf,oBAAoB;IACpB,mBAAmB;IACnB,uBAAuB;IACvB,kBAAkB;IAClB,WAAW,EAAE,mCAAmC;IAChD,wBAAwB;IACxB,iBAAiB;AACrB;;AAEA;IACI,mCAAmC;AACvC","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.citation-button {\n    background-color: var(--purple-400);\n    color: var(--purple-700);\n    height: 14px;\n    width: 14px;\n    border-radius: 2px;\n    font-size: 12px;\n    cursor: pointer;\n    display: inline-flex;\n    align-items: center;\n    justify-content: center;\n    position: relative;\n    top: -0.5em; /* Makes it appear as superscript */\n    vertical-align: baseline;\n    margin-right: 2px;\n}\n\n.citation-button:hover {\n    background-color: var(--purple-500);\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/CodeBlock.css":
/*!*******************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/CodeBlock.css ***!
  \*******************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.code-block-container {
  display: flex;
  flex-direction: column;
  position: relative;
  margin: 10px 0;

  background-color: var(--chat-background-color);
  border-radius: 4px;
  border: 1px solid var(--jp-cell-editor-border-color);
  overflow: hidden;
}

.code-content {
  width: 100%;
  overflow-x: auto;
}

.code-block-toolbar {
  display: flex;
  flex-direction: row;
  align-items: center;
  justify-content: end;

  width: 100%;
  background-color: var(--chat-user-message-background-color);
  border-bottom: 1px solid var(--jp-cell-editor-border-color);
  font-size: 0.8em;
}

.code-location {
  flex-grow: 1;
  margin-left: 5px;
  color: var(--chat-user-message-font-color);
}

.code-block-toolbar button {
  background-color: var(--chat-user-message-background-color);
  border: none;
  border-left: 1px solid var(--jp-cell-editor-border-color);
  border-radius: 0px;

  font-size: 0.8em;
  color: var(--chat-user-message-font-color);
}

.code-block-toolbar button:hover {
  background-color: var(--chat-background-color);
  color: var(--chat-assistant-message-font-color);
}

.active-cell-code-block {
  opacity: 0.7;
}

.active-cell-code-block:hover {
  opacity: 1;
  transition: 0.3s;
}

.code-block-expand-button {
  display: flex;
  justify-content: center;
  align-items: center;
  padding: 4px 0;
  width: 100%;
  background-color: var(--chat-background-color);
  transition: background-color 0.2s;
  cursor: pointer;
}

.code-block-expand-button:hover {
  background-color: rgba(0, 0, 0, 0.05);
}

.code-block-expand-button svg {
  display: block;
  margin: 0;
}

.code-block-expand-button .icon-button {
  background-color: transparent;
}

.agent-mode-toggle {
  cursor: pointer;
  padding: 10px;
  color: var(--jp-ui-font-color2);
  display: flex;
  justify-content: space-between;
  align-items: center;
  border: 1px solid var(--jp-cell-editor-border-color);
  border-radius: 5px;
  transition: background-color 0.2s ease, border-color 0.2s ease;
}

.agent-mode-toggle:hover {
  background-color: var(--jp-layout-color3);
}

.agent-mode-toggle.error-fixup {
  border: none;
}

.agent-mode-toggle.error-fixup.expanded {
  background-color: var(--jp-layout-color2);
}

.agent-mode-toggle-content {
  display: flex;
  align-items: center;
  gap: 10px;
  flex: 1;
  min-width: 0;
}

.agent-mode-toggle-content svg {
  flex-shrink: 0;
}

.agent-mode-toggle svg:last-child {
  flex-shrink: 0;
}

.agent-mode-toggle.expanded {
  border: none;
  border-radius: 5px 5px 0 0;
  background-color: var(--jp-layout-color2);
}

.agent-mode-collapsed {
  border: none;
  margin: 0 0;
}



`, "",{"version":3,"sources":["webpack://./style/CodeBlock.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,aAAa;EACb,sBAAsB;EACtB,kBAAkB;EAClB,cAAc;;EAEd,8CAA8C;EAC9C,kBAAkB;EAClB,oDAAoD;EACpD,gBAAgB;AAClB;;AAEA;EACE,WAAW;EACX,gBAAgB;AAClB;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,mBAAmB;EACnB,oBAAoB;;EAEpB,WAAW;EACX,2DAA2D;EAC3D,2DAA2D;EAC3D,gBAAgB;AAClB;;AAEA;EACE,YAAY;EACZ,gBAAgB;EAChB,0CAA0C;AAC5C;;AAEA;EACE,2DAA2D;EAC3D,YAAY;EACZ,yDAAyD;EACzD,kBAAkB;;EAElB,gBAAgB;EAChB,0CAA0C;AAC5C;;AAEA;EACE,8CAA8C;EAC9C,+CAA+C;AACjD;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,UAAU;EACV,gBAAgB;AAClB;;AAEA;EACE,aAAa;EACb,uBAAuB;EACvB,mBAAmB;EACnB,cAAc;EACd,WAAW;EACX,8CAA8C;EAC9C,iCAAiC;EACjC,eAAe;AACjB;;AAEA;EACE,qCAAqC;AACvC;;AAEA;EACE,cAAc;EACd,SAAS;AACX;;AAEA;EACE,6BAA6B;AAC/B;;AAEA;EACE,eAAe;EACf,aAAa;EACb,+BAA+B;EAC/B,aAAa;EACb,8BAA8B;EAC9B,mBAAmB;EACnB,oDAAoD;EACpD,kBAAkB;EAClB,8DAA8D;AAChE;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,SAAS;EACT,OAAO;EACP,YAAY;AACd;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,YAAY;EACZ,0BAA0B;EAC1B,yCAAyC;AAC3C;;AAEA;EACE,YAAY;EACZ,WAAW;AACb","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.code-block-container {\n  display: flex;\n  flex-direction: column;\n  position: relative;\n  margin: 10px 0;\n\n  background-color: var(--chat-background-color);\n  border-radius: 4px;\n  border: 1px solid var(--jp-cell-editor-border-color);\n  overflow: hidden;\n}\n\n.code-content {\n  width: 100%;\n  overflow-x: auto;\n}\n\n.code-block-toolbar {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n  justify-content: end;\n\n  width: 100%;\n  background-color: var(--chat-user-message-background-color);\n  border-bottom: 1px solid var(--jp-cell-editor-border-color);\n  font-size: 0.8em;\n}\n\n.code-location {\n  flex-grow: 1;\n  margin-left: 5px;\n  color: var(--chat-user-message-font-color);\n}\n\n.code-block-toolbar button {\n  background-color: var(--chat-user-message-background-color);\n  border: none;\n  border-left: 1px solid var(--jp-cell-editor-border-color);\n  border-radius: 0px;\n\n  font-size: 0.8em;\n  color: var(--chat-user-message-font-color);\n}\n\n.code-block-toolbar button:hover {\n  background-color: var(--chat-background-color);\n  color: var(--chat-assistant-message-font-color);\n}\n\n.active-cell-code-block {\n  opacity: 0.7;\n}\n\n.active-cell-code-block:hover {\n  opacity: 1;\n  transition: 0.3s;\n}\n\n.code-block-expand-button {\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  padding: 4px 0;\n  width: 100%;\n  background-color: var(--chat-background-color);\n  transition: background-color 0.2s;\n  cursor: pointer;\n}\n\n.code-block-expand-button:hover {\n  background-color: rgba(0, 0, 0, 0.05);\n}\n\n.code-block-expand-button svg {\n  display: block;\n  margin: 0;\n}\n\n.code-block-expand-button .icon-button {\n  background-color: transparent;\n}\n\n.agent-mode-toggle {\n  cursor: pointer;\n  padding: 10px;\n  color: var(--jp-ui-font-color2);\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  border: 1px solid var(--jp-cell-editor-border-color);\n  border-radius: 5px;\n  transition: background-color 0.2s ease, border-color 0.2s ease;\n}\n\n.agent-mode-toggle:hover {\n  background-color: var(--jp-layout-color3);\n}\n\n.agent-mode-toggle.error-fixup {\n  border: none;\n}\n\n.agent-mode-toggle.error-fixup.expanded {\n  background-color: var(--jp-layout-color2);\n}\n\n.agent-mode-toggle-content {\n  display: flex;\n  align-items: center;\n  gap: 10px;\n  flex: 1;\n  min-width: 0;\n}\n\n.agent-mode-toggle-content svg {\n  flex-shrink: 0;\n}\n\n.agent-mode-toggle svg:last-child {\n  flex-shrink: 0;\n}\n\n.agent-mode-toggle.expanded {\n  border: none;\n  border-radius: 5px 5px 0 0;\n  background-color: var(--jp-layout-color2);\n}\n\n.agent-mode-collapsed {\n  border: none;\n  margin: 0 0;\n}\n\n\n\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/ConnectionForm.css":
/*!************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/ConnectionForm.css ***!
  \************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.modal-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: rgba(0, 0, 0, 0.5);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 1000;
}

.modal-content {
    background: var(--jp-layout-color0);
    border: 1px solid var(--jp-border-color1);
    border-radius: 4px;
    padding: 20px;
    width: 500px;
    max-width: 90%;
    max-height: 90vh;
    overflow-y: auto;
    position: relative;
}

.modal-content-large {
    width: 90%;
}

.modal-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.modal-header h3 {
    margin: 0;
    font-size: 1.2em;
    color: var(--jp-ui-font-color1);
}

.modal-close-button {
    background: none;
    border: none;
    cursor: pointer;
    padding: 4px;
    color: var(--jp-ui-font-color2);
}

.modal-close-button:hover {
    color: var(--jp-ui-font-color1);
}

.form-group {
    margin-bottom: 20px;
    width: 100%;
    box-sizing: border-box;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 500;
    color: var(--jp-ui-font-color1);
}

.form-group input,
.form-group select {
    width: 100%;
    box-sizing: border-box;
    padding: 8px 12px;
    border: 1px solid var(--jp-border-color1);
    border-radius: 4px;
    background: var(--jp-layout-color0);
    color: var(--jp-ui-font-color1);
    font-size: 14px;
    transition: border-color 0.2s;
}

.form-group input:focus,
.form-group select:focus {
    outline: none;
    border-color: var(--purple-500);
    box-shadow: 0 0 0 2px rgba(124, 58, 237, 0.1);
}

.form-group input::placeholder {
    color: var(--jp-ui-font-color3);
}

.form-actions {
    display: flex;
    justify-content: flex-end;
    gap: 12px;
    margin-top: 24px;
    padding-top: 20px;
    border-top: 1px solid var(--jp-border-color1);
}

.form-actions button {
    min-width: 100px;
    padding: 8px 16px;
}

.form-actions button[type="submit"] {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 8px;
}

.error {
    color: var(--jp-error-color1);
    background: var(--jp-error-color3);
    padding: 12px;
    border-radius: 4px;
    margin-bottom: 20px;
    font-size: 14px;
}

.form-info {
    font-size: 12px;
    color: var(--jp-ui-font-color3);
}

.form-info a {
    margin-left: 4px;
    color: var(--purple-700);
    text-decoration: none;
}

.form-info a:hover {
    text-decoration: underline;
} 

.alert-banner {
    background-color: var(--yellow-100);
    border: 1px solid var(--yellow-500);
    border-radius: 4px;
    padding: 12px;
    margin-bottom: 16px;
    font-size: 14px;
    line-height: 1.5;
    color: var(--grey-900);
}`, "",{"version":3,"sources":["webpack://./style/ConnectionForm.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,eAAe;IACf,MAAM;IACN,OAAO;IACP,QAAQ;IACR,SAAS;IACT,oCAAoC;IACpC,aAAa;IACb,uBAAuB;IACvB,mBAAmB;IACnB,aAAa;AACjB;;AAEA;IACI,mCAAmC;IACnC,yCAAyC;IACzC,kBAAkB;IAClB,aAAa;IACb,YAAY;IACZ,cAAc;IACd,gBAAgB;IAChB,gBAAgB;IAChB,kBAAkB;AACtB;;AAEA;IACI,UAAU;AACd;;AAEA;IACI,aAAa;IACb,8BAA8B;IAC9B,mBAAmB;IACnB,mBAAmB;AACvB;;AAEA;IACI,SAAS;IACT,gBAAgB;IAChB,+BAA+B;AACnC;;AAEA;IACI,gBAAgB;IAChB,YAAY;IACZ,eAAe;IACf,YAAY;IACZ,+BAA+B;AACnC;;AAEA;IACI,+BAA+B;AACnC;;AAEA;IACI,mBAAmB;IACnB,WAAW;IACX,sBAAsB;AAC1B;;AAEA;IACI,cAAc;IACd,kBAAkB;IAClB,gBAAgB;IAChB,+BAA+B;AACnC;;AAEA;;IAEI,WAAW;IACX,sBAAsB;IACtB,iBAAiB;IACjB,yCAAyC;IACzC,kBAAkB;IAClB,mCAAmC;IACnC,+BAA+B;IAC/B,eAAe;IACf,6BAA6B;AACjC;;AAEA;;IAEI,aAAa;IACb,+BAA+B;IAC/B,6CAA6C;AACjD;;AAEA;IACI,+BAA+B;AACnC;;AAEA;IACI,aAAa;IACb,yBAAyB;IACzB,SAAS;IACT,gBAAgB;IAChB,iBAAiB;IACjB,6CAA6C;AACjD;;AAEA;IACI,gBAAgB;IAChB,iBAAiB;AACrB;;AAEA;IACI,aAAa;IACb,uBAAuB;IACvB,mBAAmB;IACnB,QAAQ;AACZ;;AAEA;IACI,6BAA6B;IAC7B,kCAAkC;IAClC,aAAa;IACb,kBAAkB;IAClB,mBAAmB;IACnB,eAAe;AACnB;;AAEA;IACI,eAAe;IACf,+BAA+B;AACnC;;AAEA;IACI,gBAAgB;IAChB,wBAAwB;IACxB,qBAAqB;AACzB;;AAEA;IACI,0BAA0B;AAC9B;;AAEA;IACI,mCAAmC;IACnC,mCAAmC;IACnC,kBAAkB;IAClB,aAAa;IACb,mBAAmB;IACnB,eAAe;IACf,gBAAgB;IAChB,sBAAsB;AAC1B","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.modal-overlay {\n    position: fixed;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    background-color: rgba(0, 0, 0, 0.5);\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    z-index: 1000;\n}\n\n.modal-content {\n    background: var(--jp-layout-color0);\n    border: 1px solid var(--jp-border-color1);\n    border-radius: 4px;\n    padding: 20px;\n    width: 500px;\n    max-width: 90%;\n    max-height: 90vh;\n    overflow-y: auto;\n    position: relative;\n}\n\n.modal-content-large {\n    width: 90%;\n}\n\n.modal-header {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    margin-bottom: 20px;\n}\n\n.modal-header h3 {\n    margin: 0;\n    font-size: 1.2em;\n    color: var(--jp-ui-font-color1);\n}\n\n.modal-close-button {\n    background: none;\n    border: none;\n    cursor: pointer;\n    padding: 4px;\n    color: var(--jp-ui-font-color2);\n}\n\n.modal-close-button:hover {\n    color: var(--jp-ui-font-color1);\n}\n\n.form-group {\n    margin-bottom: 20px;\n    width: 100%;\n    box-sizing: border-box;\n}\n\n.form-group label {\n    display: block;\n    margin-bottom: 8px;\n    font-weight: 500;\n    color: var(--jp-ui-font-color1);\n}\n\n.form-group input,\n.form-group select {\n    width: 100%;\n    box-sizing: border-box;\n    padding: 8px 12px;\n    border: 1px solid var(--jp-border-color1);\n    border-radius: 4px;\n    background: var(--jp-layout-color0);\n    color: var(--jp-ui-font-color1);\n    font-size: 14px;\n    transition: border-color 0.2s;\n}\n\n.form-group input:focus,\n.form-group select:focus {\n    outline: none;\n    border-color: var(--purple-500);\n    box-shadow: 0 0 0 2px rgba(124, 58, 237, 0.1);\n}\n\n.form-group input::placeholder {\n    color: var(--jp-ui-font-color3);\n}\n\n.form-actions {\n    display: flex;\n    justify-content: flex-end;\n    gap: 12px;\n    margin-top: 24px;\n    padding-top: 20px;\n    border-top: 1px solid var(--jp-border-color1);\n}\n\n.form-actions button {\n    min-width: 100px;\n    padding: 8px 16px;\n}\n\n.form-actions button[type=\"submit\"] {\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    gap: 8px;\n}\n\n.error {\n    color: var(--jp-error-color1);\n    background: var(--jp-error-color3);\n    padding: 12px;\n    border-radius: 4px;\n    margin-bottom: 20px;\n    font-size: 14px;\n}\n\n.form-info {\n    font-size: 12px;\n    color: var(--jp-ui-font-color3);\n}\n\n.form-info a {\n    margin-left: 4px;\n    color: var(--purple-700);\n    text-decoration: none;\n}\n\n.form-info a:hover {\n    text-decoration: underline;\n} \n\n.alert-banner {\n    background-color: var(--yellow-100);\n    border: 1px solid var(--yellow-500);\n    border-radius: 4px;\n    padding: 12px;\n    margin-bottom: 16px;\n    font-size: 14px;\n    line-height: 1.5;\n    color: var(--grey-900);\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/DatabasePage.css":
/*!**********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/DatabasePage.css ***!
  \**********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.settings-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.header-buttons {
    display: flex;
    gap: 12px;
    align-items: center;
}

.header-buttons .button-base {
    min-width: 120px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 8px 16px;
}

.connections-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

.connection-card {
    background: var(--jp-layout-color0);
    border: 1px solid var(--jp-border-color1);
    border-radius: 8px;
    padding: 16px;
    transition: all 0.2s ease;
    display: flex;
    flex-direction: column;
}

.connection-card:hover {
    border: 1px solid var(--purple-500);
}

.connection-card-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 8px;
}

.connection-alias {
    font-size: 1.2em;
    font-weight: bold;
    color: var(--jp-ui-font-color1);
    margin: 0;
}

.connection-type {
    background: var(--purple-100);
    color: var(--purple-700);
    border-radius: 12px;
    padding: 2px 10px;
    font-size: 0.85em;
    font-weight: 500;
    text-transform: capitalize;
    margin-left: 8px;
}

.connection-divider {
    height: 1px;
    background: var(--jp-border-color2);
    margin: 8px 0 12px 0;
    width: 100%;
}

.connection-details {
    flex-grow: 1;
}

.connection-details p {
    margin: 4px 0;
    font-size: 0.9em;
    color: var(--jp-ui-font-color2);
}

.connection-actions {
    display: flex;
    margin-top: 12px;
    gap: 8px;
}

.connection-actions button {
    padding: 4px 8px;
    font-size: 0.9em;
}

.connection-actions .delete-button {
    color: var(--jp-error-color1);
}

.connection-actions .delete-button:hover {
    background-color: var(--jp-error-color2);
    color: white;
}

.delete-container {
    position: relative;
}

.confirmation-buttons {
    display: flex;
    gap: 8px;
}

/* No connections container styles */
.no-connections-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    min-height: 400px;
    text-align: center;
    padding: 40px 20px;
}

.no-connections-container p {
    font-size: 1.1em;
    color: var(--jp-ui-font-color2);
    margin-bottom: 32px;
    margin-top: 0;
}

.video-tutorial {
    border-radius: 8px;
    display: block;
    border: 1px solid var(--purple-500);
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
    padding: 12px;
}

.video-container iframe {
    border-radius: 8px;
    display: block;
} `, "",{"version":3,"sources":["webpack://./style/DatabasePage.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,aAAa;IACb,8BAA8B;IAC9B,mBAAmB;IACnB,mBAAmB;AACvB;;AAEA;IACI,aAAa;IACb,SAAS;IACT,mBAAmB;AACvB;;AAEA;IACI,gBAAgB;IAChB,YAAY;IACZ,aAAa;IACb,mBAAmB;IACnB,uBAAuB;IACvB,iBAAiB;AACrB;;AAEA;IACI,aAAa;IACb,4DAA4D;IAC5D,SAAS;IACT,gBAAgB;AACpB;;AAEA;IACI,mCAAmC;IACnC,yCAAyC;IACzC,kBAAkB;IAClB,aAAa;IACb,yBAAyB;IACzB,aAAa;IACb,sBAAsB;AAC1B;;AAEA;IACI,mCAAmC;AACvC;;AAEA;IACI,aAAa;IACb,8BAA8B;IAC9B,mBAAmB;IACnB,kBAAkB;AACtB;;AAEA;IACI,gBAAgB;IAChB,iBAAiB;IACjB,+BAA+B;IAC/B,SAAS;AACb;;AAEA;IACI,6BAA6B;IAC7B,wBAAwB;IACxB,mBAAmB;IACnB,iBAAiB;IACjB,iBAAiB;IACjB,gBAAgB;IAChB,0BAA0B;IAC1B,gBAAgB;AACpB;;AAEA;IACI,WAAW;IACX,mCAAmC;IACnC,oBAAoB;IACpB,WAAW;AACf;;AAEA;IACI,YAAY;AAChB;;AAEA;IACI,aAAa;IACb,gBAAgB;IAChB,+BAA+B;AACnC;;AAEA;IACI,aAAa;IACb,gBAAgB;IAChB,QAAQ;AACZ;;AAEA;IACI,gBAAgB;IAChB,gBAAgB;AACpB;;AAEA;IACI,6BAA6B;AACjC;;AAEA;IACI,wCAAwC;IACxC,YAAY;AAChB;;AAEA;IACI,kBAAkB;AACtB;;AAEA;IACI,aAAa;IACb,QAAQ;AACZ;;AAEA,oCAAoC;AACpC;IACI,aAAa;IACb,sBAAsB;IACtB,mBAAmB;IACnB,uBAAuB;IACvB,iBAAiB;IACjB,kBAAkB;IAClB,kBAAkB;AACtB;;AAEA;IACI,gBAAgB;IAChB,+BAA+B;IAC/B,mBAAmB;IACnB,aAAa;AACjB;;AAEA;IACI,kBAAkB;IAClB,cAAc;IACd,mCAAmC;IACnC,mBAAmB;IACnB,yCAAyC;IACzC,aAAa;AACjB;;AAEA;IACI,kBAAkB;IAClB,cAAc;AAClB","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.settings-header {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    margin-bottom: 20px;\n}\n\n.header-buttons {\n    display: flex;\n    gap: 12px;\n    align-items: center;\n}\n\n.header-buttons .button-base {\n    min-width: 120px;\n    height: 32px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    padding: 8px 16px;\n}\n\n.connections-grid {\n    display: grid;\n    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));\n    gap: 20px;\n    margin-top: 20px;\n}\n\n.connection-card {\n    background: var(--jp-layout-color0);\n    border: 1px solid var(--jp-border-color1);\n    border-radius: 8px;\n    padding: 16px;\n    transition: all 0.2s ease;\n    display: flex;\n    flex-direction: column;\n}\n\n.connection-card:hover {\n    border: 1px solid var(--purple-500);\n}\n\n.connection-card-header {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    margin-bottom: 8px;\n}\n\n.connection-alias {\n    font-size: 1.2em;\n    font-weight: bold;\n    color: var(--jp-ui-font-color1);\n    margin: 0;\n}\n\n.connection-type {\n    background: var(--purple-100);\n    color: var(--purple-700);\n    border-radius: 12px;\n    padding: 2px 10px;\n    font-size: 0.85em;\n    font-weight: 500;\n    text-transform: capitalize;\n    margin-left: 8px;\n}\n\n.connection-divider {\n    height: 1px;\n    background: var(--jp-border-color2);\n    margin: 8px 0 12px 0;\n    width: 100%;\n}\n\n.connection-details {\n    flex-grow: 1;\n}\n\n.connection-details p {\n    margin: 4px 0;\n    font-size: 0.9em;\n    color: var(--jp-ui-font-color2);\n}\n\n.connection-actions {\n    display: flex;\n    margin-top: 12px;\n    gap: 8px;\n}\n\n.connection-actions button {\n    padding: 4px 8px;\n    font-size: 0.9em;\n}\n\n.connection-actions .delete-button {\n    color: var(--jp-error-color1);\n}\n\n.connection-actions .delete-button:hover {\n    background-color: var(--jp-error-color2);\n    color: white;\n}\n\n.delete-container {\n    position: relative;\n}\n\n.confirmation-buttons {\n    display: flex;\n    gap: 8px;\n}\n\n/* No connections container styles */\n.no-connections-container {\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    justify-content: center;\n    min-height: 400px;\n    text-align: center;\n    padding: 40px 20px;\n}\n\n.no-connections-container p {\n    font-size: 1.1em;\n    color: var(--jp-ui-font-color2);\n    margin-bottom: 32px;\n    margin-top: 0;\n}\n\n.video-tutorial {\n    border-radius: 8px;\n    display: block;\n    border: 1px solid var(--purple-500);\n    border-radius: 12px;\n    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);\n    padding: 12px;\n}\n\n.video-container iframe {\n    border-radius: 8px;\n    display: block;\n} "],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/DropdownMenu.css":
/*!**********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/DropdownMenu.css ***!
  \**********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.dropdown-container {
  position: relative;
  display: inline-block;
}

.dropdown-menu {
  position: absolute;
  top: calc(100% + 4px);
  z-index: 1000;
  background-color: var(--jp-layout-color1);
  border: 1px solid var(--jp-layout-color2);
  border-radius: 3px;
  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
  display: flex;
  flex-direction: column;
  min-width: 200px;
  white-space: nowrap;
  height: 400px;
  min-width: 225px;
  max-width: 350px;
  overflow-y: auto;
}

/* Left-aligned dropdown */
.dropdown-menu-left {
  left: 0;
  right: auto;
}

/* Right-aligned dropdown */
.dropdown-menu-right {
  right: 0;
  left: auto;
}

.dropdown-item-row {
  display: flex;
  flex-direction: row;
  justify-content: space-between;
  align-items: center;
  gap: 8px;
  padding: 4px 2px;
  padding-right: 20px; /* Add padding to leave space for the scrollbar */
}

.dropdown-item-row:hover {
  background-color: var(--jp-layout-color2);
}

.dropdown-item-main {
  display: flex;
  flex-direction: row;
  align-items: center;
  text-align: left;
  border: none;
  background: none;
  color: var(--jp-ui-font-color1);
  flex: 1;
  overflow: hidden;
  text-overflow: ellipsis;
  cursor: pointer;
}

.dropdown-item-icon {
  width: 20px;
  min-width: 20px;
  height: 20px;
  display: flex;
  align-items: center;
  justify-content: center;
}

.dropdown-item-label {
  padding-left: 3px; /* Add consistent padding */
}

.dropdown-item-disabled {
  opacity: 0.5;
  cursor: default;
}

/* 
  When using Lab Icons, we seem to get an extra div around the svg icon
  This makes sure the svg is aligned properly in that div
*/
.dropdown-item-icon > div, 
.dropdown-item-secondary > div{
  display: flex;
  align-items: center;
}
`, "",{"version":3,"sources":["webpack://./style/DropdownMenu.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,kBAAkB;EAClB,qBAAqB;AACvB;;AAEA;EACE,kBAAkB;EAClB,qBAAqB;EACrB,aAAa;EACb,yCAAyC;EACzC,yCAAyC;EACzC,kBAAkB;EAClB,wCAAwC;EACxC,aAAa;EACb,sBAAsB;EACtB,gBAAgB;EAChB,mBAAmB;EACnB,aAAa;EACb,gBAAgB;EAChB,gBAAgB;EAChB,gBAAgB;AAClB;;AAEA,0BAA0B;AAC1B;EACE,OAAO;EACP,WAAW;AACb;;AAEA,2BAA2B;AAC3B;EACE,QAAQ;EACR,UAAU;AACZ;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,mBAAmB;EACnB,QAAQ;EACR,gBAAgB;EAChB,mBAAmB,EAAE,iDAAiD;AACxE;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,mBAAmB;EACnB,gBAAgB;EAChB,YAAY;EACZ,gBAAgB;EAChB,+BAA+B;EAC/B,OAAO;EACP,gBAAgB;EAChB,uBAAuB;EACvB,eAAe;AACjB;;AAEA;EACE,WAAW;EACX,eAAe;EACf,YAAY;EACZ,aAAa;EACb,mBAAmB;EACnB,uBAAuB;AACzB;;AAEA;EACE,iBAAiB,EAAE,2BAA2B;AAChD;;AAEA;EACE,YAAY;EACZ,eAAe;AACjB;;AAEA;;;CAGC;AACD;;EAEE,aAAa;EACb,mBAAmB;AACrB","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.dropdown-container {\n  position: relative;\n  display: inline-block;\n}\n\n.dropdown-menu {\n  position: absolute;\n  top: calc(100% + 4px);\n  z-index: 1000;\n  background-color: var(--jp-layout-color1);\n  border: 1px solid var(--jp-layout-color2);\n  border-radius: 3px;\n  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);\n  display: flex;\n  flex-direction: column;\n  min-width: 200px;\n  white-space: nowrap;\n  height: 400px;\n  min-width: 225px;\n  max-width: 350px;\n  overflow-y: auto;\n}\n\n/* Left-aligned dropdown */\n.dropdown-menu-left {\n  left: 0;\n  right: auto;\n}\n\n/* Right-aligned dropdown */\n.dropdown-menu-right {\n  right: 0;\n  left: auto;\n}\n\n.dropdown-item-row {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  align-items: center;\n  gap: 8px;\n  padding: 4px 2px;\n  padding-right: 20px; /* Add padding to leave space for the scrollbar */\n}\n\n.dropdown-item-row:hover {\n  background-color: var(--jp-layout-color2);\n}\n\n.dropdown-item-main {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n  text-align: left;\n  border: none;\n  background: none;\n  color: var(--jp-ui-font-color1);\n  flex: 1;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  cursor: pointer;\n}\n\n.dropdown-item-icon {\n  width: 20px;\n  min-width: 20px;\n  height: 20px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n\n.dropdown-item-label {\n  padding-left: 3px; /* Add consistent padding */\n}\n\n.dropdown-item-disabled {\n  opacity: 0.5;\n  cursor: default;\n}\n\n/* \n  When using Lab Icons, we seem to get an extra div around the svg icon\n  This makes sure the svg is aligned properly in that div\n*/\n.dropdown-item-icon > div, \n.dropdown-item-secondary > div{\n  display: flex;\n  align-items: center;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/EditAppDropdown.css":
/*!*************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/EditAppDropdown.css ***!
  \*************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/* UpdateAppDropdown Styles */

.update-app-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    z-index: 1000;
    background-color: var(--jp-layout-color1);
    border: 1px solid var(--jp-border-color1);
    border-radius: 3px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
    min-width: 300px;
    max-width: 500px;
}

.update-app-dropdown-content {
    padding: 12px;
}

.update-app-dropdown-label {
    display: block;
    margin-bottom: 8px;
    font-weight: 500;
    color: var(--jp-ui-font-color1);
    font-size: var(--jp-ui-font-size1);
}

.update-app-dropdown-textarea {
    width: 100%;
    min-height: 100px;
    padding: 8px;
    border: 1px solid var(--jp-border-color1);
    border-radius: 3px;
    font-family: var(--jp-ui-font-family);
    font-size: var(--jp-ui-font-size1);
    resize: vertical;
    box-sizing: border-box;
    background-color: var(--jp-input-background);
    color: var(--jp-ui-font-color1);
}

.update-app-dropdown-buttons {
    display: flex;
    justify-content: flex-end;
    gap: 8px;
    margin-top: 12px;
}

.update-app-dropdown-button {
    padding: 4px 8px;
    border: none;
    border-radius: 3px;
    cursor: pointer;
    font-family: var(--jp-ui-font-family);
    font-size: var(--jp-ui-font-size0);
}

.update-app-dropdown-button-cancel {
    background-color: var(--jp-layout-color2);
    color: var(--jp-ui-font-color1);
}

.update-app-dropdown-button-submit {
    
    background-color: var(--purple-300);
    color: var(--purple-700);
    cursor: pointer;
}

.update-app-dropdown-button-submit.disabled {
    background-color: var(--jp-layout-color2);
    color: var(--jp-ui-font-color2);
    cursor: not-allowed;
}
`, "",{"version":3,"sources":["webpack://./style/EditAppDropdown.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF,6BAA6B;;AAE7B;IACI,kBAAkB;IAClB,SAAS;IACT,OAAO;IACP,aAAa;IACb,yCAAyC;IACzC,yCAAyC;IACzC,kBAAkB;IAClB,yCAAyC;IACzC,gBAAgB;IAChB,gBAAgB;AACpB;;AAEA;IACI,aAAa;AACjB;;AAEA;IACI,cAAc;IACd,kBAAkB;IAClB,gBAAgB;IAChB,+BAA+B;IAC/B,kCAAkC;AACtC;;AAEA;IACI,WAAW;IACX,iBAAiB;IACjB,YAAY;IACZ,yCAAyC;IACzC,kBAAkB;IAClB,qCAAqC;IACrC,kCAAkC;IAClC,gBAAgB;IAChB,sBAAsB;IACtB,4CAA4C;IAC5C,+BAA+B;AACnC;;AAEA;IACI,aAAa;IACb,yBAAyB;IACzB,QAAQ;IACR,gBAAgB;AACpB;;AAEA;IACI,gBAAgB;IAChB,YAAY;IACZ,kBAAkB;IAClB,eAAe;IACf,qCAAqC;IACrC,kCAAkC;AACtC;;AAEA;IACI,yCAAyC;IACzC,+BAA+B;AACnC;;AAEA;;IAEI,mCAAmC;IACnC,wBAAwB;IACxB,eAAe;AACnB;;AAEA;IACI,yCAAyC;IACzC,+BAA+B;IAC/B,mBAAmB;AACvB","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n/* UpdateAppDropdown Styles */\n\n.update-app-dropdown {\n    position: absolute;\n    top: 100%;\n    left: 0;\n    z-index: 1000;\n    background-color: var(--jp-layout-color1);\n    border: 1px solid var(--jp-border-color1);\n    border-radius: 3px;\n    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);\n    min-width: 300px;\n    max-width: 500px;\n}\n\n.update-app-dropdown-content {\n    padding: 12px;\n}\n\n.update-app-dropdown-label {\n    display: block;\n    margin-bottom: 8px;\n    font-weight: 500;\n    color: var(--jp-ui-font-color1);\n    font-size: var(--jp-ui-font-size1);\n}\n\n.update-app-dropdown-textarea {\n    width: 100%;\n    min-height: 100px;\n    padding: 8px;\n    border: 1px solid var(--jp-border-color1);\n    border-radius: 3px;\n    font-family: var(--jp-ui-font-family);\n    font-size: var(--jp-ui-font-size1);\n    resize: vertical;\n    box-sizing: border-box;\n    background-color: var(--jp-input-background);\n    color: var(--jp-ui-font-color1);\n}\n\n.update-app-dropdown-buttons {\n    display: flex;\n    justify-content: flex-end;\n    gap: 8px;\n    margin-top: 12px;\n}\n\n.update-app-dropdown-button {\n    padding: 4px 8px;\n    border: none;\n    border-radius: 3px;\n    cursor: pointer;\n    font-family: var(--jp-ui-font-family);\n    font-size: var(--jp-ui-font-size0);\n}\n\n.update-app-dropdown-button-cancel {\n    background-color: var(--jp-layout-color2);\n    color: var(--jp-ui-font-color1);\n}\n\n.update-app-dropdown-button-submit {\n    \n    background-color: var(--purple-300);\n    color: var(--purple-700);\n    cursor: pointer;\n}\n\n.update-app-dropdown-button-submit.disabled {\n    background-color: var(--jp-layout-color2);\n    color: var(--jp-ui-font-color2);\n    cursor: not-allowed;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/ErrorFixupToolUI.css":
/*!**************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/ErrorFixupToolUI.css ***!
  \**************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.error-fixup-root {
    display: flex;
    flex-direction: column;
    width: 100%;
}

.error-fixup-header {
    padding: 0 var(--chat-taskpane-item-indent);
}

.error-fixup-messages-container {
    margin-left: var(--chat-taskpane-item-indent);
    padding: 0 10px;
    border-left: 1.5px solid var(--jp-cell-editor-border-color);
}

.error-fixup-container {
    display: flex;
    flex-direction: column;
    align-items: stretch;
    justify-content: start;
    background-color: transparent;
    margin: 0 0;
    color: var(--jp-ui-font-color2);
    overflow: hidden;
}

.error-fixup-container.expanded {
    border: 1px solid var(--jp-cell-editor-border-color);
    border-radius: 5px;
    background-color: var(--jp-layout-color2);
    margin-bottom: 5px;
}

.error-fixup-expanded {
    background-color: transparent;
    color: var(--jp-ui-font-color1);
    white-space: pre-wrap;
    word-break: break-word;
    border: none;
    border-radius: 0;
}

.error-fixup-indented-block {
    margin-left: 10px;
    padding-left: 10px;
    border-left: 1px solid var(--jp-ui-font-color3);
}`, "",{"version":3,"sources":["webpack://./style/ErrorFixupToolUI.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,aAAa;IACb,sBAAsB;IACtB,WAAW;AACf;;AAEA;IACI,2CAA2C;AAC/C;;AAEA;IACI,6CAA6C;IAC7C,eAAe;IACf,2DAA2D;AAC/D;;AAEA;IACI,aAAa;IACb,sBAAsB;IACtB,oBAAoB;IACpB,sBAAsB;IACtB,6BAA6B;IAC7B,WAAW;IACX,+BAA+B;IAC/B,gBAAgB;AACpB;;AAEA;IACI,oDAAoD;IACpD,kBAAkB;IAClB,yCAAyC;IACzC,kBAAkB;AACtB;;AAEA;IACI,6BAA6B;IAC7B,+BAA+B;IAC/B,qBAAqB;IACrB,sBAAsB;IACtB,YAAY;IACZ,gBAAgB;AACpB;;AAEA;IACI,iBAAiB;IACjB,kBAAkB;IAClB,+CAA+C;AACnD","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.error-fixup-root {\n    display: flex;\n    flex-direction: column;\n    width: 100%;\n}\n\n.error-fixup-header {\n    padding: 0 var(--chat-taskpane-item-indent);\n}\n\n.error-fixup-messages-container {\n    margin-left: var(--chat-taskpane-item-indent);\n    padding: 0 10px;\n    border-left: 1.5px solid var(--jp-cell-editor-border-color);\n}\n\n.error-fixup-container {\n    display: flex;\n    flex-direction: column;\n    align-items: stretch;\n    justify-content: start;\n    background-color: transparent;\n    margin: 0 0;\n    color: var(--jp-ui-font-color2);\n    overflow: hidden;\n}\n\n.error-fixup-container.expanded {\n    border: 1px solid var(--jp-cell-editor-border-color);\n    border-radius: 5px;\n    background-color: var(--jp-layout-color2);\n    margin-bottom: 5px;\n}\n\n.error-fixup-expanded {\n    background-color: transparent;\n    color: var(--jp-ui-font-color1);\n    white-space: pre-wrap;\n    word-break: break-word;\n    border: none;\n    border-radius: 0;\n}\n\n.error-fixup-indented-block {\n    margin-left: 10px;\n    padding-left: 10px;\n    border-left: 1px solid var(--jp-ui-font-color3);\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/ErrorMimeRendererPlugin.css":
/*!*********************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/ErrorMimeRendererPlugin.css ***!
  \*********************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.error-mime-renderer-container {
  display: flex;
  flex-direction: row;
  justify-content: start;
  align-items: start;
  background-color: var(--jp-rendermime-error-background);
  width: 100%;
}

.error-mime-renderer-button {
  display: flex;
  flex-direction: row;
  justify-content: start;
  align-items: center;

  background-color: var(--jp-error-color3);
  border: var(--jp-error-color0) 1px solid;
  color: var(--jp-error-color0);

  margin: 10px;
  box-sizing: border-box;

  border-radius: 3px;
  font-size: 14px;
}

.error-mime-renderer-button:hover {
  background-color: var(--jp-error-color4);
  cursor: pointer;
}

.error-mime-renderer-button svg {
  margin-right: 5px;
}

.error-mime-renderer-button p {
  margin: 0;
}

.output-block {
  padding: 10px;
  background-color: var(--yellow-500);
  border-radius: 3px;
}

.output-block pre {
  color: var(--yellow-900) !important;
}

.collapse-button {
  background-color: transparent;
  border: none;
  color: var(--yellow-900);
  padding: 0;
  cursor: pointer;
}
`, "",{"version":3,"sources":["webpack://./style/ErrorMimeRendererPlugin.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,aAAa;EACb,mBAAmB;EACnB,sBAAsB;EACtB,kBAAkB;EAClB,uDAAuD;EACvD,WAAW;AACb;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,sBAAsB;EACtB,mBAAmB;;EAEnB,wCAAwC;EACxC,wCAAwC;EACxC,6BAA6B;;EAE7B,YAAY;EACZ,sBAAsB;;EAEtB,kBAAkB;EAClB,eAAe;AACjB;;AAEA;EACE,wCAAwC;EACxC,eAAe;AACjB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,SAAS;AACX;;AAEA;EACE,aAAa;EACb,mCAAmC;EACnC,kBAAkB;AACpB;;AAEA;EACE,mCAAmC;AACrC;;AAEA;EACE,6BAA6B;EAC7B,YAAY;EACZ,wBAAwB;EACxB,UAAU;EACV,eAAe;AACjB","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.error-mime-renderer-container {\n  display: flex;\n  flex-direction: row;\n  justify-content: start;\n  align-items: start;\n  background-color: var(--jp-rendermime-error-background);\n  width: 100%;\n}\n\n.error-mime-renderer-button {\n  display: flex;\n  flex-direction: row;\n  justify-content: start;\n  align-items: center;\n\n  background-color: var(--jp-error-color3);\n  border: var(--jp-error-color0) 1px solid;\n  color: var(--jp-error-color0);\n\n  margin: 10px;\n  box-sizing: border-box;\n\n  border-radius: 3px;\n  font-size: 14px;\n}\n\n.error-mime-renderer-button:hover {\n  background-color: var(--jp-error-color4);\n  cursor: pointer;\n}\n\n.error-mime-renderer-button svg {\n  margin-right: 5px;\n}\n\n.error-mime-renderer-button p {\n  margin: 0;\n}\n\n.output-block {\n  padding: 10px;\n  background-color: var(--yellow-500);\n  border-radius: 3px;\n}\n\n.output-block pre {\n  color: var(--yellow-900) !important;\n}\n\n.collapse-button {\n  background-color: transparent;\n  border: none;\n  color: var(--yellow-900);\n  padding: 0;\n  cursor: pointer;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/FilesSelector.css":
/*!***********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/FilesSelector.css ***!
  \***********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */


.file-list {
  list-style: none;
  padding-left: 0;
  margin: 0;
}

.file-list li {
  margin-bottom: 6px;
}

.modal-footer {
  margin-top: 16px;
  display: flex;
  justify-content: flex-end;
}

.files-selector-submit-button {
  margin-top: 8px;
  background-color: var(--purple-400) !important;
  color: var(--purple-700) !important;
  border: none !important;
  border-radius: 4px !important;
  font-weight: 500 !important;
  padding: 8px 16px !important;
  width: 100% !important;
  max-width: 100% !important;
  box-sizing: border-box !important;
}

.files-selector-submit-button:hover {
  background-color: var(--purple-500) !important;
}

.file-list input[type="checkbox"],
.select-all input[type="checkbox"]{
  transform: scale(1.3);
  margin-right: 6px;
  accent-color: var(--purple-500);
}

.file-list svg {
  color: grey;
  margin-right: 4px;
  vertical-align: middle;
}

.select-all label {
  font-weight: 500;
  display: flex;
  align-items: center;
  gap: 6px;
}

/* Modal header */
.modal-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 8px;
  margin-bottom: 1px;
}

.modal-title {
  margin: 0;
  font-size: 1.2rem;
}


.modal-subtext {
  font-size: 0.7rem;
  color: #555;
  margin: 0;
  font-style: italic;
}

.modal-subheader{
  margin-bottom: 7px;
}

/* Checkbox label for spacing */
.checkbox-label {
  display: flex;
  align-items: center;
  gap: 6px;
}

/* Scrollable file list */
.file-list-scrollable {
  max-height: 300px;
  overflow-y: auto;
  margin-top: 8px;
}

/* File list items */
.file-list {
  list-style: none;
  padding-left: 0;
  margin: 0;
}

/* Select all section */
.files-selector-select-all {
  margin-bottom: 8px;
}
`, "",{"version":3,"sources":["webpack://./style/FilesSelector.css"],"names":[],"mappings":"AAAA;;;EAGE;;;AAGF;EACE,gBAAgB;EAChB,eAAe;EACf,SAAS;AACX;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,gBAAgB;EAChB,aAAa;EACb,yBAAyB;AAC3B;;AAEA;EACE,eAAe;EACf,8CAA8C;EAC9C,mCAAmC;EACnC,uBAAuB;EACvB,6BAA6B;EAC7B,2BAA2B;EAC3B,4BAA4B;EAC5B,sBAAsB;EACtB,0BAA0B;EAC1B,iCAAiC;AACnC;;AAEA;EACE,8CAA8C;AAChD;;AAEA;;EAEE,qBAAqB;EACrB,iBAAiB;EACjB,+BAA+B;AACjC;;AAEA;EACE,WAAW;EACX,iBAAiB;EACjB,sBAAsB;AACxB;;AAEA;EACE,gBAAgB;EAChB,aAAa;EACb,mBAAmB;EACnB,QAAQ;AACV;;AAEA,iBAAiB;AACjB;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,QAAQ;EACR,kBAAkB;AACpB;;AAEA;EACE,SAAS;EACT,iBAAiB;AACnB;;;AAGA;EACE,iBAAiB;EACjB,WAAW;EACX,SAAS;EACT,kBAAkB;AACpB;;AAEA;EACE,kBAAkB;AACpB;;AAEA,+BAA+B;AAC/B;EACE,aAAa;EACb,mBAAmB;EACnB,QAAQ;AACV;;AAEA,yBAAyB;AACzB;EACE,iBAAiB;EACjB,gBAAgB;EAChB,eAAe;AACjB;;AAEA,oBAAoB;AACpB;EACE,gBAAgB;EAChB,eAAe;EACf,SAAS;AACX;;AAEA,uBAAuB;AACvB;EACE,kBAAkB;AACpB","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n\n.file-list {\n  list-style: none;\n  padding-left: 0;\n  margin: 0;\n}\n\n.file-list li {\n  margin-bottom: 6px;\n}\n\n.modal-footer {\n  margin-top: 16px;\n  display: flex;\n  justify-content: flex-end;\n}\n\n.files-selector-submit-button {\n  margin-top: 8px;\n  background-color: var(--purple-400) !important;\n  color: var(--purple-700) !important;\n  border: none !important;\n  border-radius: 4px !important;\n  font-weight: 500 !important;\n  padding: 8px 16px !important;\n  width: 100% !important;\n  max-width: 100% !important;\n  box-sizing: border-box !important;\n}\n\n.files-selector-submit-button:hover {\n  background-color: var(--purple-500) !important;\n}\n\n.file-list input[type=\"checkbox\"],\n.select-all input[type=\"checkbox\"]{\n  transform: scale(1.3);\n  margin-right: 6px;\n  accent-color: var(--purple-500);\n}\n\n.file-list svg {\n  color: grey;\n  margin-right: 4px;\n  vertical-align: middle;\n}\n\n.select-all label {\n  font-weight: 500;\n  display: flex;\n  align-items: center;\n  gap: 6px;\n}\n\n/* Modal header */\n.modal-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  gap: 8px;\n  margin-bottom: 1px;\n}\n\n.modal-title {\n  margin: 0;\n  font-size: 1.2rem;\n}\n\n\n.modal-subtext {\n  font-size: 0.7rem;\n  color: #555;\n  margin: 0;\n  font-style: italic;\n}\n\n.modal-subheader{\n  margin-bottom: 7px;\n}\n\n/* Checkbox label for spacing */\n.checkbox-label {\n  display: flex;\n  align-items: center;\n  gap: 6px;\n}\n\n/* Scrollable file list */\n.file-list-scrollable {\n  max-height: 300px;\n  overflow-y: auto;\n  margin-top: 8px;\n}\n\n/* File list items */\n.file-list {\n  list-style: none;\n  padding-left: 0;\n  margin: 0;\n}\n\n/* Select all section */\n.files-selector-select-all {\n  margin-bottom: 8px;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/IconButton.css":
/*!********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/IconButton.css ***!
  \********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.icon-button {
  display: flex;
  align-items: center;
  text-align: center;
  justify-content: center;
  background-color: transparent;
  border: none;
  cursor: pointer;
  position: relative;
}

.icon-button-hover:hover {
  background-color: var(--jp-layout-color3);
}

.notification-dot {
  position: absolute;
  top: -1px;
  right: 1px;
  width: 8px;
  height: 8px;
  border-radius: 50%;
  border: 1px solid white;
}

.notification-dot-success {
  background-color: var(--green-600);
}

.notification-dot-warning {
  background-color: var(--yellow-600);
}`, "",{"version":3,"sources":["webpack://./style/IconButton.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,aAAa;EACb,mBAAmB;EACnB,kBAAkB;EAClB,uBAAuB;EACvB,6BAA6B;EAC7B,YAAY;EACZ,eAAe;EACf,kBAAkB;AACpB;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,kBAAkB;EAClB,SAAS;EACT,UAAU;EACV,UAAU;EACV,WAAW;EACX,kBAAkB;EAClB,uBAAuB;AACzB;;AAEA;EACE,kCAAkC;AACpC;;AAEA;EACE,mCAAmC;AACrC","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.icon-button {\n  display: flex;\n  align-items: center;\n  text-align: center;\n  justify-content: center;\n  background-color: transparent;\n  border: none;\n  cursor: pointer;\n  position: relative;\n}\n\n.icon-button-hover:hover {\n  background-color: var(--jp-layout-color3);\n}\n\n.notification-dot {\n  position: absolute;\n  top: -1px;\n  right: 1px;\n  width: 8px;\n  height: 8px;\n  border-radius: 50%;\n  border: 1px solid white;\n}\n\n.notification-dot-success {\n  background-color: var(--green-600);\n}\n\n.notification-dot-warning {\n  background-color: var(--yellow-600);\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/MarkdownMessage.css":
/*!*************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/MarkdownMessage.css ***!
  \*************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.markdown-message-part * .jp-RenderedHTMLCommon :not(pre) > code {
    background-color: var(--purple-300);
    color: var(--purple-700);
    border-radius: 3px;
    display: inline-flex;
    align-items: center;
}

/* Ensure long URLs in markdown messages wrap instead of overflowing */
.markdown-message-part a {
    word-break: break-all;
    overflow-wrap: anywhere;
    white-space: pre-line;
}`, "",{"version":3,"sources":["webpack://./style/MarkdownMessage.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,mCAAmC;IACnC,wBAAwB;IACxB,kBAAkB;IAClB,oBAAoB;IACpB,mBAAmB;AACvB;;AAEA,sEAAsE;AACtE;IACI,qBAAqB;IACrB,uBAAuB;IACvB,qBAAqB;AACzB","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.markdown-message-part * .jp-RenderedHTMLCommon :not(pre) > code {\n    background-color: var(--purple-300);\n    color: var(--purple-700);\n    border-radius: 3px;\n    display: inline-flex;\n    align-items: center;\n}\n\n/* Ensure long URLs in markdown messages wrap instead of overflowing */\n.markdown-message-part a {\n    word-break: break-all;\n    overflow-wrap: anywhere;\n    white-space: pre-line;\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/ModelSelector.css":
/*!***********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/ModelSelector.css ***!
  \***********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/* ModelSelector.css - responsive design with compact mode */

.model-selector {
  position: relative;
  flex: 0 0 auto;
  margin: 0 8px;
  height: 20px; /* Match height of other elements */
  display: flex;
  align-items: center; /* Center vertically */
  color: var(--jp-ui-font-color2);
}

.model-selector:hover {
  color: var(--jp-ui-font-color1);
}

.model-selector-dropdown {
  position: relative;
  height: 20px; /* Fixed height to match other elements */
  border-radius: 4px;
  cursor: pointer;
  display: flex;
  align-items: center; /* Ensure content is vertically centered */
  width: min-content;
  max-width: 18ch;
}


.selected-model {
  display: flex;
  align-items: center;
  justify-content: space-between;
  width: 100%;
  height: 100%;
  padding: 0 8px;
  font-size: 12px;
  font-weight: 500;
  line-height: 1;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}

.model-icon {
  display: flex;
  align-items: center;
  justify-content: center;
  width: 14px;
  height: 14px;
  line-height: 1;
}

.dropdown-arrow {
  font-size: 8px;
  transition: transform 0.2s;
  margin-left: 4px;
  flex-shrink: 0; /* Prevent arrow from shrinking */
}

/* Model options dropdown */
.model-options {
  position: absolute;
  bottom: 100%;
  max-height: 180px;
  overflow-y: auto;
  background-color: var(--jp-layout-color1);
  border: 1px solid var(--jp-layout-color2);
  border-radius: 4px;
  margin-bottom: 4px;
  box-shadow: 0 -2px 6px rgba(0, 0, 0, 0.1);
  z-index: 1000;
  width: auto;
}

.model-option {
  padding: 4px 8px;
  font-size: 12px;
  /* Keep this size for readability */
  color: var(--jp-content-font-color1);
  cursor: pointer;
  transition: background-color 0.2s;
  white-space: nowrap;
  /* Prevent text wrapping */
}

.model-option:hover {
  background-color: var(--jp-layout-color2);
  color: var(--purple-700);
}

.model-option.selected {
  background-color: var(--jp-layout-color2);
  color: var(--purple-700);
}

/* When inside chat-controls - ensure proper alignment with other controls */
.chat-controls .model-selector {
  height: 20px;
  display: flex;
  align-items: center;
}

.chat-controls .model-selector-dropdown {
  height: 20px;
  align-self: center;
}

/* Ensure dropdown appears above other elements */
.model-options {
  z-index: 1010;
  /* Higher z-index to ensure visibility */
}

.model-name {
  display: inline-block;
  max-width: 120px;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  vertical-align: bottom;
}

/* On wider screens, show only the name of the model*/
.model-icon {
  display: none;
}

.model-name {
  display: inline;
}

/* On compact screens, show only the icon */
@container (max-width: 260px) {

  /* Shift the dropdown to the left to help prevent right-edge overflow */
  .model-options {
    left: -40px;
  }

  .model-icon {
    display: inline;
  }

  .model-name {
    display: none;
  }
}`, "",{"version":3,"sources":["webpack://./style/ModelSelector.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF,4DAA4D;;AAE5D;EACE,kBAAkB;EAClB,cAAc;EACd,aAAa;EACb,YAAY,EAAE,mCAAmC;EACjD,aAAa;EACb,mBAAmB,EAAE,sBAAsB;EAC3C,+BAA+B;AACjC;;AAEA;EACE,+BAA+B;AACjC;;AAEA;EACE,kBAAkB;EAClB,YAAY,EAAE,yCAAyC;EACvD,kBAAkB;EAClB,eAAe;EACf,aAAa;EACb,mBAAmB,EAAE,0CAA0C;EAC/D,kBAAkB;EAClB,eAAe;AACjB;;;AAGA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,WAAW;EACX,YAAY;EACZ,cAAc;EACd,eAAe;EACf,gBAAgB;EAChB,cAAc;EACd,mBAAmB;EACnB,gBAAgB;EAChB,uBAAuB;AACzB;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,WAAW;EACX,YAAY;EACZ,cAAc;AAChB;;AAEA;EACE,cAAc;EACd,0BAA0B;EAC1B,gBAAgB;EAChB,cAAc,EAAE,iCAAiC;AACnD;;AAEA,2BAA2B;AAC3B;EACE,kBAAkB;EAClB,YAAY;EACZ,iBAAiB;EACjB,gBAAgB;EAChB,yCAAyC;EACzC,yCAAyC;EACzC,kBAAkB;EAClB,kBAAkB;EAClB,yCAAyC;EACzC,aAAa;EACb,WAAW;AACb;;AAEA;EACE,gBAAgB;EAChB,eAAe;EACf,mCAAmC;EACnC,oCAAoC;EACpC,eAAe;EACf,iCAAiC;EACjC,mBAAmB;EACnB,0BAA0B;AAC5B;;AAEA;EACE,yCAAyC;EACzC,wBAAwB;AAC1B;;AAEA;EACE,yCAAyC;EACzC,wBAAwB;AAC1B;;AAEA,4EAA4E;AAC5E;EACE,YAAY;EACZ,aAAa;EACb,mBAAmB;AACrB;;AAEA;EACE,YAAY;EACZ,kBAAkB;AACpB;;AAEA,iDAAiD;AACjD;EACE,aAAa;EACb,wCAAwC;AAC1C;;AAEA;EACE,qBAAqB;EACrB,gBAAgB;EAChB,gBAAgB;EAChB,uBAAuB;EACvB,mBAAmB;EACnB,sBAAsB;AACxB;;AAEA,qDAAqD;AACrD;EACE,aAAa;AACf;;AAEA;EACE,eAAe;AACjB;;AAEA,2CAA2C;AAC3C;;EAEE,uEAAuE;EACvE;IACE,WAAW;EACb;;EAEA;IACE,eAAe;EACjB;;EAEA;IACE,aAAa;EACf;AACF","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n/* ModelSelector.css - responsive design with compact mode */\n\n.model-selector {\n  position: relative;\n  flex: 0 0 auto;\n  margin: 0 8px;\n  height: 20px; /* Match height of other elements */\n  display: flex;\n  align-items: center; /* Center vertically */\n  color: var(--jp-ui-font-color2);\n}\n\n.model-selector:hover {\n  color: var(--jp-ui-font-color1);\n}\n\n.model-selector-dropdown {\n  position: relative;\n  height: 20px; /* Fixed height to match other elements */\n  border-radius: 4px;\n  cursor: pointer;\n  display: flex;\n  align-items: center; /* Ensure content is vertically centered */\n  width: min-content;\n  max-width: 18ch;\n}\n\n\n.selected-model {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  width: 100%;\n  height: 100%;\n  padding: 0 8px;\n  font-size: 12px;\n  font-weight: 500;\n  line-height: 1;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n.model-icon {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  width: 14px;\n  height: 14px;\n  line-height: 1;\n}\n\n.dropdown-arrow {\n  font-size: 8px;\n  transition: transform 0.2s;\n  margin-left: 4px;\n  flex-shrink: 0; /* Prevent arrow from shrinking */\n}\n\n/* Model options dropdown */\n.model-options {\n  position: absolute;\n  bottom: 100%;\n  max-height: 180px;\n  overflow-y: auto;\n  background-color: var(--jp-layout-color1);\n  border: 1px solid var(--jp-layout-color2);\n  border-radius: 4px;\n  margin-bottom: 4px;\n  box-shadow: 0 -2px 6px rgba(0, 0, 0, 0.1);\n  z-index: 1000;\n  width: auto;\n}\n\n.model-option {\n  padding: 4px 8px;\n  font-size: 12px;\n  /* Keep this size for readability */\n  color: var(--jp-content-font-color1);\n  cursor: pointer;\n  transition: background-color 0.2s;\n  white-space: nowrap;\n  /* Prevent text wrapping */\n}\n\n.model-option:hover {\n  background-color: var(--jp-layout-color2);\n  color: var(--purple-700);\n}\n\n.model-option.selected {\n  background-color: var(--jp-layout-color2);\n  color: var(--purple-700);\n}\n\n/* When inside chat-controls - ensure proper alignment with other controls */\n.chat-controls .model-selector {\n  height: 20px;\n  display: flex;\n  align-items: center;\n}\n\n.chat-controls .model-selector-dropdown {\n  height: 20px;\n  align-self: center;\n}\n\n/* Ensure dropdown appears above other elements */\n.model-options {\n  z-index: 1010;\n  /* Higher z-index to ensure visibility */\n}\n\n.model-name {\n  display: inline-block;\n  max-width: 120px;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  vertical-align: bottom;\n}\n\n/* On wider screens, show only the name of the model*/\n.model-icon {\n  display: none;\n}\n\n.model-name {\n  display: inline;\n}\n\n/* On compact screens, show only the icon */\n@container (max-width: 260px) {\n\n  /* Shift the dropdown to the left to help prevent right-edge overflow */\n  .model-options {\n    left: -40px;\n  }\n\n  .model-icon {\n    display: inline;\n  }\n\n  .model-name {\n    display: none;\n  }\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/NextStepsPills.css":
/*!************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/NextStepsPills.css ***!
  \************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.connected-input-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    border-radius: 8px;
}

.next-steps-pills-container {
    display: flex;
    flex-direction: column;
    gap: 8px;
    padding: 8px 20px;
    margin-bottom: 0;
    border-top-left-radius: 12px;
    border-top-right-radius: 12px;
    margin-left: 10px;
    margin-right: 10px;
    align-self: stretch; /* Stretch the container to the width of the parent */
    background-color: var(--chat-user-message-background-color);
    transform: translateY(-10px);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.next-steps-header {
    display: flex;
    align-items: center;
    justify-content: left;
    width: 100%;
    padding: 4px 0;
    cursor: pointer;
    user-select: none;
    gap: 4px;
}

.next-steps-title {
    font-size: 10px;
    font-weight: 400;
    color: var(--jp-ui-font-color2);
    letter-spacing: 0.5px;
}

.next-steps-caret {
    font-size: 10px;
    color: var(--jp-ui-font-color2);
    transition: transform 0.2s cubic-bezier(0.4, 0, 0.2, 1);
    opacity: 0.7;
}

.next-steps-header:hover {
    color: var(--jp-ui-font-color1);
}

.next-steps-caret.expanded {
    transform: rotate(0deg);
}

.next-steps-caret.collapsed {
    transform: rotate(-90deg);
}

.next-steps-header:hover .next-steps-caret {
    opacity: 1;
}

.next-steps-pills-container {
    opacity: 1;
    transform: translateY(0);
}

.next-steps-pills-container.animating-out {
    opacity: 0;
    transform: translateY(-10px) scale(0.95);
    transition: all 0.2s cubic-bezier(0.4, 0, 1, 1);
}

.next-steps-pills-list {
    display: flex;
    flex-direction: column;
    gap: 6px;
    flex: 1;
}

.next-step-pill {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    background: var(--jp-layout-color1);
    border: 1px solid var(--jp-border-color2);
    border-radius: 20px;
    color: var(--jp-ui-font-color2);
    font-size: 12px;
    font-weight: 400;
    cursor: pointer;
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
    opacity: 0;
    transform: translateY(5px) scale(0.9);
    animation: pillSlideIn 0.3s cubic-bezier(0.4, 0, 0.2, 1) forwards;
    white-space: nowrap;
    width: 100%;
    overflow: hidden;
    position: relative;
}

.next-step-pill::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, var(--jp-brand-color3) 0%, rgba(var(--jp-brand-color1), 0.1) 100%);
    border-radius: 20px;
    opacity: 0;
    transition: opacity 0.2s ease;
}

.next-step-pill:hover {
    background: var(--jp-layout-color2);
    transform: translateY(-1px) scale(1.02);
    box-shadow: 0 4px 12px rgba(var(--jp-brand-color1), 0.15);
}

.next-step-pill:hover::before {
    opacity: 1;
}

.next-step-pill:active {
    transform: translateY(0) scale(0.98);
    transition: all 0.1s ease;
}

.next-step-pill-text {
    position: relative;
    z-index: 1;
    line-height: 1.2;
}

.next-step-pill-icon {
    position: relative;
    z-index: 1;
    color: var(--jp-brand-color1);
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
    display: none;
}

.next-step-pill:hover .next-step-pill-icon {
    display: block;
    transform: translateX(2px);
    color: var(--jp-brand-color2);
}

@keyframes pillSlideIn {
    to {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

/* Responsive design for smaller screens */
@media (max-width: 600px) {
    .next-step-pill {
        max-width: 150px;
        font-size: 11px;
        padding: 5px 10px;
    }
    
    .next-steps-pills-container {
        padding: 6px 10px;
        margin-bottom: 6px;
    }
}

/* Animation for when pills are being dismissed */
.next-steps-pills-container.animating-out .next-step-pill {
    animation: pillSlideOut 0.2s cubic-bezier(0.4, 0, 1, 1) backwards;
}

@keyframes pillSlideOut {
    to {
        opacity: 0;
        transform: translateY(-5px) scale(0.8);
    }
} `, "",{"version":3,"sources":["webpack://./style/NextStepsPills.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,aAAa;IACb,sBAAsB;IACtB,mBAAmB;IACnB,kBAAkB;AACtB;;AAEA;IACI,aAAa;IACb,sBAAsB;IACtB,QAAQ;IACR,iBAAiB;IACjB,gBAAgB;IAChB,4BAA4B;IAC5B,6BAA6B;IAC7B,iBAAiB;IACjB,kBAAkB;IAClB,mBAAmB,EAAE,qDAAqD;IAC1E,2DAA2D;IAC3D,4BAA4B;IAC5B,iDAAiD;AACrD;;AAEA;IACI,aAAa;IACb,mBAAmB;IACnB,qBAAqB;IACrB,WAAW;IACX,cAAc;IACd,eAAe;IACf,iBAAiB;IACjB,QAAQ;AACZ;;AAEA;IACI,eAAe;IACf,gBAAgB;IAChB,+BAA+B;IAC/B,qBAAqB;AACzB;;AAEA;IACI,eAAe;IACf,+BAA+B;IAC/B,uDAAuD;IACvD,YAAY;AAChB;;AAEA;IACI,+BAA+B;AACnC;;AAEA;IACI,uBAAuB;AAC3B;;AAEA;IACI,yBAAyB;AAC7B;;AAEA;IACI,UAAU;AACd;;AAEA;IACI,UAAU;IACV,wBAAwB;AAC5B;;AAEA;IACI,UAAU;IACV,wCAAwC;IACxC,+CAA+C;AACnD;;AAEA;IACI,aAAa;IACb,sBAAsB;IACtB,QAAQ;IACR,OAAO;AACX;;AAEA;IACI,oBAAoB;IACpB,mBAAmB;IACnB,QAAQ;IACR,iBAAiB;IACjB,mCAAmC;IACnC,yCAAyC;IACzC,mBAAmB;IACnB,+BAA+B;IAC/B,eAAe;IACf,gBAAgB;IAChB,eAAe;IACf,iDAAiD;IACjD,UAAU;IACV,qCAAqC;IACrC,iEAAiE;IACjE,mBAAmB;IACnB,WAAW;IACX,gBAAgB;IAChB,kBAAkB;AACtB;;AAEA;IACI,WAAW;IACX,kBAAkB;IAClB,MAAM;IACN,OAAO;IACP,QAAQ;IACR,SAAS;IACT,sGAAsG;IACtG,mBAAmB;IACnB,UAAU;IACV,6BAA6B;AACjC;;AAEA;IACI,mCAAmC;IACnC,uCAAuC;IACvC,yDAAyD;AAC7D;;AAEA;IACI,UAAU;AACd;;AAEA;IACI,oCAAoC;IACpC,yBAAyB;AAC7B;;AAEA;IACI,kBAAkB;IAClB,UAAU;IACV,gBAAgB;AACpB;;AAEA;IACI,kBAAkB;IAClB,UAAU;IACV,6BAA6B;IAC7B,iDAAiD;IACjD,aAAa;AACjB;;AAEA;IACI,cAAc;IACd,0BAA0B;IAC1B,6BAA6B;AACjC;;AAEA;IACI;QACI,UAAU;QACV,iCAAiC;IACrC;AACJ;;AAEA,0CAA0C;AAC1C;IACI;QACI,gBAAgB;QAChB,eAAe;QACf,iBAAiB;IACrB;;IAEA;QACI,iBAAiB;QACjB,kBAAkB;IACtB;AACJ;;AAEA,iDAAiD;AACjD;IACI,iEAAiE;AACrE;;AAEA;IACI;QACI,UAAU;QACV,sCAAsC;IAC1C;AACJ","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.connected-input-container {\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    border-radius: 8px;\n}\n\n.next-steps-pills-container {\n    display: flex;\n    flex-direction: column;\n    gap: 8px;\n    padding: 8px 20px;\n    margin-bottom: 0;\n    border-top-left-radius: 12px;\n    border-top-right-radius: 12px;\n    margin-left: 10px;\n    margin-right: 10px;\n    align-self: stretch; /* Stretch the container to the width of the parent */\n    background-color: var(--chat-user-message-background-color);\n    transform: translateY(-10px);\n    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);\n}\n\n.next-steps-header {\n    display: flex;\n    align-items: center;\n    justify-content: left;\n    width: 100%;\n    padding: 4px 0;\n    cursor: pointer;\n    user-select: none;\n    gap: 4px;\n}\n\n.next-steps-title {\n    font-size: 10px;\n    font-weight: 400;\n    color: var(--jp-ui-font-color2);\n    letter-spacing: 0.5px;\n}\n\n.next-steps-caret {\n    font-size: 10px;\n    color: var(--jp-ui-font-color2);\n    transition: transform 0.2s cubic-bezier(0.4, 0, 0.2, 1);\n    opacity: 0.7;\n}\n\n.next-steps-header:hover {\n    color: var(--jp-ui-font-color1);\n}\n\n.next-steps-caret.expanded {\n    transform: rotate(0deg);\n}\n\n.next-steps-caret.collapsed {\n    transform: rotate(-90deg);\n}\n\n.next-steps-header:hover .next-steps-caret {\n    opacity: 1;\n}\n\n.next-steps-pills-container {\n    opacity: 1;\n    transform: translateY(0);\n}\n\n.next-steps-pills-container.animating-out {\n    opacity: 0;\n    transform: translateY(-10px) scale(0.95);\n    transition: all 0.2s cubic-bezier(0.4, 0, 1, 1);\n}\n\n.next-steps-pills-list {\n    display: flex;\n    flex-direction: column;\n    gap: 6px;\n    flex: 1;\n}\n\n.next-step-pill {\n    display: inline-flex;\n    align-items: center;\n    gap: 6px;\n    padding: 6px 12px;\n    background: var(--jp-layout-color1);\n    border: 1px solid var(--jp-border-color2);\n    border-radius: 20px;\n    color: var(--jp-ui-font-color2);\n    font-size: 12px;\n    font-weight: 400;\n    cursor: pointer;\n    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);\n    opacity: 0;\n    transform: translateY(5px) scale(0.9);\n    animation: pillSlideIn 0.3s cubic-bezier(0.4, 0, 0.2, 1) forwards;\n    white-space: nowrap;\n    width: 100%;\n    overflow: hidden;\n    position: relative;\n}\n\n.next-step-pill::before {\n    content: '';\n    position: absolute;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    background: linear-gradient(135deg, var(--jp-brand-color3) 0%, rgba(var(--jp-brand-color1), 0.1) 100%);\n    border-radius: 20px;\n    opacity: 0;\n    transition: opacity 0.2s ease;\n}\n\n.next-step-pill:hover {\n    background: var(--jp-layout-color2);\n    transform: translateY(-1px) scale(1.02);\n    box-shadow: 0 4px 12px rgba(var(--jp-brand-color1), 0.15);\n}\n\n.next-step-pill:hover::before {\n    opacity: 1;\n}\n\n.next-step-pill:active {\n    transform: translateY(0) scale(0.98);\n    transition: all 0.1s ease;\n}\n\n.next-step-pill-text {\n    position: relative;\n    z-index: 1;\n    line-height: 1.2;\n}\n\n.next-step-pill-icon {\n    position: relative;\n    z-index: 1;\n    color: var(--jp-brand-color1);\n    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);\n    display: none;\n}\n\n.next-step-pill:hover .next-step-pill-icon {\n    display: block;\n    transform: translateX(2px);\n    color: var(--jp-brand-color2);\n}\n\n@keyframes pillSlideIn {\n    to {\n        opacity: 1;\n        transform: translateY(0) scale(1);\n    }\n}\n\n/* Responsive design for smaller screens */\n@media (max-width: 600px) {\n    .next-step-pill {\n        max-width: 150px;\n        font-size: 11px;\n        padding: 5px 10px;\n    }\n    \n    .next-steps-pills-container {\n        padding: 6px 10px;\n        margin-bottom: 6px;\n    }\n}\n\n/* Animation for when pills are being dismissed */\n.next-steps-pills-container.animating-out .next-step-pill {\n    animation: pillSlideOut 0.2s cubic-bezier(0.4, 0, 1, 1) backwards;\n}\n\n@keyframes pillSlideOut {\n    to {\n        opacity: 0;\n        transform: translateY(-5px) scale(0.8);\n    }\n} "],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/NotebookFooter.css":
/*!************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/NotebookFooter.css ***!
  \************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/* Main container */
.notebook-footer-container {
    position: relative;
    width: 100%;
    padding: 12px 16px;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 12px;
}

/* Input container */
.input-container {
    width: 80%;
    max-width: 600px;
}

/* Input wrapper */
.input-wrapper {
    display: flex;
    align-items: center;
    background: var(--jp-layout-color1);
    border: 1px solid var(--jp-border-color2);
    border-radius: 12px;
    padding: 8px 10px;
    gap: 12px;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: 
        0 2px 8px rgba(0, 0, 0, 0.1),
        0 1px 3px rgba(0, 0, 0, 0.08),
        inset 0 1px 0 rgba(255, 255, 255, 0.1);
    position: relative;
    overflow: hidden;
}

.input-wrapper::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: var(--jp-layout-color0);
    opacity: 0;
    transition: opacity 0.3s ease;
    pointer-events: none;
}

.input-wrapper:hover {
    transform: translateY(-1px);
    box-shadow: 
        0 4px 12px rgba(0, 0, 0, 0.15),
        0 2px 6px rgba(0, 0, 0, 0.1),
        inset 0 1px 0 rgba(255, 255, 255, 0.15);
}

.input-wrapper:hover::before {
    opacity: 1;
}

.input-wrapper:focus-within {
    border-color: var(--purple-500);
    box-shadow: 
        0 4px 16px rgba(0, 0, 0, 0.15),
        0 2px 8px rgba(0, 0, 0, 0.1),
        0 0 0 3px rgba(147, 51, 234, 0.1),
        inset 0 1px 0 rgba(255, 255, 255, 0.2);
    transform: translateY(-2px);
}

.input-wrapper:focus-within::before {
    opacity: 1;
}

/* Left icon */
.input-icon-left {
    font-size: 18px;
    color: var(--jp-ui-font-color2);
    display: flex;
    align-items: center;
    transition: all 0.3s ease;
    filter: drop-shadow(0 1px 2px rgba(0, 0, 0, 0.1));
    font-weight: 500;
}

.input-wrapper:focus-within .input-icon-left {
    color: var(--purple-600);
    transform: scale(1.1);
}

.input-wrapper:hover .input-icon-left,
.input-wrapper:hover .input-action-button,
.input-wrapper.generating .input-icon-left,
.input-wrapper.generating .input-action-button {
    color: var(--purple-500);
    transform: scale(1.05);
}

/* Input field */
.prompt-input {
    flex: 1;
    border: none;
    outline: none;
    background: transparent;
    font-size: 13px;
    font-weight: 400;
    line-height: 1.4;
    font-family: var(--jp-ui-font-family);
    color: var(--jp-ui-font-color1);
    padding: 6px 0;
    transition: all 0.3s ease;
    position: relative;
    z-index: 1;
}

.prompt-input::placeholder {
    color: var(--jp-ui-font-color2);
    font-weight: 400;
}

.prompt-input:focus {
    color: var(--jp-ui-font-color0);
}

/* Input action buttons */
.input-action-button {
    width: 32px;
    height: 32px;
    border: none;
    border-radius: 50%;
    background: transparent;
    color: var(--jp-ui-font-color2);
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
    font-weight: 600;
    transition: all 0.2s ease;
}

.input-action-button:hover:not(:disabled) {
    transform: scale(1.1);
}

.input-action-button:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
    color: var(--jp-ui-font-color2);
}

/* Right icons container */
.input-icons-right {
    display: flex;
    align-items: center;
    gap: 4px;
}

/* Button row */
.button-row {
    display: flex;
    flex-direction: row;
    align-items: stretch;
    justify-content: center;
    background: var(--jp-layout-color1);
    border: 1px solid var(--jp-border-color2);
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.03);
    transition: all 0.2s ease;
}

.button-row:hover {
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.06);
    border-color: var(--jp-border-color2);
}

/* Footer buttons */
.footer-button {
    min-width: 80px;
    padding: 10px 14px;
    font-size: 12px;
    font-weight: 400;
    line-height: 1.3;
    font-family: var(--jp-ui-font-family);
    cursor: pointer;
    transition: all 0.2s ease;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 4px;
    box-sizing: border-box;
    position: relative;
    color: var(--jp-ui-font-color1);
}

.footer-button:not(:last-child)::after {
    content: '';
    position: absolute;
    right: 0;
    top: 30%;
    bottom: 30%;
    width: 1px;
    background: var(--jp-border-color1);
    opacity: 0.6;
}

.jp-ThemedContainer .button-row button {
    border: none;
    background: transparent;
    border-radius: 0;
    position: relative;
    overflow: hidden;
    height: 100%;
}

.jp-ThemedContainer .button-row button::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255, 255, 255, 0.02);
    opacity: 0;
    transition: opacity 0.2s ease;
}

.jp-ThemedContainer .button-row button:hover {
    background: var(--jp-layout-color2);
}

.jp-ThemedContainer .button-row button:hover::before {
    opacity: 1;
}

/* Button content */
.button-content {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 4px;
    transition: all 0.2s ease;
}

.footer-button:hover .button-content {
    transform: none;
}

/* Button icon */
.button-icon {
    height: 16px;
    width: 16px;
    line-height: 1;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--jp-ui-font-color2);
    transition: color 0.2s ease;
}

/* Button label */
.button-label {
    margin-top: 1px;
    font-size: 10px;
    line-height: 1.2;
    color: var(--jp-ui-font-color2);
    transition: color 0.2s ease;
}

.footer-button:hover .button-icon,
.footer-button:hover .button-label {
    color: var(--purple-500);
}

/* Cell info */
.cell-info {
    font-size: 12px;
    font-weight: 400;
    line-height: 1.4;
    color: var(--jp-ui-font-color2);
    font-family: var(--jp-ui-font-family);
    text-align: center;
    padding: 4px 8px;
    background: rgba(var(--jp-ui-font-color3), 0.05);
    border-radius: 6px;
    backdrop-filter: blur(4px);
}`, "",{"version":3,"sources":["webpack://./style/NotebookFooter.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF,mBAAmB;AACnB;IACI,kBAAkB;IAClB,WAAW;IACX,kBAAkB;IAClB,aAAa;IACb,sBAAsB;IACtB,mBAAmB;IACnB,SAAS;AACb;;AAEA,oBAAoB;AACpB;IACI,UAAU;IACV,gBAAgB;AACpB;;AAEA,kBAAkB;AAClB;IACI,aAAa;IACb,mBAAmB;IACnB,mCAAmC;IACnC,yCAAyC;IACzC,mBAAmB;IACnB,iBAAiB;IACjB,SAAS;IACT,iDAAiD;IACjD;;;8CAG0C;IAC1C,kBAAkB;IAClB,gBAAgB;AACpB;;AAEA;IACI,WAAW;IACX,kBAAkB;IAClB,MAAM;IACN,OAAO;IACP,QAAQ;IACR,SAAS;IACT,mCAAmC;IACnC,UAAU;IACV,6BAA6B;IAC7B,oBAAoB;AACxB;;AAEA;IACI,2BAA2B;IAC3B;;;+CAG2C;AAC/C;;AAEA;IACI,UAAU;AACd;;AAEA;IACI,+BAA+B;IAC/B;;;;8CAI0C;IAC1C,2BAA2B;AAC/B;;AAEA;IACI,UAAU;AACd;;AAEA,cAAc;AACd;IACI,eAAe;IACf,+BAA+B;IAC/B,aAAa;IACb,mBAAmB;IACnB,yBAAyB;IACzB,iDAAiD;IACjD,gBAAgB;AACpB;;AAEA;IACI,wBAAwB;IACxB,qBAAqB;AACzB;;AAEA;;;;IAII,wBAAwB;IACxB,sBAAsB;AAC1B;;AAEA,gBAAgB;AAChB;IACI,OAAO;IACP,YAAY;IACZ,aAAa;IACb,uBAAuB;IACvB,eAAe;IACf,gBAAgB;IAChB,gBAAgB;IAChB,qCAAqC;IACrC,+BAA+B;IAC/B,cAAc;IACd,yBAAyB;IACzB,kBAAkB;IAClB,UAAU;AACd;;AAEA;IACI,+BAA+B;IAC/B,gBAAgB;AACpB;;AAEA;IACI,+BAA+B;AACnC;;AAEA,yBAAyB;AACzB;IACI,WAAW;IACX,YAAY;IACZ,YAAY;IACZ,kBAAkB;IAClB,uBAAuB;IACvB,+BAA+B;IAC/B,eAAe;IACf,aAAa;IACb,mBAAmB;IACnB,uBAAuB;IACvB,eAAe;IACf,gBAAgB;IAChB,yBAAyB;AAC7B;;AAEA;IACI,qBAAqB;AACzB;;AAEA;IACI,YAAY;IACZ,mBAAmB;IACnB,eAAe;IACf,+BAA+B;AACnC;;AAEA,0BAA0B;AAC1B;IACI,aAAa;IACb,mBAAmB;IACnB,QAAQ;AACZ;;AAEA,eAAe;AACf;IACI,aAAa;IACb,mBAAmB;IACnB,oBAAoB;IACpB,uBAAuB;IACvB,mCAAmC;IACnC,yCAAyC;IACzC,kBAAkB;IAClB,gBAAgB;IAChB,yCAAyC;IACzC,yBAAyB;AAC7B;;AAEA;IACI,yCAAyC;IACzC,qCAAqC;AACzC;;AAEA,mBAAmB;AACnB;IACI,eAAe;IACf,kBAAkB;IAClB,eAAe;IACf,gBAAgB;IAChB,gBAAgB;IAChB,qCAAqC;IACrC,eAAe;IACf,yBAAyB;IACzB,aAAa;IACb,sBAAsB;IACtB,mBAAmB;IACnB,QAAQ;IACR,sBAAsB;IACtB,kBAAkB;IAClB,+BAA+B;AACnC;;AAEA;IACI,WAAW;IACX,kBAAkB;IAClB,QAAQ;IACR,QAAQ;IACR,WAAW;IACX,UAAU;IACV,mCAAmC;IACnC,YAAY;AAChB;;AAEA;IACI,YAAY;IACZ,uBAAuB;IACvB,gBAAgB;IAChB,kBAAkB;IAClB,gBAAgB;IAChB,YAAY;AAChB;;AAEA;IACI,WAAW;IACX,kBAAkB;IAClB,MAAM;IACN,OAAO;IACP,QAAQ;IACR,SAAS;IACT,qCAAqC;IACrC,UAAU;IACV,6BAA6B;AACjC;;AAEA;IACI,mCAAmC;AACvC;;AAEA;IACI,UAAU;AACd;;AAEA,mBAAmB;AACnB;IACI,aAAa;IACb,sBAAsB;IACtB,mBAAmB;IACnB,QAAQ;IACR,yBAAyB;AAC7B;;AAEA;IACI,eAAe;AACnB;;AAEA,gBAAgB;AAChB;IACI,YAAY;IACZ,WAAW;IACX,cAAc;IACd,aAAa;IACb,mBAAmB;IACnB,uBAAuB;IACvB,+BAA+B;IAC/B,2BAA2B;AAC/B;;AAEA,iBAAiB;AACjB;IACI,eAAe;IACf,eAAe;IACf,gBAAgB;IAChB,+BAA+B;IAC/B,2BAA2B;AAC/B;;AAEA;;IAEI,wBAAwB;AAC5B;;AAEA,cAAc;AACd;IACI,eAAe;IACf,gBAAgB;IAChB,gBAAgB;IAChB,+BAA+B;IAC/B,qCAAqC;IACrC,kBAAkB;IAClB,gBAAgB;IAChB,gDAAgD;IAChD,kBAAkB;IAClB,0BAA0B;AAC9B","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n/* Main container */\n.notebook-footer-container {\n    position: relative;\n    width: 100%;\n    padding: 12px 16px;\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    gap: 12px;\n}\n\n/* Input container */\n.input-container {\n    width: 80%;\n    max-width: 600px;\n}\n\n/* Input wrapper */\n.input-wrapper {\n    display: flex;\n    align-items: center;\n    background: var(--jp-layout-color1);\n    border: 1px solid var(--jp-border-color2);\n    border-radius: 12px;\n    padding: 8px 10px;\n    gap: 12px;\n    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);\n    box-shadow: \n        0 2px 8px rgba(0, 0, 0, 0.1),\n        0 1px 3px rgba(0, 0, 0, 0.08),\n        inset 0 1px 0 rgba(255, 255, 255, 0.1);\n    position: relative;\n    overflow: hidden;\n}\n\n.input-wrapper::before {\n    content: '';\n    position: absolute;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    background: var(--jp-layout-color0);\n    opacity: 0;\n    transition: opacity 0.3s ease;\n    pointer-events: none;\n}\n\n.input-wrapper:hover {\n    transform: translateY(-1px);\n    box-shadow: \n        0 4px 12px rgba(0, 0, 0, 0.15),\n        0 2px 6px rgba(0, 0, 0, 0.1),\n        inset 0 1px 0 rgba(255, 255, 255, 0.15);\n}\n\n.input-wrapper:hover::before {\n    opacity: 1;\n}\n\n.input-wrapper:focus-within {\n    border-color: var(--purple-500);\n    box-shadow: \n        0 4px 16px rgba(0, 0, 0, 0.15),\n        0 2px 8px rgba(0, 0, 0, 0.1),\n        0 0 0 3px rgba(147, 51, 234, 0.1),\n        inset 0 1px 0 rgba(255, 255, 255, 0.2);\n    transform: translateY(-2px);\n}\n\n.input-wrapper:focus-within::before {\n    opacity: 1;\n}\n\n/* Left icon */\n.input-icon-left {\n    font-size: 18px;\n    color: var(--jp-ui-font-color2);\n    display: flex;\n    align-items: center;\n    transition: all 0.3s ease;\n    filter: drop-shadow(0 1px 2px rgba(0, 0, 0, 0.1));\n    font-weight: 500;\n}\n\n.input-wrapper:focus-within .input-icon-left {\n    color: var(--purple-600);\n    transform: scale(1.1);\n}\n\n.input-wrapper:hover .input-icon-left,\n.input-wrapper:hover .input-action-button,\n.input-wrapper.generating .input-icon-left,\n.input-wrapper.generating .input-action-button {\n    color: var(--purple-500);\n    transform: scale(1.05);\n}\n\n/* Input field */\n.prompt-input {\n    flex: 1;\n    border: none;\n    outline: none;\n    background: transparent;\n    font-size: 13px;\n    font-weight: 400;\n    line-height: 1.4;\n    font-family: var(--jp-ui-font-family);\n    color: var(--jp-ui-font-color1);\n    padding: 6px 0;\n    transition: all 0.3s ease;\n    position: relative;\n    z-index: 1;\n}\n\n.prompt-input::placeholder {\n    color: var(--jp-ui-font-color2);\n    font-weight: 400;\n}\n\n.prompt-input:focus {\n    color: var(--jp-ui-font-color0);\n}\n\n/* Input action buttons */\n.input-action-button {\n    width: 32px;\n    height: 32px;\n    border: none;\n    border-radius: 50%;\n    background: transparent;\n    color: var(--jp-ui-font-color2);\n    cursor: pointer;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    font-size: 16px;\n    font-weight: 600;\n    transition: all 0.2s ease;\n}\n\n.input-action-button:hover:not(:disabled) {\n    transform: scale(1.1);\n}\n\n.input-action-button:disabled {\n    opacity: 0.6;\n    cursor: not-allowed;\n    transform: none;\n    color: var(--jp-ui-font-color2);\n}\n\n/* Right icons container */\n.input-icons-right {\n    display: flex;\n    align-items: center;\n    gap: 4px;\n}\n\n/* Button row */\n.button-row {\n    display: flex;\n    flex-direction: row;\n    align-items: stretch;\n    justify-content: center;\n    background: var(--jp-layout-color1);\n    border: 1px solid var(--jp-border-color2);\n    border-radius: 8px;\n    overflow: hidden;\n    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.03);\n    transition: all 0.2s ease;\n}\n\n.button-row:hover {\n    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.06);\n    border-color: var(--jp-border-color2);\n}\n\n/* Footer buttons */\n.footer-button {\n    min-width: 80px;\n    padding: 10px 14px;\n    font-size: 12px;\n    font-weight: 400;\n    line-height: 1.3;\n    font-family: var(--jp-ui-font-family);\n    cursor: pointer;\n    transition: all 0.2s ease;\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    gap: 4px;\n    box-sizing: border-box;\n    position: relative;\n    color: var(--jp-ui-font-color1);\n}\n\n.footer-button:not(:last-child)::after {\n    content: '';\n    position: absolute;\n    right: 0;\n    top: 30%;\n    bottom: 30%;\n    width: 1px;\n    background: var(--jp-border-color1);\n    opacity: 0.6;\n}\n\n.jp-ThemedContainer .button-row button {\n    border: none;\n    background: transparent;\n    border-radius: 0;\n    position: relative;\n    overflow: hidden;\n    height: 100%;\n}\n\n.jp-ThemedContainer .button-row button::before {\n    content: '';\n    position: absolute;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    background: rgba(255, 255, 255, 0.02);\n    opacity: 0;\n    transition: opacity 0.2s ease;\n}\n\n.jp-ThemedContainer .button-row button:hover {\n    background: var(--jp-layout-color2);\n}\n\n.jp-ThemedContainer .button-row button:hover::before {\n    opacity: 1;\n}\n\n/* Button content */\n.button-content {\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    gap: 4px;\n    transition: all 0.2s ease;\n}\n\n.footer-button:hover .button-content {\n    transform: none;\n}\n\n/* Button icon */\n.button-icon {\n    height: 16px;\n    width: 16px;\n    line-height: 1;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    color: var(--jp-ui-font-color2);\n    transition: color 0.2s ease;\n}\n\n/* Button label */\n.button-label {\n    margin-top: 1px;\n    font-size: 10px;\n    line-height: 1.2;\n    color: var(--jp-ui-font-color2);\n    transition: color 0.2s ease;\n}\n\n.footer-button:hover .button-icon,\n.footer-button:hover .button-label {\n    color: var(--purple-500);\n}\n\n/* Cell info */\n.cell-info {\n    font-size: 12px;\n    font-weight: 400;\n    line-height: 1.4;\n    color: var(--jp-ui-font-color2);\n    font-family: var(--jp-ui-font-family);\n    text-align: center;\n    padding: 4px 8px;\n    background: rgba(var(--jp-ui-font-color3), 0.05);\n    border-radius: 6px;\n    backdrop-filter: blur(4px);\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/ProfilerPage.css":
/*!**********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/ProfilerPage.css ***!
  \**********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.profiler-warning {
    color: red;
}

.profiler-button-container {
    display: flex;
    gap: 10px;
    margin-bottom: 10px;
}

.json-container {
    overflow-y: auto;
    padding: 10px;
    background-color: var(--jp-input-background);
}

.profiler-clear-button {
    margin-bottom: 10px;
}

.profiler-no-requests {
    color: #666;
    font-style: italic;
}

.profiler-request-container {
    margin-bottom: 20px;
}

.profiler-request-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 5px;
}

.profiler-copy-button {
    font-size: 12px;
    padding: 4px 8px;
}

`, "",{"version":3,"sources":["webpack://./style/ProfilerPage.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,UAAU;AACd;;AAEA;IACI,aAAa;IACb,SAAS;IACT,mBAAmB;AACvB;;AAEA;IACI,gBAAgB;IAChB,aAAa;IACb,4CAA4C;AAChD;;AAEA;IACI,mBAAmB;AACvB;;AAEA;IACI,WAAW;IACX,kBAAkB;AACtB;;AAEA;IACI,mBAAmB;AACvB;;AAEA;IACI,aAAa;IACb,8BAA8B;IAC9B,mBAAmB;IACnB,kBAAkB;AACtB;;AAEA;IACI,eAAe;IACf,gBAAgB;AACpB","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.profiler-warning {\n    color: red;\n}\n\n.profiler-button-container {\n    display: flex;\n    gap: 10px;\n    margin-bottom: 10px;\n}\n\n.json-container {\n    overflow-y: auto;\n    padding: 10px;\n    background-color: var(--jp-input-background);\n}\n\n.profiler-clear-button {\n    margin-bottom: 10px;\n}\n\n.profiler-no-requests {\n    color: #666;\n    font-style: italic;\n}\n\n.profiler-request-container {\n    margin-bottom: 20px;\n}\n\n.profiler-request-header {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    margin-bottom: 5px;\n}\n\n.profiler-copy-button {\n    font-size: 12px;\n    padding: 4px 8px;\n}\n\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/PythonCode.css":
/*!********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/PythonCode.css ***!
  \********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.code-block-python-code pre {
  flex-grow: 1;
  height: 100%;
  width: 100%;
  margin: 0 !important;
  padding: 10px !important;
  font-size: 12px !important;
  overflow-x: auto;
}

.code-block-python-code code {
  white-space: pre !important;
}

.code-block-python-code .jp-RenderedHTMLCommon {
  /* Remove default Jupyter padding */
  padding-right: 0px !important;
}

.code-block-python-code .jp-RenderedHTMLCommon>*:last-child {
  /* 
        Remove the default Jupyter ending margin 
        so that the rendered code is flush with the bottom
        of the CodeMessagePart
    */
  margin-bottom: 0px;
}`, "",{"version":3,"sources":["webpack://./style/PythonCode.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,YAAY;EACZ,YAAY;EACZ,WAAW;EACX,oBAAoB;EACpB,wBAAwB;EACxB,0BAA0B;EAC1B,gBAAgB;AAClB;;AAEA;EACE,2BAA2B;AAC7B;;AAEA;EACE,mCAAmC;EACnC,6BAA6B;AAC/B;;AAEA;EACE;;;;KAIG;EACH,kBAAkB;AACpB","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.code-block-python-code pre {\n  flex-grow: 1;\n  height: 100%;\n  width: 100%;\n  margin: 0 !important;\n  padding: 10px !important;\n  font-size: 12px !important;\n  overflow-x: auto;\n}\n\n.code-block-python-code code {\n  white-space: pre !important;\n}\n\n.code-block-python-code .jp-RenderedHTMLCommon {\n  /* Remove default Jupyter padding */\n  padding-right: 0px !important;\n}\n\n.code-block-python-code .jp-RenderedHTMLCommon>*:last-child {\n  /* \n        Remove the default Jupyter ending margin \n        so that the rendered code is flush with the bottom\n        of the CodeMessagePart\n    */\n  margin-bottom: 0px;\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/RevertQuestionnaire.css":
/*!*****************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/RevertQuestionnaire.css ***!
  \*****************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.revert-questionnaire-message {
    display: flex;
    flex-direction: column;
    gap: 2px;
    padding: 12px 16px;
    margin: 8px 8px;
    border-radius: 12px;
    background-color: var(--chat-user-message-background-color);
    border: 1px solid var(--jp-border-color2);
    box-sizing: border-box;
    width: calc(100% - 16px);
    max-width: calc(100vw - 32px);
}

.revert-questionnaire-message-text {
    font-size: 12px;
    color: var(--jp-ui-font-color1);
    margin-bottom: 20px;
    word-wrap: break-word;
    overflow-wrap: break-word;
    max-width: 100%;
}

.revert-questionnaire-button {
    display: inline-flex;
    align-items: center;
    justify-content: space-between;
    gap: 8px;
    padding: 8px 12px;
    background: var(--jp-layout-color1);
    border: 1px solid var(--jp-border-color2);
    border-radius: 20px;
    color: var(--jp-ui-font-color2);
    font-size: 12px;
    cursor: pointer;
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
    text-align: left;
    width: 100%;
    overflow: hidden;
    position: relative;
    margin-bottom: 6px;
    box-sizing: border-box;
    word-wrap: break-word;
    overflow-wrap: break-word;
    white-space: normal;
    min-height: 36px;
    max-width: 100%;
}

.revert-questionnaire-button::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, var(--jp-brand-color3) 0%, rgba(var(--jp-brand-color1), 0.1) 100%);
    border-radius: 20px;
    opacity: 0;
    transition: opacity 0.2s ease;
}

.revert-questionnaire-button:hover {
    background: var(--jp-layout-color2);
    transform: translateY(-1px) scale(1.02);
    box-shadow: 0 4px 12px rgba(var(--jp-brand-color1), 0.15);
    border-color: var(--jp-brand-color1);
}

.revert-questionnaire-button:hover::before {
    opacity: 1;
}

.revert-questionnaire-button:active {
    transform: translateY(0) scale(0.98);
    transition: all 0.1s ease;
}

.revert-questionnaire-button::after {
    content: '→';
    color: var(--jp-brand-color1);
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
    opacity: 0;
    transform: translateX(-4px);
    flex-shrink: 0;
    margin-left: auto;
}

.revert-questionnaire-button:hover::after {
    opacity: 1;
    transform: translateX(0);
}`, "",{"version":3,"sources":["webpack://./style/RevertQuestionnaire.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,aAAa;IACb,sBAAsB;IACtB,QAAQ;IACR,kBAAkB;IAClB,eAAe;IACf,mBAAmB;IACnB,2DAA2D;IAC3D,yCAAyC;IACzC,sBAAsB;IACtB,wBAAwB;IACxB,6BAA6B;AACjC;;AAEA;IACI,eAAe;IACf,+BAA+B;IAC/B,mBAAmB;IACnB,qBAAqB;IACrB,yBAAyB;IACzB,eAAe;AACnB;;AAEA;IACI,oBAAoB;IACpB,mBAAmB;IACnB,8BAA8B;IAC9B,QAAQ;IACR,iBAAiB;IACjB,mCAAmC;IACnC,yCAAyC;IACzC,mBAAmB;IACnB,+BAA+B;IAC/B,eAAe;IACf,eAAe;IACf,iDAAiD;IACjD,gBAAgB;IAChB,WAAW;IACX,gBAAgB;IAChB,kBAAkB;IAClB,kBAAkB;IAClB,sBAAsB;IACtB,qBAAqB;IACrB,yBAAyB;IACzB,mBAAmB;IACnB,gBAAgB;IAChB,eAAe;AACnB;;AAEA;IACI,WAAW;IACX,kBAAkB;IAClB,MAAM;IACN,OAAO;IACP,QAAQ;IACR,SAAS;IACT,sGAAsG;IACtG,mBAAmB;IACnB,UAAU;IACV,6BAA6B;AACjC;;AAEA;IACI,mCAAmC;IACnC,uCAAuC;IACvC,yDAAyD;IACzD,oCAAoC;AACxC;;AAEA;IACI,UAAU;AACd;;AAEA;IACI,oCAAoC;IACpC,yBAAyB;AAC7B;;AAEA;IACI,YAAY;IACZ,6BAA6B;IAC7B,iDAAiD;IACjD,UAAU;IACV,2BAA2B;IAC3B,cAAc;IACd,iBAAiB;AACrB;;AAEA;IACI,UAAU;IACV,wBAAwB;AAC5B","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.revert-questionnaire-message {\n    display: flex;\n    flex-direction: column;\n    gap: 2px;\n    padding: 12px 16px;\n    margin: 8px 8px;\n    border-radius: 12px;\n    background-color: var(--chat-user-message-background-color);\n    border: 1px solid var(--jp-border-color2);\n    box-sizing: border-box;\n    width: calc(100% - 16px);\n    max-width: calc(100vw - 32px);\n}\n\n.revert-questionnaire-message-text {\n    font-size: 12px;\n    color: var(--jp-ui-font-color1);\n    margin-bottom: 20px;\n    word-wrap: break-word;\n    overflow-wrap: break-word;\n    max-width: 100%;\n}\n\n.revert-questionnaire-button {\n    display: inline-flex;\n    align-items: center;\n    justify-content: space-between;\n    gap: 8px;\n    padding: 8px 12px;\n    background: var(--jp-layout-color1);\n    border: 1px solid var(--jp-border-color2);\n    border-radius: 20px;\n    color: var(--jp-ui-font-color2);\n    font-size: 12px;\n    cursor: pointer;\n    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);\n    text-align: left;\n    width: 100%;\n    overflow: hidden;\n    position: relative;\n    margin-bottom: 6px;\n    box-sizing: border-box;\n    word-wrap: break-word;\n    overflow-wrap: break-word;\n    white-space: normal;\n    min-height: 36px;\n    max-width: 100%;\n}\n\n.revert-questionnaire-button::before {\n    content: '';\n    position: absolute;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    background: linear-gradient(135deg, var(--jp-brand-color3) 0%, rgba(var(--jp-brand-color1), 0.1) 100%);\n    border-radius: 20px;\n    opacity: 0;\n    transition: opacity 0.2s ease;\n}\n\n.revert-questionnaire-button:hover {\n    background: var(--jp-layout-color2);\n    transform: translateY(-1px) scale(1.02);\n    box-shadow: 0 4px 12px rgba(var(--jp-brand-color1), 0.15);\n    border-color: var(--jp-brand-color1);\n}\n\n.revert-questionnaire-button:hover::before {\n    opacity: 1;\n}\n\n.revert-questionnaire-button:active {\n    transform: translateY(0) scale(0.98);\n    transition: all 0.1s ease;\n}\n\n.revert-questionnaire-button::after {\n    content: '→';\n    color: var(--jp-brand-color1);\n    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);\n    opacity: 0;\n    transform: translateX(-4px);\n    flex-shrink: 0;\n    margin-left: auto;\n}\n\n.revert-questionnaire-button:hover::after {\n    opacity: 1;\n    transform: translateX(0);\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/RulesForm.css":
/*!*******************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/RulesForm.css ***!
  \*******************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.rules-form textarea {
    width: 100%;
    box-sizing: border-box;
    padding: 8px 12px;
    border: 1px solid var(--jp-border-color1);
    border-radius: 4px;
    background: var(--jp-layout-color0);
    color: var(--jp-ui-font-color1);
    font-size: 14px;
    transition: border-color 0.2s;
    font-family: var(--jp-ui-font-family);
    resize: vertical;
    min-height: 120px;
}

.rules-form textarea:focus {
    outline: none;
    border-color: var(--purple-500);
    box-shadow: 0 0 0 2px rgba(124, 58, 237, 0.1);
}

.rules-form .form-group sub {
    color: var(--jp-ui-font-color2);
    margin-top: 4px;
    margin-bottom: 4px;
    display: block;
}

/* Rules List Styling */
.rules-list {
    margin-top: 24px;
    display: flex;
    flex-direction: column;
    gap: 16px;
}

.rules-list .rule-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 20px;
    border: 1px solid var(--jp-border-color1);
    border-radius: 8px;
    background: var(--jp-layout-color0);
    transition: border-color 0.2s, box-shadow 0.2s;
    cursor: pointer;
}

.rules-list .rule-item:hover {
    border-color: var(--jp-border-color2);
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
}

.rules-list .rule-content {
    flex: 1;
    margin-right: 16px;
}

.rules-list .rule-name {
    margin: 0 0 8px 0;
    color: var(--jp-ui-font-color1);
    font-size: 14px;
    font-weight: 500;
    line-height: 1;
}

.rules-list .rule-description {
    margin: 0;
    color: var(--jp-ui-font-color2);
    font-size: 14px;
    line-height: 1.5;
}

.rules-list .rule-actions {
    display: flex;
    gap: 8px;
}

.rules-list .empty-state {
    text-align: center;
    padding: 40px 20px;
    color: var(--jp-ui-font-color2);
    font-style: italic;
}

.rules-list .empty-state p {
    margin: 0;
    font-size: 16px;
}
`, "",{"version":3,"sources":["webpack://./style/RulesForm.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,WAAW;IACX,sBAAsB;IACtB,iBAAiB;IACjB,yCAAyC;IACzC,kBAAkB;IAClB,mCAAmC;IACnC,+BAA+B;IAC/B,eAAe;IACf,6BAA6B;IAC7B,qCAAqC;IACrC,gBAAgB;IAChB,iBAAiB;AACrB;;AAEA;IACI,aAAa;IACb,+BAA+B;IAC/B,6CAA6C;AACjD;;AAEA;IACI,+BAA+B;IAC/B,eAAe;IACf,kBAAkB;IAClB,cAAc;AAClB;;AAEA,uBAAuB;AACvB;IACI,gBAAgB;IAChB,aAAa;IACb,sBAAsB;IACtB,SAAS;AACb;;AAEA;IACI,aAAa;IACb,8BAA8B;IAC9B,mBAAmB;IACnB,aAAa;IACb,yCAAyC;IACzC,kBAAkB;IAClB,mCAAmC;IACnC,8CAA8C;IAC9C,eAAe;AACnB;;AAEA;IACI,qCAAqC;IACrC,wCAAwC;AAC5C;;AAEA;IACI,OAAO;IACP,kBAAkB;AACtB;;AAEA;IACI,iBAAiB;IACjB,+BAA+B;IAC/B,eAAe;IACf,gBAAgB;IAChB,cAAc;AAClB;;AAEA;IACI,SAAS;IACT,+BAA+B;IAC/B,eAAe;IACf,gBAAgB;AACpB;;AAEA;IACI,aAAa;IACb,QAAQ;AACZ;;AAEA;IACI,kBAAkB;IAClB,kBAAkB;IAClB,+BAA+B;IAC/B,kBAAkB;AACtB;;AAEA;IACI,SAAS;IACT,eAAe;AACnB","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.rules-form textarea {\n    width: 100%;\n    box-sizing: border-box;\n    padding: 8px 12px;\n    border: 1px solid var(--jp-border-color1);\n    border-radius: 4px;\n    background: var(--jp-layout-color0);\n    color: var(--jp-ui-font-color1);\n    font-size: 14px;\n    transition: border-color 0.2s;\n    font-family: var(--jp-ui-font-family);\n    resize: vertical;\n    min-height: 120px;\n}\n\n.rules-form textarea:focus {\n    outline: none;\n    border-color: var(--purple-500);\n    box-shadow: 0 0 0 2px rgba(124, 58, 237, 0.1);\n}\n\n.rules-form .form-group sub {\n    color: var(--jp-ui-font-color2);\n    margin-top: 4px;\n    margin-bottom: 4px;\n    display: block;\n}\n\n/* Rules List Styling */\n.rules-list {\n    margin-top: 24px;\n    display: flex;\n    flex-direction: column;\n    gap: 16px;\n}\n\n.rules-list .rule-item {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    padding: 20px;\n    border: 1px solid var(--jp-border-color1);\n    border-radius: 8px;\n    background: var(--jp-layout-color0);\n    transition: border-color 0.2s, box-shadow 0.2s;\n    cursor: pointer;\n}\n\n.rules-list .rule-item:hover {\n    border-color: var(--jp-border-color2);\n    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);\n}\n\n.rules-list .rule-content {\n    flex: 1;\n    margin-right: 16px;\n}\n\n.rules-list .rule-name {\n    margin: 0 0 8px 0;\n    color: var(--jp-ui-font-color1);\n    font-size: 14px;\n    font-weight: 500;\n    line-height: 1;\n}\n\n.rules-list .rule-description {\n    margin: 0;\n    color: var(--jp-ui-font-color2);\n    font-size: 14px;\n    line-height: 1.5;\n}\n\n.rules-list .rule-actions {\n    display: flex;\n    gap: 8px;\n}\n\n.rules-list .empty-state {\n    text-align: center;\n    padding: 40px 20px;\n    color: var(--jp-ui-font-color2);\n    font-style: italic;\n}\n\n.rules-list .empty-state p {\n    margin: 0;\n    font-size: 16px;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/SelectedContextContainer.css":
/*!**********************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/SelectedContextContainer.css ***!
  \**********************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.context-container {
  display: flex;
  flex-wrap: wrap;
  align-items: center;
  gap: 4px;
  padding: 8px 10px;
  overflow-x: hidden;
}

/* Consistent spacing for all children of context container */
.context-container>* {
  margin: 2px;
}

.selected-context-container {
  display: flex;
  align-items: center;
  text-align: center;
  background-color: var(--jp-layout-color2);
  border-radius: 3px;
  padding: 4px 8px;
  margin: 2px;

  font-size: 12px;
  height: 20px;
  max-width: 100%;
  min-width: 0;

  border: 1px solid var(--jp-border-color1);
  cursor: pointer;
}

.selected-context-container:hover {
  background-color: var(--jp-layout-color3);
}

.selected-context-container .rule-name {
  margin-left: 6px;
  color: var(--jp-content-font-color1);
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
  max-width: 200px;
}

.selected-context-container .icon {
  display: flex;
  flex-direction: column;
  justify-content: center;
  width: 12px;
  max-height: 14px;
  color: var(--jp-content-font-color3);
}`, "",{"version":3,"sources":["webpack://./style/SelectedContextContainer.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,aAAa;EACb,eAAe;EACf,mBAAmB;EACnB,QAAQ;EACR,iBAAiB;EACjB,kBAAkB;AACpB;;AAEA,6DAA6D;AAC7D;EACE,WAAW;AACb;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,kBAAkB;EAClB,yCAAyC;EACzC,kBAAkB;EAClB,gBAAgB;EAChB,WAAW;;EAEX,eAAe;EACf,YAAY;EACZ,eAAe;EACf,YAAY;;EAEZ,yCAAyC;EACzC,eAAe;AACjB;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,gBAAgB;EAChB,oCAAoC;EACpC,mBAAmB;EACnB,gBAAgB;EAChB,uBAAuB;EACvB,gBAAgB;AAClB;;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,uBAAuB;EACvB,WAAW;EACX,gBAAgB;EAChB,oCAAoC;AACtC","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.context-container {\n  display: flex;\n  flex-wrap: wrap;\n  align-items: center;\n  gap: 4px;\n  padding: 8px 10px;\n  overflow-x: hidden;\n}\n\n/* Consistent spacing for all children of context container */\n.context-container>* {\n  margin: 2px;\n}\n\n.selected-context-container {\n  display: flex;\n  align-items: center;\n  text-align: center;\n  background-color: var(--jp-layout-color2);\n  border-radius: 3px;\n  padding: 4px 8px;\n  margin: 2px;\n\n  font-size: 12px;\n  height: 20px;\n  max-width: 100%;\n  min-width: 0;\n\n  border: 1px solid var(--jp-border-color1);\n  cursor: pointer;\n}\n\n.selected-context-container:hover {\n  background-color: var(--jp-layout-color3);\n}\n\n.selected-context-container .rule-name {\n  margin-left: 6px;\n  color: var(--jp-content-font-color1);\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  max-width: 200px;\n}\n\n.selected-context-container .icon {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  width: 12px;\n  max-height: 14px;\n  color: var(--jp-content-font-color3);\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/SettingsWidget.css":
/*!************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/SettingsWidget.css ***!
  \************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.settings-widget {
    height: 100%;
    width: 100%;
    padding: 20px;
    box-sizing: border-box;
}

.settings-layout {
    display: flex;
    height: 100%;
}

.settings-sidebar {
    width: 250px;
    padding: 20px;
}

.settings-sidebar nav ul {
    list-style: none;
    padding: 0;
    margin: 0;
}

.settings-sidebar nav li {
    padding: 12px 16px;
    margin: 4px 0;
    cursor: pointer;
    border-radius: 4px;
    transition: background-color 0.2s;
}

.settings-sidebar nav li:hover {
    background-color: var(--jp-layout-color2);
}

.settings-sidebar nav li.active {
    background-color: var(--jp-layout-color2);
    font-weight: 500;
}

.settings-main {
    flex: 1;
    padding: 20px;
    overflow-y: auto;
}

a {
    color: var(--purple-500) !important;
}

.settings-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.settings-header h2 {
    margin: 0;
    font-size: 1.5em;
    color: var(--jp-ui-font-color1);
}

.settings-option {
    margin: 12px 0;
}

.settings-checkbox-label {
    display: flex;
    align-items: center; 
    cursor: pointer;
}

.settings-checkbox-label input[type="checkbox"] {
    margin-right: 8px;
}

.settings-checkbox-label span {
    line-height: 1; /* Ensures text aligns with checkbox */
}

.settings-option-description {
    margin-top: 4px;
    margin-left: 26px; /* Aligns with the text label text */
    font-size: 0.9em;
    color: var(--jp-ui-font-color2);
    line-height: 1.4;
}`, "",{"version":3,"sources":["webpack://./style/SettingsWidget.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,YAAY;IACZ,WAAW;IACX,aAAa;IACb,sBAAsB;AAC1B;;AAEA;IACI,aAAa;IACb,YAAY;AAChB;;AAEA;IACI,YAAY;IACZ,aAAa;AACjB;;AAEA;IACI,gBAAgB;IAChB,UAAU;IACV,SAAS;AACb;;AAEA;IACI,kBAAkB;IAClB,aAAa;IACb,eAAe;IACf,kBAAkB;IAClB,iCAAiC;AACrC;;AAEA;IACI,yCAAyC;AAC7C;;AAEA;IACI,yCAAyC;IACzC,gBAAgB;AACpB;;AAEA;IACI,OAAO;IACP,aAAa;IACb,gBAAgB;AACpB;;AAEA;IACI,mCAAmC;AACvC;;AAEA;IACI,aAAa;IACb,8BAA8B;IAC9B,mBAAmB;IACnB,mBAAmB;AACvB;;AAEA;IACI,SAAS;IACT,gBAAgB;IAChB,+BAA+B;AACnC;;AAEA;IACI,cAAc;AAClB;;AAEA;IACI,aAAa;IACb,mBAAmB;IACnB,eAAe;AACnB;;AAEA;IACI,iBAAiB;AACrB;;AAEA;IACI,cAAc,EAAE,sCAAsC;AAC1D;;AAEA;IACI,eAAe;IACf,iBAAiB,EAAE,oCAAoC;IACvD,gBAAgB;IAChB,+BAA+B;IAC/B,gBAAgB;AACpB","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.settings-widget {\n    height: 100%;\n    width: 100%;\n    padding: 20px;\n    box-sizing: border-box;\n}\n\n.settings-layout {\n    display: flex;\n    height: 100%;\n}\n\n.settings-sidebar {\n    width: 250px;\n    padding: 20px;\n}\n\n.settings-sidebar nav ul {\n    list-style: none;\n    padding: 0;\n    margin: 0;\n}\n\n.settings-sidebar nav li {\n    padding: 12px 16px;\n    margin: 4px 0;\n    cursor: pointer;\n    border-radius: 4px;\n    transition: background-color 0.2s;\n}\n\n.settings-sidebar nav li:hover {\n    background-color: var(--jp-layout-color2);\n}\n\n.settings-sidebar nav li.active {\n    background-color: var(--jp-layout-color2);\n    font-weight: 500;\n}\n\n.settings-main {\n    flex: 1;\n    padding: 20px;\n    overflow-y: auto;\n}\n\na {\n    color: var(--purple-500) !important;\n}\n\n.settings-header {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    margin-bottom: 20px;\n}\n\n.settings-header h2 {\n    margin: 0;\n    font-size: 1.5em;\n    color: var(--jp-ui-font-color1);\n}\n\n.settings-option {\n    margin: 12px 0;\n}\n\n.settings-checkbox-label {\n    display: flex;\n    align-items: center; \n    cursor: pointer;\n}\n\n.settings-checkbox-label input[type=\"checkbox\"] {\n    margin-right: 8px;\n}\n\n.settings-checkbox-label span {\n    line-height: 1; /* Ensures text aligns with checkbox */\n}\n\n.settings-option-description {\n    margin-top: 4px;\n    margin-left: 26px; /* Aligns with the text label text */\n    font-size: 0.9em;\n    color: var(--jp-ui-font-color2);\n    line-height: 1.4;\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/SignUpForm.css":
/*!********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/SignUpForm.css ***!
  \********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.signup-form-header {
    display: block;
    text-align: center;
    font-weight: bold;
    font-size: 20px;
    margin-bottom: 15px;
    color: var(--jp-ui-font-color0);
}

.signup-form-header-logo {
    margin: 0 auto 8px;
    display: block;
    text-align: center;
}

.signup-form-message {
    font-size: 14px;
    color: var(--jp-ui-font-color1);
}

/* Form container to control layout */
.signup-form-container form {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    align-items: flex-start;
}

.signup-form-input {
    padding: 8px 12px;
    border: 1px solid var(--jp-border-color1);
    border-radius: var(--jp-border-radius);
    flex: 2;
    min-width: 200px;
    margin-bottom: 0;
    height: 36px;
    box-sizing: border-box;
}

.signup-form-input:focus {
    border-color: var(--purple-600);
    outline: none;
}

.signup-form-button {
    height: 36px;
    box-sizing: border-box;
    background-color: var(--purple-700);
    color: white;
    flex: 1;
}

.signup-form-button:hover {
    background-color: var(--purple-600);
}

/* When the form wraps, make button full width */
@media (max-width: 300px) {
    .signup-form-container form {
        flex-direction: column;
    }
    
    .signup-form-input {
        width: 100%;
        min-width: unset;
    }
    
    .signup-form-button {
        width: 100%;
    }
}`, "",{"version":3,"sources":["webpack://./style/SignUpForm.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,cAAc;IACd,kBAAkB;IAClB,iBAAiB;IACjB,eAAe;IACf,mBAAmB;IACnB,+BAA+B;AACnC;;AAEA;IACI,kBAAkB;IAClB,cAAc;IACd,kBAAkB;AACtB;;AAEA;IACI,eAAe;IACf,+BAA+B;AACnC;;AAEA,qCAAqC;AACrC;IACI,aAAa;IACb,eAAe;IACf,QAAQ;IACR,uBAAuB;AAC3B;;AAEA;IACI,iBAAiB;IACjB,yCAAyC;IACzC,sCAAsC;IACtC,OAAO;IACP,gBAAgB;IAChB,gBAAgB;IAChB,YAAY;IACZ,sBAAsB;AAC1B;;AAEA;IACI,+BAA+B;IAC/B,aAAa;AACjB;;AAEA;IACI,YAAY;IACZ,sBAAsB;IACtB,mCAAmC;IACnC,YAAY;IACZ,OAAO;AACX;;AAEA;IACI,mCAAmC;AACvC;;AAEA,gDAAgD;AAChD;IACI;QACI,sBAAsB;IAC1B;;IAEA;QACI,WAAW;QACX,gBAAgB;IACpB;;IAEA;QACI,WAAW;IACf;AACJ","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.signup-form-header {\n    display: block;\n    text-align: center;\n    font-weight: bold;\n    font-size: 20px;\n    margin-bottom: 15px;\n    color: var(--jp-ui-font-color0);\n}\n\n.signup-form-header-logo {\n    margin: 0 auto 8px;\n    display: block;\n    text-align: center;\n}\n\n.signup-form-message {\n    font-size: 14px;\n    color: var(--jp-ui-font-color1);\n}\n\n/* Form container to control layout */\n.signup-form-container form {\n    display: flex;\n    flex-wrap: wrap;\n    gap: 8px;\n    align-items: flex-start;\n}\n\n.signup-form-input {\n    padding: 8px 12px;\n    border: 1px solid var(--jp-border-color1);\n    border-radius: var(--jp-border-radius);\n    flex: 2;\n    min-width: 200px;\n    margin-bottom: 0;\n    height: 36px;\n    box-sizing: border-box;\n}\n\n.signup-form-input:focus {\n    border-color: var(--purple-600);\n    outline: none;\n}\n\n.signup-form-button {\n    height: 36px;\n    box-sizing: border-box;\n    background-color: var(--purple-700);\n    color: white;\n    flex: 1;\n}\n\n.signup-form-button:hover {\n    background-color: var(--purple-600);\n}\n\n/* When the form wraps, make button full width */\n@media (max-width: 300px) {\n    .signup-form-container form {\n        flex-direction: column;\n    }\n    \n    .signup-form-input {\n        width: 100%;\n        min-width: unset;\n    }\n    \n    .signup-form-button {\n        width: 100%;\n    }\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/StreamlitPreviewPlugin.css":
/*!********************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/StreamlitPreviewPlugin.css ***!
  \********************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.mito-deploy-button {
    display: flex !important;
    align-items: center !important;
    gap: 6px !important;
    padding: 4px 8px !important;
    color: var(--jp-ui-font-color1) !important;
    background-color: var(--jp-layout-color2) !important;
}

.mito-deploy-button:hover {
    background-color: var(--jp-layout-color3) !important;
}

.mito-deploy-button .mito-ai-deploy-icon {
    display: flex !important;
    align-items: center !important;
    height: 10px !important;
    width: 10px !important;
    font-size: 12px !important;
}

.mito-deploy-button::slotted(svg),
.mito-deploy-button svg {
    width: 12px !important;
    height: 12px !important;
    max-width: 12px !important;
    max-height: 12px !important;
    margin-right: 4px !important;
}`, "",{"version":3,"sources":["webpack://./style/StreamlitPreviewPlugin.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;IACI,wBAAwB;IACxB,8BAA8B;IAC9B,mBAAmB;IACnB,2BAA2B;IAC3B,0CAA0C;IAC1C,oDAAoD;AACxD;;AAEA;IACI,oDAAoD;AACxD;;AAEA;IACI,wBAAwB;IACxB,8BAA8B;IAC9B,uBAAuB;IACvB,sBAAsB;IACtB,0BAA0B;AAC9B;;AAEA;;IAEI,sBAAsB;IACtB,uBAAuB;IACvB,0BAA0B;IAC1B,2BAA2B;IAC3B,4BAA4B;AAChC","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.mito-deploy-button {\n    display: flex !important;\n    align-items: center !important;\n    gap: 6px !important;\n    padding: 4px 8px !important;\n    color: var(--jp-ui-font-color1) !important;\n    background-color: var(--jp-layout-color2) !important;\n}\n\n.mito-deploy-button:hover {\n    background-color: var(--jp-layout-color3) !important;\n}\n\n.mito-deploy-button .mito-ai-deploy-icon {\n    display: flex !important;\n    align-items: center !important;\n    height: 10px !important;\n    width: 10px !important;\n    font-size: 12px !important;\n}\n\n.mito-deploy-button::slotted(svg),\n.mito-deploy-button svg {\n    width: 12px !important;\n    height: 12px !important;\n    max-width: 12px !important;\n    max-height: 12px !important;\n    margin-right: 4px !important;\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/TextAndIconButton.css":
/*!***************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/TextAndIconButton.css ***!
  \***************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.text-and-icon-button {
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 5px;
}

.text-and-icon-button__icon {
  height: 100%;
  display: flex;
  align-items: center;
}

.text-and-icon-button__icon > svg {
  height: 100%;
  width: auto;
}
`, "",{"version":3,"sources":["webpack://./style/TextAndIconButton.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,QAAQ;AACV;;AAEA;EACE,YAAY;EACZ,aAAa;EACb,mBAAmB;AACrB;;AAEA;EACE,YAAY;EACZ,WAAW;AACb","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.text-and-icon-button {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  gap: 5px;\n}\n\n.text-and-icon-button__icon {\n  height: 100%;\n  display: flex;\n  align-items: center;\n}\n\n.text-and-icon-button__icon > svg {\n  height: 100%;\n  width: auto;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/TextButton.css":
/*!********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/TextButton.css ***!
  \********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.text-button-mito-ai {
  display: flex;
  align-items: center;
  justify-content: space-around;
}

.text-align-left {
  justify-content: flex-start;
}

.text-align-center {
  justify-content: space-around;
}

.text-align-right {
  justify-content: flex-end;
}
`, "",{"version":3,"sources":["webpack://./style/TextButton.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,aAAa;EACb,mBAAmB;EACnB,6BAA6B;AAC/B;;AAEA;EACE,2BAA2B;AAC7B;;AAEA;EACE,6BAA6B;AAC/B;;AAEA;EACE,yBAAyB;AAC3B","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.text-button-mito-ai {\n  display: flex;\n  align-items: center;\n  justify-content: space-around;\n}\n\n.text-align-left {\n  justify-content: flex-start;\n}\n\n.text-align-center {\n  justify-content: space-around;\n}\n\n.text-align-right {\n  justify-content: flex-end;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/ToggleButton.css":
/*!**********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/ToggleButton.css ***!
  \**********************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

.toggle-button-container {
  display: flex;
  gap: 1px;
  background-color: var(--jp-layout-color2);
  border: 1px solid var(--jp-ui-font-color3);
  border-radius: 2px;
  width: 100px;
  overflow: hidden;
}

.toggle-button-half {
  flex: 0 0 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 8px;
  min-width: 20px;
  font-size: 12px;
  padding: 2px 8px;
}

.toggle-button-half:first-child {
  border-radius: 0px;
}

.toggle-button-half:last-child {
  border-radius: 0px;
}

.toggle-button-half.selected {
  opacity: 1;
  background-color: var(--purple-400);
  color: var(--purple-700) !important;
}

.toggle-button-half.unselected {
  opacity: 0.6;
  background-color: transparent !important;
  color: var(--jp-ui-font-color2) !important;
}

.toggle-button-icon {
  width: 16px;
  height: 16px;
}
`, "",{"version":3,"sources":["webpack://./style/ToggleButton.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,aAAa;EACb,QAAQ;EACR,yCAAyC;EACzC,0CAA0C;EAC1C,kBAAkB;EAClB,YAAY;EACZ,gBAAgB;AAClB;;AAEA;EACE,aAAa;EACb,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,QAAQ;EACR,eAAe;EACf,eAAe;EACf,gBAAgB;AAClB;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,UAAU;EACV,mCAAmC;EACnC,mCAAmC;AACrC;;AAEA;EACE,YAAY;EACZ,wCAAwC;EACxC,0CAA0C;AAC5C;;AAEA;EACE,WAAW;EACX,YAAY;AACd","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n.toggle-button-container {\n  display: flex;\n  gap: 1px;\n  background-color: var(--jp-layout-color2);\n  border: 1px solid var(--jp-ui-font-color3);\n  border-radius: 2px;\n  width: 100px;\n  overflow: hidden;\n}\n\n.toggle-button-half {\n  flex: 0 0 50%;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  gap: 8px;\n  min-width: 20px;\n  font-size: 12px;\n  padding: 2px 8px;\n}\n\n.toggle-button-half:first-child {\n  border-radius: 0px;\n}\n\n.toggle-button-half:last-child {\n  border-radius: 0px;\n}\n\n.toggle-button-half.selected {\n  opacity: 1;\n  background-color: var(--purple-400);\n  color: var(--purple-700) !important;\n}\n\n.toggle-button-half.unselected {\n  opacity: 0.6;\n  background-color: transparent !important;\n  color: var(--jp-ui-font-color2) !important;\n}\n\n.toggle-button-icon {\n  width: 16px;\n  height: 16px;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/button.css":
/*!****************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/button.css ***!
  \****************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

/* 
    Classes that can be used for any button, making it easier to keep 
    the theme consistent. For example, use them to make a textButton or
    textAndIconButton green.
*/

.button-base {
  border: none;
  border-radius: 3px;
  cursor: pointer;
  font-size: 14px;
  /* Make sure the button grows large enough so that the text does not wrap */
  white-space: nowrap;
  padding: 5px 10px;
}

.button-green {
  background-color: var(--green-400);
  color: var(--green-900) !important;
}

.button-green:hover {
  background-color: var(--green-500);
}

.button-red {
  background-color: var(--red-400);
  color: var(--red-900) !important;
}

.button-red:hover {
  background-color: var(--red-500);
}

.button-gray {
  background-color: var(--jp-layout-color2);
  color: var(--jp-content-font-color1) !important;
}

.button-gray:hover {
  background-color: var(--jp-layout-color3);
}

.button-purple {
  background-color: var(--purple-300);
  color: var(--purple-700) !important;
}

.button-purple:hover {
  background-color: var(--purple-400);
}

.button-dark-purple {
  background-color: var(--purple-500);
  color: var(--white) !important;
}

.button-dark-purple:hover {
  background-color: var(--purple-600);
}

.button-width-block {
  width: 100%;
}

.button-width-fit-contents {
  width: fit-content;
}

.button-small {
  height: 20px;
  font-size: 12px;
  padding: 2px 5px;
}
`, "",{"version":3,"sources":["webpack://./style/button.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;;;;CAIC;;AAED;EACE,YAAY;EACZ,kBAAkB;EAClB,eAAe;EACf,eAAe;EACf,2EAA2E;EAC3E,mBAAmB;EACnB,iBAAiB;AACnB;;AAEA;EACE,kCAAkC;EAClC,kCAAkC;AACpC;;AAEA;EACE,kCAAkC;AACpC;;AAEA;EACE,gCAAgC;EAChC,gCAAgC;AAClC;;AAEA;EACE,gCAAgC;AAClC;;AAEA;EACE,yCAAyC;EACzC,+CAA+C;AACjD;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,mCAAmC;EACnC,mCAAmC;AACrC;;AAEA;EACE,mCAAmC;AACrC;;AAEA;EACE,mCAAmC;EACnC,8BAA8B;AAChC;;AAEA;EACE,mCAAmC;AACrC;;AAEA;EACE,WAAW;AACb;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,YAAY;EACZ,eAAe;EACf,gBAAgB;AAClB","sourcesContent":["/*\n * Copyright (c) Saga Inc.\n * Distributed under the terms of the GNU Affero General Public License v3.0 License.\n */\n\n/* \n    Classes that can be used for any button, making it easier to keep \n    the theme consistent. For example, use them to make a textButton or\n    textAndIconButton green.\n*/\n\n.button-base {\n  border: none;\n  border-radius: 3px;\n  cursor: pointer;\n  font-size: 14px;\n  /* Make sure the button grows large enough so that the text does not wrap */\n  white-space: nowrap;\n  padding: 5px 10px;\n}\n\n.button-green {\n  background-color: var(--green-400);\n  color: var(--green-900) !important;\n}\n\n.button-green:hover {\n  background-color: var(--green-500);\n}\n\n.button-red {\n  background-color: var(--red-400);\n  color: var(--red-900) !important;\n}\n\n.button-red:hover {\n  background-color: var(--red-500);\n}\n\n.button-gray {\n  background-color: var(--jp-layout-color2);\n  color: var(--jp-content-font-color1) !important;\n}\n\n.button-gray:hover {\n  background-color: var(--jp-layout-color3);\n}\n\n.button-purple {\n  background-color: var(--purple-300);\n  color: var(--purple-700) !important;\n}\n\n.button-purple:hover {\n  background-color: var(--purple-400);\n}\n\n.button-dark-purple {\n  background-color: var(--purple-500);\n  color: var(--white) !important;\n}\n\n.button-dark-purple:hover {\n  background-color: var(--purple-600);\n}\n\n.button-width-block {\n  width: 100%;\n}\n\n.button-width-fit-contents {\n  width: fit-content;\n}\n\n.button-small {\n  height: 20px;\n  font-size: 12px;\n  padding: 2px 5px;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./src/icons/App/DeployIcon.svg":
/*!**************************************!*\
  !*** ./src/icons/App/DeployIcon.svg ***!
  \**************************************/
/***/ ((module) => {

module.exports = "<svg width=\"1298\" height=\"1286\" viewBox=\"0 0 1298 1286\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n    <g fill=\"currentColor\">\n        <path d=\"M689.8 1007.36C644.524 1028.32 598.8 1047.93 552.76 1066.2L569.733 1285.77C638.785 1254.45 799 1157.24 926.04 893.279C871.201 922.393 816.352 948.581 769.52 970.929C743.254 983.518 716.602 995.58 689.806 1007.36L689.8 1007.36Z\" />\n        <path d=\"M815.76 382.387C791.224 382.387 766.698 391.626 748.02 410.084C729.994 427.923 720.056 451.62 720.056 476.824C720.056 502.021 729.983 525.725 748.029 543.564C785.379 580.501 846.166 580.491 883.496 543.564C883.496 543.554 883.507 543.554 883.507 543.554C901.533 525.715 911.48 502.018 911.48 476.814C911.48 451.616 901.542 427.912 883.507 410.073C864.84 391.615 840.304 382.385 815.761 382.385L815.76 382.387Z\" />\n        <path d=\"M349.453 462.747C364.328 432.924 380.213 401.747 397.229 370.408C130.563 495.835 32.0558 654.008 0.21582 722.461L220.562 739.112C243.614 682.175 268.75 625.664 296.073 569.925C312.661 535.961 330.401 499.685 349.448 462.748L349.453 462.747Z\" />\n        <path d=\"M914.027 33.9479L1263.4 379.428C1280.5 311.901 1289.8 244.215 1294.2 180.815C1294.57 175.502 1294.94 170.2 1295.24 164.841C1295.7 156.815 1296.08 148.893 1296.39 141.029C1296.74 132.003 1297.02 122.915 1297.19 113.789C1297.32 107.513 1297.42 101.3 1297.45 95.1639C1297.53 82.6117 1297.5 70.0025 1297.27 57.2892C1297.21 54.4143 1297.14 51.6017 1297.07 48.7632C1296.68 33.4872 1296.14 18.1379 1295.28 2.66453C1193.44 -3.4552 1054.16 -1.29387 914.028 33.9565L914.027 33.9479Z\" />\n        <path d=\"M1106.33 687.12C1113.39 679.36 1120.28 671.423 1126.96 663.235C1127.83 662.162 1128.78 661.11 1129.65 660.021C1136.68 651.261 1143.42 642.172 1150.03 632.933C1152.32 629.735 1154.57 626.506 1156.79 623.272C1161.92 615.824 1166.89 608.209 1171.74 600.46C1174.87 595.46 1177.89 590.408 1180.87 585.345C1184.4 579.345 1187.85 573.272 1191.24 567.105C1194.19 561.694 1197.13 556.282 1199.93 550.802C1202.02 546.729 1203.99 542.542 1206.02 538.401C1211.38 527.391 1216.53 516.287 1221.32 505.079C1222.07 503.318 1222.81 501.542 1223.56 499.766C1232.09 479.354 1239.68 458.667 1246.47 437.829L855.11 50.802C755.386 82.99 670.87 130.214 602.99 191.362C601.24 192.935 599.49 194.523 597.751 196.122C588.876 204.31 580.215 212.685 571.939 221.362C569.001 224.461 566.163 227.748 563.277 230.951C497.903 303.211 443.179 397.524 396.451 488.218C386.039 509.119 376.139 529.354 366.951 548.182C330.524 622.468 297.377 699.395 268.399 776.848C266.362 782.312 262.612 786.697 257.961 789.734C237.472 842.307 218.81 895.171 202.3 948.107L340.153 1084.43C395.164 1067.65 450.101 1048.65 504.7 1027.74C507.538 1024.61 510.887 1021.9 515.075 1020.37C566.689 1001.51 618.023 980.661 668.621 958.427C678.861 953.677 689.111 948.953 699.299 944.062C828.601 882.912 975.019 813.661 1075.33 718.903C1083.84 710.892 1092.02 702.491 1100.07 693.929C1102.19 691.669 1104.26 689.393 1106.34 687.122L1106.33 687.12ZM921.187 581.344C892.114 610.104 853.911 624.48 815.723 624.48C777.535 624.48 739.348 610.105 710.275 581.355C682.051 553.443 666.515 516.328 666.515 476.828C666.515 437.328 682.067 400.213 710.264 372.301C768.426 314.791 863.038 314.812 921.171 372.291C949.411 400.203 964.947 437.318 964.947 476.818C964.947 516.307 949.406 553.432 921.182 581.344L921.187 581.344Z\" />\n        <path d=\"M147.088 1138.72L198.905 982.058L302.981 1084.64L147.088 1138.72Z\" />\n    </g>\n</svg>\n";

/***/ }),

/***/ "./src/icons/AppBuilderExcludeCellIcon.svg":
/*!*************************************************!*\
  !*** ./src/icons/AppBuilderExcludeCellIcon.svg ***!
  \*************************************************/
/***/ ((module) => {

module.exports = "<svg width=\"21\" height=\"17\" viewBox=\"0 0 21 17\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n    <g fill=\"currentColor\" class=\"jp-icon3 jp-icon-selectable\">\n        <path d=\"M21.002 2.83398V11.333C21.002 12.8953 19.72 14.167 18.1445 14.167H11.4785V15.583H15.2881V17H6.71582V15.583H10.0498V14.167H3.85938C3.78015 14.167 3.70164 14.1606 3.62402 14.1543L5.73145 12.75H18.1445C18.9323 12.75 19.5732 12.115 19.5732 11.333V3.52148L20.9883 2.57715C20.996 2.66182 21.002 2.74736 21.002 2.83398ZM17.6455 0L15.5195 1.41699H3.85938C3.07162 1.41699 2.43067 2.05288 2.43066 2.83398V10.1416L1.00195 11.0938V2.83398C1.00196 1.2708 2.28386 0 3.85938 0H17.6455Z\"/>\n    </g>\n    <path d=\"M1 13.5L20.5 0.5\" stroke=\"#611818\" stroke-width=\"2\" stroke-linecap=\"round\"/>\n</svg>\n";

/***/ }),

/***/ "./src/icons/AppBuilderIncludeCellIcon.svg":
/*!*************************************************!*\
  !*** ./src/icons/AppBuilderIncludeCellIcon.svg ***!
  \*************************************************/
/***/ ((module) => {

module.exports = "<svg width=\"22\" height=\"17\" viewBox=\"0 0 22 17\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n    <g fill=\"currentColor\" class=\"jp-icon3 jp-icon-selectable\">\n        <path d=\"M21.002 11.333C21.002 12.8953 19.72 14.167 18.1445 14.167H11.4785V15.583H15.2881V17H6.71582V15.583H10.0498V14.167H3.85938C2.28386 14.167 1.00196 12.8961 1.00195 11.333V8.31152L2.43066 9.35938V11.333C2.43067 12.1141 3.07162 12.75 3.85938 12.75H7.05371L7.31738 12.9434C7.32993 12.9526 7.34375 12.9599 7.35645 12.9688C7.38856 12.9912 7.42094 13.0128 7.4541 13.0332C7.47857 13.0483 7.50343 13.0623 7.52832 13.0762C7.55922 13.0934 7.59044 13.1095 7.62207 13.125C7.6531 13.1402 7.68429 13.1545 7.71582 13.168C7.73979 13.1782 7.76379 13.188 7.78809 13.1973C7.82539 13.2115 7.86256 13.2254 7.90039 13.2373C7.92719 13.2457 7.95436 13.2525 7.98145 13.2598C8.01712 13.2694 8.05288 13.2776 8.08887 13.2852C8.11196 13.29 8.13497 13.2948 8.1582 13.2988C8.19981 13.306 8.24139 13.3119 8.2832 13.3164C8.30597 13.3189 8.32873 13.3206 8.35156 13.3223C8.39132 13.3252 8.43093 13.3276 8.4707 13.3281C8.49872 13.3286 8.52665 13.3279 8.55469 13.3271C8.58633 13.3263 8.61788 13.3256 8.64941 13.3232C8.68337 13.3207 8.71713 13.3167 8.75098 13.3125C8.78304 13.3084 8.81485 13.3034 8.84668 13.2979C8.87705 13.2925 8.90732 13.287 8.9375 13.2803C8.96726 13.2736 8.99692 13.2668 9.02637 13.2588C9.06575 13.2481 9.1047 13.2358 9.14355 13.2227C9.16327 13.216 9.18263 13.2085 9.20215 13.2012C9.23926 13.1873 9.27604 13.1725 9.3125 13.1562C9.34045 13.1439 9.36808 13.1309 9.39551 13.1172C9.42317 13.1033 9.45037 13.0885 9.47754 13.0732C9.51024 13.0549 9.54245 13.0359 9.57422 13.0156C9.59691 13.0011 9.61935 12.9862 9.6416 12.9707C9.67361 12.9484 9.70451 12.9247 9.73535 12.9004C9.74815 12.8903 9.76277 12.8825 9.77539 12.8721L9.92285 12.75H18.1445C18.9323 12.75 19.5732 12.115 19.5732 11.333V4.77441L21.002 3.59277V11.333ZM18.1445 0C18.4183 0 18.6828 0.0406656 18.9336 0.112305L17.3564 1.41699H3.85938C3.07162 1.41699 2.43067 2.05288 2.43066 2.83398V4.39941L2.18262 4.21777L2.01172 4.10547C1.69721 3.92062 1.34804 3.83112 1.00195 3.83105V2.83398C1.00196 1.2708 2.28386 0 3.85938 0H18.1445Z\"/>\n    </g>\n    <path d=\"M1 5.83051L4.74999 8.58062L8.49999 11.3307\" stroke=\"#155239\" stroke-width=\"2\" stroke-linecap=\"round\"/>\n    <path d=\"M21.0009 1L8.50088 11.3307\" stroke=\"#155239\" stroke-width=\"2\" stroke-linecap=\"round\"/>\n</svg>";

/***/ }),

/***/ "./src/icons/ChatIcon.svg":
/*!********************************!*\
  !*** ./src/icons/ChatIcon.svg ***!
  \********************************/
/***/ ((module) => {

module.exports = "<svg width=\"19\" height=\"20\" viewBox=\"0 0 19 20\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n    <path d=\"M15.0626 4.8125C15.5466 4.8125 15.9376 5.20352 15.9376 5.6875C15.9376 6.17148 15.5466 6.5625 15.0626 6.5625C14.5787 6.5625 14.1876 6.17148 14.1876 5.6875C14.1876 5.20352 14.5787 4.8125 15.0626 4.8125ZM12.0001 4.8125C12.4841 4.8125 12.8751 5.20352 12.8751 5.6875C12.8751 6.17148 12.4841 6.5625 12.0001 6.5625C11.5162 6.5625 11.1251 6.17148 11.1251 5.6875C11.1251 5.20352 11.5162 4.8125 12.0001 4.8125ZM8.93764 4.8125C9.42162 4.8125 9.81264 5.20352 9.81264 5.6875C9.81264 6.17148 9.42162 6.5625 8.93764 6.5625C8.45365 6.5625 8.06264 6.17148 8.06264 5.6875C8.06264 5.20352 8.45365 4.8125 8.93764 4.8125ZM12.0001 0C15.8665 0 19.0001 2.5457 19.0001 5.6875C19.0001 6.98906 18.456 8.18125 17.5537 9.14102C17.9611 10.2184 18.8087 11.1316 18.8224 11.1426C19.0029 11.334 19.0521 11.6129 18.9482 11.8535C18.8443 12.0941 18.6064 12.25 18.3439 12.25C16.6622 12.25 15.3361 11.5473 14.5404 10.984C13.7501 11.2328 12.897 11.375 12.0001 11.375C8.13373 11.375 