# gate-api
Welcome to Gate API
 APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces
for implementing API-based automated trading.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v4.102.1
- Package version: 6.102.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.gate.com/page/contacts](https://www.gate.com/page/contacts)

## Versioning

Trying our best to follow the [semantic versioning](https://semver.org/), while enjoying recent features
provided by programming language and libraries, from 4.15.2, one major versioning difference will be
introduced:

If extra code rewrite is required when you upgrade the SDK, such as:

- some outdated programming language version support is dropped
- API method signature has breaking changes.

**the MAJOR version will be incremented, but the MINOR and PATCH version are still following REST API's
instead of resetting to 0**, so that you can recognize it has some breaking changes, but still getting
the idea of from which REST API version the change is introduced.

For example, the previous REST API and SDK version are both 4.14.0. But if we decide to introduce
some breaking changes in SDK along with REST API 4.15.2 upgrade, then the version of next SDK release
will be 5.15.2(the MAJOR version is incremented to denote breaking changes, but the MINOR and PATCH
version are identical to REST API's instead of resetting them to 0)

If MAJOR version is incremented, make sure you read the release note on
[Releases](https://github.com/gateio/gateapi-python/releases)
page

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

You can install directly using:

```sh
pip install --user gate-api
```

Then import the package:
```python
import gate_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import gate_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import gate_api
from gate_api.exceptions import ApiException, GateApiException

# Defining the host is optional and defaults to https://api.gateio.ws/api/v4
# See configuration.py for a list of all supported configuration parameters.
configuration = gate_api.Configuration(
    host = "https://api.gateio.ws/api/v4"
)


api_client = gate_api.ApiClient(configuration)
# Create an instance of the API class
api_instance = gate_api.EarnUniApi(api_client)

try:
    # List currencies for lending
    api_response = api_instance.list_uni_currencies()
    print(api_response)
except GateApiException as ex:
    print("Gate api exception, label: %s, message: %s\n" % (ex.label, ex.message))
except ApiException as e:
    print("Exception when calling EarnUniApi->list_uni_currencies: %s\n" % e)

```

For a more complete API usage example, refer to the demo application in [example](example) directory

## Documentation for API Endpoints

All URIs are relative to *https://api.gateio.ws/api/v4*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*EarnUniApi* | [**list_uni_currencies**](docs/EarnUniApi.md#list_uni_currencies) | **GET** /earn/uni/currencies | List currencies for lending
*EarnUniApi* | [**get_uni_currency**](docs/EarnUniApi.md#get_uni_currency) | **GET** /earn/uni/currencies/{currency} | Get currency detail for lending
*EarnUniApi* | [**list_user_uni_lends**](docs/EarnUniApi.md#list_user_uni_lends) | **GET** /earn/uni/lends | List user&#39;s lending orders
*EarnUniApi* | [**create_uni_lend**](docs/EarnUniApi.md#create_uni_lend) | **POST** /earn/uni/lends | Lend or redeem
*EarnUniApi* | [**change_uni_lend**](docs/EarnUniApi.md#change_uni_lend) | **PATCH** /earn/uni/lends | Amend lending order
*EarnUniApi* | [**list_uni_lend_records**](docs/EarnUniApi.md#list_uni_lend_records) | **GET** /earn/uni/lend_records | List records of lending
*EarnUniApi* | [**get_uni_interest**](docs/EarnUniApi.md#get_uni_interest) | **GET** /earn/uni/interests/{currency} | Get the user&#39;s total interest income of specified currency
*EarnUniApi* | [**list_uni_interest_records**](docs/EarnUniApi.md#list_uni_interest_records) | **GET** /earn/uni/interest_records | List interest records
*EarnUniApi* | [**get_uni_interest_status**](docs/EarnUniApi.md#get_uni_interest_status) | **GET** /earn/uni/interest_status/{currency} | query currency interest compounding status
*EarnUniApi* | [**list_uni_chart**](docs/EarnUniApi.md#list_uni_chart) | **GET** /earn/uni/chart | UniLoan currency annualized trend chart
*EarnUniApi* | [**list_uni_rate**](docs/EarnUniApi.md#list_uni_rate) | **GET** /earn/uni/rate | Currency estimate annualized interest rate
*MarginUniApi* | [**list_uni_currency_pairs**](docs/MarginUniApi.md#list_uni_currency_pairs) | **GET** /margin/uni/currency_pairs | List lending markets
*MarginUniApi* | [**get_uni_currency_pair**](docs/MarginUniApi.md#get_uni_currency_pair) | **GET** /margin/uni/currency_pairs/{currency_pair} | Get detail of lending market
*MarginUniApi* | [**get_margin_uni_estimate_rate**](docs/MarginUniApi.md#get_margin_uni_estimate_rate) | **GET** /margin/uni/estimate_rate | Estimate interest Rate
*MarginUniApi* | [**list_uni_loans**](docs/MarginUniApi.md#list_uni_loans) | **GET** /margin/uni/loans | List loans
*MarginUniApi* | [**create_uni_loan**](docs/MarginUniApi.md#create_uni_loan) | **POST** /margin/uni/loans | Borrow or repay
*MarginUniApi* | [**list_uni_loan_records**](docs/MarginUniApi.md#list_uni_loan_records) | **GET** /margin/uni/loan_records | Get load records
*MarginUniApi* | [**list_uni_loan_interest_records**](docs/MarginUniApi.md#list_uni_loan_interest_records) | **GET** /margin/uni/interest_records | List interest records
*MarginUniApi* | [**get_uni_borrowable**](docs/MarginUniApi.md#get_uni_borrowable) | **GET** /margin/uni/borrowable | Get maximum borrowable
*SubAccountApi* | [**list_sub_accounts**](docs/SubAccountApi.md#list_sub_accounts) | **GET** /sub_accounts | List sub-accounts
*SubAccountApi* | [**create_sub_accounts**](docs/SubAccountApi.md#create_sub_accounts) | **POST** /sub_accounts | Create a new sub-account
*SubAccountApi* | [**get_sub_account**](docs/SubAccountApi.md#get_sub_account) | **GET** /sub_accounts/{user_id} | Get the sub-account
*SubAccountApi* | [**list_sub_account_keys**](docs/SubAccountApi.md#list_sub_account_keys) | **GET** /sub_accounts/{user_id}/keys | List all API Key of the sub-account
*SubAccountApi* | [**create_sub_account_keys**](docs/SubAccountApi.md#create_sub_account_keys) | **POST** /sub_accounts/{user_id}/keys | Create API Key of the sub-account
*SubAccountApi* | [**get_sub_account_key**](docs/SubAccountApi.md#get_sub_account_key) | **GET** /sub_accounts/{user_id}/keys/{key} | Get the API Key of the sub-account
*SubAccountApi* | [**update_sub_account_keys**](docs/SubAccountApi.md#update_sub_account_keys) | **PUT** /sub_accounts/{user_id}/keys/{key} | Update API key of the sub-account
*SubAccountApi* | [**delete_sub_account_keys**](docs/SubAccountApi.md#delete_sub_account_keys) | **DELETE** /sub_accounts/{user_id}/keys/{key} | Delete API key of the sub-account
*SubAccountApi* | [**lock_sub_account**](docs/SubAccountApi.md#lock_sub_account) | **POST** /sub_accounts/{user_id}/lock | Lock the sub-account
*SubAccountApi* | [**unlock_sub_account**](docs/SubAccountApi.md#unlock_sub_account) | **POST** /sub_accounts/{user_id}/unlock | Unlock the sub-account
*SubAccountApi* | [**list_unified_mode**](docs/SubAccountApi.md#list_unified_mode) | **GET** /sub_accounts/unified_mode | Get sub-account mode
*UnifiedApi* | [**list_unified_accounts**](docs/UnifiedApi.md#list_unified_accounts) | **GET** /unified/accounts | Get unified account information
*UnifiedApi* | [**get_unified_borrowable**](docs/UnifiedApi.md#get_unified_borrowable) | **GET** /unified/borrowable | Query about the maximum borrowing for the unified account
*UnifiedApi* | [**get_unified_transferable**](docs/UnifiedApi.md#get_unified_transferable) | **GET** /unified/transferable | Query about the maximum transferable for the unified account
*UnifiedApi* | [**get_unified_transferables**](docs/UnifiedApi.md#get_unified_transferables) | **GET** /unified/transferables | Batch query can be transferred out at most for unified accounts; each currency is the maximum value. After the user withdraws the currency, the amount of transferable currency will be changed.
*UnifiedApi* | [**get_unified_borrowable_list**](docs/UnifiedApi.md#get_unified_borrowable_list) | **GET** /unified/batch_borrowable | Batch query unified account can be borrowed up to a maximum
*UnifiedApi* | [**list_unified_loans**](docs/UnifiedApi.md#list_unified_loans) | **GET** /unified/loans | List loans
*UnifiedApi* | [**create_unified_loan**](docs/UnifiedApi.md#create_unified_loan) | **POST** /unified/loans | Borrow or repay
*UnifiedApi* | [**list_unified_loan_records**](docs/UnifiedApi.md#list_unified_loan_records) | **GET** /unified/loan_records | Get load records
*UnifiedApi* | [**list_unified_loan_interest_records**](docs/UnifiedApi.md#list_unified_loan_interest_records) | **GET** /unified/interest_records | List interest records
*UnifiedApi* | [**get_unified_risk_units**](docs/UnifiedApi.md#get_unified_risk_units) | **GET** /unified/risk_units | Get user risk unit details
*UnifiedApi* | [**get_unified_mode**](docs/UnifiedApi.md#get_unified_mode) | **GET** /unified/unified_mode | Query mode of the unified account
*UnifiedApi* | [**set_unified_mode**](docs/UnifiedApi.md#set_unified_mode) | **PUT** /unified/unified_mode | Set mode of the unified account
*UnifiedApi* | [**get_unified_estimate_rate**](docs/UnifiedApi.md#get_unified_estimate_rate) | **GET** /unified/estimate_rate | Get unified estimate rate
*UnifiedApi* | [**list_currency_discount_tiers**](docs/UnifiedApi.md#list_currency_discount_tiers) | **GET** /unified/currency_discount_tiers | List currency discount tiers
*UnifiedApi* | [**list_loan_margin_tiers**](docs/UnifiedApi.md#list_loan_margin_tiers) | **GET** /unified/loan_margin_tiers | List loan margin tiers
*UnifiedApi* | [**calculate_portfolio_margin**](docs/UnifiedApi.md#calculate_portfolio_margin) | **POST** /unified/portfolio_calculator | Portfolio margin calculator
*UnifiedApi* | [**get_user_leverage_currency_config**](docs/UnifiedApi.md#get_user_leverage_currency_config) | **GET** /unified/leverage/user_currency_config | Minimum currency leverage that can be set
*UnifiedApi* | [**get_user_leverage_currency_setting**](docs/UnifiedApi.md#get_user_leverage_currency_setting) | **GET** /unified/leverage/user_currency_setting | Get the leverage multiple of the user currency
*UnifiedApi* | [**set_user_leverage_currency_setting**](docs/UnifiedApi.md#set_user_leverage_currency_setting) | **POST** /unified/leverage/user_currency_setting | Set the loan currency leverage
*UnifiedApi* | [**list_unified_currencies**](docs/UnifiedApi.md#list_unified_currencies) | **GET** /unified/currencies | List of loan currencies supported by unified account
*UnifiedApi* | [**get_history_loan_rate**](docs/UnifiedApi.md#get_history_loan_rate) | **GET** /unified/history_loan_rate | get historical lending rates
*UnifiedApi* | [**set_unified_collateral**](docs/UnifiedApi.md#set_unified_collateral) | **POST** /unified/collateral_currencies | Set Collateral Currency
*AccountApi* | [**get_account_detail**](docs/AccountApi.md#get_account_detail) | **GET** /account/detail | Get account detail
*AccountApi* | [**get_account_rate_limit**](docs/AccountApi.md#get_account_rate_limit) | **GET** /account/rate_limit | Get user transaction rate limit information
*AccountApi* | [**list_stp_groups**](docs/AccountApi.md#list_stp_groups) | **GET** /account/stp_groups | List STP Groups
*AccountApi* | [**create_stp_group**](docs/AccountApi.md#create_stp_group) | **POST** /account/stp_groups | Create STP Group
*AccountApi* | [**list_stp_groups_users**](docs/AccountApi.md#list_stp_groups_users) | **GET** /account/stp_groups/{stp_id}/users | List users of the STP group
*AccountApi* | [**add_stp_group_users**](docs/AccountApi.md#add_stp_group_users) | **POST** /account/stp_groups/{stp_id}/users | Add users to the STP group
*AccountApi* | [**delete_stp_group_users**](docs/AccountApi.md#delete_stp_group_users) | **DELETE** /account/stp_groups/{stp_id}/users | Delete the user in the STP group
*AccountApi* | [**get_debit_fee**](docs/AccountApi.md#get_debit_fee) | **GET** /account/debit_fee | Query GT deduction configuration.
*AccountApi* | [**set_debit_fee**](docs/AccountApi.md#set_debit_fee) | **POST** /account/debit_fee | Set GT deduction.
*CollateralLoanApi* | [**list_collateral_loan_orders**](docs/CollateralLoanApi.md#list_collateral_loan_orders) | **GET** /loan/collateral/orders | List Orders
*CollateralLoanApi* | [**create_collateral_loan**](docs/CollateralLoanApi.md#create_collateral_loan) | **POST** /loan/collateral/orders | Place order
*CollateralLoanApi* | [**get_collateral_loan_order_detail**](docs/CollateralLoanApi.md#get_collateral_loan_order_detail) | **GET** /loan/collateral/orders/{order_id} | Get a single order
*CollateralLoanApi* | [**repay_collateral_loan**](docs/CollateralLoanApi.md#repay_collateral_loan) | **POST** /loan/collateral/repay | Repayment
*CollateralLoanApi* | [**list_repay_records**](docs/CollateralLoanApi.md#list_repay_records) | **GET** /loan/collateral/repay_records | Repayment history
*CollateralLoanApi* | [**list_collateral_records**](docs/CollateralLoanApi.md#list_collateral_records) | **GET** /loan/collateral/collaterals | Query collateral adjustment records
*CollateralLoanApi* | [**operate_collateral**](docs/CollateralLoanApi.md#operate_collateral) | **POST** /loan/collateral/collaterals | Increase or redeem collateral
*CollateralLoanApi* | [**get_user_total_amount**](docs/CollateralLoanApi.md#get_user_total_amount) | **GET** /loan/collateral/total_amount | Query the total borrowing and collateral amount for the user
*CollateralLoanApi* | [**get_user_ltv_info**](docs/CollateralLoanApi.md#get_user_ltv_info) | **GET** /loan/collateral/ltv | Query user&#39;s collateralization ratio
*CollateralLoanApi* | [**list_collateral_currencies**](docs/CollateralLoanApi.md#list_collateral_currencies) | **GET** /loan/collateral/currencies | Query supported borrowing and collateral currencies
*DeliveryApi* | [**list_delivery_contracts**](docs/DeliveryApi.md#list_delivery_contracts) | **GET** /delivery/{settle}/contracts | List all futures contracts
*DeliveryApi* | [**get_delivery_contract**](docs/DeliveryApi.md#get_delivery_contract) | **GET** /delivery/{settle}/contracts/{contract} | Get a single contract
*DeliveryApi* | [**list_delivery_order_book**](docs/DeliveryApi.md#list_delivery_order_book) | **GET** /delivery/{settle}/order_book | Futures order book
*DeliveryApi* | [**list_delivery_trades**](docs/DeliveryApi.md#list_delivery_trades) | **GET** /delivery/{settle}/trades | Futures trading history
*DeliveryApi* | [**list_delivery_candlesticks**](docs/DeliveryApi.md#list_delivery_candlesticks) | **GET** /delivery/{settle}/candlesticks | Get futures candlesticks
*DeliveryApi* | [**list_delivery_tickers**](docs/DeliveryApi.md#list_delivery_tickers) | **GET** /delivery/{settle}/tickers | List futures tickers
*DeliveryApi* | [**list_delivery_insurance_ledger**](docs/DeliveryApi.md#list_delivery_insurance_ledger) | **GET** /delivery/{settle}/insurance | Futures insurance balance history
*DeliveryApi* | [**list_delivery_accounts**](docs/DeliveryApi.md#list_delivery_accounts) | **GET** /delivery/{settle}/accounts | Query futures account
*DeliveryApi* | [**list_delivery_account_book**](docs/DeliveryApi.md#list_delivery_account_book) | **GET** /delivery/{settle}/account_book | Query account book
*DeliveryApi* | [**list_delivery_positions**](docs/DeliveryApi.md#list_delivery_positions) | **GET** /delivery/{settle}/positions | List all positions of a user
*DeliveryApi* | [**get_delivery_position**](docs/DeliveryApi.md#get_delivery_position) | **GET** /delivery/{settle}/positions/{contract} | Get single position
*DeliveryApi* | [**update_delivery_position_margin**](docs/DeliveryApi.md#update_delivery_position_margin) | **POST** /delivery/{settle}/positions/{contract}/margin | Update position margin
*DeliveryApi* | [**update_delivery_position_leverage**](docs/DeliveryApi.md#update_delivery_position_leverage) | **POST** /delivery/{settle}/positions/{contract}/leverage | Update position leverage
*DeliveryApi* | [**update_delivery_position_risk_limit**](docs/DeliveryApi.md#update_delivery_position_risk_limit) | **POST** /delivery/{settle}/positions/{contract}/risk_limit | Update position risk limit
*DeliveryApi* | [**list_delivery_orders**](docs/DeliveryApi.md#list_delivery_orders) | **GET** /delivery/{settle}/orders | List futures orders
*DeliveryApi* | [**create_delivery_order**](docs/DeliveryApi.md#create_delivery_order) | **POST** /delivery/{settle}/orders | Create a futures order
*DeliveryApi* | [**cancel_delivery_orders**](docs/DeliveryApi.md#cancel_delivery_orders) | **DELETE** /delivery/{settle}/orders | Cancel all &#x60;open&#x60; orders matched
*DeliveryApi* | [**get_delivery_order**](docs/DeliveryApi.md#get_delivery_order) | **GET** /delivery/{settle}/orders/{order_id} | Get a single order
*DeliveryApi* | [**cancel_delivery_order**](docs/DeliveryApi.md#cancel_delivery_order) | **DELETE** /delivery/{settle}/orders/{order_id} | Cancel a single order
*DeliveryApi* | [**get_my_delivery_trades**](docs/DeliveryApi.md#get_my_delivery_trades) | **GET** /delivery/{settle}/my_trades | List personal trading history
*DeliveryApi* | [**list_delivery_position_close**](docs/DeliveryApi.md#list_delivery_position_close) | **GET** /delivery/{settle}/position_close | List position close history
*DeliveryApi* | [**list_delivery_liquidates**](docs/DeliveryApi.md#list_delivery_liquidates) | **GET** /delivery/{settle}/liquidates | List liquidation history
*DeliveryApi* | [**list_delivery_settlements**](docs/DeliveryApi.md#list_delivery_settlements) | **GET** /delivery/{settle}/settlements | List settlement history
*DeliveryApi* | [**list_delivery_risk_limit_tiers**](docs/DeliveryApi.md#list_delivery_risk_limit_tiers) | **GET** /delivery/{settle}/risk_limit_tiers | List risk limit tiers
*DeliveryApi* | [**list_price_triggered_delivery_orders**](docs/DeliveryApi.md#list_price_triggered_delivery_orders) | **GET** /delivery/{settle}/price_orders | List All Price-triggered Orders
*DeliveryApi* | [**create_price_triggered_delivery_order**](docs/DeliveryApi.md#create_price_triggered_delivery_order) | **POST** /delivery/{settle}/price_orders | Create a price-triggered order
*DeliveryApi* | [**cancel_price_triggered_delivery_order_list**](docs/DeliveryApi.md#cancel_price_triggered_delivery_order_list) | **DELETE** /delivery/{settle}/price_orders | Cancel All Price-triggered Orders
*DeliveryApi* | [**get_price_triggered_delivery_order**](docs/DeliveryApi.md#get_price_triggered_delivery_order) | **GET** /delivery/{settle}/price_orders/{order_id} | Get a price-triggered order
*DeliveryApi* | [**cancel_price_triggered_delivery_order**](docs/DeliveryApi.md#cancel_price_triggered_delivery_order) | **DELETE** /delivery/{settle}/price_orders/{order_id} | cancel a price-triggered order
*EarnApi* | [**swap_eth2**](docs/EarnApi.md#swap_eth2) | **POST** /earn/staking/eth2/swap | ETH2 swap
*EarnApi* | [**rate_list_eth2**](docs/EarnApi.md#rate_list_eth2) | **GET** /earn/staking/eth2/rate_records | ETH2 historical rate of return query
*EarnApi* | [**list_dual_investment_plans**](docs/EarnApi.md#list_dual_investment_plans) | **GET** /earn/dual/investment_plan | Dual Investment product list
*EarnApi* | [**list_dual_orders**](docs/EarnApi.md#list_dual_orders) | **GET** /earn/dual/orders | Dual Investment order list
*EarnApi* | [**place_dual_order**](docs/EarnApi.md#place_dual_order) | **POST** /earn/dual/orders | Place Dual Investment order
*EarnApi* | [**list_structured_products**](docs/EarnApi.md#list_structured_products) | **GET** /earn/structured/products | Structured Product List
*EarnApi* | [**list_structured_orders**](docs/EarnApi.md#list_structured_orders) | **GET** /earn/structured/orders | Structured Product Order List
*EarnApi* | [**place_structured_order**](docs/EarnApi.md#place_structured_order) | **POST** /earn/structured/orders | Place Structured Product Order
*EarnApi* | [**find_coin**](docs/EarnApi.md#find_coin) | **GET** /earn/staking/coins | Staking Coins
*EarnApi* | [**swap_staking_coin**](docs/EarnApi.md#swap_staking_coin) | **POST** /earn/staking/swap | On-chain Token Swap for Earned Coins
*FlashSwapApi* | [**list_flash_swap_currency_pair**](docs/FlashSwapApi.md#list_flash_swap_currency_pair) | **GET** /flash_swap/currency_pairs | List All Supported Currency Pairs In Flash Swap
*FlashSwapApi* | [**list_flash_swap_orders**](docs/FlashSwapApi.md#list_flash_swap_orders) | **GET** /flash_swap/orders | List all flash swap orders
*FlashSwapApi* | [**create_flash_swap_order**](docs/FlashSwapApi.md#create_flash_swap_order) | **POST** /flash_swap/orders | Create a flash swap order
*FlashSwapApi* | [**get_flash_swap_order**](docs/FlashSwapApi.md#get_flash_swap_order) | **GET** /flash_swap/orders/{order_id} | Get a single flash swap order&#39;s detail
*FlashSwapApi* | [**preview_flash_swap_order**](docs/FlashSwapApi.md#preview_flash_swap_order) | **POST** /flash_swap/orders/preview | Initiate a flash swap order preview
*FuturesApi* | [**list_futures_contracts**](docs/FuturesApi.md#list_futures_contracts) | **GET** /futures/{settle}/contracts | List all futures contracts
*FuturesApi* | [**get_futures_contract**](docs/FuturesApi.md#get_futures_contract) | **GET** /futures/{settle}/contracts/{contract} | Get a single contract
*FuturesApi* | [**list_futures_order_book**](docs/FuturesApi.md#list_futures_order_book) | **GET** /futures/{settle}/order_book | Futures order book
*FuturesApi* | [**list_futures_trades**](docs/FuturesApi.md#list_futures_trades) | **GET** /futures/{settle}/trades | Futures trading history
*FuturesApi* | [**list_futures_candlesticks**](docs/FuturesApi.md#list_futures_candlesticks) | **GET** /futures/{settle}/candlesticks | Get futures candlesticks
*FuturesApi* | [**list_futures_premium_index**](docs/FuturesApi.md#list_futures_premium_index) | **GET** /futures/{settle}/premium_index | Premium Index K-Line
*FuturesApi* | [**list_futures_tickers**](docs/FuturesApi.md#list_futures_tickers) | **GET** /futures/{settle}/tickers | List futures tickers
*FuturesApi* | [**list_futures_funding_rate_history**](docs/FuturesApi.md#list_futures_funding_rate_history) | **GET** /futures/{settle}/funding_rate | Funding rate history
*FuturesApi* | [**list_futures_insurance_ledger**](docs/FuturesApi.md#list_futures_insurance_ledger) | **GET** /futures/{settle}/insurance | Futures insurance balance history
*FuturesApi* | [**list_contract_stats**](docs/FuturesApi.md#list_contract_stats) | **GET** /futures/{settle}/contract_stats | Futures stats
*FuturesApi* | [**get_index_constituents**](docs/FuturesApi.md#get_index_constituents) | **GET** /futures/{settle}/index_constituents/{index} | Get index constituents
*FuturesApi* | [**list_liquidated_orders**](docs/FuturesApi.md#list_liquidated_orders) | **GET** /futures/{settle}/liq_orders | Retrieve liquidation history
*FuturesApi* | [**list_futures_risk_limit_tiers**](docs/FuturesApi.md#list_futures_risk_limit_tiers) | **GET** /futures/{settle}/risk_limit_tiers | List risk limit tiers
*FuturesApi* | [**list_futures_accounts**](docs/FuturesApi.md#list_futures_accounts) | **GET** /futures/{settle}/accounts | Query futures account
*FuturesApi* | [**list_futures_account_book**](docs/FuturesApi.md#list_futures_account_book) | **GET** /futures/{settle}/account_book | Query account book
*FuturesApi* | [**list_positions**](docs/FuturesApi.md#list_positions) | **GET** /futures/{settle}/positions | List all positions of a user
*FuturesApi* | [**get_position**](docs/FuturesApi.md#get_position) | **GET** /futures/{settle}/positions/{contract} | Get single position
*FuturesApi* | [**update_position_margin**](docs/FuturesApi.md#update_position_margin) | **POST** /futures/{settle}/positions/{contract}/margin | Update position margin
*FuturesApi* | [**update_position_leverage**](docs/FuturesApi.md#update_position_leverage) | **POST** /futures/{settle}/positions/{contract}/leverage | Update position leverage
*FuturesApi* | [**update_position_cross_mode**](docs/FuturesApi.md#update_position_cross_mode) | **POST** /futures/{settle}/positions/cross_mode | Switch to the full position-by-store mode
*FuturesApi* | [**update_position_risk_limit**](docs/FuturesApi.md#update_position_risk_limit) | **POST** /futures/{settle}/positions/{contract}/risk_limit | Update position risk limit
*FuturesApi* | [**set_dual_mode**](docs/FuturesApi.md#set_dual_mode) | **POST** /futures/{settle}/dual_mode | Enable or disable dual mode
*FuturesApi* | [**get_dual_mode_position**](docs/FuturesApi.md#get_dual_mode_position) | **GET** /futures/{settle}/dual_comp/positions/{contract} | Retrieve position detail in dual mode
*FuturesApi* | [**update_dual_mode_position_margin**](docs/FuturesApi.md#update_dual_mode_position_margin) | **POST** /futures/{settle}/dual_comp/positions/{contract}/margin | Update position margin in dual mode
*FuturesApi* | [**update_dual_mode_position_leverage**](docs/FuturesApi.md#update_dual_mode_position_leverage) | **POST** /futures/{settle}/dual_comp/positions/{contract}/leverage | Update position leverage in dual mode
*FuturesApi* | [**update_dual_mode_position_risk_limit**](docs/FuturesApi.md#update_dual_mode_position_risk_limit) | **POST** /futures/{settle}/dual_comp/positions/{contract}/risk_limit | Update position risk limit in dual mode
*FuturesApi* | [**list_futures_orders**](docs/FuturesApi.md#list_futures_orders) | **GET** /futures/{settle}/orders | List futures orders
*FuturesApi* | [**create_futures_order**](docs/FuturesApi.md#create_futures_order) | **POST** /futures/{settle}/orders | Create a futures order
*FuturesApi* | [**cancel_futures_orders**](docs/FuturesApi.md#cancel_futures_orders) | **DELETE** /futures/{settle}/orders | Cancel all &#x60;open&#x60; orders matched
*FuturesApi* | [**get_orders_with_time_range**](docs/FuturesApi.md#get_orders_with_time_range) | **GET** /futures/{settle}/orders_timerange | List Futures Orders By Time Range
*FuturesApi* | [**create_batch_futures_order**](docs/FuturesApi.md#create_batch_futures_order) | **POST** /futures/{settle}/batch_orders | Create a batch of futures orders
*FuturesApi* | [**get_futures_order**](docs/FuturesApi.md#get_futures_order) | **GET** /futures/{settle}/orders/{order_id} | Get a single order
*FuturesApi* | [**amend_futures_order**](docs/FuturesApi.md#amend_futures_order) | **PUT** /futures/{settle}/orders/{order_id} | Amend an order
*FuturesApi* | [**cancel_futures_order**](docs/FuturesApi.md#cancel_futures_order) | **DELETE** /futures/{settle}/orders/{order_id} | Cancel a single order
*FuturesApi* | [**get_my_trades**](docs/FuturesApi.md#get_my_trades) | **GET** /futures/{settle}/my_trades | List personal trading history
*FuturesApi* | [**get_my_trades_with_time_range**](docs/FuturesApi.md#get_my_trades_with_time_range) | **GET** /futures/{settle}/my_trades_timerange | List personal trading history by time range
*FuturesApi* | [**list_position_close**](docs/FuturesApi.md#list_position_close) | **GET** /futures/{settle}/position_close | List position close history
*FuturesApi* | [**list_liquidates**](docs/FuturesApi.md#list_liquidates) | **GET** /futures/{settle}/liquidates | List liquidation history
*FuturesApi* | [**list_auto_deleverages**](docs/FuturesApi.md#list_auto_deleverages) | **GET** /futures/{settle}/auto_deleverages | List Auto-Deleveraging History
*FuturesApi* | [**countdown_cancel_all_futures**](docs/FuturesApi.md#countdown_cancel_all_futures) | **POST** /futures/{settle}/countdown_cancel_all | Countdown cancel orders
*FuturesApi* | [**get_futures_fee**](docs/FuturesApi.md#get_futures_fee) | **GET** /futures/{settle}/fee | Query user trading fee rates
*FuturesApi* | [**cancel_batch_future_orders**](docs/FuturesApi.md#cancel_batch_future_orders) | **POST** /futures/{settle}/batch_cancel_orders | Cancel a batch of orders with an ID list
*FuturesApi* | [**amend_batch_future_orders**](docs/FuturesApi.md#amend_batch_future_orders) | **POST** /futures/{settle}/batch_amend_orders | Batch modify orders with specified IDs
*FuturesApi* | [**get_futures_risk_limit_table**](docs/FuturesApi.md#get_futures_risk_limit_table) | **GET** /futures/{settle}/risk_limit_table | Query risk limit table by table_id
*FuturesApi* | [**list_price_triggered_orders**](docs/FuturesApi.md#list_price_triggered_orders) | **GET** /futures/{settle}/price_orders | List All Price-triggered Orders
*FuturesApi* | [**create_price_triggered_order**](docs/FuturesApi.md#create_price_triggered_order) | **POST** /futures/{settle}/price_orders | Create a price-triggered order
*FuturesApi* | [**cancel_price_triggered_order_list**](docs/FuturesApi.md#cancel_price_triggered_order_list) | **DELETE** /futures/{settle}/price_orders | Cancel All Price-triggered Orders
*FuturesApi* | [**get_price_triggered_order**](docs/FuturesApi.md#get_price_triggered_order) | **GET** /futures/{settle}/price_orders/{order_id} | Get a price-triggered order
*FuturesApi* | [**cancel_price_triggered_order**](docs/FuturesApi.md#cancel_price_triggered_order) | **DELETE** /futures/{settle}/price_orders/{order_id} | cancel a price-triggered order
*MarginApi* | [**list_margin_accounts**](docs/MarginApi.md#list_margin_accounts) | **GET** /margin/accounts | Margin account list
*MarginApi* | [**list_margin_account_book**](docs/MarginApi.md#list_margin_account_book) | **GET** /margin/account_book | List margin account balance change history
*MarginApi* | [**list_funding_accounts**](docs/MarginApi.md#list_funding_accounts) | **GET** /margin/funding_accounts | Funding account list
*MarginApi* | [**get_auto_repay_status**](docs/MarginApi.md#get_auto_repay_status) | **GET** /margin/auto_repay | Retrieve user auto repayment setting
*MarginApi* | [**set_auto_repay**](docs/MarginApi.md#set_auto_repay) | **POST** /margin/auto_repay | Update user&#39;s auto repayment setting
*MarginApi* | [**get_margin_transferable**](docs/MarginApi.md#get_margin_transferable) | **GET** /margin/transferable | Get the max transferable amount for a specific margin currency
*MarginApi* | [**get_user_margin_tier**](docs/MarginApi.md#get_user_margin_tier) | **GET** /margin/user/loan_margin_tiers | Check the user&#39;s own leverage lending gradient in the current market
*MarginApi* | [**get_market_margin_tier**](docs/MarginApi.md#get_market_margin_tier) | **GET** /margin/loan_margin_tiers | Query the current market leverage lending gradient
*MarginApi* | [**set_user_market_leverage**](docs/MarginApi.md#set_user_market_leverage) | **POST** /margin/leverage/user_market_setting | Set the user market leverage multiple
*MarginApi* | [**list_margin_user_account**](docs/MarginApi.md#list_margin_user_account) | **GET** /margin/user/account | Query the user&#39;s leverage account list
*MarginApi* | [**list_cross_margin_loans**](docs/MarginApi.md#list_cross_margin_loans) | **GET** /margin/cross/loans | List cross margin borrow history. (deprecated)
*MarginApi* | [**list_cross_margin_repayments**](docs/MarginApi.md#list_cross_margin_repayments) | **GET** /margin/cross/repayments | Retrieve cross margin repayments. (deprecated)
*MultiCollateralLoanApi* | [**list_multi_collateral_orders**](docs/MultiCollateralLoanApi.md#list_multi_collateral_orders) | **GET** /loan/multi_collateral/orders | List Multi-Collateral Orders
*MultiCollateralLoanApi* | [**create_multi_collateral**](docs/MultiCollateralLoanApi.md#create_multi_collateral) | **POST** /loan/multi_collateral/orders | Create Multi-Collateral Order
*MultiCollateralLoanApi* | [**get_multi_collateral_order_detail**](docs/MultiCollateralLoanApi.md#get_multi_collateral_order_detail) | **GET** /loan/multi_collateral/orders/{order_id} | Get Multi-Collateral Order Detail
*MultiCollateralLoanApi* | [**list_multi_repay_records**](docs/MultiCollateralLoanApi.md#list_multi_repay_records) | **GET** /loan/multi_collateral/repay | List Multi-Collateral Repay Records
*MultiCollateralLoanApi* | [**repay_multi_collateral_loan**](docs/MultiCollateralLoanApi.md#repay_multi_collateral_loan) | **POST** /loan/multi_collateral/repay | Repay Multi-Collateral Loan
*MultiCollateralLoanApi* | [**list_multi_collateral_records**](docs/MultiCollateralLoanApi.md#list_multi_collateral_records) | **GET** /loan/multi_collateral/mortgage | Query collateral adjustment records
*MultiCollateralLoanApi* | [**operate_multi_collateral**](docs/MultiCollateralLoanApi.md#operate_multi_collateral) | **POST** /loan/multi_collateral/mortgage | Operate Multi-Collateral
*MultiCollateralLoanApi* | [**list_user_currency_quota**](docs/MultiCollateralLoanApi.md#list_user_currency_quota) | **GET** /loan/multi_collateral/currency_quota | List User Currency Quota
*MultiCollateralLoanApi* | [**list_multi_collateral_currencies**](docs/MultiCollateralLoanApi.md#list_multi_collateral_currencies) | **GET** /loan/multi_collateral/currencies | Query supported borrowing and collateral currencies in Multi-Collateral 
*MultiCollateralLoanApi* | [**get_multi_collateral_ltv**](docs/MultiCollateralLoanApi.md#get_multi_collateral_ltv) | **GET** /loan/multi_collateral/ltv | Get Multi-Collateral ratio
*MultiCollateralLoanApi* | [**get_multi_collateral_fix_rate**](docs/MultiCollateralLoanApi.md#get_multi_collateral_fix_rate) | **GET** /loan/multi_collateral/fixed_rate | Query fixed interest rates for the currency for 7 days and 30 days
*MultiCollateralLoanApi* | [**get_multi_collateral_current_rate**](docs/MultiCollateralLoanApi.md#get_multi_collateral_current_rate) | **GET** /loan/multi_collateral/current_rate | Query the current interest rate of the currency
*OptionsApi* | [**list_options_underlyings**](docs/OptionsApi.md#list_options_underlyings) | **GET** /options/underlyings | List all underlyings
*OptionsApi* | [**list_options_expirations**](docs/OptionsApi.md#list_options_expirations) | **GET** /options/expirations | List all expiration times
*OptionsApi* | [**list_options_contracts**](docs/OptionsApi.md#list_options_contracts) | **GET** /options/contracts | List all the contracts with specified underlying and expiration time
*OptionsApi* | [**get_options_contract**](docs/OptionsApi.md#get_options_contract) | **GET** /options/contracts/{contract} | Query specified contract detail
*OptionsApi* | [**list_options_settlements**](docs/OptionsApi.md#list_options_settlements) | **GET** /options/settlements | List settlement history
*OptionsApi* | [**get_options_settlement**](docs/OptionsApi.md#get_options_settlement) | **GET** /options/settlements/{contract} | Get specified contract&#39;s settlement
*OptionsApi* | [**list_my_options_settlements**](docs/OptionsApi.md#list_my_options_settlements) | **GET** /options/my_settlements | List my options settlements
*OptionsApi* | [**list_options_order_book**](docs/OptionsApi.md#list_options_order_book) | **GET** /options/order_book | Options order book
*OptionsApi* | [**list_options_tickers**](docs/OptionsApi.md#list_options_tickers) | **GET** /options/tickers | List tickers of options contracts
*OptionsApi* | [**list_options_underlying_tickers**](docs/OptionsApi.md#list_options_underlying_tickers) | **GET** /options/underlying/tickers/{underlying} | Get underlying ticker
*OptionsApi* | [**list_options_candlesticks**](docs/OptionsApi.md#list_options_candlesticks) | **GET** /options/candlesticks | Get options candlesticks
*OptionsApi* | [**list_options_underlying_candlesticks**](docs/OptionsApi.md#list_options_underlying_candlesticks) | **GET** /options/underlying/candlesticks | Mark price candlesticks of an underlying
*OptionsApi* | [**list_options_trades**](docs/OptionsApi.md#list_options_trades) | **GET** /options/trades | Options trade history
*OptionsApi* | [**list_options_account**](docs/OptionsApi.md#list_options_account) | **GET** /options/accounts | List options account
*OptionsApi* | [**list_options_account_book**](docs/OptionsApi.md#list_options_account_book) | **GET** /options/account_book | List account changing history
*OptionsApi* | [**list_options_positions**](docs/OptionsApi.md#list_options_positions) | **GET** /options/positions | List user&#39;s positions of specified underlying
*OptionsApi* | [**get_options_position**](docs/OptionsApi.md#get_options_position) | **GET** /options/positions/{contract} | Get specified contract position
*OptionsApi* | [**list_options_position_close**](docs/OptionsApi.md#list_options_position_close) | **GET** /options/position_close | List user&#39;s liquidation history of specified underlying
*OptionsApi* | [**list_options_orders**](docs/OptionsApi.md#list_options_orders) | **GET** /options/orders | List options orders
*OptionsApi* | [**create_options_order**](docs/OptionsApi.md#create_options_order) | **POST** /options/orders | Create an options order
*OptionsApi* | [**cancel_options_orders**](docs/OptionsApi.md#cancel_options_orders) | **DELETE** /options/orders | Cancel all &#x60;open&#x60; orders matched
*OptionsApi* | [**get_options_order**](docs/OptionsApi.md#get_options_order) | **GET** /options/orders/{order_id} | Get a single order
*OptionsApi* | [**cancel_options_order**](docs/OptionsApi.md#cancel_options_order) | **DELETE** /options/orders/{order_id} | Cancel a single order
*OptionsApi* | [**countdown_cancel_all_options**](docs/OptionsApi.md#countdown_cancel_all_options) | **POST** /options/countdown_cancel_all | Countdown cancel orders
*OptionsApi* | [**list_my_options_trades**](docs/OptionsApi.md#list_my_options_trades) | **GET** /options/my_trades | List personal trading history
*OptionsApi* | [**get_options_mmp**](docs/OptionsApi.md#get_options_mmp) | **GET** /options/mmp | MMP Query
*OptionsApi* | [**set_options_mmp**](docs/OptionsApi.md#set_options_mmp) | **POST** /options/mmp | MMP Settings
*OptionsApi* | [**reset_options_mmp**](docs/OptionsApi.md#reset_options_mmp) | **POST** /options/mmp/reset | MMP Reset
*RebateApi* | [**agency_transaction_history**](docs/RebateApi.md#agency_transaction_history) | **GET** /rebate/agency/transaction_history | The agency obtains the transaction history of the recommended user
*RebateApi* | [**agency_commissions_history**](docs/RebateApi.md#agency_commissions_history) | **GET** /rebate/agency/commission_history | The agency obtains the commission history of the recommended user
*RebateApi* | [**partner_transaction_history**](docs/RebateApi.md#partner_transaction_history) | **GET** /rebate/partner/transaction_history | Partner obtains transaction records of recommended users
*RebateApi* | [**partner_commissions_history**](docs/RebateApi.md#partner_commissions_history) | **GET** /rebate/partner/commission_history | Partner obtains commission records of recommended users
*RebateApi* | [**partner_sub_list**](docs/RebateApi.md#partner_sub_list) | **GET** /rebate/partner/sub_list | Partner subordinate list
*RebateApi* | [**rebate_broker_commission_history**](docs/RebateApi.md#rebate_broker_commission_history) | **GET** /rebate/broker/commission_history | The broker obtains the user&#39;s commission rebate records
*RebateApi* | [**rebate_broker_transaction_history**](docs/RebateApi.md#rebate_broker_transaction_history) | **GET** /rebate/broker/transaction_history | The broker obtains the user&#39;s trading history
*RebateApi* | [**rebate_user_info**](docs/RebateApi.md#rebate_user_info) | **GET** /rebate/user/info | User retrieves rebate information
*RebateApi* | [**user_sub_relation**](docs/RebateApi.md#user_sub_relation) | **GET** /rebate/user/sub_relation | User-subordinate relationship
*SpotApi* | [**list_currencies**](docs/SpotApi.md#list_currencies) | **GET** /spot/currencies | List all currencies&#39; details
*SpotApi* | [**get_currency**](docs/SpotApi.md#get_currency) | **GET** /spot/currencies/{currency} | Get details of a specific currency
*SpotApi* | [**list_currency_pairs**](docs/SpotApi.md#list_currency_pairs) | **GET** /spot/currency_pairs | List all currency pairs supported
*SpotApi* | [**get_currency_pair**](docs/SpotApi.md#get_currency_pair) | **GET** /spot/currency_pairs/{currency_pair} | Get details of a specifc currency pair
*SpotApi* | [**list_tickers**](docs/SpotApi.md#list_tickers) | **GET** /spot/tickers | Retrieve ticker information
*SpotApi* | [**list_order_book**](docs/SpotApi.md#list_order_book) | **GET** /spot/order_book | Retrieve order book
*SpotApi* | [**list_trades**](docs/SpotApi.md#list_trades) | **GET** /spot/trades | Retrieve market trades
*SpotApi* | [**list_candlesticks**](docs/SpotApi.md#list_candlesticks) | **GET** /spot/candlesticks | Market candlesticks
*SpotApi* | [**get_fee**](docs/SpotApi.md#get_fee) | **GET** /spot/fee | Query user trading fee rates
*SpotApi* | [**get_batch_spot_fee**](docs/SpotApi.md#get_batch_spot_fee) | **GET** /spot/batch_fee | Query a batch of user trading fee rates
*SpotApi* | [**list_spot_accounts**](docs/SpotApi.md#list_spot_accounts) | **GET** /spot/accounts | List spot accounts
*SpotApi* | [**list_spot_account_book**](docs/SpotApi.md#list_spot_account_book) | **GET** /spot/account_book | Query account book
*SpotApi* | [**create_batch_orders**](docs/SpotApi.md#create_batch_orders) | **POST** /spot/batch_orders | Create a batch of orders
*SpotApi* | [**list_all_open_orders**](docs/SpotApi.md#list_all_open_orders) | **GET** /spot/open_orders | List all open orders
*SpotApi* | [**create_cross_liquidate_order**](docs/SpotApi.md#create_cross_liquidate_order) | **POST** /spot/cross_liquidate_orders | close position when cross-currency is disabled
*SpotApi* | [**list_orders**](docs/SpotApi.md#list_orders) | **GET** /spot/orders | List orders
*SpotApi* | [**create_order**](docs/SpotApi.md#create_order) | **POST** /spot/orders | Create an order
*SpotApi* | [**cancel_orders**](docs/SpotApi.md#cancel_orders) | **DELETE** /spot/orders | Cancel all &#x60;open&#x60; orders in specified currency pair
*SpotApi* | [**cancel_batch_orders**](docs/SpotApi.md#cancel_batch_orders) | **POST** /spot/cancel_batch_orders | Cancel a batch of orders with an ID list
*SpotApi* | [**get_order**](docs/SpotApi.md#get_order) | **GET** /spot/orders/{order_id} | Get a single order
*SpotApi* | [**cancel_order**](docs/SpotApi.md#cancel_order) | **DELETE** /spot/orders/{order_id} | Cancel a single order
*SpotApi* | [**amend_order**](docs/SpotApi.md#amend_order) | **PATCH** /spot/orders/{order_id} | Amend an order
*SpotApi* | [**list_my_trades**](docs/SpotApi.md#list_my_trades) | **GET** /spot/my_trades | List personal trading history
*SpotApi* | [**get_system_time**](docs/SpotApi.md#get_system_time) | **GET** /spot/time | Get server current time
*SpotApi* | [**countdown_cancel_all_spot**](docs/SpotApi.md#countdown_cancel_all_spot) | **POST** /spot/countdown_cancel_all | Countdown cancel orders
*SpotApi* | [**amend_batch_orders**](docs/SpotApi.md#amend_batch_orders) | **POST** /spot/amend_batch_orders | Batch modification of orders
*SpotApi* | [**get_spot_insurance_history**](docs/SpotApi.md#get_spot_insurance_history) | **GET** /spot/insurance_history | Query spot insurance fund historical data
*SpotApi* | [**list_spot_price_triggered_orders**](docs/SpotApi.md#list_spot_price_triggered_orders) | **GET** /spot/price_orders | Retrieve running auto order list
*SpotApi* | [**create_spot_price_triggered_order**](docs/SpotApi.md#create_spot_price_triggered_order) | **POST** /spot/price_orders | Create a price-triggered order
*SpotApi* | [**cancel_spot_price_triggered_order_list**](docs/SpotApi.md#cancel_spot_price_triggered_order_list) | **DELETE** /spot/price_orders | Cancel All Price-triggered Orders
*SpotApi* | [**get_spot_price_triggered_order**](docs/SpotApi.md#get_spot_price_triggered_order) | **GET** /spot/price_orders/{order_id} | Get a price-triggered order
*SpotApi* | [**cancel_spot_price_triggered_order**](docs/SpotApi.md#cancel_spot_price_triggered_order) | **DELETE** /spot/price_orders/{order_id} | cancel a price-triggered order
*WalletApi* | [**list_currency_chains**](docs/WalletApi.md#list_currency_chains) | **GET** /wallet/currency_chains | List chains supported for specified currency
*WalletApi* | [**get_deposit_address**](docs/WalletApi.md#get_deposit_address) | **GET** /wallet/deposit_address | Generate currency deposit address
*WalletApi* | [**list_withdrawals**](docs/WalletApi.md#list_withdrawals) | **GET** /wallet/withdrawals | Retrieve withdrawal records
*WalletApi* | [**list_deposits**](docs/WalletApi.md#list_deposits) | **GET** /wallet/deposits | Retrieve deposit records
*WalletApi* | [**transfer**](docs/WalletApi.md#transfer) | **POST** /wallet/transfers | Transfer between trading accounts
*WalletApi* | [**list_sub_account_transfers**](docs/WalletApi.md#list_sub_account_transfers) | **GET** /wallet/sub_account_transfers | Retrieve transfer records between main and sub accounts
*WalletApi* | [**transfer_with_sub_account**](docs/WalletApi.md#transfer_with_sub_account) | **POST** /wallet/sub_account_transfers | Transfer between main and sub accounts
*WalletApi* | [**sub_account_to_sub_account**](docs/WalletApi.md#sub_account_to_sub_account) | **POST** /wallet/sub_account_to_sub_account | Sub-account transfers to sub-account
*WalletApi* | [**get_transfer_order_status**](docs/WalletApi.md#get_transfer_order_status) | **GET** /wallet/order_status | Transfer status query
*WalletApi* | [**list_withdraw_status**](docs/WalletApi.md#list_withdraw_status) | **GET** /wallet/withdraw_status | Retrieve withdrawal status
*WalletApi* | [**list_sub_account_balances**](docs/WalletApi.md#list_sub_account_balances) | **GET** /wallet/sub_account_balances | Retrieve sub account balances
*WalletApi* | [**list_sub_account_margin_balances**](docs/WalletApi.md#list_sub_account_margin_balances) | **GET** /wallet/sub_account_margin_balances | Query sub accounts&#39; margin balances
*WalletApi* | [**list_sub_account_futures_balances**](docs/WalletApi.md#list_sub_account_futures_balances) | **GET** /wallet/sub_account_futures_balances | Query sub accounts&#39; futures account balances
*WalletApi* | [**list_sub_account_cross_margin_balances**](docs/WalletApi.md#list_sub_account_cross_margin_balances) | **GET** /wallet/sub_account_cross_margin_balances | Query subaccount&#39;s cross_margin account info
*WalletApi* | [**list_saved_address**](docs/WalletApi.md#list_saved_address) | **GET** /wallet/saved_address | Query saved address
*WalletApi* | [**get_trade_fee**](docs/WalletApi.md#get_trade_fee) | **GET** /wallet/fee | Retrieve personal trading fee
*WalletApi* | [**get_total_balance**](docs/WalletApi.md#get_total_balance) | **GET** /wallet/total_balance | Retrieve user&#39;s total balances
*WalletApi* | [**list_small_balance**](docs/WalletApi.md#list_small_balance) | **GET** /wallet/small_balance | List small balance
*WalletApi* | [**convert_small_balance**](docs/WalletApi.md#convert_small_balance) | **POST** /wallet/small_balance | Convert small balance
*WalletApi* | [**list_small_balance_history**](docs/WalletApi.md#list_small_balance_history) | **GET** /wallet/small_balance_history | List small balance history
*WalletApi* | [**list_push_orders**](docs/WalletApi.md#list_push_orders) | **GET** /wallet/push | Retrieve the UID transfer history
*WithdrawalApi* | [**withdraw**](docs/WithdrawalApi.md#withdraw) | **POST** /withdrawals | Withdraw
*WithdrawalApi* | [**withdraw_push_order**](docs/WithdrawalApi.md#withdraw_push_order) | **POST** /withdrawals/push | UID transfer
*WithdrawalApi* | [**cancel_withdrawal**](docs/WithdrawalApi.md#cancel_withdrawal) | **DELETE** /withdrawals/{withdrawal_id} | Cancel withdrawal with specified ID


## Documentation For Models

 - [AccountBalance](docs/AccountBalance.md)
 - [AccountDetail](docs/AccountDetail.md)
 - [AccountDetailKey](docs/AccountDetailKey.md)
 - [AccountRateLimit](docs/AccountRateLimit.md)
 - [AgencyCommission](docs/AgencyCommission.md)
 - [AgencyCommissionHistory](docs/AgencyCommissionHistory.md)
 - [AgencyTransaction](docs/AgencyTransaction.md)
 - [AgencyTransactionHistory](docs/AgencyTransactionHistory.md)
 - [AutoRepaySetting](docs/AutoRepaySetting.md)
 - [BatchAmendItem](docs/BatchAmendItem.md)
 - [BatchAmendOrderReq](docs/BatchAmendOrderReq.md)
 - [BatchFuturesOrder](docs/BatchFuturesOrder.md)
 - [BatchOrder](docs/BatchOrder.md)
 - [BorrowCurrencyInfo](docs/BorrowCurrencyInfo.md)
 - [BrokerCommission](docs/BrokerCommission.md)
 - [BrokerCommission1](docs/BrokerCommission1.md)
 - [BrokerCommissionSubBrokerInfo](docs/BrokerCommissionSubBrokerInfo.md)
 - [BrokerTransaction](docs/BrokerTransaction.md)
 - [BrokerTransaction1](docs/BrokerTransaction1.md)
 - [CancelBatchOrder](docs/CancelBatchOrder.md)
 - [CancelOrderResult](docs/CancelOrderResult.md)
 - [CollateralAdjust](docs/CollateralAdjust.md)
 - [CollateralAdjustRes](docs/CollateralAdjustRes.md)
 - [CollateralAlign](docs/CollateralAlign.md)
 - [CollateralCurrency](docs/CollateralCurrency.md)
 - [CollateralCurrencyInfo](docs/CollateralCurrencyInfo.md)
 - [CollateralCurrencyRes](docs/CollateralCurrencyRes.md)
 - [CollateralCurrentRate](docs/CollateralCurrentRate.md)
 - [CollateralFixRate](docs/CollateralFixRate.md)
 - [CollateralLoanCurrency](docs/CollateralLoanCurrency.md)
 - [CollateralLtv](docs/CollateralLtv.md)
 - [CollateralOrder](docs/CollateralOrder.md)
 - [CollateralRecord](docs/CollateralRecord.md)
 - [Contract](docs/Contract.md)
 - [ContractStat](docs/ContractStat.md)
 - [ConvertSmallBalance](docs/ConvertSmallBalance.md)
 - [CountdownCancelAllFuturesTask](docs/CountdownCancelAllFuturesTask.md)
 - [CountdownCancelAllOptionsTask](docs/CountdownCancelAllOptionsTask.md)
 - [CountdownCancelAllSpotTask](docs/CountdownCancelAllSpotTask.md)
 - [CreateCollateralOrder](docs/CreateCollateralOrder.md)
 - [CreateMultiCollateralOrder](docs/CreateMultiCollateralOrder.md)
 - [CreateUniLend](docs/CreateUniLend.md)
 - [CreateUniLoan](docs/CreateUniLoan.md)
 - [CrossMarginBalance](docs/CrossMarginBalance.md)
 - [CrossMarginLoan](docs/CrossMarginLoan.md)
 - [CrossMarginRepayment](docs/CrossMarginRepayment.md)
 - [Currency](docs/Currency.md)
 - [CurrencyChain](docs/CurrencyChain.md)
 - [CurrencyPair](docs/CurrencyPair.md)
 - [CurrencyQuota](docs/CurrencyQuota.md)
 - [DebitFee](docs/DebitFee.md)
 - [DeliveryCandlestick](docs/DeliveryCandlestick.md)
 - [DeliveryContract](docs/DeliveryContract.md)
 - [DeliverySettlement](docs/DeliverySettlement.md)
 - [DeliveryTicker](docs/DeliveryTicker.md)
 - [DepositAddress](docs/DepositAddress.md)
 - [DepositRecord](docs/DepositRecord.md)
 - [DualGetOrders](docs/DualGetOrders.md)
 - [DualGetPlans](docs/DualGetPlans.md)
 - [Eth2RateList](docs/Eth2RateList.md)
 - [Eth2Swap](docs/Eth2Swap.md)
 - [FindCoin](docs/FindCoin.md)
 - [FlashSwapCurrencyPair](docs/FlashSwapCurrencyPair.md)
 - [FlashSwapOrder](docs/FlashSwapOrder.md)
 - [FlashSwapOrderPreview](docs/FlashSwapOrderPreview.md)
 - [FlashSwapOrderRequest](docs/FlashSwapOrderRequest.md)
 - [FlashSwapPreviewRequest](docs/FlashSwapPreviewRequest.md)
 - [FundingAccount](docs/FundingAccount.md)
 - [FundingRateRecord](docs/FundingRateRecord.md)
 - [FutureCancelOrderResult](docs/FutureCancelOrderResult.md)
 - [FuturesAccount](docs/FuturesAccount.md)
 - [FuturesAccountBook](docs/FuturesAccountBook.md)
 - [FuturesAccountHistory](docs/FuturesAccountHistory.md)
 - [FuturesAutoDeleverage](docs/FuturesAutoDeleverage.md)
 - [FuturesBatchAmendOrderRequest](docs/FuturesBatchAmendOrderRequest.md)
 - [FuturesCandlestick](docs/FuturesCandlestick.md)
 - [FuturesFee](docs/FuturesFee.md)
 - [FuturesIndexConstituents](docs/FuturesIndexConstituents.md)
 - [FuturesInitialOrder](docs/FuturesInitialOrder.md)
 - [FuturesLimitRiskTiers](docs/FuturesLimitRiskTiers.md)
 - [FuturesLiqOrder](docs/FuturesLiqOrder.md)
 - [FuturesLiquidate](docs/FuturesLiquidate.md)
 - [FuturesOrder](docs/FuturesOrder.md)
 - [FuturesOrderAmendment](docs/FuturesOrderAmendment.md)
 - [FuturesOrderBook](docs/FuturesOrderBook.md)
 - [FuturesOrderBookItem](docs/FuturesOrderBookItem.md)
 - [FuturesPositionCrossMode](docs/FuturesPositionCrossMode.md)
 - [FuturesPremiumIndex](docs/FuturesPremiumIndex.md)
 - [FuturesPriceTrigger](docs/FuturesPriceTrigger.md)
 - [FuturesPriceTriggeredOrder](docs/FuturesPriceTriggeredOrder.md)
 - [FuturesRiskLimitTier](docs/FuturesRiskLimitTier.md)
 - [FuturesTicker](docs/FuturesTicker.md)
 - [FuturesTrade](docs/FuturesTrade.md)
 - [IndexConstituent](docs/IndexConstituent.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InsuranceRecord](docs/InsuranceRecord.md)
 - [LedgerRecord](docs/LedgerRecord.md)
 - [LiquidateOrder](docs/LiquidateOrder.md)
 - [MarginAccount](docs/MarginAccount.md)
 - [MarginAccountBook](docs/MarginAccountBook.md)
 - [MarginAccountCurrency](docs/MarginAccountCurrency.md)
 - [MarginLeverageTier](docs/MarginLeverageTier.md)
 - [MarginMarketLeverage](docs/MarginMarketLeverage.md)
 - [MarginTiers](docs/MarginTiers.md)
 - [MarginTransferable](docs/MarginTransferable.md)
 - [MaxUniBorrowable](docs/MaxUniBorrowable.md)
 - [MockFuturesOrder](docs/MockFuturesOrder.md)
 - [MockFuturesPosition](docs/MockFuturesPosition.md)
 - [MockMarginResult](docs/MockMarginResult.md)
 - [MockOptionsOrder](docs/MockOptionsOrder.md)
 - [MockOptionsPosition](docs/MockOptionsPosition.md)
 - [MockRiskUnit](docs/MockRiskUnit.md)
 - [MockSpotBalance](docs/MockSpotBalance.md)
 - [MockSpotOrder](docs/MockSpotOrder.md)
 - [MultiChainAddressItem](docs/MultiChainAddressItem.md)
 - [MultiCollateralCurrency](docs/MultiCollateralCurrency.md)
 - [MultiCollateralItem](docs/MultiCollateralItem.md)
 - [MultiCollateralOrder](docs/MultiCollateralOrder.md)
 - [MultiCollateralRecord](docs/MultiCollateralRecord.md)
 - [MultiCollateralRecordCurrency](docs/MultiCollateralRecordCurrency.md)
 - [MultiLoanItem](docs/MultiLoanItem.md)
 - [MultiLoanRepayItem](docs/MultiLoanRepayItem.md)
 - [MultiRepayRecord](docs/MultiRepayRecord.md)
 - [MultiRepayResp](docs/MultiRepayResp.md)
 - [MyFuturesTrade](docs/MyFuturesTrade.md)
 - [MyFuturesTradeTimeRange](docs/MyFuturesTradeTimeRange.md)
 - [OpenOrders](docs/OpenOrders.md)
 - [OptionsAccount](docs/OptionsAccount.md)
 - [OptionsAccountBook](docs/OptionsAccountBook.md)
 - [OptionsCandlestick](docs/OptionsCandlestick.md)
 - [OptionsContract](docs/OptionsContract.md)
 - [OptionsMMP](docs/OptionsMMP.md)
 - [OptionsMMPReset](docs/OptionsMMPReset.md)
 - [OptionsMySettlements](docs/OptionsMySettlements.md)
 - [OptionsMyTrade](docs/OptionsMyTrade.md)
 - [OptionsOrder](docs/OptionsOrder.md)
 - [OptionsPosition](docs/OptionsPosition.md)
 - [OptionsPositionClose](docs/OptionsPositionClose.md)
 - [OptionsPositionCloseOrder](docs/OptionsPositionCloseOrder.md)
 - [OptionsSettlement](docs/OptionsSettlement.md)
 - [OptionsTicker](docs/OptionsTicker.md)
 - [OptionsUnderlying](docs/OptionsUnderlying.md)
 - [OptionsUnderlyingTicker](docs/OptionsUnderlyingTicker.md)
 - [Order](docs/Order.md)
 - [OrderBook](docs/OrderBook.md)
 - [OrderCancel](docs/OrderCancel.md)
 - [OrderPatch](docs/OrderPatch.md)
 - [OrderResp](docs/OrderResp.md)
 - [PartnerCommissionHistory](docs/PartnerCommissionHistory.md)
 - [PartnerSub](docs/PartnerSub.md)
 - [PartnerSubList](docs/PartnerSubList.md)
 - [PartnerTransactionHistory](docs/PartnerTransactionHistory.md)
 - [PatchUniLend](docs/PatchUniLend.md)
 - [PlaceDualInvestmentOrder](docs/PlaceDualInvestmentOrder.md)
 - [Position](docs/Position.md)
 - [PositionClose](docs/PositionClose.md)
 - [PositionCloseOrder](docs/PositionCloseOrder.md)
 - [ProfitLossRange](docs/ProfitLossRange.md)
 - [RebateUserInfo](docs/RebateUserInfo.md)
 - [RepayCurrencyRes](docs/RepayCurrencyRes.md)
 - [RepayLoan](docs/RepayLoan.md)
 - [RepayMultiLoan](docs/RepayMultiLoan.md)
 - [RepayRecord](docs/RepayRecord.md)
 - [RepayRecordCurrency](docs/RepayRecordCurrency.md)
 - [RepayRecordLeftInterest](docs/RepayRecordLeftInterest.md)
 - [RepayRecordRepaidCurrency](docs/RepayRecordRepaidCurrency.md)
 - [RepayRecordTotalInterest](docs/RepayRecordTotalInterest.md)
 - [RepayResp](docs/RepayResp.md)
 - [RiskUnits](docs/RiskUnits.md)
 - [SavedAddress](docs/SavedAddress.md)
 - [SmallBalance](docs/SmallBalance.md)
 - [SmallBalanceHistory](docs/SmallBalanceHistory.md)
 - [SpotAccount](docs/SpotAccount.md)
 - [SpotAccountBook](docs/SpotAccountBook.md)
 - [SpotCurrencyChain](docs/SpotCurrencyChain.md)
 - [SpotFee](docs/SpotFee.md)
 - [SpotInsuranceHistory](docs/SpotInsuranceHistory.md)
 - [SpotPricePutOrder](docs/SpotPricePutOrder.md)
 - [SpotPriceTrigger](docs/SpotPriceTrigger.md)
 - [SpotPriceTriggeredOrder](docs/SpotPriceTriggeredOrder.md)
 - [StpGroup](docs/StpGroup.md)
 - [StpGroupUser](docs/StpGroupUser.md)
 - [StructuredBuy](docs/StructuredBuy.md)
 - [StructuredGetProjectList](docs/StructuredGetProjectList.md)
 - [StructuredOrderList](docs/StructuredOrderList.md)
 - [SubAccount](docs/SubAccount.md)
 - [SubAccountBalance](docs/SubAccountBalance.md)
 - [SubAccountCrossMarginBalance](docs/SubAccountCrossMarginBalance.md)
 - [SubAccountFuturesBalance](docs/SubAccountFuturesBalance.md)
 - [SubAccountKey](docs/SubAccountKey.md)
 - [SubAccountKeyPerms](docs/SubAccountKeyPerms.md)
 - [SubAccountMarginBalance](docs/SubAccountMarginBalance.md)
 - [SubAccountToSubAccount](docs/SubAccountToSubAccount.md)
 - [SubAccountTransfer](docs/SubAccountTransfer.md)
 - [SubAccountTransferRecordItem](docs/SubAccountTransferRecordItem.md)
 - [SubCrossMarginAccount](docs/SubCrossMarginAccount.md)
 - [SubUserMode](docs/SubUserMode.md)
 - [SwapCoin](docs/SwapCoin.md)
 - [SwapCoinStruct](docs/SwapCoinStruct.md)
 - [SystemTime](docs/SystemTime.md)
 - [Ticker](docs/Ticker.md)
 - [TotalBalance](docs/TotalBalance.md)
 - [Trade](docs/Trade.md)
 - [TradeFee](docs/TradeFee.md)
 - [TransactionID](docs/TransactionID.md)
 - [Transfer](docs/Transfer.md)
 - [TransferOrderStatus](docs/TransferOrderStatus.md)
 - [TransferablesResult](docs/TransferablesResult.md)
 - [TriggerOrderResponse](docs/TriggerOrderResponse.md)
 - [TriggerTime](docs/TriggerTime.md)
 - [UidPushOrder](docs/UidPushOrder.md)
 - [UidPushWithdrawal](docs/UidPushWithdrawal.md)
 - [UidPushWithdrawalResp](docs/UidPushWithdrawalResp.md)
 - [UniCurrency](docs/UniCurrency.md)
 - [UniCurrencyInterest](docs/UniCurrencyInterest.md)
 - [UniCurrencyPair](docs/UniCurrencyPair.md)
 - [UniInterestRecord](docs/UniInterestRecord.md)
 - [UniLend](docs/UniLend.md)
 - [UniLendInterest](docs/UniLendInterest.md)
 - [UniLendRecord](docs/UniLendRecord.md)
 - [UniLoan](docs/UniLoan.md)
 - [UniLoanInterestRecord](docs/UniLoanInterestRecord.md)
 - [UniLoanRecord](docs/UniLoanRecord.md)
 - [UnifiedAccount](docs/UnifiedAccount.md)
 - [UnifiedBalance](docs/UnifiedBalance.md)
 - [UnifiedBorrowable](docs/UnifiedBorrowable.md)
 - [UnifiedBorrowable1](docs/UnifiedBorrowable1.md)
 - [UnifiedCollateralReq](docs/UnifiedCollateralReq.md)
 - [UnifiedCollateralRes](docs/UnifiedCollateralRes.md)
 - [UnifiedCurrency](docs/UnifiedCurrency.md)
 - [UnifiedDiscount](docs/UnifiedDiscount.md)
 - [UnifiedDiscountTiers](docs/UnifiedDiscountTiers.md)
 - [UnifiedHistoryLoanRate](docs/UnifiedHistoryLoanRate.md)
 - [UnifiedHistoryLoanRateRates](docs/UnifiedHistoryLoanRateRates.md)
 - [UnifiedLeverageConfig](docs/UnifiedLeverageConfig.md)
 - [UnifiedLeverageSetting](docs/UnifiedLeverageSetting.md)
 - [UnifiedLoan](docs/UnifiedLoan.md)
 - [UnifiedLoanRecord](docs/UnifiedLoanRecord.md)
 - [UnifiedLoanResult](docs/UnifiedLoanResult.md)
 - [UnifiedMarginTiers](docs/UnifiedMarginTiers.md)
 - [UnifiedModeSet](docs/UnifiedModeSet.md)
 - [UnifiedPortfolioInput](docs/UnifiedPortfolioInput.md)
 - [UnifiedPortfolioOutput](docs/UnifiedPortfolioOutput.md)
 - [UnifiedRiskUnits](docs/UnifiedRiskUnits.md)
 - [UnifiedSettings](docs/UnifiedSettings.md)
 - [UnifiedTransferable](docs/UnifiedTransferable.md)
 - [UserLtvInfo](docs/UserLtvInfo.md)
 - [UserSub](docs/UserSub.md)
 - [UserSubRelation](docs/UserSubRelation.md)
 - [UserTotalAmount](docs/UserTotalAmount.md)
 - [WithdrawStatus](docs/WithdrawStatus.md)
 - [WithdrawalRecord](docs/WithdrawalRecord.md)


## Documentation For Authorization


## apiv4

Authentication with APIv4 key and secret

For details, refer to:
[APIv4 signed request requirements](https://www.gate.com/docs/apiv4/en/index.html#apiv4-signed-request-requirements)


## Author

support@mail.gate.com


