# coding: utf-8

"""
    Gate API

    Welcome to Gate API  APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces for implementing API-based automated trading.  # noqa: E501

    Contact: support@mail.gate.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class AccountRateLimit(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'tier': 'str',
        'ratio': 'str',
        'main_ratio': 'str',
        'updated_at': 'str'
    }

    attribute_map = {
        'tier': 'tier',
        'ratio': 'ratio',
        'main_ratio': 'main_ratio',
        'updated_at': 'updated_at'
    }

    def __init__(self, tier=None, ratio=None, main_ratio=None, updated_at=None, local_vars_configuration=None):  # noqa: E501
        # type: (str, str, str, str, Configuration) -> None
        """AccountRateLimit - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._tier = None
        self._ratio = None
        self._main_ratio = None
        self._updated_at = None
        self.discriminator = None

        if tier is not None:
            self.tier = tier
        if ratio is not None:
            self.ratio = ratio
        if main_ratio is not None:
            self.main_ratio = main_ratio
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def tier(self):
        """Gets the tier of this AccountRateLimit.  # noqa: E501

        Frequency limit level (For detailed frequency limit rules, see [Transaction ratio frequency limit](#rate-limit-based-on-fill-ratio))  # noqa: E501

        :return: The tier of this AccountRateLimit.  # noqa: E501
        :rtype: str
        """
        return self._tier

    @tier.setter
    def tier(self, tier):
        """Sets the tier of this AccountRateLimit.

        Frequency limit level (For detailed frequency limit rules, see [Transaction ratio frequency limit](#rate-limit-based-on-fill-ratio))  # noqa: E501

        :param tier: The tier of this AccountRateLimit.  # noqa: E501
        :type: str
        """

        self._tier = tier

    @property
    def ratio(self):
        """Gets the ratio of this AccountRateLimit.  # noqa: E501

        Transaction rate  # noqa: E501

        :return: The ratio of this AccountRateLimit.  # noqa: E501
        :rtype: str
        """
        return self._ratio

    @ratio.setter
    def ratio(self, ratio):
        """Sets the ratio of this AccountRateLimit.

        Transaction rate  # noqa: E501

        :param ratio: The ratio of this AccountRateLimit.  # noqa: E501
        :type: str
        """

        self._ratio = ratio

    @property
    def main_ratio(self):
        """Gets the main_ratio of this AccountRateLimit.  # noqa: E501

        Total transaction ratio of main account  # noqa: E501

        :return: The main_ratio of this AccountRateLimit.  # noqa: E501
        :rtype: str
        """
        return self._main_ratio

    @main_ratio.setter
    def main_ratio(self, main_ratio):
        """Sets the main_ratio of this AccountRateLimit.

        Total transaction ratio of main account  # noqa: E501

        :param main_ratio: The main_ratio of this AccountRateLimit.  # noqa: E501
        :type: str
        """

        self._main_ratio = main_ratio

    @property
    def updated_at(self):
        """Gets the updated_at of this AccountRateLimit.  # noqa: E501

        Update time  # noqa: E501

        :return: The updated_at of this AccountRateLimit.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this AccountRateLimit.

        Update time  # noqa: E501

        :param updated_at: The updated_at of this AccountRateLimit.  # noqa: E501
        :type: str
        """

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccountRateLimit):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AccountRateLimit):
            return True

        return self.to_dict() != other.to_dict()
