# coding: utf-8

"""
    Gate API

    Welcome to Gate API  APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces for implementing API-based automated trading.  # noqa: E501

    Contact: support@mail.gate.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class BatchOrder(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'order_id': 'str',
        'amend_text': 'str',
        'text': 'str',
        'succeeded': 'bool',
        'label': 'str',
        'message': 'str',
        'id': 'str',
        'create_time': 'str',
        'update_time': 'str',
        'create_time_ms': 'int',
        'update_time_ms': 'int',
        'status': 'str',
        'currency_pair': 'str',
        'type': 'str',
        'account': 'str',
        'side': 'str',
        'amount': 'str',
        'price': 'str',
        'time_in_force': 'str',
        'iceberg': 'str',
        'auto_borrow': 'bool',
        'auto_repay': 'bool',
        'left': 'str',
        'filled_amount': 'str',
        'fill_price': 'str',
        'filled_total': 'str',
        'avg_deal_price': 'str',
        'fee': 'str',
        'fee_currency': 'str',
        'point_fee': 'str',
        'gt_fee': 'str',
        'gt_discount': 'bool',
        'rebated_fee': 'str',
        'rebated_fee_currency': 'str',
        'stp_id': 'int',
        'stp_act': 'str',
        'finish_as': 'str'
    }

    attribute_map = {
        'order_id': 'order_id',
        'amend_text': 'amend_text',
        'text': 'text',
        'succeeded': 'succeeded',
        'label': 'label',
        'message': 'message',
        'id': 'id',
        'create_time': 'create_time',
        'update_time': 'update_time',
        'create_time_ms': 'create_time_ms',
        'update_time_ms': 'update_time_ms',
        'status': 'status',
        'currency_pair': 'currency_pair',
        'type': 'type',
        'account': 'account',
        'side': 'side',
        'amount': 'amount',
        'price': 'price',
        'time_in_force': 'time_in_force',
        'iceberg': 'iceberg',
        'auto_borrow': 'auto_borrow',
        'auto_repay': 'auto_repay',
        'left': 'left',
        'filled_amount': 'filled_amount',
        'fill_price': 'fill_price',
        'filled_total': 'filled_total',
        'avg_deal_price': 'avg_deal_price',
        'fee': 'fee',
        'fee_currency': 'fee_currency',
        'point_fee': 'point_fee',
        'gt_fee': 'gt_fee',
        'gt_discount': 'gt_discount',
        'rebated_fee': 'rebated_fee',
        'rebated_fee_currency': 'rebated_fee_currency',
        'stp_id': 'stp_id',
        'stp_act': 'stp_act',
        'finish_as': 'finish_as'
    }

    def __init__(self, order_id=None, amend_text=None, text=None, succeeded=None, label=None, message=None, id=None, create_time=None, update_time=None, create_time_ms=None, update_time_ms=None, status=None, currency_pair=None, type='limit', account='spot', side=None, amount=None, price=None, time_in_force='gtc', iceberg=None, auto_borrow=None, auto_repay=None, left=None, filled_amount=None, fill_price=None, filled_total=None, avg_deal_price=None, fee=None, fee_currency=None, point_fee=None, gt_fee=None, gt_discount=None, rebated_fee=None, rebated_fee_currency=None, stp_id=None, stp_act=None, finish_as=None, local_vars_configuration=None):  # noqa: E501
        # type: (str, str, str, bool, str, str, str, str, str, int, int, str, str, str, str, str, str, str, str, str, bool, bool, str, str, str, str, str, str, str, str, str, bool, str, str, int, str, str, Configuration) -> None
        """BatchOrder - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._order_id = None
        self._amend_text = None
        self._text = None
        self._succeeded = None
        self._label = None
        self._message = None
        self._id = None
        self._create_time = None
        self._update_time = None
        self._create_time_ms = None
        self._update_time_ms = None
        self._status = None
        self._currency_pair = None
        self._type = None
        self._account = None
        self._side = None
        self._amount = None
        self._price = None
        self._time_in_force = None
        self._iceberg = None
        self._auto_borrow = None
        self._auto_repay = None
        self._left = None
        self._filled_amount = None
        self._fill_price = None
        self._filled_total = None
        self._avg_deal_price = None
        self._fee = None
        self._fee_currency = None
        self._point_fee = None
        self._gt_fee = None
        self._gt_discount = None
        self._rebated_fee = None
        self._rebated_fee_currency = None
        self._stp_id = None
        self._stp_act = None
        self._finish_as = None
        self.discriminator = None

        if order_id is not None:
            self.order_id = order_id
        if amend_text is not None:
            self.amend_text = amend_text
        if text is not None:
            self.text = text
        if succeeded is not None:
            self.succeeded = succeeded
        if label is not None:
            self.label = label
        if message is not None:
            self.message = message
        if id is not None:
            self.id = id
        if create_time is not None:
            self.create_time = create_time
        if update_time is not None:
            self.update_time = update_time
        if create_time_ms is not None:
            self.create_time_ms = create_time_ms
        if update_time_ms is not None:
            self.update_time_ms = update_time_ms
        if status is not None:
            self.status = status
        if currency_pair is not None:
            self.currency_pair = currency_pair
        if type is not None:
            self.type = type
        if account is not None:
            self.account = account
        if side is not None:
            self.side = side
        if amount is not None:
            self.amount = amount
        if price is not None:
            self.price = price
        if time_in_force is not None:
            self.time_in_force = time_in_force
        if iceberg is not None:
            self.iceberg = iceberg
        if auto_borrow is not None:
            self.auto_borrow = auto_borrow
        if auto_repay is not None:
            self.auto_repay = auto_repay
        if left is not None:
            self.left = left
        if filled_amount is not None:
            self.filled_amount = filled_amount
        if fill_price is not None:
            self.fill_price = fill_price
        if filled_total is not None:
            self.filled_total = filled_total
        if avg_deal_price is not None:
            self.avg_deal_price = avg_deal_price
        if fee is not None:
            self.fee = fee
        if fee_currency is not None:
            self.fee_currency = fee_currency
        if point_fee is not None:
            self.point_fee = point_fee
        if gt_fee is not None:
            self.gt_fee = gt_fee
        if gt_discount is not None:
            self.gt_discount = gt_discount
        if rebated_fee is not None:
            self.rebated_fee = rebated_fee
        if rebated_fee_currency is not None:
            self.rebated_fee_currency = rebated_fee_currency
        if stp_id is not None:
            self.stp_id = stp_id
        if stp_act is not None:
            self.stp_act = stp_act
        if finish_as is not None:
            self.finish_as = finish_as

    @property
    def order_id(self):
        """Gets the order_id of this BatchOrder.  # noqa: E501

        Order ID  # noqa: E501

        :return: The order_id of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this BatchOrder.

        Order ID  # noqa: E501

        :param order_id: The order_id of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._order_id = order_id

    @property
    def amend_text(self):
        """Gets the amend_text of this BatchOrder.  # noqa: E501

        The custom data that the user remarked when amending the order  # noqa: E501

        :return: The amend_text of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._amend_text

    @amend_text.setter
    def amend_text(self, amend_text):
        """Sets the amend_text of this BatchOrder.

        The custom data that the user remarked when amending the order  # noqa: E501

        :param amend_text: The amend_text of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._amend_text = amend_text

    @property
    def text(self):
        """Gets the text of this BatchOrder.  # noqa: E501

        User defined information. If not empty, must follow the rules below:  1. prefixed with `t-` 2. no longer than 28 bytes without `t-` prefix 3. can only include 0-9, A-Z, a-z, underscore(_), hyphen(-) or dot(.)   # noqa: E501

        :return: The text of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this BatchOrder.

        User defined information. If not empty, must follow the rules below:  1. prefixed with `t-` 2. no longer than 28 bytes without `t-` prefix 3. can only include 0-9, A-Z, a-z, underscore(_), hyphen(-) or dot(.)   # noqa: E501

        :param text: The text of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._text = text

    @property
    def succeeded(self):
        """Gets the succeeded of this BatchOrder.  # noqa: E501

        Whether the batch of orders succeeded  # noqa: E501

        :return: The succeeded of this BatchOrder.  # noqa: E501
        :rtype: bool
        """
        return self._succeeded

    @succeeded.setter
    def succeeded(self, succeeded):
        """Sets the succeeded of this BatchOrder.

        Whether the batch of orders succeeded  # noqa: E501

        :param succeeded: The succeeded of this BatchOrder.  # noqa: E501
        :type: bool
        """

        self._succeeded = succeeded

    @property
    def label(self):
        """Gets the label of this BatchOrder.  # noqa: E501

        Error label, if any, otherwise an empty string  # noqa: E501

        :return: The label of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this BatchOrder.

        Error label, if any, otherwise an empty string  # noqa: E501

        :param label: The label of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._label = label

    @property
    def message(self):
        """Gets the message of this BatchOrder.  # noqa: E501

        Detailed error message, if any, otherwise an empty string  # noqa: E501

        :return: The message of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this BatchOrder.

        Detailed error message, if any, otherwise an empty string  # noqa: E501

        :param message: The message of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def id(self):
        """Gets the id of this BatchOrder.  # noqa: E501

        Order ID  # noqa: E501

        :return: The id of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BatchOrder.

        Order ID  # noqa: E501

        :param id: The id of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def create_time(self):
        """Gets the create_time of this BatchOrder.  # noqa: E501

        Creation time of order  # noqa: E501

        :return: The create_time of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._create_time

    @create_time.setter
    def create_time(self, create_time):
        """Sets the create_time of this BatchOrder.

        Creation time of order  # noqa: E501

        :param create_time: The create_time of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._create_time = create_time

    @property
    def update_time(self):
        """Gets the update_time of this BatchOrder.  # noqa: E501

        Last modification time of order  # noqa: E501

        :return: The update_time of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._update_time

    @update_time.setter
    def update_time(self, update_time):
        """Sets the update_time of this BatchOrder.

        Last modification time of order  # noqa: E501

        :param update_time: The update_time of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._update_time = update_time

    @property
    def create_time_ms(self):
        """Gets the create_time_ms of this BatchOrder.  # noqa: E501

        Creation time of order (in milliseconds)  # noqa: E501

        :return: The create_time_ms of this BatchOrder.  # noqa: E501
        :rtype: int
        """
        return self._create_time_ms

    @create_time_ms.setter
    def create_time_ms(self, create_time_ms):
        """Sets the create_time_ms of this BatchOrder.

        Creation time of order (in milliseconds)  # noqa: E501

        :param create_time_ms: The create_time_ms of this BatchOrder.  # noqa: E501
        :type: int
        """

        self._create_time_ms = create_time_ms

    @property
    def update_time_ms(self):
        """Gets the update_time_ms of this BatchOrder.  # noqa: E501

        Last modification time of order (in milliseconds)  # noqa: E501

        :return: The update_time_ms of this BatchOrder.  # noqa: E501
        :rtype: int
        """
        return self._update_time_ms

    @update_time_ms.setter
    def update_time_ms(self, update_time_ms):
        """Sets the update_time_ms of this BatchOrder.

        Last modification time of order (in milliseconds)  # noqa: E501

        :param update_time_ms: The update_time_ms of this BatchOrder.  # noqa: E501
        :type: int
        """

        self._update_time_ms = update_time_ms

    @property
    def status(self):
        """Gets the status of this BatchOrder.  # noqa: E501

        Order status  - `open`: to be filled - `closed`: filled - `cancelled`: cancelled  # noqa: E501

        :return: The status of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BatchOrder.

        Order status  - `open`: to be filled - `closed`: filled - `cancelled`: cancelled  # noqa: E501

        :param status: The status of this BatchOrder.  # noqa: E501
        :type: str
        """
        allowed_values = ["open", "closed", "cancelled"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def currency_pair(self):
        """Gets the currency_pair of this BatchOrder.  # noqa: E501

        Currency pair  # noqa: E501

        :return: The currency_pair of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._currency_pair

    @currency_pair.setter
    def currency_pair(self, currency_pair):
        """Sets the currency_pair of this BatchOrder.

        Currency pair  # noqa: E501

        :param currency_pair: The currency_pair of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._currency_pair = currency_pair

    @property
    def type(self):
        """Gets the type of this BatchOrder.  # noqa: E501

        Order Type   - limit : Limit Order - market : Market Order  # noqa: E501

        :return: The type of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BatchOrder.

        Order Type   - limit : Limit Order - market : Market Order  # noqa: E501

        :param type: The type of this BatchOrder.  # noqa: E501
        :type: str
        """
        allowed_values = ["limit", "market"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def account(self):
        """Gets the account of this BatchOrder.  # noqa: E501

        Account type, spot - spot account, margin - leveraged account, unified - unified account  # noqa: E501

        :return: The account of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._account

    @account.setter
    def account(self, account):
        """Sets the account of this BatchOrder.

        Account type, spot - spot account, margin - leveraged account, unified - unified account  # noqa: E501

        :param account: The account of this BatchOrder.  # noqa: E501
        :type: str
        """
        allowed_values = ["spot", "margin", "cross_margin", "unified"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and account not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `account` ({0}), must be one of {1}"  # noqa: E501
                .format(account, allowed_values)
            )

        self._account = account

    @property
    def side(self):
        """Gets the side of this BatchOrder.  # noqa: E501

        Buy or sell order  # noqa: E501

        :return: The side of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._side

    @side.setter
    def side(self, side):
        """Sets the side of this BatchOrder.

        Buy or sell order  # noqa: E501

        :param side: The side of this BatchOrder.  # noqa: E501
        :type: str
        """
        allowed_values = ["buy", "sell"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and side not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `side` ({0}), must be one of {1}"  # noqa: E501
                .format(side, allowed_values)
            )

        self._side = side

    @property
    def amount(self):
        """Gets the amount of this BatchOrder.  # noqa: E501

        Trade amount  # noqa: E501

        :return: The amount of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this BatchOrder.

        Trade amount  # noqa: E501

        :param amount: The amount of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._amount = amount

    @property
    def price(self):
        """Gets the price of this BatchOrder.  # noqa: E501

        Order price  # noqa: E501

        :return: The price of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this BatchOrder.

        Order price  # noqa: E501

        :param price: The price of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._price = price

    @property
    def time_in_force(self):
        """Gets the time_in_force of this BatchOrder.  # noqa: E501

        Time in force  - gtc: GoodTillCancelled - ioc: ImmediateOrCancelled, taker only - poc: PendingOrCancelled, makes a post-only order that always enjoys a maker fee - fok: FillOrKill, fill either completely or none  # noqa: E501

        :return: The time_in_force of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._time_in_force

    @time_in_force.setter
    def time_in_force(self, time_in_force):
        """Sets the time_in_force of this BatchOrder.

        Time in force  - gtc: GoodTillCancelled - ioc: ImmediateOrCancelled, taker only - poc: PendingOrCancelled, makes a post-only order that always enjoys a maker fee - fok: FillOrKill, fill either completely or none  # noqa: E501

        :param time_in_force: The time_in_force of this BatchOrder.  # noqa: E501
        :type: str
        """
        allowed_values = ["gtc", "ioc", "poc", "fok"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and time_in_force not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `time_in_force` ({0}), must be one of {1}"  # noqa: E501
                .format(time_in_force, allowed_values)
            )

        self._time_in_force = time_in_force

    @property
    def iceberg(self):
        """Gets the iceberg of this BatchOrder.  # noqa: E501

        Amount to display for the iceberg order. Null or 0 for normal orders.  Hiding all amount is not supported.  # noqa: E501

        :return: The iceberg of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._iceberg

    @iceberg.setter
    def iceberg(self, iceberg):
        """Sets the iceberg of this BatchOrder.

        Amount to display for the iceberg order. Null or 0 for normal orders.  Hiding all amount is not supported.  # noqa: E501

        :param iceberg: The iceberg of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._iceberg = iceberg

    @property
    def auto_borrow(self):
        """Gets the auto_borrow of this BatchOrder.  # noqa: E501

        Used in margin or cross margin trading to allow automatic loan of insufficient amount if balance is not enough.  # noqa: E501

        :return: The auto_borrow of this BatchOrder.  # noqa: E501
        :rtype: bool
        """
        return self._auto_borrow

    @auto_borrow.setter
    def auto_borrow(self, auto_borrow):
        """Sets the auto_borrow of this BatchOrder.

        Used in margin or cross margin trading to allow automatic loan of insufficient amount if balance is not enough.  # noqa: E501

        :param auto_borrow: The auto_borrow of this BatchOrder.  # noqa: E501
        :type: bool
        """

        self._auto_borrow = auto_borrow

    @property
    def auto_repay(self):
        """Gets the auto_repay of this BatchOrder.  # noqa: E501

        Enable or disable automatic repayment for automatic borrow loan generated by cross margin order. Default is disabled. Note that:  1. This field is only effective for cross margin orders. Margin account does not support setting auto repayment for orders. 2. `auto_borrow` and `auto_repay` can be both set to true in one order.  # noqa: E501

        :return: The auto_repay of this BatchOrder.  # noqa: E501
        :rtype: bool
        """
        return self._auto_repay

    @auto_repay.setter
    def auto_repay(self, auto_repay):
        """Sets the auto_repay of this BatchOrder.

        Enable or disable automatic repayment for automatic borrow loan generated by cross margin order. Default is disabled. Note that:  1. This field is only effective for cross margin orders. Margin account does not support setting auto repayment for orders. 2. `auto_borrow` and `auto_repay` can be both set to true in one order.  # noqa: E501

        :param auto_repay: The auto_repay of this BatchOrder.  # noqa: E501
        :type: bool
        """

        self._auto_repay = auto_repay

    @property
    def left(self):
        """Gets the left of this BatchOrder.  # noqa: E501

        Amount left to fill  # noqa: E501

        :return: The left of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._left

    @left.setter
    def left(self, left):
        """Sets the left of this BatchOrder.

        Amount left to fill  # noqa: E501

        :param left: The left of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._left = left

    @property
    def filled_amount(self):
        """Gets the filled_amount of this BatchOrder.  # noqa: E501

        Amount traded to fill   # noqa: E501

        :return: The filled_amount of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._filled_amount

    @filled_amount.setter
    def filled_amount(self, filled_amount):
        """Sets the filled_amount of this BatchOrder.

        Amount traded to fill   # noqa: E501

        :param filled_amount: The filled_amount of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._filled_amount = filled_amount

    @property
    def fill_price(self):
        """Gets the fill_price of this BatchOrder.  # noqa: E501

        Total filled in quote currency. Deprecated in favor of `filled_total`  # noqa: E501

        :return: The fill_price of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._fill_price

    @fill_price.setter
    def fill_price(self, fill_price):
        """Sets the fill_price of this BatchOrder.

        Total filled in quote currency. Deprecated in favor of `filled_total`  # noqa: E501

        :param fill_price: The fill_price of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._fill_price = fill_price

    @property
    def filled_total(self):
        """Gets the filled_total of this BatchOrder.  # noqa: E501

        Total filled in quote currency  # noqa: E501

        :return: The filled_total of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._filled_total

    @filled_total.setter
    def filled_total(self, filled_total):
        """Sets the filled_total of this BatchOrder.

        Total filled in quote currency  # noqa: E501

        :param filled_total: The filled_total of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._filled_total = filled_total

    @property
    def avg_deal_price(self):
        """Gets the avg_deal_price of this BatchOrder.  # noqa: E501

        Average fill price  # noqa: E501

        :return: The avg_deal_price of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._avg_deal_price

    @avg_deal_price.setter
    def avg_deal_price(self, avg_deal_price):
        """Sets the avg_deal_price of this BatchOrder.

        Average fill price  # noqa: E501

        :param avg_deal_price: The avg_deal_price of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._avg_deal_price = avg_deal_price

    @property
    def fee(self):
        """Gets the fee of this BatchOrder.  # noqa: E501

        Fee deducted  # noqa: E501

        :return: The fee of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._fee

    @fee.setter
    def fee(self, fee):
        """Sets the fee of this BatchOrder.

        Fee deducted  # noqa: E501

        :param fee: The fee of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._fee = fee

    @property
    def fee_currency(self):
        """Gets the fee_currency of this BatchOrder.  # noqa: E501

        Fee currency unit  # noqa: E501

        :return: The fee_currency of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._fee_currency

    @fee_currency.setter
    def fee_currency(self, fee_currency):
        """Sets the fee_currency of this BatchOrder.

        Fee currency unit  # noqa: E501

        :param fee_currency: The fee_currency of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._fee_currency = fee_currency

    @property
    def point_fee(self):
        """Gets the point_fee of this BatchOrder.  # noqa: E501

        Points used to deduct fee  # noqa: E501

        :return: The point_fee of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._point_fee

    @point_fee.setter
    def point_fee(self, point_fee):
        """Sets the point_fee of this BatchOrder.

        Points used to deduct fee  # noqa: E501

        :param point_fee: The point_fee of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._point_fee = point_fee

    @property
    def gt_fee(self):
        """Gets the gt_fee of this BatchOrder.  # noqa: E501

        GT used to deduct fee  # noqa: E501

        :return: The gt_fee of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._gt_fee

    @gt_fee.setter
    def gt_fee(self, gt_fee):
        """Sets the gt_fee of this BatchOrder.

        GT used to deduct fee  # noqa: E501

        :param gt_fee: The gt_fee of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._gt_fee = gt_fee

    @property
    def gt_discount(self):
        """Gets the gt_discount of this BatchOrder.  # noqa: E501

        Whether GT fee discount is used  # noqa: E501

        :return: The gt_discount of this BatchOrder.  # noqa: E501
        :rtype: bool
        """
        return self._gt_discount

    @gt_discount.setter
    def gt_discount(self, gt_discount):
        """Sets the gt_discount of this BatchOrder.

        Whether GT fee discount is used  # noqa: E501

        :param gt_discount: The gt_discount of this BatchOrder.  # noqa: E501
        :type: bool
        """

        self._gt_discount = gt_discount

    @property
    def rebated_fee(self):
        """Gets the rebated_fee of this BatchOrder.  # noqa: E501

        Rebated fee  # noqa: E501

        :return: The rebated_fee of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._rebated_fee

    @rebated_fee.setter
    def rebated_fee(self, rebated_fee):
        """Sets the rebated_fee of this BatchOrder.

        Rebated fee  # noqa: E501

        :param rebated_fee: The rebated_fee of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._rebated_fee = rebated_fee

    @property
    def rebated_fee_currency(self):
        """Gets the rebated_fee_currency of this BatchOrder.  # noqa: E501

        Rebated fee currency unit  # noqa: E501

        :return: The rebated_fee_currency of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._rebated_fee_currency

    @rebated_fee_currency.setter
    def rebated_fee_currency(self, rebated_fee_currency):
        """Sets the rebated_fee_currency of this BatchOrder.

        Rebated fee currency unit  # noqa: E501

        :param rebated_fee_currency: The rebated_fee_currency of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._rebated_fee_currency = rebated_fee_currency

    @property
    def stp_id(self):
        """Gets the stp_id of this BatchOrder.  # noqa: E501

        Orders between users in the same `stp_id` group are not allowed to be self-traded  1. If the `stp_id` of two orders being matched is non-zero and equal, they will not be executed. Instead, the corresponding strategy will be executed based on the `stp_act` of the taker. 2. `stp_id` returns `0` by default for orders that have not been set for `STP group`  # noqa: E501

        :return: The stp_id of this BatchOrder.  # noqa: E501
        :rtype: int
        """
        return self._stp_id

    @stp_id.setter
    def stp_id(self, stp_id):
        """Sets the stp_id of this BatchOrder.

        Orders between users in the same `stp_id` group are not allowed to be self-traded  1. If the `stp_id` of two orders being matched is non-zero and equal, they will not be executed. Instead, the corresponding strategy will be executed based on the `stp_act` of the taker. 2. `stp_id` returns `0` by default for orders that have not been set for `STP group`  # noqa: E501

        :param stp_id: The stp_id of this BatchOrder.  # noqa: E501
        :type: int
        """

        self._stp_id = stp_id

    @property
    def stp_act(self):
        """Gets the stp_act of this BatchOrder.  # noqa: E501

        Self-Trading Prevention Action. Users can use this field to set self-trade prevetion strategies  1. After users join the `STP Group`, he can pass `stp_act` to limit the user's self-trade prevetion strategy. If `stp_act` is not passed, the default is `cn` strategy。 2. When the user does not join the `STP group`, an error will be returned when passing the `stp_act` parameter。 3. If the user did not use 'stp_act' when placing the order, 'stp_act' will return '-'  - cn: Cancel newest, Cancel new orders and keep old ones - co: Cancel oldest, Cancel old orders and keep new ones - cb: Cancel both, Both old and new orders will be cancelled  # noqa: E501

        :return: The stp_act of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._stp_act

    @stp_act.setter
    def stp_act(self, stp_act):
        """Sets the stp_act of this BatchOrder.

        Self-Trading Prevention Action. Users can use this field to set self-trade prevetion strategies  1. After users join the `STP Group`, he can pass `stp_act` to limit the user's self-trade prevetion strategy. If `stp_act` is not passed, the default is `cn` strategy。 2. When the user does not join the `STP group`, an error will be returned when passing the `stp_act` parameter。 3. If the user did not use 'stp_act' when placing the order, 'stp_act' will return '-'  - cn: Cancel newest, Cancel new orders and keep old ones - co: Cancel oldest, Cancel old orders and keep new ones - cb: Cancel both, Both old and new orders will be cancelled  # noqa: E501

        :param stp_act: The stp_act of this BatchOrder.  # noqa: E501
        :type: str
        """
        allowed_values = ["cn", "co", "cb", "-"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and stp_act not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `stp_act` ({0}), must be one of {1}"  # noqa: E501
                .format(stp_act, allowed_values)
            )

        self._stp_act = stp_act

    @property
    def finish_as(self):
        """Gets the finish_as of this BatchOrder.  # noqa: E501

        How the order was finished.  - open: processing - filled: filled totally - cancelled: manually cancelled - ioc: time in force is `IOC`, finish immediately - stp: cancelled because self trade prevention   # noqa: E501

        :return: The finish_as of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._finish_as

    @finish_as.setter
    def finish_as(self, finish_as):
        """Sets the finish_as of this BatchOrder.

        How the order was finished.  - open: processing - filled: filled totally - cancelled: manually cancelled - ioc: time in force is `IOC`, finish immediately - stp: cancelled because self trade prevention   # noqa: E501

        :param finish_as: The finish_as of this BatchOrder.  # noqa: E501
        :type: str
        """
        allowed_values = ["open", "filled", "cancelled", "ioc", "stp"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and finish_as not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `finish_as` ({0}), must be one of {1}"  # noqa: E501
                .format(finish_as, allowed_values)
            )

        self._finish_as = finish_as

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BatchOrder):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BatchOrder):
            return True

        return self.to_dict() != other.to_dict()
