# coding: utf-8

"""
    Gate API

    Welcome to Gate API  APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces for implementing API-based automated trading.  # noqa: E501

    Contact: support@mail.gate.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class BorrowCurrencyInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'currency': 'str',
        'index_price': 'str',
        'left_repay_principal': 'str',
        'left_repay_interest': 'str',
        'left_repay_usdt': 'str'
    }

    attribute_map = {
        'currency': 'currency',
        'index_price': 'index_price',
        'left_repay_principal': 'left_repay_principal',
        'left_repay_interest': 'left_repay_interest',
        'left_repay_usdt': 'left_repay_usdt'
    }

    def __init__(self, currency=None, index_price=None, left_repay_principal=None, left_repay_interest=None, left_repay_usdt=None, local_vars_configuration=None):  # noqa: E501
        # type: (str, str, str, str, str, Configuration) -> None
        """BorrowCurrencyInfo - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._currency = None
        self._index_price = None
        self._left_repay_principal = None
        self._left_repay_interest = None
        self._left_repay_usdt = None
        self.discriminator = None

        if currency is not None:
            self.currency = currency
        if index_price is not None:
            self.index_price = index_price
        if left_repay_principal is not None:
            self.left_repay_principal = left_repay_principal
        if left_repay_interest is not None:
            self.left_repay_interest = left_repay_interest
        if left_repay_usdt is not None:
            self.left_repay_usdt = left_repay_usdt

    @property
    def currency(self):
        """Gets the currency of this BorrowCurrencyInfo.  # noqa: E501

        Currency  # noqa: E501

        :return: The currency of this BorrowCurrencyInfo.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this BorrowCurrencyInfo.

        Currency  # noqa: E501

        :param currency: The currency of this BorrowCurrencyInfo.  # noqa: E501
        :type: str
        """

        self._currency = currency

    @property
    def index_price(self):
        """Gets the index_price of this BorrowCurrencyInfo.  # noqa: E501

        Currency Index Price  # noqa: E501

        :return: The index_price of this BorrowCurrencyInfo.  # noqa: E501
        :rtype: str
        """
        return self._index_price

    @index_price.setter
    def index_price(self, index_price):
        """Sets the index_price of this BorrowCurrencyInfo.

        Currency Index Price  # noqa: E501

        :param index_price: The index_price of this BorrowCurrencyInfo.  # noqa: E501
        :type: str
        """

        self._index_price = index_price

    @property
    def left_repay_principal(self):
        """Gets the left_repay_principal of this BorrowCurrencyInfo.  # noqa: E501

        outstanding principal  # noqa: E501

        :return: The left_repay_principal of this BorrowCurrencyInfo.  # noqa: E501
        :rtype: str
        """
        return self._left_repay_principal

    @left_repay_principal.setter
    def left_repay_principal(self, left_repay_principal):
        """Sets the left_repay_principal of this BorrowCurrencyInfo.

        outstanding principal  # noqa: E501

        :param left_repay_principal: The left_repay_principal of this BorrowCurrencyInfo.  # noqa: E501
        :type: str
        """

        self._left_repay_principal = left_repay_principal

    @property
    def left_repay_interest(self):
        """Gets the left_repay_interest of this BorrowCurrencyInfo.  # noqa: E501

        outstanding interest  # noqa: E501

        :return: The left_repay_interest of this BorrowCurrencyInfo.  # noqa: E501
        :rtype: str
        """
        return self._left_repay_interest

    @left_repay_interest.setter
    def left_repay_interest(self, left_repay_interest):
        """Sets the left_repay_interest of this BorrowCurrencyInfo.

        outstanding interest  # noqa: E501

        :param left_repay_interest: The left_repay_interest of this BorrowCurrencyInfo.  # noqa: E501
        :type: str
        """

        self._left_repay_interest = left_repay_interest

    @property
    def left_repay_usdt(self):
        """Gets the left_repay_usdt of this BorrowCurrencyInfo.  # noqa: E501

        Value of left total repayments amount in USDT  # noqa: E501

        :return: The left_repay_usdt of this BorrowCurrencyInfo.  # noqa: E501
        :rtype: str
        """
        return self._left_repay_usdt

    @left_repay_usdt.setter
    def left_repay_usdt(self, left_repay_usdt):
        """Sets the left_repay_usdt of this BorrowCurrencyInfo.

        Value of left total repayments amount in USDT  # noqa: E501

        :param left_repay_usdt: The left_repay_usdt of this BorrowCurrencyInfo.  # noqa: E501
        :type: str
        """

        self._left_repay_usdt = left_repay_usdt

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BorrowCurrencyInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BorrowCurrencyInfo):
            return True

        return self.to_dict() != other.to_dict()
