# coding: utf-8

"""
    Gate API

    Welcome to Gate API  APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces for implementing API-based automated trading.  # noqa: E501

    Contact: support@mail.gate.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class BrokerTransaction1(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'transaction_time': 'int',
        'user_id': 'int',
        'group_name': 'str',
        'fee': 'str',
        'currency_pair': 'str',
        'amount': 'str',
        'fee_asset': 'str',
        'source': 'str',
        'sub_broker_info': 'BrokerCommissionSubBrokerInfo'
    }

    attribute_map = {
        'transaction_time': 'transaction_time',
        'user_id': 'user_id',
        'group_name': 'group_name',
        'fee': 'fee',
        'currency_pair': 'currency_pair',
        'amount': 'amount',
        'fee_asset': 'fee_asset',
        'source': 'source',
        'sub_broker_info': 'sub_broker_info'
    }

    def __init__(self, transaction_time=None, user_id=None, group_name=None, fee=None, currency_pair=None, amount=None, fee_asset=None, source=None, sub_broker_info=None, local_vars_configuration=None):  # noqa: E501
        # type: (int, int, str, str, str, str, str, str, BrokerCommissionSubBrokerInfo, Configuration) -> None
        """BrokerTransaction1 - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._transaction_time = None
        self._user_id = None
        self._group_name = None
        self._fee = None
        self._currency_pair = None
        self._amount = None
        self._fee_asset = None
        self._source = None
        self._sub_broker_info = None
        self.discriminator = None

        if transaction_time is not None:
            self.transaction_time = transaction_time
        if user_id is not None:
            self.user_id = user_id
        if group_name is not None:
            self.group_name = group_name
        if fee is not None:
            self.fee = fee
        if currency_pair is not None:
            self.currency_pair = currency_pair
        if amount is not None:
            self.amount = amount
        if fee_asset is not None:
            self.fee_asset = fee_asset
        if source is not None:
            self.source = source
        if sub_broker_info is not None:
            self.sub_broker_info = sub_broker_info

    @property
    def transaction_time(self):
        """Gets the transaction_time of this BrokerTransaction1.  # noqa: E501

        Transaction Time. (unix timestamp)  # noqa: E501

        :return: The transaction_time of this BrokerTransaction1.  # noqa: E501
        :rtype: int
        """
        return self._transaction_time

    @transaction_time.setter
    def transaction_time(self, transaction_time):
        """Sets the transaction_time of this BrokerTransaction1.

        Transaction Time. (unix timestamp)  # noqa: E501

        :param transaction_time: The transaction_time of this BrokerTransaction1.  # noqa: E501
        :type: int
        """

        self._transaction_time = transaction_time

    @property
    def user_id(self):
        """Gets the user_id of this BrokerTransaction1.  # noqa: E501

        User ID  # noqa: E501

        :return: The user_id of this BrokerTransaction1.  # noqa: E501
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this BrokerTransaction1.

        User ID  # noqa: E501

        :param user_id: The user_id of this BrokerTransaction1.  # noqa: E501
        :type: int
        """

        self._user_id = user_id

    @property
    def group_name(self):
        """Gets the group_name of this BrokerTransaction1.  # noqa: E501

        Group name  # noqa: E501

        :return: The group_name of this BrokerTransaction1.  # noqa: E501
        :rtype: str
        """
        return self._group_name

    @group_name.setter
    def group_name(self, group_name):
        """Sets the group_name of this BrokerTransaction1.

        Group name  # noqa: E501

        :param group_name: The group_name of this BrokerTransaction1.  # noqa: E501
        :type: str
        """

        self._group_name = group_name

    @property
    def fee(self):
        """Gets the fee of this BrokerTransaction1.  # noqa: E501

        fee (usdt)  # noqa: E501

        :return: The fee of this BrokerTransaction1.  # noqa: E501
        :rtype: str
        """
        return self._fee

    @fee.setter
    def fee(self, fee):
        """Sets the fee of this BrokerTransaction1.

        fee (usdt)  # noqa: E501

        :param fee: The fee of this BrokerTransaction1.  # noqa: E501
        :type: str
        """

        self._fee = fee

    @property
    def currency_pair(self):
        """Gets the currency_pair of this BrokerTransaction1.  # noqa: E501

        Currency pair  # noqa: E501

        :return: The currency_pair of this BrokerTransaction1.  # noqa: E501
        :rtype: str
        """
        return self._currency_pair

    @currency_pair.setter
    def currency_pair(self, currency_pair):
        """Sets the currency_pair of this BrokerTransaction1.

        Currency pair  # noqa: E501

        :param currency_pair: The currency_pair of this BrokerTransaction1.  # noqa: E501
        :type: str
        """

        self._currency_pair = currency_pair

    @property
    def amount(self):
        """Gets the amount of this BrokerTransaction1.  # noqa: E501

        Commission Amount  # noqa: E501

        :return: The amount of this BrokerTransaction1.  # noqa: E501
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this BrokerTransaction1.

        Commission Amount  # noqa: E501

        :param amount: The amount of this BrokerTransaction1.  # noqa: E501
        :type: str
        """

        self._amount = amount

    @property
    def fee_asset(self):
        """Gets the fee_asset of this BrokerTransaction1.  # noqa: E501

        Fee currency  # noqa: E501

        :return: The fee_asset of this BrokerTransaction1.  # noqa: E501
        :rtype: str
        """
        return self._fee_asset

    @fee_asset.setter
    def fee_asset(self, fee_asset):
        """Sets the fee_asset of this BrokerTransaction1.

        Fee currency  # noqa: E501

        :param fee_asset: The fee_asset of this BrokerTransaction1.  # noqa: E501
        :type: str
        """

        self._fee_asset = fee_asset

    @property
    def source(self):
        """Gets the source of this BrokerTransaction1.  # noqa: E501

        Rebate Type: Spot、Futures、Options  # noqa: E501

        :return: The source of this BrokerTransaction1.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this BrokerTransaction1.

        Rebate Type: Spot、Futures、Options  # noqa: E501

        :param source: The source of this BrokerTransaction1.  # noqa: E501
        :type: str
        """

        self._source = source

    @property
    def sub_broker_info(self):
        """Gets the sub_broker_info of this BrokerTransaction1.  # noqa: E501


        :return: The sub_broker_info of this BrokerTransaction1.  # noqa: E501
        :rtype: BrokerCommissionSubBrokerInfo
        """
        return self._sub_broker_info

    @sub_broker_info.setter
    def sub_broker_info(self, sub_broker_info):
        """Sets the sub_broker_info of this BrokerTransaction1.


        :param sub_broker_info: The sub_broker_info of this BrokerTransaction1.  # noqa: E501
        :type: BrokerCommissionSubBrokerInfo
        """

        self._sub_broker_info = sub_broker_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BrokerTransaction1):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BrokerTransaction1):
            return True

        return self.to_dict() != other.to_dict()
