# coding: utf-8

"""
    Gate API

    Welcome to Gate API  APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces for implementing API-based automated trading.  # noqa: E501

    Contact: support@mail.gate.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class CollateralFixRate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'currency': 'str',
        'rate_7d': 'str',
        'rate_30d': 'str',
        'update_time': 'int'
    }

    attribute_map = {
        'currency': 'currency',
        'rate_7d': 'rate_7d',
        'rate_30d': 'rate_30d',
        'update_time': 'update_time'
    }

    def __init__(self, currency=None, rate_7d=None, rate_30d=None, update_time=None, local_vars_configuration=None):  # noqa: E501
        # type: (str, str, str, int, Configuration) -> None
        """CollateralFixRate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._currency = None
        self._rate_7d = None
        self._rate_30d = None
        self._update_time = None
        self.discriminator = None

        if currency is not None:
            self.currency = currency
        if rate_7d is not None:
            self.rate_7d = rate_7d
        if rate_30d is not None:
            self.rate_30d = rate_30d
        if update_time is not None:
            self.update_time = update_time

    @property
    def currency(self):
        """Gets the currency of this CollateralFixRate.  # noqa: E501

        Currency  # noqa: E501

        :return: The currency of this CollateralFixRate.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this CollateralFixRate.

        Currency  # noqa: E501

        :param currency: The currency of this CollateralFixRate.  # noqa: E501
        :type: str
        """

        self._currency = currency

    @property
    def rate_7d(self):
        """Gets the rate_7d of this CollateralFixRate.  # noqa: E501

        Fixed interest rate for a lending period of 7 days  # noqa: E501

        :return: The rate_7d of this CollateralFixRate.  # noqa: E501
        :rtype: str
        """
        return self._rate_7d

    @rate_7d.setter
    def rate_7d(self, rate_7d):
        """Sets the rate_7d of this CollateralFixRate.

        Fixed interest rate for a lending period of 7 days  # noqa: E501

        :param rate_7d: The rate_7d of this CollateralFixRate.  # noqa: E501
        :type: str
        """

        self._rate_7d = rate_7d

    @property
    def rate_30d(self):
        """Gets the rate_30d of this CollateralFixRate.  # noqa: E501

        Fixed interest rate for a lending period of 30 days  # noqa: E501

        :return: The rate_30d of this CollateralFixRate.  # noqa: E501
        :rtype: str
        """
        return self._rate_30d

    @rate_30d.setter
    def rate_30d(self, rate_30d):
        """Sets the rate_30d of this CollateralFixRate.

        Fixed interest rate for a lending period of 30 days  # noqa: E501

        :param rate_30d: The rate_30d of this CollateralFixRate.  # noqa: E501
        :type: str
        """

        self._rate_30d = rate_30d

    @property
    def update_time(self):
        """Gets the update_time of this CollateralFixRate.  # noqa: E501

        Update time, timestamp, unit in seconds  # noqa: E501

        :return: The update_time of this CollateralFixRate.  # noqa: E501
        :rtype: int
        """
        return self._update_time

    @update_time.setter
    def update_time(self, update_time):
        """Sets the update_time of this CollateralFixRate.

        Update time, timestamp, unit in seconds  # noqa: E501

        :param update_time: The update_time of this CollateralFixRate.  # noqa: E501
        :type: int
        """

        self._update_time = update_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CollateralFixRate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CollateralFixRate):
            return True

        return self.to_dict() != other.to_dict()
