# coding: utf-8

"""
    Gate API

    Welcome to Gate API  APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces for implementing API-based automated trading.  # noqa: E501

    Contact: support@mail.gate.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class CollateralRecord(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'order_id': 'int',
        'record_id': 'int',
        'borrow_currency': 'str',
        'borrow_amount': 'str',
        'collateral_currency': 'str',
        'before_collateral': 'str',
        'after_collateral': 'str',
        'before_ltv': 'str',
        'after_ltv': 'str',
        'operate_time': 'int'
    }

    attribute_map = {
        'order_id': 'order_id',
        'record_id': 'record_id',
        'borrow_currency': 'borrow_currency',
        'borrow_amount': 'borrow_amount',
        'collateral_currency': 'collateral_currency',
        'before_collateral': 'before_collateral',
        'after_collateral': 'after_collateral',
        'before_ltv': 'before_ltv',
        'after_ltv': 'after_ltv',
        'operate_time': 'operate_time'
    }

    def __init__(self, order_id=None, record_id=None, borrow_currency=None, borrow_amount=None, collateral_currency=None, before_collateral=None, after_collateral=None, before_ltv=None, after_ltv=None, operate_time=None, local_vars_configuration=None):  # noqa: E501
        # type: (int, int, str, str, str, str, str, str, str, int, Configuration) -> None
        """CollateralRecord - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._order_id = None
        self._record_id = None
        self._borrow_currency = None
        self._borrow_amount = None
        self._collateral_currency = None
        self._before_collateral = None
        self._after_collateral = None
        self._before_ltv = None
        self._after_ltv = None
        self._operate_time = None
        self.discriminator = None

        if order_id is not None:
            self.order_id = order_id
        if record_id is not None:
            self.record_id = record_id
        if borrow_currency is not None:
            self.borrow_currency = borrow_currency
        if borrow_amount is not None:
            self.borrow_amount = borrow_amount
        if collateral_currency is not None:
            self.collateral_currency = collateral_currency
        if before_collateral is not None:
            self.before_collateral = before_collateral
        if after_collateral is not None:
            self.after_collateral = after_collateral
        if before_ltv is not None:
            self.before_ltv = before_ltv
        if after_ltv is not None:
            self.after_ltv = after_ltv
        if operate_time is not None:
            self.operate_time = operate_time

    @property
    def order_id(self):
        """Gets the order_id of this CollateralRecord.  # noqa: E501

        Order ID  # noqa: E501

        :return: The order_id of this CollateralRecord.  # noqa: E501
        :rtype: int
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this CollateralRecord.

        Order ID  # noqa: E501

        :param order_id: The order_id of this CollateralRecord.  # noqa: E501
        :type: int
        """

        self._order_id = order_id

    @property
    def record_id(self):
        """Gets the record_id of this CollateralRecord.  # noqa: E501

        Collateral record ID  # noqa: E501

        :return: The record_id of this CollateralRecord.  # noqa: E501
        :rtype: int
        """
        return self._record_id

    @record_id.setter
    def record_id(self, record_id):
        """Sets the record_id of this CollateralRecord.

        Collateral record ID  # noqa: E501

        :param record_id: The record_id of this CollateralRecord.  # noqa: E501
        :type: int
        """

        self._record_id = record_id

    @property
    def borrow_currency(self):
        """Gets the borrow_currency of this CollateralRecord.  # noqa: E501

        Borrowed currency  # noqa: E501

        :return: The borrow_currency of this CollateralRecord.  # noqa: E501
        :rtype: str
        """
        return self._borrow_currency

    @borrow_currency.setter
    def borrow_currency(self, borrow_currency):
        """Sets the borrow_currency of this CollateralRecord.

        Borrowed currency  # noqa: E501

        :param borrow_currency: The borrow_currency of this CollateralRecord.  # noqa: E501
        :type: str
        """

        self._borrow_currency = borrow_currency

    @property
    def borrow_amount(self):
        """Gets the borrow_amount of this CollateralRecord.  # noqa: E501

        Borrowing amount  # noqa: E501

        :return: The borrow_amount of this CollateralRecord.  # noqa: E501
        :rtype: str
        """
        return self._borrow_amount

    @borrow_amount.setter
    def borrow_amount(self, borrow_amount):
        """Sets the borrow_amount of this CollateralRecord.

        Borrowing amount  # noqa: E501

        :param borrow_amount: The borrow_amount of this CollateralRecord.  # noqa: E501
        :type: str
        """

        self._borrow_amount = borrow_amount

    @property
    def collateral_currency(self):
        """Gets the collateral_currency of this CollateralRecord.  # noqa: E501

        Collateral  # noqa: E501

        :return: The collateral_currency of this CollateralRecord.  # noqa: E501
        :rtype: str
        """
        return self._collateral_currency

    @collateral_currency.setter
    def collateral_currency(self, collateral_currency):
        """Sets the collateral_currency of this CollateralRecord.

        Collateral  # noqa: E501

        :param collateral_currency: The collateral_currency of this CollateralRecord.  # noqa: E501
        :type: str
        """

        self._collateral_currency = collateral_currency

    @property
    def before_collateral(self):
        """Gets the before_collateral of this CollateralRecord.  # noqa: E501

        The collateral amount before adjustment  # noqa: E501

        :return: The before_collateral of this CollateralRecord.  # noqa: E501
        :rtype: str
        """
        return self._before_collateral

    @before_collateral.setter
    def before_collateral(self, before_collateral):
        """Sets the before_collateral of this CollateralRecord.

        The collateral amount before adjustment  # noqa: E501

        :param before_collateral: The before_collateral of this CollateralRecord.  # noqa: E501
        :type: str
        """

        self._before_collateral = before_collateral

    @property
    def after_collateral(self):
        """Gets the after_collateral of this CollateralRecord.  # noqa: E501

        The collateral amount after adjustment  # noqa: E501

        :return: The after_collateral of this CollateralRecord.  # noqa: E501
        :rtype: str
        """
        return self._after_collateral

    @after_collateral.setter
    def after_collateral(self, after_collateral):
        """Sets the after_collateral of this CollateralRecord.

        The collateral amount after adjustment  # noqa: E501

        :param after_collateral: The after_collateral of this CollateralRecord.  # noqa: E501
        :type: str
        """

        self._after_collateral = after_collateral

    @property
    def before_ltv(self):
        """Gets the before_ltv of this CollateralRecord.  # noqa: E501

        The collateral ratio before adjustment  # noqa: E501

        :return: The before_ltv of this CollateralRecord.  # noqa: E501
        :rtype: str
        """
        return self._before_ltv

    @before_ltv.setter
    def before_ltv(self, before_ltv):
        """Sets the before_ltv of this CollateralRecord.

        The collateral ratio before adjustment  # noqa: E501

        :param before_ltv: The before_ltv of this CollateralRecord.  # noqa: E501
        :type: str
        """

        self._before_ltv = before_ltv

    @property
    def after_ltv(self):
        """Gets the after_ltv of this CollateralRecord.  # noqa: E501

        The collateral ratio after adjustment  # noqa: E501

        :return: The after_ltv of this CollateralRecord.  # noqa: E501
        :rtype: str
        """
        return self._after_ltv

    @after_ltv.setter
    def after_ltv(self, after_ltv):
        """Sets the after_ltv of this CollateralRecord.

        The collateral ratio after adjustment  # noqa: E501

        :param after_ltv: The after_ltv of this CollateralRecord.  # noqa: E501
        :type: str
        """

        self._after_ltv = after_ltv

    @property
    def operate_time(self):
        """Gets the operate_time of this CollateralRecord.  # noqa: E501

        Timestamp of the operation, in seconds  # noqa: E501

        :return: The operate_time of this CollateralRecord.  # noqa: E501
        :rtype: int
        """
        return self._operate_time

    @operate_time.setter
    def operate_time(self, operate_time):
        """Sets the operate_time of this CollateralRecord.

        Timestamp of the operation, in seconds  # noqa: E501

        :param operate_time: The operate_time of this CollateralRecord.  # noqa: E501
        :type: int
        """

        self._operate_time = operate_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CollateralRecord):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CollateralRecord):
            return True

        return self.to_dict() != other.to_dict()
