# coding: utf-8

"""
    Gate API

    Welcome to Gate API  APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces for implementing API-based automated trading.  # noqa: E501

    Contact: support@mail.gate.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class ContractStat(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'time': 'int',
        'lsr_taker': 'float',
        'lsr_account': 'float',
        'long_liq_size': 'int',
        'long_liq_amount': 'float',
        'long_liq_usd': 'float',
        'short_liq_size': 'int',
        'short_liq_amount': 'float',
        'short_liq_usd': 'float',
        'open_interest': 'int',
        'open_interest_usd': 'float',
        'top_lsr_account': 'float',
        'top_lsr_size': 'float'
    }

    attribute_map = {
        'time': 'time',
        'lsr_taker': 'lsr_taker',
        'lsr_account': 'lsr_account',
        'long_liq_size': 'long_liq_size',
        'long_liq_amount': 'long_liq_amount',
        'long_liq_usd': 'long_liq_usd',
        'short_liq_size': 'short_liq_size',
        'short_liq_amount': 'short_liq_amount',
        'short_liq_usd': 'short_liq_usd',
        'open_interest': 'open_interest',
        'open_interest_usd': 'open_interest_usd',
        'top_lsr_account': 'top_lsr_account',
        'top_lsr_size': 'top_lsr_size'
    }

    def __init__(self, time=None, lsr_taker=None, lsr_account=None, long_liq_size=None, long_liq_amount=None, long_liq_usd=None, short_liq_size=None, short_liq_amount=None, short_liq_usd=None, open_interest=None, open_interest_usd=None, top_lsr_account=None, top_lsr_size=None, local_vars_configuration=None):  # noqa: E501
        # type: (int, float, float, int, float, float, int, float, float, int, float, float, float, Configuration) -> None
        """ContractStat - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._time = None
        self._lsr_taker = None
        self._lsr_account = None
        self._long_liq_size = None
        self._long_liq_amount = None
        self._long_liq_usd = None
        self._short_liq_size = None
        self._short_liq_amount = None
        self._short_liq_usd = None
        self._open_interest = None
        self._open_interest_usd = None
        self._top_lsr_account = None
        self._top_lsr_size = None
        self.discriminator = None

        if time is not None:
            self.time = time
        if lsr_taker is not None:
            self.lsr_taker = lsr_taker
        if lsr_account is not None:
            self.lsr_account = lsr_account
        if long_liq_size is not None:
            self.long_liq_size = long_liq_size
        if long_liq_amount is not None:
            self.long_liq_amount = long_liq_amount
        if long_liq_usd is not None:
            self.long_liq_usd = long_liq_usd
        if short_liq_size is not None:
            self.short_liq_size = short_liq_size
        if short_liq_amount is not None:
            self.short_liq_amount = short_liq_amount
        if short_liq_usd is not None:
            self.short_liq_usd = short_liq_usd
        if open_interest is not None:
            self.open_interest = open_interest
        if open_interest_usd is not None:
            self.open_interest_usd = open_interest_usd
        if top_lsr_account is not None:
            self.top_lsr_account = top_lsr_account
        if top_lsr_size is not None:
            self.top_lsr_size = top_lsr_size

    @property
    def time(self):
        """Gets the time of this ContractStat.  # noqa: E501

        Stat timestamp  # noqa: E501

        :return: The time of this ContractStat.  # noqa: E501
        :rtype: int
        """
        return self._time

    @time.setter
    def time(self, time):
        """Sets the time of this ContractStat.

        Stat timestamp  # noqa: E501

        :param time: The time of this ContractStat.  # noqa: E501
        :type: int
        """

        self._time = time

    @property
    def lsr_taker(self):
        """Gets the lsr_taker of this ContractStat.  # noqa: E501

        Long/short account number ratio  # noqa: E501

        :return: The lsr_taker of this ContractStat.  # noqa: E501
        :rtype: float
        """
        return self._lsr_taker

    @lsr_taker.setter
    def lsr_taker(self, lsr_taker):
        """Sets the lsr_taker of this ContractStat.

        Long/short account number ratio  # noqa: E501

        :param lsr_taker: The lsr_taker of this ContractStat.  # noqa: E501
        :type: float
        """

        self._lsr_taker = lsr_taker

    @property
    def lsr_account(self):
        """Gets the lsr_account of this ContractStat.  # noqa: E501

        Long/short taker size ratio  # noqa: E501

        :return: The lsr_account of this ContractStat.  # noqa: E501
        :rtype: float
        """
        return self._lsr_account

    @lsr_account.setter
    def lsr_account(self, lsr_account):
        """Sets the lsr_account of this ContractStat.

        Long/short taker size ratio  # noqa: E501

        :param lsr_account: The lsr_account of this ContractStat.  # noqa: E501
        :type: float
        """

        self._lsr_account = lsr_account

    @property
    def long_liq_size(self):
        """Gets the long_liq_size of this ContractStat.  # noqa: E501

        Long liquidation size  # noqa: E501

        :return: The long_liq_size of this ContractStat.  # noqa: E501
        :rtype: int
        """
        return self._long_liq_size

    @long_liq_size.setter
    def long_liq_size(self, long_liq_size):
        """Sets the long_liq_size of this ContractStat.

        Long liquidation size  # noqa: E501

        :param long_liq_size: The long_liq_size of this ContractStat.  # noqa: E501
        :type: int
        """

        self._long_liq_size = long_liq_size

    @property
    def long_liq_amount(self):
        """Gets the long_liq_amount of this ContractStat.  # noqa: E501

        Long liquidation amount(base currency)  # noqa: E501

        :return: The long_liq_amount of this ContractStat.  # noqa: E501
        :rtype: float
        """
        return self._long_liq_amount

    @long_liq_amount.setter
    def long_liq_amount(self, long_liq_amount):
        """Sets the long_liq_amount of this ContractStat.

        Long liquidation amount(base currency)  # noqa: E501

        :param long_liq_amount: The long_liq_amount of this ContractStat.  # noqa: E501
        :type: float
        """

        self._long_liq_amount = long_liq_amount

    @property
    def long_liq_usd(self):
        """Gets the long_liq_usd of this ContractStat.  # noqa: E501

        Long liquidation volume(quote currency)  # noqa: E501

        :return: The long_liq_usd of this ContractStat.  # noqa: E501
        :rtype: float
        """
        return self._long_liq_usd

    @long_liq_usd.setter
    def long_liq_usd(self, long_liq_usd):
        """Sets the long_liq_usd of this ContractStat.

        Long liquidation volume(quote currency)  # noqa: E501

        :param long_liq_usd: The long_liq_usd of this ContractStat.  # noqa: E501
        :type: float
        """

        self._long_liq_usd = long_liq_usd

    @property
    def short_liq_size(self):
        """Gets the short_liq_size of this ContractStat.  # noqa: E501

        Short liquidation size  # noqa: E501

        :return: The short_liq_size of this ContractStat.  # noqa: E501
        :rtype: int
        """
        return self._short_liq_size

    @short_liq_size.setter
    def short_liq_size(self, short_liq_size):
        """Sets the short_liq_size of this ContractStat.

        Short liquidation size  # noqa: E501

        :param short_liq_size: The short_liq_size of this ContractStat.  # noqa: E501
        :type: int
        """

        self._short_liq_size = short_liq_size

    @property
    def short_liq_amount(self):
        """Gets the short_liq_amount of this ContractStat.  # noqa: E501

        Short liquidation amount(base currency)  # noqa: E501

        :return: The short_liq_amount of this ContractStat.  # noqa: E501
        :rtype: float
        """
        return self._short_liq_amount

    @short_liq_amount.setter
    def short_liq_amount(self, short_liq_amount):
        """Sets the short_liq_amount of this ContractStat.

        Short liquidation amount(base currency)  # noqa: E501

        :param short_liq_amount: The short_liq_amount of this ContractStat.  # noqa: E501
        :type: float
        """

        self._short_liq_amount = short_liq_amount

    @property
    def short_liq_usd(self):
        """Gets the short_liq_usd of this ContractStat.  # noqa: E501

        Short liquidation volume(quote currency)  # noqa: E501

        :return: The short_liq_usd of this ContractStat.  # noqa: E501
        :rtype: float
        """
        return self._short_liq_usd

    @short_liq_usd.setter
    def short_liq_usd(self, short_liq_usd):
        """Sets the short_liq_usd of this ContractStat.

        Short liquidation volume(quote currency)  # noqa: E501

        :param short_liq_usd: The short_liq_usd of this ContractStat.  # noqa: E501
        :type: float
        """

        self._short_liq_usd = short_liq_usd

    @property
    def open_interest(self):
        """Gets the open_interest of this ContractStat.  # noqa: E501

        Open interest size  # noqa: E501

        :return: The open_interest of this ContractStat.  # noqa: E501
        :rtype: int
        """
        return self._open_interest

    @open_interest.setter
    def open_interest(self, open_interest):
        """Sets the open_interest of this ContractStat.

        Open interest size  # noqa: E501

        :param open_interest: The open_interest of this ContractStat.  # noqa: E501
        :type: int
        """

        self._open_interest = open_interest

    @property
    def open_interest_usd(self):
        """Gets the open_interest_usd of this ContractStat.  # noqa: E501

        Open interest volume(quote currency)  # noqa: E501

        :return: The open_interest_usd of this ContractStat.  # noqa: E501
        :rtype: float
        """
        return self._open_interest_usd

    @open_interest_usd.setter
    def open_interest_usd(self, open_interest_usd):
        """Sets the open_interest_usd of this ContractStat.

        Open interest volume(quote currency)  # noqa: E501

        :param open_interest_usd: The open_interest_usd of this ContractStat.  # noqa: E501
        :type: float
        """

        self._open_interest_usd = open_interest_usd

    @property
    def top_lsr_account(self):
        """Gets the top_lsr_account of this ContractStat.  # noqa: E501

        Top trader long/short account ratio  # noqa: E501

        :return: The top_lsr_account of this ContractStat.  # noqa: E501
        :rtype: float
        """
        return self._top_lsr_account

    @top_lsr_account.setter
    def top_lsr_account(self, top_lsr_account):
        """Sets the top_lsr_account of this ContractStat.

        Top trader long/short account ratio  # noqa: E501

        :param top_lsr_account: The top_lsr_account of this ContractStat.  # noqa: E501
        :type: float
        """

        self._top_lsr_account = top_lsr_account

    @property
    def top_lsr_size(self):
        """Gets the top_lsr_size of this ContractStat.  # noqa: E501

        Top trader long/short position ratio  # noqa: E501

        :return: The top_lsr_size of this ContractStat.  # noqa: E501
        :rtype: float
        """
        return self._top_lsr_size

    @top_lsr_size.setter
    def top_lsr_size(self, top_lsr_size):
        """Sets the top_lsr_size of this ContractStat.

        Top trader long/short position ratio  # noqa: E501

        :param top_lsr_size: The top_lsr_size of this ContractStat.  # noqa: E501
        :type: float
        """

        self._top_lsr_size = top_lsr_size

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContractStat):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ContractStat):
            return True

        return self.to_dict() != other.to_dict()
