# coding: utf-8

"""
    Gate API

    Welcome to Gate API  APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces for implementing API-based automated trading.  # noqa: E501

    Contact: support@mail.gate.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class OptionsTicker(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'last_price': 'str',
        'mark_price': 'str',
        'index_price': 'str',
        'ask1_size': 'int',
        'ask1_price': 'str',
        'bid1_size': 'int',
        'bid1_price': 'str',
        'position_size': 'int',
        'mark_iv': 'str',
        'bid_iv': 'str',
        'ask_iv': 'str',
        'leverage': 'str',
        'delta': 'str',
        'gamma': 'str',
        'vega': 'str',
        'theta': 'str',
        'rho': 'str'
    }

    attribute_map = {
        'name': 'name',
        'last_price': 'last_price',
        'mark_price': 'mark_price',
        'index_price': 'index_price',
        'ask1_size': 'ask1_size',
        'ask1_price': 'ask1_price',
        'bid1_size': 'bid1_size',
        'bid1_price': 'bid1_price',
        'position_size': 'position_size',
        'mark_iv': 'mark_iv',
        'bid_iv': 'bid_iv',
        'ask_iv': 'ask_iv',
        'leverage': 'leverage',
        'delta': 'delta',
        'gamma': 'gamma',
        'vega': 'vega',
        'theta': 'theta',
        'rho': 'rho'
    }

    def __init__(self, name=None, last_price=None, mark_price=None, index_price=None, ask1_size=None, ask1_price=None, bid1_size=None, bid1_price=None, position_size=None, mark_iv=None, bid_iv=None, ask_iv=None, leverage=None, delta=None, gamma=None, vega=None, theta=None, rho=None, local_vars_configuration=None):  # noqa: E501
        # type: (str, str, str, str, int, str, int, str, int, str, str, str, str, str, str, str, str, str, Configuration) -> None
        """OptionsTicker - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._last_price = None
        self._mark_price = None
        self._index_price = None
        self._ask1_size = None
        self._ask1_price = None
        self._bid1_size = None
        self._bid1_price = None
        self._position_size = None
        self._mark_iv = None
        self._bid_iv = None
        self._ask_iv = None
        self._leverage = None
        self._delta = None
        self._gamma = None
        self._vega = None
        self._theta = None
        self._rho = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if last_price is not None:
            self.last_price = last_price
        if mark_price is not None:
            self.mark_price = mark_price
        if index_price is not None:
            self.index_price = index_price
        if ask1_size is not None:
            self.ask1_size = ask1_size
        if ask1_price is not None:
            self.ask1_price = ask1_price
        if bid1_size is not None:
            self.bid1_size = bid1_size
        if bid1_price is not None:
            self.bid1_price = bid1_price
        if position_size is not None:
            self.position_size = position_size
        if mark_iv is not None:
            self.mark_iv = mark_iv
        if bid_iv is not None:
            self.bid_iv = bid_iv
        if ask_iv is not None:
            self.ask_iv = ask_iv
        if leverage is not None:
            self.leverage = leverage
        if delta is not None:
            self.delta = delta
        if gamma is not None:
            self.gamma = gamma
        if vega is not None:
            self.vega = vega
        if theta is not None:
            self.theta = theta
        if rho is not None:
            self.rho = rho

    @property
    def name(self):
        """Gets the name of this OptionsTicker.  # noqa: E501

        Options contract name  # noqa: E501

        :return: The name of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this OptionsTicker.

        Options contract name  # noqa: E501

        :param name: The name of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def last_price(self):
        """Gets the last_price of this OptionsTicker.  # noqa: E501

        Last trading price (quote currency)  # noqa: E501

        :return: The last_price of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._last_price

    @last_price.setter
    def last_price(self, last_price):
        """Sets the last_price of this OptionsTicker.

        Last trading price (quote currency)  # noqa: E501

        :param last_price: The last_price of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._last_price = last_price

    @property
    def mark_price(self):
        """Gets the mark_price of this OptionsTicker.  # noqa: E501

        Current mark price (quote currency)  # noqa: E501

        :return: The mark_price of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._mark_price

    @mark_price.setter
    def mark_price(self, mark_price):
        """Sets the mark_price of this OptionsTicker.

        Current mark price (quote currency)  # noqa: E501

        :param mark_price: The mark_price of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._mark_price = mark_price

    @property
    def index_price(self):
        """Gets the index_price of this OptionsTicker.  # noqa: E501

        Current index price (quote currency)  # noqa: E501

        :return: The index_price of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._index_price

    @index_price.setter
    def index_price(self, index_price):
        """Sets the index_price of this OptionsTicker.

        Current index price (quote currency)  # noqa: E501

        :param index_price: The index_price of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._index_price = index_price

    @property
    def ask1_size(self):
        """Gets the ask1_size of this OptionsTicker.  # noqa: E501

        Best ask size  # noqa: E501

        :return: The ask1_size of this OptionsTicker.  # noqa: E501
        :rtype: int
        """
        return self._ask1_size

    @ask1_size.setter
    def ask1_size(self, ask1_size):
        """Sets the ask1_size of this OptionsTicker.

        Best ask size  # noqa: E501

        :param ask1_size: The ask1_size of this OptionsTicker.  # noqa: E501
        :type: int
        """

        self._ask1_size = ask1_size

    @property
    def ask1_price(self):
        """Gets the ask1_price of this OptionsTicker.  # noqa: E501

        Best ask price  # noqa: E501

        :return: The ask1_price of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._ask1_price

    @ask1_price.setter
    def ask1_price(self, ask1_price):
        """Sets the ask1_price of this OptionsTicker.

        Best ask price  # noqa: E501

        :param ask1_price: The ask1_price of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._ask1_price = ask1_price

    @property
    def bid1_size(self):
        """Gets the bid1_size of this OptionsTicker.  # noqa: E501

        Best bid size  # noqa: E501

        :return: The bid1_size of this OptionsTicker.  # noqa: E501
        :rtype: int
        """
        return self._bid1_size

    @bid1_size.setter
    def bid1_size(self, bid1_size):
        """Sets the bid1_size of this OptionsTicker.

        Best bid size  # noqa: E501

        :param bid1_size: The bid1_size of this OptionsTicker.  # noqa: E501
        :type: int
        """

        self._bid1_size = bid1_size

    @property
    def bid1_price(self):
        """Gets the bid1_price of this OptionsTicker.  # noqa: E501

        Best bid price  # noqa: E501

        :return: The bid1_price of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._bid1_price

    @bid1_price.setter
    def bid1_price(self, bid1_price):
        """Sets the bid1_price of this OptionsTicker.

        Best bid price  # noqa: E501

        :param bid1_price: The bid1_price of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._bid1_price = bid1_price

    @property
    def position_size(self):
        """Gets the position_size of this OptionsTicker.  # noqa: E501

        Current total long position size  # noqa: E501

        :return: The position_size of this OptionsTicker.  # noqa: E501
        :rtype: int
        """
        return self._position_size

    @position_size.setter
    def position_size(self, position_size):
        """Sets the position_size of this OptionsTicker.

        Current total long position size  # noqa: E501

        :param position_size: The position_size of this OptionsTicker.  # noqa: E501
        :type: int
        """

        self._position_size = position_size

    @property
    def mark_iv(self):
        """Gets the mark_iv of this OptionsTicker.  # noqa: E501

        Implied volatility  # noqa: E501

        :return: The mark_iv of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._mark_iv

    @mark_iv.setter
    def mark_iv(self, mark_iv):
        """Sets the mark_iv of this OptionsTicker.

        Implied volatility  # noqa: E501

        :param mark_iv: The mark_iv of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._mark_iv = mark_iv

    @property
    def bid_iv(self):
        """Gets the bid_iv of this OptionsTicker.  # noqa: E501

        Bid side implied volatility  # noqa: E501

        :return: The bid_iv of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._bid_iv

    @bid_iv.setter
    def bid_iv(self, bid_iv):
        """Sets the bid_iv of this OptionsTicker.

        Bid side implied volatility  # noqa: E501

        :param bid_iv: The bid_iv of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._bid_iv = bid_iv

    @property
    def ask_iv(self):
        """Gets the ask_iv of this OptionsTicker.  # noqa: E501

        Ask side implied volatility  # noqa: E501

        :return: The ask_iv of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._ask_iv

    @ask_iv.setter
    def ask_iv(self, ask_iv):
        """Sets the ask_iv of this OptionsTicker.

        Ask side implied volatility  # noqa: E501

        :param ask_iv: The ask_iv of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._ask_iv = ask_iv

    @property
    def leverage(self):
        """Gets the leverage of this OptionsTicker.  # noqa: E501

        Current leverage. Formula: underlying_price / mark_price * delta  # noqa: E501

        :return: The leverage of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._leverage

    @leverage.setter
    def leverage(self, leverage):
        """Sets the leverage of this OptionsTicker.

        Current leverage. Formula: underlying_price / mark_price * delta  # noqa: E501

        :param leverage: The leverage of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._leverage = leverage

    @property
    def delta(self):
        """Gets the delta of this OptionsTicker.  # noqa: E501

        Delta  # noqa: E501

        :return: The delta of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._delta

    @delta.setter
    def delta(self, delta):
        """Sets the delta of this OptionsTicker.

        Delta  # noqa: E501

        :param delta: The delta of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._delta = delta

    @property
    def gamma(self):
        """Gets the gamma of this OptionsTicker.  # noqa: E501

        Gamma  # noqa: E501

        :return: The gamma of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._gamma

    @gamma.setter
    def gamma(self, gamma):
        """Sets the gamma of this OptionsTicker.

        Gamma  # noqa: E501

        :param gamma: The gamma of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._gamma = gamma

    @property
    def vega(self):
        """Gets the vega of this OptionsTicker.  # noqa: E501

        Vega  # noqa: E501

        :return: The vega of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._vega

    @vega.setter
    def vega(self, vega):
        """Sets the vega of this OptionsTicker.

        Vega  # noqa: E501

        :param vega: The vega of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._vega = vega

    @property
    def theta(self):
        """Gets the theta of this OptionsTicker.  # noqa: E501

        Theta  # noqa: E501

        :return: The theta of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._theta

    @theta.setter
    def theta(self, theta):
        """Sets the theta of this OptionsTicker.

        Theta  # noqa: E501

        :param theta: The theta of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._theta = theta

    @property
    def rho(self):
        """Gets the rho of this OptionsTicker.  # noqa: E501

        Rho  # noqa: E501

        :return: The rho of this OptionsTicker.  # noqa: E501
        :rtype: str
        """
        return self._rho

    @rho.setter
    def rho(self, rho):
        """Sets the rho of this OptionsTicker.

        Rho  # noqa: E501

        :param rho: The rho of this OptionsTicker.  # noqa: E501
        :type: str
        """

        self._rho = rho

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OptionsTicker):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OptionsTicker):
            return True

        return self.to_dict() != other.to_dict()
