# coding: utf-8

"""
    Gate API

    Welcome to Gate API  APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces for implementing API-based automated trading.  # noqa: E501

    Contact: support@mail.gate.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class RepayRecord(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'order_id': 'int',
        'record_id': 'int',
        'repaid_amount': 'str',
        'borrow_currency': 'str',
        'collateral_currency': 'str',
        'init_ltv': 'str',
        'borrow_time': 'int',
        'repay_time': 'int',
        'total_interest': 'str',
        'before_left_principal': 'str',
        'after_left_principal': 'str',
        'before_left_collateral': 'str',
        'after_left_collateral': 'str'
    }

    attribute_map = {
        'order_id': 'order_id',
        'record_id': 'record_id',
        'repaid_amount': 'repaid_amount',
        'borrow_currency': 'borrow_currency',
        'collateral_currency': 'collateral_currency',
        'init_ltv': 'init_ltv',
        'borrow_time': 'borrow_time',
        'repay_time': 'repay_time',
        'total_interest': 'total_interest',
        'before_left_principal': 'before_left_principal',
        'after_left_principal': 'after_left_principal',
        'before_left_collateral': 'before_left_collateral',
        'after_left_collateral': 'after_left_collateral'
    }

    def __init__(self, order_id=None, record_id=None, repaid_amount=None, borrow_currency=None, collateral_currency=None, init_ltv=None, borrow_time=None, repay_time=None, total_interest=None, before_left_principal=None, after_left_principal=None, before_left_collateral=None, after_left_collateral=None, local_vars_configuration=None):  # noqa: E501
        # type: (int, int, str, str, str, str, int, int, str, str, str, str, str, Configuration) -> None
        """RepayRecord - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._order_id = None
        self._record_id = None
        self._repaid_amount = None
        self._borrow_currency = None
        self._collateral_currency = None
        self._init_ltv = None
        self._borrow_time = None
        self._repay_time = None
        self._total_interest = None
        self._before_left_principal = None
        self._after_left_principal = None
        self._before_left_collateral = None
        self._after_left_collateral = None
        self.discriminator = None

        if order_id is not None:
            self.order_id = order_id
        if record_id is not None:
            self.record_id = record_id
        if repaid_amount is not None:
            self.repaid_amount = repaid_amount
        if borrow_currency is not None:
            self.borrow_currency = borrow_currency
        if collateral_currency is not None:
            self.collateral_currency = collateral_currency
        if init_ltv is not None:
            self.init_ltv = init_ltv
        if borrow_time is not None:
            self.borrow_time = borrow_time
        if repay_time is not None:
            self.repay_time = repay_time
        if total_interest is not None:
            self.total_interest = total_interest
        if before_left_principal is not None:
            self.before_left_principal = before_left_principal
        if after_left_principal is not None:
            self.after_left_principal = after_left_principal
        if before_left_collateral is not None:
            self.before_left_collateral = before_left_collateral
        if after_left_collateral is not None:
            self.after_left_collateral = after_left_collateral

    @property
    def order_id(self):
        """Gets the order_id of this RepayRecord.  # noqa: E501

        Order ID  # noqa: E501

        :return: The order_id of this RepayRecord.  # noqa: E501
        :rtype: int
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this RepayRecord.

        Order ID  # noqa: E501

        :param order_id: The order_id of this RepayRecord.  # noqa: E501
        :type: int
        """

        self._order_id = order_id

    @property
    def record_id(self):
        """Gets the record_id of this RepayRecord.  # noqa: E501

        Repayment record ID  # noqa: E501

        :return: The record_id of this RepayRecord.  # noqa: E501
        :rtype: int
        """
        return self._record_id

    @record_id.setter
    def record_id(self, record_id):
        """Sets the record_id of this RepayRecord.

        Repayment record ID  # noqa: E501

        :param record_id: The record_id of this RepayRecord.  # noqa: E501
        :type: int
        """

        self._record_id = record_id

    @property
    def repaid_amount(self):
        """Gets the repaid_amount of this RepayRecord.  # noqa: E501

        Repayment amount  # noqa: E501

        :return: The repaid_amount of this RepayRecord.  # noqa: E501
        :rtype: str
        """
        return self._repaid_amount

    @repaid_amount.setter
    def repaid_amount(self, repaid_amount):
        """Sets the repaid_amount of this RepayRecord.

        Repayment amount  # noqa: E501

        :param repaid_amount: The repaid_amount of this RepayRecord.  # noqa: E501
        :type: str
        """

        self._repaid_amount = repaid_amount

    @property
    def borrow_currency(self):
        """Gets the borrow_currency of this RepayRecord.  # noqa: E501

        Borrowed currency  # noqa: E501

        :return: The borrow_currency of this RepayRecord.  # noqa: E501
        :rtype: str
        """
        return self._borrow_currency

    @borrow_currency.setter
    def borrow_currency(self, borrow_currency):
        """Sets the borrow_currency of this RepayRecord.

        Borrowed currency  # noqa: E501

        :param borrow_currency: The borrow_currency of this RepayRecord.  # noqa: E501
        :type: str
        """

        self._borrow_currency = borrow_currency

    @property
    def collateral_currency(self):
        """Gets the collateral_currency of this RepayRecord.  # noqa: E501

        Collateral  # noqa: E501

        :return: The collateral_currency of this RepayRecord.  # noqa: E501
        :rtype: str
        """
        return self._collateral_currency

    @collateral_currency.setter
    def collateral_currency(self, collateral_currency):
        """Sets the collateral_currency of this RepayRecord.

        Collateral  # noqa: E501

        :param collateral_currency: The collateral_currency of this RepayRecord.  # noqa: E501
        :type: str
        """

        self._collateral_currency = collateral_currency

    @property
    def init_ltv(self):
        """Gets the init_ltv of this RepayRecord.  # noqa: E501

        The initial collateralization rate  # noqa: E501

        :return: The init_ltv of this RepayRecord.  # noqa: E501
        :rtype: str
        """
        return self._init_ltv

    @init_ltv.setter
    def init_ltv(self, init_ltv):
        """Sets the init_ltv of this RepayRecord.

        The initial collateralization rate  # noqa: E501

        :param init_ltv: The init_ltv of this RepayRecord.  # noqa: E501
        :type: str
        """

        self._init_ltv = init_ltv

    @property
    def borrow_time(self):
        """Gets the borrow_time of this RepayRecord.  # noqa: E501

        Borrowing time, timestamp  # noqa: E501

        :return: The borrow_time of this RepayRecord.  # noqa: E501
        :rtype: int
        """
        return self._borrow_time

    @borrow_time.setter
    def borrow_time(self, borrow_time):
        """Sets the borrow_time of this RepayRecord.

        Borrowing time, timestamp  # noqa: E501

        :param borrow_time: The borrow_time of this RepayRecord.  # noqa: E501
        :type: int
        """

        self._borrow_time = borrow_time

    @property
    def repay_time(self):
        """Gets the repay_time of this RepayRecord.  # noqa: E501

        Repayment time, timestamp  # noqa: E501

        :return: The repay_time of this RepayRecord.  # noqa: E501
        :rtype: int
        """
        return self._repay_time

    @repay_time.setter
    def repay_time(self, repay_time):
        """Sets the repay_time of this RepayRecord.

        Repayment time, timestamp  # noqa: E501

        :param repay_time: The repay_time of this RepayRecord.  # noqa: E501
        :type: int
        """

        self._repay_time = repay_time

    @property
    def total_interest(self):
        """Gets the total_interest of this RepayRecord.  # noqa: E501

        Total interest  # noqa: E501

        :return: The total_interest of this RepayRecord.  # noqa: E501
        :rtype: str
        """
        return self._total_interest

    @total_interest.setter
    def total_interest(self, total_interest):
        """Sets the total_interest of this RepayRecord.

        Total interest  # noqa: E501

        :param total_interest: The total_interest of this RepayRecord.  # noqa: E501
        :type: str
        """

        self._total_interest = total_interest

    @property
    def before_left_principal(self):
        """Gets the before_left_principal of this RepayRecord.  # noqa: E501

        Principal to be repaid before repayment  # noqa: E501

        :return: The before_left_principal of this RepayRecord.  # noqa: E501
        :rtype: str
        """
        return self._before_left_principal

    @before_left_principal.setter
    def before_left_principal(self, before_left_principal):
        """Sets the before_left_principal of this RepayRecord.

        Principal to be repaid before repayment  # noqa: E501

        :param before_left_principal: The before_left_principal of this RepayRecord.  # noqa: E501
        :type: str
        """

        self._before_left_principal = before_left_principal

    @property
    def after_left_principal(self):
        """Gets the after_left_principal of this RepayRecord.  # noqa: E501

        Principal to be repaid after repayment  # noqa: E501

        :return: The after_left_principal of this RepayRecord.  # noqa: E501
        :rtype: str
        """
        return self._after_left_principal

    @after_left_principal.setter
    def after_left_principal(self, after_left_principal):
        """Sets the after_left_principal of this RepayRecord.

        Principal to be repaid after repayment  # noqa: E501

        :param after_left_principal: The after_left_principal of this RepayRecord.  # noqa: E501
        :type: str
        """

        self._after_left_principal = after_left_principal

    @property
    def before_left_collateral(self):
        """Gets the before_left_collateral of this RepayRecord.  # noqa: E501

        Collateral quantity before repayment  # noqa: E501

        :return: The before_left_collateral of this RepayRecord.  # noqa: E501
        :rtype: str
        """
        return self._before_left_collateral

    @before_left_collateral.setter
    def before_left_collateral(self, before_left_collateral):
        """Sets the before_left_collateral of this RepayRecord.

        Collateral quantity before repayment  # noqa: E501

        :param before_left_collateral: The before_left_collateral of this RepayRecord.  # noqa: E501
        :type: str
        """

        self._before_left_collateral = before_left_collateral

    @property
    def after_left_collateral(self):
        """Gets the after_left_collateral of this RepayRecord.  # noqa: E501

        Collateral quantity after repayment  # noqa: E501

        :return: The after_left_collateral of this RepayRecord.  # noqa: E501
        :rtype: str
        """
        return self._after_left_collateral

    @after_left_collateral.setter
    def after_left_collateral(self, after_left_collateral):
        """Sets the after_left_collateral of this RepayRecord.

        Collateral quantity after repayment  # noqa: E501

        :param after_left_collateral: The after_left_collateral of this RepayRecord.  # noqa: E501
        :type: str
        """

        self._after_left_collateral = after_left_collateral

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RepayRecord):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RepayRecord):
            return True

        return self.to_dict() != other.to_dict()
