# coding: utf-8

"""
    Gate API

    Welcome to Gate API  APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces for implementing API-based automated trading.  # noqa: E501

    Contact: support@mail.gate.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class SpotPricePutOrder(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'str',
        'side': 'str',
        'price': 'str',
        'amount': 'str',
        'account': 'str',
        'time_in_force': 'str',
        'auto_borrow': 'bool',
        'auto_repay': 'bool',
        'text': 'str'
    }

    attribute_map = {
        'type': 'type',
        'side': 'side',
        'price': 'price',
        'amount': 'amount',
        'account': 'account',
        'time_in_force': 'time_in_force',
        'auto_borrow': 'auto_borrow',
        'auto_repay': 'auto_repay',
        'text': 'text'
    }

    def __init__(self, type='limit', side=None, price=None, amount=None, account='normal', time_in_force='gtc', auto_borrow=False, auto_repay=False, text=None, local_vars_configuration=None):  # noqa: E501
        # type: (str, str, str, str, str, str, bool, bool, str, Configuration) -> None
        """SpotPricePutOrder - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._type = None
        self._side = None
        self._price = None
        self._amount = None
        self._account = None
        self._time_in_force = None
        self._auto_borrow = None
        self._auto_repay = None
        self._text = None
        self.discriminator = None

        if type is not None:
            self.type = type
        self.side = side
        self.price = price
        self.amount = amount
        self.account = account
        if time_in_force is not None:
            self.time_in_force = time_in_force
        if auto_borrow is not None:
            self.auto_borrow = auto_borrow
        if auto_repay is not None:
            self.auto_repay = auto_repay
        if text is not None:
            self.text = text

    @property
    def type(self):
        """Gets the type of this SpotPricePutOrder.  # noqa: E501

        Order type，default to `limit`  - limit : Limit Order - market : Market Order  # noqa: E501

        :return: The type of this SpotPricePutOrder.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this SpotPricePutOrder.

        Order type，default to `limit`  - limit : Limit Order - market : Market Order  # noqa: E501

        :param type: The type of this SpotPricePutOrder.  # noqa: E501
        :type: str
        """
        allowed_values = ["limit", "market"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def side(self):
        """Gets the side of this SpotPricePutOrder.  # noqa: E501

        Order side  - buy: buy side - sell: sell side  # noqa: E501

        :return: The side of this SpotPricePutOrder.  # noqa: E501
        :rtype: str
        """
        return self._side

    @side.setter
    def side(self, side):
        """Sets the side of this SpotPricePutOrder.

        Order side  - buy: buy side - sell: sell side  # noqa: E501

        :param side: The side of this SpotPricePutOrder.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and side is None:  # noqa: E501
            raise ValueError("Invalid value for `side`, must not be `None`")  # noqa: E501
        allowed_values = ["buy", "sell"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and side not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `side` ({0}), must be one of {1}"  # noqa: E501
                .format(side, allowed_values)
            )

        self._side = side

    @property
    def price(self):
        """Gets the price of this SpotPricePutOrder.  # noqa: E501

        Order price  # noqa: E501

        :return: The price of this SpotPricePutOrder.  # noqa: E501
        :rtype: str
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this SpotPricePutOrder.

        Order price  # noqa: E501

        :param price: The price of this SpotPricePutOrder.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and price is None:  # noqa: E501
            raise ValueError("Invalid value for `price`, must not be `None`")  # noqa: E501

        self._price = price

    @property
    def amount(self):
        """Gets the amount of this SpotPricePutOrder.  # noqa: E501

        When `type` is limit, it refers to base currency.  For instance, `BTC_USDT` means `BTC`  When `type` is `market`, it refers to different currency according to `side`  - `side` : `buy` means quote currency, `BTC_USDT` means `USDT` - `side` : `sell` means base currency，`BTC_USDT` means `BTC`   # noqa: E501

        :return: The amount of this SpotPricePutOrder.  # noqa: E501
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this SpotPricePutOrder.

        When `type` is limit, it refers to base currency.  For instance, `BTC_USDT` means `BTC`  When `type` is `market`, it refers to different currency according to `side`  - `side` : `buy` means quote currency, `BTC_USDT` means `USDT` - `side` : `sell` means base currency，`BTC_USDT` means `BTC`   # noqa: E501

        :param amount: The amount of this SpotPricePutOrder.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def account(self):
        """Gets the account of this SpotPricePutOrder.  # noqa: E501

        Trading account type. Portfolio margin account must set to `unified`  -normal: spot trading - margin: margin trading - unified: unified trading   # noqa: E501

        :return: The account of this SpotPricePutOrder.  # noqa: E501
        :rtype: str
        """
        return self._account

    @account.setter
    def account(self, account):
        """Sets the account of this SpotPricePutOrder.

        Trading account type. Portfolio margin account must set to `unified`  -normal: spot trading - margin: margin trading - unified: unified trading   # noqa: E501

        :param account: The account of this SpotPricePutOrder.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and account is None:  # noqa: E501
            raise ValueError("Invalid value for `account`, must not be `None`")  # noqa: E501
        allowed_values = ["normal", "margin", "unified"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and account not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `account` ({0}), must be one of {1}"  # noqa: E501
                .format(account, allowed_values)
            )

        self._account = account

    @property
    def time_in_force(self):
        """Gets the time_in_force of this SpotPricePutOrder.  # noqa: E501

        time_in_force  - gtc: GoodTillCancelled - ioc: ImmediateOrCancelled, taker only   # noqa: E501

        :return: The time_in_force of this SpotPricePutOrder.  # noqa: E501
        :rtype: str
        """
        return self._time_in_force

    @time_in_force.setter
    def time_in_force(self, time_in_force):
        """Sets the time_in_force of this SpotPricePutOrder.

        time_in_force  - gtc: GoodTillCancelled - ioc: ImmediateOrCancelled, taker only   # noqa: E501

        :param time_in_force: The time_in_force of this SpotPricePutOrder.  # noqa: E501
        :type: str
        """
        allowed_values = ["gtc", "ioc"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and time_in_force not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `time_in_force` ({0}), must be one of {1}"  # noqa: E501
                .format(time_in_force, allowed_values)
            )

        self._time_in_force = time_in_force

    @property
    def auto_borrow(self):
        """Gets the auto_borrow of this SpotPricePutOrder.  # noqa: E501

        Whether to borrow coins automatically  # noqa: E501

        :return: The auto_borrow of this SpotPricePutOrder.  # noqa: E501
        :rtype: bool
        """
        return self._auto_borrow

    @auto_borrow.setter
    def auto_borrow(self, auto_borrow):
        """Sets the auto_borrow of this SpotPricePutOrder.

        Whether to borrow coins automatically  # noqa: E501

        :param auto_borrow: The auto_borrow of this SpotPricePutOrder.  # noqa: E501
        :type: bool
        """

        self._auto_borrow = auto_borrow

    @property
    def auto_repay(self):
        """Gets the auto_repay of this SpotPricePutOrder.  # noqa: E501

        Whether to repay the loan automatically  # noqa: E501

        :return: The auto_repay of this SpotPricePutOrder.  # noqa: E501
        :rtype: bool
        """
        return self._auto_repay

    @auto_repay.setter
    def auto_repay(self, auto_repay):
        """Sets the auto_repay of this SpotPricePutOrder.

        Whether to repay the loan automatically  # noqa: E501

        :param auto_repay: The auto_repay of this SpotPricePutOrder.  # noqa: E501
        :type: bool
        """

        self._auto_repay = auto_repay

    @property
    def text(self):
        """Gets the text of this SpotPricePutOrder.  # noqa: E501

        The source of the order, including: - web: web - api: api - app: app  # noqa: E501

        :return: The text of this SpotPricePutOrder.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this SpotPricePutOrder.

        The source of the order, including: - web: web - api: api - app: app  # noqa: E501

        :param text: The text of this SpotPricePutOrder.  # noqa: E501
        :type: str
        """

        self._text = text

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SpotPricePutOrder):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SpotPricePutOrder):
            return True

        return self.to_dict() != other.to_dict()
