# coding: utf-8

"""
    Gate API

    Welcome to Gate API  APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces for implementing API-based automated trading.  # noqa: E501

    Contact: support@mail.gate.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class SubCrossMarginAccount(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'user_id': 'int',
        'locked': 'bool',
        'balances': 'dict(str, CrossMarginBalance)',
        'total': 'str',
        'borrowed': 'str',
        'borrowed_net': 'str',
        'net': 'str',
        'leverage': 'str',
        'interest': 'str',
        'risk': 'str',
        'total_initial_margin': 'str',
        'total_margin_balance': 'str',
        'total_maintenance_margin': 'str',
        'total_initial_margin_rate': 'str',
        'total_maintenance_margin_rate': 'str',
        'total_available_margin': 'str'
    }

    attribute_map = {
        'user_id': 'user_id',
        'locked': 'locked',
        'balances': 'balances',
        'total': 'total',
        'borrowed': 'borrowed',
        'borrowed_net': 'borrowed_net',
        'net': 'net',
        'leverage': 'leverage',
        'interest': 'interest',
        'risk': 'risk',
        'total_initial_margin': 'total_initial_margin',
        'total_margin_balance': 'total_margin_balance',
        'total_maintenance_margin': 'total_maintenance_margin',
        'total_initial_margin_rate': 'total_initial_margin_rate',
        'total_maintenance_margin_rate': 'total_maintenance_margin_rate',
        'total_available_margin': 'total_available_margin'
    }

    def __init__(self, user_id=None, locked=None, balances=None, total=None, borrowed=None, borrowed_net=None, net=None, leverage=None, interest=None, risk=None, total_initial_margin=None, total_margin_balance=None, total_maintenance_margin=None, total_initial_margin_rate=None, total_maintenance_margin_rate=None, total_available_margin=None, local_vars_configuration=None):  # noqa: E501
        # type: (int, bool, dict(str, CrossMarginBalance), str, str, str, str, str, str, str, str, str, str, str, str, str, Configuration) -> None
        """SubCrossMarginAccount - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._user_id = None
        self._locked = None
        self._balances = None
        self._total = None
        self._borrowed = None
        self._borrowed_net = None
        self._net = None
        self._leverage = None
        self._interest = None
        self._risk = None
        self._total_initial_margin = None
        self._total_margin_balance = None
        self._total_maintenance_margin = None
        self._total_initial_margin_rate = None
        self._total_maintenance_margin_rate = None
        self._total_available_margin = None
        self.discriminator = None

        if user_id is not None:
            self.user_id = user_id
        if locked is not None:
            self.locked = locked
        if balances is not None:
            self.balances = balances
        if total is not None:
            self.total = total
        if borrowed is not None:
            self.borrowed = borrowed
        if borrowed_net is not None:
            self.borrowed_net = borrowed_net
        if net is not None:
            self.net = net
        if leverage is not None:
            self.leverage = leverage
        if interest is not None:
            self.interest = interest
        if risk is not None:
            self.risk = risk
        if total_initial_margin is not None:
            self.total_initial_margin = total_initial_margin
        if total_margin_balance is not None:
            self.total_margin_balance = total_margin_balance
        if total_maintenance_margin is not None:
            self.total_maintenance_margin = total_maintenance_margin
        if total_initial_margin_rate is not None:
            self.total_initial_margin_rate = total_initial_margin_rate
        if total_maintenance_margin_rate is not None:
            self.total_maintenance_margin_rate = total_maintenance_margin_rate
        if total_available_margin is not None:
            self.total_available_margin = total_available_margin

    @property
    def user_id(self):
        """Gets the user_id of this SubCrossMarginAccount.  # noqa: E501

        User ID of the cross margin account. 0 means that the subaccount has not yet opened a cross margin account  # noqa: E501

        :return: The user_id of this SubCrossMarginAccount.  # noqa: E501
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this SubCrossMarginAccount.

        User ID of the cross margin account. 0 means that the subaccount has not yet opened a cross margin account  # noqa: E501

        :param user_id: The user_id of this SubCrossMarginAccount.  # noqa: E501
        :type: int
        """

        self._user_id = user_id

    @property
    def locked(self):
        """Gets the locked of this SubCrossMarginAccount.  # noqa: E501

        Whether account is locked  # noqa: E501

        :return: The locked of this SubCrossMarginAccount.  # noqa: E501
        :rtype: bool
        """
        return self._locked

    @locked.setter
    def locked(self, locked):
        """Sets the locked of this SubCrossMarginAccount.

        Whether account is locked  # noqa: E501

        :param locked: The locked of this SubCrossMarginAccount.  # noqa: E501
        :type: bool
        """

        self._locked = locked

    @property
    def balances(self):
        """Gets the balances of this SubCrossMarginAccount.  # noqa: E501


        :return: The balances of this SubCrossMarginAccount.  # noqa: E501
        :rtype: dict(str, CrossMarginBalance)
        """
        return self._balances

    @balances.setter
    def balances(self, balances):
        """Sets the balances of this SubCrossMarginAccount.


        :param balances: The balances of this SubCrossMarginAccount.  # noqa: E501
        :type: dict(str, CrossMarginBalance)
        """

        self._balances = balances

    @property
    def total(self):
        """Gets the total of this SubCrossMarginAccount.  # noqa: E501

        Total account value in USDT, i.e., the sum of all currencies' `(available+freeze)*price*discount`  # noqa: E501

        :return: The total of this SubCrossMarginAccount.  # noqa: E501
        :rtype: str
        """
        return self._total

    @total.setter
    def total(self, total):
        """Sets the total of this SubCrossMarginAccount.

        Total account value in USDT, i.e., the sum of all currencies' `(available+freeze)*price*discount`  # noqa: E501

        :param total: The total of this SubCrossMarginAccount.  # noqa: E501
        :type: str
        """

        self._total = total

    @property
    def borrowed(self):
        """Gets the borrowed of this SubCrossMarginAccount.  # noqa: E501

        Total borrowed value in USDT, i.e., the sum of all currencies' `borrowed*price*discount`  # noqa: E501

        :return: The borrowed of this SubCrossMarginAccount.  # noqa: E501
        :rtype: str
        """
        return self._borrowed

    @borrowed.setter
    def borrowed(self, borrowed):
        """Sets the borrowed of this SubCrossMarginAccount.

        Total borrowed value in USDT, i.e., the sum of all currencies' `borrowed*price*discount`  # noqa: E501

        :param borrowed: The borrowed of this SubCrossMarginAccount.  # noqa: E501
        :type: str
        """

        self._borrowed = borrowed

    @property
    def borrowed_net(self):
        """Gets the borrowed_net of this SubCrossMarginAccount.  # noqa: E501

        Total borrowed value in USDT * borrowed factor  # noqa: E501

        :return: The borrowed_net of this SubCrossMarginAccount.  # noqa: E501
        :rtype: str
        """
        return self._borrowed_net

    @borrowed_net.setter
    def borrowed_net(self, borrowed_net):
        """Sets the borrowed_net of this SubCrossMarginAccount.

        Total borrowed value in USDT * borrowed factor  # noqa: E501

        :param borrowed_net: The borrowed_net of this SubCrossMarginAccount.  # noqa: E501
        :type: str
        """

        self._borrowed_net = borrowed_net

    @property
    def net(self):
        """Gets the net of this SubCrossMarginAccount.  # noqa: E501

        Total net assets in USDT  # noqa: E501

        :return: The net of this SubCrossMarginAccount.  # noqa: E501
        :rtype: str
        """
        return self._net

    @net.setter
    def net(self, net):
        """Sets the net of this SubCrossMarginAccount.

        Total net assets in USDT  # noqa: E501

        :param net: The net of this SubCrossMarginAccount.  # noqa: E501
        :type: str
        """

        self._net = net

    @property
    def leverage(self):
        """Gets the leverage of this SubCrossMarginAccount.  # noqa: E501

        Position leverage  # noqa: E501

        :return: The leverage of this SubCrossMarginAccount.  # noqa: E501
        :rtype: str
        """
        return self._leverage

    @leverage.setter
    def leverage(self, leverage):
        """Sets the leverage of this SubCrossMarginAccount.

        Position leverage  # noqa: E501

        :param leverage: The leverage of this SubCrossMarginAccount.  # noqa: E501
        :type: str
        """

        self._leverage = leverage

    @property
    def interest(self):
        """Gets the interest of this SubCrossMarginAccount.  # noqa: E501

        Total unpaid interests in USDT, i.e., the sum of all currencies' `interest*price*discount`  # noqa: E501

        :return: The interest of this SubCrossMarginAccount.  # noqa: E501
        :rtype: str
        """
        return self._interest

    @interest.setter
    def interest(self, interest):
        """Sets the interest of this SubCrossMarginAccount.

        Total unpaid interests in USDT, i.e., the sum of all currencies' `interest*price*discount`  # noqa: E501

        :param interest: The interest of this SubCrossMarginAccount.  # noqa: E501
        :type: str
        """

        self._interest = interest

    @property
    def risk(self):
        """Gets the risk of this SubCrossMarginAccount.  # noqa: E501

        Risk rate. When it belows 110%, liquidation will be triggered. Calculation formula: `total / (borrowed+interest)`  # noqa: E501

        :return: The risk of this SubCrossMarginAccount.  # noqa: E501
        :rtype: str
        """
        return self._risk

    @risk.setter
    def risk(self, risk):
        """Sets the risk of this SubCrossMarginAccount.

        Risk rate. When it belows 110%, liquidation will be triggered. Calculation formula: `total / (borrowed+interest)`  # noqa: E501

        :param risk: The risk of this SubCrossMarginAccount.  # noqa: E501
        :type: str
        """

        self._risk = risk

    @property
    def total_initial_margin(self):
        """Gets the total_initial_margin of this SubCrossMarginAccount.  # noqa: E501

        Total initial margin  # noqa: E501

        :return: The total_initial_margin of this SubCrossMarginAccount.  # noqa: E501
        :rtype: str
        """
        return self._total_initial_margin

    @total_initial_margin.setter
    def total_initial_margin(self, total_initial_margin):
        """Sets the total_initial_margin of this SubCrossMarginAccount.

        Total initial margin  # noqa: E501

        :param total_initial_margin: The total_initial_margin of this SubCrossMarginAccount.  # noqa: E501
        :type: str
        """

        self._total_initial_margin = total_initial_margin

    @property
    def total_margin_balance(self):
        """Gets the total_margin_balance of this SubCrossMarginAccount.  # noqa: E501

        Total margin balance  # noqa: E501

        :return: The total_margin_balance of this SubCrossMarginAccount.  # noqa: E501
        :rtype: str
        """
        return self._total_margin_balance

    @total_margin_balance.setter
    def total_margin_balance(self, total_margin_balance):
        """Sets the total_margin_balance of this SubCrossMarginAccount.

        Total margin balance  # noqa: E501

        :param total_margin_balance: The total_margin_balance of this SubCrossMarginAccount.  # noqa: E501
        :type: str
        """

        self._total_margin_balance = total_margin_balance

    @property
    def total_maintenance_margin(self):
        """Gets the total_maintenance_margin of this SubCrossMarginAccount.  # noqa: E501

        Total maintenance margin  # noqa: E501

        :return: The total_maintenance_margin of this SubCrossMarginAccount.  # noqa: E501
        :rtype: str
        """
        return self._total_maintenance_margin

    @total_maintenance_margin.setter
    def total_maintenance_margin(self, total_maintenance_margin):
        """Sets the total_maintenance_margin of this SubCrossMarginAccount.

        Total maintenance margin  # noqa: E501

        :param total_maintenance_margin: The total_maintenance_margin of this SubCrossMarginAccount.  # noqa: E501
        :type: str
        """

        self._total_maintenance_margin = total_maintenance_margin

    @property
    def total_initial_margin_rate(self):
        """Gets the total_initial_margin_rate of this SubCrossMarginAccount.  # noqa: E501

        Total initial margin rate  # noqa: E501

        :return: The total_initial_margin_rate of this SubCrossMarginAccount.  # noqa: E501
        :rtype: str
        """
        return self._total_initial_margin_rate

    @total_initial_margin_rate.setter
    def total_initial_margin_rate(self, total_initial_margin_rate):
        """Sets the total_initial_margin_rate of this SubCrossMarginAccount.

        Total initial margin rate  # noqa: E501

        :param total_initial_margin_rate: The total_initial_margin_rate of this SubCrossMarginAccount.  # noqa: E501
        :type: str
        """

        self._total_initial_margin_rate = total_initial_margin_rate

    @property
    def total_maintenance_margin_rate(self):
        """Gets the total_maintenance_margin_rate of this SubCrossMarginAccount.  # noqa: E501

        Total maintenance margin rate  # noqa: E501

        :return: The total_maintenance_margin_rate of this SubCrossMarginAccount.  # noqa: E501
        :rtype: str
        """
        return self._total_maintenance_margin_rate

    @total_maintenance_margin_rate.setter
    def total_maintenance_margin_rate(self, total_maintenance_margin_rate):
        """Sets the total_maintenance_margin_rate of this SubCrossMarginAccount.

        Total maintenance margin rate  # noqa: E501

        :param total_maintenance_margin_rate: The total_maintenance_margin_rate of this SubCrossMarginAccount.  # noqa: E501
        :type: str
        """

        self._total_maintenance_margin_rate = total_maintenance_margin_rate

    @property
    def total_available_margin(self):
        """Gets the total_available_margin of this SubCrossMarginAccount.  # noqa: E501

        Total available margin  # noqa: E501

        :return: The total_available_margin of this SubCrossMarginAccount.  # noqa: E501
        :rtype: str
        """
        return self._total_available_margin

    @total_available_margin.setter
    def total_available_margin(self, total_available_margin):
        """Sets the total_available_margin of this SubCrossMarginAccount.

        Total available margin  # noqa: E501

        :param total_available_margin: The total_available_margin of this SubCrossMarginAccount.  # noqa: E501
        :type: str
        """

        self._total_available_margin = total_available_margin

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SubCrossMarginAccount):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SubCrossMarginAccount):
            return True

        return self.to_dict() != other.to_dict()
