# coding: utf-8

"""
    Gate API

    Welcome to Gate API  APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces for implementing API-based automated trading.  # noqa: E501

    Contact: support@mail.gate.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class UniCurrencyPair(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'currency_pair': 'str',
        'base_min_borrow_amount': 'str',
        'quote_min_borrow_amount': 'str',
        'leverage': 'str'
    }

    attribute_map = {
        'currency_pair': 'currency_pair',
        'base_min_borrow_amount': 'base_min_borrow_amount',
        'quote_min_borrow_amount': 'quote_min_borrow_amount',
        'leverage': 'leverage'
    }

    def __init__(self, currency_pair=None, base_min_borrow_amount=None, quote_min_borrow_amount=None, leverage=None, local_vars_configuration=None):  # noqa: E501
        # type: (str, str, str, str, Configuration) -> None
        """UniCurrencyPair - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._currency_pair = None
        self._base_min_borrow_amount = None
        self._quote_min_borrow_amount = None
        self._leverage = None
        self.discriminator = None

        if currency_pair is not None:
            self.currency_pair = currency_pair
        if base_min_borrow_amount is not None:
            self.base_min_borrow_amount = base_min_borrow_amount
        if quote_min_borrow_amount is not None:
            self.quote_min_borrow_amount = quote_min_borrow_amount
        if leverage is not None:
            self.leverage = leverage

    @property
    def currency_pair(self):
        """Gets the currency_pair of this UniCurrencyPair.  # noqa: E501

        Currency pair  # noqa: E501

        :return: The currency_pair of this UniCurrencyPair.  # noqa: E501
        :rtype: str
        """
        return self._currency_pair

    @currency_pair.setter
    def currency_pair(self, currency_pair):
        """Sets the currency_pair of this UniCurrencyPair.

        Currency pair  # noqa: E501

        :param currency_pair: The currency_pair of this UniCurrencyPair.  # noqa: E501
        :type: str
        """

        self._currency_pair = currency_pair

    @property
    def base_min_borrow_amount(self):
        """Gets the base_min_borrow_amount of this UniCurrencyPair.  # noqa: E501

        Minimum borrow amount of base currency  # noqa: E501

        :return: The base_min_borrow_amount of this UniCurrencyPair.  # noqa: E501
        :rtype: str
        """
        return self._base_min_borrow_amount

    @base_min_borrow_amount.setter
    def base_min_borrow_amount(self, base_min_borrow_amount):
        """Sets the base_min_borrow_amount of this UniCurrencyPair.

        Minimum borrow amount of base currency  # noqa: E501

        :param base_min_borrow_amount: The base_min_borrow_amount of this UniCurrencyPair.  # noqa: E501
        :type: str
        """

        self._base_min_borrow_amount = base_min_borrow_amount

    @property
    def quote_min_borrow_amount(self):
        """Gets the quote_min_borrow_amount of this UniCurrencyPair.  # noqa: E501

        Minimum borrow amount of quote currency  # noqa: E501

        :return: The quote_min_borrow_amount of this UniCurrencyPair.  # noqa: E501
        :rtype: str
        """
        return self._quote_min_borrow_amount

    @quote_min_borrow_amount.setter
    def quote_min_borrow_amount(self, quote_min_borrow_amount):
        """Sets the quote_min_borrow_amount of this UniCurrencyPair.

        Minimum borrow amount of quote currency  # noqa: E501

        :param quote_min_borrow_amount: The quote_min_borrow_amount of this UniCurrencyPair.  # noqa: E501
        :type: str
        """

        self._quote_min_borrow_amount = quote_min_borrow_amount

    @property
    def leverage(self):
        """Gets the leverage of this UniCurrencyPair.  # noqa: E501

        Position leverage  # noqa: E501

        :return: The leverage of this UniCurrencyPair.  # noqa: E501
        :rtype: str
        """
        return self._leverage

    @leverage.setter
    def leverage(self, leverage):
        """Sets the leverage of this UniCurrencyPair.

        Position leverage  # noqa: E501

        :param leverage: The leverage of this UniCurrencyPair.  # noqa: E501
        :type: str
        """

        self._leverage = leverage

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UniCurrencyPair):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UniCurrencyPair):
            return True

        return self.to_dict() != other.to_dict()
