# coding: utf-8

"""
    Gate API

    Welcome to Gate API  APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces for implementing API-based automated trading.  # noqa: E501

    Contact: support@mail.gate.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class UnifiedBalance(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'available': 'str',
        'freeze': 'str',
        'borrowed': 'str',
        'negative_liab': 'str',
        'futures_pos_liab': 'str',
        'equity': 'str',
        'total_freeze': 'str',
        'total_liab': 'str',
        'spot_in_use': 'str',
        'funding': 'str',
        'funding_version': 'str',
        'cross_balance': 'str',
        'iso_balance': 'str',
        'im': 'str',
        'mm': 'str',
        'imr': 'str',
        'mmr': 'str',
        'margin_balance': 'str',
        'available_margin': 'str',
        'enabled_collateral': 'bool'
    }

    attribute_map = {
        'available': 'available',
        'freeze': 'freeze',
        'borrowed': 'borrowed',
        'negative_liab': 'negative_liab',
        'futures_pos_liab': 'futures_pos_liab',
        'equity': 'equity',
        'total_freeze': 'total_freeze',
        'total_liab': 'total_liab',
        'spot_in_use': 'spot_in_use',
        'funding': 'funding',
        'funding_version': 'funding_version',
        'cross_balance': 'cross_balance',
        'iso_balance': 'iso_balance',
        'im': 'im',
        'mm': 'mm',
        'imr': 'imr',
        'mmr': 'mmr',
        'margin_balance': 'margin_balance',
        'available_margin': 'available_margin',
        'enabled_collateral': 'enabled_collateral'
    }

    def __init__(self, available=None, freeze=None, borrowed=None, negative_liab=None, futures_pos_liab=None, equity=None, total_freeze=None, total_liab=None, spot_in_use=None, funding=None, funding_version=None, cross_balance=None, iso_balance=None, im=None, mm=None, imr=None, mmr=None, margin_balance=None, available_margin=None, enabled_collateral=None, local_vars_configuration=None):  # noqa: E501
        # type: (str, str, str, str, str, str, str, str, str, str, str, str, str, str, str, str, str, str, str, bool, Configuration) -> None
        """UnifiedBalance - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._available = None
        self._freeze = None
        self._borrowed = None
        self._negative_liab = None
        self._futures_pos_liab = None
        self._equity = None
        self._total_freeze = None
        self._total_liab = None
        self._spot_in_use = None
        self._funding = None
        self._funding_version = None
        self._cross_balance = None
        self._iso_balance = None
        self._im = None
        self._mm = None
        self._imr = None
        self._mmr = None
        self._margin_balance = None
        self._available_margin = None
        self._enabled_collateral = None
        self.discriminator = None

        if available is not None:
            self.available = available
        if freeze is not None:
            self.freeze = freeze
        if borrowed is not None:
            self.borrowed = borrowed
        if negative_liab is not None:
            self.negative_liab = negative_liab
        if futures_pos_liab is not None:
            self.futures_pos_liab = futures_pos_liab
        if equity is not None:
            self.equity = equity
        if total_freeze is not None:
            self.total_freeze = total_freeze
        if total_liab is not None:
            self.total_liab = total_liab
        if spot_in_use is not None:
            self.spot_in_use = spot_in_use
        if funding is not None:
            self.funding = funding
        if funding_version is not None:
            self.funding_version = funding_version
        if cross_balance is not None:
            self.cross_balance = cross_balance
        if iso_balance is not None:
            self.iso_balance = iso_balance
        if im is not None:
            self.im = im
        if mm is not None:
            self.mm = mm
        if imr is not None:
            self.imr = imr
        if mmr is not None:
            self.mmr = mmr
        if margin_balance is not None:
            self.margin_balance = margin_balance
        if available_margin is not None:
            self.available_margin = available_margin
        if enabled_collateral is not None:
            self.enabled_collateral = enabled_collateral

    @property
    def available(self):
        """Gets the available of this UnifiedBalance.  # noqa: E501

        Available amount is valid in single currency margin/cross-currency margin/combined margin mode, and the calculation is different in different modes  # noqa: E501

        :return: The available of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._available

    @available.setter
    def available(self, available):
        """Sets the available of this UnifiedBalance.

        Available amount is valid in single currency margin/cross-currency margin/combined margin mode, and the calculation is different in different modes  # noqa: E501

        :param available: The available of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._available = available

    @property
    def freeze(self):
        """Gets the freeze of this UnifiedBalance.  # noqa: E501

        The locked amount is valid in single currency margin/cross-currency margin/combined margin mode  # noqa: E501

        :return: The freeze of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._freeze

    @freeze.setter
    def freeze(self, freeze):
        """Sets the freeze of this UnifiedBalance.

        The locked amount is valid in single currency margin/cross-currency margin/combined margin mode  # noqa: E501

        :param freeze: The freeze of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._freeze = freeze

    @property
    def borrowed(self):
        """Gets the borrowed of this UnifiedBalance.  # noqa: E501

        Borrow limit, valid in cross-currency margin/combined margin mode, 0 in other modes such as single-currency margin mode  # noqa: E501

        :return: The borrowed of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._borrowed

    @borrowed.setter
    def borrowed(self, borrowed):
        """Sets the borrowed of this UnifiedBalance.

        Borrow limit, valid in cross-currency margin/combined margin mode, 0 in other modes such as single-currency margin mode  # noqa: E501

        :param borrowed: The borrowed of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._borrowed = borrowed

    @property
    def negative_liab(self):
        """Gets the negative_liab of this UnifiedBalance.  # noqa: E501

        Negative balance loan is valid in cross-currency margin/combined margin mode, and is 0 in other modes such as single-currency margin mode  # noqa: E501

        :return: The negative_liab of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._negative_liab

    @negative_liab.setter
    def negative_liab(self, negative_liab):
        """Sets the negative_liab of this UnifiedBalance.

        Negative balance loan is valid in cross-currency margin/combined margin mode, and is 0 in other modes such as single-currency margin mode  # noqa: E501

        :param negative_liab: The negative_liab of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._negative_liab = negative_liab

    @property
    def futures_pos_liab(self):
        """Gets the futures_pos_liab of this UnifiedBalance.  # noqa: E501

        Contract opening position borrowing currency (abandoned, to be offline field)  # noqa: E501

        :return: The futures_pos_liab of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._futures_pos_liab

    @futures_pos_liab.setter
    def futures_pos_liab(self, futures_pos_liab):
        """Sets the futures_pos_liab of this UnifiedBalance.

        Contract opening position borrowing currency (abandoned, to be offline field)  # noqa: E501

        :param futures_pos_liab: The futures_pos_liab of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._futures_pos_liab = futures_pos_liab

    @property
    def equity(self):
        """Gets the equity of this UnifiedBalance.  # noqa: E501

        Equity, valid in single currency margin/cross currency margin/combined margin mode  # noqa: E501

        :return: The equity of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._equity

    @equity.setter
    def equity(self, equity):
        """Sets the equity of this UnifiedBalance.

        Equity, valid in single currency margin/cross currency margin/combined margin mode  # noqa: E501

        :param equity: The equity of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._equity = equity

    @property
    def total_freeze(self):
        """Gets the total_freeze of this UnifiedBalance.  # noqa: E501

        Total occupancy (discarded, to be offline field)  # noqa: E501

        :return: The total_freeze of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._total_freeze

    @total_freeze.setter
    def total_freeze(self, total_freeze):
        """Sets the total_freeze of this UnifiedBalance.

        Total occupancy (discarded, to be offline field)  # noqa: E501

        :param total_freeze: The total_freeze of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._total_freeze = total_freeze

    @property
    def total_liab(self):
        """Gets the total_liab of this UnifiedBalance.  # noqa: E501

        Total borrowing, valid in cross-currency margin/combined margin mode, 0 in other modes such as single-currency margin mode  # noqa: E501

        :return: The total_liab of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._total_liab

    @total_liab.setter
    def total_liab(self, total_liab):
        """Sets the total_liab of this UnifiedBalance.

        Total borrowing, valid in cross-currency margin/combined margin mode, 0 in other modes such as single-currency margin mode  # noqa: E501

        :param total_liab: The total_liab of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._total_liab = total_liab

    @property
    def spot_in_use(self):
        """Gets the spot_in_use of this UnifiedBalance.  # noqa: E501

        The amount of spot hedging is valid in the combined margin mode, and is 0 in other margin modes such as single currency and cross-currency margin modes  # noqa: E501

        :return: The spot_in_use of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._spot_in_use

    @spot_in_use.setter
    def spot_in_use(self, spot_in_use):
        """Sets the spot_in_use of this UnifiedBalance.

        The amount of spot hedging is valid in the combined margin mode, and is 0 in other margin modes such as single currency and cross-currency margin modes  # noqa: E501

        :param spot_in_use: The spot_in_use of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._spot_in_use = spot_in_use

    @property
    def funding(self):
        """Gets the funding of this UnifiedBalance.  # noqa: E501

        Uniloan financial management amount, effective when Uniloan financial management is turned on as a unified account margin switch  # noqa: E501

        :return: The funding of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._funding

    @funding.setter
    def funding(self, funding):
        """Sets the funding of this UnifiedBalance.

        Uniloan financial management amount, effective when Uniloan financial management is turned on as a unified account margin switch  # noqa: E501

        :param funding: The funding of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._funding = funding

    @property
    def funding_version(self):
        """Gets the funding_version of this UnifiedBalance.  # noqa: E501

        Funding version  # noqa: E501

        :return: The funding_version of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._funding_version

    @funding_version.setter
    def funding_version(self, funding_version):
        """Sets the funding_version of this UnifiedBalance.

        Funding version  # noqa: E501

        :param funding_version: The funding_version of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._funding_version = funding_version

    @property
    def cross_balance(self):
        """Gets the cross_balance of this UnifiedBalance.  # noqa: E501

        Full margin balance is valid in single currency margin mode, and is 0 in other modes such as cross currency margin/combined margin mode  # noqa: E501

        :return: The cross_balance of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._cross_balance

    @cross_balance.setter
    def cross_balance(self, cross_balance):
        """Sets the cross_balance of this UnifiedBalance.

        Full margin balance is valid in single currency margin mode, and is 0 in other modes such as cross currency margin/combined margin mode  # noqa: E501

        :param cross_balance: The cross_balance of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._cross_balance = cross_balance

    @property
    def iso_balance(self):
        """Gets the iso_balance of this UnifiedBalance.  # noqa: E501

        Isolated margin balance is valid in single-currency margin mode and is 0 in other modes such as cross-currency margin/combined margin mode  # noqa: E501

        :return: The iso_balance of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._iso_balance

    @iso_balance.setter
    def iso_balance(self, iso_balance):
        """Sets the iso_balance of this UnifiedBalance.

        Isolated margin balance is valid in single-currency margin mode and is 0 in other modes such as cross-currency margin/combined margin mode  # noqa: E501

        :param iso_balance: The iso_balance of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._iso_balance = iso_balance

    @property
    def im(self):
        """Gets the im of this UnifiedBalance.  # noqa: E501

        Full-position initial margin is valid in single-currency margin mode and is 0 in other modes such as cross-currency margin/combined margin mode  # noqa: E501

        :return: The im of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._im

    @im.setter
    def im(self, im):
        """Sets the im of this UnifiedBalance.

        Full-position initial margin is valid in single-currency margin mode and is 0 in other modes such as cross-currency margin/combined margin mode  # noqa: E501

        :param im: The im of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._im = im

    @property
    def mm(self):
        """Gets the mm of this UnifiedBalance.  # noqa: E501

        The full position maintains margin, which is valid in the single currency margin mode, and other cross-currency margin combination margin mode is 0.  # noqa: E501

        :return: The mm of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._mm

    @mm.setter
    def mm(self, mm):
        """Sets the mm of this UnifiedBalance.

        The full position maintains margin, which is valid in the single currency margin mode, and other cross-currency margin combination margin mode is 0.  # noqa: E501

        :param mm: The mm of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._mm = mm

    @property
    def imr(self):
        """Gets the imr of this UnifiedBalance.  # noqa: E501

        Full-position initial margin rate is valid in single-currency margin mode and is 0 in other modes such as cross-currency margin/combined margin mode  # noqa: E501

        :return: The imr of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._imr

    @imr.setter
    def imr(self, imr):
        """Sets the imr of this UnifiedBalance.

        Full-position initial margin rate is valid in single-currency margin mode and is 0 in other modes such as cross-currency margin/combined margin mode  # noqa: E501

        :param imr: The imr of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._imr = imr

    @property
    def mmr(self):
        """Gets the mmr of this UnifiedBalance.  # noqa: E501

        Full-position maintenance margin rate is valid in single-currency margin mode and is 0 in other modes such as cross-currency margin/combined margin mode  # noqa: E501

        :return: The mmr of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._mmr

    @mmr.setter
    def mmr(self, mmr):
        """Sets the mmr of this UnifiedBalance.

        Full-position maintenance margin rate is valid in single-currency margin mode and is 0 in other modes such as cross-currency margin/combined margin mode  # noqa: E501

        :param mmr: The mmr of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._mmr = mmr

    @property
    def margin_balance(self):
        """Gets the margin_balance of this UnifiedBalance.  # noqa: E501

        Full margin balance is valid in single currency margin mode and is 0 in other modes such as cross currency margin/combined margin mode  # noqa: E501

        :return: The margin_balance of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._margin_balance

    @margin_balance.setter
    def margin_balance(self, margin_balance):
        """Sets the margin_balance of this UnifiedBalance.

        Full margin balance is valid in single currency margin mode and is 0 in other modes such as cross currency margin/combined margin mode  # noqa: E501

        :param margin_balance: The margin_balance of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._margin_balance = margin_balance

    @property
    def available_margin(self):
        """Gets the available_margin of this UnifiedBalance.  # noqa: E501

        Full margin available for full position is valid in single currency margin mode, and is 0 in other modes such as cross-currency margin/combined margin mode  # noqa: E501

        :return: The available_margin of this UnifiedBalance.  # noqa: E501
        :rtype: str
        """
        return self._available_margin

    @available_margin.setter
    def available_margin(self, available_margin):
        """Sets the available_margin of this UnifiedBalance.

        Full margin available for full position is valid in single currency margin mode, and is 0 in other modes such as cross-currency margin/combined margin mode  # noqa: E501

        :param available_margin: The available_margin of this UnifiedBalance.  # noqa: E501
        :type: str
        """

        self._available_margin = available_margin

    @property
    def enabled_collateral(self):
        """Gets the enabled_collateral of this UnifiedBalance.  # noqa: E501

        Currency enabled as margin: true - Enabled, false - Disabled  # noqa: E501

        :return: The enabled_collateral of this UnifiedBalance.  # noqa: E501
        :rtype: bool
        """
        return self._enabled_collateral

    @enabled_collateral.setter
    def enabled_collateral(self, enabled_collateral):
        """Sets the enabled_collateral of this UnifiedBalance.

        Currency enabled as margin: true - Enabled, false - Disabled  # noqa: E501

        :param enabled_collateral: The enabled_collateral of this UnifiedBalance.  # noqa: E501
        :type: bool
        """

        self._enabled_collateral = enabled_collateral

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UnifiedBalance):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UnifiedBalance):
            return True

        return self.to_dict() != other.to_dict()
