# coding: utf-8

"""
    Gate API

    Welcome to Gate API  APIv4 provides operations related to spot, margin, and contract trading, including public interfaces for querying market data and authenticated private interfaces for implementing API-based automated trading.  # noqa: E501

    Contact: support@mail.gate.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class UnifiedCollateralReq(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'collateral_type': 'int',
        'enable_list': 'list[str]',
        'disable_list': 'list[str]'
    }

    attribute_map = {
        'collateral_type': 'collateral_type',
        'enable_list': 'enable_list',
        'disable_list': 'disable_list'
    }

    def __init__(self, collateral_type=None, enable_list=None, disable_list=None, local_vars_configuration=None):  # noqa: E501
        # type: (int, list[str], list[str], Configuration) -> None
        """UnifiedCollateralReq - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._collateral_type = None
        self._enable_list = None
        self._disable_list = None
        self.discriminator = None

        if collateral_type is not None:
            self.collateral_type = collateral_type
        if enable_list is not None:
            self.enable_list = enable_list
        if disable_list is not None:
            self.disable_list = disable_list

    @property
    def collateral_type(self):
        """Gets the collateral_type of this UnifiedCollateralReq.  # noqa: E501

        User-set collateral mode0(all)-All currencies used as collateral, 1(custom)-Custom currencies used as collateral; when collateral_type is 0(all), the enable_list and disable_list parameters are invalid  # noqa: E501

        :return: The collateral_type of this UnifiedCollateralReq.  # noqa: E501
        :rtype: int
        """
        return self._collateral_type

    @collateral_type.setter
    def collateral_type(self, collateral_type):
        """Sets the collateral_type of this UnifiedCollateralReq.

        User-set collateral mode0(all)-All currencies used as collateral, 1(custom)-Custom currencies used as collateral; when collateral_type is 0(all), the enable_list and disable_list parameters are invalid  # noqa: E501

        :param collateral_type: The collateral_type of this UnifiedCollateralReq.  # noqa: E501
        :type: int
        """
        allowed_values = [0, 1]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and collateral_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `collateral_type` ({0}), must be one of {1}"  # noqa: E501
                .format(collateral_type, allowed_values)
            )

        self._collateral_type = collateral_type

    @property
    def enable_list(self):
        """Gets the enable_list of this UnifiedCollateralReq.  # noqa: E501

        Currency list, where collateral_type=1(custom) indicates the logic of addition  # noqa: E501

        :return: The enable_list of this UnifiedCollateralReq.  # noqa: E501
        :rtype: list[str]
        """
        return self._enable_list

    @enable_list.setter
    def enable_list(self, enable_list):
        """Sets the enable_list of this UnifiedCollateralReq.

        Currency list, where collateral_type=1(custom) indicates the logic of addition  # noqa: E501

        :param enable_list: The enable_list of this UnifiedCollateralReq.  # noqa: E501
        :type: list[str]
        """

        self._enable_list = enable_list

    @property
    def disable_list(self):
        """Gets the disable_list of this UnifiedCollateralReq.  # noqa: E501

        Cancellation list, indicating the logic of cancellation  # noqa: E501

        :return: The disable_list of this UnifiedCollateralReq.  # noqa: E501
        :rtype: list[str]
        """
        return self._disable_list

    @disable_list.setter
    def disable_list(self, disable_list):
        """Sets the disable_list of this UnifiedCollateralReq.

        Cancellation list, indicating the logic of cancellation  # noqa: E501

        :param disable_list: The disable_list of this UnifiedCollateralReq.  # noqa: E501
        :type: list[str]
        """

        self._disable_list = disable_list

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UnifiedCollateralReq):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UnifiedCollateralReq):
            return True

        return self.to_dict() != other.to_dict()
