# -*- coding: utf-8 -*-
"""
Created on Tue Sep 13 06:22:53 2022

@author: Antonio
"""

# ----------------------------------------------------------------------------------------------------------------------
#  Copyright (c) 2022-2023. Antonio Bulgheroni.
#  Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
#  documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
#  rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
#  permit persons to whom the Software is furnished to do so, subject to the following conditions:
#  The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
#  Software.
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
#  WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS
#  OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
#  OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
# ----------------------------------------------------------------------------------------------------------------------
import random

import pytest
from PyQt5 import QtCore

from autologbook.protocol_editor_models import UserRole


def test_userrole():

    # creation success
    for i in range(len(UserRole)):
        try:
            UserRole(QtCore.Qt.UserRole + 1 + i)
        except:
            # this should not happen!
            assert False

    # creation failures
    with pytest.raises(ValueError):
        UserRole(random.randint(0, QtCore.Qt.UserRole))

    # test minimum value
    for e in UserRole:
        assert e > QtCore.Qt.UserRole
