#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
---
module: active_directories_info
short_description: Information module for Active Directories Info
description:
- Get all Active Directories Info.
- Duo-IdentitySync - Get the list of all configured Active Directories.
version_added: '1.0.0'
extends_documentation_fragment:
  - cisco.ise.module_info
author: Rafael Campos (@racampos)
options: {}
requirements:
- ciscoisesdk >= 2.2.1
- python >= 3.5
notes:
  - SDK Method used are
    active_directories.ActiveDirectories.get_active_directories,

  - Paths used are
    get /api/v1/duo-identitysync/activedirectories,

"""

EXAMPLES = r"""
- name: Get all Active Directories Info
  cisco.ise.active_directories_info:
    ise_hostname: "{{ise_hostname}}"
    ise_username: "{{ise_username}}"
    ise_password: "{{ise_password}}"
    ise_verify: "{{ise_verify}}"
  register: result

"""

RETURN = r"""
ise_response:
  description: A dictionary or list with the response returned by the Cisco ISE Python SDK
  returned: always
  type: list
  elements: dict
  sample: >
    [
      {
        "directoryID": "string",
        "domain": "string",
        "name": "string"
      }
    ]
"""
