header_metadata_mappings_string = {
    "paper": {"to": "paper"},
    "accession number": {"to": "accession-number"},
    "conformed submission type": {"to": "type"},
    "public document count": {"to": "public-document-count"},
    "public-document_count": {"to": "public-document-count"},
    "conformed period of report": {"to": "period"},
    "filed as of date": {"to": "filing-date"},
    "date as of change": {"to": "date-of-filing-date-change"},
    "effectiveness date": {"to": "effectiveness-date"},
    "filer": {"to": "filer"},
    "company data": {"to": "company-data"},
    "company conformed name": {"to": "conformed-name"},
    "central index key": {"to": "cik"},
    "state of incorporation": {"to": "state-of-incorporation"},
    "fiscal year end": {"to": "fiscal-year-end"},
    "filing values": {"to": "filing-values"},
    "form type": {"to": "form-type"},
    "sec act": {"to": "act","regex":r"(?:\d{2})(\d{2})\s+Act"},
    "sec file number": {"to": "file-number"},
    "film number": {"to": "film-number"},
    "business address": {"to": "business-address"},
    "street 1": {"to": "street1"},
    "city": {"to": "city"},
    "state": {"to": "state"},
    "zip": {"to": "zip"},
    "business phone": {"to": "phone"},
    "mail address": {"to": "mail-address"},
    "former company": {"to": "former-company"},
    "former conformed name": {"to": "former-conformed-name"},
    "date of name change": {"to": "date-changed"},
    "sros": {"to": "sros"},
    "subject company": {"to": "subject-company"},
    "standard industrial classification": {"to": "assigned-sic","regex":r"\[(\d+)\]"},
    "irs number": {"to": "irs-number"},
    "filed by": {"to": "filed-by"},
    "street 2": {"to": "street2"},
    "items": {"to": "items"},
    "group members": {"to": "group-members"},
    "organization name": {"to": "organization-name"},
    "recieved date": {"to": "recieved-date"},
    "action date": {"to": "action-date"},
    "non us state territory": {"to": "non-us-state-territory"},
    "address is a non us location": {"to": "address-is-a-non-us-location"},
    "ein": {"to": "ein"},
    "class-contract-ticker-symbol": {"to": "class-contract-ticker-symbol"},
    "class-contract-name": {"to": "class-contract-name"},
    "class-contract-id": {"to": "class-contract-id"},
    "sec-document": {"to": "sec-document"},
    "sec-header": {"to": "sec-header"},
    "acceptance-datetime": {"to": "acceptance-datetime"},
    "series-and-classes-contracts-data": {"to": "series-and-classes-contracts-data"},
    "existing-series-and-classes-contracts": {"to": "existing-series-and-classes-contracts"},
    "merger-series-and-classes-contracts": {"to": "merger-series-and-classes-contracts"},
    "new-series-and-classes-contracts": {"to": "new-series-and-classes-contracts"},
    "series": {"to": "series"},
    "owner-cik": {"to": "owner-cik"},
    "series-id": {"to": "series-id"},
    "series-name": {"to": "series-name"},
    "acquiring-data": {"to": "acquiring-data"},
    "target-data": {"to": "target-data"},
    "new-classes-contracts": {"to": "new-classes-contracts"},
    "new-series": {"to": "new-series"},
    "relationship": {"to": "relationship"}
}


header_metadata_mappings_bytes = {
    key.encode(): {k.encode(): v.encode() if isinstance(v, str) else v for k, v in value.items()}
    for key, value in header_metadata_mappings_string.items()
}