# Generated by Django 5.2 on 2025-04-23 17:23

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AiUsage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('event_count', models.IntegerField(default=0, verbose_name='Events')),
                ('token_usage', models.IntegerField(default=0, verbose_name='Tokens')),
                ('run_time_seconds', models.FloatField(default=0.0, verbose_name='Run Time')),
                ('was_successful', models.BooleanField(default=True, verbose_name='Success')),
                ('recorded_date', models.DateField(default=django.utils.timezone.now)),
            ],
            options={
                'verbose_name': 'AI Usage',
                'verbose_name_plural': 'AI Usage',
                'db_table': 'django_spire_ai_usage',
            },
        ),
        migrations.CreateModel(
            name='AiInteraction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('event_count', models.IntegerField(default=0, verbose_name='Events')),
                ('token_usage', models.IntegerField(default=0, verbose_name='Tokens')),
                ('run_time_seconds', models.FloatField(default=0.0, verbose_name='Run Time')),
                ('was_successful', models.BooleanField(default=True, verbose_name='Success')),
                ('actor', models.CharField(max_length=100)),
                ('user_email', models.EmailField(blank=True, max_length=254, null=True)),
                ('user_first_name', models.CharField(blank=True, max_length=100, null=True)),
                ('user_last_name', models.CharField(blank=True, max_length=100, null=True)),
                ('module_name', models.TextField()),
                ('callable_name', models.TextField()),
                ('exception', models.TextField(blank=True, null=True)),
                ('stack_trace', models.TextField(blank=True, null=True)),
                ('created_datetime', models.DateTimeField(default=django.utils.timezone.now)),
                ('interaction', models.JSONField(blank=True, null=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='ai_interactions', related_query_name='ai_interaction', to=settings.AUTH_USER_MODEL)),
                ('ai_usage', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='interactions', related_query_name='interaction', to='django_spire_ai.aiusage')),
            ],
            options={
                'verbose_name': 'AI Interaction',
                'verbose_name_plural': 'AI Interactions',
                'db_table': 'django_spire_ai_interaction',
            },
        ),
    ]
