# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiIntegrationArgs', 'ApiIntegration']

@pulumi.input_type
class ApiIntegrationArgs:
    def __init__(__self__, *,
                 allow_configuration_access: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_write_access: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ignore_responders_from_payload: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner_team_id: Optional[pulumi.Input[builtins.str]] = None,
                 responders: Optional[pulumi.Input[Sequence[pulumi.Input['ApiIntegrationResponderArgs']]]] = None,
                 suppress_notifications: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 webhook_url: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ApiIntegration resource.
        :param pulumi.Input[builtins.bool] allow_write_access: This parameter is for configuring the write access of integration. If write access is restricted, the integration will not be authorized to write within any domain. Default: `true`.
        :param pulumi.Input[builtins.bool] enabled: This parameter is for specifying whether the integration will be enabled or not. Default: `true`
        :param pulumi.Input[builtins.bool] ignore_responders_from_payload: If enabled, the integration will ignore recipients sent in request payloads. Default: `false`.
        :param pulumi.Input[builtins.str] name: Name of the integration. Name must be unique for each integration.
        :param pulumi.Input[builtins.str] owner_team_id: Owner team id of the integration. If changed, this will recreate a new API integration, which will probably have a different API key.
        :param pulumi.Input[Sequence[pulumi.Input['ApiIntegrationResponderArgs']]] responders: User, schedule, teams or escalation names to calculate which users will receive the notifications of the alert.
        :param pulumi.Input[builtins.bool] suppress_notifications: If enabled, notifications that come from alerts will be suppressed. Default: `false`.
        :param pulumi.Input[builtins.str] type: Type of the integration (API, Marid, Prometheus, etc). The full list of options can be found [here](https://docs.opsgenie.com/docs/integration-types-to-use-with-api).
        :param pulumi.Input[builtins.str] webhook_url: It is required if type is `Webhook`. This is the url Opsgenie will be sending request to.
        """
        if allow_configuration_access is not None:
            pulumi.set(__self__, "allow_configuration_access", allow_configuration_access)
        if allow_write_access is not None:
            pulumi.set(__self__, "allow_write_access", allow_write_access)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if ignore_responders_from_payload is not None:
            pulumi.set(__self__, "ignore_responders_from_payload", ignore_responders_from_payload)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_team_id is not None:
            pulumi.set(__self__, "owner_team_id", owner_team_id)
        if responders is not None:
            pulumi.set(__self__, "responders", responders)
        if suppress_notifications is not None:
            pulumi.set(__self__, "suppress_notifications", suppress_notifications)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if webhook_url is not None:
            pulumi.set(__self__, "webhook_url", webhook_url)

    @property
    @pulumi.getter(name="allowConfigurationAccess")
    def allow_configuration_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "allow_configuration_access")

    @allow_configuration_access.setter
    def allow_configuration_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_configuration_access", value)

    @property
    @pulumi.getter(name="allowWriteAccess")
    def allow_write_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This parameter is for configuring the write access of integration. If write access is restricted, the integration will not be authorized to write within any domain. Default: `true`.
        """
        return pulumi.get(self, "allow_write_access")

    @allow_write_access.setter
    def allow_write_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_write_access", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This parameter is for specifying whether the integration will be enabled or not. Default: `true`
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="ignoreRespondersFromPayload")
    def ignore_responders_from_payload(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, the integration will ignore recipients sent in request payloads. Default: `false`.
        """
        return pulumi.get(self, "ignore_responders_from_payload")

    @ignore_responders_from_payload.setter
    def ignore_responders_from_payload(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore_responders_from_payload", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the integration. Name must be unique for each integration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownerTeamId")
    def owner_team_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Owner team id of the integration. If changed, this will recreate a new API integration, which will probably have a different API key.
        """
        return pulumi.get(self, "owner_team_id")

    @owner_team_id.setter
    def owner_team_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_team_id", value)

    @property
    @pulumi.getter
    def responders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiIntegrationResponderArgs']]]]:
        """
        User, schedule, teams or escalation names to calculate which users will receive the notifications of the alert.
        """
        return pulumi.get(self, "responders")

    @responders.setter
    def responders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiIntegrationResponderArgs']]]]):
        pulumi.set(self, "responders", value)

    @property
    @pulumi.getter(name="suppressNotifications")
    def suppress_notifications(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, notifications that come from alerts will be suppressed. Default: `false`.
        """
        return pulumi.get(self, "suppress_notifications")

    @suppress_notifications.setter
    def suppress_notifications(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "suppress_notifications", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the integration (API, Marid, Prometheus, etc). The full list of options can be found [here](https://docs.opsgenie.com/docs/integration-types-to-use-with-api).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        It is required if type is `Webhook`. This is the url Opsgenie will be sending request to.
        """
        return pulumi.get(self, "webhook_url")

    @webhook_url.setter
    def webhook_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "webhook_url", value)


@pulumi.input_type
class _ApiIntegrationState:
    def __init__(__self__, *,
                 allow_configuration_access: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_write_access: Optional[pulumi.Input[builtins.bool]] = None,
                 api_key: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ignore_responders_from_payload: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner_team_id: Optional[pulumi.Input[builtins.str]] = None,
                 responders: Optional[pulumi.Input[Sequence[pulumi.Input['ApiIntegrationResponderArgs']]]] = None,
                 suppress_notifications: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 webhook_url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApiIntegration resources.
        :param pulumi.Input[builtins.bool] allow_write_access: This parameter is for configuring the write access of integration. If write access is restricted, the integration will not be authorized to write within any domain. Default: `true`.
        :param pulumi.Input[builtins.str] api_key: (Computed) API key of the created integration
        :param pulumi.Input[builtins.bool] enabled: This parameter is for specifying whether the integration will be enabled or not. Default: `true`
        :param pulumi.Input[builtins.bool] ignore_responders_from_payload: If enabled, the integration will ignore recipients sent in request payloads. Default: `false`.
        :param pulumi.Input[builtins.str] name: Name of the integration. Name must be unique for each integration.
        :param pulumi.Input[builtins.str] owner_team_id: Owner team id of the integration. If changed, this will recreate a new API integration, which will probably have a different API key.
        :param pulumi.Input[Sequence[pulumi.Input['ApiIntegrationResponderArgs']]] responders: User, schedule, teams or escalation names to calculate which users will receive the notifications of the alert.
        :param pulumi.Input[builtins.bool] suppress_notifications: If enabled, notifications that come from alerts will be suppressed. Default: `false`.
        :param pulumi.Input[builtins.str] type: Type of the integration (API, Marid, Prometheus, etc). The full list of options can be found [here](https://docs.opsgenie.com/docs/integration-types-to-use-with-api).
        :param pulumi.Input[builtins.str] webhook_url: It is required if type is `Webhook`. This is the url Opsgenie will be sending request to.
        """
        if allow_configuration_access is not None:
            pulumi.set(__self__, "allow_configuration_access", allow_configuration_access)
        if allow_write_access is not None:
            pulumi.set(__self__, "allow_write_access", allow_write_access)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if ignore_responders_from_payload is not None:
            pulumi.set(__self__, "ignore_responders_from_payload", ignore_responders_from_payload)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_team_id is not None:
            pulumi.set(__self__, "owner_team_id", owner_team_id)
        if responders is not None:
            pulumi.set(__self__, "responders", responders)
        if suppress_notifications is not None:
            pulumi.set(__self__, "suppress_notifications", suppress_notifications)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if webhook_url is not None:
            pulumi.set(__self__, "webhook_url", webhook_url)

    @property
    @pulumi.getter(name="allowConfigurationAccess")
    def allow_configuration_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "allow_configuration_access")

    @allow_configuration_access.setter
    def allow_configuration_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_configuration_access", value)

    @property
    @pulumi.getter(name="allowWriteAccess")
    def allow_write_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This parameter is for configuring the write access of integration. If write access is restricted, the integration will not be authorized to write within any domain. Default: `true`.
        """
        return pulumi.get(self, "allow_write_access")

    @allow_write_access.setter
    def allow_write_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_write_access", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Computed) API key of the created integration
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This parameter is for specifying whether the integration will be enabled or not. Default: `true`
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="ignoreRespondersFromPayload")
    def ignore_responders_from_payload(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, the integration will ignore recipients sent in request payloads. Default: `false`.
        """
        return pulumi.get(self, "ignore_responders_from_payload")

    @ignore_responders_from_payload.setter
    def ignore_responders_from_payload(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore_responders_from_payload", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the integration. Name must be unique for each integration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownerTeamId")
    def owner_team_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Owner team id of the integration. If changed, this will recreate a new API integration, which will probably have a different API key.
        """
        return pulumi.get(self, "owner_team_id")

    @owner_team_id.setter
    def owner_team_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_team_id", value)

    @property
    @pulumi.getter
    def responders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiIntegrationResponderArgs']]]]:
        """
        User, schedule, teams or escalation names to calculate which users will receive the notifications of the alert.
        """
        return pulumi.get(self, "responders")

    @responders.setter
    def responders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiIntegrationResponderArgs']]]]):
        pulumi.set(self, "responders", value)

    @property
    @pulumi.getter(name="suppressNotifications")
    def suppress_notifications(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, notifications that come from alerts will be suppressed. Default: `false`.
        """
        return pulumi.get(self, "suppress_notifications")

    @suppress_notifications.setter
    def suppress_notifications(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "suppress_notifications", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the integration (API, Marid, Prometheus, etc). The full list of options can be found [here](https://docs.opsgenie.com/docs/integration-types-to-use-with-api).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        It is required if type is `Webhook`. This is the url Opsgenie will be sending request to.
        """
        return pulumi.get(self, "webhook_url")

    @webhook_url.setter
    def webhook_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "webhook_url", value)


@pulumi.type_token("opsgenie:index/apiIntegration:ApiIntegration")
class ApiIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_configuration_access: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_write_access: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ignore_responders_from_payload: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner_team_id: Optional[pulumi.Input[builtins.str]] = None,
                 responders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiIntegrationResponderArgs', 'ApiIntegrationResponderArgsDict']]]]] = None,
                 suppress_notifications: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 webhook_url: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an API Integration within Opsgenie.

        ## Import

        API Integrations can be imported using the `integration_id`, e.g.

        ```sh
        $ pulumi import opsgenie:index/apiIntegration:ApiIntegration this integration_id`
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_write_access: This parameter is for configuring the write access of integration. If write access is restricted, the integration will not be authorized to write within any domain. Default: `true`.
        :param pulumi.Input[builtins.bool] enabled: This parameter is for specifying whether the integration will be enabled or not. Default: `true`
        :param pulumi.Input[builtins.bool] ignore_responders_from_payload: If enabled, the integration will ignore recipients sent in request payloads. Default: `false`.
        :param pulumi.Input[builtins.str] name: Name of the integration. Name must be unique for each integration.
        :param pulumi.Input[builtins.str] owner_team_id: Owner team id of the integration. If changed, this will recreate a new API integration, which will probably have a different API key.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiIntegrationResponderArgs', 'ApiIntegrationResponderArgsDict']]]] responders: User, schedule, teams or escalation names to calculate which users will receive the notifications of the alert.
        :param pulumi.Input[builtins.bool] suppress_notifications: If enabled, notifications that come from alerts will be suppressed. Default: `false`.
        :param pulumi.Input[builtins.str] type: Type of the integration (API, Marid, Prometheus, etc). The full list of options can be found [here](https://docs.opsgenie.com/docs/integration-types-to-use-with-api).
        :param pulumi.Input[builtins.str] webhook_url: It is required if type is `Webhook`. This is the url Opsgenie will be sending request to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ApiIntegrationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an API Integration within Opsgenie.

        ## Import

        API Integrations can be imported using the `integration_id`, e.g.

        ```sh
        $ pulumi import opsgenie:index/apiIntegration:ApiIntegration this integration_id`
        ```

        :param str resource_name: The name of the resource.
        :param ApiIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_configuration_access: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_write_access: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ignore_responders_from_payload: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner_team_id: Optional[pulumi.Input[builtins.str]] = None,
                 responders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiIntegrationResponderArgs', 'ApiIntegrationResponderArgsDict']]]]] = None,
                 suppress_notifications: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 webhook_url: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiIntegrationArgs.__new__(ApiIntegrationArgs)

            __props__.__dict__["allow_configuration_access"] = allow_configuration_access
            __props__.__dict__["allow_write_access"] = allow_write_access
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["headers"] = headers
            __props__.__dict__["ignore_responders_from_payload"] = ignore_responders_from_payload
            __props__.__dict__["name"] = name
            __props__.__dict__["owner_team_id"] = owner_team_id
            __props__.__dict__["responders"] = responders
            __props__.__dict__["suppress_notifications"] = suppress_notifications
            __props__.__dict__["type"] = type
            __props__.__dict__["webhook_url"] = webhook_url
            __props__.__dict__["api_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ApiIntegration, __self__).__init__(
            'opsgenie:index/apiIntegration:ApiIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_configuration_access: Optional[pulumi.Input[builtins.bool]] = None,
            allow_write_access: Optional[pulumi.Input[builtins.bool]] = None,
            api_key: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            ignore_responders_from_payload: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            owner_team_id: Optional[pulumi.Input[builtins.str]] = None,
            responders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiIntegrationResponderArgs', 'ApiIntegrationResponderArgsDict']]]]] = None,
            suppress_notifications: Optional[pulumi.Input[builtins.bool]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            webhook_url: Optional[pulumi.Input[builtins.str]] = None) -> 'ApiIntegration':
        """
        Get an existing ApiIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_write_access: This parameter is for configuring the write access of integration. If write access is restricted, the integration will not be authorized to write within any domain. Default: `true`.
        :param pulumi.Input[builtins.str] api_key: (Computed) API key of the created integration
        :param pulumi.Input[builtins.bool] enabled: This parameter is for specifying whether the integration will be enabled or not. Default: `true`
        :param pulumi.Input[builtins.bool] ignore_responders_from_payload: If enabled, the integration will ignore recipients sent in request payloads. Default: `false`.
        :param pulumi.Input[builtins.str] name: Name of the integration. Name must be unique for each integration.
        :param pulumi.Input[builtins.str] owner_team_id: Owner team id of the integration. If changed, this will recreate a new API integration, which will probably have a different API key.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiIntegrationResponderArgs', 'ApiIntegrationResponderArgsDict']]]] responders: User, schedule, teams or escalation names to calculate which users will receive the notifications of the alert.
        :param pulumi.Input[builtins.bool] suppress_notifications: If enabled, notifications that come from alerts will be suppressed. Default: `false`.
        :param pulumi.Input[builtins.str] type: Type of the integration (API, Marid, Prometheus, etc). The full list of options can be found [here](https://docs.opsgenie.com/docs/integration-types-to-use-with-api).
        :param pulumi.Input[builtins.str] webhook_url: It is required if type is `Webhook`. This is the url Opsgenie will be sending request to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiIntegrationState.__new__(_ApiIntegrationState)

        __props__.__dict__["allow_configuration_access"] = allow_configuration_access
        __props__.__dict__["allow_write_access"] = allow_write_access
        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["headers"] = headers
        __props__.__dict__["ignore_responders_from_payload"] = ignore_responders_from_payload
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_team_id"] = owner_team_id
        __props__.__dict__["responders"] = responders
        __props__.__dict__["suppress_notifications"] = suppress_notifications
        __props__.__dict__["type"] = type
        __props__.__dict__["webhook_url"] = webhook_url
        return ApiIntegration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowConfigurationAccess")
    def allow_configuration_access(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "allow_configuration_access")

    @property
    @pulumi.getter(name="allowWriteAccess")
    def allow_write_access(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This parameter is for configuring the write access of integration. If write access is restricted, the integration will not be authorized to write within any domain. Default: `true`.
        """
        return pulumi.get(self, "allow_write_access")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[builtins.str]:
        """
        (Computed) API key of the created integration
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This parameter is for specifying whether the integration will be enabled or not. Default: `true`
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="ignoreRespondersFromPayload")
    def ignore_responders_from_payload(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If enabled, the integration will ignore recipients sent in request payloads. Default: `false`.
        """
        return pulumi.get(self, "ignore_responders_from_payload")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the integration. Name must be unique for each integration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerTeamId")
    def owner_team_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Owner team id of the integration. If changed, this will recreate a new API integration, which will probably have a different API key.
        """
        return pulumi.get(self, "owner_team_id")

    @property
    @pulumi.getter
    def responders(self) -> pulumi.Output[Optional[Sequence['outputs.ApiIntegrationResponder']]]:
        """
        User, schedule, teams or escalation names to calculate which users will receive the notifications of the alert.
        """
        return pulumi.get(self, "responders")

    @property
    @pulumi.getter(name="suppressNotifications")
    def suppress_notifications(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If enabled, notifications that come from alerts will be suppressed. Default: `false`.
        """
        return pulumi.get(self, "suppress_notifications")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Type of the integration (API, Marid, Prometheus, etc). The full list of options can be found [here](https://docs.opsgenie.com/docs/integration-types-to-use-with-api).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        It is required if type is `Webhook`. This is the url Opsgenie will be sending request to.
        """
        return pulumi.get(self, "webhook_url")

