# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetScheduleResult',
    'AwaitableGetScheduleResult',
    'get_schedule',
    'get_schedule_output',
]

@pulumi.output_type
class GetScheduleResult:
    """
    A collection of values returned by getSchedule.
    """
    def __init__(__self__, description=None, enabled=None, id=None, name=None, owner_team_id=None, timezone=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner_team_id and not isinstance(owner_team_id, str):
            raise TypeError("Expected argument 'owner_team_id' to be a str")
        pulumi.set(__self__, "owner_team_id", owner_team_id)
        if timezone and not isinstance(timezone, str):
            raise TypeError("Expected argument 'timezone' to be a str")
        pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Timezone of schedule. Please look at [Supported Timezone Ids](https://docs.opsgenie.com/docs/supported-timezone-ids) for available timezones - Default: `America/New_York`.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enable/disable state of schedule
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerTeamId")
    def owner_team_id(self) -> Optional[builtins.str]:
        """
        Owner team id of the schedule.
        """
        return pulumi.get(self, "owner_team_id")

    @property
    @pulumi.getter
    def timezone(self) -> Optional[builtins.str]:
        """
        The description of schedule.
        """
        return pulumi.get(self, "timezone")


class AwaitableGetScheduleResult(GetScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduleResult(
            description=self.description,
            enabled=self.enabled,
            id=self.id,
            name=self.name,
            owner_team_id=self.owner_team_id,
            timezone=self.timezone)


def get_schedule(description: Optional[builtins.str] = None,
                 enabled: Optional[builtins.bool] = None,
                 name: Optional[builtins.str] = None,
                 owner_team_id: Optional[builtins.str] = None,
                 timezone: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduleResult:
    """
    Manages a Schedule within Opsgenie.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_opsgenie as opsgenie

    test = opsgenie.get_schedule(name="sre-team schedule")
    ```


    :param builtins.str description: Timezone of schedule. Please look at [Supported Timezone Ids](https://docs.opsgenie.com/docs/supported-timezone-ids) for available timezones - Default: `America/New_York`.
    :param builtins.bool enabled: Enable/disable state of schedule
    :param builtins.str name: Name of the schedule.
    :param builtins.str owner_team_id: Owner team id of the schedule.
    :param builtins.str timezone: The description of schedule.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['enabled'] = enabled
    __args__['name'] = name
    __args__['ownerTeamId'] = owner_team_id
    __args__['timezone'] = timezone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('opsgenie:index/getSchedule:getSchedule', __args__, opts=opts, typ=GetScheduleResult).value

    return AwaitableGetScheduleResult(
        description=pulumi.get(__ret__, 'description'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        owner_team_id=pulumi.get(__ret__, 'owner_team_id'),
        timezone=pulumi.get(__ret__, 'timezone'))
def get_schedule_output(description: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        enabled: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                        name: Optional[pulumi.Input[builtins.str]] = None,
                        owner_team_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        timezone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScheduleResult]:
    """
    Manages a Schedule within Opsgenie.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_opsgenie as opsgenie

    test = opsgenie.get_schedule(name="sre-team schedule")
    ```


    :param builtins.str description: Timezone of schedule. Please look at [Supported Timezone Ids](https://docs.opsgenie.com/docs/supported-timezone-ids) for available timezones - Default: `America/New_York`.
    :param builtins.bool enabled: Enable/disable state of schedule
    :param builtins.str name: Name of the schedule.
    :param builtins.str owner_team_id: Owner team id of the schedule.
    :param builtins.str timezone: The description of schedule.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['enabled'] = enabled
    __args__['name'] = name
    __args__['ownerTeamId'] = owner_team_id
    __args__['timezone'] = timezone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('opsgenie:index/getSchedule:getSchedule', __args__, opts=opts, typ=GetScheduleResult)
    return __ret__.apply(lambda __response__: GetScheduleResult(
        description=pulumi.get(__response__, 'description'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        owner_team_id=pulumi.get(__response__, 'owner_team_id'),
        timezone=pulumi.get(__response__, 'timezone')))
