# generated by datamodel-codegen:
#   filename:  openapi.yml
#   timestamp: 2025-08-04T13:02:46+00:00

from __future__ import annotations

from dataclasses import dataclass
from enum import Enum
from typing import List, Optional, Union


class TestElementStatus(Enum):
    InProgress = 'InProgress'
    Released = 'Released'


class ContentType(Enum):
    txt = 'txt'
    xml = 'xml'


@dataclass
class AdvancedContent:
    contentType: Optional[ContentType] = None
    contentExtID: Optional[str] = None
    content: Optional[str] = None


@dataclass
class OptionalAdvancedContent:
    optional: Optional[AdvancedContent] = None


@dataclass
class OptionalUser:
    optional: Optional[str] = None


class ProjectStatus(Enum):
    Planned = 'Planned'
    Active = 'Active'
    Finished = 'Finished'
    Closed = 'Closed'


class DefectMetricType(Enum):
    Status = 'Status'
    Priority = 'Priority'
    Classification = 'Classification'


class ProjectTreeNodeType(Enum):
    Project = 'Project'
    Version = 'Version'
    Cycle = 'Cycle'


class Severity(Enum):
    Information = 'Information'
    Warning = 'Warning'
    Error = 'Error'


class UDFType(Enum):
    String = 'String'
    Enumeration = 'Enumeration'
    Boolean = 'Boolean'


class TestLabelVisibilityType(Enum):
    OnlyPrivate = 'OnlyPrivate'
    OnlyPublic = 'OnlyPublic'
    All = 'All'


class AutStatus(Enum):
    NotPlanned = 'NotPlanned'
    Planned = 'Planned'
    InProgress = 'InProgress'
    InReview = 'InReview'
    Released = 'Released'


class SpecStatus(Enum):
    NotPlanned = 'NotPlanned'
    Planned = 'Planned'
    InProgress = 'InProgress'
    InReview = 'InReview'
    Released = 'Released'


class Priority(Enum):
    Undefined = 'Undefined'
    Low = 'Low'
    Middle = 'Middle'
    High = 'High'


class ActivityStatus(Enum):
    NotPlanned = 'NotPlanned'
    Planned = 'Planned'
    Assigned = 'Assigned'
    Running = 'Running'
    Skipped = 'Skipped'
    Canceled = 'Canceled'
    Performed = 'Performed'


class ExecStatus(Enum):
    NotBlocked = 'NotBlocked'
    Blocked = 'Blocked'


class VerdictStatus(Enum):
    Undefined = 'Undefined'
    ToVerify = 'ToVerify'
    Fail = 'Fail'
    Pass = 'Pass'


class InteractionVerdict(Enum):
    Pass = 'Pass'
    Fail = 'Fail'
    Skipped = 'Skipped'
    ToVerify = 'ToVerify'
    Warn = 'Warn'
    Undefined = 'Undefined'
    Blocked = 'Blocked'


class SequencePhase(Enum):
    Setup = 'Setup'
    TestStep = 'TestStep'
    Teardown = 'Teardown'


class InteractionCallType(Enum):
    Check = 'Check'
    Flow = 'Flow'


class InteractionType(Enum):
    Atomic = 'Atomic'
    Compound = 'Compound'
    Textual = 'Textual'


class OperationalState(Enum):
    Enabled = 'Enabled'
    Disabled = 'Disabled'


class GlobalHumanRole(Enum):
    Administrator = 'Administrator'
    ProjectAdministrator = 'ProjectAdministrator'
    ProjectUser = 'ProjectUser'


class ProjectRole(Enum):
    TestManager = 'TestManager'
    TestDesigner = 'TestDesigner'
    TestProgrammer = 'TestProgrammer'
    Tester = 'Tester'
    ReadOnlyDesigner = 'ReadOnlyDesigner'
    ReadOnlyImplementer = 'ReadOnlyImplementer'
    ReadOnlyTester = 'ReadOnlyTester'


class TOVExchangeFormat(Enum):
    xml = 'xml'
    json = 'json'
    inherited = 'inherited'


class ImportResult(Enum):
    Imported = 'Imported'
    PartiallyImported = 'PartiallyImported'
    NotImported = 'NotImported'


class ExecutionMode(Enum):
    execute = 'execute'
    continue_ = 'continue'
    view = 'view'
    simulate = 'simulate'


@dataclass
class UserGlobalRoles:
    roles: List[GlobalHumanRole]


@dataclass
class UserProjectRoles:
    userKey: str
    roles: List[ProjectRole]


@dataclass
class ProjectUser:
    key: str
    name: str
    login: str
    projectRoles: List[ProjectRole]


@dataclass
class LicenseWarning:
    expiresSoon: bool
    baseCountExceeded: bool
    gracedForeignLicense: bool


@dataclass
class LoginData:
    login: str
    password: str
    force: Optional[bool] = None
    context: Optional[str] = None


@dataclass
class ChangePasswordData:
    login: str
    password: str
    newPassword: str


@dataclass
class LoginSession:
    userKey: str
    login: str
    sessionToken: str
    globalRoles: List[str]
    internalUserManagement: bool
    serverVersion: str
    licenseWarning: Optional[LicenseWarning] = None


@dataclass
class TestLabel:
    key: str
    name: str
    ownerKey: str
    visibility: bool
    libraryKey: Optional[str] = None


@dataclass
class TestLabelDataForUpdate:
    name: Optional[str] = None
    visibility: Optional[bool] = None


@dataclass
class TestLabelDataForInsert:
    name: str
    adaptName: Optional[bool] = True


@dataclass
class ProjectMember:
    userKey: str
    userLogin: str
    userName: str
    projectKey: str
    projectName: str
    roles: List[ProjectRole]


@dataclass
class ProjectSummary:
    key: str
    creationTime: str
    name: str
    status: ProjectStatus
    visibility: bool
    tovsCount: int
    cyclesCount: int
    description: str
    lockerKey: Optional[str] = None
    startDate: Optional[str] = None
    endDate: Optional[str] = None


@dataclass
class ProjectContext:
    tovName: str
    cycleName: Optional[str] = None
    executionMode: Optional[ExecutionMode] = None


@dataclass
class ProjectDetails:
    key: str
    creationTime: str
    name: str
    status: ProjectStatus
    visibility: bool
    tovsCount: int
    cyclesCount: int
    description: str
    lockerKey: Optional[str] = None
    startDate: Optional[str] = None
    endDate: Optional[str] = None
    projectContext: Optional[ProjectContext] = None


@dataclass
class ProjectInspection:
    inspectionKey: str
    severity: Severity


@dataclass
class ProjectCustomer:
    customerName: str
    customerAddress: str
    testLab: str
    placeOfInspection: str
    contactPerson: str


@dataclass
class ProjectCreation:
    pass


@dataclass
class UnknownProject(ProjectCreation):
    pass


@dataclass
class NewProject(ProjectCreation):
    pass


@dataclass
class ProjectImported(ProjectCreation):
    project: str


@dataclass
class TOVCreation:
    pass


@dataclass
class UnknownTOV(TOVCreation):
    pass


@dataclass
class NewTOV(TOVCreation):
    pass


@dataclass
class TOVCloned(TOVCreation):
    tov: str
    tovKey: Optional[str] = None


@dataclass
class TOVClonedFromSameProject(TOVCreation):
    tov: str
    tovKey: Optional[str] = None


@dataclass
class TOVClonedFromDifferentProject(TOVCreation):
    project: str
    tov: str
    tovKey: Optional[str] = None


@dataclass
class TOVImportedAsNew(TOVCreation):
    project: str
    tov: str


@dataclass
class TOVImportedAsClone(TOVCreation):
    project: str
    tov: str
    tovCloned: str


@dataclass
class TOVImportedAsNewFromPlugin(TOVCreation):
    plugin: str
    tov: str


@dataclass
class TOVImportedAsCloneFromPlugin(TOVCreation):
    plugin: str
    tov: str
    tovCloned: str


@dataclass
class TOVImported(TOVCreation):
    project: str
    tov: str


@dataclass
class TOVDerivedFromSameProject(TOVCreation):
    baseTOV: str
    variantsDefinition: str
    baseTOVKey: Optional[str] = None
    variantsDefinitionKey: Optional[str] = None


@dataclass
class TOVDerivedFromDifferentProject(TOVCreation):
    project: str
    baseTOV: str
    variantsDefinition: str
    baseTOVKey: Optional[str] = None
    variantsDefinitionKey: Optional[str] = None


@dataclass
class ProjectDetailsResponse:
    projectKey: str
    name: str
    inspection: List[ProjectInspection]
    testObjectName: str
    id: str
    customer: ProjectCustomer
    status: ProjectStatus
    visible: bool
    testIntelligence: bool
    description: str
    creation: ProjectCreation
    instantOfCreation: str
    onlyAdminsMayManageUDFs: bool
    variantsManagementEnabled: str
    startDate: Optional[str] = None
    endDate: Optional[str] = None


@dataclass
class TOVSummary:
    key: str
    creationTime: str
    name: str
    status: ProjectStatus
    visibility: bool
    cyclesCount: int
    description: str
    exchangeFormat: TOVExchangeFormat
    lockerKey: Optional[str] = None
    startDate: Optional[str] = None
    endDate: Optional[str] = None


@dataclass
class TOVDetails:
    key: str
    creationTime: str
    name: str
    status: ProjectStatus
    visibility: bool
    cyclesCount: int
    description: str
    exchangeFormat: TOVExchangeFormat
    lockerKey: Optional[str] = None
    startDate: Optional[str] = None
    endDate: Optional[str] = None


@dataclass
class TOVResponse:
    name: str
    visible: bool
    projectKey: str
    description: str
    isBaseTov: bool
    creation: TOVCreation
    key: str
    status: ProjectStatus
    testingIntelligence: bool
    instantOfCreation: str
    cloningVisibility: bool
    endDate: Optional[str] = None
    startDate: Optional[str] = None


@dataclass
class OptionalLocalDateTime:
    optional: Optional[str] = None


@dataclass
class CycleSummary:
    key: str
    creationTime: str
    name: str
    status: ProjectStatus
    visibility: bool
    description: str
    startDate: Optional[str] = None
    endDate: Optional[str] = None


@dataclass
class CycleDetails:
    key: str
    creationTime: str
    name: str
    status: ProjectStatus
    visibility: bool
    description: str
    startDate: Optional[str] = None
    endDate: Optional[str] = None


@dataclass
class CycleNode:
    nodeType: ProjectTreeNodeType
    key: str
    name: str
    creationTime: str
    status: ProjectStatus
    visibility: bool


@dataclass
class UserDetails:
    key: str
    login: str
    name: str
    email: str
    passwordExpired: bool
    active: bool


@dataclass
class UserDataForInsert:
    login: str
    password: str
    name: str
    email: str


@dataclass
class UserDataForUpdate:
    login: Optional[str] = None
    name: Optional[str] = None
    email: Optional[str] = None
    passwordExpired: Optional[bool] = None
    active: Optional[bool] = None


@dataclass
class UserSummary:
    key: str
    login: str
    name: str
    active: bool


@dataclass
class TestBenchVersions:
    releaseVersion: str
    databaseVersion: str
    revision: str


@dataclass
class ServerLocations:
    jBossHost: str
    jBossJNDIPort: int
    legacyPlayHost: str
    legacyPlayPort: int


@dataclass
class ActionFailure:
    code: int
    message: str
    description: Optional[str] = None


@dataclass
class UserDefinedField:
    key: str
    name: str
    value: str
    udfType: UDFType


@dataclass
class UDFEnumerationValue:
    valueKey: str
    valueName: str


@dataclass
class Keyword:
    key: str
    name: str
    isVariantsMarker: bool


@dataclass
class UserReference:
    key: str
    name: str


@dataclass
class RequirementAssignment:
    key: str
    name: str
    id: str
    extendedId: str
    version: str
    owner: str
    status: str
    priority: str
    repositoryId: str


@dataclass
class RequirementReference:
    key: str
    edited: bool


@dataclass
class MetricsDistribution:
    name: str
    count: int
    percentage: int


@dataclass
class DefectsDistribution:
    statusDistribution: Optional[List[MetricsDistribution]] = None
    priorityDistribution: Optional[List[MetricsDistribution]] = None
    classDistribution: Optional[List[MetricsDistribution]] = None


@dataclass
class ConditionSummary:
    key: str
    uniqueID: str
    name: str
    description: str
    version: Optional[str] = None


@dataclass
class SpecificationSummary:
    key: str
    description: str
    reviewComment: str
    status: SpecStatus
    priority: Priority
    locker: Optional[UserReference] = None
    responsible: Optional[UserReference] = None
    dueDate: Optional[str] = None
    reviewer: Optional[UserReference] = None


@dataclass
class TestCaseSetSpecificationSummary:
    key: str
    description: str
    reviewComment: str
    status: SpecStatus
    priority: Priority
    preConditions: List[ConditionSummary]
    postConditions: List[ConditionSummary]
    udfs: List[UserDefinedField]
    keywords: List[Keyword]
    references: List[str]
    requirements: List[RequirementReference]
    responsible: Optional[UserReference] = None
    dueDate: Optional[str] = None
    reviewer: Optional[UserReference] = None


@dataclass
class TestCaseSpecificationDetails:
    key: str
    comments: str
    udfs: List[UserDefinedField]
    keywords: List[Keyword]
    requirements: List[RequirementReference]
    version: Optional[str] = None


@dataclass
class TestThemeSpecification:
    key: str
    description: str
    reviewComment: str
    status: SpecStatus
    priority: Priority
    udfs: List[UserDefinedField]
    keywords: List[Keyword]
    requirements: List[RequirementReference]
    references: List[str]
    dueDate: Optional[str] = None
    reviewer: Optional[UserReference] = None
    responsible: Optional[UserReference] = None


@dataclass
class TestCaseSetExecutionSummary:
    key: str
    comments: str
    udfs: List[UserDefinedField]
    keywords: List[Keyword]


@dataclass
class TestCaseSpecificationSummary:
    key: str
    comments: str
    requirements: List[RequirementReference]


@dataclass
class TestCaseExecutionSummary:
    key: str
    status: ActivityStatus
    execStatus: ExecStatus
    verdict: VerdictStatus
    defects: List[str]
    comments: str
    tester: Optional[UserReference] = None


@dataclass
class TestCaseSummary:
    uniqueID: str
    index: int
    spec: TestCaseSpecificationSummary
    exec: Optional[TestCaseExecutionSummary] = None


@dataclass
class TestCaseExecutionDetails:
    key: str
    status: ActivityStatus
    execStatus: ExecStatus
    verdict: VerdictStatus
    plannedDuration: int
    actualDuration: int
    currentUser: UserReference
    comments: str
    defects: List[str]
    udfs: List[UserDefinedField]
    keywords: List[Keyword]
    references: List[str]
    version: Optional[str] = None
    tester: Optional[UserReference] = None


@dataclass
class TestCaseSetDetails:
    key: str
    numbering: str
    uniqueID: str
    name: str
    spec: TestCaseSetSpecificationSummary
    testCases: List[TestCaseSummary]
    exec: Optional[TestCaseSetExecutionSummary] = None


class KindOfDataType(Enum):
    Regular = 'Regular'
    Reference = 'Reference'
    Global = 'Global'
    AcceptingGlobal = 'AcceptingGlobal'


@dataclass
class DataTypeSummary:
    key: str
    kind: KindOfDataType
    name: str
    path: str
    uniqueID: str
    version: Optional[str] = None


class ParameterDefinitionType(Enum):
    DetailedInstance = 'DetailedInstance'
    InstanceTable = 'InstanceTable'
    AtomicInstance = 'AtomicInstance'


class ParameterEvaluationType(Enum):
    CallByReference = 'CallByReference'
    CallByValue = 'CallByValue'
    CallByReferenceMandatory = 'CallByReferenceMandatory'


class RepresentativeType(Enum):
    Text = 'Text'
    Placeholder = 'Placeholder'
    Attachment = 'Attachment'
    Hyperlink = 'Hyperlink'
    Reference = 'Reference'


class ArgumentValueType(Enum):
    EquivalenceClass = 'EquivalenceClass'
    Representative = 'Representative'
    InstancesArray = 'InstancesArray'
    CBRRepresentative = 'CBRRepresentative'


class TestCaseDetailsOrigin(Enum):
    Fallback = 'Fallback'
    Generated = 'Generated'
    Rejected = 'Rejected'
    Restored = 'Restored'
    Upgraded = 'Upgraded'


class ReferenceKind(Enum):
    Reference = 'Reference'
    Link = 'Link'
    Attachment = 'Attachment'
    Hyperlink = 'Hyperlink'


class TestFilterType(Enum):
    TestTheme = 'TestTheme'
    TestCaseSet = 'TestCaseSet'
    TestCase = 'TestCase'


@dataclass
class FilterInfo:
    name: str
    filterType: TestFilterType
    testThemeUID: Optional[str] = None


@dataclass
class TovStructureOptions:
    treeRootUID: Optional[str] = None
    suppressFilteredData: Optional[bool] = None
    suppressEmptyTestThemes: Optional[bool] = None
    filters: Optional[List[FilterInfo]] = None


@dataclass
class CycleStructureOptions:
    treeRootUID: Optional[str] = None
    basedOnExecution: Optional[bool] = None
    suppressFilteredData: Optional[bool] = None
    suppressNotExecutable: Optional[bool] = None
    suppressEmptyTestThemes: Optional[bool] = None
    filters: Optional[List[FilterInfo]] = None


@dataclass
class CycleReportOptions:
    treeRootUID: Optional[str] = None
    executionMode: Optional[ExecutionMode] = None
    suppressFilteredData: Optional[bool] = None
    suppressNotExecutable: Optional[bool] = None
    suppressEmptyTestThemes: Optional[bool] = None
    filters: Optional[List[FilterInfo]] = None


@dataclass
class DefectAttribute:
    name: str
    value: str


@dataclass
class ProjectDefectField:
    values: List[str]
    defaultValue: Optional[str] = None


@dataclass
class DefectUDF:
    name: str
    udfType: UDFType
    isMandatory: bool
    values: Optional[List[str]] = None


@dataclass
class TestStructureExecution:
    status: ActivityStatus
    execStatus: ExecStatus
    verdict: VerdictStatus


@dataclass
class TestStructureItemExecution(TestStructureExecution):
    key: str
    locker: Optional[UserReference] = None


@dataclass
class TestCaseExecution(TestStructureExecution):
    key: str


@dataclass
class TestStructureSpecification:
    pass


@dataclass
class TestStructureItemSpecification(TestStructureSpecification):
    key: str
    status: SpecStatus
    locker: Optional[UserReference] = None


@dataclass
class TestCaseSpecification(TestStructureSpecification):
    key: str


@dataclass
class TestStructureItemBaseInformation:
    key: str
    numbering: str
    parentKey: str
    name: str
    uniqueID: str
    matchesFilter: bool


@dataclass
class TestCaseBaseInformation:
    numbering: str
    parentKey: str
    name: str
    uniqueID: str
    matchesFilter: bool


@dataclass
class TestStructureAutomation:
    key: str
    status: AutStatus
    locker: Optional[UserReference] = None


class TestStructureElementType(Enum):
    RootNode = 'RootNode'
    TestThemeNode = 'TestThemeNode'
    TestCaseSetNode = 'TestCaseSetNode'
    TestCaseNode = 'TestCaseNode'


@dataclass
class AttachedFilter:
    key: str
    name: str
    filterType: TestFilterType
    content: str


@dataclass
class CreatedJob:
    jobID: str


@dataclass
class JobProgress:
    totalItemsCount: int
    handledItemsCount: int


@dataclass
class ReportingResult:
    pass


@dataclass
class ReportingFailure(ReportingResult):
    error: ActionFailure


@dataclass
class ReportingSuccess(ReportingResult):
    reportName: str


@dataclass
class ExecutionImportingResult:
    pass


@dataclass
class ExecutionImportingFailure(ExecutionImportingResult):
    error: ActionFailure


@dataclass
class TestCaseExecutionImportResult:
    key: str
    executionKey: str
    uid: str
    importResult: ImportResult
    warnings: List[ActionFailure]
    error: Optional[ActionFailure] = None


@dataclass
class ExecutionImportOptions:
    fileName: str
    treeRootUID: Optional[str] = None
    useExistingDefect: Optional[bool] = None
    discardTesterInformation: Optional[bool] = None
    defaultTester: Optional[str] = None
    filters: Optional[List[FilterInfo]] = None


@dataclass
class UploadedFile:
    fileName: str


@dataclass
class TestThemeExecution:
    key: str
    status: ActivityStatus
    execStatus: ExecStatus
    verdict: VerdictStatus
    udfs: List[UserDefinedField]
    keywords: List[Keyword]
    references: List[str]
    comments: Optional[str] = None
    responsible: Optional[UserReference] = None


@dataclass
class TestThemeDetails:
    key: str
    name: str
    uniqueID: str
    numbering: str
    spec: TestThemeSpecification
    exec: Optional[TestThemeExecution] = None


@dataclass
class TestObjectVersionCSVReportOptions:
    reportRootUID: Optional[str] = None
    fields: Optional[List[str]] = None
    characterEncoding: Optional[str] = None


@dataclass
class TestCycleCSVReportOptions:
    reportRootUID: Optional[str] = None
    fields: Optional[List[str]] = None
    characterEncoding: Optional[str] = None
    basedOn: Optional[str] = None


class UDFLocation(Enum):
    TestThemesInSpecification = 'TestThemesInSpecification'
    TestCaseSetsInSpecification = 'TestCaseSetsInSpecification'
    TestCasesInSpecification = 'TestCasesInSpecification'
    TestThemesInExecution = 'TestThemesInExecution'
    TestCaseSetsInExecution = 'TestCaseSetsInExecution'
    TestCasesInExecution = 'TestCasesInExecution'


class UDFAbsolutePosition(Enum):
    First = 'First'
    Last = 'Last'


@dataclass
class AfterUDF:
    udfKey: str


@dataclass
class BeforeUDF:
    udfKey: str


@dataclass
class UDFForUpdate:
    name: Optional[str] = None
    isMandatory: Optional[bool] = None
    definedFor: Optional[List[UDFLocation]] = None
    udfType: Optional[UDFType] = None
    enumerationValues: Optional[List[UDFEnumerationValue]] = None


@dataclass
class UDFsMoveResponse:
    targetKeys: List[str]


@dataclass
class TestFilter:
    key: str
    name: str
    owner: str
    pluginName: Optional[str] = None


@dataclass
class UDFUpdatedResponse:
    pass


@dataclass
class UDFForRestriction:
    onlyAdminsMayManageUDFs: bool


@dataclass
class UDFRestrictionResponse:
    projectKey: str
    onlyAdminsMayManageUDFs: bool


@dataclass
class CycleCreation:
    pass


@dataclass
class CycleCloned(CycleCreation):
    cycle: str


@dataclass
class CycleImported(CycleCreation):
    project: str
    tov: str
    cycle: str


@dataclass
class CycleImportedAsNew(CycleCreation):
    tov: str
    cycle: str


@dataclass
class CycleImportedAsClone(CycleCreation):
    tov: str
    cycle: str
    clonedCycle: str


@dataclass
class CycleImportedAsNewFromPlugin(CycleCreation):
    plugin: str
    tov: str
    cycle: str


@dataclass
class CycleClonedFromPlugin(CycleCreation):
    plugin: str
    cycle: str


@dataclass
class CycleImportedAsCloneFromPlugin(CycleCreation):
    plugin: str
    tov: str
    cycle: str
    clonedCycle: str


@dataclass
class UnknownCycle(CycleCreation):
    pass


@dataclass
class NewCycle(CycleCreation):
    pass


@dataclass
class NewPassword:
    newPassword: str


@dataclass
class ImageDetails:
    key: str
    suffix: str
    imageData: str


@dataclass
class UdfValueForImport:
    udfKey: str
    value: str


@dataclass
class RichTextForImport:
    html: Optional[str] = None
    plain: Optional[str] = None


@dataclass
class ExecutionResultForImport:
    status: ActivityStatus
    execStatus: ExecStatus
    verdict: VerdictStatus
    timestamp: Optional[str] = None


@dataclass
class TestCaseExecutionForImport:
    uniqueID: str
    testCaseExecutionKey: str
    result: ExecutionResultForImport
    durationMillis: int
    testerKey: Optional[str] = None
    comments: Optional[RichTextForImport] = None
    defects: Optional[List[str]] = None
    udfs: Optional[List[UdfValueForImport]] = None


@dataclass
class TestCaseSetExecutionForImport:
    testCaseSetKey: str
    executionKey: str
    durationMillis: int
    testCases: List[TestCaseExecutionForImport]
    testerKey: Optional[str] = None
    comments: Optional[RichTextForImport] = None
    udfs: Optional[List[UdfValueForImport]] = None


@dataclass
class InteractionCallExecution:
    verdict: InteractionVerdict
    duration: int
    currentUser: UserReference
    comments: str
    references: List[str]
    defects: List[str]
    time: Optional[str] = None
    tester: Optional[UserReference] = None


@dataclass
class DefaultValue:
    name: str
    valueType: ArgumentValueType


@dataclass
class ParameterDetails:
    key: str
    name: str
    definitionType: ParameterDefinitionType
    evaluationType: ParameterEvaluationType
    dataTypeKey: Optional[str] = None
    defaultValue: Optional[DefaultValue] = None
    signatureID: Optional[str] = None


@dataclass
class TOVNode:
    nodeType: ProjectTreeNodeType
    key: str
    name: str
    creationTime: str
    status: ProjectStatus
    visibility: bool
    children: List[CycleNode]


@dataclass
class UDF:
    udfKey: str
    name: str
    projectKey: str
    isMandatory: bool
    definedFor: List[UDFLocation]


@dataclass
class BooleanUDF(UDF):
    pass


@dataclass
class EnumerationUDF(UDF):
    enumerationValues: List[UDFEnumerationValue]


@dataclass
class StringUDF(UDF):
    pass


@dataclass
class ReferenceAssignment:
    key: str
    value: str
    referenceType: ReferenceKind
    versionName: Optional[str] = None


@dataclass
class ParameterSummary:
    definitionType: ParameterDefinitionType
    key: str
    name: str
    evaluationType: ParameterEvaluationType
    valueType: RepresentativeType
    dataType: Optional[DataTypeSummary] = None
    value: Optional[str] = None


@dataclass
class AssignedDefect:
    key: str
    title: str
    id: str
    description: str
    identicalVersionKey: str
    status: str
    priority: str
    classification: str
    creationTime: str
    references: List[str]
    udfs: List[DefectAttribute]
    version: Optional[str] = None
    tester: Optional[str] = None
    lastEditTime: Optional[str] = None
    lastEditorKey: Optional[str] = None
    defectManagementSystem: Optional[str] = None
    defectManagementProject: Optional[str] = None


@dataclass
class ExternalDefectManagement:
    system: str
    project: str
    udfs: List[DefectUDF]


@dataclass
class DefectConfig:
    status: ProjectDefectField
    classification: ProjectDefectField
    priority: ProjectDefectField
    external: Optional[ExternalDefectManagement] = None


@dataclass
class TestStructureTreeNode:
    elementType: TestStructureElementType


@dataclass
class RootNode(TestStructureTreeNode):
    base: TestStructureItemBaseInformation
    filters: List[AttachedFilter]


@dataclass
class TestThemeNode(TestStructureTreeNode):
    base: TestStructureItemBaseInformation
    filters: List[AttachedFilter]
    spec: Optional[TestStructureItemSpecification] = None
    aut: Optional[TestStructureAutomation] = None
    exec: Optional[TestStructureItemExecution] = None


@dataclass
class TestCaseSetNode(TestStructureTreeNode):
    base: TestStructureItemBaseInformation
    spec: Optional[TestStructureItemSpecification] = None
    aut: Optional[TestStructureAutomation] = None
    exec: Optional[TestStructureItemExecution] = None


@dataclass
class TestCaseNode(TestStructureTreeNode):
    base: TestCaseBaseInformation
    spec: Optional[TestCaseSpecification] = None
    exec: Optional[TestCaseExecution] = None


@dataclass
class TestStructureTree:
    nodes: List[Union[TestThemeNode, TestCaseSetNode, TestCaseNode]]
    root: Optional[Union[RootNode, TestThemeNode, TestCaseSetNode, TestCaseNode]] = None


@dataclass
class ReportingCompletion:
    time: str
    result: ReportingResult


@dataclass
class ExecutionImportingCompletion:
    time: str
    result: ExecutionImportingResult


@dataclass
class TestCaseSetExecutionImportResult:
    key: str
    executionKey: str
    finished: bool
    testCases: List[TestCaseExecutionImportResult]
    error: Optional[ActionFailure] = None


@dataclass
class UDFPosition:
    after: Optional[AfterUDF] = None
    before: Optional[BeforeUDF] = None
    absolute: Optional[UDFAbsolutePosition] = None


@dataclass
class UDFForMove:
    udfKeys: List[str]
    newPositions: UDFPosition


@dataclass
class StringUDFUpdatedResponse(UDFUpdatedResponse):
    stringUDF: StringUDF
    affectedFilters: List[TestFilter]


@dataclass
class BooleanUDFUpdatedResponse(UDFUpdatedResponse):
    booleanUdf: BooleanUDF
    affectedFilters: List[TestFilter]


@dataclass
class EnumerationUDFUpdatedResponse(UDFUpdatedResponse):
    enumerationUDF: EnumerationUDF
    affectedFilters: List[TestFilter]


@dataclass
class CycleResponse:
    name: str
    visible: bool
    projectKey: str
    description: str
    creation: CycleCreation
    key: str
    tovKey: str
    status: ProjectStatus
    testingIntelligence: bool
    instantOfCreation: str
    endDate: Optional[str] = None
    startDate: Optional[str] = None


@dataclass
class ImageInfo:
    key: str
    value: ImageDetails


@dataclass
class InteractionCallSpecification:
    key: str
    interactionType: InteractionType
    name: str
    sequencePhase: SequencePhase
    callType: InteractionCallType
    comments: str
    callParameters: List[ParameterSummary]
    description: Optional[str] = None
    interactionKey: Optional[str] = None
    callingInteractionKey: Optional[str] = None


@dataclass
class InteractionCall:
    sequenceID: str
    numbering: str
    spec: InteractionCallSpecification
    parentID: Optional[str] = None
    exec: Optional[InteractionCallExecution] = None


@dataclass
class InteractionDetails:
    key: str
    name: str
    uniqueID: str
    status: TestElementStatus
    defaultCallType: InteractionCallType
    description: str
    path: str
    parameters: List[ParameterDetails]
    preConditions: List[ConditionSummary]
    postConditions: List[ConditionSummary]
    references: List[str]
    locker: Optional[UserReference] = None
    version: Optional[str] = None
    parentUniqueID: Optional[str] = None
    libraryKey: Optional[str] = None
    advancedContent: Optional[AdvancedContent] = None


@dataclass
class ProjectNode:
    nodeType: ProjectTreeNodeType
    key: str
    name: str
    creationTime: str
    status: ProjectStatus
    visibility: bool
    children: List[TOVNode]


@dataclass
class TestCaseDetails:
    uniqueID: str
    spec: TestCaseSpecificationDetails
    testSequence: List[InteractionCall]
    parameters: List[ParameterSummary]
    interactions: List[InteractionDetails]
    exec: Optional[TestCaseExecutionDetails] = None
    origin: Optional[TestCaseDetailsOrigin] = None


@dataclass
class ReportingJob:
    id: str
    projectKey: str
    owner: str
    start: str
    progress: Optional[JobProgress] = None
    completion: Optional[ReportingCompletion] = None


@dataclass
class ExecutionImportingJob:
    id: str
    projectKey: str
    owner: str
    start: str
    progress: Optional[JobProgress] = None
    completion: Optional[ExecutionImportingCompletion] = None


@dataclass
class ExecutionImportingSuccess(ExecutionImportingResult):
    testCaseSets: List[TestCaseSetExecutionImportResult]


@dataclass
class UDFForInsert:
    name: str
    isMandatory: bool
    definedFor: List[UDFLocation]
    udfType: UDFType
    enumerationName: Optional[List[str]] = None
    position: Optional[UDFPosition] = None


@dataclass
class RichTextInfo:
    html: str
    images: List[ImageInfo]


@dataclass
class InteractionDetailsForUpdate:
    name: Optional[str] = None
    description: Optional[RichTextInfo] = None
    callType: Optional[InteractionCallType] = None
    locker: Optional[OptionalUser] = None
    advancedContent: Optional[OptionalAdvancedContent] = None


@dataclass
class SpecificationDetailsForUpdate:
    responsible: Optional[OptionalUser] = None
    reviewer: Optional[OptionalUser] = None
    locker: Optional[OptionalUser] = None
    priority: Optional[Priority] = None
    dueDate: Optional[OptionalLocalDateTime] = None
    description: Optional[RichTextInfo] = None
    reviewComment: Optional[RichTextInfo] = None


@dataclass
class ProjectDetailsForUpdate:
    name: Optional[str] = None
    testObjectName: Optional[str] = None
    id: Optional[str] = None
    customerName: Optional[str] = None
    customerAddress: Optional[str] = None
    contactPerson: Optional[str] = None
    testLab: Optional[str] = None
    placeOfInspection: Optional[str] = None
    status: Optional[ProjectStatus] = None
    isVisibleToTester: Optional[bool] = None
    isTestingIntelligenceActive: Optional[bool] = None
    description: Optional[RichTextInfo] = None
    startDate: Optional[OptionalLocalDateTime] = None
    endDate: Optional[OptionalLocalDateTime] = None
    inspections: Optional[List[str]] = None
    variantsManagementEnabled: Optional[OperationalState] = None


@dataclass
class TOVForUpdate:
    name: Optional[str] = None
    endDate: Optional[OptionalLocalDateTime] = None
    visible: Optional[bool] = None
    description: Optional[RichTextInfo] = None
    isBaseTov: Optional[bool] = None
    status: Optional[ProjectStatus] = None
    testingIntelligence: Optional[bool] = None
    startDate: Optional[OptionalLocalDateTime] = None
    cloningVisibility: Optional[bool] = None


@dataclass
class CycleForUpdate:
    name: Optional[str] = None
    endDate: Optional[OptionalLocalDateTime] = None
    visible: Optional[bool] = None
    description: Optional[RichTextInfo] = None
    status: Optional[ProjectStatus] = None
    testingIntelligence: Optional[bool] = None
    startDate: Optional[OptionalLocalDateTime] = None
