# VTL Engine

|              |                                                                                                                                                                                |
|--------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Testing      | [![Testing](https://github.com/Meaningful-Data/vtlengine/actions/workflows/testing.yml/badge.svg)](https://github.com/Meaningful-Data/vtlengine/actions/workflows/testing.yml) |
| Package      | [![PyPI Latest Release](https://img.shields.io/pypi/v/vtlengine.svg)](https://pypi.org/project/vtlengine/)                                                                     |
| License      | [![License - AGPL 3.0](https://img.shields.io/pypi/l/vtlengine.svg)](https://github.com/Meaningful-Data/vtlengine/blob/main/LICENSE.md)                                        |
| Mentioned in | [![Mentioned in Awesome Official Statistics ](https://awesome.re/mentioned-badge.svg)](https://github.com/SNStatComp/awesome-official-statistics-software)                                               |

## Introduction

The VTL Engine is a Python library that allows you to validate, format and execute VTL scripts.

It is a Python-based library around
the [VTL Language 2.1](https://sdmx-twg.github.io/vtl/2.1/html/index.html).

## Useful Links

- [MeaningfulData: who we are](https://www.meaningfuldata.eu)
- [Documentation](https://docs.vtlengine.meaningfuldata.eu)
- [Source Code](https://github.com/Meaningful-Data/vtlengine)
- [Bug Tracker](https://github.com/Meaningful-Data/vtlengine/issues?q=is%3Aopen+is%3Aissue+label%3Abug)
- [New features Tracker](https://github.com/Meaningful-Data/vtlengine/issues?q=is%3Aopen+is%3Aissue+label%3Aenhancement)

## Installation

### Requirements

The VTL Engine requires Python 3.9 or higher.

### Install with pip

To install the VTL Engine on any Operating System, you can use pip:

```bash

pip install vtlengine

```

*Note: it is recommended to install the VTL Engine in a virtual environment.*

### S3 extra

If you want to use the S3 functionality, you can install the VTL Engine with the `s3` extra:

```bash
pip install vtlengine[s3]
```

## Documentation

The documentation for the VTL Engine is available
at [docs.vtlengine.meaningfuldata.eu](https://docs.vtlengine.meaningfuldata.eu).