import sgqlc.types
import sgqlc.types.datetime
import sgqlc.types.relay


schema = sgqlc.types.Schema()


# Unexport Node/PageInfo, let schema re-declare them
schema -= sgqlc.types.relay.Node
schema -= sgqlc.types.relay.PageInfo


__docformat__ = "markdown"


########################################################################
# Scalars and Enumerations
########################################################################
class AccessKeyIndexEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `account`None
    * `user`None
    """

    __schema__ = schema
    __choices__ = ("account", "user")


class AccountNotificationDigestSettingsModelDigestType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ANOMALIES_DIGEST`: anomalies based digest
    * `INACTIVE_DIGEST`: inactive monitors digest
    * `MISCONF_DIGEST`: misconfigured monitors digest
    """

    __schema__ = schema
    __choices__ = ("ANOMALIES_DIGEST", "INACTIVE_DIGEST", "MISCONF_DIGEST")


class AccountNotificationRoutingRulesModelMonitorLabelsMatchType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AND`: AND
    * `OR`: OR
    """

    __schema__ = schema
    __choices__ = ("AND", "OR")


class AccountNotificationSettingsModelNotificationScheduleType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BACKUP_OR_FAILURE`: Backup Or Failure
    * `DIGEST`: Digest
    * `REALTIME`: Realtime
    """

    __schema__ = schema
    __choices__ = ("BACKUP_OR_FAILURE", "DIGEST", "REALTIME")


class AccountNotificationSettingsModelType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ALATION`: Alation
    * `AZURE_DEVOPS`: Azure Devops
    * `DATADOG`: Datadog
    * `EMAIL`: Email
    * `GOOGLE_CHAT`: Google Chat
    * `INCIDENTIO`: Incidentio
    * `JIRA`: Jira
    * `MSTEAMS`: Msteams
    * `MSTEAMS_V2`: Msteams V2
    * `OPSGENIE`: Opsgenie
    * `PAGERDUTY`: Pagerduty
    * `SERVICENOW`: Servicenow
    * `SLACK`: Slack
    * `SLACK_V2`: Slack V2
    * `WEBEX`: Webex
    * `WEBHOOK`: Webhook
    """

    __schema__ = schema
    __choices__ = (
        "ALATION",
        "AZURE_DEVOPS",
        "DATADOG",
        "EMAIL",
        "GOOGLE_CHAT",
        "INCIDENTIO",
        "JIRA",
        "MSTEAMS",
        "MSTEAMS_V2",
        "OPSGENIE",
        "PAGERDUTY",
        "SERVICENOW",
        "SLACK",
        "SLACK_V2",
        "WEBEX",
        "WEBHOOK",
    )


class ActorType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AI`None
    * `HUMAN`None
    * `assistant`None
    * `system`None
    * `user`None
    """

    __schema__ = schema
    __choices__ = ("AI", "HUMAN", "assistant", "system", "user")


class AdfJobRunModelStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CANCELLED`: Cancelled
    * `CANCELLING`: Cancelling
    * `FAILED`: Failed
    * `INACTIVE`: Inactive
    * `INPROGRESS`: InProgress
    * `QUEUED`: Queued
    * `SKIPPED`: Skipped
    * `SUCCEEDED`: Succeeded
    """

    __schema__ = schema
    __choices__ = (
        "CANCELLED",
        "CANCELLING",
        "FAILED",
        "INACTIVE",
        "INPROGRESS",
        "QUEUED",
        "SKIPPED",
        "SUCCEEDED",
    )


class AdfTaskRunModelStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CANCELLED`: Cancelled
    * `CANCELLING`: Cancelling
    * `FAILED`: Failed
    * `INACTIVE`: Inactive
    * `INPROGRESS`: InProgress
    * `QUEUED`: Queued
    * `SKIPPED`: Skipped
    * `SUCCEEDED`: Succeeded
    """

    __schema__ = schema
    __choices__ = (
        "CANCELLED",
        "CANCELLING",
        "FAILED",
        "INACTIVE",
        "INPROGRESS",
        "QUEUED",
        "SKIPPED",
        "SUCCEEDED",
    )


class AgentModelAgentType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DATA_STORE_AGENT`: Data Store Agent
    * `REMOTE_AGENT`: Remote Agent
    """

    __schema__ = schema
    __choices__ = ("DATA_STORE_AGENT", "REMOTE_AGENT")


class AgentModelAuthType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AWS_ASSUMABLE_ROLE`: AWS Assumable Role
    * `AWS_IAM_AUTH`: AWS IAM Authorization
    * `AWS_VPCE`: AWS VPC Endpoint
    * `AZURE_FUNCTION_APP_KEY`: Azure Function App Key
    * `AZURE_STORAGE_ACCOUNT_KEYS`: Azure Storage Account Shared Key
    * `GCP_JSON_SERVICE_ACCOUNT_KEY`: GCP JSON Service Account Key
    * `GCP_WORKLOAD_IDENTITY_FEDERATION`: GCP Workload Identity
      Federation
    * `MCD_SHA512`: MCD SHA-512
    * `OAUTH2_CLIENT_CREDENTIALS`: OAUTH 2.0 Client Credentials Grant
    * `OAUTH2_PASSWORD`: OAUTH 2.0 Password Grant
    """

    __schema__ = schema
    __choices__ = (
        "AWS_ASSUMABLE_ROLE",
        "AWS_IAM_AUTH",
        "AWS_VPCE",
        "AZURE_FUNCTION_APP_KEY",
        "AZURE_STORAGE_ACCOUNT_KEYS",
        "GCP_JSON_SERVICE_ACCOUNT_KEY",
        "GCP_WORKLOAD_IDENTITY_FEDERATION",
        "MCD_SHA512",
        "OAUTH2_CLIENT_CREDENTIALS",
        "OAUTH2_PASSWORD",
    )


class AgentModelPlatform(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AWS`: AWS
    * `AWS_GENERIC`: AWS_GENERIC
    * `AZURE`: Azure
    * `GCP`: GCP
    * `SNOWFLAKE`: SNOWFLAKE
    """

    __schema__ = schema
    __choices__ = ("AWS", "AWS_GENERIC", "AZURE", "GCP", "SNOWFLAKE")


class AgentModelStorageType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AZURE_BLOB`: Azure Storage
    * `GCS`: Google Cloud Storage
    * `S3`: Amazon S3
    * `SNOWFLAKE_INTERNAL_STAGE`: Snowflake Internal Stage
    """

    __schema__ = schema
    __choices__ = ("AZURE_BLOB", "GCS", "S3", "SNOWFLAKE_INTERNAL_STAGE")


class AgentModelWrapperType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CLOUDFORMATION`: CloudFormation
    * `SNA_CONTAINER`: Snowflake Application Container
    * `TERRAFORM`: Terraform
    """

    __schema__ = schema
    __choices__ = ("CLOUDFORMATION", "SNA_CONTAINER", "TERRAFORM")


class AgentTraceFormatEnum(sgqlc.types.Enum):
    """Enum for agent trace format types.

    Enumeration Choices:

    * `STANDARD`None
    * `STRANDS`None
    """

    __schema__ = schema
    __choices__ = ("STANDARD", "STRANDS")


class AgentTraceTableModelSpanFormat(sgqlc.types.Enum):
    """Enumeration Choices:

    * `STANDARD`: standard
    * `STRANDS`: strands
    """

    __schema__ = schema
    __choices__ = ("STANDARD", "STRANDS")


class AgentTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DATA_STORE_AGENT`None
    * `REMOTE_AGENT`None
    """

    __schema__ = schema
    __choices__ = ("DATA_STORE_AGENT", "REMOTE_AGENT")


class AggregateMetricType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `MAX`None
    * `MEAN`None
    * `MIN`None
    * `NULL_COUNT`None
    * `NULL_RATE`None
    * `ROW_COUNT`None
    * `STDDEV`None
    * `UNIQUENESS_COUNT`None
    * `UNIQUENESS_RATE`None
    """

    __schema__ = schema
    __choices__ = (
        "MAX",
        "MEAN",
        "MIN",
        "NULL_COUNT",
        "NULL_RATE",
        "ROW_COUNT",
        "STDDEV",
        "UNIQUENESS_COUNT",
        "UNIQUENESS_RATE",
    )


class AggregationFunction(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AVG`None
    * `MAX`None
    * `MEDIAN`None
    * `MIN`None
    """

    __schema__ = schema
    __choices__ = ("AVG", "MAX", "MEDIAN", "MIN")


class AiAgentType(sgqlc.types.Enum):
    """Types of AI agents available in the system.

    Enumeration Choices:

    * `TROUBLESHOOTING`None
    """

    __schema__ = schema
    __choices__ = ("TROUBLESHOOTING",)


class AirflowRunState(sgqlc.types.Enum):
    """Enumeration Choices:

    * `deferred`None
    * `failed`None
    * `queued`None
    * `removed`None
    * `restarting`None
    * `running`None
    * `scheduled`None
    * `skipped`None
    * `success`None
    * `unknown`None
    * `up_for_reschedule`None
    * `up_for_retry`None
    * `upstream_failed`None
    """

    __schema__ = schema
    __choices__ = (
        "deferred",
        "failed",
        "queued",
        "removed",
        "restarting",
        "running",
        "scheduled",
        "skipped",
        "success",
        "unknown",
        "up_for_reschedule",
        "up_for_retry",
        "upstream_failed",
    )


class AlertAccessRequestStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `EXPIRED`None
    * `NOTIFIED`None
    * `PENDING`None
    * `RESOLVED`None
    """

    __schema__ = schema
    __choices__ = ("EXPIRED", "NOTIFIED", "PENDING", "RESOLVED")


class AlertGroupBy(sgqlc.types.Enum):
    """Enumeration Choices:

    * `STATUS`None
    * `TYPE`None
    """

    __schema__ = schema
    __choices__ = ("STATUS", "TYPE")


class AlertReactionReason(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DETECTOR_TOO_SENSITIVE`None
    * `DONT_CARE_ABOUT_THIS_TABLE`None
    * `SEEN_THIS_TOO_MANY_TIMES`None
    """

    __schema__ = schema
    __choices__ = (
        "DETECTOR_TOO_SENSITIVE",
        "DONT_CARE_ABOUT_THIS_TABLE",
        "SEEN_THIS_TOO_MANY_TIMES",
    )


class AlertReactionType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `HELPFUL`None
    * `NOT_HELPFUL`None
    """

    __schema__ = schema
    __choices__ = ("HELPFUL", "NOT_HELPFUL")


class AlertStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ACKNOWLEDGED`None
    * `EXPECTED`None
    * `FALSE_POSITIVE`None
    * `FIXED`None
    * `NO_ACTION_NEEDED`None
    * `WORK_IN_PROGRESS`None
    """

    __schema__ = schema
    __choices__ = (
        "ACKNOWLEDGED",
        "EXPECTED",
        "FALSE_POSITIVE",
        "FIXED",
        "NO_ACTION_NEEDED",
        "WORK_IN_PROGRESS",
    )


class AlertStatusInput(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ACKNOWLEDGED`None
    * `EXPECTED`None
    * `FALSE_POSITIVE`None
    * `FIXED`None
    * `NO_ACTION_NEEDED`None
    * `NO_STATUS`None
    * `WORK_IN_PROGRESS`None
    """

    __schema__ = schema
    __choices__ = (
        "ACKNOWLEDGED",
        "EXPECTED",
        "FALSE_POSITIVE",
        "FIXED",
        "NO_ACTION_NEEDED",
        "NO_STATUS",
        "WORK_IN_PROGRESS",
    )


class AlertSubType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ADF_JOB_FAILURE`None
    * `AGENT_ANOMALIES`None
    * `AGENT_ANOMALY`None
    * `AIRFLOW_DAG_FAILURE`None
    * `ANOMALIES`None
    * `COMPARISON_RULE_BREACH`None
    * `CUSTOM_RULE_ANOMALIES`None
    * `DATABRICKS_JOB_FAILURE`None
    * `DBT_ERRORS`None
    * `DBT_MODEL_ERROR`None
    * `DBT_SEED_ERROR`None
    * `DBT_SNAPSHOT_ERROR`None
    * `DBT_TEST_FAILURE`None
    * `DBT_TEST_WARNING`None
    * `DELETED_TABLES`None
    * `DIMENSION_ANOMALY`None
    * `ETL_ERRORS`None
    * `FIELD_METRICS_ANOMALY`None
    * `FIELD_QUALITY_RULE_BREACH`None
    * `FRESHNESS_ANOMALY`None
    * `FRESHNESS_SLI_RULE_BREACH`None
    * `JSON_SCHEMA_ANOMALY_FIELDS_ADDED`None
    * `JSON_SCHEMA_ANOMALY_FIELDS_REMOVED`None
    * `JSON_SCHEMA_CHANGES`None
    * `JSON_SCHEMA_RULE_BREACH`None
    * `MERGED`None
    * `METRIC_ANOMALIES`None
    * `METRIC_COMPARISON_ANOMALIES`None
    * `METRIC_COMPARISON_ANOMALY`None
    * `PERFORMANCE_ANOMALIES`None
    * `PERFORMANCE_ANOMALY`None
    * `PSEUDO_INTEGRATION_TEST`None
    * `RULE_RUN_EXECUTION_ERROR`None
    * `SCHEMA_ANOMALY_FIELDS_ADDED`None
    * `SCHEMA_ANOMALY_FIELDS_CHANGED`None
    * `SCHEMA_ANOMALY_FIELDS_REMOVED`None
    * `SCHEMA_CHANGES`None
    * `SQL_RULE_BREACH`None
    * `VALIDATION_BREACH`None
    * `VOLUME_ANOMALY`None
    * `VOLUME_ANOMALY_ABNORMAL_SIZE_CHANGE`None
    * `VOLUME_ANOMALY_DATA_ADDED`None
    * `VOLUME_ANOMALY_DATA_REMOVED`None
    * `VOLUME_ANOMALY_UNCHANGED_SIZE`None
    * `VOLUME_SLI_RULE_BREACH`None
    """

    __schema__ = schema
    __choices__ = (
        "ADF_JOB_FAILURE",
        "AGENT_ANOMALIES",
        "AGENT_ANOMALY",
        "AIRFLOW_DAG_FAILURE",
        "ANOMALIES",
        "COMPARISON_RULE_BREACH",
        "CUSTOM_RULE_ANOMALIES",
        "DATABRICKS_JOB_FAILURE",
        "DBT_ERRORS",
        "DBT_MODEL_ERROR",
        "DBT_SEED_ERROR",
        "DBT_SNAPSHOT_ERROR",
        "DBT_TEST_FAILURE",
        "DBT_TEST_WARNING",
        "DELETED_TABLES",
        "DIMENSION_ANOMALY",
        "ETL_ERRORS",
        "FIELD_METRICS_ANOMALY",
        "FIELD_QUALITY_RULE_BREACH",
        "FRESHNESS_ANOMALY",
        "FRESHNESS_SLI_RULE_BREACH",
        "JSON_SCHEMA_ANOMALY_FIELDS_ADDED",
        "JSON_SCHEMA_ANOMALY_FIELDS_REMOVED",
        "JSON_SCHEMA_CHANGES",
        "JSON_SCHEMA_RULE_BREACH",
        "MERGED",
        "METRIC_ANOMALIES",
        "METRIC_COMPARISON_ANOMALIES",
        "METRIC_COMPARISON_ANOMALY",
        "PERFORMANCE_ANOMALIES",
        "PERFORMANCE_ANOMALY",
        "PSEUDO_INTEGRATION_TEST",
        "RULE_RUN_EXECUTION_ERROR",
        "SCHEMA_ANOMALY_FIELDS_ADDED",
        "SCHEMA_ANOMALY_FIELDS_CHANGED",
        "SCHEMA_ANOMALY_FIELDS_REMOVED",
        "SCHEMA_CHANGES",
        "SQL_RULE_BREACH",
        "VALIDATION_BREACH",
        "VOLUME_ANOMALY",
        "VOLUME_ANOMALY_ABNORMAL_SIZE_CHANGE",
        "VOLUME_ANOMALY_DATA_ADDED",
        "VOLUME_ANOMALY_DATA_REMOVED",
        "VOLUME_ANOMALY_UNCHANGED_SIZE",
        "VOLUME_SLI_RULE_BREACH",
    )


class AlertType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AGENT_ANOMALIES`None
    * `ANOMALIES`None
    * `CUSTOM_RULE_ANOMALIES`None
    * `DBT_ERRORS`None
    * `DELETED_TABLES`None
    * `ETL_ERRORS`None
    * `JSON_SCHEMA_CHANGES`None
    * `MERGED`None
    * `METRIC_ANOMALIES`None
    * `METRIC_COMPARISON_ANOMALIES`None
    * `PERFORMANCE_ANOMALIES`None
    * `PSEUDO_INTEGRATION_TEST`None
    * `RULE_RUN_EXECUTION_ERROR`None
    * `SCHEMA_CHANGES`None
    """

    __schema__ = schema
    __choices__ = (
        "AGENT_ANOMALIES",
        "ANOMALIES",
        "CUSTOM_RULE_ANOMALIES",
        "DBT_ERRORS",
        "DELETED_TABLES",
        "ETL_ERRORS",
        "JSON_SCHEMA_CHANGES",
        "MERGED",
        "METRIC_ANOMALIES",
        "METRIC_COMPARISON_ANOMALIES",
        "PERFORMANCE_ANOMALIES",
        "PSEUDO_INTEGRATION_TEST",
        "RULE_RUN_EXECUTION_ERROR",
        "SCHEMA_CHANGES",
    )


class AlertsFilterFieldName(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AUDIENCE`None
    * `DATABASE`None
    * `DOMAIN`None
    * `HAS_AZURE_DEVOPS_WORK_ITEMS`None
    * `HAS_DATADOG_INCIDENTS`None
    * `HAS_JIRA_TICKETS`None
    * `HAS_KEY_ASSETS`None
    * `HAS_OPSGENIE_INCIDENTS`None
    * `HAS_SERVICE_NOW_INCIDENTS`None
    * `IS_NORMALIZED`None
    * `MONITOR_TAG`None
    * `OWNER`None
    * `PRIORITY`None
    * `SCHEMA`None
    * `SEVERITY`None
    * `STATUS`None
    * `TABLE`None
    * `TAG`None
    * `TYPE`None
    """

    __schema__ = schema
    __choices__ = (
        "AUDIENCE",
        "DATABASE",
        "DOMAIN",
        "HAS_AZURE_DEVOPS_WORK_ITEMS",
        "HAS_DATADOG_INCIDENTS",
        "HAS_JIRA_TICKETS",
        "HAS_KEY_ASSETS",
        "HAS_OPSGENIE_INCIDENTS",
        "HAS_SERVICE_NOW_INCIDENTS",
        "IS_NORMALIZED",
        "MONITOR_TAG",
        "OWNER",
        "PRIORITY",
        "SCHEMA",
        "SEVERITY",
        "STATUS",
        "TABLE",
        "TAG",
        "TYPE",
    )


class AssetCollectionRuleEffect(sgqlc.types.Enum):
    """Enumeration Choices:

    * `allow`None
    * `block`None
    """

    __schema__ = schema
    __choices__ = ("allow", "block")


class AssetFilterTableNameOperator(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CONTAINS`None
    * `ENDS_WITH`None
    * `MATCH_PATTERN`None
    * `STARTS_WITH`None
    """

    __schema__ = schema
    __choices__ = ("CONTAINS", "ENDS_WITH", "MATCH_PATTERN", "STARTS_WITH")


class AssetFilterTableTagOperator(sgqlc.types.Enum):
    """Enumeration Choices:

    * `HAS_ALL`None
    * `HAS_ANY`None
    """

    __schema__ = schema
    __choices__ = ("HAS_ALL", "HAS_ANY")


class AssetFilterType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ACTIVITY_READ`None
    * `ACTIVITY_READ_IS_NULL`None
    * `ACTIVITY_READ_WRITE`None
    * `ACTIVITY_READ_WRITE_IS_NULL`None
    * `ACTIVITY_VOLUME_CHANGE`None
    * `ACTIVITY_WRITE`None
    * `ACTIVITY_WRITE_IS_NULL`None
    * `TABLE_NAME`None
    * `TABLE_TAG`None
    * `TABLE_TYPE`None
    """

    __schema__ = schema
    __choices__ = (
        "ACTIVITY_READ",
        "ACTIVITY_READ_IS_NULL",
        "ACTIVITY_READ_WRITE",
        "ACTIVITY_READ_WRITE_IS_NULL",
        "ACTIVITY_VOLUME_CHANGE",
        "ACTIVITY_WRITE",
        "ACTIVITY_WRITE_IS_NULL",
        "TABLE_NAME",
        "TABLE_TAG",
        "TABLE_TYPE",
    )


class AssetSelectionLevel(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DATABASE`None
    * `SCHEMA`None
    * `TABLE`None
    * `WAREHOUSE`None
    """

    __schema__ = schema
    __choices__ = ("DATABASE", "SCHEMA", "TABLE", "WAREHOUSE")


class AssetsSortDirection(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ASC`None
    * `DESC`None
    """

    __schema__ = schema
    __choices__ = ("ASC", "DESC")


class AuthType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BASIC`None
    * `BEARER`None
    * `NO_AUTH`None
    """

    __schema__ = schema
    __choices__ = ("BASIC", "BEARER", "NO_AUTH")


class AuthTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AWS_ASSUMABLE_ROLE`None
    * `AWS_IAM_AUTH`None
    * `AWS_VPCE`None
    * `AZURE_FUNCTION_APP_KEY`None
    * `AZURE_STORAGE_ACCOUNT_KEYS`None
    * `GCP_JSON_SERVICE_ACCOUNT_KEY`None
    * `GCP_WORKLOAD_IDENTITY_FEDERATION`None
    * `MCD_SHA512`None
    * `OAUTH2_CLIENT_CREDENTIALS`None
    * `OAUTH2_PASSWORD`None
    """

    __schema__ = schema
    __choices__ = (
        "AWS_ASSUMABLE_ROLE",
        "AWS_IAM_AUTH",
        "AWS_VPCE",
        "AZURE_FUNCTION_APP_KEY",
        "AZURE_STORAGE_ACCOUNT_KEYS",
        "GCP_JSON_SERVICE_ACCOUNT_KEY",
        "GCP_WORKLOAD_IDENTITY_FEDERATION",
        "MCD_SHA512",
        "OAUTH2_CLIENT_CREDENTIALS",
        "OAUTH2_PASSWORD",
    )


class AuthorizationGroupSource(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AUTHORIZATION_PROVIDER`: Group is automatically created/managed
      from the account's auth provider via a protocol such as SCIM.
    * `BUILT_IN`: Group is automatically provided and managed by Monte
      Carlo for all customers.
    * `CUSTOM`: Group is defined and managed by the account either
      through the Admin UI or APIs.
    """

    __schema__ = schema
    __choices__ = ("AUTHORIZATION_PROVIDER", "BUILT_IN", "CUSTOM")


class AutoOperator(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AUTO`None
    * `AUTO_HIGH`None
    * `AUTO_LOW`None
    """

    __schema__ = schema
    __choices__ = ("AUTO", "AUTO_HIGH", "AUTO_LOW")


class AwsEnvConfiguration(sgqlc.types.Enum):
    """Enumeration Choices:

    * `primary`None
    * `secondary`None
    """

    __schema__ = schema
    __choices__ = ("primary", "secondary")


class BiContainerModelType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `LOOKER`: Looker
    * `POWER_BI`: Power BI
    * `TABLEAU`: Tableau
    """

    __schema__ = schema
    __choices__ = ("LOOKER", "POWER_BI", "TABLEAU")


class BigInt(sgqlc.types.Scalar):
    """BigInt is an extension of the regular Int field     that supports
    Integers bigger than a signed     32-bit integer.  Copied from
    https://stackoverflow.com/questions/45624042/graphene-django-
    converts-models-biginteger-to-graphene-integer Current graphene:
    https://github.com/graphql-
    python/graphene/blob/master/graphene/types/scalars.py#L88
    """

    __schema__ = schema


class BillingInvoiceStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DRAFT`None
    * `FINALIZED`None
    * `VOID`None
    """

    __schema__ = schema
    __choices__ = ("DRAFT", "FINALIZED", "VOID")


class BillingInvoicesSort(sgqlc.types.Enum):
    """Enumeration Choices:

    * `date_asc`None
    * `date_desc`None
    """

    __schema__ = schema
    __choices__ = ("date_asc", "date_desc")


class BillingPlanType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ENTERPRISE`None
    * `ENTERPRISE_WITH_ADVANCED_NETWORKING`None
    * `SCALE`None
    * `SCALE_WITH_ADVANCED_NETWORKING`None
    * `START`None
    """

    __schema__ = schema
    __choices__ = (
        "ENTERPRISE",
        "ENTERPRISE_WITH_ADVANCED_NETWORKING",
        "SCALE",
        "SCALE_WITH_ADVANCED_NETWORKING",
        "START",
    )


Boolean = sgqlc.types.Boolean


class BooleanOperator(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AND`None
    * `OR`None
    """

    __schema__ = schema
    __choices__ = ("AND", "OR")


class CollectionNodeModelStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ASSIGNED`: Assigned
    * `AVAILABLE`: Available
    * `DELETED`: Deleted
    * `READY`: Ready
    * `UNASSIGNED`: Unassigned
    """

    __schema__ = schema
    __choices__ = ("ASSIGNED", "AVAILABLE", "DELETED", "READY", "UNASSIGNED")


class CollectionPreferenceEffectType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `allow`None
    * `block`None
    """

    __schema__ = schema
    __choices__ = ("allow", "block")


class CollectionPreferenceMatchType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `exact_match`None
    * `prefix`None
    * `regexp`None
    * `substring`None
    * `suffix`None
    """

    __schema__ = schema
    __choices__ = ("exact_match", "prefix", "regexp", "substring", "suffix")


class CollectionPreferenceTargetObjectType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `dataset`None
    * `project`None
    * `table`None
    """

    __schema__ = schema
    __choices__ = ("dataset", "project", "table")


class CollectionStorageModelStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ASSIGNED`: Assigned
    * `AVAILABLE`: Available
    * `DELETED`: Deleted
    * `READY`: Ready
    * `UNASSIGNED`: Unassigned
    """

    __schema__ = schema
    __choices__ = ("ASSIGNED", "AVAILABLE", "DELETED", "READY", "UNASSIGNED")


class ComparisonDataSourceType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `SOURCE`None
    * `TARGET`None
    """

    __schema__ = schema
    __choices__ = ("SOURCE", "TARGET")


class ComparisonType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ABSOLUTE_VOLUME`None
    * `CHANGE`None
    * `COMPARISON_DELTA`None
    * `DYNAMIC_THRESHOLD`None
    * `FRESHNESS`None
    * `GROWTH_VOLUME`None
    * `LOOKBACK`None
    * `QUERY_PERFORMANCE`None
    * `SOURCE_TARGET_DELTA`None
    * `THRESHOLD`None
    """

    __schema__ = schema
    __choices__ = (
        "ABSOLUTE_VOLUME",
        "CHANGE",
        "COMPARISON_DELTA",
        "DYNAMIC_THRESHOLD",
        "FRESHNESS",
        "GROWTH_VOLUME",
        "LOOKBACK",
        "QUERY_PERFORMANCE",
        "SOURCE_TARGET_DELTA",
        "THRESHOLD",
    )


class ConnectionModelType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AIRFLOW`: Airflow
    * `ATHENA`: Athena
    * `AZURE_DATA_FACTORY`: Azure Data Factory
    * `BIGQUERY`: BigQuery
    * `CLICKHOUSE`: ClickHouse
    * `CONFLUENT_KAFKA`: Confluent Kafka
    * `CONFLUENT_KAFKA_CONNECT`: Confluent Kafka Connect
    * `DATABRICKS_DELTA`: Databricks Delta
    * `DATABRICKS_METASTORE`: Databricks metastore
    * `DATABRICKS_METASTORE_SQL_WAREHOUSE`: Databricks Metastore Sql
      Warehouse
    * `DATABRICKS_SQL_WAREHOUSE`: Databricks Sql Warehouse
    * `DB2`: Db2
    * `DBT_CLOUD`: dbt Cloud
    * `DBT_CLOUD_V2`: dbt Cloud v2
    * `DBT_CLOUD_WEBHOOK`: dbt Cloud Webhook
    * `DBT_CORE`: dbt Core
    * `DREMIO`: dremio
    * `FIVETRAN`: Fivetran
    * `GLUE`: Glue
    * `HIVE`: Hive
    * `HIVE_MYSQL`: Hive (MySQL)
    * `HIVE_S3`: Hive (S3 Location)
    * `INFORMATICA`: Informatica
    * `LOOKER`: Looker
    * `LOOKER_GIT`: Looker Git
    * `LOOKER_GIT_CLONE`: Looker Git Clone either ssh or https
    * `LOOKER_GIT_SSH`: Looker Git SSH
    * `MSK_KAFKA`: MSK Kafka
    * `MSK_KAFKA_CONNECT`: MSK Kafka Connect
    * `MYSQL`: MySQL
    * `ORACLE`: Oracle
    * `PINECONE`: Pinecone
    * `POWER_BI`: Power BI
    * `PRESTO`: Presto
    * `REDSHIFT`: Amazon Redshift
    * `S3`: S3
    * `S3_METADATA_EVENTS`: S3 Metadata Events
    * `S3_QL_EVENTS`: S3 Query Log Events
    * `SALESFORCE_CRM`: Salesforce CRM
    * `SALESFORCE_DATA_CLOUD`: Salesforce Data Cloud
    * `SELF_HOSTED_KAFKA`: Self Hosted Kafka
    * `SELF_HOSTED_KAFKA_CONNECT`: Self Hosted Kafka Connect
    * `SNOWFLAKE`: Snowflake
    * `SPARK`: Spark
    * `TABLEAU`: Tableau
    * `TERADATA`: teradata
    * `TRANSACTIONAL_DB`: transactional-db
    """

    __schema__ = schema
    __choices__ = (
        "AIRFLOW",
        "ATHENA",
        "AZURE_DATA_FACTORY",
        "BIGQUERY",
        "CLICKHOUSE",
        "CONFLUENT_KAFKA",
        "CONFLUENT_KAFKA_CONNECT",
        "DATABRICKS_DELTA",
        "DATABRICKS_METASTORE",
        "DATABRICKS_METASTORE_SQL_WAREHOUSE",
        "DATABRICKS_SQL_WAREHOUSE",
        "DB2",
        "DBT_CLOUD",
        "DBT_CLOUD_V2",
        "DBT_CLOUD_WEBHOOK",
        "DBT_CORE",
        "DREMIO",
        "FIVETRAN",
        "GLUE",
        "HIVE",
        "HIVE_MYSQL",
        "HIVE_S3",
        "INFORMATICA",
        "LOOKER",
        "LOOKER_GIT",
        "LOOKER_GIT_CLONE",
        "LOOKER_GIT_SSH",
        "MSK_KAFKA",
        "MSK_KAFKA_CONNECT",
        "MYSQL",
        "ORACLE",
        "PINECONE",
        "POWER_BI",
        "PRESTO",
        "REDSHIFT",
        "S3",
        "S3_METADATA_EVENTS",
        "S3_QL_EVENTS",
        "SALESFORCE_CRM",
        "SALESFORCE_DATA_CLOUD",
        "SELF_HOSTED_KAFKA",
        "SELF_HOSTED_KAFKA_CONNECT",
        "SNOWFLAKE",
        "SPARK",
        "TABLEAU",
        "TERADATA",
        "TRANSACTIONAL_DB",
    )


class ConnectionSubtypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AZURE_DEDICATED_SQL_POOL`None
    * `AZURE_SQL_DATABASE`None
    * `DB2`None
    * `MARIADB`None
    * `MOTHERDUCK`None
    * `MYSQL`None
    * `ORACLE`None
    * `POSTGRES`None
    * `SAP_HANA`None
    * `SQL_SERVER`None
    * `TERADATA`None
    """

    __schema__ = schema
    __choices__ = (
        "AZURE_DEDICATED_SQL_POOL",
        "AZURE_SQL_DATABASE",
        "DB2",
        "MARIADB",
        "MOTHERDUCK",
        "MYSQL",
        "ORACLE",
        "POSTGRES",
        "SAP_HANA",
        "SQL_SERVER",
        "TERADATA",
    )


class ConnectionTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AIRFLOW`None
    * `ATHENA`None
    * `AZURE_DATA_FACTORY`None
    * `BIGQUERY`None
    * `CLICKHOUSE`None
    * `CONFLUENT_KAFKA`None
    * `CONFLUENT_KAFKA_CONNECT`None
    * `DATABRICKS_DELTA`None
    * `DATABRICKS_METASTORE`None
    * `DATABRICKS_METASTORE_SQL_WAREHOUSE`None
    * `DATABRICKS_SQL_WAREHOUSE`None
    * `DB2`None
    * `DBT_CLOUD`None
    * `DBT_CLOUD_V2`None
    * `DBT_CLOUD_WEBHOOK`None
    * `DBT_CORE`None
    * `DREMIO`None
    * `FIVETRAN`None
    * `GLUE`None
    * `HIVE`None
    * `HIVE_MYSQL`None
    * `HIVE_S3`None
    * `INFORMATICA`None
    * `LOOKER`None
    * `LOOKER_GIT`None
    * `LOOKER_GIT_CLONE`None
    * `LOOKER_GIT_SSH`None
    * `MSK_KAFKA`None
    * `MSK_KAFKA_CONNECT`None
    * `MYSQL`None
    * `ORACLE`None
    * `PINECONE`None
    * `POWER_BI`None
    * `PRESTO`None
    * `REDSHIFT`None
    * `S3`None
    * `S3_METADATA_EVENTS`None
    * `S3_QL_EVENTS`None
    * `SALESFORCE_CRM`None
    * `SALESFORCE_DATA_CLOUD`None
    * `SELF_HOSTED_KAFKA`None
    * `SELF_HOSTED_KAFKA_CONNECT`None
    * `SNOWFLAKE`None
    * `SPARK`None
    * `TABLEAU`None
    * `TERADATA`None
    * `TRANSACTIONAL_DB`None
    """

    __schema__ = schema
    __choices__ = (
        "AIRFLOW",
        "ATHENA",
        "AZURE_DATA_FACTORY",
        "BIGQUERY",
        "CLICKHOUSE",
        "CONFLUENT_KAFKA",
        "CONFLUENT_KAFKA_CONNECT",
        "DATABRICKS_DELTA",
        "DATABRICKS_METASTORE",
        "DATABRICKS_METASTORE_SQL_WAREHOUSE",
        "DATABRICKS_SQL_WAREHOUSE",
        "DB2",
        "DBT_CLOUD",
        "DBT_CLOUD_V2",
        "DBT_CLOUD_WEBHOOK",
        "DBT_CORE",
        "DREMIO",
        "FIVETRAN",
        "GLUE",
        "HIVE",
        "HIVE_MYSQL",
        "HIVE_S3",
        "INFORMATICA",
        "LOOKER",
        "LOOKER_GIT",
        "LOOKER_GIT_CLONE",
        "LOOKER_GIT_SSH",
        "MSK_KAFKA",
        "MSK_KAFKA_CONNECT",
        "MYSQL",
        "ORACLE",
        "PINECONE",
        "POWER_BI",
        "PRESTO",
        "REDSHIFT",
        "S3",
        "S3_METADATA_EVENTS",
        "S3_QL_EVENTS",
        "SALESFORCE_CRM",
        "SALESFORCE_DATA_CLOUD",
        "SELF_HOSTED_KAFKA",
        "SELF_HOSTED_KAFKA_CONNECT",
        "SNOWFLAKE",
        "SPARK",
        "TABLEAU",
        "TERADATA",
        "TRANSACTIONAL_DB",
    )


class ConsolidatedMonitorStatusType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DISABLED`None
    * `ENABLED`None
    * `ERROR`None
    * `INSUFFICIENT_DATA`None
    * `SNOOZED`None
    * `TRAINING`None
    """

    __schema__ = schema
    __choices__ = ("DISABLED", "ENABLED", "ERROR", "INSUFFICIENT_DATA", "SNOOZED", "TRAINING")


class CustomRuleComparisonOperator(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AUTO`None
    * `AUTO_HIGH`None
    * `AUTO_LOW`None
    * `EQ`None
    * `GT`None
    * `GTE`None
    * `INSIDE_RANGE`None
    * `IS_NOT_NULL`None
    * `IS_NULL`None
    * `LT`None
    * `LTE`None
    * `NEQ`None
    * `OUTSIDE_RANGE`None
    """

    __schema__ = schema
    __choices__ = (
        "AUTO",
        "AUTO_HIGH",
        "AUTO_LOW",
        "EQ",
        "GT",
        "GTE",
        "INSIDE_RANGE",
        "IS_NOT_NULL",
        "IS_NULL",
        "LT",
        "LTE",
        "NEQ",
        "OUTSIDE_RANGE",
    )


class CustomRuleModelQueryResultType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `LABELED_NUMERICS`: LABELED_NUMERICS
    * `ROWS`: ROWS
    * `ROW_COUNT`: ROW_COUNT
    * `SINGLE_NUMERIC`: SINGLE_NUMERIC
    * `UNIQUE_ROW_COUNT`: UNIQUE_ROW_COUNT
    * `UNIQUE_VALUE_LIST`: UNIQUE_VALUE_LIST
    * `VALUE_LIST`: VALUE_LIST
    """

    __schema__ = schema
    __choices__ = (
        "LABELED_NUMERICS",
        "ROWS",
        "ROW_COUNT",
        "SINGLE_NUMERIC",
        "UNIQUE_ROW_COUNT",
        "UNIQUE_VALUE_LIST",
        "VALUE_LIST",
    )


class CustomRuleModelRuleType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `COMPARISON`: Comparison
    * `CUSTOM_SQL`: Custom SQL
    * `FIELD_QUALITY`: Metric - legacy
    * `FRESHNESS`: Freshness
    * `QUERY_PERF`: Query performance
    * `TABLE_METRIC`: Table metric rule
    * `VALIDATION`: Validation
    * `VOLUME`: Volume
    """

    __schema__ = schema
    __choices__ = (
        "COMPARISON",
        "CUSTOM_SQL",
        "FIELD_QUALITY",
        "FRESHNESS",
        "QUERY_PERF",
        "TABLE_METRIC",
        "VALIDATION",
        "VOLUME",
    )


class CustomSQLTemplateModelQueryResultType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `LABELED_NUMERICS`: LABELED_NUMERICS
    * `ROWS`: ROWS
    * `ROW_COUNT`: ROW_COUNT
    * `SINGLE_NUMERIC`: SINGLE_NUMERIC
    * `UNIQUE_ROW_COUNT`: UNIQUE_ROW_COUNT
    * `UNIQUE_VALUE_LIST`: UNIQUE_VALUE_LIST
    * `VALUE_LIST`: VALUE_LIST
    """

    __schema__ = schema
    __choices__ = (
        "LABELED_NUMERICS",
        "ROWS",
        "ROW_COUNT",
        "SINGLE_NUMERIC",
        "UNIQUE_ROW_COUNT",
        "UNIQUE_VALUE_LIST",
        "VALUE_LIST",
    )


class DashboardType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `READ`None
    * `WRITE`None
    """

    __schema__ = schema
    __choices__ = ("READ", "WRITE")


class DataAssetTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ASSET_TYPE_EXTERNAL`None
    * `ASSET_TYPE_SNOWFLAKE_STREAM`None
    * `ASSET_TYPE_TABLE`None
    * `ASSET_TYPE_VIEW`None
    * `ASSET_TYPE_WILDCARD_TABLE`None
    """

    __schema__ = schema
    __choices__ = (
        "ASSET_TYPE_EXTERNAL",
        "ASSET_TYPE_SNOWFLAKE_STREAM",
        "ASSET_TYPE_TABLE",
        "ASSET_TYPE_VIEW",
        "ASSET_TYPE_WILDCARD_TABLE",
    )


class DataCollectorDeploymentTypeExtendedEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CLOUD_V1`None
    * `CLOUD_V2_M`None
    * `CLOUD_V2_P`None
    * `REMOTE_V1`None
    * `REMOTE_V1_5`None
    * `REMOTE_V2_EA`None
    * `REMOTE_V2_IA`None
    """

    __schema__ = schema
    __choices__ = (
        "CLOUD_V1",
        "CLOUD_V2_M",
        "CLOUD_V2_P",
        "REMOTE_V1",
        "REMOTE_V1_5",
        "REMOTE_V2_EA",
        "REMOTE_V2_IA",
    )


class DataCollectorEventTypes(sgqlc.types.Enum):
    """Enumeration Choices:

    * `s3_metadata_events`None
    * `s3_ql_events`None
    """

    __schema__ = schema
    __choices__ = ("s3_metadata_events", "s3_ql_events")


class DataCollectorModelDeploymentTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CLOUD_V1`None
    * `CLOUD_V2`None
    * `REMOTE_V1`None
    * `REMOTE_V1_5`None
    * `REMOTE_V2`None
    """

    __schema__ = schema
    __choices__ = ("CLOUD_V1", "CLOUD_V2", "REMOTE_V1", "REMOTE_V1_5", "REMOTE_V2")


class DataCollectorScheduleModelDeleteReason(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AGENT_TRACE_TABLE_DELETED`: agent_trace_table_deleted
    * `CONNECTION_DELETED`: connection_deleted
    * `DEPRECATED_JOB_TYPE`: deprecated_job_type
    * `MONITOR_DELETED`: monitor_deleted
    * `NO_AGENT`: no_agent
    * `NO_COLLECTOR`: no_collector
    * `RULE_DELETED`: rule_deleted
    * `SIZE_COLLECTION_DISABLED`: size_collection_disabled
    """

    __schema__ = schema
    __choices__ = (
        "AGENT_TRACE_TABLE_DELETED",
        "CONNECTION_DELETED",
        "DEPRECATED_JOB_TYPE",
        "MONITOR_DELETED",
        "NO_AGENT",
        "NO_COLLECTOR",
        "RULE_DELETED",
        "SIZE_COLLECTION_DISABLED",
    )


class DataCollectorScheduleModelScheduleType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DYNAMIC`: Dynamic
    * `FIXED`: Fixed
    * `LOOSE`: Loose
    * `MANUAL`: Manual
    """

    __schema__ = schema
    __choices__ = ("DYNAMIC", "FIXED", "LOOSE", "MANUAL")


class DataCollectorScheduleModelSkipReason(sgqlc.types.Enum):
    """Enumeration Choices:

    * `MANUALLY_SKIPPED`: Manually skipped
    * `NONE`: Empty reason
    """

    __schema__ = schema
    __choices__ = ("MANUALLY_SKIPPED", "NONE")


class DataColumnTypes(sgqlc.types.Enum):
    """Available types for column values.

    Enumeration Choices:

    * `CHART`None
    * `DATE_TIME`None
    * `HOURS`None
    * `NUMERIC`None
    * `PERCENTAGE`None
    * `TEXT`None
    """

    __schema__ = schema
    __choices__ = ("CHART", "DATE_TIME", "HOURS", "NUMERIC", "PERCENTAGE", "TEXT")


class DataExplorerWidgetModelWidgetType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DISCRETE`: DISCRETE
    * `FIELD_PROFILE_TABLE_V2`: FIELD_PROFILE_TABLE_V2
    * `NUMERIC_DESCRIPTIVE_STATS`: NUMERIC_DESCRIPTIVE_STATS
    * `TIMESTAMP_HISTOGRAM`: TIMESTAMP_HISTOGRAM
    """

    __schema__ = schema
    __choices__ = (
        "DISCRETE",
        "FIELD_PROFILE_TABLE_V2",
        "NUMERIC_DESCRIPTIVE_STATS",
        "TIMESTAMP_HISTOGRAM",
    )


class DataExportNames(sgqlc.types.Enum):
    """Available Data Exports.

    Enumeration Choices:

    * `ALERTS`: Export containing all alerts data in the past 90 days
    * `ALERTS_AND_EVENTS`: Export containing both alerts and events
      data
    * `ALL_MONITORS`: DEPRECATED
    * `ASSETS`: Export containing all assets data
    * `EVENTS`: Export containing all events data in the past 90 days
    * `LINEAGE_EDGES`: Export containing lineage edges data. (This
      report is not generally available.)
    * `MONITORS`: Export containing all monitors data
    """

    __schema__ = schema
    __choices__ = (
        "ALERTS",
        "ALERTS_AND_EVENTS",
        "ALL_MONITORS",
        "ASSETS",
        "EVENTS",
        "LINEAGE_EDGES",
        "MONITORS",
    )


class DataMaintenanceMetric(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ALL`None
    * `DT_METRICS`None
    * `FH_METRICS`None
    * `FRESHNESS`None
    * `METRIC_MONITOR`None
    * `MONITOR`None
    * `UNCHANGED_SIZE`None
    * `VOLUME`None
    """

    __schema__ = schema
    __choices__ = (
        "ALL",
        "DT_METRICS",
        "FH_METRICS",
        "FRESHNESS",
        "METRIC_MONITOR",
        "MONITOR",
        "UNCHANGED_SIZE",
        "VOLUME",
    )


class DataMaintenanceReasonType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CUSTOM`None
    * `HOLIDAY`None
    * `TRAINING`None
    """

    __schema__ = schema
    __choices__ = ("CUSTOM", "HOLIDAY", "TRAINING")


class DataProductMetric(sgqlc.types.Enum):
    """Metrics for data products

    Enumeration Choices:

    * `INCIDENTS_BY_DAY`None
    * `INCIDENTS_BY_HOUR`None
    * `INCIDENTS_BY_PRIORITY`None
    * `INCIDENTS_BY_SEVERITY`None
    * `INCIDENTS_BY_STATUS`None
    * `INCIDENTS_STATUS_UPDATE_RATES_BY_DAY`None
    * `INCIDENTS_STATUS_UPDATE_RATES_BY_HOUR`None
    * `INCIDENTS_TIME_TO_FIXED_BY_DAY`None
    * `INCIDENTS_TIME_TO_FIXED_BY_HOUR`None
    * `INCIDENTS_TIME_TO_RESPONSE_BY_DAY`None
    * `INCIDENTS_TIME_TO_RESPONSE_BY_HOUR`None
    * `TABLE_UPTIME_FOR_AUTOMATED_FRESHNESS_MONITORS_BY_DAY`None
    * `TABLE_UPTIME_FOR_AUTOMATED_FRESHNESS_MONITORS_BY_HOUR`None
    * `TABLE_UPTIME_FOR_AUTOMATED_VOLUME_MONITORS_BY_DAY`None
    * `TABLE_UPTIME_FOR_AUTOMATED_VOLUME_MONITORS_BY_HOUR`None
    * `TABLE_UPTIME_FOR_CUSTOM_FRESHNESS_MONITORS_BY_DAY`None
    * `TABLE_UPTIME_FOR_CUSTOM_FRESHNESS_MONITORS_BY_HOUR`None
    * `TABLE_UPTIME_FOR_CUSTOM_SQL_MONITORS_BY_DAY`None
    * `TABLE_UPTIME_FOR_CUSTOM_SQL_MONITORS_BY_HOUR`None
    * `TABLE_UPTIME_FOR_CUSTOM_VOLUME_MONITORS_BY_DAY`None
    * `TABLE_UPTIME_FOR_CUSTOM_VOLUME_MONITORS_BY_HOUR`None
    * `TABLE_UPTIME_FOR_FIELD_HEALTH_MONITORS_BY_DAY`None
    * `TABLE_UPTIME_FOR_FIELD_HEALTH_MONITORS_BY_HOUR`None
    """

    __schema__ = schema
    __choices__ = (
        "INCIDENTS_BY_DAY",
        "INCIDENTS_BY_HOUR",
        "INCIDENTS_BY_PRIORITY",
        "INCIDENTS_BY_SEVERITY",
        "INCIDENTS_BY_STATUS",
        "INCIDENTS_STATUS_UPDATE_RATES_BY_DAY",
        "INCIDENTS_STATUS_UPDATE_RATES_BY_HOUR",
        "INCIDENTS_TIME_TO_FIXED_BY_DAY",
        "INCIDENTS_TIME_TO_FIXED_BY_HOUR",
        "INCIDENTS_TIME_TO_RESPONSE_BY_DAY",
        "INCIDENTS_TIME_TO_RESPONSE_BY_HOUR",
        "TABLE_UPTIME_FOR_AUTOMATED_FRESHNESS_MONITORS_BY_DAY",
        "TABLE_UPTIME_FOR_AUTOMATED_FRESHNESS_MONITORS_BY_HOUR",
        "TABLE_UPTIME_FOR_AUTOMATED_VOLUME_MONITORS_BY_DAY",
        "TABLE_UPTIME_FOR_AUTOMATED_VOLUME_MONITORS_BY_HOUR",
        "TABLE_UPTIME_FOR_CUSTOM_FRESHNESS_MONITORS_BY_DAY",
        "TABLE_UPTIME_FOR_CUSTOM_FRESHNESS_MONITORS_BY_HOUR",
        "TABLE_UPTIME_FOR_CUSTOM_SQL_MONITORS_BY_DAY",
        "TABLE_UPTIME_FOR_CUSTOM_SQL_MONITORS_BY_HOUR",
        "TABLE_UPTIME_FOR_CUSTOM_VOLUME_MONITORS_BY_DAY",
        "TABLE_UPTIME_FOR_CUSTOM_VOLUME_MONITORS_BY_HOUR",
        "TABLE_UPTIME_FOR_FIELD_HEALTH_MONITORS_BY_DAY",
        "TABLE_UPTIME_FOR_FIELD_HEALTH_MONITORS_BY_HOUR",
    )


class DataShareType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `SNOWFLAKE`None
    """

    __schema__ = schema
    __choices__ = ("SNOWFLAKE",)


class DataSourceType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `SQL`None
    * `TABLE`None
    """

    __schema__ = schema
    __choices__ = ("SQL", "TABLE")


class DatabricksJobRunModelStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BLOCKED`: BLOCKED
    * `CANCELLED`: CANCELLED
    * `ERROR`: ERROR
    * `FAILED`: FAILED
    * `SKIPPED`: SKIPPED
    * `SUCCEEDED`: SUCCEEDED
    * `TIMED_OUT`: TIMED_OUT
    """

    __schema__ = schema
    __choices__ = ("BLOCKED", "CANCELLED", "ERROR", "FAILED", "SKIPPED", "SUCCEEDED", "TIMED_OUT")


class DatabricksTaskRunModelStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BLOCKED`: BLOCKED
    * `CANCELLED`: CANCELLED
    * `ERROR`: ERROR
    * `FAILED`: FAILED
    * `SKIPPED`: SKIPPED
    * `SUCCEEDED`: SUCCEEDED
    * `TIMED_OUT`: TIMED_OUT
    """

    __schema__ = schema
    __choices__ = ("BLOCKED", "CANCELLED", "ERROR", "FAILED", "SKIPPED", "SUCCEEDED", "TIMED_OUT")


Date = sgqlc.types.datetime.Date

DateTime = sgqlc.types.datetime.DateTime


class DbtJobExecutionStatuses(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CANCELLED`None
    * `ERROR`None
    * `FAILED`None
    * `RUNNING`None
    * `SUCCESS`None
    """

    __schema__ = schema
    __choices__ = ("CANCELLED", "ERROR", "FAILED", "RUNNING", "SUCCESS")


class DbtProjectModelSource(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CLI`: CLI
    * `DBT_CLOUD`: dbt Cloud
    * `DBT_CORE`: dbt Core
    """

    __schema__ = schema
    __choices__ = ("CLI", "DBT_CLOUD", "DBT_CORE")


class DecryptionServiceTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `KMS`None
    """

    __schema__ = schema
    __choices__ = ("KMS",)


class DecryptionServiceUpdateTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `KMS`None
    """

    __schema__ = schema
    __choices__ = ("KMS",)


class DenialReason(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ENTITLEMENTS`None
    * `INVALID_USER`None
    * `TROUBLESHOOTING_AGENT_OFF`None
    * `TSA_FEATURE_FLAG_OFF`None
    """

    __schema__ = schema
    __choices__ = (
        "ENTITLEMENTS",
        "INVALID_USER",
        "TROUBLESHOOTING_AGENT_OFF",
        "TSA_FEATURE_FLAG_OFF",
    )


class DetectorStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ACTIVE`None
    * `INACTIVE`None
    * `TRAINING`None
    """

    __schema__ = schema
    __choices__ = ("ACTIVE", "INACTIVE", "TRAINING")


class ETLAssetType(sgqlc.types.Enum):
    """Enum to distinguish between jobs and tasks

    Enumeration Choices:

    * `JOB`None
    * `TASK`None
    """

    __schema__ = schema
    __choices__ = ("JOB", "TASK")


class EdgeType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `IS_DOWNSTREAM`None
    * `IS_READ_BY`None
    * `MODIFIES`None
    """

    __schema__ = schema
    __choices__ = ("IS_DOWNSTREAM", "IS_READ_BY", "MODIFIES")


class EntitlementLimits(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DAILY_API_CALLS`None
    * `DATA_PRODUCTS`None
    * `DOMAINS`None
    * `MONITORED_TABLES`None
    * `USERS`None
    """

    __schema__ = schema
    __choices__ = ("DAILY_API_CALLS", "DATA_PRODUCTS", "DOMAINS", "MONITORED_TABLES", "USERS")


class EntitlementTypes(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ADVANCED_NETWORKING`None
    * `ADVANCED_SECURITY`None
    * `ADVANCED_SECURITY_V1_2`None
    * `API_CALLS`None
    * `AUDIT_LOGGING`None
    * `AUTH_GROUP_CONNECTION_RESTRICTION`None
    * `DATA_LAKES`None
    * `DATA_MESH`None
    * `EDW`None
    * `ENTERPRISE_PRODUCTIVITY`None
    * `ENTERPRISE_SUPPORT`None
    * `GEN_AI_PIPELINES`None
    * `INGESTED_TABLES`None
    * `MONITORED_TABLES`None
    * `MULTI_WORKSPACE`None
    * `SSO`None
    * `TRANSACTIONAL_DATABASES`None
    * `USERS`None
    """

    __schema__ = schema
    __choices__ = (
        "ADVANCED_NETWORKING",
        "ADVANCED_SECURITY",
        "ADVANCED_SECURITY_V1_2",
        "API_CALLS",
        "AUDIT_LOGGING",
        "AUTH_GROUP_CONNECTION_RESTRICTION",
        "DATA_LAKES",
        "DATA_MESH",
        "EDW",
        "ENTERPRISE_PRODUCTIVITY",
        "ENTERPRISE_SUPPORT",
        "GEN_AI_PIPELINES",
        "INGESTED_TABLES",
        "MONITORED_TABLES",
        "MULTI_WORKSPACE",
        "SSO",
        "TRANSACTIONAL_DATABASES",
        "USERS",
    )


class EtlDurationTrendIssue(sgqlc.types.Enum):
    """Represents potential reasons why the duration trend cannot be
    calculated.

    Enumeration Choices:

    * `NO_SUCCESS_RUNS_LAST_7_DAYS`: No successful completed runs in
      the last 7 days
    * `NO_SUCCESS_RUNS_PREVIOUS_7_DAYS`: No successful completed runs
      in the 7 days prior to the last 7 days
    * `ZERO_DURATION_LAST_7_DAYS`: All successful completed runs in
      the last 7 days have zero duration
    """

    __schema__ = schema
    __choices__ = (
        "NO_SUCCESS_RUNS_LAST_7_DAYS",
        "NO_SUCCESS_RUNS_PREVIOUS_7_DAYS",
        "ZERO_DURATION_LAST_7_DAYS",
    )


class EtlPerformanceSortDirection(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ASC`None
    * `DESC`None
    """

    __schema__ = schema
    __choices__ = ("ASC", "DESC")


class EtlRunStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BLOCKED`None
    * `CANCELLED`None
    * `CANCELLING`None
    * `DEFERRED`None
    * `ERROR`None
    * `FAIL`None
    * `FAILED`None
    * `INACTIVE`None
    * `IN_PROGRESS`None
    * `PARTIAL_SUCCESS`None
    * `PASS`None
    * `QUEUED`None
    * `REMOVED`None
    * `RESTARTING`None
    * `SCHEDULED`None
    * `SKIPPED`None
    * `SUCCESS`None
    * `TIMED_OUT`None
    * `UNKNOWN`None
    * `UPSTREAM_FAILED`None
    * `UP_FOR_RESCHEDULE`None
    * `UP_FOR_RETRY`None
    * `WARN`None
    """

    __schema__ = schema
    __choices__ = (
        "BLOCKED",
        "CANCELLED",
        "CANCELLING",
        "DEFERRED",
        "ERROR",
        "FAIL",
        "FAILED",
        "INACTIVE",
        "IN_PROGRESS",
        "PARTIAL_SUCCESS",
        "PASS",
        "QUEUED",
        "REMOVED",
        "RESTARTING",
        "SCHEDULED",
        "SKIPPED",
        "SUCCESS",
        "TIMED_OUT",
        "UNKNOWN",
        "UPSTREAM_FAILED",
        "UP_FOR_RESCHEDULE",
        "UP_FOR_RETRY",
        "WARN",
    )


class EtlType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AIRFLOW`None
    * `AZURE_DATA_FACTORY`None
    * `DATABRICKS`None
    * `DBT`None
    * `FIVETRAN`None
    * `INFORMATICA`None
    """

    __schema__ = schema
    __choices__ = ("AIRFLOW", "AZURE_DATA_FACTORY", "DATABRICKS", "DBT", "FIVETRAN", "INFORMATICA")


class EventModelEventState(sgqlc.types.Enum):
    """Enumeration Choices:

    * `FALSE_POSITIVE`: FALSE POSITIVE
    * `MUTED`: MUTED
    * `NOTIFIED`: NOTIFIED
    * `NO_ACTION_REQUIRED`: NO ACTION REQUIRED
    * `OPEN`: OPEN
    * `RESOLVED`: RESOLVED
    * `STALE`: STALE
    * `SYSTEM_RESOLVED`: RESOLVED
    * `TIMELINE`: Timeline event status
    * `USER_RESOLVED`: RESOLVED
    """

    __schema__ = schema
    __choices__ = (
        "FALSE_POSITIVE",
        "MUTED",
        "NOTIFIED",
        "NO_ACTION_REQUIRED",
        "OPEN",
        "RESOLVED",
        "STALE",
        "SYSTEM_RESOLVED",
        "TIMELINE",
        "USER_RESOLVED",
    )


class EventModelEventType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ADF_JOB_FAILURE`: Data Factory Pipeline Failure
    * `AGENT_ANOM`: Agent Anomaly
    * `AIRFLOW_DAG_FAILURE`: Airflow DAG Failure
    * `COMMENT`: Timeline Comment
    * `COMPARISON_RULE_ANOM`: Comparison Rule Anomaly
    * `CUSTOM_RULE_ANOM`: Custom Rule Anomaly
    * `DATABRICKS_JOB_FAILURE`: Databricks Job Failure
    * `DBT_MODEL_ERROR`: dbt Model Error
    * `DBT_SEED_ERROR`: dbt Seed Error
    * `DBT_SNAPSHOT_ERROR`: dbt Snapshot Error
    * `DBT_TEST_FAILURE`: dbt Test Failure
    * `DBT_TEST_WARNING`: dbt Test Warning
    * `DECLARED_INCIDENT_SEVERITY_UPDATE`: Incident Severity Update
    * `DELETE_TABLE`: Delete Table
    * `DIST_ANOM`: Distribution Anomaly
    * `FRESH_ANOM`: Freshness Anomaly
    * `INACTIVE_MONITOR`: Inactive Monitor
    * `INCIDENT_DETECTOR_FEEDBACK`: Detector Feedback
    * `INCIDENT_MERGE`: Incident Merge
    * `INCIDENT_NAME_UPDATE`: Incident Name Update
    * `INCIDENT_OWNER_UPDATE`: Incident Owner Update
    * `INCIDENT_REACTION`: Incident Reaction
    * `INCIDENT_SEVERITY_UPDATE`: Incident Severity Update
    * `INCIDENT_SLACK_THREAD`: Incident Slack Thread
    * `INCIDENT_SPLIT`: Incident Split
    * `INCIDENT_STATUS_UPDATE`: Incident Status Update
    * `JSON_SCHEMA_CHANGE`: JSON Schema Change
    * `METRIC_ANOM`: Metric Anomaly
    * `METRIC_COMPARISON_ANOM`: Metric Comparison Anomaly
    * `QUERY_PERFORMANCE_ANOM`: Query Performance Anomaly
    * `QUERY_RUNTIME_ANOM`: Query Runtime Anomaly
    * `RULE_RUN_FAILURE`: Rule Run Failure
    * `SCHEMA_CHANGE`: Schema Change
    * `SIZE_ANOM`: Size Anomaly
    * `SIZE_DIFF`: Row count anomaly
    * `UNCHANGED_SIZE_ANOM`: Unchanged Size Anomaly
    * `VALIDATION_ANOM`: Validation Anomaly
    """

    __schema__ = schema
    __choices__ = (
        "ADF_JOB_FAILURE",
        "AGENT_ANOM",
        "AIRFLOW_DAG_FAILURE",
        "COMMENT",
        "COMPARISON_RULE_ANOM",
        "CUSTOM_RULE_ANOM",
        "DATABRICKS_JOB_FAILURE",
        "DBT_MODEL_ERROR",
        "DBT_SEED_ERROR",
        "DBT_SNAPSHOT_ERROR",
        "DBT_TEST_FAILURE",
        "DBT_TEST_WARNING",
        "DECLARED_INCIDENT_SEVERITY_UPDATE",
        "DELETE_TABLE",
        "DIST_ANOM",
        "FRESH_ANOM",
        "INACTIVE_MONITOR",
        "INCIDENT_DETECTOR_FEEDBACK",
        "INCIDENT_MERGE",
        "INCIDENT_NAME_UPDATE",
        "INCIDENT_OWNER_UPDATE",
        "INCIDENT_REACTION",
        "INCIDENT_SEVERITY_UPDATE",
        "INCIDENT_SLACK_THREAD",
        "INCIDENT_SPLIT",
        "INCIDENT_STATUS_UPDATE",
        "JSON_SCHEMA_CHANGE",
        "METRIC_ANOM",
        "METRIC_COMPARISON_ANOM",
        "QUERY_PERFORMANCE_ANOM",
        "QUERY_RUNTIME_ANOM",
        "RULE_RUN_FAILURE",
        "SCHEMA_CHANGE",
        "SIZE_ANOM",
        "SIZE_DIFF",
        "UNCHANGED_SIZE_ANOM",
        "VALIDATION_ANOM",
    )


class EventMutingRuleModelRuleType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `EXACT_MATCH_RULE`None
    * `REGEX_RULE`None
    """

    __schema__ = schema
    __choices__ = ("EXACT_MATCH_RULE", "REGEX_RULE")


class EventRcaStatusModelReason(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BAD_METRIC_EXPRESSION`: Bad metric expression
    * `BAD_RULE_CONFIGURATION`: Mostly for MaC monitors which where
      configured incorrectly
    * `BASELINE_SAMPLE_INSUFFICIENT`: Baseline sample too small to run
      analysis.
    * `BREACHES_SAMPLE_INSUFFICIENT`: Breaches sample too small to run
      analysis.
    * `CONNECTION_NOT_SUPPORTED`: Connection not supported
    * `DATA_SAMPLING_DISABLED`: Data Sampling disabled for warehouse
    * `DOES_NOT_MEET_CRITERIA`: Does not meet criteria
    * `DUPLICATE_EVENT`: Equivalent event already processed
    * `EVENT_MISSING_INCIDENT`: Event missing incident
    * `EVENT_MISSING_TABLE`: Event missing associated table
    * `HIGH_BREACHING_MONITOR`: Do not create RCAs for high breaching
      monitors
    * `MISSING_EVENT_WAREHOUSE`: Missing event warehouse connection.
    * `NOT_ENOUGH_BREACHES_DATA_RETURNED`: Not enough breaches data
      returned for correlation analysis
    * `NOT_ENOUGH_DATA_RETURNED`: Not enough data (breaches and normal
      rows) returned for correlation analysis
    * `NOT_ENOUGH_NORM_DATA_RETURNED`: Not enough normal data returned
      for correlation analysis
    * `NO_EXPLANATORY_FIELDS`: Unable to identify explanatory fields
    * `NO_HISTORY_ACCESS_METHOD_SELECTED`: No relevant history access
      method could be selected
    * `NO_TIME_FIELDS`: Unable to identify time fields
    * `PERMISSION_FAILURE`: Failure due to insufficient permissions
    * `QUERY_TIMEOUT`: RCA query timeout
    * `RCA_QUOTA_EXCEEDED`: RCA quota exceeded. Not running.
    * `RESOURCES_EXCEEDED`: Resources exceeded when running query.
    * `S3_OBJECT_WRITER_NOT_SUPPORTED`: S3 object writer not supported
    * `SQL_COMPILATION_ERROR`: Error in SQL RCA query.
    * `TABLE_TYPE_NOT_SUPPORTED`: Table type not supported
    * `UNKNOWN`: RCA failure needs further investigation to determine
      failure cause.
    * `WAREHOUSE_DISABLED`: Warehouse disabled for RCA
    * `WAREHOUSE_NOT_SUPPORTED`: RCA warehouse not supported
    """

    __schema__ = schema
    __choices__ = (
        "BAD_METRIC_EXPRESSION",
        "BAD_RULE_CONFIGURATION",
        "BASELINE_SAMPLE_INSUFFICIENT",
        "BREACHES_SAMPLE_INSUFFICIENT",
        "CONNECTION_NOT_SUPPORTED",
        "DATA_SAMPLING_DISABLED",
        "DOES_NOT_MEET_CRITERIA",
        "DUPLICATE_EVENT",
        "EVENT_MISSING_INCIDENT",
        "EVENT_MISSING_TABLE",
        "HIGH_BREACHING_MONITOR",
        "MISSING_EVENT_WAREHOUSE",
        "NOT_ENOUGH_BREACHES_DATA_RETURNED",
        "NOT_ENOUGH_DATA_RETURNED",
        "NOT_ENOUGH_NORM_DATA_RETURNED",
        "NO_EXPLANATORY_FIELDS",
        "NO_HISTORY_ACCESS_METHOD_SELECTED",
        "NO_TIME_FIELDS",
        "PERMISSION_FAILURE",
        "QUERY_TIMEOUT",
        "RCA_QUOTA_EXCEEDED",
        "RESOURCES_EXCEEDED",
        "S3_OBJECT_WRITER_NOT_SUPPORTED",
        "SQL_COMPILATION_ERROR",
        "TABLE_TYPE_NOT_SUPPORTED",
        "UNKNOWN",
        "WAREHOUSE_DISABLED",
        "WAREHOUSE_NOT_SUPPORTED",
    )


class ExecDashboardMetrics(sgqlc.types.Enum):
    """Available executive dashboard metrics.      For series, we
    use the plural. Ex: INCIDENTS_COUNTS, vs. singular for single. Ex:
    TABLES_COUNT

    Enumeration Choices:

    * `DAILY_MUTED_TABLES_COUNTS`None
    * `DAILY_NON_MUTED_TABLES_COUNTS`None
    * `DAILY_TABLES_COUNTS`None
    * `DECLARED_INCIDENTS_BY_SEVERITY_AND_TYPE_COUNTS`None
    * `DECLARED_INCIDENTS_BY_SEVERITY_COUNTS`None
    * `DECLARED_INCIDENTS_COUNTS`None
    * `DECLARED_INCIDENTS_TIME_TO_RESOLVED`None
    * `FIELD_MONITOR_UPTIME_PCT`None
    * `FRESHNESS_UPTIME_PCT`None
    * `INCIDENTS_COUNTS`None
    * `INCIDENTS_MEDIAN_TIME_TO_FIRST_RESPONSE`None
    * `INCIDENTS_MEDIAN_TIME_TO_RESOLUTION`None
    * `INCIDENTS_STATUS_UPDATE_RATE`None
    * `MONITORS_CREATED_COUNT`None
    * `MONITORS_INCIDENTS_COUNTS`None
    * `OOTB_FRESHNESS_UPTIME_PCT`None
    * `OOTB_VOLUME_UPTIME_PCT`None
    * `SQL_RULES_UPTIME_PCT`None
    * `STACK_SUMMARY`None
    * `USER_APP_VIEWS_COUNTS`None
    * `USER_PAGE_VIEWS_COUNTS`None
    * `USER_VISITS_COUNTS`None
    * `VOLUME_UPTIME_PCT`None
    """

    __schema__ = schema
    __choices__ = (
        "DAILY_MUTED_TABLES_COUNTS",
        "DAILY_NON_MUTED_TABLES_COUNTS",
        "DAILY_TABLES_COUNTS",
        "DECLARED_INCIDENTS_BY_SEVERITY_AND_TYPE_COUNTS",
        "DECLARED_INCIDENTS_BY_SEVERITY_COUNTS",
        "DECLARED_INCIDENTS_COUNTS",
        "DECLARED_INCIDENTS_TIME_TO_RESOLVED",
        "FIELD_MONITOR_UPTIME_PCT",
        "FRESHNESS_UPTIME_PCT",
        "INCIDENTS_COUNTS",
        "INCIDENTS_MEDIAN_TIME_TO_FIRST_RESPONSE",
        "INCIDENTS_MEDIAN_TIME_TO_RESOLUTION",
        "INCIDENTS_STATUS_UPDATE_RATE",
        "MONITORS_CREATED_COUNT",
        "MONITORS_INCIDENTS_COUNTS",
        "OOTB_FRESHNESS_UPTIME_PCT",
        "OOTB_VOLUME_UPTIME_PCT",
        "SQL_RULES_UPTIME_PCT",
        "STACK_SUMMARY",
        "USER_APP_VIEWS_COUNTS",
        "USER_PAGE_VIEWS_COUNTS",
        "USER_VISITS_COUNTS",
        "VOLUME_UPTIME_PCT",
    )


class ExecDashboardTables(sgqlc.types.Enum):
    """Available executive dashboard tables.

    Enumeration Choices:

    * `DOMAINS_TABLE`None
    * `MONITORS_TABLE`None
    * `USERS_TABLE`None
    """

    __schema__ = schema
    __choices__ = ("DOMAINS_TABLE", "MONITORS_TABLE", "USERS_TABLE")


class FacetType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BI_TYPES`None
    * `DATASETS`None
    * `DATA_PRODUCTS`None
    * `ETL_TYPES`None
    * `PROJECTS`None
    * `RESOURCE_TYPES`None
    * `TAGS`None
    * `TAG_NAMES`None
    * `TAG_VALUES`None
    * `WAREHOUSE_TYPES`None
    """

    __schema__ = schema
    __choices__ = (
        "BI_TYPES",
        "DATASETS",
        "DATA_PRODUCTS",
        "ETL_TYPES",
        "PROJECTS",
        "RESOURCE_TYPES",
        "TAGS",
        "TAG_NAMES",
        "TAG_VALUES",
        "WAREHOUSE_TYPES",
    )


class FieldConfigType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `FIRST`None
    * `LAST`None
    """

    __schema__ = schema
    __choices__ = ("FIRST", "LAST")


class FieldHealthMetrics(sgqlc.types.Enum):
    """Field Health monitor opt-in metrics.

    Enumeration Choices:

    * `EMPTY_STRING_RATE`None
    * `FALSE_RATE`None
    * `FUTURE_TIMESTAMP_RATE`None
    * `NAN_RATE`None
    * `NEGATIVE_RATE`None
    * `NULL_RATE`None
    * `NUMERIC_MAX`None
    * `NUMERIC_MEAN`None
    * `NUMERIC_MEDIAN`None
    * `NUMERIC_MIN`None
    * `NUMERIC_QUANTILES`None
    * `NUMERIC_STDDEV`None
    * `PAST_TIMESTAMP_RATE`None
    * `PERCENTILE_20`None
    * `PERCENTILE_40`None
    * `PERCENTILE_60`None
    * `PERCENTILE_80`None
    * `TEXT_ALL_SPACE_RATE`None
    * `TEXT_EMAIL_ADDRESS_RATE`None
    * `TEXT_INT_RATE`None
    * `TEXT_MAX_LENGTH`None
    * `TEXT_MEAN_LENGTH`None
    * `TEXT_MIN_LENGTH`None
    * `TEXT_NULL_KEYWORD_RATE`None
    * `TEXT_NUMBER_RATE`None
    * `TEXT_SSN_RATE`None
    * `TEXT_STD_LENGTH`None
    * `TEXT_TIMESTAMP_RATE`None
    * `TEXT_US_PHONE_RATE`None
    * `TEXT_US_STATE_CODE_RATE`None
    * `TEXT_US_ZIP_CODE_RATE`None
    * `TEXT_UUID_RATE`None
    * `TRUE_RATE`None
    * `UNIQUE_RATE`None
    * `UNIX_ZERO_RATE`None
    * `ZERO_RATE`None
    """

    __schema__ = schema
    __choices__ = (
        "EMPTY_STRING_RATE",
        "FALSE_RATE",
        "FUTURE_TIMESTAMP_RATE",
        "NAN_RATE",
        "NEGATIVE_RATE",
        "NULL_RATE",
        "NUMERIC_MAX",
        "NUMERIC_MEAN",
        "NUMERIC_MEDIAN",
        "NUMERIC_MIN",
        "NUMERIC_QUANTILES",
        "NUMERIC_STDDEV",
        "PAST_TIMESTAMP_RATE",
        "PERCENTILE_20",
        "PERCENTILE_40",
        "PERCENTILE_60",
        "PERCENTILE_80",
        "TEXT_ALL_SPACE_RATE",
        "TEXT_EMAIL_ADDRESS_RATE",
        "TEXT_INT_RATE",
        "TEXT_MAX_LENGTH",
        "TEXT_MEAN_LENGTH",
        "TEXT_MIN_LENGTH",
        "TEXT_NULL_KEYWORD_RATE",
        "TEXT_NUMBER_RATE",
        "TEXT_SSN_RATE",
        "TEXT_STD_LENGTH",
        "TEXT_TIMESTAMP_RATE",
        "TEXT_US_PHONE_RATE",
        "TEXT_US_STATE_CODE_RATE",
        "TEXT_US_ZIP_CODE_RATE",
        "TEXT_UUID_RATE",
        "TRUE_RATE",
        "UNIQUE_RATE",
        "UNIX_ZERO_RATE",
        "ZERO_RATE",
    )


class FieldMetricCategory(sgqlc.types.Enum):
    """Enumeration Choices:

    * `COMPLETENESS`None
    * `CUSTOM`None
    * `DISTRIBUTION`None
    * `PIPELINE`None
    * `UNIQUENESS`None
    * `VALIDITY`None
    """

    __schema__ = schema
    __choices__ = ("COMPLETENESS", "CUSTOM", "DISTRIBUTION", "PIPELINE", "UNIQUENESS", "VALIDITY")


class FieldMetricType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `APPROX_DISTINCTNESS`None
    * `APPROX_DISTINCT_COUNT`None
    * `APPROX_QUANTILES`None
    * `DUPLICATE_COUNT`None
    * `EMPTY_STRING_COUNT`None
    * `EMPTY_STRING_RATE`None
    * `FALSE_COUNT`None
    * `FALSE_RATE`None
    * `FUTURE_TIMESTAMP_COUNT`None
    * `FUTURE_TIMESTAMP_RATE`None
    * `MAX_LENGTH`None
    * `MEAN_LENGTH`None
    * `MIN_LENGTH`None
    * `NAN_COUNT`None
    * `NAN_RATE`None
    * `NEGATIVE_COUNT`None
    * `NEGATIVE_RATE`None
    * `NON_NULL_COUNT`None
    * `NULL_COUNT`None
    * `NULL_RATE`None
    * `NUMERIC_MAX`None
    * `NUMERIC_MEAN`None
    * `NUMERIC_MEDIAN`None
    * `NUMERIC_MIN`None
    * `NUMERIC_QUANTILES`None
    * `NUMERIC_STDDEV`None
    * `P20`None
    * `P40`None
    * `P60`None
    * `P80`None
    * `PAST_TIMESTAMP_COUNT`None
    * `PAST_TIMESTAMP_RATE`None
    * `PERCENTILE_20`None
    * `PERCENTILE_40`None
    * `PERCENTILE_60`None
    * `PERCENTILE_80`None
    * `PMAX`None
    * `PMIN`None
    * `RELATIVE_ROW_COUNT`None
    * `ROW_COUNT`None
    * `ROW_COUNT_CHANGE`None
    * `SUM`None
    * `TEXT_ALL_SPACES_COUNT`None
    * `TEXT_ALL_SPACES_RATE`None
    * `TEXT_ALL_SPACE_COUNT`None
    * `TEXT_ALL_SPACE_RATE`None
    * `TEXT_EMAIL_ADDRESS_RATE`None
    * `TEXT_INT_RATE`None
    * `TEXT_MAX_LENGTH`None
    * `TEXT_MEAN_LENGTH`None
    * `TEXT_MIN_LENGTH`None
    * `TEXT_NOT_EMAIL_ADDRESS_COUNT`None
    * `TEXT_NOT_INT_COUNT`None
    * `TEXT_NOT_NUMBER_COUNT`None
    * `TEXT_NOT_SSN_COUNT`None
    * `TEXT_NOT_TIMESTAMP_COUNT`None
    * `TEXT_NOT_US_PHONE_COUNT`None
    * `TEXT_NOT_US_STATE_CODE_COUNT`None
    * `TEXT_NOT_US_ZIP_CODE_COUNT`None
    * `TEXT_NOT_UUID_COUNT`None
    * `TEXT_NULL_KEYWORD_COUNT`None
    * `TEXT_NULL_KEYWORD_RATE`None
    * `TEXT_NUMBER_RATE`None
    * `TEXT_SSN_RATE`None
    * `TEXT_STD_LENGTH`None
    * `TEXT_TIMESTAMP_RATE`None
    * `TEXT_US_PHONE_RATE`None
    * `TEXT_US_STATE_CODE_RATE`None
    * `TEXT_US_ZIP_CODE_RATE`None
    * `TEXT_UUID_RATE`None
    * `TIME_SINCE_LAST_ROW_COUNT_CHANGE`None
    * `TRUE_COUNT`None
    * `TRUE_RATE`None
    * `UNIQUE_COUNT`None
    * `UNIQUE_RATE`None
    * `UNIX_ZERO_COUNT`None
    * `UNIX_ZERO_RATE`None
    * `ZERO_COUNT`None
    * `ZERO_RATE`None
    """

    __schema__ = schema
    __choices__ = (
        "APPROX_DISTINCTNESS",
        "APPROX_DISTINCT_COUNT",
        "APPROX_QUANTILES",
        "DUPLICATE_COUNT",
        "EMPTY_STRING_COUNT",
        "EMPTY_STRING_RATE",
        "FALSE_COUNT",
        "FALSE_RATE",
        "FUTURE_TIMESTAMP_COUNT",
        "FUTURE_TIMESTAMP_RATE",
        "MAX_LENGTH",
        "MEAN_LENGTH",
        "MIN_LENGTH",
        "NAN_COUNT",
        "NAN_RATE",
        "NEGATIVE_COUNT",
        "NEGATIVE_RATE",
        "NON_NULL_COUNT",
        "NULL_COUNT",
        "NULL_RATE",
        "NUMERIC_MAX",
        "NUMERIC_MEAN",
        "NUMERIC_MEDIAN",
        "NUMERIC_MIN",
        "NUMERIC_QUANTILES",
        "NUMERIC_STDDEV",
        "P20",
        "P40",
        "P60",
        "P80",
        "PAST_TIMESTAMP_COUNT",
        "PAST_TIMESTAMP_RATE",
        "PERCENTILE_20",
        "PERCENTILE_40",
        "PERCENTILE_60",
        "PERCENTILE_80",
        "PMAX",
        "PMIN",
        "RELATIVE_ROW_COUNT",
        "ROW_COUNT",
        "ROW_COUNT_CHANGE",
        "SUM",
        "TEXT_ALL_SPACES_COUNT",
        "TEXT_ALL_SPACES_RATE",
        "TEXT_ALL_SPACE_COUNT",
        "TEXT_ALL_SPACE_RATE",
        "TEXT_EMAIL_ADDRESS_RATE",
        "TEXT_INT_RATE",
        "TEXT_MAX_LENGTH",
        "TEXT_MEAN_LENGTH",
        "TEXT_MIN_LENGTH",
        "TEXT_NOT_EMAIL_ADDRESS_COUNT",
        "TEXT_NOT_INT_COUNT",
        "TEXT_NOT_NUMBER_COUNT",
        "TEXT_NOT_SSN_COUNT",
        "TEXT_NOT_TIMESTAMP_COUNT",
        "TEXT_NOT_US_PHONE_COUNT",
        "TEXT_NOT_US_STATE_CODE_COUNT",
        "TEXT_NOT_US_ZIP_CODE_COUNT",
        "TEXT_NOT_UUID_COUNT",
        "TEXT_NULL_KEYWORD_COUNT",
        "TEXT_NULL_KEYWORD_RATE",
        "TEXT_NUMBER_RATE",
        "TEXT_SSN_RATE",
        "TEXT_STD_LENGTH",
        "TEXT_TIMESTAMP_RATE",
        "TEXT_US_PHONE_RATE",
        "TEXT_US_STATE_CODE_RATE",
        "TEXT_US_ZIP_CODE_RATE",
        "TEXT_UUID_RATE",
        "TIME_SINCE_LAST_ROW_COUNT_CHANGE",
        "TRUE_COUNT",
        "TRUE_RATE",
        "UNIQUE_COUNT",
        "UNIQUE_RATE",
        "UNIX_ZERO_COUNT",
        "UNIX_ZERO_RATE",
        "ZERO_COUNT",
        "ZERO_RATE",
    )


class FieldMode(sgqlc.types.Enum):
    """Enumeration Choices:

    * `NULLABLE`None
    * `REPEATED`None
    * `REQUIRED`None
    """

    __schema__ = schema
    __choices__ = ("NULLABLE", "REPEATED", "REQUIRED")


class FieldQueryType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `APPROX_DISTINCTNESS`None
    * `APPROX_DISTINCT_COUNT`None
    * `APPROX_QUANTILES`None
    * `CUSTOM`None
    * `DUPLICATE_COUNT`None
    * `EMPTY_STRING_COUNT`None
    * `EMPTY_STRING_RATE`None
    * `FALSE_COUNT`None
    * `FALSE_RATE`None
    * `FUTURE_TIMESTAMP_COUNT`None
    * `FUTURE_TIMESTAMP_RATE`None
    * `MAX_LENGTH`None
    * `MEAN_LENGTH`None
    * `MIN_LENGTH`None
    * `NAN_COUNT`None
    * `NAN_RATE`None
    * `NEGATIVE_COUNT`None
    * `NEGATIVE_RATE`None
    * `NON_NULL_COUNT`None
    * `NULL_COUNT`None
    * `NULL_RATE`None
    * `NUMERIC_MAX`None
    * `NUMERIC_MEAN`None
    * `NUMERIC_MEDIAN`None
    * `NUMERIC_MIN`None
    * `NUMERIC_QUANTILES`None
    * `NUMERIC_STDDEV`None
    * `P20`None
    * `P40`None
    * `P60`None
    * `P80`None
    * `PAST_TIMESTAMP_COUNT`None
    * `PAST_TIMESTAMP_RATE`None
    * `PERCENTILE_20`None
    * `PERCENTILE_40`None
    * `PERCENTILE_60`None
    * `PERCENTILE_80`None
    * `PMAX`None
    * `PMIN`None
    * `RELATIVE_ROW_COUNT`None
    * `ROW_COUNT`None
    * `ROW_COUNT_CHANGE`None
    * `SUM`None
    * `TEXT_ALL_SPACES_COUNT`None
    * `TEXT_ALL_SPACES_RATE`None
    * `TEXT_ALL_SPACE_COUNT`None
    * `TEXT_ALL_SPACE_RATE`None
    * `TEXT_EMAIL_ADDRESS_RATE`None
    * `TEXT_INT_RATE`None
    * `TEXT_MAX_LENGTH`None
    * `TEXT_MEAN_LENGTH`None
    * `TEXT_MIN_LENGTH`None
    * `TEXT_NOT_EMAIL_ADDRESS_COUNT`None
    * `TEXT_NOT_INT_COUNT`None
    * `TEXT_NOT_NUMBER_COUNT`None
    * `TEXT_NOT_SSN_COUNT`None
    * `TEXT_NOT_TIMESTAMP_COUNT`None
    * `TEXT_NOT_US_PHONE_COUNT`None
    * `TEXT_NOT_US_STATE_CODE_COUNT`None
    * `TEXT_NOT_US_ZIP_CODE_COUNT`None
    * `TEXT_NOT_UUID_COUNT`None
    * `TEXT_NULL_KEYWORD_COUNT`None
    * `TEXT_NULL_KEYWORD_RATE`None
    * `TEXT_NUMBER_RATE`None
    * `TEXT_SSN_RATE`None
    * `TEXT_STD_LENGTH`None
    * `TEXT_TIMESTAMP_RATE`None
    * `TEXT_US_PHONE_RATE`None
    * `TEXT_US_STATE_CODE_RATE`None
    * `TEXT_US_ZIP_CODE_RATE`None
    * `TEXT_UUID_RATE`None
    * `TIME_SINCE_LAST_ROW_COUNT_CHANGE`None
    * `TRUE_COUNT`None
    * `TRUE_RATE`None
    * `UNIQUE_COUNT`None
    * `UNIQUE_RATE`None
    * `UNIX_ZERO_COUNT`None
    * `UNIX_ZERO_RATE`None
    * `ZERO_COUNT`None
    * `ZERO_RATE`None
    """

    __schema__ = schema
    __choices__ = (
        "APPROX_DISTINCTNESS",
        "APPROX_DISTINCT_COUNT",
        "APPROX_QUANTILES",
        "CUSTOM",
        "DUPLICATE_COUNT",
        "EMPTY_STRING_COUNT",
        "EMPTY_STRING_RATE",
        "FALSE_COUNT",
        "FALSE_RATE",
        "FUTURE_TIMESTAMP_COUNT",
        "FUTURE_TIMESTAMP_RATE",
        "MAX_LENGTH",
        "MEAN_LENGTH",
        "MIN_LENGTH",
        "NAN_COUNT",
        "NAN_RATE",
        "NEGATIVE_COUNT",
        "NEGATIVE_RATE",
        "NON_NULL_COUNT",
        "NULL_COUNT",
        "NULL_RATE",
        "NUMERIC_MAX",
        "NUMERIC_MEAN",
        "NUMERIC_MEDIAN",
        "NUMERIC_MIN",
        "NUMERIC_QUANTILES",
        "NUMERIC_STDDEV",
        "P20",
        "P40",
        "P60",
        "P80",
        "PAST_TIMESTAMP_COUNT",
        "PAST_TIMESTAMP_RATE",
        "PERCENTILE_20",
        "PERCENTILE_40",
        "PERCENTILE_60",
        "PERCENTILE_80",
        "PMAX",
        "PMIN",
        "RELATIVE_ROW_COUNT",
        "ROW_COUNT",
        "ROW_COUNT_CHANGE",
        "SUM",
        "TEXT_ALL_SPACES_COUNT",
        "TEXT_ALL_SPACES_RATE",
        "TEXT_ALL_SPACE_COUNT",
        "TEXT_ALL_SPACE_RATE",
        "TEXT_EMAIL_ADDRESS_RATE",
        "TEXT_INT_RATE",
        "TEXT_MAX_LENGTH",
        "TEXT_MEAN_LENGTH",
        "TEXT_MIN_LENGTH",
        "TEXT_NOT_EMAIL_ADDRESS_COUNT",
        "TEXT_NOT_INT_COUNT",
        "TEXT_NOT_NUMBER_COUNT",
        "TEXT_NOT_SSN_COUNT",
        "TEXT_NOT_TIMESTAMP_COUNT",
        "TEXT_NOT_US_PHONE_COUNT",
        "TEXT_NOT_US_STATE_CODE_COUNT",
        "TEXT_NOT_US_ZIP_CODE_COUNT",
        "TEXT_NOT_UUID_COUNT",
        "TEXT_NULL_KEYWORD_COUNT",
        "TEXT_NULL_KEYWORD_RATE",
        "TEXT_NUMBER_RATE",
        "TEXT_SSN_RATE",
        "TEXT_STD_LENGTH",
        "TEXT_TIMESTAMP_RATE",
        "TEXT_US_PHONE_RATE",
        "TEXT_US_STATE_CODE_RATE",
        "TEXT_US_ZIP_CODE_RATE",
        "TEXT_UUID_RATE",
        "TIME_SINCE_LAST_ROW_COUNT_CHANGE",
        "TRUE_COUNT",
        "TRUE_RATE",
        "UNIQUE_COUNT",
        "UNIQUE_RATE",
        "UNIX_ZERO_COUNT",
        "UNIX_ZERO_RATE",
        "ZERO_COUNT",
        "ZERO_RATE",
    )


class FieldType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BOOLEAN`None
    * `DATE`None
    * `NUMERIC`None
    * `TEXT`None
    * `TIME`None
    * `TIME_OF_DAY`None
    * `UNKNOWN`None
    """

    __schema__ = schema
    __choices__ = ("BOOLEAN", "DATE", "NUMERIC", "TEXT", "TIME", "TIME_OF_DAY", "UNKNOWN")


class FieldValueFilterOperator(sgqlc.types.Enum):
    """Enumeration Choices:

    * `EXCLUDE`None
    * `INCLUDE`None
    """

    __schema__ = schema
    __choices__ = ("EXCLUDE", "INCLUDE")


class FilterType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BINARY`None
    * `GROUP`None
    * `SQL`None
    * `UNARY`None
    """

    __schema__ = schema
    __choices__ = ("BINARY", "GROUP", "SQL", "UNARY")


class FilterValueType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `FIELD`None
    * `LITERAL`None
    * `SQL`None
    """

    __schema__ = schema
    __choices__ = ("FIELD", "LITERAL", "SQL")


class FivetranConnectorSetupStates(sgqlc.types.Enum):
    """Defines the current setup state of a Fivetran Connector

    Enumeration Choices:

    * `BROKEN`None
    * `CONNECTED`None
    * `INCOMPLETE`None
    """

    __schema__ = schema
    __choices__ = ("BROKEN", "CONNECTED", "INCOMPLETE")


class FivetranConnectorStatuses(sgqlc.types.Enum):
    """Defines the user facing statues of Fivetran connectors.
    See: https://fivetran.com/docs/getting-started/fivetran-
    dashboard/connectors#connectorstatus

    Enumeration Choices:

    * `Active`None
    * `Broken`None
    * `Delayed`None
    * `Incomplete`None
    * `Paused`None
    """

    __schema__ = schema
    __choices__ = ("Active", "Broken", "Delayed", "Incomplete", "Paused")


class FivetranConnectorSyncStates(sgqlc.types.Enum):
    """Defines the current sync state of a Fivetran Connector

    Enumeration Choices:

    * `PAUSED`None
    * `RESCHEDULED`None
    * `SCHEDULED`None
    * `SYNCING`None
    """

    __schema__ = schema
    __choices__ = ("PAUSED", "RESCHEDULED", "SCHEDULED", "SYNCING")


class FivetranConnectorUpdateStates(sgqlc.types.Enum):
    """Defines the current data update state of a Fivetran connector

    Enumeration Choices:

    * `DELAYED`None
    * `ON_SCHEDULE`None
    """

    __schema__ = schema
    __choices__ = ("DELAYED", "ON_SCHEDULE")


Float = sgqlc.types.Float


class GenericScalar(sgqlc.types.Scalar):
    """The `GenericScalar` scalar type represents a generic GraphQL
    scalar value that could be: String, Boolean, Int, Float, List or
    Object.
    """

    __schema__ = schema


ID = sgqlc.types.ID


class IdempotentStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `COMPLETED`None
    * `ERROR`None
    * `IN_PROGRESS`None
    """

    __schema__ = schema
    __choices__ = ("COMPLETED", "ERROR", "IN_PROGRESS")


class ImportanceScoreOperator(sgqlc.types.Enum):
    """Enumeration Choices:

    * `EQ`None
    * `GT`None
    * `GTE`None
    * `LT`None
    * `LTE`None
    * `RANGE`None
    """

    __schema__ = schema
    __choices__ = ("EQ", "GT", "GTE", "LT", "LTE", "RANGE")


class IncidentCategory(sgqlc.types.Enum):
    """Categories to classify incidents

    Enumeration Choices:

    * `dbt_errors`None
    * `dimension`None
    * `field_health`None
    * `field_quality_rule`None
    * `freshness`None
    * `schema`None
    * `sql_rule`None
    * `validation`None
    * `volume`None
    """

    __schema__ = schema
    __choices__ = (
        "dbt_errors",
        "dimension",
        "field_health",
        "field_quality_rule",
        "freshness",
        "schema",
        "sql_rule",
        "validation",
        "volume",
    )


class IncidentFeedback(sgqlc.types.Enum):
    """Enumeration Choices:

    * `expected`None
    * `false_positive`None
    * `fixed`None
    * `investigating`None
    * `no_action_needed`None
    * `no_status`None
    * `work_in_progress`None
    """

    __schema__ = schema
    __choices__ = (
        "expected",
        "false_positive",
        "fixed",
        "investigating",
        "no_action_needed",
        "no_status",
        "work_in_progress",
    )


class IncidentGroupBy(sgqlc.types.Enum):
    """Enumeration Choices:

    * `STATUS`None
    * `TYPE`None
    """

    __schema__ = schema
    __choices__ = ("STATUS", "TYPE")


class IncidentModelFeedback(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ANOMALY_NORMALIZED`: Anomaly normalized
    * `EXPECTED`: Expected
    * `FALSE_POSITIVE`: False positive
    * `FIXED`: Fixed
    * `HELPFUL`: Helpful
    * `INVESTIGATING`: Acknowledged
    * `NOT_HELPFUL`: Not helpful
    * `NO_ACTION_NEEDED`: No action needed
    * `WORK_IN_PROGRESS`: Work in progress
    """

    __schema__ = schema
    __choices__ = (
        "ANOMALY_NORMALIZED",
        "EXPECTED",
        "FALSE_POSITIVE",
        "FIXED",
        "HELPFUL",
        "INVESTIGATING",
        "NOT_HELPFUL",
        "NO_ACTION_NEEDED",
        "WORK_IN_PROGRESS",
    )


class IncidentModelIncidentType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AGENT_ANOMALIES`: Agent anomalies
    * `ANOMALIES`: Anomalies
    * `CUSTOM_RULE_ANOMALIES`: Custom rule anomalies
    * `DBT_ERRORS`: dbt errors
    * `DELETED_TABLES`: Deleted tables
    * `ETL_ERRORS`: ETL errors
    * `JSON_SCHEMA_CHANGES`: JSON schema changes
    * `MERGED`: Merged alerts
    * `METRIC_ANOMALIES`: Metric anomalies
    * `METRIC_COMPARISON_ANOMALIES`: Metric Comparison Anomalies
    * `PERFORMANCE_ANOMALIES`: Performance anomalies
    * `PSEUDO_INTEGRATION_TEST`: Pseudo anomalies
    * `RULE_RUN_EXECUTION_ERROR`: Rule run failure
    * `SCHEMA_CHANGES`: Schema changes
    """

    __schema__ = schema
    __choices__ = (
        "AGENT_ANOMALIES",
        "ANOMALIES",
        "CUSTOM_RULE_ANOMALIES",
        "DBT_ERRORS",
        "DELETED_TABLES",
        "ETL_ERRORS",
        "JSON_SCHEMA_CHANGES",
        "MERGED",
        "METRIC_ANOMALIES",
        "METRIC_COMPARISON_ANOMALIES",
        "PERFORMANCE_ANOMALIES",
        "PSEUDO_INTEGRATION_TEST",
        "RULE_RUN_EXECUTION_ERROR",
        "SCHEMA_CHANGES",
    )


class IncidentModelPriority(sgqlc.types.Enum):
    """Enumeration Choices:

    * `P1`: P1
    * `P2`: P2
    * `P3`: P3
    * `P4`: P4
    * `P5`: P5
    """

    __schema__ = schema
    __choices__ = ("P1", "P2", "P3", "P4", "P5")


class IncidentSubType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `abnormal_size_change`None
    * `adf_job_failure`None
    * `agent_anomaly`None
    * `airflow_dag_failure`None
    * `comparison_rule_breach`None
    * `data_added`None
    * `data_removed`None
    * `databricks_job_failure`None
    * `dbt_model_error`None
    * `dbt_seed_error`None
    * `dbt_snapshot_error`None
    * `dbt_test_failure`None
    * `dbt_test_warning`None
    * `dimension_anomaly`None
    * `field_metrics_anomaly`None
    * `field_quality_rule_breach`None
    * `fields_added`None
    * `fields_changed`None
    * `fields_removed`None
    * `freshness_anomaly`None
    * `freshness_sli_rule_breach`None
    * `json_fields_added`None
    * `json_fields_removed`None
    * `json_schema_rule_breach`None
    * `metric_comparison_anomaly`None
    * `performance_anomaly`None
    * `sql_rule_breach`None
    * `unchanged_size`None
    * `validation_breach`None
    * `volume_anomaly`None
    * `volume_sli_rule_breach`None
    """

    __schema__ = schema
    __choices__ = (
        "abnormal_size_change",
        "adf_job_failure",
        "agent_anomaly",
        "airflow_dag_failure",
        "comparison_rule_breach",
        "data_added",
        "data_removed",
        "databricks_job_failure",
        "dbt_model_error",
        "dbt_seed_error",
        "dbt_snapshot_error",
        "dbt_test_failure",
        "dbt_test_warning",
        "dimension_anomaly",
        "field_metrics_anomaly",
        "field_quality_rule_breach",
        "fields_added",
        "fields_changed",
        "fields_removed",
        "freshness_anomaly",
        "freshness_sli_rule_breach",
        "json_fields_added",
        "json_fields_removed",
        "json_schema_rule_breach",
        "metric_comparison_anomaly",
        "performance_anomaly",
        "sql_rule_breach",
        "unchanged_size",
        "validation_breach",
        "volume_anomaly",
        "volume_sli_rule_breach",
    )


class IncidentsFilterFields(sgqlc.types.Enum):
    """Enumeration Choices:

    * `audience`None
    * `contains_key_asset`None
    * `dataset`None
    * `domain`None
    * `incident_type`None
    * `include_normalized`None
    * `jira`None
    * `opsgenie`None
    * `owner`None
    * `priority`None
    * `project`None
    * `servicenow`None
    * `severity`None
    * `status`None
    * `table`None
    * `tag`None
    """

    __schema__ = schema
    __choices__ = (
        "audience",
        "contains_key_asset",
        "dataset",
        "domain",
        "incident_type",
        "include_normalized",
        "jira",
        "opsgenie",
        "owner",
        "priority",
        "project",
        "servicenow",
        "severity",
        "status",
        "table",
        "tag",
    )


class InformaticaActivityType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `TASK`None
    * `TASK_FLOW`None
    * `UNKNOWN`None
    """

    __schema__ = schema
    __choices__ = ("TASK", "TASK_FLOW", "UNKNOWN")


Int = sgqlc.types.Int


class IntegrationKeyScope(sgqlc.types.Enum):
    """Enumeration Choices:

    * `Agent`None
    * `AirflowCallbacks`None
    * `AzureDevopsWebhook`None
    * `CircuitBreaker`None
    * `DatabricksMetadata`None
    * `DatabricksWebhook`None
    * `DbtCloudWebhook`None
    * `MCP`None
    * `S3PresignedUrl`None
    * `SCIM_v2`None
    * `Spark`None
    """

    __schema__ = schema
    __choices__ = (
        "Agent",
        "AirflowCallbacks",
        "AzureDevopsWebhook",
        "CircuitBreaker",
        "DatabricksMetadata",
        "DatabricksWebhook",
        "DbtCloudWebhook",
        "MCP",
        "S3PresignedUrl",
        "SCIM_v2",
        "Spark",
    )


class InternalJobType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AGENT_REACHABILITY`None
    * `AGENT_SPANS`None
    * `DIRECT_LINEAGE`None
    * `ETL`None
    * `JSON_SCHEMA`None
    * `METADATA`None
    * `QUERY_LOGS`None
    * `QUERY_LOGS_BOOTSTRAP`None
    * `REPORTS`None
    * `S3_METADATA_EVENTS`None
    * `S3_QL_EVENTS`None
    * `SLO`None
    * `SQL_QUERY`None
    * `STREAM_METADATA`None
    * `TABLEAU_GQL`None
    """

    __schema__ = schema
    __choices__ = (
        "AGENT_REACHABILITY",
        "AGENT_SPANS",
        "DIRECT_LINEAGE",
        "ETL",
        "JSON_SCHEMA",
        "METADATA",
        "QUERY_LOGS",
        "QUERY_LOGS_BOOTSTRAP",
        "REPORTS",
        "S3_METADATA_EVENTS",
        "S3_QL_EVENTS",
        "SLO",
        "SQL_QUERY",
        "STREAM_METADATA",
        "TABLEAU_GQL",
    )


class InvitationType(sgqlc.types.Enum):
    """Used to select the template to use for new user invites.

    Enumeration Choices:

    * `Observability`None
    """

    __schema__ = schema
    __choices__ = ("Observability",)


class IsNotMonitoredReason(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ACCOUNT_NOT_BASED_ON_MONITORING`None
    * `INGESTION_EXCLUSION_RULE_OTHER`None
    * `MONITORING_EXCLUSION_RULE_OTHER`None
    * `MONITORING_INCLUSION_MISSING_OTHER`None
    * `NON_MONITORABLE_BI`None
    * `NOT_FOUND_IN_METADATA_COLLECTION_OTHER`None
    * `NOT_MONITORABLE_OTHER`None
    * `NO_REASON_FOUND`None
    """

    __schema__ = schema
    __choices__ = (
        "ACCOUNT_NOT_BASED_ON_MONITORING",
        "INGESTION_EXCLUSION_RULE_OTHER",
        "MONITORING_EXCLUSION_RULE_OTHER",
        "MONITORING_INCLUSION_MISSING_OTHER",
        "NON_MONITORABLE_BI",
        "NOT_FOUND_IN_METADATA_COLLECTION_OTHER",
        "NOT_MONITORABLE_OTHER",
        "NO_REASON_FOUND",
    )


class JSONString(sgqlc.types.Scalar):
    """Allows use of a JSON String for input / output from the GraphQL
    schema.  Use of this type is *not recommended* as you lose the
    benefits of having a defined, static schema (one of the key
    benefits of GraphQL).
    """

    __schema__ = schema


class JobExecutionStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CANCELLED`None
    * `EVALUATING`None
    * `FAILED`None
    * `IN_PROGRESS`None
    * `SUCCESS`None
    * `TIMEOUT`None
    """

    __schema__ = schema
    __choices__ = ("CANCELLED", "EVALUATING", "FAILED", "IN_PROGRESS", "SUCCESS", "TIMEOUT")


class JobPerformanceFacet(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DBT_PROJECT`None
    * `DOMAIN`None
    * `ETL_CONTAINER`None
    * `JOB_NAME`None
    * `JOB_TYPE`None
    * `LAST_RUN_STATUS`None
    * `TAGS`None
    """

    __schema__ = schema
    __choices__ = (
        "DBT_PROJECT",
        "DOMAIN",
        "ETL_CONTAINER",
        "JOB_NAME",
        "JOB_TYPE",
        "LAST_RUN_STATUS",
        "TAGS",
    )


class JobsPerformanceSummarySort(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AVG_RUN_DURATION`None
    * `DISPLAY_NAME`None
    * `FAILURE_RATE`None
    * `INTEGRATION_TYPE`None
    * `LAST_RUN_END_TIME`None
    * `LAST_RUN_START_TIME`None
    * `LAST_RUN_STATUS`None
    * `LAST_RUN_UUID`None
    * `MCON`None
    * `RUN_COUNT`None
    * `RUN_DURATION_TREND_7D`None
    """

    __schema__ = schema
    __choices__ = (
        "AVG_RUN_DURATION",
        "DISPLAY_NAME",
        "FAILURE_RATE",
        "INTEGRATION_TYPE",
        "LAST_RUN_END_TIME",
        "LAST_RUN_START_TIME",
        "LAST_RUN_STATUS",
        "LAST_RUN_UUID",
        "MCON",
        "RUN_COUNT",
        "RUN_DURATION_TREND_7D",
    )


class LineageFilterName(sgqlc.types.Enum):
    """Enumeration Choices:

    * `OBJECT_TYPE`None
    """

    __schema__ = schema
    __choices__ = ("OBJECT_TYPE",)


class LineageFilterOperator(sgqlc.types.Enum):
    """Enumeration Choices:

    * `EXCLUDE`None
    * `INCLUDE`None
    """

    __schema__ = schema
    __choices__ = ("EXCLUDE", "INCLUDE")


class LineageGraphTraversalDirection(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BOTH`None
    * `DOWNSTREAM`None
    * `UPSTREAM`None
    """

    __schema__ = schema
    __choices__ = ("BOTH", "DOWNSTREAM", "UPSTREAM")


class LineageNodeJobDirectionType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `dest`None
    * `source`None
    """

    __schema__ = schema
    __choices__ = ("dest", "source")


class LineageNodeJobType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AIRFLOW`None
    * `AZURE_DATA_FACTORY`None
    * `CONFLUENT_KAFKA_CONNECT`None
    * `DATABRICKS`None
    * `DBT_CLOUD`None
    * `DBT_CORE`None
    * `INFORMATICA`None
    * `MSK_KAFKA_CONNECT`None
    * `SELF_HOSTED_KAFKA_CONNECT`None
    * `UNKNOWN`None
    """

    __schema__ = schema
    __choices__ = (
        "AIRFLOW",
        "AZURE_DATA_FACTORY",
        "CONFLUENT_KAFKA_CONNECT",
        "DATABRICKS",
        "DBT_CLOUD",
        "DBT_CORE",
        "INFORMATICA",
        "MSK_KAFKA_CONNECT",
        "SELF_HOSTED_KAFKA_CONNECT",
        "UNKNOWN",
    )


class LogsIntegrationType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DEFAULT`None
    """

    __schema__ = schema
    __choices__ = ("DEFAULT",)


class LookbackRange(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ONE_DAY`None
    * `ONE_HOUR`None
    * `SEVEN_DAY`None
    * `TWELVE_HOUR`None
    """

    __schema__ = schema
    __choices__ = ("ONE_DAY", "ONE_HOUR", "SEVEN_DAY", "TWELVE_HOUR")


class MetricDataType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `NUMERIC`None
    * `PERCENTAGE`None
    * `STRING`None
    """

    __schema__ = schema
    __choices__ = ("NUMERIC", "PERCENTAGE", "STRING")


class MetricMonitorSelectExpressionModelDataType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BOOLEAN`: BOOLEAN
    * `DATETIME`: DATETIME
    * `NUMERIC`: NUMERIC
    * `STRING`: STRING
    """

    __schema__ = schema
    __choices__ = ("BOOLEAN", "DATETIME", "NUMERIC", "STRING")


class MetricMonitoringBootstrapState(sgqlc.types.Enum):
    """Enumeration Choices:

    * `COMPLETED`None
    * `FAILED`None
    * `LOADING_HISTORY`None
    * `PAUSED`None
    * `PENDING`None
    * `SKIPPED_HISTORY`None
    * `TIMEOUT`None
    * `WAITING`None
    """

    __schema__ = schema
    __choices__ = (
        "COMPLETED",
        "FAILED",
        "LOADING_HISTORY",
        "PAUSED",
        "PENDING",
        "SKIPPED_HISTORY",
        "TIMEOUT",
        "WAITING",
    )


class MetricMonitoringModelPriority(sgqlc.types.Enum):
    """Enumeration Choices:

    * `P1`: P1
    * `P2`: P2
    * `P3`: P3
    * `P4`: P4
    * `P5`: P5
    """

    __schema__ = schema
    __choices__ = ("P1", "P2", "P3", "P4", "P5")


class MetricMonitoringModelType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AGENT`: Agent
    * `CATEGORIES`: Dimension
    * `HOURLY_STATS`: Statistical metrics over an hour interval
    * `JSON_SCHEMA`: JSON schema
    * `METRIC_COMPARISON`: Comparison
    * `STATS`: Metric
    """

    __schema__ = schema
    __choices__ = (
        "AGENT",
        "CATEGORIES",
        "HOURLY_STATS",
        "JSON_SCHEMA",
        "METRIC_COMPARISON",
        "STATS",
    )


class ModelExecutionTypes(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DBT`None
    """

    __schema__ = schema
    __choices__ = ("DBT",)


class MonitorAggTimeInterval(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DAY`None
    * `HOUR`None
    * `MONTH`None
    * `WEEK`None
    """

    __schema__ = schema
    __choices__ = ("DAY", "HOUR", "MONTH", "WEEK")


class MonitorBreachType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BREACHED`None
    * `NOT_BREACHED`None
    """

    __schema__ = schema
    __choices__ = ("BREACHED", "NOT_BREACHED")


class MonitorConfigurationStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ERROR`None
    * `INCOMPLETE`None
    * `NOT_RUN`None
    * `NO_TIME_AXIS`None
    * `NO_TIME_AXIS_BIG_TABLE`None
    * `SUCCESS`None
    """

    __schema__ = schema
    __choices__ = (
        "ERROR",
        "INCOMPLETE",
        "NOT_RUN",
        "NO_TIME_AXIS",
        "NO_TIME_AXIS_BIG_TABLE",
        "SUCCESS",
    )


class MonitorConfigurationStatusType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `MISCONFIGURED`None
    * `NO_STATUS`None
    * `SUCCESS`None
    """

    __schema__ = schema
    __choices__ = ("MISCONFIGURED", "NO_STATUS", "SUCCESS")


class MonitorLabelsMatchType(sgqlc.types.Enum):
    """Used to select the logical operator for matching labels

    Enumeration Choices:

    * `AND`None
    * `OR`None
    """

    __schema__ = schema
    __choices__ = ("AND", "OR")


class MonitorRecommendationModel(sgqlc.types.Enum):
    """Enumeration Choices:

    * `METRIC`None
    * `REGEX`None
    * `SEGMENTATION`None
    * `VALIDATION`None
    """

    __schema__ = schema
    __choices__ = ("METRIC", "REGEX", "SEGMENTATION", "VALIDATION")


class MonitorRecommendationType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AI_VALIDATION`None
    * `HEURISTIC`None
    """

    __schema__ = schema
    __choices__ = ("AI_VALIDATION", "HEURISTIC")


class MonitorRunStatusType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ERROR`None
    * `IN_PROGRESS`None
    * `NO_STATUS`None
    * `PAUSED`None
    * `SNOOZED`None
    * `SUCCESS`None
    """

    __schema__ = schema
    __choices__ = ("ERROR", "IN_PROGRESS", "NO_STATUS", "PAUSED", "SNOOZED", "SUCCESS")


class MonitorStatusType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ERROR`None
    * `INSUFFICIENT_DATA`None
    * `IN_PROGRESS`None
    * `IN_TRAINING`None
    * `MISCONFIGURED`None
    * `NO_STATUS`None
    * `PAUSED`None
    * `SNOOZED`None
    * `SUCCESS`None
    """

    __schema__ = schema
    __choices__ = (
        "ERROR",
        "INSUFFICIENT_DATA",
        "IN_PROGRESS",
        "IN_TRAINING",
        "MISCONFIGURED",
        "NO_STATUS",
        "PAUSED",
        "SNOOZED",
        "SUCCESS",
    )


class MonitorTrainingStatusType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `INSUFFICIENT_DATA`None
    * `IN_TRAINING`None
    * `NO_STATUS`None
    * `SUCCESS`None
    """

    __schema__ = schema
    __choices__ = ("INSUFFICIENT_DATA", "IN_TRAINING", "NO_STATUS", "SUCCESS")


class MonitoredRuleType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AllTablesMonitoringRule`None
    * `DomainMonitoringRule`None
    * `LastActivityMonitoringRule`None
    * `TableNameMonitoringRule`None
    * `TableTagMonitoringRule`None
    * `TableTypeMonitoringRule`None
    """

    __schema__ = schema
    __choices__ = (
        "AllTablesMonitoringRule",
        "DomainMonitoringRule",
        "LastActivityMonitoringRule",
        "TableNameMonitoringRule",
        "TableTagMonitoringRule",
        "TableTypeMonitoringRule",
    )


class MonitoredTableRuleJobStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `COMPLETED`None
    * `FAILED`None
    * `IN_PROGRESS`None
    * `QUEUED`None
    """

    __schema__ = schema
    __choices__ = ("COMPLETED", "FAILED", "IN_PROGRESS", "QUEUED")


class MonitoredTableRuleTableAttribute(sgqlc.types.Enum):
    """Enumeration Choices:

    * `last_activity`None
    * `read_activity`None
    * `table_id`None
    * `table_tag`None
    * `table_type`None
    * `write_activity`None
    """

    __schema__ = schema
    __choices__ = (
        "last_activity",
        "read_activity",
        "table_id",
        "table_tag",
        "table_type",
        "write_activity",
    )


class MonitoredTableRuleType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `all`None
    * `exact_match`None
    * `gt`None
    * `in`None
    * `is_null`None
    * `lte`None
    * `prefix`None
    * `substring`None
    * `suffix`None
    * `wildcard_pattern`None
    """

    __schema__ = schema
    __choices__ = (
        "all",
        "exact_match",
        "gt",
        "in",
        "is_null",
        "lte",
        "prefix",
        "substring",
        "suffix",
        "wildcard_pattern",
    )


class MutedEventType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CUSTOM_RULE_ANOM`None
    * `DELETE_TABLE`None
    * `DIST_ANOM`None
    * `FRESH_ANOM`None
    * `JSON_SCHEMA_CHANGE`None
    * `METRIC_ANOM`None
    * `QUERY_RUNTIME_ANOM`None
    * `SCHEMA_CHANGE`None
    * `SIZE_ANOM`None
    * `SIZE_DIFF`None
    * `UNCHANGED_SIZE_ANOM`None
    * `VALIDATION_ANOM`None
    """

    __schema__ = schema
    __choices__ = (
        "CUSTOM_RULE_ANOM",
        "DELETE_TABLE",
        "DIST_ANOM",
        "FRESH_ANOM",
        "JSON_SCHEMA_CHANGE",
        "METRIC_ANOM",
        "QUERY_RUNTIME_ANOM",
        "SCHEMA_CHANGE",
        "SIZE_ANOM",
        "SIZE_DIFF",
        "UNCHANGED_SIZE_ANOM",
        "VALIDATION_ANOM",
    )


class NodeType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `MODEL`None
    * `SEED`None
    * `SNAPSHOT`None
    * `SOURCE`None
    * `TEST`None
    """

    __schema__ = schema
    __choices__ = ("MODEL", "SEED", "SNAPSHOT", "SOURCE", "TEST")


class OAuthGrantTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `client_credentials`None
    * `password`None
    """

    __schema__ = schema
    __choices__ = ("client_credentials", "password")


class ObjectPropertyModelPropertySourceType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `COLLECTION`: Collection
    * `DASHBOARD`: Dashboard
    * `DATA_PRODUCT`: Data Product
    * `DBT`: DBT
    * `DOMAIN`: Domain
    * `LINEAGE_API`: Lineage API
    * `TAGS_COLLECTION`: Tags Collection
    """

    __schema__ = schema
    __choices__ = (
        "COLLECTION",
        "DASHBOARD",
        "DATA_PRODUCT",
        "DBT",
        "DOMAIN",
        "LINEAGE_API",
        "TAGS_COLLECTION",
    )


class OotbTableMonitorTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `FRESHNESS`None
    * `SCHEMA`None
    * `VOLUME_SIZE_DIFF`None
    * `VOLUME_UNCHANGED_SIZE`None
    """

    __schema__ = schema
    __choices__ = ("FRESHNESS", "SCHEMA", "VOLUME_SIZE_DIFF", "VOLUME_UNCHANGED_SIZE")


class PerformanceDashboardAccessValidationCode(sgqlc.types.Enum):
    """Performance dashboard access validation codes.

    Enumeration Choices:

    * `Admin_Disabled`None
    * `Ok`None
    * `Unauthorized`None
    * `Unsupported_Warehouse`None
    """

    __schema__ = schema
    __choices__ = ("Admin_Disabled", "Ok", "Unauthorized", "Unsupported_Warehouse")


class PeriodGrouping(sgqlc.types.Enum):
    """Time size of the periods.

    Enumeration Choices:

    * `DAY`None
    * `MONTH`None
    * `WEEK`None
    """

    __schema__ = schema
    __choices__ = ("DAY", "MONTH", "WEEK")


class Permission(sgqlc.types.Enum):
    """Currently-defined permissions.

    Enumeration Choices:

    * `CatalogAccess`None
    * `CatalogEdit`None
    * `DashboardAccess`None
    * `DashboardEdit`None
    * `DashboardEditTheirOwn`None
    * `DataExportsAccess`None
    * `DataproductsAccess`None
    * `DataproductsEdit`None
    * `DataproductsEditAll`None
    * `DataproductsEditTheirOwn`None
    * `GraphqlMutate`None
    * `GraphqlQuery`None
    * `IncidentsAccess`None
    * `IncidentsEdit`None
    * `IncidentsUpdateStatus`None
    * `MonitorsAccess`None
    * `MonitorsAggregates`None
    * `MonitorsEdit`None
    * `PerformanceAccess`None
    * `PipelinesAccess`None
    * `PipelinesEdit`None
    * `ProductsAccess`None
    * `ProductsDiscoveryAccess`None
    * `ProductsObservabilityAccess`None
    * `ProductsSamplingAccess`None
    * `SettingsAccess`None
    * `SettingsApiAccess`None
    * `SettingsApiEdit`None
    * `SettingsApiTokensManage`None
    * `SettingsBillingAccess`None
    * `SettingsCollectionPreferencesEdit`None
    * `SettingsCollectionPreferencesList`None
    * `SettingsCollectionPreferencesUpgrade`None
    * `SettingsDomainsAccess`None
    * `SettingsDomainsEdit`None
    * `SettingsDomainsList`None
    * `SettingsDomainsViewDetail`None
    * `SettingsEdit`None
    * `SettingsIntegrationsAccess`None
    * `SettingsIntegrationsEdit`None
    * `SettingsMutedDataAccess`None
    * `SettingsMutedDataEdit`None
    * `SettingsNotificationsAccess`None
    * `SettingsNotificationsEdit`None
    * `SettingsPiiFiltersEdit`None
    * `SettingsPiiFiltersList`None
    * `SettingsPiiFiltersViewMetrics`None
    * `SettingsSecretsAccess`None
    * `SettingsSecretsEdit`None
    * `SettingsSecretsValuesAccess`None
    * `SettingsUsageAccess`None
    * `SettingsUsageEdit`None
    * `SettingsUserSubscribeWeeklyDigest`None
    * `SettingsUsersAccess`None
    * `SettingsUsersEdit`None
    * `SettingsUsersEditAuthProvisioning`None
    * `SettingsUsersEditSso`None
    * `SettingsUsersManageDomainsManagers`None
    * `SettingsUsersManageOwners`None
    * `UsersList`None
    """

    __schema__ = schema
    __choices__ = (
        "CatalogAccess",
        "CatalogEdit",
        "DashboardAccess",
        "DashboardEdit",
        "DashboardEditTheirOwn",
        "DataExportsAccess",
        "DataproductsAccess",
        "DataproductsEdit",
        "DataproductsEditAll",
        "DataproductsEditTheirOwn",
        "GraphqlMutate",
        "GraphqlQuery",
        "IncidentsAccess",
        "IncidentsEdit",
        "IncidentsUpdateStatus",
        "MonitorsAccess",
        "MonitorsAggregates",
        "MonitorsEdit",
        "PerformanceAccess",
        "PipelinesAccess",
        "PipelinesEdit",
        "ProductsAccess",
        "ProductsDiscoveryAccess",
        "ProductsObservabilityAccess",
        "ProductsSamplingAccess",
        "SettingsAccess",
        "SettingsApiAccess",
        "SettingsApiEdit",
        "SettingsApiTokensManage",
        "SettingsBillingAccess",
        "SettingsCollectionPreferencesEdit",
        "SettingsCollectionPreferencesList",
        "SettingsCollectionPreferencesUpgrade",
        "SettingsDomainsAccess",
        "SettingsDomainsEdit",
        "SettingsDomainsList",
        "SettingsDomainsViewDetail",
        "SettingsEdit",
        "SettingsIntegrationsAccess",
        "SettingsIntegrationsEdit",
        "SettingsMutedDataAccess",
        "SettingsMutedDataEdit",
        "SettingsNotificationsAccess",
        "SettingsNotificationsEdit",
        "SettingsPiiFiltersEdit",
        "SettingsPiiFiltersList",
        "SettingsPiiFiltersViewMetrics",
        "SettingsSecretsAccess",
        "SettingsSecretsEdit",
        "SettingsSecretsValuesAccess",
        "SettingsUsageAccess",
        "SettingsUsageEdit",
        "SettingsUserSubscribeWeeklyDigest",
        "SettingsUsersAccess",
        "SettingsUsersEdit",
        "SettingsUsersEditAuthProvisioning",
        "SettingsUsersEditSso",
        "SettingsUsersManageDomainsManagers",
        "SettingsUsersManageOwners",
        "UsersList",
    )


class PermissionEffect(sgqlc.types.Enum):
    """Possible effects of a policy.

    Enumeration Choices:

    * `Allow`None
    * `Deny`None
    """

    __schema__ = schema
    __choices__ = ("Allow", "Deny")


class PiiFilteringFailModeType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CLOSE`None
    * `OPEN`None
    """

    __schema__ = schema
    __choices__ = ("CLOSE", "OPEN")


class PlatformServiceSupportCode(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DATA_STORE_NOT_SUPPORTED`: Data stores not supported by the
      service
    * `NEW_CONNECTIONS_NOT_SUPPORTED`: New connections not supported
      by the service
    * `REMOTE_AGENT_NOT_SUPPORTED`: Remote agents not supported by the
      service
    * `SUPPORTED`: The service supports the requested attributes
    * `UPDATE_REQUIRED`: The service needs to be updated to support
      the requested attributes
    """

    __schema__ = schema
    __choices__ = (
        "DATA_STORE_NOT_SUPPORTED",
        "NEW_CONNECTIONS_NOT_SUPPORTED",
        "REMOTE_AGENT_NOT_SUPPORTED",
        "SUPPORTED",
        "UPDATE_REQUIRED",
    )


class PlatformTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AWS`None
    * `AWS_GENERIC`None
    * `AZURE`None
    * `GCP`None
    * `SNOWFLAKE`None
    """

    __schema__ = schema
    __choices__ = ("AWS", "AWS_GENERIC", "AZURE", "GCP", "SNOWFLAKE")


class PowerBIAuthModeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `PRIMARY_USER`None
    * `SERVICE_PRINCIPAL`None
    """

    __schema__ = schema
    __choices__ = ("PRIMARY_USER", "SERVICE_PRINCIPAL")


class PowerBIAuthModeEnumV2(sgqlc.types.Enum):
    """Enumeration Choices:

    * `PRIMARY_USER`None
    * `SERVICE_PRINCIPAL`None
    """

    __schema__ = schema
    __choices__ = ("PRIMARY_USER", "SERVICE_PRINCIPAL")


class PowerBIUpdateAuthModeEnumV2(sgqlc.types.Enum):
    """Enumeration Choices:

    * `PRIMARY_USER`None
    * `SERVICE_PRINCIPAL`None
    """

    __schema__ = schema
    __choices__ = ("PRIMARY_USER", "SERVICE_PRINCIPAL")


class PredicateArity(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BINARY`None
    * `UNARY`None
    """

    __schema__ = schema
    __choices__ = ("BINARY", "UNARY")


class PredicateRequiredType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ANY`None
    * `DATE`None
    * `REGEX`None
    * `TEXT`None
    * `TIMESTAMP`None
    """

    __schema__ = schema
    __choices__ = ("ANY", "DATE", "REGEX", "TEXT", "TIMESTAMP")


class Priority(sgqlc.types.Enum):
    """Enumeration Choices:

    * `P1`None
    * `P2`None
    * `P3`None
    * `P4`None
    * `P5`None
    """

    __schema__ = schema
    __choices__ = ("P1", "P2", "P3", "P4", "P5")


class Provider(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AZURE_DEVOPS`None
    * `GITHUB`None
    * `GITLAB`None
    """

    __schema__ = schema
    __choices__ = ("AZURE_DEVOPS", "GITHUB", "GITLAB")


class ProvisioningSchema(sgqlc.types.Enum):
    """Schema version for this auth provisioning configuration.

    Enumeration Choices:

    * `SCIM_V2`None
    """

    __schema__ = schema
    __choices__ = ("SCIM_V2",)


class PullRequestFilterName(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AUTHOR`None
    * `FILE_PATH`None
    * `FULL_REPO`None
    * `REPO`None
    * `TEXT_SEARCH`None
    """

    __schema__ = schema
    __choices__ = ("AUTHOR", "FILE_PATH", "FULL_REPO", "REPO", "TEXT_SEARCH")


class QueryCategory(sgqlc.types.Enum):
    """Possible query categories

    Enumeration Choices:

    * `alter`None
    * `clone`None
    * `copy`None
    * `create_table`None
    * `create_table_as_select`None
    * `create_table_using_template`None
    * `create_view`None
    * `delete_from`None
    * `delete_using`None
    * `drop_table`None
    * `explain`None
    * `insert_into`None
    * `insert_overwrite`None
    * `load`None
    * `merge`None
    * `put`None
    * `query`None
    * `rename`None
    * `select_into`None
    * `swap`None
    * `truncate`None
    * `unload`None
    * `update`None
    """

    __schema__ = schema
    __choices__ = (
        "alter",
        "clone",
        "copy",
        "create_table",
        "create_table_as_select",
        "create_table_using_template",
        "create_view",
        "delete_from",
        "delete_using",
        "drop_table",
        "explain",
        "insert_into",
        "insert_overwrite",
        "load",
        "merge",
        "put",
        "query",
        "rename",
        "select_into",
        "swap",
        "truncate",
        "unload",
        "update",
    )


class QueryLogType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `READ`None
    * `WRITE`None
    """

    __schema__ = schema
    __choices__ = ("READ", "WRITE")


class QueryRcaType(sgqlc.types.Enum):
    """Types of query RCAs

    Enumeration Choices:

    * `AFR`None
    * `DBT_FAIL_SKIP`None
    * `EMPTY`None
    * `FAILED`None
    * `NEW`None
    * `QDR`None
    * `UPDATE`None
    * `UPSTREAM`None
    """

    __schema__ = schema
    __choices__ = ("AFR", "DBT_FAIL_SKIP", "EMPTY", "FAILED", "NEW", "QDR", "UPDATE", "UPSTREAM")


class QueryResultType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `LABELED_NUMERICS`None
    * `ROWS`None
    * `ROW_COUNT`None
    * `SINGLE_NUMERIC`None
    * `UNIQUE_ROW_COUNT`None
    * `UNIQUE_VALUE_LIST`None
    * `VALUE_LIST`None
    """

    __schema__ = schema
    __choices__ = (
        "LABELED_NUMERICS",
        "ROWS",
        "ROW_COUNT",
        "SINGLE_NUMERIC",
        "UNIQUE_ROW_COUNT",
        "UNIQUE_VALUE_LIST",
        "VALUE_LIST",
    )


class QueryType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `read`: Filter for reads on the table
    * `write`: Filter for writes to the table
    """

    __schema__ = schema
    __choices__ = ("read", "write")


class RcaJobsModelJobType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DELTA_HISTORY_SAMPLING`: Delta History sampling
    * `FIELD_QUALITY_CORRELATION`: Field Quality Rule value
      correlation
    * `METRIC_CORRELATION`: Metric (Field Health) value correlation
    * `NUMERIC_CORRELATION`: Numeric (Field Health) value correlation
    * `SIZE_DIFF_CORRELATION`: Size Diff value correlation
    * `SIZE_DIFF_SAMPLING`: Size Diff sampling
    * `SQL_RULE_BREACH_SAMPLING`: SQL rule breach sampling
    * `SQL_RULE_CUSTOM_SAMPLING`: Custom SQL monitor custom sampling
    * `SQL_RULE_PROFILING`: Custom SQL monitor sample data profiling
    """

    __schema__ = schema
    __choices__ = (
        "DELTA_HISTORY_SAMPLING",
        "FIELD_QUALITY_CORRELATION",
        "METRIC_CORRELATION",
        "NUMERIC_CORRELATION",
        "SIZE_DIFF_CORRELATION",
        "SIZE_DIFF_SAMPLING",
        "SQL_RULE_BREACH_SAMPLING",
        "SQL_RULE_CUSTOM_SAMPLING",
        "SQL_RULE_PROFILING",
    )


class RcaJobsModelStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CANCELED`: canceled
    * `EMPTY`: No root cause found
    * `EXPIRED`: expired
    * `FAILED`: RCA process has failed
    * `FOUND`: Root cause has been found
    * `PARTIAL_DATA`: partial_data
    """

    __schema__ = schema
    __choices__ = ("CANCELED", "EMPTY", "EXPIRED", "FAILED", "FOUND", "PARTIAL_DATA")


class RcaStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CANCELED`None
    * `EMPTY`None
    * `EXPIRED`None
    * `FAILED`None
    * `FOUND`None
    * `PARTIAL_DATA`None
    """

    __schema__ = schema
    __choices__ = ("CANCELED", "EMPTY", "EXPIRED", "FAILED", "FOUND", "PARTIAL_DATA")


class RelationshipType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `EXPERT`None
    * `OWNER`None
    """

    __schema__ = schema
    __choices__ = ("EXPERT", "OWNER")


class ReportStatusEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `COMPLETED`None
    * `FAILED`None
    * `QUEUED`None
    * `RUNNING`None
    """

    __schema__ = schema
    __choices__ = ("COMPLETED", "FAILED", "QUEUED", "RUNNING")


class ReportTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ALERTS_REPORT`None
    * `ASSETS_REPORT`None
    * `CONSUMPTION_REPORT`None
    * `EVENTS_REPORT`None
    * `LINEAGE_EDGES_REPORT`None
    * `MONITORS_REPORT`None
    """

    __schema__ = schema
    __choices__ = (
        "ALERTS_REPORT",
        "ASSETS_REPORT",
        "CONSUMPTION_REPORT",
        "EVENTS_REPORT",
        "LINEAGE_EDGES_REPORT",
        "MONITORS_REPORT",
    )


class ResponseMetadataType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `MONITOR_RECOMMENDATIONS`None
    * `QUERY_RESPONSE`None
    """

    __schema__ = schema
    __choices__ = ("MONITOR_RECOMMENDATIONS", "QUERY_RESPONSE")


class SamplingEnabledMetricTypes(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DUPLICATE_COUNT`None
    * `EMPTY_STRING_COUNT`None
    * `EMPTY_STRING_RATE`None
    * `FALSE_COUNT`None
    * `FALSE_RATE`None
    * `FUTURE_TIMESTAMP_COUNT`None
    * `FUTURE_TIMESTAMP_RATE`None
    * `NAN_COUNT`None
    * `NAN_RATE`None
    * `NEGATIVE_COUNT`None
    * `NEGATIVE_RATE`None
    * `NON_NULL_COUNT`None
    * `NULL_COUNT`None
    * `NULL_RATE`None
    * `NUMERIC_MAX`None
    * `NUMERIC_MEAN`None
    * `NUMERIC_MEDIAN`None
    * `NUMERIC_MIN`None
    * `NUMERIC_STDDEV`None
    * `PAST_TIMESTAMP_COUNT`None
    * `PAST_TIMESTAMP_RATE`None
    * `PERCENTILE_20`None
    * `PERCENTILE_40`None
    * `PERCENTILE_60`None
    * `PERCENTILE_80`None
    * `RELATIVE_ROW_COUNT`None
    * `ROW_COUNT_CHANGE`None
    * `SUM`None
    * `TEXT_ALL_SPACE_COUNT`None
    * `TEXT_ALL_SPACE_RATE`None
    * `TEXT_EMAIL_ADDRESS_RATE`None
    * `TEXT_INT_RATE`None
    * `TEXT_MAX_LENGTH`None
    * `TEXT_MEAN_LENGTH`None
    * `TEXT_MIN_LENGTH`None
    * `TEXT_NOT_EMAIL_ADDRESS_COUNT`None
    * `TEXT_NOT_INT_COUNT`None
    * `TEXT_NOT_NUMBER_COUNT`None
    * `TEXT_NOT_SSN_COUNT`None
    * `TEXT_NOT_TIMESTAMP_COUNT`None
    * `TEXT_NOT_US_PHONE_COUNT`None
    * `TEXT_NOT_US_STATE_CODE_COUNT`None
    * `TEXT_NOT_US_ZIP_CODE_COUNT`None
    * `TEXT_NOT_UUID_COUNT`None
    * `TEXT_NULL_KEYWORD_COUNT`None
    * `TEXT_NULL_KEYWORD_RATE`None
    * `TEXT_NUMBER_RATE`None
    * `TEXT_SSN_RATE`None
    * `TEXT_STD_LENGTH`None
    * `TEXT_TIMESTAMP_RATE`None
    * `TEXT_US_PHONE_RATE`None
    * `TEXT_US_STATE_CODE_RATE`None
    * `TEXT_US_ZIP_CODE_RATE`None
    * `TEXT_UUID_RATE`None
    * `TIME_SINCE_LAST_ROW_COUNT_CHANGE`None
    * `TRUE_COUNT`None
    * `TRUE_RATE`None
    * `UNIQUE_COUNT`None
    * `UNIQUE_RATE`None
    * `UNIX_ZERO_COUNT`None
    * `UNIX_ZERO_RATE`None
    * `ZERO_COUNT`None
    * `ZERO_RATE`None
    """

    __schema__ = schema
    __choices__ = (
        "DUPLICATE_COUNT",
        "EMPTY_STRING_COUNT",
        "EMPTY_STRING_RATE",
        "FALSE_COUNT",
        "FALSE_RATE",
        "FUTURE_TIMESTAMP_COUNT",
        "FUTURE_TIMESTAMP_RATE",
        "NAN_COUNT",
        "NAN_RATE",
        "NEGATIVE_COUNT",
        "NEGATIVE_RATE",
        "NON_NULL_COUNT",
        "NULL_COUNT",
        "NULL_RATE",
        "NUMERIC_MAX",
        "NUMERIC_MEAN",
        "NUMERIC_MEDIAN",
        "NUMERIC_MIN",
        "NUMERIC_STDDEV",
        "PAST_TIMESTAMP_COUNT",
        "PAST_TIMESTAMP_RATE",
        "PERCENTILE_20",
        "PERCENTILE_40",
        "PERCENTILE_60",
        "PERCENTILE_80",
        "RELATIVE_ROW_COUNT",
        "ROW_COUNT_CHANGE",
        "SUM",
        "TEXT_ALL_SPACE_COUNT",
        "TEXT_ALL_SPACE_RATE",
        "TEXT_EMAIL_ADDRESS_RATE",
        "TEXT_INT_RATE",
        "TEXT_MAX_LENGTH",
        "TEXT_MEAN_LENGTH",
        "TEXT_MIN_LENGTH",
        "TEXT_NOT_EMAIL_ADDRESS_COUNT",
        "TEXT_NOT_INT_COUNT",
        "TEXT_NOT_NUMBER_COUNT",
        "TEXT_NOT_SSN_COUNT",
        "TEXT_NOT_TIMESTAMP_COUNT",
        "TEXT_NOT_US_PHONE_COUNT",
        "TEXT_NOT_US_STATE_CODE_COUNT",
        "TEXT_NOT_US_ZIP_CODE_COUNT",
        "TEXT_NOT_UUID_COUNT",
        "TEXT_NULL_KEYWORD_COUNT",
        "TEXT_NULL_KEYWORD_RATE",
        "TEXT_NUMBER_RATE",
        "TEXT_SSN_RATE",
        "TEXT_STD_LENGTH",
        "TEXT_TIMESTAMP_RATE",
        "TEXT_US_PHONE_RATE",
        "TEXT_US_STATE_CODE_RATE",
        "TEXT_US_ZIP_CODE_RATE",
        "TEXT_UUID_RATE",
        "TIME_SINCE_LAST_ROW_COUNT_CHANGE",
        "TRUE_COUNT",
        "TRUE_RATE",
        "UNIQUE_COUNT",
        "UNIQUE_RATE",
        "UNIX_ZERO_COUNT",
        "UNIX_ZERO_RATE",
        "ZERO_COUNT",
        "ZERO_RATE",
    )


class ScheduleType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DYNAMIC`None
    * `FIXED`None
    * `LOOSE`None
    * `MANUAL`None
    """

    __schema__ = schema
    __choices__ = ("DYNAMIC", "FIXED", "LOOSE", "MANUAL")


class SearchCategoryEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ALL_OTHER_TABLES`None
    * `RESOLVED_TABLES`None
    """

    __schema__ = schema
    __choices__ = ("ALL_OTHER_TABLES", "RESOLVED_TABLES")


class SegmentationType(sgqlc.types.Enum):
    """Defines different types of segmentation types

    Enumeration Choices:

    * `CUSTOM_SQL_EXPRESSION`None
    * `FIELD`None
    """

    __schema__ = schema
    __choices__ = ("CUSTOM_SQL_EXPRESSION", "FIELD")


class SelfHostedCredentialsTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AWS_SECRETS_MANAGER`None
    * `ENV_VAR`None
    """

    __schema__ = schema
    __choices__ = ("AWS_SECRETS_MANAGER", "ENV_VAR")


class SelfHostedUpdateCredentialsTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AWS_SECRETS_MANAGER`None
    * `ENV_VAR`None
    """

    __schema__ = schema
    __choices__ = ("AWS_SECRETS_MANAGER", "ENV_VAR")


class SensitivityLevels(sgqlc.types.Enum):
    """Enumeration Choices:

    * `HIGH`None
    * `LOW`None
    * `MEDIUM`None
    """

    __schema__ = schema
    __choices__ = ("HIGH", "LOW", "MEDIUM")


class ServiceNowCredentialsType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `OAUTH_CLIENT_CREDENTIALS`None
    * `USERNAME_PASSWORD`None
    """

    __schema__ = schema
    __choices__ = ("OAUTH_CLIENT_CREDENTIALS", "USERNAME_PASSWORD")


class Severity(sgqlc.types.Enum):
    """Enumeration Choices:

    * `SEV_1`None
    * `SEV_2`None
    * `SEV_3`None
    * `SEV_4`None
    """

    __schema__ = schema
    __choices__ = ("SEV_1", "SEV_2", "SEV_3", "SEV_4")


class SeverityInput(sgqlc.types.Enum):
    """Enumeration Choices:

    * `NO_SEVERITY`None
    * `SEV_1`None
    * `SEV_2`None
    * `SEV_3`None
    * `SEV_4`None
    """

    __schema__ = schema
    __choices__ = ("NO_SEVERITY", "SEV_1", "SEV_2", "SEV_3", "SEV_4")


class SharedQueryTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `PERMANENT`None
    * `TEMPORARY`None
    """

    __schema__ = schema
    __choices__ = ("PERMANENT", "TEMPORARY")


class SlackAppType(sgqlc.types.Enum):
    """Defines different types of Slack apps

    Enumeration Choices:

    * `DISCOVER`None
    * `OBSERVE`None
    """

    __schema__ = schema
    __choices__ = ("DISCOVER", "OBSERVE")


class SlackCredentialsV2ModelSlackAppType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DISCOVER`: discover
    * `OBSERVE`: observe
    """

    __schema__ = schema
    __choices__ = ("DISCOVER", "OBSERVE")


class SlackEngagementEventType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CHANNEL_COMMENT`None
    * `REACTION_ADDED`None
    * `REACTION_REMOVED`None
    * `THREAD_REPLY`None
    """

    __schema__ = schema
    __choices__ = ("CHANNEL_COMMENT", "REACTION_ADDED", "REACTION_REMOVED", "THREAD_REPLY")


class SqlDialect(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ATHENA`None
    * `BIGQUERY`None
    * `CLICKHOUSE`None
    * `DATABRICKS`None
    * `DB2`None
    * `DREMIO`None
    * `HIVE`None
    * `MARIADB`None
    * `MOTHERDUCK`None
    * `MYSQL`None
    * `ORACLE`None
    * `POSTGRES`None
    * `PRESTO`None
    * `REDSHIFT`None
    * `SALESFORCE_CRM`None
    * `SALESFORCE_DATA_CLOUD`None
    * `SAPHANA`None
    * `SNOWFLAKE`None
    * `SPARK`None
    * `SQL_SERVER`None
    * `TERADATA`None
    * `TSQL`None
    * `UNKNOWN`None
    """

    __schema__ = schema
    __choices__ = (
        "ATHENA",
        "BIGQUERY",
        "CLICKHOUSE",
        "DATABRICKS",
        "DB2",
        "DREMIO",
        "HIVE",
        "MARIADB",
        "MOTHERDUCK",
        "MYSQL",
        "ORACLE",
        "POSTGRES",
        "PRESTO",
        "REDSHIFT",
        "SALESFORCE_CRM",
        "SALESFORCE_DATA_CLOUD",
        "SAPHANA",
        "SNOWFLAKE",
        "SPARK",
        "SQL_SERVER",
        "TERADATA",
        "TSQL",
        "UNKNOWN",
    )


class SqlJobCheckpointStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `EXECUTING_COMPLETE`None
    * `EXECUTING_START`None
    * `HAS_ERROR`None
    * `PROCESSING_COMPLETE`None
    * `PROCESSING_START`None
    * `REGISTERED`None
    """

    __schema__ = schema
    __choices__ = (
        "EXECUTING_COMPLETE",
        "EXECUTING_START",
        "HAS_ERROR",
        "PROCESSING_COMPLETE",
        "PROCESSING_START",
        "REGISTERED",
    )


class State(sgqlc.types.Enum):
    """Enumeration Choices:

    * `APPLIED`None
    * `FAILED`None
    * `PENDING`None
    * `SKIPPED`None
    """

    __schema__ = schema
    __choices__ = ("APPLIED", "FAILED", "PENDING", "SKIPPED")


class StatementOption(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ALL_ACCOUNT_OWNERS`None
    * `SPECIFIC_ADDRESSES`None
    """

    __schema__ = schema
    __choices__ = ("ALL_ACCOUNT_OWNERS", "SPECIFIC_ADDRESSES")


class Status(sgqlc.types.Enum):
    """Access Request status

    Enumeration Choices:

    * `NOTIFIED`None
    * `PENDING`None
    * `RESOLVED`None
    """

    __schema__ = schema
    __choices__ = ("NOTIFIED", "PENDING", "RESOLVED")


class StorageEncryptionType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AMAZON_S3_SSE`None
    * `MONTE_CARLO_KMS`None
    """

    __schema__ = schema
    __choices__ = ("AMAZON_S3_SSE", "MONTE_CARLO_KMS")


class StorageTypeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AZURE_BLOB`None
    * `GCS`None
    * `S3`None
    * `SNOWFLAKE_INTERNAL_STAGE`None
    """

    __schema__ = schema
    __choices__ = ("AZURE_BLOB", "GCS", "S3", "SNOWFLAKE_INTERNAL_STAGE")


class StreamingClusterModelClusterType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CONFLUENT_KAFKA`: Confluent Kafka
    * `CONFLUENT_KAFKA_CONNECT`: Confluent Kafka Connect
    * `MSK_KAFKA`: MSK Kafka
    * `MSK_KAFKA_CONNECT`: MSK Kafka Connect
    * `SELF_HOSTED_KAFKA`: Self Hosted Kafka
    * `SELF_HOSTED_KAFKA_CONNECT`: Self Hosted Kafka Connect
    """

    __schema__ = schema
    __choices__ = (
        "CONFLUENT_KAFKA",
        "CONFLUENT_KAFKA_CONNECT",
        "MSK_KAFKA",
        "MSK_KAFKA_CONNECT",
        "SELF_HOSTED_KAFKA",
        "SELF_HOSTED_KAFKA_CONNECT",
    )


class StreamingSystemModelType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CONFLUENT_CLOUD`: Confluent Cloud
    * `MSK`: MSK
    * `SELF_HOSTED`: Self Hosted
    """

    __schema__ = schema
    __choices__ = ("CONFLUENT_CLOUD", "MSK", "SELF_HOSTED")


String = sgqlc.types.String


class TableAnomalyModelReason(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AGENT`: Agent Anomaly
    * `COMPARISON_RULE`: Comparison Rule Anomaly
    * `CUSTOM_RULE`: Custom Rule Anomaly
    * `DIST`: Distribution Anomaly
    * `FRESHNESS`: Freshness Anomaly
    * `METRIC`: Metric Anomaly
    * `METRIC_COMPARISON`: Metric Comparison Anomaly
    * `QUERY_PERFORMANCE`: Query Performance Anomaly
    * `QUERY_RUNTIME`: Query Time Anomaly
    * `RULE_RUN_FAILURE`: Rule Run Failure Anomaly
    * `SIZE`: Size Anomaly
    * `SIZE_DIFF`: Row count anomaly
    * `UNCHANGED_SIZE`: Unchanged Size Anomaly
    """

    __schema__ = schema
    __choices__ = (
        "AGENT",
        "COMPARISON_RULE",
        "CUSTOM_RULE",
        "DIST",
        "FRESHNESS",
        "METRIC",
        "METRIC_COMPARISON",
        "QUERY_PERFORMANCE",
        "QUERY_RUNTIME",
        "RULE_RUN_FAILURE",
        "SIZE",
        "SIZE_DIFF",
        "UNCHANGED_SIZE",
    )


class TableFlagType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DEPRECATION`None
    * `WARNING`None
    """

    __schema__ = schema
    __choices__ = ("DEPRECATION", "WARNING")


class TableMonitorMetricType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `TABLES_WITHOUT_MONITORS_COUNT`None
    * `TABLES_WITH_MONITORS_COUNT`None
    * `TOTAL_MONITORS_COUNT`None
    * `TOTAL_TABLES_COUNT`None
    """

    __schema__ = schema
    __choices__ = (
        "TABLES_WITHOUT_MONITORS_COUNT",
        "TABLES_WITH_MONITORS_COUNT",
        "TOTAL_MONITORS_COUNT",
        "TOTAL_TABLES_COUNT",
    )


class TableMonitorModelPriority(sgqlc.types.Enum):
    """Enumeration Choices:

    * `P1`: P1
    * `P2`: P2
    * `P3`: P3
    * `P4`: P4
    * `P5`: P5
    """

    __schema__ = schema
    __choices__ = ("P1", "P2", "P3", "P4", "P5")


class TableType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DYNAMIC`None
    * `EXTERNAL`None
    * `SNAPSHOT`None
    * `SNOWFLAKE_STREAM`None
    * `TABLE`None
    * `VECTOR_INDEX`None
    * `VIEW`None
    * `WILDCARD_TABLE`None
    """

    __schema__ = schema
    __choices__ = (
        "DYNAMIC",
        "EXTERNAL",
        "SNAPSHOT",
        "SNOWFLAKE_STREAM",
        "TABLE",
        "VECTOR_INDEX",
        "VIEW",
        "WILDCARD_TABLE",
    )


class TagAssignmentObjectType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CUSTOM_RULE_MONITOR`None
    * `METRIC_MONITOR`None
    * `TABLE_MONITOR`None
    """

    __schema__ = schema
    __choices__ = ("CUSTOM_RULE_MONITOR", "METRIC_MONITOR", "TABLE_MONITOR")


class TagType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DATA_QUALITY_DIMENSION_TAG`None
    * `MONITOR_TAG`None
    """

    __schema__ = schema
    __choices__ = ("DATA_QUALITY_DIMENSION_TAG", "MONITOR_TAG")


class TasksPerformanceSummarySort(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AVG_RUN_DURATION`None
    * `DISPLAY_NAME`None
    * `FAILURE_RATE`None
    * `INTEGRATION_TYPE`None
    * `LAST_RUN_END_TIME`None
    * `LAST_RUN_START_TIME`None
    * `LAST_RUN_STATUS`None
    * `LAST_RUN_UUID`None
    * `MCON`None
    * `RUN_COUNT`None
    * `RUN_DURATION_TREND_7D`None
    """

    __schema__ = schema
    __choices__ = (
        "AVG_RUN_DURATION",
        "DISPLAY_NAME",
        "FAILURE_RATE",
        "INTEGRATION_TYPE",
        "LAST_RUN_END_TIME",
        "LAST_RUN_START_TIME",
        "LAST_RUN_STATUS",
        "LAST_RUN_UUID",
        "MCON",
        "RUN_COUNT",
        "RUN_DURATION_TREND_7D",
    )


class TeradataLogMechEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BROWSER`None
    * `JWT`None
    * `KRB5`None
    * `LDAP`None
    * `TD2`None
    * `TDNEGO`None
    """

    __schema__ = schema
    __choices__ = ("BROWSER", "JWT", "KRB5", "LDAP", "TD2", "TDNEGO")


class TeradataLogMechUpdateEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BROWSER`None
    * `JWT`None
    * `KRB5`None
    * `LDAP`None
    * `TD2`None
    * `TDNEGO`None
    """

    __schema__ = schema
    __choices__ = ("BROWSER", "JWT", "KRB5", "LDAP", "TD2", "TDNEGO")


class TeradataSSLModeEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ALLOW`None
    * `DISABLE`None
    * `PREFER`None
    * `REQUIRE`None
    * `VERIFY_CA`None
    * `VERIFY_FULL`None
    """

    __schema__ = schema
    __choices__ = ("ALLOW", "DISABLE", "PREFER", "REQUIRE", "VERIFY_CA", "VERIFY_FULL")


class TeradataSSLModeUpdateEnum(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ALLOW`None
    * `DISABLE`None
    * `PREFER`None
    * `REQUIRE`None
    * `VERIFY_CA`None
    * `VERIFY_FULL`None
    """

    __schema__ = schema
    __choices__ = ("ALLOW", "DISABLE", "PREFER", "REQUIRE", "VERIFY_CA", "VERIFY_FULL")


class ThresholdModifierType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `METRIC`None
    * `PERCENTAGE`None
    """

    __schema__ = schema
    __choices__ = ("METRIC", "PERCENTAGE")


class ThresholdStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ACTIVE`None
    * `INACTIVE`None
    * `TRAINING`None
    """

    __schema__ = schema
    __choices__ = ("ACTIVE", "INACTIVE", "TRAINING")


class ThresholdType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `COMPARISON`None
    * `CUSTOM`None
    * `FIELD_HEALTH`None
    * `FRESHNESS`None
    * `ROWS`None
    * `SIZE_DIFF`None
    * `UNCHANGED_SIZE`None
    * `VOLUME_CHANGE`None
    """

    __schema__ = schema
    __choices__ = (
        "COMPARISON",
        "CUSTOM",
        "FIELD_HEALTH",
        "FRESHNESS",
        "ROWS",
        "SIZE_DIFF",
        "UNCHANGED_SIZE",
        "VOLUME_CHANGE",
    )


class TimeBucketSize(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DAY`None
    * `HOUR`None
    """

    __schema__ = schema
    __choices__ = ("DAY", "HOUR")


class TimeRangeUnit(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DAY`None
    * `MONTH`None
    * `WEEK`None
    """

    __schema__ = schema
    __choices__ = ("DAY", "MONTH", "WEEK")


class TraceSortDirection(sgqlc.types.Enum):
    """Sort direction for traces.

    Enumeration Choices:

    * `ASC`None
    * `DESC`None
    """

    __schema__ = schema
    __choices__ = ("ASC", "DESC")


class TraceSortField(sgqlc.types.Enum):
    """Fields that can be used for sorting traces.

    Enumeration Choices:

    * `COMPLETION_TOKENS`None
    * `COUNT_LLM_CALLS`None
    * `DURATION_SECONDS`None
    * `PROMPT_TOKENS`None
    * `TOTAL_TOKENS`None
    * `TRACE_END_TIME`None
    * `TRACE_ID`None
    * `TRACE_START_TIME`None
    """

    __schema__ = schema
    __choices__ = (
        "COMPLETION_TOKENS",
        "COUNT_LLM_CALLS",
        "DURATION_SECONDS",
        "PROMPT_TOKENS",
        "TOTAL_TOKENS",
        "TRACE_END_TIME",
        "TRACE_ID",
        "TRACE_START_TIME",
    )


class TutorialStatusType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `completed`None
    * `initial`None
    * `invalid`None
    * `started`None
    """

    __schema__ = schema
    __choices__ = ("completed", "initial", "invalid", "started")


class UUID(sgqlc.types.Scalar):
    """Leverages the internal Python implmeentation of UUID (uuid.UUID)
    to provide native UUID objects in fields, resolvers and input.
    """

    __schema__ = schema


class UnifiedUserAssignmentModelRelationshipType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `EXPERT`: Expert
    * `OWNER`: Owner
    """

    __schema__ = schema
    __choices__ = ("EXPERT", "OWNER")


class Upload(sgqlc.types.Scalar):
    """Create scalar that ignores normal serialization/deserialization,
    since that will be handled by the multipart request spec
    """

    __schema__ = schema


class UserDefinedMonitorModelBreached(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BREACHED`: BREACHED
    * `NOT_BREACHED`: NOT_BREACHED
    """

    __schema__ = schema
    __choices__ = ("BREACHED", "NOT_BREACHED")


class UserDefinedMonitorModelConsolidatedMonitorStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DISABLED`: DISABLED
    * `ENABLED`: ENABLED
    * `ERROR`: ERROR
    * `INSUFFICIENT_DATA`: INSUFFICIENT_DATA
    * `SNOOZED`: SNOOZED
    * `TRAINING`: TRAINING
    """

    __schema__ = schema
    __choices__ = ("DISABLED", "ENABLED", "ERROR", "INSUFFICIENT_DATA", "SNOOZED", "TRAINING")


class UserDefinedMonitorModelMonitorType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AGENT`: Agent
    * `CATEGORIES`: Dimension
    * `COMPARISON`: Comparison
    * `CUSTOM_SQL`: Custom SQL
    * `FIELD_QUALITY`: Metric - legacy
    * `FRESHNESS`: Freshness
    * `HOURLY_STATS`: Statistical metrics over an hour interval
    * `JSON_SCHEMA`: JSON schema
    * `METRIC_COMPARISON`: Comparison
    * `QUERY_PERF`: Query performance
    * `STATS`: Metric
    * `TABLE_METRIC`: Table metric rule
    * `VALIDATION`: Validation
    * `VOLUME`: Volume
    """

    __schema__ = schema
    __choices__ = (
        "AGENT",
        "CATEGORIES",
        "COMPARISON",
        "CUSTOM_SQL",
        "FIELD_QUALITY",
        "FRESHNESS",
        "HOURLY_STATS",
        "JSON_SCHEMA",
        "METRIC_COMPARISON",
        "QUERY_PERF",
        "STATS",
        "TABLE_METRIC",
        "VALIDATION",
        "VOLUME",
    )


class UserDefinedMonitorModelScheduleType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DYNAMIC`: Dynamic
    * `FIXED`: Fixed
    * `LOOSE`: Loose
    * `MANUAL`: Manual
    """

    __schema__ = schema
    __choices__ = ("DYNAMIC", "FIXED", "LOOSE", "MANUAL")


class UserDefinedMonitorModelSegmentationType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CUSTOM_SQL_EXPRESSION`: custom_sql_expression
    * `FIELD`: field
    """

    __schema__ = schema
    __choices__ = ("CUSTOM_SQL_EXPRESSION", "FIELD")


class UserDefinedMonitorModelUdmType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `MONITOR`: MONITOR
    * `RULE`: RULE
    """

    __schema__ = schema
    __choices__ = ("MONITOR", "RULE")


class UserDefinedMonitorSearchFields(sgqlc.types.Enum):
    """Defines which fields can be used for full text search in the user
    defined monitors view

    Enumeration Choices:

    * `CREATOR_ID`None
    * `ENTITIES`None
    * `MONITOR_FIELDS`None
    * `NAMESPACE`None
    * `RULE_DESCRIPTION`None
    * `RULE_NAME`None
    * `UPDATER_ID`None
    """

    __schema__ = schema
    __choices__ = (
        "CREATOR_ID",
        "ENTITIES",
        "MONITOR_FIELDS",
        "NAMESPACE",
        "RULE_DESCRIPTION",
        "RULE_NAME",
        "UPDATER_ID",
    )


class UserDefinedMonitors(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AGENT`: Agent
    * `CATEGORIES`: Dimension - legacy
    * `COMPARISON`: Comparison - legacy
    * `CUSTOM_SQL`: Custom SQL
    * `FIELD_QUALITY`: Metric - legacy
    * `FRESHNESS`: Freshness
    * `JSON_SCHEMA`: JSON schema
    * `METRIC_COMPARISON`: Comparison
    * `QUERY_PERF`: Query performance
    * `SCHEMA`: Schema
    * `STATS`: Metric
    * `TABLE`: Table
    * `TABLE_METRIC`: Volume - legacy
    * `VALIDATION`: Validation
    * `VOLUME`: Volume
    """

    __schema__ = schema
    __choices__ = (
        "AGENT",
        "CATEGORIES",
        "COMPARISON",
        "CUSTOM_SQL",
        "FIELD_QUALITY",
        "FRESHNESS",
        "JSON_SCHEMA",
        "METRIC_COMPARISON",
        "QUERY_PERF",
        "SCHEMA",
        "STATS",
        "TABLE",
        "TABLE_METRIC",
        "VALIDATION",
        "VOLUME",
    )


class UserInviteModelInviteType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `OBSERVABILITY`: observability
    """

    __schema__ = schema
    __choices__ = ("OBSERVABILITY",)


class UserInviteModelState(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ACCEPTED`: Accepted
    * `INVALIDATED`: Invalidated
    * `SENT`: Sent
    """

    __schema__ = schema
    __choices__ = ("ACCEPTED", "INVALIDATED", "SENT")


class UserModelDeleteReason(sgqlc.types.Enum):
    """Enumeration Choices:

    * `ACCOUNT_DEACTIVATED`: account deactivated
    * `DEACTIVATED_BY_SCIM_REQUEST`: deactivated through SCIM request
    * `DELETED_BY_MC`: deleted by MC admin
    * `DELETED_BY_USER`: deleted by user
    """

    __schema__ = schema
    __choices__ = (
        "ACCOUNT_DEACTIVATED",
        "DEACTIVATED_BY_SCIM_REQUEST",
        "DELETED_BY_MC",
        "DELETED_BY_USER",
    )


class UserModelPersona(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AI_ENGINEER`: ai_engineer
    * `BI_ANALYST_ENGINEER`: bi_analyst_or_engineer
    * `DATA_ANALYST`: data_analyst
    * `DATA_ENGINEER`: data_engineer
    * `DATA_SCIENTIST`: data_scientist
    * `EARLY_USER`: early_user
    * `EXECUTIVE`: executive
    * `OTHER`: other
    * `PRODUCT_MANAGER_OWNER`: product_manager_or_owner
    * `SOFTWARE_ENGINEER`: software_engineer
    * `TEAM_LEAD`: team_lead
    """

    __schema__ = schema
    __choices__ = (
        "AI_ENGINEER",
        "BI_ANALYST_ENGINEER",
        "DATA_ANALYST",
        "DATA_ENGINEER",
        "DATA_SCIENTIST",
        "EARLY_USER",
        "EXECUTIVE",
        "OTHER",
        "PRODUCT_MANAGER_OWNER",
        "SOFTWARE_ENGINEER",
        "TEAM_LEAD",
    )


class UserModelState(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CHECK_BACK`: Check Back Soon
    * `CONNECT_DW`: Connect Data Warehouse
    * `DASHBOARD`: View Dashboard
    * `INSTALL_DC`: Install Data Collector
    * `INTEGRATIONS`: Other integrations
    * `INVITE_USERS`: Invite Users
    * `NOT_AVAILABLE`: Not available
    * `SET_ACCOUNT_NAME`: Set Account Name
    * `SIGNED_UP`: Signed-Up
    """

    __schema__ = schema
    __choices__ = (
        "CHECK_BACK",
        "CONNECT_DW",
        "DASHBOARD",
        "INSTALL_DC",
        "INTEGRATIONS",
        "INVITE_USERS",
        "NOT_AVAILABLE",
        "SET_ACCOUNT_NAME",
        "SIGNED_UP",
    )


class UserPersona(sgqlc.types.Enum):
    """Enumeration Choices:

    * `AI_ENGINEER`None
    * `BI_ANALYST_ENGINEER`None
    * `DATA_ANALYST`None
    * `DATA_ENGINEER`None
    * `DATA_SCIENTIST`None
    * `EARLY_USER`None
    * `EXECUTIVE`None
    * `OTHER`None
    * `PRODUCT_MANAGER_OWNER`None
    * `SOFTWARE_ENGINEER`None
    * `TEAM_LEAD`None
    """

    __schema__ = schema
    __choices__ = (
        "AI_ENGINEER",
        "BI_ANALYST_ENGINEER",
        "DATA_ANALYST",
        "DATA_ENGINEER",
        "DATA_SCIENTIST",
        "EARLY_USER",
        "EXECUTIVE",
        "OTHER",
        "PRODUCT_MANAGER_OWNER",
        "SOFTWARE_ENGINEER",
        "TEAM_LEAD",
    )


class WarehouseModelConnectionType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `BIGQUERY`: BigQuery
    * `CLICKHOUSE`: ClickHouse
    * `DATA_LAKE`: Data Lake
    * `DB2`: Db2
    * `DREMIO`: Dremio
    * `ETL`: etl
    * `MYSQL`: MySQL
    * `ORACLE`: Oracle
    * `PINECONE`: Pinecone
    * `REDSHIFT`: Amazon Redshift
    * `S3_METADATA_EVENTS`: S3 Metadata Events
    * `SALESFORCE_CRM`: salesforce-crm
    * `SALESFORCE_DATA_CLOUD`: Salesforce Data Cloud
    * `SNOWFLAKE`: Snowflake
    * `TERADATA`: Teradata
    * `TRANSACTIONAL_DB`: Transactional DB
    """

    __schema__ = schema
    __choices__ = (
        "BIGQUERY",
        "CLICKHOUSE",
        "DATA_LAKE",
        "DB2",
        "DREMIO",
        "ETL",
        "MYSQL",
        "ORACLE",
        "PINECONE",
        "REDSHIFT",
        "S3_METADATA_EVENTS",
        "SALESFORCE_CRM",
        "SALESFORCE_DATA_CLOUD",
        "SNOWFLAKE",
        "TERADATA",
        "TRANSACTIONAL_DB",
    )


class WarehouseRelationType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `CONSUMER`None
    * `PRODUCER`None
    """

    __schema__ = schema
    __choices__ = ("CONSUMER", "PRODUCER")


class WarehouseTableModelStatus(sgqlc.types.Enum):
    """Enumeration Choices:

    * `G`None
    * `R`None
    * `Y`None
    """

    __schema__ = schema
    __choices__ = ("G", "R", "Y")


class WebhookServiceTypes(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DATABRICKS`None
    * `GITLAB`None
    * `JIRA`None
    * `OPSGENIE`None
    * `PAGERDUTY`None
    * `SERVICENOW`None
    """

    __schema__ = schema
    __choices__ = ("DATABRICKS", "GITLAB", "JIRA", "OPSGENIE", "PAGERDUTY", "SERVICENOW")


class WidgetType(sgqlc.types.Enum):
    """Enumeration Choices:

    * `DISCRETE`None
    * `FIELD_PROFILE_TABLE_V2`None
    * `NUMERIC_DESCRIPTIVE_STATS`None
    * `TIMESTAMP_HISTOGRAM`None
    """

    __schema__ = schema
    __choices__ = (
        "DISCRETE",
        "FIELD_PROFILE_TABLE_V2",
        "NUMERIC_DESCRIPTIVE_STATS",
        "TIMESTAMP_HISTOGRAM",
    )


########################################################################
# Input Objects
########################################################################
class AIMessageInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("message", "actor", "mcons")
    message = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="message")
    """Message from the specified actor"""

    actor = sgqlc.types.Field(sgqlc.types.non_null(ActorType), graphql_name="actor")
    """The actor that sends the message"""

    mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="mcons")
    """The mcons for the tables added in this message"""


class AgentSpanFieldFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("value",)
    value = sgqlc.types.Field(String, graphql_name="value")


class AgentSpanFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("agent", "workflow", "task", "span_name")
    agent = sgqlc.types.Field(AgentSpanFieldFilterInput, graphql_name="agent")

    workflow = sgqlc.types.Field(AgentSpanFieldFilterInput, graphql_name="workflow")

    task = sgqlc.types.Field(AgentSpanFieldFilterInput, graphql_name="task")

    span_name = sgqlc.types.Field(AgentSpanFieldFilterInput, graphql_name="spanName")


class AggregateInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("by", "time_axis")
    by = sgqlc.types.Field(sgqlc.types.non_null(MonitorAggTimeInterval), graphql_name="by")
    """The aggregation time interval to use."""

    time_axis = sgqlc.types.Field(
        sgqlc.types.non_null("FilterValueUnionInput"), graphql_name="timeAxis"
    )
    """Time axis to group by"""


class AggregateMetricParams(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("aggregate_metric_type", "aggregate_metric_field_name", "alias")
    aggregate_metric_type = sgqlc.types.Field(
        sgqlc.types.non_null(AggregateMetricType), graphql_name="aggregateMetricType"
    )
    """Metric type"""

    aggregate_metric_field_name = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="aggregateMetricFieldName"
    )
    """Field to aggregate over"""

    alias = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="alias")
    """Alias to assign metric"""


class AirflowConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("host_name",)
    host_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="hostName")
    """Airflow host name"""


class AirflowEnvInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("env_name", "env_id", "version", "base_url")
    env_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="envName")
    """Environment name"""

    env_id = sgqlc.types.Field(String, graphql_name="envId")

    version = sgqlc.types.Field(String, graphql_name="version")

    base_url = sgqlc.types.Field(String, graphql_name="baseUrl")


class AlertsFilterCriteriaInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "types",
        "sub_types",
        "owners",
        "severities",
        "priorities",
        "statuses",
        "table_databases",
        "table_schemas",
        "table_ids",
        "table_mcons",
        "domain_id",
        "monitor_ids",
        "monitor_tags",
        "is_normalized",
        "has_jira_tickets",
        "has_service_now_incidents",
        "has_opsgenie_incidents",
        "has_datadog_incidents",
        "has_azure_devops_work_items",
        "has_key_assets",
        "tags",
        "audience_ids",
        "domain_ids",
        "data_product_ids",
    )
    types = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(AlertType)), graphql_name="types"
    )

    sub_types = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(AlertSubType)), graphql_name="subTypes"
    )

    owners = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="owners")
    """Return alerts assigned to specified owners (by email)."""

    severities = sgqlc.types.Field(sgqlc.types.list_of(Severity), graphql_name="severities")

    priorities = sgqlc.types.Field(sgqlc.types.list_of(Priority), graphql_name="priorities")

    statuses = sgqlc.types.Field(sgqlc.types.list_of(AlertStatus), graphql_name="statuses")

    table_databases = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="tableDatabases"
    )
    """Return alerts that involve tables that belong to the specified
    databases.
    """

    table_schemas = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="tableSchemas"
    )
    """Return alerts that involve tables that belong to the specified
    schemas.
    """

    table_ids = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="tableIds"
    )
    """Return alerts that involve the specified tables."""

    table_mcons = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="tableMcons"
    )
    """Return alerts that involve the specified tables."""

    domain_id = sgqlc.types.Field(UUID, graphql_name="domainId")

    monitor_ids = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(UUID)), graphql_name="monitorIds"
    )
    """Return alerts triggered by specified monitors."""

    monitor_tags = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(UUID)), graphql_name="monitorTags"
    )
    """Return alerts triggered by monitors that have any of the specified
    tags.
    """

    is_normalized = sgqlc.types.Field(Boolean, graphql_name="isNormalized")
    """Normalized alerts are alerts where all associated events are in
    resolved state.If true, return only normalized alerts. If false,
    return only non-normalized alerts.
    """

    has_jira_tickets = sgqlc.types.Field(Boolean, graphql_name="hasJiraTickets")
    """If true, return only alerts with jira tickets. If false, return
    only alerts without any jira tickets.
    """

    has_service_now_incidents = sgqlc.types.Field(Boolean, graphql_name="hasServiceNowIncidents")
    """If true, return only alerts with ServiceNow incidents. If false,
    return only alerts without any ServiceNow incidents.
    """

    has_opsgenie_incidents = sgqlc.types.Field(Boolean, graphql_name="hasOpsgenieIncidents")
    """If true, return only alerts with Opsgenie incidents. If false,
    return only alerts without any Opsgenie incidents.
    """

    has_datadog_incidents = sgqlc.types.Field(Boolean, graphql_name="hasDatadogIncidents")
    """If true, return only alerts with Datadog incidents. If false,
    return only alerts without any Datadog incidents.
    """

    has_azure_devops_work_items = sgqlc.types.Field(Boolean, graphql_name="hasAzureDevopsWorkItems")
    """If true, return only alerts with Azure DevOps work items. If
    false, return only alerts without any Azure DevOps work items.
    """

    has_key_assets = sgqlc.types.Field(Boolean, graphql_name="hasKeyAssets")
    """If true, return only alerts associated with key assets.If false,
    return only alerts not associated with any key assets.
    """

    tags = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("TagKeyValuePairInput")), graphql_name="tags"
    )
    """Return alerts with the specified tags."""

    audience_ids = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(UUID)), graphql_name="audienceIds"
    )
    """Return alerts that notified specified audiences."""

    domain_ids = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(UUID)), graphql_name="domainIds"
    )

    data_product_ids = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(UUID)), graphql_name="dataProductIds"
    )
    """Return alerts that are on tables belong to these data products."""


class AlertsFilterDataFilterType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("field_name", "value")
    field_name = sgqlc.types.Field(
        sgqlc.types.non_null(AlertsFilterFieldName), graphql_name="fieldName"
    )

    value = sgqlc.types.Field(GenericScalar, graphql_name="value")


class AlertsFilterDataRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("field_name", "search_criteria", "first", "after", "search_value")
    field_name = sgqlc.types.Field(
        sgqlc.types.non_null(AlertsFilterFieldName), graphql_name="fieldName"
    )

    search_criteria = sgqlc.types.Field(
        sgqlc.types.non_null("AlertsFilterDataSearchCriteriaType"), graphql_name="searchCriteria"
    )

    first = sgqlc.types.Field(Int, graphql_name="first")
    """Number of results to return"""

    after = sgqlc.types.Field(String, graphql_name="after")
    """Cursor to paginate results"""

    search_value = sgqlc.types.Field(String, graphql_name="searchValue")
    """Respond with filter values which contain this text"""


class AlertsFilterDataSearchCriteriaType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("updated_time", "created_time", "filters")
    updated_time = sgqlc.types.Field("DateTimeRangeInput", graphql_name="updatedTime")
    """Supply a time range to filter alerts by their updated time. Either
    this or `createdTime` must be supplied.
    """

    created_time = sgqlc.types.Field("DateTimeRangeInput", graphql_name="createdTime")
    """Supply a time range to filter alerts by their created time. Either
    this or `updatedTime` must be supplied.
    """

    filters = sgqlc.types.Field(
        sgqlc.types.list_of(AlertsFilterDataFilterType), graphql_name="filters"
    )
    """List of filters to apply to alerts"""


class AlertsFilterExclusionCriteriaInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("types", "sub_types")
    types = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(AlertType)), graphql_name="types"
    )

    sub_types = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(AlertSubType)), graphql_name="subTypes"
    )


class AlertsFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("include", "exclude")
    include = sgqlc.types.Field(AlertsFilterCriteriaInput, graphql_name="include")
    """Return alerts that match these conditions."""

    exclude = sgqlc.types.Field(AlertsFilterExclusionCriteriaInput, graphql_name="exclude")
    """Exclude alerts that match these conditions. Exclusion criteria
    overrides inclusion criteria.
    """


class ApiCallReference(sgqlc.types.Input):
    """References (For instance UUIDs) that were passed as input to
    GraphQL API calls
    """

    __schema__ = schema
    __field_names__ = ("parameter_name", "parameter_value", "parameter_values")
    parameter_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="parameterName")
    """Name of the parameter"""

    parameter_value = sgqlc.types.Field(String, graphql_name="parameterValue")
    """Value of the parameter. If provided, `parameter_values` will be
    ignored
    """

    parameter_values = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="parameterValues"
    )
    """List of values for the parameter"""


class AssetCollectionRuleConditionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("attribute_name", "value", "comparison_type")
    attribute_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="attributeName")
    """The name of the attribute to match"""

    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")
    """The value (or pattern) to compare the attribute against"""

    comparison_type = sgqlc.types.Field(
        CollectionPreferenceMatchType, graphql_name="comparisonType"
    )
    """The method for comparing the attribute to the given value"""


class AssetCollectionRuleInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("conditions", "effect")
    conditions = sgqlc.types.Field(
        sgqlc.types.list_of(AssetCollectionRuleConditionInput), graphql_name="conditions"
    )
    """The set of conditions that need to match in order for this rule to
    apply
    """

    effect = sgqlc.types.Field(AssetCollectionRuleEffect, graphql_name="effect")
    """Whether to allow or block the asset when this rule matches."""


class AssetFilterUnionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "table_name",
        "table_name_operator",
        "table_type",
        "table_tags",
        "table_tags_operator",
        "read_days",
        "write_days",
        "read_write_days",
        "volume_change_days",
        "read_activity_is_null",
        "write_activity_is_null",
        "read_write_activity_is_null",
        "type",
        "negated",
    )
    table_name = sgqlc.types.Field(String, graphql_name="tableName")

    table_name_operator = sgqlc.types.Field(
        AssetFilterTableNameOperator, graphql_name="tableNameOperator"
    )

    table_type = sgqlc.types.Field(TableType, graphql_name="tableType")

    table_tags = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="tableTags"
    )

    table_tags_operator = sgqlc.types.Field(
        AssetFilterTableTagOperator, graphql_name="tableTagsOperator"
    )

    read_days = sgqlc.types.Field(Int, graphql_name="readDays")

    write_days = sgqlc.types.Field(Int, graphql_name="writeDays")

    read_write_days = sgqlc.types.Field(Int, graphql_name="readWriteDays")

    volume_change_days = sgqlc.types.Field(Int, graphql_name="volumeChangeDays")

    read_activity_is_null = sgqlc.types.Field(Boolean, graphql_name="readActivityIsNull")

    write_activity_is_null = sgqlc.types.Field(Boolean, graphql_name="writeActivityIsNull")

    read_write_activity_is_null = sgqlc.types.Field(Boolean, graphql_name="readWriteActivityIsNull")

    type = sgqlc.types.Field(sgqlc.types.non_null(AssetFilterType), graphql_name="type")

    negated = sgqlc.types.Field(Boolean, graphql_name="negated")


class AssetIncludeDatabaseInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("name", "schemas")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")

    schemas = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="schemas"
    )


class AssetSelectionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("databases", "filters", "exclusions")
    databases = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(AssetIncludeDatabaseInput)),
        graphql_name="databases",
    )

    filters = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(AssetFilterUnionInput)), graphql_name="filters"
    )

    exclusions = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(AssetFilterUnionInput)), graphql_name="exclusions"
    )


class AssetsSortInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("sort_field", "sort_direction")
    sort_field = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="sortField")
    """Field to sort by."""

    sort_direction = sgqlc.types.Field(AssetsSortDirection, graphql_name="sortDirection")
    """Sort direction. ASC or DESC, default is ASC"""


class AssetsUsageFilterOptions(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "only_ingested_tables",
        "only_not_ingested_tables",
        "only_monitored_tables",
        "only_not_monitored_tables",
        "only_ingested_schemas",
        "only_not_ingested_schemas",
    )
    only_ingested_tables = sgqlc.types.Field(Boolean, graphql_name="onlyIngestedTables")
    """To filter results that only has ingested tables."""

    only_not_ingested_tables = sgqlc.types.Field(Boolean, graphql_name="onlyNotIngestedTables")
    """To filter results that only does not have ingested tables."""

    only_monitored_tables = sgqlc.types.Field(Boolean, graphql_name="onlyMonitoredTables")
    """To filter results that only has monitored tables."""

    only_not_monitored_tables = sgqlc.types.Field(Boolean, graphql_name="onlyNotMonitoredTables")
    """To filter results that only does not have monitored tables."""

    only_ingested_schemas = sgqlc.types.Field(Boolean, graphql_name="onlyIngestedSchemas")
    """To filter results that only has ingested schemas."""

    only_not_ingested_schemas = sgqlc.types.Field(Boolean, graphql_name="onlyNotIngestedSchemas")
    """To filter results that only does not have ingested schemas."""


class AudienceNotificationSettingInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "recipients",
        "custom_display_names",
        "recipients_display_names",
        "notification_type",
        "extra",
        "audience_id",
        "integration_id",
        "uuid",
    )
    recipients = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name="recipients"
    )
    """Destination to send notifications to"""

    custom_display_names = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="customDisplayNames"
    )
    """Display names for the recipients. If this input parameter is
    provided, it should contain an entry for each recipient in the
    same order as the `recipients` list
    """

    recipients_display_names = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="recipientsDisplayNames"
    )
    """Display names for the recipients. If this input parameter is
    provided, it should contain an entry for each recipient in the
    same order as the `recipients` list
    """

    notification_type = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="notificationType"
    )
    """Specify the notification integration to use. Supported options
    include: email, opsgenie, pagerduty, slack, slack_v2, google_chat,
    webhook, msteams, msteams_v2, alation, servicenow, jira, webex,
    incidentio, datadog, azure_devops
    """

    extra = sgqlc.types.Field("NotificationExtra", graphql_name="extra")
    """Any extra values"""

    audience_id = sgqlc.types.Field(UUID, graphql_name="audienceId")
    """Audience associated with the recipient"""

    integration_id = sgqlc.types.Field(UUID, graphql_name="integrationId")
    """Integration ID for the recipient"""

    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """For updating a notification setting"""


class AzureDataFactoryConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "tenant_id",
        "client_id",
        "client_secret",
        "subscription_id",
        "resource_group_name",
        "factory_name",
    )
    tenant_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="tenantId")
    """Azure tenant id"""

    client_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="clientId")
    """Azure client id"""

    client_secret = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="clientSecret")
    """Azure client secret"""

    subscription_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="subscriptionId")
    """Azure subscription id"""

    resource_group_name = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="resourceGroupName"
    )
    """Azure resource group name"""

    factory_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="factoryName")
    """Azure Data Factory name"""


class AzureDataFactoryUpdateConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "tenant_id",
        "client_id",
        "client_secret",
        "subscription_id",
        "resource_group_name",
        "factory_name",
    )
    tenant_id = sgqlc.types.Field(String, graphql_name="tenantId")
    """Azure tenant id"""

    client_id = sgqlc.types.Field(String, graphql_name="clientId")
    """Azure client id"""

    client_secret = sgqlc.types.Field(String, graphql_name="clientSecret")
    """Azure client secret"""

    subscription_id = sgqlc.types.Field(String, graphql_name="subscriptionId")
    """Azure subscription id"""

    resource_group_name = sgqlc.types.Field(String, graphql_name="resourceGroupName")
    """Azure resource group name"""

    factory_name = sgqlc.types.Field(String, graphql_name="factoryName")
    """Azure Data Factory name"""


class AzureDevOpsBasicAuthCredentialsInput(sgqlc.types.Input):
    """Basic authentication credentials using Personal Access Token
    (PAT).
    """

    __schema__ = schema
    __field_names__ = ("access_token",)
    access_token = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="accessToken")
    """Personal Access Token (PAT) for basic authentication"""


class AzureDevOpsOauthCredentialsInput(sgqlc.types.Input):
    """OAuth credentials for Azure DevOps integration (preferred method)."""

    __schema__ = schema
    __field_names__ = ("tenant_id", "client_id", "client_secret")
    tenant_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="tenantId")
    """Azure AD tenant ID"""

    client_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="clientId")
    """OAuth client ID"""

    client_secret = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="clientSecret")
    """OAuth client secret"""


class AzureDevopsBasicAuthCredentialsInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("access_token",)
    access_token = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="accessToken")
    """Typically an Azure DevOps personal access token"""


class AzureDevopsOauthCredentialsInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("tenant_id", "client_id", "client_secret")
    tenant_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="tenantId")

    client_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="clientId")

    client_secret = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="clientSecret")


class AzureDevopsSourceSelectionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("project_id", "repository_id")
    project_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="projectId")
    """ID of Azure DevOps project"""

    repository_id = sgqlc.types.Field(String, graphql_name="repositoryId")
    """ID of Azure DevOps repository"""


class BiWarehouseSourcesInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("warehouse_resource_id", "warehouse_resource_type", "bi_warehouse_id")
    warehouse_resource_id = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="warehouseResourceId"
    )
    """Warehouse resource ID. This is a Monte Carlo ID"""

    warehouse_resource_type = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="warehouseResourceType"
    )
    """Warehouse type. Examples: snowflake, redshift, etc."""

    bi_warehouse_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="biWarehouseId")
    """The warehouse ID in the BI instance of the customer. This is an ID
    in the customer ID space and is not a Monte Carlo ID.
    """


class BigQueryUpdateConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("service_json",)
    service_json = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="serviceJson")
    """Service account key file as a base64 string"""


class BqConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("service_json",)
    service_json = sgqlc.types.Field(String, graphql_name="serviceJson")
    """Service account key file as a base64 string"""


class BulkUpdateAlertsValues(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("owner", "feedback")
    owner = sgqlc.types.Field(String, graphql_name="owner")

    feedback = sgqlc.types.Field(String, graphql_name="feedback")


class BulkUpdateIncidentsValues(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("owner", "feedback")
    owner = sgqlc.types.Field(String, graphql_name="owner")

    feedback = sgqlc.types.Field(String, graphql_name="feedback")


class CatalogMappingInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("from_name", "to_name")
    from_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="fromName")
    """From catalog object name."""

    to_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="toName")
    """To catalog object name."""


class ClassificationCategoriesInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("label", "description", "examples")
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="label")

    description = sgqlc.types.Field(String, graphql_name="description")

    examples = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="examples"
    )


class CollectionBlockInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("resource_id", "project", "dataset")
    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="resourceId")
    """The resource UUID this collection block applies to."""

    project = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="project")
    """Top-level object hierarchy e.g. database, catalog, etc."""

    dataset = sgqlc.types.Field(String, graphql_name="dataset")
    """Intermediate object hierarchy e.g. schema, database, etc."""


class CollectionBlockListParentScopeInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("resource_id", "project", "dataset")
    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="resourceId")
    """Warehouse to scope the rules to"""

    project = sgqlc.types.Field(String, graphql_name="project")
    """Project/database to scope the rules to"""

    dataset = sgqlc.types.Field(String, graphql_name="dataset")
    """Dataset/schema to scope the rules to"""


class ComparisonAlertConditionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "metric",
        "custom_metric",
        "source_field",
        "target_field",
        "type",
        "operator",
        "threshold_value",
        "is_threshold_relative",
    )
    metric = sgqlc.types.Field(String, graphql_name="metric")

    custom_metric = sgqlc.types.Field("CustomComparisonMetricInput", graphql_name="customMetric")

    source_field = sgqlc.types.Field(String, graphql_name="sourceField")

    target_field = sgqlc.types.Field(String, graphql_name="targetField")

    type = sgqlc.types.Field(String, graphql_name="type")

    operator = sgqlc.types.Field(String, graphql_name="operator")

    threshold_value = sgqlc.types.Field(Float, graphql_name="thresholdValue")

    is_threshold_relative = sgqlc.types.Field(Boolean, graphql_name="isThresholdRelative")


class ConfluentKafkaConnectCredentialsInput(sgqlc.types.Input):
    """Credentials to Confluent Connect APIs"""

    __schema__ = schema
    __field_names__ = ("confluent_env", "cluster", "api_key", "secret", "url")
    confluent_env = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="confluentEnv")
    """Confluent environment."""

    cluster = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cluster")
    """Confluent Kafka cluster in which the connectors are defined."""

    api_key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="apiKey")
    """Confluent Cloud API key."""

    secret = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="secret")
    """Confluent Cloud Api key's secret."""

    url = sgqlc.types.Field(String, graphql_name="url")
    """URL for the Confluent Connect."""


class ConfluentKafkaCredentialsInput(sgqlc.types.Input):
    """Credentials to a Confluent Kafka Cluster"""

    __schema__ = schema
    __field_names__ = ("cluster", "api_key", "secret", "url")
    cluster = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cluster")
    """Confluent Kafka cluster."""

    api_key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="apiKey")
    """Confluent Kafka API key."""

    secret = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="secret")
    """Confluent Kafka Api key's secret."""

    url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="url")
    """URL for the Confluent kafka cluster."""


class ConnectionTestOptions(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("dc_id", "skip_validation", "skip_permission_tests", "test_options")
    dc_id = sgqlc.types.Field(UUID, graphql_name="dcId")
    """DC UUID. To disambiguate accounts with multiple collectors."""

    skip_validation = sgqlc.types.Field(Boolean, graphql_name="skipValidation")
    """Skip all connection tests."""

    skip_permission_tests = sgqlc.types.Field(Boolean, graphql_name="skipPermissionTests")
    """Skips all permission tests for the service account/role for
    anysupported integrations. Only validates network connection
    between the DC and resource can be established.
    """

    test_options = sgqlc.types.Field("ValidatorTestOptions", graphql_name="testOptions")
    """Specify tests to run (Redshift only)."""


class CreateOrUpdateAgentTraceTableInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("uuid", "mcon", "connection_uuid", "span_format")
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """UUID of existing agent trace table to update"""

    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """MCON of the table"""

    connection_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="connectionUuid")
    """Connection UUID to query the table"""

    span_format = sgqlc.types.Field(AgentTraceFormatEnum, graphql_name="spanFormat")
    """Format of spans in the table"""


class CreatedByFilters(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("created_by", "is_template_managed", "namespace", "rule_name")
    created_by = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="createdBy")
    """Emails of users who created monitors to filter by"""

    is_template_managed = sgqlc.types.Field(Boolean, graphql_name="isTemplateManaged")
    """Filter only by monitors created with monitor-as-code (if true)"""

    namespace = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="namespace")
    """Filter by namespace name (for monitors created via monitor-as-
    code)
    """

    rule_name = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="ruleName")
    """Filter by rule names (for monitors created via monitor-as-code)"""


class CriteriaInput(sgqlc.types.Input):
    """Filtering criteria, specified by data type"""

    __schema__ = schema
    __field_names__ = (
        "string_filters",
        "timestamp_filters",
        "numeric_filters",
        "custom_where_clause",
    )
    string_filters = sgqlc.types.Field(
        sgqlc.types.list_of("StringFilterInput"), graphql_name="stringFilters"
    )
    """String filters"""

    timestamp_filters = sgqlc.types.Field(
        sgqlc.types.list_of("TimestampFilterInput"), graphql_name="timestampFilters"
    )
    """Timestamp filters"""

    numeric_filters = sgqlc.types.Field(
        sgqlc.types.list_of("NumericFilterInput"), graphql_name="numericFilters"
    )
    """Numeric filters"""

    custom_where_clause = sgqlc.types.Field(String, graphql_name="customWhereClause")
    """Custom where clause"""


class CustomComparisonMetricInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("uuid", "display_name", "source_sql_expression", "target_sql_expression")
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")

    display_name = sgqlc.types.Field(String, graphql_name="displayName")

    source_sql_expression = sgqlc.types.Field(String, graphql_name="sourceSqlExpression")

    target_sql_expression = sgqlc.types.Field(String, graphql_name="targetSqlExpression")


class CustomMetricInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("uuid", "display_name", "sql_expression")
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")

    display_name = sgqlc.types.Field(String, graphql_name="displayName")

    sql_expression = sgqlc.types.Field(String, graphql_name="sqlExpression")


class CustomMetricQueryInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "connection_id",
        "data_source",
        "mcon",
        "sql_expression",
        "time_axis_name",
        "time_axis_type",
        "agg_time_interval",
        "where_condition",
        "use_literal_period",
        "collection_lag_hours",
    )
    connection_id = sgqlc.types.Field(UUID, graphql_name="connectionId")
    """Connection UUID to use for the query"""

    data_source = sgqlc.types.Field("DataSourceUnionInput", graphql_name="dataSource")
    """Target data source"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Mcon of the target table"""

    sql_expression = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="sqlExpression")
    """SQL expression of the custom metric"""

    time_axis_name = sgqlc.types.Field(String, graphql_name="timeAxisName")
    """Time axis name"""

    time_axis_type = sgqlc.types.Field(String, graphql_name="timeAxisType")
    """Time axis type"""

    agg_time_interval = sgqlc.types.Field(MonitorAggTimeInterval, graphql_name="aggTimeInterval")
    """Aggregation time interval to use. (defaults to HOUR)"""

    where_condition = sgqlc.types.Field(String, graphql_name="whereCondition")
    """WHERE condition to apply to the query"""

    use_literal_period = sgqlc.types.Field(Boolean, graphql_name="useLiteralPeriod")
    """Use a literal period in the queries"""

    collection_lag_hours = sgqlc.types.Field(Int, graphql_name="collectionLagHours")
    """Time to offset the collection time bucket by in hours. Only when
    using literal periods
    """


class CustomRuleComparisonInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "comparison_type",
        "full_table_id",
        "full_table_ids",
        "mcon",
        "field",
        "fields",
        "metric",
        "custom_metric",
        "operator",
        "threshold",
        "upper_threshold",
        "lower_threshold",
        "baseline_agg_function",
        "baseline_interval_minutes",
        "is_threshold_relative",
        "threshold_lookback_minutes",
        "threshold_ref",
        "threshold_sensitivity",
        "min_buffer",
        "max_buffer",
        "number_of_agg_periods",
        "threshold_lookback_data_points",
    )
    comparison_type = sgqlc.types.Field(ComparisonType, graphql_name="comparisonType")

    full_table_id = sgqlc.types.Field(String, graphql_name="fullTableId")

    full_table_ids = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="fullTableIds")

    mcon = sgqlc.types.Field(String, graphql_name="mcon")

    field = sgqlc.types.Field(String, graphql_name="field")

    fields = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="fields"
    )

    metric = sgqlc.types.Field(String, graphql_name="metric")

    custom_metric = sgqlc.types.Field(CustomMetricInput, graphql_name="customMetric")

    operator = sgqlc.types.Field(CustomRuleComparisonOperator, graphql_name="operator")
    """Comparison operator"""

    threshold = sgqlc.types.Field(Float, graphql_name="threshold")
    """Threshold value"""

    upper_threshold = sgqlc.types.Field(Float, graphql_name="upperThreshold")
    """Upper threshold value"""

    lower_threshold = sgqlc.types.Field(Float, graphql_name="lowerThreshold")
    """Lower threshold value"""

    baseline_agg_function = sgqlc.types.Field(
        AggregationFunction, graphql_name="baselineAggFunction"
    )
    """Function used to aggregate historical data points to calculate
    baseline
    """

    baseline_interval_minutes = sgqlc.types.Field(Int, graphql_name="baselineIntervalMinutes")
    """Time interval to aggregate over to calculate baseline."""

    is_threshold_relative = sgqlc.types.Field(Boolean, graphql_name="isThresholdRelative")
    """True, if threshold is a relative percentage change of baseline.
    False, if threshold is absolute change
    """

    threshold_lookback_minutes = sgqlc.types.Field(Int, graphql_name="thresholdLookbackMinutes")
    """Time to look back for rules which compare current and past values."""

    threshold_ref = sgqlc.types.Field(String, graphql_name="thresholdRef")
    """Key used to retrieve the threshold values from external source"""

    threshold_sensitivity = sgqlc.types.Field(
        SensitivityLevels, graphql_name="thresholdSensitivity"
    )
    """Sensitivity for automated thresholds"""

    min_buffer = sgqlc.types.Field("ThresholdModifierInput", graphql_name="minBuffer")
    """The lower bound buffer to modify the alert threshold."""

    max_buffer = sgqlc.types.Field("ThresholdModifierInput", graphql_name="maxBuffer")
    """The upper bound buffer to modify the alert threshold."""

    number_of_agg_periods = sgqlc.types.Field(Int, graphql_name="numberOfAggPeriods")
    """The number of periods to use in the aggregate comparison for
    Volume Growth comparisons.
    """

    threshold_lookback_data_points = sgqlc.types.Field(
        Int, graphql_name="thresholdLookbackDataPoints"
    )
    """Number of data points to look back for rules which compare current
    and past values.
    """


class CustomRuleSnoozeInput(sgqlc.types.Input):
    """input variables for snoozing"""

    __schema__ = schema
    __field_names__ = ("rule_uuid", "snooze_minutes", "conditional_snooze")
    rule_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="ruleUuid")
    """UUID of rule to snooze"""

    snooze_minutes = sgqlc.types.Field(Int, graphql_name="snoozeMinutes")
    """number of minutes to snooze rule"""

    conditional_snooze = sgqlc.types.Field(Boolean, graphql_name="conditionalSnooze")
    """snooze rule until breach condition changes or is resolved"""


class CustomRuleSqlBlocksInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("alert_condition", "where_condition", "group_by")
    alert_condition = sgqlc.types.Field("FilterGroupInput", graphql_name="alertCondition")

    where_condition = sgqlc.types.Field("FilterGroupInput", graphql_name="whereCondition")

    group_by = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("FilterValueUnionInput")), graphql_name="groupBy"
    )


class CustomSqlRuleAlertConditionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "type",
        "operator",
        "threshold",
        "baseline_agg_function",
        "baseline_interval_minutes",
        "is_threshold_relative",
        "threshold_sensitivity",
        "upper_threshold",
        "lower_threshold",
    )
    type = sgqlc.types.Field(sgqlc.types.non_null(ComparisonType), graphql_name="type")

    operator = sgqlc.types.Field(
        sgqlc.types.non_null(CustomRuleComparisonOperator), graphql_name="operator"
    )
    """Comparison operator"""

    threshold = sgqlc.types.Field(Float, graphql_name="threshold")
    """Threshold value"""

    baseline_agg_function = sgqlc.types.Field(
        AggregationFunction, graphql_name="baselineAggFunction"
    )
    """Function used to aggregate historical data points to calculate
    baseline
    """

    baseline_interval_minutes = sgqlc.types.Field(Int, graphql_name="baselineIntervalMinutes")
    """Time interval to aggregate over to calculate baseline."""

    is_threshold_relative = sgqlc.types.Field(Boolean, graphql_name="isThresholdRelative")
    """True, if threshold is a relative percentage change of baseline.
    False, if threshold is absolute change
    """

    threshold_sensitivity = sgqlc.types.Field(
        SensitivityLevels, graphql_name="thresholdSensitivity"
    )
    """Sensitivity for automated thresholds"""

    upper_threshold = sgqlc.types.Field(Float, graphql_name="upperThreshold")
    """Upper threshold value"""

    lower_threshold = sgqlc.types.Field(Float, graphql_name="lowerThreshold")
    """Lower threshold value"""


class DODCriteriaInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "time_range",
        "data_product_uuids",
        "audience_uuids",
        "domain_uuids",
        "tags",
        "monitor_tags",
    )
    time_range = sgqlc.types.Field("TimeRangeInput", graphql_name="timeRange")
    """Time range criteria."""

    data_product_uuids = sgqlc.types.Field(
        sgqlc.types.list_of(UUID), graphql_name="dataProductUuids"
    )
    """Data product uuid filters."""

    audience_uuids = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name="audienceUuids")
    """Audience uuid filters."""

    domain_uuids = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name="domainUuids")
    """Domain uuid filters."""

    tags = sgqlc.types.Field(sgqlc.types.list_of("TagKeyValuePairInput"), graphql_name="tags")
    """Tags filters."""

    monitor_tags = sgqlc.types.Field(
        sgqlc.types.list_of("TagKeyValuePairInput"), graphql_name="monitorTags"
    )
    """Monitor tags filters."""


class DataExplorerComparisonDashboardInputType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "uuid",
        "warehouse_uuid",
        "name",
        "dashboard_left",
        "dashboard_right",
        "widgets",
        "criteria",
    )
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """UUID of comparison dashboard, required if updating existing object"""

    warehouse_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="warehouseUuid")
    """UUID of warehouse"""

    name = sgqlc.types.Field(String, graphql_name="name")
    """Descriptive name"""

    dashboard_left = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="dashboardLeft")
    """First dashboard to be compared"""

    dashboard_right = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="dashboardRight")
    """Second dashboard to be compared"""

    widgets = sgqlc.types.Field(
        sgqlc.types.list_of("DataExplorerWidgetInputType"), graphql_name="widgets"
    )

    criteria = sgqlc.types.Field(JSONString, graphql_name="criteria")
    """Saved criteria"""


class DataExplorerDashboardInputType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "uuid",
        "warehouse_uuid",
        "mcon",
        "name",
        "time_axis_field_name",
        "base_where_clause",
        "widgets",
        "criteria",
    )
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """UUID of dashboard, required if updating existing object"""

    warehouse_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="warehouseUuid")
    """UUID of warehouse"""

    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """MCON of underlying warehouse table"""

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Descriptive name of dashboard"""

    time_axis_field_name = sgqlc.types.Field(String, graphql_name="timeAxisFieldName")
    """Time axis field name"""

    base_where_clause = sgqlc.types.Field(String, graphql_name="baseWhereClause")
    """Base where clause"""

    widgets = sgqlc.types.Field(
        sgqlc.types.list_of("DataExplorerWidgetInputType"), graphql_name="widgets"
    )
    """Configured widgets"""

    criteria = sgqlc.types.Field(JSONString, graphql_name="criteria")
    """Saved criteria"""


class DataExplorerWidgetInputType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("field_name", "widget_type", "config")
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="fieldName")
    """Field name visualized by this widget"""

    widget_type = sgqlc.types.Field(sgqlc.types.non_null(WidgetType), graphql_name="widgetType")
    """Type of widget"""

    config = sgqlc.types.Field(JSONString, graphql_name="config")
    """Additional configuration for widget"""


class DataProfilerWidgetDataInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "dataset",
        "widget_type",
        "field_name",
        "field_name_pattern",
        "limit",
        "offset",
        "widget_config",
    )
    dataset = sgqlc.types.Field(sgqlc.types.non_null("DatasetInput"), graphql_name="dataset")

    widget_type = sgqlc.types.Field(sgqlc.types.non_null(WidgetType), graphql_name="widgetType")

    field_name = sgqlc.types.Field(String, graphql_name="fieldName")
    """filter by field name. Supported by DISCRETE and FIELD_PROFILE
    widgets
    """

    field_name_pattern = sgqlc.types.Field(String, graphql_name="fieldNamePattern")
    """filter by field name pattern. Supported by FIELD_PROFILE widgets"""

    limit = sgqlc.types.Field(Int, graphql_name="limit")

    offset = sgqlc.types.Field(Int, graphql_name="offset")

    widget_config = sgqlc.types.Field("WidgetConfig", graphql_name="widgetConfig")
    """Widget configuration"""


class DataShareInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("type", "account", "region", "organization")
    type = sgqlc.types.Field(DataShareType, graphql_name="type")
    """Type of data share (default: 'snowflake')"""

    account = sgqlc.types.Field(String, graphql_name="account")
    """Data share account identifier (optional if account has only one)"""

    region = sgqlc.types.Field(String, graphql_name="region")
    """Data share region (optional if account has only one)"""

    organization = sgqlc.types.Field(String, graphql_name="organization")
    """Organization identifier"""


class DataSourceSchemaInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("fields",)
    fields = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SchemaFieldInput"))),
        graphql_name="fields",
    )


class DataSourceUnionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("sql", "mcon", "transforms", "type", "connection_type", "schema")
    sql = sgqlc.types.Field(String, graphql_name="sql")
    """The SQL query that defines the source of the data"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")

    transforms = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("TransformInput")), graphql_name="transforms"
    )

    type = sgqlc.types.Field(sgqlc.types.non_null(DataSourceType), graphql_name="type")

    connection_type = sgqlc.types.Field(String, graphql_name="connectionType")

    schema = sgqlc.types.Field(DataSourceSchemaInput, graphql_name="schema")


class DatabricksSqlWarehouseConnectionInput(sgqlc.types.Input):
    """Credentials and connection details to a Databricks SQL warehouse
    connection
    """

    __schema__ = schema
    __field_names__ = ("dc_id", "databricks_config")
    dc_id = sgqlc.types.Field(UUID, graphql_name="dcId")
    """The Data Collector UUID for a new Databricks Connection"""

    databricks_config = sgqlc.types.Field(
        "DatabricksSqlWarehouseInput", graphql_name="databricksConfig"
    )
    """Configuration for Databricks."""


class DatabricksSqlWarehouseInput(sgqlc.types.Input):
    """Credentials to a Databricks sql warehouse."""

    __schema__ = schema
    __field_names__ = (
        "databricks_workspace_url",
        "databricks_warehouse_id",
        "databricks_token",
        "databricks_client_id",
        "databricks_client_secret",
        "databricks_workspace_id",
        "azure_tenant_id",
        "azure_workspace_resource_id",
    )
    databricks_workspace_url = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="databricksWorkspaceUrl"
    )
    """Databricks workspace URL"""

    databricks_warehouse_id = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="databricksWarehouseId"
    )
    """Databricks warehouse ID"""

    databricks_token = sgqlc.types.Field(String, graphql_name="databricksToken")
    """User token"""

    databricks_client_id = sgqlc.types.Field(String, graphql_name="databricksClientId")
    """Client ID (for M2M oauth)"""

    databricks_client_secret = sgqlc.types.Field(String, graphql_name="databricksClientSecret")
    """Client Secret (for M2M oauth)"""

    databricks_workspace_id = sgqlc.types.Field(String, graphql_name="databricksWorkspaceId")
    """Databricks workspace ID"""

    azure_tenant_id = sgqlc.types.Field(String, graphql_name="azureTenantId")
    """Azure Tenant ID (for M2M oauth with an Entra ID managed service
    principal)
    """

    azure_workspace_resource_id = sgqlc.types.Field(String, graphql_name="azureWorkspaceResourceId")
    """Azure ARM resource ID of the Databricks workspace (for M2M oauth
    with an Entra ID managed service principal)
    """


class DatabricksSqlWarehouseUpdateConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "databricks_workspace_url",
        "databricks_warehouse_id",
        "databricks_token",
        "databricks_client_id",
        "databricks_client_secret",
        "databricks_workspace_id",
    )
    databricks_workspace_url = sgqlc.types.Field(String, graphql_name="databricksWorkspaceUrl")
    """Databricks workspace URL"""

    databricks_warehouse_id = sgqlc.types.Field(String, graphql_name="databricksWarehouseId")
    """Databricks warehouse ID"""

    databricks_token = sgqlc.types.Field(String, graphql_name="databricksToken")
    """User token"""

    databricks_client_id = sgqlc.types.Field(String, graphql_name="databricksClientId")
    """Client ID (for M2M oauth)"""

    databricks_client_secret = sgqlc.types.Field(String, graphql_name="databricksClientSecret")
    """Client Secret (for M2M oauth)"""

    databricks_workspace_id = sgqlc.types.Field(String, graphql_name="databricksWorkspaceId")
    """Databricks workspace ID"""


class DatasetFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("dataset_mcons",)
    dataset_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="datasetMcons")
    """MCONs of datasets to filter by."""


class DatasetInput(sgqlc.types.Input):
    """Specifies base table + criteria for dashboard/widget"""

    __schema__ = schema
    __field_names__ = ("mcon", "criteria", "base_where_clause", "connection_id")
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """MCON of underlying table"""

    criteria = sgqlc.types.Field(CriteriaInput, graphql_name="criteria")
    """Filtering criteria"""

    base_where_clause = sgqlc.types.Field(String, graphql_name="baseWhereClause")
    """Base where clause"""

    connection_id = sgqlc.types.Field(UUID, graphql_name="connectionId")
    """Optional connection ID to use for queries"""


class DateTimeRangeInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("before", "after")
    before = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="before")
    """Return records before this time."""

    after = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="after")
    """Return records after or at this time."""


class DbtArtifactsInput(sgqlc.types.Input):
    """dbt artifacts"""

    __schema__ = schema
    __field_names__ = ("manifest", "run_results", "logs")
    manifest = sgqlc.types.Field(String, graphql_name="manifest")
    """manifest file name"""

    run_results = sgqlc.types.Field(String, graphql_name="runResults")
    """run results file name"""

    logs = sgqlc.types.Field(String, graphql_name="logs")
    """logs file name"""


class DbtCloudConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "dbt_cloud_api_token",
        "dbt_cloud_account_id",
        "dbt_cloud_base_url",
        "dbt_cloud_webhook_hmac_secret",
        "dbt_cloud_webhook_id",
    )
    dbt_cloud_api_token = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="dbtCloudApiToken"
    )
    """dbt Cloud API token"""

    dbt_cloud_account_id = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="dbtCloudAccountId"
    )
    """dbt Cloud account ID"""

    dbt_cloud_base_url = sgqlc.types.Field(String, graphql_name="dbtCloudBaseUrl")
    """dbt Cloud base URL"""

    dbt_cloud_webhook_hmac_secret = sgqlc.types.Field(
        String, graphql_name="dbtCloudWebhookHmacSecret"
    )
    """dbt Cloud webhook HMAC secret"""

    dbt_cloud_webhook_id = sgqlc.types.Field(String, graphql_name="dbtCloudWebhookId")
    """dbt Cloud webhook ID"""


class DbtCloudUpdateConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "dbt_cloud_base_url",
        "dbt_cloud_webhook_hmac_secret",
        "dbt_cloud_webhook_id",
        "dbt_cloud_api_token",
        "dbt_cloud_account_id",
    )
    dbt_cloud_base_url = sgqlc.types.Field(String, graphql_name="dbtCloudBaseUrl")
    """dbt cloud URL"""

    dbt_cloud_webhook_hmac_secret = sgqlc.types.Field(
        String, graphql_name="dbtCloudWebhookHmacSecret"
    )
    """dbt cloud webhook HMAC secret"""

    dbt_cloud_webhook_id = sgqlc.types.Field(String, graphql_name="dbtCloudWebhookId")
    """dbt cloud webhook ID"""

    dbt_cloud_api_token = sgqlc.types.Field(String, graphql_name="dbtCloudApiToken")
    """dbt cloud API token"""

    dbt_cloud_account_id = sgqlc.types.Field(String, graphql_name="dbtCloudAccountId")
    """dbt cloud account ID"""


class DeleteAgentTraceTableInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("uuid",)
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """UUID of the agent trace table to delete"""


class ExtendedDataSourceInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "data_source",
        "dw_id",
        "where_condition",
        "segments",
        "connection_uuid",
        "timeout",
    )
    data_source = sgqlc.types.Field(
        sgqlc.types.non_null(DataSourceUnionInput), graphql_name="dataSource"
    )
    """Data source can be table or sql."""

    dw_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="dwId")
    """Warehouse of the data source."""

    where_condition = sgqlc.types.Field(String, graphql_name="whereCondition")
    """Where condition used for table data source."""

    segments = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("FilterValueUnionInput")), graphql_name="segments"
    )
    """segments for data source."""

    connection_uuid = sgqlc.types.Field(UUID, graphql_name="connectionUuid")
    """Connection UUID for the data source."""

    timeout = sgqlc.types.Field(Int, graphql_name="timeout")
    """Timeout for the SQL query."""


class FieldConfigInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("type", "count", "field")
    type = sgqlc.types.Field(sgqlc.types.non_null(FieldConfigType), graphql_name="type")

    count = sgqlc.types.Field(Int, graphql_name="count")

    field = sgqlc.types.Field(String, graphql_name="field")


class FieldMetricFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("field_name", "operator", "value")
    field_name = sgqlc.types.Field(String, graphql_name="fieldName")
    """Field to filter by"""

    operator = sgqlc.types.Field(
        sgqlc.types.non_null(CustomRuleComparisonOperator), graphql_name="operator"
    )
    """Operator to filter field by"""

    value = sgqlc.types.Field(String, graphql_name="value")
    """Value to filter field by"""


class FieldMetricInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "table_mcon",
        "table_mcons",
        "field_name",
        "field_names",
        "metric_type",
        "value_list",
        "value_sql",
        "filters",
    )
    table_mcon = sgqlc.types.Field(String, graphql_name="tableMcon")
    """MCON of the table the metric is based on"""

    table_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="tableMcons")
    """MCONs of the table the metric is based on"""

    field_name = sgqlc.types.Field(String, graphql_name="fieldName")
    """Name of the field the metric is based on"""

    field_names = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="fieldNames")
    """Name of the fields the metric is based on"""

    metric_type = sgqlc.types.Field(
        sgqlc.types.non_null(FieldMetricType), graphql_name="metricType"
    )
    """Type of metric to compute"""

    value_list = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="valueList")
    """Values for metrics that check for cardinality"""

    value_sql = sgqlc.types.Field(String, graphql_name="valueSql")
    """Values SQL expression for metrics that check for cardinality"""

    filters = sgqlc.types.Field(sgqlc.types.list_of(FieldMetricFilterInput), graphql_name="filters")
    """Filters for which rows the metric is computed over"""


class FieldQueryFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("field_name", "operator", "value")
    field_name = sgqlc.types.Field(String, graphql_name="fieldName")
    """Field to filter by"""

    operator = sgqlc.types.Field(
        sgqlc.types.non_null(CustomRuleComparisonOperator), graphql_name="operator"
    )
    """Operator to filter field by"""

    value = sgqlc.types.Field(String, graphql_name="value")
    """Value to filter field by"""


class FieldQueryParametersInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "table_mcons",
        "field_names",
        "query_type",
        "value_list",
        "value_sql",
        "filters",
    )
    table_mcons = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name="tableMcons"
    )
    """MCONs of the table the query is based on"""

    field_names = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name="fieldNames"
    )
    """Name of the fields the query is based on"""

    query_type = sgqlc.types.Field(sgqlc.types.non_null(FieldQueryType), graphql_name="queryType")
    """Type of query"""

    value_list = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="valueList")
    """Values for queries that check for cardinality"""

    value_sql = sgqlc.types.Field(String, graphql_name="valueSql")
    """Values SQL expression for metrics that check for cardinality"""

    filters = sgqlc.types.Field(sgqlc.types.list_of(FieldQueryFilterInput), graphql_name="filters")
    """Filters for which rows the query is computed over"""


class FilterGroupInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("type", "id", "conditions", "operator")
    type = sgqlc.types.Field(FilterType, graphql_name="type")

    id = sgqlc.types.Field(String, graphql_name="id")

    conditions = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("FilterUnionInput")), graphql_name="conditions"
    )

    operator = sgqlc.types.Field(BooleanOperator, graphql_name="operator")


class FilterPredicateInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("name", "negated")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")

    negated = sgqlc.types.Field(Boolean, graphql_name="negated")


class FilterUnionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "value",
        "predicate",
        "left",
        "right",
        "sql",
        "conditions",
        "operator",
        "type",
        "id",
    )
    value = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("FilterValueUnionInput")), graphql_name="value"
    )

    predicate = sgqlc.types.Field(FilterPredicateInput, graphql_name="predicate")

    left = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("FilterValueUnionInput")), graphql_name="left"
    )

    right = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("FilterValueUnionInput")), graphql_name="right"
    )

    sql = sgqlc.types.Field(String, graphql_name="sql")

    conditions = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("FilterUnionInput")), graphql_name="conditions"
    )

    operator = sgqlc.types.Field(BooleanOperator, graphql_name="operator")

    type = sgqlc.types.Field(sgqlc.types.non_null(FilterType), graphql_name="type")

    id = sgqlc.types.Field(String, graphql_name="id")


class FilterValueUnionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("literal", "sql", "field", "table", "mcon", "type", "id")
    literal = sgqlc.types.Field(String, graphql_name="literal")

    sql = sgqlc.types.Field(String, graphql_name="sql")

    field = sgqlc.types.Field(String, graphql_name="field")

    table = sgqlc.types.Field(String, graphql_name="table")

    mcon = sgqlc.types.Field(String, graphql_name="mcon")

    type = sgqlc.types.Field(sgqlc.types.non_null(FilterValueType), graphql_name="type")

    id = sgqlc.types.Field(String, graphql_name="id")


class FreshnessAutomatedAlertConditionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("sensitivity_level",)
    sensitivity_level = sgqlc.types.Field(
        sgqlc.types.non_null(SensitivityLevels), graphql_name="sensitivityLevel"
    )
    """Sensitivity for automated thresholds"""


class FreshnessExplicitAlertConditionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "start_time",
        "interval_minutes",
        "interval_crontab",
        "interval_crontab_day_or",
        "timezone",
        "is_auto_schedule_config",
        "threshold",
    )
    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """Start time of the collection"""

    interval_minutes = sgqlc.types.Field(Int, graphql_name="intervalMinutes")
    """Collection interval in minutes"""

    interval_crontab = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="intervalCrontab"
    )
    """Collection interval in crontab format"""

    interval_crontab_day_or = sgqlc.types.Field(Boolean, graphql_name="intervalCrontabDayOr")
    """If true, use default cron behavior and run when day-of-month OR
    day-of-week match. If false, use alternate behavior and run when
    day-of-month AND day-of-week match.
    """

    timezone = sgqlc.types.Field(String, graphql_name="timezone")
    """Timezone for daylight savings and interpreting cron expressions"""

    is_auto_schedule_config = sgqlc.types.Field(Boolean, graphql_name="isAutoScheduleConfig")
    """Set to true to use auto schedule configuration"""

    threshold = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="threshold")
    """Explicit freshness threshold in minutes"""


class GetExplanationForEventRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("event_uuid", "start_time", "end_time")
    event_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="eventUuid")
    """Event UUID"""

    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """Start time range. By default, current time - 4 weeks"""

    end_time = sgqlc.types.Field(DateTime, graphql_name="endTime")
    """End time range. By default, current time"""


class GetExplanationRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("query_group", "start_time", "end_time")
    query_group = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="queryGroup")
    """Query group hash"""

    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """Start time range. By default, current time - 4 weeks"""

    end_time = sgqlc.types.Field(DateTime, graphql_name="endTime")
    """End time range. By default, current time"""


class GetTracesInput(sgqlc.types.Input):
    """Input parameters for GetTraces query."""

    __schema__ = schema
    __field_names__ = (
        "agent_name",
        "trace_table_mcon",
        "start_time",
        "end_time",
        "first",
        "after",
        "last",
        "before",
        "sort_field",
        "sort_direction",
    )
    agent_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="agentName")
    """Agent name to filter by"""

    trace_table_mcon = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="traceTableMcon"
    )
    """MCON of the trace table to query. Filters traces to only those
    from this table.
    """

    start_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="startTime")
    """Start of time range (inclusive)"""

    end_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="endTime")
    """End of time range (inclusive)"""

    first = sgqlc.types.Field(Int, graphql_name="first")
    """Number of records to fetch for forward pagination"""

    after = sgqlc.types.Field(String, graphql_name="after")
    """Cursor for forward pagination"""

    last = sgqlc.types.Field(Int, graphql_name="last")
    """Number of records to fetch for backward pagination"""

    before = sgqlc.types.Field(String, graphql_name="before")
    """Cursor for backward pagination"""

    sort_field = sgqlc.types.Field(TraceSortField, graphql_name="sortField")
    """Field to sort by"""

    sort_direction = sgqlc.types.Field(TraceSortDirection, graphql_name="sortDirection")
    """Sort direction"""


class GitlabNamespaceSelection(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("namespace_id", "select_all", "projects", "parents")
    namespace_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="namespaceId")
    """GitLab ID of the group or subgroup"""

    select_all = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="selectAll")
    """True if all projects in the namespace are selected"""

    projects = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name="projects")
    """Optional: List of GitLab projects IDs or NULL (=all projects)"""

    parents = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name="parents")
    """Optional: List of all parent namespace IDs"""


class ImportanceScoreTableStatsRule(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("operator", "value", "value_min", "value_max")
    operator = sgqlc.types.Field(
        sgqlc.types.non_null(ImportanceScoreOperator), graphql_name="operator"
    )
    """Comparison operator. Options include: ==, >=, <=, >, <, RANGE"""

    value = sgqlc.types.Field(Float, graphql_name="value")

    value_min = sgqlc.types.Field(Float, graphql_name="valueMin")

    value_max = sgqlc.types.Field(Float, graphql_name="valueMax")


class IncidentsFilterDataFilterType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("field_name", "value")
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="fieldName")

    value = sgqlc.types.Field(sgqlc.types.non_null(GenericScalar), graphql_name="value")


class IncidentsFilterDataRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("field_name", "search_criteria", "first", "after", "search_value")
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="fieldName")

    search_criteria = sgqlc.types.Field(
        sgqlc.types.non_null("IncidentsFilterDataSearchCriteriaType"), graphql_name="searchCriteria"
    )

    first = sgqlc.types.Field(Int, graphql_name="first")
    """Number of results to return"""

    after = sgqlc.types.Field(String, graphql_name="after")
    """Cursor to paginate results"""

    search_value = sgqlc.types.Field(String, graphql_name="searchValue")
    """Respond with filter values which contain this text"""


class IncidentsFilterDataSearchCriteriaType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("start_time", "end_time", "filters")
    start_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="startTime")
    """filter for incidents after or equal to this time"""

    end_time = sgqlc.types.Field(DateTime, graphql_name="endTime")
    """filter for incidents before this time"""

    filters = sgqlc.types.Field(
        sgqlc.types.list_of(IncidentsFilterDataFilterType), graphql_name="filters"
    )
    """List of filters to apply to incidents"""


class IndexedFieldFilterType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("field_name", "values", "operator")
    field_name = sgqlc.types.Field(String, graphql_name="fieldName")
    """Field name"""

    values = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="values")
    """Values to filter by"""

    operator = sgqlc.types.Field(FieldValueFilterOperator, graphql_name="operator")
    """comparison operator to use when filtering"""


class InformaticaConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("username", "password")
    username = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="username")
    """Username"""

    password = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="password")
    """Password"""


class InputObjectProperty(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("mcon_id", "property_name", "property_value", "property_source_type")
    mcon_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mconId")
    """Monte Carlo full identifier for an entity"""

    property_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="propertyName")
    """Name of the property (AKA tag key)"""

    property_value = sgqlc.types.Field(String, graphql_name="propertyValue")
    """Value of the property (AKA tag value)"""

    property_source_type = sgqlc.types.Field(String, graphql_name="propertySourceType")
    """Where property originated."""


class InviteUsersInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("emails", "client_mutation_id")
    emails = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name="emails"
    )

    client_mutation_id = sgqlc.types.Field(String, graphql_name="clientMutationId")


class IsImportantTableStatsRule(sgqlc.types.Input):
    """The key asset rule matches the is_important table stat"""

    __schema__ = schema
    __field_names__ = ("value",)
    value = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="value")


class JiraStatusMappingInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("incident_feedback", "jira_status")
    incident_feedback = sgqlc.types.Field(String, graphql_name="incidentFeedback")
    """The feedback that will be set on the Monte Carlo incident if the
    Jira ticket is set to any of the provided Jira statuses
    """

    jira_status = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="jiraStatus"
    )
    """The Jira statuses that will map to the Monte Carlo incident
    feedback
    """


class JiraWebhookConfigInput(sgqlc.types.Input):
    """Jira webhook config"""

    __schema__ = schema
    __field_names__ = ("status_mappings",)
    status_mappings = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(JiraStatusMappingInput)),
        graphql_name="statusMappings",
    )
    """Status mapping"""


class JobsPerformanceFacetFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("facet", "include_options", "exclude_options")
    facet = sgqlc.types.Field(sgqlc.types.non_null(JobPerformanceFacet), graphql_name="facet")
    """Facet these filter selections apply to"""

    include_options = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="includeOptions"
    )
    """Filter to include only these options, if provided"""

    exclude_options = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="excludeOptions"
    )
    """Filter to exclude these options, if provided"""


class JobsPerformanceFacetQueryInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("facet", "search")
    facet = sgqlc.types.Field(sgqlc.types.non_null(JobPerformanceFacet), graphql_name="facet")
    """The specific facet to get options/counts for"""

    search = sgqlc.types.Field(String, graphql_name="search")
    """Optional search text to use to filter the returned facet options"""


class JobsPerformanceFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("start_time", "end_time", "facet_filters", "job_mcons")
    start_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="startTime")
    """Starting time of period to query for"""

    end_time = sgqlc.types.Field(DateTime, graphql_name="endTime")
    """Ending time of period to query for"""

    facet_filters = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(JobsPerformanceFacetFilterInput)),
        graphql_name="facetFilters",
    )
    """All currently applied facet filters"""

    job_mcons = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="jobMcons"
    )
    """Job mcons to filter by"""


class JobsPerformancePagingInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("first", "after", "last", "before", "order_by", "order_direction")
    first = sgqlc.types.Field(Int, graphql_name="first")
    """Number of items to retrieve after the cursor. Defaults to 20 if no
    other paging parameters are provided
    """

    after = sgqlc.types.Field(String, graphql_name="after")
    """Starting cursor when paging forward"""

    last = sgqlc.types.Field(Int, graphql_name="last")
    """Number of items to retrieve before the cursor when paging backward"""

    before = sgqlc.types.Field(String, graphql_name="before")
    """Ending cursor when paging backward"""

    order_by = sgqlc.types.Field(JobsPerformanceSummarySort, graphql_name="orderBy")
    """Field by which to order the results. Defaults to
    LAST_RUN_START_TIME
    """

    order_direction = sgqlc.types.Field(EtlPerformanceSortDirection, graphql_name="orderDirection")
    """Sort direction. Defaults to EnumMeta.ASC"""


class LineageEdgeInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("source_mcon", "destination_mcon")
    source_mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="sourceMcon")
    """Source table MCON of an edge"""

    destination_mcon = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="destinationMcon"
    )
    """Destination table MCON of an edge"""


class LineageFilter(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("name", "values", "operator")
    name = sgqlc.types.Field(sgqlc.types.non_null(LineageFilterName), graphql_name="name")
    """Name of the filter"""

    values = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name="values"
    )
    """Filter values"""

    operator = sgqlc.types.Field(
        sgqlc.types.non_null(LineageFilterOperator), graphql_name="operator"
    )
    """Filter operator"""


class LookerConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("base_url", "client_id", "client_secret", "verify_ssl")
    base_url = sgqlc.types.Field(String, graphql_name="baseUrl")
    """Host url"""

    client_id = sgqlc.types.Field(String, graphql_name="clientId")
    """Looker client id"""

    client_secret = sgqlc.types.Field(String, graphql_name="clientSecret")
    """Looker client secret"""

    verify_ssl = sgqlc.types.Field(Boolean, graphql_name="verifySsl")
    """Verify SSL (uncheck for self-signed certs)"""


class LookerGitAuthConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("repo_url", "username", "token", "ssh_key")
    repo_url = sgqlc.types.Field(String, graphql_name="repoUrl")
    """For HTTPS the repository URL as https://server/project.gitFor SSH
    the repository URL as ssh://[user@]server/project.gitor the
    shorter form [user@]server:project.git
    """

    username = sgqlc.types.Field(String, graphql_name="username")
    """The git username"""

    token = sgqlc.types.Field(String, graphql_name="token")
    """The access token for git HTTPS integrations"""

    ssh_key = sgqlc.types.Field(String, graphql_name="sshKey")
    """SSH key, base64-encoded"""


class LookerGitAuthUpdateConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("ssh_key", "repo_url", "username", "token")
    ssh_key = sgqlc.types.Field(String, graphql_name="sshKey")
    """SSH key, base64-encoded"""

    repo_url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="repoUrl")
    """Repository URL as ssh://[user@]server/project.git or the shorter
    form [user@]server:project.git
    """

    username = sgqlc.types.Field(String, graphql_name="username")
    """Username for Git authentication"""

    token = sgqlc.types.Field(String, graphql_name="token")
    """Token for Git authentication"""


class LookerGitCloneConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("repo_url", "username", "token")
    repo_url = sgqlc.types.Field(String, graphql_name="repoUrl")
    """Repository URL as https://server/project.git"""

    username = sgqlc.types.Field(String, graphql_name="username")
    """The git username"""

    token = sgqlc.types.Field(String, graphql_name="token")
    """The access token for git HTTPS integrations"""


class LookerUpdateConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("base_url", "client_id", "client_secret", "verify_ssl")
    base_url = sgqlc.types.Field(String, graphql_name="baseUrl")
    """Host url"""

    client_id = sgqlc.types.Field(String, graphql_name="clientId")
    """Looker client id"""

    client_secret = sgqlc.types.Field(String, graphql_name="clientSecret")
    """Looker client secret"""

    verify_ssl = sgqlc.types.Field(Boolean, graphql_name="verifySsl")
    """Verify SSL (uncheck for self-signed certs)"""


class MergeAlertsInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("id", "severity", "status", "name")
    id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="id")
    """UUID of the alert to update"""

    severity = sgqlc.types.Field(SeverityInput, graphql_name="severity")
    """By assigning a severity to the alert, the alert will be declared
    an incident
    """

    status = sgqlc.types.Field(AlertStatusInput, graphql_name="status")
    """Status to assign to the alert."""

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Custom name for the alert."""


class MetricAggregationInputType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("metric", "aggregation")
    metric = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="metric")
    """Query performance metric"""

    aggregation = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="aggregation")
    """Metric aggregation function"""


class MetricAlertConditionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "metric",
        "custom_metric",
        "fields",
        "type",
        "operator",
        "threshold_value",
        "lower_threshold",
        "upper_threshold",
        "id",
    )
    metric = sgqlc.types.Field(String, graphql_name="metric")

    custom_metric = sgqlc.types.Field(CustomMetricInput, graphql_name="customMetric")

    fields = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="fields"
    )

    type = sgqlc.types.Field(String, graphql_name="type")

    operator = sgqlc.types.Field(String, graphql_name="operator")

    threshold_value = sgqlc.types.Field(Float, graphql_name="thresholdValue")

    lower_threshold = sgqlc.types.Field(Float, graphql_name="lowerThreshold")

    upper_threshold = sgqlc.types.Field(Float, graphql_name="upperThreshold")

    id = sgqlc.types.Field(String, graphql_name="id")


class MetricsFilter(sgqlc.types.Input):
    """Filters for the metrics to be fetched"""

    __schema__ = schema
    __field_names__ = (
        "monitor_id",
        "mcon",
        "full_table_id",
        "dw_id",
        "segments_filter",
        "where_condition",
        "label",
        "field",
        "ootb",
        "data_source_uuid",
    )
    monitor_id = sgqlc.types.Field(UUID, graphql_name="monitorId")
    """UUID of the monitor or custom rule"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """MCON of the asset tracked by the metrics to be fetched"""

    full_table_id = sgqlc.types.Field(String, graphql_name="fullTableId")
    """Full table ID of the table tracked by the metrics to be fetched"""

    dw_id = sgqlc.types.Field(UUID, graphql_name="dwId")
    """Warehouse UUID of the asset tracked by the metrics to be fetched"""

    segments_filter = sgqlc.types.Field(
        sgqlc.types.list_of("SegmentsFilter"), graphql_name="segmentsFilter"
    )
    """DEPRECATED: use whereCondition or label instead. Call will fail."""

    where_condition = sgqlc.types.Field(String, graphql_name="whereCondition")
    """Filter to the segment with this value as the whereCondition."""

    label = sgqlc.types.Field(String, graphql_name="label")
    """Filter to the segment with this value as the label."""

    field = sgqlc.types.Field(String, graphql_name="field")
    """Field name for filtering based on fields for field health monitors"""

    ootb = sgqlc.types.Field(Boolean, graphql_name="ootb")
    """Indicates whether to get the datapoints for out-of-the-box metric.
    If this is true, then the monitor_id parameter will be ignored.
    """

    data_source_uuid = sgqlc.types.Field(UUID, graphql_name="dataSourceUuid")
    """UUID of the data source associated with the metric. Used to
    differentiate source vs. target metric.
    """


class ModifyCollectionBlockListInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "id",
        "resource_id",
        "project",
        "dataset",
        "table_name",
        "match_type",
        "effect",
    )
    id = sgqlc.types.Field(String, graphql_name="id")
    """ID of the rule. If provided, the rule will be updated instead of
    created.
    """

    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="resourceId")
    """Warehouse that the collection preference belongs to."""

    project = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="project")
    """Value used to match against project/database."""

    dataset = sgqlc.types.Field(String, graphql_name="dataset")
    """Value used to match against dataset/schema."""

    table_name = sgqlc.types.Field(String, graphql_name="tableName")
    """Value used to match against table name."""

    match_type = sgqlc.types.Field(
        sgqlc.types.non_null(CollectionPreferenceMatchType), graphql_name="matchType"
    )

    effect = sgqlc.types.Field(CollectionPreferenceEffectType, graphql_name="effect")


class MonitorConfigurationInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("mcon", "time_fields")
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """MC mcon"""

    time_fields = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("TimestampResult")), graphql_name="timeFields"
    )
    """field and timestamp for monitor configuration"""


class MonitorRecommendationsInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("dataset", "field_names", "recommendation_type", "models")
    dataset = sgqlc.types.Field(sgqlc.types.non_null(DatasetInput), graphql_name="dataset")

    field_names = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="fieldNames")
    """Recommend monitors for specific field names"""

    recommendation_type = sgqlc.types.Field(
        MonitorRecommendationType, graphql_name="recommendationType"
    )
    """Generate this type of monitor recommendations"""

    models = sgqlc.types.Field(
        sgqlc.types.list_of(MonitorRecommendationModel), graphql_name="models"
    )
    """Recommend monitors for specific models. Default for HEURISTIC is
    VALIDATION, METRIC and for AI_VALIDATION is VALIDATION,
    SEGMENTATION, REGEX
    """


class MonitorSamplingConfigInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("percentage", "count")
    percentage = sgqlc.types.Field(Float, graphql_name="percentage")

    count = sgqlc.types.Field(Int, graphql_name="count")


class MonitorSelectExpressionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("expression", "data_type")
    expression = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="expression")
    """SQL select expression, could be a raw column name or a more
    complex expression
    """

    data_type = sgqlc.types.Field(String, graphql_name="dataType")
    """Data type of expression. Required if expression is a complex
    expression and not a raw column name
    """


class MonitoredTableRuleInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "is_exclude",
        "rule_type",
        "table_rule_text",
        "table_rule_attribute",
        "id",
        "monitored_rule_type",
    )
    is_exclude = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isExclude")
    """Whether the rule is an exclusion rule"""

    rule_type = sgqlc.types.Field(MonitoredTableRuleType, graphql_name="ruleType")
    """Deprecated, use monitored_rule_type"""

    table_rule_text = sgqlc.types.Field(String, graphql_name="tableRuleText")
    """The rule. If rule_type=ALL, this field must be empty.If the rule
    is a tag rule, this field must be a JSON string. Construct the
    tags in this format: If tags are 'monitor' and 'importance:high'
    (where monitor & importance are the propertyName and null & high
    are the propertyValue. See
    [ObjectProperty]({{Types.ObjectProperty}})), then pass in
    '[["monitor",null],["name","value"]]'
    """

    table_rule_attribute = sgqlc.types.Field(
        MonitoredTableRuleTableAttribute, graphql_name="tableRuleAttribute"
    )
    """Table attribute to match against. Omit if rule_type=ALL. If
    rule_type != ALL, and this field is omitted, by default the rule
    will match against table_id.
    """

    id = sgqlc.types.Field(String, graphql_name="id")
    """ID of the rule. If provided, the rule will be updated instead of
    created.
    """

    monitored_rule_type = sgqlc.types.Field(MonitoredRuleType, graphql_name="monitoredRuleType")
    """Monitoring rule type"""


class MonteCarloStatusMappingInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("servicenow_incident_state", "incident_feedback")
    servicenow_incident_state = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="servicenowIncidentState"
    )

    incident_feedback = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="incidentFeedback",
    )


class MskKafkaConnectCredentialsInput(sgqlc.types.Input):
    """Credentials for MSK Kafka Connect"""

    __schema__ = schema
    __field_names__ = ("cluster_arn", "iam_role_arn", "external_id")
    cluster_arn = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="clusterArn")
    """ARN of the MSK cluster that connectors are running against"""

    iam_role_arn = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="iamRoleArn")
    """ARN of an assumable IAM role used for collection, see our public
    docs for required permissions
    """

    external_id = sgqlc.types.Field(String, graphql_name="externalId")
    """Optional external id, if one is required to assume the provided
    IAM role
    """


class NodeInput(sgqlc.types.Input):
    """Minimal information to identify a node"""

    __schema__ = schema
    __field_names__ = ("object_type", "object_id", "resource_id", "resource_name")
    object_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="objectType")
    """Object type"""

    object_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="objectId")
    """Object identifier"""

    resource_id = sgqlc.types.Field(UUID, graphql_name="resourceId")
    """The id of the resource containing the node"""

    resource_name = sgqlc.types.Field(String, graphql_name="resourceName")
    """The name of the resource containing the node"""


class NotificationDigestSettings(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("start_time", "interval_minutes", "digest_type")
    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """Start time of scheduled digest. If not set, by default it is UTC
    00:00 daily
    """

    interval_minutes = sgqlc.types.Field(Int, graphql_name="intervalMinutes")
    """Interval of how frequently to run the schedule. If not set, by
    default it is 1440 minutes(24h)
    """

    digest_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="digestType")
    """Type of digest. Supported options include: anomalies_digest,
    misconf_digest, inactive_digest
    """


class NotificationExtra(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "slack_is_private",
        "webhook_shared_secret",
        "webhook_encrypted_secret",
        "team_id",
        "team_name",
        "priority",
        "url",
        "username",
        "password",
        "dc_proxy",
        "turn_off_normalized_messages",
        "receive_normalized",
        "disable_ssl_verification",
        "include_incident_fields",
        "jira_project_id",
        "jira_issue_type_id",
        "pd_severity_error",
        "ado_project",
        "ado_work_item_type",
        "schema_version",
    )
    slack_is_private = sgqlc.types.Field(Boolean, graphql_name="slackIsPrivate")
    """Skip attempting to join if the channel is private. Requires a
    channel invitation first
    """

    webhook_shared_secret = sgqlc.types.Field(String, graphql_name="webhookSharedSecret")
    """An optional shared signing secret to use for validating the
    integrity of information when using a webhook integration
    """

    webhook_encrypted_secret = sgqlc.types.Field(String, graphql_name="webhookEncryptedSecret")
    """This field should be provided by the frontend when an update is
    being done to the notification setting and a shared secret key
    already existed for the web hook
    """

    team_id = sgqlc.types.Field(String, graphql_name="teamId")
    """The team ID to use when sending notifications to a Slack workspace"""

    team_name = sgqlc.types.Field(String, graphql_name="teamName")
    """The team ID to use when sending notifications to a Slack workspace"""

    priority = sgqlc.types.Field(String, graphql_name="priority")
    """Priority in remote notification system (Opsgenie)"""

    url = sgqlc.types.Field(String, graphql_name="url")
    """API URL (Opsgenie, use this for regional URLs)"""

    username = sgqlc.types.Field(String, graphql_name="username")
    """Username for external notification integration"""

    password = sgqlc.types.Field(String, graphql_name="password")
    """Password for external notification integration"""

    dc_proxy = sgqlc.types.Field(Boolean, graphql_name="dcProxy")
    """True if HTTP requests should be proxied through the Data Collector"""

    turn_off_normalized_messages = sgqlc.types.Field(
        Boolean, graphql_name="turnOffNormalizedMessages"
    )
    """True if normalized messages need to be turned off. DEPRECATED: Use
    receiveNormalized instead.
    """

    receive_normalized = sgqlc.types.Field(Boolean, graphql_name="receiveNormalized")
    """True if normalized messages should be received"""

    disable_ssl_verification = sgqlc.types.Field(Boolean, graphql_name="disableSslVerification")
    """True if HTTP requests proxied through the Data Collector should
    not verify SSL certificates
    """

    include_incident_fields = sgqlc.types.Field(JSONString, graphql_name="includeIncidentFields")
    """Field-value pairs to include as additional fields (when creating
    incidents in ServiceNow, Datadog or JIRA)
    """

    jira_project_id = sgqlc.types.Field(Int, graphql_name="jiraProjectId")
    """Project Id for Jira"""

    jira_issue_type_id = sgqlc.types.Field(Int, graphql_name="jiraIssueTypeId")
    """Issue Type Id for Jira"""

    pd_severity_error = sgqlc.types.Field(Boolean, graphql_name="pdSeverityError")
    """True if must send events to PagerDuty with severity error, for
    high urgency incidents
    """

    ado_project = sgqlc.types.Field(String, graphql_name="adoProject")
    """Project name for Azure DevOps"""

    ado_work_item_type = sgqlc.types.Field(String, graphql_name="adoWorkItemType")
    """Work item type for Azure DevOps (Bug, Task, Issue, etc.)"""

    schema_version = sgqlc.types.Field(String, graphql_name="schemaVersion")
    """Version of the notification settings schema"""


class NotificationRoutingRules(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "project_names",
        "project_mcons",
        "dataset_ids",
        "full_table_ids",
        "table_mcons",
        "rule_ids",
        "domain_ids",
        "tag_keys",
        "tag_key_values",
        "all_tag_key_values",
        "table_stats_rules",
        "monitor_labels",
        "monitor_labels_match_type",
        "exclude_project_names",
        "exclude_project_mcons",
        "exclude_dataset_ids",
        "exclude_full_table_ids",
        "exclude_table_mcons",
        "exclude_tag_keys",
        "exclude_tag_key_values",
        "exclude_all_tag_key_values",
        "table_regex",
    )
    project_names = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="projectNames")
    """Allowlist by project names"""

    project_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="projectMcons")
    """Allowlist by project mcons"""

    dataset_ids = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name="datasetIds")
    """Allowlist by dataset identifiers"""

    full_table_ids = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="fullTableIds")
    """Allowlist by full table identifiers"""

    table_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="tableMcons")
    """Allowlist by table mcons"""

    rule_ids = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name="ruleIds")
    """Allowlist by rule identifiers"""

    domain_ids = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name="domainIds")
    """Allowlist by domain identifiers"""

    tag_keys = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="tagKeys")
    """Allowlist by tag keys"""

    tag_key_values = sgqlc.types.Field(
        sgqlc.types.list_of("NotificationTagPairs"), graphql_name="tagKeyValues"
    )
    """Allowlist by tag key/value pairs"""

    all_tag_key_values = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.list_of("NotificationTagPairs")),
        graphql_name="allTagKeyValues",
    )

    table_stats_rules = sgqlc.types.Field("TableStatsRules", graphql_name="tableStatsRules")
    """Allowlist by table stats (importance_score, is_important)."""

    monitor_labels = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name="monitorLabels")
    """Allowlist by monitor labels"""

    monitor_labels_match_type = sgqlc.types.Field(
        MonitorLabelsMatchType, graphql_name="monitorLabelsMatchType"
    )
    """Logic operator for matching labels. Defaults to OR."""

    exclude_project_names = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="excludeProjectNames"
    )
    """Denylist by project names"""

    exclude_project_mcons = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="excludeProjectMcons"
    )
    """Denylist by project mcons"""

    exclude_dataset_ids = sgqlc.types.Field(
        sgqlc.types.list_of(UUID), graphql_name="excludeDatasetIds"
    )
    """Denylist by dataset identifiers"""

    exclude_full_table_ids = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="excludeFullTableIds"
    )
    """Denylist by full table identifiers"""

    exclude_table_mcons = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="excludeTableMcons"
    )
    """Denylist by table mcon identifiers"""

    exclude_tag_keys = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="excludeTagKeys")
    """Denylist by tag keys"""

    exclude_tag_key_values = sgqlc.types.Field(
        sgqlc.types.list_of("NotificationTagPairs"), graphql_name="excludeTagKeyValues"
    )
    """Denylist by tag key/value pairs"""

    exclude_all_tag_key_values = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.list_of("NotificationTagPairs")),
        graphql_name="excludeAllTagKeyValues",
    )

    table_regex = sgqlc.types.Field(String, graphql_name="tableRegex")
    """For use in updating regex based rules"""


class NotificationTagPairs(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("name", "value")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Tag key"""

    value = sgqlc.types.Field(String, graphql_name="value")
    """Tag Value"""


class NumericFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("field_name", "ranges")
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="fieldName")
    """Field name to filter on"""

    ranges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("NumericRangeInput")), graphql_name="ranges"
    )
    """Numeric ranges to filter by (combined via OR)"""


class NumericRangeInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("lower_bound_value", "upper_bound_value")
    lower_bound_value = sgqlc.types.Field(Int, graphql_name="lowerBoundValue")
    """Numeric range end value"""

    upper_bound_value = sgqlc.types.Field(Int, graphql_name="upperBoundValue")
    """Numeric range start value"""


class OAuthConfiguration(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "client_id",
        "client_secret",
        "grant_type",
        "access_token_endpoint",
        "scope",
        "username",
        "password",
    )
    client_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="clientId")
    """Oauth Client ID"""

    client_secret = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="clientSecret")
    """Oauth Client Secret"""

    grant_type = sgqlc.types.Field(
        sgqlc.types.non_null(OAuthGrantTypeEnum), graphql_name="grantType"
    )
    """OAuth Grant type. Can be one of (client_credentials, password)"""

    access_token_endpoint = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="accessTokenEndpoint"
    )
    """OAuth endpoint used to acquire access tokens"""

    scope = sgqlc.types.Field(String, graphql_name="scope")
    """OAuth Scope"""

    username = sgqlc.types.Field(String, graphql_name="username")
    """OAuth Username for oauth password grant flow"""

    password = sgqlc.types.Field(String, graphql_name="password")
    """OAuth Password for oauth password grant flow"""


class ObjectPropertyInput(sgqlc.types.Input):
    """Object properties, indexed by the search service"""

    __schema__ = schema
    __field_names__ = ("property_name", "property_value")
    property_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="propertyName")
    """The name (key) of the property"""

    property_value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="propertyValue")
    """The value for the property"""


class PiiFilterStatusPair(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("filter_name", "enabled")
    filter_name = sgqlc.types.Field(String, graphql_name="filterName")
    """The unique name of the PII filter."""

    enabled = sgqlc.types.Field(Boolean, graphql_name="enabled")
    """Whether the PII filter should be enabled or not."""


class PineconeConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("environment", "project_id", "api_key")
    environment = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="environment")
    """Identifier of Pinecone environment (e.g. us-east-1-aws)."""

    project_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="projectId")
    """Identifier of Pinecone project."""

    api_key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="apiKey")
    """API key for Pinecone project."""


class PineconeUpdateConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("environment", "project_id", "api_key")
    environment = sgqlc.types.Field(String, graphql_name="environment")
    """Identifier of Pinecone environment (e.g. us-east-1-aws)."""

    project_id = sgqlc.types.Field(String, graphql_name="projectId")
    """Identifier of Pinecone project."""

    api_key = sgqlc.types.Field(String, graphql_name="apiKey")
    """API key for Pinecone project."""


class PowerBIConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "tenant_id",
        "auth_mode",
        "client_id",
        "client_secret",
        "username",
        "password",
    )
    tenant_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="tenantId")
    """Azure Power BI tenant uuid"""

    auth_mode = sgqlc.types.Field(
        sgqlc.types.non_null(PowerBIAuthModeEnumV2), graphql_name="authMode"
    )
    """Authentication mode. We support two values here
    [service_principal, primary_user]
    """

    client_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="clientId")
    """App Client UUID"""

    client_secret = sgqlc.types.Field(String, graphql_name="clientSecret")
    """Secret key for the client ID. Required if auth_mode is
    service_principal.
    """

    username = sgqlc.types.Field(String, graphql_name="username")
    """Username when auth as a primary user. Required if auth_mode is
    primary_user.
    """

    password = sgqlc.types.Field(String, graphql_name="password")
    """Password when auth as a primary user. Required if auth_mode is
    primary_user.
    """


class PowerBiUpdateConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "tenant_id",
        "auth_mode",
        "client_id",
        "client_secret",
        "username",
        "password",
    )
    tenant_id = sgqlc.types.Field(String, graphql_name="tenantId")
    """Azure Power BI tenant uuid"""

    auth_mode = sgqlc.types.Field(
        sgqlc.types.non_null(PowerBIUpdateAuthModeEnumV2), graphql_name="authMode"
    )
    """Authentication mode. We support two values here
    [service_principal, primary_user]
    """

    client_id = sgqlc.types.Field(String, graphql_name="clientId")
    """App Client UUID"""

    client_secret = sgqlc.types.Field(String, graphql_name="clientSecret")
    """Secret key for the client ID. Required if auth_mode is
    service_principal.
    """

    username = sgqlc.types.Field(String, graphql_name="username")
    """Username when auth as a primary user. Required if auth_mode is
    primary_user.
    """

    password = sgqlc.types.Field(String, graphql_name="password")
    """Password when auth as a primary user. Required if auth_mode is
    primary_user.
    """


class ProjectFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("project_mcons",)
    project_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="projectMcons")
    """MCONs of projects to filter by."""


class PullRequestFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("filter_name", "values")
    filter_name = sgqlc.types.Field(PullRequestFilterName, graphql_name="filterName")
    """Name of the filter"""

    values = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="values")
    """Values and counts of the filter"""


class QPMonitorConfigInputType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("metadata", "comparisons")
    metadata = sgqlc.types.Field(
        sgqlc.types.non_null("QuerySelectionInput"), graphql_name="metadata"
    )
    """Query selection"""

    comparisons = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(CustomRuleComparisonInput)),
        graphql_name="comparisons",
    )
    """Comparisons"""


class QueryLogsFacetRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "field_name",
        "search_criteria",
        "apply_mask",
        "first",
        "search_prefix",
        "included_query_types",
    )
    field_name = sgqlc.types.Field(String, graphql_name="fieldName")
    """Field name"""

    search_criteria = sgqlc.types.Field("SearchCriteriaType", graphql_name="searchCriteria")

    apply_mask = sgqlc.types.Field(Boolean, graphql_name="applyMask")
    """Apply mask"""

    first = sgqlc.types.Field(Int, graphql_name="first")
    """First"""

    search_prefix = sgqlc.types.Field(String, graphql_name="searchPrefix")
    """Search facets by prefix"""

    included_query_types = sgqlc.types.Field(
        sgqlc.types.list_of(QueryLogType), graphql_name="includedQueryTypes"
    )
    """The query log types we want to include in the time series
    aggregation. The options are [READ], [WRITE] or [READ, WRITE]
    """


class QueryLogsFacetRequestTypeV2(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("requests",)
    requests = sgqlc.types.Field(
        sgqlc.types.list_of(QueryLogsFacetRequestType), graphql_name="requests"
    )


class QueryLogsRequestInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "search_criteria",
        "query_group_field",
        "query_runtime_field",
        "sort_field",
        "sort_order",
        "first",
        "offset",
        "included_query_types",
    )
    search_criteria = sgqlc.types.Field(
        sgqlc.types.non_null("SearchCriteriaType"), graphql_name="searchCriteria"
    )

    query_group_field = sgqlc.types.Field(String, graphql_name="queryGroupField")

    query_runtime_field = sgqlc.types.Field(String, graphql_name="queryRuntimeField")

    sort_field = sgqlc.types.Field(String, graphql_name="sortField")

    sort_order = sgqlc.types.Field(String, graphql_name="sortOrder")

    first = sgqlc.types.Field(Int, graphql_name="first")

    offset = sgqlc.types.Field(Int, graphql_name="offset")

    included_query_types = sgqlc.types.Field(
        sgqlc.types.list_of(QueryLogType), graphql_name="includedQueryTypes"
    )
    """Query types to include in the results. Can be READ, WRITE or both.
    By default it will use WRITE
    """


class QueryPerformanceDataRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("search_criteria", "query_group_values", "time_bucket_size", "metrics")
    search_criteria = sgqlc.types.Field("SearchCriteriaType", graphql_name="searchCriteria")
    """Query search criteria"""

    query_group_values = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name="queryGroupValues"
    )
    """Query group identifiers"""

    time_bucket_size = sgqlc.types.Field(String, graphql_name="timeBucketSize")
    """Size of time buckets"""

    metrics = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(MetricAggregationInputType)),
        graphql_name="metrics",
    )
    """Metric aggregations"""


class QueryRuntimePercentileTimeSeriesRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("search_criteria", "time_bucket_size", "percentiles", "included_query_types")
    search_criteria = sgqlc.types.Field("SearchCriteriaType", graphql_name="searchCriteria")

    time_bucket_size = sgqlc.types.Field(String, graphql_name="timeBucketSize")

    percentiles = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(Int)), graphql_name="percentiles"
    )
    """Each time series returned will be for a given percentile. Examples
    are: 50, 75, 95. 99, 100
    """

    included_query_types = sgqlc.types.Field(
        sgqlc.types.list_of(QueryLogType), graphql_name="includedQueryTypes"
    )
    """The query log types we want to include in the time series
    aggregation. The options are [READ], [WRITE] or [READ, WRITE]
    """


class QuerySelectionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("query_type", "indexed_field_filters")
    query_type = sgqlc.types.Field(sgqlc.types.non_null(QueryLogType), graphql_name="queryType")
    """Type of the monitored queries"""

    indexed_field_filters = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(IndexedFieldFilterType)),
        graphql_name="indexedFieldFilters",
    )
    """Selection criteria of the monitored queries"""


class QueryTemplateVariableValueInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("name", "value", "value_json")
    name = sgqlc.types.Field(String, graphql_name="name")
    """Variable name"""

    value = sgqlc.types.Field(String, graphql_name="value")
    """Variable value"""

    value_json = sgqlc.types.Field(JSONString, graphql_name="valueJson")
    """Variable value (in JSON)"""


class RedshiftConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("db_name", "host", "port", "user", "password")
    db_name = sgqlc.types.Field(String, graphql_name="dbName")
    """Name of database to add connection for"""

    host = sgqlc.types.Field(String, graphql_name="host")
    """Hostname of the warehouse"""

    port = sgqlc.types.Field(Int, graphql_name="port")
    """HTTP Port to use"""

    user = sgqlc.types.Field(String, graphql_name="user")
    """User with access to the database"""

    password = sgqlc.types.Field(String, graphql_name="password")
    """User's password"""


class RedshiftUpdateConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("db_name", "host", "port", "user", "password")
    db_name = sgqlc.types.Field(String, graphql_name="dbName")
    """Name of database to add connection for"""

    host = sgqlc.types.Field(String, graphql_name="host")
    """Hostname of the warehouse"""

    port = sgqlc.types.Field(Int, graphql_name="port")
    """HTTP Port to use"""

    user = sgqlc.types.Field(String, graphql_name="user")
    """User with access to the database"""

    password = sgqlc.types.Field(String, graphql_name="password")
    """User's password"""


class ReportArgumentsUnionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("alert_id", "monitor_id", "type")
    alert_id = sgqlc.types.Field(UUID, graphql_name="alertId")

    monitor_id = sgqlc.types.Field(UUID, graphql_name="monitorId")

    type = sgqlc.types.Field(sgqlc.types.non_null(ReportTypeEnum), graphql_name="type")


class RetrieveTableDataRequestInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("dataset", "order_by", "limit")
    dataset = sgqlc.types.Field(sgqlc.types.non_null(DatasetInput), graphql_name="dataset")

    order_by = sgqlc.types.Field(String, graphql_name="orderBy")

    limit = sgqlc.types.Field(Int, graphql_name="limit")


class RetrieveWidgetDataRequestInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "dataset",
        "widget_type",
        "field_name",
        "limit",
        "offset",
        "config",
        "widget_config",
    )
    dataset = sgqlc.types.Field(sgqlc.types.non_null(DatasetInput), graphql_name="dataset")

    widget_type = sgqlc.types.Field(sgqlc.types.non_null(WidgetType), graphql_name="widgetType")

    field_name = sgqlc.types.Field(String, graphql_name="fieldName")

    limit = sgqlc.types.Field(Int, graphql_name="limit")

    offset = sgqlc.types.Field(Int, graphql_name="offset")

    config = sgqlc.types.Field(JSONString, graphql_name="config")
    """DEPRECATED - use widget_config"""

    widget_config = sgqlc.types.Field("WidgetConfig", graphql_name="widgetConfig")
    """Widget configuration"""


class RuntimeVariableValueInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("name", "value")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")

    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")


class ScheduleConfigInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "schedule_type",
        "interval_minutes",
        "dynamic_schedule_mcons",
        "interval_crontab",
        "interval_crontab_day_or",
        "start_time",
        "min_interval_minutes",
        "timezone",
    )
    schedule_type = sgqlc.types.Field(
        sgqlc.types.non_null(ScheduleType), graphql_name="scheduleType"
    )
    """Type of schedule"""

    interval_minutes = sgqlc.types.Field(Int, graphql_name="intervalMinutes")
    """Time interval between job executions, in minutes"""

    dynamic_schedule_mcons = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="dynamicScheduleMcons"
    )
    """Mcons of tables to trigger schedule on update"""

    interval_crontab = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="intervalCrontab"
    )
    """Time interval between job executions, using a cron expression"""

    interval_crontab_day_or = sgqlc.types.Field(Boolean, graphql_name="intervalCrontabDayOr")
    """If true, use default cron behavior and run when day-of-month OR
    day-of-week match. If false, use alternate behavior and run when
    day-of-month AND day-of-week match.
    """

    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """For schedule_type=fixed, the date the schedule should start"""

    min_interval_minutes = sgqlc.types.Field(Int, graphql_name="minIntervalMinutes")
    """For schedule_type=dynamic, the minimum time interval between job
    executions
    """

    timezone = sgqlc.types.Field(String, graphql_name="timezone")
    """Timezone for daylight savings and interpreting cron expressions."""


class SchemaFieldInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("name", "type", "mode", "nested", "sql_name", "main_type")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")

    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="type")

    mode = sgqlc.types.Field(FieldMode, graphql_name="mode")

    nested = sgqlc.types.Field(Boolean, graphql_name="nested")

    sql_name = sgqlc.types.Field(String, graphql_name="sqlName")

    main_type = sgqlc.types.Field(FieldType, graphql_name="mainType")


class SearchCriteriaType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "indexed_field_filters",
        "query_group",
        "start_time",
        "end_time",
        "query_group_field",
        "query_ids",
        "require_runtime_field",
    )
    indexed_field_filters = sgqlc.types.Field(
        sgqlc.types.list_of(IndexedFieldFilterType), graphql_name="indexedFieldFilters"
    )
    """List of indexed field filters"""

    query_group = sgqlc.types.Field(String, graphql_name="queryGroup")

    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """start time, overrides days_back"""

    end_time = sgqlc.types.Field(DateTime, graphql_name="endTime")
    """end time, overrides days_back"""

    query_group_field = sgqlc.types.Field(String, graphql_name="queryGroupField")

    query_ids = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="queryIds")
    """List of query ids"""

    require_runtime_field = sgqlc.types.Field(Boolean, graphql_name="requireRuntimeField")
    """When set, only return queries with the execution_time_ms_l field
    present
    """


class SegmentCountQueryInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "connection_id",
        "data_source",
        "mcon",
        "segmented_expressions",
        "time_axis_name",
        "time_axis_type",
        "agg_time_interval",
        "lookback_days",
        "where_condition",
        "preview",
    )
    connection_id = sgqlc.types.Field(UUID, graphql_name="connectionId")
    """Connection UUID to use for the query"""

    data_source = sgqlc.types.Field(DataSourceUnionInput, graphql_name="dataSource")
    """Target data source"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Mcon of the target table"""

    segmented_expressions = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="segmentedExpressions",
    )
    """Segmentation fields/expressions"""

    time_axis_name = sgqlc.types.Field(String, graphql_name="timeAxisName")
    """Time axis name"""

    time_axis_type = sgqlc.types.Field(String, graphql_name="timeAxisType")
    """Time axis type"""

    agg_time_interval = sgqlc.types.Field(MonitorAggTimeInterval, graphql_name="aggTimeInterval")
    """Aggregation time interval to use. (defaults to HOUR)"""

    lookback_days = sgqlc.types.Field(Int, graphql_name="lookbackDays")
    """History days for the monitor"""

    where_condition = sgqlc.types.Field(String, graphql_name="whereCondition")
    """WHERE condition to apply to the query"""

    preview = sgqlc.types.Field(Boolean, graphql_name="preview")
    """Whether query fetches a preview of segments instead of a total
    count
    """


class SegmentsFilter(sgqlc.types.Input):
    """A segment key and its value"""

    __schema__ = schema
    __field_names__ = ("key", "value")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    """The segment name"""

    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")
    """Value of the segment"""


class SelfHostedCredentialsConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "connection_type",
        "self_hosted_credentials_type",
        "decryption_service_type",
        "env_var_name",
        "kms_key_id",
        "aws_secret",
        "aws_region",
        "assumable_role",
        "external_id",
    )
    connection_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="connectionType")
    """Connection type to test credentials for (e.g. 'snowflake')"""

    self_hosted_credentials_type = sgqlc.types.Field(
        sgqlc.types.non_null(SelfHostedCredentialsTypeEnum),
        graphql_name="selfHostedCredentialsType",
    )
    """Self-hosted credentials type (e.g. 'env_var',
    'aws_secrets_manager')
    """

    decryption_service_type = sgqlc.types.Field(
        DecryptionServiceTypeEnum, graphql_name="decryptionServiceType"
    )
    """Optional type of service used to decrypt environment variable
    credentials (e.g. 'kms'). Required when
    self_hosted_credentials_type is 'env_var'.
    """

    env_var_name = sgqlc.types.Field(String, graphql_name="envVarName")
    """Name of environment variable containing credentials. Required when
    self_hosted_credentials_type is 'env_var'.
    """

    kms_key_id = sgqlc.types.Field(String, graphql_name="kmsKeyId")
    """Optional KMS key id for decrypting environment variable
    credentials. Required when decryption_service_type is 'kms'.
    """

    aws_secret = sgqlc.types.Field(String, graphql_name="awsSecret")
    """ARN or name of AWS Secret Manager secret containing credentials.
    Required when self_hosted_credentials_type is
    'aws_secrets_manager'.
    """

    aws_region = sgqlc.types.Field(String, graphql_name="awsRegion")
    """Optional AWS region to access ASM secret or KMS key"""

    assumable_role = sgqlc.types.Field(String, graphql_name="assumableRole")
    """Optional ARN of AWS role to assume when accessing secret manager
    secret or KMS key
    """

    external_id = sgqlc.types.Field(String, graphql_name="externalId")
    """Optional external id for AWS assumable role"""


class SelfHostedKafkaConnectCredentialsInput(sgqlc.types.Input):
    """Credentials to a Self Hosted Kafka Cluster"""

    __schema__ = schema
    __field_names__ = ("cluster", "auth_type", "auth_token", "url")
    cluster = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cluster")
    """Self Hosted Kafka Connect cluster."""

    auth_type = sgqlc.types.Field(sgqlc.types.non_null(AuthType), graphql_name="authType")
    """Type of Auth used to connect to the cluster."""

    auth_token = sgqlc.types.Field(String, graphql_name="authToken")
    """Authentication Token. Required for Basic and Bearer Auth."""

    url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="url")
    """URL for the Self Hosted kafka connect cluster."""


class SelfHostedKafkaCredentialsInput(sgqlc.types.Input):
    """Credentials to a Self Hosted Kafka Cluster"""

    __schema__ = schema
    __field_names__ = ("cluster", "auth_type", "auth_token", "url")
    cluster = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cluster")
    """Self Hosted Kafka cluster."""

    auth_type = sgqlc.types.Field(sgqlc.types.non_null(AuthType), graphql_name="authType")
    """Type of Auth used to connect to the cluster."""

    auth_token = sgqlc.types.Field(String, graphql_name="authToken")
    """Authentication Token. Required for Basic and Bearer Auth."""

    url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="url")
    """URL for the Self Hosted kafka cluster."""


class SelfHostedUpdateCredentialsConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "self_hosted_credentials_type",
        "decryption_service_type",
        "env_var_name",
        "kms_key_id",
        "aws_secret",
        "aws_region",
        "assumable_role",
        "external_id",
    )
    self_hosted_credentials_type = sgqlc.types.Field(
        SelfHostedUpdateCredentialsTypeEnum, graphql_name="selfHostedCredentialsType"
    )
    """Self-hosted credentials type (e.g. 'env_var',
    'aws_secrets_manager')
    """

    decryption_service_type = sgqlc.types.Field(
        DecryptionServiceUpdateTypeEnum, graphql_name="decryptionServiceType"
    )
    """Optional type of service used to decrypt environment variable
    credentials (e.g. 'kms'). Required when
    self_hosted_credentials_type is 'env_var'.
    """

    env_var_name = sgqlc.types.Field(String, graphql_name="envVarName")
    """Name of environment variable containing credentials. Required when
    self_hosted_credentials_type is 'env_var'.
    """

    kms_key_id = sgqlc.types.Field(String, graphql_name="kmsKeyId")
    """Optional KMS key id for decrypting environment variable
    credentials. Required when decryption_service_type is 'kms'.
    """

    aws_secret = sgqlc.types.Field(String, graphql_name="awsSecret")
    """ARN or name of AWS Secret Manager secret containing credentials.
    Required when self_hosted_credentials_type is
    'aws_secrets_manager'.
    """

    aws_region = sgqlc.types.Field(String, graphql_name="awsRegion")
    """Optional AWS region to access ASM secret or KMS key"""

    assumable_role = sgqlc.types.Field(String, graphql_name="assumableRole")
    """Optional ARN of AWS role to assume when accessing secret manager
    secret or KMS key
    """

    external_id = sgqlc.types.Field(String, graphql_name="externalId")
    """Optional external id for AWS assumable role"""


class SensitivityInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("level",)
    level = sgqlc.types.Field(SensitivityLevels, graphql_name="level")
    """Low, medium or high sensitivity"""


class ServiceNowCredentialsUnionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("username", "password", "client_id", "client_secret", "type")
    username = sgqlc.types.Field(String, graphql_name="username")

    password = sgqlc.types.Field(String, graphql_name="password")

    client_id = sgqlc.types.Field(String, graphql_name="clientId")

    client_secret = sgqlc.types.Field(String, graphql_name="clientSecret")

    type = sgqlc.types.Field(sgqlc.types.non_null(ServiceNowCredentialsType), graphql_name="type")


class ServiceNowIntegrationOptionsInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "oauth_token_endpoint",
        "api_base_url",
        "incident_link_url_pattern",
        "supports_user_table",
        "supports_fetch_fields",
        "supports_fetch_incident",
        "set_description_field",
        "status_mappings",
    )
    oauth_token_endpoint = sgqlc.types.Field(String, graphql_name="oauthTokenEndpoint")

    api_base_url = sgqlc.types.Field(String, graphql_name="apiBaseUrl")

    incident_link_url_pattern = sgqlc.types.Field(String, graphql_name="incidentLinkUrlPattern")

    supports_user_table = sgqlc.types.Field(Boolean, graphql_name="supportsUserTable")

    supports_fetch_fields = sgqlc.types.Field(Boolean, graphql_name="supportsFetchFields")

    supports_fetch_incident = sgqlc.types.Field(Boolean, graphql_name="supportsFetchIncident")

    set_description_field = sgqlc.types.Field(Boolean, graphql_name="setDescriptionField")

    status_mappings = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(MonteCarloStatusMappingInput)),
        graphql_name="statusMappings",
    )


class ServiceNowStateMappingInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("incident_feedback", "servicenow_incident_state")
    incident_feedback = sgqlc.types.Field(String, graphql_name="incidentFeedback")
    """('The feedback that will be set on the Monte Carlo incident if the
    ServiceNow incident is set to any of the provided ServiceNow
    statuses',)
    """

    servicenow_incident_state = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="servicenowIncidentState"
    )
    """The ServiceNow states that will map to the Monte Carlo incident
    feedback
    """


class ServiceNowWebhookConfigInput(sgqlc.types.Input):
    """ServiceNow webhook config"""

    __schema__ = schema
    __field_names__ = ("state_mappings",)
    state_mappings = sgqlc.types.Field(
        sgqlc.types.list_of(ServiceNowStateMappingInput), graphql_name="stateMappings"
    )
    """Mapping FROM ServiceNow incident states TO Monte Carlo alert
    status
    """


class SetIncidentFeedbackInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("incident_id", "feedback", "client_mutation_id")
    incident_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="incidentId")
    """UUID of incident to add feedback"""

    feedback = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="feedback")
    """The feedback to be added to an incident"""

    client_mutation_id = sgqlc.types.Field(String, graphql_name="clientMutationId")


class SetIncidentFeedbackV2Input(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("incident_id", "feedback", "client_mutation_id")
    incident_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="incidentId")
    """UUID of incident to add feedback"""

    feedback = sgqlc.types.Field(sgqlc.types.non_null(IncidentFeedback), graphql_name="feedback")
    """The feedback to be added to an incident"""

    client_mutation_id = sgqlc.types.Field(String, graphql_name="clientMutationId")


class SimulateMonitorEvaluationRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("evaluation_start_time", "evaluation_end_time", "limit")
    evaluation_start_time = sgqlc.types.Field(DateTime, graphql_name="evaluationStartTime")
    """Evaluation start time"""

    evaluation_end_time = sgqlc.types.Field(DateTime, graphql_name="evaluationEndTime")
    """Evaluation end time"""

    limit = sgqlc.types.Field(Int, graphql_name="limit")
    """Number of breaching query groups to return"""


class SnowflakeConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "user",
        "private_key",
        "private_key_passphrase",
        "account",
        "warehouse",
        "oauth",
    )
    user = sgqlc.types.Field(String, graphql_name="user")
    """User with access to snowflake."""

    private_key = sgqlc.types.Field(String, graphql_name="privateKey")
    """User's private key (base64 encoded)."""

    private_key_passphrase = sgqlc.types.Field(String, graphql_name="privateKeyPassphrase")
    """User's private key passphrase. This argument is only needed when
    the private key is encrypted.
    """

    account = sgqlc.types.Field(String, graphql_name="account")
    """Snowflake account name"""

    warehouse = sgqlc.types.Field(String, graphql_name="warehouse")
    """Name of the warehouse for the user"""

    oauth = sgqlc.types.Field(OAuthConfiguration, graphql_name="oauth")
    """Configuration for OAuth for Snowflake."""


class SnowflakeUpdateConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "user",
        "password",
        "private_key",
        "private_key_passphrase",
        "account",
        "warehouse",
        "oauth",
    )
    user = sgqlc.types.Field(String, graphql_name="user")
    """User with access to snowflake."""

    password = sgqlc.types.Field(String, graphql_name="password")
    """User's password if using user/password basic auth"""

    private_key = sgqlc.types.Field(String, graphql_name="privateKey")
    """User's private key (base64 encoded) if using key pair auth."""

    private_key_passphrase = sgqlc.types.Field(String, graphql_name="privateKeyPassphrase")
    """User's private key passphrase if using key pair auth. This
    argument is only needed when the private key is encrypted.
    """

    account = sgqlc.types.Field(String, graphql_name="account")
    """Snowflake account name"""

    warehouse = sgqlc.types.Field(String, graphql_name="warehouse")
    """Name of the warehouse for the user"""

    oauth = sgqlc.types.Field(OAuthConfiguration, graphql_name="oauth")
    """Configuration for OAuth for Snowflake."""


class SparkBinaryInput(sgqlc.types.Input):
    """Credentials to the Spark  Thrift server in binary mode"""

    __schema__ = schema
    __field_names__ = ("database", "host", "port", "username", "password")
    database = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="database")
    """Database name"""

    host = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="host")
    """Host name"""

    port = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="port")
    """Port"""

    username = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="username")
    """User name"""

    password = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="password")
    """Password"""


class SparkDatabricksConnectionInput(sgqlc.types.Input):
    """Credentials and connection details to a new Databricks cluster
    connection
    """

    __schema__ = schema
    __field_names__ = ("dc_id", "connection_type", "databricks_config")
    dc_id = sgqlc.types.Field(UUID, graphql_name="dcId")
    """The Data Collector UUID for a new Databricks Connection"""

    connection_type = sgqlc.types.Field(String, graphql_name="connectionType")
    """The Databricks connection type for a new Databricks connection"""

    databricks_config = sgqlc.types.Field("SparkDatabricksInput", graphql_name="databricksConfig")
    """Configuration for Databricks."""


class SparkDatabricksInput(sgqlc.types.Input):
    """Credentials to a Databricks cluster"""

    __schema__ = schema
    __field_names__ = (
        "databricks_workspace_url",
        "databricks_workspace_id",
        "databricks_cluster_id",
        "databricks_token",
    )
    databricks_workspace_url = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="databricksWorkspaceUrl"
    )
    """Databricks workspace URL"""

    databricks_workspace_id = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="databricksWorkspaceId"
    )
    """Databricks workspace ID"""

    databricks_cluster_id = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="databricksClusterId"
    )
    """Databricks cluster ID"""

    databricks_token = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="databricksToken"
    )
    """User token"""


class SparkDatabricksUpdateConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "databricks_workspace_url",
        "databricks_workspace_id",
        "databricks_cluster_id",
        "databricks_token",
    )
    databricks_workspace_url = sgqlc.types.Field(String, graphql_name="databricksWorkspaceUrl")
    """Databricks workspace URL"""

    databricks_workspace_id = sgqlc.types.Field(String, graphql_name="databricksWorkspaceId")
    """Databricks workspace ID"""

    databricks_cluster_id = sgqlc.types.Field(String, graphql_name="databricksClusterId")
    """Databricks cluster ID"""

    databricks_token = sgqlc.types.Field(String, graphql_name="databricksToken")
    """User token"""


class SparkHttpInput(sgqlc.types.Input):
    """Credentials to the Spark  Thrift server in HTTP mode"""

    __schema__ = schema
    __field_names__ = ("url", "username", "password")
    url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="url")
    """Connection URL to the Thrift server"""

    username = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="username")
    """User name"""

    password = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="password")
    """Password"""


class SslInputOptions(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("ca", "ca_data", "cert", "key", "mechanism", "skip_verification")
    ca = sgqlc.types.Field(String, graphql_name="ca")
    """CA bundle file"""

    ca_data = sgqlc.types.Field(String, graphql_name="caData")
    """CA certificate data to use for the connection"""

    cert = sgqlc.types.Field(String, graphql_name="cert")
    """Certificate file"""

    key = sgqlc.types.Field(String, graphql_name="key")
    """Key file"""

    mechanism = sgqlc.types.Field(String, graphql_name="mechanism")
    """How the file is passed to the DC. Possible values are: "dc-s3" or
    "url"
    """

    skip_verification = sgqlc.types.Field(Boolean, graphql_name="skipVerification")
    """Whether SSL certificate verification should be skipped"""


class SslOptions(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "ca_data",
        "cert_data",
        "key_data",
        "key_password",
        "disabled",
        "verify_cert",
        "verify_identity",
        "skip_cert_verification",
    )
    ca_data = sgqlc.types.Field(String, graphql_name="caData")
    """SSL CA certificate data to use for the connection"""

    cert_data = sgqlc.types.Field(String, graphql_name="certData")
    """SSL certificate data to use for the connection"""

    key_data = sgqlc.types.Field(String, graphql_name="keyData")
    """SSL key data to use for the connection"""

    key_password = sgqlc.types.Field(String, graphql_name="keyPassword")
    """SSL key password to use for the connection"""

    disabled = sgqlc.types.Field(Boolean, graphql_name="disabled")
    """Disables usage of TLS."""

    verify_cert = sgqlc.types.Field(Boolean, graphql_name="verifyCert")
    """Set to true to check the server certificate’s validity"""

    verify_identity = sgqlc.types.Field(Boolean, graphql_name="verifyIdentity")
    """Verify the server's identity"""

    skip_cert_verification = sgqlc.types.Field(Boolean, graphql_name="skipCertVerification")
    """Skip certificate verification"""


class SslUpdateOptions(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "ca_data",
        "cert_data",
        "key_data",
        "key_password",
        "disabled",
        "verify_cert",
        "verify_identity",
        "skip_cert_verification",
    )
    ca_data = sgqlc.types.Field(String, graphql_name="caData")
    """SSL CA certificate data to use for the connection"""

    cert_data = sgqlc.types.Field(String, graphql_name="certData")
    """SSL certificate data to use for the connection"""

    key_data = sgqlc.types.Field(String, graphql_name="keyData")
    """SSL key data to use for the connection"""

    key_password = sgqlc.types.Field(String, graphql_name="keyPassword")
    """SSL key password to use for the connection"""

    disabled = sgqlc.types.Field(Boolean, graphql_name="disabled")
    """Disables usage of TLS."""

    verify_cert = sgqlc.types.Field(Boolean, graphql_name="verifyCert")
    """Set to true to check the server certificate’s validity"""

    verify_identity = sgqlc.types.Field(Boolean, graphql_name="verifyIdentity")
    """Verify the server's identity"""

    skip_cert_verification = sgqlc.types.Field(Boolean, graphql_name="skipCertVerification")
    """Skip certificate verification"""


class StringFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("field_name", "values")
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="fieldName")
    """Field name to filter on"""

    values = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name="values"
    )
    """Values to filter by (combined via OR)"""


class TableMonitorAlertConditionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("metric", "operator")
    metric = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="metric")

    operator = sgqlc.types.Field(String, graphql_name="operator")


class TableStatsRules(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("importance_score", "is_important")
    importance_score = sgqlc.types.Field(
        ImportanceScoreTableStatsRule, graphql_name="importanceScore"
    )

    is_important = sgqlc.types.Field(IsImportantTableStatsRule, graphql_name="isImportant")


class TableauConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "server_name",
        "username",
        "password",
        "client_id",
        "secret_id",
        "secret_value",
        "token_name",
        "token_value",
        "site_name",
        "verify_ssl",
    )
    server_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="serverName")
    """The Tableau server name"""

    username = sgqlc.types.Field(String, graphql_name="username")
    """Username for the Tableau user if using username/password or
    Connected Apps
    """

    password = sgqlc.types.Field(String, graphql_name="password")
    """Password for the Tableau user if using username/password"""

    client_id = sgqlc.types.Field(String, graphql_name="clientId")
    """The Tableau Connected Apps Client ID"""

    secret_id = sgqlc.types.Field(String, graphql_name="secretId")
    """The Tableau Connected Apps Secret ID"""

    secret_value = sgqlc.types.Field(String, graphql_name="secretValue")
    """The Tableau Connected Apps Secret value"""

    token_name = sgqlc.types.Field(String, graphql_name="tokenName")
    """The personal access token name for PAT authentication"""

    token_value = sgqlc.types.Field(String, graphql_name="tokenValue")
    """The personal access token value for PAT authentication"""

    site_name = sgqlc.types.Field(String, graphql_name="siteName")
    """The Tableau site name"""

    verify_ssl = sgqlc.types.Field(Boolean, graphql_name="verifySsl")
    """Whether to verify the SSL connection to Tableau server"""


class TableauUpdateConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "server_name",
        "username",
        "password",
        "token_name",
        "token_value",
        "client_id",
        "secret_id",
        "secret_value",
        "site_name",
        "verify_ssl",
    )
    server_name = sgqlc.types.Field(String, graphql_name="serverName")
    """The Tableau server name"""

    username = sgqlc.types.Field(String, graphql_name="username")
    """Username for the Tableau user if using username/password or
    Connected Apps
    """

    password = sgqlc.types.Field(String, graphql_name="password")
    """Password for the Tableau user if using username/password"""

    token_name = sgqlc.types.Field(String, graphql_name="tokenName")
    """The personal access token name for PAT authentication"""

    token_value = sgqlc.types.Field(String, graphql_name="tokenValue")
    """The personal access token value for PAT authentication"""

    client_id = sgqlc.types.Field(String, graphql_name="clientId")
    """The Tableau Connected Apps Client ID"""

    secret_id = sgqlc.types.Field(String, graphql_name="secretId")
    """The Tableau Connected Apps Secret ID"""

    secret_value = sgqlc.types.Field(String, graphql_name="secretValue")
    """The Tableau Connected Apps Secret value"""

    site_name = sgqlc.types.Field(String, graphql_name="siteName")
    """The Tableau site name"""

    verify_ssl = sgqlc.types.Field(Boolean, graphql_name="verifySsl")
    """Whether to verify the SSL connection to Tableau server"""


class TagFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("tag_name", "tag_values")
    tag_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="tagName")
    """Tag name"""

    tag_values = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="tagValues")
    """Tag values. If empty, match all with tag_name"""


class TagKeyValuePairInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("name", "value")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Tag key"""

    value = sgqlc.types.Field(String, graphql_name="value")
    """Tag Value"""


class TagPair(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("name", "value")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Tag key"""

    value = sgqlc.types.Field(String, graphql_name="value")
    """Tag Value"""


class TasksPerformanceFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("start_time", "end_time", "job_mcon")
    start_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="startTime")
    """Starting time of period to query for"""

    end_time = sgqlc.types.Field(DateTime, graphql_name="endTime")
    """Ending time of period to query for"""

    job_mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="jobMcon")
    """Job mcon to get associated tasks"""


class TasksPerformancePagingInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("first", "after", "last", "before", "order_by", "order_direction")
    first = sgqlc.types.Field(Int, graphql_name="first")
    """Number of items to retrieve after the cursor. Defaults to 20 if no
    other paging parameters are provided
    """

    after = sgqlc.types.Field(String, graphql_name="after")
    """Starting cursor when paging forward"""

    last = sgqlc.types.Field(Int, graphql_name="last")
    """Number of items to retrieve before the cursor when paging backward"""

    before = sgqlc.types.Field(String, graphql_name="before")
    """Ending cursor when paging backward"""

    order_by = sgqlc.types.Field(TasksPerformanceSummarySort, graphql_name="orderBy")
    """Field by which to order the results. Defaults to
    LAST_RUN_START_TIME
    """

    order_direction = sgqlc.types.Field(EtlPerformanceSortDirection, graphql_name="orderDirection")
    """Sort direction. Defaults to EnumMeta.ASC"""


class ThresholdModifierInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("modifier_type", "value")
    modifier_type = sgqlc.types.Field(
        sgqlc.types.non_null(ThresholdModifierType), graphql_name="modifierType"
    )
    """The type of threshold modifier"""

    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="value")
    """The value of the threshold modifier. If the type is PERCENTAGE,
    this should be a decimal value.
    """


class TimeRangeInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "metric_group_period_unit",
        "look_back_length",
        "look_back_unit",
        "start_time",
        "end_time",
    )
    metric_group_period_unit = sgqlc.types.Field(
        sgqlc.types.non_null(TimeRangeUnit), graphql_name="metricGroupPeriodUnit"
    )
    """Metric group unit. Will be used as the granularity for metrics on
    the Dashboard.
    """

    look_back_length = sgqlc.types.Field(Int, graphql_name="lookBackLength")
    """Look back length in integer. Together with look_back_unit, they
    defined how many days/weeks/months to look back by default. When
    this is set, look_back_unit should be set as well,
    start_time/end_time will be ignored.
    """

    look_back_unit = sgqlc.types.Field(TimeRangeUnit, graphql_name="lookBackUnit")
    """Look back time unit. Together with look_back_length, they define
    how many days/weeks/months to look back by default.When this is
    set, look_back_length is required, start_time/end_time will be
    ignored.
    """

    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """Start time for metrics on this dashboard. If this is set, the
    end_time is required. If look_back_length and/or look_back_unit is
    set, this field is ignored.
    """

    end_time = sgqlc.types.Field(DateTime, graphql_name="endTime")
    """End time for metrics on this dashboard. If this is set, the
    start_time is required. If look_back_length and/or look_back_unit
    is set, this field is ignored.
    """


class TimestampFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("field_name", "ranges")
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="fieldName")
    """Field name to filter on"""

    ranges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("TimestampRangeInput")), graphql_name="ranges"
    )
    """Time ranges to filter by (combined via OR)"""


class TimestampHistogramSimpleWidgetConfig(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("additional_aggregate_metrics", "time_bucket_size")
    additional_aggregate_metrics = sgqlc.types.Field(
        sgqlc.types.list_of(AggregateMetricParams), graphql_name="additionalAggregateMetrics"
    )

    time_bucket_size = sgqlc.types.Field(TimeBucketSize, graphql_name="timeBucketSize")
    """Aggregation time bucket size"""


class TimestampRangeInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("start_time", "end_time")
    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """Time range start"""

    end_time = sgqlc.types.Field(DateTime, graphql_name="endTime")
    """Time range end"""


class TimestampResult(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("field_name", "timestamp")
    field_name = sgqlc.types.Field(String, graphql_name="fieldName")

    timestamp = sgqlc.types.Field(DateTime, graphql_name="timestamp")


class ToggleDatasetInputItem(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("dw_id", "ds_id")
    dw_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="dwId")
    """Warehouse the dataset is contained in."""

    ds_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="dsId")
    """ID of the dataset."""


class ToggleMuteDatasetInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("dw_id", "ds_id", "mute", "muted_event_types", "client_mutation_id")
    dw_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="dwId")
    """Warehouse the dataset is contained in."""

    ds_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="dsId")
    """ID of the dataset."""

    mute = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="mute")
    """True for muting the table, False for un-muting"""

    muted_event_types = sgqlc.types.Field(
        sgqlc.types.list_of(MutedEventType), graphql_name="mutedEventTypes"
    )
    """Restrict muting to the following event types (optional)"""

    client_mutation_id = sgqlc.types.Field(String, graphql_name="clientMutationId")


class ToggleMuteDatasetsInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("datasets", "mute", "muted_event_types", "client_mutation_id")
    datasets = sgqlc.types.Field(
        sgqlc.types.list_of(ToggleDatasetInputItem), graphql_name="datasets"
    )
    """The datasets being muted"""

    mute = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="mute")
    """True for muting the table, False for un-muting"""

    muted_event_types = sgqlc.types.Field(
        sgqlc.types.list_of(MutedEventType), graphql_name="mutedEventTypes"
    )
    """Restrict muting to the following event types (optional)"""

    client_mutation_id = sgqlc.types.Field(String, graphql_name="clientMutationId")


class ToggleMuteTableInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "mcon",
        "full_table_id",
        "dw_id",
        "mute",
        "muted_event_types",
        "client_mutation_id",
    )
    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Mcon of table to toggle muting for"""

    full_table_id = sgqlc.types.Field(String, graphql_name="fullTableId")
    """Deprecated - use mcon. Ignored if mcon is present"""

    dw_id = sgqlc.types.Field(UUID, graphql_name="dwId")
    """Warehouse the table is contained in. Required when using a
    fullTableId
    """

    mute = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="mute")
    """True for muting the table, False for un-muting"""

    muted_event_types = sgqlc.types.Field(
        sgqlc.types.list_of(MutedEventType), graphql_name="mutedEventTypes"
    )
    """Restrict muting to the following event types (optional)"""

    client_mutation_id = sgqlc.types.Field(String, graphql_name="clientMutationId")


class ToggleMuteTablesInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("tables", "mute", "muted_event_types", "client_mutation_id")
    tables = sgqlc.types.Field(sgqlc.types.list_of("ToggleTableInputItem"), graphql_name="tables")
    """The tables being muted"""

    mute = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="mute")
    """True for muting the table, False for un-muting"""

    muted_event_types = sgqlc.types.Field(
        sgqlc.types.list_of(MutedEventType), graphql_name="mutedEventTypes"
    )
    """Restrict muting to the following event types (optional)"""

    client_mutation_id = sgqlc.types.Field(String, graphql_name="clientMutationId")


class ToggleMuteWithRegexInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("dw_id", "rule_regex", "mute", "muted_event_types", "client_mutation_id")
    dw_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="dwId")
    """Warehouse the dataset is contained in."""

    rule_regex = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="ruleRegex")
    """Valid regex to match fullTableIds. FullTableIds have the following
    format: "PROJECT_NAME:DATASET_NAME.TABLE_ID"
    """

    mute = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="mute")
    """True for muting the table, False for un-muting"""

    muted_event_types = sgqlc.types.Field(
        sgqlc.types.list_of(MutedEventType), graphql_name="mutedEventTypes"
    )
    """Restrict muting to the following event types (optional)"""

    client_mutation_id = sgqlc.types.Field(String, graphql_name="clientMutationId")


class ToggleTableInputItem(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("mcon", "full_table_id", "dw_id")
    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Mcon of the table to toggle muting for"""

    full_table_id = sgqlc.types.Field(String, graphql_name="fullTableId")
    """Deprecated - use mcon. Ignored if mcon is present"""

    dw_id = sgqlc.types.Field(UUID, graphql_name="dwId")
    """Warehouse the table is contained in. Required when using a full
    table id
    """


class TopQueryGroupsRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("search_criteria", "first", "offset", "sort_field", "metric_field_name")
    search_criteria = sgqlc.types.Field(
        sgqlc.types.non_null(SearchCriteriaType), graphql_name="searchCriteria"
    )

    first = sgqlc.types.Field(Int, graphql_name="first")

    offset = sgqlc.types.Field(Int, graphql_name="offset")

    sort_field = sgqlc.types.Field(String, graphql_name="sortField")

    metric_field_name = sgqlc.types.Field(String, graphql_name="metricFieldName")


class TrackTableInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("mcon", "full_table_id", "dw_id", "track", "client_mutation_id")
    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Mcon of table to toggle tracking for"""

    full_table_id = sgqlc.types.Field(String, graphql_name="fullTableId")
    """Deprecated - use mcon. Ignored if mcon is present"""

    dw_id = sgqlc.types.Field(UUID, graphql_name="dwId")
    """Warehouse the table is contained in. Required when using a
    fullTableId
    """

    track = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="track")
    """Enable or disable table tracking"""

    client_mutation_id = sgqlc.types.Field(String, graphql_name="clientMutationId")


class TransactionalDbConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "db_name",
        "db_type",
        "host",
        "port",
        "user",
        "password",
        "token",
        "consumer_key",
        "consumer_secret",
        "connection_settings",
        "domain",
    )
    db_name = sgqlc.types.Field(String, graphql_name="dbName")
    """Name of database to add connection for"""

    db_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="dbType")
    """Type of Transactional DB to add connection for"""

    host = sgqlc.types.Field(String, graphql_name="host")
    """Hostname of the warehouse"""

    port = sgqlc.types.Field(Int, graphql_name="port")
    """HTTP Port to use"""

    user = sgqlc.types.Field(String, graphql_name="user")
    """User with access to the database"""

    password = sgqlc.types.Field(String, graphql_name="password")
    """User's password"""

    token = sgqlc.types.Field(String, graphql_name="token")
    """Auth Token for connection"""

    consumer_key = sgqlc.types.Field(String, graphql_name="consumerKey")
    """Consumer key for connection"""

    consumer_secret = sgqlc.types.Field(String, graphql_name="consumerSecret")
    """Consumer secret for connection"""

    connection_settings = sgqlc.types.Field(
        "TransactionalDbConnectionSettings", graphql_name="connectionSettings"
    )
    """Optional connection settings"""

    domain = sgqlc.types.Field(String, graphql_name="domain")
    """Domain for the connection"""


class TransactionalDbConnectionSettings(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("td_sslmode", "td_logmech", "tls", "ssl_options", "rds_proxy")
    td_sslmode = sgqlc.types.Field(TeradataSSLModeEnum, graphql_name="tdSslmode")
    """Specifies the mode for connections to Teradata database."""

    td_logmech = sgqlc.types.Field(TeradataLogMechEnum, graphql_name="tdLogmech")
    """Teradata logon authentication method."""

    tls = sgqlc.types.Field(Boolean, graphql_name="tls")
    """Should we use TLS when connecting to Dremio, required for Dremio
    Cloud.
    """

    ssl_options = sgqlc.types.Field(SslOptions, graphql_name="sslOptions")
    """Optional SSL options."""

    rds_proxy = sgqlc.types.Field(Boolean, graphql_name="rdsProxy")
    """Indicates if we are connecting to the database through a RDS
    Proxy.
    """


class TransactionalDbUpdateConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "db_name",
        "db_type",
        "host",
        "port",
        "user",
        "password",
        "token",
        "consumer_key",
        "consumer_secret",
        "domain",
        "connection_settings",
        "ssl_options",
    )
    db_name = sgqlc.types.Field(String, graphql_name="dbName")
    """Name of database to add connection for"""

    db_type = sgqlc.types.Field(String, graphql_name="dbType")
    """Type of Transactional DB to add connection for"""

    host = sgqlc.types.Field(String, graphql_name="host")
    """Hostname of the warehouse"""

    port = sgqlc.types.Field(Int, graphql_name="port")
    """HTTP Port to use"""

    user = sgqlc.types.Field(String, graphql_name="user")
    """User with access to the database"""

    password = sgqlc.types.Field(String, graphql_name="password")
    """User's password"""

    token = sgqlc.types.Field(String, graphql_name="token")
    """Token to access the database"""

    consumer_key = sgqlc.types.Field(String, graphql_name="consumerKey")
    """OAuth client ID or consumer key"""

    consumer_secret = sgqlc.types.Field(String, graphql_name="consumerSecret")
    """OAuth client secret or consumer secret"""

    domain = sgqlc.types.Field(String, graphql_name="domain")
    """Domain to use for the connection"""

    connection_settings = sgqlc.types.Field(
        "TransactionalDbUpdateConnectionSettings", graphql_name="connectionSettings"
    )
    """Optional connection settings"""

    ssl_options = sgqlc.types.Field(SslUpdateOptions, graphql_name="sslOptions")
    """Optional SSL options."""


class TransactionalDbUpdateConnectionSettings(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("td_sslmode", "td_logmech", "rds_proxy")
    td_sslmode = sgqlc.types.Field(TeradataSSLModeUpdateEnum, graphql_name="tdSslmode")
    """Specifies the mode for connections to Teradata database."""

    td_logmech = sgqlc.types.Field(TeradataLogMechUpdateEnum, graphql_name="tdLogmech")
    """Teradata logon authentication method."""

    rds_proxy = sgqlc.types.Field(Boolean, graphql_name="rdsProxy")
    """Indicates if we are connecting to the database through a RDS
    Proxy.
    """


class TransformInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "alias",
        "prompt",
        "categories",
        "model_connection_id",
        "output_type",
        "sql_expression",
        "field_config_list",
        "model_name",
        "function",
        "field",
        "id",
    )
    alias = sgqlc.types.Field(String, graphql_name="alias")

    prompt = sgqlc.types.Field(String, graphql_name="prompt")

    categories = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(ClassificationCategoriesInput)),
        graphql_name="categories",
    )

    model_connection_id = sgqlc.types.Field(String, graphql_name="modelConnectionId")

    output_type = sgqlc.types.Field(String, graphql_name="outputType")

    sql_expression = sgqlc.types.Field(String, graphql_name="sqlExpression")

    field_config_list = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(FieldConfigInput)), graphql_name="fieldConfigList"
    )

    model_name = sgqlc.types.Field(String, graphql_name="modelName")

    function = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="function")

    field = sgqlc.types.Field(String, graphql_name="field")

    id = sgqlc.types.Field(String, graphql_name="id")


class UCSAutomatedAlertConditionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("sensitivity_level",)
    sensitivity_level = sgqlc.types.Field(
        sgqlc.types.non_null(SensitivityLevels), graphql_name="sensitivityLevel"
    )
    """Sensitivity for automated thresholds"""


class UCSExplicitAlertConditionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "start_time",
        "interval_minutes",
        "interval_crontab",
        "interval_crontab_day_or",
        "timezone",
        "is_auto_schedule_config",
        "threshold",
    )
    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """Start time of the collection"""

    interval_minutes = sgqlc.types.Field(Int, graphql_name="intervalMinutes")
    """Collection interval in minutes"""

    interval_crontab = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="intervalCrontab"
    )
    """Collection interval in crontab format"""

    interval_crontab_day_or = sgqlc.types.Field(Boolean, graphql_name="intervalCrontabDayOr")
    """If true, use default cron behavior and run when day-of-month OR
    day-of-week match. If false, use alternate behavior and run when
    day-of-month AND day-of-week match.
    """

    timezone = sgqlc.types.Field(String, graphql_name="timezone")
    """Timezone for daylight savings and interpreting cron expressions"""

    is_auto_schedule_config = sgqlc.types.Field(Boolean, graphql_name="isAutoScheduleConfig")
    """Set to true to use auto schedule configuration"""

    threshold = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="threshold")
    """Explicit freshness threshold in minutes"""


class UpdateDataShareInput(sgqlc.types.Input):
    """Input for updating Snowflake data share configuration"""

    __schema__ = schema
    __field_names__ = ("enabled", "account_id", "account_name", "data_share")
    enabled = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="enabled")
    """Whether to enable data sharing"""

    account_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="accountId")
    """UUID of the account to update"""

    account_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="accountName")
    """Name of the account (validation)"""

    data_share = sgqlc.types.Field(DataShareInput, graphql_name="dataShare")
    """Input data share attributes"""


class UpdateUserStateInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("state", "client_mutation_id")
    state = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="state")

    client_mutation_id = sgqlc.types.Field(String, graphql_name="clientMutationId")


class UsageAlertConfigInput(sgqlc.types.Input):
    """input variables for daily usage alert"""

    __schema__ = schema
    __field_names__ = ("threshold", "emails", "disabled")
    threshold = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="threshold")
    """Usage threshold that triggers the alert"""

    emails = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name="emails"
    )
    """List of recipients"""

    disabled = sgqlc.types.Field(Boolean, graphql_name="disabled")
    """Disable the alert (optional)"""


class UserSettingInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("key", "value", "description")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    """User setting key"""

    value = sgqlc.types.Field(JSONString, graphql_name="value")
    """User settings"""

    description = sgqlc.types.Field(String, graphql_name="description")
    """Description for this user's settings"""


class ValidatorTestOptions(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "validate_select",
        "validate_info_access",
        "validate_table_metadata",
        "validate_syslog",
    )
    validate_select = sgqlc.types.Field(Boolean, graphql_name="validateSelect")
    """Whether the validate select query should be executed"""

    validate_info_access = sgqlc.types.Field(Boolean, graphql_name="validateInfoAccess")
    """Whether the validate info access query should be executed"""

    validate_table_metadata = sgqlc.types.Field(Boolean, graphql_name="validateTableMetadata")
    """Whether the validate table metadata query should be executed"""

    validate_syslog = sgqlc.types.Field(Boolean, graphql_name="validateSyslog")
    """Whether the validate syslog query should be executed"""


class VariableDefinitionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("name", "runtime", "values")
    name = sgqlc.types.Field(String, graphql_name="name")

    runtime = sgqlc.types.Field(Boolean, graphql_name="runtime")

    values = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="values"
    )


class VolumeChangeAutomatedAlertConditionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("sensitivity_level",)
    sensitivity_level = sgqlc.types.Field(
        sgqlc.types.non_null(SensitivityLevels), graphql_name="sensitivityLevel"
    )
    """Sensitivity for automated thresholds"""


class VolumeChangeExplicitAlertConditionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = (
        "start_time",
        "interval_minutes",
        "interval_crontab",
        "interval_crontab_day_or",
        "timezone",
        "threshold_lookback_minutes",
        "upper_threshold",
        "lower_threshold",
    )
    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """Start time of the collection"""

    interval_minutes = sgqlc.types.Field(Int, graphql_name="intervalMinutes")
    """Collection interval in minutes"""

    interval_crontab = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="intervalCrontab"
    )
    """Collection interval in crontab format"""

    interval_crontab_day_or = sgqlc.types.Field(Boolean, graphql_name="intervalCrontabDayOr")
    """If true, use default cron behavior and run when day-of-month OR
    day-of-week match. If false, use alternate behavior and run when
    day-of-month AND day-of-week match.
    """

    timezone = sgqlc.types.Field(String, graphql_name="timezone")
    """Timezone for daylight savings and interpreting cron expressions"""

    threshold_lookback_minutes = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="thresholdLookbackMinutes"
    )
    """Threshold lookback in minutes"""

    upper_threshold = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="upperThreshold")
    """Upper threshold in percent"""

    lower_threshold = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="lowerThreshold")
    """Lower threshold in percent"""


class WebhookHeaderInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("key", "value")
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    """The header field name"""

    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")
    """The header field value"""


class WidgetConfig(sgqlc.types.Input):
    """Widget configuration.             Only one (or none)
    of these properties should be set, depending on the widget type.
    For widgetType=TIMESTAMP_HISTOGRAM, use timestampHistogramConfig.
    For widgetType=NUMERICAL_CONTINUOUS, use
    numericalContinuousConfig.
    """

    __schema__ = schema
    __field_names__ = ("timestamp_histogram_config",)
    timestamp_histogram_config = sgqlc.types.Field(
        TimestampHistogramSimpleWidgetConfig, graphql_name="timestampHistogramConfig"
    )


class WildcardTemplateInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ("template_name", "template_regex")
    template_name = sgqlc.types.Field(String, graphql_name="templateName")

    template_regex = sgqlc.types.Field(String, graphql_name="templateRegex")


########################################################################
# Output Objects and Interfaces
########################################################################
class AssetCollectionPreferenceNode(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    """The ID of the object."""


class AssetFilterInterface(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ("type", "negated")
    type = sgqlc.types.Field(sgqlc.types.non_null(AssetFilterType), graphql_name="type")

    negated = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="negated")


class CollectionPreferenceNode(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    """The ID of the object."""


class DataSourceInputInterface(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ("type", "connection_type", "schema")
    type = sgqlc.types.Field(sgqlc.types.non_null(DataSourceType), graphql_name="type")

    connection_type = sgqlc.types.Field(String, graphql_name="connectionType")

    schema = sgqlc.types.Field("DataSourceSchema", graphql_name="schema")


class DataSourceInterface(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ("type", "connection_type", "schema")
    type = sgqlc.types.Field(sgqlc.types.non_null(DataSourceType), graphql_name="type")

    connection_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="connectionType")

    schema = sgqlc.types.Field(sgqlc.types.non_null("DataSourceSchema"), graphql_name="schema")


class FilterInterface(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ("type", "id")
    type = sgqlc.types.Field(sgqlc.types.non_null(FilterType), graphql_name="type")

    id = sgqlc.types.Field(String, graphql_name="id")


class FilterValueInterface(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ("type", "id")
    type = sgqlc.types.Field(sgqlc.types.non_null(FilterValueType), graphql_name="type")

    id = sgqlc.types.Field(String, graphql_name="id")


class IBaseRca(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ("rca_type", "rca_uuid")
    rca_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="rcaType")
    """RCA type"""

    rca_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="rcaUuid")
    """Unique identifier of an RCA"""


class IComparisonMonitor(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ("source", "target")
    source = sgqlc.types.Field("ExtendedDataSource", graphql_name="source")

    target = sgqlc.types.Field("ExtendedDataSource", graphql_name="target")


class ICustomRulesMonitor(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = (
        "has_custom_rule_name",
        "rule_description",
        "rule_comparisons",
        "rule_notes",
        "rule_variables",
        "variable_definitions",
        "is_snoozed",
        "snooze_until_time",
        "slack_snooze_user",
        "conditional_snooze",
        "breach_rate",
        "interval_minutes",
        "custom_sql_rule_type",
        "invalid_rows",
        "alert_ids",
        "breached",
        "migrated_to_uuid",
    )
    has_custom_rule_name = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="hasCustomRuleName"
    )
    """Whether the monitor has a name given by the monitor creator"""

    rule_description = sgqlc.types.Field(String, graphql_name="ruleDescription")
    """**DEPRECATED**"""

    rule_comparisons = sgqlc.types.Field(
        sgqlc.types.list_of("CustomRuleComparison"), graphql_name="ruleComparisons"
    )
    """Deprecated in favor of comparisons"""

    rule_notes = sgqlc.types.Field(String, graphql_name="ruleNotes")
    """**DEPRECATED**"""

    rule_variables = sgqlc.types.Field(JSONString, graphql_name="ruleVariables")
    """variables defined for the sql rule"""

    variable_definitions = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("VariableDefinition")),
        graphql_name="variableDefinitions",
    )
    """Possible variable values for SQL query. Allows specifying runtime
    variables as well.
    """

    is_snoozed = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isSnoozed")
    """Whether the monitor is currently snoozed"""

    snooze_until_time = sgqlc.types.Field(DateTime, graphql_name="snoozeUntilTime")
    """If snoozed, the wake up time in UTC"""

    slack_snooze_user = sgqlc.types.Field(String, graphql_name="slackSnoozeUser")
    """Slack user who snoozed rule"""

    conditional_snooze = sgqlc.types.Field(Boolean, graphql_name="conditionalSnooze")
    """Whether the monitor is conditionally snoozed"""

    breach_rate = sgqlc.types.Field(String, graphql_name="breachRate")
    """Percentage of last 10 runs in which the monitor's condition was
    breached
    """

    interval_minutes = sgqlc.types.Field(Int, graphql_name="intervalMinutes")
    """Interval between monitor runs, in minutes"""

    custom_sql_rule_type = sgqlc.types.Field(String, graphql_name="customSqlRuleType")
    """The type of custom SQL rule. Only set for custom SQL rules"""

    invalid_rows = sgqlc.types.Field(BigInt, graphql_name="invalidRows")
    """Number of invalid rows. Only for alerted monitors"""

    alert_ids = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name="alertIds")
    """Alert ids related last breached run. Is only returned if monitor
    is breached.
    """

    breached = sgqlc.types.Field(MonitorBreachType, graphql_name="breached")
    """Monitor breached status"""

    migrated_to_uuid = sgqlc.types.Field(String, graphql_name="migratedToUuid")
    """UUID of the monitor this was migrated to, if applicable"""


class IEtlAssetPerformanceSummary(sgqlc.types.Interface):
    """ETL asset performance summary (such as a job or a task)"""

    __schema__ = schema
    __field_names__ = (
        "mcon",
        "display_name",
        "integration_type",
        "run_count",
        "last_run_uuid",
        "last_run_start_time",
        "last_run_end_time",
        "last_run_status",
        "avg_run_duration",
        "run_duration_trend7d",
        "run_duration_trend7d_issue",
        "failure_rate",
        "runs",
    )
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """Unique MC identifier for the asset"""

    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")
    """Human-readable name of the asset"""

    integration_type = sgqlc.types.Field(
        sgqlc.types.non_null(EtlType), graphql_name="integrationType"
    )
    """The integration type of the asset"""

    run_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="runCount")
    """Total runs for the asset, in the period"""

    last_run_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="lastRunUuid")
    """Last run of the asset, in the period"""

    last_run_start_time = sgqlc.types.Field(
        sgqlc.types.non_null(DateTime), graphql_name="lastRunStartTime"
    )
    """The start time of the last run of the asset, in the period"""

    last_run_end_time = sgqlc.types.Field(DateTime, graphql_name="lastRunEndTime")
    """The end time of the last run of the asset, in the period"""

    last_run_status = sgqlc.types.Field(
        sgqlc.types.non_null(EtlRunStatus), graphql_name="lastRunStatus"
    )
    """The status of the last run of the asset, in the period."""

    avg_run_duration = sgqlc.types.Field(Int, graphql_name="avgRunDuration")
    """Average duration of runs for the asset in the period, in ms"""

    run_duration_trend7d = sgqlc.types.Field(Float, graphql_name="runDurationTrend7d")
    """7-day trend of successful run durations for the asset, expressed
    as a decimal percentage (e.g., 0.15 = 15% increase). null if it
    cannot be calculated — see runDurationTrend7dIssue for details
    """

    run_duration_trend7d_issue = sgqlc.types.Field(
        EtlDurationTrendIssue, graphql_name="runDurationTrend7dIssue"
    )
    """If the 7-day trend cannot be calculated, this provides the reason
    why
    """

    failure_rate = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="failureRate")
    """Failure rate, expressed as a decimal percentage (.50 = 50%)"""

    runs = sgqlc.types.Field(
        sgqlc.types.non_null(
            sgqlc.types.list_of(sgqlc.types.non_null(sgqlc.types.list_of(String)))
        ),
        graphql_name="runs",
    )
    """List of run datapoints during the period for the asset, returned
    as a list of [start time (epoch ms), duration (ms), status]. For
    failures, it also includes [failure time (epoch ms)]
    """


class IEventDataBaseTimeline(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = (
        "updated_by_email",
        "updated_by_name",
        "updated_by_cognito_id",
        "updated_by_id",
        "updated_at",
        "event_uuid",
    )
    updated_by_email = sgqlc.types.Field(String, graphql_name="updatedByEmail")
    """email of the person who did some update that lead to this timeline
    item
    """

    updated_by_name = sgqlc.types.Field(String, graphql_name="updatedByName")
    """ame of the person who did some update that lead to this timeline
    item
    """

    updated_by_cognito_id = sgqlc.types.Field(String, graphql_name="updatedByCognitoId")
    """cognito id of the person who did some update that lead to this
    timeline item
    """

    updated_by_id = sgqlc.types.Field(String, graphql_name="updatedById")
    """mc id of the person who did some update that lead to this timeline
    item
    """

    updated_at = sgqlc.types.Field(String, graphql_name="updatedAt")
    """formatted datetime of when the timeline created"""

    event_uuid = sgqlc.types.Field(UUID, graphql_name="eventUuid")
    """Event unique identifier"""


class IMetricsMonitor(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = (
        "monitor_fields",
        "monitor_time_axis_field_name",
        "monitor_time_axis_field_type",
        "where_condition",
        "use_partition_clause",
        "segmented_expressions",
        "segmentation_type",
        "history_days",
        "collection_lag_hours",
        "select_expressions",
        "selected_metrics",
        "agg_time_interval",
        "high_segment_count",
        "min_segment_size",
        "segment_count",
        "bootstrap",
        "sensitivity",
        "monitor_sql_blocks",
        "agent_span_filters",
        "sampling_config",
        "filters",
    )
    monitor_fields = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="monitorFields")
    """Field/s to monitor"""

    monitor_time_axis_field_name = sgqlc.types.Field(
        String, graphql_name="monitorTimeAxisFieldName"
    )
    """The name of the table/view field used for establishing the table
    time
    """

    monitor_time_axis_field_type = sgqlc.types.Field(
        String, graphql_name="monitorTimeAxisFieldType"
    )
    """Type of time axis field used for establishing the table time"""

    where_condition = sgqlc.types.Field(String, graphql_name="whereCondition")
    """Comparison predicate for the monitor SQL query"""

    use_partition_clause = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="usePartitionClause"
    )
    """Whether to use automatic partition filter in query"""

    segmented_expressions = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="segmentedExpressions"
    )
    """Fields or expressions used to segment the monitored field
    (currently supports one such value)
    """

    segmentation_type = sgqlc.types.Field(SegmentationType, graphql_name="segmentationType")
    """The type of segmentation specified in segmented_expressions. For
    instance field or custom_sql_expression.
    """

    history_days = sgqlc.types.Field(Int, graphql_name="historyDays")
    """Number of lookback days for each monitor execution"""

    collection_lag_hours = sgqlc.types.Field(Int, graphql_name="collectionLagHours")
    """Hours to delay data collection. Only available for metric monitors
    with version >= 2.
    """

    select_expressions = sgqlc.types.Field(
        sgqlc.types.list_of("MetricMonitorSelectExpression"), graphql_name="selectExpressions"
    )
    """Monitor select expression"""

    selected_metrics = sgqlc.types.Field(
        sgqlc.types.list_of(FieldHealthMetrics), graphql_name="selectedMetrics"
    )
    """Selected metrics for the monitor. If empty, all metrics will be
    monitored. Only available for Field Health monitors.
    """

    agg_time_interval = sgqlc.types.Field(MonitorAggTimeInterval, graphql_name="aggTimeInterval")
    """For field health and dimension monitoring, the aggregation time
    interval to use. Either HOUR or DAY
    """

    high_segment_count = sgqlc.types.Field(Boolean, graphql_name="highSegmentCount")
    """Flag to apply additional limits which increase the supported
    segment count
    """

    min_segment_size = sgqlc.types.Field(Int, graphql_name="minSegmentSize")
    """Minimum number of rows for a segment to be retrieved. Segments
    with less rows than this will be discarded.
    """

    segment_count = sgqlc.types.Field(Int, graphql_name="segmentCount")
    """Number of segments collected on the last run of the monitor, or
    hinted during creation. If the monitor wasn't able to run, or the
    the monitor wasjust created and no segment count was passed during
    creation, the value will be null.
    """

    bootstrap = sgqlc.types.Field("MonitorBootstrap", graphql_name="bootstrap")
    """Current bootstrap state of the monitor"""

    sensitivity = sgqlc.types.Field(SensitivityLevels, graphql_name="sensitivity")
    """Sensitivity for automated thresholds"""

    monitor_sql_blocks = sgqlc.types.Field("MonitorSqlBlocks", graphql_name="monitorSqlBlocks")
    """SQL blocks used on the monitor"""

    agent_span_filters = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("AgentSpanFilter")),
        graphql_name="agentSpanFilters",
    )
    """agent span filters used on the monitor"""

    sampling_config = sgqlc.types.Field("MonitorSamplingConfig", graphql_name="samplingConfig")
    """Sampling configuration for the monitor"""

    filters = sgqlc.types.Field("FilterGroup", graphql_name="filters")
    """Filters used on the monitor"""


class IMonitor(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = (
        "uuid",
        "monitor_type",
        "created_time",
        "last_update_time",
        "creator_id",
        "updater_id",
        "creator",
        "updater",
        "resource_id",
        "entities",
        "entity_mcons",
        "entity_count",
        "schedule_type",
        "name",
        "rule_name",
        "description",
        "notes",
        "labels",
        "failure_audiences",
        "severity",
        "priority",
        "comparisons",
        "data_source",
        "notification_settings",
        "notify_rule_run_failure",
        "is_snoozeable",
        "is_paused",
        "migrated_to_uuid",
        "is_template_managed",
        "namespace",
        "next_execution_time",
        "prev_execution_time",
        "is_transitioning_data_provider",
        "schedule_config",
        "thirty_days_incident_count",
        "seven_days_incident_count",
        "incident_count_history",
        "weekly_incident_count_change_rate",
        "seven_days_error_count",
        "thirty_days_error_history",
        "seven_days_timeout_count",
        "thirty_days_timeout_history",
        "connection_id",
        "version",
        "is_ootb_monitor",
        "ootb_monitor_type",
        "is_auto_threshold_available",
        "tags",
        "data_quality_dimension",
        "is_ootb_replacement",
        "timeout",
    )
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """Unique identifier for monitors"""

    monitor_type = sgqlc.types.Field(
        sgqlc.types.non_null(UserDefinedMonitors), graphql_name="monitorType"
    )
    """Type of monitor"""

    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdTime")
    """Monitor creation time (UTC)"""

    last_update_time = sgqlc.types.Field(DateTime, graphql_name="lastUpdateTime")
    """Monitor last update time (UTC)"""

    creator_id = sgqlc.types.Field(String, graphql_name="creatorId")
    """Email of user who created the monitor"""

    updater_id = sgqlc.types.Field(String, graphql_name="updaterId")
    """Email of user who last updated the monitor"""

    creator = sgqlc.types.Field("User", graphql_name="creator")
    """Monitor creator"""

    updater = sgqlc.types.Field("User", graphql_name="updater")
    """Monitor updater"""

    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="resourceId")
    """Warehouse Unique Identifier"""

    entities = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="entities")
    """Full table IDs for monitored tables/views"""

    entity_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="entityMcons")
    """MCONs for monitored tables/views"""

    entity_count = sgqlc.types.Field(Int, graphql_name="entityCount")
    """Number of monitored entities"""

    schedule_type = sgqlc.types.Field(String, graphql_name="scheduleType")
    """Monitor scheduling type"""

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Monitor/rule name, default or user-defined"""

    rule_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="ruleName")
    """DEPRECATED: Rule name, default or user-defined, null for monitors.
    Use name instead.
    """

    description = sgqlc.types.Field(String, graphql_name="description")
    """Monitor user-defined name"""

    notes = sgqlc.types.Field(String, graphql_name="notes")
    """Notes defined on this monitor"""

    labels = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="labels")
    """List of tags used to filter a monitor"""

    failure_audiences = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="failureAudiences"
    )
    """List of audiences to notify on run failure"""

    severity = sgqlc.types.Field(String, graphql_name="severity")
    """DEPRECATED. Use priority instead. Default severity for incidents
    involving this monitor
    """

    priority = sgqlc.types.Field(String, graphql_name="priority")
    """Default priority for alerts involving this monitor"""

    comparisons = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("CustomRuleComparison")),
        graphql_name="comparisons",
    )
    """Metric evaluator configuration"""

    data_source = sgqlc.types.Field("MonitorDataSource", graphql_name="dataSource")
    """Data source for the monitor"""

    notification_settings = sgqlc.types.Field(
        sgqlc.types.list_of("AccountNotificationSetting"), graphql_name="notificationSettings"
    )
    """Notification channels that match the monitor. Only returned for
    custom monitors.
    """

    notify_rule_run_failure = sgqlc.types.Field(Boolean, graphql_name="notifyRuleRunFailure")
    """DEPRECATED: Completely ignored. This field has no effect on
    anything. Use `failure_audiences` to determine who is notified
    when run failures occur.
    """

    is_snoozeable = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isSnoozeable")
    """Whether the monitor can be snoozed"""

    is_paused = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isPaused")
    """Whether the monitor is currently paused"""

    migrated_to_uuid = sgqlc.types.Field(String, graphql_name="migratedToUuid")
    """UUID of the monitor this was migrated to, if applicable"""

    is_template_managed = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="isTemplateManaged"
    )
    """Whether the monitor was created from through monitor-as-code"""

    namespace = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="namespace")
    """The monitor-as-code namespace used when creating the monitor"""

    next_execution_time = sgqlc.types.Field(DateTime, graphql_name="nextExecutionTime")
    """The next time (UTC) in which the monitor will run"""

    prev_execution_time = sgqlc.types.Field(DateTime, graphql_name="prevExecutionTime")
    """The last time (UTC) in which the monitor ran"""

    is_transitioning_data_provider = sgqlc.types.Field(
        Boolean, graphql_name="isTransitioningDataProvider"
    )

    schedule_config = sgqlc.types.Field("ScheduleConfigOutput", graphql_name="scheduleConfig")

    thirty_days_incident_count = sgqlc.types.Field(Int, graphql_name="thirtyDaysIncidentCount")
    """Number of incidents in the past 30 days"""

    seven_days_incident_count = sgqlc.types.Field(Int, graphql_name="sevenDaysIncidentCount")
    """Number of incidents in the past 7 days"""

    incident_count_history = sgqlc.types.Field(
        sgqlc.types.list_of("IncidentDailyCount"), graphql_name="incidentCountHistory"
    )
    """Number of incidents per day for the past 30 days"""

    weekly_incident_count_change_rate = sgqlc.types.Field(
        Int, graphql_name="weeklyIncidentCountChangeRate"
    )
    """Change in percentage between between last 7 days and the 7 days
    before.
    """

    seven_days_error_count = sgqlc.types.Field(Int, graphql_name="sevenDaysErrorCount")
    """Number of failed runs in the past 7 days"""

    thirty_days_error_history = sgqlc.types.Field(
        sgqlc.types.list_of("RunDailyCount"), graphql_name="thirtyDaysErrorHistory"
    )
    """Number of failed runs per day for the past 30 days"""

    seven_days_timeout_count = sgqlc.types.Field(Int, graphql_name="sevenDaysTimeoutCount")
    """Number of timeout runs in the past 7 days"""

    thirty_days_timeout_history = sgqlc.types.Field(
        sgqlc.types.list_of("RunDailyCount"), graphql_name="thirtyDaysTimeoutHistory"
    )
    """Number of timeout runs per day for the past 30 days"""

    connection_id = sgqlc.types.Field(UUID, graphql_name="connectionId")
    """The connection UUID associated with the rule"""

    version = sgqlc.types.Field(String, graphql_name="version")
    """Indicates the version of this monitor. For instance, older
    freshness and volume rules will have version '1' and unified new
    ones will have version '2'.
    """

    is_ootb_monitor = sgqlc.types.Field(Boolean, graphql_name="isOotbMonitor")
    """Indicates whether this is an OOTB monitor (set to true for OOTB
    monitors and OOTB replacement rules)
    """

    ootb_monitor_type = sgqlc.types.Field(OotbTableMonitorTypeEnum, graphql_name="ootbMonitorType")
    """The type of OOTB monitor"""

    is_auto_threshold_available = sgqlc.types.Field(
        Boolean, graphql_name="isAutoThresholdAvailable"
    )
    """For OOTB monitors, this flag indicates whether ML thresholds are
    available.
    """

    tags = sgqlc.types.Field(sgqlc.types.list_of("TagKeyValuePairOutput"), graphql_name="tags")
    """Tags on this monitor."""

    data_quality_dimension = sgqlc.types.Field(String, graphql_name="dataQualityDimension")
    """Data quality dimension on a monitor."""

    is_ootb_replacement = sgqlc.types.Field(Boolean, graphql_name="isOotbReplacement")
    """(experimental) Returns if this monitor replaces the default ootb
    detector.
    """

    timeout = sgqlc.types.Field(Int, graphql_name="timeout")
    """Timeout for the SQL query"""


class IMonitorStatus(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = (
        "monitor_run_status",
        "monitor_configuration_status",
        "monitor_training_status",
        "monitor_status",
        "consolidated_monitor_status",
        "exceptions",
    )
    monitor_run_status = sgqlc.types.Field(
        sgqlc.types.non_null(MonitorRunStatusType), graphql_name="monitorRunStatus"
    )
    """Monitor run status"""

    monitor_configuration_status = sgqlc.types.Field(
        sgqlc.types.non_null(MonitorConfigurationStatusType),
        graphql_name="monitorConfigurationStatus",
    )
    """Monitor configuration status"""

    monitor_training_status = sgqlc.types.Field(
        sgqlc.types.non_null(MonitorTrainingStatusType), graphql_name="monitorTrainingStatus"
    )
    """Monitor training status"""

    monitor_status = sgqlc.types.Field(
        sgqlc.types.non_null(MonitorStatusType), graphql_name="monitorStatus"
    )
    """Consolidated monitor status"""

    consolidated_monitor_status = sgqlc.types.Field(
        sgqlc.types.non_null(ConsolidatedMonitorStatusType),
        graphql_name="consolidatedMonitorStatus",
    )
    """Consolidated monitor status that indicates the overall status of
    the monitor
    """

    exceptions = sgqlc.types.Field(String, graphql_name="exceptions")
    """Exceptions if any occurred during the last run"""


class IQueryRca(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = (
        "query_log_group_hash",
        "query_log_id",
        "query_type",
        "query_subtype",
        "user",
        "start_time",
        "mcon",
    )
    query_log_group_hash = sgqlc.types.Field(String, graphql_name="queryLogGroupHash")
    """Hash of query group the query belongs to"""

    query_log_id = sgqlc.types.Field(String, graphql_name="queryLogId")
    """UUID of specific query"""

    query_type = sgqlc.types.Field(String, graphql_name="queryType")
    """The type of query that failed"""

    query_subtype = sgqlc.types.Field(String, graphql_name="querySubtype")
    """The sub-type of the query that failed"""

    user = sgqlc.types.Field(String, graphql_name="user")
    """The user who ran the query that failed"""

    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """The RCA start time"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """The MCON of the table associated with the RCA"""


class Node(sgqlc.types.Interface):
    """An object with an ID"""

    __schema__ = schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    """The ID of the object."""


class NodeWithUUID(sgqlc.types.Interface):
    """Use this when the node has a uuid field. Uuid will be returned as
    the id of the node.
    """

    __schema__ = schema
    __field_names__ = ("id",)
    id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="id")


class RecommendationConfigInterface(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = (
        "schedule_config",
        "resource_id",
        "description",
        "display_description",
        "notes",
        "type",
        "data_source",
        "labels",
        "reason",
    )
    schedule_config = sgqlc.types.Field(
        sgqlc.types.non_null("ScheduleConfig"), graphql_name="scheduleConfig"
    )

    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="resourceId")

    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="description")

    display_description = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="displayDescription"
    )

    notes = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="notes")

    type = sgqlc.types.Field(sgqlc.types.non_null(UserDefinedMonitors), graphql_name="type")

    data_source = sgqlc.types.Field(
        sgqlc.types.non_null(DataSourceInterface), graphql_name="dataSource"
    )

    labels = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="labels",
    )

    reason = sgqlc.types.Field(String, graphql_name="reason")


class ReportArgumentsInterface(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ("type",)
    type = sgqlc.types.Field(sgqlc.types.non_null(ReportTypeEnum), graphql_name="type")


class ResponseMetadataInterface(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ("type",)
    type = sgqlc.types.Field(sgqlc.types.non_null(ResponseMetadataType), graphql_name="type")


class ServiceNowCredentialsInterface(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ("type",)
    type = sgqlc.types.Field(sgqlc.types.non_null(ServiceNowCredentialsType), graphql_name="type")


class AIMessageOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("message", "actor", "status")
    message = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="message")
    """Message from the specified actor"""

    actor = sgqlc.types.Field(sgqlc.types.non_null(ActorType), graphql_name="actor")
    """The actor that sends the message"""

    status = sgqlc.types.Field(String, graphql_name="status")
    """When streaming the results, it returns the status of the request"""


class AccessRequest(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "user_id",
        "status",
        "target_permission",
        "target_id",
        "reason",
        "created_time",
        "updated_time",
        "notified_admins",
    )
    id = sgqlc.types.Field(Int, graphql_name="id")
    """Unique identifier for the access request"""

    user_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="userId")
    """User who requested access"""

    status = sgqlc.types.Field(Status, graphql_name="status")
    """Current status of the access request"""

    target_permission = sgqlc.types.Field(
        sgqlc.types.non_null(Permission), graphql_name="targetPermission"
    )
    """Permission requested"""

    target_id = sgqlc.types.Field(String, graphql_name="targetId")
    """Object ID access was requested for"""

    reason = sgqlc.types.Field(String, graphql_name="reason")
    """Reason for requesting access"""

    created_time = sgqlc.types.Field(DateTime, graphql_name="createdTime")
    """When the request was created"""

    updated_time = sgqlc.types.Field(DateTime, graphql_name="updatedTime")
    """When the request was last updated"""

    notified_admins = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="notifiedAdmins")
    """List of admin emails that were notified about this request"""


class AccessRequestOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success", "access_request")
    success = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="success")
    """Whether the operation was successful"""

    access_request = sgqlc.types.Field(AccessRequest, graphql_name="accessRequest")
    """The access request object"""


class AccessToken(sgqlc.types.Type):
    """Generated API Token ID and Access Key. Only available once"""

    __schema__ = schema
    __field_names__ = ("id", "token")
    id = sgqlc.types.Field(String, graphql_name="id")
    """Token user ID"""

    token = sgqlc.types.Field(String, graphql_name="token")
    """Generated token"""


class Account(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "uuid",
        "name",
        "created_on",
        "config",
        "allow_non_sso_login",
        "data_share",
        "is_deleted",
        "pending_deletion",
        "notification_settings",
        "data_collectors",
        "users",
        "user_invites",
        "user_account_before_switch",
        "warehouses",
        "bi",
        "etl_containers",
        "connections",
        "alerts",
        "custom_sql_templates",
        "tablepartitionkeysmodel_set",
        "slack_credentials",
        "slack_channels",
        "slack_msg_details",
        "resources",
        "account_domains",
        "alation_integrations",
        "slack_credentials_v2",
        "collection_preferences",
        "asset_collection_preferences",
        "data_products",
        "opsgenie_integrations",
        "collibra_integrations",
        "agenttracetablemodel_set",
        "entitlements",
        "dashboards",
        "comparison_dashboards",
        "widgets",
        "identity_provider",
        "tableau_accounts",
        "use_monitor_domains",
        "active_collection_regions",
        "internal_notifications",
        "can_generate_data_collector_template",
        "entitlements_limits",
        "monitor_limits",
        "statement_option",
        "statement_emails",
        "usage_alert_config",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """The account id"""

    name = sgqlc.types.Field(String, graphql_name="name")
    """The account name"""

    created_on = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdOn")
    """When the account was first created"""

    config = sgqlc.types.Field(JSONString, graphql_name="config")
    """Account configuration"""

    allow_non_sso_login = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="allowNonSsoLogin"
    )

    data_share = sgqlc.types.Field(JSONString, graphql_name="dataShare")
    """Information necessary to setup a Snowflake Data Share"""

    is_deleted = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isDeleted")

    pending_deletion = sgqlc.types.Field(Date, graphql_name="pendingDeletion")
    """The date the account was marked as pending for deletion"""

    notification_settings = sgqlc.types.Field(
        sgqlc.types.non_null(
            sgqlc.types.list_of(sgqlc.types.non_null("AccountNotificationSetting"))
        ),
        graphql_name="notificationSettings",
        args=sgqlc.types.ArgDict(
            (
                (
                    "with_audience",
                    sgqlc.types.Arg(Boolean, graphql_name="withAudience", default=None),
                ),
            )
        ),
    )
    """Arguments:

    * `with_audience` (`Boolean`): If true, only settings associated
      to an audience will be returned. If false, only settings not
      associated will be returned. If not provided, all settings will
      be returned
    """

    data_collectors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DataCollector"))),
        graphql_name="dataCollectors",
    )

    users = sgqlc.types.Field(
        sgqlc.types.non_null("UserConnection"),
        graphql_name="users",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("email", sgqlc.types.Arg(String, graphql_name="email", default=None)),
                ("first_name", sgqlc.types.Arg(String, graphql_name="firstName", default=None)),
                ("last_name", sgqlc.types.Arg(String, graphql_name="lastName", default=None)),
                ("role", sgqlc.types.Arg(String, graphql_name="role", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `email` (`String`)None
    * `first_name` (`String`)None
    * `last_name` (`String`)None
    * `role` (`String`)None
    """

    user_invites = sgqlc.types.Field(
        sgqlc.types.non_null("UserInviteConnection"),
        graphql_name="userInvites",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("state", sgqlc.types.Arg(String, graphql_name="state", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `state` (`String`)None
    """

    user_account_before_switch = sgqlc.types.Field(
        sgqlc.types.non_null("UserInviteConnection"),
        graphql_name="userAccountBeforeSwitch",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("state", sgqlc.types.Arg(String, graphql_name="state", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `state` (`String`)None
    """

    warehouses = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Warehouse"))),
        graphql_name="warehouses",
    )

    bi = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("BiContainer"))),
        graphql_name="bi",
    )

    etl_containers = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("EtlContainer"))),
        graphql_name="etlContainers",
    )

    connections = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Connection"))),
        graphql_name="connections",
    )

    alerts = sgqlc.types.Field(
        sgqlc.types.non_null("IncidentConnection"),
        graphql_name="alerts",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    custom_sql_templates = sgqlc.types.Field(
        sgqlc.types.non_null("CustomSQLTemplateConnection"),
        graphql_name="customSqlTemplates",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("uuid", sgqlc.types.Arg(UUID, graphql_name="uuid", default=None)),
                ("name", sgqlc.types.Arg(String, graphql_name="name", default=None)),
                ("description", sgqlc.types.Arg(String, graphql_name="description", default=None)),
                ("sql_template", sgqlc.types.Arg(String, graphql_name="sqlTemplate", default=None)),
                ("dialect", sgqlc.types.Arg(String, graphql_name="dialect", default=None)),
                (
                    "query_result_type",
                    sgqlc.types.Arg(
                        CustomSQLTemplateModelQueryResultType,
                        graphql_name="queryResultType",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `uuid` (`UUID`)None
    * `name` (`String`)None
    * `description` (`String`)None
    * `sql_template` (`String`)None
    * `dialect` (`String`)None
    * `query_result_type`
      (`CustomSQLTemplateModelQueryResultType`)None
    """

    tablepartitionkeysmodel_set = sgqlc.types.Field(
        sgqlc.types.non_null("TablePartitionKeysConnection"),
        graphql_name="tablepartitionkeysmodelSet",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    slack_credentials = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SlackCredentials"))),
        graphql_name="slackCredentials",
    )

    slack_channels = sgqlc.types.Field(
        sgqlc.types.non_null("SlackChannelV2Connection"),
        graphql_name="slackChannels",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """The account associated with the slack channel.

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    slack_msg_details = sgqlc.types.Field(
        sgqlc.types.non_null("SlackMessageDetailsConnection"),
        graphql_name="slackMsgDetails",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    resources = sgqlc.types.Field(
        sgqlc.types.non_null("ResourceConnection"),
        graphql_name="resources",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Customer account

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    account_domains = sgqlc.types.Field(
        sgqlc.types.non_null("DomainRestrictionConnection"),
        graphql_name="accountDomains",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Related account

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    alation_integrations = sgqlc.types.Field(
        sgqlc.types.non_null("AlationIntegrationConnection"),
        graphql_name="alationIntegrations",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    slack_credentials_v2 = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SlackCredentialsV2"))),
        graphql_name="slackCredentialsV2",
    )

    collection_preferences = sgqlc.types.Field(
        sgqlc.types.non_null("CollectionBlockConnection"),
        graphql_name="collectionPreferences",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    asset_collection_preferences = sgqlc.types.Field(
        sgqlc.types.non_null("AssetCollectionPreferencesConnection"),
        graphql_name="assetCollectionPreferences",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    data_products = sgqlc.types.Field(
        sgqlc.types.non_null("DataProductConnection"),
        graphql_name="dataProducts",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    opsgenie_integrations = sgqlc.types.Field(
        sgqlc.types.non_null(
            sgqlc.types.list_of(sgqlc.types.non_null("OpsgenieIntegrationOutput"))
        ),
        graphql_name="opsgenieIntegrations",
    )

    collibra_integrations = sgqlc.types.Field(
        sgqlc.types.non_null("CollibraIntegrationConnection"),
        graphql_name="collibraIntegrations",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    agenttracetablemodel_set = sgqlc.types.Field(
        sgqlc.types.non_null("AgentTraceTableConnection"),
        graphql_name="agenttracetablemodelSet",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    entitlements = sgqlc.types.Field(
        sgqlc.types.list_of(EntitlementTypes), graphql_name="entitlements"
    )
    """Entitlements granted to the account"""

    dashboards = sgqlc.types.Field(
        sgqlc.types.non_null("DataExplorerDashboardTypeConnection"),
        graphql_name="dashboards",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    comparison_dashboards = sgqlc.types.Field(
        sgqlc.types.non_null("DataExplorerComparisonDashboardTypeConnection"),
        graphql_name="comparisonDashboards",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    widgets = sgqlc.types.Field(
        sgqlc.types.non_null("DataExplorerWidgetTypeConnection"),
        graphql_name="widgets",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    identity_provider = sgqlc.types.Field("SamlIdentityProvider", graphql_name="identityProvider")

    tableau_accounts = sgqlc.types.Field(
        sgqlc.types.list_of("TableauAccount"), graphql_name="tableauAccounts"
    )

    use_monitor_domains = sgqlc.types.Field(Boolean, graphql_name="useMonitorDomains")
    """Indicates whether the account is using monitor domains"""

    active_collection_regions = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="activeCollectionRegions"
    )
    """AWS Regions where a DC can be hosted"""

    internal_notifications = sgqlc.types.Field(
        sgqlc.types.list_of("InternalNotifications"), graphql_name="internalNotifications"
    )
    """MC internal account notifications."""

    can_generate_data_collector_template = sgqlc.types.Field(
        Boolean, graphql_name="canGenerateDataCollectorTemplate"
    )
    """Indicates whether the account is allowed to generate a data
    collector template
    """

    entitlements_limits = sgqlc.types.Field(
        sgqlc.types.list_of("AccountEntitlementLimit"), graphql_name="entitlementsLimits"
    )

    monitor_limits = sgqlc.types.Field("MonitorLimits", graphql_name="monitorLimits")

    statement_option = sgqlc.types.Field(StatementOption, graphql_name="statementOption")
    """The account's preference for who should receive statement emails"""

    statement_emails = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="statementEmails"
    )
    """List of email addresses to receive statements"""

    usage_alert_config = sgqlc.types.Field(
        "UsageAlertConfigOutput", graphql_name="usageAlertConfig"
    )


class AccountAuditLog(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "timestamp",
        "account_uuid",
        "account_name",
        "email",
        "first_name",
        "last_name",
        "url",
        "event_type",
        "api_name",
        "api_is_query",
        "api_call_references",
        "api_call_source",
        "client_ip",
    )
    timestamp = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="timestamp")
    """Timestamp of the event"""

    account_uuid = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="accountUuid")
    """Account ID"""

    account_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="accountName")
    """Account name"""

    email = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="email")
    """Email of the user"""

    first_name = sgqlc.types.Field(String, graphql_name="firstName")
    """First name of the user"""

    last_name = sgqlc.types.Field(String, graphql_name="lastName")
    """Last name of the user"""

    url = sgqlc.types.Field(String, graphql_name="url")
    """URL on which the event occurred"""

    event_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="eventType")
    """Event type"""

    api_name = sgqlc.types.Field(String, graphql_name="apiName")
    """API name in case of GraphQL API calls"""

    api_is_query = sgqlc.types.Field(Boolean, graphql_name="apiIsQuery")
    """Whether a GraphQL API call is a query"""

    api_call_references = sgqlc.types.Field(String, graphql_name="apiCallReferences")
    """References (For instance UUIDs) passed as input parameters in
    GraphQL API calls
    """

    api_call_source = sgqlc.types.Field(String, graphql_name="apiCallSource")
    """Indicates the source of the GraphQL API call.For instance, `Web`
    or `Programmatic`
    """

    client_ip = sgqlc.types.Field(String, graphql_name="clientIp")
    """Client IP address"""


class AccountEntitlementLimit(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("name", "value")
    name = sgqlc.types.Field(sgqlc.types.non_null(EntitlementLimits), graphql_name="name")

    value = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="value")


class AccountEntitlementsInfo(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("entitlements",)
    entitlements = sgqlc.types.Field(
        sgqlc.types.list_of(EntitlementTypes), graphql_name="entitlements"
    )


class AccountNotificationDigestSettings(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "interval_minutes",
        "start_time",
        "prev_execution_time",
        "next_execution_time",
        "created_time",
        "uuid",
        "digest_type",
        "routing_rules",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    interval_minutes = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="intervalMinutes")
    """Frequency interval in minutes to indicate how often to run the the
    schedule.
    """

    start_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="startTime")
    """First start time to run the schedule."""

    prev_execution_time = sgqlc.types.Field(DateTime, graphql_name="prevExecutionTime")
    """Previous successful execution time."""

    next_execution_time = sgqlc.types.Field(
        sgqlc.types.non_null(DateTime), graphql_name="nextExecutionTime"
    )
    """Scheduled time for next run."""

    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdTime")
    """Timestamp of when the schedule is created."""

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """Unique id of the digest settings."""

    digest_type = sgqlc.types.Field(
        sgqlc.types.non_null(AccountNotificationDigestSettingsModelDigestType),
        graphql_name="digestType",
    )
    """Type of digest."""

    routing_rules = sgqlc.types.Field("NotificationRoutingRule", graphql_name="routingRules")


class AccountNotificationRoutingRules(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "uuid",
        "table_rules",
        "tag_rules",
        "sql_rules",
        "table_stats_rules",
        "domain_rules",
        "monitor_labels",
        "monitor_labels_match_type",
        "table_id_rules",
        "asset_rules",
        "anomaly_types",
        "incident_sub_types",
        "custom_message",
        "digest_settings",
        "audience",
        "created_time",
        "updated_time",
        "created_by",
        "last_update_user",
        "notification_settings",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """The route rule id"""

    table_rules = sgqlc.types.Field(String, graphql_name="tableRules")
    """Table/dataset based rules (regex)"""

    tag_rules = sgqlc.types.Field(JSONString, graphql_name="tagRules")
    """Key and key/value based rules"""

    sql_rules = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(UUID)), graphql_name="sqlRules"
    )
    """Custom sql rules"""

    table_stats_rules = sgqlc.types.Field(JSONString, graphql_name="tableStatsRules")
    """Rules based on table stats (importance_score, is_important)."""

    domain_rules = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(UUID)), graphql_name="domainRules"
    )
    """List of domain UUIDs to match event objects against."""

    monitor_labels = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(UUID)), graphql_name="monitorLabels"
    )
    """labels"""

    monitor_labels_match_type = sgqlc.types.Field(
        sgqlc.types.non_null(AccountNotificationRoutingRulesModelMonitorLabelsMatchType),
        graphql_name="monitorLabelsMatchType",
    )
    """Specifies what logic operator to apply when matching labels"""

    table_id_rules = sgqlc.types.Field(JSONString, graphql_name="tableIdRules")
    """Project/dataset/table based rules"""

    asset_rules = sgqlc.types.Field(JSONString, graphql_name="assetRules")
    """Asset based rules"""

    anomaly_types = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="anomalyTypes"
    )
    """List of supported incident types to send notifications for"""

    incident_sub_types = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="incidentSubTypes"
    )
    """All the incident sub-types this notification settings will alert
    on.
    """

    custom_message = sgqlc.types.Field(String, graphql_name="customMessage")
    """Custom text to be included with the notification"""

    digest_settings = sgqlc.types.Field(
        AccountNotificationDigestSettings, graphql_name="digestSettings"
    )
    """Digest notification settings for events matching the rule"""

    audience = sgqlc.types.Field("MonitorLabelObject", graphql_name="audience")
    """Routing rules per audience"""

    created_time = sgqlc.types.Field(DateTime, graphql_name="createdTime")

    updated_time = sgqlc.types.Field(DateTime, graphql_name="updatedTime")

    created_by = sgqlc.types.Field("User", graphql_name="createdBy")
    """Creator of the routing rule"""

    last_update_user = sgqlc.types.Field("User", graphql_name="lastUpdateUser")
    """Routing rule last updated by"""

    notification_settings = sgqlc.types.Field(
        "NotificationSetting", graphql_name="notificationSettings"
    )


class AccountNotificationSetting(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "deleted_at",
        "uuid",
        "created_by",
        "created_time",
        "last_updated_by",
        "last_update_time",
        "name",
        "is_template_managed",
        "namespace",
        "type",
        "recipients",
        "extra",
        "routing_rules",
        "notification_schedule_type",
        "notification_enabled",
        "audience",
        "slack_msg_details",
        "specification_rule",
        "recipient",
        "recipient_display_name",
        "recipients_display_names",
        "digest_settings",
        "permalink",
        "notification_count_history",
        "anomaly_types",
        "incident_sub_types",
        "alert_sub_types",
        "matching_incidents",
        "custom_message",
        "integration_id",
        "channel_url",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    deleted_at = sgqlc.types.Field(DateTime, graphql_name="deletedAt")

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """Effective ID for notification settings"""

    created_by = sgqlc.types.Field("User", graphql_name="createdBy")
    """Creator of the notification"""

    created_time = sgqlc.types.Field(DateTime, graphql_name="createdTime")
    """When the notification was first created"""

    last_updated_by = sgqlc.types.Field("User", graphql_name="lastUpdatedBy")
    """User who last updated this notification"""

    last_update_time = sgqlc.types.Field(DateTime, graphql_name="lastUpdateTime")
    """When the notification was last updated"""

    name = sgqlc.types.Field(String, graphql_name="name")
    """Resource name for notifications created through notifications-as-
    code
    """

    is_template_managed = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="isTemplateManaged"
    )
    """Is this monitor managed by a configuration template
    (notifications-as-code)?
    """

    namespace = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="namespace")
    """Namespace of notification, used for notifications-as-code"""

    type = sgqlc.types.Field(
        sgqlc.types.non_null(AccountNotificationSettingsModelType), graphql_name="type"
    )
    """Type of notification integration (e.g. slack)"""

    recipients = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="recipients"
    )
    """Destinations to send notifications to"""

    extra = sgqlc.types.Field(JSONString, graphql_name="extra")
    """Any additional information for various notification integrations"""

    routing_rules = sgqlc.types.Field(AccountNotificationRoutingRules, graphql_name="routingRules")

    notification_schedule_type = sgqlc.types.Field(
        sgqlc.types.non_null(AccountNotificationSettingsModelNotificationScheduleType),
        graphql_name="notificationScheduleType",
    )
    """Indicates whether the notification is of real time or digest types"""

    notification_enabled = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="notificationEnabled"
    )
    """When enabled notifications for this setting are sent."""

    audience = sgqlc.types.Field("MonitorLabelObject", graphql_name="audience")
    """Notification settings per audience"""

    slack_msg_details = sgqlc.types.Field(
        sgqlc.types.non_null("SlackMessageDetailsConnection"),
        graphql_name="slackMsgDetails",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    specification_rule = sgqlc.types.Field(String, graphql_name="specificationRule")
    """Deprecated. Use routingRules tableRules."""

    recipient = sgqlc.types.Field(String, graphql_name="recipient")
    """Deprecated. Use recipients instead."""

    recipient_display_name = sgqlc.types.Field(String, graphql_name="recipientDisplayName")

    recipients_display_names = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="recipientsDisplayNames"
    )

    digest_settings = sgqlc.types.Field(
        AccountNotificationDigestSettings, graphql_name="digestSettings"
    )

    permalink = sgqlc.types.Field(String, graphql_name="permalink")

    notification_count_history = sgqlc.types.Field(
        sgqlc.types.list_of("NotificationDailyCount"), graphql_name="notificationCountHistory"
    )
    """Number of incidents per day for the past 30 days"""

    anomaly_types = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="anomalyTypes")
    """Limit notifications to specific incident types (default=all).
    Supported options include: anomalies, schema_changes,
    json_schema_changes, deleted_tables, metric_anomalies,
    agent_anomalies, metric_comparison_anomalies,
    custom_rule_anomalies, performance_anomalies, dbt_errors,
    etl_errors, pseudo_integration_test, rule_run_execution_error,
    merged
    """

    incident_sub_types = sgqlc.types.Field(
        sgqlc.types.list_of(IncidentSubType), graphql_name="incidentSubTypes"
    )
    """Limit notifications to specific incident sub types (default=all)."""

    alert_sub_types = sgqlc.types.Field(
        sgqlc.types.list_of(AlertSubType), graphql_name="alertSubTypes"
    )
    """Limit notifications to specific alert sub types (default=all)."""

    matching_incidents = sgqlc.types.Field(Int, graphql_name="matchingIncidents")

    custom_message = sgqlc.types.Field(String, graphql_name="customMessage")
    """Message to add on every notification"""

    integration_id = sgqlc.types.Field(UUID, graphql_name="integrationId")
    """Integration ID for the recipient"""

    channel_url = sgqlc.types.Field(String, graphql_name="channelUrl")
    """URL of the channel if this is a channel-based notification.
    Currently only Slack and MS Teams is supported.
    """


class AccountSecretOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "name",
        "scope",
        "description",
        "expires_at",
        "value",
        "created_by",
        "created_at",
        "updated_by",
        "last_update",
    )
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """The secret name"""

    scope = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="scope")
    """The secret scope"""

    description = sgqlc.types.Field(String, graphql_name="description")
    """The secret description"""

    expires_at = sgqlc.types.Field(DateTime, graphql_name="expiresAt")
    """When does the secret expire. Null if it doesn't expire."""

    value = sgqlc.types.Field(String, graphql_name="value")
    """The secret value. Can only be accessed under specific conditions
    and by explicitly asking it with the 'reveal' option.
    """

    created_by = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="createdBy")
    """The user that created the secret"""

    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")
    """When the secret was created"""

    updated_by = sgqlc.types.Field(String, graphql_name="updatedBy")
    """The user that updated the secret"""

    last_update = sgqlc.types.Field(DateTime, graphql_name="lastUpdate")
    """When the secret was last updated"""


class AccountUsageObject(sgqlc.types.Type):
    """Account usage and consumption."""

    __schema__ = schema
    __field_names__ = ("ingested", "monitored", "timestamp")
    ingested = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="ingested")
    """Number of ingested tables"""

    monitored = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="monitored")
    """Number of monitored tables"""

    timestamp = sgqlc.types.Field(DateTime, graphql_name="timestamp")
    """Timestamp of the usage record."""


class ActiveNodeDetails(sgqlc.types.Type):
    """Active node information"""

    __schema__ = schema
    __field_names__ = (
        "name",
        "stack_arn",
        "uuid",
        "code_version",
        "template_version",
        "private_cidr",
        "private_ip_addresses",
    )
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Node Name"""

    stack_arn = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="stackArn")
    """Stack ARN"""

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """Node UUID"""

    code_version = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="codeVersion")
    """Code Version"""

    template_version = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="templateVersion"
    )
    """Template Version"""

    private_cidr = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name="privateCidr"
    )
    """Private CIDR"""

    private_ip_addresses = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name="privateIpAddresses"
    )
    """List of Private IP addresses"""


class AddAllowListEntry(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success", "project_name", "dataset")
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """Whether the mutation succeeded."""

    project_name = sgqlc.types.Field(String, graphql_name="projectName")
    """The project name for which the dataset was added."""

    dataset = sgqlc.types.Field(String, graphql_name="dataset")
    """The dataset name that was added."""


class AddBiConnectionMutation(sgqlc.types.Type):
    """Add a bi connection and setup any associated jobs"""

    __schema__ = schema
    __field_names__ = ("connection",)
    connection = sgqlc.types.Field("Connection", graphql_name="connection")


class AddConnectionMutation(sgqlc.types.Type):
    """Add a connection and setup any associated jobs. Creates a
    warehouse if not specified
    """

    __schema__ = schema
    __field_names__ = ("connection",)
    connection = sgqlc.types.Field("Connection", graphql_name="connection")


class AddDatabricksConnectionMutation(sgqlc.types.Type):
    """Add a databricks connection and setup any associated jobs. Creates
    a warehouse if not specified
    """

    __schema__ = schema
    __field_names__ = ("connection",)
    connection = sgqlc.types.Field("Connection", graphql_name="connection")


class AddEtlConnectionMutation(sgqlc.types.Type):
    """Add an etl connection and setup any associated jobs"""

    __schema__ = schema
    __field_names__ = ("connection",)
    connection = sgqlc.types.Field("Connection", graphql_name="connection")


class AddMonitorsLabels(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class AddPlatformService(sgqlc.types.Type):
    """Adds a new platform service to the account, restricted operation."""

    __schema__ = schema
    __field_names__ = ("service_uuid",)
    service_uuid = sgqlc.types.Field(UUID, graphql_name="serviceUuid")
    """The UUID of to the new service"""


class AddRedshiftConsumerConnectionMutation(sgqlc.types.Type):
    """Add a Redshift consumer connection. Used for DataShare lineage."""

    __schema__ = schema
    __field_names__ = ("connection",)
    connection = sgqlc.types.Field("Connection", graphql_name="connection")


class AddStreamingConnectionMutation(sgqlc.types.Type):
    """Add a connection for a streaming cluster and setup any associated
    jobs. Creates a streaming cluster if a cluster if not specified.
    """

    __schema__ = schema
    __field_names__ = ("connection",)
    connection = sgqlc.types.Field("Connection", graphql_name="connection")


class AddStreamingSystemMutation(sgqlc.types.Type):
    """Add a streaming system, which contains a set of streaming clusters
    that work together in the system.
    """

    __schema__ = schema
    __field_names__ = ("streaming_system",)
    streaming_system = sgqlc.types.Field("StreamingSystem", graphql_name="streamingSystem")


class AddToCollectionBlockList(sgqlc.types.Type):
    """Adds to the list of entities for which metadata collection is not
    allowed on this account.
    """

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """Whether the mutation succeeded."""


class AdditionalData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "projects_validated",
        "datasets_validated",
        "tables_validated",
        "queries_with_results",
        "returned_data",
    )
    projects_validated = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="projectsValidated"
    )
    """Projects that were validated."""

    datasets_validated = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="datasetsValidated"
    )
    """Datasets that were validated."""

    tables_validated = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="tablesValidated"
    )
    """Tables that were validated."""

    queries_with_results = sgqlc.types.Field(
        sgqlc.types.list_of("QueryWithResults"), graphql_name="queriesWithResults"
    )
    """Queries that were executed for validation along with their
    results.
    """

    returned_data = sgqlc.types.Field(GenericScalar, graphql_name="returnedData")
    """JSON object containing all data returned from validation."""


class AdditionalMonitoredTablesCountOutput(sgqlc.types.Type):
    """Number of additional tables that would be monitored by"""

    __schema__ = schema
    __field_names__ = ("count", "total_count")
    count = sgqlc.types.Field(Int, graphql_name="count")
    """Number of additional tables that would be monitored by current and
    new rules if applied
    """

    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")
    """Total number of tables encapsulated by the rule (both currently
    monitored and unmonitored)
    """


class AdfJobConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AdfJobEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class AdfJobEdge(sgqlc.types.Type):
    """A Relay edge containing a `AdfJob` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("AdfJob", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AdfJobRunConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AdfJobRunEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class AdfJobRunEdge(sgqlc.types.Type):
    """A Relay edge containing a `AdfJobRun` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("AdfJobRun", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AdfJobRunsConnection(sgqlc.types.relay.Connection):
    """ADF job executions response"""

    __schema__ = schema
    __field_names__ = ("page_info", "edges", "edge_count", "total_count")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AdfJobRunsEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""

    edge_count = sgqlc.types.Field(Int, graphql_name="edgeCount")
    """Total number of edges returned (page count)"""

    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")
    """Total number of edges matching filter (total count)"""


class AdfJobRunsEdge(sgqlc.types.Type):
    """A Relay edge containing a `AdfJobRuns` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("AdfJobRun", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AdfTaskConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AdfTaskEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class AdfTaskEdge(sgqlc.types.Type):
    """A Relay edge containing a `AdfTask` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("AdfTask", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AdfTaskRunConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AdfTaskRunEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class AdfTaskRunEdge(sgqlc.types.Type):
    """A Relay edge containing a `AdfTaskRun` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("AdfTaskRun", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class Agent(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "uuid",
        "data_collector",
        "endpoint",
        "platform",
        "agent_type",
        "wrapper_type",
        "auth_type",
        "storage_type",
        "credentials_s3_key",
        "created_time",
        "last_updated_time",
        "wrapper_version",
        "image_build",
        "image_version",
        "is_remote_upgradeable",
        "is_deleted",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")
    """Unique ID of the Agent."""

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """Unique UUID of the Agent."""

    data_collector = sgqlc.types.Field(
        sgqlc.types.non_null("DataCollector"), graphql_name="dataCollector"
    )
    """Data Collector the Agent is registered to."""

    endpoint = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="endpoint")
    """The address of the Agent; bucket name, IP address, URL, etc."""

    platform = sgqlc.types.Field(AgentModelPlatform, graphql_name="platform")
    """The cloud platform the Agent is deployed in."""

    agent_type = sgqlc.types.Field(
        sgqlc.types.non_null(AgentModelAgentType), graphql_name="agentType"
    )
    """Type of Agent deployed."""

    wrapper_type = sgqlc.types.Field(AgentModelWrapperType, graphql_name="wrapperType")
    """Type of MC provided wrapper, if any."""

    auth_type = sgqlc.types.Field(sgqlc.types.non_null(AgentModelAuthType), graphql_name="authType")
    """The authorization type used to connect to this Agent."""

    storage_type = sgqlc.types.Field(
        sgqlc.types.non_null(AgentModelStorageType), graphql_name="storageType"
    )
    """Type of data store used by this Agent."""

    credentials_s3_key = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="credentialsS3Key"
    )
    """Key to the credentials vault. Used to look up the agent
    credentials.
    """

    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdTime")
    """Timestamp of when agent was registered."""

    last_updated_time = sgqlc.types.Field(DateTime, graphql_name="lastUpdatedTime")
    """Timestamp of the last image version update."""

    wrapper_version = sgqlc.types.Field(String, graphql_name="wrapperVersion")
    """If using an MC wrapper, the version number"""

    image_build = sgqlc.types.Field(String, graphql_name="imageBuild")
    """Build number of agent image. Null if agent_type is
    DATA_STORE_AGENT
    """

    image_version = sgqlc.types.Field(String, graphql_name="imageVersion")
    """Docker image version of the agent. Null if agent_type is
    DATA_STORE_AGENT
    """

    is_remote_upgradeable = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="isRemoteUpgradeable"
    )
    """True if Monte Carlo has access to update the image version of the
    remote agent.
    """

    is_deleted = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isDeleted")
    """If the Agent is deregistered from the DC, this field will be
    'true', allowing the customer to register a different Agent with
    the data collector.
    """


class AgentLogEntry(sgqlc.types.Type):
    """A log entry from an agent."""

    __schema__ = schema
    __field_names__ = ("timestamp", "payload")
    timestamp = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="timestamp")
    """Timestamp for the log entry."""

    payload = sgqlc.types.Field(GenericScalar, graphql_name="payload")
    """The JSON payload in the log entry. If the entry is a text message,
    then a dictionary with a single 'message' attribute is returned.
    """


class AgentMetadata(sgqlc.types.Type):
    """Metadata about AI agents for agent observability."""

    __schema__ = schema
    __field_names__ = ("account_uuid", "agent_name", "trace_table_mcon")
    account_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="accountUuid")
    """Account UUID"""

    agent_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="agentName")
    """Name of the agent"""

    trace_table_mcon = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="traceTableMcon"
    )
    """MCON of the trace table associated with this agent"""


class AgentSpanFieldFilter(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("value",)
    value = sgqlc.types.Field(String, graphql_name="value")


class AgentSpanFilter(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("agent", "workflow", "task", "span_name")
    agent = sgqlc.types.Field(AgentSpanFieldFilter, graphql_name="agent")

    workflow = sgqlc.types.Field(AgentSpanFieldFilter, graphql_name="workflow")

    task = sgqlc.types.Field(AgentSpanFieldFilter, graphql_name="task")

    span_name = sgqlc.types.Field(AgentSpanFieldFilter, graphql_name="spanName")


class AgentSpanNode(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("node_name", "node_value", "child_nodes", "level", "count", "is_leaf")
    node_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="nodeName")

    node_value = sgqlc.types.Field(String, graphql_name="nodeValue")

    child_nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("AgentSpanNode"))),
        graphql_name="childNodes",
    )

    level = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="level")

    count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="count")

    is_leaf = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isLeaf")


class AgentSpanTree(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("nodes", "query")
    nodes = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(AgentSpanNode))),
        graphql_name="nodes",
    )

    query = sgqlc.types.Field(String, graphql_name="query")


class AgentTraceTableConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AgentTraceTableEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class AgentTraceTableEdge(sgqlc.types.Type):
    """A Relay edge containing a `AgentTraceTable` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("AgentTraceTable", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AggregatedMetricDataType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("query_group", "metric_aggregation", "timestamp", "value")
    query_group = sgqlc.types.Field(String, graphql_name="queryGroup")
    """Query group identifier"""

    metric_aggregation = sgqlc.types.Field(
        "MetricAggregationOutputType", graphql_name="metricAggregation"
    )
    """Metric aggregation"""

    timestamp = sgqlc.types.Field(DateTime, graphql_name="timestamp")
    """Aggregated data timestamp"""

    value = sgqlc.types.Field(Float, graphql_name="value")
    """Aggregated data value"""


class AggregatedQuery(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "date",
        "group_id",
        "query_hash",
        "user",
        "category",
        "latest_query",
        "latest_query_id",
        "latest_query_timestamp",
        "count",
        "average_run_time",
    )
    date = sgqlc.types.Field(Date, graphql_name="date")
    """Date the queries occurred on"""

    group_id = sgqlc.types.Field(String, graphql_name="groupId")
    """Hash that is shared by all the aggregated queries for writes"""

    query_hash = sgqlc.types.Field(String, graphql_name="queryHash")
    """Hash that is shared by all the aggregated queries for reads"""

    user = sgqlc.types.Field(String, graphql_name="user")
    """User of the aggregated queries"""

    category = sgqlc.types.Field(QueryCategory, graphql_name="category")
    """Category of the aggregated queries"""

    latest_query = sgqlc.types.Field(String, graphql_name="latestQuery")
    """Substring of the latest query from the aggregated group containing
    the first n characters defined by the query_characters parameter
    in the request
    """

    latest_query_id = sgqlc.types.Field(String, graphql_name="latestQueryId")
    """ID of the latest query"""

    latest_query_timestamp = sgqlc.types.Field(DateTime, graphql_name="latestQueryTimestamp")
    """Timestamp of the latest query"""

    count = sgqlc.types.Field(Int, graphql_name="count")
    """Count of the number of queries aggregated"""

    average_run_time = sgqlc.types.Field(Int, graphql_name="averageRunTime")
    """Average run time of the aggregated queries in milliseconds"""


class AggregatedQueryResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("aggregated_queries", "page_info")
    aggregated_queries = sgqlc.types.Field(
        sgqlc.types.list_of(AggregatedQuery), graphql_name="aggregatedQueries"
    )
    """List of aggregated queries which are grouped based on their group
    ID
    """

    page_info = sgqlc.types.Field("NextPageInfo", graphql_name="pageInfo")
    """Data necessary to paginate aggregated queries"""


class AiAgent(sgqlc.types.Type):
    """AI Agent configuration for an account."""

    __schema__ = schema
    __field_names__ = ("created_time", "updated_time", "agent_type", "context_prompt")
    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdTime")

    updated_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedTime")

    agent_type = sgqlc.types.Field(sgqlc.types.non_null(AiAgentType), graphql_name="agentType")

    context_prompt = sgqlc.types.Field(String, graphql_name="contextPrompt")
    """Custom context prompt for the AI agent"""


class AirflowCapabilitiesResponse(sgqlc.types.Type):
    """Airflow capabilities information"""

    __schema__ = schema
    __field_names__ = ("has_connection", "has_callbacks")
    has_connection = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="hasConnection")
    """True if the account has a connection set up"""

    has_callbacks = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="hasCallbacks")
    """True if the account has callbacks set up"""


class AirflowDagConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AirflowDagEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class AirflowDagEdge(sgqlc.types.Type):
    """A Relay edge containing a `AirflowDag` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("AirflowDag", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AirflowDagRunConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AirflowDagRunEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class AirflowDagRunEdge(sgqlc.types.Type):
    """A Relay edge containing a `AirflowDagRun` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("AirflowDagRun", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AirflowDagRunInfo(sgqlc.types.Type):
    """Airflow DAG Run information"""

    __schema__ = schema
    __field_names__ = ("run_id", "start_date", "end_date", "success", "duration", "error", "state")
    run_id = sgqlc.types.Field(String, graphql_name="runId")
    """Run ID"""

    start_date = sgqlc.types.Field(DateTime, graphql_name="startDate")
    """Start date"""

    end_date = sgqlc.types.Field(DateTime, graphql_name="endDate")
    """End date"""

    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """Run was completed successfully"""

    duration = sgqlc.types.Field(Float, graphql_name="duration")
    """Run duration in seconds"""

    error = sgqlc.types.Field(String, graphql_name="error")
    """Error message in case of failure"""

    state = sgqlc.types.Field(sgqlc.types.non_null(AirflowRunState), graphql_name="state")
    """Current state of the run"""


class AirflowTaskConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AirflowTaskEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class AirflowTaskEdge(sgqlc.types.Type):
    """A Relay edge containing a `AirflowTask` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("AirflowTask", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AirflowTaskRunAttempt(sgqlc.types.Type):
    """Individual attempt details for an Airflow task run"""

    __schema__ = schema
    __field_names__ = (
        "attempt_number",
        "start_date",
        "end_date",
        "state",
        "success",
        "duration",
        "exception_message",
    )
    attempt_number = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="attemptNumber")
    """Attempt number"""

    start_date = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="startDate")
    """Attempt start time"""

    end_date = sgqlc.types.Field(DateTime, graphql_name="endDate")
    """Attempt end time"""

    state = sgqlc.types.Field(sgqlc.types.non_null(AirflowRunState), graphql_name="state")
    """Attempt state"""

    success = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="success")
    """Whether attempt succeeded"""

    duration = sgqlc.types.Field(Float, graphql_name="duration")
    """Attempt duration in seconds"""

    exception_message = sgqlc.types.Field(String, graphql_name="exceptionMessage")
    """Error message if failed"""


class AirflowTaskRunConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AirflowTaskRunEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class AirflowTaskRunEdge(sgqlc.types.Type):
    """A Relay edge containing a `AirflowTaskRun` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("AirflowTaskRun", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AirflowTaskRunStats(sgqlc.types.Type):
    """Airflow Task Run statistics"""

    __schema__ = schema
    __field_names__ = (
        "num_run_success",
        "num_run_failure",
        "num_run_running",
        "avg_duration",
        "last_run",
        "task_id",
        "dag_id",
        "resource__name",
        "task_mcon",
        "job_mcon",
        "urls",
    )
    num_run_success = sgqlc.types.Field(Int, graphql_name="numRunSuccess")
    """Number of successful tasks"""

    num_run_failure = sgqlc.types.Field(Int, graphql_name="numRunFailure")
    """Number of failed tasks"""

    num_run_running = sgqlc.types.Field(Int, graphql_name="numRunRunning")
    """Number of running tasks"""

    avg_duration = sgqlc.types.Field(Float, graphql_name="avgDuration")
    """Average duration of tasks"""

    last_run = sgqlc.types.Field(DateTime, graphql_name="lastRun")
    """Last run timestamp of tasks"""

    task_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="taskId")
    """Task ID of Airflow task"""

    dag_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="dagId")
    """DAG ID of Airflow DAG"""

    resource__name = sgqlc.types.Field(String, graphql_name="resource_Name")
    """Resource name of Airflow connection"""

    task_mcon = sgqlc.types.Field(String, graphql_name="taskMcon")
    """MCON of Task for provided task_id"""

    job_mcon = sgqlc.types.Field(String, graphql_name="jobMcon")
    """MCON of Job for provided job_id"""

    urls = sgqlc.types.Field("AirflowUrls", graphql_name="urls")
    """URLs to Airflow UI"""


class AirflowTaskRunStatsConnection(sgqlc.types.relay.Connection):
    """Airflow Task Run statistics response"""

    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AirflowTaskRunStatsEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class AirflowTaskRunStatsEdge(sgqlc.types.Type):
    """A Relay edge containing a `AirflowTaskRunStats` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field(AirflowTaskRunStats, graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AirflowUrls(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("dag", "dag_run", "task_run")
    dag = sgqlc.types.Field(String, graphql_name="dag")
    """URL to Airflow UI for the DAG"""

    dag_run = sgqlc.types.Field(String, graphql_name="dagRun")
    """URL to Airflow UI for the DAG run"""

    task_run = sgqlc.types.Field(String, graphql_name="taskRun")
    """URL to Airflow UI for the task run"""


class AlationIntegrationConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AlationIntegrationEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class AlationIntegrationEdge(sgqlc.types.Type):
    """A Relay edge containing a `AlationIntegration` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("AlationIntegration", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AlertAccessRequest(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "user_id",
        "alert_id",
        "status",
        "created_time",
        "updated_time",
        "notified_admins",
    )
    id = sgqlc.types.Field(Int, graphql_name="id")
    """Unique identifier for the access request"""

    user_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="userId")
    """User who requested access"""

    alert_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="alertId")
    """Alert ID access was requested for"""

    status = sgqlc.types.Field(AlertAccessRequestStatus, graphql_name="status")
    """Current status of the access request"""

    created_time = sgqlc.types.Field(DateTime, graphql_name="createdTime")
    """When the request was created"""

    updated_time = sgqlc.types.Field(DateTime, graphql_name="updatedTime")
    """When the request was last updated"""

    notified_admins = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="notifiedAdmins")
    """List of admin emails that were notified about this request"""


class AlertAccessRequestOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success", "access_request")
    success = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="success")
    """Whether the operation was successful"""

    access_request = sgqlc.types.Field(AlertAccessRequest, graphql_name="accessRequest")
    """The access request object"""


class AlertConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges", "total_count")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AlertEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""

    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")


class AlertDescriptionOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("description",)
    description = sgqlc.types.Field(String, graphql_name="description")


class AlertEdge(sgqlc.types.Type):
    """A Relay edge containing a `Alert` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("Alert", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AlertRcaData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("primary_rca", "event_rcas", "alert_rcas")
    primary_rca = sgqlc.types.Field("PrimaryRcaData", graphql_name="primaryRca")

    event_rcas = sgqlc.types.Field(sgqlc.types.list_of("EventRcaData"), graphql_name="eventRcas")

    alert_rcas = sgqlc.types.Field(
        sgqlc.types.list_of("AlertScopedRcaData"), graphql_name="alertRcas"
    )


class AlertReaction(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("type", "reasons", "notes")
    type = sgqlc.types.Field(sgqlc.types.non_null(AlertReactionType), graphql_name="type")

    reasons = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(AlertReactionReason))),
        graphql_name="reasons",
    )

    notes = sgqlc.types.Field(String, graphql_name="notes")


class AlertTimePeriodAggregateData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("start_date", "end_date", "values")
    start_date = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name="startDate")
    """The start date for the aggregated data"""

    end_date = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name="endDate")
    """The end date for the aggregated data"""

    values = sgqlc.types.Field(sgqlc.types.list_of("LabelCount"), graphql_name="values")
    """The aggregate label and count for the time time period"""


class AlertTypeSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "anomalies",
        "schema_changes",
        "json_schema_changes",
        "deleted_tables",
        "metric_anomalies",
        "agent_anomalies",
        "metric_comparison_anomalies",
        "custom_rule_anomalies",
        "performance_anomalies",
        "dbt_errors",
        "etl_errors",
        "pseudo_integration_test",
        "rule_run_execution_error",
        "merged",
    )
    anomalies = sgqlc.types.Field(Int, graphql_name="anomalies")

    schema_changes = sgqlc.types.Field(Int, graphql_name="schemaChanges")

    json_schema_changes = sgqlc.types.Field(Int, graphql_name="jsonSchemaChanges")

    deleted_tables = sgqlc.types.Field(Int, graphql_name="deletedTables")

    metric_anomalies = sgqlc.types.Field(Int, graphql_name="metricAnomalies")

    agent_anomalies = sgqlc.types.Field(Int, graphql_name="agentAnomalies")

    metric_comparison_anomalies = sgqlc.types.Field(Int, graphql_name="metricComparisonAnomalies")

    custom_rule_anomalies = sgqlc.types.Field(Int, graphql_name="customRuleAnomalies")

    performance_anomalies = sgqlc.types.Field(Int, graphql_name="performanceAnomalies")

    dbt_errors = sgqlc.types.Field(Int, graphql_name="dbtErrors")

    etl_errors = sgqlc.types.Field(Int, graphql_name="etlErrors")

    pseudo_integration_test = sgqlc.types.Field(Int, graphql_name="pseudoIntegrationTest")

    rule_run_execution_error = sgqlc.types.Field(Int, graphql_name="ruleRunExecutionError")

    merged = sgqlc.types.Field(Int, graphql_name="merged")


class AlertWeeklyDataDashboard(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("weekly_data",)
    weekly_data = sgqlc.types.Field(
        sgqlc.types.list_of(AlertTimePeriodAggregateData), graphql_name="weeklyData"
    )
    """The weekly alert data"""


class AlertsCountByDate(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("date", "count")
    date = sgqlc.types.Field(Date, graphql_name="date")
    """Alert updated date"""

    count = sgqlc.types.Field(Int, graphql_name="count")
    """Count of alerts on the date"""


class AlertsCountByDateConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AlertsCountByDateEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class AlertsCountByDateEdge(sgqlc.types.Type):
    """A Relay edge containing a `AlertsCountByDate` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field(AlertsCountByDate, graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AlertsFilter(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "field_name",
        "display_name",
        "query_parameter_name",
        "query_parameter_accepts_multiple_values",
        "facetable",
        "facet_searchable",
    )
    field_name = sgqlc.types.Field(
        sgqlc.types.non_null(AlertsFilterFieldName), graphql_name="fieldName"
    )

    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")

    query_parameter_name = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="queryParameterName"
    )
    """Associated getAlerts parameter used to filter alerts"""

    query_parameter_accepts_multiple_values = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="queryParameterAcceptsMultipleValues"
    )
    """Whether the associated getAlerts parameter accepts multiple values
    as input
    """

    facetable = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="facetable")
    """Whether the filter shows up as a facet on the alert feed page"""

    facet_searchable = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="facetSearchable"
    )
    """Whether the filter values can be searched by their display name"""


class AlertsFilterData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("field_name", "values", "page_info")
    field_name = sgqlc.types.Field(AlertsFilterFieldName, graphql_name="fieldName")

    values = sgqlc.types.Field(sgqlc.types.list_of("AlertsFilterDataValue"), graphql_name="values")
    """List of possible values to filter alerts by"""

    page_info = sgqlc.types.Field("NextPageInfo", graphql_name="pageInfo")
    """Data for paginating values"""


class AlertsFilterDataValue(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("value", "display_name", "count", "child_values", "query_parameter_name")
    value = sgqlc.types.Field(GenericScalar, graphql_name="value")

    display_name = sgqlc.types.Field(String, graphql_name="displayName")

    count = sgqlc.types.Field(Int, graphql_name="count")

    child_values = sgqlc.types.Field(
        sgqlc.types.list_of("AlertsFilterDataValue"), graphql_name="childValues"
    )

    query_parameter_name = sgqlc.types.Field(String, graphql_name="queryParameterName")
    """If this has a value, it should override the value from
    AlertsFilter
    """


class ApiUsageLimits(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("total_requests_per_day", "requests_per_second", "burst_limit")
    total_requests_per_day = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="totalRequestsPerDay"
    )

    requests_per_second = sgqlc.types.Field(
        sgqlc.types.non_null(Float), graphql_name="requestsPerSecond"
    )

    burst_limit = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="burstLimit")


class ApiUsageResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("limits", "usage")
    limits = sgqlc.types.Field(sgqlc.types.non_null(ApiUsageLimits), graphql_name="limits")

    usage = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("DailyUsage"))),
        graphql_name="usage",
    )


class AssetCollectionPreferencesConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AssetCollectionPreferencesEdge")),
        graphql_name="edges",
    )
    """Contains the nodes in this connection."""


class AssetCollectionPreferencesEdge(sgqlc.types.Type):
    """A Relay edge containing a `AssetCollectionPreferences` and its
    cursor.
    """

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("AssetCollectionPreferences", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AssetCollectionRule(sgqlc.types.Type):
    """Asset collection rule."""

    __schema__ = schema
    __field_names__ = ("conditions", "effect")
    conditions = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AssetCollectionRuleCondition")),
        graphql_name="conditions",
    )
    """The set of conditions that need to match in order for this rule to
    apply
    """

    effect = sgqlc.types.Field(
        sgqlc.types.non_null(AssetCollectionRuleEffect), graphql_name="effect"
    )
    """Whether to allow or block the asset when this rule matches."""


class AssetCollectionRuleCondition(sgqlc.types.Type):
    """Asset collection rule condition."""

    __schema__ = schema
    __field_names__ = ("attribute_name", "value", "comparison_type")
    attribute_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="attributeName")
    """The name of the attribute to match"""

    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")
    """The value (or pattern) to compare the attribute against"""

    comparison_type = sgqlc.types.Field(
        CollectionPreferenceMatchType, graphql_name="comparisonType"
    )
    """The method for comparing the attribute to the given value"""


class AssetIncludeDatabase(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("name", "schemas")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")

    schemas = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="schemas"
    )


class AssetSelection(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("databases", "filters", "exclusions")
    databases = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(AssetIncludeDatabase))),
        graphql_name="databases",
    )

    filters = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(AssetFilterInterface))),
        graphql_name="filters",
    )

    exclusions = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(AssetFilterInterface))),
        graphql_name="exclusions",
    )


class AssetSelectionResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "name",
        "id",
        "type",
        "count",
        "count_unselected",
        "count_database_schema",
        "selected",
        "mcon",
    )
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")

    id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="id")

    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="type")

    count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="count")

    count_unselected = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="countUnselected")

    count_database_schema = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="countDatabaseSchema"
    )

    selected = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="selected")

    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")


class AssetUsageNode(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "mcon_id",
        "display_name",
        "path",
        "schema_count_is_ingested",
        "schema_count_is_not_ingested",
        "table_count",
        "table_count_is_ingested",
        "table_count_is_not_ingested",
        "table_count_is_monitored",
        "table_count_is_not_monitored",
        "is_excluded",
        "is_monitored",
        "importance_score",
        "last_activity",
        "last_read",
        "last_write",
        "last_volume_change",
        "object_properties",
        "table_type",
    )
    mcon_id = sgqlc.types.Field(String, graphql_name="mconId")
    """MCON of the object represented by this node."""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """User-friendly display name of the catalog object."""

    path = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="path")
    """Object's hierarchy as list of ancestors plus self, if applicable."""

    schema_count_is_ingested = sgqlc.types.Field(Int, graphql_name="schemaCountIsIngested")
    """The number of schemas associated with this node that are ingested."""

    schema_count_is_not_ingested = sgqlc.types.Field(Int, graphql_name="schemaCountIsNotIngested")
    """The number of schemas associated with this node that are not
    ingested.
    """

    table_count = sgqlc.types.Field(Int, graphql_name="tableCount")
    """The number of tables associated with this node."""

    table_count_is_ingested = sgqlc.types.Field(Int, graphql_name="tableCountIsIngested")
    """The number of tables associated with this node that are ingested."""

    table_count_is_not_ingested = sgqlc.types.Field(Int, graphql_name="tableCountIsNotIngested")
    """The number of tables associated with this node that are not
    ingested.
    """

    table_count_is_monitored = sgqlc.types.Field(Int, graphql_name="tableCountIsMonitored")
    """The number of tables associated with this node that are monitored."""

    table_count_is_not_monitored = sgqlc.types.Field(Int, graphql_name="tableCountIsNotMonitored")
    """The number of tables associated with this node that are not
    monitored.
    """

    is_excluded = sgqlc.types.Field(Boolean, graphql_name="isExcluded")
    """Whether or not a table node is excluded from ingestion control.
    When it is True, it means that the table is excluded for
    ingestion.
    """

    is_monitored = sgqlc.types.Field(Boolean, graphql_name="isMonitored")
    """Whether or not a table node is monitored. When it is False, it
    means that the table is not monitored.
    """

    importance_score = sgqlc.types.Field(Float, graphql_name="importanceScore")
    """The importance score of the table."""

    last_activity = sgqlc.types.Field(DateTime, graphql_name="lastActivity")
    """The last activity date of the table. When was the last time the
    table was read or written.
    """

    last_read = sgqlc.types.Field(DateTime, graphql_name="lastRead")
    """The last read date of the table. When was the last time the table
    was read from.
    """

    last_write = sgqlc.types.Field(DateTime, graphql_name="lastWrite")
    """The last write date of the table. When was the last time the table
    was written to .
    """

    last_volume_change = sgqlc.types.Field(DateTime, graphql_name="lastVolumeChange")
    """The last time a significant write was executed on the table"""

    object_properties = sgqlc.types.Field(
        sgqlc.types.list_of("PartialObjectProperty"), graphql_name="objectProperties"
    )
    """Properties of the table (like tags)."""

    table_type = sgqlc.types.Field(String, graphql_name="tableType")
    """The type of the table."""


class AssetsUsageResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "nodes",
        "has_next_page",
        "next_page_offset",
        "group_object_type",
        "total_count",
    )
    nodes = sgqlc.types.Field(sgqlc.types.list_of(AssetUsageNode), graphql_name="nodes")
    """Nodes for current page."""

    has_next_page = sgqlc.types.Field(Boolean, graphql_name="hasNextPage")
    """If there are more nodes."""

    next_page_offset = sgqlc.types.Field(Int, graphql_name="nextPageOffset")
    """Where to start for next page, if next page exists."""

    group_object_type = sgqlc.types.Field(String, graphql_name="groupObjectType")
    """Object type of the group, when grouping by type."""

    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")
    """Total number of nodes."""


class AssignmentWithProperties(sgqlc.types.Type):
    """Domain Assignment configuration"""

    __schema__ = schema
    __field_names__ = (
        "mcon",
        "display_name",
        "resource_type",
        "resource_uuid",
        "resource_name",
        "object_type",
    )
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """MCON of the object assigned to a domain"""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """Display name of the object assigned to a domain"""

    resource_type = sgqlc.types.Field(String, graphql_name="resourceType")
    """Resource type of the object assigned to a domain"""

    resource_uuid = sgqlc.types.Field(UUID, graphql_name="resourceUuid")
    """Resource uuid of the object assigned to a domain"""

    resource_name = sgqlc.types.Field(String, graphql_name="resourceName")
    """Resource name of the object assigned to a domain"""

    object_type = sgqlc.types.Field(String, graphql_name="objectType")
    """Type of object assigned to a domain"""


class Audience(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid", "label")
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")

    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="label")


class AudienceMonitorConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AudienceMonitorEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class AudienceMonitorEdge(sgqlc.types.Type):
    """A Relay edge containing a `AudienceMonitor` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("AudienceMonitor", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AudienceRef(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid", "label")
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """Audience UUID"""

    label = sgqlc.types.Field(String, graphql_name="label")
    """Audience label"""


class AudienceRoutingStats(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "audience_uuid",
        "audience_label",
        "mcons_covered_by_table_monitors",
        "mcons_covered_by_notification_routing",
        "sample_mcons_routing_not_table_monitor",
    )
    audience_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="audienceUuid")

    audience_label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="audienceLabel")

    mcons_covered_by_table_monitors = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="mconsCoveredByTableMonitors"
    )

    mcons_covered_by_notification_routing = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="mconsCoveredByNotificationRouting"
    )

    sample_mcons_routing_not_table_monitor = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MconMonitorPair"))),
        graphql_name="sampleMconsRoutingNotTableMonitor",
    )


class AuditLogEntryConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AuditLogEntryEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class AuditLogEntryEdge(sgqlc.types.Type):
    """A Relay edge containing a `AuditLogEntry` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("AuditLogEntry", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class AuthorRef(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("name", "username", "email")
    name = sgqlc.types.Field(String, graphql_name="name")

    username = sgqlc.types.Field(String, graphql_name="username")

    email = sgqlc.types.Field(String, graphql_name="email")


class AuthorizationGroupOutput(sgqlc.types.Type):
    """Authorization group used to configure access and permissions for
    users.
    """

    __schema__ = schema
    __field_names__ = (
        "name",
        "roles",
        "version",
        "is_managed",
        "label",
        "description",
        "users",
        "domain_restrictions",
        "connection_restrictions",
        "sso_group",
        "source",
        "is_membership_managed",
    )
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Unique to the account, human-readable name (for use in code/policy
    reference).
    """

    roles = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("RoleOutput")), graphql_name="roles"
    )
    """List of roles that are assigned to this group."""

    version = sgqlc.types.Field(String, graphql_name="version")
    """Version of the permissions definitions the group is designed for,
    ex: 2022-03-17. Defaults to current.
    """

    is_managed = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isManaged")
    """Indicates if this group is managed by Monte Carlo or through an
    authorization provider, such as SCIM. If so, changes to the group
    are restricted. See the source for details.
    """

    label = sgqlc.types.Field(String, graphql_name="label")
    """UI/user-friendly display name, ex: Data Consumers"""

    description = sgqlc.types.Field(String, graphql_name="description")
    """Description/help text to help users understand the purpose of the
    group
    """

    users = sgqlc.types.Field(sgqlc.types.list_of("AuthUser"), graphql_name="users")
    """List of users  who are members of the group."""

    domain_restrictions = sgqlc.types.Field(
        sgqlc.types.list_of("DomainRestriction"), graphql_name="domainRestrictions"
    )
    """List of domains this group is limited to."""

    connection_restrictions = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("ConnectionRestriction"))),
        graphql_name="connectionRestrictions",
    )
    """List of connections this group is limited to."""

    sso_group = sgqlc.types.Field(String, graphql_name="ssoGroup")
    """SSO group name to map this authorization group to"""

    source = sgqlc.types.Field(
        sgqlc.types.non_null(AuthorizationGroupSource), graphql_name="source"
    )
    """The source or provider of this authorization group."""

    is_membership_managed = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="isMembershipManaged"
    )
    """Indicates if the membership of this group is managed through an
    authorization provider or SSO group. If true, membership changes
    can only be made through that source.
    """


class AuthorizationProvisioningOutput(sgqlc.types.Type):
    """Authorization Provisioning configuration, used for provisioning
    users and groups.
    """

    __schema__ = schema
    __field_names__ = (
        "uuid",
        "enabled",
        "provider_name",
        "default_domains",
        "default_roles",
        "base_endpoint",
        "last_updated_on",
        "last_update_user",
        "created_by",
        "created_on",
        "schema",
        "audit_logs",
    )
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """UUID of the auth provisioning model."""

    enabled = sgqlc.types.Field(Boolean, graphql_name="enabled")
    """Is this Authorization Provisioning configuration enabled."""

    provider_name = sgqlc.types.Field(String, graphql_name="providerName")
    """Short text to describe the provider."""

    default_domains = sgqlc.types.Field(
        sgqlc.types.list_of("DomainRestriction"), graphql_name="defaultDomains"
    )
    """List of default domains for auth groups created by this
    configuration.
    """

    default_roles = sgqlc.types.Field(
        sgqlc.types.list_of("RoleOutput"), graphql_name="defaultRoles"
    )
    """List of default roles that are assigned to auth groups created by
    this configuration.
    """

    base_endpoint = sgqlc.types.Field(String, graphql_name="baseEndpoint")
    """Base endpoint used by this auth provisioning."""

    last_updated_on = sgqlc.types.Field(DateTime, graphql_name="lastUpdatedOn")
    """Timestamp when this configuration was last modified."""

    last_update_user = sgqlc.types.Field("AuthUser", graphql_name="lastUpdateUser")
    """User that last updated this configuration."""

    created_by = sgqlc.types.Field("AuthUser", graphql_name="createdBy")
    """User that created this configuration."""

    created_on = sgqlc.types.Field(DateTime, graphql_name="createdOn")
    """Timestamp when this configuration was created."""

    schema = sgqlc.types.Field(String, graphql_name="schema")
    """Schema version for this auth provisioning configuration."""

    audit_logs = sgqlc.types.Field(
        AuditLogEntryConnection,
        graphql_name="auditLogs",
        args=sgqlc.types.ArgDict(
            (
                ("start_time", sgqlc.types.Arg(DateTime, graphql_name="startTime", default=None)),
                ("end_time", sgqlc.types.Arg(DateTime, graphql_name="endTime", default=None)),
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                (
                    "timestamp__lt",
                    sgqlc.types.Arg(DateTime, graphql_name="timestamp_Lt", default=None),
                ),
            )
        ),
    )
    """Get usage audit logs

    Arguments:

    * `start_time` (`DateTime`): Start time to fetch audit logs.
      Defaults to current time - 30 days
    * `end_time` (`DateTime`): End time for fetching audit logs.
      Defaults to current time.
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `timestamp__lt` (`DateTime`)None
    """


class AvailableFilter(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("filter_name", "values")
    filter_name = sgqlc.types.Field(PullRequestFilterName, graphql_name="filterName")
    """Name of the filter"""

    values = sgqlc.types.Field(
        sgqlc.types.list_of("AvailableFilterAggregatedValue"), graphql_name="values"
    )
    """Values and counts of the filter"""


class AvailableFilterAggregatedValue(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("value", "count")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")
    """Value of the filter"""

    count = sgqlc.types.Field(Int, graphql_name="count")
    """Count of the filter value"""


class AwsAgentInfraDetailsResult(sgqlc.types.Type):
    """Infrastructure information for an AWS Agent."""

    __schema__ = schema
    __field_names__ = ("template", "parameters")
    template = sgqlc.types.Field(sgqlc.types.non_null(GenericScalar), graphql_name="template")
    """The CloudFormation template, in YAML format"""

    parameters = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(GenericScalar)), graphql_name="parameters"
    )
    """The current template parameters."""


class AwsAgentLogsQueryResult(sgqlc.types.Type):
    """The result for a CloudWatch query, includes events and status."""

    __schema__ = schema
    __field_names__ = ("status", "events")
    status = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="status")
    """The status of the query, for example Running or Complete"""

    events = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(GenericScalar)), graphql_name="events"
    )
    """The log events."""


class AwsAgentLogsStopQueryResult(sgqlc.types.Type):
    """The result for stop_query."""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="success")
    """Indicates if the query was successfully stopped"""


class AwsAgentStartLogsQueryResult(sgqlc.types.Type):
    """The result for start_query including the query ID."""

    __schema__ = schema
    __field_names__ = ("query_id",)
    query_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="queryId")
    """The ID for the started query"""


class AwsAgentUpgradeLogEntry(sgqlc.types.Type):
    """An upgrade log entry from an AWS agent."""

    __schema__ = schema
    __field_names__ = (
        "timestamp",
        "logical_resource_id",
        "resource_status",
        "resource_status_reason",
        "resource_type",
    )
    timestamp = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="timestamp")
    """Timestamp for the log entry."""

    logical_resource_id = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="logicalResourceId"
    )
    """Resource ID."""

    resource_status = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="resourceStatus")
    """Resource status, for example: 'UPDATE_COMPLETE'."""

    resource_status_reason = sgqlc.types.Field(String, graphql_name="resourceStatusReason")
    """Reason for the status, for example: 'User Initiated'."""

    resource_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="resourceType")
    """Resource type, for example: 'AWS::Lambda::Function'."""


class AwsInformation(sgqlc.types.Type):
    """AWS information"""

    __schema__ = schema
    __field_names__ = (
        "account_id",
        "region",
        "secondary_region",
        "is_secondary",
        "env_configuration",
    )
    account_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="accountId")
    """AWS Account ID"""

    region = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="region")
    """AWS Region"""

    secondary_region = sgqlc.types.Field(String, graphql_name="secondaryRegion")
    """AWS Secondary Region"""

    is_secondary = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isSecondary")
    """Is this the Secondary Region?"""

    env_configuration = sgqlc.types.Field(
        sgqlc.types.non_null(AwsEnvConfiguration), graphql_name="envConfiguration"
    )
    """Active AWS Environment Configuration"""


class AwsPrivateLinkDetails(sgqlc.types.Type):
    """AWS Private Link information"""

    __schema__ = schema
    __field_names__ = ("account_id", "mcd_principal", "regions")
    account_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="accountId")
    """AWS Account ID"""

    mcd_principal = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcdPrincipal")
    """MCD Principal"""

    regions = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AwsPrivateLinkRegionDetails")),
        graphql_name="regions",
    )
    """List of AWS Private Link regions"""


class AwsPrivateLinkRegionDetails(sgqlc.types.Type):
    """AWS Private Link region information"""

    __schema__ = schema
    __field_names__ = (
        "region",
        "connection_vpc_id",
        "data_store_vpc_endpoint_id",
        "agent_vpc_endpoint_id",
    )
    region = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="region")
    """AWS Region"""

    connection_vpc_id = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="connectionVpcId"
    )
    """Connection VPC ID"""

    data_store_vpc_endpoint_id = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="dataStoreVpcEndpointId"
    )
    """Data Store VPC Endpoint ID"""

    agent_vpc_endpoint_id = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="agentVpcEndpointId"
    )
    """Agent VPC Endpoint ID"""


class AzureAgentCleanupTasks(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("deleted_instances",)
    deleted_instances = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="deletedInstances"
    )
    """Number of deleted tasks"""


class AzureAgentTasksSummary(sgqlc.types.Type):
    """Durable Functions tasks information for an Azure Agent."""

    __schema__ = schema
    __field_names__ = ("pending_instances", "completed_instances")
    pending_instances = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="pendingInstances"
    )
    """Number of pending tasks."""

    completed_instances = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="completedInstances"
    )
    """Number of completed tasks"""


class AzureDevOpsIntegrationOutput(sgqlc.types.Type):
    """Output type for Azure DevOps integration."""

    __schema__ = schema
    __field_names__ = (
        "integration_id",
        "integration_name",
        "organization",
        "created_time",
        "updated_time",
        "created_by",
        "last_update_user",
    )
    integration_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="integrationId")
    """The integration ID"""

    integration_name = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="integrationName"
    )
    """A short name to identify the integration"""

    organization = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="organization")
    """Azure DevOps organization name"""

    created_time = sgqlc.types.Field(DateTime, graphql_name="createdTime")
    """When the integration was created"""

    updated_time = sgqlc.types.Field(DateTime, graphql_name="updatedTime")
    """When the integration was last updated"""

    created_by = sgqlc.types.Field("User", graphql_name="createdBy")
    """Who created the integration"""

    last_update_user = sgqlc.types.Field("User", graphql_name="lastUpdateUser")
    """Who last updated the integration"""


class AzureDevOpsProjectOutput(sgqlc.types.Type):
    """Output type for Azure DevOps project."""

    __schema__ = schema
    __field_names__ = ("id", "name", "description")
    id = sgqlc.types.Field(String, graphql_name="id")
    """Project ID"""

    name = sgqlc.types.Field(String, graphql_name="name")
    """Project name"""

    description = sgqlc.types.Field(String, graphql_name="description")
    """Project description"""


class AzureDevOpsWorkItemOutput(sgqlc.types.Type):
    """Output type for Azure DevOps work item operations."""

    __schema__ = schema
    __field_names__ = (
        "work_item_id",
        "alert_id",
        "integration_id",
        "work_item_url",
        "work_item_type",
        "project",
        "created_by_email",
        "created_at",
    )
    work_item_id = sgqlc.types.Field(String, graphql_name="workItemId")
    """Work item ID in Azure DevOps"""

    alert_id = sgqlc.types.Field(UUID, graphql_name="alertId")
    """Alert/incident UUID"""

    integration_id = sgqlc.types.Field(UUID, graphql_name="integrationId")
    """Integration UUID"""

    work_item_url = sgqlc.types.Field(String, graphql_name="workItemUrl")
    """URL to the work item in Azure DevOps"""

    work_item_type = sgqlc.types.Field(String, graphql_name="workItemType")
    """Type of work item (Bug, Task, User Story)"""

    project = sgqlc.types.Field(String, graphql_name="project")
    """Project name"""

    created_by_email = sgqlc.types.Field(String, graphql_name="createdByEmail")
    """Email of user who created the work item"""

    created_at = sgqlc.types.Field(DateTime, graphql_name="createdAt")
    """When the work item was created"""


class AzureDevOpsWorkItemTypeOutput(sgqlc.types.Type):
    """Output type for Azure DevOps work item type."""

    __schema__ = schema
    __field_names__ = ("name", "description")
    name = sgqlc.types.Field(String, graphql_name="name")
    """Work item type name (e.g., Bug, Task, User Story)"""

    description = sgqlc.types.Field(String, graphql_name="description")
    """Work item type description"""


class AzureDevopsBasicAuthCredentials(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("access_token",)
    access_token = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="accessToken")
    """Obfuscated access token"""


class AzureDevopsInstallation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "uuid",
        "organization_name",
        "installed_by",
        "basic_auth_credentials",
        "oauth_credentials",
        "display_name",
    )
    uuid = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="uuid")

    organization_name = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="organizationName"
    )
    """Azure DevOps organization name"""

    installed_by = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="installedBy")
    """Installed by user email"""

    basic_auth_credentials = sgqlc.types.Field(
        AzureDevopsBasicAuthCredentials, graphql_name="basicAuthCredentials"
    )

    oauth_credentials = sgqlc.types.Field(
        "AzureDevopsOauthCredentials", graphql_name="oauthCredentials"
    )

    display_name = sgqlc.types.Field(String, graphql_name="displayName")


class AzureDevopsInstallationListItem(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid", "organization_name", "installed_by", "display_name")
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """Internal Github installation uuid"""

    organization_name = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="organizationName"
    )
    """Azure DevOps organization name"""

    installed_by = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="installedBy")
    """Installed by user email"""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")


class AzureDevopsInstallations(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("installations",)
    installations = sgqlc.types.Field(
        sgqlc.types.list_of(AzureDevopsInstallationListItem), graphql_name="installations"
    )


class AzureDevopsOauthCredentials(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("tenant_id", "client_id", "client_secret")
    tenant_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="tenantId")

    client_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="clientId")

    client_secret = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="clientSecret")
    """Obfuscated client secret"""


class AzureDevopsOrganization(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("name", "projects", "repositories", "selections")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")

    projects = sgqlc.types.Field(sgqlc.types.list_of("AzureDevopsProject"), graphql_name="projects")

    repositories = sgqlc.types.Field(
        sgqlc.types.list_of("AzureDevopsRepository"), graphql_name="repositories"
    )

    selections = sgqlc.types.Field(
        sgqlc.types.list_of("AzureDevopsSourceSelection"), graphql_name="selections"
    )


class AzureDevopsProject(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "name", "repositories")
    id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="id")

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")

    repositories = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("AzureDevopsRepository")),
        graphql_name="repositories",
    )


class AzureDevopsRepository(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "name", "project")
    id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="id")

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")

    project = sgqlc.types.Field(sgqlc.types.non_null(AzureDevopsProject), graphql_name="project")


class AzureDevopsSourceSelection(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("project_id", "repository_id")
    project_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="projectId")

    repository_id = sgqlc.types.Field(String, graphql_name="repositoryId")


class AzureInformation(sgqlc.types.Type):
    """Azure information"""

    __schema__ = schema
    __field_names__ = ("subscription_id", "primary_region", "secondary_region")
    subscription_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="subscriptionId")
    """Azure Subscription ID"""

    primary_region = sgqlc.types.Field(String, graphql_name="primaryRegion")
    """Azure Region"""

    secondary_region = sgqlc.types.Field(String, graphql_name="secondaryRegion")
    """Azure Secondary Region"""


class BiContainer(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "created_time",
        "updated_time",
        "created_by",
        "last_update_user",
        "deleted_at",
        "account",
        "uuid",
        "data_collector",
        "type",
        "name",
        "connections",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdTime")

    updated_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedTime")

    created_by = sgqlc.types.Field("User", graphql_name="createdBy")
    """Creator"""

    last_update_user = sgqlc.types.Field("User", graphql_name="lastUpdateUser")
    """Last updated by"""

    deleted_at = sgqlc.types.Field(DateTime, graphql_name="deletedAt")

    account = sgqlc.types.Field(sgqlc.types.non_null(Account), graphql_name="account")

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")

    data_collector = sgqlc.types.Field("DataCollector", graphql_name="dataCollector")

    type = sgqlc.types.Field(sgqlc.types.non_null(BiContainerModelType), graphql_name="type")

    name = sgqlc.types.Field(String, graphql_name="name")

    connections = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Connection"))),
        graphql_name="connections",
    )


class BiLineage(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "workbook_id",
        "friendly_name",
        "content_url",
        "owner_id",
        "project_id",
        "project_name",
        "created",
        "updated",
        "total_views",
        "workbook_creators",
        "view_id",
        "category",
        "mcon",
        "name",
        "display_name",
    )
    workbook_id = sgqlc.types.Field(String, graphql_name="workbookId")

    friendly_name = sgqlc.types.Field(String, graphql_name="friendlyName")

    content_url = sgqlc.types.Field(String, graphql_name="contentUrl")

    owner_id = sgqlc.types.Field(String, graphql_name="ownerId")

    project_id = sgqlc.types.Field(String, graphql_name="projectId")

    project_name = sgqlc.types.Field(String, graphql_name="projectName")

    created = sgqlc.types.Field(DateTime, graphql_name="created")

    updated = sgqlc.types.Field(DateTime, graphql_name="updated")

    total_views = sgqlc.types.Field(Int, graphql_name="totalViews")

    workbook_creators = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="workbookCreators"
    )

    view_id = sgqlc.types.Field(String, graphql_name="viewId")

    category = sgqlc.types.Field(String, graphql_name="category")
    """Node type"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Monte Carlo object name"""

    name = sgqlc.types.Field(String, graphql_name="name")
    """Object name (table name, report name, etc)"""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """Friendly display name"""


class BiMetadata(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "owner",
        "site",
        "uri",
        "sheets",
        "embedded_datasources",
        "upstream_data_quality_warnings",
        "view_path",
        "workbook_id",
        "workbook_name",
        "view_id",
        "luid",
        "name",
        "is_certified",
        "has_extracts",
        "has_active_warning",
        "has_user_reference",
        "contains_unsupported_custom_sql",
        "extract_last_refresh_time",
        "container_name",
        "container_type",
        "dashboards",
        "model_name",
        "source_file",
        "view_name",
        "connection_name",
        "lookml_model_id",
        "explore_id",
        "explore_name",
        "query",
        "is_deleted",
        "user_id",
        "hidden",
        "deleted_at",
        "last_accessed_at",
        "last_viewed_at",
        "description",
        "favorite_count",
        "view_count",
        "preferred_viewer",
        "readonly",
        "refresh_interval",
        "load_configuration",
        "edit_uri",
        "look_ids",
        "looker_dashboard_tiles",
        "importance_score",
        "dashboard_folder",
        "avg_daily_views_last30_days",
        "total_views_since_creation",
        "model_id",
        "dashboard",
        "chart_title",
        "user_emails",
        "reason",
        "is_manual",
        "aggregation",
        "date_range",
        "workspace",
        "created_by",
        "modified_at",
        "modified_by",
        "report_type",
        "tiles",
        "workbook",
        "url",
        "email",
        "org",
        "kind",
        "project_name",
        "creation_time",
        "created_at",
    )
    owner = sgqlc.types.Field("OwnerRef", graphql_name="owner")

    site = sgqlc.types.Field("SiteRef", graphql_name="site")

    uri = sgqlc.types.Field(String, graphql_name="uri")

    sheets = sgqlc.types.Field(sgqlc.types.list_of("SheetDashboardRef"), graphql_name="sheets")

    embedded_datasources = sgqlc.types.Field(
        sgqlc.types.list_of("NameRef"), graphql_name="embeddedDatasources"
    )

    upstream_data_quality_warnings = sgqlc.types.Field(
        sgqlc.types.list_of("DataQualityWarningsRef"), graphql_name="upstreamDataQualityWarnings"
    )

    view_path = sgqlc.types.Field(String, graphql_name="viewPath")

    workbook_id = sgqlc.types.Field(String, graphql_name="workbookId")

    workbook_name = sgqlc.types.Field(String, graphql_name="workbookName")

    view_id = sgqlc.types.Field(String, graphql_name="viewId")

    luid = sgqlc.types.Field(String, graphql_name="luid")

    name = sgqlc.types.Field(String, graphql_name="name")

    is_certified = sgqlc.types.Field(Boolean, graphql_name="isCertified")

    has_extracts = sgqlc.types.Field(Boolean, graphql_name="hasExtracts")

    has_active_warning = sgqlc.types.Field(Boolean, graphql_name="hasActiveWarning")

    has_user_reference = sgqlc.types.Field(Boolean, graphql_name="hasUserReference")

    contains_unsupported_custom_sql = sgqlc.types.Field(
        Boolean, graphql_name="containsUnsupportedCustomSql"
    )

    extract_last_refresh_time = sgqlc.types.Field(String, graphql_name="extractLastRefreshTime")

    container_name = sgqlc.types.Field(String, graphql_name="containerName")

    container_type = sgqlc.types.Field(String, graphql_name="containerType")

    dashboards = sgqlc.types.Field(
        sgqlc.types.list_of("SheetDashboardRef"), graphql_name="dashboards"
    )

    model_name = sgqlc.types.Field(String, graphql_name="modelName")

    source_file = sgqlc.types.Field(String, graphql_name="sourceFile")

    view_name = sgqlc.types.Field(String, graphql_name="viewName")

    connection_name = sgqlc.types.Field(String, graphql_name="connectionName")

    lookml_model_id = sgqlc.types.Field(String, graphql_name="lookmlModelId")

    explore_id = sgqlc.types.Field(String, graphql_name="exploreId")

    explore_name = sgqlc.types.Field(String, graphql_name="exploreName")

    query = sgqlc.types.Field("QueryRef", graphql_name="query")

    is_deleted = sgqlc.types.Field(Boolean, graphql_name="isDeleted")

    user_id = sgqlc.types.Field(String, graphql_name="userId")

    hidden = sgqlc.types.Field(String, graphql_name="hidden")

    deleted_at = sgqlc.types.Field(String, graphql_name="deletedAt")

    last_accessed_at = sgqlc.types.Field(String, graphql_name="lastAccessedAt")

    last_viewed_at = sgqlc.types.Field(String, graphql_name="lastViewedAt")

    description = sgqlc.types.Field(String, graphql_name="description")

    favorite_count = sgqlc.types.Field(Int, graphql_name="favoriteCount")

    view_count = sgqlc.types.Field(Int, graphql_name="viewCount")

    preferred_viewer = sgqlc.types.Field(String, graphql_name="preferredViewer")

    readonly = sgqlc.types.Field(Boolean, graphql_name="readonly")

    refresh_interval = sgqlc.types.Field(String, graphql_name="refreshInterval")

    load_configuration = sgqlc.types.Field(String, graphql_name="loadConfiguration")

    edit_uri = sgqlc.types.Field(String, graphql_name="editUri")

    look_ids = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="lookIds")

    looker_dashboard_tiles = sgqlc.types.Field(
        sgqlc.types.list_of("LookerDashboardTileRef"), graphql_name="lookerDashboardTiles"
    )

    importance_score = sgqlc.types.Field(Float, graphql_name="importanceScore")

    dashboard_folder = sgqlc.types.Field(String, graphql_name="dashboardFolder")

    avg_daily_views_last30_days = sgqlc.types.Field(Float, graphql_name="avgDailyViewsLast30Days")

    total_views_since_creation = sgqlc.types.Field(Int, graphql_name="totalViewsSinceCreation")

    model_id = sgqlc.types.Field(String, graphql_name="modelId")

    dashboard = sgqlc.types.Field("SheetDashboardRef", graphql_name="dashboard")

    chart_title = sgqlc.types.Field(String, graphql_name="chartTitle")

    user_emails = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="userEmails")

    reason = sgqlc.types.Field(String, graphql_name="reason")

    is_manual = sgqlc.types.Field(String, graphql_name="isManual")

    aggregation = sgqlc.types.Field(String, graphql_name="aggregation")

    date_range = sgqlc.types.Field(String, graphql_name="dateRange")

    workspace = sgqlc.types.Field("PowerBIWorkSpaceRef", graphql_name="workspace")

    created_by = sgqlc.types.Field(String, graphql_name="createdBy")

    modified_at = sgqlc.types.Field(String, graphql_name="modifiedAt")

    modified_by = sgqlc.types.Field(String, graphql_name="modifiedBy")

    report_type = sgqlc.types.Field(String, graphql_name="reportType")

    tiles = sgqlc.types.Field(sgqlc.types.list_of("PowerBIDashboardTileRef"), graphql_name="tiles")

    workbook = sgqlc.types.Field(String, graphql_name="workbook")

    url = sgqlc.types.Field(String, graphql_name="url")

    email = sgqlc.types.Field(String, graphql_name="email")

    org = sgqlc.types.Field(String, graphql_name="org")

    kind = sgqlc.types.Field(String, graphql_name="kind")

    project_name = sgqlc.types.Field(String, graphql_name="projectName")

    creation_time = sgqlc.types.Field(String, graphql_name="creationTime")

    created_at = sgqlc.types.Field(String, graphql_name="createdAt")


class BiWarehouseSources(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("warehouse_resource_id", "warehouse_resource_type", "bi_warehouse_id")
    warehouse_resource_id = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="warehouseResourceId"
    )
    """Warehouse resource ID. This is a Monte Carlo ID"""

    warehouse_resource_type = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="warehouseResourceType"
    )
    """Warehouse type. Examples: snowflake, redshift, etc."""

    bi_warehouse_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="biWarehouseId")
    """The warehouse ID in the BI instance of the customer. This is an ID
    in the customer ID space and is not a Monte Carlo ID.
    """


class BigQueryProject(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("full_project_id", "friendly_name")
    full_project_id = sgqlc.types.Field(String, graphql_name="fullProjectId")

    friendly_name = sgqlc.types.Field(String, graphql_name="friendlyName")


class BillingContractInvoice(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "start_time",
        "end_time",
        "tier_name",
        "total",
        "status",
        "commit_consumed",
        "items",
    )
    id = sgqlc.types.Field(String, graphql_name="id")
    """The id of the invoice"""

    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """The start of the invoice period"""

    end_time = sgqlc.types.Field(DateTime, graphql_name="endTime")
    """The end of the invoice period"""

    tier_name = sgqlc.types.Field(String, graphql_name="tierName")
    """The name of the current tier"""

    total = sgqlc.types.Field(Int, graphql_name="total")
    """The total cost minus credits"""

    status = sgqlc.types.Field(BillingInvoiceStatus, graphql_name="status")
    """The status of the invoice"""

    commit_consumed = sgqlc.types.Field(Int, graphql_name="commitConsumed")
    """Money subtracted from commits"""

    items = sgqlc.types.Field(
        sgqlc.types.list_of("BillingContractInvoiceItem"), graphql_name="items"
    )
    """Products charged in the invoice"""


class BillingContractInvoiceItem(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("credits", "rate")
    credits = sgqlc.types.Field(Int, graphql_name="credits")
    """The number of credits used."""

    rate = sgqlc.types.Field(Float, graphql_name="rate")
    """The rate at which credits were used."""


class BillingContractInvoiceResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("invoices",)
    invoices = sgqlc.types.Field(
        sgqlc.types.list_of(BillingContractInvoice), graphql_name="invoices"
    )
    """List of contract invoices for the account"""


class BillingCreditGrant(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "name",
        "start_time",
        "end_time",
        "amount_paid",
        "amount_remaining",
        "quantity_remaining",
        "currency",
    )
    id = sgqlc.types.Field(String, graphql_name="id")
    """The id of the credit grant"""

    name = sgqlc.types.Field(String, graphql_name="name")
    """Description of the credit"""

    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """The starting time when the credit is valid for use"""

    end_time = sgqlc.types.Field(DateTime, graphql_name="endTime")
    """The time that the credit expires"""

    amount_paid = sgqlc.types.Field(Int, graphql_name="amountPaid")
    """The amount paid"""

    amount_remaining = sgqlc.types.Field(Int, graphql_name="amountRemaining")
    """The amount of credit remaining"""

    quantity_remaining = sgqlc.types.Field(Int, graphql_name="quantityRemaining")
    """Quantity remaining calculated from amount_remaining."""

    currency = sgqlc.types.Field(String, graphql_name="currency")
    """The unit of the credit. Currently only `USD (cents)` is supported."""


class BillingCreditGrantResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("credit_grants", "page_info")
    credit_grants = sgqlc.types.Field(
        sgqlc.types.list_of(BillingCreditGrant), graphql_name="creditGrants"
    )
    """List of credit grants for the account"""

    page_info = sgqlc.types.Field("NextPageInfo", graphql_name="pageInfo")
    """Data necessary to paginate the list of credit grants"""


class BillingInvoice(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "start_time",
        "end_time",
        "plan_name",
        "total",
        "currency",
        "status",
        "products",
    )
    id = sgqlc.types.Field(String, graphql_name="id")
    """The id of the invoice"""

    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """The start of the invoice period"""

    end_time = sgqlc.types.Field(DateTime, graphql_name="endTime")
    """The end of the invoice period"""

    plan_name = sgqlc.types.Field(String, graphql_name="planName")
    """The name of the plan"""

    total = sgqlc.types.Field(Int, graphql_name="total")
    """The total cost minus credits"""

    currency = sgqlc.types.Field(String, graphql_name="currency")
    """The currency of the total. Currently only `USD (cents)` is
    supported.
    """

    status = sgqlc.types.Field(BillingInvoiceStatus, graphql_name="status")
    """The status of the invoice"""

    products = sgqlc.types.Field(
        sgqlc.types.list_of("BillingInvoiceProduct"), graphql_name="products"
    )
    """Products charged in the invoice"""


class BillingInvoiceProduct(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("name", "charges")
    name = sgqlc.types.Field(String, graphql_name="name")
    """The name of the product"""

    charges = sgqlc.types.Field(
        sgqlc.types.list_of("BillingInvoiceProductCharge"), graphql_name="charges"
    )
    """Charges for the product"""


class BillingInvoiceProductCharge(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("quantity", "commit_rate", "on_demand_rate")
    quantity = sgqlc.types.Field(Int, graphql_name="quantity")
    """The quantity of product charged"""

    commit_rate = sgqlc.types.Field(Int, graphql_name="commitRate")
    """Value only exists for commit plans."""

    on_demand_rate = sgqlc.types.Field(Int, graphql_name="onDemandRate")
    """Value exists for both commit and on-demand plans."""


class BillingInvoiceResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("invoices", "page_info")
    invoices = sgqlc.types.Field(sgqlc.types.list_of(BillingInvoice), graphql_name="invoices")
    """List of invoices for the account"""

    page_info = sgqlc.types.Field("NextPageInfo", graphql_name="pageInfo")
    """Data necessary to paginate the list of invoices"""


class BillingMonitorUsage(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "date",
        "table_monitor_credits",
        "metric_monitor_credits",
        "validation_monitor_credits",
        "comparison_monitor_credits",
        "custom_sql_monitor_credits",
        "performance_monitor_credits",
        "json_schema_monitor_credits",
        "metric_legacy_monitor_credits",
        "freshness_rule_monitor_credits",
        "volume_rule_monitor_credits",
        "metric_comparison_monitor_credits",
    )
    date = sgqlc.types.Field(Date, graphql_name="date")
    """The date for this data point"""

    table_monitor_credits = sgqlc.types.Field(Float, graphql_name="tableMonitorCredits")
    """Credits used by table monitors"""

    metric_monitor_credits = sgqlc.types.Field(Float, graphql_name="metricMonitorCredits")
    """Credits used by metric monitors"""

    validation_monitor_credits = sgqlc.types.Field(Float, graphql_name="validationMonitorCredits")
    """Credits used by validation monitors"""

    comparison_monitor_credits = sgqlc.types.Field(Float, graphql_name="comparisonMonitorCredits")
    """Credits used by comparison monitors"""

    custom_sql_monitor_credits = sgqlc.types.Field(Float, graphql_name="customSqlMonitorCredits")
    """Credits used by custom SQL monitors"""

    performance_monitor_credits = sgqlc.types.Field(Float, graphql_name="performanceMonitorCredits")
    """Credits used by performance monitors"""

    json_schema_monitor_credits = sgqlc.types.Field(Float, graphql_name="jsonSchemaMonitorCredits")
    """Credits used by JSON schema monitors"""

    metric_legacy_monitor_credits = sgqlc.types.Field(
        Float, graphql_name="metricLegacyMonitorCredits"
    )
    """Credits used by metric_legacy monitors"""

    freshness_rule_monitor_credits = sgqlc.types.Field(
        Float, graphql_name="freshnessRuleMonitorCredits"
    )
    """Credits used by freshness rule monitors"""

    volume_rule_monitor_credits = sgqlc.types.Field(Float, graphql_name="volumeRuleMonitorCredits")
    """Credits used by volume rule monitors"""

    metric_comparison_monitor_credits = sgqlc.types.Field(
        Float, graphql_name="metricComparisonMonitorCredits"
    )
    """Credits used by metric comparison monitors"""


class BillingMonitorUsageResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("usages",)
    usages = sgqlc.types.Field(sgqlc.types.list_of(BillingMonitorUsage), graphql_name="usages")
    """List of daily monitor usage data points."""


class BulkAddMonitorDataQualityDimension(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class BulkAddMonitorTags(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class BulkCreateOrUpdateObjectProperties(sgqlc.types.Type):
    """Create or update a list of properties (tags) for objects (e.g.
    tables, fields, etc.)
    """

    __schema__ = schema
    __field_names__ = ("object_properties",)
    object_properties = sgqlc.types.Field(
        sgqlc.types.list_of("ObjectProperty"), graphql_name="objectProperties"
    )
    """List of properties created or updated"""


class BulkSetEtlJobGeneratesAlerts(sgqlc.types.Type):
    """Set whether a set of ETL jobs (like an Airflow DAG) generates
    alerts or not
    """

    __schema__ = schema
    __field_names__ = ("updated_jobs",)
    updated_jobs = sgqlc.types.Field(Int, graphql_name="updatedJobs")
    """Number of jobs updated"""


class BulkUpdateAlerts(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class BulkUpdateIncidents(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class CaasCollectionNodeParameters(sgqlc.types.Type):
    """Node parameters"""

    __schema__ = schema
    __field_names__ = ("parameters",)
    parameters = sgqlc.types.Field(sgqlc.types.non_null(GenericScalar), graphql_name="parameters")
    """Node parameters"""


class CaasLinkCollectionResources(sgqlc.types.Type):
    """Links a pre-provisioned node and data-store to the specified DC.
    Only non-active DCs with template_variant=aether are supported.
    """

    __schema__ = schema
    __field_names__ = ("dc",)
    dc = sgqlc.types.Field("DataCollector", graphql_name="dc")
    """The data collector that was updated"""


class CaasUpdateCollectionNodeEnv(sgqlc.types.Type):
    """Updates the environment variables for the collection node
    associated to the specified DC
    """

    __schema__ = schema
    __field_names__ = ("ok",)
    ok = sgqlc.types.Field(Boolean, graphql_name="ok")
    """Boolean indicating if the operation was successful"""


class CaasUpdateCollectionNodeParameters(sgqlc.types.Type):
    """Updates the parameters for the collection node associated to the
    specified DC
    """

    __schema__ = schema
    __field_names__ = ("ok",)
    ok = sgqlc.types.Field(Boolean, graphql_name="ok")
    """Boolean indicating if the operation was successful"""


class CaasUpdateCollectionNodeVersion(sgqlc.types.Type):
    """Updates the collection node associated to the specified DC to the
    specified version.If no version is provided, the node is upgraded
    to latest version.
    """

    __schema__ = schema
    __field_names__ = ("ok",)
    ok = sgqlc.types.Field(Boolean, graphql_name="ok")
    """Boolean indicating if the operation was successful"""


class CaasUpdateCollectionStorageEncryption(sgqlc.types.Type):
    """Sets the collection storage encryption"""

    __schema__ = schema
    __field_names__ = ("ok",)
    ok = sgqlc.types.Field(Boolean, graphql_name="ok")
    """Boolean indicating if the operation was successful"""


class CaasUpdateCollectionStorageLink(sgqlc.types.Type):
    """If there's an agent associated to the service, it makes sure the
    link to the CaaS storage is deleted.
    """

    __schema__ = schema
    __field_names__ = ("ok",)
    ok = sgqlc.types.Field(Boolean, graphql_name="ok")
    """Boolean indicating if the operation was successful"""


class CaasUpdateCollectionStorageParameters(sgqlc.types.Type):
    """Updates the parameters for the collection storage associated to
    the specified DC
    """

    __schema__ = schema
    __field_names__ = ("ok",)
    ok = sgqlc.types.Field(Boolean, graphql_name="ok")
    """Boolean indicating if the operation was successful"""


class CaasUpdateCollectionStorageVersion(sgqlc.types.Type):
    """Updates the collection storage template version associated to the
    specified DC.
    """

    __schema__ = schema
    __field_names__ = ("ok",)
    ok = sgqlc.types.Field(Boolean, graphql_name="ok")
    """Boolean indicating if the operation was successful"""


class CatalogMapping(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("from_name", "to_name")
    from_name = sgqlc.types.Field(String, graphql_name="fromName")
    """From catalog object name."""

    to_name = sgqlc.types.Field(String, graphql_name="toName")
    """To catalog object name."""


class CatalogMappings(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("database_mappings",)
    database_mappings = sgqlc.types.Field(
        sgqlc.types.list_of(CatalogMapping), graphql_name="databaseMappings"
    )


class CatalogNavNode(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("mcon_id", "display_name", "object_type", "path", "may_have_children")
    mcon_id = sgqlc.types.Field(String, graphql_name="mconId")
    """MCON ID of the object represented by this node."""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """User-friendly display name of the catalog object."""

    object_type = sgqlc.types.Field(String, graphql_name="objectType")
    """The catalog object's type."""

    path = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="path")
    """Object's hierarchy as list of ancestors plus self, if applicable."""

    may_have_children = sgqlc.types.Field(Boolean, graphql_name="mayHaveChildren")
    """Whether or not the node may have children. (Does not indicate if
    it actually does.)
    """


class CatalogNavResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("nodes", "has_next_page", "next_page_offset", "group_object_type")
    nodes = sgqlc.types.Field(sgqlc.types.list_of(CatalogNavNode), graphql_name="nodes")
    """Nodes for current nav page."""

    has_next_page = sgqlc.types.Field(Boolean, graphql_name="hasNextPage")
    """If there are more nodes."""

    next_page_offset = sgqlc.types.Field(Int, graphql_name="nextPageOffset")
    """Where to start for next page, if next page exists."""

    group_object_type = sgqlc.types.Field(String, graphql_name="groupObjectType")
    """Object type of the group, when grouping by type."""


class CatalogObjectMetadataConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("CatalogObjectMetadataEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class CatalogObjectMetadataEdge(sgqlc.types.Type):
    """A Relay edge containing a `CatalogObjectMetadata` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("CatalogObjectMetadata", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class CategorizedSearchResponse(sgqlc.types.Type):
    """List of tables for dynamic schedule"""

    __schema__ = schema
    __field_names__ = ("total_hits", "results")
    total_hits = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="totalHits")
    """Number of results"""

    results = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("CategorizedSearchResult")), graphql_name="results"
    )
    """List of matching results"""


class CategorizedSearchResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "mcon",
        "lineage_node_id",
        "object_type",
        "object_id",
        "display_name",
        "parent_mcon",
        "path",
        "project_id",
        "dataset",
        "table_id",
        "properties",
        "resource_id",
        "warehouse_display_name",
        "description",
        "field_type",
        "highlight",
        "highlight_properties",
        "field_names",
        "is_important",
        "importance_score",
        "upstream_resource_ids",
        "bi_parent_name",
        "is_monitored",
        "is_muted",
        "etl_type",
        "supports_data_explorer",
        "category",
        "is_dynamic_schedule_supported",
    )
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """Monte Carlo full identifier for an entity"""

    lineage_node_id = sgqlc.types.Field(String, graphql_name="lineageNodeId")
    """Identifier for lineage nodes. Warning - To be deprecated soon"""

    object_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="objectType")
    """Type of object (e.g. table, view, etc.)"""

    object_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="objectId")
    """Partial identifier (e.g. project:dataset.table)"""

    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")
    """Friendly name for entity"""

    parent_mcon = sgqlc.types.Field(String, graphql_name="parentMcon")
    """Identifier for any parents (e.g. field belonging to a table)"""

    path = sgqlc.types.Field(String, graphql_name="path")
    """Path to node"""

    project_id = sgqlc.types.Field(String, graphql_name="projectId")
    """Name of project (database or catalog in some warehouses)"""

    dataset = sgqlc.types.Field(String, graphql_name="dataset")
    """Name of dataset (schema in some warehouses)"""

    table_id = sgqlc.types.Field(String, graphql_name="tableId")
    """Name of the table"""

    properties = sgqlc.types.Field(
        sgqlc.types.list_of("SearchResultProperty"), graphql_name="properties"
    )
    """Any attached labels"""

    resource_id = sgqlc.types.Field(String, graphql_name="resourceId")
    """Resource identifier (e.g. warehouse). Warning - To be deprecated
    soon
    """

    warehouse_display_name = sgqlc.types.Field(String, graphql_name="warehouseDisplayName")
    """Name of warehouse"""

    description = sgqlc.types.Field(String, graphql_name="description")
    """Description of object"""

    field_type = sgqlc.types.Field(String, graphql_name="fieldType")
    """Data type of field. Only populated if object_type=field"""

    highlight = sgqlc.types.Field(
        sgqlc.types.list_of("HighlightSnippets"), graphql_name="highlight"
    )
    """Highlight snippets"""

    highlight_properties = sgqlc.types.Field(
        sgqlc.types.list_of("NestedHighlightSnippets"), graphql_name="highlightProperties"
    )
    """Highlight snippets for object properties"""

    field_names = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="fieldNames")
    """Field names (if object_type=table)"""

    is_important = sgqlc.types.Field(Boolean, graphql_name="isImportant")
    """Whether the table or field is important"""

    importance_score = sgqlc.types.Field(Float, graphql_name="importanceScore")
    """Importance score for tables"""

    upstream_resource_ids = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="upstreamResourceIds"
    )
    """Upstream resource ids"""

    bi_parent_name = sgqlc.types.Field(String, graphql_name="biParentName")
    """Name of parent resource to BI asset"""

    is_monitored = sgqlc.types.Field(Boolean, graphql_name="isMonitored")
    """Whether the table is monitored"""

    is_muted = sgqlc.types.Field(Boolean, graphql_name="isMuted")
    """Whether the table is muted"""

    etl_type = sgqlc.types.Field(EtlType, graphql_name="etlType")
    """ETL type of the job asset (if object_type=job)"""

    supports_data_explorer = sgqlc.types.Field(Boolean, graphql_name="supportsDataExplorer")
    """Whether the table supports data explorer"""

    category = sgqlc.types.Field(SearchCategoryEnum, graphql_name="category")
    """Name of the category for the table like: RESOLVED TABLES, ALL
    TABLES etc
    """

    is_dynamic_schedule_supported = sgqlc.types.Field(
        Boolean, graphql_name="isDynamicScheduleSupported"
    )
    """Whether the table is supported for dynamic scheduling"""


class CategoryLabelRank(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("time_series_uuid", "label", "rank")
    time_series_uuid = sgqlc.types.Field(UUID, graphql_name="timeSeriesUuid")

    label = sgqlc.types.Field(String, graphql_name="label")

    rank = sgqlc.types.Field(Float, graphql_name="rank")


class CircuitBreakerState(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "job_execution_uuid",
        "account_uuid",
        "resource_uuid",
        "custom_rule_uuid",
        "status",
        "log",
    )
    job_execution_uuid = sgqlc.types.Field(UUID, graphql_name="jobExecutionUuid")
    """UUID for the job execution that identifies the circuit breaker run"""

    account_uuid = sgqlc.types.Field(UUID, graphql_name="accountUuid")
    """UUID for the account that owns the rule"""

    resource_uuid = sgqlc.types.Field(UUID, graphql_name="resourceUuid")
    """UUID for the warehouse that owns the rule"""

    custom_rule_uuid = sgqlc.types.Field(UUID, graphql_name="customRuleUuid")
    """UUID for the custom rule that was run as a circuit breaker"""

    status = sgqlc.types.Field(SqlJobCheckpointStatus, graphql_name="status")
    """Status of the circuit breaker run"""

    log = sgqlc.types.Field(JSONString, graphql_name="log")
    """Array of JSON objects containing state for each stage of the job
    execution
    """


class ClassificationCategories(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("label", "description", "examples")
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="label")

    description = sgqlc.types.Field(String, graphql_name="description")

    examples = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="examples"
    )


class CleanupCollectorRecordInAccount(sgqlc.types.Type):
    """Deletes an unassociated collector record in the account. This does
    not delete the CloudFormation stack and will not succeed if the
    collector is active and/or associated with a warehouse.
    """

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """If the collector record was deleted"""


class CollectionBlockConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("CollectionBlockEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class CollectionBlockEdge(sgqlc.types.Type):
    """A Relay edge containing a `CollectionBlock` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("CollectionBlock", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class CollectionDataSet(sgqlc.types.Type):
    """Data set to collect data."""

    __schema__ = schema
    __field_names__ = ("resource_id", "project", "dataset")
    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="resourceId")
    """The resource UUID of the dataset."""

    project = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="project")
    """Top-level object hierarchy e.g. database, catalog, etc."""

    dataset = sgqlc.types.Field(String, graphql_name="dataset")
    """Intermediate object hierarchy e.g. schema, database, etc."""


class CollectionDataSetConnection(sgqlc.types.relay.Connection):
    """Datasets to collect data"""

    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("CollectionDataSetEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class CollectionDataSetEdge(sgqlc.types.Type):
    """A Relay edge containing a `CollectionDataSet` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field(CollectionDataSet, graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class CollectionDetails(sgqlc.types.Type):
    """Collection platform information"""

    __schema__ = schema
    __field_names__ = ("private_link_details", "active_node_details")
    private_link_details = sgqlc.types.Field(
        "PrivateLinkDetails", graphql_name="privateLinkDetails"
    )
    """Private Link information"""

    active_node_details = sgqlc.types.Field(
        sgqlc.types.list_of(ActiveNodeDetails), graphql_name="activeNodeDetails"
    )
    """List of active nodes"""


class CollectionNode(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "status", "stack_arn", "assigned_on", "resources")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    status = sgqlc.types.Field(
        sgqlc.types.non_null(CollectionNodeModelStatus), graphql_name="status"
    )
    """Resource status"""

    stack_arn = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="stackArn")
    """ARN of CloudFormation stack"""

    assigned_on = sgqlc.types.Field(DateTime, graphql_name="assignedOn")
    """Timestamp resource was assigned"""

    resources = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="resources")
    """Node resources"""


class CollectionProperties(sgqlc.types.Type):
    """Collection infrastructure properties"""

    __schema__ = schema
    __field_names__ = (
        "cross_account_external_id",
        "customer_account_token",
        "code_bucket",
        "code_version",
        "platform_aws_account_id",
        "docker_image_uri",
        "platform_region_details",
    )
    cross_account_external_id = sgqlc.types.Field(String, graphql_name="crossAccountExternalId")
    """External id for cross account IAM role"""

    customer_account_token = sgqlc.types.Field(String, graphql_name="customerAccountToken")
    """Customer account token (unique per data collector)"""

    code_bucket = sgqlc.types.Field(String, graphql_name="codeBucket")
    """S3 bucket containing data collector code"""

    code_version = sgqlc.types.Field(String, graphql_name="codeVersion")
    """Data collector code version"""

    platform_aws_account_id = sgqlc.types.Field(String, graphql_name="platformAwsAccountId")
    """Monte Carlo AWS account id"""

    docker_image_uri = sgqlc.types.Field(String, graphql_name="dockerImageUri")
    """URI of the docker image for the data collector"""

    platform_region_details = sgqlc.types.Field(
        "PlatformRegionProperties", graphql_name="platformRegionDetails"
    )
    """Region-specific properties"""


class CollectionStatusOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("interval_in_seconds", "interval_crontab", "next_run")
    interval_in_seconds = sgqlc.types.Field(Float, graphql_name="intervalInSeconds")
    """Interval in seconds between data collections"""

    interval_crontab = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="intervalCrontab"
    )
    """Interval as cron expressions between data collections"""

    next_run = sgqlc.types.Field(DateTime, graphql_name="nextRun")
    """Date & time of next collection run"""


class CollectionStorage(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "status", "stack_arn", "assigned_on", "resources")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    status = sgqlc.types.Field(
        sgqlc.types.non_null(CollectionStorageModelStatus), graphql_name="status"
    )
    """Resource status"""

    stack_arn = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="stackArn")
    """ARN of CloudFormation stack"""

    assigned_on = sgqlc.types.Field(DateTime, graphql_name="assignedOn")
    """Timestamp resource was assigned"""

    resources = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="resources")
    """Storage resources"""


class CollibraDomainSearchResponse(sgqlc.types.Type):
    """Collibra domain search response for table search name"""

    __schema__ = schema
    __field_names__ = (
        "collibra_table_asset_id",
        "collibra_table_asset_domain_id",
        "collibra_schema_asset_id",
        "collibra_database_asset_id",
        "collibra_database_asset_domain_id",
    )
    collibra_table_asset_id = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="collibraTableAssetId"
    )
    """Collibra table asset ID"""

    collibra_table_asset_domain_id = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="collibraTableAssetDomainId"
    )
    """Collibra table asset domain ID"""

    collibra_schema_asset_id = sgqlc.types.Field(String, graphql_name="collibraSchemaAssetId")
    """Collibra schema asset ID"""

    collibra_database_asset_id = sgqlc.types.Field(String, graphql_name="collibraDatabaseAssetId")
    """Collibra database asset ID"""

    collibra_database_asset_domain_id = sgqlc.types.Field(
        String, graphql_name="collibraDatabaseAssetDomainId"
    )
    """Collibra database asset domain ID"""


class CollibraIntegrationConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("CollibraIntegrationEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class CollibraIntegrationEdge(sgqlc.types.Type):
    """A Relay edge containing a `CollibraIntegration` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("CollibraIntegration", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class CollibraMonitorNoteResponse(sgqlc.types.Type):
    """Collibra monitor note response."""

    __schema__ = schema
    __field_names__ = ("monitor_uuid", "collibra_note")
    monitor_uuid = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="monitorUuid")
    """Monitor uuid"""

    collibra_note = sgqlc.types.Field(String, graphql_name="collibraNote")
    """Collibra note"""


class CollibraPingResponse(sgqlc.types.Type):
    """Collibra ping information"""

    __schema__ = schema
    __field_names__ = ("ping",)
    ping = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="ping")
    """True if got response from Collibra using credentials"""


class ColumnLineage(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("selected_column", "lineage_sources")
    selected_column = sgqlc.types.Field(String, graphql_name="selectedColumn")
    """The column on the destination table"""

    lineage_sources = sgqlc.types.Field(
        sgqlc.types.list_of("LineageSources"), graphql_name="lineageSources"
    )
    """Direct source lineage of the selected column"""


class ComparableDashboardType(sgqlc.types.Type):
    """Another dashboard that is compatible for comparison"""

    __schema__ = schema
    __field_names__ = ("dashboard_uuid", "shared_time_axis_field_name", "shared_field_names")
    dashboard_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="dashboardUuid")

    shared_time_axis_field_name = sgqlc.types.Field(String, graphql_name="sharedTimeAxisFieldName")
    """Shared time axis field name"""

    shared_field_names = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="sharedFieldNames"
    )
    """Fields shared between dashboards"""


class ComparisonAlertCondition(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "metric",
        "custom_metric",
        "source_field",
        "target_field",
        "type",
        "operator",
        "threshold_value",
        "is_threshold_relative",
    )
    metric = sgqlc.types.Field(String, graphql_name="metric")

    custom_metric = sgqlc.types.Field("CustomComparisonMetric", graphql_name="customMetric")

    source_field = sgqlc.types.Field(String, graphql_name="sourceField")

    target_field = sgqlc.types.Field(String, graphql_name="targetField")

    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="type")

    operator = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="operator")

    threshold_value = sgqlc.types.Field(Float, graphql_name="thresholdValue")

    is_threshold_relative = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="isThresholdRelative"
    )


class ComparisonEvaluationResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("errors", "field_metric_time_series_count", "max_segments")
    errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Error"))),
        graphql_name="errors",
    )

    field_metric_time_series_count = sgqlc.types.Field(
        Int, graphql_name="fieldMetricTimeSeriesCount"
    )
    """Number of separate field/metric time series in the query."""

    max_segments = sgqlc.types.Field(Int, graphql_name="maxSegments")
    """Maximum number of allowed segments for the given field and metric
    selection.
    """


class ComparisonMonitorResponseConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("ComparisonMonitorResponseEdge")),
        graphql_name="edges",
    )
    """Contains the nodes in this connection."""


class ComparisonMonitorResponseEdge(sgqlc.types.Type):
    """A Relay edge containing a `ComparisonMonitorResponse` and its
    cursor.
    """

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("ComparisonMonitorResponse", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class ConfigureAiAgentPrompt(sgqlc.types.Type):
    """Configure or update the context prompt for an AI agent type"""

    __schema__ = schema
    __field_names__ = ("ai_agent", "success")
    ai_agent = sgqlc.types.Field(AiAgent, graphql_name="aiAgent")
    """The configured AI agent"""

    success = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="success")
    """Whether the operation succeeded"""


class ConfigureMetadataEvents(sgqlc.types.Type):
    """Configure collection of metadata via S3 events"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class ConfigureQueryLogEvents(sgqlc.types.Type):
    """Configure collection of query logs via S3 events"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class ConnectPlatformServiceToExistingAgent(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("agent_id",)
    agent_id = sgqlc.types.Field(UUID, graphql_name="agentId")
    """The UUID assigned to the new agent."""


class ConnectPlatformServiceToExistingBucket(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("data_store_id",)
    data_store_id = sgqlc.types.Field(UUID, graphql_name="dataStoreId")
    """The UUID assigned to the data store created from the existing
    bucket.
    """


class ConnectPlatformServiceToLegacyBucket(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("dc",)
    dc = sgqlc.types.Field("DataCollector", graphql_name="dc")
    """The data collector that was updated"""


class ConnectedMcons(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("connected_mcons",)
    connected_mcons = sgqlc.types.Field(
        sgqlc.types.list_of("LineageMconNode"), graphql_name="connectedMcons"
    )
    """List of mcons"""


class Connection(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "created_time",
        "updated_time",
        "created_by",
        "last_update_user",
        "deleted_at",
        "uuid",
        "type",
        "subtype",
        "name",
        "warehouse",
        "bi_container",
        "etl_container",
        "deletion_protection",
        "job_types",
        "streaming_cluster",
        "credentials_s3_key",
        "integration_gateway_credentials_key",
        "data",
        "created_on",
        "updated_on",
        "is_active",
        "disabled_on",
        "dbt_projects",
        "account",
        "connection_identifier",
        "connection_identifiers",
        "job_errors",
        "resolved_connection_type",
        "sql_job_timeout_maximum",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdTime")

    updated_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedTime")

    created_by = sgqlc.types.Field("User", graphql_name="createdBy")
    """Creator"""

    last_update_user = sgqlc.types.Field("User", graphql_name="lastUpdateUser")
    """Last updated by"""

    deleted_at = sgqlc.types.Field(DateTime, graphql_name="deletedAt")

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")

    type = sgqlc.types.Field(sgqlc.types.non_null(ConnectionModelType), graphql_name="type")

    subtype = sgqlc.types.Field(String, graphql_name="subtype")
    """Subtype of a plugin connection"""

    name = sgqlc.types.Field(String, graphql_name="name")
    """Connection name"""

    warehouse = sgqlc.types.Field("Warehouse", graphql_name="warehouse")

    bi_container = sgqlc.types.Field(BiContainer, graphql_name="biContainer")

    etl_container = sgqlc.types.Field("EtlContainer", graphql_name="etlContainer")

    deletion_protection = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="deletionProtection"
    )
    """Prevents deletion when enabled."""

    job_types = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="jobTypes",
    )

    streaming_cluster = sgqlc.types.Field("StreamingCluster", graphql_name="streamingCluster")

    credentials_s3_key = sgqlc.types.Field(String, graphql_name="credentialsS3Key")

    integration_gateway_credentials_key = sgqlc.types.Field(
        String, graphql_name="integrationGatewayCredentialsKey"
    )

    data = sgqlc.types.Field(JSONString, graphql_name="data")

    created_on = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdOn")

    updated_on = sgqlc.types.Field(DateTime, graphql_name="updatedOn")

    is_active = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isActive")

    disabled_on = sgqlc.types.Field(DateTime, graphql_name="disabledOn")

    dbt_projects = sgqlc.types.Field(
        sgqlc.types.non_null("DbtProjectConnection"),
        graphql_name="dbtProjects",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """dbt connection

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    account = sgqlc.types.Field(Account, graphql_name="account")

    connection_identifier = sgqlc.types.Field(
        "ConnectionIdentifier", graphql_name="connectionIdentifier"
    )

    connection_identifiers = sgqlc.types.Field(
        sgqlc.types.list_of("ConnectionIdentifier"), graphql_name="connectionIdentifiers"
    )

    job_errors = sgqlc.types.Field(sgqlc.types.list_of("JobError"), graphql_name="jobErrors")
    """Errors related to the connection"""

    resolved_connection_type = sgqlc.types.Field(String, graphql_name="resolvedConnectionType")
    """Identifies the connection type"""

    sql_job_timeout_maximum = sgqlc.types.Field(Int, graphql_name="sqlJobTimeoutMaximum")
    """The maximum timeout for SQL jobs that can be set for this
    connection
    """


class ConnectionIdentifier(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("key", "value")
    key = sgqlc.types.Field(String, graphql_name="key")
    """Connection credential key serving as an identifier"""

    value = sgqlc.types.Field(String, graphql_name="value")
    """Value of connection identifier key"""


class ConnectionValidation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("type", "message", "data")
    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="type")
    """Validation type"""

    message = sgqlc.types.Field(String, graphql_name="message")
    """Message describing the validation"""

    data = sgqlc.types.Field("ConnectionValidationData", graphql_name="data")
    """Metadata for the validation"""


class ConnectionValidationData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("database", "table", "error")
    database = sgqlc.types.Field(String, graphql_name="database")
    """Database name"""

    table = sgqlc.types.Field(String, graphql_name="table")
    """Table identifier"""

    error = sgqlc.types.Field(String, graphql_name="error")
    """Error message"""


class ContractCommit(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "name", "start", "expiration", "amount_paid", "amount_remaining")
    id = sgqlc.types.Field(String, graphql_name="id")
    """The id of the commit"""

    name = sgqlc.types.Field(String, graphql_name="name")
    """Description of the commit"""

    start = sgqlc.types.Field(DateTime, graphql_name="start")
    """The starting time of the commit"""

    expiration = sgqlc.types.Field(DateTime, graphql_name="expiration")
    """The expiration time of the commit"""

    amount_paid = sgqlc.types.Field(Int, graphql_name="amountPaid")
    """The committed funds paid upfront"""

    amount_remaining = sgqlc.types.Field(Int, graphql_name="amountRemaining")
    """The amount of committed funds remaining"""


class ContractCommitResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("contract_commits",)
    contract_commits = sgqlc.types.Field(
        sgqlc.types.list_of(ContractCommit), graphql_name="contractCommits"
    )
    """List of commits for all contracts"""


class ConversionResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "account_name",
        "account_uuid",
        "has_job_connection",
        "use_cbp_v2",
        "table_monitor_specs",
        "removed_table_monitor_specs",
        "job_routing_rules_specs",
        "unconvertible_routing_rules",
        "unconvertible_monitoring_rules",
        "warnings",
        "warehouse_count",
        "routing_rules_count",
        "monitoring_rules_count",
        "converted_monitor_uuids",
        "monitored_tables_count",
        "selected_tables_count",
        "top_multicovered_mcons_by_monitor_count",
        "mcon_coverage_distribution",
        "top_multicovered_mcons_by_monitor_count_per_alert_condition",
        "mcon_coverage_distribution_per_alert_condition",
        "mcon_coverage_distribution_per_audience_and_alert_condition",
        "multi_covered_mcons_by_audience_alert_condition_count",
        "multi_covered_mcons_by_alert_condition_count",
        "multi_covered_mcons_global_count",
        "sample_covered_not_monitored",
        "sample_monitored_not_covered",
        "mcons_covered_by_table_monitor_audiences",
        "mcons_covered_by_notification_routing_audiences",
        "sample_mcons_routing_not_table_monitor",
        "audience_routing_stats",
        "text_output",
        "summary_text",
        "table_monitor_specs_text",
        "job_routing_rules_text",
        "unconvertible_rules_text",
        "warnings_text",
        "validation_errors",
        "full_output_text",
    )
    account_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="accountName")

    account_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="accountUuid")

    has_job_connection = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="hasJobConnection"
    )

    use_cbp_v2 = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="useCbpV2")

    table_monitor_specs = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("TableMonitorSpec"))),
        graphql_name="tableMonitorSpecs",
    )

    removed_table_monitor_specs = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("TableMonitorSpec"))),
        graphql_name="removedTableMonitorSpecs",
    )

    job_routing_rules_specs = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("JobRoutingRuleSpec"))),
        graphql_name="jobRoutingRulesSpecs",
    )

    unconvertible_routing_rules = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("RoutingRuleData"))),
        graphql_name="unconvertibleRoutingRules",
    )

    unconvertible_monitoring_rules = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MonitoringRuleData"))),
        graphql_name="unconvertibleMonitoringRules",
    )

    warnings = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="warnings",
    )

    warehouse_count = sgqlc.types.Field(Int, graphql_name="warehouseCount")

    routing_rules_count = sgqlc.types.Field(Int, graphql_name="routingRulesCount")

    monitoring_rules_count = sgqlc.types.Field(Int, graphql_name="monitoringRulesCount")

    converted_monitor_uuids = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(UUID))),
        graphql_name="convertedMonitorUuids",
    )

    monitored_tables_count = sgqlc.types.Field(Int, graphql_name="monitoredTablesCount")

    selected_tables_count = sgqlc.types.Field(Int, graphql_name="selectedTablesCount")

    top_multicovered_mcons_by_monitor_count = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MconCountPair"))),
        graphql_name="topMulticoveredMconsByMonitorCount",
    )

    mcon_coverage_distribution = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MconsMonitorsCountPair"))),
        graphql_name="mconCoverageDistribution",
    )

    top_multicovered_mcons_by_monitor_count_per_alert_condition = sgqlc.types.Field(
        sgqlc.types.non_null(GenericScalar),
        graphql_name="topMulticoveredMconsByMonitorCountPerAlertCondition",
    )

    mcon_coverage_distribution_per_alert_condition = sgqlc.types.Field(
        sgqlc.types.non_null(GenericScalar),
        graphql_name="mconCoverageDistributionPerAlertCondition",
    )

    mcon_coverage_distribution_per_audience_and_alert_condition = sgqlc.types.Field(
        sgqlc.types.non_null(GenericScalar),
        graphql_name="mconCoverageDistributionPerAudienceAndAlertCondition",
    )

    multi_covered_mcons_by_audience_alert_condition_count = sgqlc.types.Field(
        Int, graphql_name="multiCoveredMconsByAudienceAlertConditionCount"
    )

    multi_covered_mcons_by_alert_condition_count = sgqlc.types.Field(
        Int, graphql_name="multiCoveredMconsByAlertConditionCount"
    )

    multi_covered_mcons_global_count = sgqlc.types.Field(
        Int, graphql_name="multiCoveredMconsGlobalCount"
    )

    sample_covered_not_monitored = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MconMonitorPair"))),
        graphql_name="sampleCoveredNotMonitored",
    )

    sample_monitored_not_covered = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MconRuleIdPair"))),
        graphql_name="sampleMonitoredNotCovered",
    )

    mcons_covered_by_table_monitor_audiences = sgqlc.types.Field(
        Int, graphql_name="mconsCoveredByTableMonitorAudiences"
    )

    mcons_covered_by_notification_routing_audiences = sgqlc.types.Field(
        Int, graphql_name="mconsCoveredByNotificationRoutingAudiences"
    )

    sample_mcons_routing_not_table_monitor = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MconMonitorPair"))),
        graphql_name="sampleMconsRoutingNotTableMonitor",
    )

    audience_routing_stats = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(AudienceRoutingStats))),
        graphql_name="audienceRoutingStats",
    )

    text_output = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="textOutput")

    summary_text = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="summaryText")

    table_monitor_specs_text = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="tableMonitorSpecsText"
    )

    job_routing_rules_text = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="jobRoutingRulesText"
    )

    unconvertible_rules_text = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="unconvertibleRulesText"
    )

    warnings_text = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="warningsText")

    validation_errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="validationErrors",
    )

    full_output_text = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="fullOutputText"
    )


class ConvertConfigTemplateToUiMonitors(sgqlc.types.Type):
    """Convert a config template to UI Monitors"""

    __schema__ = schema
    __field_names__ = ("response",)
    response = sgqlc.types.Field("ConvertConfigTemplateToUiMonitorsOutput", graphql_name="response")
    """Exported template"""


class ConvertConfigTemplateToUiMonitorsOutput(sgqlc.types.Type):
    """Convert config template to UI monitors response"""

    __schema__ = schema
    __field_names__ = ("monitors",)
    monitors = sgqlc.types.Field(
        sgqlc.types.list_of("UserDefinedMonitorV2"), graphql_name="monitors"
    )
    """Converted monitors"""


class ConvertUiMonitorsToConfigTemplate(sgqlc.types.Type):
    """Convert a set of monitors to a config template"""

    __schema__ = schema
    __field_names__ = ("response",)
    response = sgqlc.types.Field("ConvertUiMonitorsToConfigTemplateOutput", graphql_name="response")
    """Exported template"""


class ConvertUiMonitorsToConfigTemplateOutput(sgqlc.types.Type):
    """Convert monitors to config template response"""

    __schema__ = schema
    __field_names__ = (
        "monitors",
        "config_template_as_yaml",
        "config_template_as_dict",
        "errors",
        "warnings",
    )
    monitors = sgqlc.types.Field(sgqlc.types.list_of("UserDefinedMonitor"), graphql_name="monitors")
    """Converted monitors"""

    config_template_as_yaml = sgqlc.types.Field(String, graphql_name="configTemplateAsYaml")
    """Config Template as YAML"""

    config_template_as_dict = sgqlc.types.Field(JSONString, graphql_name="configTemplateAsDict")
    """Config Template as a dictionary"""

    errors = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="errors")
    """Errors encountered"""

    warnings = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="warnings")
    """Warnings encountered"""


class CorrelationSamplingMetadata(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("time_axis", "explanatory_field")
    time_axis = sgqlc.types.Field("TimeAxisMetadata", graphql_name="timeAxis")
    """Field used as the time axis"""

    explanatory_field = sgqlc.types.Field(
        "ExplanatoryFieldMetadata", graphql_name="explanatoryField"
    )
    """Field from which values are sampled"""


class CorrelationSamplingResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("sample",)
    sample = sgqlc.types.Field(sgqlc.types.list_of("RcaPlotData"), graphql_name="sample")
    """List of value distribution samples"""


class CreateAccessToken(sgqlc.types.Type):
    """Generate an API Access Token and associate to user"""

    __schema__ = schema
    __field_names__ = ("access_token",)
    access_token = sgqlc.types.Field(AccessToken, graphql_name="accessToken")


class CreateAccountSecret(sgqlc.types.Type):
    """Create an account secret"""

    __schema__ = schema
    __field_names__ = ("secret",)
    secret = sgqlc.types.Field(AccountSecretOutput, graphql_name="secret")
    """The secret that was created"""


class CreateAzureDevOpsIntegration(sgqlc.types.Type):
    """Create a new Azure DevOps integration."""

    __schema__ = schema
    __field_names__ = ("azure_devops_integration", "oauth_redirect_url")
    azure_devops_integration = sgqlc.types.Field(
        AzureDevOpsIntegrationOutput, graphql_name="azureDevopsIntegration"
    )
    """The created integration"""

    oauth_redirect_url = sgqlc.types.Field(String, graphql_name="oauthRedirectUrl")
    """OAuth redirect URL if OAuth credentials were provided"""


class CreateAzureDevOpsWorkItemForAlert(sgqlc.types.Type):
    """Create a new Azure DevOps work item from a Monte Carlo alert.
    This mutation creates a work item in Azure DevOps and links it to
    the alert.
    """

    __schema__ = schema
    __field_names__ = ("azure_devops_work_item",)
    azure_devops_work_item = sgqlc.types.Field(
        AzureDevOpsWorkItemOutput, graphql_name="azureDevopsWorkItem"
    )


class CreateAzureDevopsInstallation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("installation", "oauth_redirect_url")
    installation = sgqlc.types.Field(AzureDevopsInstallation, graphql_name="installation")
    """If using basic auth, the Azure DevOps installation that was
    created
    """

    oauth_redirect_url = sgqlc.types.Field(String, graphql_name="oauthRedirectUrl")


class CreateCollectorRecord(sgqlc.types.Type):
    """Create an additional collector record (with template) in the
    account.
    """

    __schema__ = schema
    __field_names__ = ("dc",)
    dc = sgqlc.types.Field("DataCollector", graphql_name="dc")
    """The data collector that was created"""


class CreateCustomMetricRule(sgqlc.types.Type):
    """Deprecated, use CreateOrUpdateCustomMetricRule instead"""

    __schema__ = schema
    __field_names__ = ("custom_rule",)
    custom_rule = sgqlc.types.Field("CustomRule", graphql_name="customRule")


class CreateCustomRule(sgqlc.types.Type):
    """Deprecated, use CreateOrUpdateCustomRule instead"""

    __schema__ = schema
    __field_names__ = ("custom_rule",)
    custom_rule = sgqlc.types.Field("CustomRule", graphql_name="customRule")


class CreateCustomUser(sgqlc.types.Type):
    """Create a CustomUser"""

    __schema__ = schema
    __field_names__ = ("custom_user",)
    custom_user = sgqlc.types.Field("CustomUser", graphql_name="customUser")


class CreateDataMaintenanceWindowFromHolidays(sgqlc.types.Type):
    """Create a data maintenance window for a set of holidays"""

    __schema__ = schema
    __field_names__ = ("entries",)
    entries = sgqlc.types.Field(sgqlc.types.list_of("DataMaintenanceEntry"), graphql_name="entries")


class CreateDatabricksNotebookJob(sgqlc.types.Type):
    """Create Databricks directory, upload the collection notebook and
    setup a job.
    """

    __schema__ = schema
    __field_names__ = ("databricks",)
    databricks = sgqlc.types.Field("DatabricksJobResponse", graphql_name="databricks")
    """The Databricks resources which were created."""


class CreateDatabricksSecret(sgqlc.types.Type):
    """Create Databricks scope and secret for an integration key."""

    __schema__ = schema
    __field_names__ = ("success", "scope_name", "secret_name")
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """Indicates whether the operation was completed successfully."""

    scope_name = sgqlc.types.Field(String, graphql_name="scopeName")
    """Scope name that the secret was created with"""

    secret_name = sgqlc.types.Field(String, graphql_name="secretName")
    """Name of the secret that was created"""


class CreateDatadogIncidentForAlert(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("datadog_incident",)
    datadog_incident = sgqlc.types.Field("DatadogIncident", graphql_name="datadogIncident")
    """The created Datadog incident"""


class CreateDatadogIntegration(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("datadog_integration",)
    datadog_integration = sgqlc.types.Field(
        "DatadogIntegrationOutput", graphql_name="datadogIntegration"
    )
    """The integration"""


class CreateIntegrationKey(sgqlc.types.Type):
    """Create an integration key"""

    __schema__ = schema
    __field_names__ = ("key",)
    key = sgqlc.types.Field("IntegrationKey", graphql_name="key")
    """Integration key id and secret (only available once)."""


class CreateJiraIntegration(sgqlc.types.Type):
    """Create a Jira integration"""

    __schema__ = schema
    __field_names__ = ("jira_integration",)
    jira_integration = sgqlc.types.Field("JiraIntegrationOutput", graphql_name="jiraIntegration")
    """The integration that was created"""


class CreateJiraTicketForAlert(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("jira_ticket",)
    jira_ticket = sgqlc.types.Field("JiraTicketOutput", graphql_name="jiraTicket")
    """The created Jira ticket"""


class CreateJiraTicketForIncident(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("jira_ticket",)
    jira_ticket = sgqlc.types.Field("JiraTicketOutput", graphql_name="jiraTicket")
    """The created Jira ticket"""


class CreateLogsIntegration(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("logs_integration",)
    logs_integration = sgqlc.types.Field("LogsIntegrationOutput", graphql_name="logsIntegration")
    """The integration that was created"""


class CreateMcpIntegrationKey(sgqlc.types.Type):
    """Create an MCP integration key"""

    __schema__ = schema
    __field_names__ = ("key",)
    key = sgqlc.types.Field("IntegrationKey", graphql_name="key")
    """Integration key id and secret (only available once)."""


class CreateOpsgenieIntegration(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("opsgenie_integration",)
    opsgenie_integration = sgqlc.types.Field(
        "OpsgenieIntegrationOutput", graphql_name="opsgenieIntegration"
    )
    """The integration"""


class CreateOrUpdateAgent(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("agent_id", "validation_result")
    agent_id = sgqlc.types.Field(UUID, graphql_name="agentId")
    """The UUID of the agent that was created or updated."""

    validation_result = sgqlc.types.Field(
        "TestCredentialsV2Response", graphql_name="validationResult"
    )
    """Result validating the provided parameters."""


class CreateOrUpdateAgentMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("agent_monitor", "queries")
    agent_monitor = sgqlc.types.Field("MetricMonitoring", graphql_name="agentMonitor")

    queries = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="queries"
    )
    """SQL queries that will be run by the monitor on each execution."""


class CreateOrUpdateAgentTraceTable(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("agent_trace_table",)
    agent_trace_table = sgqlc.types.Field("AgentTraceTable", graphql_name="agentTraceTable")


class CreateOrUpdateAlationIntegration(sgqlc.types.Type):
    """Create or update Alation integration"""

    __schema__ = schema
    __field_names__ = ("alation_integration",)
    alation_integration = sgqlc.types.Field("AlationIntegration", graphql_name="alationIntegration")


class CreateOrUpdateAlationTableFlag(sgqlc.types.Type):
    """Create or update Alation flag on a table. The flag could be a
    warning or a deprecation.
    """

    __schema__ = schema
    __field_names__ = ("alation_flag_ids",)
    alation_flag_ids = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name="alationFlagIds")
    """List of IDs of flags created. This list will have more than one
    entry when multiple tables matched the input full_table_id.
    """


class CreateOrUpdateAlertComment(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("comment_event",)
    comment_event = sgqlc.types.Field("Event", graphql_name="commentEvent")
    """The alert comment event."""


class CreateOrUpdateAudience(sgqlc.types.Type):
    """Create a notification audience"""

    __schema__ = schema
    __field_names__ = ("audience",)
    audience = sgqlc.types.Field("NotificationAudience", graphql_name="audience")


class CreateOrUpdateAudienceNotificationSetting(sgqlc.types.Type):
    """Create or update an audience notification setting"""

    __schema__ = schema
    __field_names__ = ("notification_setting",)
    notification_setting = sgqlc.types.Field(
        "NotificationSetting", graphql_name="notificationSetting"
    )
    """Setting that was created or updated"""


class CreateOrUpdateAudienceRoutingRule(sgqlc.types.Type):
    """Create or update an audience routing rule"""

    __schema__ = schema
    __field_names__ = ("routing_rule",)
    routing_rule = sgqlc.types.Field("NotificationRoutingRule", graphql_name="routingRule")
    """Routing rule that was created or updated"""


class CreateOrUpdateAuthProvisioning(sgqlc.types.Type):
    """Create or update an account's authorization provisioning
    configuration.
    """

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="success")


class CreateOrUpdateAuthorizationGroup(sgqlc.types.Type):
    """Create or update an authorization group."""

    __schema__ = schema
    __field_names__ = ("authorization_group",)
    authorization_group = sgqlc.types.Field(
        AuthorizationGroupOutput, graphql_name="authorizationGroup"
    )
    """Created or updated authorization group."""


class CreateOrUpdateCatalogObjectMetadata(sgqlc.types.Type):
    """Create or update an asset's metadata"""

    __schema__ = schema
    __field_names__ = ("catalog_object_metadata",)
    catalog_object_metadata = sgqlc.types.Field(
        "CatalogObjectMetadata", graphql_name="catalogObjectMetadata"
    )
    """Object metadata created or updated"""


class CreateOrUpdateCollibraIntegration(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("collibra_integration",)
    collibra_integration = sgqlc.types.Field(
        "CollibraIntegration", graphql_name="collibraIntegration"
    )


class CreateOrUpdateComparisonMonitor(sgqlc.types.Type):
    """Create or update a comparison monitor"""

    __schema__ = schema
    __field_names__ = ("comparison_monitor", "yaml", "source_queries", "target_queries")
    comparison_monitor = sgqlc.types.Field(
        "ComparisonMonitorResponse", graphql_name="comparisonMonitor"
    )

    yaml = sgqlc.types.Field(String, graphql_name="yaml")

    source_queries = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="sourceQueries"
    )
    """SQL queries that will be run by the monitor for source on each
    execution.
    """

    target_queries = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="targetQueries"
    )
    """SQL queries that will be run by the monitor for target on each
    execution.
    """


class CreateOrUpdateComparisonRule(sgqlc.types.Type):
    """Create or update a comparison rule"""

    __schema__ = schema
    __field_names__ = ("custom_rule", "yaml", "queries")
    custom_rule = sgqlc.types.Field("CustomRule", graphql_name="customRule")

    yaml = sgqlc.types.Field(String, graphql_name="yaml")

    queries = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="queries"
    )
    """SQL queries that will be run by the monitor on each execution."""


class CreateOrUpdateCustomMetricRule(sgqlc.types.Type):
    """Create or update a custom metric rule"""

    __schema__ = schema
    __field_names__ = ("custom_rule",)
    custom_rule = sgqlc.types.Field("CustomRule", graphql_name="customRule")


class CreateOrUpdateCustomRule(sgqlc.types.Type):
    """DEPRECATED. Depending on the type of monitor you would like to
    create, use CreateOrUpdateVolumeRule,
    CreateOrUpdateFreshnessCustomRule, CreateOrUpdateCustomSqlRule,
    CreateOrUpdateComparisonRule or CreateOrUpdateQueryPerfRule
    instead.
    """

    __schema__ = schema
    __field_names__ = ("custom_rule",)
    custom_rule = sgqlc.types.Field("CustomRule", graphql_name="customRule")


class CreateOrUpdateCustomSQLTemplate(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("custom_sql_template",)
    custom_sql_template = sgqlc.types.Field("CustomSQLTemplate", graphql_name="customSqlTemplate")


class CreateOrUpdateCustomSqlRule(sgqlc.types.Type):
    """Create or update a custom SQL rule"""

    __schema__ = schema
    __field_names__ = ("custom_rule", "yaml", "queries")
    custom_rule = sgqlc.types.Field("CustomRule", graphql_name="customRule")

    yaml = sgqlc.types.Field(String, graphql_name="yaml")

    queries = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="queries"
    )
    """SQL queries that will be run by the monitor on each execution."""


class CreateOrUpdateDataExplorerComparisonDashboardMutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("data_explorer_comparison_dashboard",)
    data_explorer_comparison_dashboard = sgqlc.types.Field(
        "DataExplorerComparisonDashboardType", graphql_name="dataExplorerComparisonDashboard"
    )


class CreateOrUpdateDataExplorerDashboardMutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("data_explorer_dashboard",)
    data_explorer_dashboard = sgqlc.types.Field(
        "DataExplorerDashboardType", graphql_name="dataExplorerDashboard"
    )


class CreateOrUpdateDataMaintenanceEntry(sgqlc.types.Type):
    """Creates or updates a data maintenance period"""

    __schema__ = schema
    __field_names__ = ("entry",)
    entry = sgqlc.types.Field("DataMaintenanceEntry", graphql_name="entry")


class CreateOrUpdateDataOperationsDashboardMutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("data_operations_dashboard",)
    data_operations_dashboard = sgqlc.types.Field(
        "DataOperationsDashboardOutput", graphql_name="dataOperationsDashboard"
    )
    """Created or updated data operations dashboard"""


class CreateOrUpdateDataProduct(sgqlc.types.Type):
    """Create or update a data product"""

    __schema__ = schema
    __field_names__ = ("data_product",)
    data_product = sgqlc.types.Field("DataProduct", graphql_name="dataProduct")
    """Created or updated data product"""


class CreateOrUpdateDataProductV2(sgqlc.types.Type):
    """Create or update a data product"""

    __schema__ = schema
    __field_names__ = ("data_product",)
    data_product = sgqlc.types.Field("DataProduct", graphql_name="dataProduct")
    """Created or updated data product"""


class CreateOrUpdateDomain(sgqlc.types.Type):
    """Create or update a domain"""

    __schema__ = schema
    __field_names__ = ("domain",)
    domain = sgqlc.types.Field("DomainOutput", graphql_name="domain")
    """Created or updated domain"""


class CreateOrUpdateFieldQualityRule(sgqlc.types.Type):
    """Create or update a field quality rule"""

    __schema__ = schema
    __field_names__ = ("custom_rule",)
    custom_rule = sgqlc.types.Field("CustomRule", graphql_name="customRule")


class CreateOrUpdateFreshnessCustomRule(sgqlc.types.Type):
    """Create or update a freshness custom rule"""

    __schema__ = schema
    __field_names__ = ("custom_rule",)
    custom_rule = sgqlc.types.Field("CustomRule", graphql_name="customRule")


class CreateOrUpdateIncidentComment(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("comment_event",)
    comment_event = sgqlc.types.Field("Event", graphql_name="commentEvent")
    """The incident comment event."""


class CreateOrUpdateJsonSchemaMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("json_schema_monitor", "yaml", "queries")
    json_schema_monitor = sgqlc.types.Field("MetricMonitoring", graphql_name="jsonSchemaMonitor")

    yaml = sgqlc.types.Field(String, graphql_name="yaml")

    queries = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="queries"
    )
    """SQL queries that will be run by the monitor on each execution."""


class CreateOrUpdateLineageEdge(sgqlc.types.Type):
    """Create or update a lineage edge"""

    __schema__ = schema
    __field_names__ = ("edge",)
    edge = sgqlc.types.Field("LineageGraphEdge", graphql_name="edge")


class CreateOrUpdateLineageNode(sgqlc.types.Type):
    """Create or update a lineage node"""

    __schema__ = schema
    __field_names__ = ("node",)
    node = sgqlc.types.Field("LineageGraphNode", graphql_name="node")


class CreateOrUpdateLineageNodeBlockPattern(sgqlc.types.Type):
    """Create or update a node block pattern"""

    __schema__ = schema
    __field_names__ = ("pattern",)
    pattern = sgqlc.types.Field("LineageNodeBlockPattern", graphql_name="pattern")


class CreateOrUpdateLineageNodeCollapsingRule(sgqlc.types.Type):
    """Create or update a node collapsing rule"""

    __schema__ = schema
    __field_names__ = ("rule",)
    rule = sgqlc.types.Field("LineageNodeCollapsingRule", graphql_name="rule")
    """Collapsing rule that was created or updated"""


class CreateOrUpdateLineageNodeReplacementRule(sgqlc.types.Type):
    """Create or update a node replacement rule"""

    __schema__ = schema
    __field_names__ = ("rule",)
    rule = sgqlc.types.Field("LineageNodeReplacementRule", graphql_name="rule")
    """Replacement rule that was created or updated"""


class CreateOrUpdateMetricMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("metric_monitor", "yaml", "queries")
    metric_monitor = sgqlc.types.Field("MetricMonitoring", graphql_name="metricMonitor")

    yaml = sgqlc.types.Field(String, graphql_name="yaml")

    queries = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="queries"
    )
    """SQL queries that will be run by the monitor on each execution."""


class CreateOrUpdateMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("monitor",)
    monitor = sgqlc.types.Field("MetricMonitoring", graphql_name="monitor")


class CreateOrUpdateMonitorLabel(sgqlc.types.Type):
    """Create or update a monitor label"""

    __schema__ = schema
    __field_names__ = ("monitor_label",)
    monitor_label = sgqlc.types.Field("MonitorLabelObject", graphql_name="monitorLabel")
    """The created monitor label"""


class CreateOrUpdateMonteCarloConfigTemplate(sgqlc.types.Type):
    """Create or update a Monte Carlo Config Template"""

    __schema__ = schema
    __field_names__ = ("response",)
    response = sgqlc.types.Field("MonteCarloConfigTemplateUpdateResponse", graphql_name="response")
    """Response"""


class CreateOrUpdateMonteCarloConfigTemplateAsync(sgqlc.types.Type):
    """Create or update a Monte Carlo Config Template asynchronously"""

    __schema__ = schema
    __field_names__ = ("response",)
    response = sgqlc.types.Field(
        "MonteCarloConfigTemplateUpdateAsyncResponse", graphql_name="response"
    )
    """Response"""


class CreateOrUpdateNotificationSetting(sgqlc.types.Type):
    """Create or update a notification setting"""

    __schema__ = schema
    __field_names__ = ("notification_setting",)
    notification_setting = sgqlc.types.Field(
        AccountNotificationSetting, graphql_name="notificationSetting"
    )
    """Setting that was created or updated"""


class CreateOrUpdateObjectProperty(sgqlc.types.Type):
    """Create or update properties (tags) for objects (e.g. tables,
    fields, etc.)
    """

    __schema__ = schema
    __field_names__ = ("object_property",)
    object_property = sgqlc.types.Field("ObjectProperty", graphql_name="objectProperty")
    """Property created or updated"""


class CreateOrUpdateQueryPerfRule(sgqlc.types.Type):
    """Create or update query performance rule/monitor.
    There must be exactly (3) comparisons, which follow this format:
    {                 "comparisonType": "QUERY_PERFORMANCE",
    "operator": "GT",                 "metric": "runtime",
    "threshold": <THRESHOLD IN SECONDS>,             },             {
    "comparisonType": "QUERY_PERFORMANCE",                 "operator":
    "GT",                 "metric": "runtime_change",
    "threshold": <THRESHOLD AS PERCENTAGE>,
    "baselineAggFunction": <MEDIAN|AVG>,
    "thresholdLookbackDataPoints": <NUMBER OF DATA POINTS TO INCLUDE
    IN LOOKBACK RANGE>,             },             {
    "comparisonType": "QUERY_PERFORMANCE",                 "operator":
    "GT",                 "metric": "consecutive_breach_count",
    "threshold": <NUMBER OF CONSECUTIVE BREACHES TO TRIGGER AN ALERT>,
    }
    """

    __schema__ = schema
    __field_names__ = ("custom_rule", "yaml")
    custom_rule = sgqlc.types.Field("CustomRule", graphql_name="customRule")

    yaml = sgqlc.types.Field(String, graphql_name="yaml")


class CreateOrUpdateRecipientName(sgqlc.types.Type):
    """Create or update a recipient's custom name"""

    __schema__ = schema
    __field_names__ = ("recipient", "name")
    recipient = sgqlc.types.Field(String, graphql_name="recipient")

    name = sgqlc.types.Field(String, graphql_name="name")


class CreateOrUpdateResource(sgqlc.types.Type):
    """Create or update a resource"""

    __schema__ = schema
    __field_names__ = ("resource",)
    resource = sgqlc.types.Field("Resource", graphql_name="resource")


class CreateOrUpdateSamlIdentityProvider(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("account",)
    account = sgqlc.types.Field(Account, graphql_name="account")


class CreateOrUpdateServiceApiToken(sgqlc.types.Type):
    """Generate a service API Access Token"""

    __schema__ = schema
    __field_names__ = ("access_token",)
    access_token = sgqlc.types.Field(AccessToken, graphql_name="accessToken")


class CreateOrUpdateTableMonitor(sgqlc.types.Type):
    """Create or update a table monitor"""

    __schema__ = schema
    __field_names__ = ("table_monitor", "yaml")
    table_monitor = sgqlc.types.Field("TableMonitor", graphql_name="tableMonitor")

    yaml = sgqlc.types.Field(String, graphql_name="yaml")
    """YAML representation of the monitor (only returned for dry_run)"""


class CreateOrUpdateTagAssignmentsMutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """Indicates if the assignments are created successfully."""


class CreateOrUpdateTagMutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("tag_object",)
    tag_object = sgqlc.types.Field("TagObjectOutput", graphql_name="tagObject")
    """Created or updated data operations dashboard"""


class CreateOrUpdateUserSettings(sgqlc.types.Type):
    """Create a new user-specific setting"""

    __schema__ = schema
    __field_names__ = ("user_settings",)
    user_settings = sgqlc.types.Field("UserSettings", graphql_name="userSettings")
    """Response"""


class CreateOrUpdateUserSettingsBatch(sgqlc.types.Type):
    """Create or update a list of user-specific settings"""

    __schema__ = schema
    __field_names__ = ("user_settings",)
    user_settings = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("UserSettings")), graphql_name="userSettings"
    )
    """List of updated settings"""


class CreateOrUpdateValidation(sgqlc.types.Type):
    """Create or update a validation"""

    __schema__ = schema
    __field_names__ = ("validation", "yaml", "queries")
    validation = sgqlc.types.Field("CustomRule", graphql_name="validation")

    yaml = sgqlc.types.Field(String, graphql_name="yaml")

    queries = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="queries"
    )
    """SQL queries that will be run by the monitor on each execution."""


class CreateOrUpdateVolumeRule(sgqlc.types.Type):
    """Create or update a Volume Rule"""

    __schema__ = schema
    __field_names__ = ("custom_rule",)
    custom_rule = sgqlc.types.Field("CustomRule", graphql_name="customRule")


class CreatePagerDutyServiceIntegration(sgqlc.types.Type):
    """Create a PagerDuty service integration"""

    __schema__ = schema
    __field_names__ = ("pagerduty_service_integration",)
    pagerduty_service_integration = sgqlc.types.Field(
        "PagerDutyServiceIntegrationOutput", graphql_name="pagerdutyServiceIntegration"
    )
    """The integration that was created"""


class CreateServiceNowIncidentForAlert(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("servicenow_incident",)
    servicenow_incident = sgqlc.types.Field(
        "ServiceNowIncidentOutput", graphql_name="servicenowIncident"
    )
    """The created ServiceNow incident"""


class CreateServiceNowIntegration(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("servicenow_integration",)
    servicenow_integration = sgqlc.types.Field(
        "ServiceNowIntegrationOutput", graphql_name="servicenowIntegration"
    )
    """The integration that was created"""


class CreateSharedQuery(sgqlc.types.Type):
    """Create a new shared API Explorer GraphQL query or mutation"""

    __schema__ = schema
    __field_names__ = ("link",)
    link = sgqlc.types.Field(String, graphql_name="link")
    """Link to newly shared query"""


class CreateTableauAssetWarning(sgqlc.types.Type):
    """Creates a warning on an asset."""

    __schema__ = schema
    __field_names__ = ("tableau_warning_id",)
    tableau_warning_id = sgqlc.types.Field(String, graphql_name="tableauWarningId")
    """ID of the created warning in Tableau ID space."""


class CreateUnifiedUserAssignment(sgqlc.types.Type):
    """Associate a UnifiedUser with a CatalogObject"""

    __schema__ = schema
    __field_names__ = ("unified_user_assignment",)
    unified_user_assignment = sgqlc.types.Field(
        "UnifiedUserAssignment", graphql_name="unifiedUserAssignment"
    )


class CreateWebexIntegration(sgqlc.types.Type):
    """Create a Webex integration"""

    __schema__ = schema
    __field_names__ = ("webex_integration",)
    webex_integration = sgqlc.types.Field("WebexIntegrationOutput", graphql_name="webexIntegration")
    """The integration that was created"""


class CreatorDimension(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("full_name", "email", "user_id")
    full_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="fullName")

    email = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="email")

    user_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="userId")


class CreatorMonitorCount(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("creator", "count")
    creator = sgqlc.types.Field(sgqlc.types.non_null(CreatorDimension), graphql_name="creator")

    count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="count")


class CreatorMonitorCountsResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("results", "total_count", "offset", "limit")
    results = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(CreatorMonitorCount)), graphql_name="results"
    )

    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="totalCount")

    offset = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="offset")

    limit = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="limit")


class CustomComparisonMetric(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid", "display_name", "source_sql_expression", "target_sql_expression")
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")

    display_name = sgqlc.types.Field(String, graphql_name="displayName")

    source_sql_expression = sgqlc.types.Field(String, graphql_name="sourceSqlExpression")

    target_sql_expression = sgqlc.types.Field(String, graphql_name="targetSqlExpression")


class CustomMetric(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "uuid",
        "display_name",
        "sql_expression",
        "metric_name",
        "source_sql_expression",
        "target_sql_expression",
    )
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """UUID to identify the custom metric"""

    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")
    """Display name of the custom metric"""

    sql_expression = sgqlc.types.Field(String, graphql_name="sqlExpression")
    """SQL expression to evaluate for the custom metric"""

    metric_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="metricName")
    """Metric name that should be used to get the values loaded for the
    custom metric
    """

    source_sql_expression = sgqlc.types.Field(String, graphql_name="sourceSqlExpression")
    """Source SQL expression to evaluate for the custom comparison metric"""

    target_sql_expression = sgqlc.types.Field(String, graphql_name="targetSqlExpression")
    """Target SQL expression to evaluate for the custom comparison metric"""


class CustomMetricQuery(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("query",)
    query = sgqlc.types.Field(String, graphql_name="query")
    """SQL query to evaluate the custom metric"""


class CustomRuleComparison(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "comparison_type",
        "full_table_id",
        "full_table_ids",
        "field",
        "fields",
        "metric",
        "custom_metric",
        "operator",
        "threshold",
        "upper_threshold",
        "lower_threshold",
        "baseline_agg_function",
        "baseline_interval_minutes",
        "is_threshold_relative",
        "is_freshness_from_metadata",
        "threshold_lookback_minutes",
        "threshold_ref",
        "threshold_sensitivity",
        "min_buffer",
        "max_buffer",
        "number_of_agg_periods",
        "data_collection_interval_minutes",
        "rule_interval_minutes",
        "threshold_lookback_data_points",
        "source_metric",
        "target_metric",
        "source_field",
        "target_field",
    )
    comparison_type = sgqlc.types.Field(
        sgqlc.types.non_null(ComparisonType), graphql_name="comparisonType"
    )
    """Type of comparison"""

    full_table_id = sgqlc.types.Field(String, graphql_name="fullTableId")

    full_table_ids = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="fullTableIds")

    field = sgqlc.types.Field(String, graphql_name="field")

    fields = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="fields"
    )

    metric = sgqlc.types.Field(String, graphql_name="metric")

    custom_metric = sgqlc.types.Field(CustomMetric, graphql_name="customMetric")
    """Custom metric, if defined with a custom metric"""

    operator = sgqlc.types.Field(
        sgqlc.types.non_null(CustomRuleComparisonOperator), graphql_name="operator"
    )
    """Comparison operator"""

    threshold = sgqlc.types.Field(Float, graphql_name="threshold")
    """Threshold value"""

    upper_threshold = sgqlc.types.Field(Float, graphql_name="upperThreshold")
    """Upper threshold value"""

    lower_threshold = sgqlc.types.Field(Float, graphql_name="lowerThreshold")
    """Lower threshold value"""

    baseline_agg_function = sgqlc.types.Field(
        AggregationFunction, graphql_name="baselineAggFunction"
    )
    """Function used to aggregate historical data points to calculate
    baseline
    """

    baseline_interval_minutes = sgqlc.types.Field(Int, graphql_name="baselineIntervalMinutes")
    """Time interval to aggregate over to calculate baseline."""

    is_threshold_relative = sgqlc.types.Field(Boolean, graphql_name="isThresholdRelative")
    """True, if threshold is a relative percentage change of baseline.
    False, if threshold is absolute change
    """

    is_freshness_from_metadata = sgqlc.types.Field(Boolean, graphql_name="isFreshnessFromMetadata")
    """True if freshness is calculated from metadata."""

    threshold_lookback_minutes = sgqlc.types.Field(Int, graphql_name="thresholdLookbackMinutes")
    """Time to look back for rules which compare current and past values."""

    threshold_ref = sgqlc.types.Field(String, graphql_name="thresholdRef")
    """Key used to retrieve the threshold values from external source"""

    threshold_sensitivity = sgqlc.types.Field(
        SensitivityLevels, graphql_name="thresholdSensitivity"
    )
    """Sensitivity for automated thresholds"""

    min_buffer = sgqlc.types.Field("ThresholdModifier", graphql_name="minBuffer")
    """The lower bound buffer to modify the alert threshold"""

    max_buffer = sgqlc.types.Field("ThresholdModifier", graphql_name="maxBuffer")
    """The upper bound buffer to modify the alert threshold"""

    number_of_agg_periods = sgqlc.types.Field(Int, graphql_name="numberOfAggPeriods")
    """The number of periods to use in the aggregate comparison for
    Volume Growth comparisons.
    """

    data_collection_interval_minutes = sgqlc.types.Field(
        Int, graphql_name="dataCollectionIntervalMinutes"
    )
    """Time interval of data collection for the rule."""

    rule_interval_minutes = sgqlc.types.Field(Int, graphql_name="ruleIntervalMinutes")
    """Time interval for the rule evaluation."""

    threshold_lookback_data_points = sgqlc.types.Field(
        Int, graphql_name="thresholdLookbackDataPoints"
    )
    """Number of data points to look back for rules which compare current
    and past values.
    """

    source_metric = sgqlc.types.Field(String, graphql_name="sourceMetric")
    """Name of source metric"""

    target_metric = sgqlc.types.Field(String, graphql_name="targetMetric")
    """Name of target metric"""

    source_field = sgqlc.types.Field(String, graphql_name="sourceField")
    """Name of source field"""

    target_field = sgqlc.types.Field(String, graphql_name="targetField")
    """Name of target field"""


class CustomRuleConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("CustomRuleEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class CustomRuleEdge(sgqlc.types.Type):
    """A Relay edge containing a `CustomRule` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("CustomRule", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class CustomRuleExecutionAnalytics(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("date", "runs", "passes", "breaches")
    date = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="date")
    """Date for the analytics, if grouped by week/month it has the start
    of each grouping period
    """

    runs = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="runs")
    """Number of runs"""

    passes = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="passes")
    """Number of passes"""

    breaches = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="breaches")
    """Number of breaches"""


class CustomRuleQueryConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("CustomRuleQueryEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class CustomRuleQueryEdge(sgqlc.types.Type):
    """A Relay edge containing a `CustomRuleQuery` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("CustomRuleQuery", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class CustomRuleSqlBlocks(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("alert_condition", "where_condition", "group_by")
    alert_condition = sgqlc.types.Field(
        sgqlc.types.non_null("FilterGroup"), graphql_name="alertCondition"
    )

    where_condition = sgqlc.types.Field(
        sgqlc.types.non_null("FilterGroup"), graphql_name="whereCondition"
    )

    group_by = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(FilterValueInterface))),
        graphql_name="groupBy",
    )


class CustomSQLOutputDownload(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("sampling_disabled", "download_url")
    sampling_disabled = sgqlc.types.Field(Boolean, graphql_name="samplingDisabled")

    download_url = sgqlc.types.Field(String, graphql_name="downloadUrl")
    """Link to download the query response which expires in 5 minutes."""


class CustomSQLOutputSample(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "columns",
        "rows",
        "sampling_disabled",
        "next_file_index",
        "total_samples_size",
    )
    columns = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="columns")

    rows = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.list_of(String)), graphql_name="rows")

    sampling_disabled = sgqlc.types.Field(Boolean, graphql_name="samplingDisabled")

    next_file_index = sgqlc.types.Field(Int, graphql_name="nextFileIndex")
    """Next file index to retrieve."""

    total_samples_size = sgqlc.types.Field(Int, graphql_name="totalSamplesSize")
    """Total number of samples retrieved."""


class CustomSQLTemplateConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges", "total_count", "edge_count")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("CustomSQLTemplateEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""

    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")

    edge_count = sgqlc.types.Field(Int, graphql_name="edgeCount")


class CustomSQLTemplateEdge(sgqlc.types.Type):
    """A Relay edge containing a `CustomSQLTemplate` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("CustomSQLTemplate", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class CustomUserConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("CustomUserEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class CustomUserEdge(sgqlc.types.Type):
    """A Relay edge containing a `CustomUser` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("CustomUser", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DODCriteriaOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "time_range",
        "data_product_uuids",
        "audience_uuids",
        "domain_uuids",
        "tags",
        "monitor_tags",
    )
    time_range = sgqlc.types.Field(
        sgqlc.types.non_null("TimeRangeOutput"), graphql_name="timeRange"
    )
    """Time range criteria."""

    data_product_uuids = sgqlc.types.Field(
        sgqlc.types.list_of(UUID), graphql_name="dataProductUuids"
    )
    """Data Product UUIDs."""

    audience_uuids = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name="audienceUuids")
    """Audience UUIDs."""

    domain_uuids = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name="domainUuids")
    """Domain UUIDs."""

    tags = sgqlc.types.Field(sgqlc.types.list_of("TagKeyValuePairOutput"), graphql_name="tags")
    """Tags."""

    monitor_tags = sgqlc.types.Field(
        sgqlc.types.list_of("TagKeyValuePairOutput"), graphql_name="monitorTags"
    )
    """Monitor tags filters."""


class DailyUsage(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("date", "requests_used", "requests_remaining")
    date = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name="date")

    requests_used = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="requestsUsed")

    requests_remaining = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="requestsRemaining"
    )


class DataAssetDashboard(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "data_sources_count",
        "project_count",
        "schema_count",
        "table_count",
        "view_count",
        "external_table_count",
        "wildcard_table_count",
    )
    data_sources_count = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="dataSourcesCount"
    )
    """The number of data sources monitored"""

    project_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="projectCount")
    """The number of projects monitored"""

    schema_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="schemaCount")
    """The number of schemas monitored"""

    table_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="tableCount")
    """The number of tables monitored"""

    view_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="viewCount")
    """The number of views monitored"""

    external_table_count = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="externalTableCount"
    )
    """The number of external tables monitored"""

    wildcard_table_count = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="wildcardTableCount"
    )
    """The number of wildcard tables monitored"""


class DataCollector(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "account",
        "uuid",
        "api_gateway_id",
        "kinesis_endpoint_id",
        "cloudwatch_log_endpoint_id",
        "cross_account_role_arn",
        "stack_arn",
        "customer_aws_account_id",
        "customer_aws_region",
        "template_launch_url",
        "template_provider",
        "template_variant",
        "template_version",
        "template_parameters",
        "code_version",
        "kinesis_access_role",
        "active",
        "last_updated",
        "is_custom",
        "oauth_credentials_s3_key",
        "release_channel",
        "warehouses",
        "bi_container",
        "etl_container",
        "agents",
        "supports_data_store_agents",
        "supports_remote_agents",
        "collection_node",
        "collection_storage",
        "deployment_type",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    account = sgqlc.types.Field(sgqlc.types.non_null(Account), graphql_name="account")

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")

    api_gateway_id = sgqlc.types.Field(String, graphql_name="apiGatewayId")

    kinesis_endpoint_id = sgqlc.types.Field(String, graphql_name="kinesisEndpointId")

    cloudwatch_log_endpoint_id = sgqlc.types.Field(String, graphql_name="cloudwatchLogEndpointId")

    cross_account_role_arn = sgqlc.types.Field(String, graphql_name="crossAccountRoleArn")

    stack_arn = sgqlc.types.Field(String, graphql_name="stackArn")

    customer_aws_account_id = sgqlc.types.Field(String, graphql_name="customerAwsAccountId")

    customer_aws_region = sgqlc.types.Field(String, graphql_name="customerAwsRegion")

    template_launch_url = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="templateLaunchUrl"
    )

    template_provider = sgqlc.types.Field(String, graphql_name="templateProvider")

    template_variant = sgqlc.types.Field(String, graphql_name="templateVariant")

    template_version = sgqlc.types.Field(String, graphql_name="templateVersion")

    template_parameters = sgqlc.types.Field(JSONString, graphql_name="templateParameters")

    code_version = sgqlc.types.Field(String, graphql_name="codeVersion")

    kinesis_access_role = sgqlc.types.Field(String, graphql_name="kinesisAccessRole")

    active = sgqlc.types.Field(Boolean, graphql_name="active")

    last_updated = sgqlc.types.Field(DateTime, graphql_name="lastUpdated")

    is_custom = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isCustom")

    oauth_credentials_s3_key = sgqlc.types.Field(String, graphql_name="oauthCredentialsS3Key")

    release_channel = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="releaseChannel")
    """[PENDING DEPRECATION WARNING] This field only applies to legacy
    data collectors that are updated via the legacy release train. V2
    collectors (CaaS) are updated via the CaaS release train, where
    release channels are tracked in the CollectionNodeModel. See
    https://mc-d.io/trains for more details on the CaaS release train.
    """

    warehouses = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Warehouse"))),
        graphql_name="warehouses",
    )

    bi_container = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(BiContainer))),
        graphql_name="biContainer",
    )

    etl_container = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("EtlContainer"))),
        graphql_name="etlContainer",
    )

    agents = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(Agent))),
        graphql_name="agents",
    )
    """Agents associated with the data collector"""

    supports_data_store_agents = sgqlc.types.Field(Boolean, graphql_name="supportsDataStoreAgents")
    """Indicates whether the data collector's version supports data store
    agents
    """

    supports_remote_agents = sgqlc.types.Field(Boolean, graphql_name="supportsRemoteAgents")
    """Indicates whether the data collector's version supports remote
    agents
    """

    collection_node = sgqlc.types.Field(CollectionNode, graphql_name="collectionNode")
    """CaaS node associated to this DC"""

    collection_storage = sgqlc.types.Field(CollectionStorage, graphql_name="collectionStorage")
    """CaaS storage associated to this DC"""

    deployment_type = sgqlc.types.Field(
        DataCollectorModelDeploymentTypeEnum, graphql_name="deploymentType"
    )
    """Deprecated - use getPlatformServices.deployment.deploymentType
    instead
    """


class DataCollectorSchedule(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "uuid",
        "dc_id",
        "resource_id",
        "connection_id",
        "project_id",
        "output_stream",
        "output_s3_bucket",
        "last_job_id",
        "job_type",
        "schedule_type",
        "created_on",
        "override",
        "skip",
        "last_run",
        "interval_in_seconds",
        "interval_crontab",
        "interval_crontab_lag_minutes",
        "interval_crontab_day_or",
        "start_time",
        "prev_execution_time",
        "next_execution_time",
        "timezone",
        "dynamic_schedule_mcons",
        "is_dynamic_schedule_poller",
        "min_interval_seconds",
        "is_automatic",
        "friendly_name",
        "notes",
        "limits",
        "is_deleted",
        "delete_reason",
        "skip_reason",
        "queued_at",
        "metric_monitors",
        "custom_rules",
        "agent_trace_tables",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")

    dc_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="dcId")

    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="resourceId")

    connection_id = sgqlc.types.Field(UUID, graphql_name="connectionId")

    project_id = sgqlc.types.Field(String, graphql_name="projectId")

    output_stream = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="outputStream")

    output_s3_bucket = sgqlc.types.Field(String, graphql_name="outputS3Bucket")

    last_job_id = sgqlc.types.Field(String, graphql_name="lastJobId")

    job_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="jobType")

    schedule_type = sgqlc.types.Field(
        sgqlc.types.non_null(DataCollectorScheduleModelScheduleType), graphql_name="scheduleType"
    )

    created_on = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdOn")

    override = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="override")

    skip = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="skip")

    last_run = sgqlc.types.Field(DateTime, graphql_name="lastRun")

    interval_in_seconds = sgqlc.types.Field(Int, graphql_name="intervalInSeconds")

    interval_crontab = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="intervalCrontab"
    )

    interval_crontab_lag_minutes = sgqlc.types.Field(Int, graphql_name="intervalCrontabLagMinutes")

    interval_crontab_day_or = sgqlc.types.Field(Boolean, graphql_name="intervalCrontabDayOr")
    """If true, use default cron behavior and run when day-of-month OR
    day-of-week match. If false, use alternate behavior and run when
    day-of-month AND day-of-week match.
    """

    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")

    prev_execution_time = sgqlc.types.Field(DateTime, graphql_name="prevExecutionTime")

    next_execution_time = sgqlc.types.Field(DateTime, graphql_name="nextExecutionTime")

    timezone = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="timezone")

    dynamic_schedule_mcons = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="dynamicScheduleMcons"
    )
    """Mcons of tables that trigger the schedule on update"""

    is_dynamic_schedule_poller = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="isDynamicSchedulePoller"
    )
    """If true, this schedule is for used to poll forfreshness to trigger
    dynamically scheduled jobs
    """

    min_interval_seconds = sgqlc.types.Field(Int, graphql_name="minIntervalSeconds")
    """Minimum interval between job executions. Used to preventa dynamic
    scheduled job from executing too frequently
    """

    is_automatic = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isAutomatic")
    """If true, it was scheduled automatically based on job configuration"""

    friendly_name = sgqlc.types.Field(String, graphql_name="friendlyName")

    notes = sgqlc.types.Field(String, graphql_name="notes")

    limits = sgqlc.types.Field(JSONString, graphql_name="limits")

    is_deleted = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isDeleted")

    delete_reason = sgqlc.types.Field(
        DataCollectorScheduleModelDeleteReason, graphql_name="deleteReason"
    )

    skip_reason = sgqlc.types.Field(DataCollectorScheduleModelSkipReason, graphql_name="skipReason")
    """This field will be set when the schedule is set to skip=true froma
    manual action or when the connection is disabled.
    """

    queued_at = sgqlc.types.Field(DateTime, graphql_name="queuedAt")
    """The last time this schedule was added to the execution queue"""

    metric_monitors = sgqlc.types.Field(
        sgqlc.types.non_null(ComparisonMonitorResponseConnection),
        graphql_name="metricMonitors",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                ("type", sgqlc.types.Arg(String, graphql_name="type", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `type` (`String`)None
    """

    custom_rules = sgqlc.types.Field(
        sgqlc.types.non_null(CustomRuleConnection),
        graphql_name="customRules",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
                (
                    "rule_type",
                    sgqlc.types.Arg(CustomRuleModelRuleType, graphql_name="ruleType", default=None),
                ),
                (
                    "warehouse_uuid",
                    sgqlc.types.Arg(UUID, graphql_name="warehouseUuid", default=None),
                ),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `rule_type` (`CustomRuleModelRuleType`)None
    * `warehouse_uuid` (`UUID`)None
    """

    agent_trace_tables = sgqlc.types.Field(
        sgqlc.types.non_null(AgentTraceTableConnection),
        graphql_name="agentTraceTables",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """


class DataCollectorScheduleInfo(sgqlc.types.Type):
    """Detailed information about a data collector schedule"""

    __schema__ = schema
    __field_names__ = (
        "uuid",
        "resource_id",
        "connection_id",
        "internal_job_type",
        "limits",
        "interval_in_seconds",
    )
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """UUID of the schedule"""

    resource_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="resourceId")
    """Resource ID (warehouse UUID) this schedule belongs to"""

    connection_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="connectionId")
    """Connection ID this schedule belongs to"""

    internal_job_type = sgqlc.types.Field(
        sgqlc.types.non_null(InternalJobType), graphql_name="internalJobType"
    )
    """Type of job (metadata, query_logs, etc.)"""

    limits = sgqlc.types.Field(JSONString, graphql_name="limits")
    """Limits configuration for the job"""

    interval_in_seconds = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="intervalInSeconds"
    )
    """Interval between job runs in seconds"""


class DataExplorerComparisonDashboardTypeConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DataExplorerComparisonDashboardTypeEdge")),
        graphql_name="edges",
    )
    """Contains the nodes in this connection."""


class DataExplorerComparisonDashboardTypeEdge(sgqlc.types.Type):
    """A Relay edge containing a `DataExplorerComparisonDashboardType`
    and its cursor.
    """

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DataExplorerComparisonDashboardType", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DataExplorerDashboardTypeConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DataExplorerDashboardTypeEdge")),
        graphql_name="edges",
    )
    """Contains the nodes in this connection."""


class DataExplorerDashboardTypeEdge(sgqlc.types.Type):
    """A Relay edge containing a `DataExplorerDashboardType` and its
    cursor.
    """

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DataExplorerDashboardType", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DataExplorerWidgetTypeConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DataExplorerWidgetTypeEdge")),
        graphql_name="edges",
    )
    """Contains the nodes in this connection."""


class DataExplorerWidgetTypeEdge(sgqlc.types.Type):
    """A Relay edge containing a `DataExplorerWidgetType` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DataExplorerWidgetType", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DataExportURL(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("url", "created_at")
    url = sgqlc.types.Field(String, graphql_name="url")
    """Pre-signed URL for fetching report, expiration time is 1 minute"""

    created_at = sgqlc.types.Field(DateTime, graphql_name="createdAt")
    """Report creation time in UTC"""


class DataMaintenanceEntry(sgqlc.types.Type):
    """Data maintenance entry"""

    __schema__ = schema
    __field_names__ = (
        "created_time",
        "updated_time",
        "id",
        "account_uuid",
        "resource_uuid",
        "database",
        "dataset",
        "full_table_id",
        "monitor_id",
        "time_series_uuid",
        "maintenance_type",
        "start_time",
        "end_time",
        "reason",
        "reason_type",
    )
    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdTime")

    updated_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedTime")

    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    account_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="accountUuid")

    resource_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="resourceUuid")

    database = sgqlc.types.Field(String, graphql_name="database")

    dataset = sgqlc.types.Field(String, graphql_name="dataset")

    full_table_id = sgqlc.types.Field(String, graphql_name="fullTableId")

    monitor_id = sgqlc.types.Field(UUID, graphql_name="monitorId")

    time_series_uuid = sgqlc.types.Field(UUID, graphql_name="timeSeriesUuid")

    maintenance_type = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="maintenanceType")

    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")

    end_time = sgqlc.types.Field(DateTime, graphql_name="endTime")

    reason = sgqlc.types.Field(String, graphql_name="reason")

    reason_type = sgqlc.types.Field(
        sgqlc.types.non_null(DataMaintenanceReasonType), graphql_name="reasonType"
    )


class DataOperationsDashboardOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "uuid",
        "name",
        "criteria",
        "created_by",
        "updated_by",
        "description",
        "created_time",
        "updated_time",
    )
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """UUID of the Data Operations Dashboard."""

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Name of the Data Operations Dashboard."""

    criteria = sgqlc.types.Field(sgqlc.types.non_null(DODCriteriaOutput), graphql_name="criteria")
    """Data Operations Dashboard Criteria."""

    created_by = sgqlc.types.Field(sgqlc.types.non_null("UserInfoOutput"), graphql_name="createdBy")
    """Created by user of the dashboard."""

    updated_by = sgqlc.types.Field(sgqlc.types.non_null("UserInfoOutput"), graphql_name="updatedBy")
    """Last updated user of the dashboard."""

    description = sgqlc.types.Field(String, graphql_name="description")
    """Description of the Data Operations Dashboard."""

    created_time = sgqlc.types.Field(DateTime, graphql_name="createdTime")
    """When the dashboard's created."""

    updated_time = sgqlc.types.Field(DateTime, graphql_name="updatedTime")
    """When the dashboard's created."""


class DataPoint(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("timestamp", "value")
    timestamp = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="timestamp")

    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="value")


class DataProductAssetConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DataProductAssetEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DataProductAssetData(sgqlc.types.Type):
    """Information about an asset related to data product usage and
    recommendations
    """

    __schema__ = schema
    __field_names__ = ("data_products", "mcon", "table", "pipeline_end_node", "pipelines")
    data_products = sgqlc.types.Field(
        sgqlc.types.list_of("DataProduct"), graphql_name="dataProducts"
    )
    """UUIDs of d"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """MC unique identifier"""

    table = sgqlc.types.Field("WarehouseTable", graphql_name="table")
    """Table entity for requesting"""

    pipeline_end_node = sgqlc.types.Field(Boolean, graphql_name="pipelineEndNode")
    """Whether this is an end node for an important data pipeline"""

    pipelines = sgqlc.types.Field(
        sgqlc.types.list_of("DataProductPipeline"), graphql_name="pipelines"
    )
    """Pipelines node is a member of"""


class DataProductAssetEdge(sgqlc.types.Type):
    """A Relay edge containing a `DataProductAsset` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DataProductAsset", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DataProductConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DataProductEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DataProductDryRunTableCounts(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "total_asset_count",
        "total_asset_monitored_count",
        "total_asset_unmonitored_count",
    )
    total_asset_count = sgqlc.types.Field(Int, graphql_name="totalAssetCount")
    """Total count of assets that would be in the data product"""

    total_asset_monitored_count = sgqlc.types.Field(Int, graphql_name="totalAssetMonitoredCount")
    """Total count of already monitored assets"""

    total_asset_unmonitored_count = sgqlc.types.Field(
        Int, graphql_name="totalAssetUnmonitoredCount"
    )
    """Total count of yet unmonitored assets"""


class DataProductEdge(sgqlc.types.Type):
    """A Relay edge containing a `DataProduct` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DataProduct", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DataProductMetricData(sgqlc.types.Type):
    """Data product metric with calculated data points"""

    __schema__ = schema
    __field_names__ = ("metric", "data_points", "fill_missing_data_points_with", "overall_value")
    metric = sgqlc.types.Field(sgqlc.types.non_null(DataProductMetric), graphql_name="metric")
    """Metric identifier"""

    data_points = sgqlc.types.Field(
        sgqlc.types.list_of("DataProductMetricDataPoint"), graphql_name="dataPoints"
    )
    """Data points for the metric"""

    fill_missing_data_points_with = sgqlc.types.Field(
        Float, graphql_name="fillMissingDataPointsWith"
    )
    """Value to use for missing data points. This is used to tell the FE
    which is the value to use when there is no data for a specific
    date or time.
    """

    overall_value = sgqlc.types.Field(Float, graphql_name="overallValue")
    """Overall value for the metric that is not grouped into data points"""


class DataProductMetricDataPoint(sgqlc.types.Type):
    """Data point for a data product metric"""

    __schema__ = schema
    __field_names__ = ("label", "value")
    label = sgqlc.types.Field(String, graphql_name="label")
    """Label associated to the value"""

    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="value")
    """Value for the data point"""


class DataProductPipeline(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("pipe_mcon", "pipe_full_id", "pipe_display_name", "pipe_score")
    pipe_mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="pipeMcon")

    pipe_full_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="pipeFullId")

    pipe_display_name = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="pipeDisplayName"
    )

    pipe_score = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="pipeScore")


class DataProductUpstreamCoverageData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "total_upstream_count",
        "total_upstream_monitored_count",
        "total_upstream_unmonitored_count",
        "total_asset_count",
        "total_asset_monitored_count",
        "total_asset_unmonitored_count",
        "asset_data",
    )
    total_upstream_count = sgqlc.types.Field(Int, graphql_name="totalUpstreamCount")
    """Total count of upstream monitorable assets"""

    total_upstream_monitored_count = sgqlc.types.Field(
        Int, graphql_name="totalUpstreamMonitoredCount"
    )
    """Total count of upstream monitored assets"""

    total_upstream_unmonitored_count = sgqlc.types.Field(
        Int, graphql_name="totalUpstreamUnmonitoredCount"
    )
    """Total count of upstream unmonitored assets"""

    total_asset_count = sgqlc.types.Field(Int, graphql_name="totalAssetCount")
    """Total count of monitorable assets"""

    total_asset_monitored_count = sgqlc.types.Field(Int, graphql_name="totalAssetMonitoredCount")
    """Total count of monitored assets"""

    total_asset_unmonitored_count = sgqlc.types.Field(
        Int, graphql_name="totalAssetUnmonitoredCount"
    )
    """Total count of unmonitored assets"""

    asset_data = sgqlc.types.Field(
        sgqlc.types.list_of("TableUpstreamData"), graphql_name="assetData"
    )
    """Per asset upstream counts"""


class DataProfileField(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("name", "type", "min", "max", "p25", "p50", "p75", "dist")
    name = sgqlc.types.Field(String, graphql_name="name")

    type = sgqlc.types.Field(String, graphql_name="type")

    min = sgqlc.types.Field(Float, graphql_name="min")

    max = sgqlc.types.Field(Float, graphql_name="max")

    p25 = sgqlc.types.Field(Float, graphql_name="p25")

    p50 = sgqlc.types.Field(Float, graphql_name="p50")

    p75 = sgqlc.types.Field(Float, graphql_name="p75")

    dist = sgqlc.types.Field(JSONString, graphql_name="dist")


class DataProfileResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("sample_size", "fields")
    sample_size = sgqlc.types.Field(Int, graphql_name="sampleSize")

    fields = sgqlc.types.Field(sgqlc.types.list_of(DataProfileField), graphql_name="fields")


class DataQualityWarningsRef(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "name",
        "author",
        "is_severe",
        "is_active",
        "warning_type",
        "message",
        "created_at",
        "updated_at",
    )
    name = sgqlc.types.Field(String, graphql_name="name")

    author = sgqlc.types.Field(AuthorRef, graphql_name="author")

    is_severe = sgqlc.types.Field(String, graphql_name="isSevere")

    is_active = sgqlc.types.Field(String, graphql_name="isActive")

    warning_type = sgqlc.types.Field(String, graphql_name="warningType")

    message = sgqlc.types.Field(String, graphql_name="message")

    created_at = sgqlc.types.Field(String, graphql_name="createdAt")

    updated_at = sgqlc.types.Field(String, graphql_name="updatedAt")


class DataResponseType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "data_frame",
        "sql_query",
        "presigned_url",
        "is_customer_hosted_data",
        "response_metadata",
    )
    data_frame = sgqlc.types.Field(JSONString, graphql_name="dataFrame")

    sql_query = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="sqlQuery")
    """Raw SQL query that produced this data"""

    presigned_url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="presignedUrl")
    """Presigned URL containing data output"""

    is_customer_hosted_data = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="isCustomerHostedData"
    )
    """If true, data is located at a customer-hosted object storage"""

    response_metadata = sgqlc.types.Field(
        "QueryResponseMetadataType", graphql_name="responseMetadata"
    )
    """Provides metadata that describes how response is structured."""


class DataShareOutput(sgqlc.types.Type):
    """Data share configuration details"""

    __schema__ = schema
    __field_names__ = ("type", "account", "region", "organization")
    type = sgqlc.types.Field(String, graphql_name="type")
    """Type of data share (e.g., 'snowflake')"""

    account = sgqlc.types.Field(String, graphql_name="account")
    """Data share account identifier"""

    region = sgqlc.types.Field(String, graphql_name="region")
    """Data share region"""

    organization = sgqlc.types.Field(String, graphql_name="organization")
    """Data share organization identifier"""


class DataSourceEvaluationResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "data_source",
        "connection_uuid",
        "warehouse_uuid",
        "mcons",
        "errors",
        "row_count",
        "unresolved_mcons",
        "where_condition",
        "segments",
    )
    data_source = sgqlc.types.Field(
        sgqlc.types.non_null(DataSourceInterface), graphql_name="dataSource"
    )

    connection_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="connectionUuid")

    warehouse_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="warehouseUuid")

    mcons = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="mcons",
    )

    errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("Error"))),
        graphql_name="errors",
    )

    row_count = sgqlc.types.Field(Int, graphql_name="rowCount")

    unresolved_mcons = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="unresolvedMcons"
    )

    where_condition = sgqlc.types.Field(String, graphql_name="whereCondition")

    segments = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(FilterValueInterface)), graphql_name="segments"
    )


class DataSourceSchema(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("fields",)
    fields = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("SchemaField"))),
        graphql_name="fields",
    )


class DatabricksClusterResponse(sgqlc.types.Type):
    """Databricks cluster details."""

    __schema__ = schema
    __field_names__ = ("cluster_id", "state")
    cluster_id = sgqlc.types.Field(String, graphql_name="clusterId")
    """ID of the cluster."""

    state = sgqlc.types.Field(String, graphql_name="state")
    """State of the cluster."""


class DatabricksJobConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DatabricksJobEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DatabricksJobEdge(sgqlc.types.Type):
    """A Relay edge containing a `DatabricksJob` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DatabricksJob", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DatabricksJobResponse(sgqlc.types.Type):
    """Databricks job details."""

    __schema__ = schema
    __field_names__ = (
        "workspace_job_id",
        "workspace_job_name",
        "workspace_notebook_path",
        "notebook_source",
        "notebook_version",
    )
    workspace_job_id = sgqlc.types.Field(String, graphql_name="workspaceJobId")
    """Generated Databricks job ID."""

    workspace_job_name = sgqlc.types.Field(String, graphql_name="workspaceJobName")
    """Generated Databricks job name."""

    workspace_notebook_path = sgqlc.types.Field(String, graphql_name="workspaceNotebookPath")
    """Uploaded Databricks notebook path."""

    notebook_source = sgqlc.types.Field(String, graphql_name="notebookSource")
    """Source location used to create the notebook."""

    notebook_version = sgqlc.types.Field(String, graphql_name="notebookVersion")
    """Version of the notebook created"""


class DatabricksJobRunConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DatabricksJobRunEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DatabricksJobRunEdge(sgqlc.types.Type):
    """A Relay edge containing a `DatabricksJobRun` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DatabricksJobRun", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DatabricksJobRunsConnection(sgqlc.types.relay.Connection):
    """Databricks job executions response"""

    __schema__ = schema
    __field_names__ = ("page_info", "edges", "edge_count", "total_count")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DatabricksJobRunsEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""

    edge_count = sgqlc.types.Field(Int, graphql_name="edgeCount")
    """Total number of edges returned (page count)"""

    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")
    """Total number of edges matching filter (total count)"""


class DatabricksJobRunsEdge(sgqlc.types.Type):
    """A Relay edge containing a `DatabricksJobRuns` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DatabricksJobRun", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DatabricksNotebookLink(sgqlc.types.Type):
    """Databricks notebook link details."""

    __schema__ = schema
    __field_names__ = ("presigned_url", "notebook_source")
    presigned_url = sgqlc.types.Field(String, graphql_name="presignedUrl")
    """Temporary link containing the notebook."""

    notebook_source = sgqlc.types.Field(String, graphql_name="notebookSource")
    """Source location used to create the notebook link."""


class DatabricksTaskConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DatabricksTaskEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DatabricksTaskEdge(sgqlc.types.Type):
    """A Relay edge containing a `DatabricksTask` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DatabricksTask", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DatabricksTaskRunConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DatabricksTaskRunEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DatabricksTaskRunEdge(sgqlc.types.Type):
    """A Relay edge containing a `DatabricksTaskRun` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DatabricksTaskRun", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DatabricksWarehouseResponse(sgqlc.types.Type):
    """Databricks warehouse details."""

    __schema__ = schema
    __field_names__ = ("warehouse_id", "state")
    warehouse_id = sgqlc.types.Field(String, graphql_name="warehouseId")
    """ID of the warehouse."""

    state = sgqlc.types.Field(String, graphql_name="state")
    """State of the warehouse."""


class DatadogIntegrationOutput(sgqlc.types.Type):
    """A Datadog integration"""

    __schema__ = schema
    __field_names__ = (
        "integration_id",
        "integration_name",
        "site",
        "default_incident_fields",
        "created_time",
        "updated_time",
        "created_by",
        "last_update_user",
    )
    integration_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="integrationId")
    """The integration ID"""

    integration_name = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="integrationName"
    )
    """A short name to identify the integration"""

    site = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="site")
    """Datadog site (e.g. datadoghq.com)"""

    default_incident_fields = sgqlc.types.Field(JSONString, graphql_name="defaultIncidentFields")
    """Default values for Datadog incident fields"""

    created_time = sgqlc.types.Field(DateTime, graphql_name="createdTime")
    """When the integration was created"""

    updated_time = sgqlc.types.Field(DateTime, graphql_name="updatedTime")
    """When the integration was last updated"""

    created_by = sgqlc.types.Field("User", graphql_name="createdBy")
    """Who created the integration"""

    last_update_user = sgqlc.types.Field("User", graphql_name="lastUpdateUser")
    """Who last updated the integration"""


class DatadogServiceOutput(sgqlc.types.Type):
    """A Datadog incident service"""

    __schema__ = schema
    __field_names__ = ("id", "name")
    id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="id")
    """Datadog service id"""

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Service name"""


class DatadogTeamOutput(sgqlc.types.Type):
    """A Datadog incident team"""

    __schema__ = schema
    __field_names__ = ("id", "name")
    id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="id")
    """Datadog team id"""

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Team name"""


class DatadogUserOutput(sgqlc.types.Type):
    """A Datadog user"""

    __schema__ = schema
    __field_names__ = ("id", "email", "name")
    id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="id")
    """Datadog user id"""

    email = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="email")
    """User email"""

    name = sgqlc.types.Field(String, graphql_name="name")
    """User name"""


class DatasetConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DatasetEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DatasetEdge(sgqlc.types.Type):
    """A Relay edge containing a `Dataset` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("Dataset", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DatasetEntity(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("dataset_id",)
    dataset_id = sgqlc.types.Field(String, graphql_name="datasetId")
    """Dataset ID"""


class DbtConnectionDetails(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("dbt_cloud_account_id", "dbt_cloud_webhook_id", "dbt_cloud_base_url")
    dbt_cloud_account_id = sgqlc.types.Field(String, graphql_name="dbtCloudAccountId")

    dbt_cloud_webhook_id = sgqlc.types.Field(String, graphql_name="dbtCloudWebhookId")

    dbt_cloud_base_url = sgqlc.types.Field(String, graphql_name="dbtCloudBaseUrl")


class DbtEdgeConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DbtEdgeEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DbtEdgeEdge(sgqlc.types.Type):
    """A Relay edge containing a `DbtEdge` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DbtEdge", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DbtJobConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DbtJobEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DbtJobEdge(sgqlc.types.Type):
    """A Relay edge containing a `DbtJob` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DbtJob", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DbtJobExecutionConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DbtJobExecutionEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DbtJobExecutionEdge(sgqlc.types.Type):
    """A Relay edge containing a `DbtJobExecution` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DbtJobExecution", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DbtJobExecutionsConnection(sgqlc.types.relay.Connection):
    """dbt job executions response"""

    __schema__ = schema
    __field_names__ = ("page_info", "edges", "edge_count", "total_count")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DbtJobExecutionsEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""

    edge_count = sgqlc.types.Field(Int, graphql_name="edgeCount")
    """Total number of edges returned (page count)"""

    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")
    """Total number of edges matching filter (total count)"""


class DbtJobExecutionsEdge(sgqlc.types.Type):
    """A Relay edge containing a `DbtJobExecutions` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DbtJobExecution", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DbtJobInfo(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "integration_type",
        "job_name",
        "mc_dbt_job_mcon",
        "mc_dbt_job_execution_id",
        "mc_dbt_run_id",
        "dbt_cloud_job_id",
        "dbt_cloud_run_id",
        "dbt_node_id",
        "dbt_node_name",
        "invocation_id",
    )
    integration_type = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="integrationType"
    )
    """Type of Integration"""

    job_name = sgqlc.types.Field(String, graphql_name="jobName")
    """Name of Job"""

    mc_dbt_job_mcon = sgqlc.types.Field(String, graphql_name="mcDbtJobMcon")
    """MC dbt Job mcon"""

    mc_dbt_job_execution_id = sgqlc.types.Field(UUID, graphql_name="mcDbtJobExecutionId")
    """MC dbt Job Execution ID (uuid)"""

    mc_dbt_run_id = sgqlc.types.Field(UUID, graphql_name="mcDbtRunId")
    """MC dbt Run ID (uuid)"""

    dbt_cloud_job_id = sgqlc.types.Field(String, graphql_name="dbtCloudJobId")
    """dbt Cloud Job ID"""

    dbt_cloud_run_id = sgqlc.types.Field(String, graphql_name="dbtCloudRunId")
    """dbt Cloud Run ID"""

    dbt_node_id = sgqlc.types.Field(String, graphql_name="dbtNodeId")
    """dbt node ID"""

    dbt_node_name = sgqlc.types.Field(String, graphql_name="dbtNodeName")
    """dbt node name"""

    invocation_id = sgqlc.types.Field(String, graphql_name="invocationId")
    """dbt Invocation ID"""


class DbtModelResult(sgqlc.types.Type):
    """dbt model result"""

    __schema__ = schema
    __field_names__ = ("node_id", "node_name", "schema", "database")
    node_id = sgqlc.types.Field(String, graphql_name="nodeId")
    """dbt node id"""

    node_name = sgqlc.types.Field(String, graphql_name="nodeName")
    """dbt node name"""

    schema = sgqlc.types.Field(String, graphql_name="schema")
    """dbt schema name"""

    database = sgqlc.types.Field(String, graphql_name="database")
    """dbt database name"""


class DbtModelResultsConnection(sgqlc.types.relay.Connection):
    """dbt model results response"""

    __schema__ = schema
    __field_names__ = ("page_info", "edges", "edge_count", "total_count")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DbtModelResultsEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""

    edge_count = sgqlc.types.Field(Int, graphql_name="edgeCount")
    """Total number of edges returned (page count)"""

    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")
    """Total number of edges matching filter (total count)"""


class DbtModelResultsEdge(sgqlc.types.Type):
    """A Relay edge containing a `DbtModelResults` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DbtRunResult", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DbtModelsConnection(sgqlc.types.relay.Connection):
    """dbt models response"""

    __schema__ = schema
    __field_names__ = ("page_info", "edges", "edge_count", "total_count")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DbtModelsEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""

    edge_count = sgqlc.types.Field(Int, graphql_name="edgeCount")
    """Total number of edges returned (page count)"""

    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")
    """Total number of edges matching filter (total count)"""


class DbtModelsEdge(sgqlc.types.Type):
    """A Relay edge containing a `DbtModels` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field(DbtModelResult, graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DbtNodeConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DbtNodeEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DbtNodeEdge(sgqlc.types.Type):
    """A Relay edge containing a `DbtNode` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DbtNode", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DbtNodeResultCount(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("nodes_count",)
    nodes_count = sgqlc.types.Field(
        sgqlc.types.list_of("DbtResultCount"), graphql_name="nodesCount"
    )
    """List of dbt nodes and their counts"""


class DbtProjectConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DbtProjectEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DbtProjectEdge(sgqlc.types.Type):
    """A Relay edge containing a `DbtProject` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DbtProject", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DbtResultCount(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("count", "node_type")
    count = sgqlc.types.Field(Int, graphql_name="count")
    """Number of dbt nodes"""

    node_type = sgqlc.types.Field(String, graphql_name="nodeType")
    """Type of dbt node"""


class DbtRunConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DbtRunEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DbtRunEdge(sgqlc.types.Type):
    """A Relay edge containing a `DbtRun` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DbtRun", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DbtRunResult(sgqlc.types.Type):
    """dbt run result"""

    __schema__ = schema
    __field_names__ = (
        "node_id",
        "node_name",
        "run_started_at",
        "started_at",
        "execution_time",
        "status",
        "run_uuid",
        "mcon",
        "job_name",
        "job_mcon",
        "command",
    )
    node_id = sgqlc.types.Field(String, graphql_name="nodeId")
    """dbt node id"""

    node_name = sgqlc.types.Field(String, graphql_name="nodeName")
    """dbt node name"""

    run_started_at = sgqlc.types.Field(DateTime, graphql_name="runStartedAt")
    """Time dbt run started"""

    started_at = sgqlc.types.Field(DateTime, graphql_name="startedAt")
    """Time dbt node execution started"""

    execution_time = sgqlc.types.Field(Float, graphql_name="executionTime")
    """Total dbt node execution time (in seconds)"""

    status = sgqlc.types.Field(String, graphql_name="status")
    """Execution status"""

    run_uuid = sgqlc.types.Field(UUID, graphql_name="runUuid")
    """Internal id of dbt run"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """MCON of associated table"""

    job_name = sgqlc.types.Field(String, graphql_name="jobName")
    """Dbt job name"""

    job_mcon = sgqlc.types.Field(String, graphql_name="jobMcon")
    """MCON of associated dbt job"""

    command = sgqlc.types.Field(String, graphql_name="command")
    """dbt command executed"""


class DbtRunStepConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DbtRunStepEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DbtRunStepEdge(sgqlc.types.Type):
    """A Relay edge containing a `DbtRunStep` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DbtRunStep", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DbtTestResultsConnection(sgqlc.types.relay.Connection):
    """dbt test results response"""

    __schema__ = schema
    __field_names__ = ("page_info", "edges", "edge_count", "total_count")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DbtTestResultsEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""

    edge_count = sgqlc.types.Field(Int, graphql_name="edgeCount")
    """Total number of edges returned (page count)"""

    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")
    """Total number of edges matching filter (total count)"""


class DbtTestResultsEdge(sgqlc.types.Type):
    """A Relay edge containing a `DbtTestResults` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DbtTestRunResult", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DbtTestRunResult(sgqlc.types.Type):
    """dbt test run result"""

    __schema__ = schema
    __field_names__ = (
        "node_id",
        "node_name",
        "run_started_at",
        "started_at",
        "execution_time",
        "status",
        "run_uuid",
        "mcon",
        "job_name",
        "job_mcon",
        "command",
        "model_id",
        "model_name",
    )
    node_id = sgqlc.types.Field(String, graphql_name="nodeId")
    """dbt node id"""

    node_name = sgqlc.types.Field(String, graphql_name="nodeName")
    """dbt node name"""

    run_started_at = sgqlc.types.Field(DateTime, graphql_name="runStartedAt")
    """Time dbt run started"""

    started_at = sgqlc.types.Field(DateTime, graphql_name="startedAt")
    """Time dbt node execution started"""

    execution_time = sgqlc.types.Field(Float, graphql_name="executionTime")
    """Total dbt node execution time (in seconds)"""

    status = sgqlc.types.Field(String, graphql_name="status")
    """Execution status"""

    run_uuid = sgqlc.types.Field(UUID, graphql_name="runUuid")
    """Internal id of dbt run"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """MCON of associated table"""

    job_name = sgqlc.types.Field(String, graphql_name="jobName")
    """Dbt job name"""

    job_mcon = sgqlc.types.Field(String, graphql_name="jobMcon")
    """MCON of associated dbt job"""

    command = sgqlc.types.Field(String, graphql_name="command")
    """dbt command executed"""

    model_id = sgqlc.types.Field(String, graphql_name="modelId")
    """Id of associated dbt model"""

    model_name = sgqlc.types.Field(String, graphql_name="modelName")
    """Name of associated dbt model"""


class DcMigrationStatusResponse(sgqlc.types.Type):
    """DC migration status"""

    __schema__ = schema
    __field_names__ = ("output",)
    output = sgqlc.types.Field(GenericScalar, graphql_name="output")
    """Output from the migration process"""


class DcPingResponse(sgqlc.types.Type):
    """Describes the result of pinging a data collector."""

    __schema__ = schema
    __field_names__ = ("dc_id", "trace_id")
    dc_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="dcId")
    """The UUID identifying the data collector pinged."""

    trace_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="traceId")
    """A unique identifier for correlating the data collector ping."""


class DeauthorizeSlackAppMutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteAccessToken(sgqlc.types.Type):
    """Delete an API Access Token by ID"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """If the token was successfully deleted"""


class DeleteAccountSecret(sgqlc.types.Type):
    """Delete an account secret"""

    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")


class DeleteAgent(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteAgentTraceTable(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """Whether the agent trace table was successfully deleted"""


class DeleteAlationIntegration(sgqlc.types.Type):
    """Delete Alation integration"""

    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")


class DeleteAlertComment(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteAllowListEntry(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success", "project_name", "dataset")
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """Whether the mutation succeeded."""

    project_name = sgqlc.types.Field(String, graphql_name="projectName")
    """The project_name from which the dataset was deleted"""

    dataset = sgqlc.types.Field(String, graphql_name="dataset")
    """The dataset which was deleted."""


class DeleteAssetCollectionPreferences(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success", "resource_id", "asset_type")
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """Whether the mutation succeeded."""

    resource_id = sgqlc.types.Field(UUID, graphql_name="resourceId")
    """The resource UUID the preferences were removed from."""

    asset_type = sgqlc.types.Field(String, graphql_name="assetType")
    """The asset type that the preferences were removed for."""


class DeleteAudienceNotificationSetting(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Int, graphql_name="deleted")


class DeleteAudienceRoutingRule(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Int, graphql_name="deleted")


class DeleteAuthorizationGroup(sgqlc.types.Type):
    """Delete an authorization group"""

    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Int, graphql_name="deleted")
    """Number of groups deleted."""


class DeleteAzureDevOpsIntegration(sgqlc.types.Type):
    """Delete an Azure DevOps integration."""

    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")
    """If the integration was deleted"""


class DeleteAzureDevopsInstallation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """True if deleting the installation was successful"""


class DeleteCatalogObjectMetadata(sgqlc.types.Type):
    """Delete metadata for an asset"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteCollibraIntegration(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")


class DeleteCustomRule(sgqlc.types.Type):
    """Delete a custom rule"""

    __schema__ = schema
    __field_names__ = ("uuid",)
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")


class DeleteCustomSQLTemplate(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteDataExplorerComparisonDashboardMutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="success")


class DeleteDataExplorerDashboardMutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteDataMaintenanceEntry(sgqlc.types.Type):
    """Delete a data maintenance window"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteDataOperationsDashboardMutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """Indicates whether the delete happened successfully or not."""


class DeleteDataProduct(sgqlc.types.Type):
    """Delete a data product"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """Status of the deletion operation."""


class DeleteDataProductV2(sgqlc.types.Type):
    """Delete a data product"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """Status of the deletion operation."""


class DeleteDatadogIntegration(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")
    """If the integration was deleted"""


class DeleteDomain(sgqlc.types.Type):
    """Delete a domain"""

    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Int, graphql_name="deleted")
    """Number of domains deleted"""


class DeleteEventOnboardingData(sgqlc.types.Type):
    """Delete stored event onboarding configuration"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """Indicates whether the event onboarding data was deleted
    successfully
    """


class DeleteGithubInstallation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")
    """True if deleting the installation was successful"""


class DeleteGitlabInstallation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")
    """True if deleting the installation was successful"""


class DeleteIncidentComment(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteIntegrationKey(sgqlc.types.Type):
    """Delete an integration key"""

    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")
    """True if the key was deleted, false otherwise"""


class DeleteIntegrationMutation(sgqlc.types.Type):
    """Delete an integration and all its contained connections"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteJiraIntegration(sgqlc.types.Type):
    """Delete a Jira integration"""

    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")


class DeleteLineageNode(sgqlc.types.Type):
    """Delete a lineage node and any lineage edges connected to it."""

    __schema__ = schema
    __field_names__ = ("objects_deleted", "nodes_deleted", "edges_deleted")
    objects_deleted = sgqlc.types.Field(Int, graphql_name="objectsDeleted")
    """Total number of objects (nodes + edges) deleted"""

    nodes_deleted = sgqlc.types.Field(Int, graphql_name="nodesDeleted")
    """Total number of nodes deleted"""

    edges_deleted = sgqlc.types.Field(Int, graphql_name="edgesDeleted")
    """Total number of edges deleted"""


class DeleteLineageNodeBlockPattern(sgqlc.types.Type):
    """Delete a lineage node block pattern."""

    __schema__ = schema
    __field_names__ = ("pattern",)
    pattern = sgqlc.types.Field("LineageNodeBlockPattern", graphql_name="pattern")


class DeleteLineageNodeCollapsingRule(sgqlc.types.Type):
    """Delete a lineage node collapsing rule"""

    __schema__ = schema
    __field_names__ = ("rule",)
    rule = sgqlc.types.Field("LineageNodeCollapsingRule", graphql_name="rule")


class DeleteLineageNodeReplacementRule(sgqlc.types.Type):
    """Delete a lineage node replacement rule"""

    __schema__ = schema
    __field_names__ = ("rule",)
    rule = sgqlc.types.Field("LineageNodeReplacementRule", graphql_name="rule")


class DeleteLogsIntegration(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteMcpIntegrationKey(sgqlc.types.Type):
    """Delete an MCP integration key created by the current user"""

    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")
    """True if the key was deleted, false otherwise"""


class DeleteMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteMonitorLabel(sgqlc.types.Type):
    """Delete a monitor label"""

    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")
    """True if the monitor label was deleted"""


class DeleteMonitorTag(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteMonitors(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteMonteCarloConfigTemplate(sgqlc.types.Type):
    """Delete a Monte Carlo Config Template"""

    __schema__ = schema
    __field_names__ = ("response",)
    response = sgqlc.types.Field("MonteCarloConfigTemplateDeleteResponse", graphql_name="response")
    """Response"""


class DeleteNotificationSetting(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Int, graphql_name="deleted")


class DeleteObjectProperty(sgqlc.types.Type):
    """Delete properties (tags) for objects (e.g. tables, fields, etc.)"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteOpsgenieIntegration(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")
    """If the integration was deleted"""


class DeletePagerDutyServiceIntegration(sgqlc.types.Type):
    """Delete a PagerDuty service integration"""

    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")


class DeleteRecipientName(sgqlc.types.Type):
    """Create or update a recipient's custom name"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteSamlIdentityProvider(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("account",)
    account = sgqlc.types.Field(Account, graphql_name="account")


class DeleteServiceNowIntegration(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")


class DeleteStreamingClusterMutation(sgqlc.types.Type):
    """Delete a streaming clusters, and connections on this cluster."""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteStreamingSystemMutation(sgqlc.types.Type):
    """Delete a streaming system. This will delete all clusters within
    the streaming system as well.
    """

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteTableMonitor(sgqlc.types.Type):
    """Delete a table monitor"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="success")


class DeleteUnifiedUserAssignment(sgqlc.types.Type):
    """Associate a UnifiedUser with a CatalogObject"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DeleteUserInvite(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """Indicates whether the operation was completed successfully"""


class DeleteWebexIntegration(sgqlc.types.Type):
    """Delete a Webex integration"""

    __schema__ = schema
    __field_names__ = ("deleted",)
    deleted = sgqlc.types.Field(Boolean, graphql_name="deleted")


class DeltaLog(sgqlc.types.Type):
    """Represents a single entry in the table's Delta History"""

    __schema__ = schema
    __field_names__ = ("version", "timestamp", "user_name", "operation", "operation_metrics")
    version = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="version")
    """Table version generated by the operation."""

    timestamp = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="timestamp")
    """When this version was committed."""

    user_name = sgqlc.types.Field(String, graphql_name="userName")
    """Name of the user that ran the operation."""

    operation = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="operation")
    """Name of the operation."""

    operation_metrics = sgqlc.types.Field(
        sgqlc.types.non_null(JSONString), graphql_name="operationMetrics"
    )
    """Metrics of the operation (for example, number of rows and files
    modified).
    """


class DeltaLogConnection(sgqlc.types.relay.Connection):
    """Describes a page of DeltaLog results"""

    __schema__ = schema
    __field_names__ = ("edges", "page_info")
    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DeltaLogConnectionEdge")), graphql_name="edges"
    )

    page_info = sgqlc.types.Field(
        sgqlc.types.non_null("DeltaLogConnectionPageInfo"), graphql_name="pageInfo"
    )
    """Holds details of the current results page"""


class DeltaLogConnectionEdge(sgqlc.types.Type):
    """Describes each item in a paginated list of Delta Log results"""

    __schema__ = schema
    __field_names__ = ("cursor", "node")
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A consistent identifier for each operation in the results list"""

    node = sgqlc.types.Field(sgqlc.types.non_null(DeltaLog), graphql_name="node")
    """The Delta Log object representing a single operation"""


class DeltaLogConnectionPageInfo(sgqlc.types.Type):
    """Information about the current page of Delta Log results"""

    __schema__ = schema
    __field_names__ = ("end_cursor", "has_next_page")
    end_cursor = sgqlc.types.Field(String, graphql_name="endCursor")
    """The last edge's identifier, can be passed as after argument"""

    has_next_page = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="hasNextPage")
    """Whether there are more results to be fetched"""


class DeploymentInfo(sgqlc.types.Type):
    """Deployment environment information"""

    __schema__ = schema
    __field_names__ = (
        "aws_account_id",
        "aws_region",
        "tenant_id",
        "deployment_type",
        "integration_gateway_url",
    )
    aws_account_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="awsAccountId")
    """AWS Account ID"""

    aws_region = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="awsRegion")
    """AWS Region"""

    tenant_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="tenantId")
    """Tenant ID"""

    deployment_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="deploymentType")
    """Environment Deployment Type"""

    integration_gateway_url = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="integrationGatewayUrl"
    )
    """Integration Gateway URL"""


class DerivedTablePartialLineage(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("mcon", "columns", "source_column_used_as_non_selected", "display_name")
    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Derived destination table's mcon"""

    columns = sgqlc.types.Field(sgqlc.types.list_of("SourceColumn"), graphql_name="columns")
    """A list of columns in the derived table, that are derived from some
    source
    """

    source_column_used_as_non_selected = sgqlc.types.Field(
        Boolean, graphql_name="sourceColumnUsedAsNonSelected"
    )
    """Indicates whether the input source column is used as a non
    selected column in the query that derives the current table
    """

    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """Display name for BI tables"""


class DerivedTablesLineageResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("mcon", "source_column", "destinations", "is_last_page", "cursor")
    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Source table mcon"""

    source_column = sgqlc.types.Field(String, graphql_name="sourceColumn")
    """Source column"""

    destinations = sgqlc.types.Field(
        sgqlc.types.list_of(DerivedTablePartialLineage), graphql_name="destinations"
    )
    """Derived tables and their columns that are influenced by the source
    col
    """

    is_last_page = sgqlc.types.Field(Boolean, graphql_name="isLastPage")
    """Indicates whether this response the the last page of response"""

    cursor = sgqlc.types.Field(String, graphql_name="cursor")
    """Cursor for getting the next page of results"""


class DirectedGraph(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("vertices", "edges")
    vertices = sgqlc.types.Field(String, graphql_name="vertices")

    edges = sgqlc.types.Field(String, graphql_name="edges")


class DisableFreshnessTableMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid",)
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """UUID of the underlying OOTB replacement rule"""


class DisableMetadataEvents(sgqlc.types.Type):
    """Disable collection of metadata via S3 events"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DisableQueryLogEvents(sgqlc.types.Type):
    """Disable collection of query logs via S3 events"""

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")


class DisableUCSTableMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid",)
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """UUID of the underlying OOTB replacement rule"""


class DisableUser(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("user",)
    user = sgqlc.types.Field("User", graphql_name="user")


class DisableVolumeChangeTableMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid",)
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """UUID of the underlying OOTB replacement rule"""


class DisplayableFieldValueType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "field_name",
        "value_as_string",
        "value_as_string_array",
        "linked_mcon",
        "linked_mcon_array",
    )
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="fieldName")

    value_as_string = sgqlc.types.Field(String, graphql_name="valueAsString")

    value_as_string_array = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="valueAsStringArray"
    )

    linked_mcon = sgqlc.types.Field(String, graphql_name="linkedMcon")

    linked_mcon_array = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="linkedMconArray"
    )


class DomainOutput(sgqlc.types.Type):
    """Domain configuration"""

    __schema__ = schema
    __field_names__ = (
        "uuid",
        "name",
        "description",
        "created_by_email",
        "domain_tag",
        "assignments",
        "excluded_assignments",
        "tags",
        "excluded_tags",
        "assignments_with_properties",
        "excluded_assignments_with_properties",
        "obj_assignment_update_time",
    )
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """Domain UUID"""

    name = sgqlc.types.Field(String, graphql_name="name")
    """Domain name"""

    description = sgqlc.types.Field(String, graphql_name="description")
    """Domain description"""

    created_by_email = sgqlc.types.Field(String, graphql_name="createdByEmail")
    """Domain created by email address"""

    domain_tag = sgqlc.types.Field(String, graphql_name="domainTag")
    """The domain's tag representation"""

    assignments = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="assignments")
    """Objects assigned to domain (as MCONs)"""

    excluded_assignments = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="excludedAssignments"
    )
    """Objects excluded from domain (as MCONs)"""

    tags = sgqlc.types.Field(sgqlc.types.list_of("TagKeyValuePairOutput"), graphql_name="tags")
    """Filter by tag key/value pairs for tables."""

    excluded_tags = sgqlc.types.Field(
        sgqlc.types.list_of("TagKeyValuePairOutput"), graphql_name="excludedTags"
    )
    """Filter out by tag key/value pairs for tables."""

    assignments_with_properties = sgqlc.types.Field(
        sgqlc.types.list_of(AssignmentWithProperties), graphql_name="assignmentsWithProperties"
    )
    """Objects assigned to domains and their properties"""

    excluded_assignments_with_properties = sgqlc.types.Field(
        sgqlc.types.list_of(AssignmentWithProperties),
        graphql_name="excludedAssignmentsWithProperties",
    )
    """Objects excluded from domains and their properties"""

    obj_assignment_update_time = sgqlc.types.Field(DateTime, graphql_name="objAssignmentUpdateTime")
    """Last update time for object assignments cause by domain changes
    (as opposed to catalog changes)
    """


class DomainRef(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid", "name")
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """Domain UUID"""

    name = sgqlc.types.Field(String, graphql_name="name")
    """Domain label"""


class DomainRestrictionConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("DomainRestrictionEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class DomainRestrictionEdge(sgqlc.types.Type):
    """A Relay edge containing a `DomainRestriction` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("DomainRestriction", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class DownstreamBI(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("node_id", "full_table_id", "downstream_bi")
    node_id = sgqlc.types.Field(String, graphql_name="nodeId")

    full_table_id = sgqlc.types.Field(String, graphql_name="fullTableId")

    downstream_bi = sgqlc.types.Field(sgqlc.types.list_of(BiLineage), graphql_name="downstreamBi")


class DownstreamImpactRadiusSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("total_users_affected", "total_reports_affected")
    total_users_affected = sgqlc.types.Field(Int, graphql_name="totalUsersAffected")
    """Number of users affected"""

    total_reports_affected = sgqlc.types.Field(Int, graphql_name="totalReportsAffected")
    """Number of reports affected"""


class DownstreamReport(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "mcon",
        "display_name",
        "report_type",
        "object_id",
        "owner_id",
        "is_custom",
        "importance_score",
        "tableau_metadata",
    )
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """MCON of the report."""

    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")
    """Display name of the report"""

    report_type = sgqlc.types.Field(String, graphql_name="reportType")
    """Type of the report"""

    object_id = sgqlc.types.Field(String, graphql_name="objectId")
    """ID of the object"""

    owner_id = sgqlc.types.Field(String, graphql_name="ownerId")
    """ID of the owner of this object"""

    is_custom = sgqlc.types.Field(Boolean, graphql_name="isCustom")
    """Indicates whether this is a custom lineage node (created by a
    user)
    """

    importance_score = sgqlc.types.Field(Float, graphql_name="importanceScore")
    """Importance score of the report"""

    tableau_metadata = sgqlc.types.Field("TableauMetadata", graphql_name="tableauMetadata")
    """Metadata for Tableau objects"""


class DownstreamReportOwners(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("owner_ids", "has_next_page", "limit", "offset")
    owner_ids = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name="ownerIds"
    )
    """Owner ID of a BI report"""

    has_next_page = sgqlc.types.Field(Boolean, graphql_name="hasNextPage")
    """Whether more pages of results exist. Used for pagination."""

    limit = sgqlc.types.Field(Int, graphql_name="limit")
    """Limit results returned"""

    offset = sgqlc.types.Field(Int, graphql_name="offset")
    """Offset when paging"""


class DownstreamReportTypes(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("downstream_report_types",)
    downstream_report_types = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="downstreamReportTypes"
    )
    """List of distinct downstream report types."""


class DownstreamReports(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("downstream_reports", "limit", "offset", "has_next_page")
    downstream_reports = sgqlc.types.Field(
        sgqlc.types.list_of(DownstreamReport), graphql_name="downstreamReports"
    )
    """List of downstream reports"""

    limit = sgqlc.types.Field(Int, graphql_name="limit")
    """Limit results returned"""

    offset = sgqlc.types.Field(Int, graphql_name="offset")
    """Offset when paging"""

    has_next_page = sgqlc.types.Field(Boolean, graphql_name="hasNextPage")
    """Whether more pages of results exist. Used for pagination."""


class Dynamic(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("min", "max", "reason")
    min = sgqlc.types.Field(Float, graphql_name="min")
    """Deprecated: Minimum threshold"""

    max = sgqlc.types.Field(Float, graphql_name="max")
    """Deprecated: Maximum threshold"""

    reason = sgqlc.types.Field(String, graphql_name="reason")
    """Explanation if min/max is missing"""


class ETLJobOrTaskSearchResult(sgqlc.types.Type):
    """Search result for ETL jobs and tasks"""

    __schema__ = schema
    __field_names__ = ("mcon", "name", "etl_type", "asset_type")
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """Monte Carlo full identifier for an entity"""

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Name of the job or task"""

    etl_type = sgqlc.types.Field(sgqlc.types.non_null(EtlType), graphql_name="etlType")
    """ETL type (airflow, databricks, azure-data-factory, dbt)"""

    asset_type = sgqlc.types.Field(sgqlc.types.non_null(ETLAssetType), graphql_name="assetType")
    """Whether this is a job or task"""


class ETLJobsConnectionTypeConnection(sgqlc.types.relay.Connection):
    """Etl Jobs"""

    __schema__ = schema
    __field_names__ = ("page_info", "edges", "edge_count", "total_count")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("ETLJobsConnectionTypeEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""

    edge_count = sgqlc.types.Field(Int, graphql_name="edgeCount")
    """Total number of edges returned (page count)"""

    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")
    """Total number of edges matching filter (total count)"""


class ETLJobsConnectionTypeEdge(sgqlc.types.Type):
    """A Relay edge containing a `ETLJobsConnectionType` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("ETLJobUnionType", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class ETLJobsType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("jobs", "has_next_page")
    jobs = sgqlc.types.Field(sgqlc.types.list_of("ETLJobUnionType"), graphql_name="jobs")
    """ETL Jobs list"""

    has_next_page = sgqlc.types.Field(Boolean, graphql_name="hasNextPage")
    """Boolean indicating if there's a next page based on limit/offset"""


class ETLTasksType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("tasks", "has_next_page")
    tasks = sgqlc.types.Field(sgqlc.types.list_of("ETLTaskUnionType"), graphql_name="tasks")
    """ETL Tasks list"""

    has_next_page = sgqlc.types.Field(Boolean, graphql_name="hasNextPage")
    """Boolean indicating if there's a next page based on limit/offset"""


class EmptyDataCollector(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid", "customer_aws_region")
    uuid = sgqlc.types.Field(String, graphql_name="uuid")

    customer_aws_region = sgqlc.types.Field(String, graphql_name="customerAwsRegion")


class EnableAutomatedFreshnessTableMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid",)
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """UUID of the underlying OOTB replacement rule"""


class EnableAutomatedUCSTableMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid",)
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """UUID of the underlying OOTB replacement rule"""


class EnableAutomatedVolumeChangeTableMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid",)
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """UUID of the underlying OOTB replacement rule"""


class EnableExplicitFreshnessTableMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid",)
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """UUID of the underlying OOTB replacement rule"""


class EnableExplicitUCSTableMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid",)
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """UUID of the underlying OOTB replacement rule"""


class EnableExplicitVolumeChangeTableMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid",)
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """UUID of the underlying OOTB replacement rule"""


class Error(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("code", "message", "id", "extra", "path")
    code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="code")

    message = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="message")

    id = sgqlc.types.Field(String, graphql_name="id")

    extra = sgqlc.types.Field(GenericScalar, graphql_name="extra")

    path = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="path")


class EtlContainer(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "created_time",
        "updated_time",
        "created_by",
        "last_update_user",
        "deleted_at",
        "account",
        "uuid",
        "data_collector",
        "type",
        "name",
        "is_synthetic",
        "connections",
        "incidents",
        "events",
        "airflowdagmodel_set",
        "airflowtaskmodel_set",
        "airflowdagrunmodel_set",
        "airflowtaskrunmodel_set",
        "databricksjobmodel_set",
        "databrickstaskmodel_set",
        "databricksjobrunmodel_set",
        "databrickstaskrunmodel_set",
        "adfjobmodel_set",
        "adftaskmodel_set",
        "adfjobrunmodel_set",
        "adftaskrunmodel_set",
        "job_count",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdTime")

    updated_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedTime")

    created_by = sgqlc.types.Field("User", graphql_name="createdBy")
    """Creator"""

    last_update_user = sgqlc.types.Field("User", graphql_name="lastUpdateUser")
    """Last updated by"""

    deleted_at = sgqlc.types.Field(DateTime, graphql_name="deletedAt")

    account = sgqlc.types.Field(sgqlc.types.non_null(Account), graphql_name="account")

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")

    data_collector = sgqlc.types.Field(DataCollector, graphql_name="dataCollector")

    type = sgqlc.types.Field(EtlType, graphql_name="type")

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """A friendly name for this etl container"""

    is_synthetic = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isSynthetic")
    """Whether this etl container is created as a result of another
    connection
    """

    connections = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(Connection))),
        graphql_name="connections",
    )

    incidents = sgqlc.types.Field(
        sgqlc.types.non_null("IncidentConnection"),
        graphql_name="incidents",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    events = sgqlc.types.Field(
        sgqlc.types.non_null("EventConnection"),
        graphql_name="events",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    airflowdagmodel_set = sgqlc.types.Field(
        sgqlc.types.non_null(AirflowDagConnection),
        graphql_name="airflowdagmodelSet",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """ETL container associated with the pipeline

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    airflowtaskmodel_set = sgqlc.types.Field(
        sgqlc.types.non_null(AirflowTaskConnection),
        graphql_name="airflowtaskmodelSet",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """ETL container associated with the pipeline

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    airflowdagrunmodel_set = sgqlc.types.Field(
        sgqlc.types.non_null(AirflowDagRunConnection),
        graphql_name="airflowdagrunmodelSet",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """ETL container associated with the event

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    airflowtaskrunmodel_set = sgqlc.types.Field(
        sgqlc.types.non_null(AirflowTaskRunConnection),
        graphql_name="airflowtaskrunmodelSet",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """ETL container associated with the event

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    databricksjobmodel_set = sgqlc.types.Field(
        sgqlc.types.non_null(DatabricksJobConnection),
        graphql_name="databricksjobmodelSet",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """ETL container associated with the pipeline

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    databrickstaskmodel_set = sgqlc.types.Field(
        sgqlc.types.non_null(DatabricksTaskConnection),
        graphql_name="databrickstaskmodelSet",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """ETL container associated with the pipeline

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    databricksjobrunmodel_set = sgqlc.types.Field(
        sgqlc.types.non_null(DatabricksJobRunConnection),
        graphql_name="databricksjobrunmodelSet",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """ETL container associated with the event

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    databrickstaskrunmodel_set = sgqlc.types.Field(
        sgqlc.types.non_null(DatabricksTaskRunConnection),
        graphql_name="databrickstaskrunmodelSet",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """ETL container associated with the event

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    adfjobmodel_set = sgqlc.types.Field(
        sgqlc.types.non_null(AdfJobConnection),
        graphql_name="adfjobmodelSet",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """ETL container associated with the pipeline

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    adftaskmodel_set = sgqlc.types.Field(
        sgqlc.types.non_null(AdfTaskConnection),
        graphql_name="adftaskmodelSet",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """ETL container associated with the pipeline

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    adfjobrunmodel_set = sgqlc.types.Field(
        sgqlc.types.non_null(AdfJobRunConnection),
        graphql_name="adfjobrunmodelSet",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """ETL container associated with the event

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    adftaskrunmodel_set = sgqlc.types.Field(
        sgqlc.types.non_null(AdfTaskRunConnection),
        graphql_name="adftaskrunmodelSet",
        args=sgqlc.types.ArgDict(
            (
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """ETL container associated with the event

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """

    job_count = sgqlc.types.Field(Int, graphql_name="jobCount")
    """Number of ETL jobs in this container"""


class EventConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("EventEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class EventDetectorFeedbackConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("EventDetectorFeedbackEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class EventDetectorFeedbackEdge(sgqlc.types.Type):
    """A Relay edge containing a `EventDetectorFeedback` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("EventDetectorFeedback", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class EventEdge(sgqlc.types.Type):
    """A Relay edge containing a `Event` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("Event", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class EventEvaluation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("field", "function", "prompt", "output_type", "sql_expression")
    field = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="field")
    """Field evaluated"""

    function = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="function")
    """Function used in the evaluation"""

    prompt = sgqlc.types.Field(String, graphql_name="prompt")
    """Prompt used in the evaluation"""

    output_type = sgqlc.types.Field(String, graphql_name="outputType")
    """Output type used in the evaluation"""

    sql_expression = sgqlc.types.Field(String, graphql_name="sqlExpression")
    """SQL expression used in the evaluation"""


class EventGroup(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("group_key", "group_metadata", "group_events")
    group_key = sgqlc.types.Field(sgqlc.types.non_null("EventGroupKey"), graphql_name="groupKey")
    """Attributes that uniquely defines an event group"""

    group_metadata = sgqlc.types.Field(
        sgqlc.types.non_null("EventGroupMetadata"), graphql_name="groupMetadata"
    )
    """Additional metadata of the event group (not used to create the
    event group)
    """

    group_events = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("Event")), graphql_name="groupEvents"
    )
    """List of events in an event group"""


class EventGroupKey(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "monitor_uuid",
        "event_type",
        "table_mcon",
        "metric",
        "query_group_hash",
        "job_mcon",
        "job_run_id",
    )
    monitor_uuid = sgqlc.types.Field(UUID, graphql_name="monitorUuid")
    """The UUID of the monitor of the grouped events"""

    event_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="eventType")
    """The type of the grouped events"""

    table_mcon = sgqlc.types.Field(String, graphql_name="tableMcon")
    """MCON of the table of the grouped events"""

    metric = sgqlc.types.Field(String, graphql_name="metric")
    """The metric type of the grouped events"""

    query_group_hash = sgqlc.types.Field(String, graphql_name="queryGroupHash")
    """Hash used to group events related to the same query"""

    job_mcon = sgqlc.types.Field(String, graphql_name="jobMcon")
    """MCON of the job of the grouped events"""

    job_run_id = sgqlc.types.Field(String, graphql_name="jobRunId")
    """Run ID of the job/DAG of the grouped events"""


class EventGroupMetadata(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "newest_event_generated_time",
        "group_title",
        "table",
        "warehouse",
        "total_events",
    )
    newest_event_generated_time = sgqlc.types.Field(
        DateTime, graphql_name="newestEventGeneratedTime"
    )

    group_title = sgqlc.types.Field(String, graphql_name="groupTitle")

    table = sgqlc.types.Field("WarehouseTable", graphql_name="table")

    warehouse = sgqlc.types.Field("Warehouse", graphql_name="warehouse")

    total_events = sgqlc.types.Field(Int, graphql_name="totalEvents")
    """Total number of events in the event group"""


class EventMutingRule(sgqlc.types.Type):
    """Placeholder for deprecated API call"""

    __schema__ = schema
    __field_names__ = (
        "id",
        "uuid",
        "warehouse",
        "rule_type",
        "rule",
        "is_active",
        "created_time",
        "last_update_time",
        "event_types",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")

    warehouse = sgqlc.types.Field(sgqlc.types.non_null("Warehouse"), graphql_name="warehouse")

    rule_type = sgqlc.types.Field(
        sgqlc.types.non_null(EventMutingRuleModelRuleType), graphql_name="ruleType"
    )

    rule = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="rule")

    is_active = sgqlc.types.Field(Boolean, graphql_name="isActive")

    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdTime")

    last_update_time = sgqlc.types.Field(
        sgqlc.types.non_null(DateTime), graphql_name="lastUpdateTime"
    )

    event_types = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="eventTypes"
    )


class EventOnbardingConfig(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("account_uuid", "config")
    account_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="accountUuid")

    config = sgqlc.types.Field(JSONString, graphql_name="config")
    """Onboarding Config meant to be shared between customers and MC"""


class EventRcaData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("event_uuid", "rcas")
    event_uuid = sgqlc.types.Field(UUID, graphql_name="eventUuid")

    rcas = sgqlc.types.Field(sgqlc.types.list_of("ExtendedRca"), graphql_name="rcas")


class EventRcaStatus(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "event", "rca", "set_ts", "reason", "rca_module", "rca_job_uuid")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    event = sgqlc.types.Field(sgqlc.types.non_null("Event"), graphql_name="event")

    rca = sgqlc.types.Field("RcaJob", graphql_name="rca")

    set_ts = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="setTs")

    reason = sgqlc.types.Field(
        sgqlc.types.non_null(EventRcaStatusModelReason), graphql_name="reason"
    )
    """Reason why RCA was assigned a specific status."""

    rca_module = sgqlc.types.Field(String, graphql_name="rcaModule")
    """The RCA module that detected the failure reason"""

    rca_job_uuid = sgqlc.types.Field(UUID, graphql_name="rcaJobUuid")
    """UUID of the RCA job associated with the status"""


class EventRcaStatusModelType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "event", "rca", "set_ts", "reason", "rca_module")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    event = sgqlc.types.Field(sgqlc.types.non_null("Event"), graphql_name="event")

    rca = sgqlc.types.Field("RcaJob", graphql_name="rca")

    set_ts = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="setTs")

    reason = sgqlc.types.Field(
        sgqlc.types.non_null(EventRcaStatusModelReason), graphql_name="reason"
    )
    """Reason why RCA was assigned a specific status."""

    rca_module = sgqlc.types.Field(String, graphql_name="rcaModule")
    """The RCA module that detected the failure reason"""


class EventStateSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "open",
        "false_positive",
        "no_action_required",
        "notified",
        "resolved",
        "user_resolved",
        "system_resolved",
        "muted",
        "stale",
    )
    open = sgqlc.types.Field(Int, graphql_name="open")

    false_positive = sgqlc.types.Field(Int, graphql_name="falsePositive")

    no_action_required = sgqlc.types.Field(Int, graphql_name="noActionRequired")

    notified = sgqlc.types.Field(Int, graphql_name="notified")

    resolved = sgqlc.types.Field(Int, graphql_name="resolved")

    user_resolved = sgqlc.types.Field(Int, graphql_name="userResolved")

    system_resolved = sgqlc.types.Field(Int, graphql_name="systemResolved")

    muted = sgqlc.types.Field(Int, graphql_name="muted")

    stale = sgqlc.types.Field(Int, graphql_name="stale")


class EventTopology(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("event", "upstream")
    event = sgqlc.types.Field("Event", graphql_name="event")
    """Reference to an event"""

    upstream = sgqlc.types.Field(sgqlc.types.list_of("Event"), graphql_name="upstream")
    """List of events immediately upstream"""


class EventTypeSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "schema_change",
        "fresh_anom",
        "unchanged_size_anom",
        "json_schema_change",
        "delete_table",
        "size_anom",
        "size_diff",
        "metric_anom",
        "metric_comparison_anom",
        "agent_anom",
        "custom_rule_anom",
        "validation_anom",
        "dist_anom",
        "query_runtime_anom",
        "query_performance_anom",
        "dbt_model_error",
        "dbt_test_failure",
        "dbt_test_warning",
        "dbt_snapshot_error",
        "dbt_seed_error",
        "airflow_dag_failure",
        "databricks_job_failure",
        "adf_job_failure",
        "rule_run_failure",
        "comparison_rule_anom",
    )
    schema_change = sgqlc.types.Field(Int, graphql_name="schemaChange")

    fresh_anom = sgqlc.types.Field(Int, graphql_name="freshAnom")

    unchanged_size_anom = sgqlc.types.Field(Int, graphql_name="unchangedSizeAnom")

    json_schema_change = sgqlc.types.Field(Int, graphql_name="jsonSchemaChange")

    delete_table = sgqlc.types.Field(Int, graphql_name="deleteTable")

    size_anom = sgqlc.types.Field(Int, graphql_name="sizeAnom")

    size_diff = sgqlc.types.Field(Int, graphql_name="sizeDiff")

    metric_anom = sgqlc.types.Field(Int, graphql_name="metricAnom")

    metric_comparison_anom = sgqlc.types.Field(Int, graphql_name="metricComparisonAnom")

    agent_anom = sgqlc.types.Field(Int, graphql_name="agentAnom")

    custom_rule_anom = sgqlc.types.Field(Int, graphql_name="customRuleAnom")

    validation_anom = sgqlc.types.Field(Int, graphql_name="validationAnom")

    dist_anom = sgqlc.types.Field(Int, graphql_name="distAnom")

    query_runtime_anom = sgqlc.types.Field(Int, graphql_name="queryRuntimeAnom")

    query_performance_anom = sgqlc.types.Field(Int, graphql_name="queryPerformanceAnom")

    dbt_model_error = sgqlc.types.Field(Int, graphql_name="dbtModelError")

    dbt_test_failure = sgqlc.types.Field(Int, graphql_name="dbtTestFailure")

    dbt_test_warning = sgqlc.types.Field(Int, graphql_name="dbtTestWarning")

    dbt_snapshot_error = sgqlc.types.Field(Int, graphql_name="dbtSnapshotError")

    dbt_seed_error = sgqlc.types.Field(Int, graphql_name="dbtSeedError")

    airflow_dag_failure = sgqlc.types.Field(Int, graphql_name="airflowDagFailure")

    databricks_job_failure = sgqlc.types.Field(Int, graphql_name="databricksJobFailure")

    adf_job_failure = sgqlc.types.Field(Int, graphql_name="adfJobFailure")

    rule_run_failure = sgqlc.types.Field(Int, graphql_name="ruleRunFailure")

    comparison_rule_anom = sgqlc.types.Field(Int, graphql_name="comparisonRuleAnom")


class ExecDashboardDataColumn(sgqlc.types.Type):
    """A column for a table."""

    __schema__ = schema
    __field_names__ = ("name", "type")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Name associated with the column, can be used to identify it."""

    type = sgqlc.types.Field(sgqlc.types.non_null(DataColumnTypes), graphql_name="type")
    """Data type of the values included in the column."""


class ExecDashboardDataPoint(sgqlc.types.Type):
    """A single measure/data point for a metric."""

    __schema__ = schema
    __field_names__ = ("value", "period_start", "dimension", "children")
    value = sgqlc.types.Field(Float, graphql_name="value")
    """Value of data point."""

    period_start = sgqlc.types.Field(DateTime, graphql_name="periodStart")
    """Start of period for data point, for time series."""

    dimension = sgqlc.types.Field(String, graphql_name="dimension")
    """Dimension of data point, for category series."""

    children = sgqlc.types.Field(
        sgqlc.types.list_of("ExecDashboardDataPoint"), graphql_name="children"
    )


class ExecDashboardDataRow(sgqlc.types.Type):
    """A row with values for each column."""

    __schema__ = schema
    __field_names__ = ("values",)
    values = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="values")
    """Values for each column in the row."""


class ExecDashboardMetric(sgqlc.types.Type):
    """A set of data points (or single data point) that is a named
    measure.
    """

    __schema__ = schema
    __field_names__ = ("metric", "data_points", "has_error")
    metric = sgqlc.types.Field(sgqlc.types.non_null(ExecDashboardMetrics), graphql_name="metric")
    """Metric identifier."""

    data_points = sgqlc.types.Field(
        sgqlc.types.list_of(ExecDashboardDataPoint), graphql_name="dataPoints"
    )
    """Data points. May only be one for single-value metrics."""

    has_error = sgqlc.types.Field(Boolean, graphql_name="hasError")
    """If true, indicates an error occurred trying to get metric data."""


class ExecDashboardTable(sgqlc.types.Type):
    """A table with measured values."""

    __schema__ = schema
    __field_names__ = ("table", "data_columns", "data_rows", "is_visible", "has_error")
    table = sgqlc.types.Field(sgqlc.types.non_null(ExecDashboardTables), graphql_name="table")
    """Table identifier."""

    data_columns = sgqlc.types.Field(
        sgqlc.types.list_of(ExecDashboardDataColumn), graphql_name="dataColumns"
    )
    """Column definitions."""

    data_rows = sgqlc.types.Field(
        sgqlc.types.list_of(ExecDashboardDataRow), graphql_name="dataRows"
    )
    """Row values."""

    is_visible = sgqlc.types.Field(Boolean, graphql_name="isVisible")
    """If true, indicates that the table must be shown, otherwise it
    should be hidden.
    """

    has_error = sgqlc.types.Field(Boolean, graphql_name="hasError")
    """If true, indicates an error occurred trying to get metric data."""


class ExplanationDataPointType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "query_id",
        "timestamp",
        "execution_time",
        "baseline_metric",
        "pct_increase_over_baseline_upper_threshold",
        "is_breach",
    )
    query_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="queryId")
    """Query ID of query execution"""

    timestamp = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="timestamp")
    """Timestamp of query"""

    execution_time = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="executionTime")
    """Execution time of query"""

    baseline_metric = sgqlc.types.Field(Float, graphql_name="baselineMetric")
    """Historical baseline metric"""

    pct_increase_over_baseline_upper_threshold = sgqlc.types.Field(
        Float, graphql_name="pctIncreaseOverBaselineUpperThreshold"
    )
    """Upper threshold of % increase over historical baseline metric"""

    is_breach = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isBreach")
    """True if this query execution breaches monitor."""


class ExplanatoryFieldMetadata(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("candidates",)
    candidates = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="candidates")
    """Fields which can be used as explanatory"""


class ExtendedDataSource(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "data_source",
        "dw_id",
        "where_condition",
        "segments",
        "connection_uuid",
        "timeout",
        "uuid",
        "segment_count_hint",
    )
    data_source = sgqlc.types.Field(
        sgqlc.types.non_null(DataSourceInputInterface), graphql_name="dataSource"
    )
    """Data source can be table or sql."""

    dw_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="dwId")
    """Warehouse of the data source."""

    where_condition = sgqlc.types.Field(String, graphql_name="whereCondition")
    """Where condition used for table data source."""

    segments = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(FilterValueInterface)), graphql_name="segments"
    )
    """segments for data source."""

    connection_uuid = sgqlc.types.Field(UUID, graphql_name="connectionUuid")
    """Connection UUID for the data source."""

    timeout = sgqlc.types.Field(Int, graphql_name="timeout")
    """Timeout for the SQL query."""

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """UUID of the data source."""

    segment_count_hint = sgqlc.types.Field(Int, graphql_name="segmentCountHint")
    """Segment count from the previous run."""


class FHEvent(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "event_uuid",
        "alert_uuid",
        "where_condition",
        "metric",
        "field",
        "value",
        "date",
        "lower_threshold",
        "upper_threshold",
        "threshold_type",
        "comparison_operator",
        "auto_operator",
        "custom_metric_display_name",
        "custom_metric_sql_expression",
        "historical_mean",
        "detector_feedback",
        "agg_time_interval",
        "event_type",
        "time_series_uuid",
        "parent_time_series_uuid",
    )
    event_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="eventUuid")
    """UUID of the anomaly event"""

    alert_uuid = sgqlc.types.Field(UUID, graphql_name="alertUuid")
    """UUID of the alert associated with this event"""

    where_condition = sgqlc.types.Field(String, graphql_name="whereCondition")
    """Segmented where condition"""

    metric = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="metric")
    """Metric name"""

    field = sgqlc.types.Field(String, graphql_name="field")
    """Field name"""

    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="value")
    """Value"""

    date = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="date")
    """Timestamp of the event"""

    lower_threshold = sgqlc.types.Field(Float, graphql_name="lowerThreshold")
    """Lower threshold"""

    upper_threshold = sgqlc.types.Field(Float, graphql_name="upperThreshold")
    """Upper threshold"""

    threshold_type = sgqlc.types.Field(String, graphql_name="thresholdType")
    """Threshold type (explicit or auto)"""

    comparison_operator = sgqlc.types.Field(
        CustomRuleComparisonOperator, graphql_name="comparisonOperator"
    )
    """Threshold comparison operator"""

    auto_operator = sgqlc.types.Field(AutoOperator, graphql_name="autoOperator")
    """Operator used (when using automatic operators)"""

    custom_metric_display_name = sgqlc.types.Field(String, graphql_name="customMetricDisplayName")
    """Display name of the custom metric"""

    custom_metric_sql_expression = sgqlc.types.Field(
        String, graphql_name="customMetricSqlExpression"
    )
    """SQL expression evaluated for the custom metric"""

    historical_mean = sgqlc.types.Field(Float, graphql_name="historicalMean")
    """Historical mean value"""

    detector_feedback = sgqlc.types.Field("EventDetectorFeedback", graphql_name="detectorFeedback")
    """Feedback for the detector about the event"""

    agg_time_interval = sgqlc.types.Field(MonitorAggTimeInterval, graphql_name="aggTimeInterval")
    """Aggregation time interval. When not using a hourly interval, the
    timecomponent of the event timestamp should be ignored.
    """

    event_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="eventType")
    """Type of the event"""

    time_series_uuid = sgqlc.types.Field(UUID, graphql_name="timeSeriesUuid")
    """Time series UUID"""

    parent_time_series_uuid = sgqlc.types.Field(UUID, graphql_name="parentTimeSeriesUuid")
    """Parent time series UUID"""


class FHEvents(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("events", "total_count")
    events = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(FHEvent))),
        graphql_name="events",
    )
    """List of events"""

    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="totalCount")
    """Total number of results available"""


class FHEventsFilterValues(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("values", "total_count")
    values = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="values",
    )
    """List of values"""

    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="totalCount")
    """Total number of results available"""


class FHNumericRcaResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("rca",)
    rca = sgqlc.types.Field(sgqlc.types.list_of("FHNumericResult"), graphql_name="rca")


class FHNumericResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "metric_name",
        "metric_field_name",
        "explanatory_field_name",
        "explanatory_field_value",
        "normal_row_ratio",
        "anomalous_row_ratio",
        "normal_metric_value",
        "anomalous_metric_value",
        "explainability1",
        "explainability2",
        "correlation",
    )
    metric_name = sgqlc.types.Field(String, graphql_name="metricName")
    """The metric which we ran the correlation for (i.e. mean, p80, etc.)"""

    metric_field_name = sgqlc.types.Field(String, graphql_name="metricFieldName")
    """The name of the field we ran the correlation for"""

    explanatory_field_name = sgqlc.types.Field(String, graphql_name="explanatoryFieldName")
    """The name of the column in which a value is correlated with the
    anomalous rows
    """

    explanatory_field_value = sgqlc.types.Field(String, graphql_name="explanatoryFieldValue")
    """The value correlated with the anomalous rows"""

    normal_row_ratio = sgqlc.types.Field(Float, graphql_name="normalRowRatio")
    """The ratio of rows out of total rows for the explanatory value
    prior to the anomaly
    """

    anomalous_row_ratio = sgqlc.types.Field(Float, graphql_name="anomalousRowRatio")
    """The ratio of rows out of total rows for the explanatory value in
    the anomalous rows
    """

    normal_metric_value = sgqlc.types.Field(Float, graphql_name="normalMetricValue")
    """The value of the relevant metric prior to the anomaly"""

    anomalous_metric_value = sgqlc.types.Field(Float, graphql_name="anomalousMetricValue")
    """The value of metric in the anomalous rows"""

    explainability1 = sgqlc.types.Field(Float, graphql_name="explainability1")
    """Explainability 1 score"""

    explainability2 = sgqlc.types.Field(Float, graphql_name="explainability2")
    """Explainability 2 score"""

    correlation = sgqlc.types.Field(String, graphql_name="correlation")
    """high or low correlation found on field"""


class FacetEntry(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("key", "count", "display")
    key = sgqlc.types.Field(String, graphql_name="key")
    """Key of facet entry"""

    count = sgqlc.types.Field(Int, graphql_name="count")
    """Number of documents that contain key"""

    display = sgqlc.types.Field(String, graphql_name="display")
    """Display value of the facet entry"""


class FacetResultType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("value", "display_name", "count")
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")
    """Field value"""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """Display name"""

    count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="count")
    """Count"""


class FacetResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("facet_type", "entries")
    facet_type = sgqlc.types.Field(FacetType, graphql_name="facetType")
    """Facet type"""

    entries = sgqlc.types.Field(sgqlc.types.list_of(FacetEntry), graphql_name="entries")
    """Facet entries"""


class FieldChange(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("field", "friendly_name", "scalar_change", "many_to_many_change")
    field = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="field")
    """The name of the changed field"""

    friendly_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="friendlyName")
    """Friendly name of the changed field"""

    scalar_change = sgqlc.types.Field("ScalarChange", graphql_name="scalarChange")
    """Change to scalar field"""

    many_to_many_change = sgqlc.types.Field("ManyToManyChange", graphql_name="manyToManyChange")
    """Change to M2M field"""


class FieldConfig(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("type", "count", "field")
    type = sgqlc.types.Field(sgqlc.types.non_null(FieldConfigType), graphql_name="type")

    count = sgqlc.types.Field(Int, graphql_name="count")

    field = sgqlc.types.Field(String, graphql_name="field")


class FieldDistRcaData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("time_field", "anom_time", "explanatory_field", "val")
    time_field = sgqlc.types.Field(String, graphql_name="timeField")
    """Table field which serves as a time axis"""

    anom_time = sgqlc.types.Field(DateTime, graphql_name="anomTime")
    """Time when the anomaly occurred"""

    explanatory_field = sgqlc.types.Field(String, graphql_name="explanatoryField")
    """Table field containing the explanatory value"""

    val = sgqlc.types.Field(String, graphql_name="val")
    """Explanatory value used in the analysis"""


class FieldDistRcaResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("rca", "plot_data", "low_card_fields_wo_rca", "available_fields")
    rca = sgqlc.types.Field(sgqlc.types.list_of(FieldDistRcaData), graphql_name="rca")

    plot_data = sgqlc.types.Field(
        sgqlc.types.list_of("RcaPlotData"),
        graphql_name="plotData",
        args=sgqlc.types.ArgDict(
            (("field_name", sgqlc.types.Arg(String, graphql_name="fieldName", default=None)),)
        ),
    )
    """Arguments:

    * `field_name` (`String`)None
    """

    low_card_fields_wo_rca = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="lowCardFieldsWoRca"
    )

    available_fields = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="availableFields"
    )


class FieldDownstreamBi(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "bi_account_id",
        "bi_identifier",
        "bi_name",
        "bi_type",
        "bi_node_id",
        "last_seen",
    )
    bi_account_id = sgqlc.types.Field(String, graphql_name="biAccountId")

    bi_identifier = sgqlc.types.Field(String, graphql_name="biIdentifier")

    bi_name = sgqlc.types.Field(String, graphql_name="biName")

    bi_type = sgqlc.types.Field(String, graphql_name="biType")

    bi_node_id = sgqlc.types.Field(String, graphql_name="biNodeId")

    last_seen = sgqlc.types.Field(DateTime, graphql_name="lastSeen")


class FieldHealth(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("lower", "upper", "status", "reason")
    lower = sgqlc.types.Field(Float, graphql_name="lower")
    """Field health lower threshold"""

    upper = sgqlc.types.Field(Float, graphql_name="upper")
    """Field health upper threshold"""

    status = sgqlc.types.Field(DetectorStatus, graphql_name="status")
    """Status of the FH detection"""

    reason = sgqlc.types.Field(String, graphql_name="reason")
    """Reason for not providing FH thresholds"""


class FieldHealthSampling(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "columns",
        "rows",
        "sampling_disabled",
        "next_file_index",
        "total_samples_size",
        "normal_records_query",
        "anomalous_records_query",
    )
    columns = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="columns")

    rows = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.list_of(String)), graphql_name="rows")

    sampling_disabled = sgqlc.types.Field(Boolean, graphql_name="samplingDisabled")

    next_file_index = sgqlc.types.Field(Int, graphql_name="nextFileIndex")
    """Next file index to retrieve."""

    total_samples_size = sgqlc.types.Field(Int, graphql_name="totalSamplesSize")
    """Total number of samples retrieved."""

    normal_records_query = sgqlc.types.Field(String, graphql_name="normalRecordsQuery")
    """This is null for summary statistics such as mean, min, max, and
    percentiles
    """

    anomalous_records_query = sgqlc.types.Field(String, graphql_name="anomalousRecordsQuery")


class FieldHealthSamplingConditionsResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("conditions",)
    conditions = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="conditions"
    )
    """List of conditions that can be used to construct sample query."""


class FieldMetadata(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("field_type", "table")
    field_type = sgqlc.types.Field(String, graphql_name="fieldType")

    table = sgqlc.types.Field("TableRef", graphql_name="table")


class FieldMetricDataResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("data", "sql_query", "field_name", "metric_info")
    data = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null("MetricMeasurement"))),
        graphql_name="data",
    )

    sql_query = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="sqlQuery")

    field_name = sgqlc.types.Field(String, graphql_name="fieldName")

    metric_info = sgqlc.types.Field(sgqlc.types.non_null("MetricInfo"), graphql_name="metricInfo")


class FieldMetricDefinition(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "name",
        "display_name",
        "description",
        "category",
        "unit",
        "is_percentage",
        "field_types",
        "deprecated",
        "supports_manual_threshold",
        "supports_auto_threshold",
        "supports_auto_high_threshold",
        "supports_auto_low_threshold",
        "is_grouped",
        "is_field_level",
    )
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Name of the field metric"""

    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")
    """Display name of the field metric"""

    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="description")
    """Description of the field metric"""

    category = sgqlc.types.Field(sgqlc.types.non_null(FieldMetricCategory), graphql_name="category")
    """Category of the field metric. For example, uniqueness, validity,
    etc
    """

    unit = sgqlc.types.Field(sgqlc.types.non_null("MetricUnit"), graphql_name="unit")
    """Unit of the field metric"""

    is_percentage = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isPercentage")
    """Whether this field metric represents a percentage metric. For
    example, % null
    """

    field_types = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(FieldType)), graphql_name="fieldTypes"
    )
    """A list of field types which this metric applies to"""

    deprecated = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="deprecated")
    """Indicates if the field metric was deprecated"""

    supports_manual_threshold = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="supportsManualThreshold"
    )
    """Indicates whether the metric can be used in a Metric Monitor with
    manual thresholds
    """

    supports_auto_threshold = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="supportsAutoThreshold"
    )
    """Indicates whether the metric can be used in a Metric Monitor with
    automatic thresholds
    """

    supports_auto_high_threshold = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="supportsAutoHighThreshold"
    )
    """Indicates whether the metric can be used in a Metric Monitor with
    automatic thresholds (considering only anomalously high values)
    """

    supports_auto_low_threshold = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="supportsAutoLowThreshold"
    )
    """Indicates whether the metric can be used in a Metric Monitor with
    automatic thresholds (considering only anomalously low values)
    """

    is_grouped = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isGrouped")
    """Indicates whether this metric is a collection (grouping) of other
    metrics
    """

    is_field_level = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isFieldLevel")
    """Indicates whether this metric is a field level metric"""


class FieldMetricFilterOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("field_name", "operator", "value")
    field_name = sgqlc.types.Field(String, graphql_name="fieldName")
    """Field to filter by"""

    operator = sgqlc.types.Field(
        sgqlc.types.non_null(CustomRuleComparisonOperator), graphql_name="operator"
    )
    """Operator to filter field by"""

    value = sgqlc.types.Field(String, graphql_name="value")
    """Value to filter field by"""


class FieldMetricOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "table_mcon",
        "table_mcons",
        "field_name",
        "field_names",
        "metric_type",
        "value_list",
        "value_sql",
        "filters",
    )
    table_mcon = sgqlc.types.Field(String, graphql_name="tableMcon")
    """MCON of the table the metric is based on"""

    table_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="tableMcons")
    """MCONs of the table the metric is based on"""

    field_name = sgqlc.types.Field(String, graphql_name="fieldName")
    """Name of the field the metric is based on"""

    field_names = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="fieldNames")
    """Name of the fields the metric is based on"""

    metric_type = sgqlc.types.Field(
        sgqlc.types.non_null(FieldMetricType), graphql_name="metricType"
    )
    """Type of metric to compute"""

    value_list = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="valueList")
    """Values for metrics that check for cardinality"""

    value_sql = sgqlc.types.Field(String, graphql_name="valueSql")
    """Values SQL expression for metrics that check for cardinality"""

    filters = sgqlc.types.Field(
        sgqlc.types.list_of(FieldMetricFilterOutput), graphql_name="filters"
    )
    """Filters for which rows the metric is computed over"""


class FieldMetricQuery(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("sql_query",)
    sql_query = sgqlc.types.Field(String, graphql_name="sqlQuery")
    """SQL query for the metric"""


class FieldOverviewProperty(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("metric_name", "display_name", "value", "metric_data_type")
    metric_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="metricName")

    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")

    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")

    metric_data_type = sgqlc.types.Field(
        sgqlc.types.non_null(MetricDataType), graphql_name="metricDataType"
    )


class FieldOverviewResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("sql_query", "properties")
    sql_query = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="sqlQuery")

    properties = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(FieldOverviewProperty))),
        graphql_name="properties",
    )


class FieldQuery(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("sql_query", "variables")
    sql_query = sgqlc.types.Field(String, graphql_name="sqlQuery")
    """SQL query"""

    variables = sgqlc.types.Field(JSONString, graphql_name="variables")
    """Possible variable values for SQL query"""


class FieldQueryFilterOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("field_name", "operator", "value")
    field_name = sgqlc.types.Field(String, graphql_name="fieldName")
    """Field to filter by"""

    operator = sgqlc.types.Field(
        sgqlc.types.non_null(CustomRuleComparisonOperator), graphql_name="operator"
    )
    """Operator to filter field by"""

    value = sgqlc.types.Field(String, graphql_name="value")
    """Value to filter field by"""


class FieldQueryParametersOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "table_mcons",
        "field_names",
        "query_type",
        "value_list",
        "value_sql",
        "filters",
    )
    table_mcons = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name="tableMcons"
    )
    """MCONs of the table the query is based on"""

    field_names = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name="fieldNames"
    )
    """Name of the fields the query is based on"""

    query_type = sgqlc.types.Field(sgqlc.types.non_null(FieldQueryType), graphql_name="queryType")
    """Type of query"""

    value_list = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="valueList")
    """Values for queries that check for cardinality"""

    value_sql = sgqlc.types.Field(String, graphql_name="valueSql")
    """Values SQL expression for metrics that check for cardinality"""

    filters = sgqlc.types.Field(sgqlc.types.list_of(FieldQueryFilterOutput), graphql_name="filters")
    """Filters for which rows the query is computed over"""


class FieldTypeChange(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("field_name", "new_field_type", "old_field_type")
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="fieldName")

    new_field_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="newFieldType")

    old_field_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="oldFieldType")


class FieldValueCorrelation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("field", "value", "norm_rate", "anom_rate")
    field = sgqlc.types.Field(String, graphql_name="field")

    value = sgqlc.types.Field(String, graphql_name="value")

    norm_rate = sgqlc.types.Field(Float, graphql_name="normRate")

    anom_rate = sgqlc.types.Field(Float, graphql_name="anomRate")


class FilterPredicate(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("name", "negated")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")

    negated = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="negated")


class FivetranConnectorConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("FivetranConnectorEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class FivetranConnectorEdge(sgqlc.types.Type):
    """A Relay edge containing a `FivetranConnector` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("FivetranConnector", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class FivetranDestinationConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("FivetranDestinationEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class FivetranDestinationEdge(sgqlc.types.Type):
    """A Relay edge containing a `FivetranDestination` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("FivetranDestination", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class FlattenedLineageGraphEdges(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("mcon", "directly_connected_mcons", "directly_connected_nodes")
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """Monte Carlo full identifier for an entity"""

    directly_connected_mcons = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="directlyConnectedMcons"
    )
    """MCONs of nodes directly connected to the entity"""

    directly_connected_nodes = sgqlc.types.Field(
        sgqlc.types.list_of("LineageGraphEdgeNode"), graphql_name="directlyConnectedNodes"
    )
    """Nodes directly connected to the entity, including edge properties"""


class Freshness(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "status",
        "expected",
        "breach",
        "reason",
        "last_update",
        "detector_threshold",
        "threshold_low",
        "threshold_medium",
        "threshold_high",
    )
    status = sgqlc.types.Field(DetectorStatus, graphql_name="status")
    """Status of the freshness detector"""

    expected = sgqlc.types.Field(Float, graphql_name="expected")
    """Deprecated: Time delta of next expected update (in seconds)"""

    breach = sgqlc.types.Field(Float, graphql_name="breach")
    """Deprecated: Time delta when a delay is considered a breach (in
    seconds)
    """

    reason = sgqlc.types.Field(String, graphql_name="reason")
    """Explanation if expected and/or breach is missing"""

    last_update = sgqlc.types.Field(DateTime, graphql_name="lastUpdate")
    """Deprecated, use getMetricsV4: Last time the table was updated"""

    detector_threshold = sgqlc.types.Field(Float, graphql_name="detectorThreshold")
    """Deprecated: The threshold calculated by the detector model"""

    threshold_low = sgqlc.types.Field(Float, graphql_name="thresholdLow")
    """The "low" level threshold calculated by the detector model"""

    threshold_medium = sgqlc.types.Field(Float, graphql_name="thresholdMedium")
    """The "medium" level threshold calculated by the detector model"""

    threshold_high = sgqlc.types.Field(Float, graphql_name="thresholdHigh")
    """The "high" level threshold calculated by the detector model"""


class FreshnessAutomatedAlertConditionOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("sensitivity_level",)
    sensitivity_level = sgqlc.types.Field(
        sgqlc.types.non_null(SensitivityLevels), graphql_name="sensitivityLevel"
    )
    """Sensitivity for automated thresholds"""


class FreshnessDetectorThresholdOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("value",)
    value = sgqlc.types.Field(sgqlc.types.non_null("ThresholdLMHType"), graphql_name="value")
    """Thresholds in minutes"""


class FreshnessExplicitAlertConditionOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "start_time",
        "interval_minutes",
        "interval_crontab",
        "interval_crontab_day_or",
        "timezone",
        "is_auto_schedule_config",
        "threshold",
    )
    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """Start time of the collection"""

    interval_minutes = sgqlc.types.Field(Int, graphql_name="intervalMinutes")
    """Collection interval in minutes"""

    interval_crontab = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="intervalCrontab"
    )
    """Collection interval in crontab format"""

    interval_crontab_day_or = sgqlc.types.Field(Boolean, graphql_name="intervalCrontabDayOr")
    """If true, use default cron behavior and run when day-of-month OR
    day-of-week match. If false, use alternate behavior and run when
    day-of-month AND day-of-week match.
    """

    timezone = sgqlc.types.Field(String, graphql_name="timezone")
    """Timezone for daylight savings and interpreting cron expressions"""

    is_auto_schedule_config = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="isAutoScheduleConfig"
    )
    """True if auto schedule configuration is used"""

    threshold = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="threshold")
    """Explicit freshness threshold in minutes"""


class FreshnessTableMonitorConfigOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "uuid",
        "status",
        "metric",
        "most_recent_value",
        "collection_status",
        "supports_explicit_alert_condition",
        "tags",
        "data_quality_dimension",
        "alert_condition",
        "detector_threshold",
    )
    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """UUID of the underlying OOTB replacement rule"""

    status = sgqlc.types.Field(
        sgqlc.types.non_null(ConsolidatedMonitorStatusType), graphql_name="status"
    )
    """Detection status"""

    metric = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="metric")
    """Name of metric for which the detector is active"""

    most_recent_value = sgqlc.types.Field(Float, graphql_name="mostRecentValue")
    """Most recent value change analyzed by the detector"""

    collection_status = sgqlc.types.Field(
        sgqlc.types.non_null(CollectionStatusOutput), graphql_name="collectionStatus"
    )
    """Collection status information"""

    supports_explicit_alert_condition = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="supportsExplicitAlertCondition"
    )
    """True if using the explicit alert condition is supported"""

    tags = sgqlc.types.Field(sgqlc.types.list_of("TagKeyValuePairOutput"), graphql_name="tags")
    """Tags for the alert condition"""

    data_quality_dimension = sgqlc.types.Field(String, graphql_name="dataQualityDimension")
    """Data quality dimension for the alert condition"""

    alert_condition = sgqlc.types.Field(
        sgqlc.types.non_null("FreshnessAlertConditionOutput"), graphql_name="alertCondition"
    )
    """Alert condition configuration"""

    detector_threshold = sgqlc.types.Field(
        sgqlc.types.non_null(FreshnessDetectorThresholdOutput), graphql_name="detectorThreshold"
    )
    """Detector freshness threshold"""


class GenerateCollectorTemplate(sgqlc.types.Type):
    """Generate a data collector template (uploaded to S3)"""

    __schema__ = schema
    __field_names__ = ("dc",)
    dc = sgqlc.types.Field(DataCollector, graphql_name="dc")
    """The data collector that was created or updated"""


class GenerateDcUpgradeTemplate(sgqlc.types.Type):
    """Generates a template for DC upgrade and a URL to execute the
    template in the cloud provider.
    """

    __schema__ = schema
    __field_names__ = (
        "upgrade_launch_url",
        "template_url",
        "code_version",
        "template_version",
        "template_variant",
        "is_mc_hosted",
        "is_up_to_date",
    )
    upgrade_launch_url = sgqlc.types.Field(String, graphql_name="upgradeLaunchUrl")
    """A link that launches the upgrade flow (for instance in AWS
    CloudFormation) that customers can complete to upgrade a data
    collector stack.
    """

    template_url = sgqlc.types.Field(String, graphql_name="templateUrl")
    """A link to the deployment template URL (for instance an AWS S3
    URL). This can be used to diff against an existing deployment
    template and review upgrades.
    """

    code_version = sgqlc.types.Field(String, graphql_name="codeVersion")
    """The code version of the upgrade."""

    template_version = sgqlc.types.Field(String, graphql_name="templateVersion")
    """The template version of the upgrade."""

    template_variant = sgqlc.types.Field(String, graphql_name="templateVariant")
    """The template variant of the upgrade."""

    is_mc_hosted = sgqlc.types.Field(Boolean, graphql_name="isMcHosted")
    """Indicates whether the data collector is hosted by Monte Carlo."""

    is_up_to_date = sgqlc.types.Field(Boolean, graphql_name="isUpToDate")
    """Indicates whether the data collector is already running on the
    latest code and infrastructure.
    """


class GenerateReport(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("report_job_id",)
    report_job_id = sgqlc.types.Field(UUID, graphql_name="reportJobId")


class GenerateWebhookUrl(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("webhook_url", "webhook_id", "service")
    webhook_url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="webhookUrl")
    """Generate a webhook URL"""

    webhook_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="webhookId")
    """The ID of the webhook"""

    service = sgqlc.types.Field(sgqlc.types.non_null(WebhookServiceTypes), graphql_name="service")
    """The external service"""


class GetAccountAuditLogsResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("records", "page_info")
    records = sgqlc.types.Field(sgqlc.types.list_of(AccountAuditLog), graphql_name="records")
    """List of audit log records"""

    page_info = sgqlc.types.Field("PageInfo", graphql_name="pageInfo")
    """Pagination info"""


class GetAlationTableFlags(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("flag_type", "flag_reason")
    flag_type = sgqlc.types.Field(sgqlc.types.non_null(TableFlagType), graphql_name="flagType")
    """The type of the flag. Either WARNING or DEPRECATION"""

    flag_reason = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="flagReason")
    """A reason or a description of the flag"""


class GetTableauAssetWarningByIdResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("message",)
    message = sgqlc.types.Field(String, graphql_name="message")
    """The message body of the warning."""


class GithubAppInfo(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("install_link", "installations")
    install_link = sgqlc.types.Field(String, graphql_name="installLink")
    """Link to click in order to install new Github integration"""

    installations = sgqlc.types.Field(
        sgqlc.types.list_of("GithubAppInstallation"), graphql_name="installations"
    )
    """Metadata about Github App installation"""


class GithubAppInstallation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "uuid",
        "show_impact_analysis",
        "host",
        "settings_link",
        "gh_org",
        "display_name",
    )
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """Internal Github installation uuid"""

    show_impact_analysis = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="showImpactAnalysis"
    )
    """Controls whether or not to show impacted models and reports as a
    PR comment
    """

    host = sgqlc.types.Field(String, graphql_name="host")

    settings_link = sgqlc.types.Field(String, graphql_name="settingsLink")
    """Link to click in order to configure Github App installation"""

    gh_org = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="ghOrg")
    """GitHub organization name"""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")


class GithubPullRequestConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("GithubPullRequestEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class GithubPullRequestEdge(sgqlc.types.Type):
    """A Relay edge containing a `GithubPullRequest` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("GithubPullRequest", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class GithubPullRequestFile(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("path", "change_type", "additions", "deletions")
    path = sgqlc.types.Field(String, graphql_name="path")
    """File path from the root of the repository"""

    change_type = sgqlc.types.Field(String, graphql_name="changeType")
    """File change type: added, modified, removed"""

    additions = sgqlc.types.Field(Int, graphql_name="additions")
    """Number of lines added"""

    deletions = sgqlc.types.Field(Int, graphql_name="deletions")
    """Number of lines deleted"""


class GithubPullRequestImpact(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("mcon",)
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """MCON of a table impacted by the pull request"""


class GithubPullRequestInsight(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("pull_request",)
    pull_request = sgqlc.types.Field(
        sgqlc.types.non_null("GithubPullRequest"), graphql_name="pullRequest"
    )
    """Reference to the pull request identified as root cause"""


class GithubPullRequestsList(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("pull_requests",)
    pull_requests = sgqlc.types.Field(
        sgqlc.types.list_of("GithubPullRequest"), graphql_name="pullRequests"
    )
    """List of pull requests"""


class GithubUser(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("login", "avatar_url", "url")
    login = sgqlc.types.Field(String, graphql_name="login")
    """User login"""

    avatar_url = sgqlc.types.Field(String, graphql_name="avatarUrl")
    """User Avatar URL"""

    url = sgqlc.types.Field(String, graphql_name="url")
    """User webpage url"""


class GitlabAppInfo(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("install_link", "installations")
    install_link = sgqlc.types.Field(String, graphql_name="installLink")
    """Link to click in order to install new Gitlab integration"""

    installations = sgqlc.types.Field(
        sgqlc.types.list_of("GitlabAppInstallation"), graphql_name="installations"
    )
    """Metadata about Gitlab App installation"""


class GitlabAppInstallation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid", "show_impact_analysis", "host", "project_selection", "display_name")
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """Internal Github installation uuid"""

    show_impact_analysis = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="showImpactAnalysis"
    )
    """Controls whether or not to show impacted models and reports as a
    PR comment
    """

    host = sgqlc.types.Field(String, graphql_name="host")

    project_selection = sgqlc.types.Field(
        sgqlc.types.list_of("GitlabProjectSelection"), graphql_name="projectSelection"
    )
    """Projects selected for the Gitlab installation"""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")


class GitlabEntityRef(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "name", "path")
    id = sgqlc.types.Field(Int, graphql_name="id")

    name = sgqlc.types.Field(String, graphql_name="name")

    path = sgqlc.types.Field(String, graphql_name="path")


class GitlabNamespace(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("namespace", "namespace_id", "select_all", "projects", "webhook_err")
    namespace = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="namespace")
    """Name of the GitLab group"""

    namespace_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="namespaceId")
    """ID of the GitLab group"""

    select_all = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="selectAll")
    """True if all the projects in the namespace are selected"""

    projects = sgqlc.types.Field(sgqlc.types.list_of("GitlabProject"), graphql_name="projects")
    """List of projects in the namespace"""

    webhook_err = sgqlc.types.Field(String, graphql_name="webhookErr")
    """Error message if webhook creation failed"""


class GitlabProject(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "name", "selected")
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="id")
    """ID of the project"""

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Name of the project"""

    selected = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="selected")
    """True if the project is selected"""


class GitlabProjectSelection(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("namespace_id", "parents", "projects", "webhook_err", "select_all")
    namespace_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="namespaceId")
    """ID of the Gitlab group or subgroup"""

    parents = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name="parents")

    projects = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name="projects")

    webhook_err = sgqlc.types.Field(String, graphql_name="webhookErr")
    """Error message in case of webhook creation failure"""

    select_all = sgqlc.types.Field(Boolean, graphql_name="selectAll")


class GitlabTraversalResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("groups", "projects")
    groups = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(GitlabEntityRef)), graphql_name="groups"
    )

    projects = sgqlc.types.Field(sgqlc.types.list_of(GitlabEntityRef), graphql_name="projects")


class GraphEdge(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("source", "destination", "source_id", "destination_id", "hidden")
    source = sgqlc.types.Field(String, graphql_name="source")

    destination = sgqlc.types.Field(String, graphql_name="destination")

    source_id = sgqlc.types.Field(Int, graphql_name="sourceId")

    destination_id = sgqlc.types.Field(Int, graphql_name="destinationId")

    hidden = sgqlc.types.Field(Boolean, graphql_name="hidden")


class HighlightSnippets(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("field_name", "snippets")
    field_name = sgqlc.types.Field(String, graphql_name="fieldName")
    """Field name"""

    snippets = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="snippets")
    """Highlighted snippet"""


class HolidayCode(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("code",)
    code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="code")
    """Country or financial market code"""


class HolidayName(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("name", "next_date", "occurrence")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Holiday name"""

    next_date = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="nextDate")
    """Date"""

    occurrence = sgqlc.types.Field(String, graphql_name="occurrence")
    """Textual description of when the holiday occurs"""


class HostingDomainDetails(sgqlc.types.Type):
    """Hosting domain information"""

    __schema__ = schema
    __field_names__ = ("ui", "api", "integrations")
    ui = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="ui")
    """Frontend URL"""

    api = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="api")
    """GraphQL API URL"""

    integrations = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="integrations")
    """Integrations Gateway URL"""


class HostingInformation(sgqlc.types.Type):
    """Hosting information"""

    __schema__ = schema
    __field_names__ = (
        "domain_details",
        "login_details",
        "infrastructure_details",
        "network_details",
        "collection_details",
        "available_env_configurations",
    )
    domain_details = sgqlc.types.Field(
        sgqlc.types.non_null(HostingDomainDetails), graphql_name="domainDetails"
    )
    """Hosting domain information"""

    login_details = sgqlc.types.Field(
        sgqlc.types.non_null("LoginDetails"), graphql_name="loginDetails"
    )
    """Login information"""

    infrastructure_details = sgqlc.types.Field(
        sgqlc.types.non_null("InfrastructureDetails"), graphql_name="infrastructureDetails"
    )
    """Infrastructure information"""

    network_details = sgqlc.types.Field(
        sgqlc.types.non_null("NetworkDetails"), graphql_name="networkDetails"
    )
    """Network information"""

    collection_details = sgqlc.types.Field(CollectionDetails, graphql_name="collectionDetails")
    """Collection platform information"""

    available_env_configurations = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(AwsEnvConfiguration)),
        graphql_name="availableEnvConfigurations",
    )
    """List of enabled configurations (primary/secondary)"""


class IncidentCategoryCount(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("incident_category", "category_count")
    incident_category = sgqlc.types.Field(IncidentCategory, graphql_name="incidentCategory")

    category_count = sgqlc.types.Field(Int, graphql_name="categoryCount")
    """Number of monitors in category"""


class IncidentConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges", "total_count")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("IncidentEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""

    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")
    """Both startTime and endTime must be supplied to get totalCount"""


class IncidentDailyCount(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("day", "incident_count")
    day = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name="day")
    """The date for the incident count"""

    incident_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="incidentCount")
    """The incident count"""


class IncidentDashboardData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "total_incident_count",
        "no_status_count",
        "investigating_count",
        "fixed_count",
        "expected_and_no_action_count",
    )
    total_incident_count = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="totalIncidentCount"
    )
    """The total count of incidents over the specified weeks"""

    no_status_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="noStatusCount")
    """The total count of incidents with no status over the specified
    weeks
    """

    investigating_count = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="investigatingCount"
    )
    """The total count of incidents with status of investigating over the
    specified weeks
    """

    fixed_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="fixedCount")
    """The total count of incidents with fixed status over the specified
    weeks
    """

    expected_and_no_action_count = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="expectedAndNoActionCount"
    )
    """The total count of incidents with status expected or no action
    over the specified weeks
    """


class IncidentEdge(sgqlc.types.Type):
    """A Relay edge containing a `Incident` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("Incident", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class IncidentRcaData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("primary_rca", "event_rcas", "incident_rcas")
    primary_rca = sgqlc.types.Field("PrimaryRcaData", graphql_name="primaryRca")

    event_rcas = sgqlc.types.Field(sgqlc.types.list_of(EventRcaData), graphql_name="eventRcas")

    incident_rcas = sgqlc.types.Field(
        sgqlc.types.list_of("IncidentScopedRcaData"), graphql_name="incidentRcas"
    )


class IncidentSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("incident_id", "types", "states", "tables", "key_assets", "has_rca")
    incident_id = sgqlc.types.Field(UUID, graphql_name="incidentId")

    types = sgqlc.types.Field(EventTypeSummary, graphql_name="types")

    states = sgqlc.types.Field(EventStateSummary, graphql_name="states")

    tables = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="tables")

    key_assets = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="keyAssets")
    """Key assets(tables) in incident"""

    has_rca = sgqlc.types.Field(Boolean, graphql_name="hasRca")
    """Deprecated: Whether an rca insight exists for this incident"""


class IncidentTableMcons(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("tables",)
    tables = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="tables")
    """The list of table mcons directly impacted by incident"""


class IncidentTimePeriodAggregateData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("start_date", "end_date", "values")
    start_date = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name="startDate")
    """The start date for the aggregated data"""

    end_date = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name="endDate")
    """The end date for the aggregated data"""

    values = sgqlc.types.Field(sgqlc.types.list_of("LabelCount"), graphql_name="values")
    """The aggregate label and count for the time time period"""


class IncidentTopology(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("root_events",)
    root_events = sgqlc.types.Field(sgqlc.types.list_of(EventTopology), graphql_name="rootEvents")
    """List of root events in the incident"""


class IncidentTypeSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "anomalies",
        "schema_changes",
        "json_schema_changes",
        "deleted_tables",
        "metric_anomalies",
        "agent_anomalies",
        "metric_comparison_anomalies",
        "custom_rule_anomalies",
        "performance_anomalies",
        "dbt_errors",
        "etl_errors",
        "pseudo_integration_test",
        "rule_run_execution_error",
        "merged",
    )
    anomalies = sgqlc.types.Field(Int, graphql_name="anomalies")

    schema_changes = sgqlc.types.Field(Int, graphql_name="schemaChanges")

    json_schema_changes = sgqlc.types.Field(Int, graphql_name="jsonSchemaChanges")

    deleted_tables = sgqlc.types.Field(Int, graphql_name="deletedTables")

    metric_anomalies = sgqlc.types.Field(Int, graphql_name="metricAnomalies")

    agent_anomalies = sgqlc.types.Field(Int, graphql_name="agentAnomalies")

    metric_comparison_anomalies = sgqlc.types.Field(Int, graphql_name="metricComparisonAnomalies")

    custom_rule_anomalies = sgqlc.types.Field(Int, graphql_name="customRuleAnomalies")

    performance_anomalies = sgqlc.types.Field(Int, graphql_name="performanceAnomalies")

    dbt_errors = sgqlc.types.Field(Int, graphql_name="dbtErrors")

    etl_errors = sgqlc.types.Field(Int, graphql_name="etlErrors")

    pseudo_integration_test = sgqlc.types.Field(Int, graphql_name="pseudoIntegrationTest")

    rule_run_execution_error = sgqlc.types.Field(Int, graphql_name="ruleRunExecutionError")

    merged = sgqlc.types.Field(Int, graphql_name="merged")


class IncidentWeeklyDataDashboard(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("weekly_data",)
    weekly_data = sgqlc.types.Field(
        sgqlc.types.list_of(IncidentTimePeriodAggregateData), graphql_name="weeklyData"
    )
    """The weekly incident data"""


class IncidentsCountByDate(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("date", "count")
    date = sgqlc.types.Field(Date, graphql_name="date")
    """Date of the count"""

    count = sgqlc.types.Field(Int, graphql_name="count")
    """Count of incidents on the date"""


class IncidentsCountByDateConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("IncidentsCountByDateEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class IncidentsCountByDateEdge(sgqlc.types.Type):
    """A Relay edge containing a `IncidentsCountByDate` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field(IncidentsCountByDate, graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class IncidentsFilter(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "field_name",
        "display_name",
        "incidents_parameter_name",
        "incidents_parameter_accepts_multiple_values",
        "facetable",
        "facet_searchable",
    )
    field_name = sgqlc.types.Field(String, graphql_name="fieldName")

    display_name = sgqlc.types.Field(String, graphql_name="displayName")

    incidents_parameter_name = sgqlc.types.Field(String, graphql_name="incidentsParameterName")
    """Associated getIncidents parameter used to filter incidents"""

    incidents_parameter_accepts_multiple_values = sgqlc.types.Field(
        Boolean, graphql_name="incidentsParameterAcceptsMultipleValues"
    )
    """Whether the associated getIncidents parameter accepts multiple
    values as input
    """

    facetable = sgqlc.types.Field(Boolean, graphql_name="facetable")
    """Whether the filter shows up as a facet on the incidents UI page"""

    facet_searchable = sgqlc.types.Field(Boolean, graphql_name="facetSearchable")
    """Whether the filter values can be searched by their display name"""


class IncidentsFilterData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("field_name", "values", "page_info")
    field_name = sgqlc.types.Field(IncidentsFilterFields, graphql_name="fieldName")

    values = sgqlc.types.Field(
        sgqlc.types.list_of("IncidentsFilterDataValue"), graphql_name="values"
    )
    """List of possible values to filter incidents"""

    page_info = sgqlc.types.Field("NextPageInfo", graphql_name="pageInfo")
    """Data for paginating values"""


class IncidentsFilterDataValue(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("value", "display_name", "count", "child_values", "incidents_parameter_name")
    value = sgqlc.types.Field(GenericScalar, graphql_name="value")

    display_name = sgqlc.types.Field(String, graphql_name="displayName")

    count = sgqlc.types.Field(Int, graphql_name="count")

    child_values = sgqlc.types.Field(
        sgqlc.types.list_of("IncidentsFilterDataValue"), graphql_name="childValues"
    )

    incidents_parameter_name = sgqlc.types.Field(String, graphql_name="incidentsParameterName")
    """If this has a value, it should override the value from
    IncidentsFilter
    """


class IndexedFieldFilterOutputType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("field_name", "values", "operator")
    field_name = sgqlc.types.Field(String, graphql_name="fieldName")
    """Field name"""

    values = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="values")
    """Values to filter by"""

    operator = sgqlc.types.Field(FieldValueFilterOperator, graphql_name="operator")
    """comparison operator to use when filtering"""


class IndexedFieldSpecType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "field_name",
        "display_name",
        "displayable",
        "aggregatable",
        "facetable",
        "filterable",
        "facet_searchable",
        "dashboard_types",
    )
    field_name = sgqlc.types.Field(String, graphql_name="fieldName")

    display_name = sgqlc.types.Field(String, graphql_name="displayName")

    displayable = sgqlc.types.Field(Boolean, graphql_name="displayable")

    aggregatable = sgqlc.types.Field(Boolean, graphql_name="aggregatable")

    facetable = sgqlc.types.Field(Boolean, graphql_name="facetable")

    filterable = sgqlc.types.Field(Boolean, graphql_name="filterable")

    facet_searchable = sgqlc.types.Field(Boolean, graphql_name="facetSearchable")

    dashboard_types = sgqlc.types.Field(
        sgqlc.types.list_of(DashboardType), graphql_name="dashboardTypes"
    )


class InfrastructureDetails(sgqlc.types.Type):
    """Infrastructure information"""

    __schema__ = schema
    __field_names__ = ("cloud_designation", "tenant_id", "hosting_type", "aws", "azure")
    cloud_designation = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="cloudDesignation"
    )
    """Cloud Designation"""

    tenant_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="tenantId")
    """Tenant ID"""

    hosting_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="hostingType")
    """Environment Hosting Type"""

    aws = sgqlc.types.Field(sgqlc.types.non_null(AwsInformation), graphql_name="aws")
    """AWS information"""

    azure = sgqlc.types.Field(AzureInformation, graphql_name="azure")
    """Azure information"""


class Insight(sgqlc.types.Type):
    """Available data on a specific element of the system created by DS"""

    __schema__ = schema
    __field_names__ = ("name", "title", "usage", "description", "reports", "available")
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Name (id) of insight"""

    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="title")
    """Insight display name"""

    usage = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="usage")
    """Explains what the insight data can be used for"""

    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="description")
    """Information the reports for the insight will provide"""

    reports = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("Report")), graphql_name="reports"
    )
    """Reports available for the insight"""

    available = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="available")
    """True if this insight is currently available"""


class IntegrationKey(sgqlc.types.Type):
    """Integration key id and secret. Only available once."""

    __schema__ = schema
    __field_names__ = ("id", "secret")
    id = sgqlc.types.Field(String, graphql_name="id")
    """Key id"""

    secret = sgqlc.types.Field(String, graphql_name="secret")
    """Key secret"""


class IntegrationKeyMetadata(sgqlc.types.Type):
    """Metadata for an integration key (will not include the associated
    secret)
    """

    __schema__ = schema
    __field_names__ = ("id", "description", "scope", "warehouses", "created_time", "created_by")
    id = sgqlc.types.Field(String, graphql_name="id")
    """Key id"""

    description = sgqlc.types.Field(String, graphql_name="description")
    """Key description"""

    scope = sgqlc.types.Field(String, graphql_name="scope")
    """Key scope (integration it can be used for)"""

    warehouses = sgqlc.types.Field(sgqlc.types.list_of("Warehouse"), graphql_name="warehouses")
    """Warehouses associated with key"""

    created_time = sgqlc.types.Field(DateTime, graphql_name="createdTime")
    """Time key was created"""

    created_by = sgqlc.types.Field("User", graphql_name="createdBy")
    """Who created the key"""


class IntegrationUpdateResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid", "type", "name")
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")

    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="type")

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")


class InternalNotifications(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("type", "friendly_message", "details", "is_urgent", "expiration_date")
    type = sgqlc.types.Field(String, graphql_name="type")
    """Type of notification."""

    friendly_message = sgqlc.types.Field(String, graphql_name="friendlyMessage")
    """Human readable message."""

    details = sgqlc.types.Field(JSONString, graphql_name="details")
    """Raw information about the message (e.g. specifics)."""

    is_urgent = sgqlc.types.Field(Boolean, graphql_name="isUrgent")
    """Whether to display a modal or badge."""

    expiration_date = sgqlc.types.Field(DateTime, graphql_name="expirationDate")
    """Reserved for future use (e.g. hiding old messages)."""


class InvestigationQuery(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("query", "has_error")
    query = sgqlc.types.Field(String, graphql_name="query")

    has_error = sgqlc.types.Field(Boolean, graphql_name="hasError")


class InviteUsersPayload(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("users", "client_mutation_id")
    users = sgqlc.types.Field(sgqlc.types.list_of("UserInvite"), graphql_name="users")

    client_mutation_id = sgqlc.types.Field(String, graphql_name="clientMutationId")


class InviteUsersV2(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("invites", "existing_users", "already_invited")
    invites = sgqlc.types.Field(sgqlc.types.list_of("UserInvite"), graphql_name="invites")
    """List of users invites sent"""

    existing_users = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="existingUsers")
    """List of email addresses of users who already exist and cannot be
    invited
    """

    already_invited = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="alreadyInvited")
    """List of email addresses already invited to this account or another
    account
    """


class JiraIntegrationOutput(sgqlc.types.Type):
    """A Jira integration"""

    __schema__ = schema
    __field_names__ = (
        "integration_id",
        "integration_name",
        "server_url",
        "username",
        "default_ticket_fields",
        "webhook_enabled",
        "webhook_url",
        "webhook_config",
        "is_token_auth",
        "webhook_secret_defined",
        "webhook_secret_mismatch_detected",
        "created_time",
        "updated_time",
        "created_by",
        "last_updated_by",
    )
    integration_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="integrationId")
    """The integration ID"""

    integration_name = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="integrationName"
    )
    """A short name to identify the integration"""

    server_url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="serverUrl")
    """The domain name for your Jira site"""

    username = sgqlc.types.Field(String, graphql_name="username")
    """The Jira username for basic authentication."""

    default_ticket_fields = sgqlc.types.Field(JSONString, graphql_name="defaultTicketFields")
    """Default values for ticket fields."""

    webhook_enabled = sgqlc.types.Field(Boolean, graphql_name="webhookEnabled")
    """Whether the Jira webhook is enabled"""

    webhook_url = sgqlc.types.Field(String, graphql_name="webhookUrl")
    """The Jira webhook URL. Configure this as the target of your Jira
    Webhook.
    """

    webhook_config = sgqlc.types.Field("JiraWebhookConfigOutput", graphql_name="webhookConfig")
    """Webhook config"""

    is_token_auth = sgqlc.types.Field(Boolean, graphql_name="isTokenAuth")
    """If the integration is Basic or Token Auth"""

    webhook_secret_defined = sgqlc.types.Field(Boolean, graphql_name="webhookSecretDefined")
    """Whether a secret has been configured for validating the signatures
    of webhook payloads sent by JIRA
    """

    webhook_secret_mismatch_detected = sgqlc.types.Field(
        Boolean, graphql_name="webhookSecretMismatchDetected"
    )
    """Indicates whether a mismatch was detected for the JIRA secret in
    the received payloads
    """

    created_time = sgqlc.types.Field(DateTime, graphql_name="createdTime")
    """When the integration was created"""

    updated_time = sgqlc.types.Field(DateTime, graphql_name="updatedTime")
    """When the integration was last updated"""

    created_by = sgqlc.types.Field("User", graphql_name="createdBy")
    """Who created the integration"""

    last_updated_by = sgqlc.types.Field("User", graphql_name="lastUpdatedBy")
    """Who last updated the integration"""


class JiraIssueTypeFieldAllowedValueOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "display_value", "children")
    id = sgqlc.types.Field(String, graphql_name="id")
    """The option's ID"""

    display_value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayValue")
    """The option's user friendly display value"""

    children = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("JiraIssueTypeFieldAllowedValueOutput")),
        graphql_name="children",
    )
    """For dependant option types, the option's children"""


class JiraIssueTypeFieldOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "key",
        "name",
        "required",
        "has_default_value",
        "has_default_value_in_jira",
        "type",
        "custom_type",
        "items_type",
        "allowed_values",
        "default_value",
        "is_multi",
    )
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    """The field key"""

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """The field name"""

    required = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="required")
    """If the field is required to create the issue"""

    has_default_value = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="hasDefaultValue"
    )
    """If the field has a default value when not set, considering
    integration level default values configured on Monte Carlo
    """

    has_default_value_in_jira = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="hasDefaultValueInJira"
    )
    """If the field has a default value in Jira when not set"""

    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="type")
    """The field type"""

    custom_type = sgqlc.types.Field(String, graphql_name="customType")
    """For custom fields, the JIRA custom field type"""

    items_type = sgqlc.types.Field(String, graphql_name="itemsType")
    """For array types, the type of the items in the array"""

    allowed_values = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(JiraIssueTypeFieldAllowedValueOutput)),
        graphql_name="allowedValues",
    )
    """The allowed values for option fields"""

    default_value = sgqlc.types.Field(JSONString, graphql_name="defaultValue")
    """JSON-string representing the JIRA defined default value for this
    field
    """

    is_multi = sgqlc.types.Field(Boolean, graphql_name="isMulti")
    """For array type fields, indicates if more than one value is allowed"""


class JiraIssueTypeOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "name", "untranslated_name", "fields")
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="id")
    """The issue type ID"""

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """The issue type name"""

    untranslated_name = sgqlc.types.Field(String, graphql_name="untranslatedName")
    """The issue type untranslated name"""

    fields = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(JiraIssueTypeFieldOutput))),
        graphql_name="fields",
    )
    """The issue type fields"""


class JiraProjectOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "key", "name")
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="id")
    """The project ID"""

    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="key")
    """The project key"""

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """The project name"""


class JiraStatusMappingOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("incident_feedback", "jira_status")
    incident_feedback = sgqlc.types.Field(String, graphql_name="incidentFeedback")
    """The feedback that will be set on the Monte Carlo incident if the
    Jira ticket is set to any of the provided Jira statuses
    """

    jira_status = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="jiraStatus"
    )
    """The Jira statuses that will map to the Monte Carlo incident
    feedback
    """


class JiraStatusOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "name")
    id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="id")
    """The status ID"""

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """The status name"""


class JiraTeamOutput(sgqlc.types.Type):
    """A JIRA team details"""

    __schema__ = schema
    __field_names__ = ("team_id", "display_name", "description", "team_type")
    team_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="teamId")
    """The team ID"""

    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")
    """The team display name"""

    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="description")
    """The team description"""

    team_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="teamType")
    """The team type"""


class JiraTestCredentialsOutput(sgqlc.types.Type):
    """A Jira test credentials result"""

    __schema__ = schema
    __field_names__ = ("valid_credentials",)
    valid_credentials = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="validCredentials"
    )
    """Returns if the credentials are valid"""


class JiraTicketDetailsOutput(sgqlc.types.Type):
    """Ticket details stored at Jira"""

    __schema__ = schema
    __field_names__ = ("assignee", "status", "found")
    assignee = sgqlc.types.Field("JiraUserOutput", graphql_name="assignee")
    """The user assigned to the ticket"""

    status = sgqlc.types.Field("JiraTicketStatusOutput", graphql_name="status")
    """The ticket status"""

    found = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="found")
    """Whether the ticket was found in JIRA"""


class JiraTicketOutput(sgqlc.types.Type):
    """A Jira ticket"""

    __schema__ = schema
    __field_names__ = (
        "ticket_id",
        "ticket_url",
        "ticket_key",
        "incident_id",
        "alert_id",
        "integration_id",
        "created_by",
        "created_at",
        "details",
    )
    ticket_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="ticketId")
    """The ticket ID in Monte Carlo"""

    ticket_url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="ticketUrl")
    """The ticket URL"""

    ticket_key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="ticketKey")
    """The ticket key"""

    incident_id = sgqlc.types.Field(UUID, graphql_name="incidentId")
    """The incident ID"""

    alert_id = sgqlc.types.Field(UUID, graphql_name="alertId")
    """The alert ID"""

    integration_id = sgqlc.types.Field(UUID, graphql_name="integrationId")
    """The integration ID. Might be null if integration was deleted."""

    created_by = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="createdBy")
    """Email of the user that created the ticket"""

    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdAt")
    """When the ticket was created"""

    details = sgqlc.types.Field(JiraTicketDetailsOutput, graphql_name="details")
    """Ticket details stored at Jira"""


class JiraTicketStatusOutput(sgqlc.types.Type):
    """A JIRA ticket status"""

    __schema__ = schema
    __field_names__ = ("name", "description")
    name = sgqlc.types.Field(String, graphql_name="name")
    """A short descriptive name for the status"""

    description = sgqlc.types.Field(String, graphql_name="description")
    """A more detailed description of the status"""


class JiraUserOutput(sgqlc.types.Type):
    """A JIRA user details"""

    __schema__ = schema
    __field_names__ = ("avatar_url", "display_name", "email_address", "name", "account_id", "key")
    avatar_url = sgqlc.types.Field(String, graphql_name="avatarUrl")
    """The user 24x24 avatar URL"""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """The user display name"""

    email_address = sgqlc.types.Field(String, graphql_name="emailAddress")
    """The user email"""

    name = sgqlc.types.Field(String, graphql_name="name")
    """The JIRA DC user name (this uniquely identifies the user)"""

    account_id = sgqlc.types.Field(String, graphql_name="accountId")
    """The JIRA Cloud user accountId (this ID uniquely identifies the
    user)
    """

    key = sgqlc.types.Field(String, graphql_name="key")
    """The JIRA DC user key (this ID uniquely identifies the user)"""


class JiraWebhookConfigOutput(sgqlc.types.Type):
    """Jira webhook config"""

    __schema__ = schema
    __field_names__ = ("status_mappings",)
    status_mappings = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(JiraStatusMappingOutput)),
        graphql_name="statusMappings",
    )
    """Status mapping"""


class JobError(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "message",
        "job_execution_uuid",
        "dc_schedule_uuid",
        "timestamp",
        "result_count",
        "job_type",
        "stack_name",
        "data_collector_uuid",
    )
    message = sgqlc.types.Field(String, graphql_name="message")
    """The error message"""

    job_execution_uuid = sgqlc.types.Field(UUID, graphql_name="jobExecutionUuid")
    """The Job Execution ID"""

    dc_schedule_uuid = sgqlc.types.Field(UUID, graphql_name="dcScheduleUuid")
    """The data collector schedule UUID"""

    timestamp = sgqlc.types.Field(DateTime, graphql_name="timestamp")
    """The timestamp of the error"""

    result_count = sgqlc.types.Field(Int, graphql_name="resultCount")
    """The number of results returned"""

    job_type = sgqlc.types.Field(String, graphql_name="jobType")
    """The type of job that failed"""

    stack_name = sgqlc.types.Field(String, graphql_name="stackName")
    """The name of the stack for the data collector"""

    data_collector_uuid = sgqlc.types.Field(UUID, graphql_name="dataCollectorUuid")
    """The data collector uuid"""


class JobExecutionException(sgqlc.types.Type):
    """Job execution exception details"""

    __schema__ = schema
    __field_names__ = ("type", "description", "sql_query")
    type = sgqlc.types.Field(String, graphql_name="type")
    """Exception type"""

    description = sgqlc.types.Field(String, graphql_name="description")
    """Exception description"""

    sql_query = sgqlc.types.Field(String, graphql_name="sqlQuery")
    """SQL query execution that triggered the exception"""


class JobExecutionHistoryLog(sgqlc.types.Type):
    """Job history log entry"""

    __schema__ = schema
    __field_names__ = (
        "job_execution_uuid",
        "start_time",
        "status",
        "end_time",
        "exceptions",
        "exceptions_detail",
        "runtime_variables",
        "comparison_data_source_type",
        "table_monitor_warning",
        "size_collection_table_mcon",
        "size_collection_enabled",
        "total_invocations_count",
        "total_result_count",
        "total_execution_duration",
        "consolidating_job_uuid",
    )
    job_execution_uuid = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="jobExecutionUuid"
    )
    """UUID of job execution"""

    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """When the job was scheduled"""

    status = sgqlc.types.Field(JobExecutionStatus, graphql_name="status")

    end_time = sgqlc.types.Field(DateTime, graphql_name="endTime")
    """When the job was completed"""

    exceptions = sgqlc.types.Field(String, graphql_name="exceptions")
    """Exceptions that were captured during this job execution (pre-
    formatted)
    """

    exceptions_detail = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(JobExecutionException)),
        graphql_name="exceptionsDetail",
    )
    """Exceptions that were captured during this job execution"""

    runtime_variables = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("VariableValue")), graphql_name="runtimeVariables"
    )
    """Runtime variables used in the job execution"""

    comparison_data_source_type = sgqlc.types.Field(
        ComparisonDataSourceType, graphql_name="comparisonDataSourceType"
    )
    """Comparison Source type in the job execution"""

    table_monitor_warning = sgqlc.types.Field(Boolean, graphql_name="tableMonitorWarning")
    """True if this table monitor execution failure was treated as a
    warning and no failure notification was sent.
    """

    size_collection_table_mcon = sgqlc.types.Field(String, graphql_name="sizeCollectionTableMcon")
    """MCON of the table for size collection executions in table monitors"""

    size_collection_enabled = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="sizeCollectionEnabled"
    )
    """True if size collection is enabled for the asset"""

    total_invocations_count = sgqlc.types.Field(Int, graphql_name="totalInvocationsCount")
    """Total number of invocations for the job execution. May be null if
    execution has not completed.
    """

    total_result_count = sgqlc.types.Field(Int, graphql_name="totalResultCount")
    """Total number of objects returned by the job execution. May be null
    if execution has not completed.
    """

    total_execution_duration = sgqlc.types.Field(Float, graphql_name="totalExecutionDuration")
    """Total execution duration in seconds. May be null if execution has
    not completed.
    """

    consolidating_job_uuid = sgqlc.types.Field(String, graphql_name="consolidatingJobUuid")
    """UUID of the consolidating job execution"""


class JobExecutionHistoryLogConnection(sgqlc.types.relay.Connection):
    """Job history log entries"""

    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("JobExecutionHistoryLogEdge")),
        graphql_name="edges",
    )
    """Contains the nodes in this connection."""


class JobExecutionHistoryLogEdge(sgqlc.types.Type):
    """A Relay edge containing a `JobExecutionHistoryLog` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field(JobExecutionHistoryLog, graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class JobInfo(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("dbt_job_info",)
    dbt_job_info = sgqlc.types.Field(DbtJobInfo, graphql_name="dbtJobInfo")


class JobPerformanceData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("job_summaries",)
    job_summaries = sgqlc.types.Field(
        sgqlc.types.non_null("JobPerformanceSummaryConnection"),
        graphql_name="jobSummaries",
        args=sgqlc.types.ArgDict(
            (
                ("before", sgqlc.types.Arg(String, graphql_name="before", default=None)),
                ("after", sgqlc.types.Arg(String, graphql_name="after", default=None)),
                ("first", sgqlc.types.Arg(Int, graphql_name="first", default=None)),
                ("last", sgqlc.types.Arg(Int, graphql_name="last", default=None)),
            )
        ),
    )
    """Paged list of summary-level information about job performance, for
    jobs that executed in the specified period

    Arguments:

    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    """


class JobPerformanceSummaryConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges", "total_count")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("JobPerformanceSummaryEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""

    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")
    """Total number of jobs matching filter (total count)"""


class JobPerformanceSummaryEdge(sgqlc.types.Type):
    """A Relay edge containing a `JobPerformanceSummary` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("JobPerformanceSummary", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class JobRoutingRuleSpec(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "original_rule_uuid",
        "audience",
        "job_anomaly_types",
        "job_sub_types",
        "job_asset_rules",
        "description",
    )
    original_rule_uuid = sgqlc.types.Field(
        sgqlc.types.non_null(UUID), graphql_name="originalRuleUuid"
    )

    audience = sgqlc.types.Field(Audience, graphql_name="audience")

    job_anomaly_types = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="jobAnomalyTypes",
    )

    job_sub_types = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="jobSubTypes",
    )

    job_asset_rules = sgqlc.types.Field(GenericScalar, graphql_name="jobAssetRules")

    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="description")


class JobsPerformanceFacetOption(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("display_name", "value", "match_count")
    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """Display text to use, if different from value, such as when value
    is a UUID but we want human readable option
    """

    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="value")
    """Unique value (within the facet) for the option"""

    match_count = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="matchCount")
    """Number of jobs associated with this value"""


class JobsPerformanceFacetResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("facet", "display_name", "options")
    facet = sgqlc.types.Field(sgqlc.types.non_null(JobPerformanceFacet), graphql_name="facet")
    """Field name"""

    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")
    """Facet display name"""

    options = sgqlc.types.Field(
        sgqlc.types.list_of(JobsPerformanceFacetOption), graphql_name="options"
    )
    """Facet options"""


class LLMModel(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "name",
        "description",
        "warehouse_type",
        "category",
        "context_window",
        "regions",
        "default",
    )
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")

    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="description")

    warehouse_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="warehouseType")

    category = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="category")

    context_window = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="contextWindow")

    regions = sgqlc.types.Field(GenericScalar, graphql_name="regions")

    default = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="default")


class LabelCount(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("label", "count")
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="label")
    """The label value"""

    count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="count")
    """The count for the label"""


class LastSizeChange(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("timestamp", "size", "size_delta")
    timestamp = sgqlc.types.Field(DateTime, graphql_name="timestamp")
    """Timestamp when the last size change occurred"""

    size = sgqlc.types.Field(Float, graphql_name="size")
    """Table size after the last size change occurred"""

    size_delta = sgqlc.types.Field(Float, graphql_name="sizeDelta")
    """Size delta to the previous table size change"""


class LineageAirflowJobAttributes(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "dag_id",
        "task_id",
        "display_name",
        "resource_name",
        "mcon",
        "status",
        "last_run_finished_at",
    )
    dag_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="dagId")
    """Airflow DAG Id"""

    task_id = sgqlc.types.Field(String, graphql_name="taskId")
    """Airflow Task Id"""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """Airflow DAG Name"""

    resource_name = sgqlc.types.Field(String, graphql_name="resourceName")
    """Airflow Environment Name"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Airflow DAG MCON"""

    status = sgqlc.types.Field(String, graphql_name="status")
    """Status of most recent job execution"""

    last_run_finished_at = sgqlc.types.Field(DateTime, graphql_name="lastRunFinishedAt")
    """Timestamp of the most recent job execution's completion"""


class LineageAzureDataFactoryJobAttributes(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "job_id",
        "task_id",
        "display_name",
        "resource_name",
        "mcon",
        "status",
        "last_run_finished_at",
    )
    job_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="jobId")
    """Azure Data Factory Pipeline Id"""

    task_id = sgqlc.types.Field(String, graphql_name="taskId")
    """Azure Data Factory Activity Id"""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """Azure Data Factory Pipeline Name"""

    resource_name = sgqlc.types.Field(String, graphql_name="resourceName")
    """Azure Data Factory Environment Name"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Azure Data Factory Pipeline MCON"""

    status = sgqlc.types.Field(String, graphql_name="status")
    """Status of most recent pipeline execution"""

    last_run_finished_at = sgqlc.types.Field(DateTime, graphql_name="lastRunFinishedAt")
    """Timestamp of the most recent pipeline execution's completion"""


class LineageBaseJobAttributes(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("display_name", "mcon", "status", "last_run_finished_at")
    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """Job name"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Job MCON"""

    status = sgqlc.types.Field(String, graphql_name="status")
    """Status of most recent job execution"""

    last_run_finished_at = sgqlc.types.Field(DateTime, graphql_name="lastRunFinishedAt")
    """Timestamp of the most recent job execution's completion"""


class LineageDatabricksJobAttributes(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "job_id",
        "task_id",
        "display_name",
        "resource_name",
        "mcon",
        "status",
        "last_run_finished_at",
    )
    job_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="jobId")
    """Databricks Job Id"""

    task_id = sgqlc.types.Field(String, graphql_name="taskId")
    """Databricks task Id"""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """Databricks Job Name"""

    resource_name = sgqlc.types.Field(String, graphql_name="resourceName")
    """Databricks Environment Name"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Databricks Job MCON"""

    status = sgqlc.types.Field(String, graphql_name="status")
    """Status of most recent job execution"""

    last_run_finished_at = sgqlc.types.Field(DateTime, graphql_name="lastRunFinishedAt")
    """Timestamp of the most recent job execution's completion"""


class LineageDbtJobAttributes(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("job_uuid", "display_name", "resource_id", "mcon")
    job_uuid = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="jobUuid")
    """DBT job uuid"""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """DBT job name"""

    resource_id = sgqlc.types.Field(String, graphql_name="resourceId")
    """UUID of the Monte Carlo resource/integration which isassociated to
    the DBT job
    """

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """DBT job MCON"""


class LineageEdgeJob(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("job_type", "job_attributes")
    job_type = sgqlc.types.Field(sgqlc.types.non_null(LineageNodeJobType), graphql_name="jobType")
    """Job type"""

    job_attributes = sgqlc.types.Field(
        sgqlc.types.non_null("LineageJobAttributes"), graphql_name="jobAttributes"
    )


class LineageGraph(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("base_node", "base_nodes", "connected_nodes", "flattened_edges")
    base_node = sgqlc.types.Field("LineageGraphNode", graphql_name="baseNode")
    """This is the base node for which lineage is fetched. If there are
    multiples nodes requested this is the first one.
    """

    base_nodes = sgqlc.types.Field(
        sgqlc.types.list_of("LineageGraphNode"), graphql_name="baseNodes"
    )
    """These are the base nodes for which lineages are fetched"""

    connected_nodes = sgqlc.types.Field(
        sgqlc.types.list_of("LineageGraphNode"), graphql_name="connectedNodes"
    )
    """List of nodes connected to the base node. This could be nodes that
    are multiple hops away from the base node in the graph in cases
    where nodes at multiple hops were queried.
    """

    flattened_edges = sgqlc.types.Field(
        sgqlc.types.list_of(FlattenedLineageGraphEdges), graphql_name="flattenedEdges"
    )
    """Each entry is an mcon and a list of mcons it is directly connected
    to
    """


class LineageGraphEdge(sgqlc.types.Type):
    """A lineage graph edge"""

    __schema__ = schema
    __field_names__ = ("source", "destination", "job_ts", "expire_at", "is_custom")
    source = sgqlc.types.Field("LineageGraphNode", graphql_name="source")
    """The source node"""

    destination = sgqlc.types.Field("LineageGraphNode", graphql_name="destination")
    """The destination node"""

    job_ts = sgqlc.types.Field(DateTime, graphql_name="jobTs")
    """The timestamp of the job run or API call that created this edge"""

    expire_at = sgqlc.types.Field(DateTime, graphql_name="expireAt")
    """The timestamp when this edge will expire"""

    is_custom = sgqlc.types.Field(Boolean, graphql_name="isCustom")
    """Indicates whether this is a custom lineage edge (created by a
    user)
    """


class LineageGraphEdgeJobs(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("source_mcon", "destination_mcon", "jobs")
    source_mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="sourceMcon")

    destination_mcon = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="destinationMcon"
    )

    jobs = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(LineageEdgeJob)), graphql_name="jobs"
    )
    """Jobs associated to this edge"""


class LineageGraphEdgeNode(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("mcon", "jobs", "hidden")
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """Target MCON of this edge"""

    jobs = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(LineageEdgeJob)), graphql_name="jobs"
    )
    """Jobs associated to this edge"""

    hidden = sgqlc.types.Field(Int, graphql_name="hidden")
    """The number of hidden nodes for virtual/collapsed edges"""


class LineageGraphNode(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "mcon",
        "display_name",
        "has_downstream_nodes",
        "has_upstream_nodes",
        "object_type",
        "is_custom",
        "job_ts",
        "expire_at",
        "jobs",
        "is_monitored",
        "is_excluded",
        "last_activity",
        "model_execution_status",
        "element_id",
    )
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """Monte Carlo full identifier for an entity"""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """Friendly name for entity"""

    has_downstream_nodes = sgqlc.types.Field(Boolean, graphql_name="hasDownstreamNodes")
    """Indicates whether this node has downstream nodes"""

    has_upstream_nodes = sgqlc.types.Field(Boolean, graphql_name="hasUpstreamNodes")
    """Indicates whether this node has upstream nodes"""

    object_type = sgqlc.types.Field(String, graphql_name="objectType")
    """Type of the object that this lineage node denotes"""

    is_custom = sgqlc.types.Field(Boolean, graphql_name="isCustom")
    """Indicates whether this is a custom lineage node (created by a
    user)
    """

    job_ts = sgqlc.types.Field(DateTime, graphql_name="jobTs")
    """The timestamp of the job run or API call that created this node"""

    expire_at = sgqlc.types.Field(DateTime, graphql_name="expireAt")
    """The timestamp when this node will expire"""

    jobs = sgqlc.types.Field(sgqlc.types.list_of("LineageNodeJob"), graphql_name="jobs")
    """List of jobs"""

    is_monitored = sgqlc.types.Field(Boolean, graphql_name="isMonitored")
    """Indicates whether this is table asset is opt-in for monitoring"""

    is_excluded = sgqlc.types.Field(Boolean, graphql_name="isExcluded")
    """Indicates whether this is table asset is excluded from ingestion"""

    last_activity = sgqlc.types.Field(DateTime, graphql_name="lastActivity")
    """Last read/write on table"""

    model_execution_status = sgqlc.types.Field(
        "LineageGraphNodeModelExecutionStatus", graphql_name="modelExecutionStatus"
    )
    """The most recent model execution status information which affected
    this table (e.g. DBT model)
    """

    element_id = sgqlc.types.Field(Int, graphql_name="elementId")
    """Internal lineage node id. Only unique for current run."""


class LineageGraphNodeJobs(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("mcon", "jobs", "model_execution_status")
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """Table MCON"""

    jobs = sgqlc.types.Field(sgqlc.types.list_of("LineageNodeJob"), graphql_name="jobs")
    """List of jobs"""

    model_execution_status = sgqlc.types.Field(
        "LineageGraphNodeModelExecutionStatus", graphql_name="modelExecutionStatus"
    )
    """The most recent model execution status information which affected
    this table (e.g. DBT model)
    """


class LineageGraphNodeModelExecutionStatus(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "created_time",
        "updated_time",
        "mcon",
        "account_id",
        "model_type",
        "status",
        "run_at",
        "completed_at",
        "execution_time",
        "model_id",
    )
    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdTime")

    updated_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedTime")

    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """The MCON of the table associated to this model execution"""

    account_id = sgqlc.types.Field(UUID, graphql_name="accountId")
    """The account uuid associated to this record"""

    model_type = sgqlc.types.Field(
        sgqlc.types.non_null(ModelExecutionTypes), graphql_name="modelType"
    )
    """The type of the model (e.g. DBT)"""

    status = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="status")
    """The status of the most recent execution of a model which affected
    the associated node
    """

    run_at = sgqlc.types.Field(DateTime, graphql_name="runAt")
    """The timestamp of the most recent execution of a model which
    affected the associated node
    """

    completed_at = sgqlc.types.Field(DateTime, graphql_name="completedAt")
    """The timestamp of the completion of the most recent execution of a
    model which affected the associated node
    """

    execution_time = sgqlc.types.Field(Float, graphql_name="executionTime")
    """The model execution duration"""

    model_id = sgqlc.types.Field(String, graphql_name="modelId")
    """The ID of the associated model execution record (e.g.
    DbtRunStepModel)
    """


class LineageGraphNodesEdgesJobs(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("nodes", "edges")
    nodes = sgqlc.types.Field(sgqlc.types.list_of(LineageGraphNodeJobs), graphql_name="nodes")
    """Lineage nodes with jobs"""

    edges = sgqlc.types.Field(sgqlc.types.list_of(LineageGraphEdgeJobs), graphql_name="edges")
    """Lineage edges with jobs"""


class LineageInformaticaJobAttributes(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "resource_name",
        "mcon",
        "informatica_activity_type",
        "task_flow_id",
        "task_flow_name",
        "task_id",
        "task_name",
        "status",
        "last_run_finished_at",
    )
    resource_name = sgqlc.types.Field(String, graphql_name="resourceName")
    """Informatica integration name"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Informatica job MCON"""

    informatica_activity_type = sgqlc.types.Field(
        InformaticaActivityType, graphql_name="informaticaActivityType"
    )
    """Informatica activity type"""

    task_flow_id = sgqlc.types.Field(String, graphql_name="taskFlowId")
    """Informatica task flow id"""

    task_flow_name = sgqlc.types.Field(String, graphql_name="taskFlowName")
    """Informatica task flow name"""

    task_id = sgqlc.types.Field(String, graphql_name="taskId")
    """Informatica task id"""

    task_name = sgqlc.types.Field(String, graphql_name="taskName")
    """Informatica task name"""

    status = sgqlc.types.Field(String, graphql_name="status")
    """Status of most recent job execution"""

    last_run_finished_at = sgqlc.types.Field(DateTime, graphql_name="lastRunFinishedAt")
    """Timestamp of the most recent job execution's completion"""


class LineageKafkaConnectorJobAttributes(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "job_id",
        "display_name",
        "external_origin_id",
        "external_cluster_id",
        "mcon",
    )
    job_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="jobId")
    """Kafka Connector ID"""

    display_name = sgqlc.types.Field(String, graphql_name="displayName")
    """kafka Connector display name"""

    external_origin_id = sgqlc.types.Field(String, graphql_name="externalOriginId")
    """External unique identifier of the job"""

    external_cluster_id = sgqlc.types.Field(String, graphql_name="externalClusterId")
    """Cluster the connector runs in"""

    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Kafka Connector MCON"""


class LineageMconNode(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("mcon", "importance_score")
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")
    """MC resource identifier"""

    importance_score = sgqlc.types.Field(Float, graphql_name="importanceScore")
    """Entity importance score"""


class LineageNodeBlockPattern(sgqlc.types.Type):
    """A pattern defining nodes to be blocked from lineage"""

    __schema__ = schema
    __field_names__ = (
        "id",
        "uuid",
        "account_id",
        "resource_id",
        "dataset_regexp",
        "project_regexp",
        "table_regexp",
        "created_time",
        "last_update_user",
        "last_update_time",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """Pattern UUID"""

    account_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="accountId")
    """Customer account id"""

    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="resourceId")
    """Resource containing the node"""

    dataset_regexp = sgqlc.types.Field(String, graphql_name="datasetRegexp")
    """Block nodes with dataset id matching this regexp"""

    project_regexp = sgqlc.types.Field(String, graphql_name="projectRegexp")
    """Block nodes with project id matching this regexp"""

    table_regexp = sgqlc.types.Field(String, graphql_name="tableRegexp")
    """Block nodes with table id matching this regexp"""

    created_time = sgqlc.types.Field(DateTime, graphql_name="createdTime")
    """When the regexp was first created"""

    last_update_user = sgqlc.types.Field("User", graphql_name="lastUpdateUser")
    """Who last updated the regexp"""

    last_update_time = sgqlc.types.Field(DateTime, graphql_name="lastUpdateTime")
    """When the regexp was last updated"""


class LineageNodeCollapsingRule(sgqlc.types.Type):
    """A pattern matching lineage nodes that should be collapsed"""

    __schema__ = schema
    __field_names__ = (
        "created_time",
        "updated_time",
        "created_by",
        "last_update_user",
        "uuid",
        "account_id",
        "pattern",
        "case_insensitive",
    )
    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdTime")

    updated_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="updatedTime")

    created_by = sgqlc.types.Field("User", graphql_name="createdBy")
    """Creator"""

    last_update_user = sgqlc.types.Field("User", graphql_name="lastUpdateUser")
    """Last updated by"""

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """Collapsing pattern UUID"""

    account_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="accountId")
    """Customer account id"""

    pattern = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="pattern")
    """Pattern to match collapsible nodes global id"""

    case_insensitive = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="caseInsensitive"
    )
    """Case sensitivity of the pattern matching"""


class LineageNodeJob(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("job_type", "job_attributes", "direction")
    job_type = sgqlc.types.Field(sgqlc.types.non_null(LineageNodeJobType), graphql_name="jobType")
    """Job type"""

    job_attributes = sgqlc.types.Field(
        sgqlc.types.non_null("LineageJobAttributes"), graphql_name="jobAttributes"
    )

    direction = sgqlc.types.Field(
        sgqlc.types.non_null(LineageNodeJobDirectionType), graphql_name="direction"
    )
    """Directional relationship of the table that the job
    (node) is associated with.             - source (table is source):
    means that the job reads the table (node)                 that
    this job node is associated with.             - dest (table is
    destination): means that the job modifies the table (node)
    that this job node is associated with.
    """


class LineageNodeReplacementRule(sgqlc.types.Type):
    """A replacement pattern modifying lineage node's canonical name"""

    __schema__ = schema
    __field_names__ = (
        "id",
        "uuid",
        "account_id",
        "resource_id",
        "pattern",
        "replacement",
        "case_insensitive",
        "last_update_user",
        "last_update_time",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """Replacement rule UUID"""

    account_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="accountId")
    """Customer account id"""

    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="resourceId")
    """Resource containing the node"""

    pattern = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="pattern")
    """Modify canonical name by replacing the pattern with replacement"""

    replacement = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="replacement")
    """Modify canonical name by replacing the pattern with replacement"""

    case_insensitive = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="caseInsensitive"
    )
    """Case sensitivity of the pattern matching"""

    last_update_user = sgqlc.types.Field("User", graphql_name="lastUpdateUser")
    """Who last updated the replacement rule"""

    last_update_time = sgqlc.types.Field(DateTime, graphql_name="lastUpdateTime")
    """When the replacement rule was last updated"""


class LineageNodeReplacementRuleResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("test_input_string", "replaced_string")
    test_input_string = sgqlc.types.Field(String, graphql_name="testInputString")
    """The provided test input string"""

    replaced_string = sgqlc.types.Field(String, graphql_name="replacedString")
    """The replaced string, using provided pattern/replacement"""


class LineageNodeTypeStat(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("object_type", "count")
    object_type = sgqlc.types.Field(String, graphql_name="objectType")
    """Type of element object"""

    count = sgqlc.types.Field(Int, graphql_name="count")
    """Number of elements of object_type"""


class LineageNodeTypeStats(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("node_type_stats",)
    node_type_stats = sgqlc.types.Field(
        sgqlc.types.list_of(LineageNodeTypeStat), graphql_name="nodeTypeStats"
    )
    """Stats for node types"""


class LineageSources(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("mcon", "source_columns")
    mcon = sgqlc.types.Field(String, graphql_name="mcon")
    """Mcon of the source table"""

    source_columns = sgqlc.types.Field(
        sgqlc.types.list_of("SourceColumn"), graphql_name="sourceColumns"
    )
    """Source columns from this source table"""


class LinkAzureDevOpsIntegration(sgqlc.types.Type):
    """Complete OAuth flow for Azure DevOps integration."""

    __schema__ = schema
    __field_names__ = ("success", "azure_devops_integration")
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """True if exchanging code for tokens was successful"""

    azure_devops_integration = sgqlc.types.Field(
        AzureDevOpsIntegrationOutput, graphql_name="azureDevopsIntegration"
    )
    """Created or updated Azure DevOps integration"""


class LinkAzureDevOpsWorkItemForAlert(sgqlc.types.Type):
    """Link an existing Azure DevOps work item to a Monte Carlo alert.
    This mutation creates a link between an existing work item and an
    alert without creating a new work item.
    """

    __schema__ = schema
    __field_names__ = ("azure_devops_work_item",)
    azure_devops_work_item = sgqlc.types.Field(
        AzureDevOpsWorkItemOutput, graphql_name="azureDevopsWorkItem"
    )


class LinkAzureDevopsInstallation(sgqlc.types.Type):
    """Called from the FE when an OAuth callback is received."""

    __schema__ = schema
    __field_names__ = ("success", "installation")
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """True if exchanging code for tokens was successful"""

    installation = sgqlc.types.Field(AzureDevopsInstallation, graphql_name="installation")
    """Updated Azure DevOps installation"""


class LinkDatadogIncidentForAlert(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("datadog_incident",)
    datadog_incident = sgqlc.types.Field("DatadogIncident", graphql_name="datadogIncident")
    """The linked Datadog incident"""


class LinkGithubAppInstallation(sgqlc.types.Type):
    """Called from the FE as part of the post-installation callback. The
    "code" parameter is used to validate that the request is an
    authentic Github callback and authenticates the user on the Github
    side.
    """

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """True if linking the installation was successful"""


class LinkGitlabApp(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success", "installation_id")
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """True if linking the installation was successful"""

    installation_id = sgqlc.types.Field(String, graphql_name="installationId")
    """Internal UUID of the installation"""


class LinkJiraTicketForAlert(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("jira_ticket",)
    jira_ticket = sgqlc.types.Field(JiraTicketOutput, graphql_name="jiraTicket")
    """The created Jira ticket"""


class LinkJiraTicketForIncident(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("jira_ticket",)
    jira_ticket = sgqlc.types.Field(JiraTicketOutput, graphql_name="jiraTicket")
    """The created Jira ticket"""


class LinkMsTeamsInstallation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """True if linking the installation was successful"""


class LinkOpsgenieIncident(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("link_details",)
    link_details = sgqlc.types.Field("OpsgenieLinkOutput", graphql_name="linkDetails")
    """The link details"""


class LinkServiceNowIncidentForAlert(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("servicenow_incident",)
    servicenow_incident = sgqlc.types.Field(
        "ServiceNowIncidentOutput", graphql_name="servicenowIncident"
    )
    """The created ServiceNow incident"""


class LinkSlackAppInstallation(sgqlc.types.Type):
    """Handle Slack OAuth callback"""

    __schema__ = schema
    __field_names__ = ("installation_uuid",)
    installation_uuid = sgqlc.types.Field(String, graphql_name="installationUuid")
    """The UUID of the Slack installation"""


class ListDataOperationsDashboardsOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("total_count", "data_operations_dashboards", "next_page_info")
    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")
    """total count of the operations dashboards."""

    data_operations_dashboards = sgqlc.types.Field(
        sgqlc.types.list_of(DataOperationsDashboardOutput), graphql_name="dataOperationsDashboards"
    )
    """result data operations list."""

    next_page_info = sgqlc.types.Field("NextPageInfo", graphql_name="nextPageInfo")
    """pagination information."""


class ListDataQualityDimensionsOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("data_quality_dimension",)
    data_quality_dimension = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name="dataQualityDimension"
    )
    """All supported data quality dimensions."""


class ListDatasetsResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("datasets", "next_page_token")
    datasets = sgqlc.types.Field(sgqlc.types.list_of(DatasetEntity), graphql_name="datasets")
    """List of dataset IDs"""

    next_page_token = sgqlc.types.Field(String, graphql_name="nextPageToken")
    """Page token for the next page"""


class ListMonitorTagsOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("total_count", "tags")
    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")
    """Total count of the monitor tags in a user's account."""

    tags = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null("TagInfoOutput")), graphql_name="tags"
    )
    """Monitor Tags list."""


class ListProjectsResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("projects", "next_page_token")
    projects = sgqlc.types.Field(sgqlc.types.list_of("ProjectEntity"), graphql_name="projects")
    """List of project IDs"""

    next_page_token = sgqlc.types.Field(String, graphql_name="nextPageToken")
    """Page token for the next page"""


class ListTagsOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("total_count", "tags")
    total_count = sgqlc.types.Field(Int, graphql_name="totalCount")
    """Total count of the tags in a user's account."""

    tags = sgqlc.types.Field(sgqlc.types.list_of("TagObjectOutput"), graphql_name="tags")
    """Tags list."""


class LoginDetails(sgqlc.types.Type):
    """Login information"""

    __schema__ = schema
    __field_names__ = ("sso",)
    sso = sgqlc.types.Field(sgqlc.types.non_null("SsoDetails"), graphql_name="sso")
    """SSO information"""


class LogsIntegrationOutput(sgqlc.types.Type):
    """A Logs integration (for monitor execution logging)"""

    __schema__ = schema
    __field_names__ = (
        "integration_id",
        "integration_name",
        "webhook_url",
        "integration_type",
        "headers",
        "created_time",
        "updated_time",
        "created_by",
        "last_update_user",
    )
    integration_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="integrationId")
    """The integration ID"""

    integration_name = sgqlc.types.Field(String, graphql_name="integrationName")
    """A short name to identify the integration"""

    webhook_url = sgqlc.types.Field(String, graphql_name="webhookUrl")
    """The URL to post messages to"""

    integration_type = sgqlc.types.Field(
        sgqlc.types.non_null(LogsIntegrationType), graphql_name="integrationType"
    )
    """Type log integration to use"""

    headers = sgqlc.types.Field(sgqlc.types.list_of("WebhookHeader"), graphql_name="headers")
    """Header key/value to use when sending webhook request"""

    created_time = sgqlc.types.Field(DateTime, graphql_name="createdTime")
    """When the integration was created"""

    updated_time = sgqlc.types.Field(DateTime, graphql_name="updatedTime")
    """When the integration was last updated"""

    created_by = sgqlc.types.Field("User", graphql_name="createdBy")
    """Who created the integration"""

    last_update_user = sgqlc.types.Field("User", graphql_name="lastUpdateUser")
    """Who last updated the integration"""


class LookerDashboardTileRef(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("tile_id", "tile_title")
    tile_id = sgqlc.types.Field(String, graphql_name="tileId")

    tile_title = sgqlc.types.Field(String, graphql_name="tileTitle")


class ManyToManyChange(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("operation", "object_names")
    operation = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="operation")
    """add/delete"""

    object_names = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name="objectNames"
    )
    """Related objects"""


class MatchAndCreateBiWarehouseSources(sgqlc.types.Type):
    """Create or update a BI warehouse source. If BI warehouse source
    details are provided in the bi_warehouse_sources parameter then
    those are saved. Else, details are pulled from the BI APIs,
    matched with warehouses in Monte Carlo and details saved only if
    there is a full match.
    """

    __schema__ = schema
    __field_names__ = ("matching_bi_warehouse_sources",)
    matching_bi_warehouse_sources = sgqlc.types.Field(
        "MatchingBiWarehouseSources", graphql_name="matchingBiWarehouseSources"
    )


class MatchingBiWarehouseSources(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "match_successful",
        "bi_warehouse_sources",
        "raw_bi_warehouse_connections",
        "raw_warehouse_connections",
    )
    match_successful = sgqlc.types.Field(Boolean, graphql_name="matchSuccessful")
    """Indicates whether all BI source warehouses could be matched with a
    warehouse stored in MC. Only true if all BI source warehouses
    could be matched.
    """

    bi_warehouse_sources = sgqlc.types.Field(
        sgqlc.types.list_of(BiWarehouseSources), graphql_name="biWarehouseSources"
    )
    """Details of matched warehouses."""

    raw_bi_warehouse_connections = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="rawBiWarehouseConnections"
    )
    """Raw response from customer's BI system listing the warehouses it
    is connected to. Only set if match_successful is False.
    """

    raw_warehouse_connections = sgqlc.types.Field(
        sgqlc.types.list_of(String), graphql_name="rawWarehouseConnections"
    )
    """Details of warehouses that are in MC. Only set if match_successful
    is False.
    """


class McSqlResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("errors", "sql", "fragments")
    errors = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(Error))),
        graphql_name="errors",
    )

    sql = sgqlc.types.Field(String, graphql_name="sql")

    fragments = sgqlc.types.Field(GenericScalar, graphql_name="fragments")


class MconCountPair(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("mcon", "count")
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")

    count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="count")


class MconMonitorPair(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("mcon", "monitor_name")
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")

    monitor_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="monitorName")


class MconRuleIdPair(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("mcon", "monitoring_rule_id")
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="mcon")

    monitoring_rule_id = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="monitoringRuleId"
    )


class MconsMonitorsCountPair(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("mcons_count", "monitors_count")
    mcons_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="mconsCount")

    monitors_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="monitorsCount")


class MergeAlerts(sgqlc.types.Type):
    """Merge alerts together"""

    __schema__ = schema
    __field_names__ = ("alert",)
    alert = sgqlc.types.Field("Alert", graphql_name="alert")
    """The updated alert"""


class MetricAggregationOutputType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("metric", "aggregation")
    metric = sgqlc.types.Field(String, graphql_name="metric")
    """Query performance metric"""

    aggregation = sgqlc.types.Field(String, graphql_name="aggregation")
    """Metric aggregation function"""


class MetricAnomalyCorrelation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("field", "metric", "correlations")
    field = sgqlc.types.Field(String, graphql_name="field")

    metric = sgqlc.types.Field(String, graphql_name="metric")

    correlations = sgqlc.types.Field(
        sgqlc.types.list_of(FieldValueCorrelation), graphql_name="correlations"
    )


class MetricAnomalyCorrelationV2(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("field", "metric", "data", "has_strong_correlations")
    field = sgqlc.types.Field(String, graphql_name="field")

    metric = sgqlc.types.Field(String, graphql_name="metric")

    data = sgqlc.types.Field(sgqlc.types.list_of(FieldValueCorrelation), graphql_name="data")

    has_strong_correlations = sgqlc.types.Field(Boolean, graphql_name="hasStrongCorrelations")


class MetricCorrelationResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("metric_anomalies", "metric_anomalies_v2")
    metric_anomalies = sgqlc.types.Field(
        sgqlc.types.list_of(MetricAnomalyCorrelation), graphql_name="metricAnomalies"
    )

    metric_anomalies_v2 = sgqlc.types.Field(
        sgqlc.types.list_of(MetricAnomalyCorrelationV2), graphql_name="metricAnomaliesV2"
    )


class MetricDimensions(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("rank", "label", "sequence_number", "data_source_uuid")
    rank = sgqlc.types.Field(Float, graphql_name="rank")

    label = sgqlc.types.Field(String, graphql_name="label")

    sequence_number = sgqlc.types.Field(Int, graphql_name="sequenceNumber")

    data_source_uuid = sgqlc.types.Field(UUID, graphql_name="dataSourceUuid")


class MetricEventGroup(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("group_key", "group_metadata")
    group_key = sgqlc.types.Field(
        sgqlc.types.non_null("MetricEventGroupKey"), graphql_name="groupKey"
    )
    """Attributes that uniquely defines an event group"""

    group_metadata = sgqlc.types.Field(
        sgqlc.types.non_null("MetricEventGroupMetadata"), graphql_name="groupMetadata"
    )
    """Additional metadata of the event group (not used to create the
    event group)
    """


class MetricEventGroupKey(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("monitor_uuid", "metric")
    monitor_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="monitorUuid")
    """The UUID of the metric monitor of the grouped events"""

    metric = sgqlc.types.Field(String, graphql_name="metric")
    """The name of the metric of the grouped events"""


class MetricEventGroupMetadata(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("newest_event_generated_time", "group_title", "tables", "total_events")
    newest_event_generated_time = sgqlc.types.Field(
        DateTime, graphql_name="newestEventGeneratedTime"
    )

    group_title = sgqlc.types.Field(String, graphql_name="groupTitle")

    tables = sgqlc.types.Field(sgqlc.types.list_of("WarehouseTable"), graphql_name="tables")
    """All tables associated with the metric event group"""

    total_events = sgqlc.types.Field(Int, graphql_name="totalEvents")
    """Total number of events in the event group"""


class MetricInfo(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("display_name", "metric", "metric_data_type")
    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")

    metric = sgqlc.types.Field(sgqlc.types.non_null(AggregateMetricType), graphql_name="metric")

    metric_data_type = sgqlc.types.Field(
        sgqlc.types.non_null(MetricDataType), graphql_name="metricDataType"
    )


class MetricMeasurement(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("timestamp", "value")
    timestamp = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="timestamp")

    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name="value")


class MetricMonitorSelectExpression(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "metric_monitor", "expression", "data_type", "is_raw_column_name")
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    metric_monitor = sgqlc.types.Field(
        sgqlc.types.non_null("ComparisonMonitorResponse"), graphql_name="metricMonitor"
    )

    expression = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="expression")

    data_type = sgqlc.types.Field(
        MetricMonitorSelectExpressionModelDataType, graphql_name="dataType"
    )

    is_raw_column_name = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="isRawColumnName"
    )


class MetricMonitoringConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("MetricMonitoringEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class MetricMonitoringEdge(sgqlc.types.Type):
    """A Relay edge containing a `MetricMonitoring` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("MetricMonitoring", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class MetricSampling(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("columns", "rows", "query", "has_error")
    columns = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="columns")

    rows = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.list_of(String)), graphql_name="rows")

    query = sgqlc.types.Field(String, graphql_name="query")

    has_error = sgqlc.types.Field(Boolean, graphql_name="hasError")


class MetricUnit(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("singular", "plural")
    singular = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="singular")
    """Singular unit. For example, row"""

    plural = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="plural")
    """Plural unit. For example, rows"""


class Metrics(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("metrics", "is_partial_date_range", "metrics_json")
    metrics = sgqlc.types.Field(sgqlc.types.list_of("TableMetricV2"), graphql_name="metrics")
    """List of metrics. Deprecated: Use metricsJson for better
    performance
    """

    is_partial_date_range = sgqlc.types.Field(Boolean, graphql_name="isPartialDateRange")

    metrics_json = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="metricsJson")
    """List of metrics, in JSON representation"""


class MigrateCollectorResources(sgqlc.types.Type):
    """Migrate resources (warehouses, BI) from one data collector to
    another
    """

    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """If the migration was successful"""


class MigrateConnectionFromSnowflakeAgent(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """True if the connection was migrated successfully."""


class MigrateConnectionToSnowflakeAgent(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("success",)
    success = sgqlc.types.Field(Boolean, graphql_name="success")
    """True if the connection was migrated successfully."""


class MonitorAtRisk(sgqlc.types.Type):
    """Monitor that could be affected if this table monitor is deleted"""

    __schema__ = schema
    __field_names__ = ("uuid", "description", "creator", "created_time", "monitor_type")
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """Monitor UUID"""

    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="description")
    """Monitor description"""

    creator = sgqlc.types.Field(String, graphql_name="creator")
    """ID of user who created the monitor"""

    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name="createdTime")
    """When the monitor was created"""

    monitor_type = sgqlc.types.Field(
        sgqlc.types.non_null(UserDefinedMonitors), graphql_name="monitorType"
    )
    """Type of monitor"""


class MonitorAtRiskConnection(sgqlc.types.relay.Connection):
    """Relay connection for monitors at risk"""

    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("MonitorAtRiskEdge")), graphql_name="edges"
    )
    """Contains the nodes in this connection."""


class MonitorAtRiskEdge(sgqlc.types.Type):
    """A Relay edge containing a `MonitorAtRisk` and its cursor."""

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field(MonitorAtRisk, graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class MonitorBootstrap(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "state",
        "exceptions_detail",
        "skip_reason",
        "started_at",
        "finished_at",
        "days_loaded",
        "estimated_seconds_remaining",
        "progress_percent",
    )
    state = sgqlc.types.Field(
        sgqlc.types.non_null(MetricMonitoringBootstrapState), graphql_name="state"
    )
    """State of the monitor bootstrapping process."""

    exceptions_detail = sgqlc.types.Field(
        sgqlc.types.list_of(sgqlc.types.non_null(JobExecutionException)),
        graphql_name="exceptionsDetail",
    )
    """Exceptions that were captured while the bootstrap is in an error
    state.
    """

    skip_reason = sgqlc.types.Field(String, graphql_name="skipReason")
    """Reason why the historical data loading was skipped, if the status
    is SKIPPED_HISTORY.
    """

    started_at = sgqlc.types.Field(DateTime, graphql_name="startedAt")
    """Indicates when historical data loading started."""

    finished_at = sgqlc.types.Field(DateTime, graphql_name="finishedAt")
    """Indicates when historical data loading finished."""

    days_loaded = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="daysLoaded")
    """Number of days of historical data that have been loaded."""

    estimated_seconds_remaining = sgqlc.types.Field(Int, graphql_name="estimatedSecondsRemaining")
    """Estimated time remaining for the historical data loading to
    complete, in seconds.
    """

    progress_percent = sgqlc.types.Field(Int, graphql_name="progressPercent")
    """Progress for loading historical data."""


class MonitorConfiguration(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("time_field", "aggregation_type", "lookback_days")
    time_field = sgqlc.types.Field(String, graphql_name="timeField")
    """Time field to use for the monitor"""

    aggregation_type = sgqlc.types.Field(MonitorAggTimeInterval, graphql_name="aggregationType")
    """Day or Hour"""

    lookback_days = sgqlc.types.Field(Int, graphql_name="lookbackDays")
    """The history days for the monitor"""


class MonitorDashboardData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "total_monitor_count",
        "paused_count",
        "snoozed_count",
        "active_count",
        "training_count",
        "misconfigured_count",
        "error_count",
        "in_progress_count",
        "no_status_count",
    )
    total_monitor_count = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="totalMonitorCount"
    )
    """Total count of monitors actively in MC account"""

    paused_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="pausedCount")
    """Total number of paused monitors"""

    snoozed_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="snoozedCount")
    """Total number of snoozed monitors"""

    active_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="activeCount")
    """Total count of monitors with active status"""

    training_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="trainingCount")
    """Total count of monitors with training status"""

    misconfigured_count = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="misconfiguredCount"
    )
    """Total count of monitors with misconfigured status"""

    error_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="errorCount")
    """Total count of monitors with error status"""

    in_progress_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="inProgressCount")
    """Total number of monitors currently running"""

    no_status_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="noStatusCount")
    """Total number of monitors with state no status"""


class MonitorDataSource(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "uuid",
        "connection_uuid",
        "custom_sql",
        "type",
        "schema",
        "tables",
        "transforms",
    )
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")

    connection_uuid = sgqlc.types.Field(UUID, graphql_name="connectionUuid")
    """The connection uuid"""

    custom_sql = sgqlc.types.Field(String, graphql_name="customSql")

    type = sgqlc.types.Field(sgqlc.types.non_null(DataSourceType), graphql_name="type")

    schema = sgqlc.types.Field(DataSourceSchema, graphql_name="schema")

    tables = sgqlc.types.Field(sgqlc.types.list_of("WarehouseTable"), graphql_name="tables")

    transforms = sgqlc.types.Field(sgqlc.types.list_of("Transform"), graphql_name="transforms")


class MonitorDataset(sgqlc.types.Type):
    """Datasets referenced by monitors, grouped by dataset name"""

    __schema__ = schema
    __field_names__ = ("display_name", "mcons")
    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")
    """Dataset name"""

    mcons = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="mcons",
    )
    """List of MCONs for the datasets with this name"""


class MonitorLabel(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("label",)
    label = sgqlc.types.Field(String, graphql_name="label")
    """The monitor label name"""


class MonitorLabelObject(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "uuid",
        "label",
        "created_by",
        "default_failure_audience",
        "monitors",
        "monitor_count",
        "notification_count",
        "used_in_mac",
    )
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")
    """Unique identifier of a monitor label"""

    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="label")
    """Monitor label name"""

    created_by = sgqlc.types.Field("User", graphql_name="createdBy")
    """Monitor label creator"""

    default_failure_audience = sgqlc.types.Field(
        sgqlc.types.non_null(Boolean), graphql_name="defaultFailureAudience"
    )
    """When creating a new monitor, this audience should be included, by
    default, in the monitor's list of failure_audiences
    """

    monitors = sgqlc.types.Field(
        sgqlc.types.list_of("Monitor"),
        graphql_name="monitors",
        args=sgqlc.types.ArgDict(
            (
                (
                    "monitor_types",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(UserDefinedMonitors),
                        graphql_name="monitorTypes",
                        default=None,
                    ),
                ),
                (
                    "status_types",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(MonitorStatusType),
                        graphql_name="statusTypes",
                        default=None,
                    ),
                ),
                (
                    "consolidated_status_types",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(ConsolidatedMonitorStatusType),
                        graphql_name="consolidatedStatusTypes",
                        default=None,
                    ),
                ),
                (
                    "description_field_or_table",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(String),
                        graphql_name="descriptionFieldOrTable",
                        default=None,
                    ),
                ),
                (
                    "created_by",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(String)),
                        graphql_name="createdBy",
                        default=None,
                    ),
                ),
                (
                    "updated_by",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(String)),
                        graphql_name="updatedBy",
                        default=None,
                    ),
                ),
                (
                    "priorities",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(String), graphql_name="priorities", default=None
                    ),
                ),
                ("domain_id", sgqlc.types.Arg(UUID, graphql_name="domainId", default=None)),
                (
                    "domain_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(UUID)),
                        graphql_name="domainIds",
                        default=None,
                    ),
                ),
                (
                    "uuids",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(String), graphql_name="uuids", default=None
                    ),
                ),
                (
                    "created_by_filters",
                    sgqlc.types.Arg(
                        CreatedByFilters, graphql_name="createdByFilters", default=None
                    ),
                ),
                (
                    "labels",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(String), graphql_name="labels", default=None
                    ),
                ),
                (
                    "search",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(String), graphql_name="search", default=None
                    ),
                ),
                (
                    "search_fields",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(UserDefinedMonitorSearchFields),
                        graphql_name="searchFields",
                        default=None,
                    ),
                ),
                (
                    "namespaces",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(String), graphql_name="namespaces", default=None
                    ),
                ),
                (
                    "is_template_managed",
                    sgqlc.types.Arg(Boolean, graphql_name="isTemplateManaged", default=None),
                ),
                (
                    "is_ootb_replacement",
                    sgqlc.types.Arg(Boolean, graphql_name="isOotbReplacement", default=False),
                ),
                (
                    "include_ootb_monitors",
                    sgqlc.types.Arg(Boolean, graphql_name="includeOotbMonitors", default=False),
                ),
                (
                    "include_ootb_replacement",
                    sgqlc.types.Arg(Boolean, graphql_name="includeOotbReplacement", default=False),
                ),
                (
                    "mcons",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(String), graphql_name="mcons", default=None
                    ),
                ),
                (
                    "exclude_mcons",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(String), graphql_name="excludeMcons", default=None
                    ),
                ),
                (
                    "alerted_only",
                    sgqlc.types.Arg(Boolean, graphql_name="alertedOnly", default=None),
                ),
                (
                    "tags",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(TagKeyValuePairInput), graphql_name="tags", default=None
                    ),
                ),
                (
                    "asset_tags",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(TagKeyValuePairInput)),
                        graphql_name="assetTags",
                        default=None,
                    ),
                ),
                (
                    "exclude_asset_tags",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(TagKeyValuePairInput)),
                        graphql_name="excludeAssetTags",
                        default=None,
                    ),
                ),
                (
                    "data_product_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(UUID), graphql_name="dataProductIds", default=None
                    ),
                ),
                (
                    "data_quality_dimensions",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(String),
                        graphql_name="dataQualityDimensions",
                        default=None,
                    ),
                ),
                ("order_by", sgqlc.types.Arg(String, graphql_name="orderBy", default=None)),
                ("limit", sgqlc.types.Arg(Int, graphql_name="limit", default=None)),
                ("offset", sgqlc.types.Arg(Int, graphql_name="offset", default=None)),
            )
        ),
    )
    """List of monitors using this label

    Arguments:

    * `monitor_types` (`[UserDefinedMonitors]`): Type of monitors to
      filter by, default all
    * `status_types` (`[MonitorStatusType]`): Type of monitor status
      to filter by, default all
    * `consolidated_status_types` (`[ConsolidatedMonitorStatusType]`):
      Type of consolidated monitor status to filter by, default all
    * `description_field_or_table` (`[String]`): DEPRECATED
    * `created_by` (`[String!]`): Filter by creator using a list of
      user emails
    * `updated_by` (`[String!]`): Filter by updater using a list of
      user emails
    * `priorities` (`[String]`): Filter by priorities. It can include
      null to include monitors without a priority set
    * `domain_id` (`UUID`): Domain uuid to filter by
    * `domain_ids` (`[UUID!]`): List of domain uuids to filter by
    * `uuids` (`[String]`): list of uuids of the monitors to filter by
    * `created_by_filters` (`CreatedByFilters`): Deprecated
    * `labels` (`[String]`): List of labels to filter by
    * `search` (`[String]`): Search criteria for filtering the
      monitors list
    * `search_fields` (`[UserDefinedMonitorSearchFields]`): Which
      fields to include during search
    * `namespaces` (`[String]`): filter by namespaces
    * `is_template_managed` (`Boolean`): Filter monitors created by
      code
    * `is_ootb_replacement` (`Boolean`): Filter monitors which replace
      a default ootb detector (default: `false`)
    * `include_ootb_monitors` (`Boolean`): If set to true, OOTB
      monitors will be returned. They will be the first few monitors
      in the first page of the results (default: `false`)
    * `include_ootb_replacement` (`Boolean`): If set to true and
      is_ootb_replacement is not specified or false, ootb_replacement
      monitors will be included in result (default: `false`)
    * `mcons` (`[String]`): Filter by warehouses, projects, datasets,
      or tables (MCON)
    * `exclude_mcons` (`[String]`): Exclude monitors associated with
      these warehouses, projects, datasets, or tables (MCON)
    * `alerted_only` (`Boolean`): EXPERIMENTAL. Filter monitors to
      only the ones that are breached.
    * `tags` (`[TagKeyValuePairInput]`): Filter by monitor tags. It
      can include null to include monitors without tags
    * `asset_tags` (`[TagKeyValuePairInput!]`): Filter by asset tags.
      Returns monitors with at least one linked table that has any of
      the provided tags
    * `exclude_asset_tags` (`[TagKeyValuePairInput!]`): Exclude
      monitors that have any linked table whose tags consist only of
      the provided tags. Tables with additional tags or no tags are
      included
    * `data_product_ids` (`[UUID]`): Filter by data product IDs
    * `data_quality_dimensions` (`[String]`): Filter by data quality
      dimensions
    * `order_by` (`String`): Field and direction to order monitors by
    * `limit` (`Int`): Number of monitors to return
    * `offset` (`Int`): From which monitor to return the next results
    """

    monitor_count = sgqlc.types.Field(Int, graphql_name="monitorCount")
    """The number of monitors using this label"""

    notification_count = sgqlc.types.Field(Int, graphql_name="notificationCount")
    """The number of notifications using this label"""

    used_in_mac = sgqlc.types.Field(Boolean, graphql_name="usedInMac")
    """Flag for whether any MaC monitors use this label"""


class MonitorLimits(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "max_time_series",
        "max_time_series_hourly",
        "max_time_series_daily",
        "max_time_series_weekly",
        "max_time_series_monthly",
    )
    max_time_series = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="maxTimeSeries")
    """Time series limit"""

    max_time_series_hourly = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="maxTimeSeriesHourly"
    )
    """Hourly time series limit"""

    max_time_series_daily = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="maxTimeSeriesDaily"
    )
    """Daily time series limit"""

    max_time_series_weekly = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="maxTimeSeriesWeekly"
    )
    """Weekly time series limit"""

    max_time_series_monthly = sgqlc.types.Field(
        sgqlc.types.non_null(Int), graphql_name="maxTimeSeriesMonthly"
    )
    """Monthly time series limit"""


class MonitorProject(sgqlc.types.Type):
    """Projects referenced by monitors, grouped by project name"""

    __schema__ = schema
    __field_names__ = ("display_name", "mcons")
    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")
    """Project name"""

    mcons = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="mcons",
    )
    """List of MCONs for the projects with this name"""


class MonitorQueries(sgqlc.types.Type):
    """A monitor query"""

    __schema__ = schema
    __field_names__ = ("queries",)
    queries = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="queries")
    """The SQL queries executed by the monitor"""


class MonitorQueriesResults(sgqlc.types.Type):
    """Result of executing a monitor query for test purposes"""

    __schema__ = schema
    __field_names__ = ("queries",)
    queries = sgqlc.types.Field(sgqlc.types.list_of("SQLResponse"), graphql_name="queries")
    """The SQL queries results"""


class MonitorRecommendationsResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("monitor_recommendations",)
    monitor_recommendations = sgqlc.types.Field(
        sgqlc.types.non_null(
            sgqlc.types.list_of(sgqlc.types.non_null(RecommendationConfigInterface))
        ),
        graphql_name="monitorRecommendations",
    )


class MonitorSamplingConfig(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("percentage", "count")
    percentage = sgqlc.types.Field(Float, graphql_name="percentage")

    count = sgqlc.types.Field(Int, graphql_name="count")


class MonitorSchedulingConfiguration(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("schedule_type", "interval_minutes", "start_time")
    schedule_type = sgqlc.types.Field(String, graphql_name="scheduleType")
    """One of fixed/dynamic or None if cannot decide automatically"""

    interval_minutes = sgqlc.types.Field(Int, graphql_name="intervalMinutes")
    """Number of minutes between monitor runs is schedule type is fixed"""

    start_time = sgqlc.types.Field(DateTime, graphql_name="startTime")
    """Date to start the monitor if schedule type is fixed"""


class MonitorScoreTrendType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("day", "pass_percentage")
    day = sgqlc.types.Field(String, graphql_name="day")
    """The day of the score trend"""

    pass_percentage = sgqlc.types.Field(Float, graphql_name="passPercentage")
    """Pass percentage for the day"""


class MonitorSqlBlocks(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("alert_condition", "where_condition", "group_by", "agent_span")
    alert_condition = sgqlc.types.Field(
        sgqlc.types.non_null("FilterGroup"), graphql_name="alertCondition"
    )

    where_condition = sgqlc.types.Field(
        sgqlc.types.non_null("FilterGroup"), graphql_name="whereCondition"
    )

    group_by = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(FilterValueInterface))),
        graphql_name="groupBy",
    )

    agent_span = sgqlc.types.Field(sgqlc.types.non_null("FilterGroup"), graphql_name="agentSpan")


class MonitorSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "resources",
        "stats",
        "categories",
        "hourly_stats",
        "json_schema",
        "custom_sql",
        "table_metric",
    )
    resources = sgqlc.types.Field("TableResources", graphql_name="resources")

    stats = sgqlc.types.Field(Int, graphql_name="stats")

    categories = sgqlc.types.Field(Int, graphql_name="categories")

    hourly_stats = sgqlc.types.Field(Int, graphql_name="hourlyStats")
    """Hourly stats monitors (DEPRECATED)"""

    json_schema = sgqlc.types.Field(Int, graphql_name="jsonSchema")

    custom_sql = sgqlc.types.Field(Int, graphql_name="customSql")

    table_metric = sgqlc.types.Field(Int, graphql_name="tableMetric")


class MonitorTable(sgqlc.types.Type):
    """Tables referenced by monitors, grouped by table identifier"""

    __schema__ = schema
    __field_names__ = ("display_name", "mcons")
    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")
    """Table identifier"""

    mcons = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="mcons",
    )
    """List of MCONs for the tables with this identifier"""


class MonitorTypeCount(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("monitor_type", "count")
    monitor_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="monitorType")

    count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="count")


class MonitorTypeCountsResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("results", "total_count", "offset", "limit")
    results = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(MonitorTypeCount)), graphql_name="results"
    )

    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="totalCount")

    offset = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="offset")

    limit = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="limit")


class MonitorWarehouse(sgqlc.types.Type):
    """Warehouse assets referenced by monitors, grouped by name"""

    __schema__ = schema
    __field_names__ = ("display_name", "mcons")
    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="displayName")
    """Warehouse name"""

    mcons = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="mcons",
    )
    """List of MCONs for the warehouses with this name"""


class MonitoredTableRuleJobStatusObject(sgqlc.types.Type):
    """Job status for updating monitored table rules"""

    __schema__ = schema
    __field_names__ = ("created_time", "updated_time", "uuid", "tables_updated", "status")
    created_time = sgqlc.types.Field(DateTime, graphql_name="createdTime")
    """Time when the job was created"""

    updated_time = sgqlc.types.Field(DateTime, graphql_name="updatedTime")
    """Time when the job was last updated"""

    uuid = sgqlc.types.Field(UUID, graphql_name="uuid")
    """Job ID for the job"""

    tables_updated = sgqlc.types.Field(Int, graphql_name="tablesUpdated")
    """Number of tables updated by the job"""

    status = sgqlc.types.Field(MonitoredTableRuleJobStatus, graphql_name="status")
    """Status of the job"""


class MonitoredTableRuleListUpdateOutput(sgqlc.types.Type):
    """Output of the async update of the monitored table rules"""

    __schema__ = schema
    __field_names__ = ("rules", "job_id")
    rules = sgqlc.types.Field(sgqlc.types.list_of("MonitoredTableRuleObject"), graphql_name="rules")
    """The complete list of rules for deciding which tables are monitored
    within the given project & dataset scope
    """

    job_id = sgqlc.types.Field(UUID, graphql_name="jobId")
    """The job ID for the async update"""


class MonitoredTableRuleObject(sgqlc.types.Type):
    """Rule for deciding which tables are monitored"""

    __schema__ = schema
    __field_names__ = (
        "id",
        "dataset",
        "is_exclude",
        "project",
        "rule_type",
        "table_rule_attribute",
        "table_rule_text",
        "source",
        "monitored_rule_type",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name="id")

    dataset = sgqlc.types.Field(String, graphql_name="dataset")
    """Schema/Dataset where rule applies"""

    is_exclude = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isExclude")
    """Is this an exclude rule?"""

    project = sgqlc.types.Field(String, graphql_name="project")
    """Project/database scope of the rule"""

    rule_type = sgqlc.types.Field(MonitoredTableRuleType, graphql_name="ruleType")
    """Type of rule"""

    table_rule_attribute = sgqlc.types.Field(
        MonitoredTableRuleTableAttribute, graphql_name="tableRuleAttribute"
    )
    """Table attribute that the rule matches against"""

    table_rule_text = sgqlc.types.Field(String, graphql_name="tableRuleText")
    """Either a simple string value or a JSON string (for tag rules)"""

    source = sgqlc.types.Field(String, graphql_name="source")
    """Source of the rule"""

    monitored_rule_type = sgqlc.types.Field(MonitoredRuleType, graphql_name="monitoredRuleType")
    """Monitoring rule type"""


class MonitoringRuleData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "id",
        "warehouse_uuid",
        "warehouse_name",
        "project_name",
        "dataset",
        "is_exclude",
        "rule_type",
        "table_rule_attribute",
        "table_rule_text",
        "is_disabled",
        "source",
        "monitored_rule_type",
        "created_by_id",
        "last_update_user_id",
    )
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name="id")

    warehouse_uuid = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="warehouseUuid")

    warehouse_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="warehouseName")

    project_name = sgqlc.types.Field(String, graphql_name="projectName")

    dataset = sgqlc.types.Field(String, graphql_name="dataset")

    is_exclude = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isExclude")

    rule_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="ruleType")

    table_rule_attribute = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="tableRuleAttribute"
    )

    table_rule_text = sgqlc.types.Field(String, graphql_name="tableRuleText")

    is_disabled = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name="isDisabled")

    source = sgqlc.types.Field(String, graphql_name="source")

    monitored_rule_type = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="monitoredRuleType"
    )

    created_by_id = sgqlc.types.Field(Int, graphql_name="createdById")

    last_update_user_id = sgqlc.types.Field(Int, graphql_name="lastUpdateUserId")


class MonteCarloConfigTemplateConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ("page_info", "edges")
    page_info = sgqlc.types.Field(sgqlc.types.non_null("PageInfo"), graphql_name="pageInfo")
    """Pagination data for this connection."""

    edges = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of("MonteCarloConfigTemplateEdge")),
        graphql_name="edges",
    )
    """Contains the nodes in this connection."""


class MonteCarloConfigTemplateDeleteResponse(sgqlc.types.Type):
    """Monte Carlo Config Template Delete Response"""

    __schema__ = schema
    __field_names__ = ("num_deleted", "changes_applied")
    num_deleted = sgqlc.types.Field(Int, graphql_name="numDeleted")
    """Number of resources deleted"""

    changes_applied = sgqlc.types.Field(Boolean, graphql_name="changesApplied")
    """Changes applied?"""


class MonteCarloConfigTemplateEdge(sgqlc.types.Type):
    """A Relay edge containing a `MonteCarloConfigTemplate` and its
    cursor.
    """

    __schema__ = schema
    __field_names__ = ("node", "cursor")
    node = sgqlc.types.Field("MonteCarloConfigTemplate", graphql_name="node")
    """The item at the end of the edge"""

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="cursor")
    """A cursor for use in pagination"""


class MonteCarloConfigTemplateExportResponse(sgqlc.types.Type):
    """Monte Carlo Config Template Export Response"""

    __schema__ = schema
    __field_names__ = ("config_template_as_yaml", "errors")
    config_template_as_yaml = sgqlc.types.Field(String, graphql_name="configTemplateAsYaml")
    """Config Template as YAML"""

    errors = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name="errors")
    """Errors encountered"""


class MonteCarloConfigTemplateUpdateAsyncResponse(sgqlc.types.Type):
    """Monte Carlo Config Template Update Async Response"""

    __schema__ = schema
    __field_names__ = ("update_uuid", "errors_as_json", "warnings_as_json")
    update_uuid = sgqlc.types.Field(UUID, graphql_name="updateUuid")
    """The UUID of the requested update. Used to poll for the status of
    the update. Null if the update request is invalid.
    """

    errors_as_json = sgqlc.types.Field(String, graphql_name="errorsAsJson")
    """Errors encountered"""

    warnings_as_json = sgqlc.types.Field(String, graphql_name="warningsAsJson")
    """Warnings encountered"""


class MonteCarloConfigTemplateUpdateAsyncState(sgqlc.types.Type):
    """Monte Carlo Config Template Update Async State"""

    __schema__ = schema
    __field_names__ = (
        "resource_modifications",
        "changes_applied",
        "errors_as_json",
        "warnings_as_json",
        "info_as_json",
        "state",
    )
    resource_modifications = sgqlc.types.Field(
        sgqlc.types.list_of("ResourceModification"), graphql_name="resourceModifications"
    )
    """List of resource modifications"""

    changes_applied = sgqlc.types.Field(Boolean, graphql_name="changesApplied")
    """Changes applied?"""

    errors_as_json = sgqlc.types.Field(String, graphql_name="errorsAsJson")
    """Errors encountered"""

    warnings_as_json = sgqlc.types.Field(String, graphql_name="warningsAsJson")
    """Warnings encountered"""

    info_as_json = sgqlc.types.Field(String, graphql_name="infoAsJson")
    """Informational messages"""

    state = sgqlc.types.Field(sgqlc.types.non_null(State), graphql_name="state")
    """State of the async update"""


class MonteCarloConfigTemplateUpdateResponse(sgqlc.types.Type):
    """Monte Carlo Config Template Update Response"""

    __schema__ = schema
    __field_names__ = (
        "resource_modifications",
        "changes_applied",
        "errors_as_json",
        "warnings_as_json",
        "info_as_json",
    )
    resource_modifications = sgqlc.types.Field(
        sgqlc.types.list_of("ResourceModification"), graphql_name="resourceModifications"
    )
    """List of resource modifications"""

    changes_applied = sgqlc.types.Field(Boolean, graphql_name="changesApplied")
    """Changes applied?"""

    errors_as_json = sgqlc.types.Field(String, graphql_name="errorsAsJson")
    """Errors encountered"""

    warnings_as_json = sgqlc.types.Field(String, graphql_name="warningsAsJson")
    """Warnings encountered"""

    info_as_json = sgqlc.types.Field(String, graphql_name="infoAsJson")
    """Informational messages"""


class MonteCarloStatusMapping(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("servicenow_incident_state", "incident_feedback")
    servicenow_incident_state = sgqlc.types.Field(
        sgqlc.types.non_null(String), graphql_name="servicenowIncidentState"
    )

    incident_feedback = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))),
        graphql_name="incidentFeedback",
    )


class MsTeamsChannel(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("id", "team_id", "name")
    id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="id")
    """Channel ID (MS-specific)"""

    team_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="teamId")
    """ID of the team the channel belongs to"""

    name = sgqlc.types.Field(String, graphql_name="name")
    """Human readable channel name"""


class MsTeamsChannelList(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("channels",)
    channels = sgqlc.types.Field(sgqlc.types.list_of(MsTeamsChannel), graphql_name="channels")


class MsTeamsInstallation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("uuid", "name", "team_link", "team_id")
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name="uuid")

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="name")
    """Name of the installation"""

    team_link = sgqlc.types.Field(String, graphql_name="teamLink")

    team_id = sgqlc.types.Field(String, graphql_name="teamId")


class MsTeamsInstallationList(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ("install_link", "installations")
    install_link = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name="installLink")

    installations = sgqlc.types.Field(
        sgqlc.types.non_null(sgqlc.types.list_of(MsTeamsInstallation)), graphql_name="installations"
    )


class Mutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = (
        "create_or_update_agent_trace_table",
        "delete_agent_trace_table",
        "link_slack_app_installation",
        "create_logs_integration",
        "update_logs_integration",
        "delete_logs_integration",
        "generate_report",
        "create_datadog_integration",
        "update_datadog_integration",
        "delete_datadog_integration",
        "create_datadog_incident_for_alert",
        "link_datadog_incident_for_alert",
        "unlink_datadog_incident_for_alert",
        "create_or_update_table_monitor",
        "pause_table_monitor",
        "delete_table_monitor",
        "update_monitor_tags",
        "bulk_add_monitor_tags",
        "delete_monitor_tag",
        "update_monitor_data_quality_dimension",
        "bulk_add_monitor_data_quality_dimension",
        "create_or_update_tag",
        "create_or_update_tag_assignments",
        "create_or_update_data_operations_dashboard",
        "delete_data_operations_dashboard",
        "create_or_update_validation",
        "caas_link_collection_resources",
        "caas_update_collection_node_parameters",
        "caas_update_collection_node_env",
        "caas_update_collection_storage_parameters",
        "caas_update_collection_storage_version",
        "caas_update_collection_node_version",
        "trigger_platform_migration",
        "trigger_platform_migration_test",
        "trigger_migration_test",
        "add_platform_service",
        "restore_collection_storage",
        "connect_platform_service_to_legacy_bucket",
        "connect_platform_service_to_existing_bucket",
        "connect_platform_to_existing_agent",
        "caas_update_collection_storage_link",
        "caas_update_collection_storage_encryption",
        "refresh_entitlements",
        "run_table_monitor_validation",
        "test_updated_credentials_v2",
        "update_credentials_v2",
        "update_self_hosted_credentials_v2",
        "update_dbt_cloud_credentials_v2_mutation",
        "update_transactional_db_credentials_v2",
        "update_big_query_credentials_v2",
        "update_tableau_credentials_v2",
        "update_looker_credentials_v2",
        "update_looker_git_auth_credentials_v2",
        "update_power_bi_credentials_v2",
        "update_snowflake_credentials_v2",
        "update_redshift_credentials_v2",
        "update_databricks_metastore_credentials_v2",
        "update_spark_credentials_v2",
        "update_databricks_metastore_sql_warehouse_credentials_v2",
        "update_databricks_sql_warehouse_credentials_v2",
        "test_databricks_metastore_updated_credentials_v2",
        "update_azure_data_factory_credentials_v2",
        "update_pinecone_credentials_v2",
        "create_or_update_data_explorer_dashboard",
        "delete_data_explorer_dashboard",
        "create_or_update_data_explorer_comparison_dashboard",
        "delete_data_explorer_comparison_dashboard",
        "create_webex_integration",
        "update_webex_integration",
        "delete_webex_integration",
        "update_monitored_table_rule_list",
        "update_monitored_table_rule_list_async",
        "add_monitored_table_rule_async",
        "toggle_performance_dashboard_for_domain_restricted_users",
        "create_or_update_agent",
        "delete_agent",
        "upgrade_agent",
        "update_agent_parameters",
        "restart_agent",
        "cleanup_azure_agent_tasks",
        "migrate_connection_to_snowflake_agent",
        "migrate_connection_from_snowflake_agent",
        "create_tableau_asset_warning",
        "update_tableau_asset_warning",
        "generate_dc_upgrade_template",
        "delete_data_product",
        "delete_data_product_v2",
        "create_or_update_data_product",
        "create_or_update_data_product_v2",
        "update_data_product_sharing",
        "toggle_data_product_monitoring",
        "link_ms_teams_installation",
        "link_github_app_installation",
        "register_github_app_installation_request",
        "update_github_installation",
        "delete_github_installation",
        "register_gitlab_app",
        "link_gitlab_app",
        "delete_gitlab_installation",
        "select_gitlab_projects",
        "update_gitlab_installation",
        "create_azure_devops_installation",
        "update_azure_devops_installation",
        "link_azure_devops_installation",
        "delete_azure_devops_installation",
        "set_azure_devops_source_selections",
        "update_data_share",
        "test_confluent_kafka_credentials",
        "test_confluent_kafka_connect_credentials",
        "test_msk_kafka_credentials",
        "test_msk_kafka_connect_credentials",
        "test_self_hosted_kafka_credentials",
        "test_self_hosted_kafka_connect_credentials",
        "add_streaming_system",
        "add_streaming_connection",
        "delete_streaming_system",
        "delete_streaming_cluster",
        "update_streaming_system_name",
        "update_streaming_cluster_name",
        "toggle_size_collection",
        "create_mcp_integration_key",
        "delete_mcp_integration_key",
        "create_opsgenie_integration",
        "update_opsgenie_integration",
        "update_opsgenie_integration_webhook_secret",
        "delete_opsgenie_integration",
        "link_opsgenie_incident",
        "unlink_opsgenie_incident",
        "relink_opsgenie_incident",
        "create_pagerduty_service_integration",
        "update_pagerduty_service_integration",
        "update_pagerduty_service_integration_webhook_secret",
        "delete_pagerduty_service_integration",
        "enable_automated_volume_change_table_monitor",
        "enable_explicit_volume_change_table_monitor",
        "disable_volume_change_table_monitor",
        "enable_automated_ucs_table_monitor",
        "enable_explicit_ucs_table_monitor",
        "disable_ucs_table_monitor",
        "enable_automated_freshness_table_monitor",
        "enable_explicit_freshness_table_monitor",
        "disable_freshness_table_monitor",
        "create_servicenow_integration",
        "update_servicenow_integration",
        "delete_servicenow_integration",
        "create_servicenow_incident_for_alert",
        "link_servicenow_incident_for_alert",
        "unlink_servicenow_incident_for_alert",
        "create_azure_devops_integration",
        "update_azure_devops_integration",
        "link_azure_devops_integration",
        "delete_azure_devops_integration",
        "create_azure_devops_work_item_for_alert",
        "link_azure_devops_work_item_for_alert",
        "unlink_azure_devops_work_item_for_alert",
        "create_jira_integration",
        "update_jira_integration",
        "update_jira_integration_webhook_secret",
        "delete_jira_integration",
        "create_jira_ticket_for_incident",
        "create_jira_ticket_for_alert",
        "link_jira_ticket_for_incident",
        "link_jira_ticket_for_alert",
        "unlink_jira_ticket_for_incident",
        "unlink_jira_ticket_for_alert",
        "create_or_update_notification_setting",
        "create_or_update_recipient_name",
        "delete_notification_settings",
        "delete_recipient_name",
        "create_or_update_audience",
        "create_or_update_audience_notification_setting",
        "delete_audience_notification_setting",
        "create_or_update_audience_routing_rule",
        "delete_audience_routing_rule",
        "set_default_failure_audiences",
        "set_pii_filter_status",
        "update_pii_filtering_preferences",
        "update_monitor_name",
        "update_monitor_description",
        "update_monitor_notes",
        "update_monitor_labels",
        "run_monitor",
        "update_monitors_priorities",
        "update_monitors_schedules",
        "pause_monitors",
        "delete_monitors",
        "run_monitors",
        "create_custom_user",
        "create_unified_user_assignment",
        "delete_unified_user_assignment",
        "send_dbt_artifacts_event",
        "set_group_repetitive_dbt_model_failures",
        "set_group_repetitive_dbt_test_failures",
        "set_group_repetitive_dbt_test_warnings",
        "set_group_repetitive_dbt_snapshot_failures",
        "set_group_repetitive_dbt_seed_failures",
        "set_project_generate_incidents_for_model_failures",
        "set_project_generate_alerts_for_model_failures",
        "set_project_generate_incidents_for_test_failures",
        "set_project_generate_alerts_for_test_failures",
        "set_project_generate_incidents_for_test_warnings",
        "set_project_generate_alerts_for_test_warnings",
        "set_project_generate_alerts_for_snapshot_failures",
        "set_project_generate_alerts_for_seed_failures",
        "set_job_generates_incidents",
        "set_job_generates_alerts",
        "snooze_dbt_node",
        "unsnooze_dbt_node",
        "update_dbt_project_info",
        "create_or_update_monte_carlo_config_template",
        "create_or_update_monte_carlo_config_template_async",
        "delete_monte_carlo_config_template",
        "convert_ui_monitors_to_config_template",
        "convert_config_template_to_ui_monitors",
        "set_sensitivity",
        "add_to_collection_block_list",
        "remove_from_collection_block_list",
        "modify_collection_block_list",
        "add_allow_list_entry",
        "delete_allow_list_entry",
        "set_workspaces_allow_list_for_power_bi_reports_collection",
        "set_asset_collection_preferences",
        "delete_asset_collection_preferences",
        "delete_data_maintenance_entry",
        "create_or_update_data_maintenance_entry",
        "create_data_maintenance_window_from_holidays",
        "create_custom_rule",
        "create_or_update_custom_rule",
        "create_custom_metric_rule",
        "create_or_update_custom_metric_rule",
        "update_custom_metric_rule_notes",
        "update_custom_metric_severity",
        "trigger_circuit_breaker_rule",
        "trigger_custom_rule",
        "create_or_update_volume_rule",
        "create_or_update_custom_sql_rule",
        "create_or_update_comparison_rule",
        "create_or_update_query_perf_rule",
        "create_or_update_freshness_custom_rule",
        "snooze_custom_rule",
        "unsnooze_custom_rule",
        "snooze_custom_rules",
        "unsnooze_custom_rules",
        "delete_custom_rule",
        "restore_custom_rule",
        "trigger_circuit_breaker_rule_v2",
        "run_sql_rule",
        "run_custom_rules",
        "pause_rule",
        "update_custom_rule_investigation_query",
        "create_or_update_lineage_node",
        "create_or_update_lineage_edge",
        "create_or_update_lineage_node_block_pattern",
        "create_or_update_lineage_node_replacement_rule",
        "create_or_update_lineage_node_collapsing_rule",
        "delete_lineage_node",
        "delete_lineage_node_block_pattern",
        "delete_lineage_node_replacement_rule",
        "delete_lineage_node_collapsing_rule",
        "create_or_update_field_quality_rule",
        "create_or_update_catalog_object_metadata",
        "delete_catalog_object_metadata",
        "create_or_update_object_property",
        "delete_object_property",
        "bulk_create_or_update_object_properties",
        "create_or_update_monitor_label",
        "delete_monitor_label",
        "add_monitors_labels",
        "remove_monitors_labels",
        "create_or_update_custom_sql_template",
        "delete_custom_sql_template",
        "stop_monitor",
        "delete_monitor",
        "create_or_update_monitor",
        "pause_monitor",
        "resume_monitor_bootstrap",
        "pause_monitor_bootstrap",
        "create_or_update_comparison_monitor",
        "create_or_update_metric_monitor",
        "create_or_update_agent_monitor",
        "create_or_update_json_schema_monitor",
        "validate_cron",
        "set_event_detector_feedback",
        "set_event_detector_feedback_by_alert",
        "set_incident_feedback",
        "set_incident_feedback_v2",
        "set_incident_severity",
        "set_alert_severity",
        "create_or_update_incident_comment",
        "create_or_update_alert_comment",
        "set_alert_owner",
        "set_incident_owner",
        "delete_incident_comment",
        "delete_alert_comment",
        "split_incident",
        "split_alert",
        "bulk_update_incidents",
        "bulk_update_alerts",
        "update_alert",
        "send_alert_invite",
        "create_or_update_domain",
        "delete_domain",
        "create_or_update_authorization_group",
        "delete_authorization_group",
        "update_user_authorization_group_membership",
        "create_or_update_auth_provisioning",
        "request_access",
        "create_or_update_resource",
        "match_and_create_bi_warehouse_sources",
        "toggle_disable_sampling",
        "toggle_restrict_sampling",
        "toggle_disable_value_ingestion",
        "toggle_disable_value_sampling_when_testing",
        "toggle_enable_full_distribution_metrics",
        "toggle_warehouse_tags_collection_setting",
        "save_table_importance_stats",
        "set_default_incident_group_interval",
        "set_default_alert_group_interval",
        "set_default_lineage_incident_grouping",
        "set_default_lineage_alert_grouping",
        "toggle_incident_grouping",
        "toggle_alert_grouping",
        "toggle_schema_change_incident_grouping",
        "toggle_schema_change_alert_grouping",
        "toggle_wildcard_aggregation",
        "toggle_create_alerts_in_datasource",
        "set_wildcard_templates",
        "set_custom_sql_sampling_size",
        "create_shared_query",
        "create_or_update_user_settings",
        "create_or_update_user_settings_batch",
        "update_user_state",
        "update_user_persona",
        "update_account_display_assets_search_tags",
        "set_account_name",
        "set_account_billing_plan",
        "set_account_max_time_series",
        "set_warehouse_name",
        "set_etl_container_name",
        "set_connection_name",
        "set_integration_name",
        "create_or_update_saml_identity_provider",
        "delete_saml_identity_provider",
        "invite_users",
        "invite_users_v2",
        "switch_user_account",
        "delete_user_invite",
        "resend_user_invite",
        "remove_user_from_account",
        "disable_user",
        "track_table",
        "upload_credentials",
        "save_slack_credentials",
        "deauthorize_slack_app",
        "test_credentials",
        "test_database_credentials",
        "test_presto_credentials",
        "test_snowflake_credentials",
        "test_hive_credentials",
        "test_s3_credentials",
        "test_glue_credentials",
        "test_athena_credentials",
        "test_looker_git_credentials",
        "test_looker_git_clone_credentials",
        "test_dbt_cloud_credentials",
        "test_bq_credentials",
        "test_spark_credentials",
        "test_databricks_sql_warehouse_credentials",
        "test_self_hosted_credentials",
        "test_tableau_credentials",
        "test_power_bi_credentials",
        "test_fivetran_credentials",
        "toggle_mute_dataset",
        "toggle_mute_table",
        "toggle_mute_datasets",
        "toggle_mute_tables",
        "toggle_mute_with_regex",
        "toggle_slack_reply_warning",
        "toggle_slack_broadcast_updates",
        "toggle_connection_enable",
        "add_connection",
        "add_redshift_consumer_connection",
        "remove_connection",
        "set_connection_deletion_protection",
        "add_bi_connection",
        "update_bi_connection_name",
        "add_etl_connection",
        "toggle_event_config",
        "configure_metadata_events",
        "configure_query_log_events",
        "disable_metadata_events",
        "disable_query_log_events",
        "create_or_update_service_api_token",
        "create_access_token",
        "delete_access_token",
        "generate_collector_template",
        "update_credentials",
        "create_collector_record",
        "cleanup_collector_record",
        "migrate_collector_resources",
        "update_slack_channels",
        "create_integration_key",
        "delete_integration_key",
        "create_databricks_secret",
        "create_databricks_notebook_job",
        "update_databricks_notebook_job",
        "update_databricks_notebook",
        "start_databricks_cluster",
        "start_databricks_warehouse",
        "test_databricks_credentials",
        "test_delta_credentials",
        "add_databricks_connection",
        "save_event_onboarding_data",
        "delete_event_onboarding_data",
        "toggle_account_feature",
        "set_tutorial_state",
        "set_data_lake_catalog_mappings",
        "delete_integration",
        "update_workspace_identifier",
        "update_statement_option",
        "update_daily_usage_alert_config",
        "test_snowflake_credentials_v2",
        "test_redshift_credentials_v2",
        "test_bq_credentials_v2",
        "test_tableau_credentials_v2",
        "test_looker_credentials_v2",
        "test_looker_git_clone_credentials_v2",
        "test_looker_git_auth_credentials_v2",
        "test_power_bi_credentials_v2",
        "test_databricks_credentials_v2",
        "test_databricks_sql_warehouse_credentials_v2",
        "test_databricks_metastore_sql_warehouse_credentials_v2",
        "test_databricks_spark_credentials_v2",
        "test_airflow_credentials_v2",
        "test_pinecone_credentials",
        "test_transactional_db_credentials",
        "test_informatica_credentials",
        "test_azure_data_factory_credentials",
        "test_self_hosted_credentials_v2",
        "test_dbt_cloud_credentials_v2",
        "upload_airflow_dag_result",
        "upload_airflow_task_result",
        "upload_airflow_sla_misses",
        "merge_alerts",
        "request_alert_access",
        "create_or_update_collibra_integration",
        "delete_collibra_integration",
        "sync_monitors_to_collibra",
        "create_or_update_alation_integration",
        "delete_alation_integration",
        "create_or_update_alation_table_flag",
        "set_etl_job_generates_incidents",
        "set_etl_job_generates_alerts",
        "bulk_set_etl_job_generates_alerts",
        "configure_ai_agent_prompt",
        "create_account_secret",
        "update_account_secret",
        "delete_account_secret",
    )
    create_or_update_agent_trace_table = sgqlc.types.Field(
        CreateOrUpdateAgentTraceTable,
        graphql_name="createOrUpdateAgentTraceTable",
        args=sgqlc.types.ArgDict(
            (
                (
                    "input",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(CreateOrUpdateAgentTraceTableInput),
                        graphql_name="input",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """(experimental) Create or update an agent trace table

    Arguments:

    * `input` (`CreateOrUpdateAgentTraceTableInput!`)None
    """

    delete_agent_trace_table = sgqlc.types.Field(
        DeleteAgentTraceTable,
        graphql_name="deleteAgentTraceTable",
        args=sgqlc.types.ArgDict(
            (
                (
                    "input",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(DeleteAgentTraceTableInput),
                        graphql_name="input",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """(experimental) Delete an agent trace table

    Arguments:

    * `input` (`DeleteAgentTraceTableInput!`)None
    """

    link_slack_app_installation = sgqlc.types.Field(
        LinkSlackAppInstallation,
        graphql_name="linkSlackAppInstallation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "code",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="code", default=None
                    ),
                ),
                (
                    "state",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="state", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Callback API for Slack App Installation Oauth flow

    Arguments:

    * `code` (`String!`): OAuth code from Slack
    * `state` (`String!`): State parameter for OAuth flow
    """

    create_logs_integration = sgqlc.types.Field(
        CreateLogsIntegration,
        graphql_name="createLogsIntegration",
        args=sgqlc.types.ArgDict(
            (
                (
                    "headers",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(WebhookHeaderInput),
                        graphql_name="headers",
                        default=None,
                    ),
                ),
                (
                    "integration_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="integrationName", default=None
                    ),
                ),
                (
                    "integration_type",
                    sgqlc.types.Arg(
                        LogsIntegrationType, graphql_name="integrationType", default=None
                    ),
                ),
                (
                    "webhook_url",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="webhookUrl", default=None
                    ),
                ),
            )
        ),
    )
    """(general availability) Create a Logs integration (for monitor
    execution logging)

    Arguments:

    * `headers` (`[WebhookHeaderInput]`): List of headers field names
      and value to be used in the HTTP request
    * `integration_name` (`String!`): Integration name
    * `integration_type` (`LogsIntegrationType`): Type of integration,
      defaults to 'default'
    * `webhook_url` (`String!`): The webhook URL
    """

    update_logs_integration = sgqlc.types.Field(
        "UpdateLogsIntegration",
        graphql_name="updateLogsIntegration",
        args=sgqlc.types.ArgDict(
            (
                (
                    "headers",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(WebhookHeaderInput),
                        graphql_name="headers",
                        default=None,
                    ),
                ),
                (
                    "integration_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="integrationId", default=None
                    ),
                ),
                (
                    "integration_name",
                    sgqlc.types.Arg(String, graphql_name="integrationName", default=None),
                ),
                (
                    "integration_type",
                    sgqlc.types.Arg(
                        LogsIntegrationType, graphql_name="integrationType", default=None
                    ),
                ),
                ("webhook_url", sgqlc.types.Arg(String, graphql_name="webhookUrl", default=None)),
            )
        ),
    )
    """(general availability) Update a Logs integration (for monitor
    execution logging)

    Arguments:

    * `headers` (`[WebhookHeaderInput]`): List of headers field names
      and value to be used in the HTTP request
    * `integration_id` (`UUID!`): The integration ID
    * `integration_name` (`String`): Integration name
    * `integration_type` (`LogsIntegrationType`): Type of integration,
      defaults to 'default'
    * `webhook_url` (`String`): The webhook URL
    """

    delete_logs_integration = sgqlc.types.Field(
        DeleteLogsIntegration,
        graphql_name="deleteLogsIntegration",
        args=sgqlc.types.ArgDict(
            (
                (
                    "integration_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="integrationId", default=None
                    ),
                ),
            )
        ),
    )
    """(general availability) Delete a Logs integration (for monitor
    execution logging)

    Arguments:

    * `integration_id` (`UUID!`): The integration ID
    """

    generate_report = sgqlc.types.Field(
        GenerateReport,
        graphql_name="generateReport",
        args=sgqlc.types.ArgDict(
            (
                (
                    "report_parameters",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(ReportArgumentsUnionInput),
                        graphql_name="reportParameters",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """(experimental) Generate a report

    Arguments:

    * `report_parameters` (`ReportArgumentsUnionInput!`)None
    """

    create_datadog_integration = sgqlc.types.Field(
        CreateDatadogIntegration,
        graphql_name="createDatadogIntegration",
        args=sgqlc.types.ArgDict(
            (
                (
                    "api_key",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="apiKey", default=None
                    ),
                ),
                (
                    "application_key",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="applicationKey", default=None
                    ),
                ),
                (
                    "default_incident_fields",
                    sgqlc.types.Arg(JSONString, graphql_name="defaultIncidentFields", default=None),
                ),
                (
                    "integration_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="integrationName", default=None
                    ),
                ),
                (
                    "site",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="site", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Create a Datadog integration

    Arguments:

    * `api_key` (`String!`): Datadog API key
    * `application_key` (`String!`): Datadog Application key
    * `default_incident_fields` (`JSONString`): Default values for
      Datadog incident fields
    * `integration_name` (`String!`): Identifying name
    * `site` (`String!`): Datadog site (e.g. datadoghq.com)
    """

    update_datadog_integration = sgqlc.types.Field(
        "UpdateDatadogIntegration",
        graphql_name="updateDatadogIntegration",
        args=sgqlc.types.ArgDict(
            (
                ("api_key", sgqlc.types.Arg(String, graphql_name="apiKey", default=None)),
                (
                    "application_key",
                    sgqlc.types.Arg(String, graphql_name="applicationKey", default=None),
                ),
                (
                    "default_incident_fields",
                    sgqlc.types.Arg(JSONString, graphql_name="defaultIncidentFields", default=None),
                ),
                (
                    "integration_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="integrationId", default=None
                    ),
                ),
                (
                    "integration_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="integrationName", default=None
                    ),
                ),
                (
                    "site",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="site", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Update a Datadog integration

    Arguments:

    * `api_key` (`String`): Datadog API key
    * `application_key` (`String`): Datadog Application key
    * `default_incident_fields` (`JSONString`): Default values for
      Datadog incident fields
    * `integration_id` (`UUID!`): The integration ID
    * `integration_name` (`String!`): Identifying name
    * `site` (`String!`): Datadog site (e.g. datadoghq.com)
    """

    delete_datadog_integration = sgqlc.types.Field(
        DeleteDatadogIntegration,
        graphql_name="deleteDatadogIntegration",
        args=sgqlc.types.ArgDict(
            (
                (
                    "integration_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="integrationId", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Delete a Datadog integration

    Arguments:

    * `integration_id` (`UUID!`): The integration ID
    """

    create_datadog_incident_for_alert = sgqlc.types.Field(
        CreateDatadogIncidentForAlert,
        graphql_name="createDatadogIncidentForAlert",
        args=sgqlc.types.ArgDict(
            (
                (
                    "alert_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="alertId", default=None
                    ),
                ),
                (
                    "commander_email",
                    sgqlc.types.Arg(String, graphql_name="commanderEmail", default=None),
                ),
                ("description", sgqlc.types.Arg(String, graphql_name="description", default=None)),
                ("fields", sgqlc.types.Arg(JSONString, graphql_name="fields", default=None)),
                (
                    "integration_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="integrationId", default=None
                    ),
                ),
                (
                    "title",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="title", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Create a Datadog incident for alert

    Arguments:

    * `alert_id` (`UUID!`): ID of the alert
    * `commander_email` (`String`): Email of the incident commander to
      assign
    * `description` (`String`): Description of the incident
    * `fields` (`JSONString`): Additional incident fields
      (key->value).
    * `integration_id` (`UUID!`): ID of the Datadog integration
    * `title` (`String!`): Title of the incident
    """

    link_datadog_incident_for_alert = sgqlc.types.Field(
        LinkDatadogIncidentForAlert,
        graphql_name="linkDatadogIncidentForAlert",
        args=sgqlc.types.ArgDict(
            (
                (
                    "alert_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="alertId", default=None
                    ),
                ),
                (
                    "dd_incident_url",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="ddIncidentUrl", default=None
                    ),
                ),
                (
                    "integration_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="integrationId", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Link Datadog Incident for Alert

    Arguments:

    * `alert_id` (`UUID!`): ID of the alert
    * `dd_incident_url` (`String!`): Full Datadog incident URL (any
      site/region). Requires incident_read scope to resolve the
      incident UUID.
    * `integration_id` (`UUID!`): ID of the Datadog integration
    """

    unlink_datadog_incident_for_alert = sgqlc.types.Field(
        "UnlinkDatadogIncidentForAlert",
        graphql_name="unlinkDatadogIncidentForAlert",
        args=sgqlc.types.ArgDict(
            (
                (
                    "alert_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="alertId", default=None
                    ),
                ),
                (
                    "dd_incident_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="ddIncidentId", default=None
                    ),
                ),
                (
                    "integration_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="integrationId", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Unlink Datadog Incident for Alert

    Arguments:

    * `alert_id` (`UUID!`): ID of the alert
    * `dd_incident_id` (`String!`): Datadog internal incident id
    * `integration_id` (`UUID!`): ID of the Datadog integration
    """

    create_or_update_table_monitor = sgqlc.types.Field(
        CreateOrUpdateTableMonitor,
        graphql_name="createOrUpdateTableMonitor",
        args=sgqlc.types.ArgDict(
            (
                (
                    "alert_conditions",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(TableMonitorAlertConditionInput)),
                        graphql_name="alertConditions",
                        default=None,
                    ),
                ),
                (
                    "asset_selection",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(AssetSelectionInput),
                        graphql_name="assetSelection",
                        default=None,
                    ),
                ),
                (
                    "audiences",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(String)),
                        graphql_name="audiences",
                        default=None,
                    ),
                ),
                (
                    "data_quality_dimension",
                    sgqlc.types.Arg(String, graphql_name="dataQualityDimension", default=None),
                ),
                (
                    "description",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="description", default=None
                    ),
                ),
                (
                    "domain_restrictions",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(UUID)),
                        graphql_name="domainRestrictions",
                        default=None,
                    ),
                ),
                ("dry_run", sgqlc.types.Arg(Boolean, graphql_name="dryRun", default=False)),
                (
                    "failure_audiences",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(String)),
                        graphql_name="failureAudiences",
                        default=None,
                    ),
                ),
                ("notes", sgqlc.types.Arg(String, graphql_name="notes", default="")),
                ("priority", sgqlc.types.Arg(String, graphql_name="priority", default=None)),
                (
                    "tags",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(TagKeyValuePairInput)),
                        graphql_name="tags",
                        default=None,
                    ),
                ),
                ("uuid", sgqlc.types.Arg(UUID, graphql_name="uuid", default=None)),
                (
                    "warehouse_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="warehouseUuid", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Create or update a Table monitor

    Arguments:

    * `alert_conditions` (`[TableMonitorAlertConditionInput!]`): Alert
      conditions for the table monitor
    * `asset_selection` (`AssetSelectionInput!`)None
    * `audiences` (`[String!]`): The monitor notification audiences
    * `data_quality_dimension` (`String`): Data quality dimension of
      the monitor.
    * `description` (`String!`): Description of rule
    * `domain_restrictions` (`[UUID!]`): The domains to restrict to
    * `dry_run` (`Boolean`): Dry run the monitor creation or update
      and return the YAML and queries. (default: `false`)
    * `failure_audiences` (`[String!]`): The audiences to notify on
      failure
    * `notes` (`String`): Additional context for the monitor (default:
      `""`)
    * `priority` (`String`): The default priority for alerts involving
      this monitor
    * `tags` (`[TagKeyValuePairInput!]`): The monitor tags.
    * `uuid` (`UUID`): UUID of the table monitor, to update existing
      monito
    * `warehouse_uuid` (`UUID!`): Warehouse UUID
    """

    pause_table_monitor = sgqlc.types.Field(
        "PauseTableMonitor",
        graphql_name="pauseTableMonitor",
        args=sgqlc.types.ArgDict(
            (
                (
                    "monitor_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="monitorUuid", default=None
                    ),
                ),
                (
                    "pause",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(Boolean), graphql_name="pause", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Enable a Table monitor

    Arguments:

    * `monitor_uuid` (`UUID!`): UUID of the table monitor to
      pause/unpause
    * `pause` (`Boolean!`): Pause state of the monitor
    """

    delete_table_monitor = sgqlc.types.Field(
        DeleteTableMonitor,
        graphql_name="deleteTableMonitor",
        args=sgqlc.types.ArgDict(
            (
                (
                    "monitor_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="monitorUuid", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Delete a Table monitor

    Arguments:

    * `monitor_uuid` (`UUID!`): UUID of the table monitor to delete
    """

    update_monitor_tags = sgqlc.types.Field(
        "UpdateMonitorTags",
        graphql_name="updateMonitorTags",
        args=sgqlc.types.ArgDict(
            (
                ("monitor_type", sgqlc.types.Arg(String, graphql_name="monitorType", default=None)),
                (
                    "monitor_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="monitorUuid", default=None
                    ),
                ),
                (
                    "tags",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(TagKeyValuePairInput)),
                        graphql_name="tags",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """(experimental) Set whether to group dbt snapshot failures with the
    same error message into the same incident

    Arguments:

    * `monitor_type` (`String`): DEPRECATED: field is ignored
    * `monitor_uuid` (`UUID!`): UUID of the metric monitor or custom
      rule
    * `tags` (`[TagKeyValuePairInput]!`): Tags to insert on the
      monitor
    """

    bulk_add_monitor_tags = sgqlc.types.Field(
        BulkAddMonitorTags,
        graphql_name="bulkAddMonitorTags",
        args=sgqlc.types.ArgDict(
            (
                (
                    "monitor_uuids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(UUID))),
                        graphql_name="monitorUuids",
                        default=None,
                    ),
                ),
                (
                    "tags",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(TagKeyValuePairInput)),
                        graphql_name="tags",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """(experimental) Bulk add monitor tags.

    Arguments:

    * `monitor_uuids` (`[UUID!]!`): UUIDs of the metric monitor or
      custom rule
    * `tags` (`[TagKeyValuePairInput]!`): Tags to insert on the
      monitor
    """

    delete_monitor_tag = sgqlc.types.Field(
        DeleteMonitorTag,
        graphql_name="deleteMonitorTag",
        args=sgqlc.types.ArgDict(
            (
                (
                    "tag_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name="tagId", default=None),
                ),
            )
        ),
    )
    """(experimental) Delete unused monitor tag

    Arguments:

    * `tag_id` (`UUID!`): UUID of the tag to delete
    """

    update_monitor_data_quality_dimension = sgqlc.types.Field(
        "UpdateMonitorDataQualityDimension",
        graphql_name="updateMonitorDataQualityDimension",
        args=sgqlc.types.ArgDict(
            (
                (
                    "data_quality_dimension",
                    sgqlc.types.Arg(String, graphql_name="dataQualityDimension", default=None),
                ),
                (
                    "monitor_type",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="monitorType", default=None
                    ),
                ),
                (
                    "monitor_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="monitorUuid", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Update data quality dimension on a monitor.

    Arguments:

    * `data_quality_dimension` (`String`): Data quality dimension to
      assign to the monitor.If not set, we'll clear the data quality
      dimension on the monitor.
    * `monitor_type` (`String!`): Type of monitor.
    * `monitor_uuid` (`UUID!`): UUID of the metric monitor or custom
      rule.
    """

    bulk_add_monitor_data_quality_dimension = sgqlc.types.Field(
        BulkAddMonitorDataQualityDimension,
        graphql_name="bulkAddMonitorDataQualityDimension",
        args=sgqlc.types.ArgDict(
            (
                (
                    "data_quality_dimension",
                    sgqlc.types.Arg(String, graphql_name="dataQualityDimension", default=None),
                ),
                (
                    "monitor_uuids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(UUID))),
                        graphql_name="monitorUuids",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """(experimental) Bulk add monitor data quality dimension.

    Arguments:

    * `data_quality_dimension` (`String`): Data quality dimension to
      assign to monitors
    * `monitor_uuids` (`[UUID!]!`): UUIDs of the metric monitor or
      custom rule
    """

    create_or_update_tag = sgqlc.types.Field(
        CreateOrUpdateTagMutation,
        graphql_name="createOrUpdateTag",
        args=sgqlc.types.ArgDict(
            (
                ("tag_name", sgqlc.types.Arg(String, graphql_name="tagName", default=None)),
                ("tag_type", sgqlc.types.Arg(TagType, graphql_name="tagType", default=None)),
                ("tag_uuid", sgqlc.types.Arg(UUID, graphql_name="tagUuid", default=None)),
                ("tag_value", sgqlc.types.Arg(String, graphql_name="tagValue", default=None)),
            )
        ),
    )
    """(experimental) Create or update a tag.

    Arguments:

    * `tag_name` (`String`): Tag name. Required when creating a new
      tag.
    * `tag_type` (`TagType`): Tag type. Required when creating a new
      tag, and tag_type can't be changed once created.
    * `tag_uuid` (`UUID`): UUID of tag for update.
    * `tag_value` (`String`): Tag value.
    """

    create_or_update_tag_assignments = sgqlc.types.Field(
        CreateOrUpdateTagAssignmentsMutation,
        graphql_name="createOrUpdateTagAssignments",
        args=sgqlc.types.ArgDict(
            (
                (
                    "object_ids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(String)),
                        graphql_name="objectIds",
                        default=None,
                    ),
                ),
                (
                    "object_type",
                    sgqlc.types.Arg(
                        TagAssignmentObjectType, graphql_name="objectType", default=None
                    ),
                ),
                (
                    "tag_type",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(TagType), graphql_name="tagType", default=None
                    ),
                ),
                (
                    "tag_uuids",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(UUID)),
                        graphql_name="tagUuids",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """(experimental) Create or update tags assignments for a list of
    objects with the same type.

    Arguments:

    * `object_ids` (`[String]!`): Object ids.
    * `object_type` (`TagAssignmentObjectType`): Object type.
    * `tag_type` (`TagType!`): Tag Type.
    * `tag_uuids` (`[UUID]!`): UUIDs of tags to assign to the objects.
    """

    create_or_update_data_operations_dashboard = sgqlc.types.Field(
        CreateOrUpdateDataOperationsDashboardMutation,
        graphql_name="createOrUpdateDataOperationsDashboard",
        args=sgqlc.types.ArgDict(
            (
                (
                    "criteria",
                    sgqlc.types.Arg(DODCriteriaInput, graphql_name="criteria", default=None),
                ),
                ("description", sgqlc.types.Arg(String, graphql_name="description", default=None)),
                ("name", sgqlc.types.Arg(String, graphql_name="name", default=None)),
                ("uuid", sgqlc.types.Arg(UUID, graphql_name="uuid", default=None)),
            )
        ),
    )
    """(experimental) Create or update data operations dashboard.

    Arguments:

    * `criteria` (`DODCriteriaInput`): Criteria for the dashboard.
    * `description` (`String`): Description of the Data Operations
      Dashboard
    * `name` (`String`): Data Operations Dashboard name
    * `uuid` (`UUID`): UUID of data operations dashboard to update
    """

    delete_data_operations_dashboard = sgqlc.types.Field(
        DeleteDataOperationsDashboardMutation,
        graphql_name="deleteDataOperationsDashboard",
        args=sgqlc.types.ArgDict(
            (
                (
                    "data_operations_dashboard_uuid",
                    sgqlc.types.Arg(UUID, graphql_name="dataOperationsDashboardUuid", default=None),
                ),
            )
        ),
    )
    """(experimental) Delete a data operations dashboard.

    Arguments:

    * `data_operations_dashboard_uuid` (`UUID`): UUID of the data
      operations dashboard to delete.
    """

    create_or_update_validation = sgqlc.types.Field(
        CreateOrUpdateValidation,
        graphql_name="createOrUpdateValidation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "alert_condition",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(FilterGroupInput),
                        graphql_name="alertCondition",
                        default=None,
                    ),
                ),
                ("connection_id", sgqlc.types.Arg(UUID, graphql_name="connectionId", default=None)),
                (
                    "custom_rule_uuid",
                    sgqlc.types.Arg(UUID, graphql_name="customRuleUuid", default=None),
                ),
                (
                    "data_quality_dimension",
                    sgqlc.types.Arg(String, graphql_name="dataQualityDimension", default=None),
                ),
                (
                    "data_source",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(DataSourceUnionInput),
                        graphql_name="dataSource",
                        default=None,
                    ),
                ),
                (
                    "description",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="description", default=None
                    ),
                ),
                ("dry_run", sgqlc.types.Arg(Boolean, graphql_name="dryRun", default=False)),
                (
                    "dw_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name="dwId", default=None),
                ),
                (
                    "event_rollup_count",
                    sgqlc.types.Arg(Int, graphql_name="eventRollupCount", default=None),
                ),
                (
                    "event_rollup_until_changed",
                    sgqlc.types.Arg(Boolean, graphql_name="eventRollupUntilChanged", default=None),
                ),
                (
                    "failure_audiences",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(sgqlc.types.non_null(String)),
                        graphql_name="failureAudiences",
                        default=None,
                    ),
                ),
                (
                    "interval_minutes",
                    sgqlc.types.Arg(Int, graphql_name="intervalMinutes", default=None),
                ),
                (
                    "labels",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(String), graphql_name="labels", default=None
                    ),
                ),
                ("notes", sgqlc.types.Arg(String, graphql_name="notes", default="")),
                (
                    "notify_rule_run_failure",
                    sgqlc.types.Arg(Boolean, graphql_name="notifyRuleRunFailure", default=None),
                ),
                ("priority", sgqlc.types.Arg(String, graphql_name="priority", default=None)),
                (
                    "schedule_config",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(ScheduleConfigInput),
                        graphql_name="scheduleConfig",
                        default=None,
                    ),
                ),
                ("severity", sgqlc.types.Arg(String, graphql_name="severity", default="")),
                ("start_time", sgqlc.types.Arg(DateTime, graphql_name="startTime", default=None)),
                (
                    "tags",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(TagKeyValuePairInput), graphql_name="tags", default=None
                    ),
                ),
                ("timeout", sgqlc.types.Arg(Int, graphql_name="timeout", default=None)),
                ("timezone", sgqlc.types.Arg(String, graphql_name="timezone", default=None)),
            )
        ),
    )
    """Create or update a validation

    Arguments:

    * `alert_condition` (`FilterGroupInput!`)None
    * `connection_id` (`UUID`): Specify a connection (e.g. query-
      engine) to use
    * `custom_rule_uuid` (`UUID`): UUID of custom rule, to update
      existing rule
    * `data_quality_dimension` (`String`): Data quality dimension on
      the custom rule.
    * `data_source` (`DataSourceUnionInput!`)None
    * `description` (`String!`): Description of rule
    * `dry_run` (`Boolean`): Dry run the monitor creation or update
      and return the MaC YAML and queries. (default: `false`)
    * `dw_id` (`UUID!`): Warehouse UUID
    * `event_rollup_count` (`Int`): The number of events to roll up
      into a single incident
    * `event_rollup_until_changed` (`Boolean`): If true, roll up
      events until the value changes
    * `failure_audiences` (`[String!]`): The audiences to notify on
      failure
    * `interval_minutes` (`Int`): How often to run scheduled custom
      rule check (DEPRECATED, use schedule instead)
    * `labels` (`[String]`): The monitor labels
    * `notes` (`String`): Additional context for the monitor (default:
      `""`)
    * `notify_rule_run_failure` (`Boolean`): DEPRECATED: Completely
      ignored. This field has no effect on anything. Use
      `failure_audiences` to determine who is notified when run
      failures occur.
    * `priority` (`String`): The default priority for alerts involving
      this monitor
    * `schedule_config` (`ScheduleConfigInput!`): Schedule of the
      validation
    * `severity` (`String`): DEPRECATED. Use priority instead. The
      default severity for incidents involving this monitor (default:
      `""`)
    * `start_time` (`DateTime`): Start time of schedule (DEPRECATED,
      use schedule instead)
    * `tags` (`[TagKeyValuePairInput]`): The monitor tags.
    * `timeout` (`Int`): Timeout for the SQL query
    * `timezone` (`String`): Timezone (DEPRECATED, use timezone in
      scheduleConfig instead
    """

    caas_link_collection_resources = sgqlc.types.Field(
        CaasLinkCollectionResources,
        graphql_name="caasLinkCollectionResources",
        args=sgqlc.types.ArgDict(
            (
                ("dc_uuid", sgqlc.types.Arg(UUID, graphql_name="dcUuid", default=None)),
                ("service_uuid", sgqlc.types.Arg(UUID, graphql_name="serviceUuid", default=None)),
            )
        ),
    )
    """Links a pre-provisioned node and data-store to the specified DC.
    Only non-active DCs with template_variant=aether are supported.

    Arguments:

    * `dc_uuid` (`UUID`): [Deprecated] Use serviceUuid instead
    * `service_uuid` (`UUID`): Platform Service UUID. To disambiguate
      accounts with multiple services
    """

    caas_update_collection_node_parameters = sgqlc.types.Field(
        CaasUpdateCollectionNodeParameters,
        graphql_name="caasUpdateCollectionNodeParameters",
        args=sgqlc.types.ArgDict(
            (
                ("dc_uuid", sgqlc.types.Arg(UUID, graphql_name="dcUuid", default=None)),
                ("service_uuid", sgqlc.types.Arg(UUID, graphql_name="serviceUuid", default=None)),
                (
                    "updates",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(GenericScalar), graphql_name="updates", default=None
                    ),
                ),
            )
        ),
    )
    """Updates the parameters for the collection node associated to the
    specified DC

    Arguments:

    * `dc_uuid` (`UUID`): [Deprecated] Use serviceUuid instead
    * `service_uuid` (`UUID`): Platform Service UUID. To disambiguate
      accounts with multiple services
    * `updates` (`GenericScalar!`): Dictionary containing the values
      to update
    """

    caas_update_collection_node_env = sgqlc.types.Field(
        CaasUpdateCollectionNodeEnv,
        graphql_name="caasUpdateCollectionNodeEnv",
        args=sgqlc.types.ArgDict(
            (
                ("replace", sgqlc.types.Arg(Boolean, graphql_name="replace", default=False)),
                ("service_uuid", sgqlc.types.Arg(UUID, graphql_name="serviceUuid", default=None)),
                (
                    "updates",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(GenericScalar), graphql_name="updates", default=None
                    ),
                ),
            )
        ),
    )
    """Updates the environment variables for the collection node
    associated to the specified DC

    Arguments:

    * `replace` (`Boolean`): If True, the current environment
      variables will be replaced by the new ones (default: `false`)
    * `service_uuid` (`UUID`): Platform Service UUID. To disambiguate
      accounts with multiple services
    * `updates` (`GenericScalar!`): Dictionary containing the values
      to update
    """

    caas_update_collection_storage_parameters = sgqlc.types.Field(
        CaasUpdateCollectionStorageParameters,
        graphql_name="caasUpdateCollectionStorageParameters",
        args=sgqlc.types.ArgDict(
            (
                ("dc_uuid", sgqlc.types.Arg(UUID, graphql_name="dcUuid", default=None)),
                ("service_uuid", sgqlc.types.Arg(UUID, graphql_name="serviceUuid", default=None)),
                (
                    "updates",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(GenericScalar), graphql_name="updates", default=None
                    ),
                ),
            )
        ),
    )
    """Updates the parameters for the collection storage associated to
    the specified DC

    Arguments:

    * `dc_uuid` (`UUID`): [Deprecated] Use serviceUuid instead
    * `service_uuid` (`UUID`): Platform Service UUID. To disambiguate
      accounts with multiple services
    * `updates` (`GenericScalar!`): JSON string with a dictionary
      containing the values to update
    """

    caas_update_collection_storage_version = sgqlc.types.Field(
        CaasUpdateCollectionStorageVersion,
        graphql_name="caasUpdateCollectionStorageVersion",
        args=sgqlc.types.ArgDict(
            (
                (
                    "service_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="serviceUuid", default=None
                    ),
                ),
                (
                    "template_version",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(Int), graphql_name="templateVersion", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Updates the collection storage template version
    associated to a DC.

    Arguments:

    * `service_uuid` (`UUID!`): Platform Service UUID. To disambiguate
      accounts with multiple services
    * `template_version` (`Int!`): Template version to upgrade to
    """

    caas_update_collection_node_version = sgqlc.types.Field(
        CaasUpdateCollectionNodeVersion,
        graphql_name="caasUpdateCollectionNodeVersion",
        args=sgqlc.types.ArgDict(
            (
                ("code_version", sgqlc.types.Arg(String, graphql_name="codeVersion", default=None)),
                ("dc_uuid", sgqlc.types.Arg(UUID, graphql_name="dcUuid", default=None)),
                ("service_uuid", sgqlc.types.Arg(UUID, graphql_name="serviceUuid", default=None)),
                (
                    "template_version",
                    sgqlc.types.Arg(String, graphql_name="templateVersion", default=None),
                ),
            )
        ),
    )
    """Updates the collection node associated to the specified DC to the
    specified version.If no version is provided, the node is upgraded
    to latest version.

    Arguments:

    * `code_version` (`String`): Optional version to upgrade to, if
      not specified latest GA version is used
    * `dc_uuid` (`UUID`): [Deprecated] Use serviceUuid instead
    * `service_uuid` (`UUID`): Platform Service UUID. To disambiguate
      accounts with multiple services
    * `template_version` (`String`): Optional template version to
      upgrade to, if not specified and code is not specified either,
      then the template is also updated to latest GA
    """

    trigger_platform_migration = sgqlc.types.Field(
        "TriggerPlatformMigration",
        graphql_name="triggerPlatformMigration",
        args=sgqlc.types.ArgDict(
            (
                ("dc_uuid", sgqlc.types.Arg(UUID, graphql_name="dcUuid", default=None)),
                ("dry_run", sgqlc.types.Arg(Boolean, graphql_name="dryRun", default=True)),
                ("rollback", sgqlc.types.Arg(Boolean, graphql_name="rollback", default=True)),
                ("service_uuid", sgqlc.types.Arg(UUID, graphql_name="serviceUuid", default=None)),
            )
        ),
    )
    """Triggers the platform migration for a given DC in background,
    dryRun can be used to run validations without performing the
    migration.

    Arguments:

    * `dc_uuid` (`UUID`): [Deprecated] Use serviceUuid instead
    * `dry_run` (`Boolean`): Runs only validations without performing
      the migration when True (default: `true`)
    * `rollback` (`Boolean`): Whether to rollback the migration if
      validation before migration fails. This will delete the DC and
      CaaS node created to perform the migration. (default: `true`)
    * `service_uuid` (`UUID`): Platform Service UUID. To disambiguate
      accounts with multiple services
    """

    trigger_platform_migration_test = sgqlc.types.Field(
        "TriggerPlatformMigrationTest",
        graphql_name="triggerPlatformMigrationTest",
        args=sgqlc.types.ArgDict(
            (
                ("dc_uuid", sgqlc.types.Arg(UUID, graphql_name="dcUuid", default=None)),
                ("service_uuid", sgqlc.types.Arg(UUID, graphql_name="serviceUuid", default=None)),
            )
        ),
    )
    """Triggers a platform migration test for a given DC in background,
    use getPlatformMigrationTestStatus to get results.

    Arguments:

    * `dc_uuid` (`UUID`): [Deprecated] Use serviceUuid instead
    * `service_uuid` (`UUID`): Platform Service UUID. To disambiguate
      accounts with multiple services
    """

    trigger_migration_test = sgqlc.types.Field(
        "TriggerMigrationTest",
        graphql_name="triggerMigrationTest",
        args=sgqlc.types.ArgDict(
            (
                (
                    "overrides",
                    sgqlc.types.Arg(GenericScalar, graphql_name="overrides", default=None),
                ),
                (
                    "resource_uuids",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(UUID), graphql_name="resourceUuids", default=None
                    ),
                ),
                (
                    "run_all_validations",
                    sgqlc.types.Arg(Boolean, graphql_name="runAllValidations", default=False),
                ),
                (
                    "source_dc_uuid",
                    sgqlc.types.Arg(UUID, graphql_name="sourceDcUuid", default=None),
                ),
                (
                    "source_service_uuid",
                    sgqlc.types.Arg(UUID, graphql_name="sourceServiceUuid", default=None),
                ),
                (
                    "target_dc_uuid",
                    sgqlc.types.Arg(UUID, graphql_name="targetDcUuid", default=None),
                ),
                (
                    "target_service_uuid",
                    sgqlc.types.Arg(UUID, graphql_name="targetServiceUuid", default=None),
                ),
            )
        ),
    )
    """Triggers the DC migration test operation that checks if all
    connections in DC can be migrated to target_dc. Validations are
    executed in background, you can check the progress using
    getMigrationTestStatus.

    Arguments:

    * `overrides` (`GenericScalar`): Dictionary containing properties
      to override per connection. The key must be the connection UUID
      and the value a dictionary including new values for the
      connection properties, like 'host'.
    * `resource_uuids` (`[UUID]`): List of resource UUIDs to test for
      migration. By default all resources will be tested.
    * `run_all_validations` (`Boolean`): If True, all validations will
      be run, otherwise only the ones marked as prerequisite will be
      executed. (default: `false`)
    * `source_dc_uuid` (`UUID`): [Deprecated] Use sourceServiceUuid
      instead
    * `source_service_uuid` (`UUID`): Source Platform Service UUID.
    * `target_dc_uuid` (`UUID`): [Deprecated] Use targetServiceUuid
      instead
    * `target_service_uuid` (`UUID`): Target Platform Service UUID.
    """

    add_platform_service = sgqlc.types.Field(
        AddPlatformService,
        graphql_name="addPlatformService",
        args=sgqlc.types.ArgDict(
            (
                (
                    "settings_source_service_uuid",
                    sgqlc.types.Arg(UUID, graphql_name="settingsSourceServiceUuid", default=None),
                ),
            )
        ),
    )
    """Adds a new platform service to the account, restricted operation.

    Arguments:

    * `settings_source_service_uuid` (`UUID`): Optional platform
      service to use as the source for settings (concurrency, memory
      and env vars). If not provided, default settings will be used.
    """

    restore_collection_storage = sgqlc.types.Field(
        "RestoreCollectionStorage",
        graphql_name="restoreCollectionStorage",
        args=sgqlc.types.ArgDict(
            (("service_uuid", sgqlc.types.Arg(UUID, graphql_name="serviceUuid", default=None)),)
        ),
    )
    """(experimental) Associates a new built-in collection storage to the
    specified service if no other storage or agent is associated.

    Arguments:

    * `service_uuid` (`UUID`): Platform Service UUID. To disambiguate
      accounts with multiple services
    """

    connect_platform_service_to_legacy_bucket = sgqlc.types.Field(
        ConnectPlatformServiceToLegacyBucket,
        graphql_name="connectPlatformServiceToLegacyBucket",
        args=sgqlc.types.ArgDict(
            (
                (
                    "source_service_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="sourceServiceUuid", default=None
                    ),
                ),
                (
                    "target_service_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="targetServiceUuid", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Connects a platform service to the bucket used by a
    legacy DC in the same account.

    Arguments:

    * `source_service_uuid` (`UUID!`): Source Platform Service UUID.
    * `target_service_uuid` (`UUID!`): Target Platform Service UUID.
    """

    connect_platform_service_to_existing_bucket = sgqlc.types.Field(
        ConnectPlatformServiceToExistingBucket,
        graphql_name="connectPlatformServiceToExistingBucket",
        args=sgqlc.types.ArgDict(
            (
                (
                    "bucket_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="bucketName", default=None
                    ),
                ),
                ("service_uuid", sgqlc.types.Arg(UUID, graphql_name="serviceUuid", default=None)),
            )
        ),
    )
    """(experimental) Connects a platform service to an existing bucket,
    creating a new data store. The bucket must be updated to allow
    access to the execution roles used by the node. Use
    getPlatformServiceExecutionRoles to get the list of roles to
    enable.

    Arguments:

    * `bucket_name` (`String!`): Name of the bucket to connect to.
    * `service_uuid` (`UUID`): Platform Service UUID. To disambiguate
      accounts with multiple services
    """

    connect_platform_to_existing_agent = sgqlc.types.Field(
        ConnectPlatformServiceToExistingAgent,
        graphql_name="connectPlatformToExistingAgent",
        args=sgqlc.types.ArgDict(
            (
                (
                    "source_service_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="sourceServiceUuid", default=None
                    ),
                ),
                (
                    "target_service_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="targetServiceUuid", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Connects a platform service to an existing agent,
    linked to another service in the same account.

    Arguments:

    * `source_service_uuid` (`UUID!`): Source Platform Service UUID.
    * `target_service_uuid` (`UUID!`): Target Platform Service UUID.
    """

    caas_update_collection_storage_link = sgqlc.types.Field(
        CaasUpdateCollectionStorageLink,
        graphql_name="caasUpdateCollectionStorageLink",
        args=sgqlc.types.ArgDict(
            (("service_uuid", sgqlc.types.Arg(UUID, graphql_name="serviceUuid", default=None)),)
        ),
    )
    """(experimental) If there's an agent associated to the service, it
    makes sure the link to the CaaS storage is deleted.

    Arguments:

    * `service_uuid` (`UUID`): Platform Service UUID. To disambiguate
      accounts with multiple services
    """

    caas_update_collection_storage_encryption = sgqlc.types.Field(
        CaasUpdateCollectionStorageEncryption,
        graphql_name="caasUpdateCollectionStorageEncryption",
        args=sgqlc.types.ArgDict(
            (
                (
                    "encryption_type",
                    sgqlc.types.Arg(
                        StorageEncryptionType,
                        graphql_name="encryptionType",
                        default="AMAZON_S3_SSE",
                    ),
                ),
                (
                    "service_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="serviceUuid", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Sets the collection storage encryption

    Arguments:

    * `encryption_type` (`StorageEncryptionType`): Type of storage
      encryption (default: 'AMAZON_S3_SSE') (default:
      `"AMAZON_S3_SSE"`)
    * `service_uuid` (`UUID!`): Platform Service UUID. To disambiguate
      accounts with multiple services
    """

    refresh_entitlements = sgqlc.types.Field(
        "RefreshEntitlements", graphql_name="refreshEntitlements"
    )

    run_table_monitor_validation = sgqlc.types.Field(
        "RunTableMonitorValidation",
        graphql_name="runTableMonitorValidation",
        args=sgqlc.types.ArgDict(
            (("mcon", sgqlc.types.Arg(String, graphql_name="mcon", default=None)),)
        ),
    )
    """Start a monitor validation process for a table

    Arguments:

    * `mcon` (`String`): MC resource unique identifier
    """

    test_updated_credentials_v2 = sgqlc.types.Field(
        "TestUpdatedCredentialsV2Mutation",
        graphql_name="testUpdatedCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "connection_options",
                    sgqlc.types.Arg(
                        ConnectionTestOptions, graphql_name="connectionOptions", default=None
                    ),
                ),
                (
                    "connection_type",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="connectionType", default=None
                    ),
                ),
                (
                    "temp_credentials_key",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String),
                        graphql_name="tempCredentialsKey",
                        default=None,
                    ),
                ),
                (
                    "validation_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="validationName", default=None
                    ),
                ),
            )
        ),
    )
    """Test the updated credentials of an existing connection.

    Arguments:

    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `connection_type` (`String!`): The type of the existing
      connection to test.
    * `temp_credentials_key` (`String!`): The temporary credentials
      key to use to retrieve new credentials.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    """

    update_credentials_v2 = sgqlc.types.Field(
        "UpdateCredentialsV2Mutation",
        graphql_name="updateCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
                (
                    "temp_credentials_key",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String),
                        graphql_name="tempCredentialsKey",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """Save the updated credentials for an existing connection.

    Arguments:

    * `connection_id` (`UUID!`): The connection uuid of the connection
      to update.
    * `temp_credentials_key` (`String!`): The temporary credentials
      key to use to retrieve new credentials.
    """

    update_self_hosted_credentials_v2 = sgqlc.types.Field(
        "UpdateSelfHostedCredentialsV2Mutation",
        graphql_name="updateSelfHostedCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(SelfHostedUpdateCredentialsConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Update self-hosted credentials for existing
    connection

    Arguments:

    * `changes` (`SelfHostedUpdateCredentialsConnectionDetails!`):
      Updated connection parameters for the connection with self-
      hosted credentials.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    update_dbt_cloud_credentials_v2_mutation = sgqlc.types.Field(
        "UpdateDbtCloudCredentialsV2Mutation",
        graphql_name="updateDbtCloudCredentialsV2Mutation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(DbtCloudUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """Update credentials for an existing dbt cloud connection.  Note:
    This mutation only uploads credentials and returns a temporary
    key. To complete the update:  Call testUpdatedCredentialsV2 with
    the returned key as tempCredentialsKey and the same connectionId
    to validate the credentials  Call updateCredentialsV2 with the
    same tempCredentialsKey and connectionId to persist the changes.
    See full instructions here -
    https://docs.getmontecarlo.com/docs/updating-integrations#/.

    Arguments:

    * `changes` (`DbtCloudUpdateConnectionDetails!`): Updated dbt
      Cloud connection parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    update_transactional_db_credentials_v2 = sgqlc.types.Field(
        "UpdateTransactionalDbCredentialsV2Mutation",
        graphql_name="updateTransactionalDbCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(TransactionalDbUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """Update credentials for an existing Transactional DB connection.
    Note: This mutation only uploads credentials and returns a
    temporary key. To complete the update:  Call
    testUpdatedCredentialsV2 with the returned key as
    tempCredentialsKey and the same connectionId to validate the
    credentials  Call updateCredentialsV2 with the same
    tempCredentialsKey and connectionId to persist the changes.  See
    full instructions here -
    https://docs.getmontecarlo.com/docs/updating-integrations#/.

    Arguments:

    * `changes` (`TransactionalDbUpdateConnectionDetails!`): Updated
      Transactional DB connection parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    update_big_query_credentials_v2 = sgqlc.types.Field(
        "UpdateBigQueryCredentialsV2Mutation",
        graphql_name="updateBigQueryCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(BigQueryUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """Update credentials for an existing Big Query connection.  Note:
    This mutation only uploads credentials and returns a temporary
    key. To complete the update:  Call testUpdatedCredentialsV2 with
    the returned key as tempCredentialsKey and the same connectionId
    to validate the credentials  Call updateCredentialsV2 with the
    same tempCredentialsKey and connectionId to persist the changes.
    See full instructions here -
    https://docs.getmontecarlo.com/docs/updating-integrations#/.

    Arguments:

    * `changes` (`BigQueryUpdateConnectionDetails!`): Updated Big
      Query connection parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    update_tableau_credentials_v2 = sgqlc.types.Field(
        "UpdateTableauCredentialsV2Mutation",
        graphql_name="updateTableauCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(TableauUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """Update credentials for an existing Tableau connection.  Note:
    This mutation only uploads credentials and returns a temporary
    key. To complete the update:  Call testUpdatedCredentialsV2 with
    the returned key as tempCredentialsKey and the same connectionId
    to validate the credentials  Call updateCredentialsV2 with the
    same tempCredentialsKey and connectionId to persist the changes.
    See full instructions here -
    https://docs.getmontecarlo.com/docs/updating-integrations#/.

    Arguments:

    * `changes` (`TableauUpdateConnectionDetails!`): Updated Tableau
      connection parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    update_looker_credentials_v2 = sgqlc.types.Field(
        "UpdateLookerCredentialsV2Mutation",
        graphql_name="updateLookerCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(LookerUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """Update credentials for an existing Looker connection.  Note: This
    mutation only uploads credentials and returns a temporary key. To
    complete the update:  Call testUpdatedCredentialsV2 with the
    returned key as tempCredentialsKey and the same connectionId to
    validate the credentials  Call updateCredentialsV2 with the same
    tempCredentialsKey and connectionId to persist the changes.  See
    full instructions here -
    https://docs.getmontecarlo.com/docs/updating-integrations#/.

    Arguments:

    * `changes` (`LookerUpdateConnectionDetails!`): Updated Looker
      connection parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    update_looker_git_auth_credentials_v2 = sgqlc.types.Field(
        "UpdateLookerGitAuthCredentialsV2Mutation",
        graphql_name="updateLookerGitAuthCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(LookerGitAuthUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Updates the Git authentication details, supports
    HTTPS or SSH protocol.

    Arguments:

    * `changes` (`LookerGitAuthUpdateConnectionDetails!`): Updated
      Looker connection parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    update_power_bi_credentials_v2 = sgqlc.types.Field(
        "UpdatePowerBiCredentialsV2Mutation",
        graphql_name="updatePowerBiCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(PowerBiUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """Update credentials for an existing PowerBi connection.  Note:
    This mutation only uploads credentials and returns a temporary
    key. To complete the update:  Call testUpdatedCredentialsV2 with
    the returned key as tempCredentialsKey and the same connectionId
    to validate the credentials  Call updateCredentialsV2 with the
    same tempCredentialsKey and connectionId to persist the changes.
    See full instructions here -
    https://docs.getmontecarlo.com/docs/updating-integrations#/.

    Arguments:

    * `changes` (`PowerBiUpdateConnectionDetails!`): Updated PowerBi
      connection parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    update_snowflake_credentials_v2 = sgqlc.types.Field(
        "UpdateSnowflakeCredentialsV2Mutation",
        graphql_name="updateSnowflakeCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(SnowflakeUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """Update credentials for an existing Snowflake connection.  Note:
    This mutation only uploads credentials and returns a temporary
    key. To complete the update:  Call testUpdatedCredentialsV2 with
    the returned key as tempCredentialsKey and the same connectionId
    to validate the credentials  Call updateCredentialsV2 with the
    same tempCredentialsKey and connectionId to persist the changes.
    See full instructions here -
    https://docs.getmontecarlo.com/docs/updating-integrations#/.

    Arguments:

    * `changes` (`SnowflakeUpdateConnectionDetails!`): Updated
      Snowflake connection parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    update_redshift_credentials_v2 = sgqlc.types.Field(
        "UpdateRedshiftCredentialsV2Mutation",
        graphql_name="updateRedshiftCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(RedshiftUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """Update credentials for an existing Redshift connection.  Note:
    This mutation only uploads credentials and returns a temporary
    key. To complete the update:  Call testUpdatedCredentialsV2 with
    the returned key as tempCredentialsKey and the same connectionId
    to validate the credentials  Call updateCredentialsV2 with the
    same tempCredentialsKey and connectionId to persist the changes.
    See full instructions here -
    https://docs.getmontecarlo.com/docs/updating-integrations#/.

    Arguments:

    * `changes` (`RedshiftUpdateConnectionDetails!`): Updated Redshift
      connection parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    update_databricks_metastore_credentials_v2 = sgqlc.types.Field(
        "UpdateDatabricksMetastoreCredentialsV2Mutation",
        graphql_name="updateDatabricksMetastoreCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(SparkDatabricksUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """Update credentials for an existing Databricks Metastore
    connection.  Note: This mutation only uploads credentials and
    returns a temporary key. To complete the update:  Call
    testUpdatedCredentialsV2 with the returned key as
    tempCredentialsKey and the same connectionId to validate the
    credentials  Call updateCredentialsV2 with the same
    tempCredentialsKey and connectionId to persist the changes.  See
    full instructions here -
    https://docs.getmontecarlo.com/docs/updating-integrations#/.

    Arguments:

    * `changes` (`SparkDatabricksUpdateConnectionDetails!`): Updated
      Databricks Metastore connection parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    update_spark_credentials_v2 = sgqlc.types.Field(
        "UpdateSparkCredentialsV2Mutation",
        graphql_name="updateSparkCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(SparkDatabricksUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """Update credentials for an existing Spark connection.  Note: This
    mutation only uploads credentials and returns a temporary key. To
    complete the update:  Call testUpdatedCredentialsV2 with the
    returned key as tempCredentialsKey and the same connectionId to
    validate the credentials  Call updateCredentialsV2 with the same
    tempCredentialsKey and connectionId to persist the changes.  See
    full instructions here -
    https://docs.getmontecarlo.com/docs/updating-integrations#/.

    Arguments:

    * `changes` (`SparkDatabricksUpdateConnectionDetails!`): Updated
      Spark connection parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    update_databricks_metastore_sql_warehouse_credentials_v2 = sgqlc.types.Field(
        "UpdateDatabricksMetastoreSQLWarehouseCredentialsV2Mutation",
        graphql_name="updateDatabricksMetastoreSqlWarehouseCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(DatabricksSqlWarehouseUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """Update credentials for an existing Databricks Metastore SQL
    Warehouse connection.  Note: This mutation only uploads
    credentials and returns a temporary key. To complete the update:
    Call testUpdatedCredentialsV2 with the returned key as
    tempCredentialsKey and the same connectionId to validate the
    credentials  Call updateCredentialsV2 with the same
    tempCredentialsKey and connectionId to persist the changes.  See
    full instructions here -
    https://docs.getmontecarlo.com/docs/updating-integrations#/.

    Arguments:

    * `changes` (`DatabricksSqlWarehouseUpdateConnectionDetails!`):
      Updated Databricks Metastore SQL Warehouse connection
      parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    update_databricks_sql_warehouse_credentials_v2 = sgqlc.types.Field(
        "UpdateDatabricksSQLWarehouseCredentialsV2Mutation",
        graphql_name="updateDatabricksSqlWarehouseCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(DatabricksSqlWarehouseUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """Update credentials for an existing Databricks SQL Warehouse
    connection.  Note: This mutation only uploads credentials and
    returns a temporary key. To complete the update:  Call
    testUpdatedCredentialsV2 with the returned key as
    tempCredentialsKey and the same connectionId to validate the
    credentials  Call updateCredentialsV2 with the same
    tempCredentialsKey and connectionId to persist the changes.  See
    full instructions here -
    https://docs.getmontecarlo.com/docs/updating-integrations#/.

    Arguments:

    * `changes` (`DatabricksSqlWarehouseUpdateConnectionDetails!`):
      Updated Databricks SQL Warehouse connection parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    test_databricks_metastore_updated_credentials_v2 = sgqlc.types.Field(
        "TestDatabricksMetastoreUpdatedCredentialsV2Mutation",
        graphql_name="testDatabricksMetastoreUpdatedCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
                (
                    "connection_options",
                    sgqlc.types.Arg(
                        ConnectionTestOptions, graphql_name="connectionOptions", default=None
                    ),
                ),
                (
                    "temp_credentials_key",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String),
                        graphql_name="tempCredentialsKey",
                        default=None,
                    ),
                ),
                (
                    "validation_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="validationName", default=None
                    ),
                ),
            )
        ),
    )
    """Test the updated credentials of an existing Databricks Metastore
    connection.

    Arguments:

    * `connection_id` (`UUID!`): The UUID of the existing Databricks
      Metastore connection to test.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `temp_credentials_key` (`String!`): The temporary credentials
      key to use to retrieve new credentials.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    """

    update_azure_data_factory_credentials_v2 = sgqlc.types.Field(
        "UpdateAzureDataFactoryCredentialsV2Mutation",
        graphql_name="updateAzureDataFactoryCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(AzureDataFactoryUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Updates Azure Data Factory credentials for an
    existing connection

    Arguments:

    * `changes` (`AzureDataFactoryUpdateConnectionDetails!`): Updated
      Azure Data Factory connection parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    update_pinecone_credentials_v2 = sgqlc.types.Field(
        "UpdatePineconeCredentialsV2Mutation",
        graphql_name="updatePineconeCredentialsV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "changes",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(PineconeUpdateConnectionDetails),
                        graphql_name="changes",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """Update credentials for an existing Pinecone connection.  Note:
    This mutation only uploads credentials and returns a temporary
    key. To complete the update:  Call testUpdatedCredentialsV2 with
    the returned key as tempCredentialsKey and the same connectionId
    to validate the credentials  Call updateCredentialsV2 with the
    same tempCredentialsKey and connectionId to persist the changes.
    See full instructions here -
    https://docs.getmontecarlo.com/docs/updating-integrations#/.

    Arguments:

    * `changes` (`PineconeUpdateConnectionDetails!`): Updated Pinecone
      connection parameters.
    * `connection_id` (`UUID!`): ID for connection to update.
    """

    create_or_update_data_explorer_dashboard = sgqlc.types.Field(
        CreateOrUpdateDataExplorerDashboardMutation,
        graphql_name="createOrUpdateDataExplorerDashboard",
        args=sgqlc.types.ArgDict(
            (
                (
                    "data_explorer_dashboard",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(DataExplorerDashboardInputType),
                        graphql_name="dataExplorerDashboard",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """Arguments:

    * `data_explorer_dashboard`
      (`DataExplorerDashboardInputType!`)None
    """

    delete_data_explorer_dashboard = sgqlc.types.Field(
        DeleteDataExplorerDashboardMutation,
        graphql_name="deleteDataExplorerDashboard",
        args=sgqlc.types.ArgDict(
            (
                (
                    "uuid",
                    sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name="uuid", default=None),
                ),
            )
        ),
    )
    """Arguments:

    * `uuid` (`UUID!`): UUID of dashboard to be deleted
    """

    create_or_update_data_explorer_comparison_dashboard = sgqlc.types.Field(
        CreateOrUpdateDataExplorerComparisonDashboardMutation,
        graphql_name="createOrUpdateDataExplorerComparisonDashboard",
        args=sgqlc.types.ArgDict(
            (
                (
                    "data_explorer_comparison_dashboard",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(DataExplorerComparisonDashboardInputType),
                        graphql_name="dataExplorerComparisonDashboard",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """Arguments:

    * `data_explorer_comparison_dashboard`
      (`DataExplorerComparisonDashboardInputType!`)None
    """

    delete_data_explorer_comparison_dashboard = sgqlc.types.Field(
        DeleteDataExplorerComparisonDashboardMutation,
        graphql_name="deleteDataExplorerComparisonDashboard",
        args=sgqlc.types.ArgDict(
            (
                (
                    "uuid",
                    sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name="uuid", default=None),
                ),
            )
        ),
    )
    """Arguments:

    * `uuid` (`UUID!`): UUID of comparison dashboard to be deleted
    """

    create_webex_integration = sgqlc.types.Field(
        CreateWebexIntegration,
        graphql_name="createWebexIntegration",
        args=sgqlc.types.ArgDict(
            (
                ("bot_token", sgqlc.types.Arg(String, graphql_name="botToken", default=None)),
                (
                    "integration_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="integrationName", default=None
                    ),
                ),
            )
        ),
    )
    """Create a Webex integration

    Arguments:

    * `bot_token` (`String`): The bot token for authentication; if not
      provided, the previous value will be used
    * `integration_name` (`String!`): A short name to identify the
      integration
    """

    update_webex_integration = sgqlc.types.Field(
        "UpdateWebexIntegration",
        graphql_name="updateWebexIntegration",
        args=sgqlc.types.ArgDict(
            (
                ("bot_token", sgqlc.types.Arg(String, graphql_name="botToken", default=None)),
                (
                    "integration_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="integrationId", default=None
                    ),
                ),
                (
                    "integration_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="integrationName", default=None
                    ),
                ),
            )
        ),
    )
    """Update a Webex integration

    Arguments:

    * `bot_token` (`String`): The bot token for authentication; if not
      provided, the previous value will be used
    * `integration_id` (`UUID!`): The integration ID
    * `integration_name` (`String!`): A short name to identify the
      integration
    """

    delete_webex_integration = sgqlc.types.Field(
        DeleteWebexIntegration,
        graphql_name="deleteWebexIntegration",
        args=sgqlc.types.ArgDict(
            (
                (
                    "integration_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="integrationId", default=None
                    ),
                ),
            )
        ),
    )
    """Delete a Webex integration

    Arguments:

    * `integration_id` (`UUID!`): The integration ID
    """

    update_monitored_table_rule_list = sgqlc.types.Field(
        sgqlc.types.list_of(MonitoredTableRuleObject),
        graphql_name="updateMonitoredTableRuleList",
        args=sgqlc.types.ArgDict(
            (
                (
                    "dataset",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="dataset", default=None
                    ),
                ),
                (
                    "dw_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name="dwId", default=None),
                ),
                (
                    "project",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="project", default=None
                    ),
                ),
                (
                    "rules",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(MonitoredTableRuleInput)),
                        graphql_name="rules",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """Deprecated - use async version

    Arguments:

    * `dataset` (`String!`): Rules apply to tables in this
      dataset/schema
    * `dw_id` (`UUID!`): Rules apply to tables in this warehouse
    * `project` (`String!`): Rules apply to tables in this
      project/database
    * `rules` (`[MonitoredTableRuleInput]!`): The complete list of
      rules for deciding which tables are monitored
    """

    update_monitored_table_rule_list_async = sgqlc.types.Field(
        MonitoredTableRuleListUpdateOutput,
        graphql_name="updateMonitoredTableRuleListAsync",
        args=sgqlc.types.ArgDict(
            (
                ("dataset", sgqlc.types.Arg(String, graphql_name="dataset", default=None)),
                (
                    "dw_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name="dwId", default=None),
                ),
                ("project", sgqlc.types.Arg(String, graphql_name="project", default=None)),
                (
                    "rules",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(sgqlc.types.list_of(MonitoredTableRuleInput)),
                        graphql_name="rules",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """Updates the list of rules for deciding and applies them
    asynchronously.

    Arguments:

    * `dataset` (`String`): Rules apply to tables in this
      dataset/schema
    * `dw_id` (`UUID!`): Rules apply to tables in this warehouse
    * `project` (`String`): Rules apply to tables in this
      project/database
    * `rules` (`[MonitoredTableRuleInput]!`): The complete list of
      rules for deciding which tables are monitored
    """

    add_monitored_table_rule_async = sgqlc.types.Field(
        MonitoredTableRuleListUpdateOutput,
        graphql_name="addMonitoredTableRuleAsync",
        args=sgqlc.types.ArgDict(
            (
                ("dataset", sgqlc.types.Arg(String, graphql_name="dataset", default=None)),
                (
                    "dw_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name="dwId", default=None),
                ),
                (
                    "priority_mcon",
                    sgqlc.types.Arg(String, graphql_name="priorityMcon", default=None),
                ),
                ("project", sgqlc.types.Arg(String, graphql_name="project", default=None)),
                (
                    "rule",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(MonitoredTableRuleInput),
                        graphql_name="rule",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """(general availability) Adds a new monitoring rule in the requested
    scope.

    Arguments:

    * `dataset` (`String`): Rules apply to tables in this
      dataset/schema
    * `dw_id` (`UUID!`): Rules apply to tables in this warehouse
    * `priority_mcon` (`String`): Apply rules so that this MCON is
      enabled first
    * `project` (`String`): Rules apply to tables in this
      project/database
    * `rule` (`MonitoredTableRuleInput!`): New monitoring rule
    """

    toggle_performance_dashboard_for_domain_restricted_users = sgqlc.types.Field(
        "TogglePerformanceDashboardForDomainRestrictedUsers",
        graphql_name="togglePerformanceDashboardForDomainRestrictedUsers",
        args=sgqlc.types.ArgDict(
            (
                (
                    "enabled",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(Boolean), graphql_name="enabled", default=None
                    ),
                ),
            )
        ),
    )
    """Sets the toggle for enabling performance dashboard for domain
    restricted users

    Arguments:

    * `enabled` (`Boolean!`): Enable performance dashboard for domain
      restricted user
    """

    create_or_update_agent = sgqlc.types.Field(
        CreateOrUpdateAgent,
        graphql_name="createOrUpdateAgent",
        args=sgqlc.types.ArgDict(
            (
                (
                    "additional_info",
                    sgqlc.types.Arg(JSONString, graphql_name="additionalInfo", default=None),
                ),
                ("agent_id", sgqlc.types.Arg(UUID, graphql_name="agentId", default=None)),
                (
                    "agent_type",
                    sgqlc.types.Arg(AgentTypeEnum, graphql_name="agentType", default=None),
                ),
                ("auth_type", sgqlc.types.Arg(AuthTypeEnum, graphql_name="authType", default=None)),
                (
                    "credentials",
                    sgqlc.types.Arg(JSONString, graphql_name="credentials", default=None),
                ),
                (
                    "data_collector_id",
                    sgqlc.types.Arg(UUID, graphql_name="dataCollectorId", default=None),
                ),
                ("dry_run", sgqlc.types.Arg(Boolean, graphql_name="dryRun", default=False)),
                ("endpoint", sgqlc.types.Arg(String, graphql_name="endpoint", default=None)),
                (
                    "friendly_name",
                    sgqlc.types.Arg(String, graphql_name="friendlyName", default=None),
                ),
                ("image_build", sgqlc.types.Arg(String, graphql_name="imageBuild", default=None)),
                (
                    "image_version",
                    sgqlc.types.Arg(String, graphql_name="imageVersion", default=None),
                ),
                (
                    "platform",
                    sgqlc.types.Arg(PlatformTypeEnum, graphql_name="platform", default=None),
                ),
                (
                    "storage_type",
                    sgqlc.types.Arg(StorageTypeEnum, graphql_name="storageType", default=None),
                ),
                ("upgradeable", sgqlc.types.Arg(Boolean, graphql_name="upgradeable", default=None)),
                ("wrapper_type", sgqlc.types.Arg(String, graphql_name="wrapperType", default=None)),
                (
                    "wrapper_version",
                    sgqlc.types.Arg(String, graphql_name="wrapperVersion", default=None),
                ),
            )
        ),
    )
    """Create or Update a Monte Carlo Agent

    Arguments:

    * `additional_info` (`JSONString`): Additional information for the
      agent, for now only `account_name` is supported and used by
      Snowflake agents for the endpoint value.
    * `agent_id` (`UUID`): UUID of Agent to update.
    * `agent_type` (`AgentTypeEnum`): The type of Agent being
      deployed.
    * `auth_type` (`AuthTypeEnum`): The type of authorization
      provided.
    * `credentials` (`JSONString`): JSON of credentials for Agent.
    * `data_collector_id` (`UUID`): The UUID of the Data Collector to
      associate the agent with.
    * `dry_run` (`Boolean`): Dry run? (default: `false`)
    * `endpoint` (`String`): Bucket name, IP address or URL of the
      agent.
    * `friendly_name` (`String`): Friendly name for the agent, for now
      used only for connections automatically created when registering
      Snowflake agents.
    * `image_build` (`String`): Build number of agent image. Ignored
      if agent type is DATA_STORE_AGENT.
    * `image_version` (`String`): The image version of the Agent. Null
      if agent type is data_store.
    * `platform` (`PlatformTypeEnum`): The cloud platform the agent is
      deployed on.
    * `storage_type` (`StorageTypeEnum`): The storage type of the
      Agent.
    * `upgradeable` (`Boolean`): Boolean if the agent is remote
      upgradeable.
    * `wrapper_type` (`String`): The wrapper type of the Agent.
    * `wrapper_version` (`String`): The wrapper version of the Agent.
    """

    delete_agent = sgqlc.types.Field(
        DeleteAgent,
        graphql_name="deleteAgent",
        args=sgqlc.types.ArgDict(
            (
                (
                    "agent_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="agentId", default=None
                    ),
                ),
            )
        ),
    )
    """Delete a Monte Carlo Agent

    Arguments:

    * `agent_id` (`UUID!`): UUID of Agent to delete
    """

    upgrade_agent = sgqlc.types.Field(
        "UpgradeAgent",
        graphql_name="upgradeAgent",
        args=sgqlc.types.ArgDict(
            (
                (
                    "agent_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="agentId", default=None
                    ),
                ),
                ("image", sgqlc.types.Arg(String, graphql_name="image", default=None)),
                (
                    "parameters",
                    sgqlc.types.Arg(GenericScalar, graphql_name="parameters", default=None),
                ),
                ("timeout", sgqlc.types.Arg(Int, graphql_name="timeout", default=None)),
                ("trace_id", sgqlc.types.Arg(String, graphql_name="traceId", default=None)),
            )
        ),
    )
    """Upgrades a Monte Carlo Agent to a given version

    Arguments:

    * `agent_id` (`UUID!`): The UUID of the Agent to upgrade.
    * `image` (`String`): Image to upgrade the agent to (upgrades to
      the latest image by default).
    * `parameters` (`GenericScalar`): New values for template
      parameters, for example: MemorySize=1024
    * `timeout` (`Int`): Time to wait for the upgrade to complete
    * `trace_id` (`String`): Trace ID for the request.
    """

    update_agent_parameters = sgqlc.types.Field(
        "UpdateAgentParameters",
        graphql_name="updateAgentParameters",
        args=sgqlc.types.ArgDict(
            (
                (
                    "agent_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="agentId", default=None
                    ),
                ),
                (
                    "parameters",
                    sgqlc.types.Arg(GenericScalar, graphql_name="parameters", default=None),
                ),
                ("trace_id", sgqlc.types.Arg(String, graphql_name="traceId", default=None)),
            )
        ),
    )
    """Updates agent parameters like MemorySize or ConcurrentExecutions.

    Arguments:

    * `agent_id` (`UUID!`): The UUID of the Agent to update
      parameters.
    * `parameters` (`GenericScalar`): New values for template
      parameters, for example: MemorySize=1024
    * `trace_id` (`String`): Trace ID for the request.
    """

    restart_agent = sgqlc.types.Field(
        "RestartAgent",
        graphql_name="restartAgent",
        args=sgqlc.types.ArgDict(
            (
                (
                    "agent_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="agentId", default=None
                    ),
                ),
                ("trace_id", sgqlc.types.Arg(String, graphql_name="traceId", default=None)),
            )
        ),
    )
    """Restarts an agent, supported only for Azure agents.

    Arguments:

    * `agent_id` (`UUID!`): The UUID of the Agent to restart,
      supported only for Azure agents.
    * `trace_id` (`String`): Trace ID for the request.
    """

    cleanup_azure_agent_tasks = sgqlc.types.Field(
        AzureAgentCleanupTasks,
        graphql_name="cleanupAzureAgentTasks",
        args=sgqlc.types.ArgDict(
            (
                (
                    "agent_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="agentId", default=None
                    ),
                ),
                (
                    "created_time_from",
                    sgqlc.types.Arg(DateTime, graphql_name="createdTimeFrom", default=None),
                ),
                (
                    "created_time_to",
                    sgqlc.types.Arg(DateTime, graphql_name="createdTimeTo", default=None),
                ),
                (
                    "include_pending",
                    sgqlc.types.Arg(Boolean, graphql_name="includePending", default=None),
                ),
            )
        ),
    )
    """Cleanup Durable Functions tasks for an Azure Agent

    Arguments:

    * `agent_id` (`UUID!`): The UUID of the Azure Agent to cleanup
      Durable Functions tasks.
    * `created_time_from` (`DateTime`): Optional start time, defaults
      to 10 years ago
    * `created_time_to` (`DateTime`): Optional end time, defaults to
      10 minutes ago
    * `include_pending` (`Boolean`): Include pending tasks in the
      cleanup, defaults to false.
    """

    migrate_connection_to_snowflake_agent = sgqlc.types.Field(
        MigrateConnectionToSnowflakeAgent,
        graphql_name="migrateConnectionToSnowflakeAgent",
        args=sgqlc.types.ArgDict(
            (
                (
                    "agent_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="agentId", default=None
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Migrate an existing connection to a Snowflake Agent

    Arguments:

    * `agent_id` (`UUID!`): UUID of Agent to migrate to.
    * `connection_id` (`UUID!`): UUID of Connection to migrate.
    """

    migrate_connection_from_snowflake_agent = sgqlc.types.Field(
        MigrateConnectionFromSnowflakeAgent,
        graphql_name="migrateConnectionFromSnowflakeAgent",
        args=sgqlc.types.ArgDict(
            (
                (
                    "connection_details",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(SnowflakeConnectionDetails),
                        graphql_name="connectionDetails",
                        default=None,
                    ),
                ),
                (
                    "connection_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="connectionId", default=None
                    ),
                ),
                (
                    "service_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="serviceUuid", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Migrates a Snowflake Agent connection to another
    platform service

    Arguments:

    * `connection_details` (`SnowflakeConnectionDetails!`): Connection
      parameters.
    * `connection_id` (`UUID!`): UUID of Connection to migrate.
    * `service_uuid` (`UUID!`): UUID of DC to migrate to.
    """

    create_tableau_asset_warning = sgqlc.types.Field(
        CreateTableauAssetWarning,
        graphql_name="createTableauAssetWarning",
        args=sgqlc.types.ArgDict(
            (
                ("alert_id", sgqlc.types.Arg(UUID, graphql_name="alertId", default=None)),
                (
                    "bi_container_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="biContainerId", default=None
                    ),
                ),
                ("incident_id", sgqlc.types.Arg(UUID, graphql_name="incidentId", default=None)),
                (
                    "message",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="message", default=None
                    ),
                ),
                (
                    "tableau_asset_type",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="tableauAssetType", default=None
                    ),
                ),
                (
                    "tableau_luid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="tableauLuid", default=None
                    ),
                ),
            )
        ),
    )
    """Create tableau asset warning

    Arguments:

    * `alert_id` (`UUID`): UUID of the alert for which this warning is
      being created.
    * `bi_container_id` (`UUID!`): UUID of the Tableau container for
      which this warning is being created.
    * `incident_id` (`UUID`): UUID of the incident for which this
      warning is being created. Deprecated, use alertId instead
    * `message` (`String!`): The message of the warning
    * `tableau_asset_type` (`String!`): The type of the Tableau asset.
      This is a string defined by Tableau. Eg: datasource
    * `tableau_luid` (`String!`): The Tableau LUID of the tableau
      asset for which the warning is being created.
    """

    update_tableau_asset_warning = sgqlc.types.Field(
        "UpdateTableauAssetWarning",
        graphql_name="updateTableauAssetWarning",
        args=sgqlc.types.ArgDict(
            (
                (
                    "bi_container_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="biContainerId", default=None
                    ),
                ),
                (
                    "message",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="message", default=None
                    ),
                ),
                (
                    "tableau_warning_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="tableauWarningId", default=None
                    ),
                ),
            )
        ),
    )
    """Update tableau asset warning

    Arguments:

    * `bi_container_id` (`UUID!`): UUID of the Tableau container for
      which this warning is being created.
    * `message` (`String!`): The new message of the warning
    * `tableau_warning_id` (`String!`): The Tableau Data Quality
      Warning ID.
    """

    generate_dc_upgrade_template = sgqlc.types.Field(
        GenerateDcUpgradeTemplate,
        graphql_name="generateDcUpgradeTemplate",
        args=sgqlc.types.ArgDict(
            (
                (
                    "dc_id",
                    sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name="dcId", default=None),
                ),
            )
        ),
    )
    """Generates a template for DC upgrade and a URL to execute the
    template in the cloud provider.

    Arguments:

    * `dc_id` (`UUID!`): The data collector UUID
    """

    delete_data_product = sgqlc.types.Field(
        DeleteDataProduct,
        graphql_name="deleteDataProduct",
        args=sgqlc.types.ArgDict(
            (
                (
                    "uuid",
                    sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name="uuid", default=None),
                ),
            )
        ),
    )
    """Delete a data product

    Arguments:

    * `uuid` (`UUID!`): UUID of data product to delete
    """

    delete_data_product_v2 = sgqlc.types.Field(
        DeleteDataProductV2,
        graphql_name="deleteDataProductV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "uuid",
                    sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name="uuid", default=None),
                ),
            )
        ),
    )
    """Delete a data product

    Arguments:

    * `uuid` (`UUID!`): UUID of data product to delete
    """

    create_or_update_data_product = sgqlc.types.Field(
        CreateOrUpdateDataProduct,
        graphql_name="createOrUpdateDataProduct",
        args=sgqlc.types.ArgDict(
            (
                ("description", sgqlc.types.Arg(String, graphql_name="description", default=None)),
                ("domain_id", sgqlc.types.Arg(UUID, graphql_name="domainId", default=None)),
                (
                    "mcons",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(String), graphql_name="mcons", default=None
                    ),
                ),
                ("name", sgqlc.types.Arg(String, graphql_name="name", default=None)),
                ("uuid", sgqlc.types.Arg(UUID, graphql_name="uuid", default=None)),
            )
        ),
    )
    """Create or update a data product

    Arguments:

    * `description` (`String`): Description of the data product
    * `domain_id` (`UUID`): UUID of domain to create this data product
    * `mcons` (`[String]`): MCON of assets to be part of this data
      product
    * `name` (`String`): Data product name
    * `uuid` (`UUID`): UUID of data product to update
    """

    create_or_update_data_product_v2 = sgqlc.types.Field(
        CreateOrUpdateDataProductV2,
        graphql_name="createOrUpdateDataProductV2",
        args=sgqlc.types.ArgDict(
            (
                (
                    "audience_uuids",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(UUID), graphql_name="audienceUuids", default=None
                    ),
                ),
                ("description", sgqlc.types.Arg(String, graphql_name="description", default=None)),
                (
                    "enable_monitoring_upon_creation",
                    sgqlc.types.Arg(
                        Boolean, graphql_name="enableMonitoringUponCreation", default=None
                    ),
                ),
                (
                    "mcons",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(String), graphql_name="mcons", default=None
                    ),
                ),
                ("name", sgqlc.types.Arg(String, graphql_name="name", default=None)),
                ("uuid", sgqlc.types.Arg(UUID, graphql_name="uuid", default=None)),
            )
        ),
    )
    """Create or update a data product

    Arguments:

    * `audience_uuids` (`[UUID]`): UUIDs of audiences for this data
      product
    * `description` (`String`): Description of the data product
    * `enable_monitoring_upon_creation` (`Boolean`): Whether to also
      enable monitoring all tables upon data product creation
    * `mcons` (`[String]`): MCON of assets to be part of this data
      product
    * `name` (`String`): Data product name
    * `uuid` (`UUID`): UUID of data product to update
    """

    update_data_product_sharing = sgqlc.types.Field(
        "UpdateDataProductSharing",
        graphql_name="updateDataProductSharing",
        args=sgqlc.types.ArgDict(
            (
                (
                    "data_product_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="dataProductUuid", default=None
                    ),
                ),
                (
                    "shared_with_all_in_same_account",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(Boolean),
                        graphql_name="sharedWithAllInSameAccount",
                        default=False,
                    ),
                ),
            )
        ),
    )
    """Create or update sharing definition on a data product

    Arguments:

    * `data_product_uuid` (`UUID!`): UUID of data product to share
    * `shared_with_all_in_same_account` (`Boolean!`): Whether this
      data product is shared with all users in the same account.
      (default: `false`)
    """

    toggle_data_product_monitoring = sgqlc.types.Field(
        "ToggleDataProductMonitoring",
        graphql_name="toggleDataProductMonitoring",
        args=sgqlc.types.ArgDict(
            (
                (
                    "enabled",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(Boolean), graphql_name="enabled", default=None
                    ),
                ),
                (
                    "uuid",
                    sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name="uuid", default=None),
                ),
            )
        ),
    )
    """Enables/disables automatic monitoring on a data product

    Arguments:

    * `enabled` (`Boolean!`): True of false to enable or disable
      automatic monitoring on all upstream tables
    * `uuid` (`UUID!`): UUID of data product to monitor
    """

    link_ms_teams_installation = sgqlc.types.Field(
        LinkMsTeamsInstallation,
        graphql_name="linkMsTeamsInstallation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "code",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="code", default=None
                    ),
                ),
                (
                    "installation_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="installationId", default=None
                    ),
                ),
            )
        ),
    )
    """Arguments:

    * `code` (`String!`): Security code passed from MS Teams
    * `installation_id` (`String!`): MS Teams App installation id
    """

    link_github_app_installation = sgqlc.types.Field(
        LinkGithubAppInstallation,
        graphql_name="linkGithubAppInstallation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "code",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="code", default=None
                    ),
                ),
                (
                    "installation_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="installationId", default=None
                    ),
                ),
            )
        ),
    )
    """Called from the FE as part of the post-installation callback. The
    "code" parameter is used to validate that the request is an
    authentic Github callback and authenticates the user on the Github
    side.

    Arguments:

    * `code` (`String!`): Security code passed from Github
    * `installation_id` (`String!`): Github App installation id
    """

    register_github_app_installation_request = sgqlc.types.Field(
        "RegisterGithubAppInstallationRequest",
        graphql_name="registerGithubAppInstallationRequest",
        args=sgqlc.types.ArgDict(
            (
                (
                    "code",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="code", default=None
                    ),
                ),
            )
        ),
    )
    """Called from the FE as part of the post-installation callback in
    case the user requested approval from her Github admin, instead of
    approving directly. The "code" parameter is used to identify the
    Github user of the requester.

    Arguments:

    * `code` (`String!`): Security code passed from Github
    """

    update_github_installation = sgqlc.types.Field(
        "UpdateGithubAppInstallation",
        graphql_name="updateGithubInstallation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "installation_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="installationUuid", default=None
                    ),
                ),
                (
                    "show_impact_analysis",
                    sgqlc.types.Arg(Boolean, graphql_name="showImpactAnalysis", default=None),
                ),
            )
        ),
    )
    """Updates settings for the Github app installation

    Arguments:

    * `installation_uuid` (`UUID!`): Internal UUID of the installation
      to delete
    * `show_impact_analysis` (`Boolean`): If true, show impacted
      models and reports as a PR comment
    """

    delete_github_installation = sgqlc.types.Field(
        DeleteGithubInstallation,
        graphql_name="deleteGithubInstallation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "installation_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="installationUuid", default=None
                    ),
                ),
            )
        ),
    )
    """Arguments:

    * `installation_uuid` (`UUID!`): Internal UUID of the installation
      to delete
    """

    register_gitlab_app = sgqlc.types.Field(
        "RegisterGitlabApp",
        graphql_name="registerGitlabApp",
        args=sgqlc.types.ArgDict(
            (
                (
                    "app_id",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="appId", default=None
                    ),
                ),
                (
                    "app_secret",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="appSecret", default=None
                    ),
                ),
                ("host", sgqlc.types.Arg(String, graphql_name="host", default=None)),
            )
        ),
    )
    """(experimental) Registers a Gitlab app

    Arguments:

    * `app_id` (`String!`): Application ID generated by GitLab
    * `app_secret` (`String!`): Application secret generated by GitLab
    * `host` (`String`): Custom GitLab host
    """

    link_gitlab_app = sgqlc.types.Field(
        LinkGitlabApp,
        graphql_name="linkGitlabApp",
        args=sgqlc.types.ArgDict(
            (
                (
                    "code",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="code", default=None
                    ),
                ),
                (
                    "state",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="state", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Links a Gitlab app

    Arguments:

    * `code` (`String!`): Security code passed from Gitlab
    * `state` (`String!`): Client account_uuid
    """

    delete_gitlab_installation = sgqlc.types.Field(
        DeleteGitlabInstallation,
        graphql_name="deleteGitlabInstallation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "installation_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="installationUuid", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Deletes a Gitlab app

    Arguments:

    * `installation_uuid` (`UUID!`): Internal UUID of the GitLab
      installation to delete
    """

    select_gitlab_projects = sgqlc.types.Field(
        "SelectGitlabProjects",
        graphql_name="selectGitlabProjects",
        args=sgqlc.types.ArgDict(
            (
                (
                    "installation_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="installationUuid", default=None
                    ),
                ),
                (
                    "repositories",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(GitlabNamespaceSelection),
                        graphql_name="repositories",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """(experimental) Select GitLab projects for monitoring

    Arguments:

    * `installation_uuid` (`UUID!`): Internal UUID of the GitLab
      installation
    * `repositories` (`[GitlabNamespaceSelection]`)None
    """

    update_gitlab_installation = sgqlc.types.Field(
        "UpdateGitlabInstallation",
        graphql_name="updateGitlabInstallation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "installation_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="installationUuid", default=None
                    ),
                ),
                (
                    "show_impact_analysis",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(Boolean),
                        graphql_name="showImpactAnalysis",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """(experimental) Updates a Gitlab app

    Arguments:

    * `installation_uuid` (`UUID!`): Internal UUID of the installation
      to update
    * `show_impact_analysis` (`Boolean!`): If true, show impacted
      models and reports as a Merge Request comment
    """

    create_azure_devops_installation = sgqlc.types.Field(
        CreateAzureDevopsInstallation,
        graphql_name="createAzureDevopsInstallation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "basic_auth_credentials",
                    sgqlc.types.Arg(
                        AzureDevopsBasicAuthCredentialsInput,
                        graphql_name="basicAuthCredentials",
                        default=None,
                    ),
                ),
                (
                    "oauth_credentials",
                    sgqlc.types.Arg(
                        AzureDevopsOauthCredentialsInput,
                        graphql_name="oauthCredentials",
                        default=None,
                    ),
                ),
                (
                    "organization_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="organizationName", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Creates an Azure DevOps installation

    Arguments:

    * `basic_auth_credentials`
      (`AzureDevopsBasicAuthCredentialsInput`)None
    * `oauth_credentials` (`AzureDevopsOauthCredentialsInput`)None
    * `organization_name` (`String!`): Azure DevOps organization name
    """

    update_azure_devops_installation = sgqlc.types.Field(
        "UpdateAzureDevopsInstallation",
        graphql_name="updateAzureDevopsInstallation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "basic_auth_credentials",
                    sgqlc.types.Arg(
                        AzureDevopsBasicAuthCredentialsInput,
                        graphql_name="basicAuthCredentials",
                        default=None,
                    ),
                ),
                (
                    "installation_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="installationUuid", default=None
                    ),
                ),
                (
                    "oauth_credentials",
                    sgqlc.types.Arg(
                        AzureDevopsOauthCredentialsInput,
                        graphql_name="oauthCredentials",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """(experimental) Updates an Azure DevOps installation

    Arguments:

    * `basic_auth_credentials`
      (`AzureDevopsBasicAuthCredentialsInput`): Provide either basic
      credentials or OAuth credentials
    * `installation_uuid` (`UUID!`): Internal UUID of the installation
      to update
    * `oauth_credentials` (`AzureDevopsOauthCredentialsInput`):
      Provide either basic credentials or OAuth credentials
    """

    link_azure_devops_installation = sgqlc.types.Field(
        LinkAzureDevopsInstallation,
        graphql_name="linkAzureDevopsInstallation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "code",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="code", default=None
                    ),
                ),
                (
                    "state",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="state", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Completes the Azure DevOps OAuth authorization flow

    Arguments:

    * `code` (`String!`): OAuth code from callback URL
    * `state` (`String!`): OAuth state from callback URL
    """

    delete_azure_devops_installation = sgqlc.types.Field(
        DeleteAzureDevopsInstallation,
        graphql_name="deleteAzureDevopsInstallation",
        args=sgqlc.types.ArgDict(
            (
                (
                    "installation_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="installationUuid", default=None
                    ),
                ),
            )
        ),
    )
    """(experimental) Deletes an Azure DevOps installation

    Arguments:

    * `installation_uuid` (`UUID!`): Internal UUID of the Azure DevOps
      installation to delete
    """

    set_azure_devops_source_selections = sgqlc.types.Field(
        "SetAzureDevopsSourceSelections",
        graphql_name="setAzureDevopsSourceSelections",
        args=sgqlc.types.ArgDict(
            (
                (
                    "installation_uuid",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UUID), graphql_name="installationUuid", default=None
                    ),
                ),
                (
                    "selections",
                    sgqlc.types.Arg(
                        sgqlc.types.list_of(AzureDevopsSourceSelectionInput),
                        graphql_name="selections",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """(experimental) Set which Azure Devops projects/repositories are
    selected for monitoring

    Arguments:

    * `installation_uuid` (`UUID!`): Internal UUID of the Azure DevOps
      installation
    * `selections` (`[AzureDevopsSourceSelectionInput]`)None
    """

    update_data_share = sgqlc.types.Field(
        "UpdateDataShare",
        graphql_name="updateDataShare",
        args=sgqlc.types.ArgDict(
            (
                (
                    "input",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(UpdateDataShareInput),
                        graphql_name="input",
                        default=None,
                    ),
                ),
            )
        ),
    )
    """(general availability) Update data sharing configuration for an
    account

    Arguments:

    * `input` (`UpdateDataShareInput!`): Data share configuration
    """

    test_confluent_kafka_credentials = sgqlc.types.Field(
        "TestConfluentKafkaCredentials",
        graphql_name="testConfluentKafkaCredentials",
        args=sgqlc.types.ArgDict(
            (
                (
                    "connection_details",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(ConfluentKafkaCredentialsInput),
                        graphql_name="connectionDetails",
                        default=None,
                    ),
                ),
                (
                    "connection_options",
                    sgqlc.types.Arg(
                        ConnectionTestOptions, graphql_name="connectionOptions", default=None
                    ),
                ),
                (
                    "validation_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="validationName", default=None
                    ),
                ),
            )
        ),
    )
    """Test a confluent Kafka cluster credentials.

    Arguments:

    * `connection_details` (`ConfluentKafkaCredentialsInput!`):
      Required Credential Info for accessing Confluent Kafka Cluster
      APIs.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    """

    test_confluent_kafka_connect_credentials = sgqlc.types.Field(
        "TestConfluentKafkaConnectCredentials",
        graphql_name="testConfluentKafkaConnectCredentials",
        args=sgqlc.types.ArgDict(
            (
                (
                    "connection_details",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(ConfluentKafkaConnectCredentialsInput),
                        graphql_name="connectionDetails",
                        default=None,
                    ),
                ),
                (
                    "connection_options",
                    sgqlc.types.Arg(
                        ConnectionTestOptions, graphql_name="connectionOptions", default=None
                    ),
                ),
                (
                    "validation_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="validationName", default=None
                    ),
                ),
            )
        ),
    )
    """Test a confluent Kafka Connect cluster credentials.

    Arguments:

    * `connection_details` (`ConfluentKafkaConnectCredentialsInput!`):
      Required Credential Info for accessing Confluent Cloud Kafka
      Connect APIs.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `validation_name` (`String!`): Validation to run for validating
      the connection.
    """

    test_msk_kafka_credentials = sgqlc.types.Field(
        "TestMskKafkaCredentials",
        graphql_name="testMskKafkaCredentials",
        args=sgqlc.types.ArgDict(
            (
                (
                    "connection_details",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(SelfHostedKafkaCredentialsInput),
                        graphql_name="connectionDetails",
                        default=None,
                    ),
                ),
                (
                    "connection_options",
                    sgqlc.types.Arg(
                        ConnectionTestOptions, graphql_name="connectionOptions", default=None
                    ),
                ),
                (
                    "validation_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="validationName", default=None
                    ),
                ),
            )
        ),
    )
    """Test MSK Kafka cluster credentials.

    Arguments:

    * `connection_details` (`SelfHostedKafkaCredentialsInput!`):
      Required Credential Info for accessing REST Proxy in front of an
      MSK cluster
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    """

    test_msk_kafka_connect_credentials = sgqlc.types.Field(
        "TestMskKafkaConnectCredentials",
        graphql_name="testMskKafkaConnectCredentials",
        args=sgqlc.types.ArgDict(
            (
                (
                    "connection_details",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(MskKafkaConnectCredentialsInput),
                        graphql_name="connectionDetails",
                        default=None,
                    ),
                ),
                (
                    "connection_options",
                    sgqlc.types.Arg(
                        ConnectionTestOptions, graphql_name="connectionOptions", default=None
                    ),
                ),
                (
                    "validation_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="validationName", default=None
                    ),
                ),
            )
        ),
    )
    """Test MSK Kafka Connect credentials.

    Arguments:

    * `connection_details` (`MskKafkaConnectCredentialsInput!`):
      Required Credential Info for accessing MSK Kafka Connect.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `validation_name` (`String!`): Validation to run for validating
      the connection.
    """

    test_self_hosted_kafka_credentials = sgqlc.types.Field(
        "TestSelfHostedKafkaCredentials",
        graphql_name="testSelfHostedKafkaCredentials",
        args=sgqlc.types.ArgDict(
            (
                (
                    "connection_details",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(SelfHostedKafkaCredentialsInput),
                        graphql_name="connectionDetails",
                        default=None,
                    ),
                ),
                (
                    "connection_options",
                    sgqlc.types.Arg(
                        ConnectionTestOptions, graphql_name="connectionOptions", default=None
                    ),
                ),
                (
                    "validation_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="validationName", default=None
                    ),
                ),
            )
        ),
    )
    """Test Self Hosted Kafka cluster credentials.

    Arguments:

    * `connection_details` (`SelfHostedKafkaCredentialsInput!`):
      Required Credential Info for accessing Self Hosted Kafka Cluster
      APIs.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    """

    test_self_hosted_kafka_connect_credentials = sgqlc.types.Field(
        "TestSelfHostedKafkaConnectCredentials",
        graphql_name="testSelfHostedKafkaConnectCredentials",
        args=sgqlc.types.ArgDict(
            (
                (
                    "connection_details",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(SelfHostedKafkaConnectCredentialsInput),
                        graphql_name="connectionDetails",
                        default=None,
                    ),
                ),
                (
                    "connection_options",
                    sgqlc.types.Arg(
                        ConnectionTestOptions, graphql_name="connectionOptions", default=None
                    ),
                ),
                (
                    "validation_name",
                    sgqlc.types.Arg(
                        sgqlc.types.non_null(String), graphql_name="validationName", default=No