import asyncio
import typing
from functools import partial
from typing import Coroutine

from asgiref.sync import async_to_sync


def run_coro_task[T](coro: typing.Callable[[], Coroutine[typing.Any, typing.Any, T]]):
    loop = asyncio.new_event_loop()
    asyncio.set_event_loop(loop)
    asyncio.ensure_future(coro(), loop=loop)
    loop.run_forever()


def from_coroutine[T](
        coro: typing.Callable[[], Coroutine[typing.Any, typing.Any, T]],
        *args,
        **kwargs
) -> T:
    fn = partial(async_to_sync, coro)
    return fn(*args, **kwargs)
