# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aces',
 'aces.askapdata',
 'aces.beamset',
 'aces.cleanlog',
 'aces.clink',
 'aces.cluster_configs',
 'aces.data',
 'aces.data.footprints',
 'aces.data.footprints.askap',
 'aces.data.footprints.askap_commissioning',
 'aces.data.footprints.effelsberg',
 'aces.data.footprints.jodrell',
 'aces.data.footprints.legacy',
 'aces.data.footprints.sandbox',
 'aces.display',
 'aces.fov',
 'aces.holography',
 'aces.misc',
 'aces.mpfit',
 'aces.obsplan',
 'aces.operations',
 'aces.sefd',
 'aces.survey',
 'aces.utilities',
 'aces.utilities.emsim',
 'aces.utilities.emsim.examples',
 'aces.utilities.pointing']

package_data = \
{'': ['*'], 'aces.utilities.emsim': ['doc/*']}

install_requires = \
['Cython>=0.29.32,<0.30.0',
 'astropy>=5.1,<6.0',
 'bokeh>=2.4.3,<3.0.0',
 'clink>=0.33.0,<0.34.0',
 'dask-jobqueue>=0.8.1,<0.9.0',
 'dask-mpi>=2022.4.0,<2023.0.0',
 'dask>=2022.10.0,<2023.0.0',
 'distributed>=2022.10.0,<2023.0.0',
 'ephem>=4.1.3,<5.0.0',
 'graphviz>=0.20.1,<0.21.0',
 'h5py>=3.7.0,<4.0.0',
 'jupyter>=1.0.0,<2.0.0',
 'lxml>=4.9.1,<5.0.0',
 'matplotlib>=3.6.1,<4.0.0',
 'mpi4py>=3.1.3,<4.0.0',
 'multiprocessing-logging>=0.3.3,<0.4.0',
 'nbdime>=3.1.1,<4.0.0',
 'nose>=1.3.7,<2.0.0',
 'numpy>=1.23.4,<2.0.0',
 'prefect-dask>=0.2.1,<0.3.0',
 'prefect>=2.6.4,<3.0.0',
 'pytest>=7.2.1,<8.0.0',
 'python-casacore==3.5.00',
 'pytz>=2022.4,<2023.0',
 'pyyaml>=6.0,<7.0',
 'requests>=2.28.1,<3.0.0',
 'scipy>=1.9.2,<2.0.0',
 'seaborn>=0.12.0,<0.13.0',
 'tqdm>=4.64.1,<5.0.0',
 'zeroc-ice>=3.7.8,<4.0.0']

entry_points = \
{'console_scripts': ['beam_summary = aces.holography.beam_summary:main',
                     'beamset_from_ms = aces.holography.beamset_from_ms:cli',
                     'bptable = aces.holography.bptable:cli',
                     'clean_holography = aces.holography.clean_holography:cli',
                     'divmodel = aces.holography.divmodel:cli',
                     'dump_point = aces.holography.dump_point:cli',
                     'grid_holography = aces.holography.grid_holography:cli',
                     'merge_holography = aces.holography.merge_holography:cli',
                     'plot_summary = aces.holography.plot_summary:cli']}

scripts = \
['scripts/aces_test_mpi_install.py',
 'scripts/array_mean.py',
 'scripts/array_plan.py',
 'scripts/beam_pointing.py',
 'scripts/beam_show.py',
 'scripts/do_beamset_from_ms.py',
 'scripts/do_clean_holography.py',
 'scripts/do_grid_holography.py',
 'scripts/do_merge_holography.py',
 'scripts/edit_beamset.py',
 'scripts/find_bandpass_sbid.py',
 'scripts/fit_contour.py',
 'scripts/fit_plot.py',
 'scripts/fit_surface.py',
 'scripts/flag_info.py',
 'scripts/footprint-plan.py',
 'scripts/fov.py',
 'scripts/get_footprint.py',
 'scripts/illuminate.py',
 'scripts/image_merit.py',
 'scripts/make_field_overlays.py',
 'scripts/mro-riseset.py',
 'scripts/obs-preamble.py',
 'scripts/plot_clean_stats.py',
 'scripts/process_holography.py',
 'scripts/process_sefd.py',
 'scripts/s_optimise.py',
 'scripts/schedblock_query.py',
 'scripts/sefdProcessing.py',
 'scripts/sefd_convert.py',
 'scripts/sefd_merge.py',
 'scripts/sefd_spectrum.py',
 'scripts/sefd_summary.py',
 'scripts/simple_beam_plot.py',
 'scripts/singleport_convert.py',
 'scripts/solar.py',
 'scripts/start_SEFD.py',
 'scripts/start_pipeline.py',
 'scripts/survey-plan.py',
 'scripts/survey_analysis.py',
 'scripts/survey_check.py',
 'scripts/survey_find.py',
 'scripts/survey_flux_scale.py',
 'scripts/survey_post.py',
 'scripts/survey_selavy.py',
 'scripts/survey_selavy_beam.py',
 'scripts/survey_status.py',
 'scripts/survey_swarp.py',
 'scripts/survey_to_casda.py',
 'scripts/survey_validation.py',
 'scripts/tile_plot.py',
 'scripts/tile_sky.py',
 'scripts/tile_trial.py']

setup_kwargs = {
    'name': 'aces-apps',
    'version': '1.5.4',
    'description': 'A collection of utilities developed out of the ACES working group to support the processing of ASKAP data.',
    'long_description': "# ACES Applications (aces-apps)\nASKAP Comissioning and Early Science python packages.\n\n## Provides:\nA collection of tools developed by members of the ACES team to support ACES processing:\n* `aces.askapdata` - Tools for retrieving ASKAP observation metadata including:\n  * scheduling block info\n* `aces.beamset` - beamset classes supporting beam analysis\n* `aces.cleanlog` - Tools for analysing imager deconvolution (clean) logs\n* `aces.data` - Antenna positions.\n* `aces.display` - Tools for displaying data summaries\n* `aces.fov` - Tools for field-of-view modelling\n* `aces.holography` - Tools for processing holography data to measure beams:\n  * Extract a holography beamset from an ASKAP measurement set\n* `aces.misc` - Tools miscellaneous tasks\n* `aces.mpfit` - Perform Levenberg-Marquardt least-squares minimization.\n  * The original version of this software, called LMFIT, was written in FORTRAN as part of the MINPACK-1 package.\n* `aces.obsplan` - Tools for planning ASKAP observations including:\n  * Footprint utilities\n* `aces.sefd` - Tools for estimating ASKAP sensitivity\n  * SEFD from 1934 data\n* `aces.survey` - Tools for processing ASKAP survey data\n\n\n## Installation\n\nBelow are some instructions that attempt to outline the way to install for most situations.\n\nThe primary dependencies and build instructions for `pip` are located in `pyproject.toml`.\n\nCurrently, the installation depency for the `askap` module is defined in `askap-requirements.txt`.\n\n### 'I just want it deployed'\n\nThis is intended if you just want to install the tooling in a modular and simple fashion.\n\nNOTE: You'll need to [install conda](https://conda.io/projects/conda/en/latest/user-guide/install/index.html) on your system first.\n\n\n```bash\n# If using ssh:\ngit clone ssh://git@bitbucket.csiro.au:7999/aces/aces-apps.git\n\n# If using https:\ngit clone https://bitbucket.csiro.au/scm/aces/aces-apps.git\n\ncd aces-apps\n# Optional: Checkout a specific version of aces-apps. By default, this will be the latest (`master`) version.\ngit checkout {VERSION}\n\n# Create a conda environment with optional name. If you don't specify a name (with -n {ENVIRONMENTNAME}), it will be called 'aces'\nconda env create -n {ENVIRONMENTNAME}\n\n# Activate the environment\nconda activate {ENVIRONMENTNAME}\n```\n\nPlease note though that `VERSION` and `ENVIRONMENTNAME` are simply placeholders and need to be updated appropriately.\n\nIn the above, the following occurs:\n* The repository is cloned into a new directory (using `ssh` or `https`)\n* A desired version is optionally checked out\n* A `conda` environment is created installing the software.\n\n\nNOTE: If you have any error around `mpi4py` on a Pawsey system such as `galaxy`, see the section below that outlines the modules that need to be loaded.\n\n### Slightly more advanced\nThis outlines a process that gives a little more granularity for bespoke processes and use cases. Installing `aces-apps` should be a fairly straightforward process.\n\nThe current version (`1.3.0`) expects a python 3.9 installation. It is recommended that a `conda` virtual environment is created with this version:\n\n```bash\nconda create -n {ENVIRONMENTNAME} python=3.9 -y\n```\n\nThis will create a new conda environment with the appropriate python version installed.\n\nNext, activate this environment with\n\n```bash\nconda activate {ENVIRONMENTNAME}\n```\n\nBefore issuing the next set of `pip` commands, please first take note whether you will be installing this package on a system with specialised MPI tooling. For example, Cray style HPC. If so, refer to the next section.\n\nOnce the `conda` environment you previously installed has been activated (and the `mpi` tooling requirements have been dealt with), install `aces-apps` should be straight-forward.\n\n```bash\n# If using ssh:\npip install git+ssh://git@bitbucket.csiro.au:7999/aces/aces-apps.git@1.3.0\n\n# If using https:\npip install git+https://bitbucket.csiro.au/scm/aces/aces-apps.git@1.3.0\n```\n\nThis command should clone the `aces-apps` repository to a temporary space, checkout the `1.3.0` tag, and use the `pyproject.toml` file to identify dependencies, and their version specifications. *Please note the @1.3.0 tag* which will install a specific version of the `aces-apps` tooling.\n\nIf an `mpi4py` compilation error is thrown, the required `mpi` libraries and environments are likely not correctly defined. Please refer to the next section if using Galaxy/Pawsey, or the documentation for your HPC system.\n\nFinally, the `askap` python module needs to be installed (or rather, a subset of the complete module). This is being performed as a final step as its current layout is not well suited for automated installation with typical tooling. Issue these these commands:\n\n```bash\npip install -r requirements.txt\n\n# - OR -\n\npip install git+https://bitbucket.csiro.au/scm/tos/python-askap.git#egg=askap\npip install git+https://bitbucket.csiro.au/scm/tos/python-parset.git#egg=askap.parset\npip install git+https://bitbucket.csiro.au/scm/tos/python-footprint.git#egg=askap.footprint\n```\n\nSpecifically, the `python-askap` module is actually a small set of independent modules. The above set of `pip` commands will install each module instal a common namespace as a submodule. The use of the `egg=askap` argument in the endpoint is important. If a specific version of `python-askap` is required this will need be set using the typical `@1.2` style of notation.\n\n### Installing as a developer\n\nIf you are trying to develop or test code as part of the `aces-apps` tooling, the above instructions are mostly correct, but some slight tweaks are needed.\n\nFirst, clone the repository and checkout the appropriate tag/branch.\n\n```bash\n# If using ssh:\ngit clone ssh://git@bitbucket.csiro.au:7999/aces/aces-apps.git\n\n# If using https:\ngit clone https://bitbucket.csiro.au/scm/aces/aces-apps.git\n\ncd aces-apps\ngit checkout {VERSION}\n```\n\nIf you are planning on developing a new feature it is also recommended that a new branch is created to isolate changes from the main.\n\nThen create the `conda` environment and activate it\n\n```bash\nconda create -n {DEV_ENVIRONMENTNAME} python=3.9\nconda activate {DEV_ENVIRONMENTNAME}\n```\n\nUnlike the previous set of `conda` environment commands, this one *will not* use the `environment.yml` file to auto magically install everything.\n\nProvided the above has worked, you can then do a _developer install_ of the `aces-apps` by\n\n```bash\npip install -e .\n```\n\nThe `-e` will essentially create a symlink from the `site-packages/aces` path to the current location. This will let you edit code from the current location and be picked up when running scripts that `import aces`.\n\nFinally, configure the `askap` tooling.\n\n```bash\npip install -r requirements.txt\n\n# - OR -\n\npip install git+https://bitbucket.csiro.au/scm/tos/python-askap.git#egg=askap\npip install git+https://bitbucket.csiro.au/scm/tos/python-parset.git#egg=askap.parset\npip install git+https://bitbucket.csiro.au/scm/tos/python-footprint.git#egg=askap.footprint\n```\n\n### Notes on `mpi4py`\nSome tooling in `aces-apps` repositories relies on `mpi` for code parallelism. On some cray-type supercomputing systems this requires a specialised set of `mpi` libraries and compilers. The `galaxy` system is such a machine. This tooling needs to be loaded into the shell environment before issuing the `pip` command to install `aces-apps`. On Galaxy, issue these commands:\n\n```bash\n# Extra environment commands for galaxy\nmodule swap PrgEnv-cray PrgEnv-gnu\nexport MPICC=/opt/cray/pe/craype/2.5.13/bin/cc\n```\n\nSimilarly, on `zeus` the following commands are required:\n\n```bash\n# Extra environment commands for zeus\nmodule load intel-mpi\nexport MPICC=/pawsey/intel/17.0.5/compilers_and_libraries/linux/mpi/intel64/bin/mpicc\n```\n\nThese can be combined, and placed into your `~/.bashrc`:\n```bash\n# MPI4PY\n# Test if machine is galaxy\nmachine=$(hostname)\nif [[ $machine == galaxy* ]]; then\n    module swap PrgEnv-cray PrgEnv-gnu\n    export MPICC=/opt/cray/pe/craype/2.5.13/bin/cc\nfi\n\n# test if machine is zeus\nif [[ $machine == zeus* ]]; then\n    module load intel-mpi\n    export MPICC=/pawsey/intel/17.0.5/compilers_and_libraries/linux/mpi/intel64/bin/mpicc\nfi\n```\n\nPlease note that these instructions may not be correct or relevant on other HPC machines, including others at Pawsey. Care will need to be taken if attempting to deploy the package on a Cray style system.\n\nA sample script `aces_test_mpi_install.py` is installed alongside this package as a way of verifying an `mpi` installation and configuration should it be needed.\n\n\n## Notes from mpfit\n\n_Taken verbatim from the mpfit documentation_\n\nThis library contains a few useful routines I wrote or I converted from IDL.\n\nMy contacts are:\nSergey Koposov koposov@ast.cam.ac.uk\nInstitute of Astronomy, University of Cambridge\nMadingley road, CB3 0HA, Cambridge, UK\n\nIf you have found a bug or have a patch, you can send them to me.\nWith my library I do not promise a stable interface, so beware.\n\nThe licensing for the programs I wrote myself is GPL3. For all other\nprograms (mainly converted from IDL) I guess the license is either BSD or\nthey are in public domain.\n\nHere is the quick list of the functions I implemented:\nTBW\n",
    'author': 'David McConnell',
    'author_email': 'David.McConnell@csiro.au',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'scripts': scripts,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
