# Generated by Django 4.2.21 on 2025-08-30 18:43

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import mojo.models.rest


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('account', '0013_pushconfig_test_mode_alter_pushconfig_apns_enabled_and_more'),
        ('fileman', '0011_alter_filerendition_original_file'),
    ]

    operations = [
        migrations.CreateModel(
            name='Book',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Book title', max_length=200)),
                ('slug', models.SlugField(help_text='URL-friendly identifier', max_length=200, unique=True)),
                ('description', models.TextField(blank=True, help_text='Brief description of the book content')),
                ('order_priority', models.IntegerField(db_index=True, default=0, help_text='Higher values appear first in listings')),
                ('permissions', models.CharField(blank=True, help_text='Comma-separated permission strings for fine-grained access control', max_length=500)),
                ('config', models.JSONField(default=dict, help_text='Book-specific settings, plugin configuration, and custom access rules')),
                ('is_active', models.BooleanField(db_index=True, default=True, help_text='Whether this book is active and visible')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('created_by', models.ForeignKey(help_text='User who created this book', on_delete=django.db.models.deletion.PROTECT, related_name='created_books', to=settings.AUTH_USER_MODEL)),
                ('group', models.ForeignKey(help_text='Owning group for this book', on_delete=django.db.models.deletion.CASCADE, to='account.group')),
                ('modified_by', models.ForeignKey(help_text='User who last modified this book', on_delete=django.db.models.deletion.PROTECT, related_name='modified_books', to=settings.AUTH_USER_MODEL)),
                ('user', models.ForeignKey(help_text='Book owner for permission checks', on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Book',
                'verbose_name_plural': 'Books',
                'ordering': ['-order_priority', 'title'],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='Page',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Page title', max_length=200)),
                ('slug', models.SlugField(help_text='URL-friendly identifier (unique within book)', max_length=200)),
                ('content', models.TextField(help_text='Raw markdown content')),
                ('order_priority', models.IntegerField(db_index=True, default=0, help_text='Higher values appear first in listings')),
                ('metadata', models.JSONField(default=dict, help_text='Frontmatter and additional page metadata')),
                ('is_published', models.BooleanField(db_index=True, default=True, help_text='Whether this page is published and visible')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('book', models.ForeignKey(help_text='Book this page belongs to', on_delete=django.db.models.deletion.CASCADE, related_name='pages', to='docit.book')),
                ('created_by', models.ForeignKey(help_text='User who created this page', on_delete=django.db.models.deletion.PROTECT, related_name='created_pages', to=settings.AUTH_USER_MODEL)),
                ('modified_by', models.ForeignKey(help_text='User who last modified this page', on_delete=django.db.models.deletion.PROTECT, related_name='modified_pages', to=settings.AUTH_USER_MODEL)),
                ('parent', models.ForeignKey(blank=True, help_text='Parent page for hierarchical organization', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='docit.page')),
                ('user', models.ForeignKey(help_text='Page owner (inherited from book for permissions)', on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Page',
                'verbose_name_plural': 'Pages',
                'ordering': ['-order_priority', 'title'],
                'unique_together': {('book', 'slug')},
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='Asset',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order_priority', models.IntegerField(db_index=True, default=0, help_text='Higher values appear first in asset lists')),
                ('alt_text', models.CharField(blank=True, help_text='Alternative text for images and accessibility', max_length=200)),
                ('description', models.TextField(blank=True, help_text='Detailed description of the asset')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('book', models.ForeignKey(help_text='Book this asset belongs to', on_delete=django.db.models.deletion.CASCADE, related_name='assets', to='docit.book')),
                ('created_by', models.ForeignKey(help_text='User who created this asset', on_delete=django.db.models.deletion.PROTECT, related_name='created_assets', to=settings.AUTH_USER_MODEL)),
                ('file', models.ForeignKey(blank=True, help_text='Associated file from fileman', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='docit_assets', to='fileman.file')),
                ('user', models.ForeignKey(help_text='Asset owner (inherited from book for permissions)', on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Asset',
                'verbose_name_plural': 'Assets',
                'ordering': ['-order_priority', 'id'],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='PageRevision',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content', models.TextField(help_text='Markdown content snapshot at time of revision')),
                ('version', models.IntegerField(db_index=True, help_text='Sequential version number for this page')),
                ('change_summary', models.CharField(blank=True, help_text='Brief description of changes made in this revision', max_length=200)),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('created_by', models.ForeignKey(help_text='User who created this revision', on_delete=django.db.models.deletion.PROTECT, related_name='created_revisions', to=settings.AUTH_USER_MODEL)),
                ('page', models.ForeignKey(help_text='Page this revision belongs to', on_delete=django.db.models.deletion.CASCADE, related_name='revisions', to='docit.page')),
                ('user', models.ForeignKey(help_text='User for permission inheritance (from page/book)', on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Page Revision',
                'verbose_name_plural': 'Page Revisions',
                'ordering': ['-version'],
                'unique_together': {('page', 'version')},
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
    ]
