"""initial schema

Revision ID: 7e0d6dfb1b1d
Revises:
Create Date: 2025-05-07 09:17:37.181531

"""

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import sqlite

import photobooth.database.types

# revision identifiers, used by Alembic.
revision: str = "7e0d6dfb1b1d"
down_revision: str | None = None
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "mediaitems",
        sa.Column("rowid", sa.Integer(), nullable=False, system=True),
        sa.Column("id", sa.UUID(), nullable=False),
        sa.Column("media_type", sa.Enum("image", "collage", "animation", "video", "multicamera", name="mediaitemtypes"), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("updated_at", sa.DateTime(timezone=True), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("job_identifier", sa.UUID(), nullable=False),
        sa.Column("unprocessed", photobooth.database.types.PathType(), nullable=False),
        sa.Column("processed", photobooth.database.types.PathType(), nullable=False),
        sa.Column("pipeline_config", sqlite.JSON(), nullable=False),
        sa.Column("show_in_gallery", sa.Boolean(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "sharelimits",
        sa.Column("action", sa.String(), nullable=False),
        sa.Column("count", sa.Integer(), nullable=False),
        sa.Column("last_used_at", sa.DateTime(timezone=True), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.PrimaryKeyConstraint("action"),
    )
    op.create_table(
        "usagestats",
        sa.Column("action", sa.String(), nullable=False),
        sa.Column("count", sa.Integer(), nullable=False),
        sa.Column("last_used_at", sa.DateTime(timezone=True), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.PrimaryKeyConstraint("action"),
    )
    op.create_table(
        "cacheditems",
        sa.Column("id", sa.UUID(), nullable=False),
        sa.Column("mediaitem_id", sa.UUID(), nullable=False),
        sa.Column("dimension", sa.Enum("full", "preview", "thumbnail", name="dimensiontypes"), nullable=False),
        sa.Column("processed", sa.Boolean(), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("filepath", photobooth.database.types.PathType(), nullable=False),
        sa.ForeignKeyConstraint(
            ["mediaitem_id"],
            ["mediaitems.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_cacheditems_dimension"), "cacheditems", ["dimension"], unique=False)
    op.create_index(op.f("ix_cacheditems_mediaitem_id"), "cacheditems", ["mediaitem_id"], unique=False)
    op.create_index(op.f("ix_cacheditems_processed"), "cacheditems", ["processed"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_cacheditems_processed"), table_name="cacheditems")
    op.drop_index(op.f("ix_cacheditems_mediaitem_id"), table_name="cacheditems")
    op.drop_index(op.f("ix_cacheditems_dimension"), table_name="cacheditems")
    op.drop_table("cacheditems")
    op.drop_table("usagestats")
    op.drop_table("sharelimits")
    op.drop_table("mediaitems")
    # ### end Alembic commands ###
