from typing import Iterable


class DataStoreException(Exception):
    pass


class SearchException(Exception):
    pass


class SearchDepthException(Exception):
    pass


class ILMException(Exception):
    pass


class VersionConflictException(Exception):
    pass


class UnsupportedElasticVersion(Exception):
    pass


class ArchiveDisabled(Exception):
    pass


class MultiKeyError(KeyError):
    def __init__(self, keys: Iterable[str], partial_output):
        super().__init__(str(keys))
        self.keys = set(keys)
        self.partial_output = partial_output
