📦
863875 /agent/ssl_log.js
505430 /agent/ssl_log.js.map
✄
var __defProp = Object.defineProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};

// frida-shim:node_modules/@frida/base64-js/index.js
var lookup = [];
var revLookup = [];
var code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
for (let i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i];
  revLookup[code.charCodeAt(i)] = i;
}
revLookup["-".charCodeAt(0)] = 62;
revLookup["_".charCodeAt(0)] = 63;
function getLens(b64) {
  const len = b64.length;
  if (len % 4 > 0) {
    throw new Error("Invalid string. Length must be a multiple of 4");
  }
  let validLen = b64.indexOf("=");
  if (validLen === -1) validLen = len;
  const placeHoldersLen = validLen === len ? 0 : 4 - validLen % 4;
  return [validLen, placeHoldersLen];
}
function _byteLength(b64, validLen, placeHoldersLen) {
  return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
}
function toByteArray(b64) {
  const lens = getLens(b64);
  const validLen = lens[0];
  const placeHoldersLen = lens[1];
  const arr = new Uint8Array(_byteLength(b64, validLen, placeHoldersLen));
  let curByte = 0;
  const len = placeHoldersLen > 0 ? validLen - 4 : validLen;
  let i;
  for (i = 0; i < len; i += 4) {
    const tmp = revLookup[b64.charCodeAt(i)] << 18 | revLookup[b64.charCodeAt(i + 1)] << 12 | revLookup[b64.charCodeAt(i + 2)] << 6 | revLookup[b64.charCodeAt(i + 3)];
    arr[curByte++] = tmp >> 16 & 255;
    arr[curByte++] = tmp >> 8 & 255;
    arr[curByte++] = tmp & 255;
  }
  if (placeHoldersLen === 2) {
    const tmp = revLookup[b64.charCodeAt(i)] << 2 | revLookup[b64.charCodeAt(i + 1)] >> 4;
    arr[curByte++] = tmp & 255;
  }
  if (placeHoldersLen === 1) {
    const tmp = revLookup[b64.charCodeAt(i)] << 10 | revLookup[b64.charCodeAt(i + 1)] << 4 | revLookup[b64.charCodeAt(i + 2)] >> 2;
    arr[curByte++] = tmp >> 8 & 255;
    arr[curByte++] = tmp & 255;
  }
  return arr;
}
function tripletToBase64(num) {
  return lookup[num >> 18 & 63] + lookup[num >> 12 & 63] + lookup[num >> 6 & 63] + lookup[num & 63];
}
function encodeChunk(uint8, start, end) {
  const output = [];
  for (let i = start; i < end; i += 3) {
    const tmp = (uint8[i] << 16 & 16711680) + (uint8[i + 1] << 8 & 65280) + (uint8[i + 2] & 255);
    output.push(tripletToBase64(tmp));
  }
  return output.join("");
}
function fromByteArray(uint8) {
  const len = uint8.length;
  const extraBytes = len % 3;
  const parts = [];
  const maxChunkLength = 16383;
  for (let i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, i + maxChunkLength > len2 ? len2 : i + maxChunkLength));
  }
  if (extraBytes === 1) {
    const tmp = uint8[len - 1];
    parts.push(
      lookup[tmp >> 2] + lookup[tmp << 4 & 63] + "=="
    );
  } else if (extraBytes === 2) {
    const tmp = (uint8[len - 2] << 8) + uint8[len - 1];
    parts.push(
      lookup[tmp >> 10] + lookup[tmp >> 4 & 63] + lookup[tmp << 2 & 63] + "="
    );
  }
  return parts.join("");
}

// frida-shim:node_modules/@frida/ieee754/index.js
function read(buffer, offset, isLE, mLen, nBytes) {
  let e, m2;
  const eLen = nBytes * 8 - mLen - 1;
  const eMax = (1 << eLen) - 1;
  const eBias = eMax >> 1;
  let nBits = -7;
  let i = isLE ? nBytes - 1 : 0;
  const d = isLE ? -1 : 1;
  let s = buffer[offset + i];
  i += d;
  e = s & (1 << -nBits) - 1;
  s >>= -nBits;
  nBits += eLen;
  while (nBits > 0) {
    e = e * 256 + buffer[offset + i];
    i += d;
    nBits -= 8;
  }
  m2 = e & (1 << -nBits) - 1;
  e >>= -nBits;
  nBits += mLen;
  while (nBits > 0) {
    m2 = m2 * 256 + buffer[offset + i];
    i += d;
    nBits -= 8;
  }
  if (e === 0) {
    e = 1 - eBias;
  } else if (e === eMax) {
    return m2 ? NaN : (s ? -1 : 1) * Infinity;
  } else {
    m2 = m2 + Math.pow(2, mLen);
    e = e - eBias;
  }
  return (s ? -1 : 1) * m2 * Math.pow(2, e - mLen);
}
function write(buffer, value, offset, isLE, mLen, nBytes) {
  let e, m2, c;
  let eLen = nBytes * 8 - mLen - 1;
  const eMax = (1 << eLen) - 1;
  const eBias = eMax >> 1;
  const rt = mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0;
  let i = isLE ? 0 : nBytes - 1;
  const d = isLE ? 1 : -1;
  const s = value < 0 || value === 0 && 1 / value < 0 ? 1 : 0;
  value = Math.abs(value);
  if (isNaN(value) || value === Infinity) {
    m2 = isNaN(value) ? 1 : 0;
    e = eMax;
  } else {
    e = Math.floor(Math.log(value) / Math.LN2);
    if (value * (c = Math.pow(2, -e)) < 1) {
      e--;
      c *= 2;
    }
    if (e + eBias >= 1) {
      value += rt / c;
    } else {
      value += rt * Math.pow(2, 1 - eBias);
    }
    if (value * c >= 2) {
      e++;
      c /= 2;
    }
    if (e + eBias >= eMax) {
      m2 = 0;
      e = eMax;
    } else if (e + eBias >= 1) {
      m2 = (value * c - 1) * Math.pow(2, mLen);
      e = e + eBias;
    } else {
      m2 = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
      e = 0;
    }
  }
  while (mLen >= 8) {
    buffer[offset + i] = m2 & 255;
    i += d;
    m2 /= 256;
    mLen -= 8;
  }
  e = e << mLen | m2;
  eLen += mLen;
  while (eLen > 0) {
    buffer[offset + i] = e & 255;
    i += d;
    e /= 256;
    eLen -= 8;
  }
  buffer[offset + i - d] |= s * 128;
}

// frida-shim:node_modules/@frida/buffer/index.js
var config = {
  INSPECT_MAX_BYTES: 50
};
var K_MAX_LENGTH = 2147483647;
Buffer2.TYPED_ARRAY_SUPPORT = true;
Object.defineProperty(Buffer2.prototype, "parent", {
  enumerable: true,
  get: function() {
    if (!Buffer2.isBuffer(this)) return void 0;
    return this.buffer;
  }
});
Object.defineProperty(Buffer2.prototype, "offset", {
  enumerable: true,
  get: function() {
    if (!Buffer2.isBuffer(this)) return void 0;
    return this.byteOffset;
  }
});
function createBuffer(length) {
  if (length > K_MAX_LENGTH) {
    throw new RangeError('The value "' + length + '" is invalid for option "size"');
  }
  const buf = new Uint8Array(length);
  Object.setPrototypeOf(buf, Buffer2.prototype);
  return buf;
}
function Buffer2(arg, encodingOrOffset, length) {
  if (typeof arg === "number") {
    if (typeof encodingOrOffset === "string") {
      throw new TypeError(
        'The "string" argument must be of type string. Received type number'
      );
    }
    return allocUnsafe(arg);
  }
  return from(arg, encodingOrOffset, length);
}
Buffer2.poolSize = 8192;
function from(value, encodingOrOffset, length) {
  if (typeof value === "string") {
    return fromString(value, encodingOrOffset);
  }
  if (ArrayBuffer.isView(value)) {
    return fromArrayView(value);
  }
  if (value == null) {
    throw new TypeError(
      "The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type " + typeof value
    );
  }
  if (value instanceof ArrayBuffer || value && value.buffer instanceof ArrayBuffer) {
    return fromArrayBuffer(value, encodingOrOffset, length);
  }
  if (value instanceof SharedArrayBuffer || value && value.buffer instanceof SharedArrayBuffer) {
    return fromArrayBuffer(value, encodingOrOffset, length);
  }
  if (typeof value === "number") {
    throw new TypeError(
      'The "value" argument must not be of type number. Received type number'
    );
  }
  const valueOf = value.valueOf && value.valueOf();
  if (valueOf != null && valueOf !== value) {
    return Buffer2.from(valueOf, encodingOrOffset, length);
  }
  const b = fromObject(value);
  if (b) return b;
  if (typeof Symbol !== "undefined" && Symbol.toPrimitive != null && typeof value[Symbol.toPrimitive] === "function") {
    return Buffer2.from(value[Symbol.toPrimitive]("string"), encodingOrOffset, length);
  }
  throw new TypeError(
    "The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type " + typeof value
  );
}
Buffer2.from = function(value, encodingOrOffset, length) {
  return from(value, encodingOrOffset, length);
};
Object.setPrototypeOf(Buffer2.prototype, Uint8Array.prototype);
Object.setPrototypeOf(Buffer2, Uint8Array);
function assertSize(size) {
  if (typeof size !== "number") {
    throw new TypeError('"size" argument must be of type number');
  } else if (size < 0) {
    throw new RangeError('The value "' + size + '" is invalid for option "size"');
  }
}
function alloc(size, fill2, encoding) {
  assertSize(size);
  if (size <= 0) {
    return createBuffer(size);
  }
  if (fill2 !== void 0) {
    return typeof encoding === "string" ? createBuffer(size).fill(fill2, encoding) : createBuffer(size).fill(fill2);
  }
  return createBuffer(size);
}
Buffer2.alloc = function(size, fill2, encoding) {
  return alloc(size, fill2, encoding);
};
function allocUnsafe(size) {
  assertSize(size);
  return createBuffer(size < 0 ? 0 : checked(size) | 0);
}
Buffer2.allocUnsafe = function(size) {
  return allocUnsafe(size);
};
Buffer2.allocUnsafeSlow = function(size) {
  return allocUnsafe(size);
};
function fromString(string, encoding) {
  if (typeof encoding !== "string" || encoding === "") {
    encoding = "utf8";
  }
  if (!Buffer2.isEncoding(encoding)) {
    throw new TypeError("Unknown encoding: " + encoding);
  }
  const length = byteLength(string, encoding) | 0;
  let buf = createBuffer(length);
  const actual = buf.write(string, encoding);
  if (actual !== length) {
    buf = buf.slice(0, actual);
  }
  return buf;
}
function fromArrayLike(array) {
  const length = array.length < 0 ? 0 : checked(array.length) | 0;
  const buf = createBuffer(length);
  for (let i = 0; i < length; i += 1) {
    buf[i] = array[i] & 255;
  }
  return buf;
}
function fromArrayView(arrayView) {
  if (arrayView instanceof Uint8Array) {
    const copy2 = new Uint8Array(arrayView);
    return fromArrayBuffer(copy2.buffer, copy2.byteOffset, copy2.byteLength);
  }
  return fromArrayLike(arrayView);
}
function fromArrayBuffer(array, byteOffset, length) {
  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('"offset" is outside of buffer bounds');
  }
  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('"length" is outside of buffer bounds');
  }
  let buf;
  if (byteOffset === void 0 && length === void 0) {
    buf = new Uint8Array(array);
  } else if (length === void 0) {
    buf = new Uint8Array(array, byteOffset);
  } else {
    buf = new Uint8Array(array, byteOffset, length);
  }
  Object.setPrototypeOf(buf, Buffer2.prototype);
  return buf;
}
function fromObject(obj) {
  if (Buffer2.isBuffer(obj)) {
    const len = checked(obj.length) | 0;
    const buf = createBuffer(len);
    if (buf.length === 0) {
      return buf;
    }
    obj.copy(buf, 0, 0, len);
    return buf;
  }
  if (obj.length !== void 0) {
    if (typeof obj.length !== "number" || Number.isNaN(obj.length)) {
      return createBuffer(0);
    }
    return fromArrayLike(obj);
  }
  if (obj.type === "Buffer" && Array.isArray(obj.data)) {
    return fromArrayLike(obj.data);
  }
}
function checked(length) {
  if (length >= K_MAX_LENGTH) {
    throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x" + K_MAX_LENGTH.toString(16) + " bytes");
  }
  return length | 0;
}
Buffer2.isBuffer = function isBuffer(b) {
  return b != null && b._isBuffer === true && b !== Buffer2.prototype;
};
Buffer2.compare = function compare(a, b) {
  if (a instanceof Uint8Array) a = Buffer2.from(a, a.offset, a.byteLength);
  if (b instanceof Uint8Array) b = Buffer2.from(b, b.offset, b.byteLength);
  if (!Buffer2.isBuffer(a) || !Buffer2.isBuffer(b)) {
    throw new TypeError(
      'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array'
    );
  }
  if (a === b) return 0;
  let x = a.length;
  let y = b.length;
  for (let i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i];
      y = b[i];
      break;
    }
  }
  if (x < y) return -1;
  if (y < x) return 1;
  return 0;
};
Buffer2.isEncoding = function isEncoding(encoding) {
  switch (String(encoding).toLowerCase()) {
    case "hex":
    case "utf8":
    case "utf-8":
    case "ascii":
    case "latin1":
    case "binary":
    case "base64":
    case "ucs2":
    case "ucs-2":
    case "utf16le":
    case "utf-16le":
      return true;
    default:
      return false;
  }
};
Buffer2.concat = function concat(list, length) {
  if (!Array.isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers');
  }
  if (list.length === 0) {
    return Buffer2.alloc(0);
  }
  let i;
  if (length === void 0) {
    length = 0;
    for (i = 0; i < list.length; ++i) {
      length += list[i].length;
    }
  }
  const buffer = Buffer2.allocUnsafe(length);
  let pos = 0;
  for (i = 0; i < list.length; ++i) {
    let buf = list[i];
    if (buf instanceof Uint8Array) {
      if (pos + buf.length > buffer.length) {
        if (!Buffer2.isBuffer(buf)) {
          buf = Buffer2.from(buf.buffer, buf.byteOffset, buf.byteLength);
        }
        buf.copy(buffer, pos);
      } else {
        Uint8Array.prototype.set.call(
          buffer,
          buf,
          pos
        );
      }
    } else if (!Buffer2.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers');
    } else {
      buf.copy(buffer, pos);
    }
    pos += buf.length;
  }
  return buffer;
};
function byteLength(string, encoding) {
  if (Buffer2.isBuffer(string)) {
    return string.length;
  }
  if (ArrayBuffer.isView(string) || string instanceof ArrayBuffer) {
    return string.byteLength;
  }
  if (typeof string !== "string") {
    throw new TypeError(
      'The "string" argument must be one of type string, Buffer, or ArrayBuffer. Received type ' + typeof string
    );
  }
  const len = string.length;
  const mustMatch = arguments.length > 2 && arguments[2] === true;
  if (!mustMatch && len === 0) return 0;
  let loweredCase = false;
  for (; ; ) {
    switch (encoding) {
      case "ascii":
      case "latin1":
      case "binary":
        return len;
      case "utf8":
      case "utf-8":
        return utf8ToBytes(string).length;
      case "ucs2":
      case "ucs-2":
      case "utf16le":
      case "utf-16le":
        return len * 2;
      case "hex":
        return len >>> 1;
      case "base64":
        return base64ToBytes(string).length;
      default:
        if (loweredCase) {
          return mustMatch ? -1 : utf8ToBytes(string).length;
        }
        encoding = ("" + encoding).toLowerCase();
        loweredCase = true;
    }
  }
}
Buffer2.byteLength = byteLength;
function slowToString(encoding, start, end) {
  let loweredCase = false;
  if (start === void 0 || start < 0) {
    start = 0;
  }
  if (start > this.length) {
    return "";
  }
  if (end === void 0 || end > this.length) {
    end = this.length;
  }
  if (end <= 0) {
    return "";
  }
  end >>>= 0;
  start >>>= 0;
  if (end <= start) {
    return "";
  }
  if (!encoding) encoding = "utf8";
  while (true) {
    switch (encoding) {
      case "hex":
        return hexSlice(this, start, end);
      case "utf8":
      case "utf-8":
        return utf8Slice(this, start, end);
      case "ascii":
        return asciiSlice(this, start, end);
      case "latin1":
      case "binary":
        return latin1Slice(this, start, end);
      case "base64":
        return base64Slice(this, start, end);
      case "ucs2":
      case "ucs-2":
      case "utf16le":
      case "utf-16le":
        return utf16leSlice(this, start, end);
      default:
        if (loweredCase) throw new TypeError("Unknown encoding: " + encoding);
        encoding = (encoding + "").toLowerCase();
        loweredCase = true;
    }
  }
}
Buffer2.prototype._isBuffer = true;
function swap(b, n, m2) {
  const i = b[n];
  b[n] = b[m2];
  b[m2] = i;
}
Buffer2.prototype.swap16 = function swap16() {
  const len = this.length;
  if (len % 2 !== 0) {
    throw new RangeError("Buffer size must be a multiple of 16-bits");
  }
  for (let i = 0; i < len; i += 2) {
    swap(this, i, i + 1);
  }
  return this;
};
Buffer2.prototype.swap32 = function swap32() {
  const len = this.length;
  if (len % 4 !== 0) {
    throw new RangeError("Buffer size must be a multiple of 32-bits");
  }
  for (let i = 0; i < len; i += 4) {
    swap(this, i, i + 3);
    swap(this, i + 1, i + 2);
  }
  return this;
};
Buffer2.prototype.swap64 = function swap64() {
  const len = this.length;
  if (len % 8 !== 0) {
    throw new RangeError("Buffer size must be a multiple of 64-bits");
  }
  for (let i = 0; i < len; i += 8) {
    swap(this, i, i + 7);
    swap(this, i + 1, i + 6);
    swap(this, i + 2, i + 5);
    swap(this, i + 3, i + 4);
  }
  return this;
};
Buffer2.prototype.toString = function toString() {
  const length = this.length;
  if (length === 0) return "";
  if (arguments.length === 0) return utf8Slice(this, 0, length);
  return slowToString.apply(this, arguments);
};
Buffer2.prototype.toLocaleString = Buffer2.prototype.toString;
Buffer2.prototype.equals = function equals(b) {
  if (!Buffer2.isBuffer(b)) throw new TypeError("Argument must be a Buffer");
  if (this === b) return true;
  return Buffer2.compare(this, b) === 0;
};
Buffer2.prototype.inspect = function inspect() {
  let str = "";
  const max = config.INSPECT_MAX_BYTES;
  str = this.toString("hex", 0, max).replace(/(.{2})/g, "$1 ").trim();
  if (this.length > max) str += " ... ";
  return "<Buffer " + str + ">";
};
Buffer2.prototype[Symbol.for("nodejs.util.inspect.custom")] = Buffer2.prototype.inspect;
Buffer2.prototype.compare = function compare2(target, start, end, thisStart, thisEnd) {
  if (target instanceof Uint8Array) {
    target = Buffer2.from(target, target.offset, target.byteLength);
  }
  if (!Buffer2.isBuffer(target)) {
    throw new TypeError(
      'The "target" argument must be one of type Buffer or Uint8Array. Received type ' + typeof target
    );
  }
  if (start === void 0) {
    start = 0;
  }
  if (end === void 0) {
    end = target ? target.length : 0;
  }
  if (thisStart === void 0) {
    thisStart = 0;
  }
  if (thisEnd === void 0) {
    thisEnd = this.length;
  }
  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError("out of range index");
  }
  if (thisStart >= thisEnd && start >= end) {
    return 0;
  }
  if (thisStart >= thisEnd) {
    return -1;
  }
  if (start >= end) {
    return 1;
  }
  start >>>= 0;
  end >>>= 0;
  thisStart >>>= 0;
  thisEnd >>>= 0;
  if (this === target) return 0;
  let x = thisEnd - thisStart;
  let y = end - start;
  const len = Math.min(x, y);
  const thisCopy = this.slice(thisStart, thisEnd);
  const targetCopy = target.slice(start, end);
  for (let i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i];
      y = targetCopy[i];
      break;
    }
  }
  if (x < y) return -1;
  if (y < x) return 1;
  return 0;
};
function bidirectionalIndexOf(buffer, val, byteOffset, encoding, dir) {
  if (buffer.length === 0) return -1;
  if (typeof byteOffset === "string") {
    encoding = byteOffset;
    byteOffset = 0;
  } else if (byteOffset > 2147483647) {
    byteOffset = 2147483647;
  } else if (byteOffset < -2147483648) {
    byteOffset = -2147483648;
  }
  byteOffset = +byteOffset;
  if (Number.isNaN(byteOffset)) {
    byteOffset = dir ? 0 : buffer.length - 1;
  }
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
  if (byteOffset >= buffer.length) {
    if (dir) return -1;
    else byteOffset = buffer.length - 1;
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0;
    else return -1;
  }
  if (typeof val === "string") {
    val = Buffer2.from(val, encoding);
  }
  if (Buffer2.isBuffer(val)) {
    if (val.length === 0) {
      return -1;
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir);
  } else if (typeof val === "number") {
    val = val & 255;
    if (typeof Uint8Array.prototype.indexOf === "function") {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset);
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset);
      }
    }
    return arrayIndexOf(buffer, [val], byteOffset, encoding, dir);
  }
  throw new TypeError("val must be string, number or Buffer");
}
function arrayIndexOf(arr, val, byteOffset, encoding, dir) {
  let indexSize = 1;
  let arrLength = arr.length;
  let valLength = val.length;
  if (encoding !== void 0) {
    encoding = String(encoding).toLowerCase();
    if (encoding === "ucs2" || encoding === "ucs-2" || encoding === "utf16le" || encoding === "utf-16le") {
      if (arr.length < 2 || val.length < 2) {
        return -1;
      }
      indexSize = 2;
      arrLength /= 2;
      valLength /= 2;
      byteOffset /= 2;
    }
  }
  function read2(buf, i2) {
    if (indexSize === 1) {
      return buf[i2];
    } else {
      return buf.readUInt16BE(i2 * indexSize);
    }
  }
  let i;
  if (dir) {
    let foundIndex = -1;
    for (i = byteOffset; i < arrLength; i++) {
      if (read2(arr, i) === read2(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i;
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize;
      } else {
        if (foundIndex !== -1) i -= i - foundIndex;
        foundIndex = -1;
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
    for (i = byteOffset; i >= 0; i--) {
      let found = true;
      for (let j = 0; j < valLength; j++) {
        if (read2(arr, i + j) !== read2(val, j)) {
          found = false;
          break;
        }
      }
      if (found) return i;
    }
  }
  return -1;
}
Buffer2.prototype.includes = function includes(val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1;
};
Buffer2.prototype.indexOf = function indexOf(val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true);
};
Buffer2.prototype.lastIndexOf = function lastIndexOf(val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false);
};
function hexWrite(buf, string, offset, length) {
  offset = Number(offset) || 0;
  const remaining = buf.length - offset;
  if (!length) {
    length = remaining;
  } else {
    length = Number(length);
    if (length > remaining) {
      length = remaining;
    }
  }
  const strLen = string.length;
  if (length > strLen / 2) {
    length = strLen / 2;
  }
  let i;
  for (i = 0; i < length; ++i) {
    const parsed = parseInt(string.substr(i * 2, 2), 16);
    if (Number.isNaN(parsed)) return i;
    buf[offset + i] = parsed;
  }
  return i;
}
function utf8Write(buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length);
}
function asciiWrite(buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length);
}
function base64Write(buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length);
}
function ucs2Write(buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length);
}
Buffer2.prototype.write = function write2(string, offset, length, encoding) {
  if (offset === void 0) {
    encoding = "utf8";
    length = this.length;
    offset = 0;
  } else if (length === void 0 && typeof offset === "string") {
    encoding = offset;
    length = this.length;
    offset = 0;
  } else if (isFinite(offset)) {
    offset = offset >>> 0;
    if (isFinite(length)) {
      length = length >>> 0;
      if (encoding === void 0) encoding = "utf8";
    } else {
      encoding = length;
      length = void 0;
    }
  } else {
    throw new Error(
      "Buffer.write(string, encoding, offset[, length]) is no longer supported"
    );
  }
  const remaining = this.length - offset;
  if (length === void 0 || length > remaining) length = remaining;
  if (string.length > 0 && (length < 0 || offset < 0) || offset > this.length) {
    throw new RangeError("Attempt to write outside buffer bounds");
  }
  if (!encoding) encoding = "utf8";
  let loweredCase = false;
  for (; ; ) {
    switch (encoding) {
      case "hex":
        return hexWrite(this, string, offset, length);
      case "utf8":
      case "utf-8":
        return utf8Write(this, string, offset, length);
      case "ascii":
      case "latin1":
      case "binary":
        return asciiWrite(this, string, offset, length);
      case "base64":
        return base64Write(this, string, offset, length);
      case "ucs2":
      case "ucs-2":
      case "utf16le":
      case "utf-16le":
        return ucs2Write(this, string, offset, length);
      default:
        if (loweredCase) throw new TypeError("Unknown encoding: " + encoding);
        encoding = ("" + encoding).toLowerCase();
        loweredCase = true;
    }
  }
};
Buffer2.prototype.toJSON = function toJSON() {
  return {
    type: "Buffer",
    data: Array.prototype.slice.call(this._arr || this, 0)
  };
};
function base64Slice(buf, start, end) {
  if (start === 0 && end === buf.length) {
    return fromByteArray(buf);
  } else {
    return fromByteArray(buf.slice(start, end));
  }
}
function utf8Slice(buf, start, end) {
  end = Math.min(buf.length, end);
  const res = [];
  let i = start;
  while (i < end) {
    const firstByte = buf[i];
    let codePoint = null;
    let bytesPerSequence = firstByte > 239 ? 4 : firstByte > 223 ? 3 : firstByte > 191 ? 2 : 1;
    if (i + bytesPerSequence <= end) {
      let secondByte, thirdByte, fourthByte, tempCodePoint;
      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 128) {
            codePoint = firstByte;
          }
          break;
        case 2:
          secondByte = buf[i + 1];
          if ((secondByte & 192) === 128) {
            tempCodePoint = (firstByte & 31) << 6 | secondByte & 63;
            if (tempCodePoint > 127) {
              codePoint = tempCodePoint;
            }
          }
          break;
        case 3:
          secondByte = buf[i + 1];
          thirdByte = buf[i + 2];
          if ((secondByte & 192) === 128 && (thirdByte & 192) === 128) {
            tempCodePoint = (firstByte & 15) << 12 | (secondByte & 63) << 6 | thirdByte & 63;
            if (tempCodePoint > 2047 && (tempCodePoint < 55296 || tempCodePoint > 57343)) {
              codePoint = tempCodePoint;
            }
          }
          break;
        case 4:
          secondByte = buf[i + 1];
          thirdByte = buf[i + 2];
          fourthByte = buf[i + 3];
          if ((secondByte & 192) === 128 && (thirdByte & 192) === 128 && (fourthByte & 192) === 128) {
            tempCodePoint = (firstByte & 15) << 18 | (secondByte & 63) << 12 | (thirdByte & 63) << 6 | fourthByte & 63;
            if (tempCodePoint > 65535 && tempCodePoint < 1114112) {
              codePoint = tempCodePoint;
            }
          }
      }
    }
    if (codePoint === null) {
      codePoint = 65533;
      bytesPerSequence = 1;
    } else if (codePoint > 65535) {
      codePoint -= 65536;
      res.push(codePoint >>> 10 & 1023 | 55296);
      codePoint = 56320 | codePoint & 1023;
    }
    res.push(codePoint);
    i += bytesPerSequence;
  }
  return decodeCodePointsArray(res);
}
var MAX_ARGUMENTS_LENGTH = 4096;
function decodeCodePointsArray(codePoints) {
  const len = codePoints.length;
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints);
  }
  let res = "";
  let i = 0;
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    );
  }
  return res;
}
function asciiSlice(buf, start, end) {
  let ret = "";
  end = Math.min(buf.length, end);
  for (let i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 127);
  }
  return ret;
}
function latin1Slice(buf, start, end) {
  let ret = "";
  end = Math.min(buf.length, end);
  for (let i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i]);
  }
  return ret;
}
function hexSlice(buf, start, end) {
  const len = buf.length;
  if (!start || start < 0) start = 0;
  if (!end || end < 0 || end > len) end = len;
  let out = "";
  for (let i = start; i < end; ++i) {
    out += hexSliceLookupTable[buf[i]];
  }
  return out;
}
function utf16leSlice(buf, start, end) {
  const bytes = buf.slice(start, end);
  let res = "";
  for (let i = 0; i < bytes.length - 1; i += 2) {
    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
  }
  return res;
}
Buffer2.prototype.slice = function slice(start, end) {
  const len = this.length;
  start = ~~start;
  end = end === void 0 ? len : ~~end;
  if (start < 0) {
    start += len;
    if (start < 0) start = 0;
  } else if (start > len) {
    start = len;
  }
  if (end < 0) {
    end += len;
    if (end < 0) end = 0;
  } else if (end > len) {
    end = len;
  }
  if (end < start) end = start;
  const newBuf = this.subarray(start, end);
  Object.setPrototypeOf(newBuf, Buffer2.prototype);
  return newBuf;
};
function checkOffset(offset, ext, length) {
  if (offset % 1 !== 0 || offset < 0) throw new RangeError("offset is not uint");
  if (offset + ext > length) throw new RangeError("Trying to access beyond buffer length");
}
Buffer2.prototype.readUintLE = Buffer2.prototype.readUIntLE = function readUIntLE(offset, byteLength2, noAssert) {
  offset = offset >>> 0;
  byteLength2 = byteLength2 >>> 0;
  if (!noAssert) checkOffset(offset, byteLength2, this.length);
  let val = this[offset];
  let mul = 1;
  let i = 0;
  while (++i < byteLength2 && (mul *= 256)) {
    val += this[offset + i] * mul;
  }
  return val;
};
Buffer2.prototype.readUintBE = Buffer2.prototype.readUIntBE = function readUIntBE(offset, byteLength2, noAssert) {
  offset = offset >>> 0;
  byteLength2 = byteLength2 >>> 0;
  if (!noAssert) {
    checkOffset(offset, byteLength2, this.length);
  }
  let val = this[offset + --byteLength2];
  let mul = 1;
  while (byteLength2 > 0 && (mul *= 256)) {
    val += this[offset + --byteLength2] * mul;
  }
  return val;
};
Buffer2.prototype.readUint8 = Buffer2.prototype.readUInt8 = function readUInt8(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 1, this.length);
  return this[offset];
};
Buffer2.prototype.readUint16LE = Buffer2.prototype.readUInt16LE = function readUInt16LE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 2, this.length);
  return this[offset] | this[offset + 1] << 8;
};
Buffer2.prototype.readUint16BE = Buffer2.prototype.readUInt16BE = function readUInt16BE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 2, this.length);
  return this[offset] << 8 | this[offset + 1];
};
Buffer2.prototype.readUint32LE = Buffer2.prototype.readUInt32LE = function readUInt32LE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);
  return (this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16) + this[offset + 3] * 16777216;
};
Buffer2.prototype.readUint32BE = Buffer2.prototype.readUInt32BE = function readUInt32BE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);
  return this[offset] * 16777216 + (this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3]);
};
Buffer2.prototype.readBigUInt64LE = function readBigUInt64LE(offset) {
  offset = offset >>> 0;
  validateNumber(offset, "offset");
  const first = this[offset];
  const last = this[offset + 7];
  if (first === void 0 || last === void 0) {
    boundsError(offset, this.length - 8);
  }
  const lo = first + this[++offset] * 2 ** 8 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 24;
  const hi = this[++offset] + this[++offset] * 2 ** 8 + this[++offset] * 2 ** 16 + last * 2 ** 24;
  return BigInt(lo) + (BigInt(hi) << BigInt(32));
};
Buffer2.prototype.readBigUInt64BE = function readBigUInt64BE(offset) {
  offset = offset >>> 0;
  validateNumber(offset, "offset");
  const first = this[offset];
  const last = this[offset + 7];
  if (first === void 0 || last === void 0) {
    boundsError(offset, this.length - 8);
  }
  const hi = first * 2 ** 24 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 8 + this[++offset];
  const lo = this[++offset] * 2 ** 24 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 8 + last;
  return (BigInt(hi) << BigInt(32)) + BigInt(lo);
};
Buffer2.prototype.readIntLE = function readIntLE(offset, byteLength2, noAssert) {
  offset = offset >>> 0;
  byteLength2 = byteLength2 >>> 0;
  if (!noAssert) checkOffset(offset, byteLength2, this.length);
  let val = this[offset];
  let mul = 1;
  let i = 0;
  while (++i < byteLength2 && (mul *= 256)) {
    val += this[offset + i] * mul;
  }
  mul *= 128;
  if (val >= mul) val -= Math.pow(2, 8 * byteLength2);
  return val;
};
Buffer2.prototype.readIntBE = function readIntBE(offset, byteLength2, noAssert) {
  offset = offset >>> 0;
  byteLength2 = byteLength2 >>> 0;
  if (!noAssert) checkOffset(offset, byteLength2, this.length);
  let i = byteLength2;
  let mul = 1;
  let val = this[offset + --i];
  while (i > 0 && (mul *= 256)) {
    val += this[offset + --i] * mul;
  }
  mul *= 128;
  if (val >= mul) val -= Math.pow(2, 8 * byteLength2);
  return val;
};
Buffer2.prototype.readInt8 = function readInt8(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 1, this.length);
  if (!(this[offset] & 128)) return this[offset];
  return (255 - this[offset] + 1) * -1;
};
Buffer2.prototype.readInt16LE = function readInt16LE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 2, this.length);
  const val = this[offset] | this[offset + 1] << 8;
  return val & 32768 ? val | 4294901760 : val;
};
Buffer2.prototype.readInt16BE = function readInt16BE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 2, this.length);
  const val = this[offset + 1] | this[offset] << 8;
  return val & 32768 ? val | 4294901760 : val;
};
Buffer2.prototype.readInt32LE = function readInt32LE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);
  return this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16 | this[offset + 3] << 24;
};
Buffer2.prototype.readInt32BE = function readInt32BE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);
  return this[offset] << 24 | this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3];
};
Buffer2.prototype.readBigInt64LE = function readBigInt64LE(offset) {
  offset = offset >>> 0;
  validateNumber(offset, "offset");
  const first = this[offset];
  const last = this[offset + 7];
  if (first === void 0 || last === void 0) {
    boundsError(offset, this.length - 8);
  }
  const val = this[offset + 4] + this[offset + 5] * 2 ** 8 + this[offset + 6] * 2 ** 16 + (last << 24);
  return (BigInt(val) << BigInt(32)) + BigInt(first + this[++offset] * 2 ** 8 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 24);
};
Buffer2.prototype.readBigInt64BE = function readBigInt64BE(offset) {
  offset = offset >>> 0;
  validateNumber(offset, "offset");
  const first = this[offset];
  const last = this[offset + 7];
  if (first === void 0 || last === void 0) {
    boundsError(offset, this.length - 8);
  }
  const val = (first << 24) + // Overflow
  this[++offset] * 2 ** 16 + this[++offset] * 2 ** 8 + this[++offset];
  return (BigInt(val) << BigInt(32)) + BigInt(this[++offset] * 2 ** 24 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 8 + last);
};
Buffer2.prototype.readFloatLE = function readFloatLE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);
  return read(this, offset, true, 23, 4);
};
Buffer2.prototype.readFloatBE = function readFloatBE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);
  return read(this, offset, false, 23, 4);
};
Buffer2.prototype.readDoubleLE = function readDoubleLE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 8, this.length);
  return read(this, offset, true, 52, 8);
};
Buffer2.prototype.readDoubleBE = function readDoubleBE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 8, this.length);
  return read(this, offset, false, 52, 8);
};
function checkInt(buf, value, offset, ext, max, min) {
  if (!Buffer2.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance');
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds');
  if (offset + ext > buf.length) throw new RangeError("Index out of range");
}
Buffer2.prototype.writeUintLE = Buffer2.prototype.writeUIntLE = function writeUIntLE(value, offset, byteLength2, noAssert) {
  value = +value;
  offset = offset >>> 0;
  byteLength2 = byteLength2 >>> 0;
  if (!noAssert) {
    const maxBytes = Math.pow(2, 8 * byteLength2) - 1;
    checkInt(this, value, offset, byteLength2, maxBytes, 0);
  }
  let mul = 1;
  let i = 0;
  this[offset] = value & 255;
  while (++i < byteLength2 && (mul *= 256)) {
    this[offset + i] = value / mul & 255;
  }
  return offset + byteLength2;
};
Buffer2.prototype.writeUintBE = Buffer2.prototype.writeUIntBE = function writeUIntBE(value, offset, byteLength2, noAssert) {
  value = +value;
  offset = offset >>> 0;
  byteLength2 = byteLength2 >>> 0;
  if (!noAssert) {
    const maxBytes = Math.pow(2, 8 * byteLength2) - 1;
    checkInt(this, value, offset, byteLength2, maxBytes, 0);
  }
  let i = byteLength2 - 1;
  let mul = 1;
  this[offset + i] = value & 255;
  while (--i >= 0 && (mul *= 256)) {
    this[offset + i] = value / mul & 255;
  }
  return offset + byteLength2;
};
Buffer2.prototype.writeUint8 = Buffer2.prototype.writeUInt8 = function writeUInt8(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 1, 255, 0);
  this[offset] = value & 255;
  return offset + 1;
};
Buffer2.prototype.writeUint16LE = Buffer2.prototype.writeUInt16LE = function writeUInt16LE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 2, 65535, 0);
  this[offset] = value & 255;
  this[offset + 1] = value >>> 8;
  return offset + 2;
};
Buffer2.prototype.writeUint16BE = Buffer2.prototype.writeUInt16BE = function writeUInt16BE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 2, 65535, 0);
  this[offset] = value >>> 8;
  this[offset + 1] = value & 255;
  return offset + 2;
};
Buffer2.prototype.writeUint32LE = Buffer2.prototype.writeUInt32LE = function writeUInt32LE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 4, 4294967295, 0);
  this[offset + 3] = value >>> 24;
  this[offset + 2] = value >>> 16;
  this[offset + 1] = value >>> 8;
  this[offset] = value & 255;
  return offset + 4;
};
Buffer2.prototype.writeUint32BE = Buffer2.prototype.writeUInt32BE = function writeUInt32BE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 4, 4294967295, 0);
  this[offset] = value >>> 24;
  this[offset + 1] = value >>> 16;
  this[offset + 2] = value >>> 8;
  this[offset + 3] = value & 255;
  return offset + 4;
};
function wrtBigUInt64LE(buf, value, offset, min, max) {
  checkIntBI(value, min, max, buf, offset, 7);
  let lo = Number(value & BigInt(4294967295));
  buf[offset++] = lo;
  lo = lo >> 8;
  buf[offset++] = lo;
  lo = lo >> 8;
  buf[offset++] = lo;
  lo = lo >> 8;
  buf[offset++] = lo;
  let hi = Number(value >> BigInt(32) & BigInt(4294967295));
  buf[offset++] = hi;
  hi = hi >> 8;
  buf[offset++] = hi;
  hi = hi >> 8;
  buf[offset++] = hi;
  hi = hi >> 8;
  buf[offset++] = hi;
  return offset;
}
function wrtBigUInt64BE(buf, value, offset, min, max) {
  checkIntBI(value, min, max, buf, offset, 7);
  let lo = Number(value & BigInt(4294967295));
  buf[offset + 7] = lo;
  lo = lo >> 8;
  buf[offset + 6] = lo;
  lo = lo >> 8;
  buf[offset + 5] = lo;
  lo = lo >> 8;
  buf[offset + 4] = lo;
  let hi = Number(value >> BigInt(32) & BigInt(4294967295));
  buf[offset + 3] = hi;
  hi = hi >> 8;
  buf[offset + 2] = hi;
  hi = hi >> 8;
  buf[offset + 1] = hi;
  hi = hi >> 8;
  buf[offset] = hi;
  return offset + 8;
}
Buffer2.prototype.writeBigUInt64LE = function writeBigUInt64LE(value, offset = 0) {
  return wrtBigUInt64LE(this, value, offset, BigInt(0), BigInt("0xffffffffffffffff"));
};
Buffer2.prototype.writeBigUInt64BE = function writeBigUInt64BE(value, offset = 0) {
  return wrtBigUInt64BE(this, value, offset, BigInt(0), BigInt("0xffffffffffffffff"));
};
Buffer2.prototype.writeIntLE = function writeIntLE(value, offset, byteLength2, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) {
    const limit = Math.pow(2, 8 * byteLength2 - 1);
    checkInt(this, value, offset, byteLength2, limit - 1, -limit);
  }
  let i = 0;
  let mul = 1;
  let sub = 0;
  this[offset] = value & 255;
  while (++i < byteLength2 && (mul *= 256)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1;
    }
    this[offset + i] = (value / mul >> 0) - sub & 255;
  }
  return offset + byteLength2;
};
Buffer2.prototype.writeIntBE = function writeIntBE(value, offset, byteLength2, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) {
    const limit = Math.pow(2, 8 * byteLength2 - 1);
    checkInt(this, value, offset, byteLength2, limit - 1, -limit);
  }
  let i = byteLength2 - 1;
  let mul = 1;
  let sub = 0;
  this[offset + i] = value & 255;
  while (--i >= 0 && (mul *= 256)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1;
    }
    this[offset + i] = (value / mul >> 0) - sub & 255;
  }
  return offset + byteLength2;
};
Buffer2.prototype.writeInt8 = function writeInt8(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 1, 127, -128);
  if (value < 0) value = 255 + value + 1;
  this[offset] = value & 255;
  return offset + 1;
};
Buffer2.prototype.writeInt16LE = function writeInt16LE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 2, 32767, -32768);
  this[offset] = value & 255;
  this[offset + 1] = value >>> 8;
  return offset + 2;
};
Buffer2.prototype.writeInt16BE = function writeInt16BE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 2, 32767, -32768);
  this[offset] = value >>> 8;
  this[offset + 1] = value & 255;
  return offset + 2;
};
Buffer2.prototype.writeInt32LE = function writeInt32LE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 4, 2147483647, -2147483648);
  this[offset] = value & 255;
  this[offset + 1] = value >>> 8;
  this[offset + 2] = value >>> 16;
  this[offset + 3] = value >>> 24;
  return offset + 4;
};
Buffer2.prototype.writeInt32BE = function writeInt32BE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 4, 2147483647, -2147483648);
  if (value < 0) value = 4294967295 + value + 1;
  this[offset] = value >>> 24;
  this[offset + 1] = value >>> 16;
  this[offset + 2] = value >>> 8;
  this[offset + 3] = value & 255;
  return offset + 4;
};
Buffer2.prototype.writeBigInt64LE = function writeBigInt64LE(value, offset = 0) {
  return wrtBigUInt64LE(this, value, offset, -BigInt("0x8000000000000000"), BigInt("0x7fffffffffffffff"));
};
Buffer2.prototype.writeBigInt64BE = function writeBigInt64BE(value, offset = 0) {
  return wrtBigUInt64BE(this, value, offset, -BigInt("0x8000000000000000"), BigInt("0x7fffffffffffffff"));
};
function checkIEEE754(buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError("Index out of range");
  if (offset < 0) throw new RangeError("Index out of range");
}
function writeFloat(buf, value, offset, littleEndian, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 34028234663852886e22, -34028234663852886e22);
  }
  write(buf, value, offset, littleEndian, 23, 4);
  return offset + 4;
}
Buffer2.prototype.writeFloatLE = function writeFloatLE(value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert);
};
Buffer2.prototype.writeFloatBE = function writeFloatBE(value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert);
};
function writeDouble(buf, value, offset, littleEndian, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 17976931348623157e292, -17976931348623157e292);
  }
  write(buf, value, offset, littleEndian, 52, 8);
  return offset + 8;
}
Buffer2.prototype.writeDoubleLE = function writeDoubleLE(value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert);
};
Buffer2.prototype.writeDoubleBE = function writeDoubleBE(value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert);
};
Buffer2.prototype.copy = function copy(target, targetStart, start, end) {
  if (!Buffer2.isBuffer(target)) throw new TypeError("argument should be a Buffer");
  if (!start) start = 0;
  if (!end && end !== 0) end = this.length;
  if (targetStart >= target.length) targetStart = target.length;
  if (!targetStart) targetStart = 0;
  if (end > 0 && end < start) end = start;
  if (end === start) return 0;
  if (target.length === 0 || this.length === 0) return 0;
  if (targetStart < 0) {
    throw new RangeError("targetStart out of bounds");
  }
  if (start < 0 || start >= this.length) throw new RangeError("Index out of range");
  if (end < 0) throw new RangeError("sourceEnd out of bounds");
  if (end > this.length) end = this.length;
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start;
  }
  const len = end - start;
  if (this === target) {
    this.copyWithin(targetStart, start, end);
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, end),
      targetStart
    );
  }
  return len;
};
Buffer2.prototype.fill = function fill(val, start, end, encoding) {
  if (typeof val === "string") {
    if (typeof start === "string") {
      encoding = start;
      start = 0;
      end = this.length;
    } else if (typeof end === "string") {
      encoding = end;
      end = this.length;
    }
    if (encoding !== void 0 && typeof encoding !== "string") {
      throw new TypeError("encoding must be a string");
    }
    if (typeof encoding === "string" && !Buffer2.isEncoding(encoding)) {
      throw new TypeError("Unknown encoding: " + encoding);
    }
    if (val.length === 1) {
      const code4 = val.charCodeAt(0);
      if (encoding === "utf8" && code4 < 128 || encoding === "latin1") {
        val = code4;
      }
    }
  } else if (typeof val === "number") {
    val = val & 255;
  } else if (typeof val === "boolean") {
    val = Number(val);
  }
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError("Out of range index");
  }
  if (end <= start) {
    return this;
  }
  start = start >>> 0;
  end = end === void 0 ? this.length : end >>> 0;
  if (!val) val = 0;
  let i;
  if (typeof val === "number") {
    for (i = start; i < end; ++i) {
      this[i] = val;
    }
  } else {
    const bytes = Buffer2.isBuffer(val) ? val : Buffer2.from(val, encoding);
    const len = bytes.length;
    if (len === 0) {
      throw new TypeError('The value "' + val + '" is invalid for argument "value"');
    }
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len];
    }
  }
  return this;
};
var errors = {};
function E(sym, getMessage, Base) {
  errors[sym] = class NodeError extends Base {
    constructor() {
      super();
      Object.defineProperty(this, "message", {
        value: getMessage.apply(this, arguments),
        writable: true,
        configurable: true
      });
      this.name = `${this.name} [${sym}]`;
      this.stack;
      delete this.name;
    }
    get code() {
      return sym;
    }
    set code(value) {
      Object.defineProperty(this, "code", {
        configurable: true,
        enumerable: true,
        value,
        writable: true
      });
    }
    toString() {
      return `${this.name} [${sym}]: ${this.message}`;
    }
  };
}
E(
  "ERR_BUFFER_OUT_OF_BOUNDS",
  function(name) {
    if (name) {
      return `${name} is outside of buffer bounds`;
    }
    return "Attempt to access memory outside buffer bounds";
  },
  RangeError
);
E(
  "ERR_INVALID_ARG_TYPE",
  function(name, actual) {
    return `The "${name}" argument must be of type number. Received type ${typeof actual}`;
  },
  TypeError
);
E(
  "ERR_OUT_OF_RANGE",
  function(str, range, input) {
    let msg = `The value of "${str}" is out of range.`;
    let received = input;
    if (Number.isInteger(input) && Math.abs(input) > 2 ** 32) {
      received = addNumericalSeparator(String(input));
    } else if (typeof input === "bigint") {
      received = String(input);
      if (input > BigInt(2) ** BigInt(32) || input < -(BigInt(2) ** BigInt(32))) {
        received = addNumericalSeparator(received);
      }
      received += "n";
    }
    msg += ` It must be ${range}. Received ${received}`;
    return msg;
  },
  RangeError
);
function addNumericalSeparator(val) {
  let res = "";
  let i = val.length;
  const start = val[0] === "-" ? 1 : 0;
  for (; i >= start + 4; i -= 3) {
    res = `_${val.slice(i - 3, i)}${res}`;
  }
  return `${val.slice(0, i)}${res}`;
}
function checkBounds(buf, offset, byteLength2) {
  validateNumber(offset, "offset");
  if (buf[offset] === void 0 || buf[offset + byteLength2] === void 0) {
    boundsError(offset, buf.length - (byteLength2 + 1));
  }
}
function checkIntBI(value, min, max, buf, offset, byteLength2) {
  if (value > max || value < min) {
    const n = typeof min === "bigint" ? "n" : "";
    let range;
    if (byteLength2 > 3) {
      if (min === 0 || min === BigInt(0)) {
        range = `>= 0${n} and < 2${n} ** ${(byteLength2 + 1) * 8}${n}`;
      } else {
        range = `>= -(2${n} ** ${(byteLength2 + 1) * 8 - 1}${n}) and < 2 ** ${(byteLength2 + 1) * 8 - 1}${n}`;
      }
    } else {
      range = `>= ${min}${n} and <= ${max}${n}`;
    }
    throw new errors.ERR_OUT_OF_RANGE("value", range, value);
  }
  checkBounds(buf, offset, byteLength2);
}
function validateNumber(value, name) {
  if (typeof value !== "number") {
    throw new errors.ERR_INVALID_ARG_TYPE(name, "number", value);
  }
}
function boundsError(value, length, type) {
  if (Math.floor(value) !== value) {
    validateNumber(value, type);
    throw new errors.ERR_OUT_OF_RANGE(type || "offset", "an integer", value);
  }
  if (length < 0) {
    throw new errors.ERR_BUFFER_OUT_OF_BOUNDS();
  }
  throw new errors.ERR_OUT_OF_RANGE(
    type || "offset",
    `>= ${type ? 1 : 0} and <= ${length}`,
    value
  );
}
var INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g;
function base64clean(str) {
  str = str.split("=")[0];
  str = str.trim().replace(INVALID_BASE64_RE, "");
  if (str.length < 2) return "";
  while (str.length % 4 !== 0) {
    str = str + "=";
  }
  return str;
}
function utf8ToBytes(string, units) {
  units = units || Infinity;
  let codePoint;
  const length = string.length;
  let leadSurrogate = null;
  const bytes = [];
  for (let i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i);
    if (codePoint > 55295 && codePoint < 57344) {
      if (!leadSurrogate) {
        if (codePoint > 56319) {
          if ((units -= 3) > -1) bytes.push(239, 191, 189);
          continue;
        } else if (i + 1 === length) {
          if ((units -= 3) > -1) bytes.push(239, 191, 189);
          continue;
        }
        leadSurrogate = codePoint;
        continue;
      }
      if (codePoint < 56320) {
        if ((units -= 3) > -1) bytes.push(239, 191, 189);
        leadSurrogate = codePoint;
        continue;
      }
      codePoint = (leadSurrogate - 55296 << 10 | codePoint - 56320) + 65536;
    } else if (leadSurrogate) {
      if ((units -= 3) > -1) bytes.push(239, 191, 189);
    }
    leadSurrogate = null;
    if (codePoint < 128) {
      if ((units -= 1) < 0) break;
      bytes.push(codePoint);
    } else if (codePoint < 2048) {
      if ((units -= 2) < 0) break;
      bytes.push(
        codePoint >> 6 | 192,
        codePoint & 63 | 128
      );
    } else if (codePoint < 65536) {
      if ((units -= 3) < 0) break;
      bytes.push(
        codePoint >> 12 | 224,
        codePoint >> 6 & 63 | 128,
        codePoint & 63 | 128
      );
    } else if (codePoint < 1114112) {
      if ((units -= 4) < 0) break;
      bytes.push(
        codePoint >> 18 | 240,
        codePoint >> 12 & 63 | 128,
        codePoint >> 6 & 63 | 128,
        codePoint & 63 | 128
      );
    } else {
      throw new Error("Invalid code point");
    }
  }
  return bytes;
}
function asciiToBytes(str) {
  const byteArray = [];
  for (let i = 0; i < str.length; ++i) {
    byteArray.push(str.charCodeAt(i) & 255);
  }
  return byteArray;
}
function utf16leToBytes(str, units) {
  let c, hi, lo;
  const byteArray = [];
  for (let i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break;
    c = str.charCodeAt(i);
    hi = c >> 8;
    lo = c % 256;
    byteArray.push(lo);
    byteArray.push(hi);
  }
  return byteArray;
}
function base64ToBytes(str) {
  return toByteArray(base64clean(str));
}
function blitBuffer(src, dst, offset, length) {
  let i;
  for (i = 0; i < length; ++i) {
    if (i + offset >= dst.length || i >= src.length) break;
    dst[i + offset] = src[i];
  }
  return i;
}
var hexSliceLookupTable = function() {
  const alphabet = "0123456789abcdef";
  const table = new Array(256);
  for (let i = 0; i < 16; ++i) {
    const i16 = i * 16;
    for (let j = 0; j < 16; ++j) {
      table[i16 + j] = alphabet[i] + alphabet[j];
    }
  }
  return table;
}();

// agent/shared/shared_structures.ts
var module_library_mapping = {};
var unwantedFDs = /* @__PURE__ */ new Set();
var AF_INET = 2;
var AF_INET6 = 10;
var pointerSize2 = Process.pointerSize;
var AddressFamilyMapping = {
  2: "AF_INET",
  // IPv4
  10: "AF_INET6",
  // IPv6
  1: "AF_UNIX",
  // Unix domain sockets
  17: "AF_PACKET"
  // Raw packets
  // Add other address families as needed
};

// agent/util/log.ts
function log(str) {
  var message = {};
  message["contentType"] = "console";
  message["console"] = str;
  send(message);
}
function devlog(str) {
  var message = {};
  message["contentType"] = "console_dev";
  message["console_dev"] = str;
  send(message);
}
function devlog_error(str) {
  var message = {};
  message["contentType"] = "console_error";
  message["console_error"] = str;
  send(message);
}

// node_modules/frida-java-bridge/lib/android.js
var android_exports = {};
__export(android_exports, {
  ArtMethod: () => ArtMethod,
  ArtStackVisitor: () => ArtStackVisitor,
  DVM_JNI_ENV_OFFSET_SELF: () => DVM_JNI_ENV_OFFSET_SELF,
  HandleVector: () => HandleVector,
  VariableSizedHandleScope: () => VariableSizedHandleScope,
  backtrace: () => backtrace,
  deoptimizeBootImage: () => deoptimizeBootImage,
  deoptimizeEverything: () => deoptimizeEverything,
  deoptimizeMethod: () => deoptimizeMethod,
  ensureClassInitialized: () => ensureClassInitialized,
  getAndroidApiLevel: () => getAndroidApiLevel,
  getAndroidVersion: () => getAndroidVersion,
  getApi: () => getApi,
  getArtClassSpec: () => getArtClassSpec,
  getArtFieldSpec: () => getArtFieldSpec,
  getArtMethodSpec: () => getArtMethodSpec,
  getArtThreadFromEnv: () => getArtThreadFromEnv,
  getArtThreadSpec: () => getArtThreadSpec,
  makeArtClassLoaderVisitor: () => makeArtClassLoaderVisitor,
  makeArtClassVisitor: () => makeArtClassVisitor,
  makeMethodMangler: () => makeMethodMangler,
  makeObjectVisitorPredicate: () => makeObjectVisitorPredicate,
  revertGlobalPatches: () => revertGlobalPatches,
  translateMethod: () => translateMethod,
  withAllArtThreadsSuspended: () => withAllArtThreadsSuspended,
  withRunnableArtThread: () => withRunnableArtThread
});

// node_modules/frida-java-bridge/lib/alloc.js
var {
  pageSize,
  pointerSize: pointerSize3
} = Process;
var CodeAllocator = class {
  constructor(sliceSize) {
    this.sliceSize = sliceSize;
    this.slicesPerPage = pageSize / sliceSize;
    this.pages = [];
    this.free = [];
  }
  allocateSlice(spec, alignment) {
    const anyLocation = spec.near === void 0;
    const anyAlignment = alignment === 1;
    if (anyLocation && anyAlignment) {
      const slice2 = this.free.pop();
      if (slice2 !== void 0) {
        return slice2;
      }
    } else if (alignment < pageSize) {
      const { free } = this;
      const n = free.length;
      const alignMask = anyAlignment ? null : ptr(alignment - 1);
      for (let i = 0; i !== n; i++) {
        const slice2 = free[i];
        const satisfiesLocation = anyLocation || this._isSliceNear(slice2, spec);
        const satisfiesAlignment = anyAlignment || slice2.and(alignMask).isNull();
        if (satisfiesLocation && satisfiesAlignment) {
          return free.splice(i, 1)[0];
        }
      }
    }
    return this._allocatePage(spec);
  }
  _allocatePage(spec) {
    const page = Memory.alloc(pageSize, spec);
    const { sliceSize, slicesPerPage } = this;
    for (let i = 1; i !== slicesPerPage; i++) {
      const slice2 = page.add(i * sliceSize);
      this.free.push(slice2);
    }
    this.pages.push(page);
    return page;
  }
  _isSliceNear(slice2, spec) {
    const sliceEnd = slice2.add(this.sliceSize);
    const { near, maxDistance } = spec;
    const startDistance = abs(near.sub(slice2));
    const endDistance = abs(near.sub(sliceEnd));
    return startDistance.compare(maxDistance) <= 0 && endDistance.compare(maxDistance) <= 0;
  }
  freeSlice(slice2) {
    this.free.push(slice2);
  }
};
function abs(nptr) {
  const shmt = pointerSize3 === 4 ? 31 : 63;
  const mask = ptr(1).shl(shmt).not();
  return nptr.and(mask);
}
function makeAllocator(sliceSize) {
  return new CodeAllocator(sliceSize);
}

// node_modules/frida-java-bridge/lib/result.js
var JNI_OK = 0;
function checkJniResult(name, result) {
  if (result !== JNI_OK) {
    throw new Error(name + " failed: " + result);
  }
}

// node_modules/frida-java-bridge/lib/jvmti.js
var jvmtiVersion = {
  v1_0: 805371904,
  v1_2: 805372416
};
var jvmtiCapabilities = {
  canTagObjects: 1
};
var { pointerSize: pointerSize4 } = Process;
var nativeFunctionOptions = {
  exceptions: "propagate"
};
function EnvJvmti(handle2, vm3) {
  this.handle = handle2;
  this.vm = vm3;
  this.vtable = handle2.readPointer();
}
EnvJvmti.prototype.deallocate = proxy(47, "int32", ["pointer", "pointer"], function(impl, mem) {
  return impl(this.handle, mem);
});
EnvJvmti.prototype.getLoadedClasses = proxy(78, "int32", ["pointer", "pointer", "pointer"], function(impl, classCountPtr, classesPtr) {
  const result = impl(this.handle, classCountPtr, classesPtr);
  checkJniResult("EnvJvmti::getLoadedClasses", result);
});
EnvJvmti.prototype.iterateOverInstancesOfClass = proxy(112, "int32", ["pointer", "pointer", "int", "pointer", "pointer"], function(impl, klass, objectFilter, heapObjectCallback, userData) {
  const result = impl(this.handle, klass, objectFilter, heapObjectCallback, userData);
  checkJniResult("EnvJvmti::iterateOverInstancesOfClass", result);
});
EnvJvmti.prototype.getObjectsWithTags = proxy(114, "int32", ["pointer", "int", "pointer", "pointer", "pointer", "pointer"], function(impl, tagCount, tags, countPtr, objectResultPtr, tagResultPtr) {
  const result = impl(this.handle, tagCount, tags, countPtr, objectResultPtr, tagResultPtr);
  checkJniResult("EnvJvmti::getObjectsWithTags", result);
});
EnvJvmti.prototype.addCapabilities = proxy(142, "int32", ["pointer", "pointer"], function(impl, capabilitiesPtr) {
  return impl(this.handle, capabilitiesPtr);
});
function proxy(offset, retType2, argTypes2, wrapper) {
  let impl = null;
  return function() {
    if (impl === null) {
      impl = new NativeFunction(this.vtable.add((offset - 1) * pointerSize4).readPointer(), retType2, argTypes2, nativeFunctionOptions);
    }
    let args = [impl];
    args = args.concat.apply(args, arguments);
    return wrapper.apply(this, args);
  };
}

// node_modules/frida-java-bridge/lib/machine-code.js
function parseInstructionsAt(address, tryParse, { limit }) {
  let cursor = address;
  let prevInsn = null;
  for (let i = 0; i !== limit; i++) {
    const insn = Instruction.parse(cursor);
    const value = tryParse(insn, prevInsn);
    if (value !== null) {
      return value;
    }
    cursor = insn.next;
    prevInsn = insn;
  }
  return null;
}

// node_modules/frida-java-bridge/lib/memoize.js
function memoize(compute) {
  let value = null;
  let computed = false;
  return function(...args) {
    if (!computed) {
      value = compute(...args);
      computed = true;
    }
    return value;
  };
}

// node_modules/frida-java-bridge/lib/env.js
function Env(handle2, vm3) {
  this.handle = handle2;
  this.vm = vm3;
}
var pointerSize5 = Process.pointerSize;
var JNI_ABORT = 2;
var CALL_CONSTRUCTOR_METHOD_OFFSET = 28;
var CALL_OBJECT_METHOD_OFFSET = 34;
var CALL_BOOLEAN_METHOD_OFFSET = 37;
var CALL_BYTE_METHOD_OFFSET = 40;
var CALL_CHAR_METHOD_OFFSET = 43;
var CALL_SHORT_METHOD_OFFSET = 46;
var CALL_INT_METHOD_OFFSET = 49;
var CALL_LONG_METHOD_OFFSET = 52;
var CALL_FLOAT_METHOD_OFFSET = 55;
var CALL_DOUBLE_METHOD_OFFSET = 58;
var CALL_VOID_METHOD_OFFSET = 61;
var CALL_NONVIRTUAL_OBJECT_METHOD_OFFSET = 64;
var CALL_NONVIRTUAL_BOOLEAN_METHOD_OFFSET = 67;
var CALL_NONVIRTUAL_BYTE_METHOD_OFFSET = 70;
var CALL_NONVIRTUAL_CHAR_METHOD_OFFSET = 73;
var CALL_NONVIRTUAL_SHORT_METHOD_OFFSET = 76;
var CALL_NONVIRTUAL_INT_METHOD_OFFSET = 79;
var CALL_NONVIRTUAL_LONG_METHOD_OFFSET = 82;
var CALL_NONVIRTUAL_FLOAT_METHOD_OFFSET = 85;
var CALL_NONVIRTUAL_DOUBLE_METHOD_OFFSET = 88;
var CALL_NONVIRTUAL_VOID_METHOD_OFFSET = 91;
var CALL_STATIC_OBJECT_METHOD_OFFSET = 114;
var CALL_STATIC_BOOLEAN_METHOD_OFFSET = 117;
var CALL_STATIC_BYTE_METHOD_OFFSET = 120;
var CALL_STATIC_CHAR_METHOD_OFFSET = 123;
var CALL_STATIC_SHORT_METHOD_OFFSET = 126;
var CALL_STATIC_INT_METHOD_OFFSET = 129;
var CALL_STATIC_LONG_METHOD_OFFSET = 132;
var CALL_STATIC_FLOAT_METHOD_OFFSET = 135;
var CALL_STATIC_DOUBLE_METHOD_OFFSET = 138;
var CALL_STATIC_VOID_METHOD_OFFSET = 141;
var GET_OBJECT_FIELD_OFFSET = 95;
var GET_BOOLEAN_FIELD_OFFSET = 96;
var GET_BYTE_FIELD_OFFSET = 97;
var GET_CHAR_FIELD_OFFSET = 98;
var GET_SHORT_FIELD_OFFSET = 99;
var GET_INT_FIELD_OFFSET = 100;
var GET_LONG_FIELD_OFFSET = 101;
var GET_FLOAT_FIELD_OFFSET = 102;
var GET_DOUBLE_FIELD_OFFSET = 103;
var SET_OBJECT_FIELD_OFFSET = 104;
var SET_BOOLEAN_FIELD_OFFSET = 105;
var SET_BYTE_FIELD_OFFSET = 106;
var SET_CHAR_FIELD_OFFSET = 107;
var SET_SHORT_FIELD_OFFSET = 108;
var SET_INT_FIELD_OFFSET = 109;
var SET_LONG_FIELD_OFFSET = 110;
var SET_FLOAT_FIELD_OFFSET = 111;
var SET_DOUBLE_FIELD_OFFSET = 112;
var GET_STATIC_OBJECT_FIELD_OFFSET = 145;
var GET_STATIC_BOOLEAN_FIELD_OFFSET = 146;
var GET_STATIC_BYTE_FIELD_OFFSET = 147;
var GET_STATIC_CHAR_FIELD_OFFSET = 148;
var GET_STATIC_SHORT_FIELD_OFFSET = 149;
var GET_STATIC_INT_FIELD_OFFSET = 150;
var GET_STATIC_LONG_FIELD_OFFSET = 151;
var GET_STATIC_FLOAT_FIELD_OFFSET = 152;
var GET_STATIC_DOUBLE_FIELD_OFFSET = 153;
var SET_STATIC_OBJECT_FIELD_OFFSET = 154;
var SET_STATIC_BOOLEAN_FIELD_OFFSET = 155;
var SET_STATIC_BYTE_FIELD_OFFSET = 156;
var SET_STATIC_CHAR_FIELD_OFFSET = 157;
var SET_STATIC_SHORT_FIELD_OFFSET = 158;
var SET_STATIC_INT_FIELD_OFFSET = 159;
var SET_STATIC_LONG_FIELD_OFFSET = 160;
var SET_STATIC_FLOAT_FIELD_OFFSET = 161;
var SET_STATIC_DOUBLE_FIELD_OFFSET = 162;
var callMethodOffset = {
  pointer: CALL_OBJECT_METHOD_OFFSET,
  uint8: CALL_BOOLEAN_METHOD_OFFSET,
  int8: CALL_BYTE_METHOD_OFFSET,
  uint16: CALL_CHAR_METHOD_OFFSET,
  int16: CALL_SHORT_METHOD_OFFSET,
  int32: CALL_INT_METHOD_OFFSET,
  int64: CALL_LONG_METHOD_OFFSET,
  float: CALL_FLOAT_METHOD_OFFSET,
  double: CALL_DOUBLE_METHOD_OFFSET,
  void: CALL_VOID_METHOD_OFFSET
};
var callNonvirtualMethodOffset = {
  pointer: CALL_NONVIRTUAL_OBJECT_METHOD_OFFSET,
  uint8: CALL_NONVIRTUAL_BOOLEAN_METHOD_OFFSET,
  int8: CALL_NONVIRTUAL_BYTE_METHOD_OFFSET,
  uint16: CALL_NONVIRTUAL_CHAR_METHOD_OFFSET,
  int16: CALL_NONVIRTUAL_SHORT_METHOD_OFFSET,
  int32: CALL_NONVIRTUAL_INT_METHOD_OFFSET,
  int64: CALL_NONVIRTUAL_LONG_METHOD_OFFSET,
  float: CALL_NONVIRTUAL_FLOAT_METHOD_OFFSET,
  double: CALL_NONVIRTUAL_DOUBLE_METHOD_OFFSET,
  void: CALL_NONVIRTUAL_VOID_METHOD_OFFSET
};
var callStaticMethodOffset = {
  pointer: CALL_STATIC_OBJECT_METHOD_OFFSET,
  uint8: CALL_STATIC_BOOLEAN_METHOD_OFFSET,
  int8: CALL_STATIC_BYTE_METHOD_OFFSET,
  uint16: CALL_STATIC_CHAR_METHOD_OFFSET,
  int16: CALL_STATIC_SHORT_METHOD_OFFSET,
  int32: CALL_STATIC_INT_METHOD_OFFSET,
  int64: CALL_STATIC_LONG_METHOD_OFFSET,
  float: CALL_STATIC_FLOAT_METHOD_OFFSET,
  double: CALL_STATIC_DOUBLE_METHOD_OFFSET,
  void: CALL_STATIC_VOID_METHOD_OFFSET
};
var getFieldOffset = {
  pointer: GET_OBJECT_FIELD_OFFSET,
  uint8: GET_BOOLEAN_FIELD_OFFSET,
  int8: GET_BYTE_FIELD_OFFSET,
  uint16: GET_CHAR_FIELD_OFFSET,
  int16: GET_SHORT_FIELD_OFFSET,
  int32: GET_INT_FIELD_OFFSET,
  int64: GET_LONG_FIELD_OFFSET,
  float: GET_FLOAT_FIELD_OFFSET,
  double: GET_DOUBLE_FIELD_OFFSET
};
var setFieldOffset = {
  pointer: SET_OBJECT_FIELD_OFFSET,
  uint8: SET_BOOLEAN_FIELD_OFFSET,
  int8: SET_BYTE_FIELD_OFFSET,
  uint16: SET_CHAR_FIELD_OFFSET,
  int16: SET_SHORT_FIELD_OFFSET,
  int32: SET_INT_FIELD_OFFSET,
  int64: SET_LONG_FIELD_OFFSET,
  float: SET_FLOAT_FIELD_OFFSET,
  double: SET_DOUBLE_FIELD_OFFSET
};
var getStaticFieldOffset = {
  pointer: GET_STATIC_OBJECT_FIELD_OFFSET,
  uint8: GET_STATIC_BOOLEAN_FIELD_OFFSET,
  int8: GET_STATIC_BYTE_FIELD_OFFSET,
  uint16: GET_STATIC_CHAR_FIELD_OFFSET,
  int16: GET_STATIC_SHORT_FIELD_OFFSET,
  int32: GET_STATIC_INT_FIELD_OFFSET,
  int64: GET_STATIC_LONG_FIELD_OFFSET,
  float: GET_STATIC_FLOAT_FIELD_OFFSET,
  double: GET_STATIC_DOUBLE_FIELD_OFFSET
};
var setStaticFieldOffset = {
  pointer: SET_STATIC_OBJECT_FIELD_OFFSET,
  uint8: SET_STATIC_BOOLEAN_FIELD_OFFSET,
  int8: SET_STATIC_BYTE_FIELD_OFFSET,
  uint16: SET_STATIC_CHAR_FIELD_OFFSET,
  int16: SET_STATIC_SHORT_FIELD_OFFSET,
  int32: SET_STATIC_INT_FIELD_OFFSET,
  int64: SET_STATIC_LONG_FIELD_OFFSET,
  float: SET_STATIC_FLOAT_FIELD_OFFSET,
  double: SET_STATIC_DOUBLE_FIELD_OFFSET
};
var nativeFunctionOptions2 = {
  exceptions: "propagate"
};
var cachedVtable = null;
var globalRefs = [];
Env.dispose = function(env) {
  globalRefs.forEach(env.deleteGlobalRef, env);
  globalRefs = [];
};
function register(globalRef) {
  globalRefs.push(globalRef);
  return globalRef;
}
function vtable(instance) {
  if (cachedVtable === null) {
    cachedVtable = instance.handle.readPointer();
  }
  return cachedVtable;
}
function proxy2(offset, retType2, argTypes2, wrapper) {
  let impl = null;
  return function() {
    if (impl === null) {
      impl = new NativeFunction(vtable(this).add(offset * pointerSize5).readPointer(), retType2, argTypes2, nativeFunctionOptions2);
    }
    let args = [impl];
    args = args.concat.apply(args, arguments);
    return wrapper.apply(this, args);
  };
}
Env.prototype.getVersion = proxy2(4, "int32", ["pointer"], function(impl) {
  return impl(this.handle);
});
Env.prototype.findClass = proxy2(6, "pointer", ["pointer", "pointer"], function(impl, name) {
  const result = impl(this.handle, Memory.allocUtf8String(name));
  this.throwIfExceptionPending();
  return result;
});
Env.prototype.throwIfExceptionPending = function() {
  const throwable = this.exceptionOccurred();
  if (throwable.isNull()) {
    return;
  }
  this.exceptionClear();
  const handle2 = this.newGlobalRef(throwable);
  this.deleteLocalRef(throwable);
  const description = this.vaMethod("pointer", [])(this.handle, handle2, this.javaLangObject().toString);
  const descriptionStr = this.stringFromJni(description);
  this.deleteLocalRef(description);
  const error = new Error(descriptionStr);
  error.$h = handle2;
  Script.bindWeak(error, makeErrorHandleDestructor(this.vm, handle2));
  throw error;
};
function makeErrorHandleDestructor(vm3, handle2) {
  return function() {
    vm3.perform((env) => {
      env.deleteGlobalRef(handle2);
    });
  };
}
Env.prototype.fromReflectedMethod = proxy2(7, "pointer", ["pointer", "pointer"], function(impl, method2) {
  return impl(this.handle, method2);
});
Env.prototype.fromReflectedField = proxy2(8, "pointer", ["pointer", "pointer"], function(impl, method2) {
  return impl(this.handle, method2);
});
Env.prototype.toReflectedMethod = proxy2(9, "pointer", ["pointer", "pointer", "pointer", "uint8"], function(impl, klass, methodId, isStatic) {
  return impl(this.handle, klass, methodId, isStatic);
});
Env.prototype.getSuperclass = proxy2(10, "pointer", ["pointer", "pointer"], function(impl, klass) {
  return impl(this.handle, klass);
});
Env.prototype.isAssignableFrom = proxy2(11, "uint8", ["pointer", "pointer", "pointer"], function(impl, klass1, klass2) {
  return !!impl(this.handle, klass1, klass2);
});
Env.prototype.toReflectedField = proxy2(12, "pointer", ["pointer", "pointer", "pointer", "uint8"], function(impl, klass, fieldId, isStatic) {
  return impl(this.handle, klass, fieldId, isStatic);
});
Env.prototype.throw = proxy2(13, "int32", ["pointer", "pointer"], function(impl, obj) {
  return impl(this.handle, obj);
});
Env.prototype.exceptionOccurred = proxy2(15, "pointer", ["pointer"], function(impl) {
  return impl(this.handle);
});
Env.prototype.exceptionDescribe = proxy2(16, "void", ["pointer"], function(impl) {
  impl(this.handle);
});
Env.prototype.exceptionClear = proxy2(17, "void", ["pointer"], function(impl) {
  impl(this.handle);
});
Env.prototype.pushLocalFrame = proxy2(19, "int32", ["pointer", "int32"], function(impl, capacity) {
  return impl(this.handle, capacity);
});
Env.prototype.popLocalFrame = proxy2(20, "pointer", ["pointer", "pointer"], function(impl, result) {
  return impl(this.handle, result);
});
Env.prototype.newGlobalRef = proxy2(21, "pointer", ["pointer", "pointer"], function(impl, obj) {
  return impl(this.handle, obj);
});
Env.prototype.deleteGlobalRef = proxy2(22, "void", ["pointer", "pointer"], function(impl, globalRef) {
  impl(this.handle, globalRef);
});
Env.prototype.deleteLocalRef = proxy2(23, "void", ["pointer", "pointer"], function(impl, localRef) {
  impl(this.handle, localRef);
});
Env.prototype.isSameObject = proxy2(24, "uint8", ["pointer", "pointer", "pointer"], function(impl, ref1, ref2) {
  return !!impl(this.handle, ref1, ref2);
});
Env.prototype.newLocalRef = proxy2(25, "pointer", ["pointer", "pointer"], function(impl, obj) {
  return impl(this.handle, obj);
});
Env.prototype.allocObject = proxy2(27, "pointer", ["pointer", "pointer"], function(impl, clazz) {
  return impl(this.handle, clazz);
});
Env.prototype.getObjectClass = proxy2(31, "pointer", ["pointer", "pointer"], function(impl, obj) {
  return impl(this.handle, obj);
});
Env.prototype.isInstanceOf = proxy2(32, "uint8", ["pointer", "pointer", "pointer"], function(impl, obj, klass) {
  return !!impl(this.handle, obj, klass);
});
Env.prototype.getMethodId = proxy2(33, "pointer", ["pointer", "pointer", "pointer", "pointer"], function(impl, klass, name, sig) {
  return impl(this.handle, klass, Memory.allocUtf8String(name), Memory.allocUtf8String(sig));
});
Env.prototype.getFieldId = proxy2(94, "pointer", ["pointer", "pointer", "pointer", "pointer"], function(impl, klass, name, sig) {
  return impl(this.handle, klass, Memory.allocUtf8String(name), Memory.allocUtf8String(sig));
});
Env.prototype.getIntField = proxy2(100, "int32", ["pointer", "pointer", "pointer"], function(impl, obj, fieldId) {
  return impl(this.handle, obj, fieldId);
});
Env.prototype.getStaticMethodId = proxy2(113, "pointer", ["pointer", "pointer", "pointer", "pointer"], function(impl, klass, name, sig) {
  return impl(this.handle, klass, Memory.allocUtf8String(name), Memory.allocUtf8String(sig));
});
Env.prototype.getStaticFieldId = proxy2(144, "pointer", ["pointer", "pointer", "pointer", "pointer"], function(impl, klass, name, sig) {
  return impl(this.handle, klass, Memory.allocUtf8String(name), Memory.allocUtf8String(sig));
});
Env.prototype.getStaticIntField = proxy2(150, "int32", ["pointer", "pointer", "pointer"], function(impl, obj, fieldId) {
  return impl(this.handle, obj, fieldId);
});
Env.prototype.getStringLength = proxy2(164, "int32", ["pointer", "pointer"], function(impl, str) {
  return impl(this.handle, str);
});
Env.prototype.getStringChars = proxy2(165, "pointer", ["pointer", "pointer", "pointer"], function(impl, str) {
  return impl(this.handle, str, NULL);
});
Env.prototype.releaseStringChars = proxy2(166, "void", ["pointer", "pointer", "pointer"], function(impl, str, utf) {
  impl(this.handle, str, utf);
});
Env.prototype.newStringUtf = proxy2(167, "pointer", ["pointer", "pointer"], function(impl, str) {
  const utf = Memory.allocUtf8String(str);
  return impl(this.handle, utf);
});
Env.prototype.getStringUtfChars = proxy2(169, "pointer", ["pointer", "pointer", "pointer"], function(impl, str) {
  return impl(this.handle, str, NULL);
});
Env.prototype.releaseStringUtfChars = proxy2(170, "void", ["pointer", "pointer", "pointer"], function(impl, str, utf) {
  impl(this.handle, str, utf);
});
Env.prototype.getArrayLength = proxy2(171, "int32", ["pointer", "pointer"], function(impl, array) {
  return impl(this.handle, array);
});
Env.prototype.newObjectArray = proxy2(172, "pointer", ["pointer", "int32", "pointer", "pointer"], function(impl, length, elementClass, initialElement) {
  return impl(this.handle, length, elementClass, initialElement);
});
Env.prototype.getObjectArrayElement = proxy2(173, "pointer", ["pointer", "pointer", "int32"], function(impl, array, index) {
  return impl(this.handle, array, index);
});
Env.prototype.setObjectArrayElement = proxy2(174, "void", ["pointer", "pointer", "int32", "pointer"], function(impl, array, index, value) {
  impl(this.handle, array, index, value);
});
Env.prototype.newBooleanArray = proxy2(175, "pointer", ["pointer", "int32"], function(impl, length) {
  return impl(this.handle, length);
});
Env.prototype.newByteArray = proxy2(176, "pointer", ["pointer", "int32"], function(impl, length) {
  return impl(this.handle, length);
});
Env.prototype.newCharArray = proxy2(177, "pointer", ["pointer", "int32"], function(impl, length) {
  return impl(this.handle, length);
});
Env.prototype.newShortArray = proxy2(178, "pointer", ["pointer", "int32"], function(impl, length) {
  return impl(this.handle, length);
});
Env.prototype.newIntArray = proxy2(179, "pointer", ["pointer", "int32"], function(impl, length) {
  return impl(this.handle, length);
});
Env.prototype.newLongArray = proxy2(180, "pointer", ["pointer", "int32"], function(impl, length) {
  return impl(this.handle, length);
});
Env.prototype.newFloatArray = proxy2(181, "pointer", ["pointer", "int32"], function(impl, length) {
  return impl(this.handle, length);
});
Env.prototype.newDoubleArray = proxy2(182, "pointer", ["pointer", "int32"], function(impl, length) {
  return impl(this.handle, length);
});
Env.prototype.getBooleanArrayElements = proxy2(183, "pointer", ["pointer", "pointer", "pointer"], function(impl, array) {
  return impl(this.handle, array, NULL);
});
Env.prototype.getByteArrayElements = proxy2(184, "pointer", ["pointer", "pointer", "pointer"], function(impl, array) {
  return impl(this.handle, array, NULL);
});
Env.prototype.getCharArrayElements = proxy2(185, "pointer", ["pointer", "pointer", "pointer"], function(impl, array) {
  return impl(this.handle, array, NULL);
});
Env.prototype.getShortArrayElements = proxy2(186, "pointer", ["pointer", "pointer", "pointer"], function(impl, array) {
  return impl(this.handle, array, NULL);
});
Env.prototype.getIntArrayElements = proxy2(187, "pointer", ["pointer", "pointer", "pointer"], function(impl, array) {
  return impl(this.handle, array, NULL);
});
Env.prototype.getLongArrayElements = proxy2(188, "pointer", ["pointer", "pointer", "pointer"], function(impl, array) {
  return impl(this.handle, array, NULL);
});
Env.prototype.getFloatArrayElements = proxy2(189, "pointer", ["pointer", "pointer", "pointer"], function(impl, array) {
  return impl(this.handle, array, NULL);
});
Env.prototype.getDoubleArrayElements = proxy2(190, "pointer", ["pointer", "pointer", "pointer"], function(impl, array) {
  return impl(this.handle, array, NULL);
});
Env.prototype.releaseBooleanArrayElements = proxy2(191, "pointer", ["pointer", "pointer", "pointer", "int32"], function(impl, array, cArray) {
  impl(this.handle, array, cArray, JNI_ABORT);
});
Env.prototype.releaseByteArrayElements = proxy2(192, "pointer", ["pointer", "pointer", "pointer", "int32"], function(impl, array, cArray) {
  impl(this.handle, array, cArray, JNI_ABORT);
});
Env.prototype.releaseCharArrayElements = proxy2(193, "pointer", ["pointer", "pointer", "pointer", "int32"], function(impl, array, cArray) {
  impl(this.handle, array, cArray, JNI_ABORT);
});
Env.prototype.releaseShortArrayElements = proxy2(194, "pointer", ["pointer", "pointer", "pointer", "int32"], function(impl, array, cArray) {
  impl(this.handle, array, cArray, JNI_ABORT);
});
Env.prototype.releaseIntArrayElements = proxy2(195, "pointer", ["pointer", "pointer", "pointer", "int32"], function(impl, array, cArray) {
  impl(this.handle, array, cArray, JNI_ABORT);
});
Env.prototype.releaseLongArrayElements = proxy2(196, "pointer", ["pointer", "pointer", "pointer", "int32"], function(impl, array, cArray) {
  impl(this.handle, array, cArray, JNI_ABORT);
});
Env.prototype.releaseFloatArrayElements = proxy2(197, "pointer", ["pointer", "pointer", "pointer", "int32"], function(impl, array, cArray) {
  impl(this.handle, array, cArray, JNI_ABORT);
});
Env.prototype.releaseDoubleArrayElements = proxy2(198, "pointer", ["pointer", "pointer", "pointer", "int32"], function(impl, array, cArray) {
  impl(this.handle, array, cArray, JNI_ABORT);
});
Env.prototype.getByteArrayRegion = proxy2(200, "void", ["pointer", "pointer", "int", "int", "pointer"], function(impl, array, start, length, cArray) {
  impl(this.handle, array, start, length, cArray);
});
Env.prototype.setBooleanArrayRegion = proxy2(207, "void", ["pointer", "pointer", "int32", "int32", "pointer"], function(impl, array, start, length, cArray) {
  impl(this.handle, array, start, length, cArray);
});
Env.prototype.setByteArrayRegion = proxy2(208, "void", ["pointer", "pointer", "int32", "int32", "pointer"], function(impl, array, start, length, cArray) {
  impl(this.handle, array, start, length, cArray);
});
Env.prototype.setCharArrayRegion = proxy2(209, "void", ["pointer", "pointer", "int32", "int32", "pointer"], function(impl, array, start, length, cArray) {
  impl(this.handle, array, start, length, cArray);
});
Env.prototype.setShortArrayRegion = proxy2(210, "void", ["pointer", "pointer", "int32", "int32", "pointer"], function(impl, array, start, length, cArray) {
  impl(this.handle, array, start, length, cArray);
});
Env.prototype.setIntArrayRegion = proxy2(211, "void", ["pointer", "pointer", "int32", "int32", "pointer"], function(impl, array, start, length, cArray) {
  impl(this.handle, array, start, length, cArray);
});
Env.prototype.setLongArrayRegion = proxy2(212, "void", ["pointer", "pointer", "int32", "int32", "pointer"], function(impl, array, start, length, cArray) {
  impl(this.handle, array, start, length, cArray);
});
Env.prototype.setFloatArrayRegion = proxy2(213, "void", ["pointer", "pointer", "int32", "int32", "pointer"], function(impl, array, start, length, cArray) {
  impl(this.handle, array, start, length, cArray);
});
Env.prototype.setDoubleArrayRegion = proxy2(214, "void", ["pointer", "pointer", "int32", "int32", "pointer"], function(impl, array, start, length, cArray) {
  impl(this.handle, array, start, length, cArray);
});
Env.prototype.registerNatives = proxy2(215, "int32", ["pointer", "pointer", "pointer", "int32"], function(impl, klass, methods, numMethods) {
  return impl(this.handle, klass, methods, numMethods);
});
Env.prototype.monitorEnter = proxy2(217, "int32", ["pointer", "pointer"], function(impl, obj) {
  return impl(this.handle, obj);
});
Env.prototype.monitorExit = proxy2(218, "int32", ["pointer", "pointer"], function(impl, obj) {
  return impl(this.handle, obj);
});
Env.prototype.getDirectBufferAddress = proxy2(230, "pointer", ["pointer", "pointer"], function(impl, obj) {
  return impl(this.handle, obj);
});
Env.prototype.getObjectRefType = proxy2(232, "int32", ["pointer", "pointer"], function(impl, ref) {
  return impl(this.handle, ref);
});
var cachedMethods = /* @__PURE__ */ new Map();
function plainMethod(offset, retType2, argTypes2, options) {
  return getOrMakeMethod(this, "p", makePlainMethod, offset, retType2, argTypes2, options);
}
function vaMethod(offset, retType2, argTypes2, options) {
  return getOrMakeMethod(this, "v", makeVaMethod, offset, retType2, argTypes2, options);
}
function nonvirtualVaMethod(offset, retType2, argTypes2, options) {
  return getOrMakeMethod(this, "n", makeNonvirtualVaMethod, offset, retType2, argTypes2, options);
}
function getOrMakeMethod(env, flavor, construct, offset, retType2, argTypes2, options) {
  if (options !== void 0) {
    return construct(env, offset, retType2, argTypes2, options);
  }
  const key = [offset, flavor, retType2].concat(argTypes2).join("|");
  let m2 = cachedMethods.get(key);
  if (m2 === void 0) {
    m2 = construct(env, offset, retType2, argTypes2, nativeFunctionOptions2);
    cachedMethods.set(key, m2);
  }
  return m2;
}
function makePlainMethod(env, offset, retType2, argTypes2, options) {
  return new NativeFunction(
    vtable(env).add(offset * pointerSize5).readPointer(),
    retType2,
    ["pointer", "pointer", "pointer"].concat(argTypes2),
    options
  );
}
function makeVaMethod(env, offset, retType2, argTypes2, options) {
  return new NativeFunction(
    vtable(env).add(offset * pointerSize5).readPointer(),
    retType2,
    ["pointer", "pointer", "pointer", "..."].concat(argTypes2),
    options
  );
}
function makeNonvirtualVaMethod(env, offset, retType2, argTypes2, options) {
  return new NativeFunction(
    vtable(env).add(offset * pointerSize5).readPointer(),
    retType2,
    ["pointer", "pointer", "pointer", "pointer", "..."].concat(argTypes2),
    options
  );
}
Env.prototype.constructor = function(argTypes2, options) {
  return vaMethod.call(this, CALL_CONSTRUCTOR_METHOD_OFFSET, "pointer", argTypes2, options);
};
Env.prototype.vaMethod = function(retType2, argTypes2, options) {
  const offset = callMethodOffset[retType2];
  if (offset === void 0) {
    throw new Error("Unsupported type: " + retType2);
  }
  return vaMethod.call(this, offset, retType2, argTypes2, options);
};
Env.prototype.nonvirtualVaMethod = function(retType2, argTypes2, options) {
  const offset = callNonvirtualMethodOffset[retType2];
  if (offset === void 0) {
    throw new Error("Unsupported type: " + retType2);
  }
  return nonvirtualVaMethod.call(this, offset, retType2, argTypes2, options);
};
Env.prototype.staticVaMethod = function(retType2, argTypes2, options) {
  const offset = callStaticMethodOffset[retType2];
  if (offset === void 0) {
    throw new Error("Unsupported type: " + retType2);
  }
  return vaMethod.call(this, offset, retType2, argTypes2, options);
};
Env.prototype.getField = function(fieldType) {
  const offset = getFieldOffset[fieldType];
  if (offset === void 0) {
    throw new Error("Unsupported type: " + fieldType);
  }
  return plainMethod.call(this, offset, fieldType, []);
};
Env.prototype.getStaticField = function(fieldType) {
  const offset = getStaticFieldOffset[fieldType];
  if (offset === void 0) {
    throw new Error("Unsupported type: " + fieldType);
  }
  return plainMethod.call(this, offset, fieldType, []);
};
Env.prototype.setField = function(fieldType) {
  const offset = setFieldOffset[fieldType];
  if (offset === void 0) {
    throw new Error("Unsupported type: " + fieldType);
  }
  return plainMethod.call(this, offset, "void", [fieldType]);
};
Env.prototype.setStaticField = function(fieldType) {
  const offset = setStaticFieldOffset[fieldType];
  if (offset === void 0) {
    throw new Error("Unsupported type: " + fieldType);
  }
  return plainMethod.call(this, offset, "void", [fieldType]);
};
var javaLangClass = null;
Env.prototype.javaLangClass = function() {
  if (javaLangClass === null) {
    const handle2 = this.findClass("java/lang/Class");
    try {
      const get2 = this.getMethodId.bind(this, handle2);
      javaLangClass = {
        handle: register(this.newGlobalRef(handle2)),
        getName: get2("getName", "()Ljava/lang/String;"),
        getSimpleName: get2("getSimpleName", "()Ljava/lang/String;"),
        getGenericSuperclass: get2("getGenericSuperclass", "()Ljava/lang/reflect/Type;"),
        getDeclaredConstructors: get2("getDeclaredConstructors", "()[Ljava/lang/reflect/Constructor;"),
        getDeclaredMethods: get2("getDeclaredMethods", "()[Ljava/lang/reflect/Method;"),
        getDeclaredFields: get2("getDeclaredFields", "()[Ljava/lang/reflect/Field;"),
        isArray: get2("isArray", "()Z"),
        isPrimitive: get2("isPrimitive", "()Z"),
        isInterface: get2("isInterface", "()Z"),
        getComponentType: get2("getComponentType", "()Ljava/lang/Class;")
      };
    } finally {
      this.deleteLocalRef(handle2);
    }
  }
  return javaLangClass;
};
var javaLangObject = null;
Env.prototype.javaLangObject = function() {
  if (javaLangObject === null) {
    const handle2 = this.findClass("java/lang/Object");
    try {
      const get2 = this.getMethodId.bind(this, handle2);
      javaLangObject = {
        handle: register(this.newGlobalRef(handle2)),
        toString: get2("toString", "()Ljava/lang/String;"),
        getClass: get2("getClass", "()Ljava/lang/Class;")
      };
    } finally {
      this.deleteLocalRef(handle2);
    }
  }
  return javaLangObject;
};
var javaLangReflectConstructor = null;
Env.prototype.javaLangReflectConstructor = function() {
  if (javaLangReflectConstructor === null) {
    const handle2 = this.findClass("java/lang/reflect/Constructor");
    try {
      javaLangReflectConstructor = {
        getGenericParameterTypes: this.getMethodId(handle2, "getGenericParameterTypes", "()[Ljava/lang/reflect/Type;")
      };
    } finally {
      this.deleteLocalRef(handle2);
    }
  }
  return javaLangReflectConstructor;
};
var javaLangReflectMethod = null;
Env.prototype.javaLangReflectMethod = function() {
  if (javaLangReflectMethod === null) {
    const handle2 = this.findClass("java/lang/reflect/Method");
    try {
      const get2 = this.getMethodId.bind(this, handle2);
      javaLangReflectMethod = {
        getName: get2("getName", "()Ljava/lang/String;"),
        getGenericParameterTypes: get2("getGenericParameterTypes", "()[Ljava/lang/reflect/Type;"),
        getParameterTypes: get2("getParameterTypes", "()[Ljava/lang/Class;"),
        getGenericReturnType: get2("getGenericReturnType", "()Ljava/lang/reflect/Type;"),
        getGenericExceptionTypes: get2("getGenericExceptionTypes", "()[Ljava/lang/reflect/Type;"),
        getModifiers: get2("getModifiers", "()I"),
        isVarArgs: get2("isVarArgs", "()Z")
      };
    } finally {
      this.deleteLocalRef(handle2);
    }
  }
  return javaLangReflectMethod;
};
var javaLangReflectField = null;
Env.prototype.javaLangReflectField = function() {
  if (javaLangReflectField === null) {
    const handle2 = this.findClass("java/lang/reflect/Field");
    try {
      const get2 = this.getMethodId.bind(this, handle2);
      javaLangReflectField = {
        getName: get2("getName", "()Ljava/lang/String;"),
        getType: get2("getType", "()Ljava/lang/Class;"),
        getGenericType: get2("getGenericType", "()Ljava/lang/reflect/Type;"),
        getModifiers: get2("getModifiers", "()I"),
        toString: get2("toString", "()Ljava/lang/String;")
      };
    } finally {
      this.deleteLocalRef(handle2);
    }
  }
  return javaLangReflectField;
};
var javaLangReflectTypeVariable = null;
Env.prototype.javaLangReflectTypeVariable = function() {
  if (javaLangReflectTypeVariable === null) {
    const handle2 = this.findClass("java/lang/reflect/TypeVariable");
    try {
      const get2 = this.getMethodId.bind(this, handle2);
      javaLangReflectTypeVariable = {
        handle: register(this.newGlobalRef(handle2)),
        getName: get2("getName", "()Ljava/lang/String;"),
        getBounds: get2("getBounds", "()[Ljava/lang/reflect/Type;"),
        getGenericDeclaration: get2("getGenericDeclaration", "()Ljava/lang/reflect/GenericDeclaration;")
      };
    } finally {
      this.deleteLocalRef(handle2);
    }
  }
  return javaLangReflectTypeVariable;
};
var javaLangReflectWildcardType = null;
Env.prototype.javaLangReflectWildcardType = function() {
  if (javaLangReflectWildcardType === null) {
    const handle2 = this.findClass("java/lang/reflect/WildcardType");
    try {
      const get2 = this.getMethodId.bind(this, handle2);
      javaLangReflectWildcardType = {
        handle: register(this.newGlobalRef(handle2)),
        getLowerBounds: get2("getLowerBounds", "()[Ljava/lang/reflect/Type;"),
        getUpperBounds: get2("getUpperBounds", "()[Ljava/lang/reflect/Type;")
      };
    } finally {
      this.deleteLocalRef(handle2);
    }
  }
  return javaLangReflectWildcardType;
};
var javaLangReflectGenericArrayType = null;
Env.prototype.javaLangReflectGenericArrayType = function() {
  if (javaLangReflectGenericArrayType === null) {
    const handle2 = this.findClass("java/lang/reflect/GenericArrayType");
    try {
      javaLangReflectGenericArrayType = {
        handle: register(this.newGlobalRef(handle2)),
        getGenericComponentType: this.getMethodId(handle2, "getGenericComponentType", "()Ljava/lang/reflect/Type;")
      };
    } finally {
      this.deleteLocalRef(handle2);
    }
  }
  return javaLangReflectGenericArrayType;
};
var javaLangReflectParameterizedType = null;
Env.prototype.javaLangReflectParameterizedType = function() {
  if (javaLangReflectParameterizedType === null) {
    const handle2 = this.findClass("java/lang/reflect/ParameterizedType");
    try {
      const get2 = this.getMethodId.bind(this, handle2);
      javaLangReflectParameterizedType = {
        handle: register(this.newGlobalRef(handle2)),
        getActualTypeArguments: get2("getActualTypeArguments", "()[Ljava/lang/reflect/Type;"),
        getRawType: get2("getRawType", "()Ljava/lang/reflect/Type;"),
        getOwnerType: get2("getOwnerType", "()Ljava/lang/reflect/Type;")
      };
    } finally {
      this.deleteLocalRef(handle2);
    }
  }
  return javaLangReflectParameterizedType;
};
var javaLangString = null;
Env.prototype.javaLangString = function() {
  if (javaLangString === null) {
    const handle2 = this.findClass("java/lang/String");
    try {
      javaLangString = {
        handle: register(this.newGlobalRef(handle2))
      };
    } finally {
      this.deleteLocalRef(handle2);
    }
  }
  return javaLangString;
};
Env.prototype.getClassName = function(classHandle) {
  const name = this.vaMethod("pointer", [])(this.handle, classHandle, this.javaLangClass().getName);
  try {
    return this.stringFromJni(name);
  } finally {
    this.deleteLocalRef(name);
  }
};
Env.prototype.getObjectClassName = function(objHandle) {
  const jklass = this.getObjectClass(objHandle);
  try {
    return this.getClassName(jklass);
  } finally {
    this.deleteLocalRef(jklass);
  }
};
Env.prototype.getActualTypeArgument = function(type) {
  const actualTypeArguments = this.vaMethod("pointer", [])(this.handle, type, this.javaLangReflectParameterizedType().getActualTypeArguments);
  this.throwIfExceptionPending();
  if (!actualTypeArguments.isNull()) {
    try {
      return this.getTypeNameFromFirstTypeElement(actualTypeArguments);
    } finally {
      this.deleteLocalRef(actualTypeArguments);
    }
  }
};
Env.prototype.getTypeNameFromFirstTypeElement = function(typeArray) {
  const length = this.getArrayLength(typeArray);
  if (length > 0) {
    const typeArgument0 = this.getObjectArrayElement(typeArray, 0);
    try {
      return this.getTypeName(typeArgument0);
    } finally {
      this.deleteLocalRef(typeArgument0);
    }
  } else {
    return "java.lang.Object";
  }
};
Env.prototype.getTypeName = function(type, getGenericsInformation) {
  const invokeObjectMethodNoArgs = this.vaMethod("pointer", []);
  if (this.isInstanceOf(type, this.javaLangClass().handle)) {
    return this.getClassName(type);
  } else if (this.isInstanceOf(type, this.javaLangReflectGenericArrayType().handle)) {
    return this.getArrayTypeName(type);
  } else if (this.isInstanceOf(type, this.javaLangReflectParameterizedType().handle)) {
    const rawType = invokeObjectMethodNoArgs(this.handle, type, this.javaLangReflectParameterizedType().getRawType);
    this.throwIfExceptionPending();
    let result;
    try {
      result = this.getTypeName(rawType);
    } finally {
      this.deleteLocalRef(rawType);
    }
    if (getGenericsInformation) {
      result += "<" + this.getActualTypeArgument(type) + ">";
    }
    return result;
  } else if (this.isInstanceOf(type, this.javaLangReflectTypeVariable().handle)) {
    return "java.lang.Object";
  } else if (this.isInstanceOf(type, this.javaLangReflectWildcardType().handle)) {
    return "java.lang.Object";
  } else {
    return "java.lang.Object";
  }
};
Env.prototype.getArrayTypeName = function(type) {
  const invokeObjectMethodNoArgs = this.vaMethod("pointer", []);
  if (this.isInstanceOf(type, this.javaLangClass().handle)) {
    return this.getClassName(type);
  } else if (this.isInstanceOf(type, this.javaLangReflectGenericArrayType().handle)) {
    const componentType = invokeObjectMethodNoArgs(this.handle, type, this.javaLangReflectGenericArrayType().getGenericComponentType);
    this.throwIfExceptionPending();
    try {
      return "[L" + this.getTypeName(componentType) + ";";
    } finally {
      this.deleteLocalRef(componentType);
    }
  } else {
    return "[Ljava.lang.Object;";
  }
};
Env.prototype.stringFromJni = function(str) {
  const utf = this.getStringChars(str);
  if (utf.isNull()) {
    throw new Error("Unable to access string");
  }
  try {
    const length = this.getStringLength(str);
    return utf.readUtf16String(length);
  } finally {
    this.releaseStringChars(str, utf);
  }
};

// node_modules/frida-java-bridge/lib/vm.js
var JNI_VERSION_1_6 = 65542;
var pointerSize6 = Process.pointerSize;
var jsThreadID = Process.getCurrentThreadId();
var attachedThreads = /* @__PURE__ */ new Map();
var activeEnvs = /* @__PURE__ */ new Map();
function VM(api3) {
  const handle2 = api3.vm;
  let attachCurrentThread = null;
  let detachCurrentThread = null;
  let getEnv = null;
  function initialize2() {
    const vtable2 = handle2.readPointer();
    const options = {
      exceptions: "propagate"
    };
    attachCurrentThread = new NativeFunction(vtable2.add(4 * pointerSize6).readPointer(), "int32", ["pointer", "pointer", "pointer"], options);
    detachCurrentThread = new NativeFunction(vtable2.add(5 * pointerSize6).readPointer(), "int32", ["pointer"], options);
    getEnv = new NativeFunction(vtable2.add(6 * pointerSize6).readPointer(), "int32", ["pointer", "pointer", "int32"], options);
  }
  this.handle = handle2;
  this.perform = function(fn) {
    const threadId = Process.getCurrentThreadId();
    const cachedEnv = tryGetCachedEnv(threadId);
    if (cachedEnv !== null) {
      return fn(cachedEnv);
    }
    let env = this._tryGetEnv();
    const alreadyAttached = env !== null;
    if (!alreadyAttached) {
      env = this.attachCurrentThread();
      attachedThreads.set(threadId, true);
    }
    this.link(threadId, env);
    try {
      return fn(env);
    } finally {
      const isJsThread = threadId === jsThreadID;
      if (!isJsThread) {
        this.unlink(threadId);
      }
      if (!alreadyAttached && !isJsThread) {
        const allowedToDetach = attachedThreads.get(threadId);
        attachedThreads.delete(threadId);
        if (allowedToDetach) {
          this.detachCurrentThread();
        }
      }
    }
  };
  this.attachCurrentThread = function() {
    const envBuf = Memory.alloc(pointerSize6);
    checkJniResult("VM::AttachCurrentThread", attachCurrentThread(handle2, envBuf, NULL));
    return new Env(envBuf.readPointer(), this);
  };
  this.detachCurrentThread = function() {
    checkJniResult("VM::DetachCurrentThread", detachCurrentThread(handle2));
  };
  this.preventDetachDueToClassLoader = function() {
    const threadId = Process.getCurrentThreadId();
    if (attachedThreads.has(threadId)) {
      attachedThreads.set(threadId, false);
    }
  };
  this.getEnv = function() {
    const cachedEnv = tryGetCachedEnv(Process.getCurrentThreadId());
    if (cachedEnv !== null) {
      return cachedEnv;
    }
    const envBuf = Memory.alloc(pointerSize6);
    const result = getEnv(handle2, envBuf, JNI_VERSION_1_6);
    if (result === -2) {
      throw new Error("Current thread is not attached to the Java VM; please move this code inside a Java.perform() callback");
    }
    checkJniResult("VM::GetEnv", result);
    return new Env(envBuf.readPointer(), this);
  };
  this.tryGetEnv = function() {
    const cachedEnv = tryGetCachedEnv(Process.getCurrentThreadId());
    if (cachedEnv !== null) {
      return cachedEnv;
    }
    return this._tryGetEnv();
  };
  this._tryGetEnv = function() {
    const h = this.tryGetEnvHandle(JNI_VERSION_1_6);
    if (h === null) {
      return null;
    }
    return new Env(h, this);
  };
  this.tryGetEnvHandle = function(version) {
    const envBuf = Memory.alloc(pointerSize6);
    const result = getEnv(handle2, envBuf, version);
    if (result !== JNI_OK) {
      return null;
    }
    return envBuf.readPointer();
  };
  this.makeHandleDestructor = function(handle3) {
    return () => {
      this.perform((env) => {
        env.deleteGlobalRef(handle3);
      });
    };
  };
  this.link = function(tid, env) {
    const entry = activeEnvs.get(tid);
    if (entry === void 0) {
      activeEnvs.set(tid, [env, 1]);
    } else {
      entry[1]++;
    }
  };
  this.unlink = function(tid) {
    const entry = activeEnvs.get(tid);
    if (entry[1] === 1) {
      activeEnvs.delete(tid);
    } else {
      entry[1]--;
    }
  };
  function tryGetCachedEnv(threadId) {
    const entry = activeEnvs.get(threadId);
    if (entry === void 0) {
      return null;
    }
    return entry[0];
  }
  initialize2.call(this);
}
VM.dispose = function(vm3) {
  if (attachedThreads.get(jsThreadID) === true) {
    attachedThreads.delete(jsThreadID);
    vm3.detachCurrentThread();
  }
};

// node_modules/frida-java-bridge/lib/android.js
var jsizeSize = 4;
var pointerSize7 = Process.pointerSize;
var {
  readU32,
  readPointer,
  writeU32,
  writePointer
} = NativePointer.prototype;
var kAccPublic = 1;
var kAccStatic = 8;
var kAccFinal = 16;
var kAccNative = 256;
var kAccFastNative = 524288;
var kAccCriticalNative = 2097152;
var kAccFastInterpreterToInterpreterInvoke = 1073741824;
var kAccSkipAccessChecks = 524288;
var kAccSingleImplementation = 134217728;
var kAccNterpEntryPointFastPathFlag = 1048576;
var kAccNterpInvokeFastPathFlag = 2097152;
var kAccPublicApi = 268435456;
var kAccXposedHookedMethod = 268435456;
var kPointer = 0;
var kFullDeoptimization = 3;
var kSelectiveDeoptimization = 5;
var THUMB_BIT_REMOVAL_MASK = ptr(1).not();
var X86_JMP_MAX_DISTANCE = 2147467263;
var ARM64_ADRP_MAX_DISTANCE = 4294963200;
var ENV_VTABLE_OFFSET_EXCEPTION_CLEAR = 17 * pointerSize7;
var ENV_VTABLE_OFFSET_FATAL_ERROR = 18 * pointerSize7;
var DVM_JNI_ENV_OFFSET_SELF = 12;
var DVM_CLASS_OBJECT_OFFSET_VTABLE_COUNT = 112;
var DVM_CLASS_OBJECT_OFFSET_VTABLE = 116;
var DVM_OBJECT_OFFSET_CLAZZ = 0;
var DVM_METHOD_SIZE = 56;
var DVM_METHOD_OFFSET_ACCESS_FLAGS = 4;
var DVM_METHOD_OFFSET_METHOD_INDEX = 8;
var DVM_METHOD_OFFSET_REGISTERS_SIZE = 10;
var DVM_METHOD_OFFSET_OUTS_SIZE = 12;
var DVM_METHOD_OFFSET_INS_SIZE = 14;
var DVM_METHOD_OFFSET_SHORTY = 28;
var DVM_METHOD_OFFSET_JNI_ARG_INFO = 36;
var DALVIK_JNI_RETURN_VOID = 0;
var DALVIK_JNI_RETURN_FLOAT = 1;
var DALVIK_JNI_RETURN_DOUBLE = 2;
var DALVIK_JNI_RETURN_S8 = 3;
var DALVIK_JNI_RETURN_S4 = 4;
var DALVIK_JNI_RETURN_S2 = 5;
var DALVIK_JNI_RETURN_U2 = 6;
var DALVIK_JNI_RETURN_S1 = 7;
var DALVIK_JNI_NO_ARG_INFO = 2147483648;
var DALVIK_JNI_RETURN_SHIFT = 28;
var STD_STRING_SIZE = 3 * pointerSize7;
var STD_VECTOR_SIZE = 3 * pointerSize7;
var AF_UNIX = 1;
var SOCK_STREAM = 1;
var getArtRuntimeSpec = memoize(_getArtRuntimeSpec);
var getArtInstrumentationSpec = memoize(_getArtInstrumentationSpec);
var getArtMethodSpec = memoize(_getArtMethodSpec);
var getArtThreadSpec = memoize(_getArtThreadSpec);
var getArtManagedStackSpec = memoize(_getArtManagedStackSpec);
var getArtThreadStateTransitionImpl = memoize(_getArtThreadStateTransitionImpl);
var getAndroidVersion = memoize(_getAndroidVersion);
var getAndroidCodename = memoize(_getAndroidCodename);
var getAndroidApiLevel = memoize(_getAndroidApiLevel);
var getArtQuickFrameInfoGetterThunk = memoize(_getArtQuickFrameInfoGetterThunk);
var makeCxxMethodWrapperReturningPointerByValue = Process.arch === "ia32" ? makeCxxMethodWrapperReturningPointerByValueInFirstArg : makeCxxMethodWrapperReturningPointerByValueGeneric;
var nativeFunctionOptions3 = {
  exceptions: "propagate"
};
var artThreadStateTransitions = {};
var cachedApi = null;
var cachedArtClassLinkerSpec = null;
var MethodMangler = null;
var artController = null;
var inlineHooks = [];
var patchedClasses = /* @__PURE__ */ new Map();
var artQuickInterceptors = [];
var thunkPage = null;
var thunkOffset = 0;
var taughtArtAboutReplacementMethods = false;
var taughtArtAboutMethodInstrumentation = false;
var backtraceModule = null;
var jdwpSessions = [];
var socketpair = null;
var trampolineAllocator = null;
function getApi() {
  if (cachedApi === null) {
    cachedApi = _getApi();
  }
  return cachedApi;
}
function _getApi() {
  const vmModules = Process.enumerateModules().filter((m2) => /^lib(art|dvm).so$/.test(m2.name)).filter((m2) => !/\/system\/fake-libs/.test(m2.path));
  if (vmModules.length === 0) {
    return null;
  }
  const vmModule = vmModules[0];
  const flavor = vmModule.name.indexOf("art") !== -1 ? "art" : "dalvik";
  const isArt = flavor === "art";
  const temporaryApi = {
    module: vmModule,
    find(name) {
      const { module } = this;
      let address = module.findExportByName(name);
      if (address === null) {
        address = module.findSymbolByName(name);
      }
      return address;
    },
    flavor,
    addLocalReference: null
  };
  temporaryApi.isApiLevel34OrApexEquivalent = isArt && (temporaryApi.find("_ZN3art7AppInfo29GetPrimaryApkReferenceProfileEv") !== null || temporaryApi.find("_ZN3art6Thread15RunFlipFunctionEPS0_") !== null);
  const pending = isArt ? {
    functions: {
      JNI_GetCreatedJavaVMs: ["JNI_GetCreatedJavaVMs", "int", ["pointer", "int", "pointer"]],
      // Android < 7
      artInterpreterToCompiledCodeBridge: function(address) {
        this.artInterpreterToCompiledCodeBridge = address;
      },
      // Android >= 8
      _ZN3art9JavaVMExt12AddGlobalRefEPNS_6ThreadENS_6ObjPtrINS_6mirror6ObjectEEE: ["art::JavaVMExt::AddGlobalRef", "pointer", ["pointer", "pointer", "pointer"]],
      // Android >= 6
      _ZN3art9JavaVMExt12AddGlobalRefEPNS_6ThreadEPNS_6mirror6ObjectE: ["art::JavaVMExt::AddGlobalRef", "pointer", ["pointer", "pointer", "pointer"]],
      // Android < 6: makeAddGlobalRefFallbackForAndroid5() needs these:
      _ZN3art17ReaderWriterMutex13ExclusiveLockEPNS_6ThreadE: ["art::ReaderWriterMutex::ExclusiveLock", "void", ["pointer", "pointer"]],
      _ZN3art17ReaderWriterMutex15ExclusiveUnlockEPNS_6ThreadE: ["art::ReaderWriterMutex::ExclusiveUnlock", "void", ["pointer", "pointer"]],
      // Android <= 7
      _ZN3art22IndirectReferenceTable3AddEjPNS_6mirror6ObjectE: function(address) {
        this["art::IndirectReferenceTable::Add"] = new NativeFunction(address, "pointer", ["pointer", "uint", "pointer"], nativeFunctionOptions3);
      },
      // Android > 7
      _ZN3art22IndirectReferenceTable3AddENS_15IRTSegmentStateENS_6ObjPtrINS_6mirror6ObjectEEE: function(address) {
        this["art::IndirectReferenceTable::Add"] = new NativeFunction(address, "pointer", ["pointer", "uint", "pointer"], nativeFunctionOptions3);
      },
      // Android >= 7
      _ZN3art9JavaVMExt12DecodeGlobalEPv: function(address) {
        let decodeGlobal;
        if (getAndroidApiLevel() >= 26) {
          decodeGlobal = makeCxxMethodWrapperReturningPointerByValue(address, ["pointer", "pointer"]);
        } else {
          decodeGlobal = new NativeFunction(address, "pointer", ["pointer", "pointer"], nativeFunctionOptions3);
        }
        this["art::JavaVMExt::DecodeGlobal"] = function(vm3, thread, ref) {
          return decodeGlobal(vm3, ref);
        };
      },
      // Android >= 6
      _ZN3art9JavaVMExt12DecodeGlobalEPNS_6ThreadEPv: ["art::JavaVMExt::DecodeGlobal", "pointer", ["pointer", "pointer", "pointer"]],
      // makeDecodeGlobalFallback() uses:
      // Android >= 15
      _ZNK3art6Thread19DecodeGlobalJObjectEP8_jobject: ["art::Thread::DecodeJObject", "pointer", ["pointer", "pointer"]],
      // Android < 6
      _ZNK3art6Thread13DecodeJObjectEP8_jobject: ["art::Thread::DecodeJObject", "pointer", ["pointer", "pointer"]],
      // Android >= 6
      _ZN3art10ThreadList10SuspendAllEPKcb: ["art::ThreadList::SuspendAll", "void", ["pointer", "pointer", "bool"]],
      // or fallback:
      _ZN3art10ThreadList10SuspendAllEv: function(address) {
        const suspendAll = new NativeFunction(address, "void", ["pointer"], nativeFunctionOptions3);
        this["art::ThreadList::SuspendAll"] = function(threadList, cause, longSuspend) {
          return suspendAll(threadList);
        };
      },
      _ZN3art10ThreadList9ResumeAllEv: ["art::ThreadList::ResumeAll", "void", ["pointer"]],
      // Android >= 7
      _ZN3art11ClassLinker12VisitClassesEPNS_12ClassVisitorE: ["art::ClassLinker::VisitClasses", "void", ["pointer", "pointer"]],
      // Android < 7
      _ZN3art11ClassLinker12VisitClassesEPFbPNS_6mirror5ClassEPvES4_: function(address) {
        const visitClasses = new NativeFunction(address, "void", ["pointer", "pointer", "pointer"], nativeFunctionOptions3);
        this["art::ClassLinker::VisitClasses"] = function(classLinker, visitor) {
          visitClasses(classLinker, visitor, NULL);
        };
      },
      _ZNK3art11ClassLinker17VisitClassLoadersEPNS_18ClassLoaderVisitorE: ["art::ClassLinker::VisitClassLoaders", "void", ["pointer", "pointer"]],
      _ZN3art2gc4Heap12VisitObjectsEPFvPNS_6mirror6ObjectEPvES5_: ["art::gc::Heap::VisitObjects", "void", ["pointer", "pointer", "pointer"]],
      _ZN3art2gc4Heap12GetInstancesERNS_24VariableSizedHandleScopeENS_6HandleINS_6mirror5ClassEEEiRNSt3__16vectorINS4_INS5_6ObjectEEENS8_9allocatorISB_EEEE: ["art::gc::Heap::GetInstances", "void", ["pointer", "pointer", "pointer", "int", "pointer"]],
      // Android >= 9
      _ZN3art2gc4Heap12GetInstancesERNS_24VariableSizedHandleScopeENS_6HandleINS_6mirror5ClassEEEbiRNSt3__16vectorINS4_INS5_6ObjectEEENS8_9allocatorISB_EEEE: function(address) {
        const getInstances = new NativeFunction(address, "void", ["pointer", "pointer", "pointer", "bool", "int", "pointer"], nativeFunctionOptions3);
        this["art::gc::Heap::GetInstances"] = function(instance, scope, hClass, maxCount, instances) {
          const useIsAssignableFrom = 0;
          getInstances(instance, scope, hClass, useIsAssignableFrom, maxCount, instances);
        };
      },
      _ZN3art12StackVisitorC2EPNS_6ThreadEPNS_7ContextENS0_13StackWalkKindEjb: ["art::StackVisitor::StackVisitor", "void", ["pointer", "pointer", "pointer", "uint", "uint", "bool"]],
      _ZN3art12StackVisitorC2EPNS_6ThreadEPNS_7ContextENS0_13StackWalkKindEmb: ["art::StackVisitor::StackVisitor", "void", ["pointer", "pointer", "pointer", "uint", "size_t", "bool"]],
      _ZN3art12StackVisitor9WalkStackILNS0_16CountTransitionsE0EEEvb: ["art::StackVisitor::WalkStack", "void", ["pointer", "bool"]],
      _ZNK3art12StackVisitor9GetMethodEv: ["art::StackVisitor::GetMethod", "pointer", ["pointer"]],
      _ZNK3art12StackVisitor16DescribeLocationEv: function(address) {
        this["art::StackVisitor::DescribeLocation"] = makeCxxMethodWrapperReturningStdStringByValue(address, ["pointer"]);
      },
      _ZNK3art12StackVisitor24GetCurrentQuickFrameInfoEv: function(address) {
        this["art::StackVisitor::GetCurrentQuickFrameInfo"] = makeArtQuickFrameInfoGetter(address);
      },
      _ZN3art6Thread18GetLongJumpContextEv: ["art::Thread::GetLongJumpContext", "pointer", ["pointer"]],
      _ZN3art6mirror5Class13GetDescriptorEPNSt3__112basic_stringIcNS2_11char_traitsIcEENS2_9allocatorIcEEEE: function(address) {
        this["art::mirror::Class::GetDescriptor"] = address;
      },
      _ZN3art6mirror5Class11GetLocationEv: function(address) {
        this["art::mirror::Class::GetLocation"] = makeCxxMethodWrapperReturningStdStringByValue(address, ["pointer"]);
      },
      _ZN3art9ArtMethod12PrettyMethodEb: function(address) {
        this["art::ArtMethod::PrettyMethod"] = makeCxxMethodWrapperReturningStdStringByValue(address, ["pointer", "bool"]);
      },
      _ZN3art12PrettyMethodEPNS_9ArtMethodEb: function(address) {
        this["art::ArtMethod::PrettyMethodNullSafe"] = makeCxxMethodWrapperReturningStdStringByValue(address, ["pointer", "bool"]);
      },
      // Android < 6 for cloneArtMethod()
      _ZN3art6Thread14CurrentFromGdbEv: ["art::Thread::CurrentFromGdb", "pointer", []],
      _ZN3art6mirror6Object5CloneEPNS_6ThreadE: function(address) {
        this["art::mirror::Object::Clone"] = new NativeFunction(address, "pointer", ["pointer", "pointer"], nativeFunctionOptions3);
      },
      _ZN3art6mirror6Object5CloneEPNS_6ThreadEm: function(address) {
        const clone = new NativeFunction(address, "pointer", ["pointer", "pointer", "pointer"], nativeFunctionOptions3);
        this["art::mirror::Object::Clone"] = function(thisPtr, threadPtr) {
          const numTargetBytes = NULL;
          return clone(thisPtr, threadPtr, numTargetBytes);
        };
      },
      _ZN3art6mirror6Object5CloneEPNS_6ThreadEj: function(address) {
        const clone = new NativeFunction(address, "pointer", ["pointer", "pointer", "uint"], nativeFunctionOptions3);
        this["art::mirror::Object::Clone"] = function(thisPtr, threadPtr) {
          const numTargetBytes = 0;
          return clone(thisPtr, threadPtr, numTargetBytes);
        };
      },
      _ZN3art3Dbg14SetJdwpAllowedEb: ["art::Dbg::SetJdwpAllowed", "void", ["bool"]],
      _ZN3art3Dbg13ConfigureJdwpERKNS_4JDWP11JdwpOptionsE: ["art::Dbg::ConfigureJdwp", "void", ["pointer"]],
      _ZN3art31InternalDebuggerControlCallback13StartDebuggerEv: ["art::InternalDebuggerControlCallback::StartDebugger", "void", ["pointer"]],
      _ZN3art3Dbg9StartJdwpEv: ["art::Dbg::StartJdwp", "void", []],
      _ZN3art3Dbg8GoActiveEv: ["art::Dbg::GoActive", "void", []],
      _ZN3art3Dbg21RequestDeoptimizationERKNS_21DeoptimizationRequestE: ["art::Dbg::RequestDeoptimization", "void", ["pointer"]],
      _ZN3art3Dbg20ManageDeoptimizationEv: ["art::Dbg::ManageDeoptimization", "void", []],
      _ZN3art15instrumentation15Instrumentation20EnableDeoptimizationEv: ["art::Instrumentation::EnableDeoptimization", "void", ["pointer"]],
      // Android >= 6
      _ZN3art15instrumentation15Instrumentation20DeoptimizeEverythingEPKc: ["art::Instrumentation::DeoptimizeEverything", "void", ["pointer", "pointer"]],
      // Android < 6
      _ZN3art15instrumentation15Instrumentation20DeoptimizeEverythingEv: function(address) {
        const deoptimize = new NativeFunction(address, "void", ["pointer"], nativeFunctionOptions3);
        this["art::Instrumentation::DeoptimizeEverything"] = function(instrumentation, key) {
          deoptimize(instrumentation);
        };
      },
      _ZN3art7Runtime19DeoptimizeBootImageEv: ["art::Runtime::DeoptimizeBootImage", "void", ["pointer"]],
      _ZN3art15instrumentation15Instrumentation10DeoptimizeEPNS_9ArtMethodE: ["art::Instrumentation::Deoptimize", "void", ["pointer", "pointer"]],
      // Android >= 11
      _ZN3art3jni12JniIdManager14DecodeMethodIdEP10_jmethodID: ["art::jni::JniIdManager::DecodeMethodId", "pointer", ["pointer", "pointer"]],
      _ZN3art11interpreter18GetNterpEntryPointEv: ["art::interpreter::GetNterpEntryPoint", "pointer", []],
      _ZN3art7Monitor17TranslateLocationEPNS_9ArtMethodEjPPKcPi: ["art::Monitor::TranslateLocation", "void", ["pointer", "uint32", "pointer", "pointer"]]
    },
    variables: {
      _ZN3art3Dbg9gRegistryE: function(address) {
        this.isJdwpStarted = () => !address.readPointer().isNull();
      },
      _ZN3art3Dbg15gDebuggerActiveE: function(address) {
        this.isDebuggerActive = () => !!address.readU8();
      }
    },
    optionals: /* @__PURE__ */ new Set([
      "artInterpreterToCompiledCodeBridge",
      "_ZN3art9JavaVMExt12AddGlobalRefEPNS_6ThreadENS_6ObjPtrINS_6mirror6ObjectEEE",
      "_ZN3art9JavaVMExt12AddGlobalRefEPNS_6ThreadEPNS_6mirror6ObjectE",
      "_ZN3art9JavaVMExt12DecodeGlobalEPv",
      "_ZN3art9JavaVMExt12DecodeGlobalEPNS_6ThreadEPv",
      "_ZNK3art6Thread19DecodeGlobalJObjectEP8_jobject",
      "_ZNK3art6Thread13DecodeJObjectEP8_jobject",
      "_ZN3art10ThreadList10SuspendAllEPKcb",
      "_ZN3art10ThreadList10SuspendAllEv",
      "_ZN3art11ClassLinker12VisitClassesEPNS_12ClassVisitorE",
      "_ZN3art11ClassLinker12VisitClassesEPFbPNS_6mirror5ClassEPvES4_",
      "_ZNK3art11ClassLinker17VisitClassLoadersEPNS_18ClassLoaderVisitorE",
      "_ZN3art6mirror6Object5CloneEPNS_6ThreadE",
      "_ZN3art6mirror6Object5CloneEPNS_6ThreadEm",
      "_ZN3art6mirror6Object5CloneEPNS_6ThreadEj",
      "_ZN3art22IndirectReferenceTable3AddEjPNS_6mirror6ObjectE",
      "_ZN3art22IndirectReferenceTable3AddENS_15IRTSegmentStateENS_6ObjPtrINS_6mirror6ObjectEEE",
      "_ZN3art2gc4Heap12VisitObjectsEPFvPNS_6mirror6ObjectEPvES5_",
      "_ZN3art2gc4Heap12GetInstancesERNS_24VariableSizedHandleScopeENS_6HandleINS_6mirror5ClassEEEiRNSt3__16vectorINS4_INS5_6ObjectEEENS8_9allocatorISB_EEEE",
      "_ZN3art2gc4Heap12GetInstancesERNS_24VariableSizedHandleScopeENS_6HandleINS_6mirror5ClassEEEbiRNSt3__16vectorINS4_INS5_6ObjectEEENS8_9allocatorISB_EEEE",
      "_ZN3art12StackVisitorC2EPNS_6ThreadEPNS_7ContextENS0_13StackWalkKindEjb",
      "_ZN3art12StackVisitorC2EPNS_6ThreadEPNS_7ContextENS0_13StackWalkKindEmb",
      "_ZN3art12StackVisitor9WalkStackILNS0_16CountTransitionsE0EEEvb",
      "_ZNK3art12StackVisitor9GetMethodEv",
      "_ZNK3art12StackVisitor16DescribeLocationEv",
      "_ZNK3art12StackVisitor24GetCurrentQuickFrameInfoEv",
      "_ZN3art6Thread18GetLongJumpContextEv",
      "_ZN3art6mirror5Class13GetDescriptorEPNSt3__112basic_stringIcNS2_11char_traitsIcEENS2_9allocatorIcEEEE",
      "_ZN3art6mirror5Class11GetLocationEv",
      "_ZN3art9ArtMethod12PrettyMethodEb",
      "_ZN3art12PrettyMethodEPNS_9ArtMethodEb",
      "_ZN3art3Dbg13ConfigureJdwpERKNS_4JDWP11JdwpOptionsE",
      "_ZN3art31InternalDebuggerControlCallback13StartDebuggerEv",
      "_ZN3art3Dbg15gDebuggerActiveE",
      "_ZN3art15instrumentation15Instrumentation20EnableDeoptimizationEv",
      "_ZN3art15instrumentation15Instrumentation20DeoptimizeEverythingEPKc",
      "_ZN3art15instrumentation15Instrumentation20DeoptimizeEverythingEv",
      "_ZN3art7Runtime19DeoptimizeBootImageEv",
      "_ZN3art15instrumentation15Instrumentation10DeoptimizeEPNS_9ArtMethodE",
      "_ZN3art3Dbg9StartJdwpEv",
      "_ZN3art3Dbg8GoActiveEv",
      "_ZN3art3Dbg21RequestDeoptimizationERKNS_21DeoptimizationRequestE",
      "_ZN3art3Dbg20ManageDeoptimizationEv",
      "_ZN3art3Dbg9gRegistryE",
      "_ZN3art3jni12JniIdManager14DecodeMethodIdEP10_jmethodID",
      "_ZN3art11interpreter18GetNterpEntryPointEv",
      "_ZN3art7Monitor17TranslateLocationEPNS_9ArtMethodEjPPKcPi"
    ])
  } : {
    functions: {
      _Z20dvmDecodeIndirectRefP6ThreadP8_jobject: ["dvmDecodeIndirectRef", "pointer", ["pointer", "pointer"]],
      _Z15dvmUseJNIBridgeP6MethodPv: ["dvmUseJNIBridge", "void", ["pointer", "pointer"]],
      _Z20dvmHeapSourceGetBasev: ["dvmHeapSourceGetBase", "pointer", []],
      _Z21dvmHeapSourceGetLimitv: ["dvmHeapSourceGetLimit", "pointer", []],
      _Z16dvmIsValidObjectPK6Object: ["dvmIsValidObject", "uint8", ["pointer"]],
      JNI_GetCreatedJavaVMs: ["JNI_GetCreatedJavaVMs", "int", ["pointer", "int", "pointer"]]
    },
    variables: {
      gDvmJni: function(address) {
        this.gDvmJni = address;
      },
      gDvm: function(address) {
        this.gDvm = address;
      }
    }
  };
  const {
    functions = {},
    variables = {},
    optionals = /* @__PURE__ */ new Set()
  } = pending;
  const missing = [];
  for (const [name, signature2] of Object.entries(functions)) {
    const address = temporaryApi.find(name);
    if (address !== null) {
      if (typeof signature2 === "function") {
        signature2.call(temporaryApi, address);
      } else {
        temporaryApi[signature2[0]] = new NativeFunction(address, signature2[1], signature2[2], nativeFunctionOptions3);
      }
    } else {
      if (!optionals.has(name)) {
        missing.push(name);
      }
    }
  }
  for (const [name, handler] of Object.entries(variables)) {
    const address = temporaryApi.find(name);
    if (address !== null) {
      handler.call(temporaryApi, address);
    } else {
      if (!optionals.has(name)) {
        missing.push(name);
      }
    }
  }
  if (missing.length > 0) {
    throw new Error("Java API only partially available; please file a bug. Missing: " + missing.join(", "));
  }
  const vms = Memory.alloc(pointerSize7);
  const vmCount = Memory.alloc(jsizeSize);
  checkJniResult("JNI_GetCreatedJavaVMs", temporaryApi.JNI_GetCreatedJavaVMs(vms, 1, vmCount));
  if (vmCount.readInt() === 0) {
    return null;
  }
  temporaryApi.vm = vms.readPointer();
  if (isArt) {
    const apiLevel = getAndroidApiLevel();
    let kAccCompileDontBother;
    if (apiLevel >= 27) {
      kAccCompileDontBother = 33554432;
    } else if (apiLevel >= 24) {
      kAccCompileDontBother = 16777216;
    } else {
      kAccCompileDontBother = 0;
    }
    temporaryApi.kAccCompileDontBother = kAccCompileDontBother;
    const artRuntime = temporaryApi.vm.add(pointerSize7).readPointer();
    temporaryApi.artRuntime = artRuntime;
    const runtimeSpec = getArtRuntimeSpec(temporaryApi);
    const runtimeOffset = runtimeSpec.offset;
    const instrumentationOffset = runtimeOffset.instrumentation;
    temporaryApi.artInstrumentation = instrumentationOffset !== null ? artRuntime.add(instrumentationOffset) : null;
    temporaryApi.artHeap = artRuntime.add(runtimeOffset.heap).readPointer();
    temporaryApi.artThreadList = artRuntime.add(runtimeOffset.threadList).readPointer();
    const classLinker = artRuntime.add(runtimeOffset.classLinker).readPointer();
    const classLinkerOffsets = getArtClassLinkerSpec(artRuntime, runtimeSpec).offset;
    const quickResolutionTrampoline = classLinker.add(classLinkerOffsets.quickResolutionTrampoline).readPointer();
    const quickImtConflictTrampoline = classLinker.add(classLinkerOffsets.quickImtConflictTrampoline).readPointer();
    const quickGenericJniTrampoline = classLinker.add(classLinkerOffsets.quickGenericJniTrampoline).readPointer();
    const quickToInterpreterBridgeTrampoline = classLinker.add(classLinkerOffsets.quickToInterpreterBridgeTrampoline).readPointer();
    temporaryApi.artClassLinker = {
      address: classLinker,
      quickResolutionTrampoline,
      quickImtConflictTrampoline,
      quickGenericJniTrampoline,
      quickToInterpreterBridgeTrampoline
    };
    const vm3 = new VM(temporaryApi);
    temporaryApi.artQuickGenericJniTrampoline = getArtQuickEntrypointFromTrampoline(quickGenericJniTrampoline, vm3);
    temporaryApi.artQuickToInterpreterBridge = getArtQuickEntrypointFromTrampoline(quickToInterpreterBridgeTrampoline, vm3);
    temporaryApi.artQuickResolutionTrampoline = getArtQuickEntrypointFromTrampoline(quickResolutionTrampoline, vm3);
    if (temporaryApi["art::JavaVMExt::AddGlobalRef"] === void 0) {
      temporaryApi["art::JavaVMExt::AddGlobalRef"] = makeAddGlobalRefFallbackForAndroid5(temporaryApi);
    }
    if (temporaryApi["art::JavaVMExt::DecodeGlobal"] === void 0) {
      temporaryApi["art::JavaVMExt::DecodeGlobal"] = makeDecodeGlobalFallback(temporaryApi);
    }
    if (temporaryApi["art::ArtMethod::PrettyMethod"] === void 0) {
      temporaryApi["art::ArtMethod::PrettyMethod"] = temporaryApi["art::ArtMethod::PrettyMethodNullSafe"];
    }
    if (temporaryApi["art::interpreter::GetNterpEntryPoint"] !== void 0) {
      temporaryApi.artNterpEntryPoint = temporaryApi["art::interpreter::GetNterpEntryPoint"]();
    } else {
      temporaryApi.artNterpEntryPoint = temporaryApi.find("ExecuteNterpImpl");
    }
    artController = makeArtController(temporaryApi, vm3);
    fixupArtQuickDeliverExceptionBug(temporaryApi);
    let cachedJvmti = null;
    Object.defineProperty(temporaryApi, "jvmti", {
      get() {
        if (cachedJvmti === null) {
          cachedJvmti = [tryGetEnvJvmti(vm3, this.artRuntime)];
        }
        return cachedJvmti[0];
      }
    });
  }
  const cxxImports = vmModule.enumerateImports().filter((imp) => imp.name.indexOf("_Z") === 0).reduce((result, imp) => {
    result[imp.name] = imp.address;
    return result;
  }, {});
  temporaryApi.$new = new NativeFunction(cxxImports._Znwm || cxxImports._Znwj, "pointer", ["ulong"], nativeFunctionOptions3);
  temporaryApi.$delete = new NativeFunction(cxxImports._ZdlPv, "void", ["pointer"], nativeFunctionOptions3);
  MethodMangler = isArt ? ArtMethodMangler : DalvikMethodMangler;
  return temporaryApi;
}
function tryGetEnvJvmti(vm3, runtime3) {
  let env = null;
  vm3.perform(() => {
    const ensurePluginLoadedAddr = getApi().find("_ZN3art7Runtime18EnsurePluginLoadedEPKcPNSt3__112basic_stringIcNS3_11char_traitsIcEENS3_9allocatorIcEEEE");
    if (ensurePluginLoadedAddr === null) {
      return;
    }
    const ensurePluginLoaded = new NativeFunction(
      ensurePluginLoadedAddr,
      "bool",
      ["pointer", "pointer", "pointer"]
    );
    const errorPtr = Memory.alloc(pointerSize7);
    const success = ensurePluginLoaded(runtime3, Memory.allocUtf8String("libopenjdkjvmti.so"), errorPtr);
    if (!success) {
      return;
    }
    const kArtTiVersion = jvmtiVersion.v1_2 | 1073741824;
    const handle2 = vm3.tryGetEnvHandle(kArtTiVersion);
    if (handle2 === null) {
      return;
    }
    env = new EnvJvmti(handle2, vm3);
    const capaBuf = Memory.alloc(8);
    capaBuf.writeU64(jvmtiCapabilities.canTagObjects);
    const result = env.addCapabilities(capaBuf);
    if (result !== JNI_OK) {
      env = null;
    }
  });
  return env;
}
function ensureClassInitialized(env, classRef) {
  const api3 = getApi();
  if (api3.flavor !== "art") {
    return;
  }
  env.getFieldId(classRef, "x", "Z");
  env.exceptionClear();
}
function getArtVMSpec(api3) {
  return {
    offset: pointerSize7 === 4 ? {
      globalsLock: 32,
      globals: 72
    } : {
      globalsLock: 64,
      globals: 112
    }
  };
}
function _getArtRuntimeSpec(api3) {
  const vm3 = api3.vm;
  const runtime3 = api3.artRuntime;
  const startOffset = pointerSize7 === 4 ? 200 : 384;
  const endOffset = startOffset + 100 * pointerSize7;
  const apiLevel = getAndroidApiLevel();
  const codename = getAndroidCodename();
  const { isApiLevel34OrApexEquivalent } = api3;
  let spec = null;
  for (let offset = startOffset; offset !== endOffset; offset += pointerSize7) {
    const value = runtime3.add(offset).readPointer();
    if (value.equals(vm3)) {
      let classLinkerOffsets;
      let jniIdManagerOffset = null;
      if (apiLevel >= 33 || codename === "Tiramisu" || isApiLevel34OrApexEquivalent) {
        classLinkerOffsets = [offset - 4 * pointerSize7];
        jniIdManagerOffset = offset - pointerSize7;
      } else if (apiLevel >= 30 || codename === "R") {
        classLinkerOffsets = [offset - 3 * pointerSize7, offset - 4 * pointerSize7];
        jniIdManagerOffset = offset - pointerSize7;
      } else if (apiLevel >= 29) {
        classLinkerOffsets = [offset - 2 * pointerSize7];
      } else if (apiLevel >= 27) {
        classLinkerOffsets = [offset - STD_STRING_SIZE - 3 * pointerSize7];
      } else {
        classLinkerOffsets = [offset - STD_STRING_SIZE - 2 * pointerSize7];
      }
      for (const classLinkerOffset of classLinkerOffsets) {
        const internTableOffset = classLinkerOffset - pointerSize7;
        const threadListOffset = internTableOffset - pointerSize7;
        let heapOffset;
        if (isApiLevel34OrApexEquivalent) {
          heapOffset = threadListOffset - 9 * pointerSize7;
        } else if (apiLevel >= 24) {
          heapOffset = threadListOffset - 8 * pointerSize7;
        } else if (apiLevel >= 23) {
          heapOffset = threadListOffset - 7 * pointerSize7;
        } else {
          heapOffset = threadListOffset - 4 * pointerSize7;
        }
        const candidate = {
          offset: {
            heap: heapOffset,
            threadList: threadListOffset,
            internTable: internTableOffset,
            classLinker: classLinkerOffset,
            jniIdManager: jniIdManagerOffset
          }
        };
        if (tryGetArtClassLinkerSpec(runtime3, candidate) !== null) {
          spec = candidate;
          break;
        }
      }
      break;
    }
  }
  if (spec === null) {
    throw new Error("Unable to determine Runtime field offsets");
  }
  spec.offset.instrumentation = tryDetectInstrumentationOffset(api3);
  spec.offset.jniIdsIndirection = tryDetectJniIdsIndirectionOffset(api3);
  return spec;
}
var instrumentationOffsetParsers = {
  ia32: parsex86InstrumentationOffset,
  x64: parsex86InstrumentationOffset,
  arm: parseArmInstrumentationOffset,
  arm64: parseArm64InstrumentationOffset
};
function tryDetectInstrumentationOffset(api3) {
  const impl = api3["art::Runtime::DeoptimizeBootImage"];
  if (impl === void 0) {
    return null;
  }
  return parseInstructionsAt(impl, instrumentationOffsetParsers[Process.arch], { limit: 30 });
}
function parsex86InstrumentationOffset(insn) {
  if (insn.mnemonic !== "lea") {
    return null;
  }
  const offset = insn.operands[1].value.disp;
  if (offset < 256 || offset > 1024) {
    return null;
  }
  return offset;
}
function parseArmInstrumentationOffset(insn) {
  if (insn.mnemonic !== "add.w") {
    return null;
  }
  const ops = insn.operands;
  if (ops.length !== 3) {
    return null;
  }
  const op2 = ops[2];
  if (op2.type !== "imm") {
    return null;
  }
  return op2.value;
}
function parseArm64InstrumentationOffset(insn) {
  if (insn.mnemonic !== "add") {
    return null;
  }
  const ops = insn.operands;
  if (ops.length !== 3) {
    return null;
  }
  if (ops[0].value === "sp" || ops[1].value === "sp") {
    return null;
  }
  const op2 = ops[2];
  if (op2.type !== "imm") {
    return null;
  }
  const offset = op2.value.valueOf();
  if (offset < 256 || offset > 1024) {
    return null;
  }
  return offset;
}
var jniIdsIndirectionOffsetParsers = {
  ia32: parsex86JniIdsIndirectionOffset,
  x64: parsex86JniIdsIndirectionOffset,
  arm: parseArmJniIdsIndirectionOffset,
  arm64: parseArm64JniIdsIndirectionOffset
};
function tryDetectJniIdsIndirectionOffset(api3) {
  const impl = api3.find("_ZN3art7Runtime12SetJniIdTypeENS_9JniIdTypeE");
  if (impl === null) {
    return null;
  }
  const offset = parseInstructionsAt(impl, jniIdsIndirectionOffsetParsers[Process.arch], { limit: 20 });
  if (offset === null) {
    throw new Error("Unable to determine Runtime.jni_ids_indirection_ offset");
  }
  return offset;
}
function parsex86JniIdsIndirectionOffset(insn) {
  if (insn.mnemonic === "cmp") {
    return insn.operands[0].value.disp;
  }
  return null;
}
function parseArmJniIdsIndirectionOffset(insn) {
  if (insn.mnemonic === "ldr.w") {
    return insn.operands[1].value.disp;
  }
  return null;
}
function parseArm64JniIdsIndirectionOffset(insn, prevInsn) {
  if (prevInsn === null) {
    return null;
  }
  const { mnemonic } = insn;
  const { mnemonic: prevMnemonic } = prevInsn;
  if (mnemonic === "cmp" && prevMnemonic === "ldr" || mnemonic === "bl" && prevMnemonic === "str") {
    return prevInsn.operands[1].value.disp;
  }
  return null;
}
function _getArtInstrumentationSpec() {
  const deoptimizationEnabledOffsets = {
    "4-21": 136,
    "4-22": 136,
    "4-23": 172,
    "4-24": 196,
    "4-25": 196,
    "4-26": 196,
    "4-27": 196,
    "4-28": 212,
    "4-29": 172,
    "4-30": 180,
    "4-31": 180,
    "8-21": 224,
    "8-22": 224,
    "8-23": 296,
    "8-24": 344,
    "8-25": 344,
    "8-26": 352,
    "8-27": 352,
    "8-28": 392,
    "8-29": 328,
    "8-30": 336,
    "8-31": 336
  };
  const deoptEnabledOffset = deoptimizationEnabledOffsets[`${pointerSize7}-${getAndroidApiLevel()}`];
  if (deoptEnabledOffset === void 0) {
    throw new Error("Unable to determine Instrumentation field offsets");
  }
  return {
    offset: {
      forcedInterpretOnly: 4,
      deoptimizationEnabled: deoptEnabledOffset
    }
  };
}
function getArtClassLinkerSpec(runtime3, runtimeSpec) {
  const spec = tryGetArtClassLinkerSpec(runtime3, runtimeSpec);
  if (spec === null) {
    throw new Error("Unable to determine ClassLinker field offsets");
  }
  return spec;
}
function tryGetArtClassLinkerSpec(runtime3, runtimeSpec) {
  if (cachedArtClassLinkerSpec !== null) {
    return cachedArtClassLinkerSpec;
  }
  const { classLinker: classLinkerOffset, internTable: internTableOffset } = runtimeSpec.offset;
  const classLinker = runtime3.add(classLinkerOffset).readPointer();
  const internTable = runtime3.add(internTableOffset).readPointer();
  const startOffset = pointerSize7 === 4 ? 100 : 200;
  const endOffset = startOffset + 100 * pointerSize7;
  const apiLevel = getAndroidApiLevel();
  let spec = null;
  for (let offset = startOffset; offset !== endOffset; offset += pointerSize7) {
    const value = classLinker.add(offset).readPointer();
    if (value.equals(internTable)) {
      let delta;
      if (apiLevel >= 30 || getAndroidCodename() === "R") {
        delta = 6;
      } else if (apiLevel >= 29) {
        delta = 4;
      } else if (apiLevel >= 23) {
        delta = 3;
      } else {
        delta = 5;
      }
      const quickGenericJniTrampolineOffset = offset + delta * pointerSize7;
      let quickResolutionTrampolineOffset;
      if (apiLevel >= 23) {
        quickResolutionTrampolineOffset = quickGenericJniTrampolineOffset - 2 * pointerSize7;
      } else {
        quickResolutionTrampolineOffset = quickGenericJniTrampolineOffset - 3 * pointerSize7;
      }
      spec = {
        offset: {
          quickResolutionTrampoline: quickResolutionTrampolineOffset,
          quickImtConflictTrampoline: quickGenericJniTrampolineOffset - pointerSize7,
          quickGenericJniTrampoline: quickGenericJniTrampolineOffset,
          quickToInterpreterBridgeTrampoline: quickGenericJniTrampolineOffset + pointerSize7
        }
      };
      break;
    }
  }
  if (spec !== null) {
    cachedArtClassLinkerSpec = spec;
  }
  return spec;
}
function getArtClassSpec(vm3) {
  const MAX_OFFSET = 256;
  let spec = null;
  vm3.perform((env) => {
    const fieldSpec = getArtFieldSpec(vm3);
    const methodSpec = getArtMethodSpec(vm3);
    const fInfo = {
      artArrayLengthSize: 4,
      artArrayEntrySize: fieldSpec.size,
      // java/lang/Thread has 36 fields on Android 16.
      artArrayMax: 50
    };
    const mInfo = {
      artArrayLengthSize: pointerSize7,
      artArrayEntrySize: methodSpec.size,
      // java/lang/Thread has 79 methods on Android 16.
      artArrayMax: 100
    };
    const readArtArray = (objectBase, fieldOffset, lengthSize) => {
      const header = objectBase.add(fieldOffset).readPointer();
      if (header.isNull()) {
        return null;
      }
      const length = lengthSize === 4 ? header.readU32() : header.readU64().valueOf();
      if (length <= 0) {
        return null;
      }
      return {
        length,
        data: header.add(lengthSize)
      };
    };
    const hasEntry = (objectBase, offset, needle, info) => {
      try {
        const artArray = readArtArray(objectBase, offset, info.artArrayLengthSize);
        if (artArray === null) {
          return false;
        }
        const artArrayEnd = Math.min(artArray.length, info.artArrayMax);
        for (let i = 0; i !== artArrayEnd; i++) {
          const fieldPtr = artArray.data.add(i * info.artArrayEntrySize);
          if (fieldPtr.equals(needle)) {
            return true;
          }
        }
      } catch {
      }
      return false;
    };
    const clazz = env.findClass("java/lang/Thread");
    const clazzRef = env.newGlobalRef(clazz);
    try {
      let object;
      withRunnableArtThread(vm3, env, (thread) => {
        object = getApi()["art::JavaVMExt::DecodeGlobal"](vm3, thread, clazzRef);
      });
      const fieldInstance = env.getFieldId(clazzRef, "name", "Ljava/lang/String;");
      const fieldStatic = env.getStaticFieldId(clazzRef, "MAX_PRIORITY", "I");
      let offsetStatic = -1;
      let offsetInstance = -1;
      for (let offset = 0; offset !== MAX_OFFSET; offset += 4) {
        if (offsetStatic === -1 && hasEntry(object, offset, fieldStatic, fInfo)) {
          offsetStatic = offset;
        }
        if (offsetInstance === -1 && hasEntry(object, offset, fieldInstance, fInfo)) {
          offsetInstance = offset;
        }
      }
      if (offsetInstance === -1 || offsetStatic === -1) {
        throw new Error("Unable to find fields in java/lang/Thread; please file a bug");
      }
      const sfieldOffset = offsetInstance !== offsetStatic ? offsetStatic : 0;
      const ifieldOffset = offsetInstance;
      let offsetMethods = -1;
      const methodInstance = env.getMethodId(clazzRef, "getName", "()Ljava/lang/String;");
      for (let offset = 0; offset !== MAX_OFFSET; offset += 4) {
        if (offsetMethods === -1 && hasEntry(object, offset, methodInstance, mInfo)) {
          offsetMethods = offset;
        }
      }
      if (offsetMethods === -1) {
        throw new Error("Unable to find methods in java/lang/Thread; please file a bug");
      }
      let offsetCopiedMethods = -1;
      const methodsArray = readArtArray(object, offsetMethods, mInfo.artArrayLengthSize);
      const methodsArraySize = methodsArray.length;
      for (let offset = offsetMethods; offset !== MAX_OFFSET; offset += 4) {
        if (object.add(offset).readU16() === methodsArraySize) {
          offsetCopiedMethods = offset;
          break;
        }
      }
      if (offsetCopiedMethods === -1) {
        throw new Error("Unable to find copied methods in java/lang/Thread; please file a bug");
      }
      spec = {
        offset: {
          ifields: ifieldOffset,
          methods: offsetMethods,
          sfields: sfieldOffset,
          copiedMethodsOffset: offsetCopiedMethods
        }
      };
    } finally {
      env.deleteLocalRef(clazz);
      env.deleteGlobalRef(clazzRef);
    }
  });
  return spec;
}
function _getArtMethodSpec(vm3) {
  const api3 = getApi();
  let spec;
  vm3.perform((env) => {
    const process = env.findClass("android/os/Process");
    const getElapsedCpuTime = unwrapMethodId(env.getStaticMethodId(process, "getElapsedCpuTime", "()J"));
    env.deleteLocalRef(process);
    const runtimeModule = Process.getModuleByName("libandroid_runtime.so");
    const runtimeStart = runtimeModule.base;
    const runtimeEnd = runtimeStart.add(runtimeModule.size);
    const apiLevel = getAndroidApiLevel();
    const entrypointFieldSize = apiLevel <= 21 ? 8 : pointerSize7;
    const expectedAccessFlags = kAccPublic | kAccStatic | kAccFinal | kAccNative;
    const relevantAccessFlagsMask = ~(kAccFastInterpreterToInterpreterInvoke | kAccPublicApi | kAccNterpInvokeFastPathFlag) >>> 0;
    let jniCodeOffset = null;
    let accessFlagsOffset = null;
    let remaining = 2;
    for (let offset = 0; offset !== 64 && remaining !== 0; offset += 4) {
      const field = getElapsedCpuTime.add(offset);
      if (jniCodeOffset === null) {
        const address = field.readPointer();
        if (address.compare(runtimeStart) >= 0 && address.compare(runtimeEnd) < 0) {
          jniCodeOffset = offset;
          remaining--;
        }
      }
      if (accessFlagsOffset === null) {
        const flags = field.readU32();
        if ((flags & relevantAccessFlagsMask) === expectedAccessFlags) {
          accessFlagsOffset = offset;
          remaining--;
        }
      }
    }
    if (remaining !== 0) {
      throw new Error("Unable to determine ArtMethod field offsets");
    }
    const quickCodeOffset = jniCodeOffset + entrypointFieldSize;
    const size = apiLevel <= 21 ? quickCodeOffset + 32 : quickCodeOffset + pointerSize7;
    spec = {
      size,
      offset: {
        jniCode: jniCodeOffset,
        quickCode: quickCodeOffset,
        accessFlags: accessFlagsOffset
      }
    };
    if ("artInterpreterToCompiledCodeBridge" in api3) {
      spec.offset.interpreterCode = jniCodeOffset - entrypointFieldSize;
    }
  });
  return spec;
}
function getArtFieldSpec(vm3) {
  const apiLevel = getAndroidApiLevel();
  if (apiLevel >= 23) {
    return {
      size: 16,
      offset: {
        accessFlags: 4
      }
    };
  }
  if (apiLevel >= 21) {
    return {
      size: 24,
      offset: {
        accessFlags: 12
      }
    };
  }
  return null;
}
function _getArtThreadSpec(vm3) {
  const apiLevel = getAndroidApiLevel();
  let spec;
  vm3.perform((env) => {
    const threadHandle = getArtThreadFromEnv(env);
    const envHandle = env.handle;
    let isExceptionReportedOffset = null;
    let exceptionOffset = null;
    let throwLocationOffset = null;
    let topHandleScopeOffset = null;
    let managedStackOffset = null;
    let selfOffset = null;
    for (let offset = 144; offset !== 256; offset += pointerSize7) {
      const field = threadHandle.add(offset);
      const value = field.readPointer();
      if (value.equals(envHandle)) {
        exceptionOffset = offset - 6 * pointerSize7;
        managedStackOffset = offset - 4 * pointerSize7;
        selfOffset = offset + 2 * pointerSize7;
        if (apiLevel <= 22) {
          exceptionOffset -= pointerSize7;
          isExceptionReportedOffset = exceptionOffset - pointerSize7 - 9 * 8 - 3 * 4;
          throwLocationOffset = offset + 6 * pointerSize7;
          managedStackOffset -= pointerSize7;
          selfOffset -= pointerSize7;
        }
        topHandleScopeOffset = offset + 9 * pointerSize7;
        if (apiLevel <= 22) {
          topHandleScopeOffset += 2 * pointerSize7 + 4;
          if (pointerSize7 === 8) {
            topHandleScopeOffset += 4;
          }
        }
        if (apiLevel >= 23) {
          topHandleScopeOffset += pointerSize7;
        }
        break;
      }
    }
    if (topHandleScopeOffset === null) {
      throw new Error("Unable to determine ArtThread field offsets");
    }
    spec = {
      offset: {
        isExceptionReportedToInstrumentation: isExceptionReportedOffset,
        exception: exceptionOffset,
        throwLocation: throwLocationOffset,
        topHandleScope: topHandleScopeOffset,
        managedStack: managedStackOffset,
        self: selfOffset
      }
    };
  });
  return spec;
}
function _getArtManagedStackSpec() {
  const apiLevel = getAndroidApiLevel();
  if (apiLevel >= 23) {
    return {
      offset: {
        topQuickFrame: 0,
        link: pointerSize7
      }
    };
  } else {
    return {
      offset: {
        topQuickFrame: 2 * pointerSize7,
        link: 0
      }
    };
  }
}
var artQuickTrampolineParsers = {
  ia32: parseArtQuickTrampolineX86,
  x64: parseArtQuickTrampolineX86,
  arm: parseArtQuickTrampolineArm,
  arm64: parseArtQuickTrampolineArm64
};
function getArtQuickEntrypointFromTrampoline(trampoline, vm3) {
  let address;
  vm3.perform((env) => {
    const thread = getArtThreadFromEnv(env);
    const tryParse = artQuickTrampolineParsers[Process.arch];
    const insn = Instruction.parse(trampoline);
    const offset = tryParse(insn);
    if (offset !== null) {
      address = thread.add(offset).readPointer();
    } else {
      address = trampoline;
    }
  });
  return address;
}
function parseArtQuickTrampolineX86(insn) {
  if (insn.mnemonic === "jmp") {
    return insn.operands[0].value.disp;
  }
  return null;
}
function parseArtQuickTrampolineArm(insn) {
  if (insn.mnemonic === "ldr.w") {
    return insn.operands[1].value.disp;
  }
  return null;
}
function parseArtQuickTrampolineArm64(insn) {
  if (insn.mnemonic === "ldr") {
    return insn.operands[1].value.disp;
  }
  return null;
}
function getArtThreadFromEnv(env) {
  return env.handle.add(pointerSize7).readPointer();
}
function _getAndroidVersion() {
  return getAndroidSystemProperty("ro.build.version.release");
}
function _getAndroidCodename() {
  return getAndroidSystemProperty("ro.build.version.codename");
}
function _getAndroidApiLevel() {
  return parseInt(getAndroidSystemProperty("ro.build.version.sdk"), 10);
}
var systemPropertyGet = null;
var PROP_VALUE_MAX = 92;
function getAndroidSystemProperty(name) {
  if (systemPropertyGet === null) {
    systemPropertyGet = new NativeFunction(
      Process.getModuleByName("libc.so").getExportByName("__system_property_get"),
      "int",
      ["pointer", "pointer"],
      nativeFunctionOptions3
    );
  }
  const buf = Memory.alloc(PROP_VALUE_MAX);
  systemPropertyGet(Memory.allocUtf8String(name), buf);
  return buf.readUtf8String();
}
function withRunnableArtThread(vm3, env, fn) {
  const perform = getArtThreadStateTransitionImpl(vm3, env);
  const id = getArtThreadFromEnv(env).toString();
  artThreadStateTransitions[id] = fn;
  perform(env.handle);
  if (artThreadStateTransitions[id] !== void 0) {
    delete artThreadStateTransitions[id];
    throw new Error("Unable to perform state transition; please file a bug");
  }
}
function _getArtThreadStateTransitionImpl(vm3, env) {
  const callback = new NativeCallback(onThreadStateTransitionComplete, "void", ["pointer"]);
  return makeArtThreadStateTransitionImpl(vm3, env, callback);
}
function onThreadStateTransitionComplete(thread) {
  const id = thread.toString();
  const fn = artThreadStateTransitions[id];
  delete artThreadStateTransitions[id];
  fn(thread);
}
function withAllArtThreadsSuspended(fn) {
  const api3 = getApi();
  const threadList = api3.artThreadList;
  const longSuspend = false;
  api3["art::ThreadList::SuspendAll"](threadList, Memory.allocUtf8String("frida"), longSuspend ? 1 : 0);
  try {
    fn();
  } finally {
    api3["art::ThreadList::ResumeAll"](threadList);
  }
}
var ArtClassVisitor = class {
  constructor(visit) {
    const visitor = Memory.alloc(4 * pointerSize7);
    const vtable2 = visitor.add(pointerSize7);
    visitor.writePointer(vtable2);
    const onVisit = new NativeCallback((self, klass) => {
      return visit(klass) === true ? 1 : 0;
    }, "bool", ["pointer", "pointer"]);
    vtable2.add(2 * pointerSize7).writePointer(onVisit);
    this.handle = visitor;
    this._onVisit = onVisit;
  }
};
function makeArtClassVisitor(visit) {
  const api3 = getApi();
  if (api3["art::ClassLinker::VisitClasses"] instanceof NativeFunction) {
    return new ArtClassVisitor(visit);
  }
  return new NativeCallback((klass) => {
    return visit(klass) === true ? 1 : 0;
  }, "bool", ["pointer", "pointer"]);
}
var ArtClassLoaderVisitor = class {
  constructor(visit) {
    const visitor = Memory.alloc(4 * pointerSize7);
    const vtable2 = visitor.add(pointerSize7);
    visitor.writePointer(vtable2);
    const onVisit = new NativeCallback((self, klass) => {
      visit(klass);
    }, "void", ["pointer", "pointer"]);
    vtable2.add(2 * pointerSize7).writePointer(onVisit);
    this.handle = visitor;
    this._onVisit = onVisit;
  }
};
function makeArtClassLoaderVisitor(visit) {
  return new ArtClassLoaderVisitor(visit);
}
var WalkKind = {
  "include-inlined-frames": 0,
  "skip-inlined-frames": 1
};
var ArtStackVisitor = class {
  constructor(thread, context, walkKind, numFrames = 0, checkSuspended = true) {
    const api3 = getApi();
    const baseSize = 512;
    const vtableSize = 3 * pointerSize7;
    const visitor = Memory.alloc(baseSize + vtableSize);
    api3["art::StackVisitor::StackVisitor"](
      visitor,
      thread,
      context,
      WalkKind[walkKind],
      numFrames,
      checkSuspended ? 1 : 0
    );
    const vtable2 = visitor.add(baseSize);
    visitor.writePointer(vtable2);
    const onVisitFrame = new NativeCallback(this._visitFrame.bind(this), "bool", ["pointer"]);
    vtable2.add(2 * pointerSize7).writePointer(onVisitFrame);
    this.handle = visitor;
    this._onVisitFrame = onVisitFrame;
    const curShadowFrame = visitor.add(pointerSize7 === 4 ? 12 : 24);
    this._curShadowFrame = curShadowFrame;
    this._curQuickFrame = curShadowFrame.add(pointerSize7);
    this._curQuickFramePc = curShadowFrame.add(2 * pointerSize7);
    this._curOatQuickMethodHeader = curShadowFrame.add(3 * pointerSize7);
    this._getMethodImpl = api3["art::StackVisitor::GetMethod"];
    this._descLocImpl = api3["art::StackVisitor::DescribeLocation"];
    this._getCQFIImpl = api3["art::StackVisitor::GetCurrentQuickFrameInfo"];
  }
  walkStack(includeTransitions = false) {
    getApi()["art::StackVisitor::WalkStack"](this.handle, includeTransitions ? 1 : 0);
  }
  _visitFrame() {
    return this.visitFrame() ? 1 : 0;
  }
  visitFrame() {
    throw new Error("Subclass must implement visitFrame");
  }
  getMethod() {
    const methodHandle = this._getMethodImpl(this.handle);
    if (methodHandle.isNull()) {
      return null;
    }
    return new ArtMethod(methodHandle);
  }
  getCurrentQuickFramePc() {
    return this._curQuickFramePc.readPointer();
  }
  getCurrentQuickFrame() {
    return this._curQuickFrame.readPointer();
  }
  getCurrentShadowFrame() {
    return this._curShadowFrame.readPointer();
  }
  describeLocation() {
    const result = new StdString();
    this._descLocImpl(result, this.handle);
    return result.disposeToString();
  }
  getCurrentOatQuickMethodHeader() {
    return this._curOatQuickMethodHeader.readPointer();
  }
  getCurrentQuickFrameInfo() {
    return this._getCQFIImpl(this.handle);
  }
};
var ArtMethod = class {
  constructor(handle2) {
    this.handle = handle2;
  }
  prettyMethod(withSignature = true) {
    const result = new StdString();
    getApi()["art::ArtMethod::PrettyMethod"](result, this.handle, withSignature ? 1 : 0);
    return result.disposeToString();
  }
  toString() {
    return `ArtMethod(handle=${this.handle})`;
  }
};
function makeArtQuickFrameInfoGetter(impl) {
  return function(self) {
    const result = Memory.alloc(12);
    getArtQuickFrameInfoGetterThunk(impl)(result, self);
    return {
      frameSizeInBytes: result.readU32(),
      coreSpillMask: result.add(4).readU32(),
      fpSpillMask: result.add(8).readU32()
    };
  };
}
function _getArtQuickFrameInfoGetterThunk(impl) {
  let thunk = NULL;
  switch (Process.arch) {
    case "ia32":
      thunk = makeThunk(32, (writer) => {
        writer.putMovRegRegOffsetPtr("ecx", "esp", 4);
        writer.putMovRegRegOffsetPtr("edx", "esp", 8);
        writer.putCallAddressWithArguments(impl, ["ecx", "edx"]);
        writer.putMovRegReg("esp", "ebp");
        writer.putPopReg("ebp");
        writer.putRet();
      });
      break;
    case "x64":
      thunk = makeThunk(32, (writer) => {
        writer.putPushReg("rdi");
        writer.putCallAddressWithArguments(impl, ["rsi"]);
        writer.putPopReg("rdi");
        writer.putMovRegPtrReg("rdi", "rax");
        writer.putMovRegOffsetPtrReg("rdi", 8, "edx");
        writer.putRet();
      });
      break;
    case "arm":
      thunk = makeThunk(16, (writer) => {
        writer.putCallAddressWithArguments(impl, ["r0", "r1"]);
        writer.putPopRegs(["r0", "lr"]);
        writer.putMovRegReg("pc", "lr");
      });
      break;
    case "arm64":
      thunk = makeThunk(64, (writer) => {
        writer.putPushRegReg("x0", "lr");
        writer.putCallAddressWithArguments(impl, ["x1"]);
        writer.putPopRegReg("x2", "lr");
        writer.putStrRegRegOffset("x0", "x2", 0);
        writer.putStrRegRegOffset("w1", "x2", 8);
        writer.putRet();
      });
      break;
  }
  return new NativeFunction(thunk, "void", ["pointer", "pointer"], nativeFunctionOptions3);
}
var thunkRelocators = {
  ia32: globalThis.X86Relocator,
  x64: globalThis.X86Relocator,
  arm: globalThis.ThumbRelocator,
  arm64: globalThis.Arm64Relocator
};
var thunkWriters = {
  ia32: globalThis.X86Writer,
  x64: globalThis.X86Writer,
  arm: globalThis.ThumbWriter,
  arm64: globalThis.Arm64Writer
};
function makeThunk(size, write3) {
  if (thunkPage === null) {
    thunkPage = Memory.alloc(Process.pageSize);
  }
  const thunk = thunkPage.add(thunkOffset);
  const arch = Process.arch;
  const Writer = thunkWriters[arch];
  Memory.patchCode(thunk, size, (code4) => {
    const writer = new Writer(code4, { pc: thunk });
    write3(writer);
    writer.flush();
    if (writer.offset > size) {
      throw new Error(`Wrote ${writer.offset}, exceeding maximum of ${size}`);
    }
  });
  thunkOffset += size;
  return arch === "arm" ? thunk.or(1) : thunk;
}
function notifyArtMethodHooked(method2, vm3) {
  ensureArtKnowsHowToHandleMethodInstrumentation(vm3);
  ensureArtKnowsHowToHandleReplacementMethods(vm3);
}
function makeArtController(api3, vm3) {
  const threadOffsets = getArtThreadSpec(vm3).offset;
  const managedStackOffsets = getArtManagedStackSpec().offset;
  const code4 = `
#include <gum/guminterceptor.h>

extern GMutex lock;
extern GHashTable * methods;
extern GHashTable * replacements;
extern gpointer last_seen_art_method;

extern gpointer get_oat_quick_method_header_impl (gpointer method, gpointer pc);

void
init (void)
{
  g_mutex_init (&lock);
  methods = g_hash_table_new_full (NULL, NULL, NULL, NULL);
  replacements = g_hash_table_new_full (NULL, NULL, NULL, NULL);
}

void
finalize (void)
{
  g_hash_table_unref (replacements);
  g_hash_table_unref (methods);
  g_mutex_clear (&lock);
}

gboolean
is_replacement_method (gpointer method)
{
  gboolean is_replacement;

  g_mutex_lock (&lock);

  is_replacement = g_hash_table_contains (replacements, method);

  g_mutex_unlock (&lock);

  return is_replacement;
}

gpointer
get_replacement_method (gpointer original_method)
{
  gpointer replacement_method;

  g_mutex_lock (&lock);

  replacement_method = g_hash_table_lookup (methods, original_method);

  g_mutex_unlock (&lock);

  return replacement_method;
}

void
set_replacement_method (gpointer original_method,
                        gpointer replacement_method)
{
  g_mutex_lock (&lock);

  g_hash_table_insert (methods, original_method, replacement_method);
  g_hash_table_insert (replacements, replacement_method, original_method);

  g_mutex_unlock (&lock);
}

void
delete_replacement_method (gpointer original_method)
{
  gpointer replacement_method;

  g_mutex_lock (&lock);

  replacement_method = g_hash_table_lookup (methods, original_method);
  if (replacement_method != NULL)
  {
    g_hash_table_remove (methods, original_method);
    g_hash_table_remove (replacements, replacement_method);
  }

  g_mutex_unlock (&lock);
}

gpointer
translate_method (gpointer method)
{
  gpointer translated_method;

  g_mutex_lock (&lock);

  translated_method = g_hash_table_lookup (replacements, method);

  g_mutex_unlock (&lock);

  return (translated_method != NULL) ? translated_method : method;
}

gpointer
find_replacement_method_from_quick_code (gpointer method,
                                         gpointer thread)
{
  gpointer replacement_method;
  gpointer managed_stack;
  gpointer top_quick_frame;
  gpointer link_managed_stack;
  gpointer * link_top_quick_frame;

  replacement_method = get_replacement_method (method);
  if (replacement_method == NULL)
    return NULL;

  /*
   * Stack check.
   *
   * Return NULL to indicate that the original method should be invoked, otherwise
   * return a pointer to the replacement ArtMethod.
   *
   * If the caller is our own JNI replacement stub, then a stack transition must
   * have been pushed onto the current thread's linked list.
   *
   * Therefore, we invoke the original method if the following conditions are met:
   *   1- The current managed stack is empty.
   *   2- The ArtMethod * inside the linked managed stack's top quick frame is the
   *      same as our replacement.
   */
  managed_stack = thread + ${threadOffsets.managedStack};
  top_quick_frame = *((gpointer *) (managed_stack + ${managedStackOffsets.topQuickFrame}));
  if (top_quick_frame != NULL)
    return replacement_method;

  link_managed_stack = *((gpointer *) (managed_stack + ${managedStackOffsets.link}));
  if (link_managed_stack == NULL)
    return replacement_method;

  link_top_quick_frame = GSIZE_TO_POINTER (*((gsize *) (link_managed_stack + ${managedStackOffsets.topQuickFrame})) & ~((gsize) 1));
  if (link_top_quick_frame == NULL || *link_top_quick_frame != replacement_method)
    return replacement_method;

  return NULL;
}

void
on_interpreter_do_call (GumInvocationContext * ic)
{
  gpointer method, replacement_method;

  method = gum_invocation_context_get_nth_argument (ic, 0);

  replacement_method = get_replacement_method (method);
  if (replacement_method != NULL)
    gum_invocation_context_replace_nth_argument (ic, 0, replacement_method);
}

gpointer
on_art_method_get_oat_quick_method_header (gpointer method,
                                           gpointer pc)
{
  if (is_replacement_method (method))
    return NULL;

  return get_oat_quick_method_header_impl (method, pc);
}

void
on_art_method_pretty_method (GumInvocationContext * ic)
{
  const guint this_arg_index = ${Process.arch === "arm64" ? 0 : 1};
  gpointer method;

  method = gum_invocation_context_get_nth_argument (ic, this_arg_index);
  if (method == NULL)
    gum_invocation_context_replace_nth_argument (ic, this_arg_index, last_seen_art_method);
  else
    last_seen_art_method = method;
}

void
on_leave_gc_concurrent_copying_copying_phase (GumInvocationContext * ic)
{
  GHashTableIter iter;
  gpointer hooked_method, replacement_method;

  g_mutex_lock (&lock);

  g_hash_table_iter_init (&iter, methods);
  while (g_hash_table_iter_next (&iter, &hooked_method, &replacement_method))
    *((uint32_t *) replacement_method) = *((uint32_t *) hooked_method);

  g_mutex_unlock (&lock);
}
`;
  const lockSize = 8;
  const methodsSize = pointerSize7;
  const replacementsSize = pointerSize7;
  const lastSeenArtMethodSize = pointerSize7;
  const data = Memory.alloc(lockSize + methodsSize + replacementsSize + lastSeenArtMethodSize);
  const lock = data;
  const methods = lock.add(lockSize);
  const replacements = methods.add(methodsSize);
  const lastSeenArtMethod = replacements.add(replacementsSize);
  const getOatQuickMethodHeaderImpl = api3.find(pointerSize7 === 4 ? "_ZN3art9ArtMethod23GetOatQuickMethodHeaderEj" : "_ZN3art9ArtMethod23GetOatQuickMethodHeaderEm");
  const cm2 = new CModule(code4, {
    lock,
    methods,
    replacements,
    last_seen_art_method: lastSeenArtMethod,
    get_oat_quick_method_header_impl: getOatQuickMethodHeaderImpl ?? ptr("0xdeadbeef")
  });
  const fastOptions = { exceptions: "propagate", scheduling: "exclusive" };
  return {
    handle: cm2,
    replacedMethods: {
      isReplacement: new NativeFunction(cm2.is_replacement_method, "bool", ["pointer"], fastOptions),
      get: new NativeFunction(cm2.get_replacement_method, "pointer", ["pointer"], fastOptions),
      set: new NativeFunction(cm2.set_replacement_method, "void", ["pointer", "pointer"], fastOptions),
      delete: new NativeFunction(cm2.delete_replacement_method, "void", ["pointer"], fastOptions),
      translate: new NativeFunction(cm2.translate_method, "pointer", ["pointer"], fastOptions),
      findReplacementFromQuickCode: cm2.find_replacement_method_from_quick_code
    },
    getOatQuickMethodHeaderImpl,
    hooks: {
      Interpreter: {
        doCall: cm2.on_interpreter_do_call
      },
      ArtMethod: {
        getOatQuickMethodHeader: cm2.on_art_method_get_oat_quick_method_header,
        prettyMethod: cm2.on_art_method_pretty_method
      },
      Gc: {
        copyingPhase: {
          onLeave: cm2.on_leave_gc_concurrent_copying_copying_phase
        },
        runFlip: {
          onEnter: cm2.on_leave_gc_concurrent_copying_copying_phase
        }
      }
    }
  };
}
function ensureArtKnowsHowToHandleMethodInstrumentation(vm3) {
  if (taughtArtAboutMethodInstrumentation) {
    return;
  }
  taughtArtAboutMethodInstrumentation = true;
  instrumentArtQuickEntrypoints(vm3);
  instrumentArtMethodInvocationFromInterpreter();
}
function instrumentArtQuickEntrypoints(vm3) {
  const api3 = getApi();
  const quickEntrypoints = [
    api3.artQuickGenericJniTrampoline,
    api3.artQuickToInterpreterBridge,
    api3.artQuickResolutionTrampoline
  ];
  quickEntrypoints.forEach((entrypoint) => {
    Memory.protect(entrypoint, 32, "rwx");
    const interceptor = new ArtQuickCodeInterceptor(entrypoint);
    interceptor.activate(vm3);
    artQuickInterceptors.push(interceptor);
  });
}
function instrumentArtMethodInvocationFromInterpreter() {
  const api3 = getApi();
  const apiLevel = getAndroidApiLevel();
  const { isApiLevel34OrApexEquivalent } = api3;
  let artInterpreterDoCallExportRegex;
  if (apiLevel <= 22) {
    artInterpreterDoCallExportRegex = /^_ZN3art11interpreter6DoCallILb[0-1]ELb[0-1]EEEbPNS_6mirror9ArtMethodEPNS_6ThreadERNS_11ShadowFrameEPKNS_11InstructionEtPNS_6JValueE$/;
  } else if (apiLevel <= 33 && !isApiLevel34OrApexEquivalent) {
    artInterpreterDoCallExportRegex = /^_ZN3art11interpreter6DoCallILb[0-1]ELb[0-1]EEEbPNS_9ArtMethodEPNS_6ThreadERNS_11ShadowFrameEPKNS_11InstructionEtPNS_6JValueE$/;
  } else if (isApiLevel34OrApexEquivalent) {
    artInterpreterDoCallExportRegex = /^_ZN3art11interpreter6DoCallILb[0-1]EEEbPNS_9ArtMethodEPNS_6ThreadERNS_11ShadowFrameEPKNS_11InstructionEtbPNS_6JValueE$/;
  } else {
    throw new Error("Unable to find method invocation in ART; please file a bug");
  }
  const art = api3.module;
  const entries = [...art.enumerateExports(), ...art.enumerateSymbols()].filter((entry) => artInterpreterDoCallExportRegex.test(entry.name));
  if (entries.length === 0) {
    throw new Error("Unable to find method invocation in ART; please file a bug");
  }
  for (const entry of entries) {
    Interceptor.attach(entry.address, artController.hooks.Interpreter.doCall);
  }
}
function ensureArtKnowsHowToHandleReplacementMethods(vm3) {
  if (taughtArtAboutReplacementMethods) {
    return;
  }
  taughtArtAboutReplacementMethods = true;
  if (!maybeInstrumentGetOatQuickMethodHeaderInlineCopies()) {
    const { getOatQuickMethodHeaderImpl } = artController;
    if (getOatQuickMethodHeaderImpl === null) {
      return;
    }
    try {
      Interceptor.replace(getOatQuickMethodHeaderImpl, artController.hooks.ArtMethod.getOatQuickMethodHeader);
    } catch (e) {
    }
  }
  const apiLevel = getAndroidApiLevel();
  let copyingPhase = null;
  const api3 = getApi();
  if (apiLevel > 28) {
    copyingPhase = api3.find("_ZN3art2gc9collector17ConcurrentCopying12CopyingPhaseEv");
  } else if (apiLevel > 22) {
    copyingPhase = api3.find("_ZN3art2gc9collector17ConcurrentCopying12MarkingPhaseEv");
  }
  if (copyingPhase !== null) {
    Interceptor.attach(copyingPhase, artController.hooks.Gc.copyingPhase);
  }
  let runFlip = null;
  runFlip = api3.find("_ZN3art6Thread15RunFlipFunctionEPS0_");
  if (runFlip === null) {
    runFlip = api3.find("_ZN3art6Thread15RunFlipFunctionEPS0_b");
  }
  if (runFlip !== null) {
    Interceptor.attach(runFlip, artController.hooks.Gc.runFlip);
  }
}
var artGetOatQuickMethodHeaderInlinedCopyHandler = {
  arm: {
    signatures: [
      {
        pattern: [
          "b0 68",
          // ldr r0, [r6, #8]
          "01 30",
          // adds r0, #1
          "0c d0",
          // beq #0x16fcd4
          "1b 98",
          // ldr r0, [sp, #0x6c]
          ":",
          "c0 ff",
          "c0 ff",
          "00 ff",
          "00 2f"
        ],
        validateMatch: validateGetOatQuickMethodHeaderInlinedMatchArm
      },
      {
        pattern: [
          "d8 f8 08 00",
          // ldr r0, [r8, #8]
          "01 30",
          // adds r0, #1
          "0c d0",
          // beq #0x16fcd4
          "1b 98",
          // ldr r0, [sp, #0x6c]
          ":",
          "f0 ff ff 0f",
          "ff ff",
          "00 ff",
          "00 2f"
        ],
        validateMatch: validateGetOatQuickMethodHeaderInlinedMatchArm
      },
      {
        pattern: [
          "b0 68",
          // ldr r0, [r6, #8]
          "01 30",
          // adds r0, #1
          "40 f0 c3 80",
          // bne #0x203bf0
          "00 25",
          // movs r5, #0
          ":",
          "c0 ff",
          "c0 ff",
          "c0 fb 00 d0",
          "ff f8"
        ],
        validateMatch: validateGetOatQuickMethodHeaderInlinedMatchArm
      }
    ],
    instrument: instrumentGetOatQuickMethodHeaderInlinedCopyArm
  },
  arm64: {
    signatures: [
      {
        pattern: [
          /* e8 */
          "0a 40 b9",
          // ldr w8, [x23, #0x8]
          "1f 05 00 31",
          // cmn w8, #0x1
          "40 01 00 54",
          // b.eq 0x2e4204
          "88 39 00 f0",
          // adrp x8, 0xa17000
          ":",
          /* 00 */
          "fc ff ff",
          "1f fc ff ff",
          "1f 00 00 ff",
          "00 00 00 9f"
        ],
        offset: 1,
        validateMatch: validateGetOatQuickMethodHeaderInlinedMatchArm64
      },
      {
        pattern: [
          /* e8 */
          "0a 40 b9",
          // ldr w8, [x23, #0x8]
          "1f 05 00 31",
          // cmn w8, #0x1
          "01 34 00 54",
          // b.ne 0x3d8e50
          "e0 03 1f aa",
          // mov x0, xzr
          ":",
          /* 00 */
          "fc ff ff",
          "1f fc ff ff",
          "1f 00 00 ff",
          "e0 ff ff ff"
        ],
        offset: 1,
        validateMatch: validateGetOatQuickMethodHeaderInlinedMatchArm64
      }
    ],
    instrument: instrumentGetOatQuickMethodHeaderInlinedCopyArm64
  }
};
function validateGetOatQuickMethodHeaderInlinedMatchArm({ address, size }) {
  const ldr = Instruction.parse(address.or(1));
  const [ldrDst, ldrSrc] = ldr.operands;
  const methodReg = ldrSrc.value.base;
  const scratchReg = ldrDst.value;
  const branch = Instruction.parse(ldr.next.add(2));
  const targetWhenTrue = ptr(branch.operands[0].value);
  const targetWhenFalse = branch.address.add(branch.size);
  let targetWhenRegularMethod, targetWhenRuntimeMethod;
  if (branch.mnemonic === "beq") {
    targetWhenRegularMethod = targetWhenFalse;
    targetWhenRuntimeMethod = targetWhenTrue;
  } else {
    targetWhenRegularMethod = targetWhenTrue;
    targetWhenRuntimeMethod = targetWhenFalse;
  }
  return parseInstructionsAt(targetWhenRegularMethod.or(1), tryParse, { limit: 3 });
  function tryParse(insn) {
    const { mnemonic } = insn;
    if (!(mnemonic === "ldr" || mnemonic === "ldr.w")) {
      return null;
    }
    const { base, disp } = insn.operands[1].value;
    if (!(base === methodReg && disp === 20)) {
      return null;
    }
    return {
      methodReg,
      scratchReg,
      target: {
        whenTrue: targetWhenTrue,
        whenRegularMethod: targetWhenRegularMethod,
        whenRuntimeMethod: targetWhenRuntimeMethod
      }
    };
  }
}
function validateGetOatQuickMethodHeaderInlinedMatchArm64({ address, size }) {
  const [ldrDst, ldrSrc] = Instruction.parse(address).operands;
  const methodReg = ldrSrc.value.base;
  const scratchReg = "x" + ldrDst.value.substring(1);
  const branch = Instruction.parse(address.add(8));
  const targetWhenTrue = ptr(branch.operands[0].value);
  const targetWhenFalse = address.add(12);
  let targetWhenRegularMethod, targetWhenRuntimeMethod;
  if (branch.mnemonic === "b.eq") {
    targetWhenRegularMethod = targetWhenFalse;
    targetWhenRuntimeMethod = targetWhenTrue;
  } else {
    targetWhenRegularMethod = targetWhenTrue;
    targetWhenRuntimeMethod = targetWhenFalse;
  }
  return parseInstructionsAt(targetWhenRegularMethod, tryParse, { limit: 3 });
  function tryParse(insn) {
    if (insn.mnemonic !== "ldr") {
      return null;
    }
    const { base, disp } = insn.operands[1].value;
    if (!(base === methodReg && disp === 24)) {
      return null;
    }
    return {
      methodReg,
      scratchReg,
      target: {
        whenTrue: targetWhenTrue,
        whenRegularMethod: targetWhenRegularMethod,
        whenRuntimeMethod: targetWhenRuntimeMethod
      }
    };
  }
}
function maybeInstrumentGetOatQuickMethodHeaderInlineCopies() {
  if (getAndroidApiLevel() < 31) {
    return false;
  }
  const handler = artGetOatQuickMethodHeaderInlinedCopyHandler[Process.arch];
  if (handler === void 0) {
    return false;
  }
  const signatures = handler.signatures.map(({ pattern, offset = 0, validateMatch = returnEmptyObject }) => {
    return {
      pattern: new MatchPattern(pattern.join("")),
      offset,
      validateMatch
    };
  });
  const impls = [];
  for (const { base, size } of getApi().module.enumerateRanges("--x")) {
    for (const { pattern, offset, validateMatch } of signatures) {
      const matches = Memory.scanSync(base, size, pattern).map(({ address, size: size2 }) => {
        return { address: address.sub(offset), size: size2 + offset };
      }).filter((match) => {
        const validationResult = validateMatch(match);
        if (validationResult === null) {
          return false;
        }
        match.validationResult = validationResult;
        return true;
      });
      impls.push(...matches);
    }
  }
  if (impls.length === 0) {
    return false;
  }
  impls.forEach(handler.instrument);
  return true;
}
function returnEmptyObject() {
  return {};
}
var InlineHook = class {
  constructor(address, size, trampoline) {
    this.address = address;
    this.size = size;
    this.originalCode = address.readByteArray(size);
    this.trampoline = trampoline;
  }
  revert() {
    Memory.patchCode(this.address, this.size, (code4) => {
      code4.writeByteArray(this.originalCode);
    });
  }
};
function instrumentGetOatQuickMethodHeaderInlinedCopyArm({ address, size, validationResult }) {
  const { methodReg, target } = validationResult;
  const trampoline = Memory.alloc(Process.pageSize);
  let redirectCapacity = size;
  Memory.patchCode(trampoline, 256, (code4) => {
    const writer = new ThumbWriter(code4, { pc: trampoline });
    const relocator = new ThumbRelocator(address, writer);
    for (let i = 0; i !== 2; i++) {
      relocator.readOne();
    }
    relocator.writeAll();
    relocator.readOne();
    relocator.skipOne();
    writer.putBCondLabel("eq", "runtime_or_replacement_method");
    const vpushFpRegs = [45, 237, 16, 10];
    writer.putBytes(vpushFpRegs);
    const savedRegs = ["r0", "r1", "r2", "r3"];
    writer.putPushRegs(savedRegs);
    writer.putCallAddressWithArguments(artController.replacedMethods.isReplacement, [methodReg]);
    writer.putCmpRegImm("r0", 0);
    writer.putPopRegs(savedRegs);
    const vpopFpRegs = [189, 236, 16, 10];
    writer.putBytes(vpopFpRegs);
    writer.putBCondLabel("ne", "runtime_or_replacement_method");
    writer.putBLabel("regular_method");
    relocator.readOne();
    const tailIsRegular = relocator.input.address.equals(target.whenRegularMethod);
    writer.putLabel(tailIsRegular ? "regular_method" : "runtime_or_replacement_method");
    relocator.writeOne();
    while (redirectCapacity < 10) {
      const offset = relocator.readOne();
      if (offset === 0) {
        redirectCapacity = 10;
        break;
      }
      redirectCapacity = offset;
    }
    relocator.writeAll();
    writer.putBranchAddress(address.add(redirectCapacity + 1));
    writer.putLabel(tailIsRegular ? "runtime_or_replacement_method" : "regular_method");
    writer.putBranchAddress(target.whenTrue);
    writer.flush();
  });
  inlineHooks.push(new InlineHook(address, redirectCapacity, trampoline));
  Memory.patchCode(address, redirectCapacity, (code4) => {
    const writer = new ThumbWriter(code4, { pc: address });
    writer.putLdrRegAddress("pc", trampoline.or(1));
    writer.flush();
  });
}
function instrumentGetOatQuickMethodHeaderInlinedCopyArm64({ address, size, validationResult }) {
  const { methodReg, scratchReg, target } = validationResult;
  const trampoline = Memory.alloc(Process.pageSize);
  Memory.patchCode(trampoline, 256, (code4) => {
    const writer = new Arm64Writer(code4, { pc: trampoline });
    const relocator = new Arm64Relocator(address, writer);
    for (let i = 0; i !== 2; i++) {
      relocator.readOne();
    }
    relocator.writeAll();
    relocator.readOne();
    relocator.skipOne();
    writer.putBCondLabel("eq", "runtime_or_replacement_method");
    const savedRegs = [
      "d0",
      "d1",
      "d2",
      "d3",
      "d4",
      "d5",
      "d6",
      "d7",
      "x0",
      "x1",
      "x2",
      "x3",
      "x4",
      "x5",
      "x6",
      "x7",
      "x8",
      "x9",
      "x10",
      "x11",
      "x12",
      "x13",
      "x14",
      "x15",
      "x16",
      "x17"
    ];
    const numSavedRegs = savedRegs.length;
    for (let i = 0; i !== numSavedRegs; i += 2) {
      writer.putPushRegReg(savedRegs[i], savedRegs[i + 1]);
    }
    writer.putCallAddressWithArguments(artController.replacedMethods.isReplacement, [methodReg]);
    writer.putCmpRegReg("x0", "xzr");
    for (let i = numSavedRegs - 2; i >= 0; i -= 2) {
      writer.putPopRegReg(savedRegs[i], savedRegs[i + 1]);
    }
    writer.putBCondLabel("ne", "runtime_or_replacement_method");
    writer.putBLabel("regular_method");
    relocator.readOne();
    const tailInstruction = relocator.input;
    const tailIsRegular = tailInstruction.address.equals(target.whenRegularMethod);
    writer.putLabel(tailIsRegular ? "regular_method" : "runtime_or_replacement_method");
    relocator.writeOne();
    writer.putBranchAddress(tailInstruction.next);
    writer.putLabel(tailIsRegular ? "runtime_or_replacement_method" : "regular_method");
    writer.putBranchAddress(target.whenTrue);
    writer.flush();
  });
  inlineHooks.push(new InlineHook(address, size, trampoline));
  Memory.patchCode(address, size, (code4) => {
    const writer = new Arm64Writer(code4, { pc: address });
    writer.putLdrRegAddress(scratchReg, trampoline);
    writer.putBrReg(scratchReg);
    writer.flush();
  });
}
function makeMethodMangler(methodId) {
  return new MethodMangler(methodId);
}
function translateMethod(methodId) {
  return artController.replacedMethods.translate(methodId);
}
function backtrace(vm3, options = {}) {
  const { limit = 16 } = options;
  const env = vm3.getEnv();
  if (backtraceModule === null) {
    backtraceModule = makeBacktraceModule(vm3, env);
  }
  return backtraceModule.backtrace(env, limit);
}
function makeBacktraceModule(vm3, env) {
  const api3 = getApi();
  const performImpl = Memory.alloc(Process.pointerSize);
  const cm2 = new CModule(`
#include <glib.h>
#include <stdbool.h>
#include <string.h>
#include <gum/gumtls.h>
#include <json-glib/json-glib.h>

typedef struct _ArtBacktrace ArtBacktrace;
typedef struct _ArtStackFrame ArtStackFrame;

typedef struct _ArtStackVisitor ArtStackVisitor;
typedef struct _ArtStackVisitorVTable ArtStackVisitorVTable;

typedef struct _ArtClass ArtClass;
typedef struct _ArtMethod ArtMethod;
typedef struct _ArtThread ArtThread;
typedef struct _ArtContext ArtContext;

typedef struct _JNIEnv JNIEnv;

typedef struct _StdString StdString;
typedef struct _StdTinyString StdTinyString;
typedef struct _StdLargeString StdLargeString;

typedef enum {
  STACK_WALK_INCLUDE_INLINED_FRAMES,
  STACK_WALK_SKIP_INLINED_FRAMES,
} StackWalkKind;

struct _StdTinyString
{
  guint8 unused;
  gchar data[(3 * sizeof (gpointer)) - 1];
};

struct _StdLargeString
{
  gsize capacity;
  gsize size;
  gchar * data;
};

struct _StdString
{
  union
  {
    guint8 flags;
    StdTinyString tiny;
    StdLargeString large;
  };
};

struct _ArtBacktrace
{
  GChecksum * id;
  GArray * frames;
  gchar * frames_json;
};

struct _ArtStackFrame
{
  ArtMethod * method;
  gsize dexpc;
  StdString description;
};

struct _ArtStackVisitorVTable
{
  void (* unused1) (void);
  void (* unused2) (void);
  bool (* visit) (ArtStackVisitor * visitor);
};

struct _ArtStackVisitor
{
  ArtStackVisitorVTable * vtable;

  guint8 padding[512];

  ArtStackVisitorVTable vtable_storage;

  ArtBacktrace * backtrace;
};

struct _ArtMethod
{
  guint32 declaring_class;
  guint32 access_flags;
};

extern GumTlsKey current_backtrace;

extern void (* perform_art_thread_state_transition) (JNIEnv * env);

extern ArtContext * art_thread_get_long_jump_context (ArtThread * thread);

extern void art_stack_visitor_init (ArtStackVisitor * visitor, ArtThread * thread, void * context, StackWalkKind walk_kind,
    size_t num_frames, bool check_suspended);
extern void art_stack_visitor_walk_stack (ArtStackVisitor * visitor, bool include_transitions);
extern ArtMethod * art_stack_visitor_get_method (ArtStackVisitor * visitor);
extern void art_stack_visitor_describe_location (StdString * description, ArtStackVisitor * visitor);
extern ArtMethod * translate_method (ArtMethod * method);
extern void translate_location (ArtMethod * method, guint32 pc, const gchar ** source_file, gint32 * line_number);
extern void get_class_location (StdString * result, ArtClass * klass);
extern void cxx_delete (void * mem);
extern unsigned long strtoul (const char * str, char ** endptr, int base);

static bool visit_frame (ArtStackVisitor * visitor);
static void art_stack_frame_destroy (ArtStackFrame * frame);

static void append_jni_type_name (GString * s, const gchar * name, gsize length);

static void std_string_destroy (StdString * str);
static gchar * std_string_get_data (StdString * str);

void
init (void)
{
  current_backtrace = gum_tls_key_new ();
}

void
finalize (void)
{
  gum_tls_key_free (current_backtrace);
}

ArtBacktrace *
_create (JNIEnv * env,
         guint limit)
{
  ArtBacktrace * bt;

  bt = g_new (ArtBacktrace, 1);
  bt->id = g_checksum_new (G_CHECKSUM_SHA1);
  bt->frames = (limit != 0)
      ? g_array_sized_new (FALSE, FALSE, sizeof (ArtStackFrame), limit)
      : g_array_new (FALSE, FALSE, sizeof (ArtStackFrame));
  g_array_set_clear_func (bt->frames, (GDestroyNotify) art_stack_frame_destroy);
  bt->frames_json = NULL;

  gum_tls_key_set_value (current_backtrace, bt);

  perform_art_thread_state_transition (env);

  gum_tls_key_set_value (current_backtrace, NULL);

  return bt;
}

void
_on_thread_state_transition_complete (ArtThread * thread)
{
  ArtContext * context;
  ArtStackVisitor visitor = {
    .vtable_storage = {
      .visit = visit_frame,
    },
  };

  context = art_thread_get_long_jump_context (thread);

  art_stack_visitor_init (&visitor, thread, context, STACK_WALK_SKIP_INLINED_FRAMES, 0, true);
  visitor.vtable = &visitor.vtable_storage;
  visitor.backtrace = gum_tls_key_get_value (current_backtrace);

  art_stack_visitor_walk_stack (&visitor, false);

  cxx_delete (context);
}

static bool
visit_frame (ArtStackVisitor * visitor)
{
  ArtBacktrace * bt = visitor->backtrace;
  ArtStackFrame frame;
  const gchar * description, * dexpc_part;

  frame.method = art_stack_visitor_get_method (visitor);

  art_stack_visitor_describe_location (&frame.description, visitor);

  description = std_string_get_data (&frame.description);
  if (strstr (description, " '<") != NULL)
    goto skip;

  dexpc_part = strstr (description, " at dex PC 0x");
  if (dexpc_part == NULL)
    goto skip;
  frame.dexpc = strtoul (dexpc_part + 13, NULL, 16);

  g_array_append_val (bt->frames, frame);

  g_checksum_update (bt->id, (guchar *) &frame.method, sizeof (frame.method));
  g_checksum_update (bt->id, (guchar *) &frame.dexpc, sizeof (frame.dexpc));

  return true;

skip:
  std_string_destroy (&frame.description);
  return true;
}

static void
art_stack_frame_destroy (ArtStackFrame * frame)
{
  std_string_destroy (&frame->description);
}

void
_destroy (ArtBacktrace * backtrace)
{
  g_free (backtrace->frames_json);
  g_array_free (backtrace->frames, TRUE);
  g_checksum_free (backtrace->id);
  g_free (backtrace);
}

const gchar *
_get_id (ArtBacktrace * backtrace)
{
  return g_checksum_get_string (backtrace->id);
}

const gchar *
_get_frames (ArtBacktrace * backtrace)
{
  GArray * frames = backtrace->frames;
  JsonBuilder * b;
  guint i;
  JsonNode * root;

  if (backtrace->frames_json != NULL)
    return backtrace->frames_json;

  b = json_builder_new_immutable ();

  json_builder_begin_array (b);

  for (i = 0; i != frames->len; i++)
  {
    ArtStackFrame * frame = &g_array_index (frames, ArtStackFrame, i);
    gchar * description, * ret_type, * paren_open, * paren_close, * arg_types, * token, * method_name, * class_name;
    GString * signature;
    gchar * cursor;
    ArtMethod * translated_method;
    StdString location;
    gsize dexpc;
    const gchar * source_file;
    gint32 line_number;

    description = std_string_get_data (&frame->description);

    ret_type = strchr (description, '\\'') + 1;

    paren_open = strchr (ret_type, '(');
    paren_close = strchr (paren_open, ')');
    *paren_open = '\\0';
    *paren_close = '\\0';

    arg_types = paren_open + 1;

    token = strrchr (ret_type, '.');
    *token = '\\0';

    method_name = token + 1;

    token = strrchr (ret_type, ' ');
    *token = '\\0';

    class_name = token + 1;

    signature = g_string_sized_new (128);

    append_jni_type_name (signature, class_name, method_name - class_name - 1);
    g_string_append_c (signature, ',');
    g_string_append (signature, method_name);
    g_string_append (signature, ",(");

    if (arg_types != paren_close)
    {
      for (cursor = arg_types; cursor != NULL;)
      {
        gsize length;
        gchar * next;

        token = strstr (cursor, ", ");
        if (token != NULL)
        {
          length = token - cursor;
          next = token + 2;
        }
        else
        {
          length = paren_close - cursor;
          next = NULL;
        }

        append_jni_type_name (signature, cursor, length);

        cursor = next;
      }
    }

    g_string_append_c (signature, ')');

    append_jni_type_name (signature, ret_type, class_name - ret_type - 1);

    translated_method = translate_method (frame->method);
    dexpc = (translated_method == frame->method) ? frame->dexpc : 0;

    get_class_location (&location, GSIZE_TO_POINTER (translated_method->declaring_class));

    translate_location (translated_method, dexpc, &source_file, &line_number);

    json_builder_begin_object (b);

    json_builder_set_member_name (b, "signature");
    json_builder_add_string_value (b, signature->str);

    json_builder_set_member_name (b, "origin");
    json_builder_add_string_value (b, std_string_get_data (&location));

    json_builder_set_member_name (b, "className");
    json_builder_add_string_value (b, class_name);

    json_builder_set_member_name (b, "methodName");
    json_builder_add_string_value (b, method_name);

    json_builder_set_member_name (b, "methodFlags");
    json_builder_add_int_value (b, translated_method->access_flags);

    json_builder_set_member_name (b, "fileName");
    json_builder_add_string_value (b, source_file);

    json_builder_set_member_name (b, "lineNumber");
    json_builder_add_int_value (b, line_number);

    json_builder_end_object (b);

    std_string_destroy (&location);
    g_string_free (signature, TRUE);
  }

  json_builder_end_array (b);

  root = json_builder_get_root (b);
  backtrace->frames_json = json_to_string (root, FALSE);
  json_node_unref (root);

  return backtrace->frames_json;
}

static void
append_jni_type_name (GString * s,
                      const gchar * name,
                      gsize length)
{
  gchar shorty = '\\0';
  gsize i;

  switch (name[0])
  {
    case 'b':
      if (strncmp (name, "boolean", length) == 0)
        shorty = 'Z';
      else if (strncmp (name, "byte", length) == 0)
        shorty = 'B';
      break;
    case 'c':
      if (strncmp (name, "char", length) == 0)
        shorty = 'C';
      break;
    case 'd':
      if (strncmp (name, "double", length) == 0)
        shorty = 'D';
      break;
    case 'f':
      if (strncmp (name, "float", length) == 0)
        shorty = 'F';
      break;
    case 'i':
      if (strncmp (name, "int", length) == 0)
        shorty = 'I';
      break;
    case 'l':
      if (strncmp (name, "long", length) == 0)
        shorty = 'J';
      break;
    case 's':
      if (strncmp (name, "short", length) == 0)
        shorty = 'S';
      break;
    case 'v':
      if (strncmp (name, "void", length) == 0)
        shorty = 'V';
      break;
  }

  if (shorty != '\\0')
  {
    g_string_append_c (s, shorty);

    return;
  }

  if (length > 2 && name[length - 2] == '[' && name[length - 1] == ']')
  {
    g_string_append_c (s, '[');
    append_jni_type_name (s, name, length - 2);

    return;
  }

  g_string_append_c (s, 'L');

  for (i = 0; i != length; i++)
  {
    gchar ch = name[i];
    if (ch != '.')
      g_string_append_c (s, ch);
    else
      g_string_append_c (s, '/');
  }

  g_string_append_c (s, ';');
}

static void
std_string_destroy (StdString * str)
{
  bool is_large = (str->flags & 1) != 0;
  if (is_large)
    cxx_delete (str->large.data);
}

static gchar *
std_string_get_data (StdString * str)
{
  bool is_large = (str->flags & 1) != 0;
  return is_large ? str->large.data : str->tiny.data;
}
`, {
    current_backtrace: Memory.alloc(Process.pointerSize),
    perform_art_thread_state_transition: performImpl,
    art_thread_get_long_jump_context: api3["art::Thread::GetLongJumpContext"],
    art_stack_visitor_init: api3["art::StackVisitor::StackVisitor"],
    art_stack_visitor_walk_stack: api3["art::StackVisitor::WalkStack"],
    art_stack_visitor_get_method: api3["art::StackVisitor::GetMethod"],
    art_stack_visitor_describe_location: api3["art::StackVisitor::DescribeLocation"],
    translate_method: artController.replacedMethods.translate,
    translate_location: api3["art::Monitor::TranslateLocation"],
    get_class_location: api3["art::mirror::Class::GetLocation"],
    cxx_delete: api3.$delete,
    strtoul: Process.getModuleByName("libc.so").getExportByName("strtoul")
  });
  const _create = new NativeFunction(cm2._create, "pointer", ["pointer", "uint"], nativeFunctionOptions3);
  const _destroy = new NativeFunction(cm2._destroy, "void", ["pointer"], nativeFunctionOptions3);
  const fastOptions = { exceptions: "propagate", scheduling: "exclusive" };
  const _getId = new NativeFunction(cm2._get_id, "pointer", ["pointer"], fastOptions);
  const _getFrames = new NativeFunction(cm2._get_frames, "pointer", ["pointer"], fastOptions);
  const performThreadStateTransition = makeArtThreadStateTransitionImpl(vm3, env, cm2._on_thread_state_transition_complete);
  cm2._performData = performThreadStateTransition;
  performImpl.writePointer(performThreadStateTransition);
  cm2.backtrace = (env2, limit) => {
    const handle2 = _create(env2, limit);
    const bt = new Backtrace(handle2);
    Script.bindWeak(bt, destroy.bind(null, handle2));
    return bt;
  };
  function destroy(handle2) {
    _destroy(handle2);
  }
  cm2.getId = (handle2) => {
    return _getId(handle2).readUtf8String();
  };
  cm2.getFrames = (handle2) => {
    return JSON.parse(_getFrames(handle2).readUtf8String());
  };
  return cm2;
}
var Backtrace = class {
  constructor(handle2) {
    this.handle = handle2;
  }
  get id() {
    return backtraceModule.getId(this.handle);
  }
  get frames() {
    return backtraceModule.getFrames(this.handle);
  }
};
function revertGlobalPatches() {
  patchedClasses.forEach((entry) => {
    entry.vtablePtr.writePointer(entry.vtable);
    entry.vtableCountPtr.writeS32(entry.vtableCount);
  });
  patchedClasses.clear();
  for (const interceptor of artQuickInterceptors.splice(0)) {
    interceptor.deactivate();
  }
  for (const hook of inlineHooks.splice(0)) {
    hook.revert();
  }
}
function unwrapMethodId(methodId) {
  const api3 = getApi();
  const runtimeOffset = getArtRuntimeSpec(api3).offset;
  const jniIdManagerOffset = runtimeOffset.jniIdManager;
  const jniIdsIndirectionOffset = runtimeOffset.jniIdsIndirection;
  if (jniIdManagerOffset !== null && jniIdsIndirectionOffset !== null) {
    const runtime3 = api3.artRuntime;
    const jniIdsIndirection = runtime3.add(jniIdsIndirectionOffset).readInt();
    if (jniIdsIndirection !== kPointer) {
      const jniIdManager = runtime3.add(jniIdManagerOffset).readPointer();
      return api3["art::jni::JniIdManager::DecodeMethodId"](jniIdManager, methodId);
    }
  }
  return methodId;
}
var artQuickCodeReplacementTrampolineWriters = {
  ia32: writeArtQuickCodeReplacementTrampolineIA32,
  x64: writeArtQuickCodeReplacementTrampolineX64,
  arm: writeArtQuickCodeReplacementTrampolineArm,
  arm64: writeArtQuickCodeReplacementTrampolineArm64
};
function writeArtQuickCodeReplacementTrampolineIA32(trampoline, target, redirectSize, constraints, vm3) {
  const threadOffsets = getArtThreadSpec(vm3).offset;
  const artMethodOffsets = getArtMethodSpec(vm3).offset;
  let offset;
  Memory.patchCode(trampoline, 128, (code4) => {
    const writer = new X86Writer(code4, { pc: trampoline });
    const relocator = new X86Relocator(target, writer);
    const fxsave = [15, 174, 4, 36];
    const fxrstor = [15, 174, 12, 36];
    writer.putPushax();
    writer.putMovRegReg("ebp", "esp");
    writer.putAndRegU32("esp", 4294967280);
    writer.putSubRegImm("esp", 512);
    writer.putBytes(fxsave);
    writer.putMovRegFsU32Ptr("ebx", threadOffsets.self);
    writer.putCallAddressWithAlignedArguments(artController.replacedMethods.findReplacementFromQuickCode, ["eax", "ebx"]);
    writer.putTestRegReg("eax", "eax");
    writer.putJccShortLabel("je", "restore_registers", "no-hint");
    writer.putMovRegOffsetPtrReg("ebp", 7 * 4, "eax");
    writer.putLabel("restore_registers");
    writer.putBytes(fxrstor);
    writer.putMovRegReg("esp", "ebp");
    writer.putPopax();
    writer.putJccShortLabel("jne", "invoke_replacement", "no-hint");
    do {
      offset = relocator.readOne();
    } while (offset < redirectSize && !relocator.eoi);
    relocator.writeAll();
    if (!relocator.eoi) {
      writer.putJmpAddress(target.add(offset));
    }
    writer.putLabel("invoke_replacement");
    writer.putJmpRegOffsetPtr("eax", artMethodOffsets.quickCode);
    writer.flush();
  });
  return offset;
}
function writeArtQuickCodeReplacementTrampolineX64(trampoline, target, redirectSize, constraints, vm3) {
  const threadOffsets = getArtThreadSpec(vm3).offset;
  const artMethodOffsets = getArtMethodSpec(vm3).offset;
  let offset;
  Memory.patchCode(trampoline, 256, (code4) => {
    const writer = new X86Writer(code4, { pc: trampoline });
    const relocator = new X86Relocator(target, writer);
    const fxsave = [15, 174, 4, 36];
    const fxrstor = [15, 174, 12, 36];
    writer.putPushax();
    writer.putMovRegReg("rbp", "rsp");
    writer.putAndRegU32("rsp", 4294967280);
    writer.putSubRegImm("rsp", 512);
    writer.putBytes(fxsave);
    writer.putMovRegGsU32Ptr("rbx", threadOffsets.self);
    writer.putCallAddressWithAlignedArguments(artController.replacedMethods.findReplacementFromQuickCode, ["rdi", "rbx"]);
    writer.putTestRegReg("rax", "rax");
    writer.putJccShortLabel("je", "restore_registers", "no-hint");
    writer.putMovRegOffsetPtrReg("rbp", 8 * 8, "rax");
    writer.putLabel("restore_registers");
    writer.putBytes(fxrstor);
    writer.putMovRegReg("rsp", "rbp");
    writer.putPopax();
    writer.putJccShortLabel("jne", "invoke_replacement", "no-hint");
    do {
      offset = relocator.readOne();
    } while (offset < redirectSize && !relocator.eoi);
    relocator.writeAll();
    if (!relocator.eoi) {
      writer.putJmpAddress(target.add(offset));
    }
    writer.putLabel("invoke_replacement");
    writer.putJmpRegOffsetPtr("rdi", artMethodOffsets.quickCode);
    writer.flush();
  });
  return offset;
}
function writeArtQuickCodeReplacementTrampolineArm(trampoline, target, redirectSize, constraints, vm3) {
  const artMethodOffsets = getArtMethodSpec(vm3).offset;
  const targetAddress = target.and(THUMB_BIT_REMOVAL_MASK);
  let offset;
  Memory.patchCode(trampoline, 128, (code4) => {
    const writer = new ThumbWriter(code4, { pc: trampoline });
    const relocator = new ThumbRelocator(targetAddress, writer);
    const vpushFpRegs = [45, 237, 16, 10];
    const vpopFpRegs = [189, 236, 16, 10];
    writer.putPushRegs([
      "r1",
      "r2",
      "r3",
      "r5",
      "r6",
      "r7",
      "r8",
      "r10",
      "r11",
      "lr"
    ]);
    writer.putBytes(vpushFpRegs);
    writer.putSubRegRegImm("sp", "sp", 8);
    writer.putStrRegRegOffset("r0", "sp", 0);
    writer.putCallAddressWithArguments(artController.replacedMethods.findReplacementFromQuickCode, ["r0", "r9"]);
    writer.putCmpRegImm("r0", 0);
    writer.putBCondLabel("eq", "restore_registers");
    writer.putStrRegRegOffset("r0", "sp", 0);
    writer.putLabel("restore_registers");
    writer.putLdrRegRegOffset("r0", "sp", 0);
    writer.putAddRegRegImm("sp", "sp", 8);
    writer.putBytes(vpopFpRegs);
    writer.putPopRegs([
      "lr",
      "r11",
      "r10",
      "r8",
      "r7",
      "r6",
      "r5",
      "r3",
      "r2",
      "r1"
    ]);
    writer.putBCondLabel("ne", "invoke_replacement");
    do {
      offset = relocator.readOne();
    } while (offset < redirectSize && !relocator.eoi);
    relocator.writeAll();
    if (!relocator.eoi) {
      writer.putLdrRegAddress("pc", target.add(offset));
    }
    writer.putLabel("invoke_replacement");
    writer.putLdrRegRegOffset("pc", "r0", artMethodOffsets.quickCode);
    writer.flush();
  });
  return offset;
}
function writeArtQuickCodeReplacementTrampolineArm64(trampoline, target, redirectSize, { availableScratchRegs }, vm3) {
  const artMethodOffsets = getArtMethodSpec(vm3).offset;
  let offset;
  Memory.patchCode(trampoline, 256, (code4) => {
    const writer = new Arm64Writer(code4, { pc: trampoline });
    const relocator = new Arm64Relocator(target, writer);
    writer.putPushRegReg("d0", "d1");
    writer.putPushRegReg("d2", "d3");
    writer.putPushRegReg("d4", "d5");
    writer.putPushRegReg("d6", "d7");
    writer.putPushRegReg("x1", "x2");
    writer.putPushRegReg("x3", "x4");
    writer.putPushRegReg("x5", "x6");
    writer.putPushRegReg("x7", "x20");
    writer.putPushRegReg("x21", "x22");
    writer.putPushRegReg("x23", "x24");
    writer.putPushRegReg("x25", "x26");
    writer.putPushRegReg("x27", "x28");
    writer.putPushRegReg("x29", "lr");
    writer.putSubRegRegImm("sp", "sp", 16);
    writer.putStrRegRegOffset("x0", "sp", 0);
    writer.putCallAddressWithArguments(artController.replacedMethods.findReplacementFromQuickCode, ["x0", "x19"]);
    writer.putCmpRegReg("x0", "xzr");
    writer.putBCondLabel("eq", "restore_registers");
    writer.putStrRegRegOffset("x0", "sp", 0);
    writer.putLabel("restore_registers");
    writer.putLdrRegRegOffset("x0", "sp", 0);
    writer.putAddRegRegImm("sp", "sp", 16);
    writer.putPopRegReg("x29", "lr");
    writer.putPopRegReg("x27", "x28");
    writer.putPopRegReg("x25", "x26");
    writer.putPopRegReg("x23", "x24");
    writer.putPopRegReg("x21", "x22");
    writer.putPopRegReg("x7", "x20");
    writer.putPopRegReg("x5", "x6");
    writer.putPopRegReg("x3", "x4");
    writer.putPopRegReg("x1", "x2");
    writer.putPopRegReg("d6", "d7");
    writer.putPopRegReg("d4", "d5");
    writer.putPopRegReg("d2", "d3");
    writer.putPopRegReg("d0", "d1");
    writer.putBCondLabel("ne", "invoke_replacement");
    do {
      offset = relocator.readOne();
    } while (offset < redirectSize && !relocator.eoi);
    relocator.writeAll();
    if (!relocator.eoi) {
      const scratchReg = Array.from(availableScratchRegs)[0];
      writer.putLdrRegAddress(scratchReg, target.add(offset));
      writer.putBrReg(scratchReg);
    }
    writer.putLabel("invoke_replacement");
    writer.putLdrRegRegOffset("x16", "x0", artMethodOffsets.quickCode);
    writer.putBrReg("x16");
    writer.flush();
  });
  return offset;
}
var artQuickCodePrologueWriters = {
  ia32: writeArtQuickCodePrologueX86,
  x64: writeArtQuickCodePrologueX86,
  arm: writeArtQuickCodePrologueArm,
  arm64: writeArtQuickCodePrologueArm64
};
function writeArtQuickCodePrologueX86(target, trampoline, redirectSize) {
  Memory.patchCode(target, 16, (code4) => {
    const writer = new X86Writer(code4, { pc: target });
    writer.putJmpAddress(trampoline);
    writer.flush();
  });
}
function writeArtQuickCodePrologueArm(target, trampoline, redirectSize) {
  const targetAddress = target.and(THUMB_BIT_REMOVAL_MASK);
  Memory.patchCode(targetAddress, 16, (code4) => {
    const writer = new ThumbWriter(code4, { pc: targetAddress });
    writer.putLdrRegAddress("pc", trampoline.or(1));
    writer.flush();
  });
}
function writeArtQuickCodePrologueArm64(target, trampoline, redirectSize) {
  Memory.patchCode(target, 16, (code4) => {
    const writer = new Arm64Writer(code4, { pc: target });
    if (redirectSize === 16) {
      writer.putLdrRegAddress("x16", trampoline);
    } else {
      writer.putAdrpRegAddress("x16", trampoline);
    }
    writer.putBrReg("x16");
    writer.flush();
  });
}
var artQuickCodeHookRedirectSize = {
  ia32: 5,
  x64: 16,
  arm: 8,
  arm64: 16
};
var ArtQuickCodeInterceptor = class {
  constructor(quickCode) {
    this.quickCode = quickCode;
    this.quickCodeAddress = Process.arch === "arm" ? quickCode.and(THUMB_BIT_REMOVAL_MASK) : quickCode;
    this.redirectSize = 0;
    this.trampoline = null;
    this.overwrittenPrologue = null;
    this.overwrittenPrologueLength = 0;
  }
  _canRelocateCode(relocationSize, constraints) {
    const Writer = thunkWriters[Process.arch];
    const Relocator = thunkRelocators[Process.arch];
    const { quickCodeAddress } = this;
    const writer = new Writer(quickCodeAddress);
    const relocator = new Relocator(quickCodeAddress, writer);
    let offset;
    if (Process.arch === "arm64") {
      let availableScratchRegs = /* @__PURE__ */ new Set(["x16", "x17"]);
      do {
        const nextOffset = relocator.readOne();
        const nextScratchRegs = new Set(availableScratchRegs);
        const { read: read2, written } = relocator.input.regsAccessed;
        for (const regs of [read2, written]) {
          for (const reg of regs) {
            let name;
            if (reg.startsWith("w")) {
              name = "x" + reg.substring(1);
            } else {
              name = reg;
            }
            nextScratchRegs.delete(name);
          }
        }
        if (nextScratchRegs.size === 0) {
          break;
        }
        offset = nextOffset;
        availableScratchRegs = nextScratchRegs;
      } while (offset < relocationSize && !relocator.eoi);
      constraints.availableScratchRegs = availableScratchRegs;
    } else {
      do {
        offset = relocator.readOne();
      } while (offset < relocationSize && !relocator.eoi);
    }
    return offset >= relocationSize;
  }
  _allocateTrampoline() {
    if (trampolineAllocator === null) {
      const trampolineSize = pointerSize7 === 4 ? 128 : 256;
      trampolineAllocator = makeAllocator(trampolineSize);
    }
    const maxRedirectSize = artQuickCodeHookRedirectSize[Process.arch];
    let redirectSize, spec;
    let alignment = 1;
    const constraints = {};
    if (pointerSize7 === 4 || this._canRelocateCode(maxRedirectSize, constraints)) {
      redirectSize = maxRedirectSize;
      spec = {};
    } else {
      let maxDistance;
      if (Process.arch === "x64") {
        redirectSize = 5;
        maxDistance = X86_JMP_MAX_DISTANCE;
      } else if (Process.arch === "arm64") {
        redirectSize = 8;
        maxDistance = ARM64_ADRP_MAX_DISTANCE;
        alignment = 4096;
      }
      spec = { near: this.quickCodeAddress, maxDistance };
    }
    this.redirectSize = redirectSize;
    this.trampoline = trampolineAllocator.allocateSlice(spec, alignment);
    return constraints;
  }
  _destroyTrampoline() {
    trampolineAllocator.freeSlice(this.trampoline);
  }
  activate(vm3) {
    const constraints = this._allocateTrampoline();
    const { trampoline, quickCode, redirectSize } = this;
    const writeTrampoline = artQuickCodeReplacementTrampolineWriters[Process.arch];
    const prologueLength = writeTrampoline(trampoline, quickCode, redirectSize, constraints, vm3);
    this.overwrittenPrologueLength = prologueLength;
    this.overwrittenPrologue = Memory.dup(this.quickCodeAddress, prologueLength);
    const writePrologue = artQuickCodePrologueWriters[Process.arch];
    writePrologue(quickCode, trampoline, redirectSize);
  }
  deactivate() {
    const { quickCodeAddress, overwrittenPrologueLength: prologueLength } = this;
    const Writer = thunkWriters[Process.arch];
    Memory.patchCode(quickCodeAddress, prologueLength, (code4) => {
      const writer = new Writer(code4, { pc: quickCodeAddress });
      const { overwrittenPrologue } = this;
      writer.putBytes(overwrittenPrologue.readByteArray(prologueLength));
      writer.flush();
    });
    this._destroyTrampoline();
  }
};
function isArtQuickEntrypoint(address) {
  const api3 = getApi();
  const { module: m2, artClassLinker } = api3;
  return address.equals(artClassLinker.quickGenericJniTrampoline) || address.equals(artClassLinker.quickToInterpreterBridgeTrampoline) || address.equals(artClassLinker.quickResolutionTrampoline) || address.equals(artClassLinker.quickImtConflictTrampoline) || address.compare(m2.base) >= 0 && address.compare(m2.base.add(m2.size)) < 0;
}
var ArtMethodMangler = class {
  constructor(opaqueMethodId) {
    const methodId = unwrapMethodId(opaqueMethodId);
    this.methodId = methodId;
    this.originalMethod = null;
    this.hookedMethodId = methodId;
    this.replacementMethodId = null;
    this.interceptor = null;
  }
  replace(impl, isInstanceMethod, argTypes2, vm3, api3) {
    const { kAccCompileDontBother, artNterpEntryPoint } = api3;
    this.originalMethod = fetchArtMethod(this.methodId, vm3);
    const originalFlags = this.originalMethod.accessFlags;
    if ((originalFlags & kAccXposedHookedMethod) !== 0 && xposedIsSupported()) {
      const hookInfo = this.originalMethod.jniCode;
      this.hookedMethodId = hookInfo.add(2 * pointerSize7).readPointer();
      this.originalMethod = fetchArtMethod(this.hookedMethodId, vm3);
    }
    const { hookedMethodId } = this;
    const replacementMethodId = cloneArtMethod(hookedMethodId, vm3);
    this.replacementMethodId = replacementMethodId;
    patchArtMethod(replacementMethodId, {
      jniCode: impl,
      accessFlags: (originalFlags & ~(kAccCriticalNative | kAccFastNative | kAccNterpEntryPointFastPathFlag) | kAccNative | kAccCompileDontBother) >>> 0,
      quickCode: api3.artClassLinker.quickGenericJniTrampoline,
      interpreterCode: api3.artInterpreterToCompiledCodeBridge
    }, vm3);
    let hookedMethodRemovedFlags = kAccFastInterpreterToInterpreterInvoke | kAccSingleImplementation | kAccNterpEntryPointFastPathFlag;
    if ((originalFlags & kAccNative) === 0) {
      hookedMethodRemovedFlags |= kAccSkipAccessChecks;
    }
    patchArtMethod(hookedMethodId, {
      accessFlags: (originalFlags & ~hookedMethodRemovedFlags | kAccCompileDontBother) >>> 0
    }, vm3);
    const quickCode = this.originalMethod.quickCode;
    if (artNterpEntryPoint !== null && quickCode.equals(artNterpEntryPoint)) {
      patchArtMethod(hookedMethodId, {
        quickCode: api3.artQuickToInterpreterBridge
      }, vm3);
    }
    if (!isArtQuickEntrypoint(quickCode)) {
      const interceptor = new ArtQuickCodeInterceptor(quickCode);
      interceptor.activate(vm3);
      this.interceptor = interceptor;
    }
    artController.replacedMethods.set(hookedMethodId, replacementMethodId);
    notifyArtMethodHooked(hookedMethodId, vm3);
  }
  revert(vm3) {
    const { hookedMethodId, interceptor } = this;
    patchArtMethod(hookedMethodId, this.originalMethod, vm3);
    artController.replacedMethods.delete(hookedMethodId);
    if (interceptor !== null) {
      interceptor.deactivate();
      this.interceptor = null;
    }
  }
  resolveTarget(wrapper, isInstanceMethod, env, api3) {
    return this.hookedMethodId;
  }
};
function xposedIsSupported() {
  return getAndroidApiLevel() < 28;
}
function fetchArtMethod(methodId, vm3) {
  const artMethodSpec = getArtMethodSpec(vm3);
  const artMethodOffset = artMethodSpec.offset;
  return ["jniCode", "accessFlags", "quickCode", "interpreterCode"].reduce((original, name) => {
    const offset = artMethodOffset[name];
    if (offset === void 0) {
      return original;
    }
    const address = methodId.add(offset);
    const read2 = name === "accessFlags" ? readU32 : readPointer;
    original[name] = read2.call(address);
    return original;
  }, {});
}
function patchArtMethod(methodId, patches, vm3) {
  const artMethodSpec = getArtMethodSpec(vm3);
  const artMethodOffset = artMethodSpec.offset;
  Object.keys(patches).forEach((name) => {
    const offset = artMethodOffset[name];
    if (offset === void 0) {
      return;
    }
    const address = methodId.add(offset);
    const write3 = name === "accessFlags" ? writeU32 : writePointer;
    write3.call(address, patches[name]);
  });
}
var DalvikMethodMangler = class {
  constructor(methodId) {
    this.methodId = methodId;
    this.originalMethod = null;
  }
  replace(impl, isInstanceMethod, argTypes2, vm3, api3) {
    const { methodId } = this;
    this.originalMethod = Memory.dup(methodId, DVM_METHOD_SIZE);
    let argsSize = argTypes2.reduce((acc, t) => acc + t.size, 0);
    if (isInstanceMethod) {
      argsSize++;
    }
    const accessFlags = (methodId.add(DVM_METHOD_OFFSET_ACCESS_FLAGS).readU32() | kAccNative) >>> 0;
    const registersSize = argsSize;
    const outsSize = 0;
    const insSize = argsSize;
    methodId.add(DVM_METHOD_OFFSET_ACCESS_FLAGS).writeU32(accessFlags);
    methodId.add(DVM_METHOD_OFFSET_REGISTERS_SIZE).writeU16(registersSize);
    methodId.add(DVM_METHOD_OFFSET_OUTS_SIZE).writeU16(outsSize);
    methodId.add(DVM_METHOD_OFFSET_INS_SIZE).writeU16(insSize);
    methodId.add(DVM_METHOD_OFFSET_JNI_ARG_INFO).writeU32(computeDalvikJniArgInfo(methodId));
    api3.dvmUseJNIBridge(methodId, impl);
  }
  revert(vm3) {
    Memory.copy(this.methodId, this.originalMethod, DVM_METHOD_SIZE);
  }
  resolveTarget(wrapper, isInstanceMethod, env, api3) {
    const thread = env.handle.add(DVM_JNI_ENV_OFFSET_SELF).readPointer();
    let objectPtr;
    if (isInstanceMethod) {
      objectPtr = api3.dvmDecodeIndirectRef(thread, wrapper.$h);
    } else {
      const h = wrapper.$borrowClassHandle(env);
      objectPtr = api3.dvmDecodeIndirectRef(thread, h.value);
      h.unref(env);
    }
    let classObject;
    if (isInstanceMethod) {
      classObject = objectPtr.add(DVM_OBJECT_OFFSET_CLAZZ).readPointer();
    } else {
      classObject = objectPtr;
    }
    const classKey = classObject.toString(16);
    let entry = patchedClasses.get(classKey);
    if (entry === void 0) {
      const vtablePtr = classObject.add(DVM_CLASS_OBJECT_OFFSET_VTABLE);
      const vtableCountPtr = classObject.add(DVM_CLASS_OBJECT_OFFSET_VTABLE_COUNT);
      const vtable2 = vtablePtr.readPointer();
      const vtableCount = vtableCountPtr.readS32();
      const vtableSize = vtableCount * pointerSize7;
      const shadowVtable = Memory.alloc(2 * vtableSize);
      Memory.copy(shadowVtable, vtable2, vtableSize);
      vtablePtr.writePointer(shadowVtable);
      entry = {
        classObject,
        vtablePtr,
        vtableCountPtr,
        vtable: vtable2,
        vtableCount,
        shadowVtable,
        shadowVtableCount: vtableCount,
        targetMethods: /* @__PURE__ */ new Map()
      };
      patchedClasses.set(classKey, entry);
    }
    const methodKey = this.methodId.toString(16);
    let targetMethod = entry.targetMethods.get(methodKey);
    if (targetMethod === void 0) {
      targetMethod = Memory.dup(this.originalMethod, DVM_METHOD_SIZE);
      const methodIndex = entry.shadowVtableCount++;
      entry.shadowVtable.add(methodIndex * pointerSize7).writePointer(targetMethod);
      targetMethod.add(DVM_METHOD_OFFSET_METHOD_INDEX).writeU16(methodIndex);
      entry.vtableCountPtr.writeS32(entry.shadowVtableCount);
      entry.targetMethods.set(methodKey, targetMethod);
    }
    return targetMethod;
  }
};
function computeDalvikJniArgInfo(methodId) {
  if (Process.arch !== "ia32") {
    return DALVIK_JNI_NO_ARG_INFO;
  }
  const shorty = methodId.add(DVM_METHOD_OFFSET_SHORTY).readPointer().readCString();
  if (shorty === null || shorty.length === 0 || shorty.length > 65535) {
    return DALVIK_JNI_NO_ARG_INFO;
  }
  let returnType;
  switch (shorty[0]) {
    case "V":
      returnType = DALVIK_JNI_RETURN_VOID;
      break;
    case "F":
      returnType = DALVIK_JNI_RETURN_FLOAT;
      break;
    case "D":
      returnType = DALVIK_JNI_RETURN_DOUBLE;
      break;
    case "J":
      returnType = DALVIK_JNI_RETURN_S8;
      break;
    case "Z":
    case "B":
      returnType = DALVIK_JNI_RETURN_S1;
      break;
    case "C":
      returnType = DALVIK_JNI_RETURN_U2;
      break;
    case "S":
      returnType = DALVIK_JNI_RETURN_S2;
      break;
    default:
      returnType = DALVIK_JNI_RETURN_S4;
      break;
  }
  let hints = 0;
  for (let i = shorty.length - 1; i > 0; i--) {
    const ch = shorty[i];
    hints += ch === "D" || ch === "J" ? 2 : 1;
  }
  return returnType << DALVIK_JNI_RETURN_SHIFT | hints;
}
function cloneArtMethod(method2, vm3) {
  const api3 = getApi();
  if (getAndroidApiLevel() < 23) {
    const thread = api3["art::Thread::CurrentFromGdb"]();
    return api3["art::mirror::Object::Clone"](method2, thread);
  }
  return Memory.dup(method2, getArtMethodSpec(vm3).size);
}
function deoptimizeMethod(vm3, env, method2) {
  requestDeoptimization(vm3, env, kSelectiveDeoptimization, method2);
}
function deoptimizeEverything(vm3, env) {
  requestDeoptimization(vm3, env, kFullDeoptimization);
}
function deoptimizeBootImage(vm3, env) {
  const api3 = getApi();
  if (getAndroidApiLevel() < 26) {
    throw new Error("This API is only available on Android >= 8.0");
  }
  withRunnableArtThread(vm3, env, (thread) => {
    api3["art::Runtime::DeoptimizeBootImage"](api3.artRuntime);
  });
}
function requestDeoptimization(vm3, env, kind, method2) {
  const api3 = getApi();
  if (getAndroidApiLevel() < 24) {
    throw new Error("This API is only available on Android >= 7.0");
  }
  withRunnableArtThread(vm3, env, (thread) => {
    if (getAndroidApiLevel() < 30) {
      if (!api3.isJdwpStarted()) {
        const session = startJdwp(api3);
        jdwpSessions.push(session);
      }
      if (!api3.isDebuggerActive()) {
        api3["art::Dbg::GoActive"]();
      }
      const request = Memory.alloc(8 + pointerSize7);
      request.writeU32(kind);
      switch (kind) {
        case kFullDeoptimization:
          break;
        case kSelectiveDeoptimization:
          request.add(8).writePointer(method2);
          break;
        default:
          throw new Error("Unsupported deoptimization kind");
      }
      api3["art::Dbg::RequestDeoptimization"](request);
      api3["art::Dbg::ManageDeoptimization"]();
    } else {
      const instrumentation = api3.artInstrumentation;
      if (instrumentation === null) {
        throw new Error("Unable to find Instrumentation class in ART; please file a bug");
      }
      const enableDeopt = api3["art::Instrumentation::EnableDeoptimization"];
      if (enableDeopt !== void 0) {
        const deoptimizationEnabled = !!instrumentation.add(getArtInstrumentationSpec().offset.deoptimizationEnabled).readU8();
        if (!deoptimizationEnabled) {
          enableDeopt(instrumentation);
        }
      }
      switch (kind) {
        case kFullDeoptimization:
          api3["art::Instrumentation::DeoptimizeEverything"](instrumentation, Memory.allocUtf8String("frida"));
          break;
        case kSelectiveDeoptimization:
          api3["art::Instrumentation::Deoptimize"](instrumentation, method2);
          break;
        default:
          throw new Error("Unsupported deoptimization kind");
      }
    }
  });
}
var JdwpSession = class {
  constructor() {
    const libart = Process.getModuleByName("libart.so");
    const acceptImpl = libart.getExportByName("_ZN3art4JDWP12JdwpAdbState6AcceptEv");
    const receiveClientFdImpl = libart.getExportByName("_ZN3art4JDWP12JdwpAdbState15ReceiveClientFdEv");
    const controlPair = makeSocketPair();
    const clientPair = makeSocketPair();
    this._controlFd = controlPair[0];
    this._clientFd = clientPair[0];
    let acceptListener = null;
    acceptListener = Interceptor.attach(acceptImpl, function(args) {
      const state = args[0];
      const controlSockPtr = Memory.scanSync(state.add(8252), 256, "00 ff ff ff ff 00")[0].address.add(1);
      controlSockPtr.writeS32(controlPair[1]);
      acceptListener.detach();
    });
    Interceptor.replace(receiveClientFdImpl, new NativeCallback(function(state) {
      Interceptor.revert(receiveClientFdImpl);
      return clientPair[1];
    }, "int", ["pointer"]));
    Interceptor.flush();
    this._handshakeRequest = this._performHandshake();
  }
  async _performHandshake() {
    const input = new UnixInputStream(this._clientFd, { autoClose: false });
    const output = new UnixOutputStream(this._clientFd, { autoClose: false });
    const handshakePacket = [74, 68, 87, 80, 45, 72, 97, 110, 100, 115, 104, 97, 107, 101];
    try {
      await output.writeAll(handshakePacket);
      await input.readAll(handshakePacket.length);
    } catch (e) {
    }
  }
};
function startJdwp(api3) {
  const session = new JdwpSession();
  api3["art::Dbg::SetJdwpAllowed"](1);
  const options = makeJdwpOptions();
  api3["art::Dbg::ConfigureJdwp"](options);
  const startDebugger = api3["art::InternalDebuggerControlCallback::StartDebugger"];
  if (startDebugger !== void 0) {
    startDebugger(NULL);
  } else {
    api3["art::Dbg::StartJdwp"]();
  }
  return session;
}
function makeJdwpOptions() {
  const kJdwpTransportAndroidAdb = getAndroidApiLevel() < 28 ? 2 : 3;
  const kJdwpPortFirstAvailable = 0;
  const transport = kJdwpTransportAndroidAdb;
  const server = true;
  const suspend = false;
  const port = kJdwpPortFirstAvailable;
  const size = 8 + STD_STRING_SIZE + 2;
  const result = Memory.alloc(size);
  result.writeU32(transport).add(4).writeU8(server ? 1 : 0).add(1).writeU8(suspend ? 1 : 0).add(1).add(STD_STRING_SIZE).writeU16(port);
  return result;
}
function makeSocketPair() {
  if (socketpair === null) {
    socketpair = new NativeFunction(
      Process.getModuleByName("libc.so").getExportByName("socketpair"),
      "int",
      ["int", "int", "int", "pointer"]
    );
  }
  const buf = Memory.alloc(8);
  if (socketpair(AF_UNIX, SOCK_STREAM, 0, buf) === -1) {
    throw new Error("Unable to create socketpair for JDWP");
  }
  return [
    buf.readS32(),
    buf.add(4).readS32()
  ];
}
function makeAddGlobalRefFallbackForAndroid5(api3) {
  const offset = getArtVMSpec().offset;
  const lock = api3.vm.add(offset.globalsLock);
  const table = api3.vm.add(offset.globals);
  const add = api3["art::IndirectReferenceTable::Add"];
  const acquire = api3["art::ReaderWriterMutex::ExclusiveLock"];
  const release = api3["art::ReaderWriterMutex::ExclusiveUnlock"];
  const IRT_FIRST_SEGMENT = 0;
  return function(vm3, thread, obj) {
    acquire(lock, thread);
    try {
      return add(table, IRT_FIRST_SEGMENT, obj);
    } finally {
      release(lock, thread);
    }
  };
}
function makeDecodeGlobalFallback(api3) {
  const decode = api3["art::Thread::DecodeJObject"];
  if (decode === void 0) {
    throw new Error("art::Thread::DecodeJObject is not available; please file a bug");
  }
  return function(vm3, thread, ref) {
    return decode(thread, ref);
  };
}
var threadStateTransitionRecompilers = {
  ia32: recompileExceptionClearForX86,
  x64: recompileExceptionClearForX86,
  arm: recompileExceptionClearForArm,
  arm64: recompileExceptionClearForArm64
};
function makeArtThreadStateTransitionImpl(vm3, env, callback) {
  const api3 = getApi();
  const envVtable = env.handle.readPointer();
  let exceptionClearImpl;
  const innerExceptionClearImpl = api3.find("_ZN3art3JNIILb1EE14ExceptionClearEP7_JNIEnv");
  if (innerExceptionClearImpl !== null) {
    exceptionClearImpl = innerExceptionClearImpl;
  } else {
    exceptionClearImpl = envVtable.add(ENV_VTABLE_OFFSET_EXCEPTION_CLEAR).readPointer();
  }
  let nextFuncImpl;
  const innerNextFuncImpl = api3.find("_ZN3art3JNIILb1EE10FatalErrorEP7_JNIEnvPKc");
  if (innerNextFuncImpl !== null) {
    nextFuncImpl = innerNextFuncImpl;
  } else {
    nextFuncImpl = envVtable.add(ENV_VTABLE_OFFSET_FATAL_ERROR).readPointer();
  }
  const recompile = threadStateTransitionRecompilers[Process.arch];
  if (recompile === void 0) {
    throw new Error("Not yet implemented for " + Process.arch);
  }
  let perform = null;
  const threadOffsets = getArtThreadSpec(vm3).offset;
  const exceptionOffset = threadOffsets.exception;
  const neuteredOffsets = /* @__PURE__ */ new Set();
  const isReportedOffset = threadOffsets.isExceptionReportedToInstrumentation;
  if (isReportedOffset !== null) {
    neuteredOffsets.add(isReportedOffset);
  }
  const throwLocationStartOffset = threadOffsets.throwLocation;
  if (throwLocationStartOffset !== null) {
    neuteredOffsets.add(throwLocationStartOffset);
    neuteredOffsets.add(throwLocationStartOffset + pointerSize7);
    neuteredOffsets.add(throwLocationStartOffset + 2 * pointerSize7);
  }
  const codeSize = 65536;
  const code4 = Memory.alloc(codeSize);
  Memory.patchCode(code4, codeSize, (buffer) => {
    perform = recompile(buffer, code4, exceptionClearImpl, nextFuncImpl, exceptionOffset, neuteredOffsets, callback);
  });
  perform._code = code4;
  perform._callback = callback;
  return perform;
}
function recompileExceptionClearForX86(buffer, pc, exceptionClearImpl, nextFuncImpl, exceptionOffset, neuteredOffsets, callback) {
  const blocks = {};
  const branchTargets = /* @__PURE__ */ new Set();
  const pending = [exceptionClearImpl];
  while (pending.length > 0) {
    let current = pending.shift();
    const alreadyCovered = Object.values(blocks).some(({ begin, end }) => current.compare(begin) >= 0 && current.compare(end) < 0);
    if (alreadyCovered) {
      continue;
    }
    const blockAddressKey = current.toString();
    let block2 = {
      begin: current
    };
    let lastInsn = null;
    let reachedEndOfBlock = false;
    do {
      if (current.equals(nextFuncImpl)) {
        reachedEndOfBlock = true;
        break;
      }
      const insn = Instruction.parse(current);
      lastInsn = insn;
      const existingBlock = blocks[insn.address.toString()];
      if (existingBlock !== void 0) {
        delete blocks[existingBlock.begin.toString()];
        blocks[blockAddressKey] = existingBlock;
        existingBlock.begin = block2.begin;
        block2 = null;
        break;
      }
      let branchTarget = null;
      switch (insn.mnemonic) {
        case "jmp":
          branchTarget = ptr(insn.operands[0].value);
          reachedEndOfBlock = true;
          break;
        case "je":
        case "jg":
        case "jle":
        case "jne":
        case "js":
          branchTarget = ptr(insn.operands[0].value);
          break;
        case "ret":
          reachedEndOfBlock = true;
          break;
      }
      if (branchTarget !== null) {
        branchTargets.add(branchTarget.toString());
        pending.push(branchTarget);
        pending.sort((a, b) => a.compare(b));
      }
      current = insn.next;
    } while (!reachedEndOfBlock);
    if (block2 !== null) {
      block2.end = lastInsn.address.add(lastInsn.size);
      blocks[blockAddressKey] = block2;
    }
  }
  const blocksOrdered = Object.keys(blocks).map((key) => blocks[key]);
  blocksOrdered.sort((a, b) => a.begin.compare(b.begin));
  const entryBlock = blocks[exceptionClearImpl.toString()];
  blocksOrdered.splice(blocksOrdered.indexOf(entryBlock), 1);
  blocksOrdered.unshift(entryBlock);
  const writer = new X86Writer(buffer, { pc });
  let foundCore = false;
  let threadReg = null;
  blocksOrdered.forEach((block2) => {
    const size = block2.end.sub(block2.begin).toInt32();
    const relocator = new X86Relocator(block2.begin, writer);
    let offset;
    while ((offset = relocator.readOne()) !== 0) {
      const insn = relocator.input;
      const { mnemonic } = insn;
      const insnAddressId = insn.address.toString();
      if (branchTargets.has(insnAddressId)) {
        writer.putLabel(insnAddressId);
      }
      let keep = true;
      switch (mnemonic) {
        case "jmp":
          writer.putJmpNearLabel(branchLabelFromOperand(insn.operands[0]));
          keep = false;
          break;
        case "je":
        case "jg":
        case "jle":
        case "jne":
        case "js":
          writer.putJccNearLabel(mnemonic, branchLabelFromOperand(insn.operands[0]), "no-hint");
          keep = false;
          break;
        /*
         * JNI::ExceptionClear(), when checked JNI is off.
         */
        case "mov": {
          const [dst, src] = insn.operands;
          if (dst.type === "mem" && src.type === "imm") {
            const dstValue = dst.value;
            const dstOffset = dstValue.disp;
            if (dstOffset === exceptionOffset && src.value.valueOf() === 0) {
              threadReg = dstValue.base;
              writer.putPushfx();
              writer.putPushax();
              writer.putMovRegReg("xbp", "xsp");
              if (pointerSize7 === 4) {
                writer.putAndRegU32("esp", 4294967280);
              } else {
                const scratchReg = threadReg !== "rdi" ? "rdi" : "rsi";
                writer.putMovRegU64(scratchReg, uint64("0xfffffffffffffff0"));
                writer.putAndRegReg("rsp", scratchReg);
              }
              writer.putCallAddressWithAlignedArguments(callback, [threadReg]);
              writer.putMovRegReg("xsp", "xbp");
              writer.putPopax();
              writer.putPopfx();
              foundCore = true;
              keep = false;
            } else if (neuteredOffsets.has(dstOffset) && dstValue.base === threadReg) {
              keep = false;
            }
          }
          break;
        }
        /*
         * CheckJNI::ExceptionClear, when checked JNI is on. Wrapper that calls JNI::ExceptionClear().
         */
        case "call": {
          const target = insn.operands[0];
          if (target.type === "mem" && target.value.disp === ENV_VTABLE_OFFSET_EXCEPTION_CLEAR) {
            if (pointerSize7 === 4) {
              writer.putPopReg("eax");
              writer.putMovRegRegOffsetPtr("eax", "eax", 4);
              writer.putPushReg("eax");
            } else {
              writer.putMovRegRegOffsetPtr("rdi", "rdi", 8);
            }
            writer.putCallAddressWithArguments(callback, []);
            foundCore = true;
            keep = false;
          }
          break;
        }
      }
      if (keep) {
        relocator.writeAll();
      } else {
        relocator.skipOne();
      }
      if (offset === size) {
        break;
      }
    }
    relocator.dispose();
  });
  writer.dispose();
  if (!foundCore) {
    throwThreadStateTransitionParseError();
  }
  return new NativeFunction(pc, "void", ["pointer"], nativeFunctionOptions3);
}
function recompileExceptionClearForArm(buffer, pc, exceptionClearImpl, nextFuncImpl, exceptionOffset, neuteredOffsets, callback) {
  const blocks = {};
  const branchTargets = /* @__PURE__ */ new Set();
  const thumbBitRemovalMask = ptr(1).not();
  const pending = [exceptionClearImpl];
  while (pending.length > 0) {
    let current = pending.shift();
    const alreadyCovered = Object.values(blocks).some(({ begin: begin2, end }) => current.compare(begin2) >= 0 && current.compare(end) < 0);
    if (alreadyCovered) {
      continue;
    }
    const begin = current.and(thumbBitRemovalMask);
    const blockId = begin.toString();
    const thumbBit = current.and(1);
    let block2 = {
      begin
    };
    let lastInsn = null;
    let reachedEndOfBlock = false;
    let ifThenBlockRemaining = 0;
    do {
      if (current.equals(nextFuncImpl)) {
        reachedEndOfBlock = true;
        break;
      }
      const insn = Instruction.parse(current);
      const { mnemonic } = insn;
      lastInsn = insn;
      const currentAddress = current.and(thumbBitRemovalMask);
      const insnId = currentAddress.toString();
      const existingBlock = blocks[insnId];
      if (existingBlock !== void 0) {
        delete blocks[existingBlock.begin.toString()];
        blocks[blockId] = existingBlock;
        existingBlock.begin = block2.begin;
        block2 = null;
        break;
      }
      const isOutsideIfThenBlock = ifThenBlockRemaining === 0;
      let branchTarget = null;
      switch (mnemonic) {
        case "b":
          branchTarget = ptr(insn.operands[0].value);
          reachedEndOfBlock = isOutsideIfThenBlock;
          break;
        case "beq.w":
        case "beq":
        case "bne":
        case "bne.w":
        case "bgt":
          branchTarget = ptr(insn.operands[0].value);
          break;
        case "cbz":
        case "cbnz":
          branchTarget = ptr(insn.operands[1].value);
          break;
        case "pop.w":
          if (isOutsideIfThenBlock) {
            reachedEndOfBlock = insn.operands.filter((op) => op.value === "pc").length === 1;
          }
          break;
      }
      switch (mnemonic) {
        case "it":
          ifThenBlockRemaining = 1;
          break;
        case "itt":
          ifThenBlockRemaining = 2;
          break;
        case "ittt":
          ifThenBlockRemaining = 3;
          break;
        case "itttt":
          ifThenBlockRemaining = 4;
          break;
        default:
          if (ifThenBlockRemaining > 0) {
            ifThenBlockRemaining--;
          }
          break;
      }
      if (branchTarget !== null) {
        branchTargets.add(branchTarget.toString());
        pending.push(branchTarget.or(thumbBit));
        pending.sort((a, b) => a.compare(b));
      }
      current = insn.next;
    } while (!reachedEndOfBlock);
    if (block2 !== null) {
      block2.end = lastInsn.address.add(lastInsn.size);
      blocks[blockId] = block2;
    }
  }
  const blocksOrdered = Object.keys(blocks).map((key) => blocks[key]);
  blocksOrdered.sort((a, b) => a.begin.compare(b.begin));
  const entryBlock = blocks[exceptionClearImpl.and(thumbBitRemovalMask).toString()];
  blocksOrdered.splice(blocksOrdered.indexOf(entryBlock), 1);
  blocksOrdered.unshift(entryBlock);
  const writer = new ThumbWriter(buffer, { pc });
  let foundCore = false;
  let threadReg = null;
  let realImplReg = null;
  blocksOrdered.forEach((block2) => {
    const relocator = new ThumbRelocator(block2.begin, writer);
    let address = block2.begin;
    const end = block2.end;
    let size = 0;
    do {
      const offset = relocator.readOne();
      if (offset === 0) {
        throw new Error("Unexpected end of block");
      }
      const insn = relocator.input;
      address = insn.address;
      size = insn.size;
      const { mnemonic } = insn;
      const insnAddressId = address.toString();
      if (branchTargets.has(insnAddressId)) {
        writer.putLabel(insnAddressId);
      }
      let keep = true;
      switch (mnemonic) {
        case "b":
          writer.putBLabel(branchLabelFromOperand(insn.operands[0]));
          keep = false;
          break;
        case "beq.w":
          writer.putBCondLabelWide("eq", branchLabelFromOperand(insn.operands[0]));
          keep = false;
          break;
        case "bne.w":
          writer.putBCondLabelWide("ne", branchLabelFromOperand(insn.operands[0]));
          keep = false;
          break;
        case "beq":
        case "bne":
        case "bgt":
          writer.putBCondLabelWide(mnemonic.substr(1), branchLabelFromOperand(insn.operands[0]));
          keep = false;
          break;
        case "cbz": {
          const ops = insn.operands;
          writer.putCbzRegLabel(ops[0].value, branchLabelFromOperand(ops[1]));
          keep = false;
          break;
        }
        case "cbnz": {
          const ops = insn.operands;
          writer.putCbnzRegLabel(ops[0].value, branchLabelFromOperand(ops[1]));
          keep = false;
          break;
        }
        /*
         * JNI::ExceptionClear(), when checked JNI is off.
         */
        case "str":
        case "str.w": {
          const dstValue = insn.operands[1].value;
          const dstOffset = dstValue.disp;
          if (dstOffset === exceptionOffset) {
            threadReg = dstValue.base;
            const nzcvqReg = threadReg !== "r4" ? "r4" : "r5";
            const clobberedRegs = ["r0", "r1", "r2", "r3", nzcvqReg, "r9", "r12", "lr"];
            writer.putPushRegs(clobberedRegs);
            writer.putMrsRegReg(nzcvqReg, "apsr-nzcvq");
            writer.putCallAddressWithArguments(callback, [threadReg]);
            writer.putMsrRegReg("apsr-nzcvq", nzcvqReg);
            writer.putPopRegs(clobberedRegs);
            foundCore = true;
            keep = false;
          } else if (neuteredOffsets.has(dstOffset) && dstValue.base === threadReg) {
            keep = false;
          }
          break;
        }
        /*
         * CheckJNI::ExceptionClear, when checked JNI is on. Wrapper that calls JNI::ExceptionClear().
         */
        case "ldr": {
          const [dstOp, srcOp] = insn.operands;
          if (srcOp.type === "mem") {
            const src = srcOp.value;
            if (src.base[0] === "r" && src.disp === ENV_VTABLE_OFFSET_EXCEPTION_CLEAR) {
              realImplReg = dstOp.value;
            }
          }
          break;
        }
        case "blx":
          if (insn.operands[0].value === realImplReg) {
            writer.putLdrRegRegOffset("r0", "r0", 4);
            writer.putCallAddressWithArguments(callback, ["r0"]);
            foundCore = true;
            realImplReg = null;
            keep = false;
          }
          break;
      }
      if (keep) {
        relocator.writeAll();
      } else {
        relocator.skipOne();
      }
    } while (!address.add(size).equals(end));
    relocator.dispose();
  });
  writer.dispose();
  if (!foundCore) {
    throwThreadStateTransitionParseError();
  }
  return new NativeFunction(pc.or(1), "void", ["pointer"], nativeFunctionOptions3);
}
function recompileExceptionClearForArm64(buffer, pc, exceptionClearImpl, nextFuncImpl, exceptionOffset, neuteredOffsets, callback) {
  const blocks = {};
  const branchTargets = /* @__PURE__ */ new Set();
  const pending = [exceptionClearImpl];
  while (pending.length > 0) {
    let current = pending.shift();
    const alreadyCovered = Object.values(blocks).some(({ begin, end }) => current.compare(begin) >= 0 && current.compare(end) < 0);
    if (alreadyCovered) {
      continue;
    }
    const blockAddressKey = current.toString();
    let block2 = {
      begin: current
    };
    let lastInsn = null;
    let reachedEndOfBlock = false;
    do {
      if (current.equals(nextFuncImpl)) {
        reachedEndOfBlock = true;
        break;
      }
      let insn;
      try {
        insn = Instruction.parse(current);
      } catch (e) {
        if (current.readU32() === 0) {
          reachedEndOfBlock = true;
          break;
        } else {
          throw e;
        }
      }
      lastInsn = insn;
      const existingBlock = blocks[insn.address.toString()];
      if (existingBlock !== void 0) {
        delete blocks[existingBlock.begin.toString()];
        blocks[blockAddressKey] = existingBlock;
        existingBlock.begin = block2.begin;
        block2 = null;
        break;
      }
      let branchTarget = null;
      switch (insn.mnemonic) {
        case "b":
          branchTarget = ptr(insn.operands[0].value);
          reachedEndOfBlock = true;
          break;
        case "b.eq":
        case "b.ne":
        case "b.le":
        case "b.gt":
          branchTarget = ptr(insn.operands[0].value);
          break;
        case "cbz":
        case "cbnz":
          branchTarget = ptr(insn.operands[1].value);
          break;
        case "tbz":
        case "tbnz":
          branchTarget = ptr(insn.operands[2].value);
          break;
        case "ret":
          reachedEndOfBlock = true;
          break;
      }
      if (branchTarget !== null) {
        branchTargets.add(branchTarget.toString());
        pending.push(branchTarget);
        pending.sort((a, b) => a.compare(b));
      }
      current = insn.next;
    } while (!reachedEndOfBlock);
    if (block2 !== null) {
      block2.end = lastInsn.address.add(lastInsn.size);
      blocks[blockAddressKey] = block2;
    }
  }
  const blocksOrdered = Object.keys(blocks).map((key) => blocks[key]);
  blocksOrdered.sort((a, b) => a.begin.compare(b.begin));
  const entryBlock = blocks[exceptionClearImpl.toString()];
  blocksOrdered.splice(blocksOrdered.indexOf(entryBlock), 1);
  blocksOrdered.unshift(entryBlock);
  const writer = new Arm64Writer(buffer, { pc });
  writer.putBLabel("performTransition");
  const invokeCallback = pc.add(writer.offset);
  writer.putPushAllXRegisters();
  writer.putCallAddressWithArguments(callback, ["x0"]);
  writer.putPopAllXRegisters();
  writer.putRet();
  writer.putLabel("performTransition");
  let foundCore = false;
  let threadReg = null;
  let realImplReg = null;
  blocksOrdered.forEach((block2) => {
    const size = block2.end.sub(block2.begin).toInt32();
    const relocator = new Arm64Relocator(block2.begin, writer);
    let offset;
    while ((offset = relocator.readOne()) !== 0) {
      const insn = relocator.input;
      const { mnemonic } = insn;
      const insnAddressId = insn.address.toString();
      if (branchTargets.has(insnAddressId)) {
        writer.putLabel(insnAddressId);
      }
      let keep = true;
      switch (mnemonic) {
        case "b":
          writer.putBLabel(branchLabelFromOperand(insn.operands[0]));
          keep = false;
          break;
        case "b.eq":
        case "b.ne":
        case "b.le":
        case "b.gt":
          writer.putBCondLabel(mnemonic.substr(2), branchLabelFromOperand(insn.operands[0]));
          keep = false;
          break;
        case "cbz": {
          const ops = insn.operands;
          writer.putCbzRegLabel(ops[0].value, branchLabelFromOperand(ops[1]));
          keep = false;
          break;
        }
        case "cbnz": {
          const ops = insn.operands;
          writer.putCbnzRegLabel(ops[0].value, branchLabelFromOperand(ops[1]));
          keep = false;
          break;
        }
        case "tbz": {
          const ops = insn.operands;
          writer.putTbzRegImmLabel(ops[0].value, ops[1].value.valueOf(), branchLabelFromOperand(ops[2]));
          keep = false;
          break;
        }
        case "tbnz": {
          const ops = insn.operands;
          writer.putTbnzRegImmLabel(ops[0].value, ops[1].value.valueOf(), branchLabelFromOperand(ops[2]));
          keep = false;
          break;
        }
        /*
         * JNI::ExceptionClear(), when checked JNI is off.
         */
        case "str": {
          const ops = insn.operands;
          const srcReg = ops[0].value;
          const dstValue = ops[1].value;
          const dstOffset = dstValue.disp;
          if (srcReg === "xzr" && dstOffset === exceptionOffset) {
            threadReg = dstValue.base;
            writer.putPushRegReg("x0", "lr");
            writer.putMovRegReg("x0", threadReg);
            writer.putBlImm(invokeCallback);
            writer.putPopRegReg("x0", "lr");
            foundCore = true;
            keep = false;
          } else if (neuteredOffsets.has(dstOffset) && dstValue.base === threadReg) {
            keep = false;
          }
          break;
        }
        /*
         * CheckJNI::ExceptionClear, when checked JNI is on. Wrapper that calls JNI::ExceptionClear().
         */
        case "ldr": {
          const ops = insn.operands;
          const src = ops[1].value;
          if (src.base[0] === "x" && src.disp === ENV_VTABLE_OFFSET_EXCEPTION_CLEAR) {
            realImplReg = ops[0].value;
          }
          break;
        }
        case "blr":
          if (insn.operands[0].value === realImplReg) {
            writer.putLdrRegRegOffset("x0", "x0", 8);
            writer.putCallAddressWithArguments(callback, ["x0"]);
            foundCore = true;
            realImplReg = null;
            keep = false;
          }
          break;
      }
      if (keep) {
        relocator.writeAll();
      } else {
        relocator.skipOne();
      }
      if (offset === size) {
        break;
      }
    }
    relocator.dispose();
  });
  writer.dispose();
  if (!foundCore) {
    throwThreadStateTransitionParseError();
  }
  return new NativeFunction(pc, "void", ["pointer"], nativeFunctionOptions3);
}
function throwThreadStateTransitionParseError() {
  throw new Error("Unable to parse ART internals; please file a bug");
}
function fixupArtQuickDeliverExceptionBug(api3) {
  const prettyMethod = api3["art::ArtMethod::PrettyMethod"];
  if (prettyMethod === void 0) {
    return;
  }
  Interceptor.attach(prettyMethod.impl, artController.hooks.ArtMethod.prettyMethod);
  Interceptor.flush();
}
function branchLabelFromOperand(op) {
  return ptr(op.value).toString();
}
function makeCxxMethodWrapperReturningPointerByValueGeneric(address, argTypes2) {
  return new NativeFunction(address, "pointer", argTypes2, nativeFunctionOptions3);
}
function makeCxxMethodWrapperReturningPointerByValueInFirstArg(address, argTypes2) {
  const impl = new NativeFunction(address, "void", ["pointer"].concat(argTypes2), nativeFunctionOptions3);
  return function() {
    const resultPtr = Memory.alloc(pointerSize7);
    impl(resultPtr, ...arguments);
    return resultPtr.readPointer();
  };
}
function makeCxxMethodWrapperReturningStdStringByValue(impl, argTypes2) {
  const { arch } = Process;
  switch (arch) {
    case "ia32":
    case "arm64": {
      let thunk;
      if (arch === "ia32") {
        thunk = makeThunk(64, (writer) => {
          const argCount = 1 + argTypes2.length;
          const argvSize = argCount * 4;
          writer.putSubRegImm("esp", argvSize);
          for (let i = 0; i !== argCount; i++) {
            const offset = i * 4;
            writer.putMovRegRegOffsetPtr("eax", "esp", argvSize + 4 + offset);
            writer.putMovRegOffsetPtrReg("esp", offset, "eax");
          }
          writer.putCallAddress(impl);
          writer.putAddRegImm("esp", argvSize - 4);
          writer.putRet();
        });
      } else {
        thunk = makeThunk(32, (writer) => {
          writer.putMovRegReg("x8", "x0");
          argTypes2.forEach((t, i) => {
            writer.putMovRegReg("x" + i, "x" + (i + 1));
          });
          writer.putLdrRegAddress("x7", impl);
          writer.putBrReg("x7");
        });
      }
      const invokeThunk = new NativeFunction(thunk, "void", ["pointer"].concat(argTypes2), nativeFunctionOptions3);
      const wrapper = function(...args) {
        invokeThunk(...args);
      };
      wrapper.handle = thunk;
      wrapper.impl = impl;
      return wrapper;
    }
    default: {
      const result = new NativeFunction(impl, "void", ["pointer"].concat(argTypes2), nativeFunctionOptions3);
      result.impl = impl;
      return result;
    }
  }
}
var StdString = class {
  constructor() {
    this.handle = Memory.alloc(STD_STRING_SIZE);
  }
  dispose() {
    const [data, isTiny] = this._getData();
    if (!isTiny) {
      getApi().$delete(data);
    }
  }
  disposeToString() {
    const result = this.toString();
    this.dispose();
    return result;
  }
  toString() {
    const [data] = this._getData();
    return data.readUtf8String();
  }
  _getData() {
    const str = this.handle;
    const isTiny = (str.readU8() & 1) === 0;
    const data = isTiny ? str.add(1) : str.add(2 * pointerSize7).readPointer();
    return [data, isTiny];
  }
};
var StdVector = class {
  $delete() {
    this.dispose();
    getApi().$delete(this);
  }
  constructor(storage, elementSize) {
    this.handle = storage;
    this._begin = storage;
    this._end = storage.add(pointerSize7);
    this._storage = storage.add(2 * pointerSize7);
    this._elementSize = elementSize;
  }
  init() {
    this.begin = NULL;
    this.end = NULL;
    this.storage = NULL;
  }
  dispose() {
    getApi().$delete(this.begin);
  }
  get begin() {
    return this._begin.readPointer();
  }
  set begin(value) {
    this._begin.writePointer(value);
  }
  get end() {
    return this._end.readPointer();
  }
  set end(value) {
    this._end.writePointer(value);
  }
  get storage() {
    return this._storage.readPointer();
  }
  set storage(value) {
    this._storage.writePointer(value);
  }
  get size() {
    return this.end.sub(this.begin).toInt32() / this._elementSize;
  }
};
var HandleVector = class _HandleVector extends StdVector {
  static $new() {
    const vector = new _HandleVector(getApi().$new(STD_VECTOR_SIZE));
    vector.init();
    return vector;
  }
  constructor(storage) {
    super(storage, pointerSize7);
  }
  get handles() {
    const result = [];
    let cur = this.begin;
    const end = this.end;
    while (!cur.equals(end)) {
      result.push(cur.readPointer());
      cur = cur.add(pointerSize7);
    }
    return result;
  }
};
var BHS_OFFSET_LINK = 0;
var BHS_OFFSET_NUM_REFS = pointerSize7;
var BHS_SIZE = BHS_OFFSET_NUM_REFS + 4;
var kNumReferencesVariableSized = -1;
var BaseHandleScope = class _BaseHandleScope {
  $delete() {
    this.dispose();
    getApi().$delete(this);
  }
  constructor(storage) {
    this.handle = storage;
    this._link = storage.add(BHS_OFFSET_LINK);
    this._numberOfReferences = storage.add(BHS_OFFSET_NUM_REFS);
  }
  init(link, numberOfReferences) {
    this.link = link;
    this.numberOfReferences = numberOfReferences;
  }
  dispose() {
  }
  get link() {
    return new _BaseHandleScope(this._link.readPointer());
  }
  set link(value) {
    this._link.writePointer(value);
  }
  get numberOfReferences() {
    return this._numberOfReferences.readS32();
  }
  set numberOfReferences(value) {
    this._numberOfReferences.writeS32(value);
  }
};
var VSHS_OFFSET_SELF = alignPointerOffset(BHS_SIZE);
var VSHS_OFFSET_CURRENT_SCOPE = VSHS_OFFSET_SELF + pointerSize7;
var VSHS_SIZE = VSHS_OFFSET_CURRENT_SCOPE + pointerSize7;
var VariableSizedHandleScope = class _VariableSizedHandleScope extends BaseHandleScope {
  static $new(thread, vm3) {
    const scope = new _VariableSizedHandleScope(getApi().$new(VSHS_SIZE));
    scope.init(thread, vm3);
    return scope;
  }
  constructor(storage) {
    super(storage);
    this._self = storage.add(VSHS_OFFSET_SELF);
    this._currentScope = storage.add(VSHS_OFFSET_CURRENT_SCOPE);
    const kLocalScopeSize = 64;
    const kSizeOfReferencesPerScope = kLocalScopeSize - pointerSize7 - 4 - 4;
    const kNumReferencesPerScope = kSizeOfReferencesPerScope / 4;
    this._scopeLayout = FixedSizeHandleScope.layoutForCapacity(kNumReferencesPerScope);
    this._topHandleScopePtr = null;
  }
  init(thread, vm3) {
    const topHandleScopePtr = thread.add(getArtThreadSpec(vm3).offset.topHandleScope);
    this._topHandleScopePtr = topHandleScopePtr;
    super.init(topHandleScopePtr.readPointer(), kNumReferencesVariableSized);
    this.self = thread;
    this.currentScope = FixedSizeHandleScope.$new(this._scopeLayout);
    topHandleScopePtr.writePointer(this);
  }
  dispose() {
    this._topHandleScopePtr.writePointer(this.link);
    let scope;
    while ((scope = this.currentScope) !== null) {
      const next = scope.link;
      scope.$delete();
      this.currentScope = next;
    }
  }
  get self() {
    return this._self.readPointer();
  }
  set self(value) {
    this._self.writePointer(value);
  }
  get currentScope() {
    const storage = this._currentScope.readPointer();
    if (storage.isNull()) {
      return null;
    }
    return new FixedSizeHandleScope(storage, this._scopeLayout);
  }
  set currentScope(value) {
    this._currentScope.writePointer(value);
  }
  newHandle(object) {
    return this.currentScope.newHandle(object);
  }
};
var FixedSizeHandleScope = class _FixedSizeHandleScope extends BaseHandleScope {
  static $new(layout) {
    const scope = new _FixedSizeHandleScope(getApi().$new(layout.size), layout);
    scope.init();
    return scope;
  }
  constructor(storage, layout) {
    super(storage);
    const { offset } = layout;
    this._refsStorage = storage.add(offset.refsStorage);
    this._pos = storage.add(offset.pos);
    this._layout = layout;
  }
  init() {
    super.init(NULL, this._layout.numberOfReferences);
    this.pos = 0;
  }
  get pos() {
    return this._pos.readU32();
  }
  set pos(value) {
    this._pos.writeU32(value);
  }
  newHandle(object) {
    const pos = this.pos;
    const handle2 = this._refsStorage.add(pos * 4);
    handle2.writeS32(object.toInt32());
    this.pos = pos + 1;
    return handle2;
  }
  static layoutForCapacity(numRefs) {
    const refsStorage = BHS_SIZE;
    const pos = refsStorage + numRefs * 4;
    return {
      size: pos + 4,
      numberOfReferences: numRefs,
      offset: {
        refsStorage,
        pos
      }
    };
  }
};
var objectVisitorPredicateFactories = {
  arm: function(needle, onMatch) {
    const size = Process.pageSize;
    const predicate = Memory.alloc(size);
    Memory.protect(predicate, size, "rwx");
    const onMatchCallback = new NativeCallback(onMatch, "void", ["pointer"]);
    predicate._onMatchCallback = onMatchCallback;
    const instructions = [
      26625,
      // ldr r1, [r0]
      18947,
      // ldr r2, =needle
      17041,
      // cmp r1, r2
      53505,
      // bne mismatch
      19202,
      // ldr r3, =onMatch
      18200,
      // bx r3
      18288,
      // bx lr
      48896
      // nop
    ];
    const needleOffset = instructions.length * 2;
    const onMatchOffset = needleOffset + 4;
    const codeSize = onMatchOffset + 4;
    Memory.patchCode(predicate, codeSize, function(address) {
      instructions.forEach((instruction, index) => {
        address.add(index * 2).writeU16(instruction);
      });
      address.add(needleOffset).writeS32(needle);
      address.add(onMatchOffset).writePointer(onMatchCallback);
    });
    return predicate.or(1);
  },
  arm64: function(needle, onMatch) {
    const size = Process.pageSize;
    const predicate = Memory.alloc(size);
    Memory.protect(predicate, size, "rwx");
    const onMatchCallback = new NativeCallback(onMatch, "void", ["pointer"]);
    predicate._onMatchCallback = onMatchCallback;
    const instructions = [
      3107979265,
      // ldr w1, [x0]
      402653378,
      // ldr w2, =needle
      1795293247,
      // cmp w1, w2
      1409286241,
      // b.ne mismatch
      1476395139,
      // ldr x3, =onMatch
      3592355936,
      // br x3
      3596551104
      // ret
    ];
    const needleOffset = instructions.length * 4;
    const onMatchOffset = needleOffset + 4;
    const codeSize = onMatchOffset + 8;
    Memory.patchCode(predicate, codeSize, function(address) {
      instructions.forEach((instruction, index) => {
        address.add(index * 4).writeU32(instruction);
      });
      address.add(needleOffset).writeS32(needle);
      address.add(onMatchOffset).writePointer(onMatchCallback);
    });
    return predicate;
  }
};
function makeObjectVisitorPredicate(needle, onMatch) {
  const factory = objectVisitorPredicateFactories[Process.arch] || makeGenericObjectVisitorPredicate;
  return factory(needle, onMatch);
}
function makeGenericObjectVisitorPredicate(needle, onMatch) {
  return new NativeCallback((object) => {
    const klass = object.readS32();
    if (klass === needle) {
      onMatch(object);
    }
  }, "void", ["pointer", "pointer"]);
}
function alignPointerOffset(offset) {
  const remainder = offset % pointerSize7;
  if (remainder !== 0) {
    return offset + pointerSize7 - remainder;
  }
  return offset;
}

// node_modules/frida-java-bridge/lib/jvm.js
var jsizeSize2 = 4;
var { pointerSize: pointerSize8 } = Process;
var JVM_ACC_NATIVE = 256;
var JVM_ACC_IS_OLD = 65536;
var JVM_ACC_IS_OBSOLETE = 131072;
var JVM_ACC_NOT_C2_COMPILABLE = 33554432;
var JVM_ACC_NOT_C1_COMPILABLE = 67108864;
var JVM_ACC_NOT_C2_OSR_COMPILABLE = 134217728;
var nativeFunctionOptions4 = {
  exceptions: "propagate"
};
var getJvmMethodSpec = memoize(_getJvmMethodSpec);
var getJvmInstanceKlassSpec = memoize(_getJvmInstanceKlassSpec);
var getJvmThreadSpec = memoize(_getJvmThreadSpec);
var cachedApi2 = null;
var manglersScheduled = false;
var replaceManglers = /* @__PURE__ */ new Map();
var revertManglers = /* @__PURE__ */ new Map();
function getApi2() {
  if (cachedApi2 === null) {
    cachedApi2 = _getApi2();
  }
  return cachedApi2;
}
function _getApi2() {
  const vmModules = Process.enumerateModules().filter((m2) => /jvm.(dll|dylib|so)$/.test(m2.name));
  if (vmModules.length === 0) {
    return null;
  }
  const vmModule = vmModules[0];
  const temporaryApi = {
    flavor: "jvm"
  };
  const pending = Process.platform === "windows" ? [{
    module: vmModule,
    functions: {
      JNI_GetCreatedJavaVMs: ["JNI_GetCreatedJavaVMs", "int", ["pointer", "int", "pointer"]],
      JVM_Sleep: ["JVM_Sleep", "void", ["pointer", "pointer", "long"]],
      "VMThread::execute": ["VMThread::execute", "void", ["pointer"]],
      "Method::size": ["Method::size", "int", ["int"]],
      "Method::set_native_function": ["Method::set_native_function", "void", ["pointer", "pointer", "int"]],
      "Method::clear_native_function": ["Method::clear_native_function", "void", ["pointer"]],
      "Method::jmethod_id": ["Method::jmethod_id", "pointer", ["pointer"]],
      "ClassLoaderDataGraph::classes_do": ["ClassLoaderDataGraph::classes_do", "void", ["pointer"]],
      "NMethodSweeper::sweep_code_cache": ["NMethodSweeper::sweep_code_cache", "void", []],
      "OopMapCache::flush_obsolete_entries": ["OopMapCache::flush_obsolete_entries", "void", ["pointer"]]
    },
    variables: {
      "VM_RedefineClasses::`vftable'": function(address) {
        this.vtableRedefineClasses = address;
      },
      "VM_RedefineClasses::doit": function(address) {
        this.redefineClassesDoIt = address;
      },
      "VM_RedefineClasses::doit_prologue": function(address) {
        this.redefineClassesDoItPrologue = address;
      },
      "VM_RedefineClasses::doit_epilogue": function(address) {
        this.redefineClassesDoItEpilogue = address;
      },
      "VM_RedefineClasses::allow_nested_vm_operations": function(address) {
        this.redefineClassesAllow = address;
      },
      "NMethodSweeper::_traversals": function(address) {
        this.traversals = address;
      },
      "NMethodSweeper::_should_sweep": function(address) {
        this.shouldSweep = address;
      }
    },
    optionals: []
  }] : [{
    module: vmModule,
    functions: {
      JNI_GetCreatedJavaVMs: ["JNI_GetCreatedJavaVMs", "int", ["pointer", "int", "pointer"]],
      _ZN6Method4sizeEb: ["Method::size", "int", ["int"]],
      _ZN6Method19set_native_functionEPhb: ["Method::set_native_function", "void", ["pointer", "pointer", "int"]],
      _ZN6Method21clear_native_functionEv: ["Method::clear_native_function", "void", ["pointer"]],
      // JDK >= 17
      _ZN6Method24restore_unshareable_infoEP10JavaThread: ["Method::restore_unshareable_info", "void", ["pointer", "pointer"]],
      // JDK < 17
      _ZN6Method24restore_unshareable_infoEP6Thread: ["Method::restore_unshareable_info", "void", ["pointer", "pointer"]],
      _ZN6Method11link_methodERK12methodHandleP10JavaThread: ["Method::link_method", "void", ["pointer", "pointer", "pointer"]],
      _ZN6Method10jmethod_idEv: ["Method::jmethod_id", "pointer", ["pointer"]],
      _ZN6Method10clear_codeEv: function(address) {
        const clearCode = new NativeFunction(address, "void", ["pointer"], nativeFunctionOptions4);
        this["Method::clear_code"] = function(thisPtr) {
          clearCode(thisPtr);
        };
      },
      _ZN6Method10clear_codeEb: function(address) {
        const clearCode = new NativeFunction(address, "void", ["pointer", "int"], nativeFunctionOptions4);
        const lock = 0;
        this["Method::clear_code"] = function(thisPtr) {
          clearCode(thisPtr, lock);
        };
      },
      // JDK >= 13
      _ZN18VM_RedefineClasses19mark_dependent_codeEP13InstanceKlass: ["VM_RedefineClasses::mark_dependent_code", "void", ["pointer", "pointer"]],
      _ZN18VM_RedefineClasses20flush_dependent_codeEv: ["VM_RedefineClasses::flush_dependent_code", "void", []],
      // JDK < 13
      _ZN18VM_RedefineClasses20flush_dependent_codeEP13InstanceKlassP6Thread: ["VM_RedefineClasses::flush_dependent_code", "void", ["pointer", "pointer", "pointer"]],
      // JDK < 10
      _ZN18VM_RedefineClasses20flush_dependent_codeE19instanceKlassHandleP6Thread: ["VM_RedefineClasses::flush_dependent_code", "void", ["pointer", "pointer", "pointer"]],
      _ZN19ResolvedMethodTable21adjust_method_entriesEPb: ["ResolvedMethodTable::adjust_method_entries", "void", ["pointer"]],
      // JDK < 10
      _ZN15MemberNameTable21adjust_method_entriesEP13InstanceKlassPb: ["MemberNameTable::adjust_method_entries", "void", ["pointer", "pointer", "pointer"]],
      _ZN17ConstantPoolCache21adjust_method_entriesEPb: function(address) {
        const adjustMethod = new NativeFunction(address, "void", ["pointer", "pointer"], nativeFunctionOptions4);
        this["ConstantPoolCache::adjust_method_entries"] = function(thisPtr, holderPtr, tracePtr) {
          adjustMethod(thisPtr, tracePtr);
        };
      },
      // JDK < 13
      _ZN17ConstantPoolCache21adjust_method_entriesEP13InstanceKlassPb: function(address) {
        const adjustMethod = new NativeFunction(address, "void", ["pointer", "pointer", "pointer"], nativeFunctionOptions4);
        this["ConstantPoolCache::adjust_method_entries"] = function(thisPtr, holderPtr, tracePtr) {
          adjustMethod(thisPtr, holderPtr, tracePtr);
        };
      },
      _ZN20ClassLoaderDataGraph10classes_doEP12KlassClosure: ["ClassLoaderDataGraph::classes_do", "void", ["pointer"]],
      _ZN20ClassLoaderDataGraph22clean_deallocate_listsEb: ["ClassLoaderDataGraph::clean_deallocate_lists", "void", ["int"]],
      _ZN10JavaThread27thread_from_jni_environmentEP7JNIEnv_: ["JavaThread::thread_from_jni_environment", "pointer", ["pointer"]],
      _ZN8VMThread7executeEP12VM_Operation: ["VMThread::execute", "void", ["pointer"]],
      _ZN11OopMapCache22flush_obsolete_entriesEv: ["OopMapCache::flush_obsolete_entries", "void", ["pointer"]],
      _ZN14NMethodSweeper11force_sweepEv: ["NMethodSweeper::force_sweep", "void", []],
      _ZN14NMethodSweeper16sweep_code_cacheEv: ["NMethodSweeper::sweep_code_cache", "void", []],
      _ZN14NMethodSweeper17sweep_in_progressEv: ["NMethodSweeper::sweep_in_progress", "bool", []],
      JVM_Sleep: ["JVM_Sleep", "void", ["pointer", "pointer", "long"]]
    },
    variables: {
      // JDK <= 9
      _ZN18VM_RedefineClasses14_the_class_oopE: function(address) {
        this.redefineClass = address;
      },
      // 9 < JDK < 13
      _ZN18VM_RedefineClasses10_the_classE: function(address) {
        this.redefineClass = address;
      },
      // JDK < 13
      _ZN18VM_RedefineClasses25AdjustCpoolCacheAndVtable8do_klassEP5Klass: function(address) {
        this.doKlass = address;
      },
      // JDK >= 13
      _ZN18VM_RedefineClasses22AdjustAndCleanMetadata8do_klassEP5Klass: function(address) {
        this.doKlass = address;
      },
      _ZTV18VM_RedefineClasses: function(address) {
        this.vtableRedefineClasses = address;
      },
      _ZN18VM_RedefineClasses4doitEv: function(address) {
        this.redefineClassesDoIt = address;
      },
      _ZN18VM_RedefineClasses13doit_prologueEv: function(address) {
        this.redefineClassesDoItPrologue = address;
      },
      _ZN18VM_RedefineClasses13doit_epilogueEv: function(address) {
        this.redefineClassesDoItEpilogue = address;
      },
      _ZN18VM_RedefineClassesD0Ev: function(address) {
        this.redefineClassesDispose0 = address;
      },
      _ZN18VM_RedefineClassesD1Ev: function(address) {
        this.redefineClassesDispose1 = address;
      },
      _ZNK18VM_RedefineClasses26allow_nested_vm_operationsEv: function(address) {
        this.redefineClassesAllow = address;
      },
      _ZNK18VM_RedefineClasses14print_on_errorEP12outputStream: function(address) {
        this.redefineClassesOnError = address;
      },
      // JDK >= 17
      _ZN13InstanceKlass33create_new_default_vtable_indicesEiP10JavaThread: function(address) {
        this.createNewDefaultVtableIndices = address;
      },
      // JDK < 17
      _ZN13InstanceKlass33create_new_default_vtable_indicesEiP6Thread: function(address) {
        this.createNewDefaultVtableIndices = address;
      },
      _ZN19Abstract_VM_Version19jre_release_versionEv: function(address) {
        const getVersion = new NativeFunction(address, "pointer", [], nativeFunctionOptions4);
        const versionS = getVersion().readCString();
        this.version = versionS.startsWith("1.8") ? 8 : versionS.startsWith("9.") ? 9 : parseInt(versionS.slice(0, 2), 10);
        this.versionS = versionS;
      },
      _ZN14NMethodSweeper11_traversalsE: function(address) {
        this.traversals = address;
      },
      _ZN14NMethodSweeper21_sweep_fractions_leftE: function(address) {
        this.fractions = address;
      },
      _ZN14NMethodSweeper13_should_sweepE: function(address) {
        this.shouldSweep = address;
      }
    },
    optionals: [
      "_ZN6Method24restore_unshareable_infoEP10JavaThread",
      "_ZN6Method24restore_unshareable_infoEP6Thread",
      "_ZN6Method11link_methodERK12methodHandleP10JavaThread",
      "_ZN6Method10clear_codeEv",
      "_ZN6Method10clear_codeEb",
      "_ZN18VM_RedefineClasses19mark_dependent_codeEP13InstanceKlass",
      "_ZN18VM_RedefineClasses20flush_dependent_codeEv",
      "_ZN18VM_RedefineClasses20flush_dependent_codeEP13InstanceKlassP6Thread",
      "_ZN18VM_RedefineClasses20flush_dependent_codeE19instanceKlassHandleP6Thread",
      "_ZN19ResolvedMethodTable21adjust_method_entriesEPb",
      "_ZN15MemberNameTable21adjust_method_entriesEP13InstanceKlassPb",
      "_ZN17ConstantPoolCache21adjust_method_entriesEPb",
      "_ZN17ConstantPoolCache21adjust_method_entriesEP13InstanceKlassPb",
      "_ZN20ClassLoaderDataGraph22clean_deallocate_listsEb",
      "_ZN10JavaThread27thread_from_jni_environmentEP7JNIEnv_",
      "_ZN14NMethodSweeper11force_sweepEv",
      "_ZN14NMethodSweeper17sweep_in_progressEv",
      "_ZN18VM_RedefineClasses14_the_class_oopE",
      "_ZN18VM_RedefineClasses10_the_classE",
      "_ZN18VM_RedefineClasses25AdjustCpoolCacheAndVtable8do_klassEP5Klass",
      "_ZN18VM_RedefineClasses22AdjustAndCleanMetadata8do_klassEP5Klass",
      "_ZN18VM_RedefineClassesD0Ev",
      "_ZN18VM_RedefineClassesD1Ev",
      "_ZNK18VM_RedefineClasses14print_on_errorEP12outputStream",
      "_ZN13InstanceKlass33create_new_default_vtable_indicesEiP10JavaThread",
      "_ZN13InstanceKlass33create_new_default_vtable_indicesEiP6Thread",
      "_ZN14NMethodSweeper21_sweep_fractions_leftE"
    ]
  }];
  const missing = [];
  pending.forEach(function(api3) {
    const module = api3.module;
    const functions = api3.functions || {};
    const variables = api3.variables || {};
    const optionals = new Set(api3.optionals || []);
    const tmp = module.enumerateExports().reduce(function(result, exp) {
      result[exp.name] = exp;
      return result;
    }, {});
    const exportByName = module.enumerateSymbols().reduce(function(result, exp) {
      result[exp.name] = exp;
      return result;
    }, tmp);
    Object.keys(functions).forEach(function(name) {
      const exp = exportByName[name];
      if (exp !== void 0) {
        const signature2 = functions[name];
        if (typeof signature2 === "function") {
          signature2.call(temporaryApi, exp.address);
        } else {
          temporaryApi[signature2[0]] = new NativeFunction(exp.address, signature2[1], signature2[2], nativeFunctionOptions4);
        }
      } else {
        if (!optionals.has(name)) {
          missing.push(name);
        }
      }
    });
    Object.keys(variables).forEach(function(name) {
      const exp = exportByName[name];
      if (exp !== void 0) {
        const handler = variables[name];
        handler.call(temporaryApi, exp.address);
      } else {
        if (!optionals.has(name)) {
          missing.push(name);
        }
      }
    });
  });
  if (missing.length > 0) {
    throw new Error("Java API only partially available; please file a bug. Missing: " + missing.join(", "));
  }
  const vms = Memory.alloc(pointerSize8);
  const vmCount = Memory.alloc(jsizeSize2);
  checkJniResult("JNI_GetCreatedJavaVMs", temporaryApi.JNI_GetCreatedJavaVMs(vms, 1, vmCount));
  if (vmCount.readInt() === 0) {
    return null;
  }
  temporaryApi.vm = vms.readPointer();
  const allocatorFunctions = Process.platform === "windows" ? {
    $new: ["??2@YAPEAX_K@Z", "pointer", ["ulong"]],
    $delete: ["??3@YAXPEAX@Z", "void", ["pointer"]]
  } : {
    $new: ["_Znwm", "pointer", ["ulong"]],
    $delete: ["_ZdlPv", "void", ["pointer"]]
  };
  for (const [name, [rawName, retType2, argTypes2]] of Object.entries(allocatorFunctions)) {
    let address = Module.findGlobalExportByName(rawName);
    if (address === null) {
      address = DebugSymbol.fromName(rawName).address;
      if (address.isNull()) {
        throw new Error(`unable to find C++ allocator API, missing: '${rawName}'`);
      }
    }
    temporaryApi[name] = new NativeFunction(address, retType2, argTypes2, nativeFunctionOptions4);
  }
  temporaryApi.jvmti = getEnvJvmti(temporaryApi);
  if (temporaryApi["JavaThread::thread_from_jni_environment"] === void 0) {
    temporaryApi["JavaThread::thread_from_jni_environment"] = makeThreadFromJniHelper(temporaryApi);
  }
  return temporaryApi;
}
function getEnvJvmti(api3) {
  const vm3 = new VM(api3);
  let env;
  vm3.perform(() => {
    const handle2 = vm3.tryGetEnvHandle(jvmtiVersion.v1_0);
    if (handle2 === null) {
      throw new Error("JVMTI not available");
    }
    env = new EnvJvmti(handle2, vm3);
    const capaBuf = Memory.alloc(8);
    capaBuf.writeU64(jvmtiCapabilities.canTagObjects);
    const result = env.addCapabilities(capaBuf);
    checkJniResult("getEnvJvmti::AddCapabilities", result);
  });
  return env;
}
var threadOffsetParsers = {
  x64: parseX64ThreadOffset
};
function makeThreadFromJniHelper(api3) {
  let offset = null;
  const tryParse = threadOffsetParsers[Process.arch];
  if (tryParse !== void 0) {
    const vm3 = new VM(api3);
    const findClassImpl = vm3.perform((env) => env.handle.readPointer().add(6 * pointerSize8).readPointer());
    offset = parseInstructionsAt(findClassImpl, tryParse, { limit: 11 });
  }
  if (offset === null) {
    return () => {
      throw new Error("Unable to make thread_from_jni_environment() helper for the current architecture");
    };
  }
  return (env) => {
    return env.add(offset);
  };
}
function parseX64ThreadOffset(insn) {
  if (insn.mnemonic !== "lea") {
    return null;
  }
  const { base, disp } = insn.operands[1].value;
  if (!(base === "rdi" && disp < 0)) {
    return null;
  }
  return disp;
}
function ensureClassInitialized2(env, classRef) {
}
var JvmMethodMangler = class {
  constructor(methodId) {
    this.methodId = methodId;
    this.method = methodId.readPointer();
    this.originalMethod = null;
    this.newMethod = null;
    this.resolved = null;
    this.impl = null;
    this.key = methodId.toString(16);
  }
  replace(impl, isInstanceMethod, argTypes2, vm3, api3) {
    const { key } = this;
    const mangler = revertManglers.get(key);
    if (mangler !== void 0) {
      revertManglers.delete(key);
      this.method = mangler.method;
      this.originalMethod = mangler.originalMethod;
      this.newMethod = mangler.newMethod;
      this.resolved = mangler.resolved;
    }
    this.impl = impl;
    replaceManglers.set(key, this);
    ensureManglersScheduled(vm3);
  }
  revert(vm3) {
    const { key } = this;
    replaceManglers.delete(key);
    revertManglers.set(key, this);
    ensureManglersScheduled(vm3);
  }
  resolveTarget(wrapper, isInstanceMethod, env, api3) {
    const { resolved, originalMethod, methodId } = this;
    if (resolved !== null) {
      return resolved;
    }
    if (originalMethod === null) {
      return methodId;
    }
    const vip = originalMethod.oldMethod.vtableIndexPtr;
    vip.writeS32(-2);
    const jmethodID = Memory.alloc(pointerSize8);
    jmethodID.writePointer(this.method);
    this.resolved = jmethodID;
    return jmethodID;
  }
};
function ensureManglersScheduled(vm3) {
  if (!manglersScheduled) {
    manglersScheduled = true;
    Script.nextTick(doManglers, vm3);
  }
}
function doManglers(vm3) {
  const localReplaceManglers = new Map(replaceManglers);
  const localRevertManglers = new Map(revertManglers);
  replaceManglers.clear();
  revertManglers.clear();
  manglersScheduled = false;
  vm3.perform((env) => {
    const api3 = getApi2();
    const thread = api3["JavaThread::thread_from_jni_environment"](env.handle);
    let force = false;
    withJvmThread(() => {
      localReplaceManglers.forEach((mangler) => {
        const { method: method2, originalMethod, impl, methodId, newMethod } = mangler;
        if (originalMethod === null) {
          mangler.originalMethod = fetchJvmMethod(method2);
          mangler.newMethod = nativeJvmMethod(method2, impl, thread);
          installJvmMethod(mangler.newMethod, methodId, thread);
        } else {
          api3["Method::set_native_function"](newMethod.method, impl, 0);
        }
      });
      localRevertManglers.forEach((mangler) => {
        const { originalMethod, methodId, newMethod } = mangler;
        if (originalMethod !== null) {
          revertJvmMethod(originalMethod);
          const revert = originalMethod.oldMethod;
          revert.oldMethod = newMethod;
          installJvmMethod(revert, methodId, thread);
          force = true;
        }
      });
    });
    if (force) {
      forceSweep(env.handle);
    }
  });
}
function forceSweep(env) {
  const {
    fractions,
    shouldSweep,
    traversals,
    "NMethodSweeper::sweep_code_cache": sweep,
    "NMethodSweeper::sweep_in_progress": inProgress,
    "NMethodSweeper::force_sweep": force,
    JVM_Sleep: sleep
  } = getApi2();
  if (force !== void 0) {
    Thread.sleep(0.05);
    force();
    Thread.sleep(0.05);
    force();
  } else {
    let trav = traversals.readS64();
    const endTrav = trav + 2;
    while (endTrav > trav) {
      fractions.writeS32(1);
      sleep(env, NULL, 50);
      if (!inProgress()) {
        withJvmThread(() => {
          Thread.sleep(0.05);
        });
      }
      const sweepNotAlreadyInProgress = shouldSweep.readU8() === 0;
      if (sweepNotAlreadyInProgress) {
        fractions.writeS32(1);
        sweep();
      }
      trav = traversals.readS64();
    }
  }
}
function withJvmThread(fn, fnPrologue, fnEpilogue) {
  const {
    execute: execute3,
    vtable: vtable2,
    vtableSize,
    doItOffset,
    prologueOffset,
    epilogueOffset
  } = getJvmThreadSpec();
  const vtableDup = Memory.dup(vtable2, vtableSize);
  const vmOperation = Memory.alloc(pointerSize8 * 25);
  vmOperation.writePointer(vtableDup);
  const doIt = new NativeCallback(fn, "void", ["pointer"]);
  vtableDup.add(doItOffset).writePointer(doIt);
  let prologue = null;
  if (fnPrologue !== void 0) {
    prologue = new NativeCallback(fnPrologue, "int", ["pointer"]);
    vtableDup.add(prologueOffset).writePointer(prologue);
  }
  let epilogue = null;
  if (fnEpilogue !== void 0) {
    epilogue = new NativeCallback(fnEpilogue, "void", ["pointer"]);
    vtableDup.add(epilogueOffset).writePointer(epilogue);
  }
  execute3(vmOperation);
}
function _getJvmThreadSpec() {
  const {
    vtableRedefineClasses,
    redefineClassesDoIt,
    redefineClassesDoItPrologue,
    redefineClassesDoItEpilogue,
    redefineClassesOnError,
    redefineClassesAllow,
    redefineClassesDispose0,
    redefineClassesDispose1,
    "VMThread::execute": execute3
  } = getApi2();
  const vtablePtr = vtableRedefineClasses.add(2 * pointerSize8);
  const vtableSize = 15 * pointerSize8;
  const vtable2 = Memory.dup(vtablePtr, vtableSize);
  const emptyCallback = new NativeCallback(() => {
  }, "void", ["pointer"]);
  let doItOffset, prologueOffset, epilogueOffset;
  for (let offset = 0; offset !== vtableSize; offset += pointerSize8) {
    const element = vtable2.add(offset);
    const value = element.readPointer();
    if (redefineClassesOnError !== void 0 && value.equals(redefineClassesOnError) || redefineClassesDispose0 !== void 0 && value.equals(redefineClassesDispose0) || redefineClassesDispose1 !== void 0 && value.equals(redefineClassesDispose1)) {
      element.writePointer(emptyCallback);
    } else if (value.equals(redefineClassesDoIt)) {
      doItOffset = offset;
    } else if (value.equals(redefineClassesDoItPrologue)) {
      prologueOffset = offset;
      element.writePointer(redefineClassesAllow);
    } else if (value.equals(redefineClassesDoItEpilogue)) {
      epilogueOffset = offset;
      element.writePointer(emptyCallback);
    }
  }
  return {
    execute: execute3,
    emptyCallback,
    vtable: vtable2,
    vtableSize,
    doItOffset,
    prologueOffset,
    epilogueOffset
  };
}
function makeMethodMangler2(methodId) {
  return new JvmMethodMangler(methodId);
}
function installJvmMethod(method2, methodId, thread) {
  const { method: handle2, oldMethod: old } = method2;
  const api3 = getApi2();
  method2.methodsArray.add(method2.methodIndex * pointerSize8).writePointer(handle2);
  if (method2.vtableIndex >= 0) {
    method2.vtable.add(method2.vtableIndex * pointerSize8).writePointer(handle2);
  }
  methodId.writePointer(handle2);
  old.accessFlagsPtr.writeU32((old.accessFlags | JVM_ACC_IS_OLD | JVM_ACC_IS_OBSOLETE) >>> 0);
  const flushObs = api3["OopMapCache::flush_obsolete_entries"];
  if (flushObs !== void 0) {
    const { oopMapCache } = method2;
    if (!oopMapCache.isNull()) {
      flushObs(oopMapCache);
    }
  }
  const mark = api3["VM_RedefineClasses::mark_dependent_code"];
  const flush = api3["VM_RedefineClasses::flush_dependent_code"];
  if (mark !== void 0) {
    mark(NULL, method2.instanceKlass);
    flush();
  } else {
    flush(NULL, method2.instanceKlass, thread);
  }
  const traceNamePrinted = Memory.alloc(1);
  traceNamePrinted.writeU8(1);
  api3["ConstantPoolCache::adjust_method_entries"](method2.cache, method2.instanceKlass, traceNamePrinted);
  const klassClosure = Memory.alloc(3 * pointerSize8);
  const doKlassPtr = Memory.alloc(pointerSize8);
  doKlassPtr.writePointer(api3.doKlass);
  klassClosure.writePointer(doKlassPtr);
  klassClosure.add(pointerSize8).writePointer(thread);
  klassClosure.add(2 * pointerSize8).writePointer(thread);
  if (api3.redefineClass !== void 0) {
    api3.redefineClass.writePointer(method2.instanceKlass);
  }
  api3["ClassLoaderDataGraph::classes_do"](klassClosure);
  const rmtAdjustMethodEntries = api3["ResolvedMethodTable::adjust_method_entries"];
  if (rmtAdjustMethodEntries !== void 0) {
    rmtAdjustMethodEntries(traceNamePrinted);
  } else {
    const { memberNames } = method2;
    if (!memberNames.isNull()) {
      const mntAdjustMethodEntries = api3["MemberNameTable::adjust_method_entries"];
      if (mntAdjustMethodEntries !== void 0) {
        mntAdjustMethodEntries(memberNames, method2.instanceKlass, traceNamePrinted);
      }
    }
  }
  const clean = api3["ClassLoaderDataGraph::clean_deallocate_lists"];
  if (clean !== void 0) {
    clean(0);
  }
}
function nativeJvmMethod(method2, impl, thread) {
  const api3 = getApi2();
  const newMethod = fetchJvmMethod(method2);
  newMethod.constPtr.writePointer(newMethod.const);
  const flags = (newMethod.accessFlags | JVM_ACC_NATIVE | JVM_ACC_NOT_C2_COMPILABLE | JVM_ACC_NOT_C1_COMPILABLE | JVM_ACC_NOT_C2_OSR_COMPILABLE) >>> 0;
  newMethod.accessFlagsPtr.writeU32(flags);
  newMethod.signatureHandler.writePointer(NULL);
  newMethod.adapter.writePointer(NULL);
  newMethod.i2iEntry.writePointer(NULL);
  api3["Method::clear_code"](newMethod.method);
  newMethod.dataPtr.writePointer(NULL);
  newMethod.countersPtr.writePointer(NULL);
  newMethod.stackmapPtr.writePointer(NULL);
  api3["Method::clear_native_function"](newMethod.method);
  api3["Method::set_native_function"](newMethod.method, impl, 0);
  api3["Method::restore_unshareable_info"](newMethod.method, thread);
  if (api3.version >= 17) {
    const methodHandle = Memory.alloc(2 * pointerSize8);
    methodHandle.writePointer(newMethod.method);
    methodHandle.add(pointerSize8).writePointer(thread);
    api3["Method::link_method"](newMethod.method, methodHandle, thread);
  }
  return newMethod;
}
function fetchJvmMethod(method2) {
  const spec = getJvmMethodSpec();
  const constMethod = method2.add(spec.method.constMethodOffset).readPointer();
  const constMethodSize = constMethod.add(spec.constMethod.sizeOffset).readS32() * pointerSize8;
  const newConstMethod = Memory.alloc(constMethodSize + spec.method.size);
  Memory.copy(newConstMethod, constMethod, constMethodSize);
  const newMethod = newConstMethod.add(constMethodSize);
  Memory.copy(newMethod, method2, spec.method.size);
  const result = readJvmMethod(newMethod, newConstMethod, constMethodSize);
  const oldMethod = readJvmMethod(method2, constMethod, constMethodSize);
  result.oldMethod = oldMethod;
  return result;
}
function readJvmMethod(method2, constMethod, constMethodSize) {
  const api3 = getApi2();
  const spec = getJvmMethodSpec();
  const constPtr = method2.add(spec.method.constMethodOffset);
  const dataPtr = method2.add(spec.method.methodDataOffset);
  const countersPtr = method2.add(spec.method.methodCountersOffset);
  const accessFlagsPtr = method2.add(spec.method.accessFlagsOffset);
  const accessFlags = accessFlagsPtr.readU32();
  const adapter = spec.getAdapterPointer(method2, constMethod);
  const i2iEntry = method2.add(spec.method.i2iEntryOffset);
  const signatureHandler = method2.add(spec.method.signatureHandlerOffset);
  const constantPool = constMethod.add(spec.constMethod.constantPoolOffset).readPointer();
  const stackmapPtr = constMethod.add(spec.constMethod.stackmapDataOffset);
  const instanceKlass = constantPool.add(spec.constantPool.instanceKlassOffset).readPointer();
  const cache = constantPool.add(spec.constantPool.cacheOffset).readPointer();
  const instanceKlassSpec = getJvmInstanceKlassSpec();
  const methods = instanceKlass.add(instanceKlassSpec.methodsOffset).readPointer();
  const methodsCount = methods.readS32();
  const methodsArray = methods.add(pointerSize8);
  const methodIndex = constMethod.add(spec.constMethod.methodIdnumOffset).readU16();
  const vtableIndexPtr = method2.add(spec.method.vtableIndexOffset);
  const vtableIndex = vtableIndexPtr.readS32();
  const vtable2 = instanceKlass.add(instanceKlassSpec.vtableOffset);
  const oopMapCache = instanceKlass.add(instanceKlassSpec.oopMapCacheOffset).readPointer();
  const memberNames = api3.version >= 10 ? instanceKlass.add(instanceKlassSpec.memberNamesOffset).readPointer() : NULL;
  return {
    method: method2,
    methodSize: spec.method.size,
    const: constMethod,
    constSize: constMethodSize,
    constPtr,
    dataPtr,
    countersPtr,
    stackmapPtr,
    instanceKlass,
    methodsArray,
    methodsCount,
    methodIndex,
    vtableIndex,
    vtableIndexPtr,
    vtable: vtable2,
    accessFlags,
    accessFlagsPtr,
    adapter,
    i2iEntry,
    signatureHandler,
    memberNames,
    cache,
    oopMapCache
  };
}
function revertJvmMethod(method2) {
  const { oldMethod: old } = method2;
  old.accessFlagsPtr.writeU32(old.accessFlags);
  old.vtableIndexPtr.writeS32(old.vtableIndex);
}
function _getJvmMethodSpec() {
  const api3 = getApi2();
  const { version } = api3;
  let adapterHandlerLocation;
  if (version >= 17) {
    adapterHandlerLocation = "method:early";
  } else if (version >= 9 && version <= 16) {
    adapterHandlerLocation = "const-method";
  } else {
    adapterHandlerLocation = "method:late";
  }
  const isNative = 1;
  const methodSize = api3["Method::size"](isNative) * pointerSize8;
  const constMethodOffset = pointerSize8;
  const methodDataOffset = 2 * pointerSize8;
  const methodCountersOffset = 3 * pointerSize8;
  const adapterInMethodEarlyOffset = 4 * pointerSize8;
  const adapterInMethodEarlySize = adapterHandlerLocation === "method:early" ? pointerSize8 : 0;
  const accessFlagsOffset = adapterInMethodEarlyOffset + adapterInMethodEarlySize;
  const vtableIndexOffset = accessFlagsOffset + 4;
  const i2iEntryOffset = vtableIndexOffset + 4 + 8;
  const adapterInMethodLateOffset = i2iEntryOffset + pointerSize8;
  const adapterInMethodOffset = adapterInMethodEarlySize !== 0 ? adapterInMethodEarlyOffset : adapterInMethodLateOffset;
  const nativeFunctionOffset = methodSize - 2 * pointerSize8;
  const signatureHandlerOffset = methodSize - pointerSize8;
  const constantPoolOffset = 8;
  const stackmapDataOffset = constantPoolOffset + pointerSize8;
  const adapterInConstMethodOffset = stackmapDataOffset + pointerSize8;
  const adapterInConstMethodSize = adapterHandlerLocation === "const-method" ? pointerSize8 : 0;
  const constMethodSizeOffset = adapterInConstMethodOffset + adapterInConstMethodSize;
  const methodIdnumOffset = constMethodSizeOffset + 14;
  const cacheOffset = 2 * pointerSize8;
  const instanceKlassOffset = 3 * pointerSize8;
  const getAdapterPointer = adapterInConstMethodSize !== 0 ? function(method2, constMethod) {
    return constMethod.add(adapterInConstMethodOffset);
  } : function(method2, constMethod) {
    return method2.add(adapterInMethodOffset);
  };
  return {
    getAdapterPointer,
    method: {
      size: methodSize,
      constMethodOffset,
      methodDataOffset,
      methodCountersOffset,
      accessFlagsOffset,
      vtableIndexOffset,
      i2iEntryOffset,
      nativeFunctionOffset,
      signatureHandlerOffset
    },
    constMethod: {
      constantPoolOffset,
      stackmapDataOffset,
      sizeOffset: constMethodSizeOffset,
      methodIdnumOffset
    },
    constantPool: {
      cacheOffset,
      instanceKlassOffset
    }
  };
}
var vtableOffsetParsers = {
  x64: parseX64VTableOffset
};
function _getJvmInstanceKlassSpec() {
  const { version: jvmVersion, createNewDefaultVtableIndices } = getApi2();
  const tryParse = vtableOffsetParsers[Process.arch];
  if (tryParse === void 0) {
    throw new Error(`Missing vtable offset parser for ${Process.arch}`);
  }
  const vtableOffset = parseInstructionsAt(createNewDefaultVtableIndices, tryParse, { limit: 32 });
  if (vtableOffset === null) {
    throw new Error("Unable to deduce vtable offset");
  }
  const oopMultiplier = jvmVersion >= 10 && jvmVersion <= 11 || jvmVersion >= 15 ? 17 : 18;
  const methodsOffset = vtableOffset - 7 * pointerSize8;
  const memberNamesOffset = vtableOffset - 17 * pointerSize8;
  const oopMapCacheOffset = vtableOffset - oopMultiplier * pointerSize8;
  return {
    vtableOffset,
    methodsOffset,
    memberNamesOffset,
    oopMapCacheOffset
  };
}
function parseX64VTableOffset(insn) {
  if (insn.mnemonic !== "mov") {
    return null;
  }
  const dst = insn.operands[0];
  if (dst.type !== "mem") {
    return null;
  }
  const { value: dstValue } = dst;
  if (dstValue.scale !== 1) {
    return null;
  }
  const { disp } = dstValue;
  if (disp < 256) {
    return null;
  }
  const defaultVtableIndicesOffset = disp;
  return defaultVtableIndicesOffset + 16;
}

// node_modules/frida-java-bridge/lib/api.js
var getApi3 = getApi;
try {
  getAndroidVersion();
} catch (e) {
  getApi3 = getApi2;
}
var api_default = getApi3;

// node_modules/frida-java-bridge/lib/class-model.js
var code2 = `#include <json-glib/json-glib.h>
#include <string.h>

#define kAccStatic 0x0008
#define kAccConstructor 0x00010000

typedef struct _Model Model;
typedef struct _EnumerateMethodsContext EnumerateMethodsContext;

typedef struct _JavaApi JavaApi;
typedef struct _JavaClassApi JavaClassApi;
typedef struct _JavaMethodApi JavaMethodApi;
typedef struct _JavaFieldApi JavaFieldApi;

typedef struct _JNIEnv JNIEnv;
typedef guint8 jboolean;
typedef gint32 jint;
typedef jint jsize;
typedef gpointer jobject;
typedef jobject jclass;
typedef jobject jstring;
typedef jobject jarray;
typedef jarray jobjectArray;
typedef gpointer jfieldID;
typedef gpointer jmethodID;

typedef struct _jvmtiEnv jvmtiEnv;
typedef enum
{
  JVMTI_ERROR_NONE = 0
} jvmtiError;

typedef struct _ArtApi ArtApi;
typedef guint32 ArtHeapReference;
typedef struct _ArtObject ArtObject;
typedef struct _ArtClass ArtClass;
typedef struct _ArtClassLinker ArtClassLinker;
typedef struct _ArtClassVisitor ArtClassVisitor;
typedef struct _ArtClassVisitorVTable ArtClassVisitorVTable;
typedef struct _ArtMethod ArtMethod;
typedef struct _ArtString ArtString;

typedef union _StdString StdString;
typedef struct _StdStringShort StdStringShort;
typedef struct _StdStringLong StdStringLong;

typedef void (* ArtVisitClassesFunc) (ArtClassLinker * linker, ArtClassVisitor * visitor);
typedef const char * (* ArtGetClassDescriptorFunc) (ArtClass * klass, StdString * storage);
typedef void (* ArtPrettyMethodFunc) (StdString * result, ArtMethod * method, jboolean with_signature);

struct _Model
{
  GHashTable * members;
};

struct _EnumerateMethodsContext
{
  GPatternSpec * class_query;
  GPatternSpec * method_query;
  jboolean include_signature;
  jboolean ignore_case;
  jboolean skip_system_classes;
  GHashTable * groups;
};

struct _JavaClassApi
{
  jmethodID get_declared_methods;
  jmethodID get_declared_fields;
};

struct _JavaMethodApi
{
  jmethodID get_name;
  jmethodID get_modifiers;
};

struct _JavaFieldApi
{
  jmethodID get_name;
  jmethodID get_modifiers;
};

struct _JavaApi
{
  JavaClassApi clazz;
  JavaMethodApi method;
  JavaFieldApi field;
};

struct _JNIEnv
{
  gpointer * functions;
};

struct _jvmtiEnv
{
  gpointer * functions;
};

struct _ArtApi
{
  gboolean available;

  guint class_offset_ifields;
  guint class_offset_methods;
  guint class_offset_sfields;
  guint class_offset_copied_methods_offset;

  guint method_size;
  guint method_offset_access_flags;

  guint field_size;
  guint field_offset_access_flags;

  guint alignment_padding;

  ArtClassLinker * linker;
  ArtVisitClassesFunc visit_classes;
  ArtGetClassDescriptorFunc get_class_descriptor;
  ArtPrettyMethodFunc pretty_method;

  void (* free) (gpointer mem);
};

struct _ArtObject
{
  ArtHeapReference klass;
  ArtHeapReference monitor;
};

struct _ArtClass
{
  ArtObject parent;

  ArtHeapReference class_loader;
};

struct _ArtClassVisitor
{
  ArtClassVisitorVTable * vtable;
  gpointer user_data;
};

struct _ArtClassVisitorVTable
{
  void (* reserved1) (ArtClassVisitor * self);
  void (* reserved2) (ArtClassVisitor * self);
  jboolean (* visit) (ArtClassVisitor * self, ArtClass * klass);
};

struct _ArtString
{
  ArtObject parent;

  gint32 count;
  guint32 hash_code;

  union
  {
    guint16 value[0];
    guint8 value_compressed[0];
  };
};

struct _StdStringShort
{
  guint8 size;
  gchar data[(3 * sizeof (gpointer)) - sizeof (guint8)];
};

struct _StdStringLong
{
  gsize capacity;
  gsize size;
  gchar * data;
};

union _StdString
{
  StdStringShort s;
  StdStringLong l;
};

static void model_add_method (Model * self, const gchar * name, jmethodID id, jint modifiers);
static void model_add_field (Model * self, const gchar * name, jfieldID id, jint modifiers);
static void model_free (Model * model);

static jboolean collect_matching_class_methods (ArtClassVisitor * self, ArtClass * klass);
static gchar * finalize_method_groups_to_json (GHashTable * groups);
static GPatternSpec * make_pattern_spec (const gchar * pattern, jboolean ignore_case);
static gchar * class_name_from_signature (const gchar * signature);
static gchar * format_method_signature (const gchar * name, const gchar * signature);
static void append_type (GString * output, const gchar ** type);

static gpointer read_art_array (gpointer object_base, guint field_offset, guint length_size, guint * length);

static void std_string_destroy (StdString * str);
static gchar * std_string_c_str (StdString * self);

extern GMutex lock;
extern GArray * models;
extern JavaApi java_api;
extern ArtApi art_api;

void
init (void)
{
  g_mutex_init (&lock);
  models = g_array_new (FALSE, FALSE, sizeof (Model *));
}

void
finalize (void)
{
  guint n, i;

  n = models->len;
  for (i = 0; i != n; i++)
  {
    Model * model = g_array_index (models, Model *, i);
    model_free (model);
  }

  g_array_unref (models);
  g_mutex_clear (&lock);
}

Model *
model_new (jclass class_handle,
           gpointer class_object,
           JNIEnv * env)
{
  Model * model;
  GHashTable * members;
  gpointer * funcs = env->functions;
  jmethodID (* from_reflected_method) (JNIEnv *, jobject) = funcs[7];
  jfieldID (* from_reflected_field) (JNIEnv *, jobject) = funcs[8];
  jobject (* to_reflected_method) (JNIEnv *, jclass, jmethodID, jboolean) = funcs[9];
  jobject (* to_reflected_field) (JNIEnv *, jclass, jfieldID, jboolean) = funcs[12];
  void (* delete_local_ref) (JNIEnv *, jobject) = funcs[23];
  jobject (* call_object_method) (JNIEnv *, jobject, jmethodID, ...) = funcs[34];
  jint (* call_int_method) (JNIEnv *, jobject, jmethodID, ...) = funcs[49];
  const char * (* get_string_utf_chars) (JNIEnv *, jstring, jboolean *) = funcs[169];
  void (* release_string_utf_chars) (JNIEnv *, jstring, const char *) = funcs[170];
  jsize (* get_array_length) (JNIEnv *, jarray) = funcs[171];
  jobject (* get_object_array_element) (JNIEnv *, jobjectArray, jsize) = funcs[173];
  jsize n, i;

  model = g_new (Model, 1);

  members = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
  model->members = members;

  if (art_api.available)
  {
    gpointer elements;
    guint n, i;
    const guint field_arrays[] = {
      art_api.class_offset_ifields,
      art_api.class_offset_sfields
    };
    guint field_array_cursor;
    gboolean merged_fields = art_api.class_offset_sfields == 0;

    elements = read_art_array (class_object, art_api.class_offset_methods, sizeof (gsize), NULL);
    n = *(guint16 *) (class_object + art_api.class_offset_copied_methods_offset);
    for (i = 0; i != n; i++)
    {
      jmethodID id;
      guint32 access_flags;
      jboolean is_static;
      jobject method, name;
      const char * name_str;
      jint modifiers;

      id = elements + (i * art_api.method_size);

      access_flags = *(guint32 *) (id + art_api.method_offset_access_flags);
      if ((access_flags & kAccConstructor) != 0)
        continue;
      is_static = (access_flags & kAccStatic) != 0;
      method = to_reflected_method (env, class_handle, id, is_static);
      name = call_object_method (env, method, java_api.method.get_name);
      name_str = get_string_utf_chars (env, name, NULL);
      modifiers = access_flags & 0xffff;

      model_add_method (model, name_str, id, modifiers);

      release_string_utf_chars (env, name, name_str);
      delete_local_ref (env, name);
      delete_local_ref (env, method);
    }

    for (field_array_cursor = 0; field_array_cursor != G_N_ELEMENTS (field_arrays); field_array_cursor++)
    {
      jboolean is_static;

      if (field_arrays[field_array_cursor] == 0)
        continue;

      if (!merged_fields)
        is_static = field_array_cursor == 1;

      elements = read_art_array (class_object, field_arrays[field_array_cursor], sizeof (guint32), &n);
      for (i = 0; i != n; i++)
      {
        jfieldID id;
        guint32 access_flags;
        jobject field, name;
        const char * name_str;
        jint modifiers;

        id = elements + (i * art_api.field_size);

        access_flags = *(guint32 *) (id + art_api.field_offset_access_flags);
        if (merged_fields)
          is_static = (access_flags & kAccStatic) != 0;
        field = to_reflected_field (env, class_handle, id, is_static);
        name = call_object_method (env, field, java_api.field.get_name);
        name_str = get_string_utf_chars (env, name, NULL);
        modifiers = access_flags & 0xffff;

        model_add_field (model, name_str, id, modifiers);

        release_string_utf_chars (env, name, name_str);
        delete_local_ref (env, name);
        delete_local_ref (env, field);
      }
    }
  }
  else
  {
    jobject elements;

    elements = call_object_method (env, class_handle, java_api.clazz.get_declared_methods);
    n = get_array_length (env, elements);
    for (i = 0; i != n; i++)
    {
      jobject method, name;
      const char * name_str;
      jmethodID id;
      jint modifiers;

      method = get_object_array_element (env, elements, i);
      name = call_object_method (env, method, java_api.method.get_name);
      name_str = get_string_utf_chars (env, name, NULL);
      id = from_reflected_method (env, method);
      modifiers = call_int_method (env, method, java_api.method.get_modifiers);

      model_add_method (model, name_str, id, modifiers);

      release_string_utf_chars (env, name, name_str);
      delete_local_ref (env, name);
      delete_local_ref (env, method);
    }
    delete_local_ref (env, elements);

    elements = call_object_method (env, class_handle, java_api.clazz.get_declared_fields);
    n = get_array_length (env, elements);
    for (i = 0; i != n; i++)
    {
      jobject field, name;
      const char * name_str;
      jfieldID id;
      jint modifiers;

      field = get_object_array_element (env, elements, i);
      name = call_object_method (env, field, java_api.field.get_name);
      name_str = get_string_utf_chars (env, name, NULL);
      id = from_reflected_field (env, field);
      modifiers = call_int_method (env, field, java_api.field.get_modifiers);

      model_add_field (model, name_str, id, modifiers);

      release_string_utf_chars (env, name, name_str);
      delete_local_ref (env, name);
      delete_local_ref (env, field);
    }
    delete_local_ref (env, elements);
  }

  g_mutex_lock (&lock);
  g_array_append_val (models, model);
  g_mutex_unlock (&lock);

  return model;
}

static void
model_add_method (Model * self,
                  const gchar * name,
                  jmethodID id,
                  jint modifiers)
{
  GHashTable * members = self->members;
  gchar * key, type;
  const gchar * value;

  if (name[0] == '$')
    key = g_strdup_printf ("_%s", name);
  else
    key = g_strdup (name);

  type = (modifiers & kAccStatic) != 0 ? 's' : 'i';

  value = g_hash_table_lookup (members, key);
  if (value == NULL)
    g_hash_table_insert (members, key, g_strdup_printf ("m:%c0x%zx", type, id));
  else
    g_hash_table_insert (members, key, g_strdup_printf ("%s:%c0x%zx", value, type, id));
}

static void
model_add_field (Model * self,
                 const gchar * name,
                 jfieldID id,
                 jint modifiers)
{
  GHashTable * members = self->members;
  gchar * key, type;

  if (name[0] == '$')
    key = g_strdup_printf ("_%s", name);
  else
    key = g_strdup (name);
  while (g_hash_table_contains (members, key))
  {
    gchar * new_key = g_strdup_printf ("_%s", key);
    g_free (key);
    key = new_key;
  }

  type = (modifiers & kAccStatic) != 0 ? 's' : 'i';

  g_hash_table_insert (members, key, g_strdup_printf ("f:%c0x%zx", type, id));
}

static void
model_free (Model * model)
{
  g_hash_table_unref (model->members);

  g_free (model);
}

gboolean
model_has (Model * self,
           const gchar * member)
{
  return g_hash_table_contains (self->members, member);
}

const gchar *
model_find (Model * self,
            const gchar * member)
{
  return g_hash_table_lookup (self->members, member);
}

gchar *
model_list (Model * self)
{
  GString * result;
  GHashTableIter iter;
  guint i;
  const gchar * name;

  result = g_string_sized_new (128);

  g_string_append_c (result, '[');

  g_hash_table_iter_init (&iter, self->members);
  for (i = 0; g_hash_table_iter_next (&iter, (gpointer *) &name, NULL); i++)
  {
    if (i > 0)
      g_string_append_c (result, ',');

    g_string_append_c (result, '"');
    g_string_append (result, name);
    g_string_append_c (result, '"');
  }

  g_string_append_c (result, ']');

  return g_string_free (result, FALSE);
}

gchar *
enumerate_methods_art (const gchar * class_query,
                       const gchar * method_query,
                       jboolean include_signature,
                       jboolean ignore_case,
                       jboolean skip_system_classes)
{
  gchar * result;
  EnumerateMethodsContext ctx;
  ArtClassVisitor visitor;
  ArtClassVisitorVTable visitor_vtable = { NULL, };

  ctx.class_query = make_pattern_spec (class_query, ignore_case);
  ctx.method_query = make_pattern_spec (method_query, ignore_case);
  ctx.include_signature = include_signature;
  ctx.ignore_case = ignore_case;
  ctx.skip_system_classes = skip_system_classes;
  ctx.groups = g_hash_table_new_full (NULL, NULL, NULL, NULL);

  visitor.vtable = &visitor_vtable;
  visitor.user_data = &ctx;

  visitor_vtable.visit = collect_matching_class_methods;

  art_api.visit_classes (art_api.linker, &visitor);

  result = finalize_method_groups_to_json (ctx.groups);

  g_hash_table_unref (ctx.groups);
  g_pattern_spec_free (ctx.method_query);
  g_pattern_spec_free (ctx.class_query);

  return result;
}

static jboolean
collect_matching_class_methods (ArtClassVisitor * self,
                                ArtClass * klass)
{
  EnumerateMethodsContext * ctx = self->user_data;
  const char * descriptor;
  StdString descriptor_storage = { 0, };
  gchar * class_name = NULL;
  gchar * class_name_copy = NULL;
  const gchar * normalized_class_name;
  JsonBuilder * group;
  size_t class_name_length;
  GHashTable * seen_method_names;
  gpointer elements;
  guint n, i;

  if (ctx->skip_system_classes && klass->class_loader == 0)
    goto skip_class;

  descriptor = art_api.get_class_descriptor (klass, &descriptor_storage);
  if (descriptor[0] != 'L')
    goto skip_class;

  class_name = class_name_from_signature (descriptor);

  if (ctx->ignore_case)
  {
    class_name_copy = g_utf8_strdown (class_name, -1);
    normalized_class_name = class_name_copy;
  }
  else
  {
    normalized_class_name = class_name;
  }

  if (!g_pattern_match_string (ctx->class_query, normalized_class_name))
    goto skip_class;

  group = NULL;
  class_name_length = strlen (class_name);
  seen_method_names = ctx->include_signature ? NULL : g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);

  elements = read_art_array (klass, art_api.class_offset_methods, sizeof (gsize), NULL);
  n = *(guint16 *) ((gpointer) klass + art_api.class_offset_copied_methods_offset);
  for (i = 0; i != n; i++)
  {
    ArtMethod * method;
    guint32 access_flags;
    jboolean is_constructor;
    StdString method_name = { 0, };
    const gchar * bare_method_name;
    gchar * bare_method_name_copy = NULL;
    const gchar * normalized_method_name;
    gchar * normalized_method_name_copy = NULL;

    method = elements + (i * art_api.method_size);

    access_flags = *(guint32 *) ((gpointer) method + art_api.method_offset_access_flags);
    is_constructor = (access_flags & kAccConstructor) != 0;

    art_api.pretty_method (&method_name, method, ctx->include_signature);
    bare_method_name = std_string_c_str (&method_name);
    if (ctx->include_signature)
    {
      const gchar * return_type_end, * name_begin;
      GString * name;

      return_type_end = strchr (bare_method_name, ' ');
      name_begin = return_type_end + 1 + class_name_length + 1;
      if (is_constructor && g_str_has_prefix (name_begin, "<clinit>"))
        goto skip_method;

      name = g_string_sized_new (64);

      if (is_constructor)
      {
        g_string_append (name, "$init");
        g_string_append (name, strchr (name_begin, '>') + 1);
      }
      else
      {
        g_string_append (name, name_begin);
      }
      g_string_append (name, ": ");
      g_string_append_len (name, bare_method_name, return_type_end - bare_method_name);

      bare_method_name_copy = g_string_free (name, FALSE);
      bare_method_name = bare_method_name_copy;
    }
    else
    {
      const gchar * name_begin;

      name_begin = bare_method_name + class_name_length + 1;
      if (is_constructor && strcmp (name_begin, "<clinit>") == 0)
        goto skip_method;

      if (is_constructor)
        bare_method_name = "$init";
      else
        bare_method_name += class_name_length + 1;
    }

    if (seen_method_names != NULL && g_hash_table_contains (seen_method_names, bare_method_name))
      goto skip_method;

    if (ctx->ignore_case)
    {
      normalized_method_name_copy = g_utf8_strdown (bare_method_name, -1);
      normalized_method_name = normalized_method_name_copy;
    }
    else
    {
      normalized_method_name = bare_method_name;
    }

    if (!g_pattern_match_string (ctx->method_query, normalized_method_name))
      goto skip_method;

    if (group == NULL)
    {
      group = g_hash_table_lookup (ctx->groups, GUINT_TO_POINTER (klass->class_loader));
      if (group == NULL)
      {
        group = json_builder_new_immutable ();
        g_hash_table_insert (ctx->groups, GUINT_TO_POINTER (klass->class_loader), group);

        json_builder_begin_object (group);

        json_builder_set_member_name (group, "loader");
        json_builder_add_int_value (group, klass->class_loader);

        json_builder_set_member_name (group, "classes");
        json_builder_begin_array (group);
      }

      json_builder_begin_object (group);

      json_builder_set_member_name (group, "name");
      json_builder_add_string_value (group, class_name);

      json_builder_set_member_name (group, "methods");
      json_builder_begin_array (group);
    }

    json_builder_add_string_value (group, bare_method_name);

    if (seen_method_names != NULL)
      g_hash_table_add (seen_method_names, g_strdup (bare_method_name));

skip_method:
    g_free (normalized_method_name_copy);
    g_free (bare_method_name_copy);
    std_string_destroy (&method_name);
  }

  if (seen_method_names != NULL)
    g_hash_table_unref (seen_method_names);

  if (group == NULL)
    goto skip_class;

  json_builder_end_array (group);
  json_builder_end_object (group);

skip_class:
  g_free (class_name_copy);
  g_free (class_name);
  std_string_destroy (&descriptor_storage);

  return TRUE;
}

gchar *
enumerate_methods_jvm (const gchar * class_query,
                       const gchar * method_query,
                       jboolean include_signature,
                       jboolean ignore_case,
                       jboolean skip_system_classes,
                       JNIEnv * env,
                       jvmtiEnv * jvmti)
{
  gchar * result;
  GPatternSpec * class_pattern, * method_pattern;
  GHashTable * groups;
  gpointer * ef = env->functions;
  jobject (* new_global_ref) (JNIEnv *, jobject) = ef[21];
  void (* delete_local_ref) (JNIEnv *, jobject) = ef[23];
  jboolean (* is_same_object) (JNIEnv *, jobject, jobject) = ef[24];
  gpointer * jf = jvmti->functions - 1;
  jvmtiError (* deallocate) (jvmtiEnv *, void * mem) = jf[47];
  jvmtiError (* get_class_signature) (jvmtiEnv *, jclass, char **, char **) = jf[48];
  jvmtiError (* get_class_methods) (jvmtiEnv *, jclass, jint *, jmethodID **) = jf[52];
  jvmtiError (* get_class_loader) (jvmtiEnv *, jclass, jobject *) = jf[57];
  jvmtiError (* get_method_name) (jvmtiEnv *, jmethodID, char **, char **, char **) = jf[64];
  jvmtiError (* get_loaded_classes) (jvmtiEnv *, jint *, jclass **) = jf[78];
  jint class_count, class_index;
  jclass * classes;

  class_pattern = make_pattern_spec (class_query, ignore_case);
  method_pattern = make_pattern_spec (method_query, ignore_case);
  groups = g_hash_table_new_full (NULL, NULL, NULL, NULL);

  if (get_loaded_classes (jvmti, &class_count, &classes) != JVMTI_ERROR_NONE)
    goto emit_results;

  for (class_index = 0; class_index != class_count; class_index++)
  {
    jclass klass = classes[class_index];
    jobject loader = NULL;
    gboolean have_loader = FALSE;
    char * signature = NULL;
    gchar * class_name = NULL;
    gchar * class_name_copy = NULL;
    const gchar * normalized_class_name;
    jint method_count, method_index;
    jmethodID * methods = NULL;
    JsonBuilder * group = NULL;
    GHashTable * seen_method_names = NULL;

    if (skip_system_classes)
    {
      if (get_class_loader (jvmti, klass, &loader) != JVMTI_ERROR_NONE)
        goto skip_class;
      have_loader = TRUE;

      if (loader == NULL)
        goto skip_class;
    }

    if (get_class_signature (jvmti, klass, &signature, NULL) != JVMTI_ERROR_NONE)
      goto skip_class;

    class_name = class_name_from_signature (signature);

    if (ignore_case)
    {
      class_name_copy = g_utf8_strdown (class_name, -1);
      normalized_class_name = class_name_copy;
    }
    else
    {
      normalized_class_name = class_name;
    }

    if (!g_pattern_match_string (class_pattern, normalized_class_name))
      goto skip_class;

    if (get_class_methods (jvmti, klass, &method_count, &methods) != JVMTI_ERROR_NONE)
      goto skip_class;

    if (!include_signature)
      seen_method_names = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);

    for (method_index = 0; method_index != method_count; method_index++)
    {
      jmethodID method = methods[method_index];
      const gchar * method_name;
      char * method_name_value = NULL;
      char * method_signature_value = NULL;
      gchar * method_name_copy = NULL;
      const gchar * normalized_method_name;
      gchar * normalized_method_name_copy = NULL;

      if (get_method_name (jvmti, method, &method_name_value, include_signature ? &method_signature_value : NULL, NULL) != JVMTI_ERROR_NONE)
        goto skip_method;
      method_name = method_name_value;

      if (method_name[0] == '<')
      {
        if (strcmp (method_name, "<init>") == 0)
          method_name = "$init";
        else if (strcmp (method_name, "<clinit>") == 0)
          goto skip_method;
      }

      if (include_signature)
      {
        method_name_copy = format_method_signature (method_name, method_signature_value);
        method_name = method_name_copy;
      }

      if (seen_method_names != NULL && g_hash_table_contains (seen_method_names, method_name))
        goto skip_method;

      if (ignore_case)
      {
        normalized_method_name_copy = g_utf8_strdown (method_name, -1);
        normalized_method_name = normalized_method_name_copy;
      }
      else
      {
        normalized_method_name = method_name;
      }

      if (!g_pattern_match_string (method_pattern, normalized_method_name))
        goto skip_method;

      if (group == NULL)
      {
        if (!have_loader && get_class_loader (jvmti, klass, &loader) != JVMTI_ERROR_NONE)
          goto skip_method;

        if (loader == NULL)
        {
          group = g_hash_table_lookup (groups, NULL);
        }
        else
        {
          GHashTableIter iter;
          jobject cur_loader;
          JsonBuilder * cur_group;

          g_hash_table_iter_init (&iter, groups);
          while (g_hash_table_iter_next (&iter, (gpointer *) &cur_loader, (gpointer *) &cur_group))
          {
            if (cur_loader != NULL && is_same_object (env, cur_loader, loader))
            {
              group = cur_group;
              break;
            }
          }
        }

        if (group == NULL)
        {
          jobject l;
          gchar * str;

          l = (loader != NULL) ? new_global_ref (env, loader) : NULL;

          group = json_builder_new_immutable ();
          g_hash_table_insert (groups, l, group);

          json_builder_begin_object (group);

          json_builder_set_member_name (group, "loader");
          str = g_strdup_printf ("0x%" G_GSIZE_MODIFIER "x", GPOINTER_TO_SIZE (l));
          json_builder_add_string_value (group, str);
          g_free (str);

          json_builder_set_member_name (group, "classes");
          json_builder_begin_array (group);
        }

        json_builder_begin_object (group);

        json_builder_set_member_name (group, "name");
        json_builder_add_string_value (group, class_name);

        json_builder_set_member_name (group, "methods");
        json_builder_begin_array (group);
      }

      json_builder_add_string_value (group, method_name);

      if (seen_method_names != NULL)
        g_hash_table_add (seen_method_names, g_strdup (method_name));

skip_method:
      g_free (normalized_method_name_copy);
      g_free (method_name_copy);
      deallocate (jvmti, method_signature_value);
      deallocate (jvmti, method_name_value);
    }

skip_class:
    if (group != NULL)
    {
      json_builder_end_array (group);
      json_builder_end_object (group);
    }

    if (seen_method_names != NULL)
      g_hash_table_unref (seen_method_names);

    deallocate (jvmti, methods);

    g_free (class_name_copy);
    g_free (class_name);
    deallocate (jvmti, signature);

    if (loader != NULL)
      delete_local_ref (env, loader);

    delete_local_ref (env, klass);
  }

  deallocate (jvmti, classes);

emit_results:
  result = finalize_method_groups_to_json (groups);

  g_hash_table_unref (groups);
  g_pattern_spec_free (method_pattern);
  g_pattern_spec_free (class_pattern);

  return result;
}

static gchar *
finalize_method_groups_to_json (GHashTable * groups)
{
  GString * result;
  GHashTableIter iter;
  guint i;
  JsonBuilder * group;

  result = g_string_sized_new (1024);

  g_string_append_c (result, '[');

  g_hash_table_iter_init (&iter, groups);
  for (i = 0; g_hash_table_iter_next (&iter, NULL, (gpointer *) &group); i++)
  {
    JsonNode * root;
    gchar * json;

    if (i > 0)
      g_string_append_c (result, ',');

    json_builder_end_array (group);
    json_builder_end_object (group);

    root = json_builder_get_root (group);
    json = json_to_string (root, FALSE);
    g_string_append (result, json);
    g_free (json);
    json_node_unref (root);

    g_object_unref (group);
  }

  g_string_append_c (result, ']');

  return g_string_free (result, FALSE);
}

static GPatternSpec *
make_pattern_spec (const gchar * pattern,
                   jboolean ignore_case)
{
  GPatternSpec * spec;

  if (ignore_case)
  {
    gchar * str = g_utf8_strdown (pattern, -1);
    spec = g_pattern_spec_new (str);
    g_free (str);
  }
  else
  {
    spec = g_pattern_spec_new (pattern);
  }

  return spec;
}

static gchar *
class_name_from_signature (const gchar * descriptor)
{
  gchar * result, * c;

  result = g_strdup (descriptor + 1);

  for (c = result; *c != '\\0'; c++)
  {
    if (*c == '/')
      *c = '.';
  }

  c[-1] = '\\0';

  return result;
}

static gchar *
format_method_signature (const gchar * name,
                         const gchar * signature)
{
  GString * sig;
  const gchar * cursor;
  gint arg_index;

  sig = g_string_sized_new (128);

  g_string_append (sig, name);

  cursor = signature;
  arg_index = -1;
  while (TRUE)
  {
    const gchar c = *cursor;

    if (c == '(')
    {
      g_string_append_c (sig, c);
      cursor++;
      arg_index = 0;
    }
    else if (c == ')')
    {
      g_string_append_c (sig, c);
      cursor++;
      break;
    }
    else
    {
      if (arg_index >= 1)
        g_string_append (sig, ", ");

      append_type (sig, &cursor);

      if (arg_index != -1)
        arg_index++;
    }
  }

  g_string_append (sig, ": ");
  append_type (sig, &cursor);

  return g_string_free (sig, FALSE);
}

static void
append_type (GString * output,
             const gchar ** type)
{
  const gchar * cursor = *type;

  switch (*cursor)
  {
    case 'Z':
      g_string_append (output, "boolean");
      cursor++;
      break;
    case 'B':
      g_string_append (output, "byte");
      cursor++;
      break;
    case 'C':
      g_string_append (output, "char");
      cursor++;
      break;
    case 'S':
      g_string_append (output, "short");
      cursor++;
      break;
    case 'I':
      g_string_append (output, "int");
      cursor++;
      break;
    case 'J':
      g_string_append (output, "long");
      cursor++;
      break;
    case 'F':
      g_string_append (output, "float");
      cursor++;
      break;
    case 'D':
      g_string_append (output, "double");
      cursor++;
      break;
    case 'V':
      g_string_append (output, "void");
      cursor++;
      break;
    case 'L':
    {
      gchar ch;

      cursor++;
      for (; (ch = *cursor) != ';'; cursor++)
      {
        g_string_append_c (output, (ch != '/') ? ch : '.');
      }
      cursor++;

      break;
    }
    case '[':
      *type = cursor + 1;
      append_type (output, type);
      g_string_append (output, "[]");
      return;
    default:
      g_string_append (output, "BUG");
      cursor++;
  }

  *type = cursor;
}

void
dealloc (gpointer mem)
{
  g_free (mem);
}

static gpointer
read_art_array (gpointer object_base,
                guint field_offset,
                guint length_size,
                guint * length)
{
  gpointer result, header;
  guint n;

  header = GSIZE_TO_POINTER (*(guint64 *) (object_base + field_offset));
  if (header != NULL)
  {
    result = header + length_size;
    if (length_size == sizeof (guint32))
      n = *(guint32 *) header;
    else
      n = *(guint64 *) header;
  }
  else
  {
    result = NULL;
    n = 0;
  }

  if (length != NULL)
    *length = n;

  return result;
}

static void
std_string_destroy (StdString * str)
{
  if ((str->l.capacity & 1) != 0)
    art_api.free (str->l.data);
}

static gchar *
std_string_c_str (StdString * self)
{
  if ((self->l.capacity & 1) != 0)
    return self->l.data;

  return self->s.data;
}
`;
var methodQueryPattern = /(.+)!([^/]+)\/?([isu]+)?/;
var cm = null;
var unwrap = null;
var Model = class _Model {
  static build(handle2, env) {
    ensureInitialized(env);
    return unwrap(handle2, env, (object) => {
      return new _Model(cm.new(handle2, object, env));
    });
  }
  static enumerateMethods(query, api3, env) {
    ensureInitialized(env);
    const params = query.match(methodQueryPattern);
    if (params === null) {
      throw new Error("Invalid query; format is: class!method -- see documentation of Java.enumerateMethods(query) for details");
    }
    const classQuery = Memory.allocUtf8String(params[1]);
    const methodQuery = Memory.allocUtf8String(params[2]);
    let includeSignature = false;
    let ignoreCase = false;
    let skipSystemClasses = false;
    const modifiers2 = params[3];
    if (modifiers2 !== void 0) {
      includeSignature = modifiers2.indexOf("s") !== -1;
      ignoreCase = modifiers2.indexOf("i") !== -1;
      skipSystemClasses = modifiers2.indexOf("u") !== -1;
    }
    let result;
    if (api3.flavor === "jvm") {
      const json = cm.enumerateMethodsJvm(
        classQuery,
        methodQuery,
        boolToNative(includeSignature),
        boolToNative(ignoreCase),
        boolToNative(skipSystemClasses),
        env,
        api3.jvmti
      );
      try {
        result = JSON.parse(json.readUtf8String()).map((group) => {
          const loaderRef = ptr(group.loader);
          group.loader = !loaderRef.isNull() ? loaderRef : null;
          return group;
        });
      } finally {
        cm.dealloc(json);
      }
    } else {
      withRunnableArtThread(env.vm, env, (thread) => {
        const json = cm.enumerateMethodsArt(
          classQuery,
          methodQuery,
          boolToNative(includeSignature),
          boolToNative(ignoreCase),
          boolToNative(skipSystemClasses)
        );
        try {
          const addGlobalReference = api3["art::JavaVMExt::AddGlobalRef"];
          const { vm: vmHandle } = api3;
          result = JSON.parse(json.readUtf8String()).map((group) => {
            const loaderObj = group.loader;
            group.loader = loaderObj !== 0 ? addGlobalReference(vmHandle, thread, ptr(loaderObj)) : null;
            return group;
          });
        } finally {
          cm.dealloc(json);
        }
      });
    }
    return result;
  }
  constructor(handle2) {
    this.handle = handle2;
  }
  has(member) {
    return cm.has(this.handle, Memory.allocUtf8String(member)) !== 0;
  }
  find(member) {
    return cm.find(this.handle, Memory.allocUtf8String(member)).readUtf8String();
  }
  list() {
    const str = cm.list(this.handle);
    try {
      return JSON.parse(str.readUtf8String());
    } finally {
      cm.dealloc(str);
    }
  }
};
function ensureInitialized(env) {
  if (cm === null) {
    cm = compileModule(env);
    unwrap = makeHandleUnwrapper(cm, env.vm);
  }
}
function compileModule(env) {
  const { pointerSize: pointerSize12 } = Process;
  const lockSize = 8;
  const modelsSize = pointerSize12;
  const javaApiSize = 6 * pointerSize12;
  const artApiSize = 10 * 4 + 5 * pointerSize12;
  const dataSize = lockSize + modelsSize + javaApiSize + artApiSize;
  const data = Memory.alloc(dataSize);
  const lock = data;
  const models = lock.add(lockSize);
  const javaApi = models.add(modelsSize);
  const { getDeclaredMethods, getDeclaredFields } = env.javaLangClass();
  const method2 = env.javaLangReflectMethod();
  const field = env.javaLangReflectField();
  let j = javaApi;
  [
    getDeclaredMethods,
    getDeclaredFields,
    method2.getName,
    method2.getModifiers,
    field.getName,
    field.getModifiers
  ].forEach((value) => {
    j = j.writePointer(value).add(pointerSize12);
  });
  const artApi = javaApi.add(javaApiSize);
  const { vm: vm3 } = env;
  const artClass = getArtClassSpec(vm3);
  if (artClass !== null) {
    const c = artClass.offset;
    const m2 = getArtMethodSpec(vm3);
    const f2 = getArtFieldSpec(vm3);
    let s = artApi;
    [
      1,
      c.ifields,
      c.methods,
      c.sfields,
      c.copiedMethodsOffset,
      m2.size,
      m2.offset.accessFlags,
      f2.size,
      f2.offset.accessFlags,
      4294967295
    ].forEach((value) => {
      s = s.writeUInt(value).add(4);
    });
    const api3 = getApi();
    [
      api3.artClassLinker.address,
      api3["art::ClassLinker::VisitClasses"],
      api3["art::mirror::Class::GetDescriptor"],
      api3["art::ArtMethod::PrettyMethod"],
      Process.getModuleByName("libc.so").getExportByName("free")
    ].forEach((value, i) => {
      if (value === void 0) {
        value = NULL;
      }
      s = s.writePointer(value).add(pointerSize12);
    });
  }
  const cm2 = new CModule(code2, {
    lock,
    models,
    java_api: javaApi,
    art_api: artApi
  });
  const reentrantOptions = { exceptions: "propagate" };
  const fastOptions = { exceptions: "propagate", scheduling: "exclusive" };
  return {
    handle: cm2,
    mode: artClass !== null ? "full" : "basic",
    new: new NativeFunction(cm2.model_new, "pointer", ["pointer", "pointer", "pointer"], reentrantOptions),
    has: new NativeFunction(cm2.model_has, "bool", ["pointer", "pointer"], fastOptions),
    find: new NativeFunction(cm2.model_find, "pointer", ["pointer", "pointer"], fastOptions),
    list: new NativeFunction(cm2.model_list, "pointer", ["pointer"], fastOptions),
    enumerateMethodsArt: new NativeFunction(
      cm2.enumerate_methods_art,
      "pointer",
      ["pointer", "pointer", "bool", "bool", "bool"],
      reentrantOptions
    ),
    enumerateMethodsJvm: new NativeFunction(cm2.enumerate_methods_jvm, "pointer", [
      "pointer",
      "pointer",
      "bool",
      "bool",
      "bool",
      "pointer",
      "pointer"
    ], reentrantOptions),
    dealloc: new NativeFunction(cm2.dealloc, "void", ["pointer"], fastOptions)
  };
}
function makeHandleUnwrapper(cm2, vm3) {
  if (cm2.mode === "basic") {
    return nullUnwrap;
  }
  const decodeGlobal = getApi()["art::JavaVMExt::DecodeGlobal"];
  return function(handle2, env, fn) {
    let result;
    withRunnableArtThread(vm3, env, (thread) => {
      const object = decodeGlobal(vm3, thread, handle2);
      result = fn(object);
    });
    return result;
  };
}
function nullUnwrap(handle2, env, fn) {
  return fn(NULL);
}
function boolToNative(val) {
  return val ? 1 : 0;
}

// node_modules/frida-java-bridge/lib/lru.js
var LRU = class {
  constructor(capacity, destroy) {
    this.items = /* @__PURE__ */ new Map();
    this.capacity = capacity;
    this.destroy = destroy;
  }
  dispose(env) {
    const { items, destroy } = this;
    items.forEach((val) => {
      destroy(val, env);
    });
    items.clear();
  }
  get(key) {
    const { items } = this;
    const item = items.get(key);
    if (item !== void 0) {
      items.delete(key);
      items.set(key, item);
    }
    return item;
  }
  set(key, val, env) {
    const { items } = this;
    const existingVal = items.get(key);
    if (existingVal !== void 0) {
      items.delete(key);
      this.destroy(existingVal, env);
    } else if (items.size === this.capacity) {
      const oldestKey = items.keys().next().value;
      const oldestVal = items.get(oldestKey);
      items.delete(oldestKey);
      this.destroy(oldestVal, env);
    }
    items.set(key, val);
  }
};

// node_modules/frida-java-bridge/lib/mkdex.js
var kAccPublic2 = 1;
var kAccNative2 = 256;
var kAccConstructor = 65536;
var kEndianTag = 305419896;
var kClassDefSize = 32;
var kProtoIdSize = 12;
var kFieldIdSize = 8;
var kMethodIdSize = 8;
var kTypeIdSize = 4;
var kStringIdSize = 4;
var kMapItemSize = 12;
var TYPE_HEADER_ITEM = 0;
var TYPE_STRING_ID_ITEM = 1;
var TYPE_TYPE_ID_ITEM = 2;
var TYPE_PROTO_ID_ITEM = 3;
var TYPE_FIELD_ID_ITEM = 4;
var TYPE_METHOD_ID_ITEM = 5;
var TYPE_CLASS_DEF_ITEM = 6;
var TYPE_MAP_LIST = 4096;
var TYPE_TYPE_LIST = 4097;
var TYPE_ANNOTATION_SET_ITEM = 4099;
var TYPE_CLASS_DATA_ITEM = 8192;
var TYPE_CODE_ITEM = 8193;
var TYPE_STRING_DATA_ITEM = 8194;
var TYPE_DEBUG_INFO_ITEM = 8195;
var TYPE_ANNOTATION_ITEM = 8196;
var TYPE_ANNOTATIONS_DIRECTORY_ITEM = 8198;
var VALUE_TYPE = 24;
var VALUE_ARRAY = 28;
var VISIBILITY_SYSTEM = 2;
var kDefaultConstructorSize = 24;
var kDefaultConstructorDebugInfo = Buffer2.from([3, 0, 7, 14, 0]);
var kDalvikAnnotationTypeThrows = "Ldalvik/annotation/Throws;";
var kNullTerminator = Buffer2.from([0]);
function mkdex(spec) {
  const builder = new DexBuilder();
  const fullSpec = Object.assign({}, spec);
  builder.addClass(fullSpec);
  return builder.build();
}
var DexBuilder = class {
  constructor() {
    this.classes = [];
  }
  addClass(spec) {
    this.classes.push(spec);
  }
  build() {
    const model = computeModel(this.classes);
    const {
      classes,
      interfaces,
      fields,
      methods,
      protos,
      parameters,
      annotationDirectories,
      annotationSets,
      throwsAnnotations,
      types: types2,
      strings
    } = model;
    let offset = 0;
    const headerOffset = 0;
    const checksumOffset = 8;
    const signatureOffset = 12;
    const signatureSize = 20;
    const headerSize = 112;
    offset += headerSize;
    const stringIdsOffset = offset;
    const stringIdsSize = strings.length * kStringIdSize;
    offset += stringIdsSize;
    const typeIdsOffset = offset;
    const typeIdsSize = types2.length * kTypeIdSize;
    offset += typeIdsSize;
    const protoIdsOffset = offset;
    const protoIdsSize = protos.length * kProtoIdSize;
    offset += protoIdsSize;
    const fieldIdsOffset = offset;
    const fieldIdsSize = fields.length * kFieldIdSize;
    offset += fieldIdsSize;
    const methodIdsOffset = offset;
    const methodIdsSize = methods.length * kMethodIdSize;
    offset += methodIdsSize;
    const classDefsOffset = offset;
    const classDefsSize = classes.length * kClassDefSize;
    offset += classDefsSize;
    const dataOffset = offset;
    const annotationSetOffsets = annotationSets.map((set) => {
      const setOffset = offset;
      set.offset = setOffset;
      offset += 4 + set.items.length * 4;
      return setOffset;
    });
    const javaCodeItems = classes.reduce((result, klass) => {
      const constructorMethods = klass.classData.constructorMethods;
      constructorMethods.forEach((method2) => {
        const [, accessFlags, superConstructor] = method2;
        if ((accessFlags & kAccNative2) === 0 && superConstructor >= 0) {
          method2.push(offset);
          result.push({ offset, superConstructor });
          offset += kDefaultConstructorSize;
        }
      });
      return result;
    }, []);
    annotationDirectories.forEach((dir) => {
      dir.offset = offset;
      offset += 16 + dir.methods.length * 8;
    });
    const interfaceOffsets = interfaces.map((iface) => {
      offset = align2(offset, 4);
      const ifaceOffset = offset;
      iface.offset = ifaceOffset;
      offset += 4 + 2 * iface.types.length;
      return ifaceOffset;
    });
    const parameterOffsets = parameters.map((param) => {
      offset = align2(offset, 4);
      const paramOffset = offset;
      param.offset = paramOffset;
      offset += 4 + 2 * param.types.length;
      return paramOffset;
    });
    const stringChunks = [];
    const stringOffsets = strings.map((str) => {
      const strOffset = offset;
      const header = Buffer2.from(createUleb128(str.length));
      const data = Buffer2.from(str, "utf8");
      const chunk = Buffer2.concat([header, data, kNullTerminator]);
      stringChunks.push(chunk);
      offset += chunk.length;
      return strOffset;
    });
    const debugInfoOffsets = javaCodeItems.map((codeItem) => {
      const debugOffset = offset;
      offset += kDefaultConstructorDebugInfo.length;
      return debugOffset;
    });
    const throwsAnnotationBlobs = throwsAnnotations.map((annotation) => {
      const blob = makeThrowsAnnotation(annotation);
      annotation.offset = offset;
      offset += blob.length;
      return blob;
    });
    const classDataBlobs = classes.map((klass, index) => {
      klass.classData.offset = offset;
      const blob = makeClassData(klass);
      offset += blob.length;
      return blob;
    });
    const linkSize = 0;
    const linkOffset = 0;
    offset = align2(offset, 4);
    const mapOffset = offset;
    const typeListLength = interfaces.length + parameters.length;
    const mapNumItems = 4 + (fields.length > 0 ? 1 : 0) + 2 + annotationSets.length + javaCodeItems.length + annotationDirectories.length + (typeListLength > 0 ? 1 : 0) + 1 + debugInfoOffsets.length + throwsAnnotations.length + classes.length + 1;
    const mapSize = 4 + mapNumItems * kMapItemSize;
    offset += mapSize;
    const dataSize = offset - dataOffset;
    const fileSize = offset;
    const dex = Buffer2.alloc(fileSize);
    dex.write("dex\n035");
    dex.writeUInt32LE(fileSize, 32);
    dex.writeUInt32LE(headerSize, 36);
    dex.writeUInt32LE(kEndianTag, 40);
    dex.writeUInt32LE(linkSize, 44);
    dex.writeUInt32LE(linkOffset, 48);
    dex.writeUInt32LE(mapOffset, 52);
    dex.writeUInt32LE(strings.length, 56);
    dex.writeUInt32LE(stringIdsOffset, 60);
    dex.writeUInt32LE(types2.length, 64);
    dex.writeUInt32LE(typeIdsOffset, 68);
    dex.writeUInt32LE(protos.length, 72);
    dex.writeUInt32LE(protoIdsOffset, 76);
    dex.writeUInt32LE(fields.length, 80);
    dex.writeUInt32LE(fields.length > 0 ? fieldIdsOffset : 0, 84);
    dex.writeUInt32LE(methods.length, 88);
    dex.writeUInt32LE(methodIdsOffset, 92);
    dex.writeUInt32LE(classes.length, 96);
    dex.writeUInt32LE(classDefsOffset, 100);
    dex.writeUInt32LE(dataSize, 104);
    dex.writeUInt32LE(dataOffset, 108);
    stringOffsets.forEach((offset2, index) => {
      dex.writeUInt32LE(offset2, stringIdsOffset + index * kStringIdSize);
    });
    types2.forEach((id, index) => {
      dex.writeUInt32LE(id, typeIdsOffset + index * kTypeIdSize);
    });
    protos.forEach((proto, index) => {
      const [shortyIndex, returnTypeIndex, params] = proto;
      const protoOffset = protoIdsOffset + index * kProtoIdSize;
      dex.writeUInt32LE(shortyIndex, protoOffset);
      dex.writeUInt32LE(returnTypeIndex, protoOffset + 4);
      dex.writeUInt32LE(params !== null ? params.offset : 0, protoOffset + 8);
    });
    fields.forEach((field, index) => {
      const [classIndex, typeIndex, nameIndex] = field;
      const fieldOffset = fieldIdsOffset + index * kFieldIdSize;
      dex.writeUInt16LE(classIndex, fieldOffset);
      dex.writeUInt16LE(typeIndex, fieldOffset + 2);
      dex.writeUInt32LE(nameIndex, fieldOffset + 4);
    });
    methods.forEach((method2, index) => {
      const [classIndex, protoIndex, nameIndex] = method2;
      const methodOffset = methodIdsOffset + index * kMethodIdSize;
      dex.writeUInt16LE(classIndex, methodOffset);
      dex.writeUInt16LE(protoIndex, methodOffset + 2);
      dex.writeUInt32LE(nameIndex, methodOffset + 4);
    });
    classes.forEach((klass, index) => {
      const { interfaces: interfaces2, annotationsDirectory } = klass;
      const interfacesOffset = interfaces2 !== null ? interfaces2.offset : 0;
      const annotationsOffset = annotationsDirectory !== null ? annotationsDirectory.offset : 0;
      const staticValuesOffset = 0;
      const classOffset = classDefsOffset + index * kClassDefSize;
      dex.writeUInt32LE(klass.index, classOffset);
      dex.writeUInt32LE(klass.accessFlags, classOffset + 4);
      dex.writeUInt32LE(klass.superClassIndex, classOffset + 8);
      dex.writeUInt32LE(interfacesOffset, classOffset + 12);
      dex.writeUInt32LE(klass.sourceFileIndex, classOffset + 16);
      dex.writeUInt32LE(annotationsOffset, classOffset + 20);
      dex.writeUInt32LE(klass.classData.offset, classOffset + 24);
      dex.writeUInt32LE(staticValuesOffset, classOffset + 28);
    });
    annotationSets.forEach((set, index) => {
      const { items } = set;
      const setOffset = annotationSetOffsets[index];
      dex.writeUInt32LE(items.length, setOffset);
      items.forEach((item, index2) => {
        dex.writeUInt32LE(item.offset, setOffset + 4 + index2 * 4);
      });
    });
    javaCodeItems.forEach((codeItem, index) => {
      const { offset: offset2, superConstructor } = codeItem;
      const registersSize = 1;
      const insSize = 1;
      const outsSize = 1;
      const triesSize = 0;
      const insnsSize = 4;
      dex.writeUInt16LE(registersSize, offset2);
      dex.writeUInt16LE(insSize, offset2 + 2);
      dex.writeUInt16LE(outsSize, offset2 + 4);
      dex.writeUInt16LE(triesSize, offset2 + 6);
      dex.writeUInt32LE(debugInfoOffsets[index], offset2 + 8);
      dex.writeUInt32LE(insnsSize, offset2 + 12);
      dex.writeUInt16LE(4208, offset2 + 16);
      dex.writeUInt16LE(superConstructor, offset2 + 18);
      dex.writeUInt16LE(0, offset2 + 20);
      dex.writeUInt16LE(14, offset2 + 22);
    });
    annotationDirectories.forEach((dir) => {
      const dirOffset = dir.offset;
      const classAnnotationsOffset = 0;
      const fieldsSize = 0;
      const annotatedMethodsSize = dir.methods.length;
      const annotatedParametersSize = 0;
      dex.writeUInt32LE(classAnnotationsOffset, dirOffset);
      dex.writeUInt32LE(fieldsSize, dirOffset + 4);
      dex.writeUInt32LE(annotatedMethodsSize, dirOffset + 8);
      dex.writeUInt32LE(annotatedParametersSize, dirOffset + 12);
      dir.methods.forEach((method2, index) => {
        const entryOffset = dirOffset + 16 + index * 8;
        const [methodIndex, annotationSet] = method2;
        dex.writeUInt32LE(methodIndex, entryOffset);
        dex.writeUInt32LE(annotationSet.offset, entryOffset + 4);
      });
    });
    interfaces.forEach((iface, index) => {
      const ifaceOffset = interfaceOffsets[index];
      dex.writeUInt32LE(iface.types.length, ifaceOffset);
      iface.types.forEach((type, typeIndex) => {
        dex.writeUInt16LE(type, ifaceOffset + 4 + typeIndex * 2);
      });
    });
    parameters.forEach((param, index) => {
      const paramOffset = parameterOffsets[index];
      dex.writeUInt32LE(param.types.length, paramOffset);
      param.types.forEach((type, typeIndex) => {
        dex.writeUInt16LE(type, paramOffset + 4 + typeIndex * 2);
      });
    });
    stringChunks.forEach((chunk, index) => {
      chunk.copy(dex, stringOffsets[index]);
    });
    debugInfoOffsets.forEach((debugInfoOffset) => {
      kDefaultConstructorDebugInfo.copy(dex, debugInfoOffset);
    });
    throwsAnnotationBlobs.forEach((annotationBlob, index) => {
      annotationBlob.copy(dex, throwsAnnotations[index].offset);
    });
    classDataBlobs.forEach((classDataBlob, index) => {
      classDataBlob.copy(dex, classes[index].classData.offset);
    });
    dex.writeUInt32LE(mapNumItems, mapOffset);
    const mapItems = [
      [TYPE_HEADER_ITEM, 1, headerOffset],
      [TYPE_STRING_ID_ITEM, strings.length, stringIdsOffset],
      [TYPE_TYPE_ID_ITEM, types2.length, typeIdsOffset],
      [TYPE_PROTO_ID_ITEM, protos.length, protoIdsOffset]
    ];
    if (fields.length > 0) {
      mapItems.push([TYPE_FIELD_ID_ITEM, fields.length, fieldIdsOffset]);
    }
    mapItems.push([TYPE_METHOD_ID_ITEM, methods.length, methodIdsOffset]);
    mapItems.push([TYPE_CLASS_DEF_ITEM, classes.length, classDefsOffset]);
    annotationSets.forEach((set, index) => {
      mapItems.push([TYPE_ANNOTATION_SET_ITEM, set.items.length, annotationSetOffsets[index]]);
    });
    javaCodeItems.forEach((codeItem) => {
      mapItems.push([TYPE_CODE_ITEM, 1, codeItem.offset]);
    });
    annotationDirectories.forEach((dir) => {
      mapItems.push([TYPE_ANNOTATIONS_DIRECTORY_ITEM, 1, dir.offset]);
    });
    if (typeListLength > 0) {
      mapItems.push([TYPE_TYPE_LIST, typeListLength, interfaceOffsets.concat(parameterOffsets)[0]]);
    }
    mapItems.push([TYPE_STRING_DATA_ITEM, strings.length, stringOffsets[0]]);
    debugInfoOffsets.forEach((debugInfoOffset) => {
      mapItems.push([TYPE_DEBUG_INFO_ITEM, 1, debugInfoOffset]);
    });
    throwsAnnotations.forEach((annotation) => {
      mapItems.push([TYPE_ANNOTATION_ITEM, 1, annotation.offset]);
    });
    classes.forEach((klass) => {
      mapItems.push([TYPE_CLASS_DATA_ITEM, 1, klass.classData.offset]);
    });
    mapItems.push([TYPE_MAP_LIST, 1, mapOffset]);
    mapItems.forEach((item, index) => {
      const [type, size, offset2] = item;
      const itemOffset = mapOffset + 4 + index * kMapItemSize;
      dex.writeUInt16LE(type, itemOffset);
      dex.writeUInt32LE(size, itemOffset + 4);
      dex.writeUInt32LE(offset2, itemOffset + 8);
    });
    const hash = new Checksum("sha1");
    hash.update(dex.slice(signatureOffset + signatureSize));
    Buffer2.from(hash.getDigest()).copy(dex, signatureOffset);
    dex.writeUInt32LE(adler32(dex, signatureOffset), checksumOffset);
    return dex;
  }
};
function makeClassData(klass) {
  const { instanceFields, constructorMethods, virtualMethods } = klass.classData;
  const staticFieldsSize = 0;
  return Buffer2.from([
    staticFieldsSize
  ].concat(createUleb128(instanceFields.length)).concat(createUleb128(constructorMethods.length)).concat(createUleb128(virtualMethods.length)).concat(instanceFields.reduce((result, [indexDiff, accessFlags]) => {
    return result.concat(createUleb128(indexDiff)).concat(createUleb128(accessFlags));
  }, [])).concat(constructorMethods.reduce((result, [indexDiff, accessFlags, , codeOffset]) => {
    return result.concat(createUleb128(indexDiff)).concat(createUleb128(accessFlags)).concat(createUleb128(codeOffset || 0));
  }, [])).concat(virtualMethods.reduce((result, [indexDiff, accessFlags]) => {
    const codeOffset = 0;
    return result.concat(createUleb128(indexDiff)).concat(createUleb128(accessFlags)).concat([codeOffset]);
  }, [])));
}
function makeThrowsAnnotation(annotation) {
  const { thrownTypes } = annotation;
  return Buffer2.from(
    [
      VISIBILITY_SYSTEM
    ].concat(createUleb128(annotation.type)).concat([1]).concat(createUleb128(annotation.value)).concat([VALUE_ARRAY, thrownTypes.length]).concat(thrownTypes.reduce((result, type) => {
      result.push(VALUE_TYPE, type);
      return result;
    }, []))
  );
}
function computeModel(classes) {
  const strings = /* @__PURE__ */ new Set();
  const types2 = /* @__PURE__ */ new Set();
  const protos = {};
  const fields = [];
  const methods = [];
  const throwsAnnotations = {};
  const javaConstructors = /* @__PURE__ */ new Set();
  const superConstructors = /* @__PURE__ */ new Set();
  classes.forEach((klass) => {
    const { name, superClass, sourceFileName } = klass;
    strings.add("this");
    strings.add(name);
    types2.add(name);
    strings.add(superClass);
    types2.add(superClass);
    strings.add(sourceFileName);
    klass.interfaces.forEach((iface) => {
      strings.add(iface);
      types2.add(iface);
    });
    klass.fields.forEach((field) => {
      const [fieldName, fieldType] = field;
      strings.add(fieldName);
      strings.add(fieldType);
      types2.add(fieldType);
      fields.push([klass.name, fieldType, fieldName]);
    });
    if (!klass.methods.some(([methodName]) => methodName === "<init>")) {
      klass.methods.unshift(["<init>", "V", []]);
      javaConstructors.add(name);
    }
    klass.methods.forEach((method2) => {
      const [methodName, retType2, argTypes2, thrownTypes = [], accessFlags] = method2;
      strings.add(methodName);
      const protoId = addProto(retType2, argTypes2);
      let throwsAnnotationId = null;
      if (thrownTypes.length > 0) {
        const typesNormalized = thrownTypes.slice();
        typesNormalized.sort();
        throwsAnnotationId = typesNormalized.join("|");
        let throwsAnnotation = throwsAnnotations[throwsAnnotationId];
        if (throwsAnnotation === void 0) {
          throwsAnnotation = {
            id: throwsAnnotationId,
            types: typesNormalized
          };
          throwsAnnotations[throwsAnnotationId] = throwsAnnotation;
        }
        strings.add(kDalvikAnnotationTypeThrows);
        types2.add(kDalvikAnnotationTypeThrows);
        thrownTypes.forEach((type) => {
          strings.add(type);
          types2.add(type);
        });
        strings.add("value");
      }
      methods.push([klass.name, protoId, methodName, throwsAnnotationId, accessFlags]);
      if (methodName === "<init>") {
        superConstructors.add(name + "|" + protoId);
        const superConstructorId = superClass + "|" + protoId;
        if (javaConstructors.has(name) && !superConstructors.has(superConstructorId)) {
          methods.push([superClass, protoId, methodName, null, 0]);
          superConstructors.add(superConstructorId);
        }
      }
    });
  });
  function addProto(retType2, argTypes2) {
    const signature2 = [retType2].concat(argTypes2);
    const id = signature2.join("|");
    if (protos[id] !== void 0) {
      return id;
    }
    strings.add(retType2);
    types2.add(retType2);
    argTypes2.forEach((argType) => {
      strings.add(argType);
      types2.add(argType);
    });
    const shorty = signature2.map(typeToShorty).join("");
    strings.add(shorty);
    protos[id] = [id, shorty, retType2, argTypes2];
    return id;
  }
  const stringItems = Array.from(strings);
  stringItems.sort();
  const stringToIndex = stringItems.reduce((result, string, index) => {
    result[string] = index;
    return result;
  }, {});
  const typeItems = Array.from(types2).map((name) => stringToIndex[name]);
  typeItems.sort(compareNumbers);
  const typeToIndex = typeItems.reduce((result, stringIndex, typeIndex) => {
    result[stringItems[stringIndex]] = typeIndex;
    return result;
  }, {});
  const literalProtoItems = Object.keys(protos).map((id) => protos[id]);
  literalProtoItems.sort(compareProtoItems);
  const parameters = {};
  const protoItems = literalProtoItems.map((item) => {
    const [, shorty, retType2, argTypes2] = item;
    let params;
    if (argTypes2.length > 0) {
      const argTypesSig = argTypes2.join("|");
      params = parameters[argTypesSig];
      if (params === void 0) {
        params = {
          types: argTypes2.map((type) => typeToIndex[type]),
          offset: -1
        };
        parameters[argTypesSig] = params;
      }
    } else {
      params = null;
    }
    return [
      stringToIndex[shorty],
      typeToIndex[retType2],
      params
    ];
  });
  const protoToIndex = literalProtoItems.reduce((result, item, index) => {
    const [id] = item;
    result[id] = index;
    return result;
  }, {});
  const parameterItems = Object.keys(parameters).map((id) => parameters[id]);
  const fieldItems = fields.map((field) => {
    const [klass, fieldType, fieldName] = field;
    return [
      typeToIndex[klass],
      typeToIndex[fieldType],
      stringToIndex[fieldName]
    ];
  });
  fieldItems.sort(compareFieldItems);
  const methodItems = methods.map((method2) => {
    const [klass, protoId, name, annotationsId, accessFlags] = method2;
    return [
      typeToIndex[klass],
      protoToIndex[protoId],
      stringToIndex[name],
      annotationsId,
      accessFlags
    ];
  });
  methodItems.sort(compareMethodItems);
  const throwsAnnotationItems = Object.keys(throwsAnnotations).map((id) => throwsAnnotations[id]).map((item) => {
    return {
      id: item.id,
      type: typeToIndex[kDalvikAnnotationTypeThrows],
      value: stringToIndex.value,
      thrownTypes: item.types.map((type) => typeToIndex[type]),
      offset: -1
    };
  });
  const annotationSetItems = throwsAnnotationItems.map((item) => {
    return {
      id: item.id,
      items: [item],
      offset: -1
    };
  });
  const annotationSetIdToIndex = annotationSetItems.reduce((result, item, index) => {
    result[item.id] = index;
    return result;
  }, {});
  const interfaceLists = {};
  const annotationDirectories = [];
  const classItems = classes.map((klass) => {
    const classIndex = typeToIndex[klass.name];
    const accessFlags = kAccPublic2;
    const superClassIndex = typeToIndex[klass.superClass];
    let ifaceList;
    const ifaces = klass.interfaces.map((type) => typeToIndex[type]);
    if (ifaces.length > 0) {
      ifaces.sort(compareNumbers);
      const ifacesId = ifaces.join("|");
      ifaceList = interfaceLists[ifacesId];
      if (ifaceList === void 0) {
        ifaceList = {
          types: ifaces,
          offset: -1
        };
        interfaceLists[ifacesId] = ifaceList;
      }
    } else {
      ifaceList = null;
    }
    const sourceFileIndex = stringToIndex[klass.sourceFileName];
    const classMethods = methodItems.reduce((result, method2, index) => {
      const [holder, protoIndex, name, annotationsId, accessFlags2] = method2;
      if (holder === classIndex) {
        result.push([index, name, annotationsId, protoIndex, accessFlags2]);
      }
      return result;
    }, []);
    let annotationsDirectory = null;
    const methodAnnotations = classMethods.filter(([, , annotationsId]) => {
      return annotationsId !== null;
    }).map(([index, , annotationsId]) => {
      return [index, annotationSetItems[annotationSetIdToIndex[annotationsId]]];
    });
    if (methodAnnotations.length > 0) {
      annotationsDirectory = {
        methods: methodAnnotations,
        offset: -1
      };
      annotationDirectories.push(annotationsDirectory);
    }
    const instanceFields = fieldItems.reduce((result, field, index) => {
      const [holder] = field;
      if (holder === classIndex) {
        result.push([index > 0 ? 1 : 0, kAccPublic2]);
      }
      return result;
    }, []);
    const constructorNameIndex = stringToIndex["<init>"];
    const constructorMethods = classMethods.filter(([, name]) => name === constructorNameIndex).map(([index, , , protoIndex]) => {
      if (javaConstructors.has(klass.name)) {
        let superConstructor = -1;
        const numMethodItems = methodItems.length;
        for (let i = 0; i !== numMethodItems; i++) {
          const [methodClass, methodProto, methodName] = methodItems[i];
          if (methodClass === superClassIndex && methodName === constructorNameIndex && methodProto === protoIndex) {
            superConstructor = i;
            break;
          }
        }
        return [index, kAccPublic2 | kAccConstructor, superConstructor];
      } else {
        return [index, kAccPublic2 | kAccConstructor | kAccNative2, -1];
      }
    });
    const virtualMethods = compressClassMethodIndexes(classMethods.filter(([, name]) => name !== constructorNameIndex).map(([index, , , , accessFlags2]) => {
      return [index, accessFlags2 | kAccPublic2 | kAccNative2];
    }));
    const classData = {
      instanceFields,
      constructorMethods,
      virtualMethods,
      offset: -1
    };
    return {
      index: classIndex,
      accessFlags,
      superClassIndex,
      interfaces: ifaceList,
      sourceFileIndex,
      annotationsDirectory,
      classData
    };
  });
  const interfaceItems = Object.keys(interfaceLists).map((id) => interfaceLists[id]);
  return {
    classes: classItems,
    interfaces: interfaceItems,
    fields: fieldItems,
    methods: methodItems,
    protos: protoItems,
    parameters: parameterItems,
    annotationDirectories,
    annotationSets: annotationSetItems,
    throwsAnnotations: throwsAnnotationItems,
    types: typeItems,
    strings: stringItems
  };
}
function compressClassMethodIndexes(items) {
  let previousIndex = 0;
  return items.map(([index, accessFlags], elementIndex) => {
    let result;
    if (elementIndex === 0) {
      result = [index, accessFlags];
    } else {
      result = [index - previousIndex, accessFlags];
    }
    previousIndex = index;
    return result;
  });
}
function compareNumbers(a, b) {
  return a - b;
}
function compareProtoItems(a, b) {
  const [, , aRetType, aArgTypes] = a;
  const [, , bRetType, bArgTypes] = b;
  if (aRetType < bRetType) {
    return -1;
  }
  if (aRetType > bRetType) {
    return 1;
  }
  const aArgTypesSig = aArgTypes.join("|");
  const bArgTypesSig = bArgTypes.join("|");
  if (aArgTypesSig < bArgTypesSig) {
    return -1;
  }
  if (aArgTypesSig > bArgTypesSig) {
    return 1;
  }
  return 0;
}
function compareFieldItems(a, b) {
  const [aClass, aType, aName] = a;
  const [bClass, bType, bName] = b;
  if (aClass !== bClass) {
    return aClass - bClass;
  }
  if (aName !== bName) {
    return aName - bName;
  }
  return aType - bType;
}
function compareMethodItems(a, b) {
  const [aClass, aProto, aName] = a;
  const [bClass, bProto, bName] = b;
  if (aClass !== bClass) {
    return aClass - bClass;
  }
  if (aName !== bName) {
    return aName - bName;
  }
  return aProto - bProto;
}
function typeToShorty(type) {
  const firstCharacter = type[0];
  return firstCharacter === "L" || firstCharacter === "[" ? "L" : type;
}
function createUleb128(value) {
  if (value <= 127) {
    return [value];
  }
  const result = [];
  let moreSlicesNeeded = false;
  do {
    let slice2 = value & 127;
    value >>= 7;
    moreSlicesNeeded = value !== 0;
    if (moreSlicesNeeded) {
      slice2 |= 128;
    }
    result.push(slice2);
  } while (moreSlicesNeeded);
  return result;
}
function align2(value, alignment) {
  const alignmentDelta = value % alignment;
  if (alignmentDelta === 0) {
    return value;
  }
  return value + alignment - alignmentDelta;
}
function adler32(buffer, offset) {
  let a = 1;
  let b = 0;
  const length = buffer.length;
  for (let i = offset; i < length; i++) {
    a = (a + buffer[i]) % 65521;
    b = (b + a) % 65521;
  }
  return (b << 16 | a) >>> 0;
}
var mkdex_default = mkdex;

// node_modules/frida-java-bridge/lib/types.js
var JNILocalRefType = 1;
var vm = null;
var primitiveArrayHandler = null;
function initialize(_vm) {
  vm = _vm;
}
function getType(typeName, unbox, factory) {
  let type = getPrimitiveType(typeName);
  if (type === null) {
    if (typeName.indexOf("[") === 0) {
      type = getArrayType(typeName, unbox, factory);
    } else {
      if (typeName[0] === "L" && typeName[typeName.length - 1] === ";") {
        typeName = typeName.substring(1, typeName.length - 1);
      }
      type = getObjectType(typeName, unbox, factory);
    }
  }
  return Object.assign({ className: typeName }, type);
}
var primitiveTypes = {
  boolean: {
    name: "Z",
    type: "uint8",
    size: 1,
    byteSize: 1,
    defaultValue: false,
    isCompatible(v) {
      return typeof v === "boolean";
    },
    fromJni(v) {
      return !!v;
    },
    toJni(v) {
      return v ? 1 : 0;
    },
    read(address) {
      return address.readU8();
    },
    write(address, value) {
      address.writeU8(value);
    },
    toString() {
      return this.name;
    }
  },
  byte: {
    name: "B",
    type: "int8",
    size: 1,
    byteSize: 1,
    defaultValue: 0,
    isCompatible(v) {
      return Number.isInteger(v) && v >= -128 && v <= 127;
    },
    fromJni: identity,
    toJni: identity,
    read(address) {
      return address.readS8();
    },
    write(address, value) {
      address.writeS8(value);
    },
    toString() {
      return this.name;
    }
  },
  char: {
    name: "C",
    type: "uint16",
    size: 1,
    byteSize: 2,
    defaultValue: 0,
    isCompatible(v) {
      if (typeof v !== "string" || v.length !== 1) {
        return false;
      }
      const code4 = v.charCodeAt(0);
      return code4 >= 0 && code4 <= 65535;
    },
    fromJni(c) {
      return String.fromCharCode(c);
    },
    toJni(s) {
      return s.charCodeAt(0);
    },
    read(address) {
      return address.readU16();
    },
    write(address, value) {
      address.writeU16(value);
    },
    toString() {
      return this.name;
    }
  },
  short: {
    name: "S",
    type: "int16",
    size: 1,
    byteSize: 2,
    defaultValue: 0,
    isCompatible(v) {
      return Number.isInteger(v) && v >= -32768 && v <= 32767;
    },
    fromJni: identity,
    toJni: identity,
    read(address) {
      return address.readS16();
    },
    write(address, value) {
      address.writeS16(value);
    },
    toString() {
      return this.name;
    }
  },
  int: {
    name: "I",
    type: "int32",
    size: 1,
    byteSize: 4,
    defaultValue: 0,
    isCompatible(v) {
      return Number.isInteger(v) && v >= -2147483648 && v <= 2147483647;
    },
    fromJni: identity,
    toJni: identity,
    read(address) {
      return address.readS32();
    },
    write(address, value) {
      address.writeS32(value);
    },
    toString() {
      return this.name;
    }
  },
  long: {
    name: "J",
    type: "int64",
    size: 2,
    byteSize: 8,
    defaultValue: 0,
    isCompatible(v) {
      return typeof v === "number" || v instanceof Int64;
    },
    fromJni: identity,
    toJni: identity,
    read(address) {
      return address.readS64();
    },
    write(address, value) {
      address.writeS64(value);
    },
    toString() {
      return this.name;
    }
  },
  float: {
    name: "F",
    type: "float",
    size: 1,
    byteSize: 4,
    defaultValue: 0,
    isCompatible(v) {
      return typeof v === "number";
    },
    fromJni: identity,
    toJni: identity,
    read(address) {
      return address.readFloat();
    },
    write(address, value) {
      address.writeFloat(value);
    },
    toString() {
      return this.name;
    }
  },
  double: {
    name: "D",
    type: "double",
    size: 2,
    byteSize: 8,
    defaultValue: 0,
    isCompatible(v) {
      return typeof v === "number";
    },
    fromJni: identity,
    toJni: identity,
    read(address) {
      return address.readDouble();
    },
    write(address, value) {
      address.writeDouble(value);
    },
    toString() {
      return this.name;
    }
  },
  void: {
    name: "V",
    type: "void",
    size: 0,
    byteSize: 0,
    defaultValue: void 0,
    isCompatible(v) {
      return v === void 0;
    },
    fromJni() {
      return void 0;
    },
    toJni() {
      return NULL;
    },
    toString() {
      return this.name;
    }
  }
};
var primitiveTypesNames = new Set(Object.values(primitiveTypes).map((t) => t.name));
function getPrimitiveType(name) {
  const result = primitiveTypes[name];
  return result !== void 0 ? result : null;
}
function getObjectType(typeName, unbox, factory) {
  const cache = factory._types[unbox ? 1 : 0];
  let type = cache[typeName];
  if (type !== void 0) {
    return type;
  }
  if (typeName === "java.lang.Object") {
    type = getJavaLangObjectType(factory);
  } else {
    type = getAnyObjectType(typeName, unbox, factory);
  }
  cache[typeName] = type;
  return type;
}
function getJavaLangObjectType(factory) {
  return {
    name: "Ljava/lang/Object;",
    type: "pointer",
    size: 1,
    defaultValue: NULL,
    isCompatible(v) {
      if (v === null) {
        return true;
      }
      if (v === void 0) {
        return false;
      }
      const isWrapper = v.$h instanceof NativePointer;
      if (isWrapper) {
        return true;
      }
      return typeof v === "string";
    },
    fromJni(h, env, owned) {
      if (h.isNull()) {
        return null;
      }
      return factory.cast(h, factory.use("java.lang.Object"), owned);
    },
    toJni(o, env) {
      if (o === null) {
        return NULL;
      }
      if (typeof o === "string") {
        return env.newStringUtf(o);
      }
      return o.$h;
    }
  };
}
function getAnyObjectType(typeName, unbox, factory) {
  let cachedClass = null;
  let cachedIsInstance = null;
  let cachedIsDefaultString = null;
  function getClass() {
    if (cachedClass === null) {
      cachedClass = factory.use(typeName).class;
    }
    return cachedClass;
  }
  function isInstance(v) {
    const klass = getClass();
    if (cachedIsInstance === null) {
      cachedIsInstance = klass.isInstance.overload("java.lang.Object");
    }
    return cachedIsInstance.call(klass, v);
  }
  function typeIsDefaultString() {
    if (cachedIsDefaultString === null) {
      const x = getClass();
      cachedIsDefaultString = factory.use("java.lang.String").class.isAssignableFrom(x);
    }
    return cachedIsDefaultString;
  }
  return {
    name: makeJniObjectTypeName(typeName),
    type: "pointer",
    size: 1,
    defaultValue: NULL,
    isCompatible(v) {
      if (v === null) {
        return true;
      }
      if (v === void 0) {
        return false;
      }
      const isWrapper = v.$h instanceof NativePointer;
      if (isWrapper) {
        return isInstance(v);
      }
      return typeof v === "string" && typeIsDefaultString();
    },
    fromJni(h, env, owned) {
      if (h.isNull()) {
        return null;
      }
      if (typeIsDefaultString() && unbox) {
        return env.stringFromJni(h);
      }
      return factory.cast(h, factory.use(typeName), owned);
    },
    toJni(o, env) {
      if (o === null) {
        return NULL;
      }
      if (typeof o === "string") {
        return env.newStringUtf(o);
      }
      return o.$h;
    },
    toString() {
      return this.name;
    }
  };
}
var primitiveArrayTypes = [
  ["Z", "boolean"],
  ["B", "byte"],
  ["C", "char"],
  ["D", "double"],
  ["F", "float"],
  ["I", "int"],
  ["J", "long"],
  ["S", "short"]
].reduce((result, [shorty, name]) => {
  result["[" + shorty] = makePrimitiveArrayType("[" + shorty, name);
  return result;
}, {});
function makePrimitiveArrayType(shorty, name) {
  const envProto = Env.prototype;
  const nameTitled = toTitleCase(name);
  const spec = {
    typeName: name,
    newArray: envProto["new" + nameTitled + "Array"],
    setRegion: envProto["set" + nameTitled + "ArrayRegion"],
    getElements: envProto["get" + nameTitled + "ArrayElements"],
    releaseElements: envProto["release" + nameTitled + "ArrayElements"]
  };
  return {
    name: shorty,
    type: "pointer",
    size: 1,
    defaultValue: NULL,
    isCompatible(v) {
      return isCompatiblePrimitiveArray(v, name);
    },
    fromJni(h, env, owned) {
      return fromJniPrimitiveArray(h, spec, env, owned);
    },
    toJni(arr, env) {
      return toJniPrimitiveArray(arr, spec, env);
    }
  };
}
function getArrayType(typeName, unbox, factory) {
  const primitiveType = primitiveArrayTypes[typeName];
  if (primitiveType !== void 0) {
    return primitiveType;
  }
  if (typeName.indexOf("[") !== 0) {
    throw new Error("Unsupported type: " + typeName);
  }
  let elementTypeName = typeName.substring(1);
  const elementType = getType(elementTypeName, unbox, factory);
  let numInternalArrays = 0;
  const end = elementTypeName.length;
  while (numInternalArrays !== end && elementTypeName[numInternalArrays] === "[") {
    numInternalArrays++;
  }
  elementTypeName = elementTypeName.substring(numInternalArrays);
  if (elementTypeName[0] === "L" && elementTypeName[elementTypeName.length - 1] === ";") {
    elementTypeName = elementTypeName.substring(1, elementTypeName.length - 1);
  }
  let internalElementTypeName = elementTypeName.replace(/\./g, "/");
  if (primitiveTypesNames.has(internalElementTypeName)) {
    internalElementTypeName = "[".repeat(numInternalArrays) + internalElementTypeName;
  } else {
    internalElementTypeName = "[".repeat(numInternalArrays) + "L" + internalElementTypeName + ";";
  }
  const internalTypeName = "[" + internalElementTypeName;
  elementTypeName = "[".repeat(numInternalArrays) + elementTypeName;
  return {
    name: typeName.replace(/\./g, "/"),
    type: "pointer",
    size: 1,
    defaultValue: NULL,
    isCompatible(v) {
      if (v === null) {
        return true;
      }
      if (typeof v !== "object" || v.length === void 0) {
        return false;
      }
      return v.every(function(element) {
        return elementType.isCompatible(element);
      });
    },
    fromJni(arr, env, owned) {
      if (arr.isNull()) {
        return null;
      }
      const result = [];
      const n = env.getArrayLength(arr);
      for (let i = 0; i !== n; i++) {
        const element = env.getObjectArrayElement(arr, i);
        try {
          result.push(elementType.fromJni(element, env));
        } finally {
          env.deleteLocalRef(element);
        }
      }
      try {
        result.$w = factory.cast(arr, factory.use(internalTypeName), owned);
      } catch (e) {
        factory.use("java.lang.reflect.Array").newInstance(factory.use(elementTypeName).class, 0);
        result.$w = factory.cast(arr, factory.use(internalTypeName), owned);
      }
      result.$dispose = disposeObjectArray;
      return result;
    },
    toJni(elements, env) {
      if (elements === null) {
        return NULL;
      }
      if (!(elements instanceof Array)) {
        throw new Error("Expected an array");
      }
      const wrapper = elements.$w;
      if (wrapper !== void 0) {
        return wrapper.$h;
      }
      const n = elements.length;
      const klassObj = factory.use(elementTypeName);
      const classHandle = klassObj.$borrowClassHandle(env);
      try {
        const result = env.newObjectArray(n, classHandle.value, NULL);
        env.throwIfExceptionPending();
        for (let i = 0; i !== n; i++) {
          const handle2 = elementType.toJni(elements[i], env);
          try {
            env.setObjectArrayElement(result, i, handle2);
          } finally {
            if (elementType.type === "pointer" && env.getObjectRefType(handle2) === JNILocalRefType) {
              env.deleteLocalRef(handle2);
            }
          }
          env.throwIfExceptionPending();
        }
        return result;
      } finally {
        classHandle.unref(env);
      }
    }
  };
}
function disposeObjectArray() {
  const n = this.length;
  for (let i = 0; i !== n; i++) {
    const obj = this[i];
    if (obj === null) {
      continue;
    }
    const dispose2 = obj.$dispose;
    if (dispose2 === void 0) {
      break;
    }
    dispose2.call(obj);
  }
  this.$w.$dispose();
}
function fromJniPrimitiveArray(arr, spec, env, owned) {
  if (arr.isNull()) {
    return null;
  }
  const type = getPrimitiveType(spec.typeName);
  const length = env.getArrayLength(arr);
  return new PrimitiveArray(arr, spec, type, length, env, owned);
}
function toJniPrimitiveArray(arr, spec, env) {
  if (arr === null) {
    return NULL;
  }
  const handle2 = arr.$h;
  if (handle2 !== void 0) {
    return handle2;
  }
  const length = arr.length;
  const type = getPrimitiveType(spec.typeName);
  const result = spec.newArray.call(env, length);
  if (result.isNull()) {
    throw new Error("Unable to construct array");
  }
  if (length > 0) {
    const elementSize = type.byteSize;
    const writeElement = type.write;
    const unparseElementValue = type.toJni;
    const elements = Memory.alloc(length * type.byteSize);
    for (let index = 0; index !== length; index++) {
      writeElement(elements.add(index * elementSize), unparseElementValue(arr[index]));
    }
    spec.setRegion.call(env, result, 0, length, elements);
    env.throwIfExceptionPending();
  }
  return result;
}
function isCompatiblePrimitiveArray(value, typeName) {
  if (value === null) {
    return true;
  }
  if (value instanceof PrimitiveArray) {
    return value.$s.typeName === typeName;
  }
  const isArrayLike = typeof value === "object" && value.length !== void 0;
  if (!isArrayLike) {
    return false;
  }
  const elementType = getPrimitiveType(typeName);
  return Array.prototype.every.call(value, (element) => elementType.isCompatible(element));
}
function PrimitiveArray(handle2, spec, type, length, env, owned = true) {
  if (owned) {
    const h = env.newGlobalRef(handle2);
    this.$h = h;
    this.$r = Script.bindWeak(this, env.vm.makeHandleDestructor(h));
  } else {
    this.$h = handle2;
    this.$r = null;
  }
  this.$s = spec;
  this.$t = type;
  this.length = length;
  return new Proxy(this, primitiveArrayHandler);
}
primitiveArrayHandler = {
  has(target, property) {
    if (property in target) {
      return true;
    }
    return target.tryParseIndex(property) !== null;
  },
  get(target, property, receiver) {
    const index = target.tryParseIndex(property);
    if (index === null) {
      return target[property];
    }
    return target.readElement(index);
  },
  set(target, property, value, receiver) {
    const index = target.tryParseIndex(property);
    if (index === null) {
      target[property] = value;
      return true;
    }
    target.writeElement(index, value);
    return true;
  },
  ownKeys(target) {
    const keys = [];
    const { length } = target;
    for (let i = 0; i !== length; i++) {
      const key = i.toString();
      keys.push(key);
    }
    keys.push("length");
    return keys;
  },
  getOwnPropertyDescriptor(target, property) {
    const index = target.tryParseIndex(property);
    if (index !== null) {
      return {
        writable: true,
        configurable: true,
        enumerable: true
      };
    }
    return Object.getOwnPropertyDescriptor(target, property);
  }
};
Object.defineProperties(PrimitiveArray.prototype, {
  $dispose: {
    enumerable: true,
    value() {
      const ref = this.$r;
      if (ref !== null) {
        this.$r = null;
        Script.unbindWeak(ref);
      }
    }
  },
  $clone: {
    value(env) {
      return new PrimitiveArray(this.$h, this.$s, this.$t, this.length, env);
    }
  },
  tryParseIndex: {
    value(rawIndex) {
      if (typeof rawIndex === "symbol") {
        return null;
      }
      const index = parseInt(rawIndex);
      if (isNaN(index) || index < 0 || index >= this.length) {
        return null;
      }
      return index;
    }
  },
  readElement: {
    value(index) {
      return this.withElements((elements) => {
        const type = this.$t;
        return type.fromJni(type.read(elements.add(index * type.byteSize)));
      });
    }
  },
  writeElement: {
    value(index, value) {
      const { $h: handle2, $s: spec, $t: type } = this;
      const env = vm.getEnv();
      const element = Memory.alloc(type.byteSize);
      type.write(element, type.toJni(value));
      spec.setRegion.call(env, handle2, index, 1, element);
    }
  },
  withElements: {
    value(perform) {
      const { $h: handle2, $s: spec } = this;
      const env = vm.getEnv();
      const elements = spec.getElements.call(env, handle2);
      if (elements.isNull()) {
        throw new Error("Unable to get array elements");
      }
      try {
        return perform(elements);
      } finally {
        spec.releaseElements.call(env, handle2, elements);
      }
    }
  },
  toJSON: {
    value() {
      const { length, $t: type } = this;
      const { byteSize: elementSize, fromJni, read: read2 } = type;
      return this.withElements((elements) => {
        const values = [];
        for (let i = 0; i !== length; i++) {
          const value = fromJni(read2(elements.add(i * elementSize)));
          values.push(value);
        }
        return values;
      });
    }
  },
  toString: {
    value() {
      return this.toJSON().toString();
    }
  }
});
function makeJniObjectTypeName(typeName) {
  return "L" + typeName.replace(/\./g, "/") + ";";
}
function toTitleCase(str) {
  return str.charAt(0).toUpperCase() + str.slice(1);
}
function identity(value) {
  return value;
}

// node_modules/frida-java-bridge/lib/class-factory.js
var jsizeSize3 = 4;
var {
  ensureClassInitialized: ensureClassInitialized3,
  makeMethodMangler: makeMethodMangler3
} = android_exports;
var kAccStatic2 = 8;
var CONSTRUCTOR_METHOD = 1;
var STATIC_METHOD = 2;
var INSTANCE_METHOD = 3;
var STATIC_FIELD = 1;
var INSTANCE_FIELD = 2;
var STRATEGY_VIRTUAL = 1;
var STRATEGY_DIRECT = 2;
var PENDING_USE = Symbol("PENDING_USE");
var DEFAULT_CACHE_DIR = "/data/local/tmp";
var {
  getCurrentThreadId,
  pointerSize: pointerSize9
} = Process;
var factoryCache = {
  state: "empty",
  factories: [],
  loaders: null,
  Integer: null
};
var vm2 = null;
var api2 = null;
var isArtVm = null;
var wrapperHandler = null;
var dispatcherPrototype = null;
var methodPrototype = null;
var valueOfPrototype = null;
var cachedLoaderInvoke = null;
var cachedLoaderMethod = null;
var ignoredThreads = /* @__PURE__ */ new Map();
var ClassFactory = class _ClassFactory {
  static _initialize(_vm, _api) {
    vm2 = _vm;
    api2 = _api;
    isArtVm = _api.flavor === "art";
    if (_api.flavor === "jvm") {
      ensureClassInitialized3 = ensureClassInitialized2;
      makeMethodMangler3 = makeMethodMangler2;
    }
  }
  static _disposeAll(env) {
    factoryCache.factories.forEach((factory) => {
      factory._dispose(env);
    });
  }
  static get(classLoader) {
    const cache = getFactoryCache();
    const defaultFactory = cache.factories[0];
    if (classLoader === null) {
      return defaultFactory;
    }
    const indexObj = cache.loaders.get(classLoader);
    if (indexObj !== null) {
      const index = defaultFactory.cast(indexObj, cache.Integer);
      return cache.factories[index.intValue()];
    }
    const factory = new _ClassFactory();
    factory.loader = classLoader;
    factory.cacheDir = defaultFactory.cacheDir;
    addFactoryToCache(factory, classLoader);
    return factory;
  }
  constructor() {
    this.cacheDir = DEFAULT_CACHE_DIR;
    this.codeCacheDir = DEFAULT_CACHE_DIR + "/dalvik-cache";
    this.tempFileNaming = {
      prefix: "frida",
      suffix: ""
    };
    this._classes = {};
    this._classHandles = new LRU(10, releaseClassHandle);
    this._patchedMethods = /* @__PURE__ */ new Set();
    this._loader = null;
    this._types = [{}, {}];
    factoryCache.factories.push(this);
  }
  _dispose(env) {
    Array.from(this._patchedMethods).forEach((method2) => {
      method2.implementation = null;
    });
    this._patchedMethods.clear();
    revertGlobalPatches();
    this._classHandles.dispose(env);
    this._classes = {};
  }
  get loader() {
    return this._loader;
  }
  set loader(value) {
    const isInitial = this._loader === null && value !== null;
    this._loader = value;
    if (isInitial && factoryCache.state === "ready" && this === factoryCache.factories[0]) {
      addFactoryToCache(this, value);
    }
  }
  use(className, options = {}) {
    const allowCached = options.cache !== "skip";
    let C = allowCached ? this._getUsedClass(className) : void 0;
    if (C === void 0) {
      try {
        const env = vm2.getEnv();
        const { _loader: loader } = this;
        const getClassHandle = loader !== null ? makeLoaderClassHandleGetter(className, loader, env) : makeBasicClassHandleGetter(className);
        C = this._make(className, getClassHandle, env);
      } finally {
        if (allowCached) {
          this._setUsedClass(className, C);
        }
      }
    }
    return C;
  }
  _getUsedClass(className) {
    let c;
    while ((c = this._classes[className]) === PENDING_USE) {
      Thread.sleep(0.05);
    }
    if (c === void 0) {
      this._classes[className] = PENDING_USE;
    }
    return c;
  }
  _setUsedClass(className, c) {
    if (c !== void 0) {
      this._classes[className] = c;
    } else {
      delete this._classes[className];
    }
  }
  _make(name, getClassHandle, env) {
    const C = makeClassWrapperConstructor();
    const proto = Object.create(Wrapper.prototype, {
      [Symbol.for("n")]: {
        value: name
      },
      $n: {
        get() {
          return this[Symbol.for("n")];
        }
      },
      [Symbol.for("C")]: {
        value: C
      },
      $C: {
        get() {
          return this[Symbol.for("C")];
        }
      },
      [Symbol.for("w")]: {
        value: null,
        writable: true
      },
      $w: {
        get() {
          return this[Symbol.for("w")];
        },
        set(val) {
          this[Symbol.for("w")] = val;
        }
      },
      [Symbol.for("_s")]: {
        writable: true
      },
      $_s: {
        get() {
          return this[Symbol.for("_s")];
        },
        set(val) {
          this[Symbol.for("_s")] = val;
        }
      },
      [Symbol.for("c")]: {
        value: [null]
      },
      $c: {
        get() {
          return this[Symbol.for("c")];
        }
      },
      [Symbol.for("m")]: {
        value: /* @__PURE__ */ new Map()
      },
      $m: {
        get() {
          return this[Symbol.for("m")];
        }
      },
      [Symbol.for("l")]: {
        value: null,
        writable: true
      },
      $l: {
        get() {
          return this[Symbol.for("l")];
        },
        set(val) {
          this[Symbol.for("l")] = val;
        }
      },
      [Symbol.for("gch")]: {
        value: getClassHandle
      },
      $gch: {
        get() {
          return this[Symbol.for("gch")];
        }
      },
      [Symbol.for("f")]: {
        value: this
      },
      $f: {
        get() {
          return this[Symbol.for("f")];
        }
      }
    });
    C.prototype = proto;
    const classWrapper = new C(null);
    proto[Symbol.for("w")] = classWrapper;
    proto.$w = classWrapper;
    const h = classWrapper.$borrowClassHandle(env);
    try {
      const classHandle = h.value;
      ensureClassInitialized3(env, classHandle);
      proto.$l = Model.build(classHandle, env);
    } finally {
      h.unref(env);
    }
    return classWrapper;
  }
  retain(obj) {
    const env = vm2.getEnv();
    return obj.$clone(env);
  }
  cast(obj, klass, owned) {
    const env = vm2.getEnv();
    let handle2 = obj.$h;
    if (handle2 === void 0) {
      handle2 = obj;
    }
    const h = klass.$borrowClassHandle(env);
    try {
      const isValidCast = env.isInstanceOf(handle2, h.value);
      if (!isValidCast) {
        throw new Error(`Cast from '${env.getObjectClassName(handle2)}' to '${klass.$n}' isn't possible`);
      }
    } finally {
      h.unref(env);
    }
    const C = klass.$C;
    return new C(handle2, STRATEGY_VIRTUAL, env, owned);
  }
  wrap(handle2, klass, env) {
    const C = klass.$C;
    const wrapper = new C(handle2, STRATEGY_VIRTUAL, env, false);
    wrapper.$r = Script.bindWeak(wrapper, vm2.makeHandleDestructor(handle2));
    return wrapper;
  }
  array(type, elements) {
    const env = vm2.getEnv();
    const primitiveType = getPrimitiveType(type);
    if (primitiveType !== null) {
      type = primitiveType.name;
    }
    const arrayType2 = getArrayType("[" + type, false, this);
    const rawArray = arrayType2.toJni(elements, env);
    return arrayType2.fromJni(rawArray, env, true);
  }
  registerClass(spec) {
    const env = vm2.getEnv();
    const tempHandles = [];
    try {
      const Class = this.use("java.lang.Class");
      const Method = env.javaLangReflectMethod();
      const invokeObjectMethodNoArgs = env.vaMethod("pointer", []);
      const className = spec.name;
      const interfaces = spec.implements || [];
      const superClass = spec.superClass || this.use("java.lang.Object");
      const dexFields = [];
      const dexMethods = [];
      const dexSpec = {
        name: makeJniObjectTypeName(className),
        sourceFileName: makeSourceFileName(className),
        superClass: makeJniObjectTypeName(superClass.$n),
        interfaces: interfaces.map((iface) => makeJniObjectTypeName(iface.$n)),
        fields: dexFields,
        methods: dexMethods
      };
      const allInterfaces = interfaces.slice();
      interfaces.forEach((iface) => {
        Array.prototype.slice.call(iface.class.getInterfaces()).forEach((baseIface) => {
          const baseIfaceName = this.cast(baseIface, Class).getCanonicalName();
          allInterfaces.push(this.use(baseIfaceName));
        });
      });
      const fields = spec.fields || {};
      Object.getOwnPropertyNames(fields).forEach((name) => {
        const fieldType = this._getType(fields[name]);
        dexFields.push([name, fieldType.name]);
      });
      const baseMethods = {};
      const pendingOverloads = {};
      allInterfaces.forEach((iface) => {
        const h = iface.$borrowClassHandle(env);
        tempHandles.push(h);
        const ifaceHandle = h.value;
        iface.$ownMembers.filter((name) => {
          return iface[name].overloads !== void 0;
        }).forEach((name) => {
          const method2 = iface[name];
          const overloads = method2.overloads;
          const overloadIds = overloads.map((overload) => makeOverloadId(name, overload.returnType, overload.argumentTypes));
          baseMethods[name] = [method2, overloadIds, ifaceHandle];
          overloads.forEach((overload, index) => {
            const id = overloadIds[index];
            pendingOverloads[id] = [overload, ifaceHandle];
          });
        });
      });
      const methods = spec.methods || {};
      const methodNames = Object.keys(methods);
      const methodEntries = methodNames.reduce((result, name) => {
        const entry = methods[name];
        const rawName = name === "$init" ? "<init>" : name;
        if (entry instanceof Array) {
          result.push(...entry.map((e) => [rawName, e]));
        } else {
          result.push([rawName, entry]);
        }
        return result;
      }, []);
      const implMethods = [];
      methodEntries.forEach(([name, methodValue]) => {
        let type = INSTANCE_METHOD;
        let returnType;
        let argumentTypes;
        let thrownTypeNames = [];
        let impl;
        if (typeof methodValue === "function") {
          const m2 = baseMethods[name];
          if (m2 !== void 0 && Array.isArray(m2)) {
            const [baseMethod, overloadIds, parentTypeHandle] = m2;
            if (overloadIds.length > 1) {
              throw new Error(`More than one overload matching '${name}': signature must be specified`);
            }
            delete pendingOverloads[overloadIds[0]];
            const overload = baseMethod.overloads[0];
            type = overload.type;
            returnType = overload.returnType;
            argumentTypes = overload.argumentTypes;
            impl = methodValue;
            const reflectedMethod = env.toReflectedMethod(parentTypeHandle, overload.handle, 0);
            const thrownTypes = invokeObjectMethodNoArgs(env.handle, reflectedMethod, Method.getGenericExceptionTypes);
            thrownTypeNames = readTypeNames(env, thrownTypes).map(makeJniObjectTypeName);
            env.deleteLocalRef(thrownTypes);
            env.deleteLocalRef(reflectedMethod);
          } else {
            returnType = this._getType("void");
            argumentTypes = [];
            impl = methodValue;
          }
        } else {
          if (methodValue.isStatic) {
            type = STATIC_METHOD;
          }
          returnType = this._getType(methodValue.returnType || "void");
          argumentTypes = (methodValue.argumentTypes || []).map((name2) => this._getType(name2));
          impl = methodValue.implementation;
          if (typeof impl !== "function") {
            throw new Error("Expected a function implementation for method: " + name);
          }
          const id = makeOverloadId(name, returnType, argumentTypes);
          const pendingOverload = pendingOverloads[id];
          if (pendingOverload !== void 0) {
            const [overload, parentTypeHandle] = pendingOverload;
            delete pendingOverloads[id];
            type = overload.type;
            returnType = overload.returnType;
            argumentTypes = overload.argumentTypes;
            const reflectedMethod = env.toReflectedMethod(parentTypeHandle, overload.handle, 0);
            const thrownTypes = invokeObjectMethodNoArgs(env.handle, reflectedMethod, Method.getGenericExceptionTypes);
            thrownTypeNames = readTypeNames(env, thrownTypes).map(makeJniObjectTypeName);
            env.deleteLocalRef(thrownTypes);
            env.deleteLocalRef(reflectedMethod);
          }
        }
        const returnTypeName = returnType.name;
        const argumentTypeNames = argumentTypes.map((t) => t.name);
        const signature2 = "(" + argumentTypeNames.join("") + ")" + returnTypeName;
        dexMethods.push([name, returnTypeName, argumentTypeNames, thrownTypeNames, type === STATIC_METHOD ? kAccStatic2 : 0]);
        implMethods.push([name, signature2, type, returnType, argumentTypes, impl]);
      });
      const unimplementedMethodIds = Object.keys(pendingOverloads);
      if (unimplementedMethodIds.length > 0) {
        throw new Error("Missing implementation for: " + unimplementedMethodIds.join(", "));
      }
      const dex = DexFile.fromBuffer(mkdex_default(dexSpec), this);
      try {
        dex.load();
      } finally {
        dex.file.delete();
      }
      const classWrapper = this.use(spec.name);
      const numMethods = methodEntries.length;
      if (numMethods > 0) {
        const methodElementSize = 3 * pointerSize9;
        const methodElements = Memory.alloc(numMethods * methodElementSize);
        const nativeMethods = [];
        const temporaryHandles = [];
        implMethods.forEach(([name, signature2, type, returnType, argumentTypes, impl], index) => {
          const rawName = Memory.allocUtf8String(name);
          const rawSignature = Memory.allocUtf8String(signature2);
          const rawImpl = implement(name, classWrapper, type, returnType, argumentTypes, impl);
          methodElements.add(index * methodElementSize).writePointer(rawName);
          methodElements.add(index * methodElementSize + pointerSize9).writePointer(rawSignature);
          methodElements.add(index * methodElementSize + 2 * pointerSize9).writePointer(rawImpl);
          temporaryHandles.push(rawName, rawSignature);
          nativeMethods.push(rawImpl);
        });
        const h = classWrapper.$borrowClassHandle(env);
        tempHandles.push(h);
        const classHandle = h.value;
        env.registerNatives(classHandle, methodElements, numMethods);
        env.throwIfExceptionPending();
        classWrapper.$nativeMethods = nativeMethods;
      }
      return classWrapper;
    } finally {
      tempHandles.forEach((h) => {
        h.unref(env);
      });
    }
  }
  choose(specifier, callbacks) {
    const env = vm2.getEnv();
    const { flavor } = api2;
    if (flavor === "jvm") {
      this._chooseObjectsJvm(specifier, env, callbacks);
    } else if (flavor === "art") {
      const legacyApiMissing = api2["art::gc::Heap::VisitObjects"] === void 0;
      if (legacyApiMissing) {
        const preA12ApiMissing = api2["art::gc::Heap::GetInstances"] === void 0;
        if (preA12ApiMissing) {
          return this._chooseObjectsJvm(specifier, env, callbacks);
        }
      }
      withRunnableArtThread(vm2, env, (thread) => {
        if (legacyApiMissing) {
          this._chooseObjectsArtPreA12(specifier, env, thread, callbacks);
        } else {
          this._chooseObjectsArtLegacy(specifier, env, thread, callbacks);
        }
      });
    } else {
      this._chooseObjectsDalvik(specifier, env, callbacks);
    }
  }
  _chooseObjectsJvm(className, env, callbacks) {
    const classWrapper = this.use(className);
    const { jvmti } = api2;
    const JVMTI_ITERATION_CONTINUE = 1;
    const JVMTI_HEAP_OBJECT_EITHER = 3;
    const h = classWrapper.$borrowClassHandle(env);
    const tag = int64(h.value.toString());
    try {
      const heapObjectCallback = new NativeCallback((classTag, size, tagPtr2, userData) => {
        tagPtr2.writeS64(tag);
        return JVMTI_ITERATION_CONTINUE;
      }, "int", ["int64", "int64", "pointer", "pointer"]);
      jvmti.iterateOverInstancesOfClass(h.value, JVMTI_HEAP_OBJECT_EITHER, heapObjectCallback, h.value);
      const tagPtr = Memory.alloc(8);
      tagPtr.writeS64(tag);
      const countPtr = Memory.alloc(jsizeSize3);
      const objectsPtr = Memory.alloc(pointerSize9);
      jvmti.getObjectsWithTags(1, tagPtr, countPtr, objectsPtr, NULL);
      const count = countPtr.readS32();
      const objects = objectsPtr.readPointer();
      const handles = [];
      for (let i = 0; i !== count; i++) {
        handles.push(objects.add(i * pointerSize9).readPointer());
      }
      jvmti.deallocate(objects);
      try {
        for (const handle2 of handles) {
          const instance = this.cast(handle2, classWrapper);
          const result = callbacks.onMatch(instance);
          if (result === "stop") {
            break;
          }
        }
        callbacks.onComplete();
      } finally {
        handles.forEach((handle2) => {
          env.deleteLocalRef(handle2);
        });
      }
    } finally {
      h.unref(env);
    }
  }
  _chooseObjectsArtPreA12(className, env, thread, callbacks) {
    const classWrapper = this.use(className);
    const scope = VariableSizedHandleScope.$new(thread, vm2);
    let needle;
    const h = classWrapper.$borrowClassHandle(env);
    try {
      const object = api2["art::JavaVMExt::DecodeGlobal"](api2.vm, thread, h.value);
      needle = scope.newHandle(object);
    } finally {
      h.unref(env);
    }
    const maxCount = 0;
    const instances = HandleVector.$new();
    api2["art::gc::Heap::GetInstances"](api2.artHeap, scope, needle, maxCount, instances);
    const instanceHandles = instances.handles.map((handle2) => env.newGlobalRef(handle2));
    instances.$delete();
    scope.$delete();
    try {
      for (const handle2 of instanceHandles) {
        const instance = this.cast(handle2, classWrapper);
        const result = callbacks.onMatch(instance);
        if (result === "stop") {
          break;
        }
      }
      callbacks.onComplete();
    } finally {
      instanceHandles.forEach((handle2) => {
        env.deleteGlobalRef(handle2);
      });
    }
  }
  _chooseObjectsArtLegacy(className, env, thread, callbacks) {
    const classWrapper = this.use(className);
    const instanceHandles = [];
    const addGlobalReference = api2["art::JavaVMExt::AddGlobalRef"];
    const vmHandle = api2.vm;
    let needle;
    const h = classWrapper.$borrowClassHandle(env);
    try {
      needle = api2["art::JavaVMExt::DecodeGlobal"](vmHandle, thread, h.value).toInt32();
    } finally {
      h.unref(env);
    }
    const collectMatchingInstanceHandles = makeObjectVisitorPredicate(needle, (object) => {
      instanceHandles.push(addGlobalReference(vmHandle, thread, object));
    });
    api2["art::gc::Heap::VisitObjects"](api2.artHeap, collectMatchingInstanceHandles, NULL);
    try {
      for (const handle2 of instanceHandles) {
        const instance = this.cast(handle2, classWrapper);
        const result = callbacks.onMatch(instance);
        if (result === "stop") {
          break;
        }
      }
    } finally {
      instanceHandles.forEach((handle2) => {
        env.deleteGlobalRef(handle2);
      });
    }
    callbacks.onComplete();
  }
  _chooseObjectsDalvik(className, callerEnv, callbacks) {
    const classWrapper = this.use(className);
    if (api2.addLocalReference === null) {
      const libdvm = Process.getModuleByName("libdvm.so");
      let pattern;
      switch (Process.arch) {
        case "arm":
          pattern = "2d e9 f0 41 05 46 15 4e 0c 46 7e 44 11 b3 43 68";
          break;
        case "ia32":
          pattern = "8d 64 24 d4 89 5c 24 1c 89 74 24 20 e8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 85 d2";
          break;
      }
      Memory.scan(libdvm.base, libdvm.size, pattern, {
        onMatch: (address, size) => {
          let wrapper;
          if (Process.arch === "arm") {
            address = address.or(1);
            wrapper = new NativeFunction(address, "pointer", ["pointer", "pointer"]);
          } else {
            const thunk = Memory.alloc(Process.pageSize);
            Memory.patchCode(thunk, 16, (code4) => {
              const cw = new X86Writer(code4, { pc: thunk });
              cw.putMovRegRegOffsetPtr("eax", "esp", 4);
              cw.putMovRegRegOffsetPtr("edx", "esp", 8);
              cw.putJmpAddress(address);
              cw.flush();
            });
            wrapper = new NativeFunction(thunk, "pointer", ["pointer", "pointer"]);
            wrapper._thunk = thunk;
          }
          api2.addLocalReference = wrapper;
          vm2.perform((env) => {
            enumerateInstances(this, env);
          });
          return "stop";
        },
        onError(reason) {
        },
        onComplete() {
          if (api2.addLocalReference === null) {
            callbacks.onComplete();
          }
        }
      });
    } else {
      enumerateInstances(this, callerEnv);
    }
    function enumerateInstances(factory, env) {
      const { DVM_JNI_ENV_OFFSET_SELF: DVM_JNI_ENV_OFFSET_SELF2 } = android_exports;
      const thread = env.handle.add(DVM_JNI_ENV_OFFSET_SELF2).readPointer();
      let ptrClassObject;
      const h = classWrapper.$borrowClassHandle(env);
      try {
        ptrClassObject = api2.dvmDecodeIndirectRef(thread, h.value);
      } finally {
        h.unref(env);
      }
      const pattern = ptrClassObject.toMatchPattern();
      const heapSourceBase = api2.dvmHeapSourceGetBase();
      const heapSourceLimit = api2.dvmHeapSourceGetLimit();
      const size = heapSourceLimit.sub(heapSourceBase).toInt32();
      Memory.scan(heapSourceBase, size, pattern, {
        onMatch: (address, size2) => {
          if (api2.dvmIsValidObject(address)) {
            vm2.perform((env2) => {
              const thread2 = env2.handle.add(DVM_JNI_ENV_OFFSET_SELF2).readPointer();
              let instance;
              const localReference = api2.addLocalReference(thread2, address);
              try {
                instance = factory.cast(localReference, classWrapper);
              } finally {
                env2.deleteLocalRef(localReference);
              }
              const result = callbacks.onMatch(instance);
              if (result === "stop") {
                return "stop";
              }
            });
          }
        },
        onError(reason) {
        },
        onComplete() {
          callbacks.onComplete();
        }
      });
    }
  }
  openClassFile(filePath) {
    return new DexFile(filePath, null, this);
  }
  _getType(typeName, unbox = true) {
    return getType(typeName, unbox, this);
  }
};
function makeClassWrapperConstructor() {
  return function(handle2, strategy, env, owned) {
    return Wrapper.call(this, handle2, strategy, env, owned);
  };
}
function Wrapper(handle2, strategy, env, owned = true) {
  if (handle2 !== null) {
    if (owned) {
      const h = env.newGlobalRef(handle2);
      this.$h = h;
      this.$r = Script.bindWeak(this, vm2.makeHandleDestructor(h));
    } else {
      this.$h = handle2;
      this.$r = null;
    }
  } else {
    this.$h = null;
    this.$r = null;
  }
  this.$t = strategy;
  return new Proxy(this, wrapperHandler);
}
wrapperHandler = {
  has(target, property) {
    if (property in target) {
      return true;
    }
    return target.$has(property);
  },
  get(target, property, receiver) {
    if (typeof property !== "string" || property.startsWith("$") || property === "class") {
      return target[property];
    }
    const unwrap2 = target.$find(property);
    if (unwrap2 !== null) {
      return unwrap2(receiver);
    }
    return target[property];
  },
  set(target, property, value, receiver) {
    target[property] = value;
    return true;
  },
  ownKeys(target) {
    return target.$list();
  },
  getOwnPropertyDescriptor(target, property) {
    if (Object.prototype.hasOwnProperty.call(target, property)) {
      return Object.getOwnPropertyDescriptor(target, property);
    }
    return {
      writable: false,
      configurable: true,
      enumerable: true
    };
  }
};
Object.defineProperties(Wrapper.prototype, {
  [Symbol.for("new")]: {
    enumerable: false,
    get() {
      return this.$getCtor("allocAndInit");
    }
  },
  $new: {
    enumerable: true,
    get() {
      return this[Symbol.for("new")];
    }
  },
  [Symbol.for("alloc")]: {
    enumerable: false,
    value() {
      const env = vm2.getEnv();
      const h = this.$borrowClassHandle(env);
      try {
        const obj = env.allocObject(h.value);
        const factory = this.$f;
        return factory.cast(obj, this);
      } finally {
        h.unref(env);
      }
    }
  },
  $alloc: {
    enumerable: true,
    get() {
      return this[Symbol.for("alloc")];
    }
  },
  [Symbol.for("init")]: {
    enumerable: false,
    get() {
      return this.$getCtor("initOnly");
    }
  },
  $init: {
    enumerable: true,
    get() {
      return this[Symbol.for("init")];
    }
  },
  [Symbol.for("dispose")]: {
    enumerable: false,
    value() {
      const ref = this.$r;
      if (ref !== null) {
        this.$r = null;
        Script.unbindWeak(ref);
      }
      if (this.$h !== null) {
        this.$h = void 0;
      }
    }
  },
  $dispose: {
    enumerable: true,
    get() {
      return this[Symbol.for("dispose")];
    }
  },
  [Symbol.for("clone")]: {
    enumerable: false,
    value(env) {
      const C = this.$C;
      return new C(this.$h, this.$t, env);
    }
  },
  $clone: {
    value(env) {
      return this[Symbol.for("clone")](env);
    }
  },
  [Symbol.for("class")]: {
    enumerable: false,
    get() {
      const env = vm2.getEnv();
      const h = this.$borrowClassHandle(env);
      try {
        const factory = this.$f;
        return factory.cast(h.value, factory.use("java.lang.Class"));
      } finally {
        h.unref(env);
      }
    }
  },
  class: {
    enumerable: true,
    get() {
      return this[Symbol.for("class")];
    }
  },
  [Symbol.for("className")]: {
    enumerable: false,
    get() {
      const handle2 = this.$h;
      if (handle2 === null) {
        return this.$n;
      }
      return vm2.getEnv().getObjectClassName(handle2);
    }
  },
  $className: {
    enumerable: true,
    get() {
      return this[Symbol.for("className")];
    }
  },
  [Symbol.for("ownMembers")]: {
    enumerable: false,
    get() {
      const model = this.$l;
      return model.list();
    }
  },
  $ownMembers: {
    enumerable: true,
    get() {
      return this[Symbol.for("ownMembers")];
    }
  },
  [Symbol.for("super")]: {
    enumerable: false,
    get() {
      const env = vm2.getEnv();
      const C = this.$s.$C;
      return new C(this.$h, STRATEGY_DIRECT, env);
    }
  },
  $super: {
    enumerable: true,
    get() {
      return this[Symbol.for("super")];
    }
  },
  [Symbol.for("s")]: {
    enumerable: false,
    get() {
      const proto = Object.getPrototypeOf(this);
      let superWrapper = proto.$_s;
      if (superWrapper === void 0) {
        const env = vm2.getEnv();
        const h = this.$borrowClassHandle(env);
        try {
          const superHandle = env.getSuperclass(h.value);
          if (!superHandle.isNull()) {
            try {
              const superClassName = env.getClassName(superHandle);
              const factory = proto.$f;
              superWrapper = factory._getUsedClass(superClassName);
              if (superWrapper === void 0) {
                try {
                  const getSuperClassHandle = makeSuperHandleGetter(this);
                  superWrapper = factory._make(superClassName, getSuperClassHandle, env);
                } finally {
                  factory._setUsedClass(superClassName, superWrapper);
                }
              }
            } finally {
              env.deleteLocalRef(superHandle);
            }
          } else {
            superWrapper = null;
          }
        } finally {
          h.unref(env);
        }
        proto.$_s = superWrapper;
      }
      return superWrapper;
    }
  },
  $s: {
    get() {
      return this[Symbol.for("s")];
    }
  },
  [Symbol.for("isSameObject")]: {
    enumerable: false,
    value(obj) {
      const env = vm2.getEnv();
      return env.isSameObject(obj.$h, this.$h);
    }
  },
  $isSameObject: {
    value(obj) {
      return this[Symbol.for("isSameObject")](obj);
    }
  },
  [Symbol.for("getCtor")]: {
    enumerable: false,
    value(type) {
      const slot = this.$c;
      let ctor = slot[0];
      if (ctor === null) {
        const env = vm2.getEnv();
        const h = this.$borrowClassHandle(env);
        try {
          ctor = makeConstructor(h.value, this.$w, env);
          slot[0] = ctor;
        } finally {
          h.unref(env);
        }
      }
      return ctor[type];
    }
  },
  $getCtor: {
    value(type) {
      return this[Symbol.for("getCtor")](type);
    }
  },
  [Symbol.for("borrowClassHandle")]: {
    enumerable: false,
    value(env) {
      const className = this.$n;
      const classHandles = this.$f._classHandles;
      let handle2 = classHandles.get(className);
      if (handle2 === void 0) {
        handle2 = new ClassHandle(this.$gch(env), env);
        classHandles.set(className, handle2, env);
      }
      return handle2.ref();
    }
  },
  $borrowClassHandle: {
    value(env) {
      return this[Symbol.for("borrowClassHandle")](env);
    }
  },
  [Symbol.for("copyClassHandle")]: {
    enumerable: false,
    value(env) {
      const h = this.$borrowClassHandle(env);
      try {
        return env.newLocalRef(h.value);
      } finally {
        h.unref(env);
      }
    }
  },
  $copyClassHandle: {
    value(env) {
      return this[Symbol.for("copyClassHandle")](env);
    }
  },
  [Symbol.for("getHandle")]: {
    enumerable: false,
    value(env) {
      const handle2 = this.$h;
      const isDisposed = handle2 === void 0;
      if (isDisposed) {
        throw new Error("Wrapper is disposed; perhaps it was borrowed from a hook instead of calling Java.retain() to make a long-lived wrapper?");
      }
      return handle2;
    }
  },
  $getHandle: {
    value(env) {
      return this[Symbol.for("getHandle")](env);
    }
  },
  [Symbol.for("list")]: {
    enumerable: false,
    value() {
      const superWrapper = this.$s;
      const superMembers = superWrapper !== null ? superWrapper.$list() : [];
      const model = this.$l;
      return Array.from(new Set(superMembers.concat(model.list())));
    }
  },
  $list: {
    get() {
      return this[Symbol.for("list")];
    }
  },
  [Symbol.for("has")]: {
    enumerable: false,
    value(member) {
      const members = this.$m;
      if (members.has(member)) {
        return true;
      }
      const model = this.$l;
      if (model.has(member)) {
        return true;
      }
      const superWrapper = this.$s;
      if (superWrapper !== null && superWrapper.$has(member)) {
        return true;
      }
      return false;
    }
  },
  $has: {
    value(member) {
      return this[Symbol.for("has")](member);
    }
  },
  [Symbol.for("find")]: {
    enumerable: false,
    value(member) {
      const members = this.$m;
      let value = members.get(member);
      if (value !== void 0) {
        return value;
      }
      const model = this.$l;
      const spec = model.find(member);
      if (spec !== null) {
        const env = vm2.getEnv();
        const h = this.$borrowClassHandle(env);
        try {
          value = makeMember(member, spec, h.value, this.$w, env);
        } finally {
          h.unref(env);
        }
        members.set(member, value);
        return value;
      }
      const superWrapper = this.$s;
      if (superWrapper !== null) {
        return superWrapper.$find(member);
      }
      return null;
    }
  },
  $find: {
    value(member) {
      return this[Symbol.for("find")](member);
    }
  },
  [Symbol.for("toJSON")]: {
    enumerable: false,
    value() {
      const wrapperName = this.$n;
      const handle2 = this.$h;
      if (handle2 === null) {
        return `<class: ${wrapperName}>`;
      }
      const actualName = this.$className;
      if (wrapperName === actualName) {
        return `<instance: ${wrapperName}>`;
      }
      return `<instance: ${wrapperName}, $className: ${actualName}>`;
    }
  },
  toJSON: {
    get() {
      return this[Symbol.for("toJSON")];
    }
  }
});
function ClassHandle(value, env) {
  this.value = env.newGlobalRef(value);
  env.deleteLocalRef(value);
  this.refs = 1;
}
ClassHandle.prototype.ref = function() {
  this.refs++;
  return this;
};
ClassHandle.prototype.unref = function(env) {
  if (--this.refs === 0) {
    env.deleteGlobalRef(this.value);
  }
};
function releaseClassHandle(handle2, env) {
  handle2.unref(env);
}
function makeBasicClassHandleGetter(className) {
  const canonicalClassName = className.replace(/\./g, "/");
  return function(env) {
    const tid = getCurrentThreadId();
    ignore(tid);
    try {
      return env.findClass(canonicalClassName);
    } finally {
      unignore(tid);
    }
  };
}
function makeLoaderClassHandleGetter(className, usedLoader, callerEnv) {
  if (cachedLoaderMethod === null) {
    cachedLoaderInvoke = callerEnv.vaMethod("pointer", ["pointer"]);
    cachedLoaderMethod = usedLoader.loadClass.overload("java.lang.String").handle;
  }
  callerEnv = null;
  return function(env) {
    const classNameValue = env.newStringUtf(className);
    const tid = getCurrentThreadId();
    ignore(tid);
    try {
      const result = cachedLoaderInvoke(env.handle, usedLoader.$h, cachedLoaderMethod, classNameValue);
      env.throwIfExceptionPending();
      return result;
    } finally {
      unignore(tid);
      env.deleteLocalRef(classNameValue);
    }
  };
}
function makeSuperHandleGetter(classWrapper) {
  return function(env) {
    const h = classWrapper.$borrowClassHandle(env);
    try {
      return env.getSuperclass(h.value);
    } finally {
      h.unref(env);
    }
  };
}
function makeConstructor(classHandle, classWrapper, env) {
  const { $n: className, $f: factory } = classWrapper;
  const methodName = basename(className);
  const Class = env.javaLangClass();
  const Constructor = env.javaLangReflectConstructor();
  const invokeObjectMethodNoArgs = env.vaMethod("pointer", []);
  const invokeUInt8MethodNoArgs = env.vaMethod("uint8", []);
  const jsCtorMethods = [];
  const jsInitMethods = [];
  const jsRetType = factory._getType(className, false);
  const jsVoidType = factory._getType("void", false);
  const constructors = invokeObjectMethodNoArgs(env.handle, classHandle, Class.getDeclaredConstructors);
  try {
    const n = env.getArrayLength(constructors);
    if (n !== 0) {
      for (let i = 0; i !== n; i++) {
        let methodId, types2;
        const constructor = env.getObjectArrayElement(constructors, i);
        try {
          methodId = env.fromReflectedMethod(constructor);
          types2 = invokeObjectMethodNoArgs(env.handle, constructor, Constructor.getGenericParameterTypes);
        } finally {
          env.deleteLocalRef(constructor);
        }
        let jsArgTypes;
        try {
          jsArgTypes = readTypeNames(env, types2).map((name) => factory._getType(name));
        } finally {
          env.deleteLocalRef(types2);
        }
        jsCtorMethods.push(makeMethod(methodName, classWrapper, CONSTRUCTOR_METHOD, methodId, jsRetType, jsArgTypes, env));
        jsInitMethods.push(makeMethod(methodName, classWrapper, INSTANCE_METHOD, methodId, jsVoidType, jsArgTypes, env));
      }
    } else {
      const isInterface = invokeUInt8MethodNoArgs(env.handle, classHandle, Class.isInterface);
      if (isInterface) {
        throw new Error("cannot instantiate an interface");
      }
      const defaultClass = env.javaLangObject();
      const defaultConstructor = env.getMethodId(defaultClass, "<init>", "()V");
      jsCtorMethods.push(makeMethod(methodName, classWrapper, CONSTRUCTOR_METHOD, defaultConstructor, jsRetType, [], env));
      jsInitMethods.push(makeMethod(methodName, classWrapper, INSTANCE_METHOD, defaultConstructor, jsVoidType, [], env));
    }
  } finally {
    env.deleteLocalRef(constructors);
  }
  if (jsInitMethods.length === 0) {
    throw new Error("no supported overloads");
  }
  return {
    allocAndInit: makeMethodDispatcher(jsCtorMethods),
    initOnly: makeMethodDispatcher(jsInitMethods)
  };
}
function makeMember(name, spec, classHandle, classWrapper, env) {
  if (spec.startsWith("m")) {
    return makeMethodFromSpec(name, spec, classHandle, classWrapper, env);
  }
  return makeFieldFromSpec(name, spec, classHandle, classWrapper, env);
}
function makeMethodFromSpec(name, spec, classHandle, classWrapper, env) {
  const { $f: factory } = classWrapper;
  const overloads = spec.split(":").slice(1);
  const Method = env.javaLangReflectMethod();
  const invokeObjectMethodNoArgs = env.vaMethod("pointer", []);
  const invokeUInt8MethodNoArgs = env.vaMethod("uint8", []);
  const methods = overloads.map((params) => {
    const type = params[0] === "s" ? STATIC_METHOD : INSTANCE_METHOD;
    const methodId = ptr(params.substr(1));
    let jsRetType;
    const jsArgTypes = [];
    const handle2 = env.toReflectedMethod(classHandle, methodId, type === STATIC_METHOD ? 1 : 0);
    try {
      const isVarArgs = !!invokeUInt8MethodNoArgs(env.handle, handle2, Method.isVarArgs);
      const retType2 = invokeObjectMethodNoArgs(env.handle, handle2, Method.getGenericReturnType);
      env.throwIfExceptionPending();
      try {
        jsRetType = factory._getType(env.getTypeName(retType2));
      } finally {
        env.deleteLocalRef(retType2);
      }
      const argTypes2 = invokeObjectMethodNoArgs(env.handle, handle2, Method.getParameterTypes);
      try {
        const n = env.getArrayLength(argTypes2);
        for (let i = 0; i !== n; i++) {
          const t = env.getObjectArrayElement(argTypes2, i);
          let argClassName;
          try {
            argClassName = isVarArgs && i === n - 1 ? env.getArrayTypeName(t) : env.getTypeName(t);
          } finally {
            env.deleteLocalRef(t);
          }
          const argType = factory._getType(argClassName);
          jsArgTypes.push(argType);
        }
      } finally {
        env.deleteLocalRef(argTypes2);
      }
    } catch (e) {
      return null;
    } finally {
      env.deleteLocalRef(handle2);
    }
    return makeMethod(name, classWrapper, type, methodId, jsRetType, jsArgTypes, env);
  }).filter((m2) => m2 !== null);
  if (methods.length === 0) {
    throw new Error("No supported overloads");
  }
  if (name === "valueOf") {
    ensureDefaultValueOfImplemented(methods);
  }
  const result = makeMethodDispatcher(methods);
  return function(receiver) {
    return result;
  };
}
function makeMethodDispatcher(overloads) {
  const m2 = makeMethodDispatcherCallable();
  Object.setPrototypeOf(m2, dispatcherPrototype);
  m2._o = overloads;
  return m2;
}
function makeMethodDispatcherCallable() {
  const m2 = function() {
    return m2.invoke(this, arguments);
  };
  return m2;
}
dispatcherPrototype = Object.create(Function.prototype, {
  overloads: {
    enumerable: true,
    get() {
      return this._o;
    }
  },
  overload: {
    value(...args) {
      const overloads = this._o;
      const numArgs = args.length;
      const signature2 = args.join(":");
      for (let i = 0; i !== overloads.length; i++) {
        const method2 = overloads[i];
        const { argumentTypes } = method2;
        if (argumentTypes.length !== numArgs) {
          continue;
        }
        const s = argumentTypes.map((t) => t.className).join(":");
        if (s === signature2) {
          return method2;
        }
      }
      throwOverloadError(this.methodName, this.overloads, "specified argument types do not match any of:");
    }
  },
  methodName: {
    enumerable: true,
    get() {
      return this._o[0].methodName;
    }
  },
  holder: {
    enumerable: true,
    get() {
      return this._o[0].holder;
    }
  },
  type: {
    enumerable: true,
    get() {
      return this._o[0].type;
    }
  },
  handle: {
    enumerable: true,
    get() {
      throwIfDispatcherAmbiguous(this);
      return this._o[0].handle;
    }
  },
  implementation: {
    enumerable: true,
    get() {
      throwIfDispatcherAmbiguous(this);
      return this._o[0].implementation;
    },
    set(fn) {
      throwIfDispatcherAmbiguous(this);
      this._o[0].implementation = fn;
    }
  },
  returnType: {
    enumerable: true,
    get() {
      throwIfDispatcherAmbiguous(this);
      return this._o[0].returnType;
    }
  },
  argumentTypes: {
    enumerable: true,
    get() {
      throwIfDispatcherAmbiguous(this);
      return this._o[0].argumentTypes;
    }
  },
  canInvokeWith: {
    enumerable: true,
    get(args) {
      throwIfDispatcherAmbiguous(this);
      return this._o[0].canInvokeWith;
    }
  },
  clone: {
    enumerable: true,
    value(options) {
      throwIfDispatcherAmbiguous(this);
      return this._o[0].clone(options);
    }
  },
  invoke: {
    value(receiver, args) {
      const overloads = this._o;
      const isInstance = receiver.$h !== null;
      for (let i = 0; i !== overloads.length; i++) {
        const method2 = overloads[i];
        if (!method2.canInvokeWith(args)) {
          continue;
        }
        if (method2.type === INSTANCE_METHOD && !isInstance) {
          const name = this.methodName;
          if (name === "toString") {
            return `<class: ${receiver.$n}>`;
          }
          throw new Error(name + ": cannot call instance method without an instance");
        }
        return method2.apply(receiver, args);
      }
      if (this.methodName === "toString") {
        return `<class: ${receiver.$n}>`;
      }
      throwOverloadError(this.methodName, this.overloads, "argument types do not match any of:");
    }
  }
});
function makeOverloadId(name, returnType, argumentTypes) {
  return `${returnType.className} ${name}(${argumentTypes.map((t) => t.className).join(", ")})`;
}
function throwIfDispatcherAmbiguous(dispatcher) {
  const methods = dispatcher._o;
  if (methods.length > 1) {
    throwOverloadError(methods[0].methodName, methods, "has more than one overload, use .overload(<signature>) to choose from:");
  }
}
function throwOverloadError(name, methods, message) {
  const methodsSortedByArity = methods.slice().sort((a, b) => a.argumentTypes.length - b.argumentTypes.length);
  const overloads = methodsSortedByArity.map((m2) => {
    const argTypes2 = m2.argumentTypes;
    if (argTypes2.length > 0) {
      return ".overload('" + m2.argumentTypes.map((t) => t.className).join("', '") + "')";
    } else {
      return ".overload()";
    }
  });
  throw new Error(`${name}(): ${message}
	${overloads.join("\n	")}`);
}
function makeMethod(methodName, classWrapper, type, methodId, retType2, argTypes2, env, invocationOptions2) {
  const rawRetType = retType2.type;
  const rawArgTypes = argTypes2.map((t) => t.type);
  if (env === null) {
    env = vm2.getEnv();
  }
  let callVirtually, callDirectly;
  if (type === INSTANCE_METHOD) {
    callVirtually = env.vaMethod(rawRetType, rawArgTypes, invocationOptions2);
    callDirectly = env.nonvirtualVaMethod(rawRetType, rawArgTypes, invocationOptions2);
  } else if (type === STATIC_METHOD) {
    callVirtually = env.staticVaMethod(rawRetType, rawArgTypes, invocationOptions2);
    callDirectly = callVirtually;
  } else {
    callVirtually = env.constructor(rawArgTypes, invocationOptions2);
    callDirectly = callVirtually;
  }
  return makeMethodInstance([methodName, classWrapper, type, methodId, retType2, argTypes2, callVirtually, callDirectly]);
}
function makeMethodInstance(params) {
  const m2 = makeMethodCallable();
  Object.setPrototypeOf(m2, methodPrototype);
  m2._p = params;
  return m2;
}
function makeMethodCallable() {
  const m2 = function() {
    return m2.invoke(this, arguments);
  };
  return m2;
}
methodPrototype = Object.create(Function.prototype, {
  methodName: {
    enumerable: true,
    get() {
      return this._p[0];
    }
  },
  holder: {
    enumerable: true,
    get() {
      return this._p[1];
    }
  },
  type: {
    enumerable: true,
    get() {
      return this._p[2];
    }
  },
  handle: {
    enumerable: true,
    get() {
      return this._p[3];
    }
  },
  implementation: {
    enumerable: true,
    get() {
      const replacement = this._r;
      return replacement !== void 0 ? replacement : null;
    },
    set(fn) {
      const params = this._p;
      const holder = params[1];
      const type = params[2];
      if (type === CONSTRUCTOR_METHOD) {
        throw new Error("Reimplementing $new is not possible; replace implementation of $init instead");
      }
      const existingReplacement = this._r;
      if (existingReplacement !== void 0) {
        holder.$f._patchedMethods.delete(this);
        const mangler = existingReplacement._m;
        mangler.revert(vm2);
        this._r = void 0;
      }
      if (fn !== null) {
        const [methodName, classWrapper, type2, methodId, retType2, argTypes2] = params;
        const replacement = implement(methodName, classWrapper, type2, retType2, argTypes2, fn, this);
        const mangler = makeMethodMangler3(methodId);
        replacement._m = mangler;
        this._r = replacement;
        mangler.replace(replacement, type2 === INSTANCE_METHOD, argTypes2, vm2, api2);
        holder.$f._patchedMethods.add(this);
      }
    }
  },
  returnType: {
    enumerable: true,
    get() {
      return this._p[4];
    }
  },
  argumentTypes: {
    enumerable: true,
    get() {
      return this._p[5];
    }
  },
  canInvokeWith: {
    enumerable: true,
    value(args) {
      const argTypes2 = this._p[5];
      if (args.length !== argTypes2.length) {
        return false;
      }
      return argTypes2.every((t, i) => {
        return t.isCompatible(args[i]);
      });
    }
  },
  clone: {
    enumerable: true,
    value(options) {
      const params = this._p.slice(0, 6);
      return makeMethod(...params, null, options);
    }
  },
  invoke: {
    value(receiver, args) {
      const env = vm2.getEnv();
      const params = this._p;
      const type = params[2];
      const retType2 = params[4];
      const argTypes2 = params[5];
      const replacement = this._r;
      const isInstanceMethod = type === INSTANCE_METHOD;
      const numArgs = args.length;
      const frameCapacity = 2 + numArgs;
      env.pushLocalFrame(frameCapacity);
      let borrowedHandle = null;
      try {
        let jniThis;
        if (isInstanceMethod) {
          jniThis = receiver.$getHandle();
        } else {
          borrowedHandle = receiver.$borrowClassHandle(env);
          jniThis = borrowedHandle.value;
        }
        let methodId;
        let strategy = receiver.$t;
        if (replacement === void 0) {
          methodId = params[3];
        } else {
          const mangler = replacement._m;
          methodId = mangler.resolveTarget(receiver, isInstanceMethod, env, api2);
          if (isArtVm) {
            const pendingCalls = replacement._c;
            if (pendingCalls.has(getCurrentThreadId())) {
              strategy = STRATEGY_DIRECT;
            }
          }
        }
        const jniArgs = [
          env.handle,
          jniThis,
          methodId
        ];
        for (let i = 0; i !== numArgs; i++) {
          jniArgs.push(argTypes2[i].toJni(args[i], env));
        }
        let jniCall;
        if (strategy === STRATEGY_VIRTUAL) {
          jniCall = params[6];
        } else {
          jniCall = params[7];
          if (isInstanceMethod) {
            jniArgs.splice(2, 0, receiver.$copyClassHandle(env));
          }
        }
        const jniRetval = jniCall.apply(null, jniArgs);
        env.throwIfExceptionPending();
        return retType2.fromJni(jniRetval, env, true);
      } finally {
        if (borrowedHandle !== null) {
          borrowedHandle.unref(env);
        }
        env.popLocalFrame(NULL);
      }
    }
  },
  toString: {
    enumerable: true,
    value() {
      return `function ${this.methodName}(${this.argumentTypes.map((t) => t.className).join(", ")}): ${this.returnType.className}`;
    }
  }
});
function implement(methodName, classWrapper, type, retType2, argTypes2, handler, fallback = null) {
  const pendingCalls = /* @__PURE__ */ new Set();
  const f2 = makeMethodImplementation([methodName, classWrapper, type, retType2, argTypes2, handler, fallback, pendingCalls]);
  const impl = new NativeCallback(f2, retType2.type, ["pointer", "pointer"].concat(argTypes2.map((t) => t.type)));
  impl._c = pendingCalls;
  return impl;
}
function makeMethodImplementation(params) {
  return function() {
    return handleMethodInvocation(arguments, params);
  };
}
function handleMethodInvocation(jniArgs, params) {
  const env = new Env(jniArgs[0], vm2);
  const [methodName, classWrapper, type, retType2, argTypes2, handler, fallback, pendingCalls] = params;
  const ownedObjects = [];
  let self;
  if (type === INSTANCE_METHOD) {
    const C = classWrapper.$C;
    self = new C(jniArgs[1], STRATEGY_VIRTUAL, env, false);
  } else {
    self = classWrapper;
  }
  const tid = getCurrentThreadId();
  env.pushLocalFrame(3);
  let haveFrame = true;
  vm2.link(tid, env);
  try {
    pendingCalls.add(tid);
    let fn;
    if (fallback === null || !ignoredThreads.has(tid)) {
      fn = handler;
    } else {
      fn = fallback;
    }
    const args = [];
    const numArgs = jniArgs.length - 2;
    for (let i = 0; i !== numArgs; i++) {
      const t = argTypes2[i];
      const value = t.fromJni(jniArgs[2 + i], env, false);
      args.push(value);
      ownedObjects.push(value);
    }
    const retval = fn.apply(self, args);
    if (!retType2.isCompatible(retval)) {
      throw new Error(`Implementation for ${methodName} expected return value compatible with ${retType2.className}`);
    }
    let jniRetval = retType2.toJni(retval, env);
    if (retType2.type === "pointer") {
      jniRetval = env.popLocalFrame(jniRetval);
      haveFrame = false;
      ownedObjects.push(retval);
    }
    return jniRetval;
  } catch (e) {
    const jniException = e.$h;
    if (jniException !== void 0) {
      env.throw(jniException);
    } else {
      Script.nextTick(() => {
        throw e;
      });
    }
    return retType2.defaultValue;
  } finally {
    vm2.unlink(tid);
    if (haveFrame) {
      env.popLocalFrame(NULL);
    }
    pendingCalls.delete(tid);
    ownedObjects.forEach((obj) => {
      if (obj === null) {
        return;
      }
      const dispose2 = obj.$dispose;
      if (dispose2 !== void 0) {
        dispose2.call(obj);
      }
    });
  }
}
function ensureDefaultValueOfImplemented(methods) {
  const { holder, type } = methods[0];
  const hasDefaultValueOf = methods.some((m2) => m2.type === type && m2.argumentTypes.length === 0);
  if (hasDefaultValueOf) {
    return;
  }
  methods.push(makeValueOfMethod([holder, type]));
}
function makeValueOfMethod(params) {
  const m2 = makeValueOfCallable();
  Object.setPrototypeOf(m2, valueOfPrototype);
  m2._p = params;
  return m2;
}
function makeValueOfCallable() {
  const m2 = function() {
    return this;
  };
  return m2;
}
valueOfPrototype = Object.create(Function.prototype, {
  methodName: {
    enumerable: true,
    get() {
      return "valueOf";
    }
  },
  holder: {
    enumerable: true,
    get() {
      return this._p[0];
    }
  },
  type: {
    enumerable: true,
    get() {
      return this._p[1];
    }
  },
  handle: {
    enumerable: true,
    get() {
      return NULL;
    }
  },
  implementation: {
    enumerable: true,
    get() {
      return null;
    },
    set(fn) {
    }
  },
  returnType: {
    enumerable: true,
    get() {
      const classWrapper = this.holder;
      return classWrapper.$f.use(classWrapper.$n);
    }
  },
  argumentTypes: {
    enumerable: true,
    get() {
      return [];
    }
  },
  canInvokeWith: {
    enumerable: true,
    value(args) {
      return args.length === 0;
    }
  },
  clone: {
    enumerable: true,
    value(options) {
      throw new Error("Invalid operation");
    }
  }
});
function makeFieldFromSpec(name, spec, classHandle, classWrapper, env) {
  const type = spec[2] === "s" ? STATIC_FIELD : INSTANCE_FIELD;
  const id = ptr(spec.substr(3));
  const { $f: factory } = classWrapper;
  let fieldType;
  const field = env.toReflectedField(classHandle, id, type === STATIC_FIELD ? 1 : 0);
  try {
    fieldType = env.vaMethod("pointer", [])(env.handle, field, env.javaLangReflectField().getGenericType);
    env.throwIfExceptionPending();
  } finally {
    env.deleteLocalRef(field);
  }
  let rtype;
  try {
    rtype = factory._getType(env.getTypeName(fieldType));
  } finally {
    env.deleteLocalRef(fieldType);
  }
  let getValue, setValue;
  const rtypeJni = rtype.type;
  if (type === STATIC_FIELD) {
    getValue = env.getStaticField(rtypeJni);
    setValue = env.setStaticField(rtypeJni);
  } else {
    getValue = env.getField(rtypeJni);
    setValue = env.setField(rtypeJni);
  }
  return makeFieldFromParams([type, rtype, id, getValue, setValue]);
}
function makeFieldFromParams(params) {
  return function(receiver) {
    return new Field([receiver].concat(params));
  };
}
function Field(params) {
  this._p = params;
}
Object.defineProperties(Field.prototype, {
  value: {
    enumerable: true,
    get() {
      const [holder, type, rtype, id, getValue] = this._p;
      const env = vm2.getEnv();
      env.pushLocalFrame(4);
      let borrowedHandle = null;
      try {
        let jniThis;
        if (type === INSTANCE_FIELD) {
          jniThis = holder.$getHandle();
          if (jniThis === null) {
            throw new Error("Cannot access an instance field without an instance");
          }
        } else {
          borrowedHandle = holder.$borrowClassHandle(env);
          jniThis = borrowedHandle.value;
        }
        const jniRetval = getValue(env.handle, jniThis, id);
        env.throwIfExceptionPending();
        return rtype.fromJni(jniRetval, env, true);
      } finally {
        if (borrowedHandle !== null) {
          borrowedHandle.unref(env);
        }
        env.popLocalFrame(NULL);
      }
    },
    set(value) {
      const [holder, type, rtype, id, , setValue] = this._p;
      const env = vm2.getEnv();
      env.pushLocalFrame(4);
      let borrowedHandle = null;
      try {
        let jniThis;
        if (type === INSTANCE_FIELD) {
          jniThis = holder.$getHandle();
          if (jniThis === null) {
            throw new Error("Cannot access an instance field without an instance");
          }
        } else {
          borrowedHandle = holder.$borrowClassHandle(env);
          jniThis = borrowedHandle.value;
        }
        if (!rtype.isCompatible(value)) {
          throw new Error(`Expected value compatible with ${rtype.className}`);
        }
        const jniValue = rtype.toJni(value, env);
        setValue(env.handle, jniThis, id, jniValue);
        env.throwIfExceptionPending();
      } finally {
        if (borrowedHandle !== null) {
          borrowedHandle.unref(env);
        }
        env.popLocalFrame(NULL);
      }
    }
  },
  holder: {
    enumerable: true,
    get() {
      return this._p[0];
    }
  },
  fieldType: {
    enumerable: true,
    get() {
      return this._p[1];
    }
  },
  fieldReturnType: {
    enumerable: true,
    get() {
      return this._p[2];
    }
  },
  toString: {
    enumerable: true,
    value() {
      const inlineString = `Java.Field{holder: ${this.holder}, fieldType: ${this.fieldType}, fieldReturnType: ${this.fieldReturnType}, value: ${this.value}}`;
      if (inlineString.length < 200) {
        return inlineString;
      }
      const multilineString = `Java.Field{
	holder: ${this.holder},
	fieldType: ${this.fieldType},
	fieldReturnType: ${this.fieldReturnType},
	value: ${this.value},
}`;
      return multilineString.split("\n").map((l) => l.length > 200 ? l.slice(0, l.indexOf(" ") + 1) + "...," : l).join("\n");
    }
  }
});
var DexFile = class _DexFile {
  static fromBuffer(buffer, factory) {
    const fileValue = createTemporaryDex(factory);
    const filePath = fileValue.getCanonicalPath().toString();
    const file = new File(filePath, "w");
    file.write(buffer.buffer);
    file.close();
    setReadOnlyDex(filePath, factory);
    return new _DexFile(filePath, fileValue, factory);
  }
  constructor(path, file, factory) {
    this.path = path;
    this.file = file;
    this._factory = factory;
  }
  load() {
    const { _factory: factory } = this;
    const { codeCacheDir } = factory;
    const DexClassLoader = factory.use("dalvik.system.DexClassLoader");
    const JFile = factory.use("java.io.File");
    let file = this.file;
    if (file === null) {
      file = factory.use("java.io.File").$new(this.path);
    }
    if (!file.exists()) {
      throw new Error("File not found");
    }
    JFile.$new(codeCacheDir).mkdirs();
    factory.loader = DexClassLoader.$new(file.getCanonicalPath(), codeCacheDir, null, factory.loader);
    vm2.preventDetachDueToClassLoader();
  }
  getClassNames() {
    const { _factory: factory } = this;
    const DexFile2 = factory.use("dalvik.system.DexFile");
    const optimizedDex = createTemporaryDex(factory);
    const dx = DexFile2.loadDex(this.path, optimizedDex.getCanonicalPath(), 0);
    const classNames = [];
    const enumeratorClassNames = dx.entries();
    while (enumeratorClassNames.hasMoreElements()) {
      classNames.push(enumeratorClassNames.nextElement().toString());
    }
    return classNames;
  }
};
function createTemporaryDex(factory) {
  const { cacheDir, tempFileNaming } = factory;
  const JFile = factory.use("java.io.File");
  const cacheDirValue = JFile.$new(cacheDir);
  cacheDirValue.mkdirs();
  return JFile.createTempFile(tempFileNaming.prefix, tempFileNaming.suffix + ".dex", cacheDirValue);
}
function setReadOnlyDex(filePath, factory) {
  const JFile = factory.use("java.io.File");
  const file = JFile.$new(filePath);
  file.setWritable(false, false);
}
function getFactoryCache() {
  switch (factoryCache.state) {
    case "empty": {
      factoryCache.state = "pending";
      const defaultFactory = factoryCache.factories[0];
      const HashMap = defaultFactory.use("java.util.HashMap");
      const Integer = defaultFactory.use("java.lang.Integer");
      factoryCache.loaders = HashMap.$new();
      factoryCache.Integer = Integer;
      const loader = defaultFactory.loader;
      if (loader !== null) {
        addFactoryToCache(defaultFactory, loader);
      }
      factoryCache.state = "ready";
      return factoryCache;
    }
    case "pending":
      do {
        Thread.sleep(0.05);
      } while (factoryCache.state === "pending");
      return factoryCache;
    case "ready":
      return factoryCache;
  }
}
function addFactoryToCache(factory, loader) {
  const { factories, loaders, Integer } = factoryCache;
  const index = Integer.$new(factories.indexOf(factory));
  loaders.put(loader, index);
  for (let l = loader.getParent(); l !== null; l = l.getParent()) {
    if (loaders.containsKey(l)) {
      break;
    }
    loaders.put(l, index);
  }
}
function ignore(threadId) {
  let count = ignoredThreads.get(threadId);
  if (count === void 0) {
    count = 0;
  }
  count++;
  ignoredThreads.set(threadId, count);
}
function unignore(threadId) {
  let count = ignoredThreads.get(threadId);
  if (count === void 0) {
    throw new Error(`Thread ${threadId} is not ignored`);
  }
  count--;
  if (count === 0) {
    ignoredThreads.delete(threadId);
  } else {
    ignoredThreads.set(threadId, count);
  }
}
function basename(className) {
  return className.slice(className.lastIndexOf(".") + 1);
}
function readTypeNames(env, types2) {
  const names = [];
  const n = env.getArrayLength(types2);
  for (let i = 0; i !== n; i++) {
    const t = env.getObjectArrayElement(types2, i);
    try {
      names.push(env.getTypeName(t));
    } finally {
      env.deleteLocalRef(t);
    }
  }
  return names;
}
function makeSourceFileName(className) {
  const tokens = className.split(".");
  return tokens[tokens.length - 1] + ".java";
}

// node_modules/frida-java-bridge/index.js
var jsizeSize4 = 4;
var pointerSize10 = Process.pointerSize;
var Runtime = class {
  ACC_PUBLIC = 1;
  ACC_PRIVATE = 2;
  ACC_PROTECTED = 4;
  ACC_STATIC = 8;
  ACC_FINAL = 16;
  ACC_SYNCHRONIZED = 32;
  ACC_BRIDGE = 64;
  ACC_VARARGS = 128;
  ACC_NATIVE = 256;
  ACC_ABSTRACT = 1024;
  ACC_STRICT = 2048;
  ACC_SYNTHETIC = 4096;
  constructor() {
    this.classFactory = null;
    this.ClassFactory = ClassFactory;
    this.vm = null;
    this.api = null;
    this._initialized = false;
    this._apiError = null;
    this._wakeupHandler = null;
    this._pollListener = null;
    this._pendingMainOps = [];
    this._pendingVmOps = [];
    this._cachedIsAppProcess = null;
    try {
      this._tryInitialize();
    } catch (e) {
    }
  }
  _tryInitialize() {
    if (this._initialized) {
      return true;
    }
    if (this._apiError !== null) {
      throw this._apiError;
    }
    let api3;
    try {
      api3 = api_default();
      this.api = api3;
    } catch (e) {
      this._apiError = e;
      throw e;
    }
    if (api3 === null) {
      return false;
    }
    const vm3 = new VM(api3);
    this.vm = vm3;
    initialize(vm3);
    ClassFactory._initialize(vm3, api3);
    this.classFactory = new ClassFactory();
    this._initialized = true;
    return true;
  }
  _dispose() {
    if (this.api === null) {
      return;
    }
    const { vm: vm3 } = this;
    vm3.perform((env) => {
      ClassFactory._disposeAll(env);
      Env.dispose(env);
    });
    Script.nextTick(() => {
      VM.dispose(vm3);
    });
  }
  get available() {
    return this._tryInitialize();
  }
  get androidVersion() {
    return getAndroidVersion();
  }
  synchronized(obj, fn) {
    const { $h: objHandle = obj } = obj;
    if (!(objHandle instanceof NativePointer)) {
      throw new Error("Java.synchronized: the first argument `obj` must be either a pointer or a Java instance");
    }
    const env = this.vm.getEnv();
    checkJniResult("VM::MonitorEnter", env.monitorEnter(objHandle));
    try {
      fn();
    } finally {
      env.monitorExit(objHandle);
    }
  }
  enumerateLoadedClasses(callbacks) {
    this._checkAvailable();
    const { flavor } = this.api;
    if (flavor === "jvm") {
      this._enumerateLoadedClassesJvm(callbacks);
    } else if (flavor === "art") {
      this._enumerateLoadedClassesArt(callbacks);
    } else {
      this._enumerateLoadedClassesDalvik(callbacks);
    }
  }
  enumerateLoadedClassesSync() {
    const classes = [];
    this.enumerateLoadedClasses({
      onMatch(c) {
        classes.push(c);
      },
      onComplete() {
      }
    });
    return classes;
  }
  enumerateClassLoaders(callbacks) {
    this._checkAvailable();
    const { flavor } = this.api;
    if (flavor === "jvm") {
      this._enumerateClassLoadersJvm(callbacks);
    } else if (flavor === "art") {
      this._enumerateClassLoadersArt(callbacks);
    } else {
      throw new Error("Enumerating class loaders is not supported on Dalvik");
    }
  }
  enumerateClassLoadersSync() {
    const loaders = [];
    this.enumerateClassLoaders({
      onMatch(c) {
        loaders.push(c);
      },
      onComplete() {
      }
    });
    return loaders;
  }
  _enumerateLoadedClassesJvm(callbacks) {
    const { api: api3, vm: vm3 } = this;
    const { jvmti } = api3;
    const env = vm3.getEnv();
    const countPtr = Memory.alloc(jsizeSize4);
    const classesPtr = Memory.alloc(pointerSize10);
    jvmti.getLoadedClasses(countPtr, classesPtr);
    const count = countPtr.readS32();
    const classes = classesPtr.readPointer();
    const handles = [];
    for (let i = 0; i !== count; i++) {
      handles.push(classes.add(i * pointerSize10).readPointer());
    }
    jvmti.deallocate(classes);
    try {
      for (const handle2 of handles) {
        const className = env.getClassName(handle2);
        callbacks.onMatch(className, handle2);
      }
      callbacks.onComplete();
    } finally {
      handles.forEach((handle2) => {
        env.deleteLocalRef(handle2);
      });
    }
  }
  _enumerateClassLoadersJvm(callbacks) {
    this.choose("java.lang.ClassLoader", callbacks);
  }
  _enumerateLoadedClassesArt(callbacks) {
    const { vm: vm3, api: api3 } = this;
    const env = vm3.getEnv();
    const addGlobalReference = api3["art::JavaVMExt::AddGlobalRef"];
    const { vm: vmHandle } = api3;
    withRunnableArtThread(vm3, env, (thread) => {
      const collectClassHandles = makeArtClassVisitor((klass) => {
        const handle2 = addGlobalReference(vmHandle, thread, klass);
        try {
          const className = env.getClassName(handle2);
          callbacks.onMatch(className, handle2);
        } finally {
          env.deleteGlobalRef(handle2);
        }
        return true;
      });
      api3["art::ClassLinker::VisitClasses"](api3.artClassLinker.address, collectClassHandles);
    });
    callbacks.onComplete();
  }
  _enumerateClassLoadersArt(callbacks) {
    const { classFactory: factory, vm: vm3, api: api3 } = this;
    const env = vm3.getEnv();
    const visitClassLoaders = api3["art::ClassLinker::VisitClassLoaders"];
    if (visitClassLoaders === void 0) {
      throw new Error("This API is only available on Android >= 7.0");
    }
    const ClassLoader = factory.use("java.lang.ClassLoader");
    const loaderHandles = [];
    const addGlobalReference = api3["art::JavaVMExt::AddGlobalRef"];
    const { vm: vmHandle } = api3;
    withRunnableArtThread(vm3, env, (thread) => {
      const collectLoaderHandles = makeArtClassLoaderVisitor((loader) => {
        loaderHandles.push(addGlobalReference(vmHandle, thread, loader));
        return true;
      });
      withAllArtThreadsSuspended(() => {
        visitClassLoaders(api3.artClassLinker.address, collectLoaderHandles);
      });
    });
    try {
      loaderHandles.forEach((handle2) => {
        const loader = factory.cast(handle2, ClassLoader);
        callbacks.onMatch(loader);
      });
    } finally {
      loaderHandles.forEach((handle2) => {
        env.deleteGlobalRef(handle2);
      });
    }
    callbacks.onComplete();
  }
  _enumerateLoadedClassesDalvik(callbacks) {
    const { api: api3 } = this;
    const HASH_TOMBSTONE = ptr("0xcbcacccd");
    const loadedClassesOffset = 172;
    const hashEntrySize = 8;
    const ptrLoadedClassesHashtable = api3.gDvm.add(loadedClassesOffset);
    const hashTable = ptrLoadedClassesHashtable.readPointer();
    const tableSize = hashTable.readS32();
    const ptrpEntries = hashTable.add(12);
    const pEntries = ptrpEntries.readPointer();
    const end = tableSize * hashEntrySize;
    for (let offset = 0; offset < end; offset += hashEntrySize) {
      const pEntryPtr = pEntries.add(offset);
      const dataPtr = pEntryPtr.add(4).readPointer();
      if (dataPtr.isNull() || dataPtr.equals(HASH_TOMBSTONE)) {
        continue;
      }
      const descriptionPtr = dataPtr.add(24).readPointer();
      const description = descriptionPtr.readUtf8String();
      if (description.startsWith("L")) {
        const name = description.substring(1, description.length - 1).replace(/\//g, ".");
        callbacks.onMatch(name);
      }
    }
    callbacks.onComplete();
  }
  enumerateMethods(query) {
    const { classFactory: factory } = this;
    const env = this.vm.getEnv();
    const ClassLoader = factory.use("java.lang.ClassLoader");
    return Model.enumerateMethods(query, this.api, env).map((group) => {
      const handle2 = group.loader;
      group.loader = handle2 !== null ? factory.wrap(handle2, ClassLoader, env) : null;
      return group;
    });
  }
  scheduleOnMainThread(fn) {
    this.performNow(() => {
      this._pendingMainOps.push(fn);
      let { _wakeupHandler: wakeupHandler } = this;
      if (wakeupHandler === null) {
        const { classFactory: factory } = this;
        const Handler = factory.use("android.os.Handler");
        const Looper = factory.use("android.os.Looper");
        wakeupHandler = Handler.$new(Looper.getMainLooper());
        this._wakeupHandler = wakeupHandler;
      }
      if (this._pollListener === null) {
        this._pollListener = Interceptor.attach(Process.getModuleByName("libc.so").getExportByName("epoll_wait"), this._makePollHook());
        Interceptor.flush();
      }
      wakeupHandler.sendEmptyMessage(1);
    });
  }
  _makePollHook() {
    const mainThreadId = Process.id;
    const { _pendingMainOps: pending } = this;
    return function() {
      if (this.threadId !== mainThreadId) {
        return;
      }
      let fn;
      while ((fn = pending.shift()) !== void 0) {
        try {
          fn();
        } catch (e) {
          Script.nextTick(() => {
            throw e;
          });
        }
      }
    };
  }
  perform(fn) {
    this._checkAvailable();
    if (!this._isAppProcess() || this.classFactory.loader !== null) {
      try {
        this.vm.perform(fn);
      } catch (e) {
        Script.nextTick(() => {
          throw e;
        });
      }
    } else {
      this._pendingVmOps.push(fn);
      if (this._pendingVmOps.length === 1) {
        this._performPendingVmOpsWhenReady();
      }
    }
  }
  performNow(fn) {
    this._checkAvailable();
    return this.vm.perform(() => {
      const { classFactory: factory } = this;
      if (this._isAppProcess() && factory.loader === null) {
        const ActivityThread = factory.use("android.app.ActivityThread");
        const app = ActivityThread.currentApplication();
        if (app !== null) {
          initFactoryFromApplication(factory, app);
        }
      }
      return fn();
    });
  }
  _performPendingVmOpsWhenReady() {
    this.vm.perform(() => {
      const { classFactory: factory } = this;
      const ActivityThread = factory.use("android.app.ActivityThread");
      const app = ActivityThread.currentApplication();
      if (app !== null) {
        initFactoryFromApplication(factory, app);
        this._performPendingVmOps();
        return;
      }
      const runtime3 = this;
      let initialized = false;
      let hookpoint = "early";
      const handleBindApplication = ActivityThread.handleBindApplication;
      handleBindApplication.implementation = function(data) {
        if (data.instrumentationName.value !== null) {
          hookpoint = "late";
          const LoadedApk = factory.use("android.app.LoadedApk");
          const makeApplication = LoadedApk.makeApplication;
          makeApplication.implementation = function(forceDefaultAppClass, instrumentation) {
            if (!initialized) {
              initialized = true;
              initFactoryFromLoadedApk(factory, this);
              runtime3._performPendingVmOps();
            }
            return makeApplication.apply(this, arguments);
          };
        }
        handleBindApplication.apply(this, arguments);
      };
      const getPackageInfoCandidates = ActivityThread.getPackageInfo.overloads.map((m2) => [m2.argumentTypes.length, m2]).sort(([arityA], [arityB]) => arityB - arityA).map(([_, method2]) => method2);
      const getPackageInfo = getPackageInfoCandidates[0];
      getPackageInfo.implementation = function(...args) {
        const apk = getPackageInfo.call(this, ...args);
        if (!initialized && hookpoint === "early") {
          initialized = true;
          initFactoryFromLoadedApk(factory, apk);
          runtime3._performPendingVmOps();
        }
        return apk;
      };
    });
  }
  _performPendingVmOps() {
    const { vm: vm3, _pendingVmOps: pending } = this;
    let fn;
    while ((fn = pending.shift()) !== void 0) {
      try {
        vm3.perform(fn);
      } catch (e) {
        Script.nextTick(() => {
          throw e;
        });
      }
    }
  }
  use(className, options) {
    return this.classFactory.use(className, options);
  }
  openClassFile(filePath) {
    return this.classFactory.openClassFile(filePath);
  }
  choose(specifier, callbacks) {
    this.classFactory.choose(specifier, callbacks);
  }
  retain(obj) {
    return this.classFactory.retain(obj);
  }
  cast(obj, C) {
    return this.classFactory.cast(obj, C);
  }
  array(type, elements) {
    return this.classFactory.array(type, elements);
  }
  backtrace(options) {
    return backtrace(this.vm, options);
  }
  // Reference: http://stackoverflow.com/questions/2848575/how-to-detect-ui-thread-on-android
  isMainThread() {
    const Looper = this.classFactory.use("android.os.Looper");
    const mainLooper = Looper.getMainLooper();
    const myLooper = Looper.myLooper();
    if (myLooper === null) {
      return false;
    }
    return mainLooper.$isSameObject(myLooper);
  }
  registerClass(spec) {
    return this.classFactory.registerClass(spec);
  }
  deoptimizeEverything() {
    const { vm: vm3 } = this;
    return deoptimizeEverything(vm3, vm3.getEnv());
  }
  deoptimizeBootImage() {
    const { vm: vm3 } = this;
    return deoptimizeBootImage(vm3, vm3.getEnv());
  }
  deoptimizeMethod(method2) {
    const { vm: vm3 } = this;
    return deoptimizeMethod(vm3, vm3.getEnv(), method2);
  }
  _checkAvailable() {
    if (!this.available) {
      throw new Error("Java API not available");
    }
  }
  _isAppProcess() {
    let result = this._cachedIsAppProcess;
    if (result === null) {
      if (this.api.flavor === "jvm") {
        result = false;
        this._cachedIsAppProcess = result;
        return result;
      }
      const readlink = new NativeFunction(Module.getGlobalExportByName("readlink"), "pointer", ["pointer", "pointer", "pointer"], {
        exceptions: "propagate"
      });
      const pathname = Memory.allocUtf8String("/proc/self/exe");
      const bufferSize = 1024;
      const buffer = Memory.alloc(bufferSize);
      const size = readlink(pathname, buffer, ptr(bufferSize)).toInt32();
      if (size !== -1) {
        const exe = buffer.readUtf8String(size);
        result = /^\/system\/bin\/app_process/.test(exe);
      } else {
        result = true;
      }
      this._cachedIsAppProcess = result;
    }
    return result;
  }
};
function initFactoryFromApplication(factory, app) {
  const Process2 = factory.use("android.os.Process");
  factory.loader = app.getClassLoader();
  if (Process2.myUid() === Process2.SYSTEM_UID.value) {
    factory.cacheDir = "/data/system";
    factory.codeCacheDir = "/data/dalvik-cache";
  } else {
    if ("getCodeCacheDir" in app) {
      factory.cacheDir = app.getCacheDir().getCanonicalPath();
      factory.codeCacheDir = app.getCodeCacheDir().getCanonicalPath();
    } else {
      factory.cacheDir = app.getFilesDir().getCanonicalPath();
      factory.codeCacheDir = app.getCacheDir().getCanonicalPath();
    }
  }
}
function initFactoryFromLoadedApk(factory, apk) {
  const JFile = factory.use("java.io.File");
  factory.loader = apk.getClassLoader();
  const dataDir = JFile.$new(apk.getDataDir()).getCanonicalPath();
  factory.cacheDir = dataDir;
  factory.codeCacheDir = dataDir + "/cache";
}
var runtime = new Runtime();
Script.bindWeak(runtime, () => {
  runtime._dispose();
});
var frida_java_bridge_default = runtime;

// agent/shared/javalib.ts
var Java;
var javaLegacy = globalThis.Java;
if (javaLegacy && typeof javaLegacy.perform === "function") {
  devlog("[frida-java-bridge] Pre-v17 Frida detected. Using legacy global Java bridge.");
  Java = javaLegacy;
} else {
  devlog("[frida-java-bridge] Frida >=17 detected. Using 'frida-java-bridge' module.");
  Java = frida_java_bridge_default;
}

// agent/shared/shared_functions.ts
function wait_for_library_loaded(module_name) {
  let timeout_library = 5;
  let module_adress = Process.getModuleByName(module_name).base;
  if (module_adress === NULL || module_adress === null) {
    log("[*] Waiting " + timeout_library + " milliseconds for the loading of " + module_name);
    setTimeout(wait_for_library_loaded, timeout_library);
  }
}
function ssl_library_loader(plattform_name6, module_library_mapping2, moduleNames6, plattform_os, is_base_hook) {
  for (let map of module_library_mapping2[plattform_name6]) {
    let regex = new RegExp(map[0]);
    let func = map[1];
    let optionalPathFilter = map[2];
    for (let module_name of moduleNames6) {
      if (regex.test(module_name)) {
        try {
          if (optionalPathFilter) {
            const module = Process.getModuleByName(module_name);
            if (!module.path.toLowerCase().includes(optionalPathFilter.toLowerCase())) {
              continue;
            }
          }
          log(`${module_name} found & will be hooked on ${plattform_os}!`);
          try {
            Process.getModuleByName(module_name).ensureInitialized();
          } catch (error) {
            wait_for_library_loaded(module_name);
          }
          func(module_name, is_base_hook);
        } catch (error) {
          if (checkNumberOfExports(module_name) > 3) {
            devlog_error(`error: skipping module ${module_name}`);
            devlog_error("Loader error: " + error);
          }
        }
      }
    }
  }
}
function getModuleNames() {
  var moduleNames6 = [];
  Process.enumerateModules().forEach((item) => moduleNames6.push(item.name));
  return moduleNames6;
}
function checkNumberOfExports(moduleName) {
  try {
    const module = Process.getModuleByName(moduleName);
    const exports = module.enumerateExports();
    const numberOfExports = exports.length;
    devlog(`The module "${moduleName}" has ${numberOfExports} exports.`);
    return numberOfExports;
  } catch (error) {
    devlog(`Error checking exports for module "${moduleName}": ${error}`);
    return -1;
  }
}
function hasMoreThanFiveExports(moduleName) {
  const targetModule = Process.getModuleByName(moduleName);
  if (!targetModule) {
    devlog(`Module ${moduleName} not found`);
    return false;
  }
  try {
    const exports = targetModule.enumerateExports();
    return exports.length > 5;
  } catch (error) {
    devlog(`Error enumerating exports for ${moduleName}:` + error);
    return false;
  }
}
function readAddresses(moduleName, library_method_mapping) {
  const resolver = new ApiResolver("module");
  const addresses = {};
  if (!addresses[moduleName]) {
    addresses[moduleName] = {};
  }
  for (const library_name in library_method_mapping) {
    library_method_mapping[library_name].forEach(function(method2) {
      const matches = resolver.enumerateMatches("exports:" + library_name + "!" + method2);
      let match_number = 0;
      let method_name = method2.toString();
      if (method_name.endsWith("*")) {
        method_name = method_name.substring(0, method_name.length - 1);
      }
      if (!matches || matches === null) {
        devlog(`Unable to retrieve any matches for statement: exports: ${library_name}!${method2}`);
        return;
      }
      if (matches.length == 0) {
        throw "Could not find " + library_name + "!" + method2;
      } else if (matches.length == 1) {
        devlog("Found " + method2 + " " + matches[0].address);
      } else {
        for (let k = 0; k < matches.length; k++) {
          if (matches[k].name.endsWith(method_name)) {
            match_number = k;
            devlog("Found " + method2 + " " + matches[match_number].address);
            break;
          }
        }
      }
      addresses[moduleName][method_name] = matches[match_number].address;
    });
  }
  return addresses;
}
function getBaseAddress(moduleName) {
  devlog("Module to find: " + moduleName);
  const modules = Process.enumerateModules();
  for (const module of modules) {
    if (module.name == moduleName) {
      return module.base;
    }
  }
  return null;
}
function getPortsAndAddresses(sockfd, isRead, methodAddresses, enable_default_fd2) {
  var message = {};
  if (enable_default_fd2 && sockfd < 0) {
    message["src_port"] = 1234;
    message["src_addr"] = "127.0.0.1";
    message["dst_port"] = 2345;
    message["dst_addr"] = "127.0.0.1";
    message["ss_family"] = "AF_INET";
    return message;
  }
  if (unwantedFDs.has(sockfd)) {
    return null;
  }
  var getpeername = new NativeFunction(methodAddresses["getpeername"], "int", ["int", "pointer", "pointer"]);
  var getsockname = new NativeFunction(methodAddresses["getsockname"], "int", ["int", "pointer", "pointer"]);
  var ntohs = new NativeFunction(methodAddresses["ntohs"], "uint16", ["uint16"]);
  var ntohl = new NativeFunction(methodAddresses["ntohl"], "uint32", ["uint32"]);
  var addrlen = Memory.alloc(4);
  var addr = Memory.alloc(128);
  var src_dst = ["src", "dst"];
  for (let i = 0; i < src_dst.length; i++) {
    addrlen.writeU32(128);
    if (src_dst[i] == "src" !== isRead) {
      devlog("src");
      getsockname(sockfd, addr, addrlen);
    } else {
      devlog("dst");
      getpeername(sockfd, addr, addrlen);
    }
    var family = addr.readU16();
    const familyName = AddressFamilyMapping[family] || `UNKNOWN`;
    if (addr.readU16() == AF_INET) {
      message[src_dst[i] + "_port"] = ntohs(addr.add(2).readU16());
      message[src_dst[i] + "_addr"] = ntohl(addr.add(4).readU32());
      message["ss_family"] = "AF_INET";
    } else if (addr.readU16() == AF_INET6) {
      message[src_dst[i] + "_port"] = ntohs(addr.add(2).readU16());
      message[src_dst[i] + "_addr"] = "";
      var ipv6_addr = addr.add(8);
      for (var offset = 0; offset < 16; offset += 1) {
        message[src_dst[i] + "_addr"] += ("0" + ipv6_addr.add(offset).readU8().toString(16).toUpperCase()).substr(-2);
      }
      if (message[src_dst[i] + "_addr"].toString().indexOf("00000000000000000000FFFF") === 0) {
        message[src_dst[i] + "_addr"] = ntohl(ipv6_addr.add(12).readU32());
        message["ss_family"] = "AF_INET";
      } else {
        message["ss_family"] = "AF_INET6";
      }
    } else {
      if (!unwantedFDs.has(sockfd)) {
      }
      unwantedFDs.add(sockfd);
      return null;
    }
  }
  return message;
}
function byteArrayToString(byteArray) {
  return Array.from(byteArray, function(byte) {
    return ("0" + (byte & 255).toString(16)).slice(-2);
  }).join("");
}
function toHexString(byteArray) {
  const byteToHex = [];
  for (let n = 0; n <= 255; ++n) {
    const hexOctet = n.toString(16).padStart(2, "0");
    byteToHex.push(hexOctet);
  }
  return Array.prototype.map.call(new Uint8Array(byteArray), (n) => byteToHex[n]).join("");
}
function reflectionByteArrayToString(byteArray) {
  var result = "";
  var arrayReflect = Java.use("java.lang.reflect.Array");
  for (var i = 0; i < arrayReflect.getLength(byteArray); i++) {
    result += ("0" + (arrayReflect.get(byteArray, i) & 255).toString(16)).slice(-2);
  }
  return result;
}
function byteArrayToNumber(byteArray) {
  var value = 0;
  for (var i = 0; i < byteArray.length; i++) {
    value = value * 256 + (byteArray[i] & 255);
  }
  return value;
}
function getAttribute(Instance, fieldName) {
  var clazz = Java.use("java.lang.Class");
  var field = Java.cast(Instance.getClass(), clazz).getDeclaredField(fieldName);
  field.setAccessible(true);
  return field.get(Instance);
}
function isSymbolAvailable(moduleName, symbolName) {
  const resolver = new ApiResolver("module");
  const matches = resolver.enumerateMatches("exports:" + moduleName + "!" + symbolName);
  if (matches) {
    return matches.length > 0;
  } else {
    return false;
  }
}
function invokeHookingFunction(func) {
  return (moduleName, is_base_hook) => {
    func(moduleName, is_base_hook);
  };
}
function get_hex_string_from_byte_array(keyData) {
  return Array.from(new Uint8Array(keyData)).map((byte) => byte.toString(16).padStart(2, "0").toUpperCase()).join("");
}
function dumpMemory(ptrValue, size) {
  try {
    console.log("[!] dumping memory at address: " + ptrValue);
    var data = ptrValue.readByteArray(size);
    console.log(hexdump(data));
    return data;
  } catch (error) {
    console.log("Error dumping memory at: " + ptrValue + " - " + error);
    console.log("\n");
    return null;
  }
}

// agent/shared/library_identification.ts
function findModulesWithSSLKeyLogCallback() {
  const modules = Process.enumerateModules();
  const matchedModules = [];
  for (const mod of modules) {
    if (/.*libssl_sb\.so/.test(mod.name) || /.*libssl\.so/.test(mod.name) || /ibconscrypt_jni.so/.test(mod.name) || /libconscrypt_gmscore_jni.so/.test(mod.name)) {
      continue;
    }
    const targetModule = Process.getModuleByName(mod.name);
    const exports = targetModule.enumerateExports();
    for (const exp of exports) {
      if (exp.name === "SSL_CTX_set_keylog_callback") {
        matchedModules.push(mod.name);
        break;
      }
    }
  }
  return matchedModules;
}
function createModuleLibraryMappingExtend(matchedModules, hookingFunction) {
  const moduleLibraryMappingExtend = [];
  for (const mod of matchedModules) {
    devlog("[!] Installing BoringSSL hooks for " + mod);
    moduleLibraryMappingExtend.push([
      new RegExp(`.*${mod}`),
      invokeHookingFunction(hookingFunction)
    ]);
  }
  return moduleLibraryMappingExtend;
}

// agent/ssl_lib/gnutls.ts
var GnuTLS = class _GnuTLS {
  moduleName;
  socket_library;
  passed_library_method_mapping;
  // global variables
  library_method_mapping = {};
  addresses;
  module_name;
  static gnutls_transport_get_int;
  static gnutls_session_get_id;
  static gnutls_session_get_random;
  static gnutls_session_set_keylog_function;
  constructor(moduleName, socket_library6, passed_library_method_mapping) {
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.passed_library_method_mapping = passed_library_method_mapping;
    if (typeof passed_library_method_mapping !== "undefined") {
      this.library_method_mapping = passed_library_method_mapping;
    } else {
      this.library_method_mapping[`*${moduleName}*`] = ["gnutls_record_recv", "gnutls_record_send", "gnutls_session_set_keylog_function", "gnutls_transport_get_int", "gnutls_session_get_id", "gnutls_init", "gnutls_handshake", "gnutls_session_get_keylog_function", "gnutls_session_get_random"];
      this.library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    }
    this.addresses = readAddresses(moduleName, this.library_method_mapping);
    this.module_name = moduleName;
    if (offsets != "{OFFSETS}" && offsets.gnutls != null) {
      if (offsets.sockets != null) {
        const socketBaseAddress = getBaseAddress(socket_library6);
        for (const method2 of Object.keys(offsets.sockets)) {
          this.addresses[this.moduleName][`${method2}`] = offsets.sockets[`${method2}`].absolute || socketBaseAddress == null ? ptr(offsets.sockets[`${method2}`].address) : socketBaseAddress.add(ptr(offsets.sockets[`${method2}`].address));
        }
      }
      const libraryBaseAddress = getBaseAddress(moduleName);
      if (libraryBaseAddress == null) {
        log("Unable to find library base address! Given address values will be interpreted as absolute ones!");
      }
      for (const method2 of Object.keys(offsets.gnutls)) {
        this.addresses[this.moduleName][`${method2}`] = offsets.gnutls[`${method2}`].absolute || libraryBaseAddress == null ? ptr(offsets.gnutls[`${method2}`].address) : libraryBaseAddress.add(ptr(offsets.gnutls[`${method2}`].address));
      }
    }
    _GnuTLS.gnutls_transport_get_int = new NativeFunction(this.addresses[this.moduleName]["gnutls_transport_get_int"], "int", ["pointer"]);
    _GnuTLS.gnutls_session_get_id = new NativeFunction(this.addresses[this.moduleName]["gnutls_session_get_id"], "int", ["pointer", "pointer", "pointer"]);
    _GnuTLS.gnutls_session_set_keylog_function = new NativeFunction(this.addresses[this.moduleName]["gnutls_session_set_keylog_function"], "void", ["pointer", "pointer"]);
    _GnuTLS.gnutls_session_get_random = new NativeFunction(this.addresses[this.moduleName]["gnutls_session_get_random"], "pointer", ["pointer", "pointer", "pointer"]);
  }
  //NativeCallback
  static keylog_callback = new NativeCallback(function(session, label, secret) {
    var message = {};
    message["contentType"] = "keylog";
    var secret_len = secret.add(Process.pointerSize).readUInt();
    var secret_str = "";
    var p = secret.readPointer();
    for (var i = 0; i < secret_len; i++) {
      secret_str += ("0" + p.add(i).readU8().toString(16).toUpperCase()).substr(-2);
    }
    var server_random_ptr = Memory.alloc(Process.pointerSize + 4);
    var client_random_ptr = Memory.alloc(Process.pointerSize + 4);
    if (typeof this !== "undefined") {
      _GnuTLS.gnutls_session_get_random(session, client_random_ptr, server_random_ptr);
    } else {
      console.log("[-] Error while installing keylog callback");
    }
    var client_random_str = "";
    var client_random_len = 32;
    p = client_random_ptr.readPointer();
    for (i = 0; i < client_random_len; i++) {
      client_random_str += ("0" + p.add(i).readU8().toString(16).toUpperCase()).substr(-2);
    }
    message["keylog"] = label.readCString() + " " + client_random_str + " " + secret_str;
    send(message);
    return 0;
  }, "int", ["pointer", "pointer", "pointer"]);
  /**
     * Get the session_id of SSL object and return it as a hex string.
     * @param {!NativePointer} ssl A pointer to an SSL object.
     * @return {dict} A string representing the session_id of the SSL object's
     *     SSL_SESSION. For example,
     *     "59FD71B7B90202F359D89E66AE4E61247954E28431F6C6AC46625D472FF76336".
     */
  static getSslSessionId(session) {
    var len_pointer = Memory.alloc(4);
    var err = _GnuTLS.gnutls_session_get_id(session, NULL, len_pointer);
    if (err != 0) {
      if (enable_default_fd) {
        log("using dummy SessionID: 59FD71B7B90202F359D89E66AE4E61247954E28431F6C6AC46625D472FF76337");
        return "59FD71B7B90202F359D89E66AE4E61247954E28431F6C6AC46625D472FF76337";
      }
      return "";
    }
    var len = len_pointer.readU32();
    var p = Memory.alloc(len);
    err = _GnuTLS.gnutls_session_get_id(session, p, len_pointer);
    if (err != 0) {
      if (enable_default_fd) {
        log("using dummy SessionID: 59FD71B7B90202F359D89E66AE4E61247954E28431F6C6AC46625D472FF76337");
        return "59FD71B7B90202F359D89E66AE4E61247954E28431F6C6AC46625D472FF76337";
      }
      return "";
    }
    var session_id = "";
    for (var i = 0; i < len; i++) {
      session_id += ("0" + p.add(i).readU8().toString(16).toUpperCase()).substr(-2);
    }
    return session_id;
  }
  install_plaintext_read_hook() {
    var current_module_name = this.module_name;
    var lib_addesses = this.addresses;
    Interceptor.attach(this.addresses[this.moduleName]["gnutls_record_recv"], {
      onEnter: function(args) {
        var message = getPortsAndAddresses(_GnuTLS.gnutls_transport_get_int(args[0]), true, lib_addesses[current_module_name], enable_default_fd);
        message["ssl_session_id"] = _GnuTLS.getSslSessionId(args[0]);
        message["function"] = "SSL_read";
        this.message = message;
        this.buf = args[1];
      },
      onLeave: function(retval) {
        retval |= 0;
        if (retval <= 0) {
          return;
        }
        this.message["contentType"] = "datalog";
        send(this.message, this.buf.readByteArray(retval));
      }
    });
  }
  install_plaintext_write_hook() {
    var current_module_name = this.module_name;
    var lib_addesses = this.addresses;
    Interceptor.attach(this.addresses[this.moduleName]["gnutls_record_send"], {
      onEnter: function(args) {
        var message = getPortsAndAddresses(_GnuTLS.gnutls_transport_get_int(args[0]), false, lib_addesses[current_module_name], enable_default_fd);
        message["ssl_session_id"] = _GnuTLS.getSslSessionId(args[0]);
        message["function"] = "SSL_write";
        message["contentType"] = "datalog";
        send(message, args[1].readByteArray(parseInt(args[2])));
      },
      onLeave: function(retval) {
      }
    });
  }
  install_tls_keys_callback_hook() {
  }
};

// agent/android/gnutls_android.ts
var GnuTLS_Linux = class extends GnuTLS {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
    this.install_tls_keys_callback_hook();
  }
  install_tls_keys_callback_hook() {
    Interceptor.attach(this.addresses[this.module_name]["gnutls_init"], {
      onEnter: function(args) {
        this.session = args[0];
      },
      onLeave: function(retval) {
        devlog("[!] Logging session information: " + this.session);
        GnuTLS.gnutls_session_set_keylog_function(this.session.readPointer(), GnuTLS.keylog_callback);
      }
    });
  }
};
function gnutls_execute(moduleName, is_base_hook) {
  var gnutls_ssl = new GnuTLS_Linux(moduleName, socket_library, is_base_hook);
  gnutls_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = gnutls_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/ssl_lib/wolfssl.ts
var WolfSSL = class _WolfSSL {
  moduleName;
  socket_library;
  passed_library_method_mapping;
  // global variables
  library_method_mapping = {};
  addresses;
  module_name;
  static wolfSSL_get_server_random;
  static wolfSSL_get_client_random;
  static wolfSSL_get_fd;
  static wolfSSL_get_session;
  static wolfSSL_SESSION_get_master_key;
  constructor(moduleName, socket_library6, passed_library_method_mapping) {
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.passed_library_method_mapping = passed_library_method_mapping;
    if (typeof passed_library_method_mapping !== "undefined") {
      this.library_method_mapping = passed_library_method_mapping;
    } else {
      this.library_method_mapping[`*${moduleName}*`] = ["wolfSSL_read", "wolfSSL_write", "wolfSSL_get_fd", "wolfSSL_get_session", "wolfSSL_connect", "wolfSSL_KeepArrays", "wolfSSL_SESSION_get_master_key", "wolfSSL_get_client_random", "wolfSSL_get_server_random"];
      this.library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    }
    this.addresses = readAddresses(moduleName, this.library_method_mapping);
    this.module_name = moduleName;
    if (offsets != "{OFFSETS}" && offsets.wolfssl != null) {
      if (offsets.sockets != null) {
        const socketBaseAddress = getBaseAddress(socket_library6);
        for (const method2 of Object.keys(offsets.sockets)) {
          this.addresses[this.moduleName][`${method2}`] = offsets.sockets[`${method2}`].absolute || socketBaseAddress == null ? ptr(offsets.sockets[`${method2}`].address) : socketBaseAddress.add(ptr(offsets.sockets[`${method2}`].address));
        }
      }
      const libraryBaseAddress = getBaseAddress(moduleName);
      if (libraryBaseAddress == null) {
        log("Unable to find library base address! Given address values will be interpreted as absolute ones!");
      }
      for (const method2 of Object.keys(offsets.wolfssl)) {
        this.addresses[this.moduleName][`${method2}`] = offsets.wolfssl[`${method2}`].absolute || libraryBaseAddress == null ? ptr(offsets.wolfssl[`${method2}`].address) : libraryBaseAddress.add(ptr(offsets.wolfssl[`${method2}`].address));
      }
    }
    _WolfSSL.wolfSSL_get_fd = new NativeFunction(this.addresses[this.moduleName]["wolfSSL_get_fd"], "int", ["pointer"]);
    _WolfSSL.wolfSSL_get_session = new NativeFunction(this.addresses[this.moduleName]["wolfSSL_get_session"], "pointer", ["pointer"]);
  }
  install_tls_keys_callback_hook() {
    log("Error: TLS key extraction not implemented yet.");
  }
  /**
     * Get the session_id of SSL object and return it as a hex string.
     * @param {!NativePointer} ssl A pointer to an SSL object.
     * @return {dict} A string representing the session_id of the SSL object's
     *     SSL_SESSION. For example,
     *     "59FD71B7B90202F359D89E66AE4E61247954E28431F6C6AC46625D472FF76336".
     */
  static getSslSessionId(ssl) {
    var session = _WolfSSL.wolfSSL_get_session(ssl);
    if (session.isNull()) {
      if (enable_default_fd) {
        log("using dummy SessionID: 59FD71B7B90202F359D89E66AE4E61247954E28431F6C6AC46625D472FF76338");
        return "59FD71B7B90202F359D89E66AE4E61247954E28431F6C6AC46625D472FF76338";
      }
      log("Session is null");
      return 0;
    }
    var p = session.add(8);
    var len = 32;
    var session_id = "";
    for (var i = 0; i < len; i++) {
      session_id += ("0" + p.add(i).readU8().toString(16).toUpperCase()).substr(-2);
    }
    return session_id;
  }
  install_plaintext_read_hook() {
    var current_module_name = this.module_name;
    var lib_addesses = this.addresses;
    Interceptor.attach(this.addresses[this.moduleName]["wolfSSL_read"], {
      onEnter: function(args) {
        var message = getPortsAndAddresses(_WolfSSL.wolfSSL_get_fd(args[0]), true, lib_addesses[current_module_name], enable_default_fd);
        message["function"] = "wolfSSL_read";
        message["ssl_session_id"] = _WolfSSL.getSslSessionId(args[0]);
        this.message = message;
        this.buf = args[1];
      },
      onLeave: function(retval) {
        retval |= 0;
        if (retval <= 0) {
          return;
        }
        this.message["contentType"] = "datalog";
        send(this.message, this.buf.readByteArray(retval));
      }
    });
  }
  install_plaintext_write_hook() {
    var current_module_name = this.module_name;
    var lib_addesses = this.addresses;
    Interceptor.attach(this.addresses[this.moduleName]["wolfSSL_write"], {
      onEnter: function(args) {
        var message = getPortsAndAddresses(_WolfSSL.wolfSSL_get_fd(args[0]), false, lib_addesses[current_module_name], enable_default_fd);
        message["ssl_session_id"] = _WolfSSL.getSslSessionId(args[0]);
        message["function"] = "wolfSSL_write";
        message["contentType"] = "datalog";
        send(message, args[1].readByteArray(parseInt(args[2])));
      },
      onLeave: function(retval) {
      }
    });
  }
};

// agent/android/wolfssl_android.ts
var WolfSSL_Android = class extends WolfSSL {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
    this.install_tls_keys_callback_hook();
  }
  install_tls_keys_callback_hook() {
    WolfSSL.wolfSSL_get_client_random = new NativeFunction(this.addresses[this.module_name]["wolfSSL_get_client_random"], "int", ["pointer", "pointer", "int"]);
    WolfSSL.wolfSSL_get_server_random = new NativeFunction(this.addresses[this.module_name]["wolfSSL_get_server_random"], "int", ["pointer", "pointer", "int"]);
    WolfSSL.wolfSSL_SESSION_get_master_key = new NativeFunction(this.addresses[this.module_name]["wolfSSL_SESSION_get_master_key"], "int", ["pointer", "pointer", "int"]);
    Interceptor.attach(this.addresses[this.module_name]["wolfSSL_connect"], {
      onEnter: function(args) {
        this.ssl = args[0];
      },
      onLeave: function(retval) {
        this.session = WolfSSL.wolfSSL_get_session(this.ssl);
        var keysString = "";
        var requiredClientRandomLength = WolfSSL.wolfSSL_get_client_random(this.session, NULL, 0);
        var clientBuffer = Memory.alloc(requiredClientRandomLength);
        WolfSSL.wolfSSL_get_client_random(this.ssl, clientBuffer, requiredClientRandomLength);
        var clientBytes = clientBuffer.readByteArray(requiredClientRandomLength);
        keysString = `${keysString}CLIENT_RANDOM: ${toHexString(clientBytes)}
`;
        var requiredServerRandomLength = WolfSSL.wolfSSL_get_server_random(this.session, NULL, 0);
        var serverBuffer = Memory.alloc(requiredServerRandomLength);
        WolfSSL.wolfSSL_get_server_random(this.ssl, serverBuffer, requiredServerRandomLength);
        var serverBytes = serverBuffer.readByteArray(requiredServerRandomLength);
        keysString = `${keysString}SERVER_RANDOM: ${toHexString(serverBytes)}
`;
        var requiredMasterKeyLength = WolfSSL.wolfSSL_SESSION_get_master_key(this.session, NULL, 0);
        var masterBuffer = Memory.alloc(requiredMasterKeyLength);
        WolfSSL.wolfSSL_SESSION_get_master_key(this.session, masterBuffer, requiredMasterKeyLength);
        var masterBytes = masterBuffer.readByteArray(requiredMasterKeyLength);
        keysString = `${keysString}MASTER_KEY: ${toHexString(masterBytes)}
`;
        var message = {};
        message["contentType"] = "keylog";
        message["keylog"] = keysString;
        send(message);
      }
    });
  }
};
function wolfssl_execute(moduleName, is_base_hook) {
  var wolf_ssl = new WolfSSL_Android(moduleName, socket_library, is_base_hook);
  wolf_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = wolf_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/ssl_lib/nss.ts
var { readU32: readU322, readU64, readPointer: readPointer2, writeU32: writeU322, writeU64, writePointer: writePointer2 } = NativePointer.prototype;
var SECStatus;
(function(SECStatus2) {
  SECStatus2[SECStatus2["SECWouldBlock"] = -2] = "SECWouldBlock";
  SECStatus2[SECStatus2["SECFailure"] = -1] = "SECFailure";
  SECStatus2[SECStatus2["SECSuccess"] = 0] = "SECSuccess";
})(SECStatus || (SECStatus = {}));
var PRDescType;
(function(PRDescType2) {
  PRDescType2[PRDescType2["PR_DESC_FILE"] = 1] = "PR_DESC_FILE";
  PRDescType2[PRDescType2["PR_DESC_SOCKET_TCP"] = 2] = "PR_DESC_SOCKET_TCP";
  PRDescType2[PRDescType2["PR_DESC_SOCKET_UDP"] = 3] = "PR_DESC_SOCKET_UDP";
  PRDescType2[PRDescType2["PR_DESC_LAYERED"] = 4] = "PR_DESC_LAYERED";
  PRDescType2[PRDescType2["PR_DESC_PIPE"] = 5] = "PR_DESC_PIPE";
})(PRDescType || (PRDescType = {}));
var NSS = class _NSS {
  moduleName;
  socket_library;
  passed_library_method_mapping;
  // global definitions
  static doTLS13_RTT0 = -1;
  static SSL3_RANDOM_LENGTH = 32;
  // global variables
  library_method_mapping = {};
  addresses;
  module_name;
  static SSL_SESSION_get_id;
  static getsockname;
  static getpeername;
  static getDescType;
  static PR_GetNameForIdentity;
  static get_SSL_Callback;
  static PK11_ExtractKeyValue;
  static PK11_GetKeyData;
  static SS3_VERSIONS_OFFSET;
  // an offset in the SS3.HS strucht which changes on different NSS versions
  static SS3_VERSIONS_CR_OFFSET;
  constructor(moduleName, socket_library6, passed_library_method_mapping) {
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.passed_library_method_mapping = passed_library_method_mapping;
    if (typeof passed_library_method_mapping !== "undefined") {
      this.library_method_mapping = passed_library_method_mapping;
    } else {
      this.library_method_mapping[`*${moduleName}*`] = ["PR_Write", "PR_Read", "PR_FileDesc2NativeHandle", "PR_GetPeerName", "PR_GetSockName", "PR_GetNameForIdentity", "PR_GetDescType"];
      this.library_method_mapping[`*libnss.*`] = ["PK11_ExtractKeyValue", "PK11_GetKeyData"];
      this.library_method_mapping["*libssl*.so"] = ["SSL_ImportFD", "SSL_GetSessionID", "SSL_HandshakeCallback"];
      this.library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    }
    this.addresses = readAddresses(moduleName, this.library_method_mapping);
    this.module_name = moduleName;
    if (offsets != "{OFFSETS}" && offsets.nss != null) {
      if (offsets.sockets != null) {
        const socketBaseAddress = getBaseAddress(socket_library6);
        for (const method2 of Object.keys(offsets.sockets)) {
          this.addresses[this.moduleName][`${method2}`] = offsets.sockets[`${method2}`].absolute || socketBaseAddress == null ? ptr(offsets.sockets[`${method2}`].address) : socketBaseAddress.add(ptr(offsets.sockets[`${method2}`].address));
        }
      }
      const libraryBaseAddress = getBaseAddress(moduleName);
      if (libraryBaseAddress == null) {
        log("Unable to find library base address! Given address values will be interpreted as absolute ones!");
      }
      for (const method2 of Object.keys(offsets.nss)) {
        this.addresses[this.moduleName][`${method2}`] = offsets.nss[`${method2}`].absolute || libraryBaseAddress == null ? ptr(offsets.nss[`${method2}`].address) : libraryBaseAddress.add(ptr(offsets.nss[`${method2}`].address));
      }
    }
    if (!Java.available) {
      _NSS.SSL_SESSION_get_id = new NativeFunction(this.addresses[this.moduleName]["SSL_GetSessionID"], "pointer", ["pointer"]);
    }
    _NSS.getsockname = new NativeFunction(this.addresses[this.moduleName]["PR_GetSockName"], "int", ["pointer", "pointer"]);
    _NSS.getpeername = new NativeFunction(this.addresses[this.moduleName]["PR_GetPeerName"], "int", ["pointer", "pointer"]);
  }
  static get_NSS_version() {
    var getNSSversion = null;
    var version_string = "0";
    if (!Java.available) {
      getNSSversion = new NativeFunction(Module.getGlobalExportByName("NSSSSL_GetVersion"), "pointer", []);
    } else {
      getNSSversion = new NativeFunction(Process.getModuleByName("libnss3.so").getExportByName("NSSSSL_GetVersion"), "pointer", []);
    }
    if (!getNSSversion.isNull()) {
      var ptr_version_string = getNSSversion();
      if (!ptr_version_string.isNull()) {
        version_string = ptr_version_string.readCString();
      }
    }
    var match = version_string.match(/^(\d+)\.(\d+)/);
    if (!match) {
      return 0;
    }
    var major = parseInt(match[1], 10);
    var minor = parseInt(match[2], 10);
    return major * 1e3 + minor;
  }
  /* PARSING functions */
  static parse_struct_SECItem(secitem) {
    return {
      "type": secitem.readU64(),
      "data": secitem.add(pointerSize2).readPointer(),
      "len": secitem.add(pointerSize2 * 2).readU32()
    };
  }
  // https://github.com/nss-dev/nss/blob/master/lib/ssl/sslimpl.h#L971
  static parse_struct_sslSocketStr(sslSocketFD) {
    return {
      "fd": sslSocketFD.readPointer(),
      "version": sslSocketFD.add(160),
      "handshakeCallback": sslSocketFD.add(464),
      "secretCallback": sslSocketFD.add(568),
      "ssl3": sslSocketFD.add(1432)
    };
  }
  // https://github.com/nss-dev/nss/blob/master/lib/ssl/sslimpl.h#L771
  static parse_struct_ssl3Str(ssl3_struct) {
    _NSS.SS3_VERSIONS_OFFSET = 0;
    _NSS.SS3_VERSIONS_CR_OFFSET = 0;
    var nss_version = _NSS.get_NSS_version();
    if (nss_version >= 3107) {
      devlog("setting offsets for NSS version " + nss_version);
      _NSS.SS3_VERSIONS_OFFSET = 96;
      _NSS.SS3_VERSIONS_CR_OFFSET = 8;
    }
    return {
      "crSpec": ssl3_struct.readPointer(),
      "prSpec": ssl3_struct.add(pointerSize2).readPointer(),
      "cwSpec": ssl3_struct.add(pointerSize2 * 2).readPointer(),
      "pwSpec": ssl3_struct.add(pointerSize2 * 3).readPointer(),
      "peerRequestedKeyUpdate": ssl3_struct.add(pointerSize2 * 4).readU32(),
      "keyUpdateDeferred": ssl3_struct.add(pointerSize2 * 4 + 4).readU32(),
      "deferredKeyUpdateRequest": ssl3_struct.add(pointerSize2 * 4 + 8).readU32(),
      "clientCertRequested": ssl3_struct.add(pointerSize2 * 4 + 12).readU32(),
      "clientCertificate": ssl3_struct.add(pointerSize2 * 4 + 16).readPointer(),
      "clientPrivateKey": ssl3_struct.add(pointerSize2 * 5 + 16).readPointer(),
      "clientCertChain": ssl3_struct.add(pointerSize2 * 6 + 16).readPointer(),
      "sendEmptyCert": ssl3_struct.add(pointerSize2 * 7 + 16).readU32(),
      "policy": ssl3_struct.add(pointerSize2 * 7 + 20).readU32(),
      "peerCertArena": ssl3_struct.add(pointerSize2 * 7 + 24).readPointer(),
      "peerCertChain": ssl3_struct.add(pointerSize2 * 8 + 24).readPointer(),
      "ca_list": ssl3_struct.add(pointerSize2 * 9 + 24).readPointer(),
      "hs": {
        "server_random": ssl3_struct.add(pointerSize2 * 10 + 24 + _NSS.SS3_VERSIONS_CR_OFFSET),
        //SSL3Random --> typedef PRUint8 SSL3Random[SSL3_RANDOM_LENGTH];
        "client_random": ssl3_struct.add(pointerSize2 * 10 + 56 + _NSS.SS3_VERSIONS_CR_OFFSET),
        "client_inner_random": ssl3_struct.add(pointerSize2 * 10 + 88 + _NSS.SS3_VERSIONS_CR_OFFSET),
        "ws": ssl3_struct.add(pointerSize2 * 10 + 120 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "hashType": ssl3_struct.add(pointerSize2 * 10 + 124 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "messages": {
          "data": ssl3_struct.add(pointerSize2 * 10 + 128 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
          "len": ssl3_struct.add(pointerSize2 * 11 + 128 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
          "space": ssl3_struct.add(pointerSize2 * 11 + 132 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
          "fixed": ssl3_struct.add(pointerSize2 * 11 + 136 + _NSS.SS3_VERSIONS_OFFSET).readU32()
        },
        "echInnerMessages": {
          "data": ssl3_struct.add(pointerSize2 * 11 + 140 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
          "len": ssl3_struct.add(pointerSize2 * 12 + 140 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
          "space": ssl3_struct.add(pointerSize2 * 12 + 144 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
          "fixed": ssl3_struct.add(pointerSize2 * 12 + 148 + _NSS.SS3_VERSIONS_OFFSET).readU32()
        },
        "md5": ssl3_struct.add(pointerSize2 * 12 + 152 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "sha": ssl3_struct.add(pointerSize2 * 13 + 152 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "shaEchInner": ssl3_struct.add(pointerSize2 * 14 + 152 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "shaPostHandshake": ssl3_struct.add(pointerSize2 * 15 + 152 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "signatureScheme": ssl3_struct.add(pointerSize2 * 16 + 152 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "kea_def": ssl3_struct.add(pointerSize2 * 16 + 156 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "cipher_suite": ssl3_struct.add(pointerSize2 * 17 + 156 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "suite_def": ssl3_struct.add(pointerSize2 * 17 + 160 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "msg_body": {
          "data": ssl3_struct.add(pointerSize2 * 18 + 160 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
          "len": ssl3_struct.add(pointerSize2 * 19 + 160 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
          "space": ssl3_struct.add(pointerSize2 * 19 + 164 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
          "fixed": ssl3_struct.add(pointerSize2 * 19 + 168 + _NSS.SS3_VERSIONS_OFFSET).readU32()
        },
        "header_bytes": ssl3_struct.add(pointerSize2 * 19 + 172 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "msg_type": ssl3_struct.add(pointerSize2 * 19 + 176 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "msg_len": ssl3_struct.add(pointerSize2 * 19 + 180 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "isResuming": ssl3_struct.add(pointerSize2 * 19 + 184 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "sendingSCSV": ssl3_struct.add(pointerSize2 * 19 + 188 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "receivedNewSessionTicket": ssl3_struct.add(pointerSize2 * 19 + 192 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "newSessionTicket": ssl3_struct.add(pointerSize2 * 19 + 196 + _NSS.SS3_VERSIONS_OFFSET),
        // for now we calculate only its offset (44 bytes); detailes at https://github.com/nss-dev/nss/blob/master/lib/ssl/ssl3prot.h#L162
        "finishedBytes": ssl3_struct.add(pointerSize2 * 19 + 240 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "finishedMsgs": ssl3_struct.add(pointerSize2 * 19 + 244 + _NSS.SS3_VERSIONS_OFFSET),
        "authCertificatePending": ssl3_struct.add(pointerSize2 * 18 + 316 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "restartTarget": ssl3_struct.add(pointerSize2 * 19 + 320 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "canFalseStart": ssl3_struct.add(pointerSize2 * 19 + 324 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "preliminaryInfo": ssl3_struct.add(pointerSize2 * 19 + 328 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "remoteExtensions": {
          "next": ssl3_struct.add(pointerSize2 * 19 + 332 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
          "prev": ssl3_struct.add(pointerSize2 * 20 + 332 + _NSS.SS3_VERSIONS_OFFSET).readPointer()
        },
        "echOuterExtensions": {
          "next": ssl3_struct.add(pointerSize2 * 21 + 332 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
          "prev": ssl3_struct.add(pointerSize2 * 22 + 332 + _NSS.SS3_VERSIONS_OFFSET).readPointer()
        },
        "sendMessageSeq": ssl3_struct.add(pointerSize2 * 23 + 332 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        //u16 but through alignment  U32
        "lastMessageFlight": {
          "next": ssl3_struct.add(pointerSize2 * 23 + 336 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
          "prev": ssl3_struct.add(pointerSize2 * 24 + 336 + _NSS.SS3_VERSIONS_OFFSET).readPointer()
        },
        "maxMessageSent": ssl3_struct.add(pointerSize2 * 25 + 336 + _NSS.SS3_VERSIONS_OFFSET).readU16(),
        //u16
        "recvMessageSeq": ssl3_struct.add(pointerSize2 * 25 + 338 + _NSS.SS3_VERSIONS_OFFSET).readU16(),
        "recvdFragments": {
          "data": ssl3_struct.add(pointerSize2 * 25 + 340 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
          "len": ssl3_struct.add(pointerSize2 * 26 + 340 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
          "space": ssl3_struct.add(pointerSize2 * 26 + 344 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
          "fixed": ssl3_struct.add(pointerSize2 * 26 + 348 + _NSS.SS3_VERSIONS_OFFSET).readU32()
        },
        "recvdHighWater": ssl3_struct.add(pointerSize2 * 26 + 352 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "cookie": {
          "type": ssl3_struct.add(pointerSize2 * 26 + 356 + _NSS.SS3_VERSIONS_OFFSET).readU64(),
          "data": ssl3_struct.add(pointerSize2 * 27 + 356 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
          "len": ssl3_struct.add(pointerSize2 * 28 + 356 + _NSS.SS3_VERSIONS_OFFSET).readU32()
        },
        "times_array": ssl3_struct.add(pointerSize2 * 28 + 360 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "rtTimer": ssl3_struct.add(pointerSize2 * 28 + 432 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "ackTimer": ssl3_struct.add(pointerSize2 * 29 + 432 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "hdTimer": ssl3_struct.add(pointerSize2 * 30 + 432 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "rtRetries": ssl3_struct.add(pointerSize2 * 31 + 432 + _NSS.SS3_VERSIONS_OFFSET).readU32(),
        "srvVirtName": {
          "type": ssl3_struct.add(pointerSize2 * 31 + 436 + _NSS.SS3_VERSIONS_OFFSET).readU64(),
          "data": ssl3_struct.add(pointerSize2 * 32 + 436 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
          "len": ssl3_struct.add(pointerSize2 * 33 + 436 + _NSS.SS3_VERSIONS_OFFSET).readU32()
        },
        "currentSecret": ssl3_struct.add(pointerSize2 * 33 + 440 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "resumptionMasterSecret": ssl3_struct.add(pointerSize2 * 34 + 440 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "dheSecret": ssl3_struct.add(pointerSize2 * 35 + 440 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "clientEarlyTrafficSecret": ssl3_struct.add(pointerSize2 * 36 + 440 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "clientHsTrafficSecret": ssl3_struct.add(pointerSize2 * 37 + 440 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "serverHsTrafficSecret": ssl3_struct.add(pointerSize2 * 38 + 440 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "clientTrafficSecret": ssl3_struct.add(pointerSize2 * 39 + 440 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "serverTrafficSecret": ssl3_struct.add(pointerSize2 * 40 + 440 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "earlyExporterSecret": ssl3_struct.add(pointerSize2 * 41 + 440 + _NSS.SS3_VERSIONS_OFFSET).readPointer(),
        "exporterSecret": ssl3_struct.add(pointerSize2 * 42 + 440 + _NSS.SS3_VERSIONS_OFFSET).readPointer()
      }
      // end of hs struct
      /*
              typedef struct SSL3HandshakeStateStr {
          SSL3Random server_random;
          SSL3Random client_random;
          SSL3Random client_inner_random;
          SSL3WaitState ws;                       --> enum type
      
          
          SSL3HandshakeHashType hashType;         --> enum type
          sslBuffer messages;                     --> struct of 20 bytes (1 ptr + 12 bytes;see lib/ssl/sslencode.h)
          sslBuffer echInnerMessages;
          
          PK11Context *md5;
          PK11Context *sha;
          PK11Context *shaEchInner;
          PK11Context *shaPostHandshake;
          SSLSignatureScheme signatureScheme;     --> enum type( see lib/ssl/sslt.h)
          const ssl3KEADef *kea_def;
          ssl3CipherSuite cipher_suite;           --> typedef PRUint16 ssl3CipherSuite (see lib/ssl/ssl3prot.h)
          const ssl3CipherSuiteDef *suite_def;
          sslBuffer msg_body;
                              
          unsigned int header_bytes;
          
          SSLHandshakeType msg_type;
          unsigned long msg_len;
          PRBool isResuming;
          PRBool sendingSCSV;
      
          
          PRBool receivedNewSessionTicket;
          NewSessionTicket newSessionTicket;      --> (see lib/ssl/ssl3prot.h)
      
          PRUint16 finishedBytes;
          union {
              TLSFinished tFinished[2];           --> 12 bytes
              SSL3Finished sFinished[2];          --> 36 bytes
              PRUint8 data[72];
          } finishedMsgs;                         --> 72
      
          PRBool authCertificatePending;
          
          sslRestartTarget restartTarget;
      
          PRBool canFalseStart;
          
          PRUint32 preliminaryInfo;
      
          
          PRCList remoteExtensions;
          PRCList echOuterExtensions;
      
          
          PRUint16 sendMessageSeq;
          PRCList lastMessageFlight;
          PRUint16 maxMessageSent;
          PRUint16 recvMessageSeq;
          sslBuffer recvdFragments;
          PRInt32 recvdHighWater;
          SECItem cookie;
          dtlsTimer timers[3];       24 * 3
          dtlsTimer *rtTimer;
          dtlsTimer *ackTimer;
          dtlsTimer *hdTimer;
          PRUint32 rtRetries;
          SECItem srvVirtName;
                                          
      
          // This group of values is used for TLS 1.3 and above
          PK11SymKey *currentSecret;            // The secret down the "left hand side"   --> ssl3_struct.add(704)
                                                  //of the TLS 1.3 key schedule.
          PK11SymKey *resumptionMasterSecret;   // The resumption_master_secret.          --> ssl3_struct.add(712)
          PK11SymKey *dheSecret;                // The (EC)DHE shared secret.             --> ssl3_struct.add(720)
          PK11SymKey *clientEarlyTrafficSecret; // The secret we use for 0-RTT.           --> ssl3_struct.add(728)
          PK11SymKey *clientHsTrafficSecret;    // The source keys for handshake          --> ssl3_struct.add(736)
          PK11SymKey *serverHsTrafficSecret;    // traffic keys.                          --> ssl3_struct.add(744)
          PK11SymKey *clientTrafficSecret;      // The source keys for application        --> ssl3_struct.add(752)
          PK11SymKey *serverTrafficSecret;      // traffic keys                           --> ssl3_struct.add(760)
          PK11SymKey *earlyExporterSecret;      // for 0-RTT exporters                    --> ssl3_struct.add(768)
          PK11SymKey *exporterSecret;           // for exporters                          --> ssl3_struct.add(776)
          ...
      
      
          typedef struct {
          const char *label; 8
          DTLSTimerCb cb; 8
          PRIntervalTime started; 4
          PRUint32 timeout; 4
      } dtlsTimer;
      
              */
    };
  }
  // https://github.com/nss-dev/nss/blob/master/lib/ssl/sslspec.h#L140 
  static parse_struct_sl3CipherSpecStr(cwSpec) {
    return {
      "link": cwSpec.add,
      "refCt": cwSpec.add(pointerSize2 * 2),
      "direction": cwSpec.add(pointerSize2 * 2 + 4),
      "version": cwSpec.add(pointerSize2 * 2 + 8),
      "recordVersion": cwSpec.add(pointerSize2 * 2 + 12),
      "cipherDef": cwSpec.add(pointerSize2 * 2 + 16).readPointer(),
      "macDef": cwSpec.add(pointerSize2 * 3 + 16).readPointer(),
      "cipher": cwSpec.add(pointerSize2 * 4 + 16),
      "cipherContext": cwSpec.add(pointerSize2 * 4 + 24).readPointer(),
      "master_secret": cwSpec.add(pointerSize2 * 5 + 24).readPointer()
    };
  }
  /********* NSS Callbacks ************/
  /*
  This callback gets called whenever a SSL Handshake completed
  
  typedef void (*SSLHandshakeCallback)(
          PRFileDesc *fd,
          void *client_data);
  */
  static keylog_callback = new NativeCallback(function(sslSocketFD, client_data) {
    if (typeof this !== "undefined") {
      _NSS.ssl_RecordKeyLog(sslSocketFD);
    } else {
      console.log("[-] Error while installing ssl_RecordKeyLog() callback");
    }
    return 0;
  }, "void", ["pointer", "pointer"]);
  /**
   * SSL_SetSecretCallback installs a callback that TLS calls when it installs new
   * traffic secrets.
   *
   *
   *
   * SSLSecretCallback is called with the current epoch and the corresponding
   * secret; this matches the epoch used in DTLS 1.3, even if the socket is
   * operating in stream mode:
   *
   * - client_early_traffic_secret corresponds to epoch 1
   * - {client|server}_handshake_traffic_secret is epoch 2
   * - {client|server}_application_traffic_secret_{N} is epoch 3+N
   *
   * The callback is invoked separately for read secrets (client secrets on the
   * server; server secrets on the client), and write secrets.
   *
   * This callback is only called if (D)TLS 1.3 is negotiated.
   *
   * typedef void(PR_CALLBACK *SSLSecretCallback)(
   *   PRFileDesc *fd, PRUint16 epoch, SSLSecretDirection dir, PK11SymKey *secret,
   *   void *arg);
   *
   *  More: https://github.com/nss-dev/nss/blob/master/lib/ssl/sslexp.h#L614
   *
   */
  static secret_callback = new NativeCallback(function(sslSocketFD, epoch, dir, secret, arg_ptr) {
    if (typeof this !== "undefined") {
      _NSS.parse_epoch_value_from_SSL_SetSecretCallback(sslSocketFD, epoch);
    } else {
      console.log("[-] Error while installing parse_epoch_value_from_SSL_SetSecretCallback()");
    }
    return;
  }, "void", ["pointer", "uint16", "uint16", "pointer", "pointer"]);
  /********* NSS helper functions  ********/
  /**
      * Returns a dictionary of a sockfd's "src_addr", "src_port", "dst_addr", and
      * "dst_port".
      * @param {pointer} sockfd The file descriptor of the socket to inspect as PRFileDesc.
      * @param {boolean} isRead If true, the context is an SSL_read call. If
      *     false, the context is an SSL_write call.
      * @param {{ [key: string]: NativePointer}} methodAddresses Dictionary containing (at least) addresses for getpeername, getsockname, ntohs and ntohl
      * @return {{ [key: string]: string | number }} Dictionary of sockfd's "src_addr", "src_port", "dst_addr",
      *     and "dst_port".
  
    PRStatus PR_GetPeerName(
      PRFileDesc *fd,
      PRNetAddr *addr);
  
      PRStatus PR_GetSockName(
      PRFileDesc *fd,
      PRNetAddr *addr);
  
      PRStatus PR_NetAddrToString(
      const PRNetAddr *addr,
      char *string,
      PRUint32 size);
  
  
      union PRNetAddr {
      struct {
     PRUint16 family;
     char data[14];
      } raw;
      struct {
     PRUint16 family;
     PRUint16 port;
     PRUint32 ip;
     char pad[8];
      } inet;
      #if defined(_PR_INET6)
      struct {
     PRUint16 family;
     PRUint16 port;
     PRUint32 flowinfo;
     PRIPv6Addr ip;
      } ipv6;
      #endif // defined(_PR_INET6)
      };
  
      typedef union PRNetAddr PRNetAddr;
  
      */
  static getPortsAndAddressesFromNSS(sockfd, isRead, methodAddresses, enable_default_fd2) {
    var message = {};
    if (enable_default_fd2 && sockfd === null) {
      message["src_port"] = 1234;
      message["src_addr"] = "127.0.0.1";
      message["dst_port"] = 2345;
      message["dst_addr"] = "127.0.0.1";
      message["ss_family"] = "AF_INET";
      return message;
    }
    var getpeername = new NativeFunction(methodAddresses["PR_GetPeerName"], "int", ["pointer", "pointer"]);
    var getsockname = new NativeFunction(methodAddresses["PR_GetSockName"], "int", ["pointer", "pointer"]);
    var ntohs = new NativeFunction(methodAddresses["ntohs"], "uint16", ["uint16"]);
    var ntohl = new NativeFunction(methodAddresses["ntohl"], "uint32", ["uint32"]);
    var addrType = Memory.alloc(2);
    var addrlen = Memory.alloc(4);
    var addr = Memory.alloc(128);
    var src_dst = ["src", "dst"];
    for (var i = 0; i < src_dst.length; i++) {
      addrlen.writeU32(128);
      if (src_dst[i] == "src" !== isRead) {
        getsockname(sockfd, addr);
      } else {
        getpeername(sockfd, addr);
      }
      if (addr.readU16() == AF_INET) {
        message[src_dst[i] + "_port"] = ntohs(addr.add(2).readU16());
        message[src_dst[i] + "_addr"] = ntohl(addr.add(4).readU32());
        message["ss_family"] = "AF_INET";
      } else if (addr.readU16() == AF_INET6) {
        message[src_dst[i] + "_port"] = ntohs(addr.add(2).readU16());
        message[src_dst[i] + "_addr"] = "";
        var ipv6_addr = addr.add(8);
        for (var offset = 0; offset < 16; offset += 1) {
          message[src_dst[i] + "_addr"] += ("0" + ipv6_addr.add(offset).readU8().toString(16).toUpperCase()).substr(-2);
        }
        if (message[src_dst[i] + "_addr"].toString().indexOf("00000000000000000000FFFF") === 0) {
          message[src_dst[i] + "_addr"] = ntohl(ipv6_addr.add(12).readU32());
          message["ss_family"] = "AF_INET";
        } else {
          message["ss_family"] = "AF_INET6";
        }
      } else {
        devlog("[-] PIPE descriptor error: Only supporting IPv4/6: " + addr.readU16());
        throw "Only supporting IPv4/6";
      }
    }
    return message;
  }
  /**
  * This functions tests if a given address is a readable pointer
  *
  * @param {*} ptr_addr is a pointer to the memory location where we want to check if there is already an address
  * @returns 1 to indicate that there is a ptr at
  */
  static is_ptr_at_mem_location(ptr_addr) {
    try {
      ptr_addr.readPointer();
      return 1;
    } catch (error) {
      return -1;
    }
  }
  /**
  *
  * typedef struct PRFileDesc {
  *       const struct PRIOMethods *methods;
  *       PRFilePrivate *secret;
  *       PRFileDesc *lower;
  *       PRFileDesc *higher;
  *       void (*dtor) (PRFileDesc *);
  *       PRDescIdentity identity;
  *  } PRFileDesc;
  *
  * @param {*} pRFileDesc
  * @param {*} layer_name
  * @returns
  */
  static NSS_FindIdentityForName(pRFileDesc, layer_name) {
    var lower_ptr = pRFileDesc.add(pointerSize2 * 2).readPointer();
    var higher_ptr = pRFileDesc.add(pointerSize2 * 3).readPointer();
    var identity2 = pRFileDesc.add(pointerSize2 * 5).readPointer();
    if (!identity2.isNull()) {
      var nameptr = _NSS.PR_GetNameForIdentity(identity2).readCString();
      if (nameptr == layer_name) {
        return pRFileDesc;
      }
    }
    if (!lower_ptr.isNull()) {
      return this.NSS_FindIdentityForName(lower_ptr, layer_name);
    }
    if (!higher_ptr.isNull()) {
      devlog("Have upper");
    }
    devlog("[-] error while getting SSL layer");
    return NULL;
  }
  static getSessionIdString(session_id_ptr, len) {
    var session_id = "";
    for (var i = 0; i < len; i++) {
      session_id += ("0" + session_id_ptr.add(i).readU8().toString(16).toUpperCase()).substr(-2);
    }
    return session_id;
  }
  static getSSL_Layer(pRFileDesc) {
    var ssl_layer_id = 3;
    var getIdentitiesLayer = new NativeFunction(Process.getModuleByName("libnspr4.so").getExportByName("PR_GetIdentitiesLayer"), "pointer", ["pointer", "int"]);
    var ssl_layer = getIdentitiesLayer(pRFileDesc, ssl_layer_id);
    if (ptr(ssl_layer.toString()).isNull()) {
      devlog("PR_BAD_DESCRIPTOR_ERROR: " + ssl_layer);
      return -1;
    }
    return ssl_layer;
  }
  /**
  *
  * @param {*} readAddr is the address where we start reading the bytes
  * @param {*} len is the length of bytes we want to convert to a hex string
  * @returns a hex string with the length of len
  */
  static getHexString(readAddr, len) {
    var secret_str = "";
    for (var i = 0; i < len; i++) {
      secret_str += ("0" + readAddr.add(i).readU8().toString(16).toLowerCase()).substr(-2);
    }
    return secret_str;
  }
  /**
  * Get the session_id of SSL object and return it as a hex string.
  * @param {!NativePointer} ssl A pointer to an SSL object.
  * @return {dict} A string representing the session_id of the SSL object's
  *     SSL_SESSION. For example,
  *     "59FD71B7B90202F359D89E66AE4E61247954E28431F6C6AC46625D472FF76336".
  *
  * On NSS the return type of SSL_GetSessionID is a SECItem:
       typedef enum {
  * siBuffer = 0,
  * siClearDataBuffer = 1,
  * siCipherDataBuffer = 2,
  * siDERCertBuffer = 3,
  * siEncodedCertBuffer = 4,
  * siDERNameBuffer = 5,
  * siEncodedNameBuffer = 6,
  * siAsciiNameString = 7,
  * siAsciiString = 8,
  * siDEROID = 9,
  * siUnsignedInteger = 10,
  * siUTCTime = 11,
  * siGeneralizedTime = 12,
  * siVisibleString = 13,
  * siUTF8String = 14,
  * siBMPString = 15
  * } SECItemType;
  *
  * typedef struct SECItemStr SECItem;
  *
  * struct SECItemStr {
  * SECItemType type;
  * unsigned char *data;
  * unsigned int len;
  * }; --> size = 20
  *
  *
  */
  static getSslSessionIdFromFD(pRFileDesc) {
    var dummySSL_SessionID = "3E8ABF58649A1A1C58824D704173BA9AAFA2DA33B45FFEA341D218B29BBACF8F";
    var fdType = _NSS.getDescType(pRFileDesc);
    var layer = _NSS.NSS_FindIdentityForName(pRFileDesc, "SSL");
    if (!layer || Java.available) {
      return dummySSL_SessionID;
    }
    var sslSessionIdSECItem = ptr(_NSS.SSL_SESSION_get_id(layer).toString());
    if (sslSessionIdSECItem == null || sslSessionIdSECItem.isNull()) {
      try {
        devlog("---- getSslSessionIdFromFD -----");
        devlog("ERROR");
        devlog("pRFileDescType: " + _NSS.getDescType(pRFileDesc));
        if (fdType == 2) {
          var c = Memory.dup(pRFileDesc, 32);
          var getLayersIdentity = null;
          var getNameOfIdentityLayer;
          try {
            getLayersIdentity = new NativeFunction(Process.getModuleByName("libnspr4.so").getExportByName("PR_GetLayersIdentity"), "uint32", ["pointer"]);
            getNameOfIdentityLayer = new NativeFunction(Process.getModuleByName("libnspr4.so").getExportByName("PR_GetNameForIdentity"), "pointer", ["uint32"]);
          } catch (e) {
            getLayersIdentity = new NativeFunction(Process.getModuleByName("libnss3.so").getExportByName("PR_GetLayersIdentity"), "uint32", ["pointer"]);
            getNameOfIdentityLayer = new NativeFunction(Process.getModuleByName("libnss3.so").getExportByName("PR_GetNameForIdentity"), "pointer", ["uint32"]);
          }
          var layerID = getLayersIdentity(pRFileDesc);
          devlog("LayerID: " + layerID);
          var nameIDentity = getNameOfIdentityLayer(layerID);
          devlog("name address: " + nameIDentity);
          devlog("name: " + ptr(nameIDentity.toString()).readCString());
          var sslSessionIdSECItem2 = ptr(_NSS.getSSL_Layer(pRFileDesc).toString());
          devlog("sslSessionIdSECItem2 =" + sslSessionIdSECItem2);
          if (sslSessionIdSECItem2.toString().startsWith("0x7f")) {
            var aa = Memory.dup(sslSessionIdSECItem2, 32);
            var sslSessionIdSECItem3 = ptr(_NSS.SSL_SESSION_get_id(sslSessionIdSECItem2).toString());
            devlog("sslSessionIdSECItem3 =" + sslSessionIdSECItem3);
          }
          var sslSessionIdSECItem4 = ptr(_NSS.SSL_SESSION_get_id(pRFileDesc).toString());
          devlog("sslSessionIdSECItem4 =" + sslSessionIdSECItem4);
          devlog("Using Dummy Session ID");
          devlog("");
        } else if (fdType == 4) {
          pRFileDesc = ptr(_NSS.getSSL_Layer(pRFileDesc).toString());
          var sslSessionIdSECItem = ptr(_NSS.SSL_SESSION_get_id(pRFileDesc).toString());
          devlog("new sessionid_ITEM: " + sslSessionIdSECItem);
        } else {
          devlog("---- SSL Session Analysis ------------");
          var c = Memory.dup(sslSessionIdSECItem, 32);
          devlog(hexdump(c));
        }
        devlog("---- getSslSessionIdFromFD finished -----");
        devlog("");
      } catch (error) {
        devlog("Error:" + error);
      }
      return dummySSL_SessionID;
    }
    var len = sslSessionIdSECItem.add(pointerSize2 * 2).readU32();
    var session_id_ptr = sslSessionIdSECItem.add(pointerSize2).readPointer();
    var session_id = _NSS.getSessionIdString(session_id_ptr, len);
    return session_id;
  }
  static get_SSL_FD(pRFileDesc) {
    var ssl_layer = _NSS.NSS_FindIdentityForName(pRFileDesc, "SSL");
    if (!ssl_layer) {
      devlog("error: couldn't get SSL Layer from pRFileDesc");
      return NULL;
    }
    var sslSocketFD = _NSS.get_SSL_Socket(ssl_layer);
    if (!sslSocketFD) {
      devlog("error: couldn't get sslSocketFD");
      return NULL;
    }
    return sslSocketFD;
  }
  /**
  *
  *
  *
  *
  *
  *
  * /* This function tries to find the SSL layer in the stack.
  * It searches for the first SSL layer at or below the argument fd,
  * and failing that, it searches for the nearest SSL layer above the
  * argument fd.  It returns the private sslSocket from the found layer.
  *
  sslSocket *
  ssl_FindSocket(PRFileDesc *fd)
  {
  PRFileDesc *layer;
  sslSocket *ss;
  
  PORT_Assert(fd != NULL);
  PORT_Assert(ssl_layer_id != 0);
  
  layer = PR_GetIdentitiesLayer(fd, ssl_layer_id);
  if (layer == NULL) {
  PORT_SetError(PR_BAD_DESCRIPTOR_ERROR);
  return NULL;
  }
  
  ss = (sslSocket *)layer->secret;
  /* Set ss->fd lazily. We can't rely on the value of ss->fd set by
  * ssl_PushIOLayer because another PR_PushIOLayer call will switch the
  * contents of the PRFileDesc pointed by ss->fd and the new layer.
  * See bug 807250.
  *
  ss->fd = layer;
  return ss;
  }
  
  *
  *
  */
  static get_SSL_Socket(ssl_layer) {
    var sslSocket = ssl_layer.add(pointerSize2 * 1).readPointer();
    return sslSocket;
  }
  /******** NSS Encryption Keys *******/
  /**
   *
   * ss->ssl3.cwSpec->masterSecret
   *
   * @param {*} ssl3  the parsed ssl3 struct
   * @returns the client_random as hex string (lower case)
   */
  static getMasterSecret(ssl3) {
    var cwSpec = ssl3.cwSpec;
    var masterSecret_Ptr = _NSS.parse_struct_sl3CipherSpecStr(cwSpec).master_secret;
    var master_secret = _NSS.get_Secret_As_HexString(masterSecret_Ptr);
    return master_secret;
  }
  /**
   * ss->ssl3.hs.client_random
   *
   * @param {*} ssl3 is a ptr to current parsed ssl3 struct
   * @returns the client_random as hex string (lower case)
   */
  static getClientRandom(ssl3) {
    var client_random = _NSS.getHexString(ssl3.hs.client_random, _NSS.SSL3_RANDOM_LENGTH);
    return client_random;
  }
  /**
  
   
  typedef struct sslSocketStr sslSocket;
   *
  
      SSL Socket struct (https://github.com/nss-dev/nss/blob/master/lib/ssl/sslimpl.h#L971)
  struct sslSocketStr {
  PRFileDesc *fd;                                                                     +8
  
  /* Pointer to operations vector for this socket *
  const sslSocketOps *ops;                                                            +8
  
  /* SSL socket options *
  sslOptions opt;                                                                     sizeOf(sslOptions) --> 40
  /* Enabled version range *
  SSLVersionRange vrange;                                                             + 4
  
  /* A function that returns the current time. *
  SSLTimeFunc now;                                                                    +8
  void *nowArg;                                                                       +8
  
  /* State flags *
  unsigned long clientAuthRequested;                                                  +8
  unsigned long delayDisabled;     /* Nagle delay disabled *                          +8
  unsigned long firstHsDone;       /* first handshake is complete. *                  +8
  unsigned long enoughFirstHsDone; /* enough of the first handshake is                +8
                                    * done for callbacks to be able to
                                    * retrieve channel security
                                    * parameters from the SSL socket. *
  unsigned long handshakeBegun;                                                       +8
  unsigned long lastWriteBlocked;                                                     +8
  unsigned long recvdCloseNotify; /* received SSL EOF. *                              +8
  unsigned long TCPconnected;                                                         +8
  unsigned long appDataBuffered;                                                      +8
  unsigned long peerRequestedProtection; /* from old renegotiation *                  +8
  
  /* version of the protocol to use *
  SSL3ProtocolVersion version;                                                        +4
  SSL3ProtocolVersion clientHelloVersion; /* version sent in client hello. *          --> at offset 160
   */
  static get_SSL_Version(pRFileDesc) {
    var ssl_version_internal_Code = -1;
    var sslSocket = _NSS.get_SSL_FD(pRFileDesc);
    if (sslSocket.isNull()) {
      return -1;
    }
    var sslVersion_pointerSize = 160;
    ssl_version_internal_Code = sslSocket.add(sslVersion_pointerSize).readU16();
    return ssl_version_internal_Code;
  }
  static get_Secret_As_HexString(secret_key_Ptr) {
    var secret_as_hexString = "";
    var rv = _NSS.PK11_ExtractKeyValue(secret_key_Ptr);
    if (rv != SECStatus.SECSuccess) {
      devlog("ERROR access the secret key: " + secret_key_Ptr + " return value: " + rv);
      return "";
    }
    var keyData = _NSS.PK11_GetKeyData(secret_key_Ptr);
    var keyData_SECITem = _NSS.parse_struct_SECItem(keyData);
    try {
      if (keyData_SECITem.len > 64) {
        devlog("[!] error in identifiying the real key_len: " + keyData_SECITem.len);
        secret_as_hexString = _NSS.getHexString(keyData_SECITem.data, 32);
      } else {
        secret_as_hexString = _NSS.getHexString(keyData_SECITem.data, keyData_SECITem.len);
      }
    } catch (e) {
      devlog("[-] Error in extracting key from: " + keyData_SECITem.data + " with length: " + keyData_SECITem.len + " derived from secret_key_Ptr: " + secret_key_Ptr);
      dumpMemory(keyData_SECITem.data, 128);
    }
    return secret_as_hexString;
  }
  /**
   *
   * @param {*} ssl_version_internal_Code
   * @returns
   *
   *      https://github.com/nss-dev/nss/blob/c989bde00fe64c1b37df13c773adf3e91cc258c7/lib/ssl/sslproto.h#L16
   *      #define SSL_LIBRARY_VERSION_TLS_1_2             0x0303
   *      #define SSL_LIBRARY_VERSION_TLS_1_3             0x0304
   *
   *      0x0303 -->  771
   *      0x0304 -->  772
   *
   */
  static is_TLS_1_3(ssl_version_internal_Code) {
    if (ssl_version_internal_Code > 771) {
      return true;
    } else {
      return false;
    }
  }
  //see nss/lib/ssl/sslinfo.c for details */
  static get_Keylog_Dump(type, client_random, key) {
    return type + " " + client_random + " " + key;
  }
  /**
   *
   * @param {*} pRFileDesc
   * @param {*} dumping_handshake_secrets  a zero indicates an false and that the handshake just completed. A 1 indicates a true so that we are during the handshake itself
   * @returns
   */
  static getTLS_Keys(pRFileDesc, dumping_handshake_secrets) {
    var message = {};
    message["contentType"] = "keylog";
    devlog("trying to log some keying materials ...");
    var sslSocketFD = _NSS.get_SSL_FD(pRFileDesc);
    if (sslSocketFD.isNull()) {
      return;
    }
    var sslSocketStr = _NSS.parse_struct_sslSocketStr(sslSocketFD);
    var ssl3_struct = sslSocketStr.ssl3;
    var ssl3 = _NSS.parse_struct_ssl3Str(ssl3_struct);
    var client_random = _NSS.getClientRandom(ssl3);
    if (_NSS.doTLS13_RTT0 == 1) {
      var early_exporter_secret = _NSS.get_Secret_As_HexString(ssl3.hs.earlyExporterSecret);
      devlog(_NSS.get_Keylog_Dump("EARLY_EXPORTER_SECRET", client_random, early_exporter_secret));
      message["keylog"] = _NSS.get_Keylog_Dump("EARLY_EXPORTER_SECRET", client_random, early_exporter_secret);
      send(message);
      _NSS.doTLS13_RTT0 = -1;
    }
    if (dumping_handshake_secrets == 1) {
      devlog("exporting TLS 1.3 handshake keying material");
      var client_handshake_traffic_secret = _NSS.get_Secret_As_HexString(ssl3.hs.clientHsTrafficSecret);
      devlog(_NSS.get_Keylog_Dump("CLIENT_HANDSHAKE_TRAFFIC_SECRET", client_random, client_handshake_traffic_secret));
      message["keylog"] = _NSS.get_Keylog_Dump("CLIENT_HANDSHAKE_TRAFFIC_SECRET", client_random, client_handshake_traffic_secret);
      send(message);
      var server_handshake_traffic_secret = _NSS.get_Secret_As_HexString(ssl3.hs.serverHsTrafficSecret);
      devlog(_NSS.get_Keylog_Dump("SERVER_HANDSHAKE_TRAFFIC_SECRET", client_random, server_handshake_traffic_secret));
      message["keylog"] = _NSS.get_Keylog_Dump("SERVER_HANDSHAKE_TRAFFIC_SECRET", client_random, server_handshake_traffic_secret);
      send(message);
      return;
    } else if (dumping_handshake_secrets == 2) {
      devlog("exporting TLS 1.3 RTT0 handshake keying material");
      var client_early_traffic_secret = _NSS.get_Secret_As_HexString(ssl3.hs.clientEarlyTrafficSecret);
      devlog(_NSS.get_Keylog_Dump("CLIENT_EARLY_TRAFFIC_SECRET", client_random, client_early_traffic_secret));
      message["keylog"] = _NSS.get_Keylog_Dump("CLIENT_EARLY_TRAFFIC_SECRET", client_random, client_early_traffic_secret);
      send(message);
      _NSS.doTLS13_RTT0 = 1;
      return;
    }
    var ssl_version_internal_Code = _NSS.get_SSL_Version(pRFileDesc);
    if (_NSS.is_TLS_1_3(ssl_version_internal_Code)) {
      devlog("exporting TLS 1.3 keying material");
      var client_traffic_secret = _NSS.get_Secret_As_HexString(ssl3.hs.clientTrafficSecret);
      devlog(_NSS.get_Keylog_Dump("CLIENT_TRAFFIC_SECRET_0", client_random, client_traffic_secret));
      message["keylog"] = _NSS.get_Keylog_Dump("CLIENT_TRAFFIC_SECRET_0", client_random, client_traffic_secret);
      send(message);
      var server_traffic_secret = _NSS.get_Secret_As_HexString(ssl3.hs.serverTrafficSecret);
      devlog(_NSS.get_Keylog_Dump("SERVER_TRAFFIC_SECRET_0", client_random, server_traffic_secret));
      message["keylog"] = _NSS.get_Keylog_Dump("SERVER_TRAFFIC_SECRET_0", client_random, server_traffic_secret);
      send(message);
      var exporter_secret = _NSS.get_Secret_As_HexString(ssl3.hs.exporterSecret);
      devlog(_NSS.get_Keylog_Dump("EXPORTER_SECRET", client_random, exporter_secret));
      message["keylog"] = _NSS.get_Keylog_Dump("EXPORTER_SECRET", client_random, exporter_secret);
      send(message);
    } else {
      devlog("exporting TLS 1.2 keying material");
      var master_secret = _NSS.getMasterSecret(ssl3);
      devlog(_NSS.get_Keylog_Dump("CLIENT_RANDOM", client_random, master_secret));
      message["keylog"] = _NSS.get_Keylog_Dump("CLIENT_RANDOM", client_random, master_secret);
      send(message);
    }
    _NSS.doTLS13_RTT0 = -1;
    return;
  }
  static ssl_RecordKeyLog(sslSocketFD) {
    _NSS.getTLS_Keys(sslSocketFD, 0);
  }
  /***** Installing the hooks *****/
  install_plaintext_read_hook() {
    var current_module_name = this.module_name;
    var lib_addesses = this.addresses;
    Interceptor.attach(this.addresses[this.moduleName]["PR_Read"], {
      onEnter: function(args) {
        this.fd = ptr(args[0]);
        this.buf = ptr(args[1]);
      },
      onLeave: function(retval) {
        if (retval.toInt32() <= 0 || _NSS.getDescType(this.fd) == PRDescType.PR_DESC_FILE) {
          return;
        }
        var addr = Memory.alloc(8);
        var res = _NSS.getpeername(this.fd, addr);
        if (addr.readU16() == 2 || addr.readU16() == 10 || addr.readU16() == 100) {
          var message = _NSS.getPortsAndAddressesFromNSS(this.fd, true, lib_addesses[current_module_name], enable_default_fd);
          message["ssl_session_id"] = _NSS.getSslSessionIdFromFD(this.fd);
          message["function"] = "NSS_read";
          this.message = message;
          this.message["contentType"] = "datalog";
          var data = this.buf.readByteArray(new Uint32Array([retval])[0]);
          send(message, data);
        } else {
        }
      }
    });
  }
  install_plaintext_write_hook() {
    var current_module_name = this.module_name;
    var lib_addesses = this.addresses;
    Interceptor.attach(this.addresses[this.moduleName]["PR_Write"], {
      onEnter: function(args) {
        this.fd = ptr(args[0]);
        this.buf = args[1];
        this.len = args[2];
      },
      onLeave: function(retval) {
        if (retval.toInt32() <= 0) {
          return;
        }
        var addr = Memory.alloc(8);
        _NSS.getsockname(this.fd, addr);
        if (addr.readU16() == 2 || addr.readU16() == 10 || addr.readU16() == 100) {
          var message = _NSS.getPortsAndAddressesFromNSS(this.fd, false, lib_addesses[current_module_name], enable_default_fd);
          message["ssl_session_id"] = _NSS.getSslSessionIdFromFD(this.fd);
          message["function"] = "NSS_write";
          message["contentType"] = "datalog";
          send(message, this.buf.readByteArray(parseInt(this.len)));
        } else {
        }
      }
    });
  }
  /***** install callbacks for key logging ******/
  /**
   *
   * This callback gets only called in TLS 1.3 and newer versions
   *
   * @param {*} pRFileDesc
   * @param {*} secret_label
   * @param {*} secret
   * @returns
   *
      function tls13_RecordKeyLog(pRFileDesc, secret_label, secret){
  
      var sslSocketFD = get_SSL_FD(pRFileDesc);
      if(sslSocketFD == -1){
          return;
      }
  
      var sslSocketStr = parse_struct_sslSocketStr(sslSocketFD);
  
      var ssl3_struct = sslSocketStr.ssl3;
      var ssl3 = parse_struct_ssl3Str(ssl3_struct);
      
  
      var secret_as_hexString = get_Secret_As_HexString(secret);
      
  
      log(get_Keylog_Dump(secret_label,getClientRandom(ssl3),secret_as_hexString));
  
  
      return 0;
      }
  
      // our old way to get the diffrent secrets from TLS 1.3 and above
      */
  static parse_epoch_value_from_SSL_SetSecretCallback(sslSocketFD, epoch) {
    if (epoch == 1) {
      _NSS.getTLS_Keys(sslSocketFD, 2);
    } else if (epoch == 2) {
      _NSS.getTLS_Keys(sslSocketFD, 1);
    } else if (epoch >= 3) {
      return;
    } else {
      devlog("[-] secret_callback invocation: UNKNOWN");
    }
  }
  static insert_hook_into_secretCallback(addr_of_installed_secretCallback) {
    Interceptor.attach(addr_of_installed_secretCallback, {
      onEnter(args) {
        this.sslSocketFD = args[0];
        this.epoch = args[1];
        _NSS.parse_epoch_value_from_SSL_SetSecretCallback(this.sslSocketFD, this.epoch);
      },
      onLeave(retval) {
      }
    });
  }
  /**
       * Registers a secret_callback through inserting the address to our TLS 1.3 callback function at the apprioate offset of the  SSL Socket struct
       * This is neccassy because the computed handshake secrets are already freed after the handshake is completed.
       *
       *
       * @param {*} pRFileDesc a file descriptor (NSS PRFileDesc) to a SSL socket
       * @returns
       */
  static register_secret_callback(pRFileDesc) {
    var sslSocketFD = _NSS.get_SSL_FD(pRFileDesc);
    if (sslSocketFD.isNull()) {
      devlog("[-] error while installing secret callback: unable get SSL socket descriptor");
      return;
    }
    var sslSocketStr = _NSS.parse_struct_sslSocketStr(sslSocketFD);
    if (_NSS.is_ptr_at_mem_location(sslSocketStr.secretCallback.readPointer()) == 1) {
      _NSS.insert_hook_into_secretCallback(sslSocketStr.secretCallback.readPointer());
    } else {
      sslSocketStr.secretCallback.writePointer(_NSS.secret_callback);
    }
    devlog("secret callback (" + _NSS.secret_callback + ") installed to address: " + sslSocketStr.secretCallback);
  }
  install_tls_keys_callback_hook() {
  }
};

// agent/android/nss_android.ts
var NSS_Android = class extends NSS {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    var library_method_mapping = {};
    devlog("Hooking module " + moduleName);
    library_method_mapping[`*${moduleName}*`] = ["PR_Write", "PR_Read", "PR_FileDesc2NativeHandle", "PR_GetPeerName", "PR_GetSockName", "PR_GetNameForIdentity", "PR_GetDescType", "SSL_ImportFD", "SSL_HandshakeCallback", "PK11_ExtractKeyValue", "PK11_GetKeyData"];
    library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    super(moduleName, socket_library6, library_method_mapping);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  execute_hooks() {
    try {
      devlog("[!] NSS 1.3 Client Random working; keys are still not exported..");
      this.install_tls_keys_callback_hook();
    } catch (e) {
      devlog("Installing NSS key hooking - still early development stage");
      devlog("NSS Error code: " + e);
    }
  }
  install_tls_keys_callback_hook() {
    NSS.getDescType = new NativeFunction(this.addresses[this.module_name]["PR_GetDescType"], "int", ["pointer"]);
    NSS.PR_GetNameForIdentity = new NativeFunction(this.addresses[this.module_name]["PR_GetNameForIdentity"], "pointer", ["pointer"]);
    NSS.get_SSL_Callback = new NativeFunction(this.addresses[this.module_name]["SSL_HandshakeCallback"], "int", ["pointer", "pointer", "pointer"]);
    NSS.PK11_ExtractKeyValue = new NativeFunction(this.addresses[this.module_name]["PK11_ExtractKeyValue"], "int", ["pointer"]);
    NSS.PK11_GetKeyData = new NativeFunction(this.addresses[this.module_name]["PK11_GetKeyData"], "pointer", ["pointer"]);
    Interceptor.attach(this.addresses[this.module_name]["SSL_ImportFD"], {
      onEnter(args) {
        this.fd = args[1];
      },
      onLeave(retval) {
        if (retval.isNull()) {
          devlog("[-] SSL_ImportFD error: unknow null");
          return;
        }
        var retValue = NSS.get_SSL_Callback(retval, NSS.keylog_callback, NULL);
        NSS.register_secret_callback(retval);
        if (retValue < 0) {
          devlog("Callback Error");
          var getErrorText = new NativeFunction(Process.getModuleByName("libnspr4.so").getExportByName("PR_GetErrorText"), "int", ["pointer"]);
          var outbuffer = Memory.alloc(200);
          devlog("typeof outbuffer: " + typeof outbuffer);
          devlog("outbuffer: " + outbuffer);
          getErrorText(outbuffer.readPointer());
          devlog("Error msg: " + outbuffer);
        } else {
          devlog("[*] keylog callback successfull installed");
        }
      }
    });
    Interceptor.attach(this.addresses[this.module_name]["SSL_HandshakeCallback"], {
      onEnter(args) {
        this.originalCallback = args[1];
        Interceptor.attach(ptr(this.originalCallback), {
          onEnter(args2) {
            var sslSocketFD = args2[0];
            devlog("[*] NSS keylog callback successfull installed via applications callback function");
            NSS.ssl_RecordKeyLog(sslSocketFD);
          },
          onLeave(retval) {
          }
        });
      },
      onLeave(retval) {
      }
    });
  }
};
function nss_execute(moduleName, is_base_hook) {
  var nss_ssl = new NSS_Android(moduleName, socket_library, is_base_hook);
  nss_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = nss_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/ssl_lib/mbedTLS.ts
var mbed_TLS = class _mbed_TLS {
  moduleName;
  socket_library;
  passed_library_method_mapping;
  // global variables
  library_method_mapping = {};
  addresses;
  module_name;
  constructor(moduleName, socket_library6, passed_library_method_mapping) {
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.passed_library_method_mapping = passed_library_method_mapping;
    if (typeof passed_library_method_mapping !== "undefined") {
      this.library_method_mapping = passed_library_method_mapping;
    } else {
      this.library_method_mapping[`*${moduleName}*`] = ["mbedtls_ssl_read", "mbedtls_ssl_write"];
      this.library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    }
    this.addresses = readAddresses(moduleName, this.library_method_mapping);
    this.module_name = moduleName;
    if (offsets != "{OFFSETS}" && offsets.mbedtls != null) {
      if (offsets.sockets != null) {
        const socketBaseAddress = getBaseAddress(socket_library6);
        for (const method2 of Object.keys(offsets.sockets)) {
          this.addresses[this.moduleName][`${method2}`] = offsets.sockets[`${method2}`].absolute || socketBaseAddress == null ? ptr(offsets.sockets[`${method2}`].address) : socketBaseAddress.add(ptr(offsets.sockets[`${method2}`].address));
        }
      }
      const libraryBaseAddress = getBaseAddress(moduleName);
      if (libraryBaseAddress == null) {
        log("Unable to find library base address! Given address values will be interpreted as absolute ones!");
      }
      for (const method2 of Object.keys(offsets.mbedtls)) {
        this.addresses[this.moduleName][`${method2}`] = offsets.mbedtls[`${method2}`].absolute || libraryBaseAddress == null ? ptr(offsets.mbedtls[`${method2}`].address) : libraryBaseAddress.add(ptr(offsets.mbedtls[`${method2}`].address));
      }
    }
  }
  static parse_mbedtls_ssl_context_struct(sslcontext) {
    return {
      conf: sslcontext.readPointer(),
      state: sslcontext.add(Process.pointerSize).readS32(),
      renego_status: sslcontext.add(Process.pointerSize + 4).readS32(),
      renego_records_seen: sslcontext.add(Process.pointerSize + 4 + 4).readS32(),
      major_ver: sslcontext.add(Process.pointerSize + 4 + 4 + 4).readS32(),
      minor_ver: sslcontext.add(Process.pointerSize + 4 + 4 + 4 + 4).readS32(),
      badmac_seen: sslcontext.add(Process.pointerSize + 4 + 4 + 4 + 4 + 4).readU32(),
      f_send: sslcontext.add(Process.pointerSize + 4 + 4 + 4 + 4 + 4 + 4).readPointer(),
      f_recv: sslcontext.add(Process.pointerSize + 4 + 4 + 4 + 4 + 4 + 4 + Process.pointerSize).readPointer(),
      f_recv_timeout: sslcontext.add(Process.pointerSize + 4 + 4 + 4 + 4 + 4 + 4 + 2 * Process.pointerSize).readPointer(),
      p_bio: sslcontext.add(Process.platform == "windows" ? 48 : 56).readPointer(),
      session_in: sslcontext.add(Process.pointerSize + 4 + 4 + 4 + 4 + 4 + 4 + 4 * Process.pointerSize).readPointer(),
      session_out: sslcontext.add(Process.pointerSize + 4 + 4 + 4 + 4 + 4 + 4 + 5 * Process.pointerSize).readPointer(),
      session: {
        start: sslcontext.add(24 + 7 * Process.pointerSize).readPointer().readPointer(),
        ciphersuite: sslcontext.add(24 + 7 * Process.pointerSize).readPointer().add(8).readS32(),
        compression: sslcontext.add(24 + 7 * Process.pointerSize).readPointer().add(8 + 4).readS32(),
        id_len: sslcontext.add(24 + 7 * Process.pointerSize).readPointer().add(8 + 4 + 4).readU32(),
        id: sslcontext.add(24 + 7 * Process.pointerSize).readPointer().add(8 + 4 + 4 + 4).readByteArray(sslcontext.add(24 + 7 * Process.pointerSize).readPointer().add(8 + 4 + 4).readU32())
      }
    };
  }
  static getSocketDescriptor(sslcontext) {
    var ssl_context = _mbed_TLS.parse_mbedtls_ssl_context_struct(sslcontext);
    return ssl_context.p_bio.readS32();
  }
  static getSessionId(sslcontext) {
    var ssl_context = _mbed_TLS.parse_mbedtls_ssl_context_struct(sslcontext);
    var session_id = "";
    for (var byteCounter = 0; byteCounter < ssl_context.session.id_len; byteCounter++) {
      session_id = `${session_id}${ssl_context.session.id?.unwrap().add(byteCounter).readU8().toString(16).toUpperCase()}`;
    }
    return session_id;
  }
  install_plaintext_read_hook() {
    var current_module_name = this.module_name;
    var lib_addesses = this.addresses;
    Interceptor.attach(this.addresses[this.moduleName]["mbedtls_ssl_read"], {
      onEnter: function(args) {
        this.buffer = args[1];
        this.len = args[2];
        this.sslContext = args[0];
        var message = getPortsAndAddresses(_mbed_TLS.getSocketDescriptor(args[0]), true, lib_addesses[current_module_name], enable_default_fd);
        message["ssl_session_id"] = _mbed_TLS.getSessionId(args[0]);
        message["function"] = "mbedtls_ssl_read";
        this.message = message;
      },
      onLeave: function(retval) {
        retval |= 0;
        if (retval <= 0) {
          return;
        }
        var data = this.buffer.readByteArray(retval);
        this.message["contentType"] = "datalog";
        send(this.message, data);
      }
    });
  }
  install_plaintext_write_hook() {
    var current_module_name = this.module_name;
    var lib_addesses = this.addresses;
    Interceptor.attach(this.addresses[this.moduleName]["mbedtls_ssl_write"], {
      onEnter: function(args) {
        var buffer = args[1];
        var len = args[2];
        len |= 0;
        if (len <= 0) {
          return;
        }
        var data = buffer.readByteArray(len);
        var message = getPortsAndAddresses(_mbed_TLS.getSocketDescriptor(args[0]), false, lib_addesses[current_module_name], enable_default_fd);
        message["ssl_session_id"] = _mbed_TLS.getSessionId(args[0]);
        message["function"] = "mbedtls_ssl_write";
        message["contentType"] = "datalog";
        send(message, data);
      }
    });
  }
  install_tls_keys_callback_hook() {
  }
};

// agent/android/mbedTLS_android.ts
var mbed_TLS_Android = class extends mbed_TLS {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  /*
      SSL_CTX_set_keylog_callback not exported by default on android.
  
      We need to find a way to install the callback function for doing that
  
      Alternatives?:SSL_export_keying_material, SSL_SESSION_get_master_key
      */
  install_tls_keys_callback_hook() {
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
  }
};
function mbedTLS_execute(moduleName, is_base_hook) {
  var mbedTLS_ssl = new mbed_TLS_Android(moduleName, socket_library, is_base_hook);
  mbedTLS_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = mbedTLS_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// node_modules/frida-objc-bridge/lib/api.js
var cachedApi3 = null;
var defaultInvocationOptions = {
  exceptions: "propagate"
};
function getApi4() {
  if (cachedApi3 !== null) {
    return cachedApi3;
  }
  const temporaryApi = {};
  const pending = [
    {
      module: "libsystem_malloc.dylib",
      functions: {
        "free": ["void", ["pointer"]]
      }
    },
    {
      module: "libobjc.A.dylib",
      functions: {
        "objc_msgSend": function(address) {
          this.objc_msgSend = address;
        },
        "objc_msgSend_stret": function(address) {
          this.objc_msgSend_stret = address;
        },
        "objc_msgSend_fpret": function(address) {
          this.objc_msgSend_fpret = address;
        },
        "objc_msgSendSuper": function(address) {
          this.objc_msgSendSuper = address;
        },
        "objc_msgSendSuper_stret": function(address) {
          this.objc_msgSendSuper_stret = address;
        },
        "objc_msgSendSuper_fpret": function(address) {
          this.objc_msgSendSuper_fpret = address;
        },
        "objc_getClassList": ["int", ["pointer", "int"]],
        "objc_lookUpClass": ["pointer", ["pointer"]],
        "objc_allocateClassPair": ["pointer", ["pointer", "pointer", "pointer"]],
        "objc_disposeClassPair": ["void", ["pointer"]],
        "objc_registerClassPair": ["void", ["pointer"]],
        "class_isMetaClass": ["bool", ["pointer"]],
        "class_getName": ["pointer", ["pointer"]],
        "class_getImageName": ["pointer", ["pointer"]],
        "class_copyProtocolList": ["pointer", ["pointer", "pointer"]],
        "class_copyMethodList": ["pointer", ["pointer", "pointer"]],
        "class_getClassMethod": ["pointer", ["pointer", "pointer"]],
        "class_getInstanceMethod": ["pointer", ["pointer", "pointer"]],
        "class_getSuperclass": ["pointer", ["pointer"]],
        "class_addProtocol": ["bool", ["pointer", "pointer"]],
        "class_addMethod": ["bool", ["pointer", "pointer", "pointer", "pointer"]],
        "class_copyIvarList": ["pointer", ["pointer", "pointer"]],
        "objc_getProtocol": ["pointer", ["pointer"]],
        "objc_copyProtocolList": ["pointer", ["pointer"]],
        "objc_allocateProtocol": ["pointer", ["pointer"]],
        "objc_registerProtocol": ["void", ["pointer"]],
        "protocol_getName": ["pointer", ["pointer"]],
        "protocol_copyMethodDescriptionList": ["pointer", ["pointer", "bool", "bool", "pointer"]],
        "protocol_copyPropertyList": ["pointer", ["pointer", "pointer"]],
        "protocol_copyProtocolList": ["pointer", ["pointer", "pointer"]],
        "protocol_addProtocol": ["void", ["pointer", "pointer"]],
        "protocol_addMethodDescription": ["void", ["pointer", "pointer", "pointer", "bool", "bool"]],
        "ivar_getName": ["pointer", ["pointer"]],
        "ivar_getTypeEncoding": ["pointer", ["pointer"]],
        "ivar_getOffset": ["pointer", ["pointer"]],
        "object_isClass": ["bool", ["pointer"]],
        "object_getClass": ["pointer", ["pointer"]],
        "object_getClassName": ["pointer", ["pointer"]],
        "method_getName": ["pointer", ["pointer"]],
        "method_getTypeEncoding": ["pointer", ["pointer"]],
        "method_getImplementation": ["pointer", ["pointer"]],
        "method_setImplementation": ["pointer", ["pointer", "pointer"]],
        "property_getName": ["pointer", ["pointer"]],
        "property_copyAttributeList": ["pointer", ["pointer", "pointer"]],
        "sel_getName": ["pointer", ["pointer"]],
        "sel_registerName": ["pointer", ["pointer"]],
        "class_getInstanceSize": ["pointer", ["pointer"]]
      },
      optionals: {
        "objc_msgSend_stret": "ABI",
        "objc_msgSend_fpret": "ABI",
        "objc_msgSendSuper_stret": "ABI",
        "objc_msgSendSuper_fpret": "ABI",
        "object_isClass": "iOS8"
      }
    },
    {
      module: "libdispatch.dylib",
      functions: {
        "dispatch_async_f": ["void", ["pointer", "pointer", "pointer"]]
      },
      variables: {
        "_dispatch_main_q": function(address) {
          this._dispatch_main_q = address;
        }
      }
    }
  ];
  let remaining = 0;
  pending.forEach(function(api3) {
    const isObjCApi = api3.module === "libobjc.A.dylib";
    const functions = api3.functions || {};
    const variables = api3.variables || {};
    const optionals = api3.optionals || {};
    remaining += Object.keys(functions).length + Object.keys(variables).length;
    const exportByName = (Process.findModuleByName(api3.module)?.enumerateExports() ?? []).reduce(function(result, exp) {
      result[exp.name] = exp;
      return result;
    }, {});
    Object.keys(functions).forEach(function(name) {
      const exp = exportByName[name];
      if (exp !== void 0 && exp.type === "function") {
        const signature2 = functions[name];
        if (typeof signature2 === "function") {
          signature2.call(temporaryApi, exp.address);
          if (isObjCApi)
            signature2.call(temporaryApi, exp.address);
        } else {
          temporaryApi[name] = new NativeFunction(exp.address, signature2[0], signature2[1], defaultInvocationOptions);
          if (isObjCApi)
            temporaryApi[name] = temporaryApi[name];
        }
        remaining--;
      } else {
        const optional = optionals[name];
        if (optional)
          remaining--;
      }
    });
    Object.keys(variables).forEach(function(name) {
      const exp = exportByName[name];
      if (exp !== void 0 && exp.type === "variable") {
        const handler = variables[name];
        handler.call(temporaryApi, exp.address);
        remaining--;
      }
    });
  });
  if (remaining === 0) {
    if (!temporaryApi.objc_msgSend_stret)
      temporaryApi.objc_msgSend_stret = temporaryApi.objc_msgSend;
    if (!temporaryApi.objc_msgSend_fpret)
      temporaryApi.objc_msgSend_fpret = temporaryApi.objc_msgSend;
    if (!temporaryApi.objc_msgSendSuper_stret)
      temporaryApi.objc_msgSendSuper_stret = temporaryApi.objc_msgSendSuper;
    if (!temporaryApi.objc_msgSendSuper_fpret)
      temporaryApi.objc_msgSendSuper_fpret = temporaryApi.objc_msgSendSuper;
    cachedApi3 = temporaryApi;
  }
  return cachedApi3;
}

// node_modules/frida-objc-bridge/lib/fastpaths.js
var code3 = `#include <glib.h>
#include <ptrauth.h>

#define KERN_SUCCESS 0
#define MALLOC_PTR_IN_USE_RANGE_TYPE 1
#if defined (HAVE_I386) && GLIB_SIZEOF_VOID_P == 8
# define OBJC_ISA_MASK 0x7ffffffffff8ULL
#elif defined (HAVE_ARM64)
# define OBJC_ISA_MASK 0xffffffff8ULL
#endif

typedef struct _ChooseContext ChooseContext;

typedef struct _malloc_zone_t malloc_zone_t;
typedef struct _malloc_introspection_t malloc_introspection_t;
typedef struct _vm_range_t vm_range_t;

typedef gpointer Class;
typedef int kern_return_t;
typedef guint mach_port_t;
typedef mach_port_t task_t;
typedef guintptr vm_offset_t;
typedef guintptr vm_size_t;
typedef vm_offset_t vm_address_t;

struct _ChooseContext
{
  GHashTable * classes;
  GArray * matches;
};

struct _malloc_zone_t
{
  void * reserved1;
  void * reserved2;
  size_t (* size) (struct _malloc_zone_t * zone, const void * ptr);
  void * (* malloc) (struct _malloc_zone_t * zone, size_t size);
  void * (* calloc) (struct _malloc_zone_t * zone, size_t num_items, size_t size);
  void * (* valloc) (struct _malloc_zone_t * zone, size_t size);
  void (* free) (struct _malloc_zone_t * zone, void * ptr);
  void * (* realloc) (struct _malloc_zone_t * zone, void * ptr, size_t size);
  void (* destroy) (struct _malloc_zone_t * zone);
  const char * zone_name;

  unsigned (* batch_malloc) (struct _malloc_zone_t * zone, size_t size, void ** results, unsigned num_requested);
  void (* batch_free) (struct _malloc_zone_t * zone, void ** to_be_freed, unsigned num_to_be_freed);

  malloc_introspection_t * introspect;
};

typedef kern_return_t (* memory_reader_t) (task_t remote_task, vm_address_t remote_address, vm_size_t size, void ** local_memory);
typedef void (* vm_range_recorder_t) (task_t task, void * user_data, unsigned type, vm_range_t * ranges, unsigned count);
typedef kern_return_t (* enumerator_func) (task_t task, void * user_data, unsigned type_mask, vm_address_t zone_address, memory_reader_t reader,
      vm_range_recorder_t recorder);

struct _malloc_introspection_t
{
  enumerator_func enumerator;
};

struct _vm_range_t
{
  vm_address_t address;
  vm_size_t size;
};

extern int objc_getClassList (Class * buffer, int buffer_count);
extern Class class_getSuperclass (Class cls);
extern size_t class_getInstanceSize (Class cls);
extern kern_return_t malloc_get_all_zones (task_t task, memory_reader_t reader, vm_address_t ** addresses, unsigned * count);

static void collect_subclasses (Class klass, GHashTable * result);
static void collect_matches_in_ranges (task_t task, void * user_data, unsigned type, vm_range_t * ranges, unsigned count);
static kern_return_t read_local_memory (task_t remote_task, vm_address_t remote_address, vm_size_t size, void ** local_memory);

extern mach_port_t selfTask;

gpointer *
choose (Class * klass,
        gboolean consider_subclasses,
        guint * count)
{
  ChooseContext ctx;
  GHashTable * classes;
  vm_address_t * malloc_zone_addresses;
  unsigned malloc_zone_count, i;

  classes = g_hash_table_new_full (NULL, NULL, NULL, NULL);
  ctx.classes = classes;
  ctx.matches = g_array_new (FALSE, FALSE, sizeof (gpointer));
  if (consider_subclasses)
    collect_subclasses (klass, classes);
  else
    g_hash_table_insert (classes, klass, GSIZE_TO_POINTER (class_getInstanceSize (klass)));

  malloc_zone_count = 0;
  malloc_get_all_zones (selfTask, read_local_memory, &malloc_zone_addresses, &malloc_zone_count);

  for (i = 0; i != malloc_zone_count; i++)
  {
    vm_address_t zone_address = malloc_zone_addresses[i];
    malloc_zone_t * zone = (malloc_zone_t *) zone_address;
    enumerator_func enumerator;

    if (zone != NULL && zone->introspect != NULL &&
        (enumerator = (ptrauth_strip (zone->introspect, ptrauth_key_asda))->enumerator) != NULL)
    {
      enumerator = ptrauth_sign_unauthenticated (
          ptrauth_strip (enumerator, ptrauth_key_asia),
          ptrauth_key_asia, 0);

      enumerator (selfTask, &ctx, MALLOC_PTR_IN_USE_RANGE_TYPE, zone_address, read_local_memory,
          collect_matches_in_ranges);
    }
  }

  g_hash_table_unref (classes);

  *count = ctx.matches->len;

  return (gpointer *) g_array_free (ctx.matches, FALSE);
}

void
destroy (gpointer mem)
{
  g_free (mem);
}

static void
collect_subclasses (Class klass,
                    GHashTable * result)
{
  Class * classes;
  int count, i;

  count = objc_getClassList (NULL, 0);
  classes = g_malloc (count * sizeof (gpointer));
  count = objc_getClassList (classes, count);

  for (i = 0; i != count; i++)
  {
    Class candidate = classes[i];
    Class c;

    c = candidate;
    do
    {
      if (c == klass)
      {
        g_hash_table_insert (result, candidate, GSIZE_TO_POINTER (class_getInstanceSize (candidate)));
        break;
      }

      c = class_getSuperclass (c);
    }
    while (c != NULL);
  }

  g_free (classes);
}

static void
collect_matches_in_ranges (task_t task,
                           void * user_data,
                           unsigned type,
                           vm_range_t * ranges,
                           unsigned count)
{
  ChooseContext * ctx = user_data;
  GHashTable * classes = ctx->classes;
  unsigned i;

  for (i = 0; i != count; i++)
  {
    const vm_range_t * range = &ranges[i];
    gconstpointer candidate = GSIZE_TO_POINTER (range->address);
    gconstpointer isa;
    guint instance_size;

    isa = *(gconstpointer *) candidate;
#ifdef OBJC_ISA_MASK
    isa = GSIZE_TO_POINTER (GPOINTER_TO_SIZE (isa) & OBJC_ISA_MASK);
#endif

    instance_size = GPOINTER_TO_UINT (g_hash_table_lookup (classes, isa));
    if (instance_size != 0 && range->size >= instance_size)
    {
      g_array_append_val (ctx->matches, candidate);
    }
  }
}

static kern_return_t
read_local_memory (task_t remote_task,
                   vm_address_t remote_address,
                   vm_size_t size,
                   void ** local_memory)
{
  *local_memory = (void *) remote_address;

  return KERN_SUCCESS;
}
`;
var { pointerSize: pointerSize11 } = Process;
var cachedModule = null;
function get() {
  if (cachedModule === null)
    cachedModule = compileModule2();
  return cachedModule;
}
function compileModule2() {
  const {
    objc_getClassList,
    class_getSuperclass,
    class_getInstanceSize
  } = getApi4();
  const selfTask = Memory.alloc(4);
  selfTask.writeU32(Module.getGlobalExportByName("mach_task_self_").readU32());
  const cm2 = new CModule(code3, {
    objc_getClassList,
    class_getSuperclass,
    class_getInstanceSize,
    malloc_get_all_zones: Process.getModuleByName("/usr/lib/system/libsystem_malloc.dylib").getExportByName("malloc_get_all_zones"),
    selfTask
  });
  const _choose = new NativeFunction(cm2.choose, "pointer", ["pointer", "bool", "pointer"]);
  const _destroy = new NativeFunction(cm2.destroy, "void", ["pointer"]);
  return {
    handle: cm2,
    choose(klass, considerSubclasses) {
      const result = [];
      const countPtr = Memory.alloc(4);
      const matches = _choose(klass, considerSubclasses ? 1 : 0, countPtr);
      try {
        const count = countPtr.readU32();
        for (let i = 0; i !== count; i++)
          result.push(matches.add(i * pointerSize11).readPointer());
      } finally {
        _destroy(matches);
      }
      return result;
    }
  };
}

// node_modules/frida-objc-bridge/index.js
function Runtime2() {
  const pointerSize = Process.pointerSize;
  let api = null;
  let apiError = null;
  const realizedClasses = /* @__PURE__ */ new Set();
  const classRegistry = new ClassRegistry();
  const protocolRegistry = new ProtocolRegistry();
  const replacedMethods = /* @__PURE__ */ new Map();
  const scheduledWork = /* @__PURE__ */ new Map();
  let nextId = 1;
  let workCallback = null;
  let NSAutoreleasePool = null;
  const bindings = /* @__PURE__ */ new Map();
  let readObjectIsa = null;
  const msgSendBySignatureId = /* @__PURE__ */ new Map();
  const msgSendSuperBySignatureId = /* @__PURE__ */ new Map();
  let cachedNSString = null;
  let cachedNSStringCtor = null;
  let cachedNSNumber = null;
  let cachedNSNumberCtor = null;
  let singularTypeById = null;
  let modifiers = null;
  try {
    tryInitialize();
  } catch (e) {
  }
  function tryInitialize() {
    if (api !== null)
      return true;
    if (apiError !== null)
      throw apiError;
    try {
      api = getApi4();
    } catch (e) {
      apiError = e;
      throw e;
    }
    return api !== null;
  }
  function dispose() {
    for (const [rawMethodHandle, impls] of replacedMethods.entries()) {
      const methodHandle = ptr(rawMethodHandle);
      const [oldImp, newImp] = impls;
      if (api.method_getImplementation(methodHandle).equals(newImp))
        api.method_setImplementation(methodHandle, oldImp);
    }
    replacedMethods.clear();
  }
  Script.bindWeak(this, dispose);
  Object.defineProperty(this, "available", {
    enumerable: true,
    get() {
      return tryInitialize();
    }
  });
  Object.defineProperty(this, "api", {
    enumerable: true,
    get() {
      return getApi4();
    }
  });
  Object.defineProperty(this, "classes", {
    enumerable: true,
    value: classRegistry
  });
  Object.defineProperty(this, "protocols", {
    enumerable: true,
    value: protocolRegistry
  });
  Object.defineProperty(this, "Object", {
    enumerable: true,
    value: ObjCObject
  });
  Object.defineProperty(this, "Protocol", {
    enumerable: true,
    value: ObjCProtocol
  });
  Object.defineProperty(this, "Block", {
    enumerable: true,
    value: Block
  });
  Object.defineProperty(this, "mainQueue", {
    enumerable: true,
    get() {
      return api?._dispatch_main_q ?? null;
    }
  });
  Object.defineProperty(this, "registerProxy", {
    enumerable: true,
    value: registerProxy
  });
  Object.defineProperty(this, "registerClass", {
    enumerable: true,
    value: registerClass
  });
  Object.defineProperty(this, "registerProtocol", {
    enumerable: true,
    value: registerProtocol
  });
  Object.defineProperty(this, "bind", {
    enumerable: true,
    value: bind
  });
  Object.defineProperty(this, "unbind", {
    enumerable: true,
    value: unbind
  });
  Object.defineProperty(this, "getBoundData", {
    enumerable: true,
    value: getBoundData
  });
  Object.defineProperty(this, "enumerateLoadedClasses", {
    enumerable: true,
    value: enumerateLoadedClasses
  });
  Object.defineProperty(this, "enumerateLoadedClassesSync", {
    enumerable: true,
    value: enumerateLoadedClassesSync
  });
  Object.defineProperty(this, "choose", {
    enumerable: true,
    value: choose
  });
  Object.defineProperty(this, "chooseSync", {
    enumerable: true,
    value(specifier) {
      const instances = [];
      choose(specifier, {
        onMatch(i) {
          instances.push(i);
        },
        onComplete() {
        }
      });
      return instances;
    }
  });
  this.schedule = function(queue, work) {
    const id = ptr(nextId++);
    scheduledWork.set(id.toString(), work);
    if (workCallback === null) {
      workCallback = new NativeCallback(performScheduledWorkItem, "void", ["pointer"]);
    }
    Script.pin();
    api.dispatch_async_f(queue, id, workCallback);
  };
  function performScheduledWorkItem(rawId) {
    const id = rawId.toString();
    const work = scheduledWork.get(id);
    scheduledWork.delete(id);
    if (NSAutoreleasePool === null)
      NSAutoreleasePool = classRegistry.NSAutoreleasePool;
    const pool = NSAutoreleasePool.alloc().init();
    let pendingException = null;
    try {
      work();
    } catch (e) {
      pendingException = e;
    }
    pool.release();
    setImmediate(performScheduledWorkCleanup, pendingException);
  }
  function performScheduledWorkCleanup(pendingException) {
    Script.unpin();
    if (pendingException !== null) {
      throw pendingException;
    }
  }
  this.implement = function(method2, fn) {
    return new NativeCallback(fn, method2.returnType, method2.argumentTypes);
  };
  this.selector = selector;
  this.selectorAsString = selectorAsString;
  function selector(name) {
    return api.sel_registerName(Memory.allocUtf8String(name));
  }
  function selectorAsString(sel2) {
    return api.sel_getName(sel2).readUtf8String();
  }
  const registryBuiltins = /* @__PURE__ */ new Set([
    "prototype",
    "constructor",
    "hasOwnProperty",
    "toJSON",
    "toString",
    "valueOf"
  ]);
  function ClassRegistry() {
    const cachedClasses = {};
    let numCachedClasses = 0;
    const registry = new Proxy(this, {
      has(target, property) {
        return hasProperty(property);
      },
      get(target, property, receiver) {
        switch (property) {
          case "prototype":
            return target.prototype;
          case "constructor":
            return target.constructor;
          case "hasOwnProperty":
            return hasProperty;
          case "toJSON":
            return toJSON2;
          case "toString":
            return toString2;
          case "valueOf":
            return valueOf;
          default:
            const klass = findClass(property);
            return klass !== null ? klass : void 0;
        }
      },
      set(target, property, value, receiver) {
        return false;
      },
      ownKeys(target) {
        if (api === null)
          return [];
        let numClasses = api.objc_getClassList(NULL, 0);
        if (numClasses !== numCachedClasses) {
          const classHandles = Memory.alloc(numClasses * pointerSize);
          numClasses = api.objc_getClassList(classHandles, numClasses);
          for (let i = 0; i !== numClasses; i++) {
            const handle2 = classHandles.add(i * pointerSize).readPointer();
            const name = api.class_getName(handle2).readUtf8String();
            cachedClasses[name] = handle2;
          }
          numCachedClasses = numClasses;
        }
        return Object.keys(cachedClasses);
      },
      getOwnPropertyDescriptor(target, property) {
        return {
          writable: false,
          configurable: true,
          enumerable: true
        };
      }
    });
    function hasProperty(name) {
      if (registryBuiltins.has(name))
        return true;
      return findClass(name) !== null;
    }
    function getClass(name) {
      const cls = findClass(name);
      if (cls === null)
        throw new Error("Unable to find class '" + name + "'");
      return cls;
    }
    function findClass(name) {
      let handle2 = cachedClasses[name];
      if (handle2 === void 0) {
        handle2 = api.objc_lookUpClass(Memory.allocUtf8String(name));
        if (handle2.isNull())
          return null;
        cachedClasses[name] = handle2;
        numCachedClasses++;
      }
      return new ObjCObject(handle2, void 0, true);
    }
    function toJSON2() {
      return Object.keys(registry).reduce(function(r, name) {
        r[name] = getClass(name).toJSON();
        return r;
      }, {});
    }
    function toString2() {
      return "ClassRegistry";
    }
    function valueOf() {
      return "ClassRegistry";
    }
    return registry;
  }
  function ProtocolRegistry() {
    let cachedProtocols = {};
    let numCachedProtocols = 0;
    const registry = new Proxy(this, {
      has(target, property) {
        return hasProperty(property);
      },
      get(target, property, receiver) {
        switch (property) {
          case "prototype":
            return target.prototype;
          case "constructor":
            return target.constructor;
          case "hasOwnProperty":
            return hasProperty;
          case "toJSON":
            return toJSON2;
          case "toString":
            return toString2;
          case "valueOf":
            return valueOf;
          default:
            const proto = findProtocol(property);
            return proto !== null ? proto : void 0;
        }
      },
      set(target, property, value, receiver) {
        return false;
      },
      ownKeys(target) {
        if (api === null)
          return [];
        const numProtocolsBuf = Memory.alloc(pointerSize);
        const protocolHandles = api.objc_copyProtocolList(numProtocolsBuf);
        try {
          const numProtocols = numProtocolsBuf.readUInt();
          if (numProtocols !== numCachedProtocols) {
            cachedProtocols = {};
            for (let i = 0; i !== numProtocols; i++) {
              const handle2 = protocolHandles.add(i * pointerSize).readPointer();
              const name = api.protocol_getName(handle2).readUtf8String();
              cachedProtocols[name] = handle2;
            }
            numCachedProtocols = numProtocols;
          }
        } finally {
          api.free(protocolHandles);
        }
        return Object.keys(cachedProtocols);
      },
      getOwnPropertyDescriptor(target, property) {
        return {
          writable: false,
          configurable: true,
          enumerable: true
        };
      }
    });
    function hasProperty(name) {
      if (registryBuiltins.has(name))
        return true;
      return findProtocol(name) !== null;
    }
    function findProtocol(name) {
      let handle2 = cachedProtocols[name];
      if (handle2 === void 0) {
        handle2 = api.objc_getProtocol(Memory.allocUtf8String(name));
        if (handle2.isNull())
          return null;
        cachedProtocols[name] = handle2;
        numCachedProtocols++;
      }
      return new ObjCProtocol(handle2);
    }
    function toJSON2() {
      return Object.keys(registry).reduce(function(r, name) {
        r[name] = { handle: cachedProtocols[name] };
        return r;
      }, {});
    }
    function toString2() {
      return "ProtocolRegistry";
    }
    function valueOf() {
      return "ProtocolRegistry";
    }
    return registry;
  }
  const objCObjectBuiltins = /* @__PURE__ */ new Set([
    "prototype",
    "constructor",
    "handle",
    "hasOwnProperty",
    "toJSON",
    "toString",
    "valueOf",
    "equals",
    "$kind",
    "$super",
    "$superClass",
    "$class",
    "$className",
    "$moduleName",
    "$protocols",
    "$methods",
    "$ownMethods",
    "$ivars"
  ]);
  function ObjCObject(handle2, protocol, cachedIsClass, superSpecifier2) {
    let cachedClassHandle = null;
    let cachedKind = null;
    let cachedSuper = null;
    let cachedSuperClass = null;
    let cachedClass = null;
    let cachedClassName = null;
    let cachedModuleName = null;
    let cachedProtocols = null;
    let cachedMethodNames = null;
    let cachedProtocolMethods = null;
    let respondsToSelector = null;
    const cachedMethods2 = {};
    let cachedNativeMethodNames = null;
    let cachedOwnMethodNames = null;
    let cachedIvars = null;
    handle2 = getHandle(handle2);
    if (cachedIsClass === void 0) {
      const klass = api.object_getClass(handle2);
      const key = klass.toString();
      if (!realizedClasses.has(key)) {
        api.objc_lookUpClass(api.class_getName(klass));
        realizedClasses.add(key);
      }
    }
    const self = new Proxy(this, {
      has(target, property) {
        return hasProperty(property);
      },
      get(target, property, receiver) {
        switch (property) {
          case "handle":
            return handle2;
          case "prototype":
            return target.prototype;
          case "constructor":
            return target.constructor;
          case "hasOwnProperty":
            return hasProperty;
          case "toJSON":
            return toJSON2;
          case "toString":
          case "valueOf":
            const descriptionImpl = receiver.description;
            if (descriptionImpl !== void 0) {
              const description = descriptionImpl.call(receiver);
              if (description !== null)
                return description.UTF8String.bind(description);
            }
            return function() {
              return receiver.$className;
            };
          case "equals":
            return equals2;
          case "$kind":
            if (cachedKind === null) {
              if (isClass())
                cachedKind = api.class_isMetaClass(handle2) ? "meta-class" : "class";
              else
                cachedKind = "instance";
            }
            return cachedKind;
          case "$super":
            if (cachedSuper === null) {
              const superHandle = api.class_getSuperclass(classHandle());
              if (!superHandle.isNull()) {
                const specifier = Memory.alloc(2 * pointerSize);
                specifier.writePointer(handle2);
                specifier.add(pointerSize).writePointer(superHandle);
                cachedSuper = [new ObjCObject(handle2, void 0, cachedIsClass, specifier)];
              } else {
                cachedSuper = [null];
              }
            }
            return cachedSuper[0];
          case "$superClass":
            if (cachedSuperClass === null) {
              const superClassHandle = api.class_getSuperclass(classHandle());
              if (!superClassHandle.isNull()) {
                cachedSuperClass = [new ObjCObject(superClassHandle)];
              } else {
                cachedSuperClass = [null];
              }
            }
            return cachedSuperClass[0];
          case "$class":
            if (cachedClass === null)
              cachedClass = new ObjCObject(api.object_getClass(handle2), void 0, true);
            return cachedClass;
          case "$className":
            if (cachedClassName === null) {
              if (superSpecifier2)
                cachedClassName = api.class_getName(superSpecifier2.add(pointerSize).readPointer()).readUtf8String();
              else if (isClass())
                cachedClassName = api.class_getName(handle2).readUtf8String();
              else
                cachedClassName = api.object_getClassName(handle2).readUtf8String();
            }
            return cachedClassName;
          case "$moduleName":
            if (cachedModuleName === null) {
              cachedModuleName = api.class_getImageName(classHandle()).readUtf8String();
            }
            return cachedModuleName;
          case "$protocols":
            if (cachedProtocols === null) {
              cachedProtocols = {};
              const numProtocolsBuf = Memory.alloc(pointerSize);
              const protocolHandles = api.class_copyProtocolList(classHandle(), numProtocolsBuf);
              if (!protocolHandles.isNull()) {
                try {
                  const numProtocols = numProtocolsBuf.readUInt();
                  for (let i = 0; i !== numProtocols; i++) {
                    const protocolHandle = protocolHandles.add(i * pointerSize).readPointer();
                    const p = new ObjCProtocol(protocolHandle);
                    cachedProtocols[p.name] = p;
                  }
                } finally {
                  api.free(protocolHandles);
                }
              }
            }
            return cachedProtocols;
          case "$methods":
            if (cachedNativeMethodNames === null) {
              const klass = superSpecifier2 ? superSpecifier2.add(pointerSize).readPointer() : classHandle();
              const meta = api.object_getClass(klass);
              const names = /* @__PURE__ */ new Set();
              let cur = meta;
              do {
                for (let methodName of collectMethodNames(cur, "+ "))
                  names.add(methodName);
                cur = api.class_getSuperclass(cur);
              } while (!cur.isNull());
              cur = klass;
              do {
                for (let methodName of collectMethodNames(cur, "- "))
                  names.add(methodName);
                cur = api.class_getSuperclass(cur);
              } while (!cur.isNull());
              cachedNativeMethodNames = Array.from(names);
            }
            return cachedNativeMethodNames;
          case "$ownMethods":
            if (cachedOwnMethodNames === null) {
              const klass = superSpecifier2 ? superSpecifier2.add(pointerSize).readPointer() : classHandle();
              const meta = api.object_getClass(klass);
              const classMethods = collectMethodNames(meta, "+ ");
              const instanceMethods = collectMethodNames(klass, "- ");
              cachedOwnMethodNames = classMethods.concat(instanceMethods);
            }
            return cachedOwnMethodNames;
          case "$ivars":
            if (cachedIvars === null) {
              if (isClass())
                cachedIvars = {};
              else
                cachedIvars = new ObjCIvars(self, classHandle());
            }
            return cachedIvars;
          default:
            if (typeof property === "symbol") {
              return target[property];
            }
            if (protocol) {
              const details = findProtocolMethod(property);
              if (details === null || !details.implemented)
                return void 0;
            }
            const wrapper = findMethodWrapper(property);
            if (wrapper === null)
              return void 0;
            return wrapper;
        }
      },
      set(target, property, value, receiver) {
        return false;
      },
      ownKeys(target) {
        if (cachedMethodNames === null) {
          if (!protocol) {
            const jsNames = {};
            const nativeNames = {};
            let cur = api.object_getClass(handle2);
            do {
              const numMethodsBuf = Memory.alloc(pointerSize);
              const methodHandles = api.class_copyMethodList(cur, numMethodsBuf);
              const fullNamePrefix = isClass() ? "+ " : "- ";
              try {
                const numMethods = numMethodsBuf.readUInt();
                for (let i = 0; i !== numMethods; i++) {
                  const methodHandle = methodHandles.add(i * pointerSize).readPointer();
                  const sel2 = api.method_getName(methodHandle);
                  const nativeName = api.sel_getName(sel2).readUtf8String();
                  if (nativeNames[nativeName] !== void 0)
                    continue;
                  nativeNames[nativeName] = nativeName;
                  const jsName = jsMethodName(nativeName);
                  let serial = 2;
                  let name = jsName;
                  while (jsNames[name] !== void 0) {
                    serial++;
                    name = jsName + serial;
                  }
                  jsNames[name] = true;
                  const fullName = fullNamePrefix + nativeName;
                  if (cachedMethods2[fullName] === void 0) {
                    const details = {
                      sel: sel2,
                      handle: methodHandle,
                      wrapper: null
                    };
                    cachedMethods2[fullName] = details;
                    cachedMethods2[name] = details;
                  }
                }
              } finally {
                api.free(methodHandles);
              }
              cur = api.class_getSuperclass(cur);
            } while (!cur.isNull());
            cachedMethodNames = Object.keys(jsNames);
          } else {
            const methodNames = [];
            const protocolMethods = allProtocolMethods();
            Object.keys(protocolMethods).forEach(function(methodName) {
              if (methodName[0] !== "+" && methodName[0] !== "-") {
                const details = protocolMethods[methodName];
                if (details.implemented) {
                  methodNames.push(methodName);
                }
              }
            });
            cachedMethodNames = methodNames;
          }
        }
        return ["handle"].concat(cachedMethodNames);
      },
      getOwnPropertyDescriptor(target, property) {
        return {
          writable: false,
          configurable: true,
          enumerable: true
        };
      }
    });
    if (protocol) {
      respondsToSelector = !isClass() ? findMethodWrapper("- respondsToSelector:") : null;
    }
    return self;
    function hasProperty(name) {
      if (objCObjectBuiltins.has(name))
        return true;
      if (protocol) {
        const details = findProtocolMethod(name);
        return !!(details !== null && details.implemented);
      }
      return findMethod(name) !== null;
    }
    function classHandle() {
      if (cachedClassHandle === null)
        cachedClassHandle = isClass() ? handle2 : api.object_getClass(handle2);
      return cachedClassHandle;
    }
    function isClass() {
      if (cachedIsClass === void 0) {
        if (api.object_isClass)
          cachedIsClass = !!api.object_isClass(handle2);
        else
          cachedIsClass = !!api.class_isMetaClass(api.object_getClass(handle2));
      }
      return cachedIsClass;
    }
    function findMethod(rawName) {
      let method2 = cachedMethods2[rawName];
      if (method2 !== void 0)
        return method2;
      const tokens = parseMethodName(rawName);
      const fullName = tokens[2];
      method2 = cachedMethods2[fullName];
      if (method2 !== void 0) {
        cachedMethods2[rawName] = method2;
        return method2;
      }
      const kind = tokens[0];
      const name = tokens[1];
      const sel2 = selector(name);
      const defaultKind = isClass() ? "+" : "-";
      if (protocol) {
        const details = findProtocolMethod(fullName);
        if (details !== null) {
          method2 = {
            sel: sel2,
            types: details.types,
            wrapper: null,
            kind
          };
        }
      }
      if (method2 === void 0) {
        const methodHandle = kind === "+" ? api.class_getClassMethod(classHandle(), sel2) : api.class_getInstanceMethod(classHandle(), sel2);
        if (!methodHandle.isNull()) {
          method2 = {
            sel: sel2,
            handle: methodHandle,
            wrapper: null,
            kind
          };
        } else {
          if (isClass() || kind !== "-" || name === "forwardingTargetForSelector:" || name === "methodSignatureForSelector:") {
            return null;
          }
          let target = self;
          if ("- forwardingTargetForSelector:" in self) {
            const forwardingTarget = self.forwardingTargetForSelector_(sel2);
            if (forwardingTarget !== null && forwardingTarget.$kind === "instance") {
              target = forwardingTarget;
            } else {
              return null;
            }
          } else {
            return null;
          }
          const methodHandle2 = api.class_getInstanceMethod(api.object_getClass(target.handle), sel2);
          if (methodHandle2.isNull()) {
            return null;
          }
          let types2 = api.method_getTypeEncoding(methodHandle2).readUtf8String();
          if (types2 === null || types2 === "") {
            types2 = stealTypesFromProtocols(target, fullName);
            if (types2 === null)
              types2 = stealTypesFromProtocols(self, fullName);
            if (types2 === null)
              return null;
          }
          method2 = {
            sel: sel2,
            types: types2,
            wrapper: null,
            kind
          };
        }
      }
      cachedMethods2[fullName] = method2;
      cachedMethods2[rawName] = method2;
      if (kind === defaultKind)
        cachedMethods2[jsMethodName(name)] = method2;
      return method2;
    }
    function stealTypesFromProtocols(klass, fullName) {
      const candidates = Object.keys(klass.$protocols).map((protocolName) => flatProtocolMethods({}, klass.$protocols[protocolName])).reduce((allMethods, methods) => {
        Object.assign(allMethods, methods);
        return allMethods;
      }, {});
      const method2 = candidates[fullName];
      if (method2 === void 0) {
        return null;
      }
      return method2.types;
    }
    function flatProtocolMethods(result, protocol2) {
      if (protocol2.methods !== void 0) {
        Object.assign(result, protocol2.methods);
      }
      if (protocol2.protocol !== void 0) {
        flatProtocolMethods(result, protocol2.protocol);
      }
      return result;
    }
    function findProtocolMethod(rawName) {
      const protocolMethods = allProtocolMethods();
      const details = protocolMethods[rawName];
      return details !== void 0 ? details : null;
    }
    function allProtocolMethods() {
      if (cachedProtocolMethods === null) {
        const methods = {};
        const protocols = collectProtocols(protocol);
        const defaultKind = isClass() ? "+" : "-";
        Object.keys(protocols).forEach(function(name) {
          const p = protocols[name];
          const m2 = p.methods;
          Object.keys(m2).forEach(function(fullMethodName) {
            const method2 = m2[fullMethodName];
            const methodName = fullMethodName.substr(2);
            const kind = fullMethodName[0];
            let didCheckImplemented = false;
            let implemented = false;
            const details = {
              types: method2.types
            };
            Object.defineProperty(details, "implemented", {
              get() {
                if (!didCheckImplemented) {
                  if (method2.required) {
                    implemented = true;
                  } else {
                    implemented = respondsToSelector !== null && respondsToSelector.call(self, selector(methodName));
                  }
                  didCheckImplemented = true;
                }
                return implemented;
              }
            });
            methods[fullMethodName] = details;
            if (kind === defaultKind)
              methods[jsMethodName(methodName)] = details;
          });
        });
        cachedProtocolMethods = methods;
      }
      return cachedProtocolMethods;
    }
    function findMethodWrapper(name) {
      const method2 = findMethod(name);
      if (method2 === null)
        return null;
      let wrapper = method2.wrapper;
      if (wrapper === null) {
        wrapper = makeMethodInvocationWrapper(method2, self, superSpecifier2, defaultInvocationOptions);
        method2.wrapper = wrapper;
      }
      return wrapper;
    }
    function parseMethodName(rawName) {
      const match = /([+\-])\s(\S+)/.exec(rawName);
      let name, kind;
      if (match === null) {
        kind = isClass() ? "+" : "-";
        name = objcMethodName(rawName);
      } else {
        kind = match[1];
        name = match[2];
      }
      const fullName = [kind, name].join(" ");
      return [kind, name, fullName];
    }
    function toJSON2() {
      return {
        handle: handle2.toString()
      };
    }
    function equals2(ptr2) {
      return handle2.equals(getHandle(ptr2));
    }
  }
  function getReplacementMethodImplementation(methodHandle) {
    const existingEntry = replacedMethods.get(methodHandle.toString());
    if (existingEntry === void 0)
      return null;
    const [, newImp] = existingEntry;
    return newImp;
  }
  function replaceMethodImplementation(methodHandle, imp) {
    const key = methodHandle.toString();
    let oldImp;
    const existingEntry = replacedMethods.get(key);
    if (existingEntry !== void 0)
      [oldImp] = existingEntry;
    else
      oldImp = api.method_getImplementation(methodHandle);
    if (!imp.equals(oldImp))
      replacedMethods.set(key, [oldImp, imp]);
    else
      replacedMethods.delete(key);
    api.method_setImplementation(methodHandle, imp);
  }
  function collectMethodNames(klass, prefix) {
    const names = [];
    const numMethodsBuf = Memory.alloc(pointerSize);
    const methodHandles = api.class_copyMethodList(klass, numMethodsBuf);
    try {
      const numMethods = numMethodsBuf.readUInt();
      for (let i = 0; i !== numMethods; i++) {
        const methodHandle = methodHandles.add(i * pointerSize).readPointer();
        const sel2 = api.method_getName(methodHandle);
        const nativeName = api.sel_getName(sel2).readUtf8String();
        names.push(prefix + nativeName);
      }
    } finally {
      api.free(methodHandles);
    }
    return names;
  }
  function ObjCProtocol(handle2) {
    let cachedName = null;
    let cachedProtocols = null;
    let cachedProperties = null;
    let cachedMethods2 = null;
    Object.defineProperty(this, "handle", {
      value: handle2,
      enumerable: true
    });
    Object.defineProperty(this, "name", {
      get() {
        if (cachedName === null)
          cachedName = api.protocol_getName(handle2).readUtf8String();
        return cachedName;
      },
      enumerable: true
    });
    Object.defineProperty(this, "protocols", {
      get() {
        if (cachedProtocols === null) {
          cachedProtocols = {};
          const numProtocolsBuf = Memory.alloc(pointerSize);
          const protocolHandles = api.protocol_copyProtocolList(handle2, numProtocolsBuf);
          if (!protocolHandles.isNull()) {
            try {
              const numProtocols = numProtocolsBuf.readUInt();
              for (let i = 0; i !== numProtocols; i++) {
                const protocolHandle = protocolHandles.add(i * pointerSize).readPointer();
                const protocol = new ObjCProtocol(protocolHandle);
                cachedProtocols[protocol.name] = protocol;
              }
            } finally {
              api.free(protocolHandles);
            }
          }
        }
        return cachedProtocols;
      },
      enumerable: true
    });
    Object.defineProperty(this, "properties", {
      get() {
        if (cachedProperties === null) {
          cachedProperties = {};
          const numBuf = Memory.alloc(pointerSize);
          const propertyHandles = api.protocol_copyPropertyList(handle2, numBuf);
          if (!propertyHandles.isNull()) {
            try {
              const numProperties = numBuf.readUInt();
              for (let i = 0; i !== numProperties; i++) {
                const propertyHandle = propertyHandles.add(i * pointerSize).readPointer();
                const propName = api.property_getName(propertyHandle).readUtf8String();
                const attributes = {};
                const attributeEntries = api.property_copyAttributeList(propertyHandle, numBuf);
                if (!attributeEntries.isNull()) {
                  try {
                    const numAttributeValues = numBuf.readUInt();
                    for (let j = 0; j !== numAttributeValues; j++) {
                      const attributeEntry = attributeEntries.add(j * (2 * pointerSize));
                      const name = attributeEntry.readPointer().readUtf8String();
                      const value = attributeEntry.add(pointerSize).readPointer().readUtf8String();
                      attributes[name] = value;
                    }
                  } finally {
                    api.free(attributeEntries);
                  }
                }
                cachedProperties[propName] = attributes;
              }
            } finally {
              api.free(propertyHandles);
            }
          }
        }
        return cachedProperties;
      },
      enumerable: true
    });
    Object.defineProperty(this, "methods", {
      get() {
        if (cachedMethods2 === null) {
          cachedMethods2 = {};
          const numBuf = Memory.alloc(pointerSize);
          collectMethods(cachedMethods2, numBuf, { required: true, instance: false });
          collectMethods(cachedMethods2, numBuf, { required: false, instance: false });
          collectMethods(cachedMethods2, numBuf, { required: true, instance: true });
          collectMethods(cachedMethods2, numBuf, { required: false, instance: true });
        }
        return cachedMethods2;
      },
      enumerable: true
    });
    function collectMethods(methods, numBuf, spec) {
      const methodDescValues = api.protocol_copyMethodDescriptionList(handle2, spec.required ? 1 : 0, spec.instance ? 1 : 0, numBuf);
      if (methodDescValues.isNull())
        return;
      try {
        const numMethodDescValues = numBuf.readUInt();
        for (let i = 0; i !== numMethodDescValues; i++) {
          const methodDesc = methodDescValues.add(i * (2 * pointerSize));
          const name = (spec.instance ? "- " : "+ ") + selectorAsString(methodDesc.readPointer());
          const types2 = methodDesc.add(pointerSize).readPointer().readUtf8String();
          methods[name] = {
            required: spec.required,
            types: types2
          };
        }
      } finally {
        api.free(methodDescValues);
      }
    }
  }
  const objCIvarsBuiltins = /* @__PURE__ */ new Set([
    "prototype",
    "constructor",
    "hasOwnProperty",
    "toJSON",
    "toString",
    "valueOf"
  ]);
  function ObjCIvars(instance, classHandle) {
    const ivars = {};
    let cachedIvarNames = null;
    let classHandles = [];
    let currentClassHandle = classHandle;
    do {
      classHandles.unshift(currentClassHandle);
      currentClassHandle = api.class_getSuperclass(currentClassHandle);
    } while (!currentClassHandle.isNull());
    const numIvarsBuf = Memory.alloc(pointerSize);
    classHandles.forEach((c) => {
      const ivarHandles = api.class_copyIvarList(c, numIvarsBuf);
      try {
        const numIvars = numIvarsBuf.readUInt();
        for (let i = 0; i !== numIvars; i++) {
          const handle2 = ivarHandles.add(i * pointerSize).readPointer();
          const name = api.ivar_getName(handle2).readUtf8String();
          ivars[name] = [handle2, null];
        }
      } finally {
        api.free(ivarHandles);
      }
    });
    const self = new Proxy(this, {
      has(target, property) {
        return hasProperty(property);
      },
      get(target, property, receiver) {
        switch (property) {
          case "prototype":
            return target.prototype;
          case "constructor":
            return target.constructor;
          case "hasOwnProperty":
            return hasProperty;
          case "toJSON":
            return toJSON2;
          case "toString":
            return toString2;
          case "valueOf":
            return valueOf;
          default:
            const ivar = findIvar(property);
            if (ivar === null)
              return void 0;
            return ivar.get();
        }
      },
      set(target, property, value, receiver) {
        const ivar = findIvar(property);
        if (ivar === null)
          throw new Error("Unknown ivar");
        ivar.set(value);
        return true;
      },
      ownKeys(target) {
        if (cachedIvarNames === null)
          cachedIvarNames = Object.keys(ivars);
        return cachedIvarNames;
      },
      getOwnPropertyDescriptor(target, property) {
        return {
          writable: true,
          configurable: true,
          enumerable: true
        };
      }
    });
    return self;
    function findIvar(name) {
      const entry = ivars[name];
      if (entry === void 0)
        return null;
      let impl = entry[1];
      if (impl === null) {
        const ivar = entry[0];
        const offset = api.ivar_getOffset(ivar).toInt32();
        const address = instance.handle.add(offset);
        const type = parseType(api.ivar_getTypeEncoding(ivar).readUtf8String());
        const fromNative = type.fromNative || identityTransform;
        const toNative = type.toNative || identityTransform;
        let read2, write3;
        if (name === "isa") {
          read2 = readObjectIsa;
          write3 = function() {
            throw new Error("Unable to set the isa instance variable");
          };
        } else {
          read2 = type.read;
          write3 = type.write;
        }
        impl = {
          get() {
            return fromNative.call(instance, read2(address));
          },
          set(value) {
            write3(address, toNative.call(instance, value));
          }
        };
        entry[1] = impl;
      }
      return impl;
    }
    function hasProperty(name) {
      if (objCIvarsBuiltins.has(name))
        return true;
      return ivars.hasOwnProperty(name);
    }
    function toJSON2() {
      return Object.keys(self).reduce(function(result, name) {
        result[name] = self[name];
        return result;
      }, {});
    }
    function toString2() {
      return "ObjCIvars";
    }
    function valueOf() {
      return "ObjCIvars";
    }
  }
  let blockDescriptorAllocSize, blockDescriptorDeclaredSize, blockDescriptorOffsets;
  let blockSize, blockOffsets;
  if (pointerSize === 4) {
    blockDescriptorAllocSize = 16;
    blockDescriptorDeclaredSize = 20;
    blockDescriptorOffsets = {
      reserved: 0,
      size: 4,
      rest: 8
    };
    blockSize = 20;
    blockOffsets = {
      isa: 0,
      flags: 4,
      reserved: 8,
      invoke: 12,
      descriptor: 16
    };
  } else {
    blockDescriptorAllocSize = 32;
    blockDescriptorDeclaredSize = 32;
    blockDescriptorOffsets = {
      reserved: 0,
      size: 8,
      rest: 16
    };
    blockSize = 32;
    blockOffsets = {
      isa: 0,
      flags: 8,
      reserved: 12,
      invoke: 16,
      descriptor: 24
    };
  }
  const BLOCK_HAS_COPY_DISPOSE = 1 << 25;
  const BLOCK_HAS_CTOR = 1 << 26;
  const BLOCK_IS_GLOBAL = 1 << 28;
  const BLOCK_HAS_STRET = 1 << 29;
  const BLOCK_HAS_SIGNATURE = 1 << 30;
  function Block(target, options = defaultInvocationOptions) {
    this._options = options;
    if (target instanceof NativePointer) {
      const descriptor = target.add(blockOffsets.descriptor).readPointer();
      this.handle = target;
      const flags = target.add(blockOffsets.flags).readU32();
      if ((flags & BLOCK_HAS_SIGNATURE) !== 0) {
        const signatureOffset = (flags & BLOCK_HAS_COPY_DISPOSE) !== 0 ? 2 : 0;
        this.types = descriptor.add(blockDescriptorOffsets.rest + signatureOffset * pointerSize).readPointer().readCString();
        this._signature = parseSignature(this.types);
      } else {
        this._signature = null;
      }
    } else {
      this.declare(target);
      const descriptor = Memory.alloc(blockDescriptorAllocSize + blockSize);
      const block2 = descriptor.add(blockDescriptorAllocSize);
      const typesStr = Memory.allocUtf8String(this.types);
      descriptor.add(blockDescriptorOffsets.reserved).writeULong(0);
      descriptor.add(blockDescriptorOffsets.size).writeULong(blockDescriptorDeclaredSize);
      descriptor.add(blockDescriptorOffsets.rest).writePointer(typesStr);
      block2.add(blockOffsets.isa).writePointer(classRegistry.__NSGlobalBlock__);
      block2.add(blockOffsets.flags).writeU32(BLOCK_HAS_SIGNATURE | BLOCK_IS_GLOBAL);
      block2.add(blockOffsets.reserved).writeU32(0);
      block2.add(blockOffsets.descriptor).writePointer(descriptor);
      this.handle = block2;
      this._storage = [descriptor, typesStr];
      this.implementation = target.implementation;
    }
  }
  Object.defineProperties(Block.prototype, {
    implementation: {
      enumerable: true,
      get() {
        const address = this.handle.add(blockOffsets.invoke).readPointer().strip();
        const signature2 = this._getSignature();
        return makeBlockInvocationWrapper(this, signature2, new NativeFunction(
          address.sign(),
          signature2.retType.type,
          signature2.argTypes.map(function(arg) {
            return arg.type;
          }),
          this._options
        ));
      },
      set(func) {
        const signature2 = this._getSignature();
        const callback = new NativeCallback(
          makeBlockImplementationWrapper(this, signature2, func),
          signature2.retType.type,
          signature2.argTypes.map(function(arg) {
            return arg.type;
          })
        );
        this._callback = callback;
        const location = this.handle.add(blockOffsets.invoke);
        const prot = Memory.queryProtection(location);
        const writable = prot.includes("w");
        if (!writable)
          Memory.protect(location, Process.pointerSize, "rw-");
        location.writePointer(callback.strip().sign("ia", location));
        if (!writable)
          Memory.protect(location, Process.pointerSize, prot);
      }
    },
    declare: {
      value(signature2) {
        let types2 = signature2.types;
        if (types2 === void 0) {
          types2 = unparseSignature(signature2.retType, ["block"].concat(signature2.argTypes));
        }
        this.types = types2;
        this._signature = parseSignature(types2);
      }
    },
    _getSignature: {
      value() {
        const signature2 = this._signature;
        if (signature2 === null)
          throw new Error("block is missing signature; call declare()");
        return signature2;
      }
    }
  });
  function collectProtocols(p, acc) {
    acc = acc || {};
    acc[p.name] = p;
    const parentProtocols = p.protocols;
    Object.keys(parentProtocols).forEach(function(name) {
      collectProtocols(parentProtocols[name], acc);
    });
    return acc;
  }
  function registerProxy(properties) {
    const protocols = properties.protocols || [];
    const methods = properties.methods || {};
    const events = properties.events || {};
    const supportedSelectors = new Set(
      Object.keys(methods).filter((m2) => /([+\-])\s(\S+)/.exec(m2) !== null).map((m2) => m2.split(" ")[1])
    );
    const proxyMethods = {
      "- dealloc": function() {
        const target = this.data.target;
        if ("- release" in target)
          target.release();
        unbind(this.self);
        this.super.dealloc();
        const callback = this.data.events.dealloc;
        if (callback !== void 0)
          callback.call(this);
      },
      "- respondsToSelector:": function(sel2) {
        const selector2 = selectorAsString(sel2);
        if (supportedSelectors.has(selector2))
          return true;
        return this.data.target.respondsToSelector_(sel2);
      },
      "- forwardingTargetForSelector:": function(sel2) {
        const callback = this.data.events.forward;
        if (callback !== void 0)
          callback.call(this, selectorAsString(sel2));
        return this.data.target;
      },
      "- methodSignatureForSelector:": function(sel2) {
        return this.data.target.methodSignatureForSelector_(sel2);
      },
      "- forwardInvocation:": function(invocation) {
        invocation.invokeWithTarget_(this.data.target);
      }
    };
    for (var key in methods) {
      if (methods.hasOwnProperty(key)) {
        if (proxyMethods.hasOwnProperty(key))
          throw new Error("The '" + key + "' method is reserved");
        proxyMethods[key] = methods[key];
      }
    }
    const ProxyClass = registerClass({
      name: properties.name,
      super: classRegistry.NSProxy,
      protocols,
      methods: proxyMethods
    });
    return function(target, data) {
      target = target instanceof NativePointer ? new ObjCObject(target) : target;
      data = data || {};
      const instance = ProxyClass.alloc().autorelease();
      const boundData = getBoundData(instance);
      boundData.target = "- retain" in target ? target.retain() : target;
      boundData.events = events;
      for (var key2 in data) {
        if (data.hasOwnProperty(key2)) {
          if (boundData.hasOwnProperty(key2))
            throw new Error("The '" + key2 + "' property is reserved");
          boundData[key2] = data[key2];
        }
      }
      this.handle = instance.handle;
    };
  }
  function registerClass(properties) {
    let name = properties.name;
    if (name === void 0)
      name = makeClassName();
    const superClass = properties.super !== void 0 ? properties.super : classRegistry.NSObject;
    const protocols = properties.protocols || [];
    const methods = properties.methods || {};
    const methodCallbacks = [];
    const classHandle = api.objc_allocateClassPair(superClass !== null ? superClass.handle : NULL, Memory.allocUtf8String(name), ptr("0"));
    if (classHandle.isNull())
      throw new Error("Unable to register already registered class '" + name + "'");
    const metaClassHandle = api.object_getClass(classHandle);
    try {
      protocols.forEach(function(protocol) {
        api.class_addProtocol(classHandle, protocol.handle);
      });
      Object.keys(methods).forEach(function(rawMethodName) {
        const match = /([+\-])\s(\S+)/.exec(rawMethodName);
        if (match === null)
          throw new Error("Invalid method name");
        const kind = match[1];
        const name2 = match[2];
        let method2;
        const value = methods[rawMethodName];
        if (typeof value === "function") {
          let types3 = null;
          if (rawMethodName in superClass) {
            types3 = superClass[rawMethodName].types;
          } else {
            for (let protocol of protocols) {
              const method3 = protocol.methods[rawMethodName];
              if (method3 !== void 0) {
                types3 = method3.types;
                break;
              }
            }
          }
          if (types3 === null)
            throw new Error("Unable to find '" + rawMethodName + "' in super-class or any of its protocols");
          method2 = {
            types: types3,
            implementation: value
          };
        } else {
          method2 = value;
        }
        const target = kind === "+" ? metaClassHandle : classHandle;
        let types2 = method2.types;
        if (types2 === void 0) {
          types2 = unparseSignature(method2.retType, [kind === "+" ? "class" : "object", "selector"].concat(method2.argTypes));
        }
        const signature2 = parseSignature(types2);
        const implementation2 = new NativeCallback(
          makeMethodImplementationWrapper(signature2, method2.implementation),
          signature2.retType.type,
          signature2.argTypes.map(function(arg) {
            return arg.type;
          })
        );
        methodCallbacks.push(implementation2);
        api.class_addMethod(target, selector(name2), implementation2, Memory.allocUtf8String(types2));
      });
    } catch (e) {
      api.objc_disposeClassPair(classHandle);
      throw e;
    }
    api.objc_registerClassPair(classHandle);
    classHandle._methodCallbacks = methodCallbacks;
    Script.bindWeak(classHandle, makeClassDestructor(ptr(classHandle)));
    return new ObjCObject(classHandle);
  }
  function makeClassDestructor(classHandle) {
    return function() {
      api.objc_disposeClassPair(classHandle);
    };
  }
  function registerProtocol(properties) {
    let name = properties.name;
    if (name === void 0)
      name = makeProtocolName();
    const protocols = properties.protocols || [];
    const methods = properties.methods || {};
    protocols.forEach(function(protocol) {
      if (!(protocol instanceof ObjCProtocol))
        throw new Error("Expected protocol");
    });
    const methodSpecs = Object.keys(methods).map(function(rawMethodName) {
      const method2 = methods[rawMethodName];
      const match = /([+\-])\s(\S+)/.exec(rawMethodName);
      if (match === null)
        throw new Error("Invalid method name");
      const kind = match[1];
      const name2 = match[2];
      let types2 = method2.types;
      if (types2 === void 0) {
        types2 = unparseSignature(method2.retType, [kind === "+" ? "class" : "object", "selector"].concat(method2.argTypes));
      }
      return {
        kind,
        name: name2,
        types: types2,
        optional: method2.optional
      };
    });
    const handle2 = api.objc_allocateProtocol(Memory.allocUtf8String(name));
    if (handle2.isNull())
      throw new Error("Unable to register already registered protocol '" + name + "'");
    protocols.forEach(function(protocol) {
      api.protocol_addProtocol(handle2, protocol.handle);
    });
    methodSpecs.forEach(function(spec) {
      const isRequiredMethod = spec.optional ? 0 : 1;
      const isInstanceMethod = spec.kind === "-" ? 1 : 0;
      api.protocol_addMethodDescription(handle2, selector(spec.name), Memory.allocUtf8String(spec.types), isRequiredMethod, isInstanceMethod);
    });
    api.objc_registerProtocol(handle2);
    return new ObjCProtocol(handle2);
  }
  function getHandle(obj) {
    if (obj instanceof NativePointer)
      return obj;
    else if (typeof obj === "object" && obj.hasOwnProperty("handle"))
      return obj.handle;
    else
      throw new Error("Expected NativePointer or ObjC.Object instance");
  }
  function bind(obj, data) {
    const handle2 = getHandle(obj);
    const self = obj instanceof ObjCObject ? obj : new ObjCObject(handle2);
    bindings.set(handle2.toString(), {
      self,
      super: self.$super,
      data
    });
  }
  function unbind(obj) {
    const handle2 = getHandle(obj);
    bindings.delete(handle2.toString());
  }
  function getBoundData(obj) {
    return getBinding(obj).data;
  }
  function getBinding(obj) {
    const handle2 = getHandle(obj);
    const key = handle2.toString();
    let binding = bindings.get(key);
    if (binding === void 0) {
      const self = obj instanceof ObjCObject ? obj : new ObjCObject(handle2);
      binding = {
        self,
        super: self.$super,
        data: {}
      };
      bindings.set(key, binding);
    }
    return binding;
  }
  function enumerateLoadedClasses(...args) {
    const allModules = new ModuleMap();
    let unfiltered = false;
    let callbacks;
    let modules;
    if (args.length === 1) {
      callbacks = args[0];
    } else {
      callbacks = args[1];
      const options = args[0];
      modules = options.ownedBy;
    }
    if (modules === void 0) {
      modules = allModules;
      unfiltered = true;
    }
    const classGetName = api.class_getName;
    const onMatch = callbacks.onMatch.bind(callbacks);
    const swiftNominalTypeDescriptorOffset = (pointerSize === 8 ? 8 : 11) * pointerSize;
    const numClasses = api.objc_getClassList(NULL, 0);
    const classHandles = Memory.alloc(numClasses * pointerSize);
    api.objc_getClassList(classHandles, numClasses);
    for (let i = 0; i !== numClasses; i++) {
      const classHandle = classHandles.add(i * pointerSize).readPointer();
      const rawName = classGetName(classHandle);
      let name = null;
      let modulePath = modules.findPath(rawName);
      const possiblySwift = modulePath === null && (unfiltered || allModules.findPath(rawName) === null);
      if (possiblySwift) {
        name = rawName.readCString();
        const probablySwift = name.indexOf(".") !== -1;
        if (probablySwift) {
          const nominalTypeDescriptor = classHandle.add(swiftNominalTypeDescriptorOffset).readPointer();
          modulePath = modules.findPath(nominalTypeDescriptor);
        }
      }
      if (modulePath !== null) {
        if (name === null)
          name = rawName.readUtf8String();
        onMatch(name, modulePath);
      }
    }
    callbacks.onComplete();
  }
  function enumerateLoadedClassesSync(options = {}) {
    const result = {};
    enumerateLoadedClasses(options, {
      onMatch(name, owner2) {
        let group = result[owner2];
        if (group === void 0) {
          group = [];
          result[owner2] = group;
        }
        group.push(name);
      },
      onComplete() {
      }
    });
    return result;
  }
  function choose(specifier, callbacks) {
    let cls = specifier;
    let subclasses = true;
    if (!(specifier instanceof ObjCObject) && typeof specifier === "object") {
      cls = specifier.class;
      if (specifier.hasOwnProperty("subclasses"))
        subclasses = specifier.subclasses;
    }
    if (!(cls instanceof ObjCObject && (cls.$kind === "class" || cls.$kind === "meta-class")))
      throw new Error("Expected an ObjC.Object for a class or meta-class");
    const matches = get().choose(cls, subclasses).map((handle2) => new ObjCObject(handle2));
    for (const match of matches) {
      const result = callbacks.onMatch(match);
      if (result === "stop")
        break;
    }
    callbacks.onComplete();
  }
  function makeMethodInvocationWrapper(method, owner, superSpecifier, invocationOptions) {
    const sel = method.sel;
    let handle = method.handle;
    let types;
    if (handle === void 0) {
      handle = null;
      types = method.types;
    } else {
      types = api.method_getTypeEncoding(handle).readUtf8String();
    }
    const signature = parseSignature(types);
    const retType = signature.retType;
    const argTypes = signature.argTypes.slice(2);
    const objc_msgSend = superSpecifier ? getMsgSendSuperImpl(signature, invocationOptions) : getMsgSendImpl(signature, invocationOptions);
    const argVariableNames = argTypes.map(function(t, i) {
      return "a" + (i + 1);
    });
    const callArgs = [
      superSpecifier ? "superSpecifier" : "this",
      "sel"
    ].concat(argTypes.map(function(t, i) {
      if (t.toNative) {
        return "argTypes[" + i + "].toNative.call(this, " + argVariableNames[i] + ")";
      }
      return argVariableNames[i];
    }));
    let returnCaptureLeft;
    let returnCaptureRight;
    if (retType.type === "void") {
      returnCaptureLeft = "";
      returnCaptureRight = "";
    } else if (retType.fromNative) {
      returnCaptureLeft = "return retType.fromNative.call(this, ";
      returnCaptureRight = ")";
    } else {
      returnCaptureLeft = "return ";
      returnCaptureRight = "";
    }
    const m = eval("var m = function (" + argVariableNames.join(", ") + ") { " + returnCaptureLeft + "objc_msgSend(" + callArgs.join(", ") + ")" + returnCaptureRight + "; }; m;");
    Object.defineProperty(m, "handle", {
      enumerable: true,
      get: getMethodHandle
    });
    m.selector = sel;
    Object.defineProperty(m, "implementation", {
      enumerable: true,
      get() {
        const h = getMethodHandle();
        const impl = new NativeFunction(api.method_getImplementation(h), m.returnType, m.argumentTypes, invocationOptions);
        const newImp = getReplacementMethodImplementation(h);
        if (newImp !== null)
          impl._callback = newImp;
        return impl;
      },
      set(imp) {
        replaceMethodImplementation(getMethodHandle(), imp);
      }
    });
    m.returnType = retType.type;
    m.argumentTypes = signature.argTypes.map((t) => t.type);
    m.types = types;
    Object.defineProperty(m, "symbol", {
      enumerable: true,
      get() {
        return `${method.kind}[${owner.$className} ${selectorAsString(sel)}]`;
      }
    });
    m.clone = function(options) {
      return makeMethodInvocationWrapper(method, owner, superSpecifier, options);
    };
    function getMethodHandle() {
      if (handle === null) {
        if (owner.$kind === "instance") {
          let cur = owner;
          do {
            if ("- forwardingTargetForSelector:" in cur) {
              const target = cur.forwardingTargetForSelector_(sel);
              if (target === null)
                break;
              if (target.$kind !== "instance")
                break;
              const h = api.class_getInstanceMethod(target.$class.handle, sel);
              if (!h.isNull())
                handle = h;
              else
                cur = target;
            } else {
              break;
            }
          } while (handle === null);
        }
        if (handle === null)
          throw new Error("Unable to find method handle of proxied function");
      }
      return handle;
    }
    return m;
  }
  function makeMethodImplementationWrapper(signature, implementation) {
    const retType = signature.retType;
    const argTypes = signature.argTypes;
    const argVariableNames = argTypes.map(function(t, i) {
      if (i === 0)
        return "handle";
      else if (i === 1)
        return "sel";
      else
        return "a" + (i - 1);
    });
    const callArgs = argTypes.slice(2).map(function(t, i) {
      const argVariableName = argVariableNames[2 + i];
      if (t.fromNative) {
        return "argTypes[" + (2 + i) + "].fromNative.call(self, " + argVariableName + ")";
      }
      return argVariableName;
    });
    let returnCaptureLeft;
    let returnCaptureRight;
    if (retType.type === "void") {
      returnCaptureLeft = "";
      returnCaptureRight = "";
    } else if (retType.toNative) {
      returnCaptureLeft = "return retType.toNative.call(self, ";
      returnCaptureRight = ")";
    } else {
      returnCaptureLeft = "return ";
      returnCaptureRight = "";
    }
    const m = eval("var m = function (" + argVariableNames.join(", ") + ") { var binding = getBinding(handle);var self = binding.self;" + returnCaptureLeft + "implementation.call(binding" + (callArgs.length > 0 ? ", " : "") + callArgs.join(", ") + ")" + returnCaptureRight + "; }; m;");
    return m;
  }
  function makeBlockInvocationWrapper(block, signature, implementation) {
    const retType = signature.retType;
    const argTypes = signature.argTypes.slice(1);
    const argVariableNames = argTypes.map(function(t, i) {
      return "a" + (i + 1);
    });
    const callArgs = argTypes.map(function(t, i) {
      if (t.toNative) {
        return "argTypes[" + i + "].toNative.call(this, " + argVariableNames[i] + ")";
      }
      return argVariableNames[i];
    });
    let returnCaptureLeft;
    let returnCaptureRight;
    if (retType.type === "void") {
      returnCaptureLeft = "";
      returnCaptureRight = "";
    } else if (retType.fromNative) {
      returnCaptureLeft = "return retType.fromNative.call(this, ";
      returnCaptureRight = ")";
    } else {
      returnCaptureLeft = "return ";
      returnCaptureRight = "";
    }
    const f = eval("var f = function (" + argVariableNames.join(", ") + ") { " + returnCaptureLeft + "implementation(this" + (callArgs.length > 0 ? ", " : "") + callArgs.join(", ") + ")" + returnCaptureRight + "; }; f;");
    return f.bind(block);
  }
  function makeBlockImplementationWrapper(block, signature, implementation) {
    const retType = signature.retType;
    const argTypes = signature.argTypes;
    const argVariableNames = argTypes.map(function(t, i) {
      if (i === 0)
        return "handle";
      else
        return "a" + i;
    });
    const callArgs = argTypes.slice(1).map(function(t, i) {
      const argVariableName = argVariableNames[1 + i];
      if (t.fromNative) {
        return "argTypes[" + (1 + i) + "].fromNative.call(this, " + argVariableName + ")";
      }
      return argVariableName;
    });
    let returnCaptureLeft;
    let returnCaptureRight;
    if (retType.type === "void") {
      returnCaptureLeft = "";
      returnCaptureRight = "";
    } else if (retType.toNative) {
      returnCaptureLeft = "return retType.toNative.call(this, ";
      returnCaptureRight = ")";
    } else {
      returnCaptureLeft = "return ";
      returnCaptureRight = "";
    }
    const f = eval("var f = function (" + argVariableNames.join(", ") + ") { if (!this.handle.equals(handle))this.handle = handle;" + returnCaptureLeft + "implementation.call(block" + (callArgs.length > 0 ? ", " : "") + callArgs.join(", ") + ")" + returnCaptureRight + "; }; f;");
    return f.bind(block);
  }
  function rawFridaType(t) {
    return t === "object" ? "pointer" : t;
  }
  function makeClassName() {
    for (let i = 1; true; i++) {
      const name = "FridaAnonymousClass" + i;
      if (!(name in classRegistry)) {
        return name;
      }
    }
  }
  function makeProtocolName() {
    for (let i = 1; true; i++) {
      const name = "FridaAnonymousProtocol" + i;
      if (!(name in protocolRegistry)) {
        return name;
      }
    }
  }
  function objcMethodName(name) {
    return name.replace(/_/g, ":");
  }
  function jsMethodName(name) {
    let result = name.replace(/:/g, "_");
    if (objCObjectBuiltins.has(result))
      result += "2";
    return result;
  }
  const isaMasks = {
    x64: "0x7ffffffffff8",
    arm64: "0xffffffff8"
  };
  const rawMask = isaMasks[Process.arch];
  if (rawMask !== void 0) {
    const mask = ptr(rawMask);
    readObjectIsa = function(p) {
      return p.readPointer().and(mask);
    };
  } else {
    readObjectIsa = function(p) {
      return p.readPointer();
    };
  }
  function getMsgSendImpl(signature2, invocationOptions2) {
    return resolveMsgSendImpl(msgSendBySignatureId, signature2, invocationOptions2, false);
  }
  function getMsgSendSuperImpl(signature2, invocationOptions2) {
    return resolveMsgSendImpl(msgSendSuperBySignatureId, signature2, invocationOptions2, true);
  }
  function resolveMsgSendImpl(cache, signature2, invocationOptions2, isSuper) {
    if (invocationOptions2 !== defaultInvocationOptions)
      return makeMsgSendImpl(signature2, invocationOptions2, isSuper);
    const { id } = signature2;
    let impl = cache.get(id);
    if (impl === void 0) {
      impl = makeMsgSendImpl(signature2, invocationOptions2, isSuper);
      cache.set(id, impl);
    }
    return impl;
  }
  function makeMsgSendImpl(signature2, invocationOptions2, isSuper) {
    const retType2 = signature2.retType.type;
    const argTypes2 = signature2.argTypes.map(function(t) {
      return t.type;
    });
    const components = ["objc_msgSend"];
    if (isSuper)
      components.push("Super");
    const returnsStruct = retType2 instanceof Array;
    if (returnsStruct && !typeFitsInRegisters(retType2))
      components.push("_stret");
    else if (retType2 === "float" || retType2 === "double")
      components.push("_fpret");
    const name = components.join("");
    return new NativeFunction(api[name], retType2, argTypes2, invocationOptions2);
  }
  function typeFitsInRegisters(type) {
    if (Process.arch !== "x64")
      return false;
    const size = sizeOfTypeOnX64(type);
    return size <= 16;
  }
  function sizeOfTypeOnX64(type) {
    if (type instanceof Array)
      return type.reduce((total, field) => total + sizeOfTypeOnX64(field), 0);
    switch (type) {
      case "bool":
      case "char":
      case "uchar":
        return 1;
      case "int16":
      case "uint16":
        return 2;
      case "int":
      case "int32":
      case "uint":
      case "uint32":
      case "float":
        return 4;
      default:
        return 8;
    }
  }
  function unparseSignature(retType2, argTypes2) {
    const retTypeId = typeIdFromAlias(retType2);
    const argTypeIds = argTypes2.map(typeIdFromAlias);
    const argSizes = argTypeIds.map((id) => singularTypeById[id].size);
    const frameSize = argSizes.reduce((total, size) => total + size, 0);
    let frameOffset = 0;
    return retTypeId + frameSize + argTypeIds.map((id, i) => {
      const result = id + frameOffset;
      frameOffset += argSizes[i];
      return result;
    }).join("");
  }
  function parseSignature(sig) {
    const cursor = [sig, 0];
    parseQualifiers(cursor);
    const retType2 = readType(cursor);
    readNumber(cursor);
    const argTypes2 = [];
    let id = JSON.stringify(retType2.type);
    while (dataAvailable(cursor)) {
      parseQualifiers(cursor);
      const argType = readType(cursor);
      readNumber(cursor);
      argTypes2.push(argType);
      id += JSON.stringify(argType.type);
    }
    return {
      id,
      retType: retType2,
      argTypes: argTypes2
    };
  }
  function parseType(type) {
    const cursor = [type, 0];
    return readType(cursor);
  }
  function readType(cursor) {
    let id = readChar(cursor);
    if (id === "@") {
      let next = peekChar(cursor);
      if (next === "?") {
        id += next;
        skipChar(cursor);
        if (peekChar(cursor) === "<")
          skipExtendedBlock(cursor);
      } else if (next === '"') {
        skipChar(cursor);
        readUntil('"', cursor);
      }
    } else if (id === "^") {
      let next = peekChar(cursor);
      if (next === "@") {
        id += next;
        skipChar(cursor);
      }
    }
    const type = singularTypeById[id];
    if (type !== void 0) {
      return type;
    } else if (id === "[") {
      const length = readNumber(cursor);
      const elementType = readType(cursor);
      skipChar(cursor);
      return arrayType(length, elementType);
    } else if (id === "{") {
      if (!tokenExistsAhead("=", "}", cursor)) {
        readUntil("}", cursor);
        return structType([]);
      }
      readUntil("=", cursor);
      const structFields = [];
      let ch;
      while ((ch = peekChar(cursor)) !== "}") {
        if (ch === '"') {
          skipChar(cursor);
          readUntil('"', cursor);
        }
        structFields.push(readType(cursor));
      }
      skipChar(cursor);
      return structType(structFields);
    } else if (id === "(") {
      readUntil("=", cursor);
      const unionFields = [];
      while (peekChar(cursor) !== ")")
        unionFields.push(readType(cursor));
      skipChar(cursor);
      return unionType(unionFields);
    } else if (id === "b") {
      readNumber(cursor);
      return singularTypeById.i;
    } else if (id === "^") {
      readType(cursor);
      return singularTypeById["?"];
    } else if (modifiers.has(id)) {
      return readType(cursor);
    } else {
      throw new Error("Unable to handle type " + id);
    }
  }
  function skipExtendedBlock(cursor) {
    let ch;
    skipChar(cursor);
    while ((ch = peekChar(cursor)) !== ">") {
      if (peekChar(cursor) === "<") {
        skipExtendedBlock(cursor);
      } else {
        skipChar(cursor);
        if (ch === '"')
          readUntil('"', cursor);
      }
    }
    skipChar(cursor);
  }
  function readNumber(cursor) {
    let result = "";
    while (dataAvailable(cursor)) {
      const c = peekChar(cursor);
      const v = c.charCodeAt(0);
      const isDigit = v >= 48 && v <= 57;
      if (isDigit) {
        result += c;
        skipChar(cursor);
      } else {
        break;
      }
    }
    return parseInt(result);
  }
  function readUntil(token, cursor) {
    const buffer = cursor[0];
    const offset = cursor[1];
    const index = buffer.indexOf(token, offset);
    if (index === -1)
      throw new Error("Expected token '" + token + "' not found");
    const result = buffer.substring(offset, index);
    cursor[1] = index + 1;
    return result;
  }
  function readChar(cursor) {
    return cursor[0][cursor[1]++];
  }
  function peekChar(cursor) {
    return cursor[0][cursor[1]];
  }
  function tokenExistsAhead(token, terminator, cursor) {
    const [buffer, offset] = cursor;
    const tokenIndex = buffer.indexOf(token, offset);
    if (tokenIndex === -1)
      return false;
    const terminatorIndex = buffer.indexOf(terminator, offset);
    if (terminatorIndex === -1)
      throw new Error("Expected to find terminator: " + terminator);
    return tokenIndex < terminatorIndex;
  }
  function skipChar(cursor) {
    cursor[1]++;
  }
  function dataAvailable(cursor) {
    return cursor[1] !== cursor[0].length;
  }
  const qualifierById = {
    "r": "const",
    "n": "in",
    "N": "inout",
    "o": "out",
    "O": "bycopy",
    "R": "byref",
    "V": "oneway"
  };
  function parseQualifiers(cursor) {
    const qualifiers = [];
    while (true) {
      const q = qualifierById[peekChar(cursor)];
      if (q === void 0)
        break;
      qualifiers.push(q);
      skipChar(cursor);
    }
    return qualifiers;
  }
  const idByAlias = {
    "char": "c",
    "int": "i",
    "int16": "s",
    "int32": "i",
    "int64": "q",
    "uchar": "C",
    "uint": "I",
    "uint16": "S",
    "uint32": "I",
    "uint64": "Q",
    "float": "f",
    "double": "d",
    "bool": "B",
    "void": "v",
    "string": "*",
    "object": "@",
    "block": "@?",
    "class": "#",
    "selector": ":",
    "pointer": "^v"
  };
  function typeIdFromAlias(alias) {
    if (typeof alias === "object" && alias !== null)
      return `@"${alias.type}"`;
    const id = idByAlias[alias];
    if (id === void 0)
      throw new Error("No known encoding for type " + alias);
    return id;
  }
  const fromNativeId = function(h) {
    if (h.isNull()) {
      return null;
    } else if (h.toString(16) === this.handle.toString(16)) {
      return this;
    } else {
      return new ObjCObject(h);
    }
  };
  const toNativeId = function(v) {
    if (v === null)
      return NULL;
    const type = typeof v;
    if (type === "string") {
      if (cachedNSStringCtor === null) {
        cachedNSString = classRegistry.NSString;
        cachedNSStringCtor = cachedNSString.stringWithUTF8String_;
      }
      return cachedNSStringCtor.call(cachedNSString, Memory.allocUtf8String(v));
    } else if (type === "number") {
      if (cachedNSNumberCtor === null) {
        cachedNSNumber = classRegistry.NSNumber;
        cachedNSNumberCtor = cachedNSNumber.numberWithDouble_;
      }
      return cachedNSNumberCtor.call(cachedNSNumber, v);
    }
    return v;
  };
  const fromNativeBlock = function(h) {
    if (h.isNull()) {
      return null;
    } else if (h.toString(16) === this.handle.toString(16)) {
      return this;
    } else {
      return new Block(h);
    }
  };
  const toNativeBlock = function(v) {
    return v !== null ? v : NULL;
  };
  const toNativeObjectArray = function(v) {
    if (v instanceof Array) {
      const length = v.length;
      const array = Memory.alloc(length * pointerSize);
      for (let i = 0; i !== length; i++)
        array.add(i * pointerSize).writePointer(toNativeId(v[i]));
      return array;
    }
    return v;
  };
  function arrayType(length, elementType) {
    return {
      type: "pointer",
      read(address) {
        const result = [];
        const elementSize = elementType.size;
        for (let index = 0; index !== length; index++) {
          result.push(elementType.read(address.add(index * elementSize)));
        }
        return result;
      },
      write(address, values) {
        const elementSize = elementType.size;
        values.forEach((value, index) => {
          elementType.write(address.add(index * elementSize), value);
        });
      }
    };
  }
  function structType(fieldTypes) {
    let fromNative, toNative;
    if (fieldTypes.some(function(t) {
      return !!t.fromNative;
    })) {
      const fromTransforms = fieldTypes.map(function(t) {
        if (t.fromNative)
          return t.fromNative;
        else
          return identityTransform;
      });
      fromNative = function(v) {
        return v.map(function(e, i) {
          return fromTransforms[i].call(this, e);
        });
      };
    } else {
      fromNative = identityTransform;
    }
    if (fieldTypes.some(function(t) {
      return !!t.toNative;
    })) {
      const toTransforms = fieldTypes.map(function(t) {
        if (t.toNative)
          return t.toNative;
        else
          return identityTransform;
      });
      toNative = function(v) {
        return v.map(function(e, i) {
          return toTransforms[i].call(this, e);
        });
      };
    } else {
      toNative = identityTransform;
    }
    const [totalSize, fieldOffsets] = fieldTypes.reduce(function(result, t) {
      const [previousOffset, offsets2] = result;
      const { size } = t;
      const offset = align(previousOffset, size);
      offsets2.push(offset);
      return [offset + size, offsets2];
    }, [0, []]);
    return {
      type: fieldTypes.map((t) => t.type),
      size: totalSize,
      read(address) {
        return fieldTypes.map((type, index) => type.read(address.add(fieldOffsets[index])));
      },
      write(address, values) {
        values.forEach((value, index) => {
          fieldTypes[index].write(address.add(fieldOffsets[index]), value);
        });
      },
      fromNative,
      toNative
    };
  }
  function unionType(fieldTypes) {
    const largestType = fieldTypes.reduce(function(largest, t) {
      if (t.size > largest.size)
        return t;
      else
        return largest;
    }, fieldTypes[0]);
    let fromNative, toNative;
    if (largestType.fromNative) {
      const fromTransform = largestType.fromNative;
      fromNative = function(v) {
        return fromTransform.call(this, v[0]);
      };
    } else {
      fromNative = function(v) {
        return v[0];
      };
    }
    if (largestType.toNative) {
      const toTransform = largestType.toNative;
      toNative = function(v) {
        return [toTransform.call(this, v)];
      };
    } else {
      toNative = function(v) {
        return [v];
      };
    }
    return {
      type: [largestType.type],
      size: largestType.size,
      read: largestType.read,
      write: largestType.write,
      fromNative,
      toNative
    };
  }
  const longBits = pointerSize == 8 && Process.platform !== "windows" ? 64 : 32;
  modifiers = /* @__PURE__ */ new Set([
    "j",
    // complex
    "A",
    // atomic
    "r",
    // const
    "n",
    // in
    "N",
    // inout
    "o",
    // out
    "O",
    // by copy
    "R",
    // by ref
    "V",
    // one way
    "+"
    // GNU register
  ]);
  singularTypeById = {
    "c": {
      type: "char",
      size: 1,
      read: (address) => address.readS8(),
      write: (address, value) => {
        address.writeS8(value);
      },
      toNative(v) {
        if (typeof v === "boolean") {
          return v ? 1 : 0;
        }
        return v;
      }
    },
    "i": {
      type: "int",
      size: 4,
      read: (address) => address.readInt(),
      write: (address, value) => {
        address.writeInt(value);
      }
    },
    "s": {
      type: "int16",
      size: 2,
      read: (address) => address.readS16(),
      write: (address, value) => {
        address.writeS16(value);
      }
    },
    "l": {
      type: "int32",
      size: 4,
      read: (address) => address.readS32(),
      write: (address, value) => {
        address.writeS32(value);
      }
    },
    "q": {
      type: "int64",
      size: 8,
      read: (address) => address.readS64(),
      write: (address, value) => {
        address.writeS64(value);
      }
    },
    "C": {
      type: "uchar",
      size: 1,
      read: (address) => address.readU8(),
      write: (address, value) => {
        address.writeU8(value);
      }
    },
    "I": {
      type: "uint",
      size: 4,
      read: (address) => address.readUInt(),
      write: (address, value) => {
        address.writeUInt(value);
      }
    },
    "S": {
      type: "uint16",
      size: 2,
      read: (address) => address.readU16(),
      write: (address, value) => {
        address.writeU16(value);
      }
    },
    "L": {
      type: "uint" + longBits,
      size: longBits / 8,
      read: (address) => address.readULong(),
      write: (address, value) => {
        address.writeULong(value);
      }
    },
    "Q": {
      type: "uint64",
      size: 8,
      read: (address) => address.readU64(),
      write: (address, value) => {
        address.writeU64(value);
      }
    },
    "f": {
      type: "float",
      size: 4,
      read: (address) => address.readFloat(),
      write: (address, value) => {
        address.writeFloat(value);
      }
    },
    "d": {
      type: "double",
      size: 8,
      read: (address) => address.readDouble(),
      write: (address, value) => {
        address.writeDouble(value);
      }
    },
    "B": {
      type: "bool",
      size: 1,
      read: (address) => address.readU8(),
      write: (address, value) => {
        address.writeU8(value);
      },
      fromNative(v) {
        return v ? true : false;
      },
      toNative(v) {
        return v ? 1 : 0;
      }
    },
    "v": {
      type: "void",
      size: 0
    },
    "*": {
      type: "pointer",
      size: pointerSize,
      read: (address) => address.readPointer(),
      write: (address, value) => {
        address.writePointer(value);
      },
      fromNative(h) {
        return h.readUtf8String();
      }
    },
    "@": {
      type: "pointer",
      size: pointerSize,
      read: (address) => address.readPointer(),
      write: (address, value) => {
        address.writePointer(value);
      },
      fromNative: fromNativeId,
      toNative: toNativeId
    },
    "@?": {
      type: "pointer",
      size: pointerSize,
      read: (address) => address.readPointer(),
      write: (address, value) => {
        address.writePointer(value);
      },
      fromNative: fromNativeBlock,
      toNative: toNativeBlock
    },
    "^@": {
      type: "pointer",
      size: pointerSize,
      read: (address) => address.readPointer(),
      write: (address, value) => {
        address.writePointer(value);
      },
      toNative: toNativeObjectArray
    },
    "^v": {
      type: "pointer",
      size: pointerSize,
      read: (address) => address.readPointer(),
      write: (address, value) => {
        address.writePointer(value);
      }
    },
    "#": {
      type: "pointer",
      size: pointerSize,
      read: (address) => address.readPointer(),
      write: (address, value) => {
        address.writePointer(value);
      },
      fromNative: fromNativeId,
      toNative: toNativeId
    },
    ":": {
      type: "pointer",
      size: pointerSize,
      read: (address) => address.readPointer(),
      write: (address, value) => {
        address.writePointer(value);
      }
    },
    "?": {
      type: "pointer",
      size: pointerSize,
      read: (address) => address.readPointer(),
      write: (address, value) => {
        address.writePointer(value);
      }
    }
  };
  function identityTransform(v) {
    return v;
  }
  function align(value, boundary) {
    const remainder = value % boundary;
    return remainder === 0 ? value : value + (boundary - remainder);
  }
}
var runtime2 = new Runtime2();
var frida_objc_bridge_default = runtime2;

// agent/shared/objclib.ts
var ObjC;
var objcLegacy = globalThis.ObjC;
if (objcLegacy && typeof objcLegacy.perform === "function") {
  devlog("[frida-objc-bridge] Pre-v17 Frida detected. Using legacy global ObjC bridge.");
  ObjC = objcLegacy;
} else {
  devlog("[frida-objc-bridge] Frida >=17 detected. Using 'frida-objc-bridge' module.");
  ObjC = frida_objc_bridge_default;
}

// agent/ssl_lib/openssl_boringssl.ts
var ModifyReceiver = class {
  readModification = null;
  writeModification = null;
  constructor() {
    this.listenForReadMod();
    this.listenForWriteMod();
  }
  listenForReadMod() {
    recv("readmod", (newBuf) => {
      this.readModification = newBuf.payload != null ? new Uint8Array(newBuf.payload.match(/[\da-f]{2}/gi).map(function(h) {
        return parseInt(h, 16);
      })).buffer : null;
      this.listenForReadMod();
    });
  }
  listenForWriteMod() {
    recv("writemod", (newBuf) => {
      this.writeModification = newBuf.payload != null ? new Uint8Array(newBuf.payload.match(/[\da-f]{2}/gi).map(function(h) {
        return parseInt(h, 16);
      })).buffer : null;
      this.listenForWriteMod();
    });
  }
  get readmod() {
    return this.readModification;
  }
  get writemod() {
    return this.writeModification;
  }
  set readmod(val) {
    this.readModification = val;
  }
  set writemod(val) {
    this.writeModification = val;
  }
};
var OpenSSL_BoringSSL = class _OpenSSL_BoringSSL {
  moduleName;
  socket_library;
  passed_library_method_mapping;
  // global variables
  library_method_mapping = {};
  addresses;
  module_name;
  SSL_SESSION_get_id;
  SSL_CTX_set_keylog_callback;
  SSL_get_fd;
  SSL_get_session;
  static modReceiver;
  static keylog_callback = new NativeCallback(function(ctxPtr, linePtr) {
    devlog("invoking keylog_callback from OpenSSL_BoringSSL");
    var message = {};
    message["contentType"] = "keylog";
    message["keylog"] = linePtr.readCString().toUpperCase();
    send(message);
  }, "void", ["pointer", "pointer"]);
  is_base_hook;
  is_openssl;
  constructor(moduleName, socket_library6, is_base_hook, passed_library_method_mapping) {
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.passed_library_method_mapping = passed_library_method_mapping;
    _OpenSSL_BoringSSL.modReceiver = new ModifyReceiver();
    if (typeof passed_library_method_mapping !== "undefined") {
      this.library_method_mapping = passed_library_method_mapping;
    } else {
      if (checkNumberOfExports(moduleName) > 2) {
        this.library_method_mapping[`*${moduleName}*`] = ["SSL_read", "SSL_write", "SSL_get_fd", "SSL_get_session", "SSL_SESSION_get_id", "SSL_new", "SSL_CTX_set_keylog_callback"];
      }
      this.library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    }
    if (isSymbolAvailable(moduleName, "SSL_CTX_new")) {
      this.library_method_mapping[`*${moduleName}*`].push("SSL_CTX_new");
    }
    if (isSymbolAvailable(moduleName, "SSL_read_ex")) {
      this.library_method_mapping[`*${moduleName}*`].push("SSL_read_ex");
      this.is_openssl = true;
    } else {
      this.is_openssl = false;
    }
    if (isSymbolAvailable(moduleName, "SSL_write_ex")) {
      this.library_method_mapping[`*${moduleName}*`].push("SSL_write_ex");
    }
    this.is_base_hook = is_base_hook;
    this.addresses = readAddresses(moduleName, this.library_method_mapping);
    this.module_name = moduleName;
    if (offsets != "{OFFSETS}" && offsets.openssl != null) {
      if (offsets.sockets != null) {
        const socketBaseAddress = getBaseAddress(socket_library6);
        for (const method2 of Object.keys(offsets.sockets)) {
          this.addresses[this.moduleName][`${method2}`] = offsets.sockets[`${method2}`].absolute || socketBaseAddress == null ? ptr(offsets.sockets[`${method2}`].address) : socketBaseAddress.add(ptr(offsets.sockets[`${method2}`].address));
        }
      }
      const libraryBaseAddress = getBaseAddress(moduleName);
      if (libraryBaseAddress == null)
        log("Unable to find library base address! Given address values will be interpreted as absolute ones!");
      for (const method2 of Object.keys(offsets.openssl)) {
        this.addresses[this.moduleName][`${method2}`] = offsets.openssl[`${method2}`].absolute || libraryBaseAddress == null ? ptr(offsets.openssl[`${method2}`].address) : libraryBaseAddress.add(ptr(offsets.openssl[`${method2}`].address));
      }
    }
    if (!ObjC.available && checkNumberOfExports(moduleName) > 2) {
      this.SSL_SESSION_get_id = new NativeFunction(this.addresses[this.moduleName]["SSL_SESSION_get_id"], "pointer", ["pointer", "pointer"]);
      this.SSL_get_fd = ObjC.available ? new NativeFunction(this.addresses[this.moduleName]["BIO_get_fd"], "int", ["pointer"]) : new NativeFunction(this.addresses[this.moduleName]["SSL_get_fd"], "int", ["pointer"]);
      this.SSL_get_session = new NativeFunction(this.addresses[this.moduleName]["SSL_get_session"], "pointer", ["pointer"]);
    }
  }
  install_plaintext_read_hook() {
    if (!ObjC.available) {
      let ab2str2 = function(buf) {
        return String.fromCharCode.apply(null, new Uint16Array(buf));
      }, str2ab2 = function(str) {
        var buf = new ArrayBuffer(str.length + 1);
        var bufView = new Uint8Array(buf);
        for (var i = 0, strLen = str.length; i < strLen; i++) {
          bufView[i] = str.charCodeAt(i);
        }
        bufView[str.length] = 0;
        return buf;
      };
      var ab2str = ab2str2, str2ab = str2ab2;
      var lib_addesses = this.addresses;
      var instance = this;
      var current_module_name = this.module_name;
      Interceptor.attach(this.addresses[this.moduleName]["SSL_read"], {
        onEnter: function(args) {
          this.bufLen = args[2].toInt32();
          this.fd = instance.SSL_get_fd(args[0]);
          if (this.fd < 0 && enable_default_fd == false) {
            return;
          }
          var message = getPortsAndAddresses(this.fd, true, lib_addesses[current_module_name], enable_default_fd);
          message["ssl_session_id"] = instance.getSslSessionId(args[0]);
          message["function"] = "SSL_read";
          this.message = message;
          this.buf = args[1];
        },
        onLeave: function(retval) {
          retval |= 0;
          if (retval <= 0 || this.fd < 0) {
            return;
          }
          if (_OpenSSL_BoringSSL.modReceiver.readmod !== null) {
            this.buf.writeByteArray(new Uint8Array(this.bufLen));
            this.buf.writeByteArray(_OpenSSL_BoringSSL.modReceiver.readmod);
            retval = _OpenSSL_BoringSSL.modReceiver.readmod.byteLength;
          }
          this.message["contentType"] = "datalog";
          send(this.message, this.buf.readByteArray(retval));
        }
      });
    }
  }
  install_plaintext_write_hook() {
    if (!ObjC.available) {
      let str2ab2 = function(str) {
        var buf = new ArrayBuffer(str.length + 1);
        var bufView = new Uint8Array(buf);
        for (var i = 0, strLen = str.length; i < strLen; i++) {
          bufView[i] = str.charCodeAt(i);
        }
        bufView[str.length] = 0;
        return buf;
      };
      var str2ab = str2ab2;
      var current_module_name = this.module_name;
      var lib_addesses = this.addresses;
      var instance = this;
      Interceptor.attach(this.addresses[this.moduleName]["SSL_write"], {
        onEnter: function(args) {
          if (!ObjC.available) {
            try {
              this.fd = instance.SSL_get_fd(args[0]);
            } catch (error) {
              if (!this.is_base_hook) {
                const fallback_addresses = globalThis.init_addresses;
                let keys = Object.keys(fallback_addresses);
                let firstKey = keys[0];
                instance.SSL_SESSION_get_id = new NativeFunction(fallback_addresses[firstKey]["SSL_SESSION_get_id"], "pointer", ["pointer", "pointer"]);
                instance.SSL_get_fd = ObjC.available ? new NativeFunction(fallback_addresses[firstKey]["BIO_get_fd"], "int", ["pointer"]) : new NativeFunction(fallback_addresses["SSL_get_fd"], "int", ["pointer"]);
                instance.SSL_get_session = new NativeFunction(fallback_addresses[firstKey]["SSL_get_session"], "pointer", ["pointer"]);
              } else {
                if (error instanceof Error) {
                  console.log("Error: " + error.message);
                  console.log("Stack: " + error.stack);
                } else {
                  console.log("Unexpected error:", error);
                }
              }
            }
            if (this.fd < 0 && enable_default_fd == false) {
              return;
            }
            var message = getPortsAndAddresses(this.fd, false, lib_addesses[current_module_name], enable_default_fd);
            message["ssl_session_id"] = instance.getSslSessionId(args[0]);
            message["function"] = "SSL_write";
            message["contentType"] = "datalog";
            if (_OpenSSL_BoringSSL.modReceiver.writemod !== null) {
              const newPointer = Memory.alloc(_OpenSSL_BoringSSL.modReceiver.writemod.byteLength);
              newPointer.writeByteArray(_OpenSSL_BoringSSL.modReceiver.writemod);
              args[1] = newPointer;
              args[2] = new NativePointer(_OpenSSL_BoringSSL.modReceiver.writemod.byteLength);
            }
            send(message, args[1].readByteArray(args[2].toInt32()));
          }
        },
        onLeave: function(retval) {
        }
      });
    }
  }
  install_tls_keys_callback_hook() {
    log("Error: TLS key extraction not implemented yet.");
  }
  /*
   * These hooks differ between OpenSSL and BoringSSL.
   */
  install_openssl_key_extraction_hook() {
    log("Error: TLS key extraction not implemented yet.");
  }
  dump_keys_openssl(label, identifier, key, length) {
    const KEY_LENGTH_FINAL = length.toInt32();
    const RANDOM_KEY_LENGTH = 32;
    var labelStr = "";
    var client_random_str = "";
    var secret_key = "";
    if (!label.isNull()) {
      labelStr = label.readCString();
    } else {
      devlog_error("[Error] Argument 'label' is NULL");
    }
    if (!identifier.isNull()) {
      try {
        const client_random = identifier.add(352).readByteArray(RANDOM_KEY_LENGTH);
        const hex_client_random = Array.from(new Uint8Array(client_random)).map((byte) => byte.toString(16).padStart(2, "0").toUpperCase()).join("");
        client_random_str = hex_client_random;
      } catch (error) {
        client_random_str = "Error_reading_client_random";
      }
      ;
    } else {
      devlog_error("[OpenSSL Dump Keys Error] Argument 'identifier' is NULL");
    }
    if (!key.isNull()) {
      const keyData = key.readByteArray(KEY_LENGTH_FINAL);
      const hexKey = Array.from(new Uint8Array(keyData)).map((byte) => byte.toString(16).padStart(2, "0").toUpperCase()).join("");
      secret_key = hexKey;
    } else {
      devlog_error("[OpenSSL Dump Keys Error] Argument 'key' is NULL");
    }
    var message = {};
    message["contentType"] = "keylog";
    message["keylog"] = labelStr + " " + client_random_str + " " + secret_key;
    send(message);
  }
  install_boringssl_key_extraction_hook() {
    log("Error: TLS key extraction not implemented yet.");
  }
  install_extended_hooks() {
    if (this.is_openssl) {
      var current_module_name = this.module_name;
      var lib_addesses = this.addresses;
      var instance = this;
      Interceptor.attach(this.addresses[this.moduleName]["SSL_read_ex"], {
        onEnter: function(args) {
          this.bufLen = args[2].toInt32();
          this.fd = instance.SSL_get_fd(args[0]);
          if (this.fd < 0 && enable_default_fd == false) {
            return;
          }
          var message = getPortsAndAddresses(this.fd, true, lib_addesses[current_module_name], enable_default_fd);
          message["ssl_session_id"] = instance.getSslSessionId(args[0]);
          message["function"] = "SSL_read_ex";
          this.message = message;
          this.buf = args[1];
        },
        onLeave: function(retval) {
          retval |= 0;
          if (retval <= 0 || this.fd < 0) {
            return;
          }
          this.message["contentType"] = "datalog";
          send(this.message, this.buf.readByteArray(retval));
        }
      });
      Interceptor.attach(this.addresses[this.moduleName]["SSL_write_ex"], {
        onEnter: function(args) {
          if (!ObjC.available) {
            try {
              this.fd = instance.SSL_get_fd(args[0]);
            } catch (error) {
              if (!this.is_base_hook) {
                const fallback_addresses = globalThis.init_addresses;
                let keys = Object.keys(fallback_addresses);
                let firstKey = keys[0];
                instance.SSL_SESSION_get_id = new NativeFunction(fallback_addresses[firstKey]["SSL_SESSION_get_id"], "pointer", ["pointer", "pointer"]);
                instance.SSL_get_fd = ObjC.available ? new NativeFunction(fallback_addresses[firstKey]["BIO_get_fd"], "int", ["pointer"]) : new NativeFunction(fallback_addresses["SSL_get_fd"], "int", ["pointer"]);
                instance.SSL_get_session = new NativeFunction(fallback_addresses[firstKey]["SSL_get_session"], "pointer", ["pointer"]);
              } else {
                if (error instanceof Error) {
                  console.log("Error: " + error.message);
                  console.log("Stack: " + error.stack);
                } else {
                  console.log("Unexpected error:", error);
                }
              }
            }
            if (this.fd < 0 && enable_default_fd == false) {
              return;
            }
            var message = getPortsAndAddresses(this.fd, false, lib_addesses[current_module_name], enable_default_fd);
            message["ssl_session_id"] = instance.getSslSessionId(args[0]);
            message["function"] = "SSL_write_ex";
            message["contentType"] = "datalog";
            send(message, args[1].readByteArray(args[2].toInt32()));
          }
        },
        onLeave: function(retval) {
        }
      });
    }
  }
  /**
    * Get the session_id of SSL object and return it as a hex string.
    * @param {!NativePointer} ssl A pointer to an SSL object.
    * @return {dict} A string representing the session_id of the SSL object's
    *     SSL_SESSION. For example,
    *     "59FD71B7B90202F359D89E66AE4E61247954E28431F6C6AC46625D472FF76336".
    */
  getSslSessionId(ssl) {
    var session = this.SSL_get_session(ssl);
    if (session.isNull()) {
      if (enable_default_fd) {
        log("using dummy SessionID: 59FD71B7B90202F359D89E66AE4E61247954E28431F6C6AC46625D472FF76336");
        return "59FD71B7B90202F359D89E66AE4E61247954E28431F6C6AC46625D472FF76336";
      }
      log("Session is null");
      return 0;
    }
    var len_pointer = Memory.alloc(4);
    var p = this.SSL_SESSION_get_id(session, len_pointer);
    var len = len_pointer.readU32();
    var session_id = "";
    for (var i = 0; i < len; i++) {
      session_id += ("0" + p.add(i).readU8().toString(16).toUpperCase()).substr(-2);
    }
    return session_id;
  }
};

// agent/android/openssl_boringssl_android.ts
var OpenSSL_BoringSSL_Android = class extends OpenSSL_BoringSSL {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  install_tls_keys_callback_hook() {
    this.SSL_CTX_set_keylog_callback = new NativeFunction(this.addresses[this.module_name]["SSL_CTX_set_keylog_callback"], "void", ["pointer", "pointer"]);
    var instance = this;
    let callback_already_set = false;
    Interceptor.attach(this.addresses[this.module_name]["SSL_new"], {
      onEnter: function(args) {
        try {
          callback_already_set = true;
          instance.SSL_CTX_set_keylog_callback(args[0], OpenSSL_BoringSSL.keylog_callback);
        } catch (e) {
          callback_already_set = false;
          devlog_error(`Error in SSL_new hook: ${e}`);
        }
      }
    });
    if (this.addresses[this.module_name]["SSL_CTX_new"] !== null && callback_already_set === false) {
      Interceptor.attach(this.addresses[this.module_name]["SSL_CTX_new"], {
        onLeave: function(retval) {
          try {
            if (retval.isNull()) {
              devlog_error("SSL_CTX_new returned NULL");
              return;
            }
            instance.SSL_CTX_set_keylog_callback(retval, OpenSSL_BoringSSL.keylog_callback);
          } catch (e) {
            devlog_error(`Error in SSL_CTX_new hook: ${e}`);
          }
        }
      });
    }
    Interceptor.attach(this.addresses[this.module_name]["SSL_CTX_set_keylog_callback"], {
      onEnter: function(args) {
        let callback_func = args[1];
        Interceptor.attach(callback_func, {
          onEnter: function(args2) {
            var message = {};
            message["contentType"] = "keylog";
            message["keylog"] = args2[1].readCString();
            send(message);
          }
        });
      }
    });
  }
  install_conscrypt_tls_keys_callback_hook() {
    try {
      this.SSL_CTX_set_keylog_callback = new NativeFunction(this.addresses[this.module_name]["SSL_CTX_set_keylog_callback"], "void", ["pointer", "pointer"]);
      var instance = this;
      Interceptor.attach(this.addresses[this.module_name]["SSL_CTX_new"], {
        onLeave: function(retval) {
          const ssl = new NativePointer(retval);
          if (!ssl.isNull()) {
            instance.SSL_CTX_set_keylog_callback(ssl, OpenSSL_BoringSSL.keylog_callback);
          }
        }
      });
    } catch (e) {
    }
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
    this.install_tls_keys_callback_hook();
    this.install_conscrypt_tls_keys_callback_hook();
    this.install_extended_hooks();
  }
  execute_conscrypt_hooks() {
    this.install_conscrypt_tls_keys_callback_hook();
  }
};
function boring_execute(moduleName, is_base_hook) {
  var boring_ssl = new OpenSSL_BoringSSL_Android(moduleName, socket_library, is_base_hook);
  try {
    boring_ssl.execute_hooks();
  } catch (error_msg) {
    devlog(`boring_execute error: ${error_msg}`);
  }
  if (is_base_hook) {
    try {
      const init_addresses = boring_ssl.addresses[moduleName];
      if (Object.keys(init_addresses).length > 0) {
        globalThis.init_addresses[moduleName] = init_addresses;
      }
    } catch (error_msg) {
      devlog(`boring_execute base-hook error: ${error_msg}`);
    }
  }
}

// agent/android/bouncycastle.ts
function execute() {
  setTimeout(function() {
    Java.perform(function() {
      var appDataOutput = Java.use("org.spongycastle.jsse.provider.ProvSSLSocketDirect$AppDataOutput");
      appDataOutput.write.overload("[B", "int", "int").implementation = function(buf, offset, len) {
        var result = [];
        for (var i = 0; i < len; ++i) {
          result.push(buf[i] & 255);
        }
        var message = {};
        message["contentType"] = "datalog";
        message["src_port"] = this.this$0.value.getLocalPort();
        message["dst_port"] = this.this$0.value.getPort();
        var localAddress = this.this$0.value.getLocalAddress().getAddress();
        var inetAddress = this.this$0.value.getInetAddress().getAddress();
        if (localAddress.length == 4) {
          message["src_addr"] = byteArrayToNumber(localAddress);
          message["dst_addr"] = byteArrayToNumber(inetAddress);
          message["ss_family"] = "AF_INET";
        } else {
          message["src_addr"] = byteArrayToString(localAddress);
          message["dst_addr"] = byteArrayToString(inetAddress);
          message["ss_family"] = "AF_INET6";
        }
        message["ssl_session_id"] = byteArrayToString(this.this$0.value.getConnection().getSession().getId());
        message["function"] = "writeApplicationData";
        send(message, result);
        return this.write(buf, offset, len);
      };
      var appDataInput = Java.use("org.spongycastle.jsse.provider.ProvSSLSocketDirect$AppDataInput");
      appDataInput.read.overload("[B", "int", "int").implementation = function(buf, offset, len) {
        var bytesRead = this.read(buf, offset, len);
        var result = [];
        for (var i = 0; i < bytesRead; ++i) {
          result.push(buf[i] & 255);
        }
        var message = {};
        message["contentType"] = "datalog";
        message["ss_family"] = "AF_INET";
        message["src_port"] = this.this$0.value.getPort();
        message["dst_port"] = this.this$0.value.getLocalPort();
        var localAddress = this.this$0.value.getLocalAddress().getAddress();
        var inetAddress = this.this$0.value.getInetAddress().getAddress();
        if (localAddress.length == 4) {
          message["src_addr"] = byteArrayToNumber(inetAddress);
          message["dst_addr"] = byteArrayToNumber(localAddress);
          message["ss_family"] = "AF_INET";
        } else {
          message["src_addr"] = byteArrayToString(inetAddress);
          message["dst_addr"] = byteArrayToString(localAddress);
          message["ss_family"] = "AF_INET6";
        }
        message["ssl_session_id"] = byteArrayToString(this.this$0.value.getConnection().getSession().getId());
        log(message["ssl_session_id"]);
        message["function"] = "readApplicationData";
        send(message, result);
        return bytesRead;
      };
      var ProvSSLSocketDirect = Java.use("org.spongycastle.jsse.provider.ProvSSLSocketDirect");
      ProvSSLSocketDirect.notifyHandshakeComplete.implementation = function(x) {
        var protocol = this.protocol.value;
        var securityParameters = protocol.securityParameters.value;
        var clientRandom = securityParameters.clientRandom.value;
        var masterSecretObj = getAttribute(securityParameters, "masterSecret");
        var clazz = Java.use("java.lang.Class");
        var masterSecretRawField = Java.cast(masterSecretObj.getClass(), clazz).getSuperclass().getDeclaredField("data");
        masterSecretRawField.setAccessible(true);
        var masterSecretReflectArray = masterSecretRawField.get(masterSecretObj);
        var message = {};
        message["contentType"] = "keylog";
        message["keylog"] = "CLIENT_RANDOM " + byteArrayToString(clientRandom) + " " + reflectionByteArrayToString(masterSecretReflectArray);
        send(message);
        return this.notifyHandshakeComplete(x);
      };
    });
  }, 0);
}

// agent/util/process_infos.ts
function get_process_architecture() {
  return Process.arch;
}
function isAndroid() {
  if (typeof Java !== "undefined" && Java.available && Process.platform == "linux") {
    try {
      Java.androidVersion;
      return true;
    } catch (error) {
      return false;
    }
  } else {
    return false;
  }
}
function is_macos_based_version_string() {
  if (typeof ObjC !== "undefined" && ObjC.classes.NSProcessInfo !== void 0) {
    try {
      const NSProcessInfo = ObjC.classes.NSProcessInfo;
      const version = NSProcessInfo.processInfo().operatingSystemVersionString().toString().toLowerCase();
      const isMacOSFramework = ObjC.classes.NSApplication !== void 0;
      const isiOSFramework = ObjC.classes.UIApplication !== void 0;
      if (isMacOSFramework && !isiOSFramework) {
        devlog("[OS Detection] AppKit without UIKit -> macOS");
        return true;
      }
      if (isiOSFramework && !isMacOSFramework) {
        devlog("[OS Detection] UIKit without AppKit -> iOS");
        return false;
      }
      if (version.includes("ios") || version.includes("iphone") || version.includes("ipad")) {
        devlog("[OS Detection] iOS indicators in version string");
        return false;
      }
      if (version.includes("macos") || version.includes("os x") || version.includes("mac os x")) {
        devlog("[OS Detection] macOS indicators in version string");
        return true;
      }
      try {
        const fileManager = ObjC.classes.NSFileManager.defaultManager();
        if (fileManager.fileExistsAtPath_("/Applications/Safari.app")) {
          return true;
        }
        if (fileManager.fileExistsAtPath_("/Applications/MobileSafari.app")) {
          return false;
        }
      } catch (pathError) {
        devlog(`[OS Detection] Path check error: ${pathError}`);
      }
      if (isMacOSFramework) {
        devlog("[OS Detection] Fallback to AppKit presence -> macOS");
        return true;
      }
    } catch (error) {
      devlog(`[OS Detection] Version string detection error: ${error}`);
      return false;
    }
  }
  return false;
}
function isiOS() {
  if (Process.platform !== "darwin") {
    return false;
  }
  if (typeof ObjC !== "undefined" && ObjC.available) {
    try {
      if (ObjC.classes.UIApplication !== void 0) {
        devlog("[OS Detection] UIKit found -> iOS");
        return true;
      }
      if (ObjC.classes.NSApplication !== void 0) {
        devlog("[OS Detection] AppKit found -> macOS (not iOS)");
        return false;
      }
      return !is_macos_based_version_string();
    } catch (error) {
      devlog(`[OS Detection] iOS detection error: ${error}`);
      return false;
    }
  }
  return false;
}
function isMacOS() {
  if (Process.platform !== "darwin") {
    return false;
  }
  if (typeof ObjC !== "undefined" && ObjC.available) {
    try {
      if (ObjC.classes.NSApplication !== void 0) {
        devlog("[OS Detection] AppKit found -> macOS");
        return true;
      }
      if (ObjC.classes.UIApplication !== void 0) {
        devlog("[OS Detection] UIKit found -> iOS (not macOS)");
        return false;
      }
      return is_macos_based_version_string();
    } catch (error) {
      devlog(`[OS Detection] macOS detection error: ${error}`);
      return get_process_architecture() === "x64";
    }
  }
  return get_process_architecture() === "x64";
}
function isLinux() {
  if (Process.platform == "linux") {
    if (Java.available == false && Process.platform == "linux") {
      return true;
    } else {
      try {
        Java.androidVersion;
        return false;
      } catch (error) {
        return true;
      }
    }
  } else {
    return false;
  }
}
function isWindows() {
  if (Process.platform == "windows") {
    return true;
  } else {
    return false;
  }
}
function getAndroidVersion2() {
  var version = "-1";
  Java.perform(function() {
    version = Java.androidVersion;
  });
  var casted_version = +version;
  return casted_version;
}
function getDetailedPlatformInfo() {
  const info = {
    platform: Process.platform,
    architecture: Process.arch,
    isAndroid: isAndroid(),
    isiOS: isiOS(),
    isMacOS: isMacOS(),
    isLinux: isLinux(),
    isWindows: isWindows(),
    objcAvailable: typeof ObjC !== "undefined" && ObjC.available,
    javaAvailable: typeof Java !== "undefined" && Java.available
  };
  if (Process.platform === "darwin" && info.objcAvailable) {
    try {
      const processInfo = ObjC.classes.NSProcessInfo.processInfo();
      info.appleDetails = {
        versionString: processInfo.operatingSystemVersionString().toString(),
        processName: processInfo.processName().toString(),
        frameworks: {
          UIKit: ObjC.classes.UIApplication !== void 0,
          AppKit: ObjC.classes.NSApplication !== void 0,
          Foundation: ObjC.classes.NSString !== void 0
        },
        paths: {}
      };
      const fileManager = ObjC.classes.NSFileManager.defaultManager();
      const pathsToCheck = [
        "/Applications/Safari.app",
        "/Applications/MobileSafari.app",
        "/System/Library/Frameworks/AppKit.framework",
        "/System/Library/Frameworks/UIKit.framework",
        "/Users",
        "/var/mobile"
      ];
      for (const path of pathsToCheck) {
        info.appleDetails.paths[path] = fileManager.fileExistsAtPath_(path);
      }
    } catch (error) {
      info.appleDetailsError = error.toString();
    }
  }
  return info;
}

// agent/android/conscrypt.ts
var Consycrypt_BoringSSL_Android = class extends OpenSSL_BoringSSL {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    var library_method_mapping = {};
    library_method_mapping[`*${moduleName}*`] = ["SSL_CTX_new", "SSL_CTX_set_keylog_callback"];
    super(moduleName, socket_library6, is_base_hook, library_method_mapping);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  install_conscrypt_tls_keys_callback_hook() {
    this.SSL_CTX_set_keylog_callback = new NativeFunction(this.addresses[this.module_name]["SSL_CTX_set_keylog_callback"], "void", ["pointer", "pointer"]);
    var instance = this;
    if (isSymbolAvailable(this.module_name, "SSL_CTX_new")) {
      Interceptor.attach(this.addresses[this.module_name]["SSL_CTX_new"], {
        onLeave: function(retval) {
          const ssl = new NativePointer(retval);
          if (!ssl.isNull()) {
            instance.SSL_CTX_set_keylog_callback(ssl, OpenSSL_BoringSSL.keylog_callback);
          }
        }
      });
    }
  }
  execute_conscrypt_hooks() {
    this.install_conscrypt_tls_keys_callback_hook();
  }
};
function conscrypt_native_execute(moduleName, is_base_hook) {
  var boring_ssl = new Consycrypt_BoringSSL_Android(moduleName, socket_library, is_base_hook);
  try {
    boring_ssl.execute_conscrypt_hooks();
  } catch (error_msg) {
    devlog(`conscrypt_execute error: ${error_msg}`);
  }
  if (is_base_hook) {
    try {
      const init_addresses = boring_ssl.addresses[moduleName];
      if (Object.keys(init_addresses).length > 0) {
        globalThis.init_addresses[moduleName] = init_addresses;
      }
    } catch (error_msg) {
      devlog(`conscrypt_execute base-hook error: ${error_msg}`);
    }
  }
}
function findProviderInstallerImplFromClassloaders(currentClassLoader, backupImplementation) {
  let providerInstallerImpl = null;
  var classLoaders = Java.enumerateClassLoadersSync();
  for (var cl of classLoaders) {
    try {
      var classFactory = Java.ClassFactory.get(cl);
      providerInstallerImpl = classFactory.use("com.google.android.gms.common.security.ProviderInstallerImpl");
      break;
    } catch (error) {
      if (!error.toString().includes("java.lang.ClassNotFoundException")) {
        devlog_error("Error in hooking ProviderInstallerImpl (findProviderInstallerImplFromClassloaders):");
        devlog_error("Error message: (findProviderInstallerImplFromClassloaders): " + error);
      }
      providerInstallerImpl = null;
    }
  }
  var version = getAndroidVersion2();
  if (version <= 12) {
    currentClassLoader.loadClass.overload("java.lang.String").implementation = backupImplementation;
  }
  return providerInstallerImpl;
}
function findProviderInstallerFromClassloaders(currentClassLoader, backupImplementation) {
  var providerInstaller = null;
  var classLoaders = Java.enumerateClassLoadersSync();
  for (var cl of classLoaders) {
    try {
      var classFactory = Java.ClassFactory.get(cl);
      providerInstaller = classFactory.use("com.google.android.gms.security.ProviderInstaller");
      break;
    } catch (error) {
      if (!error.toString().includes("java.lang.ClassNotFoundException")) {
        devlog_error("Error in hooking ProviderInstallerImpl (findProviderInstallerFromClassloaders):");
        devlog_error("Error message (findProviderInstallerFromClassloaders): " + error);
      }
      providerInstaller = null;
    }
  }
  var version = getAndroidVersion2();
  if (version <= 12) {
    currentClassLoader.loadClass.overload("java.lang.String").implementation = backupImplementation;
  }
  return providerInstaller;
}
function execute2() {
  Java.perform(function() {
    var javaClassLoader = Java.use("java.lang.ClassLoader");
    var backupImplementation = javaClassLoader.loadClass.overload("java.lang.String").implementation;
    javaClassLoader.loadClass.overload("java.lang.String").implementation = function(className) {
      let retval = this.loadClass(className);
      if (className.endsWith("ProviderInstallerImpl")) {
        log("Process is loading ProviderInstallerImpl");
        var providerInstallerImpl2 = findProviderInstallerImplFromClassloaders(javaClassLoader, backupImplementation);
        if (providerInstallerImpl2 === null) {
          log("ProviderInstallerImpl could not be found, although it has been loaded");
        } else {
          providerInstallerImpl2.insertProvider.implementation = function() {
            log("ProviderinstallerImpl redirection/blocking");
          };
        }
      }
      return retval;
    };
    try {
      var providerInstaller = Java.use("com.google.android.gms.security.ProviderInstaller");
      providerInstaller.installIfNeeded.implementation = function(context) {
        devlog("Providerinstaller redirection/blocking");
      };
      providerInstaller.installIfNeededAsync.implementation = function(context, callback) {
        devlog("ProviderinstallerAsncy redirection/blocking");
        callback.onProviderInstalled();
      };
    } catch (error) {
      try {
        var providerInstallerImpl = null;
        var providerInstallerFromClassloder = findProviderInstallerFromClassloaders(javaClassLoader, backupImplementation);
        if (providerInstallerFromClassloder === null) {
          providerInstallerImpl = findProviderInstallerImplFromClassloaders(javaClassLoader, backupImplementation);
        }
        if (providerInstallerFromClassloder === null && providerInstallerImpl === null || providerInstallerFromClassloder === void 0) {
          devlog("ProviderInstaller could not be found, although it has been loaded");
        } else {
          if (providerInstallerImpl !== null) {
            providerInstallerImpl.insertProvider.implementation = function() {
              devlog("ProviderinstallerImpl redirection/blocking");
            };
          } else {
            providerInstallerFromClassloder.installIfNeeded.implementation = function(context) {
              devlog("Providerinstaller redirection/blocking");
            };
            providerInstallerFromClassloder.installIfNeededAsync.implementation = function(context, callback) {
              devlog("ProviderinstallerAsync redirection/blocking");
              callback.onProviderInstalled();
            };
          }
        }
      } catch (error2) {
        devlog_error("Some error in hooking the Providerinstaller");
        if (!error2.toString().includes("java.lang.ClassNotFoundException")) {
          devlog_error("[-] Error message: " + error2);
        }
      }
    }
  });
}

// agent/ssl_lib/java_ssl_libs.ts
var SSL_Java = class {
  install_java_hooks() {
    if (Java.available) {
      setTimeout(function() {
        Java.perform(function() {
          var Security = Java.use("java.security.Security");
          if (Security.getProviders().toString().includes("GmsCore_OpenSSL")) {
            log("WARNING: PID " + Process.id + " Detected GmsCore_OpenSSL Provider. This can be a bit unstable. If you having issues, rerun with -spawn for early instrumentation. Trying to remove it to fall back on default Provider");
            Security.removeProvider("GmsCore_OpenSSL");
            log("Removed GmsCore_OpenSSL");
          }
          execute2();
          if (Security.getProviders().toString().includes("Ssl_Guard")) {
            log("Ssl_Guard deteced, removing it to fall back on default Provider");
            Security.removeProvider("Ssl_Guard");
            log("Removed Ssl_Guard");
          }
          if (Security.getProviders().toString().includes("Conscrypt version")) {
            log("Conscrypt detected");
            Security.removeProvider("Conscrypt");
            log("Removed Conscrypt");
          }
          if (Security.getProviders().toString().includes("WolfSSLProvider")) {
            log("WolfSSLProvider detected");
            Security.removeProvider("WolfSSLProvider");
            log("Removed WolfSSLProvider");
          }
          devlog("Remaining: " + Security.getProviders().toString());
          Security.insertProviderAt.implementation = function(provider, position) {
            if (provider.getName().includes("Conscrypt") || provider.getName().includes("Ssl_Guard") || provider.getName().includes("GmsCore_OpenSSL") || provider.getName().includes("WolfSSLProvider")) {
              log("Blocking provider registration (insertProviderAt) of  " + provider.getName());
              return position;
            } else {
              return this.insertProviderAt(provider, position);
            }
          };
          Security.insertProviderAt.implementation = function(provider) {
            if (provider.getName().includes("Conscrypt") || provider.getName().includes("Ssl_Guard") || provider.getName().includes("GmsCore_OpenSSL") || provider.getName().includes("WolfSSLProvider")) {
              log("Blocking provider registration (addProvider) of " + provider.getName());
              return 1;
            } else {
              if (isAndroid()) {
                if (provider.getName() === "AndroidNSSP") {
                  return this.insertProviderAt(provider, 1);
                }
              }
              return this.addProvider(provider);
            }
          };
        });
      }, 0);
    }
  }
};

// agent/android/android_java_tls_libs.ts
var SSL_Java_Android = class extends SSL_Java {
  install_java_android_hooks() {
    if (Java.available) {
      setTimeout(function() {
        Java.perform(function() {
          try {
            var testLoad = Java.use("org.spongycastle.jsse.provider.ProvSSLSocketDirect");
            log("Bouncycastle/Spongycastle detected.");
            execute();
          } catch (error) {
          }
        });
      }, 0);
    }
  }
  execute_hooks() {
    this.install_java_android_hooks();
    this.install_java_hooks();
  }
};
function java_execute() {
  var java_ssl = new SSL_Java_Android();
  java_ssl.execute_hooks();
}

// agent/ssl_lib/cronet.ts
var Cronet = class {
  moduleName;
  socket_library;
  passed_library_method_mapping;
  // global variables
  library_method_mapping = {};
  addresses;
  module_name;
  is_base_hook;
  constructor(moduleName, socket_library6, is_base_hook, passed_library_method_mapping) {
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.passed_library_method_mapping = passed_library_method_mapping;
    this.module_name = moduleName;
    this.is_base_hook = is_base_hook;
    if (typeof passed_library_method_mapping !== "undefined") {
      this.library_method_mapping = passed_library_method_mapping;
    } else {
      this.library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    }
    this.addresses = readAddresses(moduleName, this.library_method_mapping);
  }
  get_client_random(s3_ptr, SSL3_RANDOM_SIZE) {
    if (!s3_ptr.isNull()) {
      const client_random_ptr = s3_ptr.add(48);
      const client_random = client_random_ptr.readByteArray(SSL3_RANDOM_SIZE);
      const hexClientRandom = get_hex_string_from_byte_array(new Uint8Array(client_random));
      return hexClientRandom;
    } else {
      devlog("[Error] s3 pointer is NULL");
      return "";
    }
  }
  get_client_random_from_ssl_struct(ssl_st_ptr) {
    const SSL3_RANDOM_SIZE = 32;
    let offset_s3;
    switch (Process.arch) {
      case "x64":
        offset_s3 = 48;
        break;
      case "arm64":
        offset_s3 = 48;
        break;
      case "ia32":
        offset_s3 = 44;
        break;
      case "arm":
        offset_s3 = 44;
        break;
      default:
        devlog("[Error] Unsupported architecture");
        return "";
    }
    const s3_ptr = ssl_st_ptr.add(offset_s3).readPointer();
    return this.get_client_random(s3_ptr, SSL3_RANDOM_SIZE);
  }
  dumpKeys(labelPtr, sslStructPtr, keyPtr) {
    const MAX_KEY_LENGTH = 64;
    const RANDOM_KEY_LENGTH = 32;
    let labelStr = "";
    let client_random = "";
    let secret_key = "";
    if (!labelPtr.isNull()) {
      labelStr = labelPtr.readCString() ?? "";
    } else {
      devlog("[Error] Argument 'labelPtr' is NULL");
    }
    if (!sslStructPtr.isNull()) {
      client_random = this.get_client_random_from_ssl_struct(sslStructPtr);
    } else {
      devlog("[Error] Argument 'sslStructPtr' is NULL");
    }
    if (!keyPtr.isNull()) {
      let KEY_LENGTH = 0;
      let calculatedKeyLength = 0;
      while (calculatedKeyLength < MAX_KEY_LENGTH) {
        const byte = keyPtr.add(calculatedKeyLength).readU8();
        if (byte === 0) {
          if (calculatedKeyLength < 20) {
            calculatedKeyLength++;
            continue;
          }
          break;
        }
        calculatedKeyLength++;
      }
      if (calculatedKeyLength > 24 && calculatedKeyLength <= 40) {
        KEY_LENGTH = 32;
      } else if (calculatedKeyLength >= 46 && calculatedKeyLength <= 49) {
        KEY_LENGTH = 48;
      } else {
        KEY_LENGTH = 32;
      }
      const keyData = keyPtr.readByteArray(KEY_LENGTH);
      const hexKey = get_hex_string_from_byte_array(keyData);
      secret_key = hexKey;
    } else {
      devlog("[Error] Argument 'key' is NULL");
    }
    var message = {};
    message["contentType"] = "keylog";
    message["keylog"] = labelStr + " " + client_random + " " + secret_key;
    send(message);
  }
  install_plaintext_read_hook() {
  }
  install_plaintext_write_hook() {
  }
  install_key_extraction_hook() {
  }
};

// agent/shared/pattern_based_hooking.ts
function get_CPU_specific_pattern(default_pattern) {
  let arch = Process.arch.toString();
  if (arch === "ia32") {
    arch = "x86";
  }
  devlog("Trying Pattern: " + JSON.stringify(default_pattern[arch]));
  if (default_pattern[arch]) {
    return default_pattern[arch];
  } else {
    throw new Error(`No patterns found for CPU architecture: ${arch}`);
  }
}
var PatternBasedHooking = class {
  found_ssl_log_secret;
  no_hooking_success;
  module;
  patterns = {};
  rescannedRanges = /* @__PURE__ */ new Set();
  // Set to keep track of memory ranges that have been rescanned
  constructor(module) {
    this.found_ssl_log_secret = false;
    this.module = module;
    if (this.module === null) {
      devlog_error("[-] PatternBasedHooking Error: Unable to find module: " + this.module.name);
      devlog_error("[-] PatternBasedHooking Error: Abborting...");
      return;
    }
    this.no_hooking_success = true;
  }
  createRegexFromModule(moduleName) {
    const baseName = moduleName.replace(/\d+(\.\d+)*\.so$/, ".so");
    const regexPattern = `.*${baseName.replace(/\./g, "\\.")}$`;
    return new RegExp(regexPattern);
  }
  hookByPatternOnReturn(patterns2, pattern_name, userCallback, maxArgs, onCompleteCallback) {
    const moduleBase = this.module.base;
    const moduleSize = this.module.size;
    this.found_ssl_log_secret = false;
    let pattern;
    if (pattern_name === "primary_pattern") {
      pattern = patterns2.primary;
    } else {
      pattern = patterns2.fallback;
    }
    Memory.scan(moduleBase, moduleSize, pattern, {
      onMatch: (address) => {
        this.found_ssl_log_secret = true;
        this.no_hooking_success = false;
        var module_by_address = Process.findModuleByAddress(address);
        log(`Pattern found at (${pattern_name}) address: ${address} in module ${module_by_address.name}`);
        log(`Pattern-based hooks installed (onReturn).`);
        Interceptor.attach(address, {
          onEnter: function(args) {
            const stored = [];
            for (let i = 0; i <= maxArgs; i++) {
              try {
                stored.push(args[i]);
              } catch (_e) {
                console.log("error :" + i + " with error :" + _e);
                break;
              }
            }
            this.storedArgs = stored;
          },
          onLeave: function(retval) {
            const storedArgs = this.storedArgs || [];
            userCallback(storedArgs, retval);
          }
        });
      },
      onError: (reason) => {
        if (!this.found_ssl_log_secret) {
          devlog_error("There was an error scanning memory: " + reason);
          devlog_error("Trying to rescan memory with permissions in mind");
          this.hookByPatternOnlyReadablePartsOnReturn(patterns2, pattern_name, userCallback, (patternSuccess) => {
            if (!patternSuccess) {
              devlog("Primary pattern failed, trying fallback pattern (onReturn)...");
              this.hookByPatternOnlyReadablePartsOnReturn(patterns2, "fallback_pattern", userCallback, (patternSuccessAlt) => {
                if (!patternSuccessAlt) {
                  devlog("None of the patterns worked. Adjust or fallback.");
                  this.no_hooking_success = true;
                }
              }, maxArgs);
            }
          }, maxArgs);
        }
      },
      onComplete: () => {
        onCompleteCallback(this.found_ssl_log_secret);
      }
    });
  }
  /**
  *  For hooking modules with either the primary or fallback pattern (onReturn)
  */
  hookModuleByPatternOnReturn(patterns2, userCallback, maxArgs) {
    const moduleBase = this.module.base;
    const moduleSize = this.module.size;
    devlog(`Module Base Address: ${moduleBase}`);
    devlog(`Module Size: ${moduleSize}`);
    this.hookByPatternOnReturn(patterns2, "primary_pattern", userCallback, maxArgs, (pattern_success) => {
      if (!pattern_success) {
        devlog("Primary pattern failed, trying fallback pattern (onReturn)...");
        this.hookByPatternOnReturn(patterns2, "fallback_pattern", userCallback, maxArgs, (pattern_success_alt) => {
          if (!pattern_success_alt) {
            devlog("None of the onReturn patterns worked. Adjust patterns as needed.");
            this.no_hooking_success = true;
          }
        });
      }
    });
  }
  invoke_pattern_based_hooking_onReturn(action, module_name, platform, arch, userCallback, maxArgs) {
    const action_specific_patterns = this.get_action_specific_pattern(module_name, platform, arch, action);
    devlog(`Using ${action} patterns for ${platform} on ${arch} (onReturn)`);
    this.hookModuleByPatternOnReturn(action_specific_patterns, userCallback, maxArgs);
  }
  hook_with_pattern_from_json_onReturn(action_type, module_name, json_module_name, jsonContent, userCallback, maxArgs) {
    this.loadPatternsFromJSON(jsonContent);
    let platform = Process.platform.toString();
    if (isAndroid())
      platform = "android";
    else if (isiOS())
      platform = "ios";
    else if (isMacOS())
      platform = "macos";
    let arch = Process.arch.toString();
    if (arch === "ia32")
      arch = "x86";
    const regex = this.createRegexFromModule(module_name);
    if (this.patterns.modules[module_name] && this.patterns.modules[module_name][platform] && this.patterns.modules[module_name][platform][arch]) {
      this.invoke_pattern_based_hooking_onReturn(action_type, module_name, platform, arch, userCallback, maxArgs);
    } else if (this.patterns.modules[json_module_name] && this.patterns.modules[json_module_name][platform] && this.patterns.modules[json_module_name][platform][arch]) {
      this.invoke_pattern_based_hooking_onReturn(action_type, json_module_name, platform, arch, userCallback, maxArgs);
    } else {
      for (const jsonModuleName in this.patterns.modules) {
        if (regex.test(module_name)) {
          if (this.patterns.modules[jsonModuleName][platform] && this.patterns.modules[jsonModuleName][platform][arch]) {
            this.invoke_pattern_based_hooking_onReturn(action_type, jsonModuleName, platform, arch, userCallback, maxArgs);
          }
        } else {
          devlog("[-] No patterns available for the current platform or architecture.");
        }
      }
    }
  }
  // Method to hook by pattern, with a custom function to handle onEnter and onLeave
  hookByPattern(patterns2, pattern_name, onMatchCallback, onCompleteCallback) {
    const moduleName = this.module?.name;
    devlog(`Trying to scan ${moduleName} ...`);
    const moduleBase = this.module.base;
    const moduleSize = this.module.size;
    this.found_ssl_log_secret = false;
    let pattern;
    if (pattern_name === "primary_pattern") {
      pattern = patterns2.primary;
    } else if (pattern_name === "fallback_pattern") {
      pattern = patterns2.fallback;
    } else if (pattern_name === "second_fallback_pattern" && patterns2.second_fallback) {
      pattern = patterns2.second_fallback;
    } else {
      devlog_error(`Pattern ${pattern_name} not found or not provided.`);
      onCompleteCallback(false);
      return;
    }
    Memory.scan(moduleBase, moduleSize, pattern, {
      onMatch: (address) => {
        this.found_ssl_log_secret = true;
        this.no_hooking_success = false;
        if (!moduleName) {
          log(`Pattern found at (${pattern_name}) address: ${address} for module ${moduleName}`);
        } else {
          log(`Pattern found at (${pattern_name}) address: ${address}`);
        }
        log(`Pattern-based hooks installed.`);
        Interceptor.attach(address, {
          onEnter: function(args) {
            onMatchCallback(args);
          }
        });
      },
      onError: (reason) => {
        if (!this.found_ssl_log_secret) {
          devlog_error("There was an error scanning memory: " + reason);
          devlog_error(`Trying to rescan memory with permissions in mind on ${moduleName}`);
          this.hookByPatternOnlyReadableParts(patterns2, pattern_name, onMatchCallback, (primary_success) => {
            if (!primary_success) {
              devlog(`[!] Primary pattern failed, trying fallback pattern on ${moduleName}`);
              this.hookByPatternOnlyReadableParts(patterns2, "fallback_pattern", onMatchCallback, (fallback_success) => {
                if (!fallback_success) {
                  devlog(`[!] Fallback pattern failed, trying second fallback pattern on ${moduleName}`);
                  this.hookByPatternOnlyReadableParts(patterns2, "second_fallback_pattern", onMatchCallback, (second_fallback_success) => {
                    if (!second_fallback_success) {
                      devlog(`[!] None of the patterns worked. You may need to adjust the patterns for ${moduleName}`);
                      this.no_hooking_success = true;
                    }
                  });
                }
              });
            }
          });
        }
      },
      onComplete: () => {
        onCompleteCallback(this.found_ssl_log_secret);
      }
    });
  }
  // Method to hook by pattern, with a custom function to handle onEnter and onLeave
  hookByPatternOnlyReadableParts(patterns2, pattern_name, onMatchCallback, onCompleteCallback) {
    const moduleName = this.module?.name;
    devlog(`trying to scan only readable parts of ${moduleName} ...`);
    var pattern = "";
    if (pattern_name === "primary_pattern") {
      pattern = patterns2.primary;
    } else if (pattern_name === "fallback_pattern") {
      pattern = patterns2.fallback;
    } else if (pattern_name === "second_fallback_pattern" && patterns2.second_fallback) {
      pattern = patterns2.second_fallback;
    } else {
      pattern = patterns2.fallback;
    }
    this.module.enumerateRanges("r--").forEach((range) => {
      const rangeKey = `${range.base}-${range.size}`;
      Memory.scan(range.base, range.size, pattern, {
        onMatch: (address, size) => {
          this.found_ssl_log_secret = true;
          log(`Pattern found at (${pattern_name}) address: ${address.toString()} on ${moduleName}`);
          log(`Pattern based hooks installed.`);
          Interceptor.attach(address, {
            onEnter: function(args) {
              onMatchCallback(args);
            },
            onLeave: function(retval) {
            }
          });
        },
        onError: (reason) => {
        },
        onComplete: () => {
          if (this.rescannedRanges.has(rangeKey)) {
            return;
          } else {
            onCompleteCallback(this.found_ssl_log_secret);
          }
        }
      });
    });
  }
  hookByPatternOnlyReadablePartsOnReturn(patterns2, pattern_name, userCallback, onCompleteCallback, maxArgs = 8) {
    devlog(`Trying to scan only readable parts of ${this.module.name} ...`);
    let pattern;
    if (pattern_name === "primary_pattern") {
      pattern = patterns2.primary;
    } else {
      pattern = patterns2.fallback;
    }
    var ranges = Process.enumerateRanges("r--");
    let found = false;
    for (let i = 0; i < ranges.length; i++) {
      if (found) {
        break;
      }
      const range = ranges[i];
      const rangeKey = `${range.base}-${range.size}`;
      Memory.scan(range.base, range.size, pattern, {
        onMatch: (address) => {
          this.found_ssl_log_secret = true;
          var module_by_address = Process.findModuleByAddress(address);
          if (module_by_address) {
            log(`Pattern found at (${pattern_name}) address: ${address} in module ${module_by_address.name}`);
            let local_offset = address.sub(module_by_address.base);
            log(`Ghidra offset (Base 0x0): ${local_offset}`);
          }
          log(`Pattern found at (${pattern_name}) address: ${address} in module <name_not_found>`);
          log(`Could not get Ghidra offset`);
          log(`Pattern-based hooks installed (onReturn).`);
          Interceptor.attach(address, {
            onEnter: function(args) {
              const stored = [];
              for (let i2 = 0; i2 <= maxArgs; i2++) {
                try {
                  stored.push(args[i2]);
                } catch (_e) {
                  console.log("i = " + i2 + "  error: " + _e);
                  break;
                }
              }
              this.storedArgs = stored;
            },
            onLeave: function(retval) {
              const storedArgs = this.storedArgs || [];
              userCallback(storedArgs, retval);
            }
          });
          found = true;
          return "stop";
        },
        onError: (reason) => {
        },
        onComplete: () => {
          if (this.rescannedRanges.has(rangeKey)) {
            return;
          } else {
          }
        }
      });
    }
  }
  // Method to hook the module with patterns provided as arguments
  hookModuleByPattern(patterns2, onMatchCallback) {
    this.hookByPattern(patterns2, "primary_pattern", onMatchCallback, (primary_success) => {
      if (!primary_success) {
        devlog("Primary pattern failed, trying fallback pattern...");
        this.hookByPattern(patterns2, "fallback_pattern", onMatchCallback, (fallback_success) => {
          if (!fallback_success && patterns2.second_fallback) {
            devlog("Fallback pattern failed, trying second fallback pattern...");
            this.hookByPattern(patterns2, "second_fallback_pattern", onMatchCallback, (second_fallback_success) => {
              if (!second_fallback_success) {
                devlog("None of the patterns worked. Adjust patterns as needed.");
                this.no_hooking_success = true;
              }
            });
          } else if (!fallback_success) {
            devlog("None of the patterns worked. Adjust patterns as needed.");
            this.no_hooking_success = true;
          }
        });
      }
    });
  }
  loadPatternsFromJSON(jsonContent) {
    try {
      this.patterns = JSON.parse(jsonContent);
      devlog("Patterns loaded successfully from JSON.");
    } catch (error) {
      devlog("[-] Error loading or parsing JSON pattern:  " + error);
    }
  }
  invoke_pattern_based_hooking(action, module_name, platform, arch, hookCallback) {
    var action_specific_patterns = this.get_action_specific_pattern(module_name, platform, arch, action);
    devlog(`Using ${action} patterns for ${platform} on ${arch}`);
    this.hookModuleByPattern(action_specific_patterns, hookCallback);
  }
  // Function to retrieve patterns based on the current CPU architecture and action
  get_action_specific_pattern(module_name, platform, arch, action) {
    const archPatterns = this.patterns.modules[module_name][platform][arch];
    if (archPatterns[action]) {
      return archPatterns[action];
    } else {
      devlog(`No patterns found for action: ${action} on architecture: ${arch}`);
    }
  }
  hook_DumpKeys(module_name, json_module_name, jsonContent, hookCallback, onReturn = false, maxArgs = 8) {
    if (!onReturn) {
      this.hook_with_pattern_from_json("Dump-Keys", module_name, json_module_name, jsonContent, hookCallback);
    } else {
      this.hook_with_pattern_from_json_onReturn("Dump-Keys", module_name, json_module_name, jsonContent, hookCallback, maxArgs);
    }
  }
  hook_tls_keylog_callback(module_name, json_module_name, jsonContent, hookCallback) {
    this.hook_with_pattern_from_json("KeyLogCallback-Function", module_name, json_module_name, jsonContent, hookCallback);
    this.hook_with_pattern_from_json("Install-Key-Log-Callback", module_name, json_module_name, jsonContent, hookCallback);
  }
  hook_ssl_read_and_write(module_name, json_module_name, jsonContent, hookCallback) {
    this.hook_with_pattern_from_json("SSL_Read", module_name, json_module_name, jsonContent, hookCallback);
    this.hook_with_pattern_from_json("SSL_Write", module_name, json_module_name, jsonContent, hookCallback);
  }
  // Method to hook functions using patterns from JSON
  hook_with_pattern_from_json(action_type, module_name, json_module_name, jsonContent, hookCallback) {
    this.loadPatternsFromJSON(jsonContent);
    let platform = Process.platform.toString();
    if (isAndroid()) {
      platform = "android";
    } else if (isiOS()) {
      platform = "ios";
    } else if (isMacOS()) {
      platform = "macos";
    }
    let arch = Process.arch.toString();
    if (arch == "ia32") {
      arch = "x86";
    }
    const regex = this.createRegexFromModule(module_name);
    if (this.patterns.modules[module_name] && this.patterns.modules[module_name][platform] && this.patterns.modules[module_name][platform][arch]) {
      this.invoke_pattern_based_hooking(action_type, module_name, platform, arch, hookCallback);
    } else if (this.patterns.modules[json_module_name] && this.patterns.modules[json_module_name][platform] && this.patterns.modules[json_module_name][platform][arch]) {
      this.invoke_pattern_based_hooking(action_type, json_module_name, platform, arch, hookCallback);
    } else {
      for (const jsonModuleName in this.patterns.modules) {
        if (regex.test(module_name)) {
          if (this.patterns.modules[jsonModuleName][platform] && this.patterns.modules[jsonModuleName][platform][arch]) {
            this.invoke_pattern_based_hooking(action_type, jsonModuleName, platform, arch, hookCallback);
          }
        } else {
          devlog("[-] No patterns available for the current platform or architecture.");
        }
      }
    }
  }
};

// agent/android/cronet_android.ts
var EXCLUDED_MODULE_SUFFIXES = ["_libpki.so", "_libcrypto.so", "libmainlinecronet.136.0.7091.2.so"];
var STABLE_CRONET_PATTERNS = {
  "arm64": {
    primary: "FF 83 02 D1 FD 7B 05 A9 F9 33 00 F9 F8 5F 07 A9 F6 57 08 A9 F4 4F 09 A9 FD 43 01 91 58 D0 3B D5 08 17 40 F9 A8 83 1F F8 08 34 40 F9 08 21 41 F9 28 11",
    // Primary pattern
    fallback: "3F 23 03 D5 FF ?3 02 D1 FD 7B 0? A9 F? ?? 0? ?9 F6 57 0? A9 F4 4F 0? A9 FD ?3 01 91 08 34 40 F9 08 ?? 41 F9 ?8 ?? 00 B4"
    // Fallback pattern
  }
};
var Cronet_Android = class extends Cronet {
  moduleName;
  socket_library;
  default_pattern;
  constructor(moduleName, socket_library6, is_base_hook, patterns2) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.default_pattern = {
      "x64": {
        primary: "41 57 41 56 41 55 41 54 53 48 83 EC ?? 48 8B 47 68 48 83 B8 20 02 00 00 00 0F 84",
        // Primary pattern
        fallback: "55 41 57 41 56 41 54 53 48 83 EC 30 48 8B 47 68 48 83 B8 20 02 00 00 00 0F 84"
        // Fallback pattern
      },
      "x86": {
        primary: "55 53 57 56 83 EC 4C E8 00 00 00 00 5B 81 C3 A9 CB 13 00 8B 44 24 60 8B 40 34",
        // Primary pattern
        fallback: "55 53 57 56 83 EC 4C E8 00 00 00 00 5B 81 C3 A9 CB 13 00 8B 44 24 60"
        // Fallback pattern
      },
      "arm64": {
        primary: "3F 23 03 D5 FF ?3 01 D1 FD 7B 0? A9 F6 57 0? A9 F4 4F 0? A9 FD ?3 0? 91 08 34 40 F9 08 1? 41 F9 ?8 0? 00 B4",
        // Primary pattern
        //fallback: "3F 23 03 D5 FF 03 02 D1 FD 7B 04 A9 F7 2B 00 F9 F6 57 06 A9 F4 4F 07 A9 FD 03 01 91 08 34 40 F9 08 ?? 41 F9 ?8 0? 00 B4",  // old Fallback pattern
        fallback: "3F 23 03 D5 FF ?3 02 D1 FD 7B 0? A9 F? ?? 0? ?9 F6 57 0? A9 F4 4F 0? A9 FD ?3 01 91 08 34 40 F9 08 ?? 41 F9 ?8 ?? 00 B4",
        // Fallback pattern
        second_fallback: "3F 23 03 D5 FF C3 05 D1 FD 7B 14 A9 FC 57 15 A9 F4 4F 16 A9 FD 03 05 91 54 D0 3B D5 88 16 40 F9 40 00 80 52 F3"
      },
      "arm": {
        primary: "2D E9 F0 43 89 B0 04 46 40 6B D0 F8 2C 01 00 28 49 D0",
        // Primary pattern
        fallback: "2D E9 F0 41 86 B0 04 46 40 6B D0 F8 30 01 00 28 53 D0"
        // Fallback pattern
      }
    };
    if (patterns2) {
      this.default_pattern = patterns2;
    }
  }
  getSoName(modulePath) {
    const m2 = modulePath.match(/([^\/\\]+\.so)$/);
    return m2 ? m2[1] : modulePath;
  }
  install_key_extraction_hook() {
    let cronetModule = Process.findModuleByName(this.module_name);
    if (cronetModule === null) {
      const soName = this.getSoName(this.module_name);
      cronetModule = Process.findModuleByName(soName);
      if (cronetModule === null) {
        devlog("[-] Cronet Error: Unable to find module: " + this.module_name);
        return;
      }
    }
    const hooker = new PatternBasedHooking(cronetModule);
    if (isPatternReplaced()) {
      devlog("Hooking libcronet functions by patterns from JSON file");
      hooker.hook_DumpKeys(this.module_name, "libcronet.so", patterns, (args) => {
        devlog("Installed ssl_log_secret() hooks using byte patterns.");
        this.dumpKeys(args[1], args[0], args[2]);
      });
    } else {
      hooker.hookModuleByPattern(get_CPU_specific_pattern(this.default_pattern), (args) => {
        devlog("Installed ssl_log_secret() hooks using byte patterns.");
        this.dumpKeys(args[1], args[0], args[2]);
      });
    }
    return hooker;
  }
  // instead of relying on pattern we check if the target module has a symbol of ssl_log_secret()
  execute_symbol_based_hooking(hooker) {
    if (hooker === void 0 || hooker === null) {
      devlog("[-] Error: Hooker is undefined.");
      return;
    }
    let dumpKeysFunc = this.dumpKeys.bind(this);
    if (this.module_name.includes("libwarp_mobile")) {
      console.log("[!] The extracted CLIENT_RANDOM from libwarp_mobile.so is currently not working correctly.");
    }
    if (hooker.no_hooking_success) {
      let symbols = Process.getModuleByName(this.module_name).enumerateSymbols().filter((exports) => exports.name.toLowerCase().includes("ssl_log"));
      if (symbols.length > 0) {
        devlog("Installed ssl_log_secret() hooks using sybmols.");
        try {
          Interceptor.attach(symbols[0].address, {
            onEnter: function(args) {
              dumpKeysFunc(args[1], args[0], args[2]);
            }
          });
        } catch (e) {
        }
      }
    }
  }
  execute_hooks() {
    let hooker_instance = this.install_key_extraction_hook();
    return hooker_instance;
  }
};
function cronet_execute(moduleName, is_base_hook) {
  if (EXCLUDED_MODULE_SUFFIXES.some((suffix) => moduleName.endsWith(suffix))) {
    devlog(`[-] Skipping module ${moduleName} due to excluded suffix.`);
    return;
  }
  let cronet;
  if (moduleName.startsWith("stable_cronet")) {
    cronet = new Cronet_Android(moduleName, socket_library, is_base_hook, STABLE_CRONET_PATTERNS);
  } else {
    cronet = new Cronet_Android(moduleName, socket_library, is_base_hook);
  }
  try {
    let hooker = cronet.execute_hooks();
    setTimeout(function() {
      try {
        cronet.execute_symbol_based_hooking(hooker);
      } catch (e) {
        devlog("[-] Error in cronet.execute_symbol_based_hooking: " + e);
      }
    }, 1e3);
  } catch (error_msg) {
    devlog(`cronet_execute error: ${error_msg}`);
  }
  if (is_base_hook) {
    try {
      const init_addresses = cronet.addresses[moduleName];
      if (Object.keys(init_addresses).length > 0) {
        globalThis.init_addresses[moduleName] = init_addresses;
      }
    } catch (error_msg) {
      devlog(`cronet_execute base-hook error: ${error_msg}`);
    }
  }
}

// agent/ssl_lib/flutter.ts
var Flutter = class {
  moduleName;
  socket_library;
  passed_library_method_mapping;
  // global variables
  library_method_mapping = {};
  addresses;
  module_name;
  is_base_hook;
  constructor(moduleName, socket_library6, is_base_hook, passed_library_method_mapping) {
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.passed_library_method_mapping = passed_library_method_mapping;
    this.module_name = moduleName;
    this.is_base_hook = is_base_hook;
    if (typeof passed_library_method_mapping !== "undefined") {
      this.library_method_mapping = passed_library_method_mapping;
    } else {
      this.library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    }
    this.addresses = readAddresses(moduleName, this.library_method_mapping);
  }
  get_client_random(s3_ptr, SSL3_RANDOM_SIZE) {
    if (!s3_ptr.isNull()) {
      const client_random_ptr = s3_ptr.add(48);
      const client_random = client_random_ptr.readByteArray(SSL3_RANDOM_SIZE);
      const hexClientRandom = get_hex_string_from_byte_array(new Uint8Array(client_random));
      return hexClientRandom;
    } else {
      devlog("[Error] s3 pointer is NULL");
      return "";
    }
  }
  get_client_random_from_ssl_struct(ssl_st_ptr) {
    const SSL3_RANDOM_SIZE = 32;
    let offset_s3;
    switch (Process.arch) {
      case "x64":
        offset_s3 = 48;
        break;
      case "arm64":
        offset_s3 = 48;
        break;
      case "ia32":
        offset_s3 = 44;
        break;
      case "arm":
        offset_s3 = 44;
        break;
      default:
        devlog("[Error] Unsupported architecture");
        return "";
    }
    const s3_ptr = ssl_st_ptr.add(offset_s3).readPointer();
    return this.get_client_random(s3_ptr, SSL3_RANDOM_SIZE);
  }
  dumpKeys(labelPtr, sslStructPtr, keyPtr) {
    const KEY_LENGTH = 32;
    let labelStr = "";
    let client_random = "";
    let secret_key = "";
    if (!labelPtr.isNull()) {
      labelStr = labelPtr.readCString() ?? "";
    } else {
      devlog("[Error] Argument 'labelPtr' is NULL");
    }
    if (!sslStructPtr.isNull()) {
      client_random = this.get_client_random_from_ssl_struct(sslStructPtr);
    } else {
      devlog("[Error] Argument 'sslStructPtr' is NULL");
    }
    if (!keyPtr.isNull()) {
      const keyData = keyPtr.readByteArray(KEY_LENGTH);
      const hexKey = get_hex_string_from_byte_array(keyData);
      secret_key = hexKey;
    } else {
      devlog("[Error] Argument 'key' is NULL");
    }
    devlog("invoking ssl_log_secret() from BoringSSL statically linked into Flutter");
    var message = {};
    message["contentType"] = "keylog";
    message["keylog"] = labelStr + " " + client_random + " " + secret_key;
    send(message);
  }
  install_plaintext_read_hook() {
  }
  install_plaintext_write_hook() {
  }
  install_key_extraction_hook() {
  }
};

// agent/android/flutter_android.ts
var Flutter_Android = class extends Flutter {
  moduleName;
  socket_library;
  default_pattern;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.default_pattern = {
      "x64": {
        primary: "55 41 57 41 56 41 55 41 54 53 48 83 EC 48 48 8B 47 68 48 83 B8 20 02 00 00 00 0F 84 FE 00 00 00",
        // Primary pattern
        fallback: "55 41 57 41 56 41 55 41 54 53 48 83 EC 38 48 8B 47 68 48 83 B8 10 02 00 00 00 0F 84 19 01 00 00"
        // Fallback pattern
      },
      "x86": {
        primary: "55 53 57 56 83 EC 4C E8 00 00 00 00 5B 81 C3 A9 CB 13 00 8B 44 24 60 8B 40 34",
        // Primary pattern
        fallback: "55 89 E5 53 57 56 83 E4 F0 83 EC 50 E8 00 00 00 00"
        // Fallback pattern
      },
      "arm64": {
        primary: "E0 03 13 AA E2 03 16 AA 6D 62 FA 17",
        // Primary pattern
        fallback: "FF 83 01 D1 F6 1B 00 F9 F5 53 04 A9 F3 7B 05 A9 08 34 40 F9 08 09 41 F9 68 07 00 B4"
        // Fallback pattern
      },
      "arm": {
        primary: "2D E9 F0 43 89 B0 04 46 40 6B D0 F8 2C 01 00 28 49 D0",
        // Primary pattern
        fallback: "2D E9 F0 41 86 B0 04 46 40 6B D0 F8 30 01 00 28 53 D0"
        // Fallback pattern
      }
    };
  }
  install_key_extraction_hook() {
    const flutterModule = Process.findModuleByName(this.module_name);
    const hooker = new PatternBasedHooking(flutterModule);
    if (isPatternReplaced()) {
      devlog("Hooking libflutter functions by patterns from JSON file");
      hooker.hook_DumpKeys(this.module_name, "libflutter.so", patterns, (args) => {
        this.dumpKeys(args[1], args[0], args[2]);
      });
    } else {
      hooker.hookModuleByPattern(get_CPU_specific_pattern(this.default_pattern), (args) => {
        this.dumpKeys(args[1], args[0], args[2]);
      });
    }
  }
  execute_hooks() {
    this.install_key_extraction_hook();
  }
};
function flutter_execute(moduleName, is_base_hook) {
  var flutter = new Flutter_Android(moduleName, socket_library, is_base_hook);
  try {
    flutter.execute_hooks();
  } catch (error_msg) {
    devlog_error(`flutter_execute error: ${error_msg}`);
  }
  if (is_base_hook) {
    try {
      const init_addresses = flutter.addresses[moduleName];
      if (Object.keys(init_addresses).length > 0) {
        globalThis.init_addresses[moduleName] = init_addresses;
      }
    } catch (error_msg) {
      devlog_error(`flutter_execute base-hook error: ${error_msg}`);
    }
  }
}

// agent/ssl_lib/s2ntls.ts
var S2nTLS = class _S2nTLS {
  moduleName;
  socket_library;
  passed_library_method_mapping;
  library_method_mapping = {};
  addresses;
  module_name;
  static s2n_get_read_fd;
  static s2n_get_write_fd;
  static s2n_set_key_log_cb;
  //this function logs the given keylog line
  static keylog_callback = new NativeCallback(function(ctxPtr, conn, logline, len) {
    devlog("invoking keylog_callback from s2ntls");
    var message = {};
    message["contentType"] = "keylog";
    message["keylog"] = logline.readCString(len.toInt32());
    send(message);
    return 1;
  }, "int", ["pointer", "pointer", "pointer", "pointer"]);
  constructor(moduleName, socket_library6, passed_library_method_mapping) {
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.passed_library_method_mapping = passed_library_method_mapping;
    if (typeof passed_library_method_mapping !== "undefined") {
      this.library_method_mapping = passed_library_method_mapping;
    } else {
      this.library_method_mapping[`*${moduleName}*`] = ["s2n_send", "s2n_recv", "s2n_connection_get_read_fd", "s2n_connection_get_write_fd", "s2n_connection_new", "s2n_config_set_key_log_cb", "s2n_connection_set_config", "s2n_config_new"];
      this.library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    }
    this.addresses = readAddresses(moduleName, this.library_method_mapping);
    this.module_name = moduleName;
    if (offsets != "{OFFSETS}" && offsets.s2n != null) {
      if (offsets.sockets != null) {
        const socketBaseAddress = getBaseAddress(socket_library6);
        for (const method2 of Object.keys(offsets.sockets)) {
          const methodOffset = offsets.sockets[`${method2}`];
          const isAbsolute = methodOffset.absolute;
          const methodAddress = ptr(methodOffset.address);
          if (isAbsolute || socketBaseAddress == null) {
            this.addresses[this.moduleName][`${method2}`] = methodAddress;
          } else {
            this.addresses[this.moduleName][`${method2}`] = socketBaseAddress.add(methodAddress);
          }
        }
      }
      const libraryBaseAddress = getBaseAddress(moduleName);
      if (libraryBaseAddress == null) {
        log("Unable to find library base address! Given address values will be interpreted as absolute ones!");
      }
      for (const method2 of Object.keys(offsets.s2n)) {
        const methodOffset = offsets.s2n[`${method2}`];
        const isAbsolute = methodOffset.absolute;
        const methodAddress = ptr(methodOffset.address);
        if (isAbsolute || libraryBaseAddress == null) {
          this.addresses[this.moduleName][`${method2}`] = methodAddress;
        } else {
          this.addresses[this.moduleName][`${method2}`] = libraryBaseAddress.add(methodAddress);
        }
      }
    }
    _S2nTLS.s2n_get_read_fd = new NativeFunction(this.addresses[this.moduleName]["s2n_connection_get_read_fd"], "int", ["pointer", "pointer"]);
    _S2nTLS.s2n_get_write_fd = new NativeFunction(this.addresses[this.moduleName]["s2n_connection_get_write_fd"], "int", ["pointer", "pointer"]);
  }
  install_tls_keys_callback_hook() {
  }
  //Hooks the s2n_send function
  //Get the buffer on enter and read the data from it
  install_plaintext_read_hook() {
    var current_module_name = this.module_name;
    var lib_addresses = this.addresses;
    Interceptor.attach(lib_addresses[this.moduleName]["s2n_recv"], {
      onEnter: function(args) {
        var readfdPtr = Memory.alloc(Process.pointerSize);
        _S2nTLS.s2n_get_read_fd(args[0], readfdPtr);
        var readfd = readfdPtr.readInt();
        var message = getPortsAndAddresses(readfd, false, lib_addresses[current_module_name], enable_default_fd);
        message["function"] = "s2n_recv";
        message["ssl_session_id"] = "0";
        this.message = message;
        this.buf = args[1];
      },
      onLeave: function(retval) {
        try {
          retval = parseInt(retval);
          if (retval <= 0 || retval > 184332) {
            return;
          }
          if (this.buf && this.buf.readByteArray) {
            this.message["contentType"] = "datalog";
            send(this.message, this.buf.readByteArray(retval));
          } else {
            console.error("Buffer is not valid or readByteArray method is missing.");
          }
        } catch (error) {
          console.error("Error in onLeave (retval: " + retval + "):", error);
        }
      }
    });
  }
  //Hooks the s2n_recv function
  //Get the buffer on enter and read the retval bytes from it on leave
  install_plaintext_write_hook() {
    var current_module_name = this.module_name;
    var lib_addresses = this.addresses;
    Interceptor.attach(lib_addresses[this.moduleName]["s2n_send"], {
      onEnter: function(args) {
        var writefdPtr = Memory.alloc(Process.pointerSize);
        _S2nTLS.s2n_get_write_fd(args[0], writefdPtr);
        var writefd = writefdPtr.readInt();
        var message = getPortsAndAddresses(writefd, true, lib_addresses[current_module_name], enable_default_fd);
        message["function"] = "s2n_send";
        message["ssl_session_id"] = "0";
        this.message = message;
        this.buf = args[1];
      },
      onLeave: function(retval) {
        retval = parseInt(retval);
        if (retval < 0) {
          return;
        }
        this.message["contentType"] = "datalog";
        send(this.message, this.buf.readByteArray(retval));
      }
    });
  }
};

// agent/android/s2ntls_android.ts
var S2nTLS_Android = class extends S2nTLS {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
    this.install_tls_keys_callback_hook();
  }
  //if set_config is called, the keylog callback is set
  install_tls_keys_callback_hook() {
    S2nTLS.s2n_set_key_log_cb = new NativeFunction(this.addresses[this.module_name]["s2n_config_set_key_log_cb"], "int", ["pointer", "pointer", "pointer"]);
    Interceptor.attach(this.addresses[this.module_name]["s2n_config_new"], {
      onLeave: function(retval) {
        let emptyPointer = ptr("0");
        S2nTLS.s2n_set_key_log_cb(retval, S2nTLS.keylog_callback, emptyPointer);
      }
    });
    Interceptor.attach(this.addresses[this.module_name]["s2n_config_set_key_log_cb"], {
      onEnter: function(args) {
        let user_callback = args[1];
        Interceptor.attach(user_callback, {
          onEnter: function(args2) {
            let logline = args2[2];
            let len = args2[3];
            var message = {};
            message["contentType"] = "keylog";
            message["keylog"] = logline.readCString(len.toInt32());
            send(message);
          }
        });
      }
    });
  }
};
function s2ntls_execute(moduleName, is_base_hook) {
  var s2n_tls = new S2nTLS_Android(moduleName, socket_library, is_base_hook);
  s2n_tls.execute_hooks();
  if (is_base_hook) {
    const init_addresses = s2n_tls.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/ssl_lib/monobtls.ts
var Mono_BTLS = class {
  moduleName;
  socket_library;
  passed_library_method_mapping;
  // global variables
  library_method_mapping = {};
  addresses;
  module_name;
  is_base_hook;
  constructor(moduleName, socket_library6, is_base_hook, passed_library_method_mapping) {
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.passed_library_method_mapping = passed_library_method_mapping;
    this.module_name = moduleName;
    this.is_base_hook = is_base_hook;
    if (typeof passed_library_method_mapping !== "undefined") {
      this.library_method_mapping = passed_library_method_mapping;
    } else {
      this.library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    }
    this.addresses = readAddresses(moduleName, this.library_method_mapping);
  }
  get_client_random(s3_ptr, SSL3_RANDOM_SIZE) {
    if (!s3_ptr.isNull()) {
      const client_random_ptr = s3_ptr.add(48);
      const client_random = client_random_ptr.readByteArray(SSL3_RANDOM_SIZE);
      const hexClientRandom = get_hex_string_from_byte_array(new Uint8Array(client_random));
      return hexClientRandom;
    } else {
      devlog("[Error] s3 pointer is NULL");
      return "";
    }
  }
  get_client_random_from_ssl_struct(ssl_st_ptr) {
    const SSL3_RANDOM_SIZE = 32;
    let offset_s3;
    switch (Process.arch) {
      case "x64":
        offset_s3 = 48;
        break;
      case "arm64":
        offset_s3 = 48;
        break;
      case "ia32":
        offset_s3 = 44;
        break;
      case "arm":
        offset_s3 = 44;
        break;
      default:
        devlog("[Error] Unsupported architecture");
        return "";
    }
    const s3_ptr = ssl_st_ptr.add(offset_s3).readPointer();
    return this.get_client_random(s3_ptr, SSL3_RANDOM_SIZE);
  }
  dumpKeys(labelPtr, sslStructPtr, keyPtr) {
    const KEY_LENGTH = 32;
    let labelStr = "";
    let client_random = "";
    let secret_key = "";
    if (!labelPtr.isNull()) {
      labelStr = labelPtr.readCString() ?? "";
    } else {
      devlog("[Error] Argument 'labelPtr' is NULL");
    }
    if (!sslStructPtr.isNull()) {
      client_random = this.get_client_random_from_ssl_struct(sslStructPtr);
    } else {
      devlog("[Error] Argument 'sslStructPtr' is NULL");
    }
    if (!keyPtr.isNull()) {
      const keyData = keyPtr.readByteArray(KEY_LENGTH);
      const hexKey = get_hex_string_from_byte_array(keyData);
      secret_key = hexKey;
    } else {
      devlog("[Error] Argument 'key' is NULL");
    }
    var message = {};
    message["contentType"] = "keylog";
    message["keylog"] = labelStr + " " + client_random + " " + secret_key;
    send(message);
  }
  install_plaintext_read_hook() {
  }
  install_plaintext_write_hook() {
  }
  install_key_extraction_hook() {
  }
};

// agent/android/mono_btls_android.ts
var Mono_BTLS_Android = class extends Mono_BTLS {
  moduleName;
  socket_library;
  default_pattern;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.default_pattern = {
      "x64": {
        primary: "55 41 57 41 56 41 54 53 49 89 D4 49 89 F6 48 89 FB E8 5A F8 FF FF",
        // Primary pattern
        fallback: "55 41 57 41 56 41 55 41 54 53 48 83 EC 38 48 8B 47 68 48 83 B8 10 02 00 00 00 0F 84 19 01 00 00"
        // Fallback pattern
      },
      "x86": {
        primary: "55 89 E5 53 57 56 83 E4 F0 83 EC 10 E8 00 00 00 00",
        // Primary pattern
        fallback: "55 53 57 56 83 EC 4C E8 00 00 00 00 5B 81 C3 A9 CB 13 00 8B 44 24 60 8B 40 34"
        // Fallback pattern
      },
      "arm64": {
        primary: "F6 57 BD A9 F4 4F 01 A9 FD 7B 02 A9 FD 83 00 91 F3 03 02 AA F4 03 01 AA F5 03 00 AA 1F FE FF 97",
        // Primary pattern
        fallback: "FF 83 01 D1 F6 1B 00 F9 F5 53 04 A9 F3 7B 05 A9 08 34 40 F9 08 09 41 F9 68 07 00 B4"
        // Fallback pattern
      },
      "arm": {
        primary: "F0 B5 03 AF 4D F8 04 8D 14 46 0D 46 06 46 FF F7 5F FD",
        // Primary pattern
        fallback: "2D E9 F0 41 86 B0 04 46 40 6B D0 F8 30 01 00 28 53 D0"
        // Fallback pattern
      }
    };
  }
  install_key_extraction_hook() {
    const flutterModule = Process.findModuleByName(this.module_name);
    const hooker = new PatternBasedHooking(flutterModule);
    if (isPatternReplaced()) {
      devlog("Hooking Libmono functions by patterns from JSON file");
      hooker.hook_DumpKeys(this.module_name, "libmono-btls-shared.so", patterns, (args) => {
        this.dumpKeys(args[1], args[0], args[2]);
      });
    } else {
      hooker.hookModuleByPattern(get_CPU_specific_pattern(this.default_pattern), (args) => {
        this.dumpKeys(args[1], args[0], args[2]);
      });
    }
  }
  execute_hooks() {
    this.install_key_extraction_hook();
  }
};
function mono_btls_execute(moduleName, is_base_hook) {
  var mono_btls = new Mono_BTLS_Android(moduleName, socket_library, is_base_hook);
  try {
    mono_btls.execute_hooks();
  } catch (error_msg) {
    devlog_error(`mono_btls_execute error: ${error_msg}`);
  }
  if (is_base_hook) {
    try {
      const init_addresses = mono_btls.addresses[moduleName];
      if (Object.keys(init_addresses).length > 0) {
        globalThis.init_addresses[moduleName] = init_addresses;
      }
    } catch (error_msg) {
      devlog_error(`mono_btls_execute base-hook error: ${error_msg}`);
    }
  }
}

// agent/ssl_lib/rustls.ts
var RusTLS = class {
  moduleName;
  socket_library;
  passed_library_method_mapping;
  // global variables
  library_method_mapping = {};
  addresses;
  module_name;
  is_base_hook;
  static rustls_client_config_builder_new;
  static rustls_client_config_builder_new_custom;
  static rustls_client_config_set_key_log;
  // Callbackfuntion for logging keying material
  static keyLogCB = new NativeCallback(function(label, client_random, client_random_len, secret, secret_size) {
    devlog("invoking keyLogCB from rustls");
    var message = {};
    message["contentType"] = "keylog";
    var labelStr;
    if (label[1].toNumber() == 0) {
      labelStr = "CLIENT_RANDOM ";
    } else {
      labelStr = label[0].readUtf8String(label[1].toNumber());
    }
    var clientRandomStr = client_random.readByteArray(client_random_len.toNumber());
    var secretStr = secret.readByteArray(secret_size.toNumber());
    var clientRandomHex = Array.from(new Uint8Array(clientRandomStr)).map((b) => b.toString(16).padStart(2, "0")).join("");
    var secretHex = Array.from(new Uint8Array(secretStr)).map((b) => b.toString(16).padStart(2, "0")).join("");
    message["keylog"] = `${labelStr} ${clientRandomHex} ${secretHex}`;
    send(message);
    return 1;
  }, "void", [["pointer", "size_t"], "pointer", "size_t", "pointer", "size_t"]);
  constructor(moduleName, socket_library6, is_base_hook, passed_library_method_mapping) {
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.passed_library_method_mapping = passed_library_method_mapping;
    this.module_name = moduleName;
    this.is_base_hook = is_base_hook;
    if (typeof passed_library_method_mapping !== "undefined") {
      this.library_method_mapping = passed_library_method_mapping;
    } else {
      if (checkNumberOfExports(moduleName) > 2) {
        try {
          this.library_method_mapping[`*${moduleName}*`] = ["*derive_logged_secret*", "*for_secret*"];
        } catch (e) {
        }
        try {
          this.library_method_mapping[`*${moduleName}*`] = [
            "*rustls_connection_write_tls*",
            "*rustls_connection_read_tls*",
            "*rustls_client_config_builder_new*",
            "*rustls_client_config_builder_new_custom*",
            "*rustls_client_config_builder_set_key_log*"
          ];
        } catch (e) {
        }
      }
      this.library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    }
    this.addresses = readAddresses(moduleName, this.library_method_mapping);
    this.module_name = moduleName;
    if (offsets != "{OFFSETS}" && offsets.rustls != null) {
      if (offsets.sockets != null) {
        const socketBaseAddress = getBaseAddress(socket_library6);
        for (const method2 of Object.keys(offsets.sockets)) {
          const methodOffset = offsets.sockets[`${method2}`];
          const isAbsolute = methodOffset.absolute;
          const methodAddress = ptr(methodOffset.address);
          if (isAbsolute || socketBaseAddress == null) {
            this.addresses[this.moduleName][`${method2}`] = methodAddress;
          } else {
            this.addresses[this.moduleName][`${method2}`] = socketBaseAddress.add(methodAddress);
          }
        }
      }
      const libraryBaseAddress = getBaseAddress(moduleName);
      if (libraryBaseAddress == null) {
        log("Unable to find library base addresss! Given address values will be interpreted as absolute ones!");
      }
      for (const method2 of Object.keys(offsets.rustls)) {
        const methodOffset = offsets.rustls[`${method2}`];
        const isAbsolute = methodOffset.absolute;
        const methodAddress = ptr(methodOffset.address);
        if (isAbsolute || libraryBaseAddress == null) {
          this.addresses[this.moduleName][`${method2}`] = methodAddress;
        } else {
          this.addresses[this.moduleName][`${method2}`] = libraryBaseAddress.add(methodAddress);
        }
      }
    }
  }
  /*
  In Rustls the labels are mapped as enums
  cf. https://github.com/rustls/rustls/blob/5860d10317528e4f162db6e26c74f81575c51403/rustls/src/tls13/key_schedule.rs#L31
  */
  enumMapping = {
    0: "RESUMPTION_PSK_BINDER_KEY",
    // ResumptionPskBinderKey
    1: "CLIENT_EARLY_TRAFFIC_SECRET",
    // ClientEarlyTrafficSecret
    2: "CLIENT_HANDSHAKE_TRAFFIC_SECRET",
    // ClientHandshakeTrafficSecret
    3: "SERVER_HANDSHAKE_TRAFFIC_SECRET",
    // ServerHandshakeTrafficSecret
    4: "CLIENT_TRAFFIC_SECRET_0",
    // ClientApplicationTrafficSecret
    5: "SERVER_TRAFFIC_SECRET_0",
    // ServerApplicationTrafficSecret
    6: "EXPORTER_SECRET",
    // ExporterMasterSecret
    7: "RESUMPTION_MASTER_SECRET",
    // ResumptionMasterSecret
    8: "DERIVED"
    // Derived
  };
  getEnumString(enumValue) {
    return this.enumMapping[enumValue] || null;
  }
  // Checks if the pointer's C-string starts with "key expansion" - only used for TLS 1.2 traffic
  isArgKeyExp(ptr2) {
    let labelStr = "";
    try {
      if (!ptr2.isNull()) {
        const label = ptr2.readCString();
        labelStr = label;
        if (labelStr === null) {
          return false;
        } else {
          return labelStr.startsWith("key expansion");
        }
      }
    } catch (error) {
      devlog("[!] Error reading pointer in isArgKeyExp (RusTLS):" + error.message);
      return false;
    }
    return false;
  }
  /**
   * Hooking hkdf_expand_label() to get secrets from TLS 1.3 traffic.
   * This is used for the Android Hooks only
   */
  /*
   Hooking hkdf_expand_label to get secrets from TLS 1.3 traffic.
   This is used for the Android Hooks.
  */
  dumpKeysFromDeriveSecrets(client_random_ptr, key, key_len, label_enum) {
    let KEY_LENGTH = 32;
    if (key_len > 16) {
      KEY_LENGTH = key_len;
    }
    let labelStr = "";
    let client_random = "";
    let secret_key = "";
    const RANDOM_KEY_LENGTH = 32;
    labelStr = this.getEnumString(label_enum) || "";
    if (client_random_ptr != null) {
      const randomData = client_random_ptr.readByteArray(RANDOM_KEY_LENGTH);
      if (randomData) {
        client_random = Array.from(new Uint8Array(randomData)).map((byte) => byte.toString(16).padStart(2, "0").toUpperCase()).join("");
      }
    } else {
      client_random = "<identify using PCAP> ";
    }
    if (!key.isNull()) {
      const keyData = key.readByteArray(KEY_LENGTH);
      if (keyData) {
        secret_key = Array.from(new Uint8Array(keyData)).map((byte) => byte.toString(16).padStart(2, "0").toUpperCase()).join("");
      }
    } else {
      devlog("[Error] Argument 'key' is NULL");
    }
    var message = {};
    message["contentType"] = "keylog";
    message["keylog"] = labelStr + " " + client_random + " " + secret_key;
    send(message);
    return true;
  }
  /**
   *  Hooking from_key_exchange() to get secrets from TLS 1.2 traffic
   *  https://github.com/rustls/rustls/blob/293f05e9d1011132a749b8b6e0435f701421fd01/rustls/src/tls12/mod.rs#L102
   *  This hook is used for both, Linux and Android.
   */
  dumpKeysFromPRF(client_random_ptr, key) {
    const KEY_LENGTH = 32;
    const MASTER_SECRET_LEN = 48;
    const labelStr = "CLIENT_RANDOM";
    let client_random = "";
    let secret_key = "";
    if (!key.isNull()) {
      const keyData = key.readByteArray(MASTER_SECRET_LEN);
      if (keyData) {
        secret_key = Array.from(new Uint8Array(keyData)).map((byte) => byte.toString(16).padStart(2, "0").toUpperCase()).join("");
      }
    } else {
      devlog("[!] Argument 'key' is NULL");
    }
    if (!client_random_ptr.isNull()) {
      const keyData = client_random_ptr.readByteArray(KEY_LENGTH);
      if (keyData) {
        client_random = Array.from(new Uint8Array(keyData)).map((byte) => byte.toString(16).padStart(2, "0").toUpperCase()).join("");
      }
    } else {
      devlog("[!] Argument 'client_random_ptr' is NULL");
    }
    var message = {};
    message["contentType"] = "keylog";
    message["keylog"] = labelStr + " " + client_random + " " + secret_key;
    send(message);
    return true;
  }
  /**
   * On Linux the BoringSecretHunter Identifies a different function (derive_logged_secrets()).
   * https://github.com/rustls/rustls/blob/bdb303696dea02ecc6b5de3907880e181899d717/rustls/src/tls13/key_schedule.rs#L676
   * The following extracts the secrets for TLS 1.3.
   */
  dumpKeysFromDeriveLogged(client_random_ptr, key, label_enum) {
    let KEY_LENGTH = key.add(64).readU32();
    let labelStr = "";
    let client_random = "";
    let secret_key = "";
    const RANDOM_KEY_LENGTH = 32;
    devlog("Called dumpKeysFromDeriveLogged()");
    labelStr = this.getEnumString(label_enum) || "";
    if (client_random_ptr != null) {
      const randomData = client_random_ptr.readByteArray(RANDOM_KEY_LENGTH);
      if (randomData) {
        client_random = Array.from(new Uint8Array(randomData)).map((byte) => byte.toString(16).padStart(2, "0").toUpperCase()).join("");
      }
    } else {
      client_random = "<identify using PCAP> ";
    }
    if (!key.isNull()) {
      const keyData = key.readByteArray(KEY_LENGTH);
      if (keyData) {
        secret_key = Array.from(new Uint8Array(keyData)).map((byte) => byte.toString(16).padStart(2, "0").toUpperCase()).join("");
      }
    } else {
      devlog("[Error] Argument 'key' is NULL");
    }
    var message = {};
    message["contentType"] = "keylog";
    message["keylog"] = labelStr + " " + client_random + " " + secret_key;
    send(message);
    return true;
  }
  hook_tls_12_key_generation_function() {
  }
  install_plaintext_read_hook() {
  }
  install_plaintext_write_hook() {
  }
  install_key_extraction_hook() {
  }
};

// agent/android/rustls_android.ts
var Rustls_Android = class extends RusTLS {
  moduleName;
  socket_library;
  default_pattern_tls13;
  default_pattern_ex_tls13;
  default_pattern_tls12;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.default_pattern_tls13 = {
      "x64": {
        //primary:  "41 57 41 56 41 55 41 54 53 48 83 EC ?? 48 8B 47 68 48 83 B8 20 02 00 00 00 0F 84", // Primary pattern
        primary: "55 41 57 41 56 41 55 41 54 53 48 81 EC C8 00 00 00 4D 89 CD 4C 89 44 24 10 48 89 4C 24 18 49 89 D6 49 89 F4 48 89 FB 0F B6 C1 C1 E0 03 48 8D",
        fallback: "55 41 57 41 56 41 55 41 54 53 48 81 EC C8 00 00 00 4D 89 CD 4C 89 44 24 10 48 89 4C"
        // Fallback pattern
      },
      "x86": {
        primary: "55 53 57 56 83 EC 4C E8 00 00 00 00 5B 81 C3 A9 CB 13 00 8B 44 24 60 8B 40 34",
        // Primary pattern
        fallback: "55 53 57 56 83 EC 4C E8 00 00 00 00 5B 81 C3 A9 CB 13 00 8B 44 24 60"
        // Fallback pattern
      },
      "arm64": {
        primary: "FF 83 04 D1 FD 7B 0C A9 FC 6F 0D A9 FA 67 0E A9 F8 5F 0F A9 F6 57 10 A9 F4 4F 11 A9 F6 03 03 2A ?8 0? 00 ?0 08 ?1 ?? 91 C9 1E 40",
        // Primary pattern
        fallback: "FF 83 04 D1 FD 7B 0C A9 FC 6F 0D A9 FA 67 0E A9 F8 5F 0F A9 F6 57 10 A9 F4 4F 11 A9 F6 03 03 2A ?8 0? 00 ?0 08"
        // Fallback pattern
      },
      "arm": {
        primary: "2D E9 F0 43 89 B0 04 46 40 6B D0 F8 2C 01 00 28 49 D0",
        // Primary pattern
        fallback: "2D E9 F0 41 86 B0 04 46 40 6B D0 F8 30 01 00 28 53 D0"
        // Fallback pattern
      }
    };
    this.default_pattern_ex_tls13 = {
      "x64": {
        //primary:  "41 57 41 56 41 55 41 54 53 48 83 EC ?? 48 8B 47 68 48 83 B8 20 02 00 00 00 0F 84", // Primary pattern
        primary: "55 41 57 41 56 41 55 41 54 53 48 81 EC C8 00 00 00 4D 89 CD 4C 89 44 24 10 48 89 4C 24 18 49 89 D6 49 89 F4 48 89 FB 0F B6 C1 C1 E0 03 48 8D",
        fallback: "55 41 57 41 56 41 55 41 54 53 48 81 EC C8 00 00 00 4D 89 CD 4C 89 44 24 10 48 89 4C"
        // Fallback pattern
      },
      "x86": {
        primary: "55 53 57 56 83 EC 4C E8 00 00 00 00 5B 81 C3 A9 CB 13 00 8B 44 24 60 8B 40 34",
        // Primary pattern
        fallback: "55 53 57 56 83 EC 4C E8 00 00 00 00 5B 81 C3 A9 CB 13 00 8B 44 24 60"
        // Fallback pattern
      },
      "arm64": {
        primary: "FF 83 04 D1 FD 7B 0C A9 FC 6F 0D A9 FA 67 0E A9 F8 5F 0F A9 F6 57 10 A9 F4 4F 11 A9 F6 03 03 2A 88 0C 00 F0 08 E1 3B 91 C9 1E 40",
        // Primary pattern
        fallback: "FF 83 04 D1 FD 7B 0C A9 FC 6F 0D A9 FA 67 0E A9 F8 5F 0F A9 F6 57 10 A9 F4 4F 11 A9 F6 03 03 2A 88 0C 00 F0 08 E1"
        // Fallback pattern
      },
      "arm": {
        primary: "2D E9 F0 43 89 B0 04 46 40 6B D0 F8 2C 01 00 28 49 D0",
        // Primary pattern
        fallback: "2D E9 F0 41 86 B0 04 46 40 6B D0 F8 30 01 00 28 53 D0"
        // Fallback pattern
      }
    };
    this.default_pattern_tls12 = {
      "x64": {
        primary: "55 41 57 41 56 41 55 41 54 53 48 81 ec 48 01 00 00 4c 89 c0 49 89 cb 49 89 d6 49 89 f7 48 89 fb 48 8b 8c 24 88 01 00 00 48 8b 94 24 80 01 00",
        fallback: "55 41 57 41 56 41 55 41 54 53 48 81 ec 48 01 00 00 4c 89 c0 49 89 cb 49 89 d6 49 89 f7 48 89 fb 48 8b 8c 24 88 01 00 00 48 8b"
      },
      "arm64": {
        primary: "FF 03 07 D1 FD 7B 19 A9 F6 57 1A A9 F4 4F 1B A9 A1 08 40 AD 03 E4 00 6F F3 03 08 AA 88 00 40 B9 EB 03 03 AA E9 03 02 AA F4 03 01 AA F5 03 00 AA E1 0B 01 AD A0 04 41 AD F6 43 02 91 E3 8F 03 AD E6 0F 00 F9 E0 03 84 3C E1 8F 02 AD",
        // Primary pattern
        fallback: "FF 03 07 D1 FD 7B 19 A9 F6 57 1A A9 F4 4F 1B A9 A1 08 40 AD 03 E4 00 6F F3 03 08 AA 88 00 40 B9 EB 03 03 AA E9 03 02 AA F4 03 01 AA F5 03 00 AA E1 0B 01 AD A0 04 41 AD F6 43 02 91 E3"
        // Fallback pattern
      },
      "arm": {
        primary: "2D E9 F0 4F D1 B0 0A AD 8A 46 05 F1 44 07 81 46 30 21 1C 46 38 46 93 46 FB F0 A8 F9 5C 9E 28 1D 40 22 31 46 FB F0 2D FA 5B 99 DD F8 74 81 CD",
        fallback: "2D E9 F0 4F D1 B0 0A AD 8A 46 05 F1 44 07 81 46 30 21 1C 46 38 46 93 46 FB F0 A8 F9 5C 9E 28 1D 40 22 31 46 FB F0 2D FA 5B 99"
      }
    };
  }
  execute_pattern_hooks() {
    this.install_key_extraction_hook();
  }
  install_key_extraction_hook() {
    const rusTLSModule = Process.findModuleByName(this.module_name);
    const hooker = new PatternBasedHooking(rusTLSModule);
    const isEx = this.module_name.includes("_ex");
    const isX64 = Process.arch === "x64";
    this.install_key_extraction_hook_tls13(hooker, isEx, isX64);
    if (!isPatternReplaced()) {
      this.install_key_extraction_hook_tls12(hooker, isEx, isX64);
    }
  }
  // This has been tested for x86_64 and ARM
  install_key_extraction_hook_tls12(hooker, isEx, isX64) {
    const doDumpKeysLogic = (args, retval) => {
      let client_random_ptr;
      let master_secret_ptr;
      if (Process.arch === "arm64") {
        client_random_ptr = args[5];
        master_secret_ptr = args[5].add(136);
      } else {
        client_random_ptr = args[6];
        master_secret_ptr = retval.add(72);
      }
      this.dumpKeysFromPRF(client_random_ptr, master_secret_ptr);
    };
    const normalPatternCallback = (args, retval) => {
      if (!retval) {
        devlog("retval is null");
        return;
      }
      if (!retval.isNull()) {
        doDumpKeysLogic(args, retval);
      }
    };
    if (isPatternReplaced()) {
      devlog(`[Hooking with JSON patterns onReturn] isEx = ${isEx}`);
      hooker.hook_DumpKeys(
        this.module_name,
        // Pick the JSON module name based on whether it’s “ex”
        isEx ? "librustls_ex.so" : "librustls.so",
        patterns,
        normalPatternCallback,
        true,
        // onReturn so we get retval
        isX64 ? 7 : 8
      );
    } else {
      devlog(`[Hooking with built-in fallback patterns onReturn] isEx = ${isEx}`);
      hooker.hookModuleByPatternOnReturn(
        // Pick the default pattern based on whether it’s “ex”
        get_CPU_specific_pattern(isEx ? this.default_pattern_tls12 : this.default_pattern_tls12),
        normalPatternCallback,
        isX64 ? 7 : 8
      );
    }
  }
  install_key_extraction_hook_tls13(hooker, isEx, isX64) {
    const doDumpKeysLogic = (args, retval) => {
      let client_random_ptr;
      let key;
      let key_len;
      let label_enum;
      client_random_ptr = args[9];
      key = args[0];
      key_len = args[5].toInt32();
      label_enum = args[3].toInt32();
      this.dumpKeysFromDeriveSecrets(client_random_ptr, key, key_len, label_enum);
    };
    const normalPatternCallback = (args, retval) => {
      if (!retval)
        return;
      if (retval.isNull()) {
        doDumpKeysLogic(args, retval);
      } else {
        if (Process.arch === "x64" || Process.arch === "arm64") {
          doDumpKeysLogic(args, retval);
        }
      }
    };
    const exPatternCallback = (args, retval) => {
      if (!retval)
        return;
      if (!retval.isNull()) {
        doDumpKeysLogic(args, retval);
      } else {
      }
    };
    if (isPatternReplaced()) {
      devlog(`[Hooking with JSON patterns onReturn] isEx = ${isEx}`);
      hooker.hook_DumpKeys(
        this.module_name,
        // Pick the JSON module name based on whether it’s “ex”
        isEx ? "librustls_ex.so" : "librustls.so",
        patterns,
        isEx ? exPatternCallback : normalPatternCallback,
        true,
        // onReturn so we get retval
        isX64 ? 7 : 9
      );
    } else {
      devlog(`[Hooking with built-in fallback patterns onReturn] isEx = ${isEx}`);
      hooker.hookModuleByPatternOnReturn(
        // Pick the default pattern based on whether it’s “ex”
        get_CPU_specific_pattern(isEx ? this.default_pattern_ex_tls13 : this.default_pattern_tls13),
        isEx ? exPatternCallback : normalPatternCallback,
        isX64 ? 7 : 9
      );
    }
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
    this.install_tls_keys_callback_hook();
  }
  // Extract the configBuilder from call to rustls_client_config_builder_new / _custom and set keyLogCB
  install_tls_keys_callback_hook() {
    RusTLS.rustls_client_config_set_key_log = new NativeFunction(this.addresses[this.moduleName]["rustls_client_config_builder_set_key_log"], "uint32", ["pointer", "pointer", "pointer"]);
    Interceptor.attach(this.addresses[this.moduleName]["rustls_client_config_builder_new"], {
      onLeave: function(retval) {
        if (retval.isNull()) {
          devlog("Error: retval is null");
          return;
        }
        RusTLS.rustls_client_config_set_key_log(retval, RusTLS.keyLogCB, ptr("0"));
        devlog("Attached keyLogCB to rustls_client_config_set_key_log");
      }
    });
    Interceptor.attach(this.addresses[this.moduleName]["rustls_client_config_builder_new_custom"], {
      onLeave: function(retval) {
        if (retval.isNull()) {
          devlog("Error: retval is null");
          return;
        }
        RusTLS.rustls_client_config_set_key_log(retval, RusTLS.keyLogCB, ptr("0"));
        devlog("Attached keyLogCB to rustls_client_config_set_key_log");
      }
    });
    Interceptor.attach(this.addresses[this.moduleName]["rustls_client_config_builder_set_key_log"], {
      onEnter: function(args) {
        var userCallbackAddress = args[1];
        devlog("User set CB to: " + userCallbackAddress);
        this.userCallbackAddress = userCallbackAddress;
      },
      onLeave: function(retval) {
        if (retval != 7e3) {
          return;
        } else {
          Interceptor.attach(this.userCallbackAddress, {
            onEnter(args) {
              devlog("Hooking user-defined callback for Rustls");
              var message = {};
              message["contentType"] = "keylog";
              var labelPtr = args[0];
              var label_len = args[1].toInt32();
              var client_random = args[2];
              var client_random_len = args[3].toInt32();
              var secret = args[4];
              var secret_len = args[5].toInt32();
              if (client_random.isNull() || client_random_len != 32) {
                devlog("Invalid client_random: " + client_random + " or client_random_lenght: " + client_random_len);
                return;
              }
              if (secret.isNull() || secret_len <= 0 || secret_len > 48) {
                devlog("Invalid secret or secret_length");
                return;
              }
              var clientRandomStr = client_random.readByteArray(client_random_len);
              var secretStr = secret.readByteArray(secret_len);
              var labelStr = labelPtr.readUtf8String(label_len);
              var clientRandomHex = Array.from(new Uint8Array(clientRandomStr)).map((b) => b.toString(16).padStart(2, "0")).join("");
              var secretHex = Array.from(new Uint8Array(secretStr)).map((b) => b.toString(16).padStart(2, "0")).join("");
              message["keylog"] = `${labelStr} ${clientRandomHex} ${secretHex}`;
              send(message);
              return 1;
            }
          });
        }
      }
    });
  }
};
function rustls_execute(moduleName, is_base_hook) {
  var rusTLS = new Rustls_Android(moduleName, socket_library, is_base_hook);
  if (hasMoreThanFiveExports(moduleName)) {
    devlog("Trying to hook RusTLS using symbols...");
    rusTLS.execute_hooks();
  } else {
    devlog("Trying to hook RusTLS using patterns...");
    rusTLS.execute_pattern_hooks();
  }
  if (is_base_hook) {
    const init_addresses = rusTLS.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/android/pattern_android.ts
var Pattern_Android = class extends Cronet {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  install_key_extraction_hook() {
    if (isPatternReplaced) {
      const patternModuleName = Process.findModuleByName(this.module_name);
      const hooker = new PatternBasedHooking(patternModuleName);
      hooker.hook_DumpKeys(this.module_name, this.module_name, patterns, (args) => {
        devlog(`Installed ssl_log_secret() hooks using byte patterns for module ${this.module_name}`);
        this.dumpKeys(args[1], args[0], args[2]);
      });
      return hooker;
    } else {
      return null;
    }
  }
  // instead of relying on pattern we check if the target module has a symbol of ssl_log_secret()
  execute_symbol_based_hooking(hooker) {
    let dumpKeysFunc = this.dumpKeys.bind(this);
    if (hooker.no_hooking_success) {
      let symbols = Process.getModuleByName(this.module_name).enumerateSymbols().filter((exports) => exports.name.toLowerCase().includes("ssl_log"));
      if (symbols.length > 0) {
        devlog("Installed ssl_log_secret() hooks using sybmols.");
        try {
          Interceptor.attach(symbols[0].address, {
            onEnter: function(args) {
              dumpKeysFunc(args[1], args[0], args[2]);
            }
          });
        } catch (e) {
        }
      }
    }
  }
  execute_boring_ssl_log_secret_hooks() {
    let hooker_instance = this.install_key_extraction_hook();
    return hooker_instance;
  }
};
function pattern_execute(moduleName, is_base_hook) {
  switch (true) {
    case moduleName.includes("boringssl"):
      let pattern_BoringSSL = new Pattern_Android(moduleName, socket_library, is_base_hook);
      try {
        let hooker = pattern_BoringSSL.execute_boring_ssl_log_secret_hooks();
        if (hooker != null) {
          setTimeout(function() {
            pattern_BoringSSL.execute_symbol_based_hooking(hooker);
          }, 1e3);
        }
      } catch (error_msg) {
        devlog(`pattern_execute error: ${error_msg}`);
      }
      if (is_base_hook) {
        try {
          const init_addresses = pattern_BoringSSL.addresses[moduleName];
          if (Object.keys(init_addresses).length > 0) {
            globalThis.init_addresses[moduleName] = init_addresses;
          }
        } catch (error_msg) {
          devlog(`pattern_execute base-hook error: ${error_msg}`);
        }
      }
      break;
    case moduleName.includes("rustls"):
      rustls_execute(moduleName, is_base_hook);
      break;
    default:
      devlog(`Unsupported Module: ${moduleName}! Trying to hook boringssl (default) with patterns!`);
      let pattern_Default = new Pattern_Android(moduleName, socket_library, is_base_hook);
      try {
        let hooker = pattern_Default.execute_boring_ssl_log_secret_hooks();
        if (hooker != null) {
          setTimeout(function() {
            pattern_Default.execute_symbol_based_hooking(hooker);
          }, 1e3);
        }
      } catch (error_msg) {
        devlog(`pattern_execute error: ${error_msg}`);
      }
      if (is_base_hook) {
        try {
          const init_addresses = pattern_Default.addresses[moduleName];
          if (Object.keys(init_addresses).length > 0) {
            globalThis.init_addresses[moduleName] = init_addresses;
          }
        } catch (error_msg) {
          devlog(`pattern_execute base-hook error: ${error_msg}`);
        }
      }
  }
}

// agent/ssl_lib/gotls.ts
var symbol_writeKeyLog = "crypto/tls.(*Config).writeKeyLog";
var symbol_tlsRead = "crypto/tls.(*Conn).Read";
var symbol_tlsWrite = "crypto/tls.(*Conn).Write";
var GoTlsLogger = class {
  found_writeKeyLog;
  module;
  no_hooking_success;
  constructor(module, found_writeKeyLog, no_hooking_success) {
    this.found_writeKeyLog = found_writeKeyLog;
    this.module = module;
    this.no_hooking_success = no_hooking_success;
  }
};
var GoTLS = class {
  moduleName;
  socket_library;
  passed_library_method_mapping;
  module_name;
  library_method_mapping = {};
  addresses = {};
  is_base_hook;
  go_version = null;
  hooked_functions = /* @__PURE__ */ new Set();
  runtime_parser;
  constructor(moduleName, socket_library6, is_base_hook, passed_library_method_mapping) {
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.passed_library_method_mapping = passed_library_method_mapping;
    this.module_name = moduleName;
    this.is_base_hook = is_base_hook;
    if (typeof passed_library_method_mapping !== "undefined") {
      this.library_method_mapping = passed_library_method_mapping;
    } else {
      this.library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    }
    let found_writeKeyLog = false;
    if (isSymbolAvailable(moduleName, symbol_writeKeyLog)) {
      this.library_method_mapping[`*${moduleName}*`].push(symbol_writeKeyLog);
      found_writeKeyLog = true;
    } else {
      devlog("[GoTLS] unable to find symbol: " + symbol_writeKeyLog + " in module: " + moduleName);
    }
    if (isSymbolAvailable(moduleName, symbol_tlsRead)) {
      this.library_method_mapping[`*${moduleName}*`].push(symbol_tlsRead);
    } else {
      devlog("[GoTLS] unable to find symbol: " + symbol_tlsRead + " in module: " + moduleName);
    }
    if (isSymbolAvailable(moduleName, symbol_tlsWrite)) {
      this.library_method_mapping[`*${moduleName}*`].push(symbol_tlsWrite);
    } else {
      devlog("[GoTLS] unable to find symbol: " + symbol_tlsWrite + " in module: " + moduleName);
    }
    this.addresses = readAddresses(moduleName, this.library_method_mapping);
    if (found_writeKeyLog === false) {
      let writeKeyLog_Address = this.resolve_symbol_with_fallback(symbol_writeKeyLog);
      if (writeKeyLog_Address !== null) {
        this.library_method_mapping[`*${moduleName}*`].push(symbol_writeKeyLog);
        this.addresses[moduleName][symbol_writeKeyLog] = writeKeyLog_Address;
        devlog("[GoTLS] found writeKeyLog symbol: " + symbol_writeKeyLog + " at address: " + writeKeyLog_Address);
      } else {
        devlog("[GoTLS] unable to find writeKeyLog symbol even with alternative symbol resolutions: " + symbol_writeKeyLog + " in module: " + moduleName);
      }
    }
  }
  detect_go_version() {
    try {
      const buildInfoSymbol = "runtime.buildVersion";
      const address = this.resolve_symbol_with_fallback(buildInfoSymbol);
      if (address) {
        const versionStr = address.readCString();
        if (versionStr) {
          const match = versionStr.match(/go(\d+)\.(\d+)(?:\.(\d+))?/);
          if (match) {
            return {
              major: parseInt(match[1]),
              minor: parseInt(match[2]),
              patch: parseInt(match[3] || "0")
            };
          }
        }
      }
    } catch (err) {
      devlog(`[GoTLS] Failed to detect Go version: ${err}`);
    }
    return null;
  }
  // Convert Go symbol name to possible mangled variants
  getGoSymbolVariants(symbol) {
    const variants = [symbol];
    const mangled1 = symbol.replace(/\//g, "_").replace(/\(\*([^)]+)\)/g, "_ptr_$1").replace(/\./g, ".");
    variants.push(mangled1);
    const mangled2 = symbol.replace(/\//g, "_").replace(/\(\*([^)]+)\)/g, "_ptr_$1").replace(/\./g, "_");
    variants.push(mangled2);
    const mangled3 = symbol.replace(/crypto\_tls/g, "crypto_tls").replace(/\(\*Conn\)/g, "_ptr_Conn").replace(/\(\*Config\)/g, "_ptr_Config").replace(/\./g, "_");
    variants.push(mangled3);
    return [...new Set(variants)];
  }
  resolve_symbol_with_fallback(symbol) {
    try {
      let address = Module.getGlobalExportByName(symbol);
      if (address)
        return address;
      try {
        address = Process.getModuleByName(this.module_name).getExportByName(symbol);
        if (address)
          return address;
      } catch (e) {
      }
      const symbolVariants = this.getGoSymbolVariants(symbol);
      for (const variant of symbolVariants) {
        try {
          address = Process.getModuleByName(this.module_name).getExportByName(variant);
          if (address) {
            devlog(`[GoTLS] Found symbol ${symbol} as ${variant}`);
            return address;
          }
        } catch (e) {
        }
      }
      if (address === null) {
        return DebugSymbol.fromName(symbol).address;
      }
      const exports = Process.getModuleByName(this.module_name).enumerateExports();
      for (const variant of symbolVariants) {
        for (const exp of exports) {
          if (exp.name === variant || exp.name.includes(variant)) {
            devlog(`[GoTLS] Found symbol ${symbol} via pattern match: ${exp.name}`);
            return exp.address;
          }
        }
      }
      const symbolBase = symbol.split(".").pop() || symbol;
      for (const exp of exports) {
        if (exp.name.toLowerCase().includes(symbolBase.toLowerCase())) {
          devlog(`[GoTLS] Found symbol ${symbol} via fuzzy match: ${exp.name}`);
          return exp.address;
        }
      }
    } catch (err) {
      devlog(`[GoTLS] Symbol resolution failed for ${symbol}: ${err}`);
    }
    devlog(`[GoTLS] Could not resolve symbol: ${symbol}`);
    return null;
  }
  /**
   *
   * Hooking writeKeyLog function to extract TLS keys.
   * Details at source code from https://github.com/golang/go/blob/54c9d776302d53ab1907645cb67fa4a948e1500c/src/crypto/tls/common.go#L1540C10-L1540C16
   *
   * @param labelPtr
   * @param sslStructPtr
   * @param keyPtr
   */
  dumpKeys(labelPtr, labelLen, clientRandomPtr, clientRandomLength, keyPtr, keyLength) {
    const MAX_KEY_LENGTH = 64;
    let labelStr = "";
    let client_random = "";
    let secret_key = "";
    if (!labelPtr.isNull()) {
      labelStr = labelPtr.readCString() ?? "";
    } else {
      devlog_error("[GoTLS Error] Argument 'labelPtr' is NULL");
    }
    if (!clientRandomPtr.isNull()) {
      if (clientRandomLength === 0) {
        clientRandomLength = 32;
      }
      const client_random_buffer = clientRandomPtr.readByteArray(clientRandomLength);
      client_random = get_hex_string_from_byte_array(new Uint8Array(client_random_buffer));
    } else {
      devlog_error("[GoTLS Error] Argument 'sslStructPtr' is NULL");
    }
    if (!keyPtr.isNull()) {
      let KEY_LENGTH = keyLength;
      if (KEY_LENGTH <= 0) {
        let calculatedKeyLength = 0;
        while (calculatedKeyLength < MAX_KEY_LENGTH) {
          const byte = keyPtr.add(calculatedKeyLength).readU8();
          if (byte === 0) {
            if (calculatedKeyLength < 20) {
              calculatedKeyLength++;
              continue;
            }
            break;
          }
          calculatedKeyLength++;
        }
        if (calculatedKeyLength > 24 && calculatedKeyLength <= 40) {
          KEY_LENGTH = 32;
        } else if (calculatedKeyLength >= 46 && calculatedKeyLength <= 49) {
          KEY_LENGTH = 48;
        } else {
          KEY_LENGTH = 32;
        }
      }
      const keyData = keyPtr.readByteArray(KEY_LENGTH);
      const hexKey = get_hex_string_from_byte_array(keyData);
      secret_key = hexKey;
    } else {
      devlog_error("[GoTLS Error] Argument 'key' is NULL");
    }
    var message = {};
    message["contentType"] = "keylog";
    message["keylog"] = labelStr + " " + client_random + " " + secret_key;
    send(message);
  }
  install_key_extraction_hook() {
  }
  // Enhanced debug function to list all exports and runtime functions for troubleshooting
  debug_list_exports() {
    try {
      const exports = Process.getModuleByName(this.module_name).enumerateExports();
      const goExports = exports.filter((exp) => exp.name.includes("crypto") || exp.name.includes("tls") || exp.name.includes("Config") || exp.name.includes("Conn") || exp.name.includes("writeKeyLog") || exp.name.includes("Read") || exp.name.includes("Write"));
      devlog(`[GoTLS] Found ${goExports.length} potential Go TLS exports in ${this.module_name}:`);
      for (const exp of goExports.slice(0, 20)) {
        devlog(`[GoTLS]   ${exp.name} @ ${exp.address}`);
      }
      if (goExports.length > 20) {
        devlog(`[GoTLS]   ... and ${goExports.length - 20} more`);
      }
    } catch (err) {
      devlog(`[GoTLS] Failed to list exports: ${err}`);
    }
  }
  install_tls_keys_callback_hook() {
    Interceptor.attach(this.addresses[this.module_name][symbol_writeKeyLog], {
      onEnter: function(args) {
        try {
          let labelStr, client_random, secret_key;
          if (Process.arch === "x64") {
            const ctx = this.context;
            const labelLen = ctx.rcx.toInt32();
            const randomLen = ctx.rsi.toInt32();
            const secretLen = ctx.r10.toInt32();
            if (labelLen > 0 && labelLen < 1024 && !ctx.rbx.isNull()) {
              labelStr = ctx.rbx.readUtf8String(labelLen);
            } else {
              throw new Error(`Invalid label parameters: ptr=${ctx.rbx}, len=${labelLen}`);
            }
            if (randomLen > 0 && randomLen < 1024 && !ctx.rdi.isNull()) {
              client_random = get_hex_string_from_byte_array(ctx.rdi.readByteArray(randomLen));
            } else {
              throw new Error(`Invalid client_random parameters: ptr=${ctx.rdi}, len=${randomLen}`);
            }
            if (secretLen > 0 && secretLen < 1024 && !ctx.r9.isNull()) {
              secret_key = get_hex_string_from_byte_array(ctx.r9.readByteArray(secretLen));
            } else {
              throw new Error(`Invalid secret parameters: ptr=${ctx.r9}, len=${secretLen}`);
            }
          } else if (Process.arch === "arm64") {
            const ctx = this.context;
            const labelLen = ctx.x2.toInt32();
            const randomLen = ctx.x4.toInt32();
            const secretLen = ctx.x6.toInt32();
            if (labelLen > 0 && labelLen < 1024 && !ctx.x1.isNull()) {
              labelStr = ctx.x1.readUtf8String(labelLen);
            } else {
              throw new Error(`Invalid label parameters: ptr=${ctx.x1}, len=${labelLen}`);
            }
            if (randomLen > 0 && randomLen < 1024 && !ctx.x3.isNull()) {
              client_random = get_hex_string_from_byte_array(ctx.x3.readByteArray(randomLen));
            } else {
              throw new Error(`Invalid client_random parameters: ptr=${ctx.x3}, len=${randomLen}`);
            }
            if (secretLen > 0 && secretLen < 1024 && !ctx.x5.isNull()) {
              secret_key = get_hex_string_from_byte_array(ctx.x5.readByteArray(secretLen));
            } else {
              throw new Error(`Invalid secret parameters: ptr=${ctx.x5}, len=${secretLen}`);
            }
          } else {
            devlog_error(`[GoTLS] Architecture ${Process.arch} not supported for register-based key extraction`);
            devlog_error(`[GoTLS] Supported architectures: x64, arm64`);
            devlog_error(`[GoTLS] Consider using function argument-based hooking for this platform`);
            return false;
          }
          const message = {
            "contentType": "keylog",
            "keylog": `${labelStr} ${client_random} ${secret_key}`
          };
          send(message);
          devlog(`[GoTLS] Key extracted on ${Process.arch}: ${labelStr} ${client_random.substring(0, 16)}...`);
          return true;
        } catch (e) {
          devlog_error(`Error in writeKeyLog hook: ${e}`);
          return false;
        }
      }
    });
    return false;
  }
  install_plaintext_write_hook() {
    const symbol = "crypto_tls.(*Conn).writeRecordLocked";
    try {
      const address = this.resolve_symbol_with_fallback(symbol);
      if (!address) {
        devlog(`[GoTLS] ${symbol} not found, skipping write hook`);
        return;
      }
      Interceptor.attach(address, {
        onEnter(args) {
          const recordType = args[2].toInt32();
          if (recordType !== 23)
            return;
          const dataPtr = args[3];
          const len = args[4].toInt32();
          if (len > 0) {
            const buf = dataPtr.readByteArray(len);
            devlog(`[GoTLS] write plaintext (${len} bytes): ${buf ? buf.toString() : "[unreadable]"}`);
            send({
              contentType: "datalog",
              function: "SSL_write",
              data: buf
            });
          }
        }
      });
      this.hooked_functions.add(symbol);
      log(`[GoTLS] Successfully hooked ${symbol}`);
    } catch (err) {
      devlog(`[GoTLS] Failed to hook writeRecordLocked: ${err}`);
    }
  }
  install_plaintext_read_hook() {
    const symbol = "crypto_tls.(*Conn).Read";
    try {
      const address = this.resolve_symbol_with_fallback(symbol);
      if (!address) {
        devlog(`[GoTLS] ${symbol} not found, skipping read hook`);
        return;
      }
      Interceptor.attach(address, {
        onEnter(args) {
          this.x0 = args[0];
        },
        onLeave(retval) {
          const len = retval.toInt32();
          if (len <= 0)
            return;
          const buf = this.x0.readByteArray(len);
          devlog(`[GoTLS] read plaintext (${len} bytes): ${buf ? buf.toString() : "[unreadable]"}`);
          send({
            contentType: "datalog",
            function: "SSL_read",
            data: buf
          });
        }
      });
      this.hooked_functions.add(symbol);
      log(`[GoTLS] Successfully hooked ${symbol}`);
    } catch (err) {
      devlog(`[GoTLS] Failed to hook Read: ${err}`);
    }
  }
  // Enhanced runtime parser hook installation currently not used - needs further testing
  install_runtime_parser_hooks() {
    try {
      const tlsFunctions = this.runtime_parser.getTLSFunctions();
      devlog(`[GoTLS] Runtime parser found ${tlsFunctions.length} TLS functions to attempt hooking`);
      if (tlsFunctions.length === 0) {
        devlog(`[GoTLS] No TLS functions found by runtime parser, trying broader search...`);
        const targetFunctions = [
          "crypto_tls.(*Config).writeKeyLog",
          "crypto_tls.(*Conn).Read",
          "crypto_tls.(*Conn).Write",
          "crypto_tls.(*Conn).writeRecordLocked",
          "writeKeyLog",
          "Read",
          "Write",
          "writeRecordLocked"
        ];
        for (const target of targetFunctions) {
          const found = this.runtime_parser.findFunction(target);
          if (found) {
            devlog(`[GoTLS] Found specific target function: ${found.name}`);
            tlsFunctions.push(found);
          }
        }
      }
    } catch (err) {
      devlog_error(`[GoTLS] Failed to install runtime parser hooks: ${err}`);
    }
  }
};

// agent/android/gotls_android.ts
var GoTLS_Android = class extends GoTLS {
  moduleName;
  socket_library;
  default_pattern;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.default_pattern = {
      "x64": {
        primary: "90 0B 40 F9 F1 43 00 D1 3F 02 10 EB E9 10 00 54 FE 0F 17 F8 FD 83 1F F8 FD 23 00 D1 E1 53 00 F9 E3 5B 00 F9 E6 67 00 F9 09 94 40 F9 49 0F 00 B4",
        // Primary pattern
        fallback: "55 41 57 41 56 41 54 53 48 83 EC 30 48 8B 47 68 48 83 B8 20 02 00 00 00 0F 84"
        // Fallback pattern
      },
      "x86": {
        primary: "90 0B 40 F9 F1 43 00 D1 3F 02 10 EB E9 10 00 54 FE 0F 17 F8 FD 83 1F F8 FD 23 00 D1 E1 53 00 F9 E3 5B 00 F9 E6 67 00 F9 09 94 40 F9 49 0F 00 B4",
        // Primary pattern
        fallback: "55 53 57 56 83 EC 4C E8 00 00 00 00 5B 81 C3 A9 CB 13 00 8B 44 24 60"
        // Fallback pattern
      },
      "arm64": {
        primary: "90 0B 40 F9 F1 43 00 D1 3F 02 10 EB E9 10 00 54 FE 0F 17 F8 FD 83 1F F8 FD 23 00 D1 E1 53 00 F9 E3 5B 00 F9 E6 67 00 F9 09 94 40 F9 49 0F 00 B4",
        // Primary pattern
        fallback: "3F 23 03 D5 FF ?3 02 D1 FD 7B 0? A9 F? ?? 0? ?9 F6 57 0? A9 F4 4F 0? A9 FD ?3 01 91 08 34 40 F9 08 ?? 41 F9 ?8 ?? 00 B4"
        // Fallback pattern
      },
      "arm": {
        primary: "90 0B 40 F9 F1 43 00 D1 3F 02 10 EB E9 10 00 54 FE 0F 17 F8 FD 83 1F F8 FD 23 00 D1 E1 53 00 F9 E3 5B 00 F9 E6 67 00 F9 09 94 40 F9 49 0F 00 B4",
        // Primary pattern
        fallback: "2D E9 F0 41 86 B0 04 46 40 6B D0 F8 30 01 00 28 53 D0"
        // Fallback pattern
      }
    };
  }
  getSoName(modulePath) {
    const m2 = modulePath.match(/([^\/\\]+\.so)$/);
    return m2 ? m2[1] : modulePath;
  }
  install_key_extraction_hook() {
    var instance = this;
    let goTLSModule = Process.findModuleByName(this.module_name);
    let soName = this.module_name;
    if (goTLSModule === null) {
      soName = this.getSoName(this.module_name);
      goTLSModule = Process.findModuleByName(soName);
      if (goTLSModule === null) {
        devlog("[-] GoTLS Error: Unable to find module: " + this.module_name);
        return;
      }
    }
    if (this.addresses[this.module_name][symbol_writeKeyLog] === void 0 || this.addresses[this.module_name][symbol_writeKeyLog] === null) {
      if (experimental === false) {
        devlog("[!] Pattern-based hooking for GoTLS may cause instability or crashes. To proceed anyway, rerun friTap with the --experimental flag.");
        return;
      }
      const hooker = new PatternBasedHooking(goTLSModule);
      if (isPatternReplaced()) {
        devlog("Hooking GoTLS functions by patterns from JSON file");
        hooker.hook_DumpKeys(this.module_name, soName, patterns, (args) => {
          devlog("Installed writeKeyLog() hooks using byte patterns.");
          const labelPtr = args[2];
          const labelLen = args[3].toInt32();
          const crPtr = args[4];
          const crLen = args[5].toInt32();
          const secretPtr = args[7];
          const secretLen = args[8].toInt32();
          this.dumpKeys(labelPtr, labelLen, crPtr, crLen, secretPtr, secretLen);
        });
      } else {
        hooker.hookModuleByPattern(get_CPU_specific_pattern(this.default_pattern), (args) => {
          devlog("Installed writeKeyLog() hooks using byte patterns.");
          const labelPtr = args[2];
          const labelLen = args[3].toInt32();
          const crPtr = args[4];
          const crLen = args[5].toInt32();
          const secretPtr = args[7];
          const secretLen = args[8].toInt32();
          this.dumpKeys(labelPtr, labelLen, crPtr, crLen, secretPtr, secretLen);
        });
      }
      return hooker;
    } else {
      devlog("[GoTLS] writeKeyLog symbol available");
      var result = instance.install_tls_keys_callback_hook();
      let hooker = new GoTlsLogger(goTLSModule, true, result);
      return hooker;
    }
  }
  // instead of relying on pattern we check if the target module has a symbol of writeKeyLog()
  execute_symbol_based_hooking(hooker) {
    if (hooker === void 0 || hooker === null) {
      devlog("[-] Error: Hooker is undefined.");
      return;
    }
    let dumpKeysFunc = this.dumpKeys.bind(this);
    if (hooker.no_hooking_success) {
      let symbols = Process.getModuleByName(this.module_name).enumerateSymbols().filter((exports) => exports.name.toLowerCase().includes("ssl_log"));
      if (symbols.length > 0) {
        devlog("Installed writeKeyLog() hooks using sybmols.");
        try {
          Interceptor.attach(symbols[0].address, {
            onEnter: function(args) {
              const labelPtr = args[2];
              const labelLen = args[3].toInt32();
              const crPtr = args[4];
              const crLen = args[5].toInt32();
              const secretPtr = args[7];
              const secretLen = args[8].toInt32();
              this.dumpKeys(labelPtr, labelLen, crPtr, crLen, secretPtr, secretLen);
            }
          });
        } catch (e) {
        }
      }
    }
  }
  execute_hooks() {
    let hooker_instance = this.install_key_extraction_hook();
    return hooker_instance;
  }
};
function gotls_execute(moduleName, is_base_hook) {
  let gotls = new GoTLS_Android(moduleName, socket_library, is_base_hook);
  try {
    let hooker = gotls.execute_hooks();
    setTimeout(function() {
      try {
        gotls.execute_symbol_based_hooking(hooker);
      } catch (e) {
        devlog("[-] Error in gotls.execute_symbol_based_hooking: " + e);
      }
    }, 1500);
  } catch (error_msg) {
    devlog(`gotls_execute error: ${error_msg}`);
  }
  if (is_base_hook) {
    try {
      const init_addresses = gotls.addresses[moduleName];
      if (Object.keys(init_addresses).length > 0) {
        globalThis.init_addresses[moduleName] = init_addresses;
      }
    } catch (error_msg) {
      devlog(`gotls_execute base-hook error: ${error_msg}`);
    }
  }
}

// agent/android/metartc.ts
var MetaRTC_Android = class extends Flutter {
  moduleName;
  socket_library;
  default_pattern;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.default_pattern = {
      "x64": {
        primary: "55 41 57 41 56 41 55 41 54 53 48 83 EC 48 48 8B 47 68 48 83 B8 20 02 00 00 00 0F 84 FE 00 00 00",
        // Primary pattern
        fallback: "55 41 57 41 56 41 55 41 54 53 48 83 EC 38 48 8B 47 68 48 83 B8 10 02 00 00 00 0F 84 19 01 00 00"
        // Fallback pattern
      },
      "x86": {
        primary: "55 53 57 56 83 EC 4C E8 00 00 00 00 5B 81 C3 A9 CB 13 00 8B 44 24 60 8B 40 34",
        // Primary pattern
        fallback: "55 89 E5 53 57 56 83 E4 F0 83 EC 50 E8 00 00 00 00"
        // Fallback pattern
      },
      "arm64": {
        primary: "09 54 40 F9 E8 03 00 AA E5 03 03 AA E4 03 02 AA E2 03 1E AA 35 24 F8 97 FE 03 02 AA 22 E1 02 91 03 04 80 52 6F F3 FF 17",
        // Primary pattern
        fallback: "FF 43 04 D1 FD 5B 00 F9 FE 6F 0C A9 FA 67 0D A9 F8 5F 0E A9 F6 57 0F A9 F4 4F 10 A9 FA 03 07 2A F6 03 06 AA F8 03 05 AA F5 03 04 AA F7 03 03 AA F3 03 02 AA F4 03 01 AA F9 03 00 2A B7 EB 01 94"
        // Fallback pattern
      },
      "arm": {
        primary: "2D E9 F0 43 89 B0 04 46 40 6B D0 F8 2C 01 00 28 49 D0",
        // Primary pattern
        fallback: "2D E9 F0 41 86 B0 04 46 40 6B D0 F8 30 01 00 28 53 D0"
        // Fallback pattern
      }
    };
  }
  install_key_extraction_hook() {
    const metartcModule = Process.findModuleByName(this.module_name);
    const hooker = new PatternBasedHooking(metartcModule);
    if (isPatternReplaced()) {
      devlog("Hooking libstartup (metartc) functions by patterns from JSON file");
      hooker.hook_DumpKeys(this.module_name, "libstartup.so", patterns, (args) => {
        this.dumpKeys(args[1], args[0], args[2]);
      });
    } else {
      hooker.hookModuleByPattern(get_CPU_specific_pattern(this.default_pattern), (args) => {
        this.dumpKeys(args[1], args[0], args[2]);
      });
    }
  }
  execute_hooks() {
    this.install_key_extraction_hook();
  }
};
function metartc_execute(moduleName, is_base_hook) {
  var metartc = new MetaRTC_Android(moduleName, socket_library, is_base_hook);
  try {
    metartc.execute_hooks();
  } catch (error_msg) {
    devlog_error(`metartc_execute error: ${error_msg}`);
  }
  if (is_base_hook) {
    try {
      const init_addresses = metartc.addresses[moduleName];
      if (Object.keys(init_addresses).length > 0) {
        globalThis.init_addresses[moduleName] = init_addresses;
      }
    } catch (error_msg) {
      devlog_error(`flutter_execute base-hook error: ${error_msg}`);
    }
  }
}

// agent/android/android_agent.ts
var plattform_name = "linux";
var moduleNames = getModuleNames();
globalThis.addresses = {};
var socket_library = "libc";
function install_java_hooks() {
  java_execute();
}
function hook_Android_Dynamic_Loader(module_library_mapping2, is_base_hook) {
  try {
    const regex_libdl = /.*libdl.*\.so/;
    const libdl = moduleNames.find((element) => element.match(regex_libdl));
    if (libdl === void 0) {
      throw "Android Dynamic loader not found!";
    }
    let dl_exports = Process.getModuleByName(libdl).enumerateExports();
    var dlopen = "dlopen";
    for (var ex of dl_exports) {
      if (ex.name === "android_dlopen_ext") {
        dlopen = "android_dlopen_ext";
        break;
      }
    }
    Interceptor.attach(Process.getModuleByName(libdl).getExportByName(dlopen), {
      onEnter: function(args) {
        this.moduleName = args[0].readCString();
      },
      onLeave: function(retval) {
        if (this.moduleName != void 0) {
          for (let map of module_library_mapping2[plattform_name]) {
            let regex = map[0];
            let func = map[1];
            if (regex.test(this.moduleName)) {
              log(`${this.moduleName} was loaded & will be hooked on Android!`);
              try {
                func(this.moduleName, is_base_hook);
              } catch (error_msg) {
                devlog(`[-] Error in hooking ${this.moduleName}: ${error_msg}`);
              }
            }
          }
        }
      }
    });
    log(`[*] Android dynamic loader hooked.`);
  } catch (error) {
    devlog("Dynamic loader error: " + error);
    log("No dynamic loader present for hooking on Android.");
  }
}
function hook_native_Android_SSL_Libs(module_library_mapping2, is_base_hook) {
  ssl_library_loader(plattform_name, module_library_mapping2, moduleNames, "Android", is_base_hook);
}
function loadPatternsFromJSON(jsonContent) {
  try {
    let data = JSON.parse(jsonContent);
    return data;
  } catch (error) {
    devlog("[-] Error loading or parsing JSON pattern:  " + error);
    return null;
  }
}
function install_pattern_based_hooks() {
  try {
    let data = loadPatternsFromJSON(patterns);
    if (data !== null && data.modules) {
      for (const moduleName in data.modules) {
        if (Object.prototype.hasOwnProperty.call(data.modules, moduleName)) {
          log("[*] Module name:" + moduleName);
          module_library_mapping[plattform_name] = [
            [moduleName, invokeHookingFunction(pattern_execute)]
          ];
          hook_native_Android_SSL_Libs(module_library_mapping, true);
        }
      }
    }
  } catch (e) {
  }
}
function load_android_hooking_agent() {
  module_library_mapping[plattform_name] = [
    [/.*libssl_sb.so/, invokeHookingFunction(boring_execute)],
    [/.*libssl\.so/, invokeHookingFunction(boring_execute)],
    [/libconscrypt_gmscore_jni.so/, invokeHookingFunction(conscrypt_native_execute)],
    // inspired from https://github.com/PiRogueToolSuite/pirogue-cli/blob/debian-12/pirogue_cli/frida-scripts/log_ssl_keys.js#L55
    [/ibconscrypt_jni.so/, invokeHookingFunction(conscrypt_native_execute)],
    [/.*flutter.*\.so/, invokeHookingFunction(flutter_execute)],
    [/.*libgnutls\.so/, invokeHookingFunction(gnutls_execute)],
    [/.*libwolfssl\.so/, invokeHookingFunction(wolfssl_execute)],
    [/.*libnss[3-4]\.so/, invokeHookingFunction(nss_execute)],
    [/libmbedtls\.so.*/, invokeHookingFunction(mbedTLS_execute)],
    [/.*libs2n.so/, invokeHookingFunction(s2ntls_execute)],
    [/.*mono-btls.*\.so/, invokeHookingFunction(mono_btls_execute)],
    [/.*cronet.*\.so/, invokeHookingFunction(cronet_execute)],
    [/.*monochrome.*\.so/, invokeHookingFunction(cronet_execute)],
    [/.*libwarp_mobile.*\.so/, invokeHookingFunction(cronet_execute)],
    // here the client_random is not working
    [/.*lib*quiche*.*\.so/, invokeHookingFunction(cronet_execute)],
    [/.*librustls.*\.so/, invokeHookingFunction(rustls_execute)],
    [/.*libstartup.*\.so/, invokeHookingFunction(metartc_execute)],
    [/libgojni.*\.so/, invokeHookingFunction(gotls_execute)]
    // Go library in some Unity based applications
  ];
  install_java_hooks();
  hook_native_Android_SSL_Libs(module_library_mapping, true);
  hook_Android_Dynamic_Loader(module_library_mapping, false);
  if (isPatternReplaced()) {
    install_pattern_based_hooks();
  }
  try {
    let matchedModules = findModulesWithSSLKeyLogCallback();
    if (matchedModules.length > 0) {
      const moduleLibraryMappingExtend = {};
      moduleLibraryMappingExtend[plattform_name] = createModuleLibraryMappingExtend(matchedModules, boring_execute);
      hook_native_Android_SSL_Libs(moduleLibraryMappingExtend, false);
      hook_Android_Dynamic_Loader(moduleLibraryMappingExtend, false);
      log("[*] Hooked additional modules with SSL_CTX_set_keylog_callback.");
    }
  } catch (error_msg) {
    devlog("[-] Error in hooking additional modules: " + error_msg);
  }
}

// agent/ios/openssl_boringssl_ios.ts
var OpenSSL_BoringSSL_iOS = class extends OpenSSL_BoringSSL {
  moduleName;
  socket_library;
  install_tls_keys_callback_hook() {
    if (ObjC.available) {
      var CALLBACK_OFFSET = 680;
      var foundationNumber = Process.getModuleByName("CoreFoundation").getExportByName("kCFCoreFoundationVersionNumber")?.readDouble();
      devlog("[*] Calculating offset to keylog callback based on the FoundationVersionNumber on iOS: " + foundationNumber);
      if (foundationNumber == void 0) {
        devlog("Installing callback for iOS < 14");
        CALLBACK_OFFSET = 680;
      } else if (foundationNumber >= 1751.108 && foundationNumber < 1854) {
        devlog("Installing callback for iOS >= 14");
        CALLBACK_OFFSET = 696;
      } else if (foundationNumber >= 1854 && foundationNumber < 1946.102) {
        devlog("Installing callback for iOS >= 15");
        CALLBACK_OFFSET = 760;
      } else if (foundationNumber >= 1946.102 && foundationNumber <= 1979.1) {
        devlog("Installing callback for iOS >= 16");
        CALLBACK_OFFSET = 768;
      } else if (foundationNumber > 1979.1) {
        devlog("Installing callback for iOS >= 17");
        CALLBACK_OFFSET = 776;
      }
      Interceptor.attach(this.addresses[this.module_name]["SSL_CTX_set_info_callback"], {
        onEnter: function(args) {
          ptr(args[0]).add(CALLBACK_OFFSET).writePointer(OpenSSL_BoringSSL.keylog_callback);
        }
      });
    }
  }
  constructor(moduleName, socket_library6, is_base_hook) {
    var library_method_mapping = {};
    library_method_mapping[`*${moduleName}*`] = ["SSL_CTX_set_info_callback"];
    super(moduleName, socket_library6, is_base_hook, library_method_mapping);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  execute_hooks() {
    this.install_tls_keys_callback_hook();
  }
};
function boring_execute2(moduleName, is_base_hook) {
  var boring_ssl = new OpenSSL_BoringSSL_iOS(moduleName, socket_library2, is_base_hook);
  boring_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = boring_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/ios/cronet_ios.ts
var Cronet_iOS = class extends Cronet {
  moduleName;
  socket_library;
  default_pattern;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.default_pattern = {
      "arm64": {
        primary: "FF 83 01 D1 F6 57 03 A9 F4 4F 04 A9 FD 7B 05 A9 FD 43 01 91 08 34 40 F9 08 51 41 F9 48 08 00 B4",
        // Primary pattern
        fallback: "3F 23 03 D5 FF 03 02 D1 FD 7B 04 A9 F7 2B 00 F9 F6 57 06 A9 F4 4F 07 A9 FD 03 01 91 08 34 40 F9 08 11 41 F9 E8 0F 00 B4"
        // Fallback pattern
      }
    };
  }
  install_key_extraction_hook() {
    const cronetModule = Process.findModuleByName(this.module_name);
    const hooker = new PatternBasedHooking(cronetModule);
    if (isPatternReplaced()) {
      devlog("Hooking Cronet functions by pattern\nThis is still untested and might fail");
      hooker.hook_DumpKeys(this.module_name, "Cronet", patterns, (args) => {
        this.dumpKeys(args[1], args[0], args[2]);
      });
    } else {
      hooker.hookModuleByPattern(get_CPU_specific_pattern(this.default_pattern), (args) => {
        this.dumpKeys(args[1], args[0], args[2]);
      });
    }
  }
  execute_hooks() {
    this.install_key_extraction_hook();
  }
};
function cronet_execute2(moduleName, is_base_hook) {
  var cronet = new Cronet_iOS(moduleName, socket_library2, is_base_hook);
  cronet.execute_hooks();
  if (is_base_hook) {
    const init_addresses = cronet.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/ios/flutter_ios.ts
var Flutter_iOS = class extends Flutter {
  moduleName;
  socket_library;
  default_pattern;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.default_pattern = {
      "arm64": {
        primary: "FF 83 01 D1 F6 57 03 A9 F4 4F 04 A9 FD 7B 05 A9 FD 43 01 91 08 34 40 F9 08 51 41 F9 48 08 00 B4",
        // Primary pattern
        fallback: "3F 23 03 D5 FF 03 02 D1 FD 7B 04 A9 F7 2B 00 F9 F6 57 06 A9 F4 4F 07 A9 FD 03 01 91 08 34 40 F9 08 11 41 F9 E8 0F 00 B4"
        // Fallback pattern
      }
    };
  }
  install_key_extraction_hook() {
    const flutterModule = Process.findModuleByName(this.module_name);
    const hooker = new PatternBasedHooking(flutterModule);
    if (isPatternReplaced()) {
      devlog("Hooking Flutter functions by patterns from JSON file");
      hooker.hook_DumpKeys(this.module_name, "Flutter", patterns, (args) => {
        this.dumpKeys(args[1], args[0], args[2]);
      });
    } else {
      hooker.hookModuleByPattern(get_CPU_specific_pattern(this.default_pattern), (args) => {
        this.dumpKeys(args[1], args[0], args[2]);
      });
    }
  }
  execute_hooks() {
    this.install_key_extraction_hook();
  }
};
function flutter_execute2(moduleName, is_base_hook) {
  var flutter = new Flutter_iOS(moduleName, socket_library2, is_base_hook);
  try {
    flutter.execute_hooks();
  } catch (error_msg) {
    devlog_error(`flutter_execute error: ${error_msg}`);
  }
  if (is_base_hook) {
    try {
      const init_addresses = flutter.addresses[moduleName];
      if (Object.keys(init_addresses).length > 0) {
        globalThis.init_addresses[moduleName] = init_addresses;
      }
    } catch (error_msg) {
      devlog_error(`flutter_execute base-hook error: ${error_msg}`);
    }
  }
}

// agent/ios/ios_agent.ts
var plattform_name2 = "darwin";
var moduleNames2 = getModuleNames();
var socket_library2 = "libSystem.B.dylib";
function hook_iOS_Dynamic_Loader(module_library_mapping2, is_base_hook) {
  try {
    const regex_libdl = /libSystem.B.dylib/;
    const libdl = moduleNames2.find((element) => element.match(regex_libdl));
    if (libdl === void 0) {
      throw "Darwin Dynamic loader not found!";
    }
    var dlopen = "dlopen";
    Interceptor.attach(Process.getModuleByName(libdl).getExportByName(dlopen), {
      onEnter: function(args) {
        this.moduleName = args[0].readCString();
      },
      onLeave: function(retval) {
        if (this.moduleName != void 0) {
          for (let map of module_library_mapping2[plattform_name2]) {
            let regex = map[0];
            let func = map[1];
            if (regex.test(this.moduleName)) {
              log(`${this.moduleName} was loaded & will be hooked on iOS!`);
              try {
                func(this.moduleName, is_base_hook);
              } catch (error_msg) {
                devlog(`iOS dynamic loader error: ${error_msg}`);
              }
            }
          }
        }
      }
    });
    log(`[*] iOS dynamic loader hooked.`);
  } catch (error) {
    devlog("Loader error: " + error);
    log("No dynamic loader present for hooking on iOS.");
  }
}
function hook_iOS_SSL_Libs(module_library_mapping2, is_base_hook) {
  ssl_library_loader(plattform_name2, module_library_mapping2, moduleNames2, "iOS", is_base_hook);
}
function load_ios_hooking_agent() {
  module_library_mapping[plattform_name2] = [
    [/.*libboringssl\.dylib/, invokeHookingFunction(boring_execute2)],
    [/.*cronet.*\.dylib/, invokeHookingFunction(cronet_execute2)],
    [/.*flutter.*\.dylib/, invokeHookingFunction(flutter_execute2)]
  ];
  hook_iOS_SSL_Libs(module_library_mapping, true);
  hook_iOS_Dynamic_Loader(module_library_mapping, false);
}

// agent/macos/openssl_boringssl_macos.ts
var OpenSSL_BoringSSL_MacOS = class extends OpenSSL_BoringSSL {
  moduleName;
  socket_library;
  install_tls_keys_callback_hook() {
    if (ObjC.available) {
      var CALLBACK_OFFSET = 680;
      var foundationNumber = Process.getModuleByName("CoreFoundation").getExportByName("kCFCoreFoundationVersionNumber")?.readDouble();
      devlog("Calculating offset to keylog callback based on the FoundationVersionNumber on MacOS: " + foundationNumber);
      if (foundationNumber == void 0) {
        CALLBACK_OFFSET = 680;
        devlog("Installing callback for MacOS < 14 using callback offset: " + CALLBACK_OFFSET);
      } else if (foundationNumber >= 1751.108 && foundationNumber < 1854) {
        CALLBACK_OFFSET = 696;
        devlog("Installing callback for MacOS >= 14 using callback offset: " + CALLBACK_OFFSET);
      } else if (foundationNumber >= 1854 && foundationNumber < 1946.102) {
        CALLBACK_OFFSET = 760;
        devlog("Installing callback for MacOS >= 15 using callback offset: " + CALLBACK_OFFSET);
      } else if (foundationNumber >= 1946.102 && foundationNumber <= 1979.1) {
        CALLBACK_OFFSET = 768;
        devlog("Installing callback for MacOS >= 16 using callback offset: " + CALLBACK_OFFSET);
      } else if (foundationNumber > 1979.1) {
        CALLBACK_OFFSET = 760;
        devlog("Installing callback for MacOS >= 17 using callback offset: " + CALLBACK_OFFSET);
      }
      Interceptor.attach(this.addresses[this.module_name]["SSL_CTX_set_info_callback"], {
        onEnter: function(args) {
          ptr(args[0]).add(CALLBACK_OFFSET).writePointer(OpenSSL_BoringSSL.keylog_callback);
        }
      });
    }
  }
  constructor(moduleName, socket_library6, is_base_hook) {
    var library_method_mapping = {};
    library_method_mapping[`*${moduleName}*`] = ["SSL_CTX_set_info_callback"];
    super(moduleName, socket_library6, is_base_hook, library_method_mapping);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  execute_hooks() {
    this.install_tls_keys_callback_hook();
  }
};
var OpenSSL_From_Python_MacOS = class extends OpenSSL_BoringSSL {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    var library_method_mapping = {};
    library_method_mapping[`*${moduleName}*`] = ["SSL_CTX_set_keylog_callback", "SSL_CTX_new", "SSL_new", "SSL_get_SSL_CTX"];
    super(moduleName, socket_library6, is_base_hook, library_method_mapping);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  install_openssl_keys_callback_hook() {
    this.SSL_CTX_set_keylog_callback = new NativeFunction(this.addresses[this.module_name]["SSL_CTX_set_keylog_callback"], "void", ["pointer", "pointer"]);
    var instance = this;
    try {
      const ssl_new_ptr = this.addresses[this.module_name]["SSL_new"];
      const ssl_get_ctx_ptr = this.addresses[this.module_name]["SSL_get_SSL_CTX"];
      const set_keylog_cb_ptr = this.addresses[this.module_name]["SSL_CTX_set_keylog_callback"];
      if (!ssl_new_ptr || !ssl_get_ctx_ptr || !set_keylog_cb_ptr) {
        devlog_error(`Required functions not found in ${this.module_name}`);
        return;
      }
      const SSL_get_SSL_CTX = new NativeFunction(ssl_get_ctx_ptr, "pointer", ["pointer"]);
      Interceptor.attach(ssl_new_ptr, {
        onEnter(args) {
        },
        onLeave(retval) {
          if (retval.isNull()) {
            devlog_error("SSL_new returned NULL");
            return;
          }
          const ssl_ptr = retval;
          const ctx_ptr = SSL_get_SSL_CTX(ssl_ptr);
          if (ctx_ptr.isNull()) {
            devlog_error("SSL_get_SSL_CTX returned NULL");
            return;
          }
          try {
            devlog("Installing callback for OpenSSL_From_Python for module: " + instance.module_name);
            instance.SSL_CTX_set_keylog_callback(ctx_ptr, OpenSSL_BoringSSL.keylog_callback);
          } catch (e) {
            devlog_error(`Failed to set keylog callback: ${e}`);
          }
        }
      });
    } catch (e) {
      devlog_error(`Error hooking ${instance.module_name}: ${e}`);
    }
    Interceptor.attach(this.addresses[this.module_name]["SSL_CTX_set_keylog_callback"], {
      onEnter: function(args) {
        let callback_func = args[1];
        Interceptor.attach(callback_func, {
          onEnter: function(args2) {
            var message = {};
            message["contentType"] = "keylog";
            message["keylog"] = args2[1].readCString();
            send(message);
          }
        });
      }
    });
  }
  execute_hooks() {
    this.install_openssl_keys_callback_hook();
  }
};
function boring_execute3(moduleName, is_base_hook) {
  var boring_ssl = new OpenSSL_BoringSSL_MacOS(moduleName, socket_library3, is_base_hook);
  boring_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = boring_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}
function ssl_python_execute(moduleName, is_base_hook) {
  var openssl = new OpenSSL_From_Python_MacOS(moduleName, socket_library3, is_base_hook);
  openssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = openssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/macos/cronet_macos.ts
var Cronet_MacOS = class extends Cronet {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  install_key_extraction_hook() {
    const cronetModule = Process.findModuleByName(this.module_name);
    const hooker = new PatternBasedHooking(cronetModule);
    if (isPatternReplaced()) {
      devlog("Hooking Cronet functions by pattern");
      hooker.hook_DumpKeys(this.module_name, "Cronet", patterns, (args) => {
        this.dumpKeys(args[1], args[0], args[2]);
      });
    }
  }
  execute_hooks() {
    this.install_key_extraction_hook();
  }
};
function cronet_execute3(moduleName, is_base_hook) {
  var cronet = new Cronet_MacOS(moduleName, socket_library3, is_base_hook);
  cronet.execute_hooks();
  if (is_base_hook) {
    const init_addresses = cronet.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/macos/macos_agent.ts
var plattform_name3 = "darwin";
var moduleNames3 = getModuleNames();
var socket_library3 = "libSystem.B.dylib";
function hook_macOS_Dynamic_Loader(module_library_mapping2, is_base_hook) {
  try {
    const regex_libdl = /libSystem.B.dylib/;
    const libdl = moduleNames3.find((element) => element.match(regex_libdl));
    if (libdl === void 0) {
      throw "Darwin Dynamic loader not found!";
    }
    var dlopen = "dlopen";
    Interceptor.attach(Process.getModuleByName("libSystem.B.dylib").getExportByName(dlopen), {
      onEnter: function(args) {
        this.moduleName = args[0].readCString();
      },
      onLeave: function(retval) {
        if (this.moduleName != void 0) {
          for (let map of module_library_mapping2[plattform_name3]) {
            let regex = map[0];
            let func = map[1];
            let optionalPath = map[2];
            if (regex.test(this.moduleName)) {
              if (optionalPath) {
                try {
                  const mod = Process.getModuleByName(this.moduleName);
                  if (!mod.path.toLowerCase().includes(optionalPath.toLowerCase())) {
                    continue;
                  }
                } catch (_) {
                  continue;
                }
              }
              log(`${this.moduleName} was loaded & will be hooked on MacOS!`);
              try {
                func(this.moduleName, is_base_hook);
              } catch (error_msg) {
                devlog(`MacOS dynamic loader error: ${error_msg}`);
              }
            }
          }
        }
      }
    });
    log("MacOS dynamic loader hooked.");
  } catch (error) {
    devlog("Loader error: " + error);
    log("No dynamic loader present for hooking on MacOS.");
  }
}
function hook_macOS_SSL_Libs(module_library_mapping2, is_base_hook) {
  ssl_library_loader(plattform_name3, module_library_mapping2, moduleNames3, "MacOS", is_base_hook);
}
function load_macos_hooking_agent() {
  module_library_mapping[plattform_name3] = [
    [/.*libboringssl\.dylib/, invokeHookingFunction(boring_execute3)],
    [/.*libssl.*\.dylib/, invokeHookingFunction(ssl_python_execute), "python"],
    // Python-specific OpenSSL
    [/.*libssl.*\.dylib/, invokeHookingFunction(boring_execute3)],
    [/.*cronet.*\.dylib/, invokeHookingFunction(cronet_execute3)]
  ];
  hook_macOS_SSL_Libs(module_library_mapping, true);
  hook_macOS_Dynamic_Loader(module_library_mapping, false);
}

// agent/linux/gnutls_linux.ts
var GnuTLS_Linux2 = class extends GnuTLS {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
    this.install_tls_keys_callback_hook();
  }
  install_tls_keys_callback_hook() {
    Interceptor.attach(this.addresses[this.module_name]["gnutls_init"], {
      onEnter: function(args) {
        this.session = args[0];
      },
      onLeave: function(retval) {
        console.log(this.session);
        GnuTLS.gnutls_session_set_keylog_function(this.session.readPointer(), GnuTLS.keylog_callback);
      }
    });
  }
};
function gnutls_execute2(moduleName, is_base_hook) {
  var gnutls_ssl = new GnuTLS_Linux2(moduleName, socket_library4, is_base_hook);
  gnutls_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = gnutls_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/linux/wolfssl_linux.ts
var WolfSSL_Linux = class extends WolfSSL {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
    this.install_tls_keys_callback_hook();
  }
  install_tls_keys_callback_hook() {
    WolfSSL.wolfSSL_get_client_random = new NativeFunction(this.addresses[this.module_name]["wolfSSL_get_client_random"], "int", ["pointer", "pointer", "int"]);
    WolfSSL.wolfSSL_get_server_random = new NativeFunction(this.addresses[this.module_name]["wolfSSL_get_server_random"], "int", ["pointer", "pointer", "int"]);
    WolfSSL.wolfSSL_SESSION_get_master_key = new NativeFunction(this.addresses[this.module_name]["wolfSSL_SESSION_get_master_key"], "int", ["pointer", "pointer", "int"]);
    Interceptor.attach(this.addresses[this.module_name]["wolfSSL_connect"], {
      onEnter: function(args) {
        this.ssl = args[0];
      },
      onLeave: function(retval) {
        this.session = WolfSSL.wolfSSL_get_session(this.ssl);
        var keysString = "";
        var requiredClientRandomLength = WolfSSL.wolfSSL_get_client_random(this.session, NULL, 0);
        var clientBuffer = Memory.alloc(requiredClientRandomLength);
        WolfSSL.wolfSSL_get_client_random(this.ssl, clientBuffer, requiredClientRandomLength);
        var clientBytes = clientBuffer.readByteArray(requiredClientRandomLength);
        keysString = `${keysString}CLIENT_RANDOM: ${toHexString(clientBytes)}
`;
        var requiredServerRandomLength = WolfSSL.wolfSSL_get_server_random(this.session, NULL, 0);
        var serverBuffer = Memory.alloc(requiredServerRandomLength);
        WolfSSL.wolfSSL_get_server_random(this.ssl, serverBuffer, requiredServerRandomLength);
        var serverBytes = serverBuffer.readByteArray(requiredServerRandomLength);
        keysString = `${keysString}SERVER_RANDOM: ${toHexString(serverBytes)}
`;
        var requiredMasterKeyLength = WolfSSL.wolfSSL_SESSION_get_master_key(this.session, NULL, 0);
        var masterBuffer = Memory.alloc(requiredMasterKeyLength);
        WolfSSL.wolfSSL_SESSION_get_master_key(this.session, masterBuffer, requiredMasterKeyLength);
        var masterBytes = masterBuffer.readByteArray(requiredMasterKeyLength);
        keysString = `${keysString}MASTER_KEY: ${toHexString(masterBytes)}
`;
        var message = {};
        message["contentType"] = "keylog";
        message["keylog"] = keysString;
        send(message);
      }
    });
  }
};
function wolfssl_execute2(moduleName, is_base_hook) {
  var wolf_ssl = new WolfSSL_Linux(moduleName, socket_library4, is_base_hook);
  wolf_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = wolf_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/linux/nss_linux.ts
var NSS_Linux = class extends NSS {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6) {
    var library_method_mapping = {};
    library_method_mapping[`*${moduleName}*`] = ["PR_Write", "PR_Read", "PR_FileDesc2NativeHandle", "PR_GetPeerName", "PR_GetSockName", "PR_GetNameForIdentity", "PR_GetDescType"];
    library_method_mapping[`*libnss*`] = ["PK11_ExtractKeyValue", "PK11_GetKeyData"];
    library_method_mapping["*libssl*.so"] = ["SSL_ImportFD", "SSL_GetSessionID", "SSL_HandshakeCallback"];
    library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    super(moduleName, socket_library6, library_method_mapping);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
    this.install_tls_keys_callback_hook();
  }
  install_tls_keys_callback_hook() {
    NSS.getDescType = new NativeFunction(this.addresses[this.module_name]["PR_GetDescType"], "int", ["pointer"]);
    NSS.PR_GetNameForIdentity = new NativeFunction(this.addresses[this.module_name]["PR_GetNameForIdentity"], "pointer", ["pointer"]);
    NSS.get_SSL_Callback = new NativeFunction(this.addresses[this.module_name]["SSL_HandshakeCallback"], "int", ["pointer", "pointer", "pointer"]);
    NSS.PK11_ExtractKeyValue = new NativeFunction(this.addresses[this.module_name]["PK11_ExtractKeyValue"], "int", ["pointer"]);
    NSS.PK11_GetKeyData = new NativeFunction(this.addresses[this.module_name]["PK11_GetKeyData"], "pointer", ["pointer"]);
    Interceptor.attach(this.addresses[this.module_name]["SSL_ImportFD"], {
      onEnter(args) {
        this.fd = args[1];
      },
      onLeave(retval) {
        if (retval.isNull()) {
          devlog("[-] SSL_ImportFD error: unknow null");
          return;
        }
        var retValue = NSS.get_SSL_Callback(retval, NSS.keylog_callback, NULL);
        NSS.register_secret_callback(retval);
        if (retValue < 0) {
          devlog("Callback Error");
          var getErrorText = new NativeFunction(Process.getModuleByName("libnspr4.so").getExportByName("PR_GetErrorText"), "int", ["pointer"]);
          var outbuffer = Memory.alloc(200);
          devlog("typeof outbuffer: " + typeof outbuffer);
          devlog("outbuffer: " + outbuffer);
          getErrorText(outbuffer.readPointer());
          devlog("Error msg: " + outbuffer);
        } else {
          devlog("[*] NSS keylog callback successfull installed");
        }
      }
    });
    Interceptor.attach(this.addresses[this.module_name]["SSL_HandshakeCallback"], {
      onEnter(args) {
        this.originalCallback = args[1];
        Interceptor.attach(ptr(this.originalCallback), {
          onEnter(args2) {
            var sslSocketFD = args2[0];
            devlog("[*] keylog callback successfull installed via applications callback function");
            NSS.ssl_RecordKeyLog(sslSocketFD);
          },
          onLeave(retval) {
          }
        });
      },
      onLeave(retval) {
      }
    });
  }
};
function nss_execute2(moduleName, is_base_hook) {
  var nss_ssl = new NSS_Linux(moduleName, socket_library4);
  nss_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = nss_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/linux/mbedTLS_linux.ts
var mbed_TLS_Linux = class extends mbed_TLS {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6) {
    super(moduleName, socket_library6);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  /*
      SSL_CTX_set_keylog_callback not exported by default on windows.
  
      We need to find a way to install the callback function for doing that
  
      Alternatives?:SSL_export_keying_material, SSL_SESSION_get_master_key
      */
  install_tls_keys_callback_hook() {
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
  }
};
function mbedTLS_execute2(moduleName, is_base_hook) {
  var mbedTLS_ssl = new mbed_TLS_Linux(moduleName, socket_library4);
  mbedTLS_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = mbedTLS_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/linux/openssl_boringssl_linux.ts
var OpenSSL_BoringSSL_Linux = class extends OpenSSL_BoringSSL {
  moduleName;
  socket_library;
  default_pattern;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.default_pattern = {
      "x64": {
        primary: "F3 0F 1E FA 48 89 F8 49 89 D0 48 89 F7 49 89 C9 48 8D 90 40 01 00 00 B9 20 00 00 00 48 89 C6 E9 8C 63 FF FF",
        // Primary pattern
        fallback: "55 41 57 41 56 41 54 53 48 83 EC 30 48 8B 47 68 48 83 B8 20 02 00 00 00 0F 84"
        // Fallback pattern
      },
      "x86": {
        primary: "55 53 57 56 83 EC 4C E8 00 00 00 00 5B 81 C3 A9 CB 13 00 8B 44 24 60 8B 40 34",
        // Primary pattern
        fallback: "55 53 57 56 83 EC 4C E8 00 00 00 00 5B 81 C3 A9 CB 13 00 8B 44 24 60"
        // Fallback pattern
      },
      "arm64": {
        primary: "3F 23 03 D5 FD 7B BF A9 E4 03 01 AA FD 03 00 91 FD 7B C1 A8 BF 23 03 D5 E1 03 00 AA E5 03 03 AA E0 03 04 AA 03 04 80 D2 E4 03 02 AA 22 80 05 91",
        // Primary pattern
        fallback: "3F 23 03 D5 FF ?3 02 D1 FD 7B 0? A9 F? ?? 0? ?9 F6 57 0? A9 F4 4F 0? A9 FD ?3 01 91 08 34 40 F9 08 ?? 41 F9 ?8 ?? 00 B4"
        // Fallback pattern
      },
      "arm": {
        primary: "2D E9 F0 43 89 B0 04 46 40 6B D0 F8 2C 01 00 28 49 D0",
        // Primary pattern
        fallback: "2D E9 F0 41 86 B0 04 46 40 6B D0 F8 30 01 00 28 53 D0"
        // Fallback pattern
      }
    };
  }
  install_tls_keys_callback_hook() {
    this.SSL_CTX_set_keylog_callback = new NativeFunction(this.addresses[this.module_name]["SSL_CTX_set_keylog_callback"], "void", ["pointer", "pointer"]);
    var instance = this;
    let callback_already_set = false;
    Interceptor.attach(this.addresses[this.module_name]["SSL_new"], {
      onEnter: function(args) {
        try {
          callback_already_set = true;
          instance.SSL_CTX_set_keylog_callback(args[0], OpenSSL_BoringSSL.keylog_callback);
        } catch (e) {
          callback_already_set = false;
          devlog_error(`Error in SSL_new hook: ${e}`);
        }
      }
    });
    if (this.addresses[this.module_name]["SSL_CTX_new"] !== null && callback_already_set === false) {
      Interceptor.attach(this.addresses[this.module_name]["SSL_CTX_new"], {
        onLeave: function(retval) {
          try {
            if (retval.isNull()) {
              devlog_error("SSL_CTX_new returned NULL");
              return;
            }
            instance.SSL_CTX_set_keylog_callback(retval, OpenSSL_BoringSSL.keylog_callback);
          } catch (e) {
            devlog_error(`Error in SSL_CTX_new hook: ${e}`);
          }
        }
      });
    }
    let setter_address = "SSL_CTX_set_keylog_callback";
    Interceptor.attach(this.addresses[this.module_name][setter_address], {
      onEnter: function(args) {
        let callback_func = args[1];
        Interceptor.attach(callback_func, {
          onEnter: function(args2) {
            var message = {};
            message["contentType"] = "keylog";
            message["keylog"] = args2[1].readCString();
            send(message);
          }
        });
      }
    });
  }
  install_openssl_key_extraction_hook() {
    let opensslModule = Process.findModuleByName(this.module_name);
    const hooker = new PatternBasedHooking(opensslModule);
    if (isPatternReplaced()) {
      devlog("Hooking libssl functions by patterns from JSON file");
      hooker.hook_DumpKeys(this.module_name, "libssl.so3", patterns, (args) => {
        devlog("Installed ssl_log_secret() hooks using byte patterns.");
        this.dump_keys_openssl(args[1], args[0], args[2], args[3]);
      });
    } else {
      hooker.hookModuleByPattern(get_CPU_specific_pattern(this.default_pattern), (args) => {
        devlog("Installed ssl_log_secret() hooks using byte patterns.");
        this.dump_keys_openssl(args[1], args[0], args[2], args[3]);
      });
    }
    return hooker;
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
    let hooker_instance = this.install_openssl_key_extraction_hook();
    if (hooker_instance !== void 0 || hooker_instance !== null) {
      devlog("Installed OpenSSL key extraction function hooks using patterns: " + hooker_instance.no_hooking_success);
    }
    this.install_tls_keys_callback_hook();
    this.install_extended_hooks();
  }
};
var OpenSSL_From_Python_Linux = class extends OpenSSL_BoringSSL {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    var library_method_mapping = {};
    library_method_mapping[`*${moduleName}*`] = ["SSL_CTX_set_keylog_callback", "SSL_CTX_new", "SSL_new", "SSL_get_SSL_CTX"];
    super(moduleName, socket_library6, is_base_hook, library_method_mapping);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  install_openssl_keys_callback_hook() {
    this.SSL_CTX_set_keylog_callback = new NativeFunction(this.addresses[this.module_name]["SSL_CTX_set_keylog_callback"], "void", ["pointer", "pointer"]);
    var instance = this;
    try {
      const ssl_new_ptr = this.addresses[this.module_name]["SSL_new"];
      const ssl_get_ctx_ptr = this.addresses[this.module_name]["SSL_get_SSL_CTX"];
      const set_keylog_cb_ptr = this.addresses[this.module_name]["SSL_CTX_set_keylog_callback"];
      if (!ssl_new_ptr || !ssl_get_ctx_ptr || !set_keylog_cb_ptr) {
        devlog_error(`Required functions not found in ${this.module_name}`);
        return;
      }
      const SSL_get_SSL_CTX = new NativeFunction(ssl_get_ctx_ptr, "pointer", ["pointer"]);
      Interceptor.attach(ssl_new_ptr, {
        onEnter(args) {
        },
        onLeave(retval) {
          if (retval.isNull()) {
            devlog_error("SSL_new returned NULL");
            return;
          }
          const ssl_ptr = retval;
          const ctx_ptr = SSL_get_SSL_CTX(ssl_ptr);
          if (ctx_ptr.isNull()) {
            devlog_error("SSL_get_SSL_CTX returned NULL");
            return;
          }
          try {
            devlog("Installing callback for OpenSSL_From_Python for module: " + instance.module_name);
            instance.SSL_CTX_set_keylog_callback(ctx_ptr, OpenSSL_BoringSSL.keylog_callback);
          } catch (e) {
            devlog_error(`Failed to set keylog callback: ${e}`);
          }
        }
      });
    } catch (e) {
      devlog_error(`Error hooking ${instance.module_name}: ${e}`);
    }
    Interceptor.attach(this.addresses[this.module_name]["SSL_CTX_set_keylog_callback"], {
      onEnter: function(args) {
        let callback_func = args[1];
        Interceptor.attach(callback_func, {
          onEnter: function(args2) {
            var message = {};
            message["contentType"] = "keylog";
            message["keylog"] = args2[1].readCString();
            send(message);
          }
        });
      }
    });
  }
  execute_hooks() {
    this.install_openssl_keys_callback_hook();
  }
};
function boring_execute4(moduleName, is_base_hook) {
  var boring_ssl = new OpenSSL_BoringSSL_Linux(moduleName, socket_library4, is_base_hook);
  boring_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = boring_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}
function ssl_python_execute2(moduleName, is_base_hook) {
  var openssl = new OpenSSL_From_Python_Linux(moduleName, socket_library4, is_base_hook);
  openssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = openssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/ssl_lib/matrixssl.ts
var matrix_SSL = class _matrix_SSL {
  moduleName;
  socket_library;
  passed_library_method_mapping;
  // global variables
  library_method_mapping = {};
  addresses;
  module_name;
  static matrixSslNewCLientSession;
  static sessionId;
  static matrixSslGetSid;
  constructor(moduleName, socket_library6, passed_library_method_mapping) {
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.passed_library_method_mapping = passed_library_method_mapping;
    if (typeof passed_library_method_mapping !== "undefined") {
      this.library_method_mapping = passed_library_method_mapping;
    } else {
      this.library_method_mapping[`*${moduleName}*`] = ["matrixSslReceivedData", "matrixSslGetWritebuf", "matrixSslGetSid", "matrixSslEncodeWritebuf"];
      this.library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl", "socket"];
    }
    this.addresses = readAddresses(moduleName, this.library_method_mapping);
    this.module_name = moduleName;
    if (offsets != "{OFFSETS}" && offsets.matrixssl != null) {
      if (offsets.sockets != null) {
        const socketBaseAddress = getBaseAddress(socket_library6);
        for (const method2 of Object.keys(offsets.sockets)) {
          this.addresses[this.moduleName][`${method2}`] = offsets.sockets[`${method2}`].absolute || socketBaseAddress == null ? ptr(offsets.sockets[`${method2}`].address) : socketBaseAddress.add(ptr(offsets.sockets[`${method2}`].address));
        }
      }
      const libraryBaseAddress = getBaseAddress(moduleName);
      if (libraryBaseAddress == null) {
        log("Unable to find library base address! Given address values will be interpreted as absolute ones!");
      }
      for (const method2 of Object.keys(offsets.matrixssl)) {
        this.addresses[this.moduleName][`${method2}`] = offsets.matrixssl[`${method2}`].absolute || libraryBaseAddress == null ? ptr(offsets.matrixssl[`${method2}`].address) : libraryBaseAddress.add(ptr(offsets.matrixssl[`${method2}`].address));
      }
    }
    _matrix_SSL.matrixSslNewCLientSession = new NativeFunction(this.addresses[this.moduleName]["matrixSslNewClientSession"], "int", ["pointer", "pointer", "pointer", "pointer", "int", "pointer", "pointer", "pointer", "pointer", "pointer"]);
    _matrix_SSL.matrixSslGetSid = new NativeFunction(this.addresses[this.moduleName]["matrixSslGetSid"], "pointer", ["pointer"]);
  }
  install_plaintext_read_hook() {
    var current_module_name = this.module_name;
    var lib_addesses = this.addresses;
    Interceptor.attach(this.addresses[this.moduleName]["matrixSslReceivedData"], {
      onEnter: function(args) {
        this.buffer = args[2];
        this.len = args[3];
        var message = getPortsAndAddresses(this.fd, true, lib_addesses[current_module_name], enable_default_fd);
        message["ssl_session_id"] = this.addresses[this.moduleName]["matrixSslGetSid"] === void 0 ? _matrix_SSL.sessionId : this.getSessionId(args[0]);
        message["function"] = "matrixSslReceivedData";
        this.message = message;
      },
      onLeave: function(retval) {
        retval |= 0;
        if (retval <= 0) {
          return;
        }
        var data = this.buffer.readByteArray(this.len);
        this.message["contentType"] = "datalog";
        send(this.message, data);
      }
    });
  }
  install_plaintext_write_hook() {
    var current_module_name = this.module_name;
    var lib_addesses = this.addresses;
    Interceptor.attach(this.addresses[this.moduleName]["matrixSslGetWritebuf"], {
      onEnter: function(args) {
        this.outBuffer = args[1];
      },
      onLeave: function(retval) {
        retval |= 0;
        if (retval <= 0) {
          return;
        }
        this.outBufferLength = retval;
      }
    });
    Interceptor.attach(this.addresses[this.moduleName]["matrixSslEncodeWritebuf"], {
      onEnter: function(args) {
        var data = this.outBuffer.readByteArray(this.outBufferLength);
        var message = getPortsAndAddresses(this.fd, false, lib_addesses[current_module_name], enable_default_fd);
        message["ssl_session_id"] = this.addresses[this.moduleName]["matrixSslGetSid"] === void 0 ? _matrix_SSL.sessionId : this.getSessionId(args[0]);
        message["function"] = "matrixSslEncodeWritebuf";
        message["contentType"] = "datalog";
        send(message, data);
      }
    });
  }
  install_tls_keys_callback_hook() {
  }
  install_helper_hook() {
    Interceptor.attach(this.addresses[this.moduleName]["matrixSslNewSessionId"], {
      onEnter: function(args) {
        this.sslSessionPointer = args[0];
      },
      onLeave: function(retval) {
        retval |= 0;
        if (retval <= 0) {
          return;
        }
        var sessionIdLength = this.sslSessionPointer.add(2 * Process.pointerSize).readU32();
        _matrix_SSL.sessionId = this.sslSessionPointer.add(Process.pointerSize).readPointer().readCString(sessionIdLength);
      }
    });
    Interceptor.attach(this.addresses[this.moduleName]["connect"], {
      onEnter: function(args) {
      },
      onLeave: function(retval) {
        retval |= 0;
        if (retval <= 0) {
          return;
        }
        this.fd = retval;
      }
    });
  }
  getSessionId(ssl) {
    const sid = _matrix_SSL.matrixSslGetSid(ssl);
    const sessionIdLength = sid.add(2 * Process.pointerSize).readU32();
    const sessionId = sid.add(Process.pointerSize).readPointer().readCString(sessionIdLength);
    return sessionId;
  }
};

// agent/linux/matrixssl_linux.ts
var matrix_SSL_Linux = class extends matrix_SSL {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  /*
      SSL_CTX_set_keylog_callback not exported by default on windows.
  
      We need to find a way to install the callback function for doing that
  
      Alternatives?:SSL_export_keying_material, SSL_SESSION_get_master_key
      */
  install_tls_keys_callback_hook() {
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
  }
};
function matrixSSL_execute(moduleName, is_base_hook) {
  var matrix_ssl = new matrix_SSL_Linux(moduleName, socket_library4, is_base_hook);
  matrix_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = matrix_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/linux/s2ntls_linux.ts
var S2nTLS_Linux = class extends S2nTLS {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
    this.install_tls_keys_callback_hook();
  }
  //if s2n_config_new is called, the keylog callback is set
  install_tls_keys_callback_hook() {
    S2nTLS.s2n_set_key_log_cb = new NativeFunction(this.addresses[this.module_name]["s2n_config_set_key_log_cb"], "int", ["pointer", "pointer", "pointer"]);
    Interceptor.attach(this.addresses[this.module_name]["s2n_config_new"], {
      onLeave: function(retval) {
        let emptyPointer = ptr("0");
        S2nTLS.s2n_set_key_log_cb(retval, S2nTLS.keylog_callback, emptyPointer);
      }
    });
    Interceptor.attach(this.addresses[this.module_name]["s2n_config_set_key_log_cb"], {
      onEnter: function(args) {
        let user_callback = args[1];
        Interceptor.attach(user_callback, {
          onEnter: function(args2) {
            let logline = args2[2];
            let len = args2[3];
            var message = {};
            message["contentType"] = "keylog";
            message["keylog"] = logline.readCString(len.toInt32());
            send(message);
          }
        });
      }
    });
  }
};
function s2ntls_execute2(moduleName, is_base_hook) {
  var s2n_tls = new S2nTLS_Linux(moduleName, socket_library4, is_base_hook);
  s2n_tls.execute_hooks();
  if (is_base_hook) {
    const init_addresses = s2n_tls.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/linux/cronet_linux.ts
var Cronet_Linux = class extends Cronet {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  install_key_extraction_hook() {
    const cronetModule = Process.findModuleByName(this.module_name);
    const hooker = new PatternBasedHooking(cronetModule);
    if (isPatternReplaced()) {
      devlog("Hooking libcronet functions by pattern");
      hooker.hook_DumpKeys(this.module_name, "libcronet.so", patterns, (args) => {
        this.dumpKeys(args[1], args[0], args[2]);
      });
    }
  }
  execute_hooks() {
    this.install_key_extraction_hook();
  }
};
function cronet_execute4(moduleName, is_base_hook) {
  var cronet = new Cronet_Linux(moduleName, socket_library4, is_base_hook);
  cronet.execute_hooks();
  if (is_base_hook) {
    const init_addresses = cronet.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/linux/rustls_linux.ts
var Rustls_Linux = class extends RusTLS {
  moduleName;
  socket_library;
  default_pattern;
  default_pattern_12;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.default_pattern = {
      "x64": {
        primary: "48 81 EC 18 01 00 00 4C 89 4C 24 40 48 89 7C 24 48 88 D0 48 89 7C 24 50 48 8B 94 24 28 01 00 00 48 89 54 24 58 48 8B 94 24 20 01 00 00 48 89",
        fallback: "48 81 EC 18 01 00 00 4C 89 4C 24 40 48 89 7C 24 48 88 D0 48 89 7C 24 50 48 8B 94 24 28 01 00 00 48 89 54 24 58 48 8B 94 24 20 01"
      }
    };
    this.default_pattern_12 = {
      "x64": {
        primary: "41 57 41 56 53 48 81 ec c0 04 00 00 4c 89 8c 24 a0 00 00 00 4c 89 44 24 70 48 89 4c 24 78 48 89 bc 24 80 00 00 00 48 89 bc 24 88 00 00 00 48 8b",
        fallback: "41 57 41 56 53 48 81 ec c0 04 00 00 4c 89 8c 24 a0 00 00 00 4c 89 44 24 70 48 89 4c 24 78 48 89 bc 24 80 00 00 00 48 89 bc 24 88"
      }
    };
  }
  execute_pattern_hooks() {
    this.install_key_extraction_hook();
  }
  install_key_extraction_hook() {
    const rusTLSModule = Process.findModuleByName(this.module_name);
    const hooker = new PatternBasedHooking(rusTLSModule);
    this.install_key_extraction_hook_tls(hooker);
    this.install_key_extraction_hook_tls_12(hooker);
  }
  install_key_extraction_hook_tls_12(hooker) {
    const doDumpKeysLogic = (args, retval) => {
      let client_random_ptr;
      let master_secret_ptr;
      client_random_ptr = args[6];
      master_secret_ptr = retval.add(72);
      this.dumpKeysFromPRF(client_random_ptr, master_secret_ptr);
    };
    const normalPatternCallback = (args, retval) => {
      if (!retval) {
        devlog("retval is null");
        return;
      }
      if (!retval.isNull()) {
        doDumpKeysLogic(args, retval);
      }
    };
    if (isPatternReplaced()) {
      hooker.hook_DumpKeys(
        this.module_name,
        // Pick the JSON module name based on whether it’s “ex”
        "rustls",
        patterns,
        normalPatternCallback,
        true,
        // onReturn so we get retval
        7
      );
    } else {
      hooker.hookModuleByPatternOnReturn(
        // Pick the default pattern based on whether it’s “ex”
        get_CPU_specific_pattern(this.default_pattern_12),
        normalPatternCallback,
        7
      );
    }
  }
  install_key_extraction_hook_tls(hooker) {
    const doDumpKeysLogic = (args, retval) => {
      let client_random_ptr;
      let key;
      let label_enum;
      client_random_ptr = args[7];
      key = args[0];
      label_enum = args[2].toInt32();
      this.dumpKeysFromDeriveLogged(client_random_ptr, key, label_enum);
    };
    const normalPatternCallback = (args, retval) => {
      if (!retval)
        return;
      if (retval.isNull()) {
        doDumpKeysLogic(args, retval);
      } else {
        if (Process.arch === "x64") {
          doDumpKeysLogic(args, retval);
        }
      }
    };
    if (isPatternReplaced()) {
      hooker.hook_DumpKeys(
        this.module_name,
        "rustls",
        patterns,
        normalPatternCallback,
        true,
        // onReturn so we get retval
        9
      );
    } else {
      hooker.hookModuleByPatternOnReturn(get_CPU_specific_pattern(this.default_pattern), normalPatternCallback, 9);
    }
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
    this.install_tls_keys_callback_hook();
  }
  // Extract the configBuilder from call to rustls_client_config_builder_new / _custom and set keyLogCB
  install_tls_keys_callback_hook() {
    RusTLS.rustls_client_config_set_key_log = new NativeFunction(this.addresses[this.moduleName]["rustls_client_config_builder_set_key_log"], "uint32", ["pointer", "pointer", "pointer"]);
    Interceptor.attach(this.addresses[this.moduleName]["rustls_client_config_builder_new"], {
      onLeave: function(retval) {
        if (retval.isNull()) {
          devlog("Error: retval is null");
          return;
        }
        RusTLS.rustls_client_config_set_key_log(retval, RusTLS.keyLogCB, ptr("0"));
        devlog("Attached keyLogCB to rustls_client_config_set_key_log");
      }
    });
    Interceptor.attach(this.addresses[this.moduleName]["rustls_client_config_builder_new_custom"], {
      onLeave: function(retval) {
        if (retval.isNull()) {
          devlog("Error: retval is null");
          return;
        }
        RusTLS.rustls_client_config_set_key_log(retval, RusTLS.keyLogCB, ptr("0"));
        devlog("Attached keyLogCB to rustls_client_config_set_key_log");
      }
    });
    Interceptor.attach(this.addresses[this.moduleName]["rustls_client_config_builder_set_key_log"], {
      onEnter: function(args) {
        var userCallbackAddress = args[1];
        devlog("User set CB to: " + userCallbackAddress);
        this.userCallbackAddress = userCallbackAddress;
      },
      onLeave: function(retval) {
        if (retval != 7e3) {
          return;
        } else {
          Interceptor.attach(this.userCallbackAddress, {
            onEnter(args) {
              devlog("Hooking user-defined callback for Rustls");
              var message = {};
              message["contentType"] = "keylog";
              var labelPtr = args[0];
              var label_len = args[1].toInt32();
              var client_random = args[2];
              var client_random_len = args[3].toInt32();
              var secret = args[4];
              var secret_len = args[5].toInt32();
              if (client_random.isNull() || client_random_len != 32) {
                devlog("Invalid client_random: " + client_random + " or client_random_lenght: " + client_random_len);
                return;
              }
              if (secret.isNull() || secret_len <= 0 || secret_len > 48) {
                devlog("Invalid secret or secret_length");
                return;
              }
              var clientRandomStr = client_random.readByteArray(client_random_len);
              var secretStr = secret.readByteArray(secret_len);
              var labelStr = labelPtr.readUtf8String(label_len);
              var clientRandomHex = Array.from(new Uint8Array(clientRandomStr)).map((b) => b.toString(16).padStart(2, "0")).join("");
              var secretHex = Array.from(new Uint8Array(secretStr)).map((b) => b.toString(16).padStart(2, "0")).join("");
              message["keylog"] = `${labelStr} ${clientRandomHex} ${secretHex}`;
              send(message);
              return 1;
            }
          });
        }
      }
    });
  }
};
function rustls_execute2(moduleName, is_base_hook) {
  var rusTLS = new Rustls_Linux(moduleName, socket_library4, is_base_hook);
  if (hasMoreThanFiveExports(moduleName)) {
    devlog("Trying to hook RusTLS using symbols...");
    rusTLS.execute_hooks();
  } else {
    devlog("Trying to hook RusTLS using patterns...");
    rusTLS.execute_pattern_hooks();
  }
  if (is_base_hook) {
    const init_addresses = rusTLS.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/linux/gotls_linux.ts
var GoTLS_Linux = class extends GoTLS {
  moduleName;
  socket_library;
  default_pattern;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.default_pattern = {
      "x64": {
        primary: "90 0B 40 F9 F1 43 00 D1 3F 02 10 EB E9 10 00 54 FE 0F 17 F8 FD 83 1F F8 FD 23 00 D1 E1 53 00 F9 E3 5B 00 F9 E6 67 00 F9 09 94 40 F9 49 0F 00 B4",
        // Primary pattern
        fallback: "55 41 57 41 56 41 54 53 48 83 EC 30 48 8B 47 68 48 83 B8 20 02 00 00 00 0F 84"
        // Fallback pattern
      },
      "x86": {
        primary: "90 0B 40 F9 F1 43 00 D1 3F 02 10 EB E9 10 00 54 FE 0F 17 F8 FD 83 1F F8 FD 23 00 D1 E1 53 00 F9 E3 5B 00 F9 E6 67 00 F9 09 94 40 F9 49 0F 00 B4",
        // Primary pattern
        fallback: "55 53 57 56 83 EC 4C E8 00 00 00 00 5B 81 C3 A9 CB 13 00 8B 44 24 60"
        // Fallback pattern
      },
      "arm64": {
        primary: "90 0B 40 F9 F1 43 00 D1 3F 02 10 EB E9 10 00 54 FE 0F 17 F8 FD 83 1F F8 FD 23 00 D1 E1 53 00 F9 E3 5B 00 F9 E6 67 00 F9 09 94 40 F9 49 0F 00 B4",
        // Primary pattern
        fallback: "3F 23 03 D5 FF ?3 02 D1 FD 7B 0? A9 F? ?? 0? ?9 F6 57 0? A9 F4 4F 0? A9 FD ?3 01 91 08 34 40 F9 08 ?? 41 F9 ?8 ?? 00 B4"
        // Fallback pattern
      },
      "arm": {
        primary: "90 0B 40 F9 F1 43 00 D1 3F 02 10 EB E9 10 00 54 FE 0F 17 F8 FD 83 1F F8 FD 23 00 D1 E1 53 00 F9 E3 5B 00 F9 E6 67 00 F9 09 94 40 F9 49 0F 00 B4",
        // Primary pattern
        fallback: "2D E9 F0 41 86 B0 04 46 40 6B D0 F8 30 01 00 28 53 D0"
        // Fallback pattern
      }
    };
  }
  getSoName(modulePath) {
    const m2 = modulePath.match(/([^\/\\]+\.so)$/);
    return m2 ? m2[1] : modulePath;
  }
  install_key_extraction_hook() {
    var instance = this;
    let goTLSModule = Process.findModuleByName(this.module_name);
    let soName = this.module_name;
    if (goTLSModule === null) {
      soName = this.getSoName(this.module_name);
      goTLSModule = Process.findModuleByName(soName);
      if (goTLSModule === null) {
        devlog("[-] GoTLS Error: Unable to find module: " + this.module_name);
        return;
      }
    }
    if (this.addresses[this.module_name][symbol_writeKeyLog] === void 0 || this.addresses[this.module_name][symbol_writeKeyLog] === null) {
      const hooker = new PatternBasedHooking(goTLSModule);
      if (isPatternReplaced()) {
        devlog("Hooking GoTLS functions by patterns from JSON file");
        hooker.hook_DumpKeys(this.module_name, soName, patterns, (args) => {
          devlog("Installed writeKeyLog() hooks using byte patterns.");
          const labelPtr = args[2];
          const labelLen = args[3].toInt32();
          const crPtr = args[4];
          const crLen = args[5].toInt32();
          const secretPtr = args[7];
          const secretLen = args[8].toInt32();
          this.dumpKeys(labelPtr, labelLen, crPtr, crLen, secretPtr, secretLen);
        });
      } else {
        hooker.hookModuleByPattern(get_CPU_specific_pattern(this.default_pattern), (args) => {
          devlog("Installed writeKeyLog() hooks using byte patterns.");
          const labelPtr = args[2];
          const labelLen = args[3].toInt32();
          const crPtr = args[4];
          const crLen = args[5].toInt32();
          const secretPtr = args[7];
          const secretLen = args[8].toInt32();
          this.dumpKeys(labelPtr, labelLen, crPtr, crLen, secretPtr, secretLen);
        });
      }
      return hooker;
    } else {
      devlog("[GoTLS] writeKeyLog symbol available");
      var result = instance.install_tls_keys_callback_hook();
      let hooker = new GoTlsLogger(goTLSModule, true, result);
      return hooker;
    }
  }
  // instead of relying on pattern we check if the target module has a symbol of writeKeyLog()
  execute_symbol_based_hooking(hooker) {
    if (hooker === void 0 || hooker === null) {
      devlog("[-] Error: Hooker is undefined.");
      return;
    }
    let dumpKeysFunc = this.dumpKeys.bind(this);
    if (hooker.no_hooking_success) {
      let symbols = Process.getModuleByName(this.module_name).enumerateSymbols().filter((exports) => exports.name.toLowerCase().includes("ssl_log"));
      if (symbols.length > 0) {
        devlog("Installed writeKeyLog() hooks using sybmols.");
        try {
          Interceptor.attach(symbols[0].address, {
            onEnter: function(args) {
              const labelPtr = args[2];
              const labelLen = args[3].toInt32();
              const crPtr = args[4];
              const crLen = args[5].toInt32();
              const secretPtr = args[7];
              const secretLen = args[8].toInt32();
              this.dumpKeys(labelPtr, labelLen, crPtr, crLen, secretPtr, secretLen);
            }
          });
        } catch (e) {
        }
      }
    }
  }
  execute_hooks() {
    let hooker_instance = this.install_key_extraction_hook();
    return hooker_instance;
  }
};
function gotls_execute2(moduleName, is_base_hook) {
  let gotls = new GoTLS_Linux(moduleName, socket_library4, is_base_hook);
  try {
    let hooker = gotls.execute_hooks();
    setTimeout(function() {
      try {
        gotls.execute_symbol_based_hooking(hooker);
      } catch (e) {
        devlog("[-] Error in gotls.execute_symbol_based_hooking: " + e);
      }
    }, 1500);
  } catch (error_msg) {
    devlog(`gotls_execute error: ${error_msg}`);
  }
  if (is_base_hook) {
    try {
      const init_addresses = gotls.addresses[moduleName];
      if (Object.keys(init_addresses).length > 0) {
        globalThis.init_addresses[moduleName] = init_addresses;
      }
    } catch (error_msg) {
      devlog(`gotls_execute base-hook error: ${error_msg}`);
    }
  }
}

// agent/linux/linux_agent.ts
var plattform_name4 = "linux";
var moduleNames4 = getModuleNames();
var socket_library4 = "libc";
function hook_Linux_Dynamic_Loader(module_library_mapping2, is_base_hook) {
  try {
    const regex_libdl = /.*libdl.*\.so/;
    const libdl = moduleNames4.find((element) => element.match(regex_libdl));
    if (libdl === void 0) {
      throw "Linux Dynamic loader not found!";
    }
    var dlopen = "dlopen";
    Interceptor.attach(Process.getModuleByName(libdl).getExportByName(dlopen), {
      onEnter: function(args) {
        this.moduleName = args[0].readCString();
      },
      onLeave: function(retval) {
        if (this.moduleName != void 0) {
          for (let map of module_library_mapping2[plattform_name4]) {
            let regex = map[0];
            let func = map[1];
            let optionalPath = map[2];
            if (regex.test(this.moduleName)) {
              if (optionalPath) {
                try {
                  const mod = Process.getModuleByName(this.moduleName);
                  if (!mod.path.toLowerCase().includes(optionalPath.toLowerCase())) {
                    continue;
                  }
                } catch (_) {
                  continue;
                }
              }
              log(`${this.moduleName} was loaded & will be hooked on Linux!`);
              try {
                func(this.moduleName, is_base_hook);
              } catch (error_msg) {
                devlog(`Linux dynamic loader error: ${error_msg}`);
              }
            }
          }
        }
      }
    });
    log(`[*] Linux dynamic loader hooked.`);
  } catch (error) {
    devlog("Loader error: " + error);
    log("No dynamic loader present for hooking.");
  }
}
function hook_Linux_SSL_Libs(module_library_mapping2, is_base_hook) {
  ssl_library_loader(plattform_name4, module_library_mapping2, moduleNames4, "Linux", is_base_hook);
}
function load_linux_hooking_agent() {
  module_library_mapping[plattform_name4] = [
    [/.*libssl_sb.so/, invokeHookingFunction(boring_execute4)],
    [/.*libssl\.so/, invokeHookingFunction(boring_execute4)],
    [/.*libssl.*\.so/, invokeHookingFunction(ssl_python_execute2), "python"],
    // Python-specific OpenSSL
    [/.*cronet.*\.so/, invokeHookingFunction(cronet_execute4)],
    [/.*libgnutls\.so/, invokeHookingFunction(gnutls_execute2)],
    [/.*libwolfssl\.so/, invokeHookingFunction(wolfssl_execute2)],
    [/.*libnspr[0-9]?\.so/, invokeHookingFunction(nss_execute2)],
    [/libmbedtls\.so.*/, invokeHookingFunction(mbedTLS_execute2)],
    [/libssl_s.a/, invokeHookingFunction(matrixSSL_execute)],
    [/.*libs2n.so/, invokeHookingFunction(s2ntls_execute2)],
    [/.*rustls.*/, invokeHookingFunction(rustls_execute2)],
    [/.*\.go.so$/, invokeHookingFunction(gotls_execute2)],
    // Go executables
    [/.*go[0-9.]+$/, invokeHookingFunction(gotls_execute2)]
    // Go versioned binaries
  ];
  hook_Linux_SSL_Libs(module_library_mapping, true);
  hook_Linux_Dynamic_Loader(module_library_mapping, false);
}

// agent/windows/sspi.ts
var keylog = (key, tlsVersion) => {
  devlog(`Exporting TLS 1.${tlsVersion} handshake keying material`);
  var message = {};
  message["contentType"] = "keylog";
  message["keylog"] = key;
  send(message);
};
var TLSVersion;
(function(TLSVersion3) {
  TLSVersion3[TLSVersion3["ONE_TWO"] = 2] = "ONE_TWO";
  TLSVersion3[TLSVersion3["ONE_THREE"] = 3] = "ONE_THREE";
})(TLSVersion || (TLSVersion = {}));
var SSPI_Windows = class {
  moduleName;
  socket_library;
  // global variables
  library_method_mapping = {};
  addresses;
  module_name;
  constructor(moduleName, socket_library6, is_base_hook) {
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    this.library_method_mapping[`*${moduleName}*`] = ["DecryptMessage", "EncryptMessage"];
    if (experimental) {
      log(`ncrypt.dll was loaded & will be hooked on Windows!`);
      this.library_method_mapping["*ncrypt*.dll"] = ["SslHashHandshake", "SslGenerateMasterKey", "SslImportMasterKey", "SslGenerateSessionKeys", "SslExpandExporterMasterKey", "SslExpandTrafficKeys"];
    }
    this.library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    this.addresses = readAddresses(moduleName, this.library_method_mapping);
    this.module_name = moduleName;
    if (offsets != "{OFFSETS}" && offsets.sspi != null) {
      if (offsets.sockets != null) {
        const socketBaseAddress = getBaseAddress(socket_library6);
        for (const method2 of Object.keys(offsets.sockets)) {
          this.addresses[this.module_name][`${method2}`] = offsets.sockets[`${method2}`].absolute || socketBaseAddress == null ? ptr(offsets.sockets[`${method2}`].address) : socketBaseAddress.add(ptr(offsets.sockets[`${method2}`].address));
        }
      }
      const libraryBaseAddress = getBaseAddress(moduleName);
      if (libraryBaseAddress == null) {
        log("Unable to find library base address! Given address values will be interpreted as absolute ones!");
      }
      for (const method2 of Object.keys(offsets.sspi)) {
        this.addresses[this.module_name][`${method2}`] = offsets.sspi[`${method2}`].absolute || libraryBaseAddress == null ? ptr(offsets.sspi[`${method2}`].address) : libraryBaseAddress.add(ptr(offsets.sspi[`${method2}`].address));
      }
    }
  }
  install_plaintext_read_hook() {
    Interceptor.attach(this.addresses[this.module_name]["DecryptMessage"], {
      onEnter: function(args) {
        this.pMessage = args[1];
      },
      onLeave: function() {
        this.cBuffers = this.pMessage.add(4).readULong();
        this.pBuffers = this.pMessage.add(8).readPointer();
        this.secBuffers = [];
        for (let i = 0; i < this.cBuffers; i++) {
          var secBuffer = this.pBuffers.add(i * 16);
          this.secBuffers.push(secBuffer);
        }
        for (let i = 0; i < this.secBuffers.length; i++) {
          var size = this.secBuffers[i].add(0).readULong();
          var type = this.secBuffers[i].add(4).readULong();
          var bufferPointer = this.secBuffers[i].add(8).readPointer();
          if (type == 1) {
            var bytes = bufferPointer.readByteArray(size);
            var message = {};
            message["ss_family"] = "AF_INET";
            message["src_port"] = 444;
            message["src_addr"] = 222;
            message["dst_port"] = 443;
            message["dst_addr"] = 222;
            message["function"] = "DecryptMessage";
            message["contentType"] = "datalog";
            message["ssl_session_id"] = 10;
            send(message, bytes);
          }
        }
      }
    });
  }
  install_plaintext_write_hook() {
    Interceptor.attach(this.addresses[this.module_name]["EncryptMessage"], {
      onEnter: function(args) {
        this.pMessage = args[2];
        this.cBuffers = this.pMessage.add(4).readULong();
        this.pBuffers = this.pMessage.add(8).readPointer();
        this.secBuffers = [];
        for (let i = 0; i < this.cBuffers; i++) {
          var secBuffer = this.pBuffers.add(i * 16);
          this.secBuffers.push(secBuffer);
        }
        for (let i = 0; i < this.secBuffers.length; i++) {
          var size = this.secBuffers[i].add(0).readULong();
          var type = this.secBuffers[i].add(4).readULong();
          var bufferPointer = this.secBuffers[i].add(8).readPointer();
          if (type == 1) {
            var bytes = bufferPointer.readByteArray(size);
            var message = {};
            message["ss_family"] = "AF_INET";
            message["src_port"] = 443;
            message["src_addr"] = 222;
            message["dst_port"] = 444;
            message["dst_addr"] = 222;
            message["function"] = "EncryptMessage";
            message["contentType"] = "datalog";
            message["ssl_session_id"] = 10;
            send(message, bytes);
          }
        }
      }
    });
  }
  install_tls_keys_hook() {
    var client_randoms = {};
    var buf2hex = function(buffer) {
      return Array.prototype.map.call(new Uint8Array(buffer), function(x) {
        return ("00" + x.toString(16)).slice(-2);
      }).join("");
    };
    var parse_h_master_key = function(pMasterKey) {
      var NcryptSslKey_ptr = pMasterKey;
      var ssl5_ptr = NcryptSslKey_ptr.add(16).readPointer();
      var master_key = ssl5_ptr.add(28).readByteArray(48);
      return buf2hex(master_key);
    };
    var parse_parameter_list = function(pParameterList, calling_func) {
      var buffer_count = pParameterList.add(4).readU32();
      var buffers = pParameterList.add(8).readPointer();
      for (var i = 0; i < buffer_count; i++) {
        var buf = buffers.add(16 * i);
        var buf_size = buf.readU32();
        var buf_type = buf.add(4).readU32();
        var buf_buf = buf.add(8).readPointer().readByteArray(buf_size);
        if (buf_type == 20) {
          devlog("Got client random from " + calling_func + "'s pParameterList: " + buf2hex(buf_buf));
          return buf2hex(buf_buf);
        }
      }
      return null;
    };
    if (this.addresses[this.module_name]["SslHashHandshake"] != null)
      Interceptor.attach(this.addresses[this.module_name]["SslHashHandshake"], {
        onEnter: function(args) {
          var buf = ptr(args[2]);
          var len = args[3].toInt32();
          var mem = buf.readByteArray(len);
          var msg_type = buf.readU8();
          var version = buf.add(4).readU16();
          if (msg_type == 1 && version == 771) {
            var crandom = buf2hex(buf.add(6).readByteArray(32));
            devlog("Got client random from SslHashHandshake: " + crandom);
            client_randoms[this.threadId] = crandom;
          }
        },
        onLeave: function(retval) {
        }
      });
    if (this.addresses[this.module_name]["SslGenerateMasterKey"] != null)
      Interceptor.attach(this.addresses[this.module_name]["SslGenerateMasterKey"], {
        onEnter: function(args) {
          this.phMasterKey = ptr(args[3]);
          this.hSslProvider = ptr(args[0]);
          this.pParameterList = ptr(args[6]);
          this.client_random = parse_parameter_list(this.pParameterList, "SslGenerateMasterKey") || client_randoms[this.threadId] || "???";
        },
        onLeave: function(retval) {
          var master_key = parse_h_master_key(this.phMasterKey.readPointer());
          devlog("Got masterkey from SslGenerateMasterKey");
          keylog("CLIENT_RANDOM " + this.client_random + " " + master_key, TLSVersion.ONE_TWO);
        }
      });
    if (this.addresses[this.module_name]["SslImportMasterKey"] != null)
      Interceptor.attach(this.addresses[this.module_name]["SslImportMasterKey"], {
        onEnter: function(args) {
          this.phMasterKey = ptr(args[2]);
          this.pParameterList = ptr(args[5]);
          this.client_random = parse_parameter_list(this.pParameterList, "SslImportMasterKey") || client_randoms[this.threadId] || "???";
        },
        onLeave: function(retval) {
          var master_key = parse_h_master_key(this.phMasterKey.readPointer());
          devlog("[*] Got masterkey from SslImportMasterKey");
          keylog("CLIENT_RANDOM " + this.client_random + " " + master_key, TLSVersion.ONE_TWO);
        }
      });
    if (this.addresses[this.module_name]["SslGenerateSessionKeys"] != null)
      Interceptor.attach(this.addresses[this.module_name]["SslGenerateSessionKeys"], {
        onEnter: function(args) {
          this.hMasterKey = ptr(args[1]);
          this.hSslProvider = ptr(args[0]);
          this.pParameterList = ptr(args[4]);
          this.client_random = parse_parameter_list(this.pParameterList, "SslGenerateSessionKeys") || client_randoms[this.threadId] || "???";
          var master_key = parse_h_master_key(this.hMasterKey);
          devlog("Got masterkey from SslGenerateSessionKeys");
          keylog("CLIENT_RANDOM " + this.client_random + " " + master_key, TLSVersion.ONE_TWO);
        },
        onLeave: function(retval) {
        }
      });
    var stages = {};
    var get_secret_from_BDDD = function(struct_BDDD) {
      var struct_3lss = struct_BDDD.add(16).readPointer();
      var struct_RUUU = struct_3lss.add(32).readPointer();
      var struct_YKSM = struct_RUUU.add(16).readPointer();
      var secret_ptr = struct_YKSM.add(24).readPointer();
      var size = struct_YKSM.add(16).readU32();
      return secret_ptr.readByteArray(size);
    };
    if (this.addresses[this.module_name]["SslExpandTrafficKeys"] != null)
      Interceptor.attach(this.addresses[this.module_name]["SslExpandTrafficKeys"], {
        onEnter: function(args) {
          this.retkey1 = ptr(args[3]);
          this.retkey2 = ptr(args[4]);
          this.client_random = client_randoms[this.threadId] || "???";
          if (stages[this.threadId]) {
            stages[this.threadId] = null;
            this.suffix = "TRAFFIC_SECRET_0";
          } else {
            stages[this.threadId] = "handshake";
            this.suffix = "HANDSHAKE_TRAFFIC_SECRET";
          }
        },
        onLeave: function(retval) {
          var key1 = get_secret_from_BDDD(this.retkey1.readPointer());
          var key2 = get_secret_from_BDDD(this.retkey2.readPointer());
          keylog("CLIENT_" + this.suffix + " " + this.client_random + " " + buf2hex(key1), TLSVersion.ONE_THREE);
          keylog("SERVER_" + this.suffix + " " + this.client_random + " " + buf2hex(key2), TLSVersion.ONE_THREE);
        }
      });
    if (this.addresses[this.module_name]["SslExpandExporterMasterKey"] != null)
      Interceptor.attach(this.addresses[this.module_name]["SslExpandExporterMasterKey"], {
        onEnter: function(args) {
          this.retkey = ptr(args[3]);
          this.client_random = client_randoms[this.threadId] || "???";
        },
        onLeave: function(retval) {
          var key = this.retkey.readPointer().add(16).readPointer().add(32).readPointer().add(16).readPointer().add(24).readPointer().readByteArray(48);
          keylog("EXPORTER_SECRET " + this.client_random + " " + buf2hex(key), TLSVersion.ONE_THREE);
        }
      });
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
    this.install_tls_keys_hook();
  }
};
function sspi_execute(moduleName, is_base_hook) {
  var sspi_ssl = new SSPI_Windows(moduleName, socket_library5, is_base_hook);
  sspi_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = sspi_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/windows/openssl_boringssl_windows.ts
var OpenSSL_BoringSSL_Windows = class extends OpenSSL_BoringSSL {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    let mapping = {};
    mapping[`${moduleName}`] = ["SSL_read", "SSL_write", "SSL_get_fd", "SSL_get_session", "SSL_SESSION_get_id", "SSL_new"];
    mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    super(moduleName, socket_library6, is_base_hook, mapping);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  /*
      SSL_CTX_set_keylog_callback not exported by default on windows.
  
      We need to find a way to install the callback function for doing that
  
      Alternatives?:SSL_export_keying_material, SSL_SESSION_get_master_key
      */
  install_tls_keys_callback_hook() {
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
  }
};
var OpenSSL_From_Python_Windows = class extends OpenSSL_BoringSSL {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    var library_method_mapping = {};
    library_method_mapping[`*${moduleName}*`] = ["SSL_CTX_set_keylog_callback", "SSL_CTX_new", "SSL_new", "SSL_get_SSL_CTX"];
    super(moduleName, socket_library6, is_base_hook, library_method_mapping);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  install_openssl_keys_callback_hook() {
    this.SSL_CTX_set_keylog_callback = new NativeFunction(this.addresses[this.module_name]["SSL_CTX_set_keylog_callback"], "void", ["pointer", "pointer"]);
    var instance = this;
    try {
      const ssl_new_ptr = this.addresses[this.module_name]["SSL_new"];
      const ssl_get_ctx_ptr = this.addresses[this.module_name]["SSL_get_SSL_CTX"];
      const set_keylog_cb_ptr = this.addresses[this.module_name]["SSL_CTX_set_keylog_callback"];
      if (!ssl_new_ptr || !ssl_get_ctx_ptr || !set_keylog_cb_ptr) {
        devlog_error(`Required functions not found in ${this.module_name}`);
        return;
      }
      const SSL_get_SSL_CTX = new NativeFunction(ssl_get_ctx_ptr, "pointer", ["pointer"]);
      Interceptor.attach(ssl_new_ptr, {
        onEnter(args) {
        },
        onLeave(retval) {
          if (retval.isNull()) {
            devlog_error("SSL_new returned NULL");
            return;
          }
          const ssl_ptr = retval;
          const ctx_ptr = SSL_get_SSL_CTX(ssl_ptr);
          if (ctx_ptr.isNull()) {
            devlog_error("SSL_get_SSL_CTX returned NULL");
            return;
          }
          try {
            devlog("Installing callback for OpenSSL_From_Python for module: " + instance.module_name);
            instance.SSL_CTX_set_keylog_callback(ctx_ptr, OpenSSL_BoringSSL.keylog_callback);
          } catch (e) {
            devlog_error(`Failed to set keylog callback: ${e}`);
          }
        }
      });
    } catch (e) {
      devlog_error(`Error hooking ${instance.module_name}: ${e}`);
    }
    Interceptor.attach(this.addresses[this.module_name]["SSL_CTX_set_keylog_callback"], {
      onEnter: function(args) {
        let callback_func = args[1];
        Interceptor.attach(callback_func, {
          onEnter: function(args2) {
            var message = {};
            message["contentType"] = "keylog";
            message["keylog"] = args2[1].readCString();
            send(message);
          }
        });
      }
    });
  }
  execute_hooks() {
    this.install_openssl_keys_callback_hook();
  }
};
function boring_execute5(moduleName, is_base_hook) {
  var boring_ssl = new OpenSSL_BoringSSL_Windows(moduleName, socket_library5, is_base_hook);
  boring_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = boring_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}
function ssl_python_execute3(moduleName, is_base_hook) {
  var openssl = new OpenSSL_From_Python_Windows(moduleName, socket_library5, is_base_hook);
  openssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = openssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/windows/gnutls_windows.ts
var GnuTLS_Windows = class extends GnuTLS {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
  }
  install_tls_keys_callback_hook() {
  }
};
function gnutls_execute3(moduleName, is_base_hook) {
  var gnu_ssl = new GnuTLS_Windows(moduleName, socket_library5, is_base_hook);
  gnu_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = gnu_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/windows/mbedTLS_windows.ts
var mbed_TLS_Windows = class extends mbed_TLS {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  /*
      SSL_CTX_set_keylog_callback not exported by default on windows.
  
      We need to find a way to install the callback function for doing that
  
      Alternatives?:SSL_export_keying_material, SSL_SESSION_get_master_key
      */
  install_tls_keys_callback_hook() {
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
  }
};
function mbedTLS_execute3(moduleName, is_base_hook) {
  var mbedTLS_ssl = new mbed_TLS_Windows(moduleName, socket_library5, is_base_hook);
  mbedTLS_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = mbedTLS_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/windows/nss_windows.ts
var NSS_Windows = class extends NSS {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    var library_method_mapping = {};
    library_method_mapping[`*${moduleName}*`] = ["PR_Write", "PR_Read", "PR_FileDesc2NativeHandle", "PR_GetPeerName", "PR_GetSockName", "PR_GetNameForIdentity"];
    library_method_mapping["*ssl*.dll"] = ["SSL_ImportFD", "SSL_GetSessionID", "SSL_HandshakeCallback"];
    super(moduleName, socket_library6, library_method_mapping);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  install_tls_keys_callback_hook() {
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
  }
};
function nss_execute3(moduleName, is_base_hook) {
  var nss_ssl = new NSS_Windows(moduleName, socket_library5, is_base_hook);
  nss_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = nss_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/windows/wolfssl_windows.ts
var WolfSSL_Windows = class extends WolfSSL {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    let mapping = {};
    mapping[`${moduleName}`] = ["wolfSSL_read", "wolfSSL_write", "wolfSSL_get_fd", "wolfSSL_get_session", "wolfSSL_connect", "wolfSSL_KeepArrays"];
    mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    super(moduleName, socket_library6, mapping);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  install_tls_keys_callback_hook() {
    log("Key extraction currently not implemented for windows!");
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
  }
};
function wolfssl_execute3(moduleName, is_base_hook) {
  var wolf_ssl = new WolfSSL_Windows(moduleName, socket_library5, is_base_hook);
  wolf_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = wolf_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/windows/matrixssl_windows.ts
var matrix_SSL_Windows = class extends matrix_SSL {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
    this.install_helper_hook();
  }
  install_tls_keys_callback_hook() {
  }
};
function matrixSSL_execute2(moduleName, is_base_hook) {
  var matrix_ssl = new matrix_SSL_Windows(moduleName, socket_library5, is_base_hook);
  matrix_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = matrix_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/windows/cronet_windows.ts
var Cronet_Windows = class extends Cronet {
  moduleName;
  socket_library;
  constructor(moduleName, socket_library6, is_base_hook) {
    super(moduleName, socket_library6, is_base_hook);
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
  }
  install_key_extraction_hook() {
    const cronetModule = Process.findModuleByName(this.module_name);
    const hooker = new PatternBasedHooking(cronetModule);
    if (isPatternReplaced()) {
      devlog("Hooking libcronet functions by pattern");
      hooker.hook_DumpKeys(this.module_name, "libcronet.dll", patterns, (args) => {
        this.dumpKeys(args[1], args[0], args[2]);
      });
    }
  }
  execute_hooks() {
    this.install_key_extraction_hook();
  }
};
function cronet_execute5(moduleName, is_base_hook) {
  var cronet = new Cronet_Windows(moduleName, socket_library5, is_base_hook);
  cronet.execute_hooks();
  if (is_base_hook) {
    const init_addresses = cronet.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/windows/lsass.ts
var keylog2 = (key, tlsVersion) => {
  devlog(`Exporting TLS 1.${tlsVersion} handshake keying material`);
  var message = {};
  message["contentType"] = "keylog";
  message["keylog"] = key;
  send(message);
};
var TLSVersion2;
(function(TLSVersion3) {
  TLSVersion3[TLSVersion3["ONE_TWO"] = 2] = "ONE_TWO";
  TLSVersion3[TLSVersion3["ONE_THREE"] = 3] = "ONE_THREE";
})(TLSVersion2 || (TLSVersion2 = {}));
var LSASS_Windows = class {
  moduleName;
  socket_library;
  // global variables
  library_method_mapping = {};
  addresses;
  module_name;
  constructor(moduleName, socket_library6, is_base_hook) {
    this.moduleName = moduleName;
    this.socket_library = socket_library6;
    log(`ncrypt.dll was loaded & will be hooked on Windows!`);
    this.library_method_mapping["*ncrypt*.dll"] = ["SslHashHandshake", "SslGenerateMasterKey", "SslImportMasterKey", "SslGenerateSessionKeys", "SslExpandExporterMasterKey", "SslExpandTrafficKeys"];
    this.library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl"];
    this.addresses = readAddresses(moduleName, this.library_method_mapping);
    this.module_name = moduleName;
  }
  install_plaintext_read_hook() {
  }
  install_plaintext_write_hook() {
  }
  install_tls_keys_hook() {
    var client_randoms = {};
    var buf2hex = function(buffer) {
      return Array.prototype.map.call(new Uint8Array(buffer), function(x) {
        return ("00" + x.toString(16)).slice(-2);
      }).join("");
    };
    var parse_h_master_key = function(pMasterKey) {
      var NcryptSslKey_ptr = pMasterKey;
      var ssl5_ptr = NcryptSslKey_ptr.add(16).readPointer();
      var master_key = ssl5_ptr.add(28).readByteArray(48);
      return buf2hex(master_key);
    };
    var parse_parameter_list = function(pParameterList, calling_func) {
      var buffer_count = pParameterList.add(4).readU32();
      var buffers = pParameterList.add(8).readPointer();
      for (var i = 0; i < buffer_count; i++) {
        var buf = buffers.add(16 * i);
        var buf_size = buf.readU32();
        var buf_type = buf.add(4).readU32();
        var buf_buf = buf.add(8).readPointer().readByteArray(buf_size);
        if (buf_type == 20) {
          devlog("Got client random from " + calling_func + "'s pParameterList: " + buf2hex(buf_buf));
          return buf2hex(buf_buf);
        }
      }
      return null;
    };
    if (this.addresses[this.module_name]["SslHashHandshake"] != null)
      Interceptor.attach(this.addresses[this.module_name]["SslHashHandshake"], {
        onEnter: function(args) {
          var buf = ptr(args[2]);
          var len = args[3].toInt32();
          var mem = buf.readByteArray(len);
          var msg_type = buf.readU8();
          var version = buf.add(4).readU16();
          if (msg_type == 1 && version == 771) {
            var crandom = buf2hex(buf.add(6).readByteArray(32));
            devlog("Got client random from SslHashHandshake: " + crandom);
            client_randoms[this.threadId] = crandom;
          }
        },
        onLeave: function(retval) {
        }
      });
    if (this.addresses[this.module_name]["SslGenerateMasterKey"] != null)
      Interceptor.attach(this.addresses[this.module_name]["SslGenerateMasterKey"], {
        onEnter: function(args) {
          this.phMasterKey = ptr(args[3]);
          this.hSslProvider = ptr(args[0]);
          this.pParameterList = ptr(args[6]);
          this.client_random = parse_parameter_list(this.pParameterList, "SslGenerateMasterKey") || client_randoms[this.threadId] || "???";
        },
        onLeave: function(retval) {
          var master_key = parse_h_master_key(this.phMasterKey.readPointer());
          devlog("Got masterkey from SslGenerateMasterKey");
          keylog2("CLIENT_RANDOM " + this.client_random + " " + master_key, TLSVersion2.ONE_TWO);
        }
      });
    if (this.addresses[this.module_name]["SslImportMasterKey"] != null)
      Interceptor.attach(this.addresses[this.module_name]["SslImportMasterKey"], {
        onEnter: function(args) {
          this.phMasterKey = ptr(args[2]);
          this.pParameterList = ptr(args[5]);
          this.client_random = parse_parameter_list(this.pParameterList, "SslImportMasterKey") || client_randoms[this.threadId] || "???";
        },
        onLeave: function(retval) {
          var master_key = parse_h_master_key(this.phMasterKey.readPointer());
          devlog("[*] Got masterkey from SslImportMasterKey");
          keylog2("CLIENT_RANDOM " + this.client_random + " " + master_key, TLSVersion2.ONE_TWO);
        }
      });
    if (this.addresses[this.module_name]["SslGenerateSessionKeys"] != null)
      Interceptor.attach(this.addresses[this.module_name]["SslGenerateSessionKeys"], {
        onEnter: function(args) {
          this.hMasterKey = ptr(args[1]);
          this.hSslProvider = ptr(args[0]);
          this.pParameterList = ptr(args[4]);
          this.client_random = parse_parameter_list(this.pParameterList, "SslGenerateSessionKeys") || client_randoms[this.threadId] || "???";
          var master_key = parse_h_master_key(this.hMasterKey);
          devlog("Got masterkey from SslGenerateSessionKeys");
          keylog2("CLIENT_RANDOM " + this.client_random + " " + master_key, TLSVersion2.ONE_TWO);
        },
        onLeave: function(retval) {
        }
      });
    var stages = {};
    var get_secret_from_BDDD = function(struct_BDDD) {
      var struct_3lss = struct_BDDD.add(16).readPointer();
      var struct_RUUU = struct_3lss.add(32).readPointer();
      var struct_YKSM = struct_RUUU.add(16).readPointer();
      var secret_ptr = struct_YKSM.add(24).readPointer();
      var size = struct_YKSM.add(16).readU32();
      return secret_ptr.readByteArray(size);
    };
    if (this.addresses[this.module_name]["SslExpandTrafficKeys"] != null)
      Interceptor.attach(this.addresses[this.module_name]["SslExpandTrafficKeys"], {
        onEnter: function(args) {
          this.retkey1 = ptr(args[3]);
          this.retkey2 = ptr(args[4]);
          this.client_random = client_randoms[this.threadId] || "???";
          if (stages[this.threadId]) {
            stages[this.threadId] = null;
            this.suffix = "TRAFFIC_SECRET_0";
          } else {
            stages[this.threadId] = "handshake";
            this.suffix = "HANDSHAKE_TRAFFIC_SECRET";
          }
        },
        onLeave: function(retval) {
          var key1 = get_secret_from_BDDD(this.retkey1.readPointer());
          var key2 = get_secret_from_BDDD(this.retkey2.readPointer());
          keylog2("CLIENT_" + this.suffix + " " + this.client_random + " " + buf2hex(key1), TLSVersion2.ONE_THREE);
          keylog2("SERVER_" + this.suffix + " " + this.client_random + " " + buf2hex(key2), TLSVersion2.ONE_THREE);
        }
      });
    if (this.addresses[this.module_name]["SslExpandExporterMasterKey"] != null)
      Interceptor.attach(this.addresses[this.module_name]["SslExpandExporterMasterKey"], {
        onEnter: function(args) {
          this.retkey = ptr(args[3]);
          this.client_random = client_randoms[this.threadId] || "???";
        },
        onLeave: function(retval) {
          var key = this.retkey.readPointer().add(16).readPointer().add(32).readPointer().add(16).readPointer().add(24).readPointer().readByteArray(48);
          keylog2("EXPORTER_SECRET " + this.client_random + " " + buf2hex(key), TLSVersion2.ONE_THREE);
        }
      });
  }
  execute_hooks() {
    this.install_plaintext_read_hook();
    this.install_plaintext_write_hook();
    this.install_tls_keys_hook();
  }
};
function lsass_execute(moduleName, is_base_hook) {
  var lsass_ssl = new LSASS_Windows(moduleName, socket_library5, is_base_hook);
  lsass_ssl.execute_hooks();
  if (is_base_hook) {
    const init_addresses = lsass_ssl.addresses[moduleName];
    if (Object.keys(init_addresses).length > 0) {
      globalThis.init_addresses[moduleName] = init_addresses;
    }
  }
}

// agent/windows/windows_agent.ts
var plattform_name5 = "windows";
var moduleNames5 = getModuleNames();
var socket_library5 = "WS2_32.dll";
function hook_Windows_Dynamic_Loader(module_library_mapping2, is_base_hook) {
  try {
    const resolver = new ApiResolver("module");
    var loadLibraryExW = resolver.enumerateMatches("exports:KERNELBASE.dll!*LoadLibraryExW");
    if (loadLibraryExW.length == 0)
      return console.log("[-] Missing windows dynamic loader!");
    Interceptor.attach(loadLibraryExW[0].address, {
      onLeave(retval) {
        let map = new ModuleMap();
        let moduleName = map.findName(retval);
        if (moduleName === null)
          return;
        for (let map2 of module_library_mapping2[plattform_name5]) {
          let regex = new RegExp(map2[0]);
          let func = map2[1];
          let optionalPath = map2[2];
          if (regex.test(moduleName)) {
            if (optionalPath) {
              try {
                const mod = Process.getModuleByName(this.moduleName);
                if (!mod.path.toLowerCase().includes(optionalPath.toLowerCase())) {
                  continue;
                }
              } catch (_) {
                continue;
              }
            }
            log(`${moduleName} was loaded & will be hooked on Windows!`);
            try {
              func(moduleName, is_base_hook);
            } catch (error_msg) {
              devlog(`Windows dynamic loader error: ${error_msg}`);
            }
            log("\n[*] Remember to hook the default SSL provider for the Windows API you have to hook lsass.exe\n");
          }
        }
      }
    });
    log("[*] Windows dynamic loader hooked.");
  } catch (error) {
    devlog("Loader error: " + error);
    log("No dynamic loader present for hooking.");
  }
}
function hook_Windows_SSL_Libs(module_library_mapping2, is_base_hook) {
  ssl_library_loader(plattform_name5, module_library_mapping2, moduleNames5, "Windows", is_base_hook);
}
function load_windows_hooking_agent() {
  module_library_mapping[plattform_name5] = [
    [/^(libssl|LIBSSL)-[0-9]+(_[0-9]+)?\.dll$/, invokeHookingFunction(boring_execute5)],
    [/^.*libssl.*\.dll$/, invokeHookingFunction(ssl_python_execute3), "python"],
    // Python-specific OpenSSL
    [/^.*(wolfssl|WOLFSSL).*\.dll$/, invokeHookingFunction(wolfssl_execute3)],
    [/^.*(libgnutls|LIBGNUTLS)-[0-9]+\.dll$/, invokeHookingFunction(gnutls_execute3)],
    [/^(nspr|NSPR)[0-9]*\.dll/, invokeHookingFunction(nss_execute3)],
    [/(sspicli|SSPICLI|SspiCli)\.dll$/, invokeHookingFunction(sspi_execute)],
    [/mbedTLS\.dll/, invokeHookingFunction(mbedTLS_execute3)],
    [/^.*(cronet|CRONET).*\.dll/, invokeHookingFunction(cronet_execute5)],
    ["/matrixSSL.dll", invokeHookingFunction(matrixSSL_execute2)]
  ];
  hook_Windows_SSL_Libs(module_library_mapping, true);
  hook_Windows_Dynamic_Loader(module_library_mapping, false);
}
function load_windows_lsass_agent() {
  devlog("Loading Windows LSASS agent...");
  module_library_mapping[plattform_name5] = [
    [/ncrypt*\.dll/, invokeHookingFunction(lsass_execute)],
    [/(sspicli|SSPICLI|SspiCli)\.dll$/, invokeHookingFunction(sspi_execute)]
  ];
  hook_Windows_SSL_Libs(module_library_mapping, true);
  hook_Windows_Dynamic_Loader(module_library_mapping, false);
}

// agent/util/anti_root.ts
var AntiRoot = class {
  RootPackages = [
    "com.noshufou.android.su",
    "com.noshufou.android.su.elite",
    "eu.chainfire.supersu",
    "com.koushikdutta.superuser",
    "com.thirdparty.superuser",
    "com.yellowes.su",
    "com.koushikdutta.rommanager",
    "com.koushikdutta.rommanager.license",
    "com.dimonvideo.luckypatcher",
    "com.chelpus.lackypatch",
    "com.ramdroid.appquarantine",
    "com.ramdroid.appquarantinepro",
    "com.devadvance.rootcloak",
    "com.devadvance.rootcloakplus",
    "de.robv.android.xposed.installer",
    "com.saurik.substrate",
    "com.zachspong.temprootremovejb",
    "com.amphoras.hidemyroot",
    "com.amphoras.hidemyrootadfree",
    "com.formyhm.hiderootPremium",
    "com.formyhm.hideroot",
    "me.phh.superuser",
    "eu.chainfire.supersu.pro",
    "com.kingouser.com",
    "com.topjohnwu.magisk"
  ];
  RootBinaries = ["su", "busybox", "supersu", "Superuser.apk", "KingoUser.apk", "SuperSu.apk", "magisk"];
  RootProperties = {
    "ro.build.selinux": "1",
    "ro.debuggable": "0",
    "service.adb.root": "0",
    "ro.secure": "1"
  };
  RootPropertiesKeys = [];
  addresses;
  module_name;
  library_method_mapping = {};
  constructor() {
    this.library_method_mapping["libc.so"] = ["strstr", "fopen", "system"];
    this.module_name = "libc.so";
    this.addresses = readAddresses(this.module_name, this.library_method_mapping);
    for (var k in this.RootProperties)
      this.RootPropertiesKeys.push(k);
  }
  java_based_bypasses() {
    Java.perform(function() {
      var PackageManager = Java.use("android.app.ApplicationPackageManager");
      var Runtime3 = Java.use("java.lang.Runtime");
      var NativeFile = Java.use("java.io.File");
      var String2 = Java.use("java.lang.String");
      var SystemProperties = Java.use("android.os.SystemProperties");
      var BufferedReader = Java.use("java.io.BufferedReader");
      var ProcessBuilder = Java.use("java.lang.ProcessBuilder");
      var StringBuffer = Java.use("java.lang.StringBuffer");
      var useKeyInfo = false;
      var useProcessManager = false;
      var ProcessManager = NULL;
      var loaded_classes = Java.enumerateLoadedClassesSync();
      devlog("Loaded " + loaded_classes.length + " classes!");
      devlog("loaded: " + loaded_classes.indexOf("java.lang.ProcessManager"));
      if (loaded_classes.indexOf("java.lang.ProcessManager") != -1) {
        try {
          useProcessManager = true;
          ProcessManager = Java.use("java.lang.ProcessManager");
        } catch (err) {
          devlog("ProcessManager Hook failed: " + err);
        }
      } else {
        devlog("ProcessManager hook not loaded");
      }
      var KeyInfo = NULL;
      if (loaded_classes.indexOf("android.security.keystore.KeyInfo") != -1) {
        try {
          useKeyInfo = true;
          KeyInfo = Java.use("android.security.keystore.KeyInfo");
        } catch (err) {
          log("KeyInfo Hook failed: " + err);
        }
      } else {
        log("KeyInfo hook not loaded");
      }
      PackageManager.getPackageInfo.overload("java.lang.String", "int").implementation = function(pname, flags) {
        var shouldFakePackage = this.RootPackages.indexOf(pname) > -1;
        if (shouldFakePackage) {
          log("Bypass root check for package: " + pname);
          pname = "set.package.name.to.a.fake.one.so.we.can.bypass.it";
        }
        return this.getPackageInfo.overload("java.lang.String", "int").call(this, pname, flags);
      };
      var exec = Runtime3.exec.overload("[Ljava.lang.String;");
      var exec1 = Runtime3.exec.overload("java.lang.String");
      var exec2 = Runtime3.exec.overload("java.lang.String", "[Ljava.lang.String;");
      var exec3 = Runtime3.exec.overload("[Ljava.lang.String;", "[Ljava.lang.String;");
      var exec4 = Runtime3.exec.overload("[Ljava.lang.String;", "[Ljava.lang.String;", "java.io.File");
      var exec5 = Runtime3.exec.overload("java.lang.String", "[Ljava.lang.String;", "java.io.File");
      exec5.implementation = function(cmd, env, dir) {
        if (cmd.indexOf("getprop") != -1 || cmd == "mount" || cmd.indexOf("build.prop") != -1 || cmd == "id" || cmd == "sh") {
          var fakeCmd = "grep";
          log("Bypass " + cmd + " command");
          return exec1.call(this, fakeCmd);
        }
        if (cmd == "su") {
          var fakeCmd = "awesome_tool";
          log("Bypass " + cmd + " command");
          return exec1.call(this, fakeCmd);
        }
        return exec5.call(this, cmd, env, dir);
      };
      exec4.implementation = function(cmdarr, env, file) {
        for (var i = 0; i < cmdarr.length; i = i + 1) {
          var tmp_cmd = cmdarr[i];
          if (tmp_cmd.indexOf("getprop") != -1 || tmp_cmd == "mount" || tmp_cmd.indexOf("build.prop") != -1 || tmp_cmd == "id" || tmp_cmd == "sh") {
            var fakeCmd = "grep";
            log("Bypass " + cmdarr + " command");
            return exec1.call(this, fakeCmd);
          }
          if (tmp_cmd == "su") {
            var fakeCmd = "awesome_tool";
            log("Bypass " + cmdarr + " command");
            return exec1.call(this, fakeCmd);
          }
        }
        return exec4.call(this, cmdarr, env, file);
      };
      exec3.implementation = function(cmdarr, envp) {
        for (var i = 0; i < cmdarr.length; i = i + 1) {
          var tmp_cmd = cmdarr[i];
          if (tmp_cmd.indexOf("getprop") != -1 || tmp_cmd == "mount" || tmp_cmd.indexOf("build.prop") != -1 || tmp_cmd == "id" || tmp_cmd == "sh") {
            var fakeCmd = "grep";
            log("Bypass " + cmdarr + " command");
            return exec1.call(this, fakeCmd);
          }
          if (tmp_cmd == "su") {
            var fakeCmd = "awesome_tool";
            log("Bypass " + cmdarr + " command");
            return exec1.call(this, fakeCmd);
          }
        }
        return exec3.call(this, cmdarr, envp);
      };
      exec2.implementation = function(cmd, env) {
        if (cmd.indexOf("getprop") != -1 || cmd == "mount" || cmd.indexOf("build.prop") != -1 || cmd == "id" || cmd == "sh") {
          var fakeCmd = "grep";
          log("Bypass " + cmd + " command");
          return exec1.call(this, fakeCmd);
        }
        if (cmd == "su") {
          var fakeCmd = "awesome_tool";
          log("Bypass " + cmd + " command");
          return exec1.call(this, fakeCmd);
        }
        return exec2.call(this, cmd, env);
      };
      exec.implementation = function(cmd) {
        for (var i = 0; i < cmd.length; i = i + 1) {
          var tmp_cmd = cmd[i];
          if (tmp_cmd.indexOf("getprop") != -1 || tmp_cmd == "mount" || tmp_cmd.indexOf("build.prop") != -1 || tmp_cmd == "id" || tmp_cmd == "sh") {
            var fakeCmd = "grep";
            log("Bypass " + cmd + " command");
            return exec1.call(this, fakeCmd);
          }
          if (tmp_cmd == "su") {
            var fakeCmd = "awesome_tool";
            log("Bypass " + cmd + " command");
            return exec1.call(this, fakeCmd);
          }
        }
        return exec.call(this, cmd);
      };
      exec1.implementation = function(cmd) {
        if (cmd.indexOf("getprop") != -1 || cmd == "mount" || cmd.indexOf("build.prop") != -1 || cmd == "id" || cmd == "sh") {
          var fakeCmd = "grep";
          log("Bypass " + cmd + " command");
          return exec1.call(this, fakeCmd);
        }
        if (cmd == "su") {
          var fakeCmd = "awesome_tool";
          log("Bypass " + cmd + " command");
          return exec1.call(this, fakeCmd);
        }
        return exec1.call(this, cmd);
      };
      String2.contains.implementation = function(name) {
        if (name == "test-keys") {
          log("Bypass test-keys check");
          return false;
        }
        return this.contains.call(this, name);
      };
      var get2 = SystemProperties.get.overload("java.lang.String");
      get2.implementation = function(name) {
        if (this.RootPropertiesKeys.indexOf(name) != -1) {
          log("Bypass " + name);
          return this.RootProperties[name];
        }
        return this.get.call(this, name);
      };
      BufferedReader.readLine.overload("boolean").implementation = function() {
        var text = this.readLine.overload("boolean").call(this);
        if (text === null) {
        } else {
          var shouldFakeRead = text.indexOf("ro.build.tags=test-keys") > -1;
          if (shouldFakeRead) {
            log("Bypass build.prop file read");
            text = text.replace("ro.build.tags=test-keys", "ro.build.tags=release-keys");
          }
        }
        return text;
      };
      var executeCommand = ProcessBuilder.command.overload("java.util.List");
      ProcessBuilder.start.implementation = function() {
        var cmd = this.command.call(this);
        var shouldModifyCommand = false;
        for (var i = 0; i < cmd.size(); i = i + 1) {
          var tmp_cmd = cmd.get(i).toString();
          if (tmp_cmd.indexOf("getprop") != -1 || tmp_cmd.indexOf("mount") != -1 || tmp_cmd.indexOf("build.prop") != -1 || tmp_cmd.indexOf("id") != -1) {
            shouldModifyCommand = true;
          }
        }
        if (shouldModifyCommand) {
          log("Bypass ProcessBuilder " + cmd);
          this.command.call(this, ["grep"]);
          return this.start.call(this);
        }
        if (cmd.indexOf("su") != -1) {
          log("Bypass ProcessBuilder " + cmd);
          this.command.call(this, ["awesome_tool"]);
          return this.start.call(this);
        }
        return this.start.call(this);
      };
      if (useProcessManager) {
        var ProcManExec = ProcessManager.exec.overload("[Ljava.lang.String;", "[Ljava.lang.String;", "java.io.File", "boolean");
        var ProcManExecVariant = ProcessManager.exec.overload("[Ljava.lang.String;", "[Ljava.lang.String;", "java.lang.String", "java.io.FileDescriptor", "java.io.FileDescriptor", "java.io.FileDescriptor", "boolean");
        ProcManExec.implementation = function(cmd, env, workdir, redirectstderr) {
          var fake_cmd = cmd;
          for (var i = 0; i < cmd.length; i = i + 1) {
            var tmp_cmd = cmd[i];
            if (tmp_cmd.indexOf("getprop") != -1 || tmp_cmd == "mount" || tmp_cmd.indexOf("build.prop") != -1 || tmp_cmd == "id") {
              var fake_cmd = ["grep"];
              log("Bypass " + cmd + " command");
            }
            if (tmp_cmd == "su") {
              var fake_cmd = ["awesome_tool"];
              log("Bypass " + cmd + " command");
            }
          }
          return ProcManExec.call(this, fake_cmd, env, workdir, redirectstderr);
        };
        ProcManExecVariant.implementation = function(cmd, env, directory, stdin, stdout, stderr, redirect) {
          var fake_cmd = cmd;
          for (var i = 0; i < cmd.length; i = i + 1) {
            var tmp_cmd = cmd[i];
            if (tmp_cmd.indexOf("getprop") != -1 || tmp_cmd == "mount" || tmp_cmd.indexOf("build.prop") != -1 || tmp_cmd == "id") {
              var fake_cmd = ["grep"];
              log("Bypass " + cmd + " command");
            }
            if (tmp_cmd == "su") {
              var fake_cmd = ["awesome_tool"];
              log("Bypass " + cmd + " command");
            }
          }
          return ProcManExecVariant.call(this, fake_cmd, env, directory, stdin, stdout, stderr, redirect);
        };
      }
      if (useKeyInfo) {
        KeyInfo.isInsideSecureHardware.implementation = function() {
          log("Bypass isInsideSecureHardware");
          return true;
        };
      }
    });
  }
  native_based_bypasses() {
    Interceptor.attach(this.addresses[this.module_name]["strstr"], {
      onEnter: function(args) {
        this.str_source = args[0];
        this.str_to_look_for = args[1];
        this.frida = Boolean(0);
        var haystack = this.str_source.readUtf8String();
        var needle = this.str_to_look_for.readUtf8String();
        if (haystack.indexOf("frida") != -1 || haystack.indexOf("xposed") != -1) {
          this.frida = Boolean(1);
        }
      },
      onLeave: function(retval) {
        if (this.frida) {
          retval.replace(ptr(0));
        }
        return retval;
      }
    });
    Interceptor.attach(this.addresses[this.module_name]["fopen"], {
      onEnter: function(args) {
        var path = args[0].readCString();
        var path_array = path.split("/");
        var executable = path_array[path_array.length - 1];
        var shouldFakeReturn = this.RootBinaries.indexOf(executable) > -1;
        if (shouldFakeReturn) {
          args[0].writeUtf8String("/notexists");
          log("Bypass native fopen");
        }
      },
      onLeave: function(retval) {
      }
    });
    Interceptor.attach(this.addresses[this.module_name]["system"], {
      onEnter: function(args) {
        var cmd = args[0].readCString();
        log("SYSTEM CMD: " + cmd);
        if (cmd.indexOf("getprop") != -1 || cmd == "mount" || cmd.indexOf("build.prop") != -1 || cmd == "id") {
          log("Bypass native system: " + cmd);
          args[0].writeUtf8String("grep");
        }
        if (cmd == "su") {
          log("Bypass native system: " + cmd);
          args[0].writeUtf8String("awesome_tool");
        }
      },
      onLeave: function(retval) {
      }
    });
  }
  execute_hooks() {
    this.java_based_bypasses();
    this.native_based_bypasses();
  }
};
function anti_root_execute() {
  var anti_root2 = new AntiRoot();
  anti_root2.execute_hooks();
}

// agent/misc/socket_tracer.ts
function has_valid_socket_type(fd) {
  var socktype = Socket.type(fd);
  if (socktype === "tcp" || socktype === "tcp6" || socktype === "udp" || socktype === "udp6") {
    if (socktype === "udp6" && ObjC.available) {
      return false;
    }
    return true;
  }
  return true;
}
function socket_trace_execute() {
  var socket_library6 = "";
  switch (Process.platform) {
    case "linux":
      socket_library6 = "libc";
      break;
    case "windows":
      socket_library6 = "WS2_32.dll";
      break;
    case "darwin":
      socket_library6 = "libSystem.B.dylib";
      break;
    default:
      log(`Platform "${Process.platform} currently not supported!`);
  }
  var library_method_mapping = {};
  const socketFDs = /* @__PURE__ */ new Map();
  if (ObjC.available) {
    library_method_mapping[`*${socket_library6}*`] = ["getpeername*", "getsockname*", "socket*", "ntohs*", "ntohl*", "recv*", "recvfrom*", "send*", "sendto*", "read*", "write*"];
  } else {
    library_method_mapping[`*${socket_library6}*`] = ["getpeername", "getsockname", "ntohs", "ntohl", "socket", "recv", "recvfrom", "send", "sendto", "read", "write", "connect"];
  }
  var addresses;
  addresses = readAddresses(socket_library6, library_method_mapping);
  if (!addresses[socket_library6] || !addresses[socket_library6]["socket"] || !addresses[socket_library6]["connect"]) {
    throw new Error(`Missing required functions in ${socket_library6}. Ensure "socket" and "connect" are exported by the library.`);
  }
  Interceptor.attach(addresses[socket_library6]["socket"], {
    onEnter: function(args) {
    },
    onLeave: function(retval) {
      this.fd = retval.toInt32();
      if (socketFDs.has(this.fd)) {
        return;
      }
      if (has_valid_socket_type(this.fd)) {
        var message = getPortsAndAddresses(this.fd, false, addresses[socket_library6], enable_default_fd);
        if (message === null) {
          return;
        }
        message["function"] = "Full_read";
        message["contentType"] = "netlog";
        socketFDs.set(this.fd, message["dst_addr"]);
        send(message);
      }
    }
  });
  Interceptor.attach(addresses[socket_library6]["connect"], {
    onEnter: function(args) {
      this.fd = args[0].toInt32();
    },
    onLeave: function(retval) {
      if (socketFDs.has(this.fd)) {
        return;
      }
      if (has_valid_socket_type(this.fd)) {
        var message = getPortsAndAddresses(this.fd, false, addresses[socket_library6], enable_default_fd);
        if (message === null) {
          return;
        }
        message["function"] = "Full_read";
        message["contentType"] = "netlog";
        socketFDs.set(this.fd, message["dst_addr"]);
        send(message);
      }
    }
  });
  Interceptor.attach(addresses[socket_library6]["read"], {
    onEnter: function(args) {
      this.fd = args[0].toInt32();
    },
    onLeave: function(retval) {
      if (socketFDs.has(this.fd)) {
        return;
      }
      if (has_valid_socket_type(this.fd)) {
        var message = getPortsAndAddresses(this.fd, true, addresses[socket_library6], enable_default_fd);
        if (message === null) {
          return;
        }
        message["function"] = "Full_read";
        message["contentType"] = "netlog";
        socketFDs.set(this.fd, message["src_addr"]);
        send(message);
      }
    }
  });
  Interceptor.attach(addresses[socket_library6]["recv"], {
    onEnter: function(args) {
      this.fd = args[0].toInt32();
    },
    onLeave: function(retval) {
      if (socketFDs.has(this.fd)) {
        return;
      }
      if (has_valid_socket_type(this.fd)) {
        var message = getPortsAndAddresses(this.fd, true, addresses[socket_library6], enable_default_fd);
        if (message === null) {
          return;
        }
        message["function"] = "Full_read";
        message["contentType"] = "netlog";
        socketFDs.set(this.fd, message["src_addr"]);
        send(message);
      }
    }
  });
  Interceptor.attach(addresses[socket_library6]["recvfrom"], {
    onEnter: function(args) {
      this.fd = args[0].toInt32();
    },
    onLeave: function(retval) {
      if (socketFDs.has(this.fd)) {
        return;
      }
      if (has_valid_socket_type(this.fd)) {
        var message = getPortsAndAddresses(this.fd, true, addresses[socket_library6], enable_default_fd);
        if (message === null) {
          return;
        }
        message["function"] = "Full_read";
        message["contentType"] = "netlog";
        socketFDs.set(this.fd, message["src_addr"]);
        send(message);
      }
    }
  });
  Interceptor.attach(addresses[socket_library6]["send"], {
    onEnter: function(args) {
      this.fd = args[0].toInt32();
    },
    onLeave: function(retval) {
      if (socketFDs.has(this.fd)) {
        return;
      }
      if (has_valid_socket_type(this.fd)) {
        var message = getPortsAndAddresses(this.fd, false, addresses[socket_library6], enable_default_fd);
        if (message === null) {
          return;
        }
        message["function"] = "Full_write";
        message["contentType"] = "netlog";
        socketFDs.set(this.fd, message["dst_addr"]);
        send(message);
      }
    }
  });
  Interceptor.attach(addresses[socket_library6]["sendto"], {
    onEnter: function(args) {
      this.fd = args[0].toInt32();
    },
    onLeave: function(retval) {
      if (socketFDs.has(this.fd)) {
        return;
      }
      if (has_valid_socket_type(this.fd)) {
        var message = getPortsAndAddresses(this.fd, false, addresses[socket_library6], enable_default_fd);
        if (message === null) {
          return;
        }
        message["function"] = "Full_write";
        message["contentType"] = "netlog";
        socketFDs.set(this.fd, message["dst_addr"]);
        send(message);
      }
    }
  });
  Interceptor.attach(addresses[socket_library6]["write"], {
    onEnter: function(args) {
      this.fd = args[0].toInt32();
    },
    onLeave: function(retval) {
      if (socketFDs.has(this.fd)) {
        return;
      }
      if (has_valid_socket_type(this.fd)) {
        var message = getPortsAndAddresses(this.fd, false, addresses[socket_library6], enable_default_fd);
        if (message === null) {
          return;
        }
        message["function"] = "Full_write";
        message["contentType"] = "netlog";
        socketFDs.set(this.fd, message["dst_addr"]);
        send(message);
      }
    }
  });
  if (ObjC.available) {
    Interceptor.attach(Process.getModuleByName("libsystem_kernel.dylib").getExportByName("write"), {
      onEnter: function(args) {
        var fd = args[0].toInt32();
        if (socketFDs.has(fd)) {
          return;
        }
        if (has_valid_socket_type(fd)) {
          var message = getPortsAndAddresses(fd, false, addresses[socket_library6], enable_default_fd);
          if (message === null) {
            return;
          }
          message["function"] = "Full_write";
          message["contentType"] = "netlog";
          socketFDs.set(this.fd, message["dst_addr"]);
          send(message);
        }
      },
      onLeave: function(retval) {
      }
    });
    Interceptor.attach(Process.getModuleByName("libsystem_kernel.dylib").getExportByName("read"), {
      onEnter: function(args) {
        this.fd = args[0].toInt32();
      },
      onLeave: function(retval) {
        if (socketFDs.has(this.fd)) {
          return;
        }
        if (has_valid_socket_type(this.fd)) {
          var message = getPortsAndAddresses(this.fd, true, addresses[socket_library6], enable_default_fd);
          if (message === null) {
            return;
          }
          message["function"] = "Full_read";
          message["contentType"] = "netlog";
          socketFDs.set(this.fd, message["src_addr"]);
          send(message);
        }
      }
    });
  }
}

// agent/ssl_log.ts
globalThis.init_addresses = {};
globalThis.global_counter = 0;
var offsets = "{OFFSETS}";
var experimental = false;
var enable_socket_tracing = false;
var anti_root = false;
var enable_default_fd = false;
var install_lsass_hook = true;
var patterns = "{PATTERNS}";
send("offset_hooking");
var enable_offset_based_hooking_state = recv("offset_hooking", (value) => {
  if (value.payload !== null && value.payload !== void 0) {
    offsets = value.payload;
  }
});
enable_offset_based_hooking_state.wait();
send("pattern_hooking");
var enable_pattern_based_hooking_state = recv("pattern_hooking", (value) => {
  if (value.payload !== null && value.payload !== void 0) {
    patterns = value.payload;
  }
});
enable_pattern_based_hooking_state.wait();
send("socket_tracing");
var enable_socket_tracing_state = recv("socket_tracing", (value) => {
  enable_socket_tracing = value.payload;
});
enable_socket_tracing_state.wait();
send("defaultFD");
var enable_default_fd_state = recv("defaultFD", (value) => {
  enable_default_fd = value.payload;
});
enable_default_fd_state.wait();
send("experimental");
var exp_recv_state = recv("experimental", (value) => {
  experimental = value.payload;
});
exp_recv_state.wait();
send("anti");
var antiroot_recv_state = recv("antiroot", (value) => {
  anti_root = value.payload;
});
antiroot_recv_state.wait();
function getOffsets() {
  return offsets;
}
function isPatternReplaced() {
  if (patterns === null) {
    return false;
  }
  return patterns.length > 10;
}
function load_os_specific_agent() {
  const platformInfo = getDetailedPlatformInfo();
  if (isWindows()) {
    log("Running Script on Windows");
    if (install_lsass_hook) {
      load_windows_lsass_agent();
    } else {
      log("Skipping LSASS hooking as per configuration");
    }
    load_windows_hooking_agent();
  } else if (isAndroid()) {
    log("Running Script on Android");
    if (anti_root) {
      log("Applying anti root checks");
      anti_root_execute();
    }
    if (enable_socket_tracing) {
      socket_trace_execute();
    }
    load_android_hooking_agent();
  } else if (isLinux()) {
    if (enable_socket_tracing) {
      socket_trace_execute();
    }
    log("Running Script on Linux");
    load_linux_hooking_agent();
  } else if (isiOS()) {
    if (enable_socket_tracing) {
      socket_trace_execute();
    }
    log("Running Script on iOS");
    load_ios_hooking_agent();
  } else if (isMacOS()) {
    if (enable_socket_tracing) {
      socket_trace_execute();
    }
    log("Running Script on MacOS");
    load_macos_hooking_agent();
  } else {
    log("Running Script on unknown platform");
    log(`Platform: ${Process.platform}, Architecture: ${Process.arch}`);
    log("Error: not supported platform!\nIf you want to have support for this platform please make an issue at our github page.");
    devlog(`[Unknown Platform] Full detection info: ${JSON.stringify(platformInfo, null, 2)}`);
  }
}
load_os_specific_agent();
export {
  anti_root,
  enable_default_fd,
  enable_socket_tracing,
  experimental,
  getOffsets,
  install_lsass_hook,
  isPatternReplaced,
  offsets,
  patterns
};

✄
{
  "version": 3,
  "sources": ["frida-shim:node_modules/@frida/base64-js/index.js", "frida-shim:node_modules/@frida/ieee754/index.js", "frida-shim:node_modules/@frida/buffer/index.js", "agent/shared/shared_structures.ts", "agent/util/log.ts", "node_modules/frida-java-bridge/lib/android.js", "node_modules/frida-java-bridge/lib/alloc.js", "node_modules/frida-java-bridge/lib/result.js", "node_modules/frida-java-bridge/lib/jvmti.js", "node_modules/frida-java-bridge/lib/machine-code.js", "node_modules/frida-java-bridge/lib/memoize.js", "node_modules/frida-java-bridge/lib/env.js", "node_modules/frida-java-bridge/lib/vm.js", "node_modules/frida-java-bridge/lib/jvm.js", "node_modules/frida-java-bridge/lib/api.js", "node_modules/frida-java-bridge/lib/class-model.js", "node_modules/frida-java-bridge/lib/lru.js", "node_modules/frida-java-bridge/lib/mkdex.js", "node_modules/frida-java-bridge/lib/types.js", "node_modules/frida-java-bridge/lib/class-factory.js", "node_modules/frida-java-bridge/index.js", "agent/shared/javalib.ts", "agent/shared/shared_functions.ts", "agent/shared/library_identification.ts", "agent/ssl_lib/gnutls.ts", "agent/android/gnutls_android.ts", "agent/ssl_lib/wolfssl.ts", "agent/android/wolfssl_android.ts", "agent/ssl_lib/nss.ts", "agent/android/nss_android.ts", "agent/ssl_lib/mbedTLS.ts", "agent/android/mbedTLS_android.ts", "node_modules/frida-objc-bridge/lib/api.js", "node_modules/frida-objc-bridge/lib/fastpaths.js", "node_modules/frida-objc-bridge/index.js", "agent/shared/objclib.ts", "agent/ssl_lib/openssl_boringssl.ts", "agent/android/openssl_boringssl_android.ts", "agent/android/bouncycastle.ts", "agent/util/process_infos.ts", "agent/android/conscrypt.ts", "agent/ssl_lib/java_ssl_libs.ts", "agent/android/android_java_tls_libs.ts", "agent/ssl_lib/cronet.ts", "agent/shared/pattern_based_hooking.ts", "agent/android/cronet_android.ts", "agent/ssl_lib/flutter.ts", "agent/android/flutter_android.ts", "agent/ssl_lib/s2ntls.ts", "agent/android/s2ntls_android.ts", "agent/ssl_lib/monobtls.ts", "agent/android/mono_btls_android.ts", "agent/ssl_lib/rustls.ts", "agent/android/rustls_android.ts", "agent/android/pattern_android.ts", "agent/ssl_lib/gotls.ts", "agent/android/gotls_android.ts", "agent/android/metartc.ts", "agent/android/android_agent.ts", "agent/ios/openssl_boringssl_ios.ts", "agent/ios/cronet_ios.ts", "agent/ios/flutter_ios.ts", "agent/ios/ios_agent.ts", "agent/macos/openssl_boringssl_macos.ts", "agent/macos/cronet_macos.ts", "agent/macos/macos_agent.ts", "agent/linux/gnutls_linux.ts", "agent/linux/wolfssl_linux.ts", "agent/linux/nss_linux.ts", "agent/linux/mbedTLS_linux.ts", "agent/linux/openssl_boringssl_linux.ts", "agent/ssl_lib/matrixssl.ts", "agent/linux/matrixssl_linux.ts", "agent/linux/s2ntls_linux.ts", "agent/linux/cronet_linux.ts", "agent/linux/rustls_linux.ts", "agent/linux/gotls_linux.ts", "agent/linux/linux_agent.ts", "agent/windows/sspi.ts", "agent/windows/openssl_boringssl_windows.ts", "agent/windows/gnutls_windows.ts", "agent/windows/mbedTLS_windows.ts", "agent/windows/nss_windows.ts", "agent/windows/wolfssl_windows.ts", "agent/windows/matrixssl_windows.ts", "agent/windows/cronet_windows.ts", "agent/windows/lsass.ts", "agent/windows/windows_agent.ts", "agent/util/anti_root.ts", "agent/misc/socket_tracer.ts", "agent/ssl_log.ts"],
  "mappings": ";;;;;;;AAAA,IAAM,SAAS,CAAC;AAChB,IAAM,YAAY,CAAC;AAEnB,IAAM,OAAO;AACb,SAAS,IAAI,GAAG,MAAM,KAAK,QAAQ,IAAI,KAAK,EAAE,GAAG;AAC/C,SAAO,CAAC,IAAI,KAAK,CAAC;AAClB,YAAU,KAAK,WAAW,CAAC,CAAC,IAAI;AAClC;AAIA,UAAU,IAAI,WAAW,CAAC,CAAC,IAAI;AAC/B,UAAU,IAAI,WAAW,CAAC,CAAC,IAAI;AAE/B,SAAS,QAAS,KAAK;AACrB,QAAM,MAAM,IAAI;AAEhB,MAAI,MAAM,IAAI,GAAG;AACf,UAAM,IAAI,MAAM,gDAAgD;AAAA,EAClE;AAIA,MAAI,WAAW,IAAI,QAAQ,GAAG;AAC9B,MAAI,aAAa,GAAI,YAAW;AAEhC,QAAM,kBAAkB,aAAa,MACjC,IACA,IAAK,WAAW;AAEpB,SAAO,CAAC,UAAU,eAAe;AACnC;AAUA,SAAS,YAAa,KAAK,UAAU,iBAAiB;AACpD,UAAS,WAAW,mBAAmB,IAAI,IAAK;AAClD;AAEO,SAAS,YAAa,KAAK;AAChC,QAAM,OAAO,QAAQ,GAAG;AACxB,QAAM,WAAW,KAAK,CAAC;AACvB,QAAM,kBAAkB,KAAK,CAAC;AAE9B,QAAM,MAAM,IAAI,WAAW,YAAY,KAAK,UAAU,eAAe,CAAC;AAEtE,MAAI,UAAU;AAGd,QAAM,MAAM,kBAAkB,IAC1B,WAAW,IACX;AAEJ,MAAI;AACJ,OAAK,IAAI,GAAG,IAAI,KAAK,KAAK,GAAG;AAC3B,UAAM,MACH,UAAU,IAAI,WAAW,CAAC,CAAC,KAAK,KAChC,UAAU,IAAI,WAAW,IAAI,CAAC,CAAC,KAAK,KACpC,UAAU,IAAI,WAAW,IAAI,CAAC,CAAC,KAAK,IACrC,UAAU,IAAI,WAAW,IAAI,CAAC,CAAC;AACjC,QAAI,SAAS,IAAK,OAAO,KAAM;AAC/B,QAAI,SAAS,IAAK,OAAO,IAAK;AAC9B,QAAI,SAAS,IAAI,MAAM;AAAA,EACzB;AAEA,MAAI,oBAAoB,GAAG;AACzB,UAAM,MACH,UAAU,IAAI,WAAW,CAAC,CAAC,KAAK,IAChC,UAAU,IAAI,WAAW,IAAI,CAAC,CAAC,KAAK;AACvC,QAAI,SAAS,IAAI,MAAM;AAAA,EACzB;AAEA,MAAI,oBAAoB,GAAG;AACzB,UAAM,MACH,UAAU,IAAI,WAAW,CAAC,CAAC,KAAK,KAChC,UAAU,IAAI,WAAW,IAAI,CAAC,CAAC,KAAK,IACpC,UAAU,IAAI,WAAW,IAAI,CAAC,CAAC,KAAK;AACvC,QAAI,SAAS,IAAK,OAAO,IAAK;AAC9B,QAAI,SAAS,IAAI,MAAM;AAAA,EACzB;AAEA,SAAO;AACT;AAEA,SAAS,gBAAiB,KAAK;AAC7B,SAAO,OAAO,OAAO,KAAK,EAAI,IAC5B,OAAO,OAAO,KAAK,EAAI,IACvB,OAAO,OAAO,IAAI,EAAI,IACtB,OAAO,MAAM,EAAI;AACrB;AAEA,SAAS,YAAa,OAAO,OAAO,KAAK;AACvC,QAAM,SAAS,CAAC;AAChB,WAAS,IAAI,OAAO,IAAI,KAAK,KAAK,GAAG;AACnC,UAAM,OACF,MAAM,CAAC,KAAK,KAAM,aAClB,MAAM,IAAI,CAAC,KAAK,IAAK,UACtB,MAAM,IAAI,CAAC,IAAI;AAClB,WAAO,KAAK,gBAAgB,GAAG,CAAC;AAAA,EAClC;AACA,SAAO,OAAO,KAAK,EAAE;AACvB;AAEO,SAAS,cAAe,OAAO;AACpC,QAAM,MAAM,MAAM;AAClB,QAAM,aAAa,MAAM;AACzB,QAAM,QAAQ,CAAC;AACf,QAAM,iBAAiB;AAGvB,WAAS,IAAI,GAAG,OAAO,MAAM,YAAY,IAAI,MAAM,KAAK,gBAAgB;AACtE,UAAM,KAAK,YAAY,OAAO,GAAI,IAAI,iBAAkB,OAAO,OAAQ,IAAI,cAAe,CAAC;AAAA,EAC7F;AAGA,MAAI,eAAe,GAAG;AACpB,UAAM,MAAM,MAAM,MAAM,CAAC;AACzB,UAAM;AAAA,MACJ,OAAO,OAAO,CAAC,IACf,OAAQ,OAAO,IAAK,EAAI,IACxB;AAAA,IACF;AAAA,EACF,WAAW,eAAe,GAAG;AAC3B,UAAM,OAAO,MAAM,MAAM,CAAC,KAAK,KAAK,MAAM,MAAM,CAAC;AACjD,UAAM;AAAA,MACJ,OAAO,OAAO,EAAE,IAChB,OAAQ,OAAO,IAAK,EAAI,IACxB,OAAQ,OAAO,IAAK,EAAI,IACxB;AAAA,IACF;AAAA,EACF;AAEA,SAAO,MAAM,KAAK,EAAE;AACtB;;;ACzIO,SAAS,KAAM,QAAQ,QAAQ,MAAM,MAAM,QAAQ;AACxD,MAAI,GAAGA;AACP,QAAM,OAAQ,SAAS,IAAK,OAAO;AACnC,QAAM,QAAQ,KAAK,QAAQ;AAC3B,QAAM,QAAQ,QAAQ;AACtB,MAAI,QAAQ;AACZ,MAAI,IAAI,OAAQ,SAAS,IAAK;AAC9B,QAAM,IAAI,OAAO,KAAK;AACtB,MAAI,IAAI,OAAO,SAAS,CAAC;AAEzB,OAAK;AAEL,MAAI,KAAM,KAAM,CAAC,SAAU;AAC3B,QAAO,CAAC;AACR,WAAS;AACT,SAAO,QAAQ,GAAG;AAChB,QAAK,IAAI,MAAO,OAAO,SAAS,CAAC;AACjC,SAAK;AACL,aAAS;AAAA,EACX;AAEA,EAAAA,KAAI,KAAM,KAAM,CAAC,SAAU;AAC3B,QAAO,CAAC;AACR,WAAS;AACT,SAAO,QAAQ,GAAG;AAChB,IAAAA,KAAKA,KAAI,MAAO,OAAO,SAAS,CAAC;AACjC,SAAK;AACL,aAAS;AAAA,EACX;AAEA,MAAI,MAAM,GAAG;AACX,QAAI,IAAI;AAAA,EACV,WAAW,MAAM,MAAM;AACrB,WAAOA,KAAI,OAAQ,IAAI,KAAK,KAAK;AAAA,EACnC,OAAO;AACL,IAAAA,KAAIA,KAAI,KAAK,IAAI,GAAG,IAAI;AACxB,QAAI,IAAI;AAAA,EACV;AACA,UAAQ,IAAI,KAAK,KAAKA,KAAI,KAAK,IAAI,GAAG,IAAI,IAAI;AAChD;AAEO,SAAS,MAAO,QAAQ,OAAO,QAAQ,MAAM,MAAM,QAAQ;AAChE,MAAI,GAAGA,IAAG;AACV,MAAI,OAAQ,SAAS,IAAK,OAAO;AACjC,QAAM,QAAQ,KAAK,QAAQ;AAC3B,QAAM,QAAQ,QAAQ;AACtB,QAAM,KAAM,SAAS,KAAK,KAAK,IAAI,GAAG,GAAG,IAAI,KAAK,IAAI,GAAG,GAAG,IAAI;AAChE,MAAI,IAAI,OAAO,IAAK,SAAS;AAC7B,QAAM,IAAI,OAAO,IAAI;AACrB,QAAM,IAAI,QAAQ,KAAM,UAAU,KAAK,IAAI,QAAQ,IAAK,IAAI;AAE5D,UAAQ,KAAK,IAAI,KAAK;AAEtB,MAAI,MAAM,KAAK,KAAK,UAAU,UAAU;AACtC,IAAAA,KAAI,MAAM,KAAK,IAAI,IAAI;AACvB,QAAI;AAAA,EACN,OAAO;AACL,QAAI,KAAK,MAAM,KAAK,IAAI,KAAK,IAAI,KAAK,GAAG;AACzC,QAAI,SAAS,IAAI,KAAK,IAAI,GAAG,CAAC,CAAC,KAAK,GAAG;AACrC;AACA,WAAK;AAAA,IACP;AACA,QAAI,IAAI,SAAS,GAAG;AAClB,eAAS,KAAK;AAAA,IAChB,OAAO;AACL,eAAS,KAAK,KAAK,IAAI,GAAG,IAAI,KAAK;AAAA,IACrC;AACA,QAAI,QAAQ,KAAK,GAAG;AAClB;AACA,WAAK;AAAA,IACP;AAEA,QAAI,IAAI,SAAS,MAAM;AACrB,MAAAA,KAAI;AACJ,UAAI;AAAA,IACN,WAAW,IAAI,SAAS,GAAG;AACzB,MAAAA,MAAM,QAAQ,IAAK,KAAK,KAAK,IAAI,GAAG,IAAI;AACxC,UAAI,IAAI;AAAA,IACV,OAAO;AACL,MAAAA,KAAI,QAAQ,KAAK,IAAI,GAAG,QAAQ,CAAC,IAAI,KAAK,IAAI,GAAG,IAAI;AACrD,UAAI;AAAA,IACN;AAAA,EACF;AAEA,SAAO,QAAQ,GAAG;AAChB,WAAO,SAAS,CAAC,IAAIA,KAAI;AACzB,SAAK;AACL,IAAAA,MAAK;AACL,YAAQ;AAAA,EACV;AAEA,MAAK,KAAK,OAAQA;AAClB,UAAQ;AACR,SAAO,OAAO,GAAG;AACf,WAAO,SAAS,CAAC,IAAI,IAAI;AACzB,SAAK;AACL,SAAK;AACL,YAAQ;AAAA,EACV;AAEA,SAAO,SAAS,IAAI,CAAC,KAAK,IAAI;AAChC;;;AC5FO,IAAM,SAAS;AAAA,EACpB,mBAAmB;AACrB;AAEA,IAAM,eAAe;AAGrBC,QAAO,sBAAsB;AAE7B,OAAO,eAAeA,QAAO,WAAW,UAAU;AAAA,EAChD,YAAY;AAAA,EACZ,KAAK,WAAY;AACf,QAAI,CAACA,QAAO,SAAS,IAAI,EAAG,QAAO;AACnC,WAAO,KAAK;AAAA,EACd;AACF,CAAC;AAED,OAAO,eAAeA,QAAO,WAAW,UAAU;AAAA,EAChD,YAAY;AAAA,EACZ,KAAK,WAAY;AACf,QAAI,CAACA,QAAO,SAAS,IAAI,EAAG,QAAO;AACnC,WAAO,KAAK;AAAA,EACd;AACF,CAAC;AAED,SAAS,aAAc,QAAQ;AAC7B,MAAI,SAAS,cAAc;AACzB,UAAM,IAAI,WAAW,gBAAgB,SAAS,gCAAgC;AAAA,EAChF;AAEA,QAAM,MAAM,IAAI,WAAW,MAAM;AACjC,SAAO,eAAe,KAAKA,QAAO,SAAS;AAC3C,SAAO;AACT;AAYO,SAASA,QAAQ,KAAK,kBAAkB,QAAQ;AAErD,MAAI,OAAO,QAAQ,UAAU;AAC3B,QAAI,OAAO,qBAAqB,UAAU;AACxC,YAAM,IAAI;AAAA,QACR;AAAA,MACF;AAAA,IACF;AACA,WAAO,YAAY,GAAG;AAAA,EACxB;AACA,SAAO,KAAK,KAAK,kBAAkB,MAAM;AAC3C;AAEAA,QAAO,WAAW;AAElB,SAAS,KAAM,OAAO,kBAAkB,QAAQ;AAC9C,MAAI,OAAO,UAAU,UAAU;AAC7B,WAAO,WAAW,OAAO,gBAAgB;AAAA,EAC3C;AAEA,MAAI,YAAY,OAAO,KAAK,GAAG;AAC7B,WAAO,cAAc,KAAK;AAAA,EAC5B;AAEA,MAAI,SAAS,MAAM;AACjB,UAAM,IAAI;AAAA,MACR,oHAC0C,OAAO;AAAA,IACnD;AAAA,EACF;AAEA,MAAI,iBAAiB,eAChB,SAAS,MAAM,kBAAkB,aAAc;AAClD,WAAO,gBAAgB,OAAO,kBAAkB,MAAM;AAAA,EACxD;AAEA,MAAI,iBAAiB,qBAChB,SAAS,MAAM,kBAAkB,mBAAoB;AACxD,WAAO,gBAAgB,OAAO,kBAAkB,MAAM;AAAA,EACxD;AAEA,MAAI,OAAO,UAAU,UAAU;AAC7B,UAAM,IAAI;AAAA,MACR;AAAA,IACF;AAAA,EACF;AAEA,QAAM,UAAU,MAAM,WAAW,MAAM,QAAQ;AAC/C,MAAI,WAAW,QAAQ,YAAY,OAAO;AACxC,WAAOA,QAAO,KAAK,SAAS,kBAAkB,MAAM;AAAA,EACtD;AAEA,QAAM,IAAI,WAAW,KAAK;AAC1B,MAAI,EAAG,QAAO;AAEd,MAAI,OAAO,WAAW,eAAe,OAAO,eAAe,QACvD,OAAO,MAAM,OAAO,WAAW,MAAM,YAAY;AACnD,WAAOA,QAAO,KAAK,MAAM,OAAO,WAAW,EAAE,QAAQ,GAAG,kBAAkB,MAAM;AAAA,EAClF;AAEA,QAAM,IAAI;AAAA,IACR,oHAC0C,OAAO;AAAA,EACnD;AACF;AAUAA,QAAO,OAAO,SAAU,OAAO,kBAAkB,QAAQ;AACvD,SAAO,KAAK,OAAO,kBAAkB,MAAM;AAC7C;AAIA,OAAO,eAAeA,QAAO,WAAW,WAAW,SAAS;AAC5D,OAAO,eAAeA,SAAQ,UAAU;AAExC,SAAS,WAAY,MAAM;AACzB,MAAI,OAAO,SAAS,UAAU;AAC5B,UAAM,IAAI,UAAU,wCAAwC;AAAA,EAC9D,WAAW,OAAO,GAAG;AACnB,UAAM,IAAI,WAAW,gBAAgB,OAAO,gCAAgC;AAAA,EAC9E;AACF;AAEA,SAAS,MAAO,MAAMC,OAAM,UAAU;AACpC,aAAW,IAAI;AACf,MAAI,QAAQ,GAAG;AACb,WAAO,aAAa,IAAI;AAAA,EAC1B;AACA,MAAIA,UAAS,QAAW;AAItB,WAAO,OAAO,aAAa,WACvB,aAAa,IAAI,EAAE,KAAKA,OAAM,QAAQ,IACtC,aAAa,IAAI,EAAE,KAAKA,KAAI;AAAA,EAClC;AACA,SAAO,aAAa,IAAI;AAC1B;AAMAD,QAAO,QAAQ,SAAU,MAAMC,OAAM,UAAU;AAC7C,SAAO,MAAM,MAAMA,OAAM,QAAQ;AACnC;AAEA,SAAS,YAAa,MAAM;AAC1B,aAAW,IAAI;AACf,SAAO,aAAa,OAAO,IAAI,IAAI,QAAQ,IAAI,IAAI,CAAC;AACtD;AAKAD,QAAO,cAAc,SAAU,MAAM;AACnC,SAAO,YAAY,IAAI;AACzB;AAIAA,QAAO,kBAAkB,SAAU,MAAM;AACvC,SAAO,YAAY,IAAI;AACzB;AAEA,SAAS,WAAY,QAAQ,UAAU;AACrC,MAAI,OAAO,aAAa,YAAY,aAAa,IAAI;AACnD,eAAW;AAAA,EACb;AAEA,MAAI,CAACA,QAAO,WAAW,QAAQ,GAAG;AAChC,UAAM,IAAI,UAAU,uBAAuB,QAAQ;AAAA,EACrD;AAEA,QAAM,SAAS,WAAW,QAAQ,QAAQ,IAAI;AAC9C,MAAI,MAAM,aAAa,MAAM;AAE7B,QAAM,SAAS,IAAI,MAAM,QAAQ,QAAQ;AAEzC,MAAI,WAAW,QAAQ;AAIrB,UAAM,IAAI,MAAM,GAAG,MAAM;AAAA,EAC3B;AAEA,SAAO;AACT;AAEA,SAAS,cAAe,OAAO;AAC7B,QAAM,SAAS,MAAM,SAAS,IAAI,IAAI,QAAQ,MAAM,MAAM,IAAI;AAC9D,QAAM,MAAM,aAAa,MAAM;AAC/B,WAAS,IAAI,GAAG,IAAI,QAAQ,KAAK,GAAG;AAClC,QAAI,CAAC,IAAI,MAAM,CAAC,IAAI;AAAA,EACtB;AACA,SAAO;AACT;AAEA,SAAS,cAAe,WAAW;AACjC,MAAI,qBAAqB,YAAY;AACnC,UAAME,QAAO,IAAI,WAAW,SAAS;AACrC,WAAO,gBAAgBA,MAAK,QAAQA,MAAK,YAAYA,MAAK,UAAU;AAAA,EACtE;AACA,SAAO,cAAc,SAAS;AAChC;AAEA,SAAS,gBAAiB,OAAO,YAAY,QAAQ;AACnD,MAAI,aAAa,KAAK,MAAM,aAAa,YAAY;AACnD,UAAM,IAAI,WAAW,sCAAsC;AAAA,EAC7D;AAEA,MAAI,MAAM,aAAa,cAAc,UAAU,IAAI;AACjD,UAAM,IAAI,WAAW,sCAAsC;AAAA,EAC7D;AAEA,MAAI;AACJ,MAAI,eAAe,UAAa,WAAW,QAAW;AACpD,UAAM,IAAI,WAAW,KAAK;AAAA,EAC5B,WAAW,WAAW,QAAW;AAC/B,UAAM,IAAI,WAAW,OAAO,UAAU;AAAA,EACxC,OAAO;AACL,UAAM,IAAI,WAAW,OAAO,YAAY,MAAM;AAAA,EAChD;AAGA,SAAO,eAAe,KAAKF,QAAO,SAAS;AAE3C,SAAO;AACT;AAEA,SAAS,WAAY,KAAK;AACxB,MAAIA,QAAO,SAAS,GAAG,GAAG;AACxB,UAAM,MAAM,QAAQ,IAAI,MAAM,IAAI;AAClC,UAAM,MAAM,aAAa,GAAG;AAE5B,QAAI,IAAI,WAAW,GAAG;AACpB,aAAO;AAAA,IACT;AAEA,QAAI,KAAK,KAAK,GAAG,GAAG,GAAG;AACvB,WAAO;AAAA,EACT;AAEA,MAAI,IAAI,WAAW,QAAW;AAC5B,QAAI,OAAO,IAAI,WAAW,YAAY,OAAO,MAAM,IAAI,MAAM,GAAG;AAC9D,aAAO,aAAa,CAAC;AAAA,IACvB;AACA,WAAO,cAAc,GAAG;AAAA,EAC1B;AAEA,MAAI,IAAI,SAAS,YAAY,MAAM,QAAQ,IAAI,IAAI,GAAG;AACpD,WAAO,cAAc,IAAI,IAAI;AAAA,EAC/B;AACF;AAEA,SAAS,QAAS,QAAQ;AAGxB,MAAI,UAAU,cAAc;AAC1B,UAAM,IAAI,WAAW,4DACa,aAAa,SAAS,EAAE,IAAI,QAAQ;AAAA,EACxE;AACA,SAAO,SAAS;AAClB;AASAG,QAAO,WAAW,SAAS,SAAU,GAAG;AACtC,SAAO,KAAK,QAAQ,EAAE,cAAc,QAClC,MAAMA,QAAO;AACjB;AAEAA,QAAO,UAAU,SAAS,QAAS,GAAG,GAAG;AACvC,MAAI,aAAa,WAAY,KAAIA,QAAO,KAAK,GAAG,EAAE,QAAQ,EAAE,UAAU;AACtE,MAAI,aAAa,WAAY,KAAIA,QAAO,KAAK,GAAG,EAAE,QAAQ,EAAE,UAAU;AACtE,MAAI,CAACA,QAAO,SAAS,CAAC,KAAK,CAACA,QAAO,SAAS,CAAC,GAAG;AAC9C,UAAM,IAAI;AAAA,MACR;AAAA,IACF;AAAA,EACF;AAEA,MAAI,MAAM,EAAG,QAAO;AAEpB,MAAI,IAAI,EAAE;AACV,MAAI,IAAI,EAAE;AAEV,WAAS,IAAI,GAAG,MAAM,KAAK,IAAI,GAAG,CAAC,GAAG,IAAI,KAAK,EAAE,GAAG;AAClD,QAAI,EAAE,CAAC,MAAM,EAAE,CAAC,GAAG;AACjB,UAAI,EAAE,CAAC;AACP,UAAI,EAAE,CAAC;AACP;AAAA,IACF;AAAA,EACF;AAEA,MAAI,IAAI,EAAG,QAAO;AAClB,MAAI,IAAI,EAAG,QAAO;AAClB,SAAO;AACT;AAEAA,QAAO,aAAa,SAAS,WAAY,UAAU;AACjD,UAAQ,OAAO,QAAQ,EAAE,YAAY,GAAG;AAAA,IACtC,KAAK;AAAA,IACL,KAAK;AAAA,IACL,KAAK;AAAA,IACL,KAAK;AAAA,IACL,KAAK;AAAA,IACL,KAAK;AAAA,IACL,KAAK;AAAA,IACL,KAAK;AAAA,IACL,KAAK;AAAA,IACL,KAAK;AAAA,IACL,KAAK;AACH,aAAO;AAAA,IACT;AACE,aAAO;AAAA,EACX;AACF;AAEAA,QAAO,SAAS,SAAS,OAAQ,MAAM,QAAQ;AAC7C,MAAI,CAAC,MAAM,QAAQ,IAAI,GAAG;AACxB,UAAM,IAAI,UAAU,6CAA6C;AAAA,EACnE;AAEA,MAAI,KAAK,WAAW,GAAG;AACrB,WAAOA,QAAO,MAAM,CAAC;AAAA,EACvB;AAEA,MAAI;AACJ,MAAI,WAAW,QAAW;AACxB,aAAS;AACT,SAAK,IAAI,GAAG,IAAI,KAAK,QAAQ,EAAE,GAAG;AAChC,gBAAU,KAAK,CAAC,EAAE;AAAA,IACpB;AAAA,EACF;AAEA,QAAM,SAASA,QAAO,YAAY,MAAM;AACxC,MAAI,MAAM;AACV,OAAK,IAAI,GAAG,IAAI,KAAK,QAAQ,EAAE,GAAG;AAChC,QAAI,MAAM,KAAK,CAAC;AAChB,QAAI,eAAe,YAAY;AAC7B,UAAI,MAAM,IAAI,SAAS,OAAO,QAAQ;AACpC,YAAI,CAACA,QAAO,SAAS,GAAG,GAAG;AACzB,gBAAMA,QAAO,KAAK,IAAI,QAAQ,IAAI,YAAY,IAAI,UAAU;AAAA,QAC9D;AACA,YAAI,KAAK,QAAQ,GAAG;AAAA,MACtB,OAAO;AACL,mBAAW,UAAU,IAAI;AAAA,UACvB;AAAA,UACA;AAAA,UACA;AAAA,QACF;AAAA,MACF;AAAA,IACF,WAAW,CAACA,QAAO,SAAS,GAAG,GAAG;AAChC,YAAM,IAAI,UAAU,6CAA6C;AAAA,IACnE,OAAO;AACL,UAAI,KAAK,QAAQ,GAAG;AAAA,IACtB;AACA,WAAO,IAAI;AAAA,EACb;AACA,SAAO;AACT;AAEA,SAAS,WAAY,QAAQ,UAAU;AACrC,MAAIA,QAAO,SAAS,MAAM,GAAG;AAC3B,WAAO,OAAO;AAAA,EAChB;AACA,MAAI,YAAY,OAAO,MAAM,KAAK,kBAAkB,aAAa;AAC/D,WAAO,OAAO;AAAA,EAChB;AACA,MAAI,OAAO,WAAW,UAAU;AAC9B,UAAM,IAAI;AAAA,MACR,6FACmB,OAAO;AAAA,IAC5B;AAAA,EACF;AAEA,QAAM,MAAM,OAAO;AACnB,QAAM,YAAa,UAAU,SAAS,KAAK,UAAU,CAAC,MAAM;AAC5D,MAAI,CAAC,aAAa,QAAQ,EAAG,QAAO;AAGpC,MAAI,cAAc;AAClB,aAAS;AACP,YAAQ,UAAU;AAAA,MAChB,KAAK;AAAA,MACL,KAAK;AAAA,MACL,KAAK;AACH,eAAO;AAAA,MACT,KAAK;AAAA,MACL,KAAK;AACH,eAAO,YAAY,MAAM,EAAE;AAAA,MAC7B,KAAK;AAAA,MACL,KAAK;AAAA,MACL,KAAK;AAAA,MACL,KAAK;AACH,eAAO,MAAM;AAAA,MACf,KAAK;AACH,eAAO,QAAQ;AAAA,MACjB,KAAK;AACH,eAAO,cAAc,MAAM,EAAE;AAAA,MAC/B;AACE,YAAI,aAAa;AACf,iBAAO,YAAY,KAAK,YAAY,MAAM,EAAE;AAAA,QAC9C;AACA,oBAAY,KAAK,UAAU,YAAY;AACvC,sBAAc;AAAA,IAClB;AAAA,EACF;AACF;AACAA,QAAO,aAAa;AAEpB,SAAS,aAAc,UAAU,OAAO,KAAK;AAC3C,MAAI,cAAc;AASlB,MAAI,UAAU,UAAa,QAAQ,GAAG;AACpC,YAAQ;AAAA,EACV;AAGA,MAAI,QAAQ,KAAK,QAAQ;AACvB,WAAO;AAAA,EACT;AAEA,MAAI,QAAQ,UAAa,MAAM,KAAK,QAAQ;AAC1C,UAAM,KAAK;AAAA,EACb;AAEA,MAAI,OAAO,GAAG;AACZ,WAAO;AAAA,EACT;AAGA,WAAS;AACT,aAAW;AAEX,MAAI,OAAO,OAAO;AAChB,WAAO;AAAA,EACT;AAEA,MAAI,CAAC,SAAU,YAAW;AAE1B,SAAO,MAAM;AACX,YAAQ,UAAU;AAAA,MAChB,KAAK;AACH,eAAO,SAAS,MAAM,OAAO,GAAG;AAAA,MAElC,KAAK;AAAA,MACL,KAAK;AACH,eAAO,UAAU,MAAM,OAAO,GAAG;AAAA,MAEnC,KAAK;AACH,eAAO,WAAW,MAAM,OAAO,GAAG;AAAA,MAEpC,KAAK;AAAA,MACL,KAAK;AACH,eAAO,YAAY,MAAM,OAAO,GAAG;AAAA,MAErC,KAAK;AACH,eAAO,YAAY,MAAM,OAAO,GAAG;AAAA,MAErC,KAAK;AAAA,MACL,KAAK;AAAA,MACL,KAAK;AAAA,MACL,KAAK;AACH,eAAO,aAAa,MAAM,OAAO,GAAG;AAAA,MAEtC;AACE,YAAI,YAAa,OAAM,IAAI,UAAU,uBAAuB,QAAQ;AACpE,oBAAY,WAAW,IAAI,YAAY;AACvC,sBAAc;AAAA,IAClB;AAAA,EACF;AACF;AAQAA,QAAO,UAAU,YAAY;AAE7B,SAAS,KAAM,GAAG,GAAGC,IAAG;AACtB,QAAM,IAAI,EAAE,CAAC;AACb,IAAE,CAAC,IAAI,EAAEA,EAAC;AACV,IAAEA,EAAC,IAAI;AACT;AAEAD,QAAO,UAAU,SAAS,SAAS,SAAU;AAC3C,QAAM,MAAM,KAAK;AACjB,MAAI,MAAM,MAAM,GAAG;AACjB,UAAM,IAAI,WAAW,2CAA2C;AAAA,EAClE;AACA,WAAS,IAAI,GAAG,IAAI,KAAK,KAAK,GAAG;AAC/B,SAAK,MAAM,GAAG,IAAI,CAAC;AAAA,EACrB;AACA,SAAO;AACT;AAEAA,QAAO,UAAU,SAAS,SAAS,SAAU;AAC3C,QAAM,MAAM,KAAK;AACjB,MAAI,MAAM,MAAM,GAAG;AACjB,UAAM,IAAI,WAAW,2CAA2C;AAAA,EAClE;AACA,WAAS,IAAI,GAAG,IAAI,KAAK,KAAK,GAAG;AAC/B,SAAK,MAAM,GAAG,IAAI,CAAC;AACnB,SAAK,MAAM,IAAI,GAAG,IAAI,CAAC;AAAA,EACzB;AACA,SAAO;AACT;AAEAA,QAAO,UAAU,SAAS,SAAS,SAAU;AAC3C,QAAM,MAAM,KAAK;AACjB,MAAI,MAAM,MAAM,GAAG;AACjB,UAAM,IAAI,WAAW,2CAA2C;AAAA,EAClE;AACA,WAAS,IAAI,GAAG,IAAI,KAAK,KAAK,GAAG;AAC/B,SAAK,MAAM,GAAG,IAAI,CAAC;AACnB,SAAK,MAAM,IAAI,GAAG,IAAI,CAAC;AACvB,SAAK,MAAM,IAAI,GAAG,IAAI,CAAC;AACvB,SAAK,MAAM,IAAI,GAAG,IAAI,CAAC;AAAA,EACzB;AACA,SAAO;AACT;AAEAA,QAAO,UAAU,WAAW,SAAS,WAAY;AAC/C,QAAM,SAAS,KAAK;AACpB,MAAI,WAAW,EAAG,QAAO;AACzB,MAAI,UAAU,WAAW,EAAG,QAAO,UAAU,MAAM,GAAG,MAAM;AAC5D,SAAO,aAAa,MAAM,MAAM,SAAS;AAC3C;AAEAA,QAAO,UAAU,iBAAiBA,QAAO,UAAU;AAEnDA,QAAO,UAAU,SAAS,SAAS,OAAQ,GAAG;AAC5C,MAAI,CAACA,QAAO,SAAS,CAAC,EAAG,OAAM,IAAI,UAAU,2BAA2B;AACxE,MAAI,SAAS,EAAG,QAAO;AACvB,SAAOA,QAAO,QAAQ,MAAM,CAAC,MAAM;AACrC;AAEAA,QAAO,UAAU,UAAU,SAAS,UAAW;AAC7C,MAAI,MAAM;AACV,QAAM,MAAM,OAAO;AACnB,QAAM,KAAK,SAAS,OAAO,GAAG,GAAG,EAAE,QAAQ,WAAW,KAAK,EAAE,KAAK;AAClE,MAAI,KAAK,SAAS,IAAK,QAAO;AAC9B,SAAO,aAAa,MAAM;AAC5B;AACAA,QAAO,UAAU,OAAO,IAAI,4BAA4B,CAAC,IAAIA,QAAO,UAAU;AAE9EA,QAAO,UAAU,UAAU,SAASE,SAAS,QAAQ,OAAO,KAAK,WAAW,SAAS;AACnF,MAAI,kBAAkB,YAAY;AAChC,aAASF,QAAO,KAAK,QAAQ,OAAO,QAAQ,OAAO,UAAU;AAAA,EAC/D;AACA,MAAI,CAACA,QAAO,SAAS,MAAM,GAAG;AAC5B,UAAM,IAAI;AAAA,MACR,mFACoB,OAAO;AAAA,IAC7B;AAAA,EACF;AAEA,MAAI,UAAU,QAAW;AACvB,YAAQ;AAAA,EACV;AACA,MAAI,QAAQ,QAAW;AACrB,UAAM,SAAS,OAAO,SAAS;AAAA,EACjC;AACA,MAAI,cAAc,QAAW;AAC3B,gBAAY;AAAA,EACd;AACA,MAAI,YAAY,QAAW;AACzB,cAAU,KAAK;AAAA,EACjB;AAEA,MAAI,QAAQ,KAAK,MAAM,OAAO,UAAU,YAAY,KAAK,UAAU,KAAK,QAAQ;AAC9E,UAAM,IAAI,WAAW,oBAAoB;AAAA,EAC3C;AAEA,MAAI,aAAa,WAAW,SAAS,KAAK;AACxC,WAAO;AAAA,EACT;AACA,MAAI,aAAa,SAAS;AACxB,WAAO;AAAA,EACT;AACA,MAAI,SAAS,KAAK;AAChB,WAAO;AAAA,EACT;AAEA,aAAW;AACX,WAAS;AACT,iBAAe;AACf,eAAa;AAEb,MAAI,SAAS,OAAQ,QAAO;AAE5B,MAAI,IAAI,UAAU;AAClB,MAAI,IAAI,MAAM;AACd,QAAM,MAAM,KAAK,IAAI,GAAG,CAAC;AAEzB,QAAM,WAAW,KAAK,MAAM,WAAW,OAAO;AAC9C,QAAM,aAAa,OAAO,MAAM,OAAO,GAAG;AAE1C,WAAS,IAAI,GAAG,IAAI,KAAK,EAAE,GAAG;AAC5B,QAAI,SAAS,CAAC,MAAM,WAAW,CAAC,GAAG;AACjC,UAAI,SAAS,CAAC;AACd,UAAI,WAAW,CAAC;AAChB;AAAA,IACF;AAAA,EACF;AAEA,MAAI,IAAI,EAAG,QAAO;AAClB,MAAI,IAAI,EAAG,QAAO;AAClB,SAAO;AACT;AAWA,SAAS,qBAAsB,QAAQ,KAAK,YAAY,UAAU,KAAK;AAErE,MAAI,OAAO,WAAW,EAAG,QAAO;AAGhC,MAAI,OAAO,eAAe,UAAU;AAClC,eAAW;AACX,iBAAa;AAAA,EACf,WAAW,aAAa,YAAY;AAClC,iBAAa;AAAA,EACf,WAAW,aAAa,aAAa;AACnC,iBAAa;AAAA,EACf;AACA,eAAa,CAAC;AACd,MAAI,OAAO,MAAM,UAAU,GAAG;AAE5B,iBAAa,MAAM,IAAK,OAAO,SAAS;AAAA,EAC1C;AAGA,MAAI,aAAa,EAAG,cAAa,OAAO,SAAS;AACjD,MAAI,cAAc,OAAO,QAAQ;AAC/B,QAAI,IAAK,QAAO;AAAA,QACX,cAAa,OAAO,SAAS;AAAA,EACpC,WAAW,aAAa,GAAG;AACzB,QAAI,IAAK,cAAa;AAAA,QACjB,QAAO;AAAA,EACd;AAGA,MAAI,OAAO,QAAQ,UAAU;AAC3B,UAAMA,QAAO,KAAK,KAAK,QAAQ;AAAA,EACjC;AAGA,MAAIA,QAAO,SAAS,GAAG,GAAG;AAExB,QAAI,IAAI,WAAW,GAAG;AACpB,aAAO;AAAA,IACT;AACA,WAAO,aAAa,QAAQ,KAAK,YAAY,UAAU,GAAG;AAAA,EAC5D,WAAW,OAAO,QAAQ,UAAU;AAClC,UAAM,MAAM;AACZ,QAAI,OAAO,WAAW,UAAU,YAAY,YAAY;AACtD,UAAI,KAAK;AACP,eAAO,WAAW,UAAU,QAAQ,KAAK,QAAQ,KAAK,UAAU;AAAA,MAClE,OAAO;AACL,eAAO,WAAW,UAAU,YAAY,KAAK,QAAQ,KAAK,UAAU;AAAA,MACtE;AAAA,IACF;AACA,WAAO,aAAa,QAAQ,CAAC,GAAG,GAAG,YAAY,UAAU,GAAG;AAAA,EAC9D;AAEA,QAAM,IAAI,UAAU,sCAAsC;AAC5D;AAEA,SAAS,aAAc,KAAK,KAAK,YAAY,UAAU,KAAK;AAC1D,MAAI,YAAY;AAChB,MAAI,YAAY,IAAI;AACpB,MAAI,YAAY,IAAI;AAEpB,MAAI,aAAa,QAAW;AAC1B,eAAW,OAAO,QAAQ,EAAE,YAAY;AACxC,QAAI,aAAa,UAAU,aAAa,WACpC,aAAa,aAAa,aAAa,YAAY;AACrD,UAAI,IAAI,SAAS,KAAK,IAAI,SAAS,GAAG;AACpC,eAAO;AAAA,MACT;AACA,kBAAY;AACZ,mBAAa;AACb,mBAAa;AACb,oBAAc;AAAA,IAChB;AAAA,EACF;AAEA,WAASG,MAAM,KAAKC,IAAG;AACrB,QAAI,cAAc,GAAG;AACnB,aAAO,IAAIA,EAAC;AAAA,IACd,OAAO;AACL,aAAO,IAAI,aAAaA,KAAI,SAAS;AAAA,IACvC;AAAA,EACF;AAEA,MAAI;AACJ,MAAI,KAAK;AACP,QAAI,aAAa;AACjB,SAAK,IAAI,YAAY,IAAI,WAAW,KAAK;AACvC,UAAID,MAAK,KAAK,CAAC,MAAMA,MAAK,KAAK,eAAe,KAAK,IAAI,IAAI,UAAU,GAAG;AACtE,YAAI,eAAe,GAAI,cAAa;AACpC,YAAI,IAAI,aAAa,MAAM,UAAW,QAAO,aAAa;AAAA,MAC5D,OAAO;AACL,YAAI,eAAe,GAAI,MAAK,IAAI;AAChC,qBAAa;AAAA,MACf;AAAA,IACF;AAAA,EACF,OAAO;AACL,QAAI,aAAa,YAAY,UAAW,cAAa,YAAY;AACjE,SAAK,IAAI,YAAY,KAAK,GAAG,KAAK;AAChC,UAAI,QAAQ;AACZ,eAAS,IAAI,GAAG,IAAI,WAAW,KAAK;AAClC,YAAIA,MAAK,KAAK,IAAI,CAAC,MAAMA,MAAK,KAAK,CAAC,GAAG;AACrC,kBAAQ;AACR;AAAA,QACF;AAAA,MACF;AACA,UAAI,MAAO,QAAO;AAAA,IACpB;AAAA,EACF;AAEA,SAAO;AACT;AAEAH,QAAO,UAAU,WAAW,SAAS,SAAU,KAAK,YAAY,UAAU;AACxE,SAAO,KAAK,QAAQ,KAAK,YAAY,QAAQ,MAAM;AACrD;AAEAA,QAAO,UAAU,UAAU,SAAS,QAAS,KAAK,YAAY,UAAU;AACtE,SAAO,qBAAqB,MAAM,KAAK,YAAY,UAAU,IAAI;AACnE;AAEAA,QAAO,UAAU,cAAc,SAAS,YAAa,KAAK,YAAY,UAAU;AAC9E,SAAO,qBAAqB,MAAM,KAAK,YAAY,UAAU,KAAK;AACpE;AAEA,SAAS,SAAU,KAAK,QAAQ,QAAQ,QAAQ;AAC9C,WAAS,OAAO,MAAM,KAAK;AAC3B,QAAM,YAAY,IAAI,SAAS;AAC/B,MAAI,CAAC,QAAQ;AACX,aAAS;AAAA,EACX,OAAO;AACL,aAAS,OAAO,MAAM;AACtB,QAAI,SAAS,WAAW;AACtB,eAAS;AAAA,IACX;AAAA,EACF;AAEA,QAAM,SAAS,OAAO;AAEtB,MAAI,SAAS,SAAS,GAAG;AACvB,aAAS,SAAS;AAAA,EACpB;AACA,MAAI;AACJ,OAAK,IAAI,GAAG,IAAI,QAAQ,EAAE,GAAG;AAC3B,UAAM,SAAS,SAAS,OAAO,OAAO,IAAI,GAAG,CAAC,GAAG,EAAE;AACnD,QAAI,OAAO,MAAM,MAAM,EAAG,QAAO;AACjC,QAAI,SAAS,CAAC,IAAI;AAAA,EACpB;AACA,SAAO;AACT;AAEA,SAAS,UAAW,KAAK,QAAQ,QAAQ,QAAQ;AAC/C,SAAO,WAAW,YAAY,QAAQ,IAAI,SAAS,MAAM,GAAG,KAAK,QAAQ,MAAM;AACjF;AAEA,SAAS,WAAY,KAAK,QAAQ,QAAQ,QAAQ;AAChD,SAAO,WAAW,aAAa,MAAM,GAAG,KAAK,QAAQ,MAAM;AAC7D;AAEA,SAAS,YAAa,KAAK,QAAQ,QAAQ,QAAQ;AACjD,SAAO,WAAW,cAAc,MAAM,GAAG,KAAK,QAAQ,MAAM;AAC9D;AAEA,SAAS,UAAW,KAAK,QAAQ,QAAQ,QAAQ;AAC/C,SAAO,WAAW,eAAe,QAAQ,IAAI,SAAS,MAAM,GAAG,KAAK,QAAQ,MAAM;AACpF;AAEAA,QAAO,UAAU,QAAQ,SAASK,OAAO,QAAQ,QAAQ,QAAQ,UAAU;AAEzE,MAAI,WAAW,QAAW;AACxB,eAAW;AACX,aAAS,KAAK;AACd,aAAS;AAAA,EAEX,WAAW,WAAW,UAAa,OAAO,WAAW,UAAU;AAC7D,eAAW;AACX,aAAS,KAAK;AACd,aAAS;AAAA,EAEX,WAAW,SAAS,MAAM,GAAG;AAC3B,aAAS,WAAW;AACpB,QAAI,SAAS,MAAM,GAAG;AACpB,eAAS,WAAW;AACpB,UAAI,aAAa,OAAW,YAAW;AAAA,IACzC,OAAO;AACL,iBAAW;AACX,eAAS;AAAA,IACX;AAAA,EACF,OAAO;AACL,UAAM,IAAI;AAAA,MACR;AAAA,IACF;AAAA,EACF;AAEA,QAAM,YAAY,KAAK,SAAS;AAChC,MAAI,WAAW,UAAa,SAAS,UAAW,UAAS;AAEzD,MAAK,OAAO,SAAS,MAAM,SAAS,KAAK,SAAS,MAAO,SAAS,KAAK,QAAQ;AAC7E,UAAM,IAAI,WAAW,wCAAwC;AAAA,EAC/D;AAEA,MAAI,CAAC,SAAU,YAAW;AAE1B,MAAI,cAAc;AAClB,aAAS;AACP,YAAQ,UAAU;AAAA,MAChB,KAAK;AACH,eAAO,SAAS,MAAM,QAAQ,QAAQ,MAAM;AAAA,MAE9C,KAAK;AAAA,MACL,KAAK;AACH,eAAO,UAAU,MAAM,QAAQ,QAAQ,MAAM;AAAA,MAE/C,KAAK;AAAA,MACL,KAAK;AAAA,MACL,KAAK;AACH,eAAO,WAAW,MAAM,QAAQ,QAAQ,MAAM;AAAA,MAEhD,KAAK;AAEH,eAAO,YAAY,MAAM,QAAQ,QAAQ,MAAM;AAAA,MAEjD,KAAK;AAAA,MACL,KAAK;AAAA,MACL,KAAK;AAAA,MACL,KAAK;AACH,eAAO,UAAU,MAAM,QAAQ,QAAQ,MAAM;AAAA,MAE/C;AACE,YAAI,YAAa,OAAM,IAAI,UAAU,uBAAuB,QAAQ;AACpE,oBAAY,KAAK,UAAU,YAAY;AACvC,sBAAc;AAAA,IAClB;AAAA,EACF;AACF;AAEAL,QAAO,UAAU,SAAS,SAAS,SAAU;AAC3C,SAAO;AAAA,IACL,MAAM;AAAA,IACN,MAAM,MAAM,UAAU,MAAM,KAAK,KAAK,QAAQ,MAAM,CAAC;AAAA,EACvD;AACF;AAEA,SAAS,YAAa,KAAK,OAAO,KAAK;AACrC,MAAI,UAAU,KAAK,QAAQ,IAAI,QAAQ;AACrC,WAAc,cAAc,GAAG;AAAA,EACjC,OAAO;AACL,WAAc,cAAc,IAAI,MAAM,OAAO,GAAG,CAAC;AAAA,EACnD;AACF;AAEA,SAAS,UAAW,KAAK,OAAO,KAAK;AACnC,QAAM,KAAK,IAAI,IAAI,QAAQ,GAAG;AAC9B,QAAM,MAAM,CAAC;AAEb,MAAI,IAAI;AACR,SAAO,IAAI,KAAK;AACd,UAAM,YAAY,IAAI,CAAC;AACvB,QAAI,YAAY;AAChB,QAAI,mBAAoB,YAAY,MAChC,IACC,YAAY,MACT,IACC,YAAY,MACT,IACA;AAEZ,QAAI,IAAI,oBAAoB,KAAK;AAC/B,UAAI,YAAY,WAAW,YAAY;AAEvC,cAAQ,kBAAkB;AAAA,QACxB,KAAK;AACH,cAAI,YAAY,KAAM;AACpB,wBAAY;AAAA,UACd;AACA;AAAA,QACF,KAAK;AACH,uBAAa,IAAI,IAAI,CAAC;AACtB,eAAK,aAAa,SAAU,KAAM;AAChC,6BAAiB,YAAY,OAAS,IAAO,aAAa;AAC1D,gBAAI,gBAAgB,KAAM;AACxB,0BAAY;AAAA,YACd;AAAA,UACF;AACA;AAAA,QACF,KAAK;AACH,uBAAa,IAAI,IAAI,CAAC;AACtB,sBAAY,IAAI,IAAI,CAAC;AACrB,eAAK,aAAa,SAAU,QAAS,YAAY,SAAU,KAAM;AAC/D,6BAAiB,YAAY,OAAQ,MAAO,aAAa,OAAS,IAAO,YAAY;AACrF,gBAAI,gBAAgB,SAAU,gBAAgB,SAAU,gBAAgB,QAAS;AAC/E,0BAAY;AAAA,YACd;AAAA,UACF;AACA;AAAA,QACF,KAAK;AACH,uBAAa,IAAI,IAAI,CAAC;AACtB,sBAAY,IAAI,IAAI,CAAC;AACrB,uBAAa,IAAI,IAAI,CAAC;AACtB,eAAK,aAAa,SAAU,QAAS,YAAY,SAAU,QAAS,aAAa,SAAU,KAAM;AAC/F,6BAAiB,YAAY,OAAQ,MAAQ,aAAa,OAAS,MAAO,YAAY,OAAS,IAAO,aAAa;AACnH,gBAAI,gBAAgB,SAAU,gBAAgB,SAAU;AACtD,0BAAY;AAAA,YACd;AAAA,UACF;AAAA,MACJ;AAAA,IACF;AAEA,QAAI,cAAc,MAAM;AAGtB,kBAAY;AACZ,yBAAmB;AAAA,IACrB,WAAW,YAAY,OAAQ;AAE7B,mBAAa;AACb,UAAI,KAAK,cAAc,KAAK,OAAQ,KAAM;AAC1C,kBAAY,QAAS,YAAY;AAAA,IACnC;AAEA,QAAI,KAAK,SAAS;AAClB,SAAK;AAAA,EACP;AAEA,SAAO,sBAAsB,GAAG;AAClC;AAKA,IAAM,uBAAuB;AAE7B,SAAS,sBAAuB,YAAY;AAC1C,QAAM,MAAM,WAAW;AACvB,MAAI,OAAO,sBAAsB;AAC/B,WAAO,OAAO,aAAa,MAAM,QAAQ,UAAU;AAAA,EACrD;AAGA,MAAI,MAAM;AACV,MAAI,IAAI;AACR,SAAO,IAAI,KAAK;AACd,WAAO,OAAO,aAAa;AAAA,MACzB;AAAA,MACA,WAAW,MAAM,GAAG,KAAK,oBAAoB;AAAA,IAC/C;AAAA,EACF;AACA,SAAO;AACT;AAEA,SAAS,WAAY,KAAK,OAAO,KAAK;AACpC,MAAI,MAAM;AACV,QAAM,KAAK,IAAI,IAAI,QAAQ,GAAG;AAE9B,WAAS,IAAI,OAAO,IAAI,KAAK,EAAE,GAAG;AAChC,WAAO,OAAO,aAAa,IAAI,CAAC,IAAI,GAAI;AAAA,EAC1C;AACA,SAAO;AACT;AAEA,SAAS,YAAa,KAAK,OAAO,KAAK;AACrC,MAAI,MAAM;AACV,QAAM,KAAK,IAAI,IAAI,QAAQ,GAAG;AAE9B,WAAS,IAAI,OAAO,IAAI,KAAK,EAAE,GAAG;AAChC,WAAO,OAAO,aAAa,IAAI,CAAC,CAAC;AAAA,EACnC;AACA,SAAO;AACT;AAEA,SAAS,SAAU,KAAK,OAAO,KAAK;AAClC,QAAM,MAAM,IAAI;AAEhB,MAAI,CAAC,SAAS,QAAQ,EAAG,SAAQ;AACjC,MAAI,CAAC,OAAO,MAAM,KAAK,MAAM,IAAK,OAAM;AAExC,MAAI,MAAM;AACV,WAAS,IAAI,OAAO,IAAI,KAAK,EAAE,GAAG;AAChC,WAAO,oBAAoB,IAAI,CAAC,CAAC;AAAA,EACnC;AACA,SAAO;AACT;AAEA,SAAS,aAAc,KAAK,OAAO,KAAK;AACtC,QAAM,QAAQ,IAAI,MAAM,OAAO,GAAG;AAClC,MAAI,MAAM;AAEV,WAAS,IAAI,GAAG,IAAI,MAAM,SAAS,GAAG,KAAK,GAAG;AAC5C,WAAO,OAAO,aAAa,MAAM,CAAC,IAAK,MAAM,IAAI,CAAC,IAAI,GAAI;AAAA,EAC5D;AACA,SAAO;AACT;AAEAA,QAAO,UAAU,QAAQ,SAAS,MAAO,OAAO,KAAK;AACnD,QAAM,MAAM,KAAK;AACjB,UAAQ,CAAC,CAAC;AACV,QAAM,QAAQ,SAAY,MAAM,CAAC,CAAC;AAElC,MAAI,QAAQ,GAAG;AACb,aAAS;AACT,QAAI,QAAQ,EAAG,SAAQ;AAAA,EACzB,WAAW,QAAQ,KAAK;AACtB,YAAQ;AAAA,EACV;AAEA,MAAI,MAAM,GAAG;AACX,WAAO;AACP,QAAI,MAAM,EAAG,OAAM;AAAA,EACrB,WAAW,MAAM,KAAK;AACpB,UAAM;AAAA,EACR;AAEA,MAAI,MAAM,MAAO,OAAM;AAEvB,QAAM,SAAS,KAAK,SAAS,OAAO,GAAG;AAEvC,SAAO,eAAe,QAAQA,QAAO,SAAS;AAE9C,SAAO;AACT;AAKA,SAAS,YAAa,QAAQ,KAAK,QAAQ;AACzC,MAAK,SAAS,MAAO,KAAK,SAAS,EAAG,OAAM,IAAI,WAAW,oBAAoB;AAC/E,MAAI,SAAS,MAAM,OAAQ,OAAM,IAAI,WAAW,uCAAuC;AACzF;AAEAA,QAAO,UAAU,aACjBA,QAAO,UAAU,aAAa,SAAS,WAAY,QAAQM,aAAY,UAAU;AAC/E,WAAS,WAAW;AACpB,EAAAA,cAAaA,gBAAe;AAC5B,MAAI,CAAC,SAAU,aAAY,QAAQA,aAAY,KAAK,MAAM;AAE1D,MAAI,MAAM,KAAK,MAAM;AACrB,MAAI,MAAM;AACV,MAAI,IAAI;AACR,SAAO,EAAE,IAAIA,gBAAe,OAAO,MAAQ;AACzC,WAAO,KAAK,SAAS,CAAC,IAAI;AAAA,EAC5B;AAEA,SAAO;AACT;AAEAN,QAAO,UAAU,aACjBA,QAAO,UAAU,aAAa,SAAS,WAAY,QAAQM,aAAY,UAAU;AAC/E,WAAS,WAAW;AACpB,EAAAA,cAAaA,gBAAe;AAC5B,MAAI,CAAC,UAAU;AACb,gBAAY,QAAQA,aAAY,KAAK,MAAM;AAAA,EAC7C;AAEA,MAAI,MAAM,KAAK,SAAS,EAAEA,WAAU;AACpC,MAAI,MAAM;AACV,SAAOA,cAAa,MAAM,OAAO,MAAQ;AACvC,WAAO,KAAK,SAAS,EAAEA,WAAU,IAAI;AAAA,EACvC;AAEA,SAAO;AACT;AAEAN,QAAO,UAAU,YACjBA,QAAO,UAAU,YAAY,SAAS,UAAW,QAAQ,UAAU;AACjE,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,aAAY,QAAQ,GAAG,KAAK,MAAM;AACjD,SAAO,KAAK,MAAM;AACpB;AAEAA,QAAO,UAAU,eACjBA,QAAO,UAAU,eAAe,SAAS,aAAc,QAAQ,UAAU;AACvE,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,aAAY,QAAQ,GAAG,KAAK,MAAM;AACjD,SAAO,KAAK,MAAM,IAAK,KAAK,SAAS,CAAC,KAAK;AAC7C;AAEAA,QAAO,UAAU,eACjBA,QAAO,UAAU,eAAe,SAAS,aAAc,QAAQ,UAAU;AACvE,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,aAAY,QAAQ,GAAG,KAAK,MAAM;AACjD,SAAQ,KAAK,MAAM,KAAK,IAAK,KAAK,SAAS,CAAC;AAC9C;AAEAA,QAAO,UAAU,eACjBA,QAAO,UAAU,eAAe,SAAS,aAAc,QAAQ,UAAU;AACvE,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,aAAY,QAAQ,GAAG,KAAK,MAAM;AAEjD,UAAS,KAAK,MAAM,IACf,KAAK,SAAS,CAAC,KAAK,IACpB,KAAK,SAAS,CAAC,KAAK,MACpB,KAAK,SAAS,CAAC,IAAI;AAC1B;AAEAA,QAAO,UAAU,eACjBA,QAAO,UAAU,eAAe,SAAS,aAAc,QAAQ,UAAU;AACvE,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,aAAY,QAAQ,GAAG,KAAK,MAAM;AAEjD,SAAQ,KAAK,MAAM,IAAI,YACnB,KAAK,SAAS,CAAC,KAAK,KACrB,KAAK,SAAS,CAAC,KAAK,IACrB,KAAK,SAAS,CAAC;AACnB;AAEAA,QAAO,UAAU,kBAAkB,SAAS,gBAAiB,QAAQ;AACnE,WAAS,WAAW;AACpB,iBAAe,QAAQ,QAAQ;AAC/B,QAAM,QAAQ,KAAK,MAAM;AACzB,QAAM,OAAO,KAAK,SAAS,CAAC;AAC5B,MAAI,UAAU,UAAa,SAAS,QAAW;AAC7C,gBAAY,QAAQ,KAAK,SAAS,CAAC;AAAA,EACrC;AAEA,QAAM,KAAK,QACT,KAAK,EAAE,MAAM,IAAI,KAAK,IACtB,KAAK,EAAE,MAAM,IAAI,KAAK,KACtB,KAAK,EAAE,MAAM,IAAI,KAAK;AAExB,QAAM,KAAK,KAAK,EAAE,MAAM,IACtB,KAAK,EAAE,MAAM,IAAI,KAAK,IACtB,KAAK,EAAE,MAAM,IAAI,KAAK,KACtB,OAAO,KAAK;AAEd,SAAO,OAAO,EAAE,KAAK,OAAO,EAAE,KAAK,OAAO,EAAE;AAC9C;AAEAA,QAAO,UAAU,kBAAkB,SAAS,gBAAiB,QAAQ;AACnE,WAAS,WAAW;AACpB,iBAAe,QAAQ,QAAQ;AAC/B,QAAM,QAAQ,KAAK,MAAM;AACzB,QAAM,OAAO,KAAK,SAAS,CAAC;AAC5B,MAAI,UAAU,UAAa,SAAS,QAAW;AAC7C,gBAAY,QAAQ,KAAK,SAAS,CAAC;AAAA,EACrC;AAEA,QAAM,KAAK,QAAQ,KAAK,KACtB,KAAK,EAAE,MAAM,IAAI,KAAK,KACtB,KAAK,EAAE,MAAM,IAAI,KAAK,IACtB,KAAK,EAAE,MAAM;AAEf,QAAM,KAAK,KAAK,EAAE,MAAM,IAAI,KAAK,KAC/B,KAAK,EAAE,MAAM,IAAI,KAAK,KACtB,KAAK,EAAE,MAAM,IAAI,KAAK,IACtB;AAEF,UAAQ,OAAO,EAAE,KAAK,OAAO,EAAE,KAAK,OAAO,EAAE;AAC/C;AAEAA,QAAO,UAAU,YAAY,SAAS,UAAW,QAAQM,aAAY,UAAU;AAC7E,WAAS,WAAW;AACpB,EAAAA,cAAaA,gBAAe;AAC5B,MAAI,CAAC,SAAU,aAAY,QAAQA,aAAY,KAAK,MAAM;AAE1D,MAAI,MAAM,KAAK,MAAM;AACrB,MAAI,MAAM;AACV,MAAI,IAAI;AACR,SAAO,EAAE,IAAIA,gBAAe,OAAO,MAAQ;AACzC,WAAO,KAAK,SAAS,CAAC,IAAI;AAAA,EAC5B;AACA,SAAO;AAEP,MAAI,OAAO,IAAK,QAAO,KAAK,IAAI,GAAG,IAAIA,WAAU;AAEjD,SAAO;AACT;AAEAN,QAAO,UAAU,YAAY,SAAS,UAAW,QAAQM,aAAY,UAAU;AAC7E,WAAS,WAAW;AACpB,EAAAA,cAAaA,gBAAe;AAC5B,MAAI,CAAC,SAAU,aAAY,QAAQA,aAAY,KAAK,MAAM;AAE1D,MAAI,IAAIA;AACR,MAAI,MAAM;AACV,MAAI,MAAM,KAAK,SAAS,EAAE,CAAC;AAC3B,SAAO,IAAI,MAAM,OAAO,MAAQ;AAC9B,WAAO,KAAK,SAAS,EAAE,CAAC,IAAI;AAAA,EAC9B;AACA,SAAO;AAEP,MAAI,OAAO,IAAK,QAAO,KAAK,IAAI,GAAG,IAAIA,WAAU;AAEjD,SAAO;AACT;AAEAN,QAAO,UAAU,WAAW,SAAS,SAAU,QAAQ,UAAU;AAC/D,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,aAAY,QAAQ,GAAG,KAAK,MAAM;AACjD,MAAI,EAAE,KAAK,MAAM,IAAI,KAAO,QAAQ,KAAK,MAAM;AAC/C,UAAS,MAAO,KAAK,MAAM,IAAI,KAAK;AACtC;AAEAA,QAAO,UAAU,cAAc,SAAS,YAAa,QAAQ,UAAU;AACrE,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,aAAY,QAAQ,GAAG,KAAK,MAAM;AACjD,QAAM,MAAM,KAAK,MAAM,IAAK,KAAK,SAAS,CAAC,KAAK;AAChD,SAAQ,MAAM,QAAU,MAAM,aAAa;AAC7C;AAEAA,QAAO,UAAU,cAAc,SAAS,YAAa,QAAQ,UAAU;AACrE,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,aAAY,QAAQ,GAAG,KAAK,MAAM;AACjD,QAAM,MAAM,KAAK,SAAS,CAAC,IAAK,KAAK,MAAM,KAAK;AAChD,SAAQ,MAAM,QAAU,MAAM,aAAa;AAC7C;AAEAA,QAAO,UAAU,cAAc,SAAS,YAAa,QAAQ,UAAU;AACrE,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,aAAY,QAAQ,GAAG,KAAK,MAAM;AAEjD,SAAQ,KAAK,MAAM,IAChB,KAAK,SAAS,CAAC,KAAK,IACpB,KAAK,SAAS,CAAC,KAAK,KACpB,KAAK,SAAS,CAAC,KAAK;AACzB;AAEAA,QAAO,UAAU,cAAc,SAAS,YAAa,QAAQ,UAAU;AACrE,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,aAAY,QAAQ,GAAG,KAAK,MAAM;AAEjD,SAAQ,KAAK,MAAM,KAAK,KACrB,KAAK,SAAS,CAAC,KAAK,KACpB,KAAK,SAAS,CAAC,KAAK,IACpB,KAAK,SAAS,CAAC;AACpB;AAEAA,QAAO,UAAU,iBAAiB,SAAS,eAAgB,QAAQ;AACjE,WAAS,WAAW;AACpB,iBAAe,QAAQ,QAAQ;AAC/B,QAAM,QAAQ,KAAK,MAAM;AACzB,QAAM,OAAO,KAAK,SAAS,CAAC;AAC5B,MAAI,UAAU,UAAa,SAAS,QAAW;AAC7C,gBAAY,QAAQ,KAAK,SAAS,CAAC;AAAA,EACrC;AAEA,QAAM,MAAM,KAAK,SAAS,CAAC,IACzB,KAAK,SAAS,CAAC,IAAI,KAAK,IACxB,KAAK,SAAS,CAAC,IAAI,KAAK,MACvB,QAAQ;AAEX,UAAQ,OAAO,GAAG,KAAK,OAAO,EAAE,KAC9B,OAAO,QACP,KAAK,EAAE,MAAM,IAAI,KAAK,IACtB,KAAK,EAAE,MAAM,IAAI,KAAK,KACtB,KAAK,EAAE,MAAM,IAAI,KAAK,EAAE;AAC5B;AAEAA,QAAO,UAAU,iBAAiB,SAAS,eAAgB,QAAQ;AACjE,WAAS,WAAW;AACpB,iBAAe,QAAQ,QAAQ;AAC/B,QAAM,QAAQ,KAAK,MAAM;AACzB,QAAM,OAAO,KAAK,SAAS,CAAC;AAC5B,MAAI,UAAU,UAAa,SAAS,QAAW;AAC7C,gBAAY,QAAQ,KAAK,SAAS,CAAC;AAAA,EACrC;AAEA,QAAM,OAAO,SAAS;AAAA,EACpB,KAAK,EAAE,MAAM,IAAI,KAAK,KACtB,KAAK,EAAE,MAAM,IAAI,KAAK,IACtB,KAAK,EAAE,MAAM;AAEf,UAAQ,OAAO,GAAG,KAAK,OAAO,EAAE,KAC9B,OAAO,KAAK,EAAE,MAAM,IAAI,KAAK,KAC7B,KAAK,EAAE,MAAM,IAAI,KAAK,KACtB,KAAK,EAAE,MAAM,IAAI,KAAK,IACtB,IAAI;AACR;AAEAA,QAAO,UAAU,cAAc,SAAS,YAAa,QAAQ,UAAU;AACrE,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,aAAY,QAAQ,GAAG,KAAK,MAAM;AACjD,SAAe,KAAK,MAAM,QAAQ,MAAM,IAAI,CAAC;AAC/C;AAEAA,QAAO,UAAU,cAAc,SAAS,YAAa,QAAQ,UAAU;AACrE,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,aAAY,QAAQ,GAAG,KAAK,MAAM;AACjD,SAAe,KAAK,MAAM,QAAQ,OAAO,IAAI,CAAC;AAChD;AAEAA,QAAO,UAAU,eAAe,SAAS,aAAc,QAAQ,UAAU;AACvE,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,aAAY,QAAQ,GAAG,KAAK,MAAM;AACjD,SAAe,KAAK,MAAM,QAAQ,MAAM,IAAI,CAAC;AAC/C;AAEAA,QAAO,UAAU,eAAe,SAAS,aAAc,QAAQ,UAAU;AACvE,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,aAAY,QAAQ,GAAG,KAAK,MAAM;AACjD,SAAe,KAAK,MAAM,QAAQ,OAAO,IAAI,CAAC;AAChD;AAEA,SAAS,SAAU,KAAK,OAAO,QAAQ,KAAK,KAAK,KAAK;AACpD,MAAI,CAACA,QAAO,SAAS,GAAG,EAAG,OAAM,IAAI,UAAU,6CAA6C;AAC5F,MAAI,QAAQ,OAAO,QAAQ,IAAK,OAAM,IAAI,WAAW,mCAAmC;AACxF,MAAI,SAAS,MAAM,IAAI,OAAQ,OAAM,IAAI,WAAW,oBAAoB;AAC1E;AAEAA,QAAO,UAAU,cACjBA,QAAO,UAAU,cAAc,SAAS,YAAa,OAAO,QAAQM,aAAY,UAAU;AACxF,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,EAAAA,cAAaA,gBAAe;AAC5B,MAAI,CAAC,UAAU;AACb,UAAM,WAAW,KAAK,IAAI,GAAG,IAAIA,WAAU,IAAI;AAC/C,aAAS,MAAM,OAAO,QAAQA,aAAY,UAAU,CAAC;AAAA,EACvD;AAEA,MAAI,MAAM;AACV,MAAI,IAAI;AACR,OAAK,MAAM,IAAI,QAAQ;AACvB,SAAO,EAAE,IAAIA,gBAAe,OAAO,MAAQ;AACzC,SAAK,SAAS,CAAC,IAAK,QAAQ,MAAO;AAAA,EACrC;AAEA,SAAO,SAASA;AAClB;AAEAN,QAAO,UAAU,cACjBA,QAAO,UAAU,cAAc,SAAS,YAAa,OAAO,QAAQM,aAAY,UAAU;AACxF,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,EAAAA,cAAaA,gBAAe;AAC5B,MAAI,CAAC,UAAU;AACb,UAAM,WAAW,KAAK,IAAI,GAAG,IAAIA,WAAU,IAAI;AAC/C,aAAS,MAAM,OAAO,QAAQA,aAAY,UAAU,CAAC;AAAA,EACvD;AAEA,MAAI,IAAIA,cAAa;AACrB,MAAI,MAAM;AACV,OAAK,SAAS,CAAC,IAAI,QAAQ;AAC3B,SAAO,EAAE,KAAK,MAAM,OAAO,MAAQ;AACjC,SAAK,SAAS,CAAC,IAAK,QAAQ,MAAO;AAAA,EACrC;AAEA,SAAO,SAASA;AAClB;AAEAN,QAAO,UAAU,aACjBA,QAAO,UAAU,aAAa,SAAS,WAAY,OAAO,QAAQ,UAAU;AAC1E,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,UAAS,MAAM,OAAO,QAAQ,GAAG,KAAM,CAAC;AACvD,OAAK,MAAM,IAAK,QAAQ;AACxB,SAAO,SAAS;AAClB;AAEAA,QAAO,UAAU,gBACjBA,QAAO,UAAU,gBAAgB,SAAS,cAAe,OAAO,QAAQ,UAAU;AAChF,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,UAAS,MAAM,OAAO,QAAQ,GAAG,OAAQ,CAAC;AACzD,OAAK,MAAM,IAAK,QAAQ;AACxB,OAAK,SAAS,CAAC,IAAK,UAAU;AAC9B,SAAO,SAAS;AAClB;AAEAA,QAAO,UAAU,gBACjBA,QAAO,UAAU,gBAAgB,SAAS,cAAe,OAAO,QAAQ,UAAU;AAChF,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,UAAS,MAAM,OAAO,QAAQ,GAAG,OAAQ,CAAC;AACzD,OAAK,MAAM,IAAK,UAAU;AAC1B,OAAK,SAAS,CAAC,IAAK,QAAQ;AAC5B,SAAO,SAAS;AAClB;AAEAA,QAAO,UAAU,gBACjBA,QAAO,UAAU,gBAAgB,SAAS,cAAe,OAAO,QAAQ,UAAU;AAChF,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,UAAS,MAAM,OAAO,QAAQ,GAAG,YAAY,CAAC;AAC7D,OAAK,SAAS,CAAC,IAAK,UAAU;AAC9B,OAAK,SAAS,CAAC,IAAK,UAAU;AAC9B,OAAK,SAAS,CAAC,IAAK,UAAU;AAC9B,OAAK,MAAM,IAAK,QAAQ;AACxB,SAAO,SAAS;AAClB;AAEAA,QAAO,UAAU,gBACjBA,QAAO,UAAU,gBAAgB,SAAS,cAAe,OAAO,QAAQ,UAAU;AAChF,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,UAAS,MAAM,OAAO,QAAQ,GAAG,YAAY,CAAC;AAC7D,OAAK,MAAM,IAAK,UAAU;AAC1B,OAAK,SAAS,CAAC,IAAK,UAAU;AAC9B,OAAK,SAAS,CAAC,IAAK,UAAU;AAC9B,OAAK,SAAS,CAAC,IAAK,QAAQ;AAC5B,SAAO,SAAS;AAClB;AAEA,SAAS,eAAgB,KAAK,OAAO,QAAQ,KAAK,KAAK;AACrD,aAAW,OAAO,KAAK,KAAK,KAAK,QAAQ,CAAC;AAE1C,MAAI,KAAK,OAAO,QAAQ,OAAO,UAAU,CAAC;AAC1C,MAAI,QAAQ,IAAI;AAChB,OAAK,MAAM;AACX,MAAI,QAAQ,IAAI;AAChB,OAAK,MAAM;AACX,MAAI,QAAQ,IAAI;AAChB,OAAK,MAAM;AACX,MAAI,QAAQ,IAAI;AAChB,MAAI,KAAK,OAAO,SAAS,OAAO,EAAE,IAAI,OAAO,UAAU,CAAC;AACxD,MAAI,QAAQ,IAAI;AAChB,OAAK,MAAM;AACX,MAAI,QAAQ,IAAI;AAChB,OAAK,MAAM;AACX,MAAI,QAAQ,IAAI;AAChB,OAAK,MAAM;AACX,MAAI,QAAQ,IAAI;AAChB,SAAO;AACT;AAEA,SAAS,eAAgB,KAAK,OAAO,QAAQ,KAAK,KAAK;AACrD,aAAW,OAAO,KAAK,KAAK,KAAK,QAAQ,CAAC;AAE1C,MAAI,KAAK,OAAO,QAAQ,OAAO,UAAU,CAAC;AAC1C,MAAI,SAAS,CAAC,IAAI;AAClB,OAAK,MAAM;AACX,MAAI,SAAS,CAAC,IAAI;AAClB,OAAK,MAAM;AACX,MAAI,SAAS,CAAC,IAAI;AAClB,OAAK,MAAM;AACX,MAAI,SAAS,CAAC,IAAI;AAClB,MAAI,KAAK,OAAO,SAAS,OAAO,EAAE,IAAI,OAAO,UAAU,CAAC;AACxD,MAAI,SAAS,CAAC,IAAI;AAClB,OAAK,MAAM;AACX,MAAI,SAAS,CAAC,IAAI;AAClB,OAAK,MAAM;AACX,MAAI,SAAS,CAAC,IAAI;AAClB,OAAK,MAAM;AACX,MAAI,MAAM,IAAI;AACd,SAAO,SAAS;AAClB;AAEAA,QAAO,UAAU,mBAAmB,SAAS,iBAAkB,OAAO,SAAS,GAAG;AAChF,SAAO,eAAe,MAAM,OAAO,QAAQ,OAAO,CAAC,GAAG,OAAO,oBAAoB,CAAC;AACpF;AAEAA,QAAO,UAAU,mBAAmB,SAAS,iBAAkB,OAAO,SAAS,GAAG;AAChF,SAAO,eAAe,MAAM,OAAO,QAAQ,OAAO,CAAC,GAAG,OAAO,oBAAoB,CAAC;AACpF;AAEAA,QAAO,UAAU,aAAa,SAAS,WAAY,OAAO,QAAQM,aAAY,UAAU;AACtF,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,MAAI,CAAC,UAAU;AACb,UAAM,QAAQ,KAAK,IAAI,GAAI,IAAIA,cAAc,CAAC;AAE9C,aAAS,MAAM,OAAO,QAAQA,aAAY,QAAQ,GAAG,CAAC,KAAK;AAAA,EAC7D;AAEA,MAAI,IAAI;AACR,MAAI,MAAM;AACV,MAAI,MAAM;AACV,OAAK,MAAM,IAAI,QAAQ;AACvB,SAAO,EAAE,IAAIA,gBAAe,OAAO,MAAQ;AACzC,QAAI,QAAQ,KAAK,QAAQ,KAAK,KAAK,SAAS,IAAI,CAAC,MAAM,GAAG;AACxD,YAAM;AAAA,IACR;AACA,SAAK,SAAS,CAAC,KAAM,QAAQ,OAAQ,KAAK,MAAM;AAAA,EAClD;AAEA,SAAO,SAASA;AAClB;AAEAN,QAAO,UAAU,aAAa,SAAS,WAAY,OAAO,QAAQM,aAAY,UAAU;AACtF,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,MAAI,CAAC,UAAU;AACb,UAAM,QAAQ,KAAK,IAAI,GAAI,IAAIA,cAAc,CAAC;AAE9C,aAAS,MAAM,OAAO,QAAQA,aAAY,QAAQ,GAAG,CAAC,KAAK;AAAA,EAC7D;AAEA,MAAI,IAAIA,cAAa;AACrB,MAAI,MAAM;AACV,MAAI,MAAM;AACV,OAAK,SAAS,CAAC,IAAI,QAAQ;AAC3B,SAAO,EAAE,KAAK,MAAM,OAAO,MAAQ;AACjC,QAAI,QAAQ,KAAK,QAAQ,KAAK,KAAK,SAAS,IAAI,CAAC,MAAM,GAAG;AACxD,YAAM;AAAA,IACR;AACA,SAAK,SAAS,CAAC,KAAM,QAAQ,OAAQ,KAAK,MAAM;AAAA,EAClD;AAEA,SAAO,SAASA;AAClB;AAEAN,QAAO,UAAU,YAAY,SAAS,UAAW,OAAO,QAAQ,UAAU;AACxE,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,UAAS,MAAM,OAAO,QAAQ,GAAG,KAAM,IAAK;AAC3D,MAAI,QAAQ,EAAG,SAAQ,MAAO,QAAQ;AACtC,OAAK,MAAM,IAAK,QAAQ;AACxB,SAAO,SAAS;AAClB;AAEAA,QAAO,UAAU,eAAe,SAAS,aAAc,OAAO,QAAQ,UAAU;AAC9E,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,UAAS,MAAM,OAAO,QAAQ,GAAG,OAAQ,MAAO;AAC/D,OAAK,MAAM,IAAK,QAAQ;AACxB,OAAK,SAAS,CAAC,IAAK,UAAU;AAC9B,SAAO,SAAS;AAClB;AAEAA,QAAO,UAAU,eAAe,SAAS,aAAc,OAAO,QAAQ,UAAU;AAC9E,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,UAAS,MAAM,OAAO,QAAQ,GAAG,OAAQ,MAAO;AAC/D,OAAK,MAAM,IAAK,UAAU;AAC1B,OAAK,SAAS,CAAC,IAAK,QAAQ;AAC5B,SAAO,SAAS;AAClB;AAEAA,QAAO,UAAU,eAAe,SAAS,aAAc,OAAO,QAAQ,UAAU;AAC9E,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,UAAS,MAAM,OAAO,QAAQ,GAAG,YAAY,WAAW;AACvE,OAAK,MAAM,IAAK,QAAQ;AACxB,OAAK,SAAS,CAAC,IAAK,UAAU;AAC9B,OAAK,SAAS,CAAC,IAAK,UAAU;AAC9B,OAAK,SAAS,CAAC,IAAK,UAAU;AAC9B,SAAO,SAAS;AAClB;AAEAA,QAAO,UAAU,eAAe,SAAS,aAAc,OAAO,QAAQ,UAAU;AAC9E,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,MAAI,CAAC,SAAU,UAAS,MAAM,OAAO,QAAQ,GAAG,YAAY,WAAW;AACvE,MAAI,QAAQ,EAAG,SAAQ,aAAa,QAAQ;AAC5C,OAAK,MAAM,IAAK,UAAU;AAC1B,OAAK,SAAS,CAAC,IAAK,UAAU;AAC9B,OAAK,SAAS,CAAC,IAAK,UAAU;AAC9B,OAAK,SAAS,CAAC,IAAK,QAAQ;AAC5B,SAAO,SAAS;AAClB;AAEAA,QAAO,UAAU,kBAAkB,SAAS,gBAAiB,OAAO,SAAS,GAAG;AAC9E,SAAO,eAAe,MAAM,OAAO,QAAQ,CAAC,OAAO,oBAAoB,GAAG,OAAO,oBAAoB,CAAC;AACxG;AAEAA,QAAO,UAAU,kBAAkB,SAAS,gBAAiB,OAAO,SAAS,GAAG;AAC9E,SAAO,eAAe,MAAM,OAAO,QAAQ,CAAC,OAAO,oBAAoB,GAAG,OAAO,oBAAoB,CAAC;AACxG;AAEA,SAAS,aAAc,KAAK,OAAO,QAAQ,KAAK,KAAK,KAAK;AACxD,MAAI,SAAS,MAAM,IAAI,OAAQ,OAAM,IAAI,WAAW,oBAAoB;AACxE,MAAI,SAAS,EAAG,OAAM,IAAI,WAAW,oBAAoB;AAC3D;AAEA,SAAS,WAAY,KAAK,OAAO,QAAQ,cAAc,UAAU;AAC/D,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,MAAI,CAAC,UAAU;AACb,iBAAa,KAAK,OAAO,QAAQ,GAAG,sBAAwB,qBAAuB;AAAA,EACrF;AACA,EAAQ,MAAM,KAAK,OAAO,QAAQ,cAAc,IAAI,CAAC;AACrD,SAAO,SAAS;AAClB;AAEAA,QAAO,UAAU,eAAe,SAAS,aAAc,OAAO,QAAQ,UAAU;AAC9E,SAAO,WAAW,MAAM,OAAO,QAAQ,MAAM,QAAQ;AACvD;AAEAA,QAAO,UAAU,eAAe,SAAS,aAAc,OAAO,QAAQ,UAAU;AAC9E,SAAO,WAAW,MAAM,OAAO,QAAQ,OAAO,QAAQ;AACxD;AAEA,SAAS,YAAa,KAAK,OAAO,QAAQ,cAAc,UAAU;AAChE,UAAQ,CAAC;AACT,WAAS,WAAW;AACpB,MAAI,CAAC,UAAU;AACb,iBAAa,KAAK,OAAO,QAAQ,GAAG,uBAAyB,sBAAwB;AAAA,EACvF;AACA,EAAQ,MAAM,KAAK,OAAO,QAAQ,cAAc,IAAI,CAAC;AACrD,SAAO,SAAS;AAClB;AAEAA,QAAO,UAAU,gBAAgB,SAAS,cAAe,OAAO,QAAQ,UAAU;AAChF,SAAO,YAAY,MAAM,OAAO,QAAQ,MAAM,QAAQ;AACxD;AAEAA,QAAO,UAAU,gBAAgB,SAAS,cAAe,OAAO,QAAQ,UAAU;AAChF,SAAO,YAAY,MAAM,OAAO,QAAQ,OAAO,QAAQ;AACzD;AAGAA,QAAO,UAAU,OAAO,SAAS,KAAM,QAAQ,aAAa,OAAO,KAAK;AACtE,MAAI,CAACA,QAAO,SAAS,MAAM,EAAG,OAAM,IAAI,UAAU,6BAA6B;AAC/E,MAAI,CAAC,MAAO,SAAQ;AACpB,MAAI,CAAC,OAAO,QAAQ,EAAG,OAAM,KAAK;AAClC,MAAI,eAAe,OAAO,OAAQ,eAAc,OAAO;AACvD,MAAI,CAAC,YAAa,eAAc;AAChC,MAAI,MAAM,KAAK,MAAM,MAAO,OAAM;AAGlC,MAAI,QAAQ,MAAO,QAAO;AAC1B,MAAI,OAAO,WAAW,KAAK,KAAK,WAAW,EAAG,QAAO;AAGrD,MAAI,cAAc,GAAG;AACnB,UAAM,IAAI,WAAW,2BAA2B;AAAA,EAClD;AACA,MAAI,QAAQ,KAAK,SAAS,KAAK,OAAQ,OAAM,IAAI,WAAW,oBAAoB;AAChF,MAAI,MAAM,EAAG,OAAM,IAAI,WAAW,yBAAyB;AAG3D,MAAI,MAAM,KAAK,OAAQ,OAAM,KAAK;AAClC,MAAI,OAAO,SAAS,cAAc,MAAM,OAAO;AAC7C,UAAM,OAAO,SAAS,cAAc;AAAA,EACtC;AAEA,QAAM,MAAM,MAAM;AAElB,MAAI,SAAS,QAAQ;AACnB,SAAK,WAAW,aAAa,OAAO,GAAG;AAAA,EACzC,OAAO;AACL,eAAW,UAAU,IAAI;AAAA,MACvB;AAAA,MACA,KAAK,SAAS,OAAO,GAAG;AAAA,MACxB;AAAA,IACF;AAAA,EACF;AAEA,SAAO;AACT;AAMAA,QAAO,UAAU,OAAO,SAAS,KAAM,KAAK,OAAO,KAAK,UAAU;AAEhE,MAAI,OAAO,QAAQ,UAAU;AAC3B,QAAI,OAAO,UAAU,UAAU;AAC7B,iBAAW;AACX,cAAQ;AACR,YAAM,KAAK;AAAA,IACb,WAAW,OAAO,QAAQ,UAAU;AAClC,iBAAW;AACX,YAAM,KAAK;AAAA,IACb;AACA,QAAI,aAAa,UAAa,OAAO,aAAa,UAAU;AAC1D,YAAM,IAAI,UAAU,2BAA2B;AAAA,IACjD;AACA,QAAI,OAAO,aAAa,YAAY,CAACA,QAAO,WAAW,QAAQ,GAAG;AAChE,YAAM,IAAI,UAAU,uBAAuB,QAAQ;AAAA,IACrD;AACA,QAAI,IAAI,WAAW,GAAG;AACpB,YAAMO,QAAO,IAAI,WAAW,CAAC;AAC7B,UAAK,aAAa,UAAUA,QAAO,OAC/B,aAAa,UAAU;AAEzB,cAAMA;AAAA,MACR;AAAA,IACF;AAAA,EACF,WAAW,OAAO,QAAQ,UAAU;AAClC,UAAM,MAAM;AAAA,EACd,WAAW,OAAO,QAAQ,WAAW;AACnC,UAAM,OAAO,GAAG;AAAA,EAClB;AAGA,MAAI,QAAQ,KAAK,KAAK,SAAS,SAAS,KAAK,SAAS,KAAK;AACzD,UAAM,IAAI,WAAW,oBAAoB;AAAA,EAC3C;AAEA,MAAI,OAAO,OAAO;AAChB,WAAO;AAAA,EACT;AAEA,UAAQ,UAAU;AAClB,QAAM,QAAQ,SAAY,KAAK,SAAS,QAAQ;AAEhD,MAAI,CAAC,IAAK,OAAM;AAEhB,MAAI;AACJ,MAAI,OAAO,QAAQ,UAAU;AAC3B,SAAK,IAAI,OAAO,IAAI,KAAK,EAAE,GAAG;AAC5B,WAAK,CAAC,IAAI;AAAA,IACZ;AAAA,EACF,OAAO;AACL,UAAM,QAAQP,QAAO,SAAS,GAAG,IAC7B,MACAA,QAAO,KAAK,KAAK,QAAQ;AAC7B,UAAM,MAAM,MAAM;AAClB,QAAI,QAAQ,GAAG;AACb,YAAM,IAAI,UAAU,gBAAgB,MAClC,mCAAmC;AAAA,IACvC;AACA,SAAK,IAAI,GAAG,IAAI,MAAM,OAAO,EAAE,GAAG;AAChC,WAAK,IAAI,KAAK,IAAI,MAAM,IAAI,GAAG;AAAA,IACjC;AAAA,EACF;AAEA,SAAO;AACT;AAMA,IAAM,SAAS,CAAC;AAChB,SAAS,EAAG,KAAK,YAAY,MAAM;AACjC,SAAO,GAAG,IAAI,MAAM,kBAAkB,KAAK;AAAA,IACzC,cAAe;AACb,YAAM;AAEN,aAAO,eAAe,MAAM,WAAW;AAAA,QACrC,OAAO,WAAW,MAAM,MAAM,SAAS;AAAA,QACvC,UAAU;AAAA,QACV,cAAc;AAAA,MAChB,CAAC;AAGD,WAAK,OAAO,GAAG,KAAK,IAAI,KAAK,GAAG;AAGhC,WAAK;AAEL,aAAO,KAAK;AAAA,IACd;AAAA,IAEA,IAAI,OAAQ;AACV,aAAO;AAAA,IACT;AAAA,IAEA,IAAI,KAAM,OAAO;AACf,aAAO,eAAe,MAAM,QAAQ;AAAA,QAClC,cAAc;AAAA,QACd,YAAY;AAAA,QACZ;AAAA,QACA,UAAU;AAAA,MACZ,CAAC;AAAA,IACH;AAAA,IAEA,WAAY;AACV,aAAO,GAAG,KAAK,IAAI,KAAK,GAAG,MAAM,KAAK,OAAO;AAAA,IAC/C;AAAA,EACF;AACF;AAEA;AAAA,EAAE;AAAA,EACA,SAAU,MAAM;AACd,QAAI,MAAM;AACR,aAAO,GAAG,IAAI;AAAA,IAChB;AAEA,WAAO;AAAA,EACT;AAAA,EAAG;AAAU;AACf;AAAA,EAAE;AAAA,EACA,SAAU,MAAM,QAAQ;AACtB,WAAO,QAAQ,IAAI,oDAAoD,OAAO,MAAM;AAAA,EACtF;AAAA,EAAG;AAAS;AACd;AAAA,EAAE;AAAA,EACA,SAAU,KAAK,OAAO,OAAO;AAC3B,QAAI,MAAM,iBAAiB,GAAG;AAC9B,QAAI,WAAW;AACf,QAAI,OAAO,UAAU,KAAK,KAAK,KAAK,IAAI,KAAK,IAAI,KAAK,IAAI;AACxD,iBAAW,sBAAsB,OAAO,KAAK,CAAC;AAAA,IAChD,WAAW,OAAO,UAAU,UAAU;AACpC,iBAAW,OAAO,KAAK;AACvB,UAAI,QAAQ,OAAO,CAAC,KAAK,OAAO,EAAE,KAAK,QAAQ,EAAE,OAAO,CAAC,KAAK,OAAO,EAAE,IAAI;AACzE,mBAAW,sBAAsB,QAAQ;AAAA,MAC3C;AACA,kBAAY;AAAA,IACd;AACA,WAAO,eAAe,KAAK,cAAc,QAAQ;AACjD,WAAO;AAAA,EACT;AAAA,EAAG;AAAU;AAEf,SAAS,sBAAuB,KAAK;AACnC,MAAI,MAAM;AACV,MAAI,IAAI,IAAI;AACZ,QAAM,QAAQ,IAAI,CAAC,MAAM,MAAM,IAAI;AACnC,SAAO,KAAK,QAAQ,GAAG,KAAK,GAAG;AAC7B,UAAM,IAAI,IAAI,MAAM,IAAI,GAAG,CAAC,CAAC,GAAG,GAAG;AAAA,EACrC;AACA,SAAO,GAAG,IAAI,MAAM,GAAG,CAAC,CAAC,GAAG,GAAG;AACjC;AAKA,SAAS,YAAa,KAAK,QAAQM,aAAY;AAC7C,iBAAe,QAAQ,QAAQ;AAC/B,MAAI,IAAI,MAAM,MAAM,UAAa,IAAI,SAASA,WAAU,MAAM,QAAW;AACvE,gBAAY,QAAQ,IAAI,UAAUA,cAAa,EAAE;AAAA,EACnD;AACF;AAEA,SAAS,WAAY,OAAO,KAAK,KAAK,KAAK,QAAQA,aAAY;AAC7D,MAAI,QAAQ,OAAO,QAAQ,KAAK;AAC9B,UAAM,IAAI,OAAO,QAAQ,WAAW,MAAM;AAC1C,QAAI;AACJ,QAAIA,cAAa,GAAG;AAClB,UAAI,QAAQ,KAAK,QAAQ,OAAO,CAAC,GAAG;AAClC,gBAAQ,OAAO,CAAC,WAAW,CAAC,QAAQA,cAAa,KAAK,CAAC,GAAG,CAAC;AAAA,MAC7D,OAAO;AACL,gBAAQ,SAAS,CAAC,QAAQA,cAAa,KAAK,IAAI,CAAC,GAAG,CAAC,iBACzCA,cAAa,KAAK,IAAI,CAAC,GAAG,CAAC;AAAA,MACzC;AAAA,IACF,OAAO;AACL,cAAQ,MAAM,GAAG,GAAG,CAAC,WAAW,GAAG,GAAG,CAAC;AAAA,IACzC;AACA,UAAM,IAAI,OAAO,iBAAiB,SAAS,OAAO,KAAK;AAAA,EACzD;AACA,cAAY,KAAK,QAAQA,WAAU;AACrC;AAEA,SAAS,eAAgB,OAAO,MAAM;AACpC,MAAI,OAAO,UAAU,UAAU;AAC7B,UAAM,IAAI,OAAO,qBAAqB,MAAM,UAAU,KAAK;AAAA,EAC7D;AACF;AAEA,SAAS,YAAa,OAAO,QAAQ,MAAM;AACzC,MAAI,KAAK,MAAM,KAAK,MAAM,OAAO;AAC/B,mBAAe,OAAO,IAAI;AAC1B,UAAM,IAAI,OAAO,iBAAiB,QAAQ,UAAU,cAAc,KAAK;AAAA,EACzE;AAEA,MAAI,SAAS,GAAG;AACd,UAAM,IAAI,OAAO,yBAAyB;AAAA,EAC5C;AAEA,QAAM,IAAI,OAAO;AAAA,IAAiB,QAAQ;AAAA,IACR,MAAM,OAAO,IAAI,CAAC,WAAW,MAAM;AAAA,IACnC;AAAA,EAAK;AACzC;AAKA,IAAM,oBAAoB;AAE1B,SAAS,YAAa,KAAK;AAEzB,QAAM,IAAI,MAAM,GAAG,EAAE,CAAC;AAEtB,QAAM,IAAI,KAAK,EAAE,QAAQ,mBAAmB,EAAE;AAE9C,MAAI,IAAI,SAAS,EAAG,QAAO;AAE3B,SAAO,IAAI,SAAS,MAAM,GAAG;AAC3B,UAAM,MAAM;AAAA,EACd;AACA,SAAO;AACT;AAEA,SAAS,YAAa,QAAQ,OAAO;AACnC,UAAQ,SAAS;AACjB,MAAI;AACJ,QAAM,SAAS,OAAO;AACtB,MAAI,gBAAgB;AACpB,QAAM,QAAQ,CAAC;AAEf,WAAS,IAAI,GAAG,IAAI,QAAQ,EAAE,GAAG;AAC/B,gBAAY,OAAO,WAAW,CAAC;AAG/B,QAAI,YAAY,SAAU,YAAY,OAAQ;AAE5C,UAAI,CAAC,eAAe;AAElB,YAAI,YAAY,OAAQ;AAEtB,eAAK,SAAS,KAAK,GAAI,OAAM,KAAK,KAAM,KAAM,GAAI;AAClD;AAAA,QACF,WAAW,IAAI,MAAM,QAAQ;AAE3B,eAAK,SAAS,KAAK,GAAI,OAAM,KAAK,KAAM,KAAM,GAAI;AAClD;AAAA,QACF;AAGA,wBAAgB;AAEhB;AAAA,MACF;AAGA,UAAI,YAAY,OAAQ;AACtB,aAAK,SAAS,KAAK,GAAI,OAAM,KAAK,KAAM,KAAM,GAAI;AAClD,wBAAgB;AAChB;AAAA,MACF;AAGA,mBAAa,gBAAgB,SAAU,KAAK,YAAY,SAAU;AAAA,IACpE,WAAW,eAAe;AAExB,WAAK,SAAS,KAAK,GAAI,OAAM,KAAK,KAAM,KAAM,GAAI;AAAA,IACpD;AAEA,oBAAgB;AAGhB,QAAI,YAAY,KAAM;AACpB,WAAK,SAAS,KAAK,EAAG;AACtB,YAAM,KAAK,SAAS;AAAA,IACtB,WAAW,YAAY,MAAO;AAC5B,WAAK,SAAS,KAAK,EAAG;AACtB,YAAM;AAAA,QACJ,aAAa,IAAM;AAAA,QACnB,YAAY,KAAO;AAAA,MACrB;AAAA,IACF,WAAW,YAAY,OAAS;AAC9B,WAAK,SAAS,KAAK,EAAG;AACtB,YAAM;AAAA,QACJ,aAAa,KAAM;AAAA,QACnB,aAAa,IAAM,KAAO;AAAA,QAC1B,YAAY,KAAO;AAAA,MACrB;AAAA,IACF,WAAW,YAAY,SAAU;AAC/B,WAAK,SAAS,KAAK,EAAG;AACtB,YAAM;AAAA,QACJ,aAAa,KAAO;AAAA,QACpB,aAAa,KAAM,KAAO;AAAA,QAC1B,aAAa,IAAM,KAAO;AAAA,QAC1B,YAAY,KAAO;AAAA,MACrB;AAAA,IACF,OAAO;AACL,YAAM,IAAI,MAAM,oBAAoB;AAAA,IACtC;AAAA,EACF;AAEA,SAAO;AACT;AAEA,SAAS,aAAc,KAAK;AAC1B,QAAM,YAAY,CAAC;AACnB,WAAS,IAAI,GAAG,IAAI,IAAI,QAAQ,EAAE,GAAG;AAEnC,cAAU,KAAK,IAAI,WAAW,CAAC,IAAI,GAAI;AAAA,EACzC;AACA,SAAO;AACT;AAEA,SAAS,eAAgB,KAAK,OAAO;AACnC,MAAI,GAAG,IAAI;AACX,QAAM,YAAY,CAAC;AACnB,WAAS,IAAI,GAAG,IAAI,IAAI,QAAQ,EAAE,GAAG;AACnC,SAAK,SAAS,KAAK,EAAG;AAEtB,QAAI,IAAI,WAAW,CAAC;AACpB,SAAK,KAAK;AACV,SAAK,IAAI;AACT,cAAU,KAAK,EAAE;AACjB,cAAU,KAAK,EAAE;AAAA,EACnB;AAEA,SAAO;AACT;AAEA,SAAS,cAAe,KAAK;AAC3B,SAAc,YAAY,YAAY,GAAG,CAAC;AAC5C;AAEA,SAAS,WAAY,KAAK,KAAK,QAAQ,QAAQ;AAC7C,MAAI;AACJ,OAAK,IAAI,GAAG,IAAI,QAAQ,EAAE,GAAG;AAC3B,QAAK,IAAI,UAAU,IAAI,UAAY,KAAK,IAAI,OAAS;AACrD,QAAI,IAAI,MAAM,IAAI,IAAI,CAAC;AAAA,EACzB;AACA,SAAO;AACT;AAIA,IAAM,sBAAuB,WAAY;AACvC,QAAM,WAAW;AACjB,QAAM,QAAQ,IAAI,MAAM,GAAG;AAC3B,WAAS,IAAI,GAAG,IAAI,IAAI,EAAE,GAAG;AAC3B,UAAM,MAAM,IAAI;AAChB,aAAS,IAAI,GAAG,IAAI,IAAI,EAAE,GAAG;AAC3B,YAAM,MAAM,CAAC,IAAI,SAAS,CAAC,IAAI,SAAS,CAAC;AAAA,IAC3C;AAAA,EACF;AACA,SAAO;AACT,EAAG;;;ACr/DI,IAAI,yBAAsF,CAAA;AAE1F,IAAM,cAAc,oBAAI,IAAG;AAE3B,IAAM,UAAU;AAChB,IAAM,WAAW;AAEjB,IAAME,eAAc,QAAQ;AAE5B,IAAM,uBAAkD;EAC3D,GAAG;;EACH,IAAI;;EACJ,GAAG;;EACH,IAAI;;;;;;AChBF,SAAU,IAAI,KAAa;AAC7B,MAAI,UAAqC,CAAA;AACzC,UAAQ,aAAa,IAAI;AACzB,UAAQ,SAAS,IAAI;AACrB,OAAK,OAAO;AAAC;AAIX,SAAU,OAAO,KAAa;AAChC,MAAI,UAAqC,CAAA;AACzC,UAAQ,aAAa,IAAI;AACzB,UAAQ,aAAa,IAAI;AACzB,OAAK,OAAO;AAAC;AAIX,SAAU,aAAa,KAAa;AACtC,MAAI,UAAqC,CAAA;AACzC,UAAQ,aAAa,IAAI;AACzB,UAAQ,eAAe,IAAI;AAC3B,OAAK,OAAO;AAAC;;;ACpBjB;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;;;ACAA,IAAM;AAAA,EACJ;AAAA,EACA,aAAAC;AACF,IAAI;AAEJ,IAAM,gBAAN,MAAoB;AAAA,EAClB,YAAa,WAAW;AACtB,SAAK,YAAY;AACjB,SAAK,gBAAgB,WAAW;AAEhC,SAAK,QAAQ,CAAC;AACd,SAAK,OAAO,CAAC;AAAA,EACf;AAAA,EAEA,cAAe,MAAM,WAAW;AAC9B,UAAM,cAAc,KAAK,SAAS;AAClC,UAAM,eAAe,cAAc;AACnC,QAAI,eAAe,cAAc;AAC/B,YAAMC,SAAQ,KAAK,KAAK,IAAI;AAC5B,UAAIA,WAAU,QAAW;AACvB,eAAOA;AAAA,MACT;AAAA,IACF,WAAW,YAAY,UAAU;AAC/B,YAAM,EAAE,KAAK,IAAI;AACjB,YAAM,IAAI,KAAK;AACf,YAAM,YAAY,eAAe,OAAO,IAAI,YAAY,CAAC;AACzD,eAAS,IAAI,GAAG,MAAM,GAAG,KAAK;AAC5B,cAAMA,SAAQ,KAAK,CAAC;AAEpB,cAAM,oBAAoB,eAAe,KAAK,aAAaA,QAAO,IAAI;AACtE,cAAM,qBAAqB,gBAAgBA,OAAM,IAAI,SAAS,EAAE,OAAO;AAEvE,YAAI,qBAAqB,oBAAoB;AAC3C,iBAAO,KAAK,OAAO,GAAG,CAAC,EAAE,CAAC;AAAA,QAC5B;AAAA,MACF;AAAA,IACF;AAEA,WAAO,KAAK,cAAc,IAAI;AAAA,EAChC;AAAA,EAEA,cAAe,MAAM;AACnB,UAAM,OAAO,OAAO,MAAM,UAAU,IAAI;AAExC,UAAM,EAAE,WAAW,cAAc,IAAI;AAErC,aAAS,IAAI,GAAG,MAAM,eAAe,KAAK;AACxC,YAAMA,SAAQ,KAAK,IAAI,IAAI,SAAS;AACpC,WAAK,KAAK,KAAKA,MAAK;AAAA,IACtB;AAEA,SAAK,MAAM,KAAK,IAAI;AAEpB,WAAO;AAAA,EACT;AAAA,EAEA,aAAcA,QAAO,MAAM;AACzB,UAAM,WAAWA,OAAM,IAAI,KAAK,SAAS;AAEzC,UAAM,EAAE,MAAM,YAAY,IAAI;AAE9B,UAAM,gBAAgB,IAAI,KAAK,IAAIA,MAAK,CAAC;AACzC,UAAM,cAAc,IAAI,KAAK,IAAI,QAAQ,CAAC;AAE1C,WAAO,cAAc,QAAQ,WAAW,KAAK,KACzC,YAAY,QAAQ,WAAW,KAAK;AAAA,EAC1C;AAAA,EAEA,UAAWA,QAAO;AAChB,SAAK,KAAK,KAAKA,MAAK;AAAA,EACtB;AACF;AAEA,SAAS,IAAK,MAAM;AAClB,QAAM,OAAQD,iBAAgB,IAAK,KAAK;AACxC,QAAM,OAAO,IAAI,CAAC,EAAE,IAAI,IAAI,EAAE,IAAI;AAClC,SAAO,KAAK,IAAI,IAAI;AACtB;AAEe,SAAR,cAAgC,WAAW;AAChD,SAAO,IAAI,cAAc,SAAS;AACpC;;;ACjFO,IAAM,SAAS;AAEf,SAAS,eAAgB,MAAM,QAAQ;AAC5C,MAAI,WAAW,QAAQ;AACrB,UAAM,IAAI,MAAM,OAAO,cAAc,MAAM;AAAA,EAC7C;AACF;;;ACJO,IAAM,eAAe;AAAA,EAC1B,MAAM;AAAA,EACN,MAAM;AACR;AAEO,IAAM,oBAAoB;AAAA,EAC/B,eAAe;AACjB;AAEA,IAAM,EAAE,aAAAE,aAAY,IAAI;AACxB,IAAM,wBAAwB;AAAA,EAC5B,YAAY;AACd;AAEO,SAAS,SAAUC,SAAQC,KAAI;AACpC,OAAK,SAASD;AACd,OAAK,KAAKC;AACV,OAAK,SAASD,QAAO,YAAY;AACnC;AAEA,SAAS,UAAU,aAAa,MAAM,IAAI,SAAS,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK;AAC9F,SAAO,KAAK,KAAK,QAAQ,GAAG;AAC9B,CAAC;AAED,SAAS,UAAU,mBAAmB,MAAM,IAAI,SAAS,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,eAAe,YAAY;AACrI,QAAM,SAAS,KAAK,KAAK,QAAQ,eAAe,UAAU;AAC1D,iBAAe,8BAA8B,MAAM;AACrD,CAAC;AAED,SAAS,UAAU,8BAA8B,MAAM,KAAK,SAAS,CAAC,WAAW,WAAW,OAAO,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO,cAAc,oBAAoB,UAAU;AAC3L,QAAM,SAAS,KAAK,KAAK,QAAQ,OAAO,cAAc,oBAAoB,QAAQ;AAClF,iBAAe,yCAAyC,MAAM;AAChE,CAAC;AAED,SAAS,UAAU,qBAAqB,MAAM,KAAK,SAAS,CAAC,WAAW,OAAO,WAAW,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,UAAU,MAAM,UAAU,iBAAiB,cAAc;AACnM,QAAM,SAAS,KAAK,KAAK,QAAQ,UAAU,MAAM,UAAU,iBAAiB,YAAY;AACxF,iBAAe,gCAAgC,MAAM;AACvD,CAAC;AAED,SAAS,UAAU,kBAAkB,MAAM,KAAK,SAAS,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,iBAAiB;AAChH,SAAO,KAAK,KAAK,QAAQ,eAAe;AAC1C,CAAC;AAED,SAAS,MAAO,QAAQE,UAASC,WAAU,SAAS;AAClD,MAAI,OAAO;AACX,SAAO,WAAY;AACjB,QAAI,SAAS,MAAM;AACjB,aAAO,IAAI,eAAe,KAAK,OAAO,KAAK,SAAS,KAAKJ,YAAW,EAAE,YAAY,GAAGG,UAASC,WAAU,qBAAqB;AAAA,IAC/H;AACA,QAAI,OAAO,CAAC,IAAI;AAChB,WAAO,KAAK,OAAO,MAAM,MAAM,SAAS;AACxC,WAAO,QAAQ,MAAM,MAAM,IAAI;AAAA,EACjC;AACF;;;ACvDO,SAAS,oBAAqB,SAAS,UAAU,EAAE,MAAM,GAAG;AACjE,MAAI,SAAS;AACb,MAAI,WAAW;AAEf,WAAS,IAAI,GAAG,MAAM,OAAO,KAAK;AAChC,UAAM,OAAO,YAAY,MAAM,MAAM;AAErC,UAAM,QAAQ,SAAS,MAAM,QAAQ;AACrC,QAAI,UAAU,MAAM;AAClB,aAAO;AAAA,IACT;AAEA,aAAS,KAAK;AACd,eAAW;AAAA,EACb;AAEA,SAAO;AACT;;;ACjBe,SAAR,QAA0B,SAAS;AACxC,MAAI,QAAQ;AACZ,MAAI,WAAW;AAEf,SAAO,YAAa,MAAM;AACxB,QAAI,CAAC,UAAU;AACb,cAAQ,QAAQ,GAAG,IAAI;AACvB,iBAAW;AAAA,IACb;AAEA,WAAO;AAAA,EACT;AACF;;;ACZe,SAAR,IAAsBC,SAAQC,KAAI;AACvC,OAAK,SAASD;AACd,OAAK,KAAKC;AACZ;AAEA,IAAMC,eAAc,QAAQ;AAE5B,IAAM,YAAY;AAElB,IAAM,iCAAiC;AAEvC,IAAM,4BAA4B;AAClC,IAAM,6BAA6B;AACnC,IAAM,0BAA0B;AAChC,IAAM,0BAA0B;AAChC,IAAM,2BAA2B;AACjC,IAAM,yBAAyB;AAC/B,IAAM,0BAA0B;AAChC,IAAM,2BAA2B;AACjC,IAAM,4BAA4B;AAClC,IAAM,0BAA0B;AAEhC,IAAM,uCAAuC;AAC7C,IAAM,wCAAwC;AAC9C,IAAM,qCAAqC;AAC3C,IAAM,qCAAqC;AAC3C,IAAM,sCAAsC;AAC5C,IAAM,oCAAoC;AAC1C,IAAM,qCAAqC;AAC3C,IAAM,sCAAsC;AAC5C,IAAM,uCAAuC;AAC7C,IAAM,qCAAqC;AAE3C,IAAM,mCAAmC;AACzC,IAAM,oCAAoC;AAC1C,IAAM,iCAAiC;AACvC,IAAM,iCAAiC;AACvC,IAAM,kCAAkC;AACxC,IAAM,gCAAgC;AACtC,IAAM,iCAAiC;AACvC,IAAM,kCAAkC;AACxC,IAAM,mCAAmC;AACzC,IAAM,iCAAiC;AAEvC,IAAM,0BAA0B;AAChC,IAAM,2BAA2B;AACjC,IAAM,wBAAwB;AAC9B,IAAM,wBAAwB;AAC9B,IAAM,yBAAyB;AAC/B,IAAM,uBAAuB;AAC7B,IAAM,wBAAwB;AAC9B,IAAM,yBAAyB;AAC/B,IAAM,0BAA0B;AAEhC,IAAM,0BAA0B;AAChC,IAAM,2BAA2B;AACjC,IAAM,wBAAwB;AAC9B,IAAM,wBAAwB;AAC9B,IAAM,yBAAyB;AAC/B,IAAM,uBAAuB;AAC7B,IAAM,wBAAwB;AAC9B,IAAM,yBAAyB;AAC/B,IAAM,0BAA0B;AAEhC,IAAM,iCAAiC;AACvC,IAAM,kCAAkC;AACxC,IAAM,+BAA+B;AACrC,IAAM,+BAA+B;AACrC,IAAM,gCAAgC;AACtC,IAAM,8BAA8B;AACpC,IAAM,+BAA+B;AACrC,IAAM,gCAAgC;AACtC,IAAM,iCAAiC;AAEvC,IAAM,iCAAiC;AACvC,IAAM,kCAAkC;AACxC,IAAM,+BAA+B;AACrC,IAAM,+BAA+B;AACrC,IAAM,gCAAgC;AACtC,IAAM,8BAA8B;AACpC,IAAM,+BAA+B;AACrC,IAAM,gCAAgC;AACtC,IAAM,iCAAiC;AAEvC,IAAM,mBAAmB;AAAA,EACvB,SAAS;AAAA,EACT,OAAO;AAAA,EACP,MAAM;AAAA,EACN,QAAQ;AAAA,EACR,OAAO;AAAA,EACP,OAAO;AAAA,EACP,OAAO;AAAA,EACP,OAAO;AAAA,EACP,QAAQ;AAAA,EACR,MAAM;AACR;AAEA,IAAM,6BAA6B;AAAA,EACjC,SAAS;AAAA,EACT,OAAO;AAAA,EACP,MAAM;AAAA,EACN,QAAQ;AAAA,EACR,OAAO;AAAA,EACP,OAAO;AAAA,EACP,OAAO;AAAA,EACP,OAAO;AAAA,EACP,QAAQ;AAAA,EACR,MAAM;AACR;AAEA,IAAM,yBAAyB;AAAA,EAC7B,SAAS;AAAA,EACT,OAAO;AAAA,EACP,MAAM;AAAA,EACN,QAAQ;AAAA,EACR,OAAO;AAAA,EACP,OAAO;AAAA,EACP,OAAO;AAAA,EACP,OAAO;AAAA,EACP,QAAQ;AAAA,EACR,MAAM;AACR;AAEA,IAAM,iBAAiB;AAAA,EACrB,SAAS;AAAA,EACT,OAAO;AAAA,EACP,MAAM;AAAA,EACN,QAAQ;AAAA,EACR,OAAO;AAAA,EACP,OAAO;AAAA,EACP,OAAO;AAAA,EACP,OAAO;AAAA,EACP,QAAQ;AACV;AAEA,IAAM,iBAAiB;AAAA,EACrB,SAAS;AAAA,EACT,OAAO;AAAA,EACP,MAAM;AAAA,EACN,QAAQ;AAAA,EACR,OAAO;AAAA,EACP,OAAO;AAAA,EACP,OAAO;AAAA,EACP,OAAO;AAAA,EACP,QAAQ;AACV;AAEA,IAAM,uBAAuB;AAAA,EAC3B,SAAS;AAAA,EACT,OAAO;AAAA,EACP,MAAM;AAAA,EACN,QAAQ;AAAA,EACR,OAAO;AAAA,EACP,OAAO;AAAA,EACP,OAAO;AAAA,EACP,OAAO;AAAA,EACP,QAAQ;AACV;AAEA,IAAM,uBAAuB;AAAA,EAC3B,SAAS;AAAA,EACT,OAAO;AAAA,EACP,MAAM;AAAA,EACN,QAAQ;AAAA,EACR,OAAO;AAAA,EACP,OAAO;AAAA,EACP,OAAO;AAAA,EACP,OAAO;AAAA,EACP,QAAQ;AACV;AAEA,IAAMC,yBAAwB;AAAA,EAC5B,YAAY;AACd;AAEA,IAAI,eAAe;AACnB,IAAI,aAAa,CAAC;AAClB,IAAI,UAAU,SAAU,KAAK;AAC3B,aAAW,QAAQ,IAAI,iBAAiB,GAAG;AAC3C,eAAa,CAAC;AAChB;AAEA,SAAS,SAAU,WAAW;AAC5B,aAAW,KAAK,SAAS;AACzB,SAAO;AACT;AAEA,SAAS,OAAQ,UAAU;AACzB,MAAI,iBAAiB,MAAM;AACzB,mBAAe,SAAS,OAAO,YAAY;AAAA,EAC7C;AACA,SAAO;AACT;AAEA,SAASC,OAAO,QAAQC,UAASC,WAAU,SAAS;AAClD,MAAI,OAAO;AACX,SAAO,WAAY;AACjB,QAAI,SAAS,MAAM;AACjB,aAAO,IAAI,eAAe,OAAO,IAAI,EAAE,IAAI,SAASJ,YAAW,EAAE,YAAY,GAAGG,UAASC,WAAUH,sBAAqB;AAAA,IAC1H;AACA,QAAI,OAAO,CAAC,IAAI;AAChB,WAAO,KAAK,OAAO,MAAM,MAAM,SAAS;AACxC,WAAO,QAAQ,MAAM,MAAM,IAAI;AAAA,EACjC;AACF;AAEA,IAAI,UAAU,aAAaC,OAAM,GAAG,SAAS,CAAC,SAAS,GAAG,SAAU,MAAM;AACxE,SAAO,KAAK,KAAK,MAAM;AACzB,CAAC;AAED,IAAI,UAAU,YAAYA,OAAM,GAAG,WAAW,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,MAAM;AAC1F,QAAM,SAAS,KAAK,KAAK,QAAQ,OAAO,gBAAgB,IAAI,CAAC;AAC7D,OAAK,wBAAwB;AAC7B,SAAO;AACT,CAAC;AAED,IAAI,UAAU,0BAA0B,WAAY;AAClD,QAAM,YAAY,KAAK,kBAAkB;AACzC,MAAI,UAAU,OAAO,GAAG;AACtB;AAAA,EACF;AACA,OAAK,eAAe;AACpB,QAAMJ,UAAS,KAAK,aAAa,SAAS;AAC1C,OAAK,eAAe,SAAS;AAE7B,QAAM,cAAc,KAAK,SAAS,WAAW,CAAC,CAAC,EAAE,KAAK,QAAQA,SAAQ,KAAK,eAAe,EAAE,QAAQ;AACpG,QAAM,iBAAiB,KAAK,cAAc,WAAW;AACrD,OAAK,eAAe,WAAW;AAE/B,QAAM,QAAQ,IAAI,MAAM,cAAc;AACtC,QAAM,KAAKA;AACX,SAAO,SAAS,OAAO,0BAA0B,KAAK,IAAIA,OAAM,CAAC;AAEjE,QAAM;AACR;AAEA,SAAS,0BAA2BC,KAAID,SAAQ;AAC9C,SAAO,WAAY;AACjB,IAAAC,IAAG,QAAQ,SAAO;AAChB,UAAI,gBAAgBD,OAAM;AAAA,IAC5B,CAAC;AAAA,EACH;AACF;AAEA,IAAI,UAAU,sBAAsBI,OAAM,GAAG,WAAW,CAAC,WAAW,SAAS,GAAG,SAAU,MAAMG,SAAQ;AACtG,SAAO,KAAK,KAAK,QAAQA,OAAM;AACjC,CAAC;AAED,IAAI,UAAU,qBAAqBH,OAAM,GAAG,WAAW,CAAC,WAAW,SAAS,GAAG,SAAU,MAAMG,SAAQ;AACrG,SAAO,KAAK,KAAK,QAAQA,OAAM;AACjC,CAAC;AAED,IAAI,UAAU,oBAAoBH,OAAM,GAAG,WAAW,CAAC,WAAW,WAAW,WAAW,OAAO,GAAG,SAAU,MAAM,OAAO,UAAU,UAAU;AAC3I,SAAO,KAAK,KAAK,QAAQ,OAAO,UAAU,QAAQ;AACpD,CAAC;AAED,IAAI,UAAU,gBAAgBA,OAAM,IAAI,WAAW,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO;AAChG,SAAO,KAAK,KAAK,QAAQ,KAAK;AAChC,CAAC;AAED,IAAI,UAAU,mBAAmBA,OAAM,IAAI,SAAS,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,QAAQ,QAAQ;AACrH,SAAO,CAAC,CAAC,KAAK,KAAK,QAAQ,QAAQ,MAAM;AAC3C,CAAC;AAED,IAAI,UAAU,mBAAmBA,OAAM,IAAI,WAAW,CAAC,WAAW,WAAW,WAAW,OAAO,GAAG,SAAU,MAAM,OAAO,SAAS,UAAU;AAC1I,SAAO,KAAK,KAAK,QAAQ,OAAO,SAAS,QAAQ;AACnD,CAAC;AAED,IAAI,UAAU,QAAQA,OAAM,IAAI,SAAS,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK;AACpF,SAAO,KAAK,KAAK,QAAQ,GAAG;AAC9B,CAAC;AAED,IAAI,UAAU,oBAAoBA,OAAM,IAAI,WAAW,CAAC,SAAS,GAAG,SAAU,MAAM;AAClF,SAAO,KAAK,KAAK,MAAM;AACzB,CAAC;AAED,IAAI,UAAU,oBAAoBA,OAAM,IAAI,QAAQ,CAAC,SAAS,GAAG,SAAU,MAAM;AAC/E,OAAK,KAAK,MAAM;AAClB,CAAC;AAED,IAAI,UAAU,iBAAiBA,OAAM,IAAI,QAAQ,CAAC,SAAS,GAAG,SAAU,MAAM;AAC5E,OAAK,KAAK,MAAM;AAClB,CAAC;AAED,IAAI,UAAU,iBAAiBA,OAAM,IAAI,SAAS,CAAC,WAAW,OAAO,GAAG,SAAU,MAAM,UAAU;AAChG,SAAO,KAAK,KAAK,QAAQ,QAAQ;AACnC,CAAC;AAED,IAAI,UAAU,gBAAgBA,OAAM,IAAI,WAAW,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,QAAQ;AACjG,SAAO,KAAK,KAAK,QAAQ,MAAM;AACjC,CAAC;AAED,IAAI,UAAU,eAAeA,OAAM,IAAI,WAAW,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK;AAC7F,SAAO,KAAK,KAAK,QAAQ,GAAG;AAC9B,CAAC;AAED,IAAI,UAAU,kBAAkBA,OAAM,IAAI,QAAQ,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,WAAW;AACnG,OAAK,KAAK,QAAQ,SAAS;AAC7B,CAAC;AAED,IAAI,UAAU,iBAAiBA,OAAM,IAAI,QAAQ,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,UAAU;AACjG,OAAK,KAAK,QAAQ,QAAQ;AAC5B,CAAC;AAED,IAAI,UAAU,eAAeA,OAAM,IAAI,SAAS,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,MAAM,MAAM;AAC7G,SAAO,CAAC,CAAC,KAAK,KAAK,QAAQ,MAAM,IAAI;AACvC,CAAC;AAED,IAAI,UAAU,cAAcA,OAAM,IAAI,WAAW,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK;AAC5F,SAAO,KAAK,KAAK,QAAQ,GAAG;AAC9B,CAAC;AAED,IAAI,UAAU,cAAcA,OAAM,IAAI,WAAW,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO;AAC9F,SAAO,KAAK,KAAK,QAAQ,KAAK;AAChC,CAAC;AAED,IAAI,UAAU,iBAAiBA,OAAM,IAAI,WAAW,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK;AAC/F,SAAO,KAAK,KAAK,QAAQ,GAAG;AAC9B,CAAC;AAED,IAAI,UAAU,eAAeA,OAAM,IAAI,SAAS,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK,OAAO;AAC7G,SAAO,CAAC,CAAC,KAAK,KAAK,QAAQ,KAAK,KAAK;AACvC,CAAC;AAED,IAAI,UAAU,cAAcA,OAAM,IAAI,WAAW,CAAC,WAAW,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO,MAAM,KAAK;AAC/H,SAAO,KAAK,KAAK,QAAQ,OAAO,OAAO,gBAAgB,IAAI,GAAG,OAAO,gBAAgB,GAAG,CAAC;AAC3F,CAAC;AAED,IAAI,UAAU,aAAaA,OAAM,IAAI,WAAW,CAAC,WAAW,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO,MAAM,KAAK;AAC9H,SAAO,KAAK,KAAK,QAAQ,OAAO,OAAO,gBAAgB,IAAI,GAAG,OAAO,gBAAgB,GAAG,CAAC;AAC3F,CAAC;AAED,IAAI,UAAU,cAAcA,OAAM,KAAK,SAAS,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK,SAAS;AAC/G,SAAO,KAAK,KAAK,QAAQ,KAAK,OAAO;AACvC,CAAC;AAED,IAAI,UAAU,oBAAoBA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO,MAAM,KAAK;AACtI,SAAO,KAAK,KAAK,QAAQ,OAAO,OAAO,gBAAgB,IAAI,GAAG,OAAO,gBAAgB,GAAG,CAAC;AAC3F,CAAC;AAED,IAAI,UAAU,mBAAmBA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO,MAAM,KAAK;AACrI,SAAO,KAAK,KAAK,QAAQ,OAAO,OAAO,gBAAgB,IAAI,GAAG,OAAO,gBAAgB,GAAG,CAAC;AAC3F,CAAC;AAED,IAAI,UAAU,oBAAoBA,OAAM,KAAK,SAAS,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK,SAAS;AACrH,SAAO,KAAK,KAAK,QAAQ,KAAK,OAAO;AACvC,CAAC;AAED,IAAI,UAAU,kBAAkBA,OAAM,KAAK,SAAS,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK;AAC/F,SAAO,KAAK,KAAK,QAAQ,GAAG;AAC9B,CAAC;AAED,IAAI,UAAU,iBAAiBA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK;AAC3G,SAAO,KAAK,KAAK,QAAQ,KAAK,IAAI;AACpC,CAAC;AAED,IAAI,UAAU,qBAAqBA,OAAM,KAAK,QAAQ,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK,KAAK;AACjH,OAAK,KAAK,QAAQ,KAAK,GAAG;AAC5B,CAAC;AAED,IAAI,UAAU,eAAeA,OAAM,KAAK,WAAW,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK;AAC9F,QAAM,MAAM,OAAO,gBAAgB,GAAG;AACtC,SAAO,KAAK,KAAK,QAAQ,GAAG;AAC9B,CAAC;AAED,IAAI,UAAU,oBAAoBA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK;AAC9G,SAAO,KAAK,KAAK,QAAQ,KAAK,IAAI;AACpC,CAAC;AAED,IAAI,UAAU,wBAAwBA,OAAM,KAAK,QAAQ,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK,KAAK;AACpH,OAAK,KAAK,QAAQ,KAAK,GAAG;AAC5B,CAAC;AAED,IAAI,UAAU,iBAAiBA,OAAM,KAAK,SAAS,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO;AAChG,SAAO,KAAK,KAAK,QAAQ,KAAK;AAChC,CAAC;AAED,IAAI,UAAU,iBAAiBA,OAAM,KAAK,WAAW,CAAC,WAAW,SAAS,WAAW,SAAS,GAAG,SAAU,MAAM,QAAQ,cAAc,gBAAgB;AACrJ,SAAO,KAAK,KAAK,QAAQ,QAAQ,cAAc,cAAc;AAC/D,CAAC;AAED,IAAI,UAAU,wBAAwBA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,OAAO,GAAG,SAAU,MAAM,OAAO,OAAO;AACzH,SAAO,KAAK,KAAK,QAAQ,OAAO,KAAK;AACvC,CAAC;AAED,IAAI,UAAU,wBAAwBA,OAAM,KAAK,QAAQ,CAAC,WAAW,WAAW,SAAS,SAAS,GAAG,SAAU,MAAM,OAAO,OAAO,OAAO;AACxI,OAAK,KAAK,QAAQ,OAAO,OAAO,KAAK;AACvC,CAAC;AAED,IAAI,UAAU,kBAAkBA,OAAM,KAAK,WAAW,CAAC,WAAW,OAAO,GAAG,SAAU,MAAM,QAAQ;AAClG,SAAO,KAAK,KAAK,QAAQ,MAAM;AACjC,CAAC;AAED,IAAI,UAAU,eAAeA,OAAM,KAAK,WAAW,CAAC,WAAW,OAAO,GAAG,SAAU,MAAM,QAAQ;AAC/F,SAAO,KAAK,KAAK,QAAQ,MAAM;AACjC,CAAC;AAED,IAAI,UAAU,eAAeA,OAAM,KAAK,WAAW,CAAC,WAAW,OAAO,GAAG,SAAU,MAAM,QAAQ;AAC/F,SAAO,KAAK,KAAK,QAAQ,MAAM;AACjC,CAAC;AAED,IAAI,UAAU,gBAAgBA,OAAM,KAAK,WAAW,CAAC,WAAW,OAAO,GAAG,SAAU,MAAM,QAAQ;AAChG,SAAO,KAAK,KAAK,QAAQ,MAAM;AACjC,CAAC;AAED,IAAI,UAAU,cAAcA,OAAM,KAAK,WAAW,CAAC,WAAW,OAAO,GAAG,SAAU,MAAM,QAAQ;AAC9F,SAAO,KAAK,KAAK,QAAQ,MAAM;AACjC,CAAC;AAED,IAAI,UAAU,eAAeA,OAAM,KAAK,WAAW,CAAC,WAAW,OAAO,GAAG,SAAU,MAAM,QAAQ;AAC/F,SAAO,KAAK,KAAK,QAAQ,MAAM;AACjC,CAAC;AAED,IAAI,UAAU,gBAAgBA,OAAM,KAAK,WAAW,CAAC,WAAW,OAAO,GAAG,SAAU,MAAM,QAAQ;AAChG,SAAO,KAAK,KAAK,QAAQ,MAAM;AACjC,CAAC;AAED,IAAI,UAAU,iBAAiBA,OAAM,KAAK,WAAW,CAAC,WAAW,OAAO,GAAG,SAAU,MAAM,QAAQ;AACjG,SAAO,KAAK,KAAK,QAAQ,MAAM;AACjC,CAAC;AAED,IAAI,UAAU,0BAA0BA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO;AACtH,SAAO,KAAK,KAAK,QAAQ,OAAO,IAAI;AACtC,CAAC;AAED,IAAI,UAAU,uBAAuBA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO;AACnH,SAAO,KAAK,KAAK,QAAQ,OAAO,IAAI;AACtC,CAAC;AAED,IAAI,UAAU,uBAAuBA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO;AACnH,SAAO,KAAK,KAAK,QAAQ,OAAO,IAAI;AACtC,CAAC;AAED,IAAI,UAAU,wBAAwBA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO;AACpH,SAAO,KAAK,KAAK,QAAQ,OAAO,IAAI;AACtC,CAAC;AAED,IAAI,UAAU,sBAAsBA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO;AAClH,SAAO,KAAK,KAAK,QAAQ,OAAO,IAAI;AACtC,CAAC;AAED,IAAI,UAAU,uBAAuBA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO;AACnH,SAAO,KAAK,KAAK,QAAQ,OAAO,IAAI;AACtC,CAAC;AAED,IAAI,UAAU,wBAAwBA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO;AACpH,SAAO,KAAK,KAAK,QAAQ,OAAO,IAAI;AACtC,CAAC;AAED,IAAI,UAAU,yBAAyBA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,SAAS,GAAG,SAAU,MAAM,OAAO;AACrH,SAAO,KAAK,KAAK,QAAQ,OAAO,IAAI;AACtC,CAAC;AAED,IAAI,UAAU,8BAA8BA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,WAAW,OAAO,GAAG,SAAU,MAAM,OAAO,QAAQ;AAC3I,OAAK,KAAK,QAAQ,OAAO,QAAQ,SAAS;AAC5C,CAAC;AAED,IAAI,UAAU,2BAA2BA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,WAAW,OAAO,GAAG,SAAU,MAAM,OAAO,QAAQ;AACxI,OAAK,KAAK,QAAQ,OAAO,QAAQ,SAAS;AAC5C,CAAC;AAED,IAAI,UAAU,2BAA2BA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,WAAW,OAAO,GAAG,SAAU,MAAM,OAAO,QAAQ;AACxI,OAAK,KAAK,QAAQ,OAAO,QAAQ,SAAS;AAC5C,CAAC;AAED,IAAI,UAAU,4BAA4BA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,WAAW,OAAO,GAAG,SAAU,MAAM,OAAO,QAAQ;AACzI,OAAK,KAAK,QAAQ,OAAO,QAAQ,SAAS;AAC5C,CAAC;AAED,IAAI,UAAU,0BAA0BA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,WAAW,OAAO,GAAG,SAAU,MAAM,OAAO,QAAQ;AACvI,OAAK,KAAK,QAAQ,OAAO,QAAQ,SAAS;AAC5C,CAAC;AAED,IAAI,UAAU,2BAA2BA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,WAAW,OAAO,GAAG,SAAU,MAAM,OAAO,QAAQ;AACxI,OAAK,KAAK,QAAQ,OAAO,QAAQ,SAAS;AAC5C,CAAC;AAED,IAAI,UAAU,4BAA4BA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,WAAW,OAAO,GAAG,SAAU,MAAM,OAAO,QAAQ;AACzI,OAAK,KAAK,QAAQ,OAAO,QAAQ,SAAS;AAC5C,CAAC;AAED,IAAI,UAAU,6BAA6BA,OAAM,KAAK,WAAW,CAAC,WAAW,WAAW,WAAW,OAAO,GAAG,SAAU,MAAM,OAAO,QAAQ;AAC1I,OAAK,KAAK,QAAQ,OAAO,QAAQ,SAAS;AAC5C,CAAC;AAED,IAAI,UAAU,qBAAqBA,OAAM,KAAK,QAAQ,CAAC,WAAW,WAAW,OAAO,OAAO,SAAS,GAAG,SAAU,MAAM,OAAO,OAAO,QAAQ,QAAQ;AACnJ,OAAK,KAAK,QAAQ,OAAO,OAAO,QAAQ,MAAM;AAChD,CAAC;AAED,IAAI,UAAU,wBAAwBA,OAAM,KAAK,QAAQ,CAAC,WAAW,WAAW,SAAS,SAAS,SAAS,GAAG,SAAU,MAAM,OAAO,OAAO,QAAQ,QAAQ;AAC1J,OAAK,KAAK,QAAQ,OAAO,OAAO,QAAQ,MAAM;AAChD,CAAC;AAED,IAAI,UAAU,qBAAqBA,OAAM,KAAK,QAAQ,CAAC,WAAW,WAAW,SAAS,SAAS,SAAS,GAAG,SAAU,MAAM,OAAO,OAAO,QAAQ,QAAQ;AACvJ,OAAK,KAAK,QAAQ,OAAO,OAAO,QAAQ,MAAM;AAChD,CAAC;AAED,IAAI,UAAU,qBAAqBA,OAAM,KAAK,QAAQ,CAAC,WAAW,WAAW,SAAS,SAAS,SAAS,GAAG,SAAU,MAAM,OAAO,OAAO,QAAQ,QAAQ;AACvJ,OAAK,KAAK,QAAQ,OAAO,OAAO,QAAQ,MAAM;AAChD,CAAC;AAED,IAAI,UAAU,sBAAsBA,OAAM,KAAK,QAAQ,CAAC,WAAW,WAAW,SAAS,SAAS,SAAS,GAAG,SAAU,MAAM,OAAO,OAAO,QAAQ,QAAQ;AACxJ,OAAK,KAAK,QAAQ,OAAO,OAAO,QAAQ,MAAM;AAChD,CAAC;AAED,IAAI,UAAU,oBAAoBA,OAAM,KAAK,QAAQ,CAAC,WAAW,WAAW,SAAS,SAAS,SAAS,GAAG,SAAU,MAAM,OAAO,OAAO,QAAQ,QAAQ;AACtJ,OAAK,KAAK,QAAQ,OAAO,OAAO,QAAQ,MAAM;AAChD,CAAC;AAED,IAAI,UAAU,qBAAqBA,OAAM,KAAK,QAAQ,CAAC,WAAW,WAAW,SAAS,SAAS,SAAS,GAAG,SAAU,MAAM,OAAO,OAAO,QAAQ,QAAQ;AACvJ,OAAK,KAAK,QAAQ,OAAO,OAAO,QAAQ,MAAM;AAChD,CAAC;AAED,IAAI,UAAU,sBAAsBA,OAAM,KAAK,QAAQ,CAAC,WAAW,WAAW,SAAS,SAAS,SAAS,GAAG,SAAU,MAAM,OAAO,OAAO,QAAQ,QAAQ;AACxJ,OAAK,KAAK,QAAQ,OAAO,OAAO,QAAQ,MAAM;AAChD,CAAC;AAED,IAAI,UAAU,uBAAuBA,OAAM,KAAK,QAAQ,CAAC,WAAW,WAAW,SAAS,SAAS,SAAS,GAAG,SAAU,MAAM,OAAO,OAAO,QAAQ,QAAQ;AACzJ,OAAK,KAAK,QAAQ,OAAO,OAAO,QAAQ,MAAM;AAChD,CAAC;AAED,IAAI,UAAU,kBAAkBA,OAAM,KAAK,SAAS,CAAC,WAAW,WAAW,WAAW,OAAO,GAAG,SAAU,MAAM,OAAO,SAAS,YAAY;AAC1I,SAAO,KAAK,KAAK,QAAQ,OAAO,SAAS,UAAU;AACrD,CAAC;AAED,IAAI,UAAU,eAAeA,OAAM,KAAK,SAAS,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK;AAC5F,SAAO,KAAK,KAAK,QAAQ,GAAG;AAC9B,CAAC;AAED,IAAI,UAAU,cAAcA,OAAM,KAAK,SAAS,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK;AAC3F,SAAO,KAAK,KAAK,QAAQ,GAAG;AAC9B,CAAC;AAED,IAAI,UAAU,yBAAyBA,OAAM,KAAK,WAAW,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK;AACxG,SAAO,KAAK,KAAK,QAAQ,GAAG;AAC9B,CAAC;AAED,IAAI,UAAU,mBAAmBA,OAAM,KAAK,SAAS,CAAC,WAAW,SAAS,GAAG,SAAU,MAAM,KAAK;AAChG,SAAO,KAAK,KAAK,QAAQ,GAAG;AAC9B,CAAC;AAED,IAAM,gBAAgB,oBAAI,IAAI;AAE9B,SAAS,YAAa,QAAQC,UAASC,WAAU,SAAS;AACxD,SAAO,gBAAgB,MAAM,KAAK,iBAAiB,QAAQD,UAASC,WAAU,OAAO;AACvF;AAEA,SAAS,SAAU,QAAQD,UAASC,WAAU,SAAS;AACrD,SAAO,gBAAgB,MAAM,KAAK,cAAc,QAAQD,UAASC,WAAU,OAAO;AACpF;AAEA,SAAS,mBAAoB,QAAQD,UAASC,WAAU,SAAS;AAC/D,SAAO,gBAAgB,MAAM,KAAK,wBAAwB,QAAQD,UAASC,WAAU,OAAO;AAC9F;AAEA,SAAS,gBAAiB,KAAK,QAAQ,WAAW,QAAQD,UAASC,WAAU,SAAS;AACpF,MAAI,YAAY,QAAW;AACzB,WAAO,UAAU,KAAK,QAAQD,UAASC,WAAU,OAAO;AAAA,EAC1D;AAEA,QAAM,MAAM,CAAC,QAAQ,QAAQD,QAAO,EAAE,OAAOC,SAAQ,EAAE,KAAK,GAAG;AAC/D,MAAIE,KAAI,cAAc,IAAI,GAAG;AAC7B,MAAIA,OAAM,QAAW;AACnB,IAAAA,KAAI,UAAU,KAAK,QAAQH,UAASC,WAAUH,sBAAqB;AACnE,kBAAc,IAAI,KAAKK,EAAC;AAAA,EAC1B;AACA,SAAOA;AACT;AAEA,SAAS,gBAAiB,KAAK,QAAQH,UAASC,WAAU,SAAS;AACjE,SAAO,IAAI;AAAA,IACT,OAAO,GAAG,EAAE,IAAI,SAASJ,YAAW,EAAE,YAAY;AAAA,IAClDG;AAAA,IACA,CAAC,WAAW,WAAW,SAAS,EAAE,OAAOC,SAAQ;AAAA,IACjD;AAAA,EAAO;AACX;AAEA,SAAS,aAAc,KAAK,QAAQD,UAASC,WAAU,SAAS;AAC9D,SAAO,IAAI;AAAA,IACT,OAAO,GAAG,EAAE,IAAI,SAASJ,YAAW,EAAE,YAAY;AAAA,IAClDG;AAAA,IACA,CAAC,WAAW,WAAW,WAAW,KAAK,EAAE,OAAOC,SAAQ;AAAA,IACxD;AAAA,EAAO;AACX;AAEA,SAAS,uBAAwB,KAAK,QAAQD,UAASC,WAAU,SAAS;AACxE,SAAO,IAAI;AAAA,IACT,OAAO,GAAG,EAAE,IAAI,SAASJ,YAAW,EAAE,YAAY;AAAA,IAClDG;AAAA,IACA,CAAC,WAAW,WAAW,WAAW,WAAW,KAAK,EAAE,OAAOC,SAAQ;AAAA,IACnE;AAAA,EAAO;AACX;AAEA,IAAI,UAAU,cAAc,SAAUA,WAAU,SAAS;AACvD,SAAO,SAAS,KAAK,MAAM,gCAAgC,WAAWA,WAAU,OAAO;AACzF;AAEA,IAAI,UAAU,WAAW,SAAUD,UAASC,WAAU,SAAS;AAC7D,QAAM,SAAS,iBAAiBD,QAAO;AACvC,MAAI,WAAW,QAAW;AACxB,UAAM,IAAI,MAAM,uBAAuBA,QAAO;AAAA,EAChD;AACA,SAAO,SAAS,KAAK,MAAM,QAAQA,UAASC,WAAU,OAAO;AAC/D;AAEA,IAAI,UAAU,qBAAqB,SAAUD,UAASC,WAAU,SAAS;AACvE,QAAM,SAAS,2BAA2BD,QAAO;AACjD,MAAI,WAAW,QAAW;AACxB,UAAM,IAAI,MAAM,uBAAuBA,QAAO;AAAA,EAChD;AACA,SAAO,mBAAmB,KAAK,MAAM,QAAQA,UAASC,WAAU,OAAO;AACzE;AAEA,IAAI,UAAU,iBAAiB,SAAUD,UAASC,WAAU,SAAS;AACnE,QAAM,SAAS,uBAAuBD,QAAO;AAC7C,MAAI,WAAW,QAAW;AACxB,UAAM,IAAI,MAAM,uBAAuBA,QAAO;AAAA,EAChD;AACA,SAAO,SAAS,KAAK,MAAM,QAAQA,UAASC,WAAU,OAAO;AAC/D;AAEA,IAAI,UAAU,WAAW,SAAU,WAAW;AAC5C,QAAM,SAAS,eAAe,SAAS;AACvC,MAAI,WAAW,QAAW;AACxB,UAAM,IAAI,MAAM,uBAAuB,SAAS;AAAA,EAClD;AACA,SAAO,YAAY,KAAK,MAAM,QAAQ,WAAW,CAAC,CAAC;AACrD;AAEA,IAAI,UAAU,iBAAiB,SAAU,WAAW;AAClD,QAAM,SAAS,qBAAqB,SAAS;AAC7C,MAAI,WAAW,QAAW;AACxB,UAAM,IAAI,MAAM,uBAAuB,SAAS;AAAA,EAClD;AACA,SAAO,YAAY,KAAK,MAAM,QAAQ,WAAW,CAAC,CAAC;AACrD;AAEA,IAAI,UAAU,WAAW,SAAU,WAAW;AAC5C,QAAM,SAAS,eAAe,SAAS;AACvC,MAAI,WAAW,QAAW;AACxB,UAAM,IAAI,MAAM,uBAAuB,SAAS;AAAA,EAClD;AACA,SAAO,YAAY,KAAK,MAAM,QAAQ,QAAQ,CAAC,SAAS,CAAC;AAC3D;AAEA,IAAI,UAAU,iBAAiB,SAAU,WAAW;AAClD,QAAM,SAAS,qBAAqB,SAAS;AAC7C,MAAI,WAAW,QAAW;AACxB,UAAM,IAAI,MAAM,uBAAuB,SAAS;AAAA,EAClD;AACA,SAAO,YAAY,KAAK,MAAM,QAAQ,QAAQ,CAAC,SAAS,CAAC;AAC3D;AAEA,IAAI,gBAAgB;AACpB,IAAI,UAAU,gBAAgB,WAAY;AACxC,MAAI,kBAAkB,MAAM;AAC1B,UAAMN,UAAS,KAAK,UAAU,iBAAiB;AAC/C,QAAI;AACF,YAAMS,OAAM,KAAK,YAAY,KAAK,MAAMT,OAAM;AAC9C,sBAAgB;AAAA,QACd,QAAQ,SAAS,KAAK,aAAaA,OAAM,CAAC;AAAA,QAC1C,SAASS,KAAI,WAAW,sBAAsB;AAAA,QAC9C,eAAeA,KAAI,iBAAiB,sBAAsB;AAAA,QAC1D,sBAAsBA,KAAI,wBAAwB,4BAA4B;AAAA,QAC9E,yBAAyBA,KAAI,2BAA2B,oCAAoC;AAAA,QAC5F,oBAAoBA,KAAI,sBAAsB,+BAA+B;AAAA,QAC7E,mBAAmBA,KAAI,qBAAqB,8BAA8B;AAAA,QAC1E,SAASA,KAAI,WAAW,KAAK;AAAA,QAC7B,aAAaA,KAAI,eAAe,KAAK;AAAA,QACrC,aAAaA,KAAI,eAAe,KAAK;AAAA,QACrC,kBAAkBA,KAAI,oBAAoB,qBAAqB;AAAA,MACjE;AAAA,IACF,UAAE;AACA,WAAK,eAAeT,OAAM;AAAA,IAC5B;AAAA,EACF;AACA,SAAO;AACT;AAEA,IAAI,iBAAiB;AACrB,IAAI,UAAU,iBAAiB,WAAY;AACzC,MAAI,mBAAmB,MAAM;AAC3B,UAAMA,UAAS,KAAK,UAAU,kBAAkB;AAChD,QAAI;AACF,YAAMS,OAAM,KAAK,YAAY,KAAK,MAAMT,OAAM;AAC9C,uBAAiB;AAAA,QACf,QAAQ,SAAS,KAAK,aAAaA,OAAM,CAAC;AAAA,QAC1C,UAAUS,KAAI,YAAY,sBAAsB;AAAA,QAChD,UAAUA,KAAI,YAAY,qBAAqB;AAAA,MACjD;AAAA,IACF,UAAE;AACA,WAAK,eAAeT,OAAM;AAAA,IAC5B;AAAA,EACF;AACA,SAAO;AACT;AAEA,IAAI,6BAA6B;AACjC,IAAI,UAAU,6BAA6B,WAAY;AACrD,MAAI,+BAA+B,MAAM;AACvC,UAAMA,UAAS,KAAK,UAAU,+BAA+B;AAC7D,QAAI;AACF,mCAA6B;AAAA,QAC3B,0BAA0B,KAAK,YAAYA,SAAQ,4BAA4B,6BAA6B;AAAA,MAC9G;AAAA,IACF,UAAE;AACA,WAAK,eAAeA,OAAM;AAAA,IAC5B;AAAA,EACF;AACA,SAAO;AACT;AAEA,IAAI,wBAAwB;AAC5B,IAAI,UAAU,wBAAwB,WAAY;AAChD,MAAI,0BAA0B,MAAM;AAClC,UAAMA,UAAS,KAAK,UAAU,0BAA0B;AACxD,QAAI;AACF,YAAMS,OAAM,KAAK,YAAY,KAAK,MAAMT,OAAM;AAC9C,8BAAwB;AAAA,QACtB,SAASS,KAAI,WAAW,sBAAsB;AAAA,QAC9C,0BAA0BA,KAAI,4BAA4B,6BAA6B;AAAA,QACvF,mBAAmBA,KAAI,qBAAqB,sBAAsB;AAAA,QAClE,sBAAsBA,KAAI,wBAAwB,4BAA4B;AAAA,QAC9E,0BAA0BA,KAAI,4BAA4B,6BAA6B;AAAA,QACvF,cAAcA,KAAI,gBAAgB,KAAK;AAAA,QACvC,WAAWA,KAAI,aAAa,KAAK;AAAA,MACnC;AAAA,IACF,UAAE;AACA,WAAK,eAAeT,OAAM;AAAA,IAC5B;AAAA,EACF;AACA,SAAO;AACT;AAEA,IAAI,uBAAuB;AAC3B,IAAI,UAAU,uBAAuB,WAAY;AAC/C,MAAI,yBAAyB,MAAM;AACjC,UAAMA,UAAS,KAAK,UAAU,yBAAyB;AACvD,QAAI;AACF,YAAMS,OAAM,KAAK,YAAY,KAAK,MAAMT,OAAM;AAC9C,6BAAuB;AAAA,QACrB,SAASS,KAAI,WAAW,sBAAsB;AAAA,QAC9C,SAASA,KAAI,WAAW,qBAAqB;AAAA,QAC7C,gBAAgBA,KAAI,kBAAkB,4BAA4B;AAAA,QAClE,cAAcA,KAAI,gBAAgB,KAAK;AAAA,QACvC,UAAUA,KAAI,YAAY,sBAAsB;AAAA,MAClD;AAAA,IACF,UAAE;AACA,WAAK,eAAeT,OAAM;AAAA,IAC5B;AAAA,EACF;AACA,SAAO;AACT;AAEA,IAAI,8BAA8B;AAClC,IAAI,UAAU,8BAA8B,WAAY;AACtD,MAAI,gCAAgC,MAAM;AACxC,UAAMA,UAAS,KAAK,UAAU,gCAAgC;AAC9D,QAAI;AACF,YAAMS,OAAM,KAAK,YAAY,KAAK,MAAMT,OAAM;AAC9C,oCAA8B;AAAA,QAC5B,QAAQ,SAAS,KAAK,aAAaA,OAAM,CAAC;AAAA,QAC1C,SAASS,KAAI,WAAW,sBAAsB;AAAA,QAC9C,WAAWA,KAAI,aAAa,6BAA6B;AAAA,QACzD,uBAAuBA,KAAI,yBAAyB,0CAA0C;AAAA,MAChG;AAAA,IACF,UAAE;AACA,WAAK,eAAeT,OAAM;AAAA,IAC5B;AAAA,EACF;AACA,SAAO;AACT;AAEA,IAAI,8BAA8B;AAClC,IAAI,UAAU,8BAA8B,WAAY;AACtD,MAAI,gCAAgC,MAAM;AACxC,UAAMA,UAAS,KAAK,UAAU,gCAAgC;AAC9D,QAAI;AACF,YAAMS,OAAM,KAAK,YAAY,KAAK,MAAMT,OAAM;AAC9C,oCAA8B;AAAA,QAC5B,QAAQ,SAAS,KAAK,aAAaA,OAAM,CAAC;AAAA,QAC1C,gBAAgBS,KAAI,kBAAkB,6BAA6B;AAAA,QACnE,gBAAgBA,KAAI,kBAAkB,6BAA6B;AAAA,MACrE;AAAA,IACF,UAAE;AACA,WAAK,eAAeT,OAAM;AAAA,IAC5B;AAAA,EACF;AACA,SAAO;AACT;AAEA,IAAI,kCAAkC;AACtC,IAAI,UAAU,kCAAkC,WAAY;AAC1D,MAAI,oCAAoC,MAAM;AAC5C,UAAMA,UAAS,KAAK,UAAU,oCAAoC;AAClE,QAAI;AACF,wCAAkC;AAAA,QAChC,QAAQ,SAAS,KAAK,aAAaA,OAAM,CAAC;AAAA,QAC1C,yBAAyB,KAAK,YAAYA,SAAQ,2BAA2B,4BAA4B;AAAA,MAC3G;AAAA,IACF,UAAE;AACA,WAAK,eAAeA,OAAM;AAAA,IAC5B;AAAA,EACF;AACA,SAAO;AACT;AAEA,IAAI,mCAAmC;AACvC,IAAI,UAAU,mCAAmC,WAAY;AAC3D,MAAI,qCAAqC,MAAM;AAC7C,UAAMA,UAAS,KAAK,UAAU,qCAAqC;AACnE,QAAI;AACF,YAAMS,OAAM,KAAK,YAAY,KAAK,MAAMT,OAAM;AAC9C,yCAAmC;AAAA,QACjC,QAAQ,SAAS,KAAK,aAAaA,OAAM,CAAC;AAAA,QAC1C,wBAAwBS,KAAI,0BAA0B,6BAA6B;AAAA,QACnF,YAAYA,KAAI,cAAc,4BAA4B;AAAA,QAC1D,cAAcA,KAAI,gBAAgB,4BAA4B;AAAA,MAChE;AAAA,IACF,UAAE;AACA,WAAK,eAAeT,OAAM;AAAA,IAC5B;AAAA,EACF;AACA,SAAO;AACT;AAEA,IAAI,iBAAiB;AACrB,IAAI,UAAU,iBAAiB,WAAY;AACzC,MAAI,mBAAmB,MAAM;AAC3B,UAAMA,UAAS,KAAK,UAAU,kBAAkB;AAChD,QAAI;AACF,uBAAiB;AAAA,QACf,QAAQ,SAAS,KAAK,aAAaA,OAAM,CAAC;AAAA,MAC5C;AAAA,IACF,UAAE;AACA,WAAK,eAAeA,OAAM;AAAA,IAC5B;AAAA,EACF;AACA,SAAO;AACT;AAEA,IAAI,UAAU,eAAe,SAAU,aAAa;AAClD,QAAM,OAAO,KAAK,SAAS,WAAW,CAAC,CAAC,EAAE,KAAK,QAAQ,aAAa,KAAK,cAAc,EAAE,OAAO;AAChG,MAAI;AACF,WAAO,KAAK,cAAc,IAAI;AAAA,EAChC,UAAE;AACA,SAAK,eAAe,IAAI;AAAA,EAC1B;AACF;AAEA,IAAI,UAAU,qBAAqB,SAAU,WAAW;AACtD,QAAM,SAAS,KAAK,eAAe,SAAS;AAC5C,MAAI;AACF,WAAO,KAAK,aAAa,MAAM;AAAA,EACjC,UAAE;AACA,SAAK,eAAe,MAAM;AAAA,EAC5B;AACF;AAEA,IAAI,UAAU,wBAAwB,SAAU,MAAM;AACpD,QAAM,sBAAsB,KAAK,SAAS,WAAW,CAAC,CAAC,EAAE,KAAK,QAAQ,MAAM,KAAK,iCAAiC,EAAE,sBAAsB;AAC1I,OAAK,wBAAwB;AAC7B,MAAI,CAAC,oBAAoB,OAAO,GAAG;AACjC,QAAI;AACF,aAAO,KAAK,gCAAgC,mBAAmB;AAAA,IACjE,UAAE;AACA,WAAK,eAAe,mBAAmB;AAAA,IACzC;AAAA,EACF;AACF;AAEA,IAAI,UAAU,kCAAkC,SAAU,WAAW;AACnE,QAAM,SAAS,KAAK,eAAe,SAAS;AAC5C,MAAI,SAAS,GAAG;AACd,UAAM,gBAAgB,KAAK,sBAAsB,WAAW,CAAC;AAC7D,QAAI;AACF,aAAO,KAAK,YAAY,aAAa;AAAA,IACvC,UAAE;AACA,WAAK,eAAe,aAAa;AAAA,IACnC;AAAA,EACF,OAAO;AAEL,WAAO;AAAA,EACT;AACF;AAEA,IAAI,UAAU,cAAc,SAAU,MAAM,wBAAwB;AAClE,QAAM,2BAA2B,KAAK,SAAS,WAAW,CAAC,CAAC;AAE5D,MAAI,KAAK,aAAa,MAAM,KAAK,cAAc,EAAE,MAAM,GAAG;AACxD,WAAO,KAAK,aAAa,IAAI;AAAA,EAC/B,WAAW,KAAK,aAAa,MAAM,KAAK,gCAAgC,EAAE,MAAM,GAAG;AACjF,WAAO,KAAK,iBAAiB,IAAI;AAAA,EACnC,WAAW,KAAK,aAAa,MAAM,KAAK,iCAAiC,EAAE,MAAM,GAAG;AAClF,UAAM,UAAU,yBAAyB,KAAK,QAAQ,MAAM,KAAK,iCAAiC,EAAE,UAAU;AAC9G,SAAK,wBAAwB;AAC7B,QAAI;AACJ,QAAI;AACF,eAAS,KAAK,YAAY,OAAO;AAAA,IACnC,UAAE;AACA,WAAK,eAAe,OAAO;AAAA,IAC7B;AAEA,QAAI,wBAAwB;AAC1B,gBAAU,MAAM,KAAK,sBAAsB,IAAI,IAAI;AAAA,IACrD;AACA,WAAO;AAAA,EACT,WAAW,KAAK,aAAa,MAAM,KAAK,4BAA4B,EAAE,MAAM,GAAG;AAE7E,WAAO;AAAA,EACT,WAAW,KAAK,aAAa,MAAM,KAAK,4BAA4B,EAAE,MAAM,GAAG;AAE7E,WAAO;AAAA,EACT,OAAO;AACL,WAAO;AAAA,EACT;AACF;AAEA,IAAI,UAAU,mBAAmB,SAAU,MAAM;AAC/C,QAAM,2BAA2B,KAAK,SAAS,WAAW,CAAC,CAAC;AAE5D,MAAI,KAAK,aAAa,MAAM,KAAK,cAAc,EAAE,MAAM,GAAG;AACxD,WAAO,KAAK,aAAa,IAAI;AAAA,EAC/B,WAAW,KAAK,aAAa,MAAM,KAAK,gCAAgC,EAAE,MAAM,GAAG;AACjF,UAAM,gBAAgB,yBAAyB,KAAK,QAAQ,MAAM,KAAK,gCAAgC,EAAE,uBAAuB;AAEhI,SAAK,wBAAwB;AAC7B,QAAI;AACF,aAAO,OAAO,KAAK,YAAY,aAAa,IAAI;AAAA,IAClD,UAAE;AACA,WAAK,eAAe,aAAa;AAAA,IACnC;AAAA,EACF,OAAO;AACL,WAAO;AAAA,EACT;AACF;AAEA,IAAI,UAAU,gBAAgB,SAAU,KAAK;AAC3C,QAAM,MAAM,KAAK,eAAe,GAAG;AACnC,MAAI,IAAI,OAAO,GAAG;AAChB,UAAM,IAAI,MAAM,yBAAyB;AAAA,EAC3C;AACA,MAAI;AACF,UAAM,SAAS,KAAK,gBAAgB,GAAG;AACvC,WAAO,IAAI,gBAAgB,MAAM;AAAA,EACnC,UAAE;AACA,SAAK,mBAAmB,KAAK,GAAG;AAAA,EAClC;AACF;;;ACj7BA,IAAM,kBAAkB;AAExB,IAAMU,eAAc,QAAQ;AAE5B,IAAM,aAAa,QAAQ,mBAAmB;AAC9C,IAAM,kBAAkB,oBAAI,IAAI;AAChC,IAAM,aAAa,oBAAI,IAAI;AAEZ,SAAR,GAAqBC,MAAK;AAC/B,QAAMC,UAASD,KAAI;AACnB,MAAI,sBAAsB;AAC1B,MAAI,sBAAsB;AAC1B,MAAI,SAAS;AAEb,WAASE,cAAc;AACrB,UAAMC,UAASF,QAAO,YAAY;AAClC,UAAM,UAAU;AAAA,MACd,YAAY;AAAA,IACd;AACA,0BAAsB,IAAI,eAAeE,QAAO,IAAI,IAAIJ,YAAW,EAAE,YAAY,GAAG,SAAS,CAAC,WAAW,WAAW,SAAS,GAAG,OAAO;AACvI,0BAAsB,IAAI,eAAeI,QAAO,IAAI,IAAIJ,YAAW,EAAE,YAAY,GAAG,SAAS,CAAC,SAAS,GAAG,OAAO;AACjH,aAAS,IAAI,eAAeI,QAAO,IAAI,IAAIJ,YAAW,EAAE,YAAY,GAAG,SAAS,CAAC,WAAW,WAAW,OAAO,GAAG,OAAO;AAAA,EAC1H;AAEA,OAAK,SAASE;AAEd,OAAK,UAAU,SAAU,IAAI;AAC3B,UAAM,WAAW,QAAQ,mBAAmB;AAE5C,UAAM,YAAY,gBAAgB,QAAQ;AAC1C,QAAI,cAAc,MAAM;AACtB,aAAO,GAAG,SAAS;AAAA,IACrB;AAEA,QAAI,MAAM,KAAK,WAAW;AAC1B,UAAM,kBAAkB,QAAQ;AAChC,QAAI,CAAC,iBAAiB;AACpB,YAAM,KAAK,oBAAoB;AAC/B,sBAAgB,IAAI,UAAU,IAAI;AAAA,IACpC;AAEA,SAAK,KAAK,UAAU,GAAG;AAEvB,QAAI;AACF,aAAO,GAAG,GAAG;AAAA,IACf,UAAE;AACA,YAAM,aAAa,aAAa;AAEhC,UAAI,CAAC,YAAY;AACf,aAAK,OAAO,QAAQ;AAAA,MACtB;AAEA,UAAI,CAAC,mBAAmB,CAAC,YAAY;AACnC,cAAM,kBAAkB,gBAAgB,IAAI,QAAQ;AACpD,wBAAgB,OAAO,QAAQ;AAE/B,YAAI,iBAAiB;AACnB,eAAK,oBAAoB;AAAA,QAC3B;AAAA,MACF;AAAA,IACF;AAAA,EACF;AAEA,OAAK,sBAAsB,WAAY;AACrC,UAAM,SAAS,OAAO,MAAMF,YAAW;AACvC,mBAAe,2BAA2B,oBAAoBE,SAAQ,QAAQ,IAAI,CAAC;AACnF,WAAO,IAAI,IAAI,OAAO,YAAY,GAAG,IAAI;AAAA,EAC3C;AAEA,OAAK,sBAAsB,WAAY;AACrC,mBAAe,2BAA2B,oBAAoBA,OAAM,CAAC;AAAA,EACvE;AAEA,OAAK,gCAAgC,WAAY;AAC/C,UAAM,WAAW,QAAQ,mBAAmB;AAE5C,QAAI,gBAAgB,IAAI,QAAQ,GAAG;AACjC,sBAAgB,IAAI,UAAU,KAAK;AAAA,IACrC;AAAA,EACF;AAEA,OAAK,SAAS,WAAY;AACxB,UAAM,YAAY,gBAAgB,QAAQ,mBAAmB,CAAC;AAC9D,QAAI,cAAc,MAAM;AACtB,aAAO;AAAA,IACT;AAEA,UAAM,SAAS,OAAO,MAAMF,YAAW;AACvC,UAAM,SAAS,OAAOE,SAAQ,QAAQ,eAAe;AACrD,QAAI,WAAW,IAAI;AACjB,YAAM,IAAI,MAAM,uGAAuG;AAAA,IACzH;AACA,mBAAe,cAAc,MAAM;AACnC,WAAO,IAAI,IAAI,OAAO,YAAY,GAAG,IAAI;AAAA,EAC3C;AAEA,OAAK,YAAY,WAAY;AAC3B,UAAM,YAAY,gBAAgB,QAAQ,mBAAmB,CAAC;AAC9D,QAAI,cAAc,MAAM;AACtB,aAAO;AAAA,IACT;AAEA,WAAO,KAAK,WAAW;AAAA,EACzB;AAEA,OAAK,aAAa,WAAY;AAC5B,UAAM,IAAI,KAAK,gBAAgB,eAAe;AAC9C,QAAI,MAAM,MAAM;AACd,aAAO;AAAA,IACT;AACA,WAAO,IAAI,IAAI,GAAG,IAAI;AAAA,EACxB;AAEA,OAAK,kBAAkB,SAAU,SAAS;AACxC,UAAM,SAAS,OAAO,MAAMF,YAAW;AACvC,UAAM,SAAS,OAAOE,SAAQ,QAAQ,OAAO;AAC7C,QAAI,WAAW,QAAQ;AACrB,aAAO;AAAA,IACT;AACA,WAAO,OAAO,YAAY;AAAA,EAC5B;AAEA,OAAK,uBAAuB,SAAUA,SAAQ;AAC5C,WAAO,MAAM;AACX,WAAK,QAAQ,SAAO;AAClB,YAAI,gBAAgBA,OAAM;AAAA,MAC5B,CAAC;AAAA,IACH;AAAA,EACF;AAEA,OAAK,OAAO,SAAU,KAAK,KAAK;AAC9B,UAAM,QAAQ,WAAW,IAAI,GAAG;AAChC,QAAI,UAAU,QAAW;AACvB,iBAAW,IAAI,KAAK,CAAC,KAAK,CAAC,CAAC;AAAA,IAC9B,OAAO;AACL,YAAM,CAAC;AAAA,IACT;AAAA,EACF;AAEA,OAAK,SAAS,SAAU,KAAK;AAC3B,UAAM,QAAQ,WAAW,IAAI,GAAG;AAChC,QAAI,MAAM,CAAC,MAAM,GAAG;AAClB,iBAAW,OAAO,GAAG;AAAA,IACvB,OAAO;AACL,YAAM,CAAC;AAAA,IACT;AAAA,EACF;AAEA,WAAS,gBAAiB,UAAU;AAClC,UAAM,QAAQ,WAAW,IAAI,QAAQ;AACrC,QAAI,UAAU,QAAW;AACvB,aAAO;AAAA,IACT;AACA,WAAO,MAAM,CAAC;AAAA,EAChB;AAEA,EAAAC,YAAW,KAAK,IAAI;AACtB;AAEA,GAAG,UAAU,SAAUE,KAAI;AACzB,MAAI,gBAAgB,IAAI,UAAU,MAAM,MAAM;AAC5C,oBAAgB,OAAO,UAAU;AACjC,IAAAA,IAAG,oBAAoB;AAAA,EACzB;AACF;;;AP5JA,IAAM,YAAY;AAClB,IAAMC,eAAc,QAAQ;AAE5B,IAAM;AAAA,EACJ;AAAA,EACA;AAAA,EACA;AAAA,EACA;AACF,IAAI,cAAc;AAElB,IAAM,aAAa;AACnB,IAAM,aAAa;AACnB,IAAM,YAAY;AAClB,IAAM,aAAa;AACnB,IAAM,iBAAiB;AACvB,IAAM,qBAAqB;AAC3B,IAAM,yCAAyC;AAC/C,IAAM,uBAAuB;AAC7B,IAAM,2BAA2B;AACjC,IAAM,kCAAkC;AACxC,IAAM,8BAA8B;AACpC,IAAM,gBAAgB;AACtB,IAAM,yBAAyB;AAE/B,IAAM,WAAW;AAEjB,IAAM,sBAAsB;AAC5B,IAAM,2BAA2B;AAEjC,IAAM,yBAAyB,IAAI,CAAC,EAAE,IAAI;AAE1C,IAAM,uBAAuB;AAC7B,IAAM,0BAA0B;AAEhC,IAAM,oCAAoC,KAAKA;AAC/C,IAAM,gCAAgC,KAAKA;AAEpC,IAAM,0BAA0B;AAEvC,IAAM,uCAAuC;AAC7C,IAAM,iCAAiC;AAEvC,IAAM,0BAA0B;AAEhC,IAAM,kBAAkB;AACxB,IAAM,iCAAiC;AACvC,IAAM,iCAAiC;AACvC,IAAM,mCAAmC;AACzC,IAAM,8BAA8B;AACpC,IAAM,6BAA6B;AACnC,IAAM,2BAA2B;AACjC,IAAM,iCAAiC;AAEvC,IAAM,yBAAyB;AAC/B,IAAM,0BAA0B;AAChC,IAAM,2BAA2B;AACjC,IAAM,uBAAuB;AAC7B,IAAM,uBAAuB;AAC7B,IAAM,uBAAuB;AAC7B,IAAM,uBAAuB;AAC7B,IAAM,uBAAuB;AAC7B,IAAM,yBAAyB;AAC/B,IAAM,0BAA0B;AAEhC,IAAM,kBAAkB,IAAIA;AAC5B,IAAM,kBAAkB,IAAIA;AAE5B,IAAM,UAAU;AAChB,IAAM,cAAc;AAEpB,IAAM,oBAAoB,QAAQ,kBAAkB;AACpD,IAAM,4BAA4B,QAAQ,0BAA0B;AAC7D,IAAM,mBAAmB,QAAQ,iBAAiB;AAClD,IAAM,mBAAmB,QAAQ,iBAAiB;AACzD,IAAM,yBAAyB,QAAQ,uBAAuB;AAC9D,IAAM,kCAAkC,QAAQ,gCAAgC;AACzE,IAAM,oBAAoB,QAAQ,kBAAkB;AAC3D,IAAM,qBAAqB,QAAQ,mBAAmB;AAC/C,IAAM,qBAAqB,QAAQ,mBAAmB;AAC7D,IAAM,kCAAkC,QAAQ,gCAAgC;AAEhF,IAAM,8CACD,QAAQ,SAAS,SACd,wDACA;AAER,IAAMC,yBAAwB;AAAA,EAC5B,YAAY;AACd;AAEA,IAAM,4BAA4B,CAAC;AAEnC,IAAI,YAAY;AAChB,IAAI,2BAA2B;AAC/B,IAAI,gBAAgB;AACpB,IAAI,gBAAgB;AACpB,IAAM,cAAc,CAAC;AACrB,IAAM,iBAAiB,oBAAI,IAAI;AAC/B,IAAM,uBAAuB,CAAC;AAC9B,IAAI,YAAY;AAChB,IAAI,cAAc;AAClB,IAAI,mCAAmC;AACvC,IAAI,sCAAsC;AAC1C,IAAI,kBAAkB;AACtB,IAAM,eAAe,CAAC;AACtB,IAAI,aAAa;AAEjB,IAAI,sBAAsB;AAEnB,SAAS,SAAU;AACxB,MAAI,cAAc,MAAM;AACtB,gBAAY,QAAQ;AAAA,EACtB;AACA,SAAO;AACT;AAEA,SAAS,UAAW;AAClB,QAAM,YAAY,QAAQ,iBAAiB,EACxC,OAAO,CAAAC,OAAK,oBAAoB,KAAKA,GAAE,IAAI,CAAC,EAC5C,OAAO,CAAAA,OAAK,CAAC,sBAAsB,KAAKA,GAAE,IAAI,CAAC;AAClD,MAAI,UAAU,WAAW,GAAG;AAC1B,WAAO;AAAA,EACT;AACA,QAAM,WAAW,UAAU,CAAC;AAE5B,QAAM,SAAU,SAAS,KAAK,QAAQ,KAAK,MAAM,KAAM,QAAQ;AAC/D,QAAM,QAAQ,WAAW;AAEzB,QAAM,eAAe;AAAA,IACnB,QAAQ;AAAA,IACR,KAAM,MAAM;AACV,YAAM,EAAE,OAAO,IAAI;AACnB,UAAI,UAAU,OAAO,iBAAiB,IAAI;AAC1C,UAAI,YAAY,MAAM;AACpB,kBAAU,OAAO,iBAAiB,IAAI;AAAA,MACxC;AACA,aAAO;AAAA,IACT;AAAA,IACA;AAAA,IACA,mBAAmB;AAAA,EACrB;AAEA,eAAa,+BAA+B,UAC1C,aAAa,KAAK,kDAAkD,MAAM,QAC1E,aAAa,KAAK,sCAAsC,MAAM;AAGhE,QAAM,UAAU,QACZ;AAAA,IACE,WAAW;AAAA,MACT,uBAAuB,CAAC,yBAAyB,OAAO,CAAC,WAAW,OAAO,SAAS,CAAC;AAAA;AAAA,MAGrF,oCAAoC,SAAU,SAAS;AACrD,aAAK,qCAAqC;AAAA,MAC5C;AAAA;AAAA,MAGA,6EAA6E,CAAC,gCAAgC,WAAW,CAAC,WAAW,WAAW,SAAS,CAAC;AAAA;AAAA,MAE1J,iEAAiE,CAAC,gCAAgC,WAAW,CAAC,WAAW,WAAW,SAAS,CAAC;AAAA;AAAA,MAE9I,wDAAwD,CAAC,yCAAyC,QAAQ,CAAC,WAAW,SAAS,CAAC;AAAA,MAChI,0DAA0D,CAAC,2CAA2C,QAAQ,CAAC,WAAW,SAAS,CAAC;AAAA;AAAA,MAGpI,0DAA0D,SAAU,SAAS;AAC3E,aAAK,kCAAkC,IAAI,IAAI,eAAe,SAAS,WAAW,CAAC,WAAW,QAAQ,SAAS,GAAGD,sBAAqB;AAAA,MACzI;AAAA;AAAA,MAEA,0FAA0F,SAAU,SAAS;AAC3G,aAAK,kCAAkC,IAAI,IAAI,eAAe,SAAS,WAAW,CAAC,WAAW,QAAQ,SAAS,GAAGA,sBAAqB;AAAA,MACzI;AAAA;AAAA,MAGA,oCAAoC,SAAU,SAAS;AACrD,YAAI;AACJ,YAAI,mBAAmB,KAAK,IAAI;AAE9B,yBAAe,4CAA4C,SAAS,CAAC,WAAW,SAAS,CAAC;AAAA,QAC5F,OAAO;AAEL,yBAAe,IAAI,eAAe,SAAS,WAAW,CAAC,WAAW,SAAS,GAAGA,sBAAqB;AAAA,QACrG;AACA,aAAK,8BAA8B,IAAI,SAAUE,KAAI,QAAQ,KAAK;AAChE,iBAAO,aAAaA,KAAI,GAAG;AAAA,QAC7B;AAAA,MACF;AAAA;AAAA,MAEA,gDAAgD,CAAC,gCAAgC,WAAW,CAAC,WAAW,WAAW,SAAS,CAAC;AAAA;AAAA;AAAA,MAI7H,iDAAiD,CAAC,8BAA8B,WAAW,CAAC,WAAW,SAAS,CAAC;AAAA;AAAA,MAEjH,2CAA2C,CAAC,8BAA8B,WAAW,CAAC,WAAW,SAAS,CAAC;AAAA;AAAA,MAG3G,sCAAsC,CAAC,+BAA+B,QAAQ,CAAC,WAAW,WAAW,MAAM,CAAC;AAAA;AAAA,MAE5G,mCAAmC,SAAU,SAAS;AACpD,cAAM,aAAa,IAAI,eAAe,SAAS,QAAQ,CAAC,SAAS,GAAGF,sBAAqB;AACzF,aAAK,6BAA6B,IAAI,SAAU,YAAY,OAAO,aAAa;AAC9E,iBAAO,WAAW,UAAU;AAAA,QAC9B;AAAA,MACF;AAAA,MAEA,iCAAiC,CAAC,8BAA8B,QAAQ,CAAC,SAAS,CAAC;AAAA;AAAA,MAGnF,wDAAwD,CAAC,kCAAkC,QAAQ,CAAC,WAAW,SAAS,CAAC;AAAA;AAAA,MAEzH,gEAAgE,SAAU,SAAS;AACjF,cAAM,eAAe,IAAI,eAAe,SAAS,QAAQ,CAAC,WAAW,WAAW,SAAS,GAAGA,sBAAqB;AACjH,aAAK,gCAAgC,IAAI,SAAU,aAAa,SAAS;AACvE,uBAAa,aAAa,SAAS,IAAI;AAAA,QACzC;AAAA,MACF;AAAA,MAEA,oEAAoE,CAAC,uCAAuC,QAAQ,CAAC,WAAW,SAAS,CAAC;AAAA,MAE1I,4DAA4D,CAAC,+BAA+B,QAAQ,CAAC,WAAW,WAAW,SAAS,CAAC;AAAA,MACrI,uJAAuJ,CAAC,+BAA+B,QAAQ,CAAC,WAAW,WAAW,WAAW,OAAO,SAAS,CAAC;AAAA;AAAA,MAGlP,wJAAwJ,SAAU,SAAS;AACzK,cAAM,eAAe,IAAI,eAAe,SAAS,QAAQ,CAAC,WAAW,WAAW,WAAW,QAAQ,OAAO,SAAS,GAAGA,sBAAqB;AAC3I,aAAK,6BAA6B,IAAI,SAAU,UAAU,OAAO,QAAQ,UAAU,WAAW;AAC5F,gBAAM,sBAAsB;AAC5B,uBAAa,UAAU,OAAO,QAAQ,qBAAqB,UAAU,SAAS;AAAA,QAChF;AAAA,MACF;AAAA,MAEA,yEAAyE,CAAC,mCAAmC,QAAQ,CAAC,WAAW,WAAW,WAAW,QAAQ,QAAQ,MAAM,CAAC;AAAA,MAC9K,yEAAyE,CAAC,mCAAmC,QAAQ,CAAC,WAAW,WAAW,WAAW,QAAQ,UAAU,MAAM,CAAC;AAAA,MAChL,gEAAgE,CAAC,gCAAgC,QAAQ,CAAC,WAAW,MAAM,CAAC;AAAA,MAC5H,oCAAoC,CAAC,gCAAgC,WAAW,CAAC,SAAS,CAAC;AAAA,MAC3F,4CAA4C,SAAU,SAAS;AAC7D,aAAK,qCAAqC,IAAI,8CAA8C,SAAS,CAAC,SAAS,CAAC;AAAA,MAClH;AAAA,MACA,oDAAoD,SAAU,SAAS;AACrE,aAAK,6CAA6C,IAAI,4BAA4B,OAAO;AAAA,MAC3F;AAAA,MAEA,sCAAsC,CAAC,mCAAmC,WAAW,CAAC,SAAS,CAAC;AAAA,MAEhG,uGAAuG,SAAU,SAAS;AACxH,aAAK,mCAAmC,IAAI;AAAA,MAC9C;AAAA,MACA,qCAAqC,SAAU,SAAS;AACtD,aAAK,iCAAiC,IAAI,8CAA8C,SAAS,CAAC,SAAS,CAAC;AAAA,MAC9G;AAAA,MAEA,mCAAmC,SAAU,SAAS;AACpD,aAAK,8BAA8B,IAAI,8CAA8C,SAAS,CAAC,WAAW,MAAM,CAAC;AAAA,MACnH;AAAA,MACA,wCAAwC,SAAU,SAAS;AACzD,aAAK,sCAAsC,IAAI,8CAA8C,SAAS,CAAC,WAAW,MAAM,CAAC;AAAA,MAC3H;AAAA;AAAA,MAGA,kCAAkC,CAAC,+BAA+B,WAAW,CAAC,CAAC;AAAA,MAC/E,0CAA0C,SAAU,SAAS;AAC3D,aAAK,4BAA4B,IAAI,IAAI,eAAe,SAAS,WAAW,CAAC,WAAW,SAAS,GAAGA,sBAAqB;AAAA,MAC3H;AAAA,MACA,2CAA2C,SAAU,SAAS;AAC5D,cAAM,QAAQ,IAAI,eAAe,SAAS,WAAW,CAAC,WAAW,WAAW,SAAS,GAAGA,sBAAqB;AAC7G,aAAK,4BAA4B,IAAI,SAAU,SAAS,WAAW;AACjE,gBAAM,iBAAiB;AACvB,iBAAO,MAAM,SAAS,WAAW,cAAc;AAAA,QACjD;AAAA,MACF;AAAA,MACA,2CAA2C,SAAU,SAAS;AAC5D,cAAM,QAAQ,IAAI,eAAe,SAAS,WAAW,CAAC,WAAW,WAAW,MAAM,GAAGA,sBAAqB;AAC1G,aAAK,4BAA4B,IAAI,SAAU,SAAS,WAAW;AACjE,gBAAM,iBAAiB;AACvB,iBAAO,MAAM,SAAS,WAAW,cAAc;AAAA,QACjD;AAAA,MACF;AAAA,MAEA,+BAA+B,CAAC,4BAA4B,QAAQ,CAAC,MAAM,CAAC;AAAA,MAC5E,qDAAqD,CAAC,2BAA2B,QAAQ,CAAC,SAAS,CAAC;AAAA,MACpG,2DAA2D,CAAC,uDAAuD,QAAQ,CAAC,SAAS,CAAC;AAAA,MACtI,yBAAyB,CAAC,uBAAuB,QAAQ,CAAC,CAAC;AAAA,MAC3D,wBAAwB,CAAC,sBAAsB,QAAQ,CAAC,CAAC;AAAA,MACzD,kEAAkE,CAAC,mCAAmC,QAAQ,CAAC,SAAS,CAAC;AAAA,MACzH,qCAAqC,CAAC,kCAAkC,QAAQ,CAAC,CAAC;AAAA,MAElF,mEAAmE,CAAC,8CAA8C,QAAQ,CAAC,SAAS,CAAC;AAAA;AAAA,MAErI,qEAAqE,CAAC,8CAA8C,QAAQ,CAAC,WAAW,SAAS,CAAC;AAAA;AAAA,MAElJ,mEAAmE,SAAU,SAAS;AACpF,cAAM,aAAa,IAAI,eAAe,SAAS,QAAQ,CAAC,SAAS,GAAGA,sBAAqB;AACzF,aAAK,4CAA4C,IAAI,SAAU,iBAAiB,KAAK;AACnF,qBAAW,eAAe;AAAA,QAC5B;AAAA,MACF;AAAA,MACA,wCAAwC,CAAC,qCAAqC,QAAQ,CAAC,SAAS,CAAC;AAAA,MACjG,uEAAuE,CAAC,oCAAoC,QAAQ,CAAC,WAAW,SAAS,CAAC;AAAA;AAAA,MAG1I,yDAAyD,CAAC,0CAA0C,WAAW,CAAC,WAAW,SAAS,CAAC;AAAA,MACrI,4CAA4C,CAAC,wCAAwC,WAAW,CAAC,CAAC;AAAA,MAElG,2DAA2D,CAAC,mCAAmC,QAAQ,CAAC,WAAW,UAAU,WAAW,SAAS,CAAC;AAAA,IACpJ;AAAA,IACA,WAAW;AAAA,MACT,wBAAwB,SAAU,SAAS;AACzC,aAAK,gBAAgB,MAAM,CAAC,QAAQ,YAAY,EAAE,OAAO;AAAA,MAC3D;AAAA,MACA,+BAA+B,SAAU,SAAS;AAChD,aAAK,mBAAmB,MAAM,CAAC,CAAC,QAAQ,OAAO;AAAA,MACjD;AAAA,IACF;AAAA,IACA,WAAW,oBAAI,IAAI;AAAA,MACjB;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,IACF,CAAC;AAAA,EACH,IACA;AAAA,IACE,WAAW;AAAA,MACT,4CAA4C,CAAC,wBAAwB,WAAW,CAAC,WAAW,SAAS,CAAC;AAAA,MACtG,+BAA+B,CAAC,mBAAmB,QAAQ,CAAC,WAAW,SAAS,CAAC;AAAA,MACjF,2BAA2B,CAAC,wBAAwB,WAAW,CAAC,CAAC;AAAA,MACjE,4BAA4B,CAAC,yBAAyB,WAAW,CAAC,CAAC;AAAA,MACnE,+BAA+B,CAAC,oBAAoB,SAAS,CAAC,SAAS,CAAC;AAAA,MACxE,uBAAuB,CAAC,yBAAyB,OAAO,CAAC,WAAW,OAAO,SAAS,CAAC;AAAA,IACvF;AAAA,IACA,WAAW;AAAA,MACT,SAAS,SAAU,SAAS;AAC1B,aAAK,UAAU;AAAA,MACjB;AAAA,MACA,MAAM,SAAU,SAAS;AACvB,aAAK,OAAO;AAAA,MACd;AAAA,IACF;AAAA,EACF;AAEJ,QAAM;AAAA,IACJ,YAAY,CAAC;AAAA,IACb,YAAY,CAAC;AAAA,IACb,YAAY,oBAAI,IAAI;AAAA,EACtB,IAAI;AAEJ,QAAM,UAAU,CAAC;AAEjB,aAAW,CAAC,MAAMG,UAAS,KAAK,OAAO,QAAQ,SAAS,GAAG;AACzD,UAAM,UAAU,aAAa,KAAK,IAAI;AACtC,QAAI,YAAY,MAAM;AACpB,UAAI,OAAOA,eAAc,YAAY;AACnC,QAAAA,WAAU,KAAK,cAAc,OAAO;AAAA,MACtC,OAAO;AACL,qBAAaA,WAAU,CAAC,CAAC,IAAI,IAAI,eAAe,SAASA,WAAU,CAAC,GAAGA,WAAU,CAAC,GAAGH,sBAAqB;AAAA,MAC5G;AAAA,IACF,OAAO;AACL,UAAI,CAAC,UAAU,IAAI,IAAI,GAAG;AACxB,gBAAQ,KAAK,IAAI;AAAA,MACnB;AAAA,IACF;AAAA,EACF;AAEA,aAAW,CAAC,MAAM,OAAO,KAAK,OAAO,QAAQ,SAAS,GAAG;AACvD,UAAM,UAAU,aAAa,KAAK,IAAI;AACtC,QAAI,YAAY,MAAM;AACpB,cAAQ,KAAK,cAAc,OAAO;AAAA,IACpC,OAAO;AACL,UAAI,CAAC,UAAU,IAAI,IAAI,GAAG;AACxB,gBAAQ,KAAK,IAAI;AAAA,MACnB;AAAA,IACF;AAAA,EACF;AAEA,MAAI,QAAQ,SAAS,GAAG;AACtB,UAAM,IAAI,MAAM,oEAAoE,QAAQ,KAAK,IAAI,CAAC;AAAA,EACxG;AAEA,QAAM,MAAM,OAAO,MAAMD,YAAW;AACpC,QAAM,UAAU,OAAO,MAAM,SAAS;AACtC,iBAAe,yBAAyB,aAAa,sBAAsB,KAAK,GAAG,OAAO,CAAC;AAC3F,MAAI,QAAQ,QAAQ,MAAM,GAAG;AAC3B,WAAO;AAAA,EACT;AACA,eAAa,KAAK,IAAI,YAAY;AAElC,MAAI,OAAO;AACT,UAAM,WAAW,mBAAmB;AAEpC,QAAI;AACJ,QAAI,YAAY,IAAI;AAClB,8BAAwB;AAAA,IAC1B,WAAW,YAAY,IAAI;AACzB,8BAAwB;AAAA,IAC1B,OAAO;AACL,8BAAwB;AAAA,IAC1B;AACA,iBAAa,wBAAwB;AAErC,UAAM,aAAa,aAAa,GAAG,IAAIA,YAAW,EAAE,YAAY;AAChE,iBAAa,aAAa;AAC1B,UAAM,cAAc,kBAAkB,YAAY;AAClD,UAAM,gBAAgB,YAAY;AAClC,UAAM,wBAAwB,cAAc;AAC5C,iBAAa,qBAAsB,0BAA0B,OAAQ,WAAW,IAAI,qBAAqB,IAAI;AAE7G,iBAAa,UAAU,WAAW,IAAI,cAAc,IAAI,EAAE,YAAY;AACtE,iBAAa,gBAAgB,WAAW,IAAI,cAAc,UAAU,EAAE,YAAY;AAQlF,UAAM,cAAc,WAAW,IAAI,cAAc,WAAW,EAAE,YAAY;AAE1E,UAAM,qBAAqB,sBAAsB,YAAY,WAAW,EAAE;AAC1E,UAAM,4BAA4B,YAAY,IAAI,mBAAmB,yBAAyB,EAAE,YAAY;AAC5G,UAAM,6BAA6B,YAAY,IAAI,mBAAmB,0BAA0B,EAAE,YAAY;AAC9G,UAAM,4BAA4B,YAAY,IAAI,mBAAmB,yBAAyB,EAAE,YAAY;AAC5G,UAAM,qCAAqC,YAAY,IAAI,mBAAmB,kCAAkC,EAAE,YAAY;AAE9H,iBAAa,iBAAiB;AAAA,MAC5B,SAAS;AAAA,MACT;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,IACF;AAEA,UAAMG,MAAK,IAAI,GAAG,YAAY;AAE9B,iBAAa,+BAA+B,oCAAoC,2BAA2BA,GAAE;AAC7G,iBAAa,8BAA8B,oCAAoC,oCAAoCA,GAAE;AACrH,iBAAa,+BAA+B,oCAAoC,2BAA2BA,GAAE;AAE7G,QAAI,aAAa,8BAA8B,MAAM,QAAW;AAC9D,mBAAa,8BAA8B,IAAI,oCAAoC,YAAY;AAAA,IACjG;AACA,QAAI,aAAa,8BAA8B,MAAM,QAAW;AAC9D,mBAAa,8BAA8B,IAAI,yBAAyB,YAAY;AAAA,IACtF;AACA,QAAI,aAAa,8BAA8B,MAAM,QAAW;AAC9D,mBAAa,8BAA8B,IAAI,aAAa,sCAAsC;AAAA,IACpG;AACA,QAAI,aAAa,sCAAsC,MAAM,QAAW;AACtE,mBAAa,qBAAqB,aAAa,sCAAsC,EAAE;AAAA,IACzF,OAAO;AACL,mBAAa,qBAAqB,aAAa,KAAK,kBAAkB;AAAA,IACxE;AAEA,oBAAgB,kBAAkB,cAAcA,GAAE;AAElD,qCAAiC,YAAY;AAE7C,QAAI,cAAc;AAClB,WAAO,eAAe,cAAc,SAAS;AAAA,MAC3C,MAAO;AACL,YAAI,gBAAgB,MAAM;AACxB,wBAAc,CAAC,eAAeA,KAAI,KAAK,UAAU,CAAC;AAAA,QACpD;AACA,eAAO,YAAY,CAAC;AAAA,MACtB;AAAA,IACF,CAAC;AAAA,EACH;AAEA,QAAM,aAAa,SAAS,iBAAiB,EAC1C,OAAO,SAAO,IAAI,KAAK,QAAQ,IAAI,MAAM,CAAC,EAC1C,OAAO,CAAC,QAAQ,QAAQ;AACvB,WAAO,IAAI,IAAI,IAAI,IAAI;AACvB,WAAO;AAAA,EACT,GAAG,CAAC,CAAC;AACP,eAAa,OAAO,IAAI,eAAe,WAAW,SAAS,WAAW,OAAO,WAAW,CAAC,OAAO,GAAGF,sBAAqB;AACxH,eAAa,UAAU,IAAI,eAAe,WAAW,QAAQ,QAAQ,CAAC,SAAS,GAAGA,sBAAqB;AAEvG,kBAAgB,QAAQ,mBAAmB;AAE3C,SAAO;AACT;AAEA,SAAS,eAAgBE,KAAIE,UAAS;AACpC,MAAI,MAAM;AAEV,EAAAF,IAAG,QAAQ,MAAM;AACf,UAAM,yBAAyB,OAAO,EAAE,KAAK,0GAA0G;AACvJ,QAAI,2BAA2B,MAAM;AACnC;AAAA,IACF;AACA,UAAM,qBAAqB,IAAI;AAAA,MAAe;AAAA,MAC5C;AAAA,MACA,CAAC,WAAW,WAAW,SAAS;AAAA,IAAC;AACnC,UAAM,WAAW,OAAO,MAAMH,YAAW;AACzC,UAAM,UAAU,mBAAmBK,UAAS,OAAO,gBAAgB,oBAAoB,GAAG,QAAQ;AAClG,QAAI,CAAC,SAAS;AAEZ;AAAA,IACF;AAEA,UAAM,gBAAgB,aAAa,OAAO;AAC1C,UAAMC,UAASH,IAAG,gBAAgB,aAAa;AAC/C,QAAIG,YAAW,MAAM;AACnB;AAAA,IACF;AACA,UAAM,IAAI,SAASA,SAAQH,GAAE;AAE7B,UAAM,UAAU,OAAO,MAAM,CAAC;AAC9B,YAAQ,SAAS,kBAAkB,aAAa;AAChD,UAAM,SAAS,IAAI,gBAAgB,OAAO;AAC1C,QAAI,WAAW,QAAQ;AACrB,YAAM;AAAA,IACR;AAAA,EACF,CAAC;AAED,SAAO;AACT;AAEO,SAAS,uBAAwB,KAAK,UAAU;AACrD,QAAMI,OAAM,OAAO;AACnB,MAAIA,KAAI,WAAW,OAAO;AACxB;AAAA,EACF;AAEA,MAAI,WAAW,UAAU,KAAK,GAAG;AACjC,MAAI,eAAe;AACrB;AAEA,SAAS,aAAcA,MAAK;AAC1B,SAAO;AAAA,IACL,QAASP,iBAAgB,IACrB;AAAA,MACE,aAAa;AAAA,MACb,SAAS;AAAA,IACX,IACA;AAAA,MACE,aAAa;AAAA,MACb,SAAS;AAAA,IACX;AAAA,EACN;AACF;AAEA,SAAS,mBAAoBO,MAAK;AA0BhC,QAAMJ,MAAKI,KAAI;AACf,QAAMF,WAAUE,KAAI;AAEpB,QAAM,cAAeP,iBAAgB,IAAK,MAAM;AAChD,QAAM,YAAY,cAAe,MAAMA;AAEvC,QAAM,WAAW,mBAAmB;AACpC,QAAM,WAAW,mBAAmB;AACpC,QAAM,EAAE,6BAA6B,IAAIO;AAEzC,MAAI,OAAO;AAEX,WAAS,SAAS,aAAa,WAAW,WAAW,UAAUP,cAAa;AAC1E,UAAM,QAAQK,SAAQ,IAAI,MAAM,EAAE,YAAY;AAC9C,QAAI,MAAM,OAAOF,GAAE,GAAG;AACpB,UAAI;AACJ,UAAI,qBAAqB;AACzB,UAAI,YAAY,MAAM,aAAa,cAAc,8BAA8B;AAC7E,6BAAqB,CAAC,SAAU,IAAIH,YAAY;AAChD,6BAAqB,SAASA;AAAA,MAChC,WAAW,YAAY,MAAM,aAAa,KAAK;AAC7C,6BAAqB,CAAC,SAAU,IAAIA,cAAc,SAAU,IAAIA,YAAY;AAC5E,6BAAqB,SAASA;AAAA,MAChC,WAAW,YAAY,IAAI;AACzB,6BAAqB,CAAC,SAAU,IAAIA,YAAY;AAAA,MAClD,WAAW,YAAY,IAAI;AACzB,6BAAqB,CAAC,SAAS,kBAAmB,IAAIA,YAAY;AAAA,MACpE,OAAO;AACL,6BAAqB,CAAC,SAAS,kBAAmB,IAAIA,YAAY;AAAA,MACpE;AAEA,iBAAW,qBAAqB,oBAAoB;AAClD,cAAM,oBAAoB,oBAAoBA;AAC9C,cAAM,mBAAmB,oBAAoBA;AAE7C,YAAI;AACJ,YAAI,8BAA8B;AAChC,uBAAa,mBAAoB,IAAIA;AAAA,QACvC,WAAW,YAAY,IAAI;AACzB,uBAAa,mBAAoB,IAAIA;AAAA,QACvC,WAAW,YAAY,IAAI;AACzB,uBAAa,mBAAoB,IAAIA;AAAA,QACvC,OAAO;AACL,uBAAa,mBAAoB,IAAIA;AAAA,QACvC;AAEA,cAAM,YAAY;AAAA,UAChB,QAAQ;AAAA,YACN,MAAM;AAAA,YACN,YAAY;AAAA,YACZ,aAAa;AAAA,YACb,aAAa;AAAA,YACb,cAAc;AAAA,UAChB;AAAA,QACF;AACA,YAAI,yBAAyBK,UAAS,SAAS,MAAM,MAAM;AACzD,iBAAO;AACP;AAAA,QACF;AAAA,MACF;AAEA;AAAA,IACF;AAAA,EACF;AAEA,MAAI,SAAS,MAAM;AACjB,UAAM,IAAI,MAAM,2CAA2C;AAAA,EAC7D;AAEA,OAAK,OAAO,kBAAkB,+BAA+BE,IAAG;AAChE,OAAK,OAAO,oBAAoB,iCAAiCA,IAAG;AAEpE,SAAO;AACT;AAEA,IAAM,+BAA+B;AAAA,EACnC,MAAM;AAAA,EACN,KAAK;AAAA,EACL,KAAK;AAAA,EACL,OAAO;AACT;AAEA,SAAS,+BAAgCA,MAAK;AAC5C,QAAM,OAAOA,KAAI,mCAAmC;AACpD,MAAI,SAAS,QAAW;AACtB,WAAO;AAAA,EACT;AAEA,SAAO,oBAAoB,MAAM,6BAA6B,QAAQ,IAAI,GAAG,EAAE,OAAO,GAAG,CAAC;AAC5F;AAEA,SAAS,8BAA+B,MAAM;AAC5C,MAAI,KAAK,aAAa,OAAO;AAC3B,WAAO;AAAA,EACT;AAEA,QAAM,SAAS,KAAK,SAAS,CAAC,EAAE,MAAM;AACtC,MAAI,SAAS,OAAS,SAAS,MAAO;AACpC,WAAO;AAAA,EACT;AAEA,SAAO;AACT;AAEA,SAAS,8BAA+B,MAAM;AAC5C,MAAI,KAAK,aAAa,SAAS;AAC7B,WAAO;AAAA,EACT;AAEA,QAAM,MAAM,KAAK;AACjB,MAAI,IAAI,WAAW,GAAG;AACpB,WAAO;AAAA,EACT;AAEA,QAAM,MAAM,IAAI,CAAC;AACjB,MAAI,IAAI,SAAS,OAAO;AACtB,WAAO;AAAA,EACT;AAEA,SAAO,IAAI;AACb;AAEA,SAAS,gCAAiC,MAAM;AAC9C,MAAI,KAAK,aAAa,OAAO;AAC3B,WAAO;AAAA,EACT;AAEA,QAAM,MAAM,KAAK;AACjB,MAAI,IAAI,WAAW,GAAG;AACpB,WAAO;AAAA,EACT;AAEA,MAAI,IAAI,CAAC,EAAE,UAAU,QAAQ,IAAI,CAAC,EAAE,UAAU,MAAM;AAClD,WAAO;AAAA,EACT;AAEA,QAAM,MAAM,IAAI,CAAC;AACjB,MAAI,IAAI,SAAS,OAAO;AACtB,WAAO;AAAA,EACT;AAEA,QAAM,SAAS,IAAI,MAAM,QAAQ;AACjC,MAAI,SAAS,OAAS,SAAS,MAAO;AACpC,WAAO;AAAA,EACT;AAEA,SAAO;AACT;AAEA,IAAM,iCAAiC;AAAA,EACrC,MAAM;AAAA,EACN,KAAK;AAAA,EACL,KAAK;AAAA,EACL,OAAO;AACT;AAEA,SAAS,iCAAkCA,MAAK;AAC9C,QAAM,OAAOA,KAAI,KAAK,8CAA8C;AACpE,MAAI,SAAS,MAAM;AACjB,WAAO;AAAA,EACT;AAEA,QAAM,SAAS,oBAAoB,MAAM,+BAA+B,QAAQ,IAAI,GAAG,EAAE,OAAO,GAAG,CAAC;AACpG,MAAI,WAAW,MAAM;AACnB,UAAM,IAAI,MAAM,yDAAyD;AAAA,EAC3E;AAEA,SAAO;AACT;AAEA,SAAS,gCAAiC,MAAM;AAC9C,MAAI,KAAK,aAAa,OAAO;AAC3B,WAAO,KAAK,SAAS,CAAC,EAAE,MAAM;AAAA,EAChC;AAEA,SAAO;AACT;AAEA,SAAS,gCAAiC,MAAM;AAC9C,MAAI,KAAK,aAAa,SAAS;AAC7B,WAAO,KAAK,SAAS,CAAC,EAAE,MAAM;AAAA,EAChC;AAEA,SAAO;AACT;AAEA,SAAS,kCAAmC,MAAM,UAAU;AAC1D,MAAI,aAAa,MAAM;AACrB,WAAO;AAAA,EACT;AAEA,QAAM,EAAE,SAAS,IAAI;AACrB,QAAM,EAAE,UAAU,aAAa,IAAI;AAEnC,MAAK,aAAa,SAAS,iBAAiB,SAAW,aAAa,QAAQ,iBAAiB,OAAQ;AACnG,WAAO,SAAS,SAAS,CAAC,EAAE,MAAM;AAAA,EACpC;AAEA,SAAO;AACT;AAEA,SAAS,6BAA8B;AACrC,QAAM,+BAA+B;AAAA,IACnC,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,IACR,QAAQ;AAAA,EACV;AAEA,QAAM,qBAAqB,6BAA6B,GAAGP,YAAW,IAAI,mBAAmB,CAAC,EAAE;AAChG,MAAI,uBAAuB,QAAW;AACpC,UAAM,IAAI,MAAM,mDAAmD;AAAA,EACrE;AAEA,SAAO;AAAA,IACL,QAAQ;AAAA,MACN,qBAAqB;AAAA,MACrB,uBAAuB;AAAA,IACzB;AAAA,EACF;AACF;AAEA,SAAS,sBAAuBK,UAAS,aAAa;AACpD,QAAM,OAAO,yBAAyBA,UAAS,WAAW;AAC1D,MAAI,SAAS,MAAM;AACjB,UAAM,IAAI,MAAM,+CAA+C;AAAA,EACjE;AACA,SAAO;AACT;AAEA,SAAS,yBAA0BA,UAAS,aAAa;AACvD,MAAI,6BAA6B,MAAM;AACrC,WAAO;AAAA,EACT;AA8BA,QAAM,EAAE,aAAa,mBAAmB,aAAa,kBAAkB,IAAI,YAAY;AACvF,QAAM,cAAcA,SAAQ,IAAI,iBAAiB,EAAE,YAAY;AAC/D,QAAM,cAAcA,SAAQ,IAAI,iBAAiB,EAAE,YAAY;AAE/D,QAAM,cAAeL,iBAAgB,IAAK,MAAM;AAChD,QAAM,YAAY,cAAe,MAAMA;AAEvC,QAAM,WAAW,mBAAmB;AAEpC,MAAI,OAAO;AAEX,WAAS,SAAS,aAAa,WAAW,WAAW,UAAUA,cAAa;AAC1E,UAAM,QAAQ,YAAY,IAAI,MAAM,EAAE,YAAY;AAClD,QAAI,MAAM,OAAO,WAAW,GAAG;AAC7B,UAAI;AACJ,UAAI,YAAY,MAAM,mBAAmB,MAAM,KAAK;AAClD,gBAAQ;AAAA,MACV,WAAW,YAAY,IAAI;AACzB,gBAAQ;AAAA,MACV,WAAW,YAAY,IAAI;AACzB,gBAAQ;AAAA,MACV,OAAO;AACL,gBAAQ;AAAA,MACV;AAEA,YAAM,kCAAkC,SAAU,QAAQA;AAE1D,UAAI;AACJ,UAAI,YAAY,IAAI;AAClB,0CAAkC,kCAAmC,IAAIA;AAAA,MAC3E,OAAO;AACL,0CAAkC,kCAAmC,IAAIA;AAAA,MAC3E;AAEA,aAAO;AAAA,QACL,QAAQ;AAAA,UACN,2BAA2B;AAAA,UAC3B,4BAA4B,kCAAkCA;AAAA,UAC9D,2BAA2B;AAAA,UAC3B,oCAAoC,kCAAkCA;AAAA,QACxE;AAAA,MACF;AAEA;AAAA,IACF;AAAA,EACF;AAEA,MAAI,SAAS,MAAM;AACjB,+BAA2B;AAAA,EAC7B;AAEA,SAAO;AACT;AAEO,SAAS,gBAAiBG,KAAI;AACnC,QAAM,aAAa;AAEnB,MAAI,OAAO;AAEX,EAAAA,IAAG,QAAQ,SAAO;AAChB,UAAM,YAAY,gBAAgBA,GAAE;AACpC,UAAM,aAAa,iBAAiBA,GAAE;AAEtC,UAAM,QAAQ;AAAA,MACZ,oBAAoB;AAAA,MACpB,mBAAmB,UAAU;AAAA;AAAA,MAE7B,aAAa;AAAA,IACf;AAEA,UAAM,QAAQ;AAAA,MACZ,oBAAoBH;AAAA,MACpB,mBAAmB,WAAW;AAAA;AAAA,MAE9B,aAAa;AAAA,IACf;AAEA,UAAM,eAAe,CAAC,YAAY,aAAa,eAAe;AAC5D,YAAM,SAAS,WAAW,IAAI,WAAW,EAAE,YAAY;AACvD,UAAI,OAAO,OAAO,GAAG;AACnB,eAAO;AAAA,MACT;AAEA,YAAM,SAAU,eAAe,IAAK,OAAO,QAAQ,IAAI,OAAO,QAAQ,EAAE,QAAQ;AAChF,UAAI,UAAU,GAAG;AACf,eAAO;AAAA,MACT;AAEA,aAAO;AAAA,QACL;AAAA,QACA,MAAM,OAAO,IAAI,UAAU;AAAA,MAC7B;AAAA,IACF;AAEA,UAAM,WAAW,CAAC,YAAY,QAAQ,QAAQ,SAAS;AACrD,UAAI;AACF,cAAM,WAAW,aAAa,YAAY,QAAQ,KAAK,kBAAkB;AACzE,YAAI,aAAa,MAAM;AACrB,iBAAO;AAAA,QACT;AAEA,cAAM,cAAc,KAAK,IAAI,SAAS,QAAQ,KAAK,WAAW;AAC9D,iBAAS,IAAI,GAAG,MAAM,aAAa,KAAK;AACtC,gBAAM,WAAW,SAAS,KAAK,IAAI,IAAI,KAAK,iBAAiB;AAC7D,cAAI,SAAS,OAAO,MAAM,GAAG;AAC3B,mBAAO;AAAA,UACT;AAAA,QACF;AAAA,MACF,QAAQ;AAAA,MACR;AAEA,aAAO;AAAA,IACT;AAEA,UAAM,QAAQ,IAAI,UAAU,kBAAkB;AAC9C,UAAM,WAAW,IAAI,aAAa,KAAK;AAEvC,QAAI;AACF,UAAI;AACJ,4BAAsBG,KAAI,KAAK,YAAU;AACvC,iBAAS,OAAO,EAAE,8BAA8B,EAAEA,KAAI,QAAQ,QAAQ;AAAA,MACxE,CAAC;AAED,YAAM,gBAAgB,IAAI,WAAW,UAAU,QAAQ,oBAAoB;AAC3E,YAAM,cAAc,IAAI,iBAAiB,UAAU,gBAAgB,GAAG;AAEtE,UAAI,eAAe;AACnB,UAAI,iBAAiB;AACrB,eAAS,SAAS,GAAG,WAAW,YAAY,UAAU,GAAG;AACvD,YAAI,iBAAiB,MAAM,SAAS,QAAQ,QAAQ,aAAa,KAAK,GAAG;AACvE,yBAAe;AAAA,QACjB;AACA,YAAI,mBAAmB,MAAM,SAAS,QAAQ,QAAQ,eAAe,KAAK,GAAG;AAC3E,2BAAiB;AAAA,QACnB;AAAA,MACF;AACA,UAAI,mBAAmB,MAAM,iBAAiB,IAAI;AAChD,cAAM,IAAI,MAAM,8DAA8D;AAAA,MAChF;AACA,YAAM,eAAgB,mBAAmB,eAAgB,eAAe;AACxE,YAAM,eAAe;AAErB,UAAI,gBAAgB;AACpB,YAAM,iBAAiB,IAAI,YAAY,UAAU,WAAW,sBAAsB;AAClF,eAAS,SAAS,GAAG,WAAW,YAAY,UAAU,GAAG;AACvD,YAAI,kBAAkB,MAAM,SAAS,QAAQ,QAAQ,gBAAgB,KAAK,GAAG;AAC3E,0BAAgB;AAAA,QAClB;AAAA,MACF;AACA,UAAI,kBAAkB,IAAI;AACxB,cAAM,IAAI,MAAM,+DAA+D;AAAA,MACjF;AAEA,UAAI,sBAAsB;AAC1B,YAAM,eAAe,aAAa,QAAQ,eAAe,MAAM,kBAAkB;AACjF,YAAM,mBAAmB,aAAa;AACtC,eAAS,SAAS,eAAe,WAAW,YAAY,UAAU,GAAG;AACnE,YAAI,OAAO,IAAI,MAAM,EAAE,QAAQ,MAAM,kBAAkB;AACrD,gCAAsB;AACtB;AAAA,QACF;AAAA,MACF;AACA,UAAI,wBAAwB,IAAI;AAC9B,cAAM,IAAI,MAAM,sEAAsE;AAAA,MACxF;AAEA,aAAO;AAAA,QACL,QAAQ;AAAA,UACN,SAAS;AAAA,UACT,SAAS;AAAA,UACT,SAAS;AAAA,UACT,qBAAqB;AAAA,QACvB;AAAA,MACF;AAAA,IACF,UAAE;AACA,UAAI,eAAe,KAAK;AACxB,UAAI,gBAAgB,QAAQ;AAAA,IAC9B;AAAA,EACF,CAAC;AAED,SAAO;AACT;AAEA,SAAS,kBAAmBA,KAAI;AAC9B,QAAMI,OAAM,OAAO;AACnB,MAAI;AAEJ,EAAAJ,IAAG,QAAQ,SAAO;AAChB,UAAM,UAAU,IAAI,UAAU,oBAAoB;AAClD,UAAM,oBAAoB,eAAe,IAAI,kBAAkB,SAAS,qBAAqB,KAAK,CAAC;AACnG,QAAI,eAAe,OAAO;AAE1B,UAAM,gBAAgB,QAAQ,gBAAgB,uBAAuB;AACrE,UAAM,eAAe,cAAc;AACnC,UAAM,aAAa,aAAa,IAAI,cAAc,IAAI;AAEtD,UAAM,WAAW,mBAAmB;AAEpC,UAAM,sBAAuB,YAAY,KAAM,IAAIH;AAEnD,UAAM,sBAAsB,aAAa,aAAa,YAAY;AAClE,UAAM,0BAA0B,EAAE,yCAAyC,gBAAgB,iCAAiC;AAE5H,QAAI,gBAAgB;AACpB,QAAI,oBAAoB;AACxB,QAAI,YAAY;AAChB,aAAS,SAAS,GAAG,WAAW,MAAM,cAAc,GAAG,UAAU,GAAG;AAClE,YAAM,QAAQ,kBAAkB,IAAI,MAAM;AAE1C,UAAI,kBAAkB,MAAM;AAC1B,cAAM,UAAU,MAAM,YAAY;AAClC,YAAI,QAAQ,QAAQ,YAAY,KAAK,KAAK,QAAQ,QAAQ,UAAU,IAAI,GAAG;AACzE,0BAAgB;AAChB;AAAA,QACF;AAAA,MACF;AAEA,UAAI,sBAAsB,MAAM;AAC9B,cAAM,QAAQ,MAAM,QAAQ;AAC5B,aAAK,QAAQ,6BAA6B,qBAAqB;AAC7D,8BAAoB;AACpB;AAAA,QACF;AAAA,MACF;AAAA,IACF;AAEA,QAAI,cAAc,GAAG;AACnB,YAAM,IAAI,MAAM,6CAA6C;AAAA,IAC/D;AAEA,UAAM,kBAAkB,gBAAgB;AAExC,UAAM,OAAQ,YAAY,KAAO,kBAAkB,KAAO,kBAAkBA;AAE5E,WAAO;AAAA,MACL;AAAA,MACA,QAAQ;AAAA,QACN,SAAS;AAAA,QACT,WAAW;AAAA,QACX,aAAa;AAAA,MACf;AAAA,IACF;AAEA,QAAI,wCAAwCO,MAAK;AAC/C,WAAK,OAAO,kBAAkB,gBAAgB;AAAA,IAChD;AAAA,EACF,CAAC;AAED,SAAO;AACT;AAEO,SAAS,gBAAiBJ,KAAI;AACnC,QAAM,WAAW,mBAAmB;AAEpC,MAAI,YAAY,IAAI;AAClB,WAAO;AAAA,MACL,MAAM;AAAA,MACN,QAAQ;AAAA,QACN,aAAa;AAAA,MACf;AAAA,IACF;AAAA,EACF;AAEA,MAAI,YAAY,IAAI;AAClB,WAAO;AAAA,MACL,MAAM;AAAA,MACN,QAAQ;AAAA,QACN,aAAa;AAAA,MACf;AAAA,IACF;AAAA,EACF;AAEA,SAAO;AACT;AAEA,SAAS,kBAAmBA,KAAI;AA6B9B,QAAM,WAAW,mBAAmB;AAEpC,MAAI;AAEJ,EAAAA,IAAG,QAAQ,SAAO;AAChB,UAAM,eAAe,oBAAoB,GAAG;AAC5C,UAAM,YAAY,IAAI;AAEtB,QAAI,4BAA4B;AAChC,QAAI,kBAAkB;AACtB,QAAI,sBAAsB;AAC1B,QAAI,uBAAuB;AAC3B,QAAI,qBAAqB;AACzB,QAAI,aAAa;AAEjB,aAAS,SAAS,KAAK,WAAW,KAAK,UAAUH,cAAa;AAC5D,YAAM,QAAQ,aAAa,IAAI,MAAM;AAErC,YAAM,QAAQ,MAAM,YAAY;AAChC,UAAI,MAAM,OAAO,SAAS,GAAG;AAC3B,0BAAkB,SAAU,IAAIA;AAChC,6BAAqB,SAAU,IAAIA;AACnC,qBAAa,SAAU,IAAIA;AAC3B,YAAI,YAAY,IAAI;AAClB,6BAAmBA;AAEnB,sCAA4B,kBAAkBA,eAAe,IAAI,IAAM,IAAI;AAE3E,gCAAsB,SAAU,IAAIA;AAEpC,gCAAsBA;AAEtB,wBAAcA;AAAA,QAChB;AAEA,+BAAuB,SAAU,IAAIA;AACrC,YAAI,YAAY,IAAI;AAClB,kCAAyB,IAAIA,eAAe;AAC5C,cAAIA,iBAAgB,GAAG;AACrB,oCAAwB;AAAA,UAC1B;AAAA,QACF;AACA,YAAI,YAAY,IAAI;AAClB,kCAAwBA;AAAA,QAC1B;AAEA;AAAA,MACF;AAAA,IACF;AAEA,QAAI,yBAAyB,MAAM;AACjC,YAAM,IAAI,MAAM,6CAA6C;AAAA,IAC/D;AAEA,WAAO;AAAA,MACL,QAAQ;AAAA,QACN,sCAAsC;AAAA,QACtC,WAAW;AAAA,QACX,eAAe;AAAA,QACf,gBAAgB;AAAA,QAChB,cAAc;AAAA,QACd,MAAM;AAAA,MACR;AAAA,IACF;AAAA,EACF,CAAC;AAED,SAAO;AACT;AAEA,SAAS,0BAA2B;AAClC,QAAM,WAAW,mBAAmB;AAEpC,MAAI,YAAY,IAAI;AAClB,WAAO;AAAA,MACL,QAAQ;AAAA,QACN,eAAe;AAAA,QACf,MAAMA;AAAA,MACR;AAAA,IACF;AAAA,EACF,OAAO;AACL,WAAO;AAAA,MACL,QAAQ;AAAA,QACN,eAAe,IAAIA;AAAA,QACnB,MAAM;AAAA,MACR;AAAA,IACF;AAAA,EACF;AACF;AAEA,IAAM,4BAA4B;AAAA,EAChC,MAAM;AAAA,EACN,KAAK;AAAA,EACL,KAAK;AAAA,EACL,OAAO;AACT;AAEA,SAAS,oCAAqC,YAAYG,KAAI;AAC5D,MAAI;AAEJ,EAAAA,IAAG,QAAQ,SAAO;AAChB,UAAM,SAAS,oBAAoB,GAAG;AAEtC,UAAM,WAAW,0BAA0B,QAAQ,IAAI;AAEvD,UAAM,OAAO,YAAY,MAAM,UAAU;AAEzC,UAAM,SAAS,SAAS,IAAI;AAC5B,QAAI,WAAW,MAAM;AACnB,gBAAU,OAAO,IAAI,MAAM,EAAE,YAAY;AAAA,IAC3C,OAAO;AACL,gBAAU;AAAA,IACZ;AAAA,EACF,CAAC;AAED,SAAO;AACT;AAEA,SAAS,2BAA4B,MAAM;AACzC,MAAI,KAAK,aAAa,OAAO;AAC3B,WAAO,KAAK,SAAS,CAAC,EAAE,MAAM;AAAA,EAChC;AAEA,SAAO;AACT;AAEA,SAAS,2BAA4B,MAAM;AACzC,MAAI,KAAK,aAAa,SAAS;AAC7B,WAAO,KAAK,SAAS,CAAC,EAAE,MAAM;AAAA,EAChC;AAEA,SAAO;AACT;AAEA,SAAS,6BAA8B,MAAM;AAC3C,MAAI,KAAK,aAAa,OAAO;AAC3B,WAAO,KAAK,SAAS,CAAC,EAAE,MAAM;AAAA,EAChC;AAEA,SAAO;AACT;AAEO,SAAS,oBAAqB,KAAK;AACxC,SAAO,IAAI,OAAO,IAAIH,YAAW,EAAE,YAAY;AACjD;AAEA,SAAS,qBAAsB;AAC7B,SAAO,yBAAyB,0BAA0B;AAC5D;AAEA,SAAS,sBAAuB;AAC9B,SAAO,yBAAyB,2BAA2B;AAC7D;AAEA,SAAS,sBAAuB;AAC9B,SAAO,SAAS,yBAAyB,sBAAsB,GAAG,EAAE;AACtE;AAEA,IAAI,oBAAoB;AACxB,IAAM,iBAAiB;AAEvB,SAAS,yBAA0B,MAAM;AACvC,MAAI,sBAAsB,MAAM;AAC9B,wBAAoB,IAAI;AAAA,MACtB,QAAQ,gBAAgB,SAAS,EAAE,gBAAgB,uBAAuB;AAAA,MAC1E;AAAA,MACA,CAAC,WAAW,SAAS;AAAA,MACrBC;AAAA,IAAqB;AAAA,EACzB;AACA,QAAM,MAAM,OAAO,MAAM,cAAc;AACvC,oBAAkB,OAAO,gBAAgB,IAAI,GAAG,GAAG;AACnD,SAAO,IAAI,eAAe;AAC5B;AAEO,SAAS,sBAAuBE,KAAI,KAAK,IAAI;AAClD,QAAM,UAAU,gCAAgCA,KAAI,GAAG;AAEvD,QAAM,KAAK,oBAAoB,GAAG,EAAE,SAAS;AAC7C,4BAA0B,EAAE,IAAI;AAEhC,UAAQ,IAAI,MAAM;AAElB,MAAI,0BAA0B,EAAE,MAAM,QAAW;AAC/C,WAAO,0BAA0B,EAAE;AACnC,UAAM,IAAI,MAAM,uDAAuD;AAAA,EACzE;AACF;AAEA,SAAS,iCAAkCA,KAAI,KAAK;AAClD,QAAM,WAAW,IAAI,eAAe,iCAAiC,QAAQ,CAAC,SAAS,CAAC;AACxF,SAAO,iCAAiCA,KAAI,KAAK,QAAQ;AAC3D;AAEA,SAAS,gCAAiC,QAAQ;AAChD,QAAM,KAAK,OAAO,SAAS;AAE3B,QAAM,KAAK,0BAA0B,EAAE;AACvC,SAAO,0BAA0B,EAAE;AACnC,KAAG,MAAM;AACX;AAEO,SAAS,2BAA4B,IAAI;AAC9C,QAAMI,OAAM,OAAO;AAEnB,QAAM,aAAaA,KAAI;AACvB,QAAM,cAAc;AACpB,EAAAA,KAAI,6BAA6B,EAAE,YAAY,OAAO,gBAAgB,OAAO,GAAG,cAAc,IAAI,CAAC;AACnG,MAAI;AACF,OAAG;AAAA,EACL,UAAE;AACA,IAAAA,KAAI,4BAA4B,EAAE,UAAU;AAAA,EAC9C;AACF;AAEA,IAAM,kBAAN,MAAsB;AAAA,EACpB,YAAa,OAAO;AAClB,UAAM,UAAU,OAAO,MAAM,IAAIP,YAAW;AAE5C,UAAMQ,UAAS,QAAQ,IAAIR,YAAW;AACtC,YAAQ,aAAaQ,OAAM;AAE3B,UAAM,UAAU,IAAI,eAAe,CAAC,MAAM,UAAU;AAClD,aAAO,MAAM,KAAK,MAAM,OAAO,IAAI;AAAA,IACrC,GAAG,QAAQ,CAAC,WAAW,SAAS,CAAC;AACjC,IAAAA,QAAO,IAAI,IAAIR,YAAW,EAAE,aAAa,OAAO;AAEhD,SAAK,SAAS;AACd,SAAK,WAAW;AAAA,EAClB;AACF;AAEO,SAAS,oBAAqB,OAAO;AAC1C,QAAMO,OAAM,OAAO;AAEnB,MAAIA,KAAI,gCAAgC,aAAa,gBAAgB;AACnE,WAAO,IAAI,gBAAgB,KAAK;AAAA,EAClC;AAEA,SAAO,IAAI,eAAe,WAAS;AACjC,WAAO,MAAM,KAAK,MAAM,OAAO,IAAI;AAAA,EACrC,GAAG,QAAQ,CAAC,WAAW,SAAS,CAAC;AACnC;AAEA,IAAM,wBAAN,MAA4B;AAAA,EAC1B,YAAa,OAAO;AAClB,UAAM,UAAU,OAAO,MAAM,IAAIP,YAAW;AAE5C,UAAMQ,UAAS,QAAQ,IAAIR,YAAW;AACtC,YAAQ,aAAaQ,OAAM;AAE3B,UAAM,UAAU,IAAI,eAAe,CAAC,MAAM,UAAU;AAClD,YAAM,KAAK;AAAA,IACb,GAAG,QAAQ,CAAC,WAAW,SAAS,CAAC;AACjC,IAAAA,QAAO,IAAI,IAAIR,YAAW,EAAE,aAAa,OAAO;AAEhD,SAAK,SAAS;AACd,SAAK,WAAW;AAAA,EAClB;AACF;AAEO,SAAS,0BAA2B,OAAO;AAChD,SAAO,IAAI,sBAAsB,KAAK;AACxC;AAEA,IAAM,WAAW;AAAA,EACf,0BAA0B;AAAA,EAC1B,uBAAuB;AACzB;AAEO,IAAM,kBAAN,MAAsB;AAAA,EAC3B,YAAa,QAAQ,SAAS,UAAU,YAAY,GAAG,iBAAiB,MAAM;AAC5E,UAAMO,OAAM,OAAO;AAEnB,UAAM,WAAW;AACjB,UAAM,aAAa,IAAIP;AAEvB,UAAM,UAAU,OAAO,MAAM,WAAW,UAAU;AAElD,IAAAO,KAAI,iCAAiC;AAAA,MAAE;AAAA,MAAS;AAAA,MAAQ;AAAA,MAAS,SAAS,QAAQ;AAAA,MAAG;AAAA,MACnF,iBAAiB,IAAI;AAAA,IAAC;AAExB,UAAMC,UAAS,QAAQ,IAAI,QAAQ;AACnC,YAAQ,aAAaA,OAAM;AAE3B,UAAM,eAAe,IAAI,eAAe,KAAK,YAAY,KAAK,IAAI,GAAG,QAAQ,CAAC,SAAS,CAAC;AACxF,IAAAA,QAAO,IAAI,IAAIR,YAAW,EAAE,aAAa,YAAY;AAErD,SAAK,SAAS;AACd,SAAK,gBAAgB;AAErB,UAAM,iBAAiB,QAAQ,IAAKA,iBAAgB,IAAK,KAAK,EAAE;AAChE,SAAK,kBAAkB;AACvB,SAAK,iBAAiB,eAAe,IAAIA,YAAW;AACpD,SAAK,mBAAmB,eAAe,IAAI,IAAIA,YAAW;AAC1D,SAAK,2BAA2B,eAAe,IAAI,IAAIA,YAAW;AAElE,SAAK,iBAAiBO,KAAI,8BAA8B;AACxD,SAAK,eAAeA,KAAI,qCAAqC;AAC7D,SAAK,eAAeA,KAAI,6CAA6C;AAAA,EACvE;AAAA,EAEA,UAAW,qBAAqB,OAAO;AACrC,WAAO,EAAE,8BAA8B,EAAE,KAAK,QAAQ,qBAAqB,IAAI,CAAC;AAAA,EAClF;AAAA,EAEA,cAAe;AACb,WAAO,KAAK,WAAW,IAAI,IAAI;AAAA,EACjC;AAAA,EAEA,aAAc;AACZ,UAAM,IAAI,MAAM,oCAAoC;AAAA,EACtD;AAAA,EAEA,YAAa;AACX,UAAM,eAAe,KAAK,eAAe,KAAK,MAAM;AACpD,QAAI,aAAa,OAAO,GAAG;AACzB,aAAO;AAAA,IACT;AACA,WAAO,IAAI,UAAU,YAAY;AAAA,EACnC;AAAA,EAEA,yBAA0B;AACxB,WAAO,KAAK,iBAAiB,YAAY;AAAA,EAC3C;AAAA,EAEA,uBAAwB;AACtB,WAAO,KAAK,eAAe,YAAY;AAAA,EACzC;AAAA,EAEA,wBAAyB;AACvB,WAAO,KAAK,gBAAgB,YAAY;AAAA,EAC1C;AAAA,EAEA,mBAAoB;AAClB,UAAM,SAAS,IAAI,UAAU;AAC7B,SAAK,aAAa,QAAQ,KAAK,MAAM;AACrC,WAAO,OAAO,gBAAgB;AAAA,EAChC;AAAA,EAEA,iCAAkC;AAChC,WAAO,KAAK,yBAAyB,YAAY;AAAA,EACnD;AAAA,EAEA,2BAA4B;AAC1B,WAAO,KAAK,aAAa,KAAK,MAAM;AAAA,EACtC;AACF;AAEO,IAAM,YAAN,MAAgB;AAAA,EACrB,YAAaD,SAAQ;AACnB,SAAK,SAASA;AAAA,EAChB;AAAA,EAEA,aAAc,gBAAgB,MAAM;AAClC,UAAM,SAAS,IAAI,UAAU;AAC7B,WAAO,EAAE,8BAA8B,EAAE,QAAQ,KAAK,QAAQ,gBAAgB,IAAI,CAAC;AACnF,WAAO,OAAO,gBAAgB;AAAA,EAChC;AAAA,EAEA,WAAY;AACV,WAAO,oBAAoB,KAAK,MAAM;AAAA,EACxC;AACF;AAEA,SAAS,4BAA6B,MAAM;AAC1C,SAAO,SAAU,MAAM;AACrB,UAAM,SAAS,OAAO,MAAM,EAAE;AAE9B,oCAAgC,IAAI,EAAE,QAAQ,IAAI;AAElD,WAAO;AAAA,MACL,kBAAkB,OAAO,QAAQ;AAAA,MACjC,eAAe,OAAO,IAAI,CAAC,EAAE,QAAQ;AAAA,MACrC,aAAa,OAAO,IAAI,CAAC,EAAE,QAAQ;AAAA,IACrC;AAAA,EACF;AACF;AAEA,SAAS,iCAAkC,MAAM;AAC/C,MAAI,QAAQ;AACZ,UAAQ,QAAQ,MAAM;AAAA,IACpB,KAAK;AACH,cAAQ,UAAU,IAAI,YAAU;AAC9B,eAAO,sBAAsB,OAAO,OAAO,CAAC;AAC5C,eAAO,sBAAsB,OAAO,OAAO,CAAC;AAC5C,eAAO,4BAA4B,MAAM,CAAC,OAAO,KAAK,CAAC;AAGvD,eAAO,aAAa,OAAO,KAAK;AAChC,eAAO,UAAU,KAAK;AAEtB,eAAO,OAAO;AAAA,MAChB,CAAC;AACD;AAAA,IACF,KAAK;AACH,cAAQ,UAAU,IAAI,YAAU;AAC9B,eAAO,WAAW,KAAK;AACvB,eAAO,4BAA4B,MAAM,CAAC,KAAK,CAAC;AAChD,eAAO,UAAU,KAAK;AAItB,eAAO,gBAAgB,OAAO,KAAK;AACnC,eAAO,sBAAsB,OAAO,GAAG,KAAK;AAE5C,eAAO,OAAO;AAAA,MAChB,CAAC;AACD;AAAA,IACF,KAAK;AACH,cAAQ,UAAU,IAAI,YAAU;AAE9B,eAAO,4BAA4B,MAAM,CAAC,MAAM,IAAI,CAAC;AACrD,eAAO,WAAW,CAAC,MAAM,IAAI,CAAC;AAC9B,eAAO,aAAa,MAAM,IAAI;AAAA,MAChC,CAAC;AACD;AAAA,IACF,KAAK;AACH,cAAQ,UAAU,IAAI,YAAU;AAC9B,eAAO,cAAc,MAAM,IAAI;AAC/B,eAAO,4BAA4B,MAAM,CAAC,IAAI,CAAC;AAC/C,eAAO,aAAa,MAAM,IAAI;AAC9B,eAAO,mBAAmB,MAAM,MAAM,CAAC;AACvC,eAAO,mBAAmB,MAAM,MAAM,CAAC;AACvC,eAAO,OAAO;AAAA,MAChB,CAAC;AACD;AAAA,EACJ;AACA,SAAO,IAAI,eAAe,OAAO,QAAQ,CAAC,WAAW,SAAS,GAAGL,sBAAqB;AACxF;AAEA,IAAM,kBAAkB;AAAA,EACtB,MAAM,WAAW;AAAA,EACjB,KAAK,WAAW;AAAA,EAChB,KAAK,WAAW;AAAA,EAChB,OAAO,WAAW;AACpB;AAEA,IAAM,eAAe;AAAA,EACnB,MAAM,WAAW;AAAA,EACjB,KAAK,WAAW;AAAA,EAChB,KAAK,WAAW;AAAA,EAChB,OAAO,WAAW;AACpB;AAEA,SAAS,UAAW,MAAMQ,QAAO;AAC/B,MAAI,cAAc,MAAM;AACtB,gBAAY,OAAO,MAAM,QAAQ,QAAQ;AAAA,EAC3C;AAEA,QAAM,QAAQ,UAAU,IAAI,WAAW;AAEvC,QAAM,OAAO,QAAQ;AAErB,QAAM,SAAS,aAAa,IAAI;AAChC,SAAO,UAAU,OAAO,MAAM,CAAAC,UAAQ;AACpC,UAAM,SAAS,IAAI,OAAOA,OAAM,EAAE,IAAI,MAAM,CAAC;AAC7C,IAAAD,OAAM,MAAM;AACZ,WAAO,MAAM;AACb,QAAI,OAAO,SAAS,MAAM;AACxB,YAAM,IAAI,MAAM,SAAS,OAAO,MAAM,0BAA0B,IAAI,EAAE;AAAA,IACxE;AAAA,EACF,CAAC;AAED,iBAAe;AAEf,SAAQ,SAAS,QAAS,MAAM,GAAG,CAAC,IAAI;AAC1C;AAEA,SAAS,sBAAuBE,SAAQR,KAAI;AAC1C,iDAA+CA,GAAE;AACjD,8CAA4CA,GAAE;AAChD;AAEA,SAAS,kBAAmBI,MAAKJ,KAAI;AACnC,QAAM,gBAAgB,iBAAiBA,GAAE,EAAE;AAC3C,QAAM,sBAAsB,uBAAuB,EAAE;AAErD,QAAMO,QAAO;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA,6BA6Hc,cAAc,YAAY;AAAA,sDACD,oBAAoB,aAAa;AAAA;AAAA;AAAA;AAAA,yDAI9B,oBAAoB,IAAI;AAAA;AAAA;AAAA;AAAA,+EAIF,oBAAoB,aAAa;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA,iCAgC9E,QAAQ,SAAS,UAAW,IAAI,CAAC;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AA0BjE,QAAM,WAAW;AACjB,QAAM,cAAcV;AACpB,QAAM,mBAAmBA;AACzB,QAAM,wBAAwBA;AAE9B,QAAM,OAAO,OAAO,MAAM,WAAW,cAAc,mBAAmB,qBAAqB;AAE3F,QAAM,OAAO;AACb,QAAM,UAAU,KAAK,IAAI,QAAQ;AACjC,QAAM,eAAe,QAAQ,IAAI,WAAW;AAC5C,QAAM,oBAAoB,aAAa,IAAI,gBAAgB;AAE3D,QAAM,8BAA8BO,KAAI,KAAMP,iBAAgB,IAC1D,iDACA,8CAA8C;AAElD,QAAMY,MAAK,IAAI,QAAQF,OAAM;AAAA,IAC3B;AAAA,IACA;AAAA,IACA;AAAA,IACA,sBAAsB;AAAA,IACtB,kCAAkC,+BAA+B,IAAI,YAAY;AAAA,EACnF,CAAC;AAED,QAAM,cAAc,EAAE,YAAY,aAAa,YAAY,YAAY;AAEvE,SAAO;AAAA,IACL,QAAQE;AAAA,IACR,iBAAiB;AAAA,MACf,eAAe,IAAI,eAAeA,IAAG,uBAAuB,QAAQ,CAAC,SAAS,GAAG,WAAW;AAAA,MAC5F,KAAK,IAAI,eAAeA,IAAG,wBAAwB,WAAW,CAAC,SAAS,GAAG,WAAW;AAAA,MACtF,KAAK,IAAI,eAAeA,IAAG,wBAAwB,QAAQ,CAAC,WAAW,SAAS,GAAG,WAAW;AAAA,MAC9F,QAAQ,IAAI,eAAeA,IAAG,2BAA2B,QAAQ,CAAC,SAAS,GAAG,WAAW;AAAA,MACzF,WAAW,IAAI,eAAeA,IAAG,kBAAkB,WAAW,CAAC,SAAS,GAAG,WAAW;AAAA,MACtF,8BAA8BA,IAAG;AAAA,IACnC;AAAA,IACA;AAAA,IACA,OAAO;AAAA,MACL,aAAa;AAAA,QACX,QAAQA,IAAG;AAAA,MACb;AAAA,MACA,WAAW;AAAA,QACT,yBAAyBA,IAAG;AAAA,QAC5B,cAAcA,IAAG;AAAA,MACnB;AAAA,MACA,IAAI;AAAA,QACF,cAAc;AAAA,UACZ,SAASA,IAAG;AAAA,QACd;AAAA,QACA,SAAS;AAAA,UACP,SAASA,IAAG;AAAA,QACd;AAAA,MACF;AAAA,IACF;AAAA,EACF;AACF;AAEA,SAAS,+CAAgDT,KAAI;AAC3D,MAAI,qCAAqC;AACvC;AAAA,EACF;AACA,wCAAsC;AAEtC,gCAA8BA,GAAE;AAChC,+CAA6C;AAC/C;AAEA,SAAS,8BAA+BA,KAAI;AAC1C,QAAMI,OAAM,OAAO;AAGnB,QAAM,mBAAmB;AAAA,IACvBA,KAAI;AAAA,IACJA,KAAI;AAAA,IACJA,KAAI;AAAA,EACN;AAEA,mBAAiB,QAAQ,gBAAc;AACrC,WAAO,QAAQ,YAAY,IAAI,KAAK;AAEpC,UAAM,cAAc,IAAI,wBAAwB,UAAU;AAC1D,gBAAY,SAASJ,GAAE;AAEvB,yBAAqB,KAAK,WAAW;AAAA,EACvC,CAAC;AACH;AAEA,SAAS,+CAAgD;AACvD,QAAMI,OAAM,OAAO;AAEnB,QAAM,WAAW,mBAAmB;AACpC,QAAM,EAAE,6BAA6B,IAAIA;AAEzC,MAAI;AACJ,MAAI,YAAY,IAAI;AAClB,sCAAkC;AAAA,EACpC,WAAW,YAAY,MAAM,CAAC,8BAA8B;AAC1D,sCAAkC;AAAA,EACpC,WAAW,8BAA8B;AACvC,sCAAkC;AAAA,EACpC,OAAO;AACL,UAAM,IAAI,MAAM,4DAA4D;AAAA,EAC9E;AAEA,QAAM,MAAMA,KAAI;AAChB,QAAM,UAAU,CAAC,GAAG,IAAI,iBAAiB,GAAG,GAAG,IAAI,iBAAiB,CAAC,EAAE,OAAO,WAAS,gCAAgC,KAAK,MAAM,IAAI,CAAC;AAEvI,MAAI,QAAQ,WAAW,GAAG;AACxB,UAAM,IAAI,MAAM,4DAA4D;AAAA,EAC9E;AAEA,aAAW,SAAS,SAAS;AAC3B,gBAAY,OAAO,MAAM,SAAS,cAAc,MAAM,YAAY,MAAM;AAAA,EAC1E;AACF;AAEA,SAAS,4CAA6CJ,KAAI;AACxD,MAAI,kCAAkC;AACpC;AAAA,EACF;AACA,qCAAmC;AAEnC,MAAI,CAAC,mDAAmD,GAAG;AACzD,UAAM,EAAE,4BAA4B,IAAI;AACxC,QAAI,gCAAgC,MAAM;AACxC;AAAA,IACF;AAEA,QAAI;AACF,kBAAY,QAAQ,6BAA6B,cAAc,MAAM,UAAU,uBAAuB;AAAA,IACxG,SAAS,GAAG;AAAA,IAKZ;AAAA,EACF;AAEA,QAAM,WAAW,mBAAmB;AAEpC,MAAI,eAAe;AACnB,QAAMI,OAAM,OAAO;AACnB,MAAI,WAAW,IAAI;AACjB,mBAAeA,KAAI,KAAK,yDAAyD;AAAA,EACnF,WAAW,WAAW,IAAI;AACxB,mBAAeA,KAAI,KAAK,yDAAyD;AAAA,EACnF;AACA,MAAI,iBAAiB,MAAM;AACzB,gBAAY,OAAO,cAAc,cAAc,MAAM,GAAG,YAAY;AAAA,EACtE;AAEA,MAAI,UAAU;AACd,YAAUA,KAAI,KAAK,sCAAsC;AACzD,MAAI,YAAY,MAAM;AACpB,cAAUA,KAAI,KAAK,uCAAuC;AAAA,EAC5D;AACA,MAAI,YAAY,MAAM;AACpB,gBAAY,OAAO,SAAS,cAAc,MAAM,GAAG,OAAO;AAAA,EAC5D;AACF;AAEA,IAAM,+CAA+C;AAAA,EACnD,KAAK;AAAA,IACH,YAAY;AAAA,MACV;AAAA,QACE,SAAS;AAAA,UACP;AAAA;AAAA,UACA;AAAA;AAAA,UACA;AAAA;AAAA,UACA;AAAA;AAAA,UACA;AAAA,UACA;AAAA,UACA;AAAA,UACA;AAAA,UACA;AAAA,QACF;AAAA,QACA,eAAe;AAAA,MACjB;AAAA,MACA;AAAA,QACE,SAAS;AAAA,UACP;AAAA;AAAA,UACA;AAAA;AAAA,UACA;AAAA;AAAA,UACA;AAAA;AAAA,UACA;AAAA,UACA;AAAA,UACA;AAAA,UACA;AAAA,UACA;AAAA,QACF;AAAA,QACA,eAAe;AAAA,MACjB;AAAA,MACA;AAAA,QACE,SAAS;AAAA,UACP;AAAA;AAAA,UACA;AAAA;AAAA,UACA;AAAA;AAAA,UACA;AAAA;AAAA,UACA;AAAA,UACA;AAAA,UACA;AAAA,UACA;AAAA,UACA;AAAA,QACF;AAAA,QACA,eAAe;AAAA,MACjB;AAAA,IACF;AAAA,IACA,YAAY;AAAA,EACd;AAAA,EACA,OAAO;AAAA,IACL,YAAY;AAAA,MACV;AAAA,QACE,SAAS;AAAA;AAAA,UACE;AAAA;AAAA,UACT;AAAA;AAAA,UACA;AAAA;AAAA,UACA;AAAA;AAAA,UACA;AAAA;AAAA,UACS;AAAA,UACT;AAAA,UACA;AAAA,UACA;AAAA,QACF;AAAA,QACA,QAAQ;AAAA,QACR,eAAe;AAAA,MACjB;AAAA,MACA;AAAA,QACE,SAAS;AAAA;AAAA,UACE;AAAA;AAAA,UACT;AAAA;AAAA,UACA;AAAA;AAAA,UACA;AAAA;AAAA,UACA;AAAA;AAAA,UACS;AAAA,UACT;AAAA,UACA;AAAA,UACA;AAAA,QACF;AAAA,QACA,QAAQ;AAAA,QACR,eAAe;AAAA,MACjB;AAAA,IACF;AAAA,IACA,YAAY;AAAA,EACd;AACF;AAEA,SAAS,+CAAgD,EAAE,SAAS,KAAK,GAAG;AAC1E,QAAM,MAAM,YAAY,MAAM,QAAQ,GAAG,CAAC,CAAC;AAC3C,QAAM,CAAC,QAAQ,MAAM,IAAI,IAAI;AAC7B,QAAM,YAAY,OAAO,MAAM;AAC/B,QAAM,aAAa,OAAO;AAE1B,QAAM,SAAS,YAAY,MAAM,IAAI,KAAK,IAAI,CAAC,CAAC;AAChD,QAAM,iBAAiB,IAAI,OAAO,SAAS,CAAC,EAAE,KAAK;AACnD,QAAM,kBAAkB,OAAO,QAAQ,IAAI,OAAO,IAAI;AAEtD,MAAI,yBAAyB;AAC7B,MAAI,OAAO,aAAa,OAAO;AAC7B,8BAA0B;AAC1B,8BAA0B;AAAA,EAC5B,OAAO;AACL,8BAA0B;AAC1B,8BAA0B;AAAA,EAC5B;AAEA,SAAO,oBAAoB,wBAAwB,GAAG,CAAC,GAAG,UAAU,EAAE,OAAO,EAAE,CAAC;AAEhF,WAAS,SAAU,MAAM;AACvB,UAAM,EAAE,SAAS,IAAI;AACrB,QAAI,EAAE,aAAa,SAAS,aAAa,UAAU;AACjD,aAAO;AAAA,IACT;AAEA,UAAM,EAAE,MAAM,KAAK,IAAI,KAAK,SAAS,CAAC,EAAE;AACxC,QAAI,EAAE,SAAS,aAAa,SAAS,KAAO;AAC1C,aAAO;AAAA,IACT;AAEA,WAAO;AAAA,MACL;AAAA,MACA;AAAA,MACA,QAAQ;AAAA,QACN,UAAU;AAAA,QACV,mBAAmB;AAAA,QACnB,mBAAmB;AAAA,MACrB;AAAA,IACF;AAAA,EACF;AACF;AAEA,SAAS,iDAAkD,EAAE,SAAS,KAAK,GAAG;AAC5E,QAAM,CAAC,QAAQ,MAAM,IAAI,YAAY,MAAM,OAAO,EAAE;AACpD,QAAM,YAAY,OAAO,MAAM;AAC/B,QAAM,aAAa,MAAM,OAAO,MAAM,UAAU,CAAC;AAEjD,QAAM,SAAS,YAAY,MAAM,QAAQ,IAAI,CAAC,CAAC;AAC/C,QAAM,iBAAiB,IAAI,OAAO,SAAS,CAAC,EAAE,KAAK;AACnD,QAAM,kBAAkB,QAAQ,IAAI,EAAE;AAEtC,MAAI,yBAAyB;AAC7B,MAAI,OAAO,aAAa,QAAQ;AAC9B,8BAA0B;AAC1B,8BAA0B;AAAA,EAC5B,OAAO;AACL,8BAA0B;AAC1B,8BAA0B;AAAA,EAC5B;AAEA,SAAO,oBAAoB,yBAAyB,UAAU,EAAE,OAAO,EAAE,CAAC;AAE1E,WAAS,SAAU,MAAM;AACvB,QAAI,KAAK,aAAa,OAAO;AAC3B,aAAO;AAAA,IACT;AAEA,UAAM,EAAE,MAAM,KAAK,IAAI,KAAK,SAAS,CAAC,EAAE;AACxC,QAAI,EAAE,SAAS,aAAa,SAAS,KAAO;AAC1C,aAAO;AAAA,IACT;AAEA,WAAO;AAAA,MACL;AAAA,MACA;AAAA,MACA,QAAQ;AAAA,QACN,UAAU;AAAA,QACV,mBAAmB;AAAA,QACnB,mBAAmB;AAAA,MACrB;AAAA,IACF;AAAA,EACF;AACF;AAEA,SAAS,qDAAsD;AAC7D,MAAI,mBAAmB,IAAI,IAAI;AAC7B,WAAO;AAAA,EACT;AAEA,QAAM,UAAU,6CAA6C,QAAQ,IAAI;AACzE,MAAI,YAAY,QAAW;AAEzB,WAAO;AAAA,EACT;AAEA,QAAM,aAAa,QAAQ,WAAW,IAAI,CAAC,EAAE,SAAS,SAAS,GAAG,gBAAgB,kBAAkB,MAAM;AACxG,WAAO;AAAA,MACL,SAAS,IAAI,aAAa,QAAQ,KAAK,EAAE,CAAC;AAAA,MAC1C;AAAA,MACA;AAAA,IACF;AAAA,EACF,CAAC;AAED,QAAM,QAAQ,CAAC;AACf,aAAW,EAAE,MAAM,KAAK,KAAK,OAAO,EAAE,OAAO,gBAAgB,KAAK,GAAG;AACnE,eAAW,EAAE,SAAS,QAAQ,cAAc,KAAK,YAAY;AAC3D,YAAM,UAAU,OAAO,SAAS,MAAM,MAAM,OAAO,EAChD,IAAI,CAAC,EAAE,SAAS,MAAAM,MAAK,MAAM;AAC1B,eAAO,EAAE,SAAS,QAAQ,IAAI,MAAM,GAAG,MAAMA,QAAO,OAAO;AAAA,MAC7D,CAAC,EACA,OAAO,WAAS;AACf,cAAM,mBAAmB,cAAc,KAAK;AAC5C,YAAI,qBAAqB,MAAM;AAC7B,iBAAO;AAAA,QACT;AACA,cAAM,mBAAmB;AACzB,eAAO;AAAA,MACT,CAAC;AACH,YAAM,KAAK,GAAG,OAAO;AAAA,IACvB;AAAA,EACF;AAEA,MAAI,MAAM,WAAW,GAAG;AACtB,WAAO;AAAA,EACT;AAEA,QAAM,QAAQ,QAAQ,UAAU;AAEhC,SAAO;AACT;AAEA,SAAS,oBAAqB;AAC5B,SAAO,CAAC;AACV;AAEA,IAAM,aAAN,MAAiB;AAAA,EACf,YAAa,SAAS,MAAM,YAAY;AACtC,SAAK,UAAU;AACf,SAAK,OAAO;AACZ,SAAK,eAAe,QAAQ,cAAc,IAAI;AAC9C,SAAK,aAAa;AAAA,EACpB;AAAA,EAEA,SAAU;AACR,WAAO,UAAU,KAAK,SAAS,KAAK,MAAM,CAAAH,UAAQ;AAChD,MAAAA,MAAK,eAAe,KAAK,YAAY;AAAA,IACvC,CAAC;AAAA,EACH;AACF;AAEA,SAAS,gDAAiD,EAAE,SAAS,MAAM,iBAAiB,GAAG;AAC7F,QAAM,EAAE,WAAW,OAAO,IAAI;AAE9B,QAAM,aAAa,OAAO,MAAM,QAAQ,QAAQ;AAChD,MAAI,mBAAmB;AAEvB,SAAO,UAAU,YAAY,KAAK,CAAAA,UAAQ;AACxC,UAAM,SAAS,IAAI,YAAYA,OAAM,EAAE,IAAI,WAAW,CAAC;AAEvD,UAAM,YAAY,IAAI,eAAe,SAAS,MAAM;AACpD,aAAS,IAAI,GAAG,MAAM,GAAG,KAAK;AAC5B,gBAAU,QAAQ;AAAA,IACpB;AACA,cAAU,SAAS;AAEnB,cAAU,QAAQ;AAClB,cAAU,QAAQ;AAClB,WAAO,cAAc,MAAM,+BAA+B;AAE1D,UAAM,cAAc,CAAC,IAAM,KAAM,IAAM,EAAI;AAC3C,WAAO,SAAS,WAAW;AAE3B,UAAM,YAAY,CAAC,MAAM,MAAM,MAAM,IAAI;AACzC,WAAO,YAAY,SAAS;AAE5B,WAAO,4BAA4B,cAAc,gBAAgB,eAAe,CAAC,SAAS,CAAC;AAC3F,WAAO,aAAa,MAAM,CAAC;AAE3B,WAAO,WAAW,SAAS;AAE3B,UAAM,aAAa,CAAC,KAAM,KAAM,IAAM,EAAI;AAC1C,WAAO,SAAS,UAAU;AAE1B,WAAO,cAAc,MAAM,+BAA+B;AAC1D,WAAO,UAAU,gBAAgB;AAEjC,cAAU,QAAQ;AAElB,UAAM,gBAAgB,UAAU,MAAM,QAAQ,OAAO,OAAO,iBAAiB;AAE7E,WAAO,SAAS,gBAAgB,mBAAmB,+BAA+B;AAClF,cAAU,SAAS;AACnB,WAAO,mBAAmB,IAAI;AAC5B,YAAM,SAAS,UAAU,QAAQ;AACjC,UAAI,WAAW,GAAG;AAChB,2BAAmB;AACnB;AAAA,MACF;AACA,yBAAmB;AAAA,IACrB;AACA,cAAU,SAAS;AACnB,WAAO,iBAAiB,QAAQ,IAAI,mBAAmB,CAAC,CAAC;AAEzD,WAAO,SAAS,gBAAgB,kCAAkC,gBAAgB;AAClF,WAAO,iBAAiB,OAAO,QAAQ;AAEvC,WAAO,MAAM;AAAA,EACf,CAAC;AAED,cAAY,KAAK,IAAI,WAAW,SAAS,kBAAkB,UAAU,CAAC;AAEtE,SAAO,UAAU,SAAS,kBAAkB,CAAAA,UAAQ;AAClD,UAAM,SAAS,IAAI,YAAYA,OAAM,EAAE,IAAI,QAAQ,CAAC;AACpD,WAAO,iBAAiB,MAAM,WAAW,GAAG,CAAC,CAAC;AAC9C,WAAO,MAAM;AAAA,EACf,CAAC;AACH;AAEA,SAAS,kDAAmD,EAAE,SAAS,MAAM,iBAAiB,GAAG;AAC/F,QAAM,EAAE,WAAW,YAAY,OAAO,IAAI;AAE1C,QAAM,aAAa,OAAO,MAAM,QAAQ,QAAQ;AAEhD,SAAO,UAAU,YAAY,KAAK,CAAAA,UAAQ;AACxC,UAAM,SAAS,IAAI,YAAYA,OAAM,EAAE,IAAI,WAAW,CAAC;AAEvD,UAAM,YAAY,IAAI,eAAe,SAAS,MAAM;AACpD,aAAS,IAAI,GAAG,MAAM,GAAG,KAAK;AAC5B,gBAAU,QAAQ;AAAA,IACpB;AACA,cAAU,SAAS;AAEnB,cAAU,QAAQ;AAClB,cAAU,QAAQ;AAClB,WAAO,cAAc,MAAM,+BAA+B;AAE1D,UAAM,YAAY;AAAA,MAChB;AAAA,MAAM;AAAA,MACN;AAAA,MAAM;AAAA,MACN;AAAA,MAAM;AAAA,MACN;AAAA,MAAM;AAAA,MACN;AAAA,MAAM;AAAA,MACN;AAAA,MAAM;AAAA,MACN;AAAA,MAAM;AAAA,MACN;AAAA,MAAM;AAAA,MACN;AAAA,MAAM;AAAA,MACN;AAAA,MAAO;AAAA,MACP;AAAA,MAAO;AAAA,MACP;AAAA,MAAO;AAAA,MACP;AAAA,MAAO;AAAA,IACT;AACA,UAAM,eAAe,UAAU;AAE/B,aAAS,IAAI,GAAG,MAAM,cAAc,KAAK,GAAG;AAC1C,aAAO,cAAc,UAAU,CAAC,GAAG,UAAU,IAAI,CAAC,CAAC;AAAA,IACrD;AAEA,WAAO,4BAA4B,cAAc,gBAAgB,eAAe,CAAC,SAAS,CAAC;AAC3F,WAAO,aAAa,MAAM,KAAK;AAE/B,aAAS,IAAI,eAAe,GAAG,KAAK,GAAG,KAAK,GAAG;AAC7C,aAAO,aAAa,UAAU,CAAC,GAAG,UAAU,IAAI,CAAC,CAAC;AAAA,IACpD;AAEA,WAAO,cAAc,MAAM,+BAA+B;AAC1D,WAAO,UAAU,gBAAgB;AAEjC,cAAU,QAAQ;AAClB,UAAM,kBAAkB,UAAU;AAElC,UAAM,gBAAgB,gBAAgB,QAAQ,OAAO,OAAO,iBAAiB;AAE7E,WAAO,SAAS,gBAAgB,mBAAmB,+BAA+B;AAClF,cAAU,SAAS;AACnB,WAAO,iBAAiB,gBAAgB,IAAI;AAE5C,WAAO,SAAS,gBAAgB,kCAAkC,gBAAgB;AAClF,WAAO,iBAAiB,OAAO,QAAQ;AAEvC,WAAO,MAAM;AAAA,EACf,CAAC;AAED,cAAY,KAAK,IAAI,WAAW,SAAS,MAAM,UAAU,CAAC;AAE1D,SAAO,UAAU,SAAS,MAAM,CAAAA,UAAQ;AACtC,UAAM,SAAS,IAAI,YAAYA,OAAM,EAAE,IAAI,QAAQ,CAAC;AACpD,WAAO,iBAAiB,YAAY,UAAU;AAC9C,WAAO,SAAS,UAAU;AAC1B,WAAO,MAAM;AAAA,EACf,CAAC;AACH;AAEO,SAAS,kBAAmB,UAAU;AAC3C,SAAO,IAAI,cAAc,QAAQ;AACnC;AAEO,SAAS,gBAAiB,UAAU;AACzC,SAAO,cAAc,gBAAgB,UAAU,QAAQ;AACzD;AAEO,SAAS,UAAWP,KAAI,UAAU,CAAC,GAAG;AAC3C,QAAM,EAAE,QAAQ,GAAG,IAAI;AAEvB,QAAM,MAAMA,IAAG,OAAO;AAEtB,MAAI,oBAAoB,MAAM;AAC5B,sBAAkB,oBAAoBA,KAAI,GAAG;AAAA,EAC/C;AAEA,SAAO,gBAAgB,UAAU,KAAK,KAAK;AAC7C;AAEA,SAAS,oBAAqBA,KAAI,KAAK;AACrC,QAAMI,OAAM,OAAO;AAEnB,QAAM,cAAc,OAAO,MAAM,QAAQ,WAAW;AAEpD,QAAMK,MAAK,IAAI,QAAQ;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA;AAAA,GA0btB;AAAA,IACC,mBAAmB,OAAO,MAAM,QAAQ,WAAW;AAAA,IACnD,qCAAqC;AAAA,IACrC,kCAAkCL,KAAI,iCAAiC;AAAA,IACvE,wBAAwBA,KAAI,iCAAiC;AAAA,IAC7D,8BAA8BA,KAAI,8BAA8B;AAAA,IAChE,8BAA8BA,KAAI,8BAA8B;AAAA,IAChE,qCAAqCA,KAAI,qCAAqC;AAAA,IAC9E,kBAAkB,cAAc,gBAAgB;AAAA,IAChD,oBAAoBA,KAAI,iCAAiC;AAAA,IACzD,oBAAoBA,KAAI,iCAAiC;AAAA,IACzD,YAAYA,KAAI;AAAA,IAChB,SAAS,QAAQ,gBAAgB,SAAS,EAAE,gBAAgB,SAAS;AAAA,EACvE,CAAC;AAED,QAAM,UAAU,IAAI,eAAeK,IAAG,SAAS,WAAW,CAAC,WAAW,MAAM,GAAGX,sBAAqB;AACpG,QAAM,WAAW,IAAI,eAAeW,IAAG,UAAU,QAAQ,CAAC,SAAS,GAAGX,sBAAqB;AAE3F,QAAM,cAAc,EAAE,YAAY,aAAa,YAAY,YAAY;AACvE,QAAM,SAAS,IAAI,eAAeW,IAAG,SAAS,WAAW,CAAC,SAAS,GAAG,WAAW;AACjF,QAAM,aAAa,IAAI,eAAeA,IAAG,aAAa,WAAW,CAAC,SAAS,GAAG,WAAW;AAEzF,QAAM,+BAA+B,iCAAiCT,KAAI,KAAKS,IAAG,oCAAoC;AACtH,EAAAA,IAAG,eAAe;AAClB,cAAY,aAAa,4BAA4B;AAErD,EAAAA,IAAG,YAAY,CAACE,MAAK,UAAU;AAC7B,UAAMR,UAAS,QAAQQ,MAAK,KAAK;AACjC,UAAM,KAAK,IAAI,UAAUR,OAAM;AAC/B,WAAO,SAAS,IAAI,QAAQ,KAAK,MAAMA,OAAM,CAAC;AAC9C,WAAO;AAAA,EACT;AAEA,WAAS,QAASA,SAAQ;AACxB,aAASA,OAAM;AAAA,EACjB;AAEA,EAAAM,IAAG,QAAQ,CAAAN,YAAU;AACnB,WAAO,OAAOA,OAAM,EAAE,eAAe;AAAA,EACvC;AAEA,EAAAM,IAAG,YAAY,CAAAN,YAAU;AACvB,WAAO,KAAK,MAAM,WAAWA,OAAM,EAAE,eAAe,CAAC;AAAA,EACvD;AAEA,SAAOM;AACT;AAEA,IAAM,YAAN,MAAgB;AAAA,EACd,YAAaN,SAAQ;AACnB,SAAK,SAASA;AAAA,EAChB;AAAA,EAEA,IAAI,KAAM;AACR,WAAO,gBAAgB,MAAM,KAAK,MAAM;AAAA,EAC1C;AAAA,EAEA,IAAI,SAAU;AACZ,WAAO,gBAAgB,UAAU,KAAK,MAAM;AAAA,EAC9C;AACF;AAEO,SAAS,sBAAuB;AACrC,iBAAe,QAAQ,WAAS;AAC9B,UAAM,UAAU,aAAa,MAAM,MAAM;AACzC,UAAM,eAAe,SAAS,MAAM,WAAW;AAAA,EACjD,CAAC;AACD,iBAAe,MAAM;AAErB,aAAW,eAAe,qBAAqB,OAAO,CAAC,GAAG;AACxD,gBAAY,WAAW;AAAA,EACzB;AAEA,aAAW,QAAQ,YAAY,OAAO,CAAC,GAAG;AACxC,SAAK,OAAO;AAAA,EACd;AACF;AAEA,SAAS,eAAgB,UAAU;AACjC,QAAMC,OAAM,OAAO;AAEnB,QAAM,gBAAgB,kBAAkBA,IAAG,EAAE;AAC7C,QAAM,qBAAqB,cAAc;AACzC,QAAM,0BAA0B,cAAc;AAE9C,MAAI,uBAAuB,QAAQ,4BAA4B,MAAM;AACnE,UAAMF,WAAUE,KAAI;AAEpB,UAAM,oBAAoBF,SAAQ,IAAI,uBAAuB,EAAE,QAAQ;AAEvE,QAAI,sBAAsB,UAAU;AAClC,YAAM,eAAeA,SAAQ,IAAI,kBAAkB,EAAE,YAAY;AACjE,aAAOE,KAAI,wCAAwC,EAAE,cAAc,QAAQ;AAAA,IAC7E;AAAA,EACF;AAEA,SAAO;AACT;AAEA,IAAM,2CAA2C;AAAA,EAC/C,MAAM;AAAA,EACN,KAAK;AAAA,EACL,KAAK;AAAA,EACL,OAAO;AACT;AAEA,SAAS,2CAA4C,YAAY,QAAQ,cAAc,aAAaJ,KAAI;AACtG,QAAM,gBAAgB,iBAAiBA,GAAE,EAAE;AAC3C,QAAM,mBAAmB,iBAAiBA,GAAE,EAAE;AAE9C,MAAI;AACJ,SAAO,UAAU,YAAY,KAAK,CAAAO,UAAQ;AACxC,UAAM,SAAS,IAAI,UAAUA,OAAM,EAAE,IAAI,WAAW,CAAC;AACrD,UAAM,YAAY,IAAI,aAAa,QAAQ,MAAM;AAEjD,UAAM,SAAS,CAAC,IAAM,KAAM,GAAM,EAAI;AACtC,UAAM,UAAU,CAAC,IAAM,KAAM,IAAM,EAAI;AAGvC,WAAO,UAAU;AAEjB,WAAO,aAAa,OAAO,KAAK;AAGhC,WAAO,aAAa,OAAO,UAAU;AACrC,WAAO,aAAa,OAAO,GAAG;AAC9B,WAAO,SAAS,MAAM;AAEtB,WAAO,kBAAkB,OAAO,cAAc,IAAI;AAClD,WAAO,mCAAmC,cAAc,gBAAgB,8BAA8B,CAAC,OAAO,KAAK,CAAC;AAEpH,WAAO,cAAc,OAAO,KAAK;AACjC,WAAO,iBAAiB,MAAM,qBAAqB,SAAS;AAG5D,WAAO,sBAAsB,OAAO,IAAI,GAAG,KAAK;AAEhD,WAAO,SAAS,mBAAmB;AAGnC,WAAO,SAAS,OAAO;AAEvB,WAAO,aAAa,OAAO,KAAK;AAGhC,WAAO,SAAS;AAEhB,WAAO,iBAAiB,OAAO,sBAAsB,SAAS;AAE9D,OAAG;AACD,eAAS,UAAU,QAAQ;AAAA,IAC7B,SAAS,SAAS,gBAAgB,CAAC,UAAU;AAE7C,cAAU,SAAS;AAEnB,QAAI,CAAC,UAAU,KAAK;AAClB,aAAO,cAAc,OAAO,IAAI,MAAM,CAAC;AAAA,IACzC;AAEA,WAAO,SAAS,oBAAoB;AAEpC,WAAO,mBAAmB,OAAO,iBAAiB,SAAS;AAE3D,WAAO,MAAM;AAAA,EACf,CAAC;AAED,SAAO;AACT;AAEA,SAAS,0CAA2C,YAAY,QAAQ,cAAc,aAAaP,KAAI;AACrG,QAAM,gBAAgB,iBAAiBA,GAAE,EAAE;AAC3C,QAAM,mBAAmB,iBAAiBA,GAAE,EAAE;AAE9C,MAAI;AACJ,SAAO,UAAU,YAAY,KAAK,CAAAO,UAAQ;AACxC,UAAM,SAAS,IAAI,UAAUA,OAAM,EAAE,IAAI,WAAW,CAAC;AACrD,UAAM,YAAY,IAAI,aAAa,QAAQ,MAAM;AAEjD,UAAM,SAAS,CAAC,IAAM,KAAM,GAAM,EAAI;AACtC,UAAM,UAAU,CAAC,IAAM,KAAM,IAAM,EAAI;AAGvC,WAAO,UAAU;AAEjB,WAAO,aAAa,OAAO,KAAK;AAGhC,WAAO,aAAa,OAAO,UAAU;AACrC,WAAO,aAAa,OAAO,GAAG;AAC9B,WAAO,SAAS,MAAM;AAEtB,WAAO,kBAAkB,OAAO,cAAc,IAAI;AAClD,WAAO,mCAAmC,cAAc,gBAAgB,8BAA8B,CAAC,OAAO,KAAK,CAAC;AAEpH,WAAO,cAAc,OAAO,KAAK;AACjC,WAAO,iBAAiB,MAAM,qBAAqB,SAAS;AAG5D,WAAO,sBAAsB,OAAO,IAAI,GAAG,KAAK;AAEhD,WAAO,SAAS,mBAAmB;AAGnC,WAAO,SAAS,OAAO;AAEvB,WAAO,aAAa,OAAO,KAAK;AAGhC,WAAO,SAAS;AAEhB,WAAO,iBAAiB,OAAO,sBAAsB,SAAS;AAE9D,OAAG;AACD,eAAS,UAAU,QAAQ;AAAA,IAC7B,SAAS,SAAS,gBAAgB,CAAC,UAAU;AAE7C,cAAU,SAAS;AAEnB,QAAI,CAAC,UAAU,KAAK;AAClB,aAAO,cAAc,OAAO,IAAI,MAAM,CAAC;AAAA,IACzC;AAEA,WAAO,SAAS,oBAAoB;AAEpC,WAAO,mBAAmB,OAAO,iBAAiB,SAAS;AAE3D,WAAO,MAAM;AAAA,EACf,CAAC;AAED,SAAO;AACT;AAEA,SAAS,0CAA2C,YAAY,QAAQ,cAAc,aAAaP,KAAI;AACrG,QAAM,mBAAmB,iBAAiBA,GAAE,EAAE;AAE9C,QAAM,gBAAgB,OAAO,IAAI,sBAAsB;AAEvD,MAAI;AACJ,SAAO,UAAU,YAAY,KAAK,CAAAO,UAAQ;AACxC,UAAM,SAAS,IAAI,YAAYA,OAAM,EAAE,IAAI,WAAW,CAAC;AACvD,UAAM,YAAY,IAAI,eAAe,eAAe,MAAM;AAE1D,UAAM,cAAc,CAAC,IAAM,KAAM,IAAM,EAAI;AAC3C,UAAM,aAAa,CAAC,KAAM,KAAM,IAAM,EAAI;AAG1C,WAAO,YAAY;AAAA,MACjB;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,IACF,CAAC;AAGD,WAAO,SAAS,WAAW;AAG3B,WAAO,gBAAgB,MAAM,MAAM,CAAC;AACpC,WAAO,mBAAmB,MAAM,MAAM,CAAC;AAEvC,WAAO,4BAA4B,cAAc,gBAAgB,8BAA8B,CAAC,MAAM,IAAI,CAAC;AAE3G,WAAO,aAAa,MAAM,CAAC;AAC3B,WAAO,cAAc,MAAM,mBAAmB;AAG9C,WAAO,mBAAmB,MAAM,MAAM,CAAC;AAEvC,WAAO,SAAS,mBAAmB;AAGnC,WAAO,mBAAmB,MAAM,MAAM,CAAC;AACvC,WAAO,gBAAgB,MAAM,MAAM,CAAC;AAGpC,WAAO,SAAS,UAAU;AAG1B,WAAO,WAAW;AAAA,MAChB;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,MACA;AAAA,IACF,CAAC;AAED,WAAO,cAAc,MAAM,oBAAoB;AAE/C,OAAG;AACD,eAAS,UAAU,QAAQ;AAAA,IAC7B,SAAS,SAAS,gBAAgB,CAAC,UAAU;AAE7C,cAAU,SAAS;AAEnB,QAAI,CAAC,UAAU,KAAK;AAClB,aAAO,iBAAiB,MAAM,OAAO,IAAI,MAAM,CAAC;AAAA,IAClD;AAEA,WAAO,SAAS,oBAAoB;AAEpC,WAAO,mBAAmB,MAAM,MAAM,iBAAiB,SAAS;AAEhE,WAAO,MAAM;AAAA,EACf,CAAC;AAED,SAAO;AACT;AAEA,SAAS,4CAA6C,YAAY,QAAQ,cAAc,EAAE,qBAAqB,GAAGP,KAAI;AACpH,QAAM,mBAAmB,iBAAiBA,GAAE,EAAE;AAE9C,MAAI;AACJ,SAAO,UAAU,YAAY,KAAK,CAAAO,UAAQ;AACxC,UAAM,SAAS,IAAI,YAAYA,OAAM,EAAE,IAAI,WAAW,CAAC;AACvD,UAAM,YAAY,IAAI,eAAe,QAAQ,MAAM;AAGnD,WAAO,cAAc,MAAM,IAAI;AAC/B,WAAO,cAAc,MAAM,IAAI;AAC/B,WAAO,cAAc,MAAM,IAAI;AAC/B,WAAO,cAAc,MAAM,IAAI;AAG/B,WAAO,cAAc,MAAM,IAAI;AAC/B,WAAO,cAAc,MAAM,IAAI;AAC/B,WAAO,cAAc,MAAM,IAAI;AAC/B,WAAO,cAAc,MAAM,KAAK;AAChC,WAAO,cAAc,OAAO,KAAK;AACjC,WAAO,cAAc,OAAO,KAAK;AACjC,WAAO,cAAc,OAAO,KAAK;AACjC,WAAO,cAAc,OAAO,KAAK;AACjC,WAAO,cAAc,OAAO,IAAI;AAGhC,WAAO,gBAAgB,MAAM,MAAM,EAAE;AACrC,WAAO,mBAAmB,MAAM,MAAM,CAAC;AAEvC,WAAO,4BAA4B,cAAc,gBAAgB,8BAA8B,CAAC,MAAM,KAAK,CAAC;AAE5G,WAAO,aAAa,MAAM,KAAK;AAC/B,WAAO,cAAc,MAAM,mBAAmB;AAG9C,WAAO,mBAAmB,MAAM,MAAM,CAAC;AAEvC,WAAO,SAAS,mBAAmB;AAGnC,WAAO,mBAAmB,MAAM,MAAM,CAAC;AACvC,WAAO,gBAAgB,MAAM,MAAM,EAAE;AAGrC,WAAO,aAAa,OAAO,IAAI;AAC/B,WAAO,aAAa,OAAO,KAAK;AAChC,WAAO,aAAa,OAAO,KAAK;AAChC,WAAO,aAAa,OAAO,KAAK;AAChC,WAAO,aAAa,OAAO,KAAK;AAChC,WAAO,aAAa,MAAM,KAAK;AAC/B,WAAO,aAAa,MAAM,IAAI;AAC9B,WAAO,aAAa,MAAM,IAAI;AAC9B,WAAO,aAAa,MAAM,IAAI;AAG9B,WAAO,aAAa,MAAM,IAAI;AAC9B,WAAO,aAAa,MAAM,IAAI;AAC9B,WAAO,aAAa,MAAM,IAAI;AAC9B,WAAO,aAAa,MAAM,IAAI;AAE9B,WAAO,cAAc,MAAM,oBAAoB;AAE/C,OAAG;AACD,eAAS,UAAU,QAAQ;AAAA,IAC7B,SAAS,SAAS,gBAAgB,CAAC,UAAU;AAE7C,cAAU,SAAS;AAEnB,QAAI,CAAC,UAAU,KAAK;AAClB,YAAM,aAAa,MAAM,KAAK,oBAAoB,EAAE,CAAC;AACrD,aAAO,iBAAiB,YAAY,OAAO,IAAI,MAAM,CAAC;AACtD,aAAO,SAAS,UAAU;AAAA,IAC5B;AAEA,WAAO,SAAS,oBAAoB;AAEpC,WAAO,mBAAmB,OAAO,MAAM,iBAAiB,SAAS;AACjE,WAAO,SAAS,KAAK;AAErB,WAAO,MAAM;AAAA,EACf,CAAC;AAED,SAAO;AACT;AAEA,IAAM,8BAA8B;AAAA,EAClC,MAAM;AAAA,EACN,KAAK;AAAA,EACL,KAAK;AAAA,EACL,OAAO;AACT;AAEA,SAAS,6BAA8B,QAAQ,YAAY,cAAc;AACvE,SAAO,UAAU,QAAQ,IAAI,CAAAA,UAAQ;AACnC,UAAM,SAAS,IAAI,UAAUA,OAAM,EAAE,IAAI,OAAO,CAAC;AAEjD,WAAO,cAAc,UAAU;AAC/B,WAAO,MAAM;AAAA,EACf,CAAC;AACH;AAEA,SAAS,6BAA8B,QAAQ,YAAY,cAAc;AACvE,QAAM,gBAAgB,OAAO,IAAI,sBAAsB;AAEvD,SAAO,UAAU,eAAe,IAAI,CAAAA,UAAQ;AAC1C,UAAM,SAAS,IAAI,YAAYA,OAAM,EAAE,IAAI,cAAc,CAAC;AAE1D,WAAO,iBAAiB,MAAM,WAAW,GAAG,CAAC,CAAC;AAC9C,WAAO,MAAM;AAAA,EACf,CAAC;AACH;AAEA,SAAS,+BAAgC,QAAQ,YAAY,cAAc;AACzE,SAAO,UAAU,QAAQ,IAAI,CAAAA,UAAQ;AACnC,UAAM,SAAS,IAAI,YAAYA,OAAM,EAAE,IAAI,OAAO,CAAC;AAEnD,QAAI,iBAAiB,IAAI;AACvB,aAAO,iBAAiB,OAAO,UAAU;AAAA,IAC3C,OAAO;AACL,aAAO,kBAAkB,OAAO,UAAU;AAAA,IAC5C;AAEA,WAAO,SAAS,KAAK;AAErB,WAAO,MAAM;AAAA,EACf,CAAC;AACH;AAEA,IAAM,+BAA+B;AAAA,EACnC,MAAM;AAAA,EACN,KAAK;AAAA,EACL,KAAK;AAAA,EACL,OAAO;AACT;AAEA,IAAM,0BAAN,MAA8B;AAAA,EAC5B,YAAa,WAAW;AACtB,SAAK,YAAY;AACjB,SAAK,mBAAoB,QAAQ,SAAS,QACtC,UAAU,IAAI,sBAAsB,IACpC;AAEJ,SAAK,eAAe;AACpB,SAAK,aAAa;AAClB,SAAK,sBAAsB;AAC3B,SAAK,4BAA4B;AAAA,EACnC;AAAA,EAEA,iBAAkB,gBAAgB,aAAa;AAC7C,UAAM,SAAS,aAAa,QAAQ,IAAI;AACxC,UAAM,YAAY,gBAAgB,QAAQ,IAAI;AAE9C,UAAM,EAAE,iBAAiB,IAAI;AAE7B,UAAM,SAAS,IAAI,OAAO,gBAAgB;AAC1C,UAAM,YAAY,IAAI,UAAU,kBAAkB,MAAM;AAExD,QAAI;AACJ,QAAI,QAAQ,SAAS,SAAS;AAC5B,UAAI,uBAAuB,oBAAI,IAAI,CAAC,OAAO,KAAK,CAAC;AAEjD,SAAG;AACD,cAAM,aAAa,UAAU,QAAQ;AAErC,cAAM,kBAAkB,IAAI,IAAI,oBAAoB;AACpD,cAAM,EAAE,MAAAK,OAAM,QAAQ,IAAI,UAAU,MAAM;AAC1C,mBAAW,QAAQ,CAACA,OAAM,OAAO,GAAG;AAClC,qBAAW,OAAO,MAAM;AACtB,gBAAI;AACJ,gBAAI,IAAI,WAAW,GAAG,GAAG;AACvB,qBAAO,MAAM,IAAI,UAAU,CAAC;AAAA,YAC9B,OAAO;AACL,qBAAO;AAAA,YACT;AACA,4BAAgB,OAAO,IAAI;AAAA,UAC7B;AAAA,QACF;AACA,YAAI,gBAAgB,SAAS,GAAG;AAC9B;AAAA,QACF;AAEA,iBAAS;AACT,+BAAuB;AAAA,MACzB,SAAS,SAAS,kBAAkB,CAAC,UAAU;AAE/C,kBAAY,uBAAuB;AAAA,IACrC,OAAO;AACL,SAAG;AACD,iBAAS,UAAU,QAAQ;AAAA,MAC7B,SAAS,SAAS,kBAAkB,CAAC,UAAU;AAAA,IACjD;AAEA,WAAO,UAAU;AAAA,EACnB;AAAA,EAEA,sBAAuB;AACrB,QAAI,wBAAwB,MAAM;AAChC,YAAM,iBAAkBf,iBAAgB,IAAK,MAAM;AACnD,4BAAsB,cAAkB,cAAc;AAAA,IACxD;AAEA,UAAM,kBAAkB,6BAA6B,QAAQ,IAAI;AAEjE,QAAI,cAAc;AAClB,QAAI,YAAY;AAChB,UAAM,cAAc,CAAC;AACrB,QAAIA,iBAAgB,KAAK,KAAK,iBAAiB,iBAAiB,WAAW,GAAG;AAC5E,qBAAe;AAEf,aAAO,CAAC;AAAA,IACV,OAAO;AACL,UAAI;AACJ,UAAI,QAAQ,SAAS,OAAO;AAC1B,uBAAe;AACf,sBAAc;AAAA,MAChB,WAAW,QAAQ,SAAS,SAAS;AACnC,uBAAe;AACf,sBAAc;AACd,oBAAY;AAAA,MACd;AAEA,aAAO,EAAE,MAAM,KAAK,kBAAkB,YAAY;AAAA,IACpD;AAEA,SAAK,eAAe;AACpB,SAAK,aAAa,oBAAoB,cAAc,MAAM,SAAS;AAEnE,WAAO;AAAA,EACT;AAAA,EAEA,qBAAsB;AACpB,wBAAoB,UAAU,KAAK,UAAU;AAAA,EAC/C;AAAA,EAEA,SAAUG,KAAI;AACZ,UAAM,cAAc,KAAK,oBAAoB;AAE7C,UAAM,EAAE,YAAY,WAAW,aAAa,IAAI;AAEhD,UAAM,kBAAkB,yCAAyC,QAAQ,IAAI;AAC7E,UAAM,iBAAiB,gBAAgB,YAAY,WAAW,cAAc,aAAaA,GAAE;AAC3F,SAAK,4BAA4B;AAEjC,SAAK,sBAAsB,OAAO,IAAI,KAAK,kBAAkB,cAAc;AAE3E,UAAM,gBAAgB,4BAA4B,QAAQ,IAAI;AAC9D,kBAAc,WAAW,YAAY,YAAY;AAAA,EACnD;AAAA,EAEA,aAAc;AACZ,UAAM,EAAE,kBAAkB,2BAA2B,eAAe,IAAI;AAExE,UAAM,SAAS,aAAa,QAAQ,IAAI;AACxC,WAAO,UAAU,kBAAkB,gBAAgB,CAAAO,UAAQ;AACzD,YAAM,SAAS,IAAI,OAAOA,OAAM,EAAE,IAAI,iBAAiB,CAAC;AAExD,YAAM,EAAE,oBAAoB,IAAI;AAEhC,aAAO,SAAS,oBAAoB,cAAc,cAAc,CAAC;AACjE,aAAO,MAAM;AAAA,IACf,CAAC;AAED,SAAK,mBAAmB;AAAA,EAC1B;AACF;AAEA,SAAS,qBAAsB,SAAS;AACtC,QAAMH,OAAM,OAAO;AAEnB,QAAM,EAAE,QAAQL,IAAG,eAAe,IAAIK;AAEtC,SAAO,QAAQ,OAAO,eAAe,yBAAyB,KAC1D,QAAQ,OAAO,eAAe,kCAAkC,KAChE,QAAQ,OAAO,eAAe,yBAAyB,KACvD,QAAQ,OAAO,eAAe,0BAA0B,KACvD,QAAQ,QAAQL,GAAE,IAAI,KAAK,KAAK,QAAQ,QAAQA,GAAE,KAAK,IAAIA,GAAE,IAAI,CAAC,IAAI;AAC7E;AAEA,IAAM,mBAAN,MAAuB;AAAA,EACrB,YAAa,gBAAgB;AAC3B,UAAM,WAAW,eAAe,cAAc;AAE9C,SAAK,WAAW;AAChB,SAAK,iBAAiB;AACtB,SAAK,iBAAiB;AACtB,SAAK,sBAAsB;AAE3B,SAAK,cAAc;AAAA,EACrB;AAAA,EAEA,QAAS,MAAM,kBAAkBc,WAAUb,KAAII,MAAK;AAClD,UAAM,EAAE,uBAAuB,mBAAmB,IAAIA;AAEtD,SAAK,iBAAiB,eAAe,KAAK,UAAUJ,GAAE;AAEtD,UAAM,gBAAgB,KAAK,eAAe;AAE1C,SAAK,gBAAgB,4BAA4B,KAAK,kBAAkB,GAAG;AACzE,YAAM,WAAW,KAAK,eAAe;AACrC,WAAK,iBAAiB,SAAS,IAAI,IAAIH,YAAW,EAAE,YAAY;AAChE,WAAK,iBAAiB,eAAe,KAAK,gBAAgBG,GAAE;AAAA,IAC9D;AAEA,UAAM,EAAE,eAAe,IAAI;AAE3B,UAAM,sBAAsB,eAAe,gBAAgBA,GAAE;AAC7D,SAAK,sBAAsB;AAE3B,mBAAe,qBAAqB;AAAA,MAClC,SAAS;AAAA,MACT,cAAe,gBAAgB,EAAE,qBAAqB,iBAAiB,mCAAoC,aAAa,2BAA2B;AAAA,MACnJ,WAAWI,KAAI,eAAe;AAAA,MAC9B,iBAAiBA,KAAI;AAAA,IACvB,GAAGJ,GAAE;AAIL,QAAI,2BAA2B,yCAAyC,2BAA2B;AACnG,SAAK,gBAAgB,gBAAgB,GAAG;AACtC,kCAA4B;AAAA,IAC9B;AAEA,mBAAe,gBAAgB;AAAA,MAC7B,cAAe,gBAAgB,CAAE,2BAA6B,2BAA2B;AAAA,IAC3F,GAAGA,GAAE;AAEL,UAAM,YAAY,KAAK,eAAe;AAItC,QAAI,uBAAuB,QAAQ,UAAU,OAAO,kBAAkB,GAAG;AACvE,qBAAe,gBAAgB;AAAA,QAC7B,WAAWI,KAAI;AAAA,MACjB,GAAGJ,GAAE;AAAA,IACP;AAEA,QAAI,CAAC,qBAAqB,SAAS,GAAG;AACpC,YAAM,cAAc,IAAI,wBAAwB,SAAS;AACzD,kBAAY,SAASA,GAAE;AAEvB,WAAK,cAAc;AAAA,IACrB;AAEA,kBAAc,gBAAgB,IAAI,gBAAgB,mBAAmB;AAErE,0BAAsB,gBAAgBA,GAAE;AAAA,EAC1C;AAAA,EAEA,OAAQA,KAAI;AACV,UAAM,EAAE,gBAAgB,YAAY,IAAI;AAExC,mBAAe,gBAAgB,KAAK,gBAAgBA,GAAE;AAEtD,kBAAc,gBAAgB,OAAO,cAAc;AAEnD,QAAI,gBAAgB,MAAM;AACxB,kBAAY,WAAW;AAEvB,WAAK,cAAc;AAAA,IACrB;AAAA,EACF;AAAA,EAEA,cAAe,SAAS,kBAAkB,KAAKI,MAAK;AAClD,WAAO,KAAK;AAAA,EACd;AACF;AAEA,SAAS,oBAAqB;AAC5B,SAAO,mBAAmB,IAAI;AAChC;AAEA,SAAS,eAAgB,UAAUJ,KAAI;AACrC,QAAM,gBAAgB,iBAAiBA,GAAE;AACzC,QAAM,kBAAkB,cAAc;AACtC,SAAQ,CAAC,WAAW,eAAe,aAAa,iBAAiB,EAC9D,OAAO,CAAC,UAAU,SAAS;AAC1B,UAAM,SAAS,gBAAgB,IAAI;AACnC,QAAI,WAAW,QAAW;AACxB,aAAO;AAAA,IACT;AACA,UAAM,UAAU,SAAS,IAAI,MAAM;AACnC,UAAMY,QAAQ,SAAS,gBAAiB,UAAU;AAClD,aAAS,IAAI,IAAIA,MAAK,KAAK,OAAO;AAClC,WAAO;AAAA,EACT,GAAG,CAAC,CAAC;AACT;AAEA,SAAS,eAAgB,UAAU,SAASZ,KAAI;AAC9C,QAAM,gBAAgB,iBAAiBA,GAAE;AACzC,QAAM,kBAAkB,cAAc;AACtC,SAAO,KAAK,OAAO,EAAE,QAAQ,UAAQ;AACnC,UAAM,SAAS,gBAAgB,IAAI;AACnC,QAAI,WAAW,QAAW;AACxB;AAAA,IACF;AACA,UAAM,UAAU,SAAS,IAAI,MAAM;AACnC,UAAMM,SAAS,SAAS,gBAAiB,WAAW;AACpD,IAAAA,OAAM,KAAK,SAAS,QAAQ,IAAI,CAAC;AAAA,EACnC,CAAC;AACH;AAEA,IAAM,sBAAN,MAA0B;AAAA,EACxB,YAAa,UAAU;AACrB,SAAK,WAAW;AAChB,SAAK,iBAAiB;AAAA,EACxB;AAAA,EAEA,QAAS,MAAM,kBAAkBO,WAAUb,KAAII,MAAK;AAClD,UAAM,EAAE,SAAS,IAAI;AAErB,SAAK,iBAAiB,OAAO,IAAI,UAAU,eAAe;AAE1D,QAAI,WAAWS,UAAS,OAAO,CAAC,KAAK,MAAO,MAAM,EAAE,MAAO,CAAC;AAC5D,QAAI,kBAAkB;AACpB;AAAA,IACF;AAMA,UAAM,eAAe,SAAS,IAAI,8BAA8B,EAAE,QAAQ,IAAI,gBAAgB;AAC9F,UAAM,gBAAgB;AACtB,UAAM,WAAW;AACjB,UAAM,UAAU;AAEhB,aAAS,IAAI,8BAA8B,EAAE,SAAS,WAAW;AACjE,aAAS,IAAI,gCAAgC,EAAE,SAAS,aAAa;AACrE,aAAS,IAAI,2BAA2B,EAAE,SAAS,QAAQ;AAC3D,aAAS,IAAI,0BAA0B,EAAE,SAAS,OAAO;AACzD,aAAS,IAAI,8BAA8B,EAAE,SAAS,wBAAwB,QAAQ,CAAC;AAEvF,IAAAT,KAAI,gBAAgB,UAAU,IAAI;AAAA,EACpC;AAAA,EAEA,OAAQJ,KAAI;AACV,WAAO,KAAK,KAAK,UAAU,KAAK,gBAAgB,eAAe;AAAA,EACjE;AAAA,EAEA,cAAe,SAAS,kBAAkB,KAAKI,MAAK;AAClD,UAAM,SAAS,IAAI,OAAO,IAAI,uBAAuB,EAAE,YAAY;AAEnE,QAAI;AACJ,QAAI,kBAAkB;AACpB,kBAAYA,KAAI,qBAAqB,QAAQ,QAAQ,EAAE;AAAA,IACzD,OAAO;AACL,YAAM,IAAI,QAAQ,mBAAmB,GAAG;AACxC,kBAAYA,KAAI,qBAAqB,QAAQ,EAAE,KAAK;AACpD,QAAE,MAAM,GAAG;AAAA,IACb;AAEA,QAAI;AACJ,QAAI,kBAAkB;AACpB,oBAAc,UAAU,IAAI,uBAAuB,EAAE,YAAY;AAAA,IACnE,OAAO;AACL,oBAAc;AAAA,IAChB;AAEA,UAAM,WAAW,YAAY,SAAS,EAAE;AACxC,QAAI,QAAQ,eAAe,IAAI,QAAQ;AACvC,QAAI,UAAU,QAAW;AACvB,YAAM,YAAY,YAAY,IAAI,8BAA8B;AAChE,YAAM,iBAAiB,YAAY,IAAI,oCAAoC;AAC3E,YAAMC,UAAS,UAAU,YAAY;AACrC,YAAM,cAAc,eAAe,QAAQ;AAE3C,YAAM,aAAa,cAAcR;AACjC,YAAM,eAAe,OAAO,MAAM,IAAI,UAAU;AAChD,aAAO,KAAK,cAAcQ,SAAQ,UAAU;AAC5C,gBAAU,aAAa,YAAY;AAEnC,cAAQ;AAAA,QACN;AAAA,QACA;AAAA,QACA;AAAA,QACA,QAAAA;AAAA,QACA;AAAA,QACA;AAAA,QACA,mBAAmB;AAAA,QACnB,eAAe,oBAAI,IAAI;AAAA,MACzB;AACA,qBAAe,IAAI,UAAU,KAAK;AAAA,IACpC;AAEA,UAAM,YAAY,KAAK,SAAS,SAAS,EAAE;AAC3C,QAAI,eAAe,MAAM,cAAc,IAAI,SAAS;AACpD,QAAI,iBAAiB,QAAW;AAC9B,qBAAe,OAAO,IAAI,KAAK,gBAAgB,eAAe;AAE9D,YAAM,cAAc,MAAM;AAC1B,YAAM,aAAa,IAAI,cAAcR,YAAW,EAAE,aAAa,YAAY;AAC3E,mBAAa,IAAI,8BAA8B,EAAE,SAAS,WAAW;AACrE,YAAM,eAAe,SAAS,MAAM,iBAAiB;AAErD,YAAM,cAAc,IAAI,WAAW,YAAY;AAAA,IACjD;AAEA,WAAO;AAAA,EACT;AACF;AAEA,SAAS,wBAAyB,UAAU;AAC1C,MAAI,QAAQ,SAAS,QAAQ;AAC3B,WAAO;AAAA,EACT;AAGA,QAAM,SAAS,SAAS,IAAI,wBAAwB,EAAE,YAAY,EAAE,YAAY;AAChF,MAAI,WAAW,QAAQ,OAAO,WAAW,KAAK,OAAO,SAAS,OAAQ;AACpE,WAAO;AAAA,EACT;AAEA,MAAI;AACJ,UAAQ,OAAO,CAAC,GAAG;AAAA,IACjB,KAAK;AACH,mBAAa;AACb;AAAA,IACF,KAAK;AACH,mBAAa;AACb;AAAA,IACF,KAAK;AACH,mBAAa;AACb;AAAA,IACF,KAAK;AACH,mBAAa;AACb;AAAA,IACF,KAAK;AAAA,IACL,KAAK;AACH,mBAAa;AACb;AAAA,IACF,KAAK;AACH,mBAAa;AACb;AAAA,IACF,KAAK;AACH,mBAAa;AACb;AAAA,IACF;AACE,mBAAa;AACb;AAAA,EACJ;AAEA,MAAI,QAAQ;AACZ,WAAS,IAAI,OAAO,SAAS,GAAG,IAAI,GAAG,KAAK;AAC1C,UAAM,KAAK,OAAO,CAAC;AACnB,aAAU,OAAO,OAAO,OAAO,MAAO,IAAI;AAAA,EAC5C;AAEA,SAAQ,cAAc,0BAA2B;AACnD;AAEA,SAAS,eAAgBW,SAAQR,KAAI;AACnC,QAAMI,OAAM,OAAO;AAEnB,MAAI,mBAAmB,IAAI,IAAI;AAC7B,UAAM,SAASA,KAAI,6BAA6B,EAAE;AAClD,WAAOA,KAAI,4BAA4B,EAAEI,SAAQ,MAAM;AAAA,EACzD;AAEA,SAAO,OAAO,IAAIA,SAAQ,iBAAiBR,GAAE,EAAE,IAAI;AACrD;AAEO,SAAS,iBAAkBA,KAAI,KAAKQ,SAAQ;AACjD,wBAAsBR,KAAI,KAAK,0BAA0BQ,OAAM;AACjE;AAEO,SAAS,qBAAsBR,KAAI,KAAK;AAC7C,wBAAsBA,KAAI,KAAK,mBAAmB;AACpD;AAEO,SAAS,oBAAqBA,KAAI,KAAK;AAC5C,QAAMI,OAAM,OAAO;AAEnB,MAAI,mBAAmB,IAAI,IAAI;AAC7B,UAAM,IAAI,MAAM,8CAA8C;AAAA,EAChE;AAEA,wBAAsBJ,KAAI,KAAK,YAAU;AACvC,IAAAI,KAAI,mCAAmC,EAAEA,KAAI,UAAU;AAAA,EACzD,CAAC;AACH;AAEA,SAAS,sBAAuBJ,KAAI,KAAK,MAAMQ,SAAQ;AACrD,QAAMJ,OAAM,OAAO;AAEnB,MAAI,mBAAmB,IAAI,IAAI;AAC7B,UAAM,IAAI,MAAM,8CAA8C;AAAA,EAChE;AAEA,wBAAsBJ,KAAI,KAAK,YAAU;AACvC,QAAI,mBAAmB,IAAI,IAAI;AAC7B,UAAI,CAACI,KAAI,cAAc,GAAG;AACxB,cAAM,UAAU,UAAUA,IAAG;AAC7B,qBAAa,KAAK,OAAO;AAAA,MAC3B;AAEA,UAAI,CAACA,KAAI,iBAAiB,GAAG;AAC3B,QAAAA,KAAI,oBAAoB,EAAE;AAAA,MAC5B;AAEA,YAAM,UAAU,OAAO,MAAM,IAAIP,YAAW;AAC5C,cAAQ,SAAS,IAAI;AAErB,cAAQ,MAAM;AAAA,QACZ,KAAK;AACH;AAAA,QACF,KAAK;AACH,kBAAQ,IAAI,CAAC,EAAE,aAAaW,OAAM;AAClC;AAAA,QACF;AACE,gBAAM,IAAI,MAAM,iCAAiC;AAAA,MACrD;AAEA,MAAAJ,KAAI,iCAAiC,EAAE,OAAO;AAE9C,MAAAA,KAAI,gCAAgC,EAAE;AAAA,IACxC,OAAO;AACL,YAAM,kBAAkBA,KAAI;AAC5B,UAAI,oBAAoB,MAAM;AAC5B,cAAM,IAAI,MAAM,gEAAgE;AAAA,MAClF;AAEA,YAAM,cAAcA,KAAI,4CAA4C;AACpE,UAAI,gBAAgB,QAAW;AAC7B,cAAM,wBAAwB,CAAC,CAAC,gBAAgB,IAAI,0BAA0B,EAAE,OAAO,qBAAqB,EAAE,OAAO;AACrH,YAAI,CAAC,uBAAuB;AAC1B,sBAAY,eAAe;AAAA,QAC7B;AAAA,MACF;AAEA,cAAQ,MAAM;AAAA,QACZ,KAAK;AACH,UAAAA,KAAI,4CAA4C,EAAE,iBAAiB,OAAO,gBAAgB,OAAO,CAAC;AAClG;AAAA,QACF,KAAK;AACH,UAAAA,KAAI,kCAAkC,EAAE,iBAAiBI,OAAM;AAC/D;AAAA,QACF;AACE,gBAAM,IAAI,MAAM,iCAAiC;AAAA,MACrD;AAAA,IACF;AAAA,EACF,CAAC;AACH;AAEA,IAAM,cAAN,MAAkB;AAAA,EAChB,cAAe;AAKb,UAAM,SAAS,QAAQ,gBAAgB,WAAW;AAClD,UAAM,aAAa,OAAO,gBAAgB,qCAAqC;AAC/E,UAAM,sBAAsB,OAAO,gBAAgB,+CAA+C;AAElG,UAAM,cAAc,eAAe;AACnC,UAAM,aAAa,eAAe;AAElC,SAAK,aAAa,YAAY,CAAC;AAC/B,SAAK,YAAY,WAAW,CAAC;AAE7B,QAAI,iBAAiB;AACrB,qBAAiB,YAAY,OAAO,YAAY,SAAU,MAAM;AAC9D,YAAM,QAAQ,KAAK,CAAC;AAEpB,YAAM,iBAAiB,OAAO,SAAS,MAAM,IAAI,IAAI,GAAG,KAAK,mBAAmB,EAAE,CAAC,EAAE,QAAQ,IAAI,CAAC;AAMlG,qBAAe,SAAS,YAAY,CAAC,CAAC;AAEtC,qBAAe,OAAO;AAAA,IACxB,CAAC;AAED,gBAAY,QAAQ,qBAAqB,IAAI,eAAe,SAAU,OAAO;AAC3E,kBAAY,OAAO,mBAAmB;AAEtC,aAAO,WAAW,CAAC;AAAA,IACrB,GAAG,OAAO,CAAC,SAAS,CAAC,CAAC;AAEtB,gBAAY,MAAM;AAElB,SAAK,oBAAoB,KAAK,kBAAkB;AAAA,EAClD;AAAA,EAEA,MAAM,oBAAqB;AACzB,UAAM,QAAQ,IAAI,gBAAgB,KAAK,WAAW,EAAE,WAAW,MAAM,CAAC;AACtE,UAAM,SAAS,IAAI,iBAAiB,KAAK,WAAW,EAAE,WAAW,MAAM,CAAC;AAExE,UAAM,kBAAkB,CAAC,IAAM,IAAM,IAAM,IAAM,IAAM,IAAM,IAAM,KAAM,KAAM,KAAM,KAAM,IAAM,KAAM,GAAI;AAC3G,QAAI;AACF,YAAM,OAAO,SAAS,eAAe;AACrC,YAAM,MAAM,QAAQ,gBAAgB,MAAM;AAAA,IAC5C,SAAS,GAAG;AAAA,IAAc;AAAA,EAC5B;AACF;AAEA,SAAS,UAAWJ,MAAK;AACvB,QAAM,UAAU,IAAI,YAAY;AAEhC,EAAAA,KAAI,0BAA0B,EAAE,CAAC;AAEjC,QAAM,UAAU,gBAAgB;AAChC,EAAAA,KAAI,yBAAyB,EAAE,OAAO;AAEtC,QAAM,gBAAgBA,KAAI,qDAAqD;AAC/E,MAAI,kBAAkB,QAAW;AAC/B,kBAAc,IAAI;AAAA,EACpB,OAAO;AACL,IAAAA,KAAI,qBAAqB,EAAE;AAAA,EAC7B;AAEA,SAAO;AACT;AAEA,SAAS,kBAAmB;AAC1B,QAAM,2BAA2B,mBAAmB,IAAI,KAAK,IAAI;AACjE,QAAM,0BAA0B;AAEhC,QAAM,YAAY;AAClB,QAAM,SAAS;AACf,QAAM,UAAU;AAChB,QAAM,OAAO;AAEb,QAAM,OAAO,IAAI,kBAAkB;AACnC,QAAM,SAAS,OAAO,MAAM,IAAI;AAChC,SACG,SAAS,SAAS,EAAE,IAAI,CAAC,EACzB,QAAQ,SAAS,IAAI,CAAC,EAAE,IAAI,CAAC,EAC7B,QAAQ,UAAU,IAAI,CAAC,EAAE,IAAI,CAAC,EAC9B,IAAI,eAAe,EACnB,SAAS,IAAI;AAChB,SAAO;AACT;AAEA,SAAS,iBAAkB;AACzB,MAAI,eAAe,MAAM;AACvB,iBAAa,IAAI;AAAA,MACf,QAAQ,gBAAgB,SAAS,EAAE,gBAAgB,YAAY;AAAA,MAC/D;AAAA,MACA,CAAC,OAAO,OAAO,OAAO,SAAS;AAAA,IAAC;AAAA,EACpC;AAEA,QAAM,MAAM,OAAO,MAAM,CAAC;AAC1B,MAAI,WAAW,SAAS,aAAa,GAAG,GAAG,MAAM,IAAI;AACnD,UAAM,IAAI,MAAM,sCAAsC;AAAA,EACxD;AAEA,SAAO;AAAA,IACL,IAAI,QAAQ;AAAA,IACZ,IAAI,IAAI,CAAC,EAAE,QAAQ;AAAA,EACrB;AACF;AAEA,SAAS,oCAAqCA,MAAK;AACjD,QAAM,SAAS,aAAa,EAAE;AAC9B,QAAM,OAAOA,KAAI,GAAG,IAAI,OAAO,WAAW;AAC1C,QAAM,QAAQA,KAAI,GAAG,IAAI,OAAO,OAAO;AAEvC,QAAM,MAAMA,KAAI,kCAAkC;AAClD,QAAM,UAAUA,KAAI,uCAAuC;AAC3D,QAAM,UAAUA,KAAI,yCAAyC;AAE7D,QAAM,oBAAoB;AAE1B,SAAO,SAAUJ,KAAI,QAAQ,KAAK;AAChC,YAAQ,MAAM,MAAM;AACpB,QAAI;AACF,aAAO,IAAI,OAAO,mBAAmB,GAAG;AAAA,IAC1C,UAAE;AACA,cAAQ,MAAM,MAAM;AAAA,IACtB;AAAA,EACF;AACF;AAEA,SAAS,yBAA0BI,MAAK;AAKtC,QAAM,SAASA,KAAI,4BAA4B;AAC/C,MAAI,WAAW,QAAW;AACxB,UAAM,IAAI,MAAM,gEAAgE;AAAA,EAClF;AAEA,SAAO,SAAUJ,KAAI,QAAQ,KAAK;AAChC,WAAO,OAAO,QAAQ,GAAG;AAAA,EAC3B;AACF;AA6CA,IAAM,mCAAmC;AAAA,EACvC,MAAM;AAAA,EACN,KAAK;AAAA,EACL,KAAK;AAAA,EACL,OAAO;AACT;AAEA,SAAS,iCAAkCA,KAAI,KAAK,UAAU;AAC5D,QAAMI,OAAM,OAAO;AACnB,QAAM,YAAY,IAAI,OAAO,YAAY;AAEzC,MAAI;AACJ,QAAM,0BAA0BA,KAAI,KAAK,6CAA6C;AACtF,MAAI,4BAA4B,MAAM;AACpC,yBAAqB;AAAA,EACvB,OAAO;AACL,yBAAqB,UAAU,IAAI,iCAAiC,EAAE,YAAY;AAAA,EACpF;AAEA,MAAI;AACJ,QAAM,oBAAoBA,KAAI,KAAK