# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.10.1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from authentik_client.models.policy_engine_mode import PolicyEngineMode
from typing import Optional, Set
from typing_extensions import Self

class ApplicationRequest(BaseModel):
    """
    Application Serializer
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Application's display Name.")
    slug: Annotated[str, Field(min_length=1, strict=True, max_length=50)] = Field(description="Internal application name, used in URLs.")
    provider: Optional[StrictInt] = None
    backchannel_providers: Optional[List[StrictInt]] = None
    open_in_new_tab: Optional[StrictBool] = Field(default=None, description="Open launch URL in a new browser tab or window.")
    meta_launch_url: Optional[StrictStr] = None
    meta_description: Optional[StrictStr] = None
    meta_publisher: Optional[StrictStr] = None
    policy_engine_mode: Optional[PolicyEngineMode] = None
    group: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["name", "slug", "provider", "backchannel_providers", "open_in_new_tab", "meta_launch_url", "meta_description", "meta_publisher", "policy_engine_mode", "group"]

    @field_validator('slug')
    def slug_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[-a-zA-Z0-9_]+$", value):
            raise ValueError(r"must validate the regular expression /^[-a-zA-Z0-9_]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApplicationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if provider (nullable) is None
        # and model_fields_set contains the field
        if self.provider is None and "provider" in self.model_fields_set:
            _dict['provider'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApplicationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "slug": obj.get("slug"),
            "provider": obj.get("provider"),
            "backchannel_providers": obj.get("backchannel_providers"),
            "open_in_new_tab": obj.get("open_in_new_tab"),
            "meta_launch_url": obj.get("meta_launch_url"),
            "meta_description": obj.get("meta_description"),
            "meta_publisher": obj.get("meta_publisher"),
            "policy_engine_mode": obj.get("policy_engine_mode"),
            "group": obj.get("group")
        })
        return _obj


