# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.10.1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from authentik_client.models.compatibility_mode_enum import CompatibilityModeEnum
from authentik_client.models.scim_authentication_mode_enum import SCIMAuthenticationModeEnum
from typing import Optional, Set
from typing_extensions import Self

class SCIMProviderRequest(BaseModel):
    """
    SCIMProvider Serializer
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True)]
    property_mappings: Optional[List[UUID]] = None
    property_mappings_group: Optional[List[UUID]] = Field(default=None, description="Property mappings used for group creation/updating.")
    url: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Base URL to SCIM requests, usually ends in /v2")
    verify_certificates: Optional[StrictBool] = None
    token: Optional[StrictStr] = Field(default=None, description="Authentication token")
    auth_mode: Optional[SCIMAuthenticationModeEnum] = None
    auth_oauth: Optional[UUID] = Field(default=None, description="OAuth Source used for authentication")
    auth_oauth_params: Optional[Dict[str, Any]] = Field(default=None, description="Additional OAuth parameters, such as grant_type")
    compatibility_mode: Optional[CompatibilityModeEnum] = Field(default=None, description="Alter authentik behavior for vendor-specific SCIM implementations.")
    exclude_users_service_account: Optional[StrictBool] = None
    filter_group: Optional[UUID] = None
    dry_run: Optional[StrictBool] = Field(default=None, description="When enabled, provider will not modify or create objects in the remote system.")
    __properties: ClassVar[List[str]] = ["name", "property_mappings", "property_mappings_group", "url", "verify_certificates", "token", "auth_mode", "auth_oauth", "auth_oauth_params", "compatibility_mode", "exclude_users_service_account", "filter_group", "dry_run"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SCIMProviderRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if auth_oauth (nullable) is None
        # and model_fields_set contains the field
        if self.auth_oauth is None and "auth_oauth" in self.model_fields_set:
            _dict['auth_oauth'] = None

        # set to None if filter_group (nullable) is None
        # and model_fields_set contains the field
        if self.filter_group is None and "filter_group" in self.model_fields_set:
            _dict['filter_group'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SCIMProviderRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "property_mappings": obj.get("property_mappings"),
            "property_mappings_group": obj.get("property_mappings_group"),
            "url": obj.get("url"),
            "verify_certificates": obj.get("verify_certificates"),
            "token": obj.get("token"),
            "auth_mode": obj.get("auth_mode"),
            "auth_oauth": obj.get("auth_oauth"),
            "auth_oauth_params": obj.get("auth_oauth_params"),
            "compatibility_mode": obj.get("compatibility_mode"),
            "exclude_users_service_account": obj.get("exclude_users_service_account"),
            "filter_group": obj.get("filter_group"),
            "dry_run": obj.get("dry_run")
        })
        return _obj


