# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TenantArgs', 'Tenant']

@pulumi.input_type
class TenantArgs:
    def __init__(__self__, *,
                 acr_values_supporteds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allow_organization_name_in_authentication_api: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 customize_mfa_in_postlogin_action: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 default_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 default_redirection_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 default_token_quota: Optional[pulumi.Input['TenantDefaultTokenQuotaArgs']] = None,
                 disable_acr_values_supported: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_locales: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 error_page: Optional[pulumi.Input['TenantErrorPageArgs']] = None,
                 flags: Optional[pulumi.Input['TenantFlagsArgs']] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_session_lifetime: Optional[pulumi.Input[_builtins.float]] = None,
                 mtls: Optional[pulumi.Input['TenantMtlsArgs']] = None,
                 oidc_logout: Optional[pulumi.Input['TenantOidcLogoutArgs']] = None,
                 picture_url: Optional[pulumi.Input[_builtins.str]] = None,
                 pushed_authorization_requests_supported: Optional[pulumi.Input[_builtins.bool]] = None,
                 sandbox_version: Optional[pulumi.Input[_builtins.str]] = None,
                 session_cookie: Optional[pulumi.Input['TenantSessionCookieArgs']] = None,
                 session_lifetime: Optional[pulumi.Input[_builtins.float]] = None,
                 sessions: Optional[pulumi.Input['TenantSessionsArgs']] = None,
                 support_email: Optional[pulumi.Input[_builtins.str]] = None,
                 support_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Tenant resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acr_values_supporteds: List of supported ACR values.
        :param pulumi.Input[_builtins.bool] allow_organization_name_in_authentication_api: Whether to accept an organization name instead of an ID on auth endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[_builtins.bool] customize_mfa_in_postlogin_action: Whether to enable flexible factors for MFA in the PostLogin action.
        :param pulumi.Input[_builtins.str] default_audience: API Audience to use by default for API Authorization flows. This setting is equivalent to appending the audience to every authorization request made to the tenant for every application.
        :param pulumi.Input[_builtins.str] default_directory: Name of the connection to be used for Password Grant exchanges. Options include `auth0-adldap`, `ad`, `auth0`, `email`, `sms`, `waad`, and `adfs`.
        :param pulumi.Input[_builtins.str] default_redirection_uri: The default absolute redirection URI. Must be HTTPS or an empty string.
        :param pulumi.Input['TenantDefaultTokenQuotaArgs'] default_token_quota: Token Quota configuration.
        :param pulumi.Input[_builtins.bool] disable_acr_values_supported: Disable list of supported ACR values.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_locales: Supported locales for the user interface. The first locale in the list will be used to set the default locale.
        :param pulumi.Input['TenantErrorPageArgs'] error_page: Configuration for the error page
        :param pulumi.Input['TenantFlagsArgs'] flags: Configuration settings for tenant flags.
        :param pulumi.Input[_builtins.str] friendly_name: Friendly name for the tenant.
        :param pulumi.Input[_builtins.float] idle_session_lifetime: Number of hours during which a session can be inactive before the user must log in again.
        :param pulumi.Input['TenantMtlsArgs'] mtls: Configuration for mTLS.
        :param pulumi.Input['TenantOidcLogoutArgs'] oidc_logout: Settings related to OIDC RP-initiated Logout.
        :param pulumi.Input[_builtins.str] picture_url: URL of logo to be shown for the tenant. Recommended size is 150px x 150px. If no URL is provided, the Auth0 logo will be used.
        :param pulumi.Input[_builtins.bool] pushed_authorization_requests_supported: Enable pushed authorization requests.
        :param pulumi.Input[_builtins.str] sandbox_version: Selected sandbox version for the extensibility environment, which allows you to use custom scripts to extend parts of Auth0's functionality.
        :param pulumi.Input['TenantSessionCookieArgs'] session_cookie: Alters behavior of tenant's session cookie. Contains a single `mode` property.
        :param pulumi.Input[_builtins.float] session_lifetime: Number of hours during which a session will stay valid.
        :param pulumi.Input['TenantSessionsArgs'] sessions: Sessions related settings for the tenant.
        :param pulumi.Input[_builtins.str] support_email: Support email address for authenticating users.
        :param pulumi.Input[_builtins.str] support_url: Support URL for authenticating users.
        """
        if acr_values_supporteds is not None:
            pulumi.set(__self__, "acr_values_supporteds", acr_values_supporteds)
        if allow_organization_name_in_authentication_api is not None:
            pulumi.set(__self__, "allow_organization_name_in_authentication_api", allow_organization_name_in_authentication_api)
        if allowed_logout_urls is not None:
            pulumi.set(__self__, "allowed_logout_urls", allowed_logout_urls)
        if customize_mfa_in_postlogin_action is not None:
            pulumi.set(__self__, "customize_mfa_in_postlogin_action", customize_mfa_in_postlogin_action)
        if default_audience is not None:
            pulumi.set(__self__, "default_audience", default_audience)
        if default_directory is not None:
            pulumi.set(__self__, "default_directory", default_directory)
        if default_redirection_uri is not None:
            pulumi.set(__self__, "default_redirection_uri", default_redirection_uri)
        if default_token_quota is not None:
            pulumi.set(__self__, "default_token_quota", default_token_quota)
        if disable_acr_values_supported is not None:
            pulumi.set(__self__, "disable_acr_values_supported", disable_acr_values_supported)
        if enabled_locales is not None:
            pulumi.set(__self__, "enabled_locales", enabled_locales)
        if error_page is not None:
            pulumi.set(__self__, "error_page", error_page)
        if flags is not None:
            pulumi.set(__self__, "flags", flags)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if idle_session_lifetime is not None:
            pulumi.set(__self__, "idle_session_lifetime", idle_session_lifetime)
        if mtls is not None:
            pulumi.set(__self__, "mtls", mtls)
        if oidc_logout is not None:
            pulumi.set(__self__, "oidc_logout", oidc_logout)
        if picture_url is not None:
            pulumi.set(__self__, "picture_url", picture_url)
        if pushed_authorization_requests_supported is not None:
            pulumi.set(__self__, "pushed_authorization_requests_supported", pushed_authorization_requests_supported)
        if sandbox_version is not None:
            pulumi.set(__self__, "sandbox_version", sandbox_version)
        if session_cookie is not None:
            pulumi.set(__self__, "session_cookie", session_cookie)
        if session_lifetime is not None:
            pulumi.set(__self__, "session_lifetime", session_lifetime)
        if sessions is not None:
            pulumi.set(__self__, "sessions", sessions)
        if support_email is not None:
            pulumi.set(__self__, "support_email", support_email)
        if support_url is not None:
            pulumi.set(__self__, "support_url", support_url)

    @_builtins.property
    @pulumi.getter(name="acrValuesSupporteds")
    def acr_values_supporteds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of supported ACR values.
        """
        return pulumi.get(self, "acr_values_supporteds")

    @acr_values_supporteds.setter
    def acr_values_supporteds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "acr_values_supporteds", value)

    @_builtins.property
    @pulumi.getter(name="allowOrganizationNameInAuthenticationApi")
    def allow_organization_name_in_authentication_api(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to accept an organization name instead of an ID on auth endpoints.
        """
        return pulumi.get(self, "allow_organization_name_in_authentication_api")

    @allow_organization_name_in_authentication_api.setter
    def allow_organization_name_in_authentication_api(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_organization_name_in_authentication_api", value)

    @_builtins.property
    @pulumi.getter(name="allowedLogoutUrls")
    def allowed_logout_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        URLs that Auth0 may redirect to after logout.
        """
        return pulumi.get(self, "allowed_logout_urls")

    @allowed_logout_urls.setter
    def allowed_logout_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_logout_urls", value)

    @_builtins.property
    @pulumi.getter(name="customizeMfaInPostloginAction")
    def customize_mfa_in_postlogin_action(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable flexible factors for MFA in the PostLogin action.
        """
        return pulumi.get(self, "customize_mfa_in_postlogin_action")

    @customize_mfa_in_postlogin_action.setter
    def customize_mfa_in_postlogin_action(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "customize_mfa_in_postlogin_action", value)

    @_builtins.property
    @pulumi.getter(name="defaultAudience")
    def default_audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API Audience to use by default for API Authorization flows. This setting is equivalent to appending the audience to every authorization request made to the tenant for every application.
        """
        return pulumi.get(self, "default_audience")

    @default_audience.setter
    def default_audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_audience", value)

    @_builtins.property
    @pulumi.getter(name="defaultDirectory")
    def default_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the connection to be used for Password Grant exchanges. Options include `auth0-adldap`, `ad`, `auth0`, `email`, `sms`, `waad`, and `adfs`.
        """
        return pulumi.get(self, "default_directory")

    @default_directory.setter
    def default_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_directory", value)

    @_builtins.property
    @pulumi.getter(name="defaultRedirectionUri")
    def default_redirection_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default absolute redirection URI. Must be HTTPS or an empty string.
        """
        return pulumi.get(self, "default_redirection_uri")

    @default_redirection_uri.setter
    def default_redirection_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_redirection_uri", value)

    @_builtins.property
    @pulumi.getter(name="defaultTokenQuota")
    def default_token_quota(self) -> Optional[pulumi.Input['TenantDefaultTokenQuotaArgs']]:
        """
        Token Quota configuration.
        """
        return pulumi.get(self, "default_token_quota")

    @default_token_quota.setter
    def default_token_quota(self, value: Optional[pulumi.Input['TenantDefaultTokenQuotaArgs']]):
        pulumi.set(self, "default_token_quota", value)

    @_builtins.property
    @pulumi.getter(name="disableAcrValuesSupported")
    def disable_acr_values_supported(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable list of supported ACR values.
        """
        return pulumi.get(self, "disable_acr_values_supported")

    @disable_acr_values_supported.setter
    def disable_acr_values_supported(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_acr_values_supported", value)

    @_builtins.property
    @pulumi.getter(name="enabledLocales")
    def enabled_locales(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Supported locales for the user interface. The first locale in the list will be used to set the default locale.
        """
        return pulumi.get(self, "enabled_locales")

    @enabled_locales.setter
    def enabled_locales(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_locales", value)

    @_builtins.property
    @pulumi.getter(name="errorPage")
    def error_page(self) -> Optional[pulumi.Input['TenantErrorPageArgs']]:
        """
        Configuration for the error page
        """
        return pulumi.get(self, "error_page")

    @error_page.setter
    def error_page(self, value: Optional[pulumi.Input['TenantErrorPageArgs']]):
        pulumi.set(self, "error_page", value)

    @_builtins.property
    @pulumi.getter
    def flags(self) -> Optional[pulumi.Input['TenantFlagsArgs']]:
        """
        Configuration settings for tenant flags.
        """
        return pulumi.get(self, "flags")

    @flags.setter
    def flags(self, value: Optional[pulumi.Input['TenantFlagsArgs']]):
        pulumi.set(self, "flags", value)

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Friendly name for the tenant.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @_builtins.property
    @pulumi.getter(name="idleSessionLifetime")
    def idle_session_lifetime(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Number of hours during which a session can be inactive before the user must log in again.
        """
        return pulumi.get(self, "idle_session_lifetime")

    @idle_session_lifetime.setter
    def idle_session_lifetime(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "idle_session_lifetime", value)

    @_builtins.property
    @pulumi.getter
    def mtls(self) -> Optional[pulumi.Input['TenantMtlsArgs']]:
        """
        Configuration for mTLS.
        """
        return pulumi.get(self, "mtls")

    @mtls.setter
    def mtls(self, value: Optional[pulumi.Input['TenantMtlsArgs']]):
        pulumi.set(self, "mtls", value)

    @_builtins.property
    @pulumi.getter(name="oidcLogout")
    def oidc_logout(self) -> Optional[pulumi.Input['TenantOidcLogoutArgs']]:
        """
        Settings related to OIDC RP-initiated Logout.
        """
        return pulumi.get(self, "oidc_logout")

    @oidc_logout.setter
    def oidc_logout(self, value: Optional[pulumi.Input['TenantOidcLogoutArgs']]):
        pulumi.set(self, "oidc_logout", value)

    @_builtins.property
    @pulumi.getter(name="pictureUrl")
    def picture_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of logo to be shown for the tenant. Recommended size is 150px x 150px. If no URL is provided, the Auth0 logo will be used.
        """
        return pulumi.get(self, "picture_url")

    @picture_url.setter
    def picture_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "picture_url", value)

    @_builtins.property
    @pulumi.getter(name="pushedAuthorizationRequestsSupported")
    def pushed_authorization_requests_supported(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable pushed authorization requests.
        """
        return pulumi.get(self, "pushed_authorization_requests_supported")

    @pushed_authorization_requests_supported.setter
    def pushed_authorization_requests_supported(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pushed_authorization_requests_supported", value)

    @_builtins.property
    @pulumi.getter(name="sandboxVersion")
    def sandbox_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Selected sandbox version for the extensibility environment, which allows you to use custom scripts to extend parts of Auth0's functionality.
        """
        return pulumi.get(self, "sandbox_version")

    @sandbox_version.setter
    def sandbox_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sandbox_version", value)

    @_builtins.property
    @pulumi.getter(name="sessionCookie")
    def session_cookie(self) -> Optional[pulumi.Input['TenantSessionCookieArgs']]:
        """
        Alters behavior of tenant's session cookie. Contains a single `mode` property.
        """
        return pulumi.get(self, "session_cookie")

    @session_cookie.setter
    def session_cookie(self, value: Optional[pulumi.Input['TenantSessionCookieArgs']]):
        pulumi.set(self, "session_cookie", value)

    @_builtins.property
    @pulumi.getter(name="sessionLifetime")
    def session_lifetime(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Number of hours during which a session will stay valid.
        """
        return pulumi.get(self, "session_lifetime")

    @session_lifetime.setter
    def session_lifetime(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "session_lifetime", value)

    @_builtins.property
    @pulumi.getter
    def sessions(self) -> Optional[pulumi.Input['TenantSessionsArgs']]:
        """
        Sessions related settings for the tenant.
        """
        return pulumi.get(self, "sessions")

    @sessions.setter
    def sessions(self, value: Optional[pulumi.Input['TenantSessionsArgs']]):
        pulumi.set(self, "sessions", value)

    @_builtins.property
    @pulumi.getter(name="supportEmail")
    def support_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Support email address for authenticating users.
        """
        return pulumi.get(self, "support_email")

    @support_email.setter
    def support_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "support_email", value)

    @_builtins.property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Support URL for authenticating users.
        """
        return pulumi.get(self, "support_url")

    @support_url.setter
    def support_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "support_url", value)


@pulumi.input_type
class _TenantState:
    def __init__(__self__, *,
                 acr_values_supporteds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allow_organization_name_in_authentication_api: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 customize_mfa_in_postlogin_action: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 default_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 default_redirection_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 default_token_quota: Optional[pulumi.Input['TenantDefaultTokenQuotaArgs']] = None,
                 disable_acr_values_supported: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_locales: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 error_page: Optional[pulumi.Input['TenantErrorPageArgs']] = None,
                 flags: Optional[pulumi.Input['TenantFlagsArgs']] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_session_lifetime: Optional[pulumi.Input[_builtins.float]] = None,
                 mtls: Optional[pulumi.Input['TenantMtlsArgs']] = None,
                 oidc_logout: Optional[pulumi.Input['TenantOidcLogoutArgs']] = None,
                 picture_url: Optional[pulumi.Input[_builtins.str]] = None,
                 pushed_authorization_requests_supported: Optional[pulumi.Input[_builtins.bool]] = None,
                 sandbox_version: Optional[pulumi.Input[_builtins.str]] = None,
                 session_cookie: Optional[pulumi.Input['TenantSessionCookieArgs']] = None,
                 session_lifetime: Optional[pulumi.Input[_builtins.float]] = None,
                 sessions: Optional[pulumi.Input['TenantSessionsArgs']] = None,
                 support_email: Optional[pulumi.Input[_builtins.str]] = None,
                 support_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Tenant resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acr_values_supporteds: List of supported ACR values.
        :param pulumi.Input[_builtins.bool] allow_organization_name_in_authentication_api: Whether to accept an organization name instead of an ID on auth endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[_builtins.bool] customize_mfa_in_postlogin_action: Whether to enable flexible factors for MFA in the PostLogin action.
        :param pulumi.Input[_builtins.str] default_audience: API Audience to use by default for API Authorization flows. This setting is equivalent to appending the audience to every authorization request made to the tenant for every application.
        :param pulumi.Input[_builtins.str] default_directory: Name of the connection to be used for Password Grant exchanges. Options include `auth0-adldap`, `ad`, `auth0`, `email`, `sms`, `waad`, and `adfs`.
        :param pulumi.Input[_builtins.str] default_redirection_uri: The default absolute redirection URI. Must be HTTPS or an empty string.
        :param pulumi.Input['TenantDefaultTokenQuotaArgs'] default_token_quota: Token Quota configuration.
        :param pulumi.Input[_builtins.bool] disable_acr_values_supported: Disable list of supported ACR values.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_locales: Supported locales for the user interface. The first locale in the list will be used to set the default locale.
        :param pulumi.Input['TenantErrorPageArgs'] error_page: Configuration for the error page
        :param pulumi.Input['TenantFlagsArgs'] flags: Configuration settings for tenant flags.
        :param pulumi.Input[_builtins.str] friendly_name: Friendly name for the tenant.
        :param pulumi.Input[_builtins.float] idle_session_lifetime: Number of hours during which a session can be inactive before the user must log in again.
        :param pulumi.Input['TenantMtlsArgs'] mtls: Configuration for mTLS.
        :param pulumi.Input['TenantOidcLogoutArgs'] oidc_logout: Settings related to OIDC RP-initiated Logout.
        :param pulumi.Input[_builtins.str] picture_url: URL of logo to be shown for the tenant. Recommended size is 150px x 150px. If no URL is provided, the Auth0 logo will be used.
        :param pulumi.Input[_builtins.bool] pushed_authorization_requests_supported: Enable pushed authorization requests.
        :param pulumi.Input[_builtins.str] sandbox_version: Selected sandbox version for the extensibility environment, which allows you to use custom scripts to extend parts of Auth0's functionality.
        :param pulumi.Input['TenantSessionCookieArgs'] session_cookie: Alters behavior of tenant's session cookie. Contains a single `mode` property.
        :param pulumi.Input[_builtins.float] session_lifetime: Number of hours during which a session will stay valid.
        :param pulumi.Input['TenantSessionsArgs'] sessions: Sessions related settings for the tenant.
        :param pulumi.Input[_builtins.str] support_email: Support email address for authenticating users.
        :param pulumi.Input[_builtins.str] support_url: Support URL for authenticating users.
        """
        if acr_values_supporteds is not None:
            pulumi.set(__self__, "acr_values_supporteds", acr_values_supporteds)
        if allow_organization_name_in_authentication_api is not None:
            pulumi.set(__self__, "allow_organization_name_in_authentication_api", allow_organization_name_in_authentication_api)
        if allowed_logout_urls is not None:
            pulumi.set(__self__, "allowed_logout_urls", allowed_logout_urls)
        if customize_mfa_in_postlogin_action is not None:
            pulumi.set(__self__, "customize_mfa_in_postlogin_action", customize_mfa_in_postlogin_action)
        if default_audience is not None:
            pulumi.set(__self__, "default_audience", default_audience)
        if default_directory is not None:
            pulumi.set(__self__, "default_directory", default_directory)
        if default_redirection_uri is not None:
            pulumi.set(__self__, "default_redirection_uri", default_redirection_uri)
        if default_token_quota is not None:
            pulumi.set(__self__, "default_token_quota", default_token_quota)
        if disable_acr_values_supported is not None:
            pulumi.set(__self__, "disable_acr_values_supported", disable_acr_values_supported)
        if enabled_locales is not None:
            pulumi.set(__self__, "enabled_locales", enabled_locales)
        if error_page is not None:
            pulumi.set(__self__, "error_page", error_page)
        if flags is not None:
            pulumi.set(__self__, "flags", flags)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if idle_session_lifetime is not None:
            pulumi.set(__self__, "idle_session_lifetime", idle_session_lifetime)
        if mtls is not None:
            pulumi.set(__self__, "mtls", mtls)
        if oidc_logout is not None:
            pulumi.set(__self__, "oidc_logout", oidc_logout)
        if picture_url is not None:
            pulumi.set(__self__, "picture_url", picture_url)
        if pushed_authorization_requests_supported is not None:
            pulumi.set(__self__, "pushed_authorization_requests_supported", pushed_authorization_requests_supported)
        if sandbox_version is not None:
            pulumi.set(__self__, "sandbox_version", sandbox_version)
        if session_cookie is not None:
            pulumi.set(__self__, "session_cookie", session_cookie)
        if session_lifetime is not None:
            pulumi.set(__self__, "session_lifetime", session_lifetime)
        if sessions is not None:
            pulumi.set(__self__, "sessions", sessions)
        if support_email is not None:
            pulumi.set(__self__, "support_email", support_email)
        if support_url is not None:
            pulumi.set(__self__, "support_url", support_url)

    @_builtins.property
    @pulumi.getter(name="acrValuesSupporteds")
    def acr_values_supporteds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of supported ACR values.
        """
        return pulumi.get(self, "acr_values_supporteds")

    @acr_values_supporteds.setter
    def acr_values_supporteds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "acr_values_supporteds", value)

    @_builtins.property
    @pulumi.getter(name="allowOrganizationNameInAuthenticationApi")
    def allow_organization_name_in_authentication_api(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to accept an organization name instead of an ID on auth endpoints.
        """
        return pulumi.get(self, "allow_organization_name_in_authentication_api")

    @allow_organization_name_in_authentication_api.setter
    def allow_organization_name_in_authentication_api(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_organization_name_in_authentication_api", value)

    @_builtins.property
    @pulumi.getter(name="allowedLogoutUrls")
    def allowed_logout_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        URLs that Auth0 may redirect to after logout.
        """
        return pulumi.get(self, "allowed_logout_urls")

    @allowed_logout_urls.setter
    def allowed_logout_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_logout_urls", value)

    @_builtins.property
    @pulumi.getter(name="customizeMfaInPostloginAction")
    def customize_mfa_in_postlogin_action(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable flexible factors for MFA in the PostLogin action.
        """
        return pulumi.get(self, "customize_mfa_in_postlogin_action")

    @customize_mfa_in_postlogin_action.setter
    def customize_mfa_in_postlogin_action(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "customize_mfa_in_postlogin_action", value)

    @_builtins.property
    @pulumi.getter(name="defaultAudience")
    def default_audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API Audience to use by default for API Authorization flows. This setting is equivalent to appending the audience to every authorization request made to the tenant for every application.
        """
        return pulumi.get(self, "default_audience")

    @default_audience.setter
    def default_audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_audience", value)

    @_builtins.property
    @pulumi.getter(name="defaultDirectory")
    def default_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the connection to be used for Password Grant exchanges. Options include `auth0-adldap`, `ad`, `auth0`, `email`, `sms`, `waad`, and `adfs`.
        """
        return pulumi.get(self, "default_directory")

    @default_directory.setter
    def default_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_directory", value)

    @_builtins.property
    @pulumi.getter(name="defaultRedirectionUri")
    def default_redirection_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default absolute redirection URI. Must be HTTPS or an empty string.
        """
        return pulumi.get(self, "default_redirection_uri")

    @default_redirection_uri.setter
    def default_redirection_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_redirection_uri", value)

    @_builtins.property
    @pulumi.getter(name="defaultTokenQuota")
    def default_token_quota(self) -> Optional[pulumi.Input['TenantDefaultTokenQuotaArgs']]:
        """
        Token Quota configuration.
        """
        return pulumi.get(self, "default_token_quota")

    @default_token_quota.setter
    def default_token_quota(self, value: Optional[pulumi.Input['TenantDefaultTokenQuotaArgs']]):
        pulumi.set(self, "default_token_quota", value)

    @_builtins.property
    @pulumi.getter(name="disableAcrValuesSupported")
    def disable_acr_values_supported(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable list of supported ACR values.
        """
        return pulumi.get(self, "disable_acr_values_supported")

    @disable_acr_values_supported.setter
    def disable_acr_values_supported(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_acr_values_supported", value)

    @_builtins.property
    @pulumi.getter(name="enabledLocales")
    def enabled_locales(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Supported locales for the user interface. The first locale in the list will be used to set the default locale.
        """
        return pulumi.get(self, "enabled_locales")

    @enabled_locales.setter
    def enabled_locales(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_locales", value)

    @_builtins.property
    @pulumi.getter(name="errorPage")
    def error_page(self) -> Optional[pulumi.Input['TenantErrorPageArgs']]:
        """
        Configuration for the error page
        """
        return pulumi.get(self, "error_page")

    @error_page.setter
    def error_page(self, value: Optional[pulumi.Input['TenantErrorPageArgs']]):
        pulumi.set(self, "error_page", value)

    @_builtins.property
    @pulumi.getter
    def flags(self) -> Optional[pulumi.Input['TenantFlagsArgs']]:
        """
        Configuration settings for tenant flags.
        """
        return pulumi.get(self, "flags")

    @flags.setter
    def flags(self, value: Optional[pulumi.Input['TenantFlagsArgs']]):
        pulumi.set(self, "flags", value)

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Friendly name for the tenant.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @_builtins.property
    @pulumi.getter(name="idleSessionLifetime")
    def idle_session_lifetime(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Number of hours during which a session can be inactive before the user must log in again.
        """
        return pulumi.get(self, "idle_session_lifetime")

    @idle_session_lifetime.setter
    def idle_session_lifetime(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "idle_session_lifetime", value)

    @_builtins.property
    @pulumi.getter
    def mtls(self) -> Optional[pulumi.Input['TenantMtlsArgs']]:
        """
        Configuration for mTLS.
        """
        return pulumi.get(self, "mtls")

    @mtls.setter
    def mtls(self, value: Optional[pulumi.Input['TenantMtlsArgs']]):
        pulumi.set(self, "mtls", value)

    @_builtins.property
    @pulumi.getter(name="oidcLogout")
    def oidc_logout(self) -> Optional[pulumi.Input['TenantOidcLogoutArgs']]:
        """
        Settings related to OIDC RP-initiated Logout.
        """
        return pulumi.get(self, "oidc_logout")

    @oidc_logout.setter
    def oidc_logout(self, value: Optional[pulumi.Input['TenantOidcLogoutArgs']]):
        pulumi.set(self, "oidc_logout", value)

    @_builtins.property
    @pulumi.getter(name="pictureUrl")
    def picture_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of logo to be shown for the tenant. Recommended size is 150px x 150px. If no URL is provided, the Auth0 logo will be used.
        """
        return pulumi.get(self, "picture_url")

    @picture_url.setter
    def picture_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "picture_url", value)

    @_builtins.property
    @pulumi.getter(name="pushedAuthorizationRequestsSupported")
    def pushed_authorization_requests_supported(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable pushed authorization requests.
        """
        return pulumi.get(self, "pushed_authorization_requests_supported")

    @pushed_authorization_requests_supported.setter
    def pushed_authorization_requests_supported(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pushed_authorization_requests_supported", value)

    @_builtins.property
    @pulumi.getter(name="sandboxVersion")
    def sandbox_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Selected sandbox version for the extensibility environment, which allows you to use custom scripts to extend parts of Auth0's functionality.
        """
        return pulumi.get(self, "sandbox_version")

    @sandbox_version.setter
    def sandbox_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sandbox_version", value)

    @_builtins.property
    @pulumi.getter(name="sessionCookie")
    def session_cookie(self) -> Optional[pulumi.Input['TenantSessionCookieArgs']]:
        """
        Alters behavior of tenant's session cookie. Contains a single `mode` property.
        """
        return pulumi.get(self, "session_cookie")

    @session_cookie.setter
    def session_cookie(self, value: Optional[pulumi.Input['TenantSessionCookieArgs']]):
        pulumi.set(self, "session_cookie", value)

    @_builtins.property
    @pulumi.getter(name="sessionLifetime")
    def session_lifetime(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Number of hours during which a session will stay valid.
        """
        return pulumi.get(self, "session_lifetime")

    @session_lifetime.setter
    def session_lifetime(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "session_lifetime", value)

    @_builtins.property
    @pulumi.getter
    def sessions(self) -> Optional[pulumi.Input['TenantSessionsArgs']]:
        """
        Sessions related settings for the tenant.
        """
        return pulumi.get(self, "sessions")

    @sessions.setter
    def sessions(self, value: Optional[pulumi.Input['TenantSessionsArgs']]):
        pulumi.set(self, "sessions", value)

    @_builtins.property
    @pulumi.getter(name="supportEmail")
    def support_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Support email address for authenticating users.
        """
        return pulumi.get(self, "support_email")

    @support_email.setter
    def support_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "support_email", value)

    @_builtins.property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Support URL for authenticating users.
        """
        return pulumi.get(self, "support_url")

    @support_url.setter
    def support_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "support_url", value)


@pulumi.type_token("auth0:index/tenant:Tenant")
class Tenant(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acr_values_supporteds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allow_organization_name_in_authentication_api: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 customize_mfa_in_postlogin_action: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 default_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 default_redirection_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 default_token_quota: Optional[pulumi.Input[Union['TenantDefaultTokenQuotaArgs', 'TenantDefaultTokenQuotaArgsDict']]] = None,
                 disable_acr_values_supported: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_locales: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 error_page: Optional[pulumi.Input[Union['TenantErrorPageArgs', 'TenantErrorPageArgsDict']]] = None,
                 flags: Optional[pulumi.Input[Union['TenantFlagsArgs', 'TenantFlagsArgsDict']]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_session_lifetime: Optional[pulumi.Input[_builtins.float]] = None,
                 mtls: Optional[pulumi.Input[Union['TenantMtlsArgs', 'TenantMtlsArgsDict']]] = None,
                 oidc_logout: Optional[pulumi.Input[Union['TenantOidcLogoutArgs', 'TenantOidcLogoutArgsDict']]] = None,
                 picture_url: Optional[pulumi.Input[_builtins.str]] = None,
                 pushed_authorization_requests_supported: Optional[pulumi.Input[_builtins.bool]] = None,
                 sandbox_version: Optional[pulumi.Input[_builtins.str]] = None,
                 session_cookie: Optional[pulumi.Input[Union['TenantSessionCookieArgs', 'TenantSessionCookieArgsDict']]] = None,
                 session_lifetime: Optional[pulumi.Input[_builtins.float]] = None,
                 sessions: Optional[pulumi.Input[Union['TenantSessionsArgs', 'TenantSessionsArgsDict']]] = None,
                 support_email: Optional[pulumi.Input[_builtins.str]] = None,
                 support_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        With this resource, you can manage Auth0 tenants, including setting logos and support contact information, setting error pages, and configuring default tenant behaviors.

        > Creating tenants through the Management API is not currently supported. Therefore, this resource can only
        manage an existing tenant created through the Auth0 dashboard.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_tenant = auth0.Tenant("my_tenant",
            friendly_name="Tenant Name",
            picture_url="http://example.com/logo.png",
            support_email="support@example.com",
            support_url="http://example.com/support",
            allowed_logout_urls=["http://example.com/logout"],
            session_lifetime=8760,
            sandbox_version="12",
            enabled_locales=["en"],
            default_redirection_uri="https://example.com/login",
            flags={
                "disable_clickjack_protection_headers": True,
                "enable_public_signup_user_exists_error": True,
                "use_scope_descriptions_for_consent": True,
                "no_disclose_enterprise_connections": False,
                "disable_management_api_sms_obfuscation": False,
                "disable_fields_map_fix": False,
            },
            session_cookie={
                "mode": "non-persistent",
            },
            sessions={
                "oidc_logout_prompt_enabled": False,
            },
            error_page={
                "html": "<html></html>",
                "show_log_link": False,
                "url": "https://example.com/error",
            })
        ```

        ## Import

        As this is not a resource identifiable by an ID within the Auth0 Management API,

        tenant can be imported using a random string.

        We recommend [Version 4 UUID](https://www.uuidgenerator.net/version4)

        Example:

        ```sh
        $ pulumi import auth0:index/tenant:Tenant my_tenant "82f4f21b-017a-319d-92e7-2291c1ca36c4"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acr_values_supporteds: List of supported ACR values.
        :param pulumi.Input[_builtins.bool] allow_organization_name_in_authentication_api: Whether to accept an organization name instead of an ID on auth endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[_builtins.bool] customize_mfa_in_postlogin_action: Whether to enable flexible factors for MFA in the PostLogin action.
        :param pulumi.Input[_builtins.str] default_audience: API Audience to use by default for API Authorization flows. This setting is equivalent to appending the audience to every authorization request made to the tenant for every application.
        :param pulumi.Input[_builtins.str] default_directory: Name of the connection to be used for Password Grant exchanges. Options include `auth0-adldap`, `ad`, `auth0`, `email`, `sms`, `waad`, and `adfs`.
        :param pulumi.Input[_builtins.str] default_redirection_uri: The default absolute redirection URI. Must be HTTPS or an empty string.
        :param pulumi.Input[Union['TenantDefaultTokenQuotaArgs', 'TenantDefaultTokenQuotaArgsDict']] default_token_quota: Token Quota configuration.
        :param pulumi.Input[_builtins.bool] disable_acr_values_supported: Disable list of supported ACR values.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_locales: Supported locales for the user interface. The first locale in the list will be used to set the default locale.
        :param pulumi.Input[Union['TenantErrorPageArgs', 'TenantErrorPageArgsDict']] error_page: Configuration for the error page
        :param pulumi.Input[Union['TenantFlagsArgs', 'TenantFlagsArgsDict']] flags: Configuration settings for tenant flags.
        :param pulumi.Input[_builtins.str] friendly_name: Friendly name for the tenant.
        :param pulumi.Input[_builtins.float] idle_session_lifetime: Number of hours during which a session can be inactive before the user must log in again.
        :param pulumi.Input[Union['TenantMtlsArgs', 'TenantMtlsArgsDict']] mtls: Configuration for mTLS.
        :param pulumi.Input[Union['TenantOidcLogoutArgs', 'TenantOidcLogoutArgsDict']] oidc_logout: Settings related to OIDC RP-initiated Logout.
        :param pulumi.Input[_builtins.str] picture_url: URL of logo to be shown for the tenant. Recommended size is 150px x 150px. If no URL is provided, the Auth0 logo will be used.
        :param pulumi.Input[_builtins.bool] pushed_authorization_requests_supported: Enable pushed authorization requests.
        :param pulumi.Input[_builtins.str] sandbox_version: Selected sandbox version for the extensibility environment, which allows you to use custom scripts to extend parts of Auth0's functionality.
        :param pulumi.Input[Union['TenantSessionCookieArgs', 'TenantSessionCookieArgsDict']] session_cookie: Alters behavior of tenant's session cookie. Contains a single `mode` property.
        :param pulumi.Input[_builtins.float] session_lifetime: Number of hours during which a session will stay valid.
        :param pulumi.Input[Union['TenantSessionsArgs', 'TenantSessionsArgsDict']] sessions: Sessions related settings for the tenant.
        :param pulumi.Input[_builtins.str] support_email: Support email address for authenticating users.
        :param pulumi.Input[_builtins.str] support_url: Support URL for authenticating users.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TenantArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can manage Auth0 tenants, including setting logos and support contact information, setting error pages, and configuring default tenant behaviors.

        > Creating tenants through the Management API is not currently supported. Therefore, this resource can only
        manage an existing tenant created through the Auth0 dashboard.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_tenant = auth0.Tenant("my_tenant",
            friendly_name="Tenant Name",
            picture_url="http://example.com/logo.png",
            support_email="support@example.com",
            support_url="http://example.com/support",
            allowed_logout_urls=["http://example.com/logout"],
            session_lifetime=8760,
            sandbox_version="12",
            enabled_locales=["en"],
            default_redirection_uri="https://example.com/login",
            flags={
                "disable_clickjack_protection_headers": True,
                "enable_public_signup_user_exists_error": True,
                "use_scope_descriptions_for_consent": True,
                "no_disclose_enterprise_connections": False,
                "disable_management_api_sms_obfuscation": False,
                "disable_fields_map_fix": False,
            },
            session_cookie={
                "mode": "non-persistent",
            },
            sessions={
                "oidc_logout_prompt_enabled": False,
            },
            error_page={
                "html": "<html></html>",
                "show_log_link": False,
                "url": "https://example.com/error",
            })
        ```

        ## Import

        As this is not a resource identifiable by an ID within the Auth0 Management API,

        tenant can be imported using a random string.

        We recommend [Version 4 UUID](https://www.uuidgenerator.net/version4)

        Example:

        ```sh
        $ pulumi import auth0:index/tenant:Tenant my_tenant "82f4f21b-017a-319d-92e7-2291c1ca36c4"
        ```

        :param str resource_name: The name of the resource.
        :param TenantArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TenantArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acr_values_supporteds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allow_organization_name_in_authentication_api: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 customize_mfa_in_postlogin_action: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 default_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 default_redirection_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 default_token_quota: Optional[pulumi.Input[Union['TenantDefaultTokenQuotaArgs', 'TenantDefaultTokenQuotaArgsDict']]] = None,
                 disable_acr_values_supported: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_locales: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 error_page: Optional[pulumi.Input[Union['TenantErrorPageArgs', 'TenantErrorPageArgsDict']]] = None,
                 flags: Optional[pulumi.Input[Union['TenantFlagsArgs', 'TenantFlagsArgsDict']]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_session_lifetime: Optional[pulumi.Input[_builtins.float]] = None,
                 mtls: Optional[pulumi.Input[Union['TenantMtlsArgs', 'TenantMtlsArgsDict']]] = None,
                 oidc_logout: Optional[pulumi.Input[Union['TenantOidcLogoutArgs', 'TenantOidcLogoutArgsDict']]] = None,
                 picture_url: Optional[pulumi.Input[_builtins.str]] = None,
                 pushed_authorization_requests_supported: Optional[pulumi.Input[_builtins.bool]] = None,
                 sandbox_version: Optional[pulumi.Input[_builtins.str]] = None,
                 session_cookie: Optional[pulumi.Input[Union['TenantSessionCookieArgs', 'TenantSessionCookieArgsDict']]] = None,
                 session_lifetime: Optional[pulumi.Input[_builtins.float]] = None,
                 sessions: Optional[pulumi.Input[Union['TenantSessionsArgs', 'TenantSessionsArgsDict']]] = None,
                 support_email: Optional[pulumi.Input[_builtins.str]] = None,
                 support_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TenantArgs.__new__(TenantArgs)

            __props__.__dict__["acr_values_supporteds"] = acr_values_supporteds
            __props__.__dict__["allow_organization_name_in_authentication_api"] = allow_organization_name_in_authentication_api
            __props__.__dict__["allowed_logout_urls"] = allowed_logout_urls
            __props__.__dict__["customize_mfa_in_postlogin_action"] = customize_mfa_in_postlogin_action
            __props__.__dict__["default_audience"] = default_audience
            __props__.__dict__["default_directory"] = default_directory
            __props__.__dict__["default_redirection_uri"] = default_redirection_uri
            __props__.__dict__["default_token_quota"] = default_token_quota
            __props__.__dict__["disable_acr_values_supported"] = disable_acr_values_supported
            __props__.__dict__["enabled_locales"] = enabled_locales
            __props__.__dict__["error_page"] = error_page
            __props__.__dict__["flags"] = flags
            __props__.__dict__["friendly_name"] = friendly_name
            __props__.__dict__["idle_session_lifetime"] = idle_session_lifetime
            __props__.__dict__["mtls"] = mtls
            __props__.__dict__["oidc_logout"] = oidc_logout
            __props__.__dict__["picture_url"] = picture_url
            __props__.__dict__["pushed_authorization_requests_supported"] = pushed_authorization_requests_supported
            __props__.__dict__["sandbox_version"] = sandbox_version
            __props__.__dict__["session_cookie"] = session_cookie
            __props__.__dict__["session_lifetime"] = session_lifetime
            __props__.__dict__["sessions"] = sessions
            __props__.__dict__["support_email"] = support_email
            __props__.__dict__["support_url"] = support_url
        super(Tenant, __self__).__init__(
            'auth0:index/tenant:Tenant',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acr_values_supporteds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allow_organization_name_in_authentication_api: Optional[pulumi.Input[_builtins.bool]] = None,
            allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            customize_mfa_in_postlogin_action: Optional[pulumi.Input[_builtins.bool]] = None,
            default_audience: Optional[pulumi.Input[_builtins.str]] = None,
            default_directory: Optional[pulumi.Input[_builtins.str]] = None,
            default_redirection_uri: Optional[pulumi.Input[_builtins.str]] = None,
            default_token_quota: Optional[pulumi.Input[Union['TenantDefaultTokenQuotaArgs', 'TenantDefaultTokenQuotaArgsDict']]] = None,
            disable_acr_values_supported: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled_locales: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            error_page: Optional[pulumi.Input[Union['TenantErrorPageArgs', 'TenantErrorPageArgsDict']]] = None,
            flags: Optional[pulumi.Input[Union['TenantFlagsArgs', 'TenantFlagsArgsDict']]] = None,
            friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
            idle_session_lifetime: Optional[pulumi.Input[_builtins.float]] = None,
            mtls: Optional[pulumi.Input[Union['TenantMtlsArgs', 'TenantMtlsArgsDict']]] = None,
            oidc_logout: Optional[pulumi.Input[Union['TenantOidcLogoutArgs', 'TenantOidcLogoutArgsDict']]] = None,
            picture_url: Optional[pulumi.Input[_builtins.str]] = None,
            pushed_authorization_requests_supported: Optional[pulumi.Input[_builtins.bool]] = None,
            sandbox_version: Optional[pulumi.Input[_builtins.str]] = None,
            session_cookie: Optional[pulumi.Input[Union['TenantSessionCookieArgs', 'TenantSessionCookieArgsDict']]] = None,
            session_lifetime: Optional[pulumi.Input[_builtins.float]] = None,
            sessions: Optional[pulumi.Input[Union['TenantSessionsArgs', 'TenantSessionsArgsDict']]] = None,
            support_email: Optional[pulumi.Input[_builtins.str]] = None,
            support_url: Optional[pulumi.Input[_builtins.str]] = None) -> 'Tenant':
        """
        Get an existing Tenant resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acr_values_supporteds: List of supported ACR values.
        :param pulumi.Input[_builtins.bool] allow_organization_name_in_authentication_api: Whether to accept an organization name instead of an ID on auth endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[_builtins.bool] customize_mfa_in_postlogin_action: Whether to enable flexible factors for MFA in the PostLogin action.
        :param pulumi.Input[_builtins.str] default_audience: API Audience to use by default for API Authorization flows. This setting is equivalent to appending the audience to every authorization request made to the tenant for every application.
        :param pulumi.Input[_builtins.str] default_directory: Name of the connection to be used for Password Grant exchanges. Options include `auth0-adldap`, `ad`, `auth0`, `email`, `sms`, `waad`, and `adfs`.
        :param pulumi.Input[_builtins.str] default_redirection_uri: The default absolute redirection URI. Must be HTTPS or an empty string.
        :param pulumi.Input[Union['TenantDefaultTokenQuotaArgs', 'TenantDefaultTokenQuotaArgsDict']] default_token_quota: Token Quota configuration.
        :param pulumi.Input[_builtins.bool] disable_acr_values_supported: Disable list of supported ACR values.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_locales: Supported locales for the user interface. The first locale in the list will be used to set the default locale.
        :param pulumi.Input[Union['TenantErrorPageArgs', 'TenantErrorPageArgsDict']] error_page: Configuration for the error page
        :param pulumi.Input[Union['TenantFlagsArgs', 'TenantFlagsArgsDict']] flags: Configuration settings for tenant flags.
        :param pulumi.Input[_builtins.str] friendly_name: Friendly name for the tenant.
        :param pulumi.Input[_builtins.float] idle_session_lifetime: Number of hours during which a session can be inactive before the user must log in again.
        :param pulumi.Input[Union['TenantMtlsArgs', 'TenantMtlsArgsDict']] mtls: Configuration for mTLS.
        :param pulumi.Input[Union['TenantOidcLogoutArgs', 'TenantOidcLogoutArgsDict']] oidc_logout: Settings related to OIDC RP-initiated Logout.
        :param pulumi.Input[_builtins.str] picture_url: URL of logo to be shown for the tenant. Recommended size is 150px x 150px. If no URL is provided, the Auth0 logo will be used.
        :param pulumi.Input[_builtins.bool] pushed_authorization_requests_supported: Enable pushed authorization requests.
        :param pulumi.Input[_builtins.str] sandbox_version: Selected sandbox version for the extensibility environment, which allows you to use custom scripts to extend parts of Auth0's functionality.
        :param pulumi.Input[Union['TenantSessionCookieArgs', 'TenantSessionCookieArgsDict']] session_cookie: Alters behavior of tenant's session cookie. Contains a single `mode` property.
        :param pulumi.Input[_builtins.float] session_lifetime: Number of hours during which a session will stay valid.
        :param pulumi.Input[Union['TenantSessionsArgs', 'TenantSessionsArgsDict']] sessions: Sessions related settings for the tenant.
        :param pulumi.Input[_builtins.str] support_email: Support email address for authenticating users.
        :param pulumi.Input[_builtins.str] support_url: Support URL for authenticating users.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TenantState.__new__(_TenantState)

        __props__.__dict__["acr_values_supporteds"] = acr_values_supporteds
        __props__.__dict__["allow_organization_name_in_authentication_api"] = allow_organization_name_in_authentication_api
        __props__.__dict__["allowed_logout_urls"] = allowed_logout_urls
        __props__.__dict__["customize_mfa_in_postlogin_action"] = customize_mfa_in_postlogin_action
        __props__.__dict__["default_audience"] = default_audience
        __props__.__dict__["default_directory"] = default_directory
        __props__.__dict__["default_redirection_uri"] = default_redirection_uri
        __props__.__dict__["default_token_quota"] = default_token_quota
        __props__.__dict__["disable_acr_values_supported"] = disable_acr_values_supported
        __props__.__dict__["enabled_locales"] = enabled_locales
        __props__.__dict__["error_page"] = error_page
        __props__.__dict__["flags"] = flags
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["idle_session_lifetime"] = idle_session_lifetime
        __props__.__dict__["mtls"] = mtls
        __props__.__dict__["oidc_logout"] = oidc_logout
        __props__.__dict__["picture_url"] = picture_url
        __props__.__dict__["pushed_authorization_requests_supported"] = pushed_authorization_requests_supported
        __props__.__dict__["sandbox_version"] = sandbox_version
        __props__.__dict__["session_cookie"] = session_cookie
        __props__.__dict__["session_lifetime"] = session_lifetime
        __props__.__dict__["sessions"] = sessions
        __props__.__dict__["support_email"] = support_email
        __props__.__dict__["support_url"] = support_url
        return Tenant(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acrValuesSupporteds")
    def acr_values_supporteds(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of supported ACR values.
        """
        return pulumi.get(self, "acr_values_supporteds")

    @_builtins.property
    @pulumi.getter(name="allowOrganizationNameInAuthenticationApi")
    def allow_organization_name_in_authentication_api(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to accept an organization name instead of an ID on auth endpoints.
        """
        return pulumi.get(self, "allow_organization_name_in_authentication_api")

    @_builtins.property
    @pulumi.getter(name="allowedLogoutUrls")
    def allowed_logout_urls(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        URLs that Auth0 may redirect to after logout.
        """
        return pulumi.get(self, "allowed_logout_urls")

    @_builtins.property
    @pulumi.getter(name="customizeMfaInPostloginAction")
    def customize_mfa_in_postlogin_action(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable flexible factors for MFA in the PostLogin action.
        """
        return pulumi.get(self, "customize_mfa_in_postlogin_action")

    @_builtins.property
    @pulumi.getter(name="defaultAudience")
    def default_audience(self) -> pulumi.Output[_builtins.str]:
        """
        API Audience to use by default for API Authorization flows. This setting is equivalent to appending the audience to every authorization request made to the tenant for every application.
        """
        return pulumi.get(self, "default_audience")

    @_builtins.property
    @pulumi.getter(name="defaultDirectory")
    def default_directory(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the connection to be used for Password Grant exchanges. Options include `auth0-adldap`, `ad`, `auth0`, `email`, `sms`, `waad`, and `adfs`.
        """
        return pulumi.get(self, "default_directory")

    @_builtins.property
    @pulumi.getter(name="defaultRedirectionUri")
    def default_redirection_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The default absolute redirection URI. Must be HTTPS or an empty string.
        """
        return pulumi.get(self, "default_redirection_uri")

    @_builtins.property
    @pulumi.getter(name="defaultTokenQuota")
    def default_token_quota(self) -> pulumi.Output[Optional['outputs.TenantDefaultTokenQuota']]:
        """
        Token Quota configuration.
        """
        return pulumi.get(self, "default_token_quota")

    @_builtins.property
    @pulumi.getter(name="disableAcrValuesSupported")
    def disable_acr_values_supported(self) -> pulumi.Output[_builtins.bool]:
        """
        Disable list of supported ACR values.
        """
        return pulumi.get(self, "disable_acr_values_supported")

    @_builtins.property
    @pulumi.getter(name="enabledLocales")
    def enabled_locales(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Supported locales for the user interface. The first locale in the list will be used to set the default locale.
        """
        return pulumi.get(self, "enabled_locales")

    @_builtins.property
    @pulumi.getter(name="errorPage")
    def error_page(self) -> pulumi.Output[Optional['outputs.TenantErrorPage']]:
        """
        Configuration for the error page
        """
        return pulumi.get(self, "error_page")

    @_builtins.property
    @pulumi.getter
    def flags(self) -> pulumi.Output['outputs.TenantFlags']:
        """
        Configuration settings for tenant flags.
        """
        return pulumi.get(self, "flags")

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[_builtins.str]:
        """
        Friendly name for the tenant.
        """
        return pulumi.get(self, "friendly_name")

    @_builtins.property
    @pulumi.getter(name="idleSessionLifetime")
    def idle_session_lifetime(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        Number of hours during which a session can be inactive before the user must log in again.
        """
        return pulumi.get(self, "idle_session_lifetime")

    @_builtins.property
    @pulumi.getter
    def mtls(self) -> pulumi.Output['outputs.TenantMtls']:
        """
        Configuration for mTLS.
        """
        return pulumi.get(self, "mtls")

    @_builtins.property
    @pulumi.getter(name="oidcLogout")
    def oidc_logout(self) -> pulumi.Output['outputs.TenantOidcLogout']:
        """
        Settings related to OIDC RP-initiated Logout.
        """
        return pulumi.get(self, "oidc_logout")

    @_builtins.property
    @pulumi.getter(name="pictureUrl")
    def picture_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL of logo to be shown for the tenant. Recommended size is 150px x 150px. If no URL is provided, the Auth0 logo will be used.
        """
        return pulumi.get(self, "picture_url")

    @_builtins.property
    @pulumi.getter(name="pushedAuthorizationRequestsSupported")
    def pushed_authorization_requests_supported(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable pushed authorization requests.
        """
        return pulumi.get(self, "pushed_authorization_requests_supported")

    @_builtins.property
    @pulumi.getter(name="sandboxVersion")
    def sandbox_version(self) -> pulumi.Output[_builtins.str]:
        """
        Selected sandbox version for the extensibility environment, which allows you to use custom scripts to extend parts of Auth0's functionality.
        """
        return pulumi.get(self, "sandbox_version")

    @_builtins.property
    @pulumi.getter(name="sessionCookie")
    def session_cookie(self) -> pulumi.Output['outputs.TenantSessionCookie']:
        """
        Alters behavior of tenant's session cookie. Contains a single `mode` property.
        """
        return pulumi.get(self, "session_cookie")

    @_builtins.property
    @pulumi.getter(name="sessionLifetime")
    def session_lifetime(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        Number of hours during which a session will stay valid.
        """
        return pulumi.get(self, "session_lifetime")

    @_builtins.property
    @pulumi.getter
    def sessions(self) -> pulumi.Output['outputs.TenantSessions']:
        """
        Sessions related settings for the tenant.
        """
        return pulumi.get(self, "sessions")

    @_builtins.property
    @pulumi.getter(name="supportEmail")
    def support_email(self) -> pulumi.Output[_builtins.str]:
        """
        Support email address for authenticating users.
        """
        return pulumi.get(self, "support_email")

    @_builtins.property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> pulumi.Output[_builtins.str]:
        """
        Support URL for authenticating users.
        """
        return pulumi.get(self, "support_url")

