"""add digest execution model

Revision ID: b97e92b038d2
Revises: 3efe14d4469a
Create Date: 2025-10-01 16:42:41.900651

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "b97e92b038d2"
down_revision = "3efe14d4469a"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "digest_task_execution",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("action_type", sa.String(), nullable=False),
        sa.Column("digest_config_id", sa.String(), nullable=False),
        sa.Column("celery_task_id", sa.String(), nullable=True),
        sa.Column(
            "status",
            postgresql.ENUM(name="executionlogstatus", create_type=False),
            nullable=False,
        ),
        sa.Column("total_recipients", sa.Integer(), nullable=True),
        sa.Column("processed_recipients", sa.Integer(), nullable=False),
        sa.Column("successful_communications", sa.Integer(), nullable=False),
        sa.Column("failed_communications", sa.Integer(), nullable=False),
        sa.Column(
            "execution_state", postgresql.JSONB(astext_type=sa.Text()), nullable=True
        ),
        sa.Column(
            "processed_user_ids", postgresql.JSONB(astext_type=sa.Text()), nullable=True
        ),
        sa.Column("started_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column("completed_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column("last_checkpoint_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column("error_message", sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(
            ["digest_config_id"], ["digest_config.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_digest_task_execution_action_type"),
        "digest_task_execution",
        ["action_type"],
        unique=False,
    )
    op.create_index(
        op.f("ix_digest_task_execution_celery_task_id"),
        "digest_task_execution",
        ["celery_task_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_digest_task_execution_digest_config_id"),
        "digest_task_execution",
        ["digest_config_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_digest_task_execution_id"),
        "digest_task_execution",
        ["id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_digest_task_execution_status"),
        "digest_task_execution",
        ["status"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_digest_task_execution_status"), table_name="digest_task_execution"
    )
    op.drop_index(
        op.f("ix_digest_task_execution_id"), table_name="digest_task_execution"
    )
    op.drop_index(
        op.f("ix_digest_task_execution_digest_config_id"),
        table_name="digest_task_execution",
    )
    op.drop_index(
        op.f("ix_digest_task_execution_celery_task_id"),
        table_name="digest_task_execution",
    )
    op.drop_index(
        op.f("ix_digest_task_execution_action_type"), table_name="digest_task_execution"
    )
    op.drop_table("digest_task_execution")
    # ### end Alembic commands ###
