from .dsl import *  # noqa: F403

DSL_FUNCTIONS = {
    "add": add,  # noqa: F405
    "adjacent": adjacent,  # noqa: F405
    "apply": apply,  # noqa: F405
    "argmax": argmax,  # noqa: F405
    "argmin": argmin,  # noqa: F405
    "asindices": asindices,  # noqa: F405
    "asobject": asobject,  # noqa: F405
    "astuple": astuple,  # noqa: F405
    "backdrop": backdrop,  # noqa: F405
    "bordering": bordering,  # noqa: F405
    "both": both,  # noqa: F405
    "bottomhalf": bottomhalf,  # noqa: F405
    "box": box,  # noqa: F405
    "branch": branch,  # noqa: F405
    "canvas": canvas,  # noqa: F405
    "cellwise": cellwise,  # noqa: F405
    "center": center,  # noqa: F405
    "centerofmass": centerofmass,  # noqa: F405
    "chain": chain,  # noqa: F405
    "cmirror": cmirror,  # noqa: F405
    "color": color,  # noqa: F405
    "colorcount": colorcount,  # noqa: F405
    "colorfilter": colorfilter,  # noqa: F405
    "combine": combine,  # noqa: F405
    "compose": compose,  # noqa: F405
    "compress": compress,  # noqa: F405
    "connect": connect,  # noqa: F405
    "contained": contained,  # noqa: F405
    "corners": corners,  # noqa: F405
    "cover": cover,  # noqa: F405
    "crement": crement,  # noqa: F405
    "crop": crop,  # noqa: F405
    "decrement": decrement,  # noqa: F405
    "dedupe": dedupe,  # noqa: F405
    "delta": delta,  # noqa: F405
    "difference": difference,  # noqa: F405
    "divide": divide,  # noqa: F405
    "dmirror": dmirror,  # noqa: F405
    "dneighbors": dneighbors,  # noqa: F405
    "double": double,  # noqa: F405
    "downscale": downscale,  # noqa: F405
    "either": either,  # noqa: F405
    "equality": equality,  # noqa: F405
    "even": even,  # noqa: F405
    "extract": extract,  # noqa: F405
    "fgpartition": fgpartition,  # noqa: F405
    "fill": fill,  # noqa: F405
    "first": first,  # noqa: F405
    "flip": flip,  # noqa: F405
    "fork": fork,  # noqa: F405
    "frontiers": frontiers,  # noqa: F405
    "gravitate": gravitate,  # noqa: F405
    "greater": greater,  # noqa: F405
    "halve": halve,  # noqa: F405
    "hconcat": hconcat,  # noqa: F405
    "height": height,  # noqa: F405
    "hfrontier": hfrontier,  # noqa: F405
    "hline": hline,  # noqa: F405
    "hmatching": hmatching,  # noqa: F405
    "hmirror": hmirror,  # noqa: F405
    "hperiod": hperiod,  # noqa: F405
    "hsplit": hsplit,  # noqa: F405
    "hupscale": hupscale,  # noqa: F405
    "identity": identity,  # noqa: F405
    "inbox": inbox,  # noqa: F405
    "increment": increment,  # noqa: F405
    "index": index,  # noqa: F405
    "ineighbors": ineighbors,  # noqa: F405
    "initset": initset,  # noqa: F405
    "insert": insert,  # noqa: F405
    "intersection": intersection,  # noqa: F405
    "interval": interval,  # noqa: F405
    "invert": invert,  # noqa: F405
    "last": last,  # noqa: F405
    "lbind": lbind,  # noqa: F405
    "leastcolor": leastcolor,  # noqa: F405
    "leastcommon": leastcommon,  # noqa: F405
    "lefthalf": lefthalf,  # noqa: F405
    "leftmost": leftmost,  # noqa: F405
    "llcorner": llcorner,  # noqa: F405
    "lowermost": lowermost,  # noqa: F405
    "lrcorner": lrcorner,  # noqa: F405
    "manhattan": manhattan,  # noqa: F405
    "mapply": mapply,  # noqa: F405
    "matcher": matcher,  # noqa: F405
    "maximum": maximum,  # noqa: F405
    "merge": merge,  # noqa: F405
    "mfilter": mfilter,  # noqa: F405
    "minimum": minimum,  # noqa: F405
    "mostcolor": mostcolor,  # noqa: F405
    "mostcommon": mostcommon,  # noqa: F405
    "move": move,  # noqa: F405
    "mpapply": mpapply,  # noqa: F405
    "multiply": multiply,  # noqa: F405
    "neighbors": neighbors,  # noqa: F405
    "normalize": normalize,  # noqa: F405
    "numcolors": numcolors,  # noqa: F405
    "gobjects": gobjects,  # noqa: F405
    "occurrences": occurrences,  # noqa: F405
    "ofcolor": ofcolor,  # noqa: F405
    "order": order,  # noqa: F405
    "other": other,  # noqa: F405
    "outbox": outbox,  # noqa: F405
    "paint": paint,  # noqa: F405
    "pair": pair,  # noqa: F405
    "palette": palette,  # noqa: F405
    "papply": papply,  # noqa: F405
    "partition": partition,  # noqa: F405
    "portrait": portrait,  # noqa: F405
    "position": position,  # noqa: F405
    "positive": positive,  # noqa: F405
    "power": power,  # noqa: F405
    "prapply": prapply,  # noqa: F405
    "product": product,  # noqa: F405
    "rapply": rapply,  # noqa: F405
    "rbind": rbind,  # noqa: F405
    "recolor": recolor,  # noqa: F405
    "remove": remove,  # noqa: F405
    "repeat": repeat,  # noqa: F405
    "replace": replace,  # noqa: F405
    "righthalf": righthalf,  # noqa: F405
    "rightmost": rightmost,  # noqa: F405
    "rot180": rot180,  # noqa: F405
    "rot270": rot270,  # noqa: F405
    "rot90": rot90,  # noqa: F405
    "sfilter": sfilter,  # noqa: F405
    "shape": shape,  # noqa: F405
    "shift": shift,  # noqa: F405
    "shoot": shoot,  # noqa: F405
    "sign": sign,  # noqa: F405
    "size": size,  # noqa: F405
    "sizefilter": sizefilter,  # noqa: F405
    "square": square,  # noqa: F405
    "subgrid": subgrid,  # noqa: F405
    "subtract": subtract,  # noqa: F405
    "switch": switch,  # noqa: F405
    "toindices": toindices,  # noqa: F405
    "toivec": toivec,  # noqa: F405
    "tojvec": tojvec,  # noqa: F405
    "toobject": toobject,  # noqa: F405
    "tophalf": tophalf,  # noqa: F405
    "totuple": totuple,  # noqa: F405
    "trim": trim,  # noqa: F405
    "ulcorner": ulcorner,  # noqa: F405
    "underfill": underfill,  # noqa: F405
    "underpaint": underpaint,  # noqa: F405
    "uppermost": uppermost,  # noqa: F405
    "upscale": upscale,  # noqa: F405
    "urcorner": urcorner,  # noqa: F405
    "valmax": valmax,  # noqa: F405
    "valmin": valmin,  # noqa: F405
    "vconcat": vconcat,  # noqa: F405
    "vfrontier": vfrontier,  # noqa: F405
    "vline": vline,  # noqa: F405
    "vmatching": vmatching,  # noqa: F405
    "vmirror": vmirror,  # noqa: F405
    "vperiod": vperiod,  # noqa: F405
    "vsplit": vsplit,  # noqa: F405
    "vupscale": vupscale,  # noqa: F405
    "width": width,  # noqa: F405
}


def get(identifier):
    """Retrieve a ARC DSL function based on its name.

    Args:
        identifier (str): The function identifier.
    """
    if isinstance(identifier, str):
        return DSL_FUNCTIONS.get(identifier)
    else:
        raise ValueError(f"Could not interpret dsl function identifier: {identifier}")
